/***********************************************************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2009 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
*********************************************************************************************************************//*!
*
* @file   CTS_LowTypes.h
*
* @brief  CTS (Capacitive Turbo Sensing) - Low_Layer : Low Level Routines
*
* @version 1.0.8.0
* 
* @date Jul-23-2009
* 
*
***********************************************************************************************************************/

/*******************************************************************************
* CTS Version control
********************************************************************************
* WARNINGS
*
*   CTS_WARNING_TYPE_1:
*       Case: CTS process handling the GPIO pin .
*       Event: When ISR interrupt CTS process and set CTS pin to OUT=0 (by DD=1 && D=0)
*       Issue: It could cause never-ending cycling of actualy used routine!!!
*       Defence: IF there is a risk of this malicious behaviour please prevent this
*           -   use WATCHDOOG and after reset check which pin coused it .. or ..
*           -   add TIMER-overflow isr before start this C/T routine
*
*   CTS_WARNING_TYPE_2:
*       Case: CTS process handling the GPIO pin .
*       Event: When ISR interrupt CTS process and set nearby pin-register on PE port handled
*              by CTS to differnet PE value
*       Issue: It could cause reset this nearby PE pin-register to previous value!!!
*       Defence: IF there is an application risk that it could cause malicious behaviour
*           -   set PE before execute CTS pin routine, or after, never in ISR
*           -   avoid use ISR
*          
********************************************************************************
* b000      3.5.2008        CTS_WARNING_TYPE_1&2
********************************************************************************
* b001      17.7.2008       CTS_WARNING_TYPE_1&2
********************************************************************************
* b002      29.10.2008      CTS_WARNING_TYPE_1&2
********************************************************************************
* b003      1.12.2008       CTS_WARNING_TYPE_1&2   
********************************************************************************
* b003fix   26.02.2009      CTS_WARNING_TYPE_1&2
*
*   FOCUS:
*       Platform-portable interface of platfom-depend Low-Layer routines
*       
*   ABOUT:
*       Platform: S08/100%, R08/0%, C08/0%, 
*       Self GPIO init
*       Interruptible
*       Accuracy ~0,3pF/LSB (S08GT32@20MHz)
*       Fast & noiseless
*       Min-report, Semi-test, Mid-overhead.
*       ROM: ~90B/Pin
*       ZRAM: -
*       RAM: -
*       SP: 1,2
*       Requiremnts: NONE or WD/TIMER to handle unexpected behavior
*
*   WARNING:
*       Error report fails when mcu module set the pin to 1 and is used CTS pin
*
********************************************************************************
* b004  in-dev              CTS_WARNING_TYPE_(1)&2 (HC08 & HCS08, not RS08) 
*
*   FOCUS:
*       Handle all Low-level behavior [c9], Improved error report [c6,c9]
*
*   ABOUT:
*       Platform:
*           S08-100%, R08-100%, C08-100%, MCF1-100%, S12-100%
*       Self GPIO init, Interruptible, Noiseless, Max-report, Full-test
*       Accuracy [c6]~0,3pF/LSB@20MHz, [c9]~0,45pF/LSB@20MHz
*       Requiremnts: NONE, no exceptions
*
*   SUB-VERSION:
*       [c6] Fast, Mid-overhead
*           ROM/ZRAM/RAM/SP[B]: 96/0/0/0
*       [c9] Safe, High-overhead.
*           ROM/ZRAM/RAM/SP[B]: 120/0/0/1
*
*******************************************************************************/

#ifndef CTS_LowTypes_H
  #define CTS_LowTypes_H

  /*******************************************************************************
  ****  Includes
  *******************************************************************************/
  #include "CTS_McuTypes.h"


  /*******************************************************************************
  ****  CTS Low defs 
  *******************************************************************************/

  //CTS ARGUMENTS ...

      /* all versions: H[f,S] or L[f,S]*/
      // input :: <0..253> is OK, 0=no turbo (no CTS & normal R/C), >0 turbo value (CTS is in use)
      #define cCTS_ARG_TURBO      (-1)    //<-128..-1> GET CTS_turbo value, this value use as argument when getting C/T
      #define cCTS_ARG_RESET      (-2)    //basic pin init (typically it is not needed!!!)
      // WARNING :: getting turbo=0 when is used argument cCTS_ARG_TURBO means ...
      //              1) parasitic capacity is very-very low!!!
      //              2) high risk of cap-signal instability!!!
      //              3) low EMC immunity!!!

      
  //CTS OUTPUT & ERRORS ...
      
      /*-----------------------------------------*/
      /*           basic error-reports           */
      /*-----------------------------------------*/
      // OUTPUT :: <1..253> is OK getting C/T, expected should be only positive range <1..127>
      //          warning: conversion is NOT limited to range 1.127!!! (maxC/T = WD or other stop-time-safety)
      // ERRORS :: see below ...
      /* all versions: H[f,S] or L[f,S]*/
      
      #define cCTS_error_HiLimit  (64)
      #define cCTS_error_LoCAP    ( 0)    //0b00000000=x00=0//CAP is too low (turbo should be decreased if is used)
      
      /* all versions: H[f,S] or L[f,S] except RS08 family*/
      #define cCTS_error_ExISR    (-1)    //0b11111111=xFF=255//ISR occured (so the last sample should be re-sampled)
      
      
      /*-----------------------------------------*/
      /*  version-depend extended error-reports  */
      /*-----------------------------------------*/
      /*all versions: H[f,S] or L[f,S]*/
      //OUTPUT :: <1..127> is OK getting C/T, expected should be only positive range <1..127>
      //ERRORS :: see below
      #define cCTS_error_LoPIN    (-2)    //0b11111110=xFE=254//HW error (HW impedance errors or pin is used by module xyz)
      #define cCTS_error_HiPIN    (-3)    //0b11111101=xFD=253//HW error (HW impedance errors or pin is used by module xyz)
      
      /*only HS,LS*/
      //          caution: conversion is limited to range 1.127!!! (maxC/T=~57,15us for mcu@20MHz == 0,05us x 9 x 127)
      #define cCTS_error_HiCAP    (-128)  //0b10000000=x80=128//HW error (not external pull-up, HW changes or turbo is too low)
      


  /*******************************************************************************
  ****    ptrf pfCTSType
  *******************************************************************************/
  typedef INT8   (*pfCTS_LowType)(INT8 CTS_arg);

  /*
  ////////////////////////////////////////////////////////////////////////////////
  ////    HELP: port A  ... Which pin can be used for CTS sensing???
  ////////////////////////////////////////////////////////////////////////////////
  //HELP #ifdef __CTS_A0H__ << is it blue?  YES = pin/routine can be used for CTS,  NO = pin is not available
  //HELP  ... use next platform independed routine naming standard in your code ...
  //HELP    INT8 CTS_A0Hs(INT8 CTS_arg);  << High-side-safe
  //HELP    INT8 CTS_A0Hf(INT8 CTS_arg);  << High-side-fast
  //HELP    INT8 CTS_A0Ls(INT8 CTS_arg);  << Low-side-fast (RS08, S12)
  //HELP    INT8 CTS_A0Lf(INT8 CTS_arg);  << Low-side-fast (RS08, S12)
  //HELP #endif
  */


  //_A
  #ifdef          __CTS_A0H__
      _ctsabi INT8 CTS_A0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A0Hf(INT8 CTS_arg);
      #ifdef      __CTS_A0L__
      _ctsabi INT8 CTS_A0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_A1H__
      _ctsabi INT8 CTS_A1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A1Hf(INT8 CTS_arg);
      #ifdef      __CTS_A1L__
      _ctsabi INT8 CTS_A1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_A2H__
      _ctsabi INT8 CTS_A2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A2Hf(INT8 CTS_arg);
      #ifdef      __CTS_A2L__
      _ctsabi INT8 CTS_A2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_A3H__
      _ctsabi INT8 CTS_A3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A3Hf(INT8 CTS_arg);
      #ifdef      __CTS_A3L__
      _ctsabi INT8 CTS_A3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_A4H__
      _ctsabi INT8 CTS_A4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A4Hf(INT8 CTS_arg);
      #ifdef      __CTS_A4L__
      _ctsabi INT8 CTS_A4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_A5H__
      _ctsabi INT8 CTS_A5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A5Hf(INT8 CTS_arg);
      #ifdef      __CTS_A5L__
      _ctsabi INT8 CTS_A5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_A6H__
      _ctsabi INT8 CTS_A6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A6Hf(INT8 CTS_arg);
      #ifdef      __CTS_A6L__
      _ctsabi INT8 CTS_A6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_A7H__
      _ctsabi INT8 CTS_A7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A7Hf(INT8 CTS_arg);
      #ifdef      __CTS_A7L__
      _ctsabi INT8 CTS_A7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_A7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_B
  #ifdef          __CTS_B0H__
      _ctsabi INT8 CTS_B0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B0Hf(INT8 CTS_arg);
      #ifdef      __CTS_B0L__
      _ctsabi INT8 CTS_B0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_B1H__
      _ctsabi INT8 CTS_B1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B1Hf(INT8 CTS_arg);
      #ifdef      __CTS_B1L__
      _ctsabi INT8 CTS_B1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_B2H__
      _ctsabi INT8 CTS_B2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B2Hf(INT8 CTS_arg);
      #ifdef      __CTS_B2L__
      _ctsabi INT8 CTS_B2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_B3H__
      _ctsabi INT8 CTS_B3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B3Hf(INT8 CTS_arg);
      #ifdef      __CTS_B3L__
      _ctsabi INT8 CTS_B3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_B4H__
      _ctsabi INT8 CTS_B4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B4Hf(INT8 CTS_arg);
      #ifdef      __CTS_B4L__
      _ctsabi INT8 CTS_B4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_B5H__
      _ctsabi INT8 CTS_B5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B5Hf(INT8 CTS_arg);
      #ifdef      __CTS_B5L__
      _ctsabi INT8 CTS_B5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_B6H__
      _ctsabi INT8 CTS_B6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B6Hf(INT8 CTS_arg);
      #ifdef      __CTS_B6L__
      _ctsabi INT8 CTS_B6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_B7H__
      _ctsabi INT8 CTS_B7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B7Hf(INT8 CTS_arg);
      #ifdef      __CTS_B7L__
      _ctsabi INT8 CTS_B7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_B7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_C
  #ifdef          __CTS_C0H__
      _ctsabi INT8 CTS_C0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C0Hf(INT8 CTS_arg);
      #ifdef      __CTS_C0L__
      _ctsabi INT8 CTS_C0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_C1H__
      _ctsabi INT8 CTS_C1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C1Hf(INT8 CTS_arg);
      #ifdef      __CTS_C1L__
      _ctsabi INT8 CTS_C1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_C2H__
      _ctsabi INT8 CTS_C2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C2Hf(INT8 CTS_arg);
      #ifdef      __CTS_C2L__
      _ctsabi INT8 CTS_C2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_C3H__
      _ctsabi INT8 CTS_C3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C3Hf(INT8 CTS_arg);
      #ifdef      __CTS_C3L__
      _ctsabi INT8 CTS_C3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_C4H__
      _ctsabi INT8 CTS_C4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C4Hf(INT8 CTS_arg);
      #ifdef      __CTS_C4L__
      _ctsabi INT8 CTS_C4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_C5H__
      _ctsabi INT8 CTS_C5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C5Hf(INT8 CTS_arg);
      #ifdef      __CTS_C5L__
      _ctsabi INT8 CTS_C5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_C6H__
      _ctsabi INT8 CTS_C6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C6Hf(INT8 CTS_arg);
      #ifdef      __CTS_C6L__
      _ctsabi INT8 CTS_C6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_C7H__
      _ctsabi INT8 CTS_C7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C7Hf(INT8 CTS_arg);
      #ifdef      __CTS_C7L__
      _ctsabi INT8 CTS_C7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_C7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_D
  #ifdef          __CTS_D0H__
      _ctsabi INT8 CTS_D0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D0Hf(INT8 CTS_arg);
      #ifdef      __CTS_D0L__
      _ctsabi INT8 CTS_D0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_D1H__
      _ctsabi INT8 CTS_D1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D1Hf(INT8 CTS_arg);
      #ifdef      __CTS_D1L__
      _ctsabi INT8 CTS_D1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_D2H__
      _ctsabi INT8 CTS_D2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D2Hf(INT8 CTS_arg);
      #ifdef      __CTS_D2L__
      _ctsabi INT8 CTS_D2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_D3H__
      _ctsabi INT8 CTS_D3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D3Hf(INT8 CTS_arg);
      #ifdef      __CTS_D3L__
      _ctsabi INT8 CTS_D3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_D4H__
      _ctsabi INT8 CTS_D4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D4Hf(INT8 CTS_arg);
      #ifdef      __CTS_D4L__
      _ctsabi INT8 CTS_D4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_D5H__
      _ctsabi INT8 CTS_D5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D5Hf(INT8 CTS_arg);
      #ifdef      __CTS_D5L__
      _ctsabi INT8 CTS_D5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_D6H__
      _ctsabi INT8 CTS_D6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D6Hf(INT8 CTS_arg);
      #ifdef      __CTS_D6L__
      _ctsabi INT8 CTS_D6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_D7H__
      _ctsabi INT8 CTS_D7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D7Hf(INT8 CTS_arg);
      #ifdef      __CTS_D7L__
      _ctsabi INT8 CTS_D7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_D7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_E
  #ifdef          __CTS_E0H__
      _ctsabi INT8 CTS_E0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E0Hf(INT8 CTS_arg);
      #ifdef      __CTS_E0L__
      _ctsabi INT8 CTS_E0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_E1H__
      _ctsabi INT8 CTS_E1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E1Hf(INT8 CTS_arg);
      #ifdef      __CTS_E1L__
      _ctsabi INT8 CTS_E1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_E2H__
      _ctsabi INT8 CTS_E2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E2Hf(INT8 CTS_arg);
      #ifdef      __CTS_E2L__
      _ctsabi INT8 CTS_E2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_E3H__
      _ctsabi INT8 CTS_E3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E3Hf(INT8 CTS_arg);
      #ifdef      __CTS_E3L__
      _ctsabi INT8 CTS_E3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_E4H__
      _ctsabi INT8 CTS_E4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E4Hf(INT8 CTS_arg);
      #ifdef      __CTS_E4L__
      _ctsabi INT8 CTS_E4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_E5H__
      _ctsabi INT8 CTS_E5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E5Hf(INT8 CTS_arg);
      #ifdef      __CTS_E5L__
      _ctsabi INT8 CTS_E5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_E6H__
      _ctsabi INT8 CTS_E6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E6Hf(INT8 CTS_arg);
      #ifdef      __CTS_E6L__
      _ctsabi INT8 CTS_E6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_E7H__
      _ctsabi INT8 CTS_E7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E7Hf(INT8 CTS_arg);
      #ifdef      __CTS_E7L__
      _ctsabi INT8 CTS_E7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_E7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_F
  #ifdef          __CTS_F0H__
      _ctsabi INT8 CTS_F0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F0Hf(INT8 CTS_arg);
      #ifdef      __CTS_F0L__
      _ctsabi INT8 CTS_F0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_F1H__
      _ctsabi INT8 CTS_F1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F1Hf(INT8 CTS_arg);
      #ifdef      __CTS_F1L__
      _ctsabi INT8 CTS_F1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_F2H__
      _ctsabi INT8 CTS_F2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F2Hf(INT8 CTS_arg);
      #ifdef      __CTS_F2L__
      _ctsabi INT8 CTS_F2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_F3H__
      _ctsabi INT8 CTS_F3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F3Hf(INT8 CTS_arg);
      #ifdef      __CTS_F3L__
      _ctsabi INT8 CTS_F3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_F4H__
      _ctsabi INT8 CTS_F4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F4Hf(INT8 CTS_arg);
      #ifdef      __CTS_F4L__
      _ctsabi INT8 CTS_F4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_F5H__
      _ctsabi INT8 CTS_F5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F5Hf(INT8 CTS_arg);
      #ifdef      __CTS_F5L__
      _ctsabi INT8 CTS_F5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_F6H__
      _ctsabi INT8 CTS_F6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F6Hf(INT8 CTS_arg);
      #ifdef      __CTS_F6L__
      _ctsabi INT8 CTS_F6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_F7H__
      _ctsabi INT8 CTS_F7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F7Hf(INT8 CTS_arg);
      #ifdef      __CTS_F7L__
      _ctsabi INT8 CTS_F7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_F7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_G
  #ifdef          __CTS_G0H__
      _ctsabi INT8 CTS_G0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G0Hf(INT8 CTS_arg);
      #ifdef      __CTS_G0L__
      _ctsabi INT8 CTS_G0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_G1H__
      _ctsabi INT8 CTS_G1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G1Hf(INT8 CTS_arg);
      #ifdef      __CTS_G1L__
      _ctsabi INT8 CTS_G1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_G2H__
      _ctsabi INT8 CTS_G2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G2Hf(INT8 CTS_arg);
      #ifdef      __CTS_G2L__
      _ctsabi INT8 CTS_G2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_G3H__
      _ctsabi INT8 CTS_G3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G3Hf(INT8 CTS_arg);
      #ifdef      __CTS_G3L__
      _ctsabi INT8 CTS_G3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_G4H__
      _ctsabi INT8 CTS_G4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G4Hf(INT8 CTS_arg);
      #ifdef      __CTS_G4L__
      _ctsabi INT8 CTS_G4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_G5H__
      _ctsabi INT8 CTS_G5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G5Hf(INT8 CTS_arg);
      #ifdef      __CTS_G5L__
      _ctsabi INT8 CTS_G5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_G6H__
      _ctsabi INT8 CTS_G6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G6Hf(INT8 CTS_arg);
      #ifdef      __CTS_G6L__
      _ctsabi INT8 CTS_G6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_G7H__
      _ctsabi INT8 CTS_G7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G7Hf(INT8 CTS_arg);
      #ifdef      __CTS_G7L__
      _ctsabi INT8 CTS_G7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_G7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_H
  #ifdef          __CTS_H0H__
      _ctsabi INT8 CTS_H0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H0Hf(INT8 CTS_arg);
      #ifdef      __CTS_H0L__
      _ctsabi INT8 CTS_H0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_H1H__
      _ctsabi INT8 CTS_H1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H1Hf(INT8 CTS_arg);
      #ifdef      __CTS_H1L__
      _ctsabi INT8 CTS_H1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_H2H__
      _ctsabi INT8 CTS_H2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H2Hf(INT8 CTS_arg);
      #ifdef      __CTS_H2L__
      _ctsabi INT8 CTS_H2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_H3H__
      _ctsabi INT8 CTS_H3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H3Hf(INT8 CTS_arg);
      #ifdef      __CTS_H3L__
      _ctsabi INT8 CTS_H3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_H4H__
      _ctsabi INT8 CTS_H4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H4Hf(INT8 CTS_arg);
      #ifdef      __CTS_H4L__
      _ctsabi INT8 CTS_H4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_H5H__
      _ctsabi INT8 CTS_H5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H5Hf(INT8 CTS_arg);
      #ifdef      __CTS_H5L__
      _ctsabi INT8 CTS_H5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_H6H__
      _ctsabi INT8 CTS_H6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H6Hf(INT8 CTS_arg);
      #ifdef      __CTS_H6L__
      _ctsabi INT8 CTS_H6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_H7H__
      _ctsabi INT8 CTS_H7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H7Hf(INT8 CTS_arg);
      #ifdef      __CTS_H7L__
      _ctsabi INT8 CTS_H7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_H7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_I
  #ifdef          __CTS_I0H__
      _ctsabi INT8 CTS_I0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I0Hf(INT8 CTS_arg);
      #ifdef      __CTS_I0L__
      _ctsabi INT8 CTS_I0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_I1H__
      _ctsabi INT8 CTS_I1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I1Hf(INT8 CTS_arg);
      #ifdef      __CTS_I1L__
      _ctsabi INT8 CTS_I1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_I2H__
      _ctsabi INT8 CTS_I2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I2Hf(INT8 CTS_arg);
      #ifdef      __CTS_I2L__
      _ctsabi INT8 CTS_I2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_I3H__
      _ctsabi INT8 CTS_I3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I3Hf(INT8 CTS_arg);
      #ifdef      __CTS_I3L__
      _ctsabi INT8 CTS_I3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_I4H__
      _ctsabi INT8 CTS_I4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I4Hf(INT8 CTS_arg);
      #ifdef      __CTS_I4L__
      _ctsabi INT8 CTS_I4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_I5H__
      _ctsabi INT8 CTS_I5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I5Hf(INT8 CTS_arg);
      #ifdef      __CTS_I5L__
      _ctsabi INT8 CTS_I5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_I6H__
      _ctsabi INT8 CTS_I6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I6Hf(INT8 CTS_arg);
      #ifdef      __CTS_I6L__
      _ctsabi INT8 CTS_I6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_I7H__
      _ctsabi INT8 CTS_I7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I7Hf(INT8 CTS_arg);
      #ifdef      __CTS_I7L__
      _ctsabi INT8 CTS_I7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_I7Lf(INT8 CTS_arg);
      #endif
  #endif

  //_J
  #ifdef          __CTS_J0H__
      _ctsabi INT8 CTS_J0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J0Hf(INT8 CTS_arg);
      #ifdef      __CTS_J0L__
      _ctsabi INT8 CTS_J0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_J1H__
      _ctsabi INT8 CTS_J1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J1Hf(INT8 CTS_arg);
      #ifdef      __CTS_J1L__
      _ctsabi INT8 CTS_J1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_J2H__
      _ctsabi INT8 CTS_J2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J2Hf(INT8 CTS_arg);
      #ifdef      __CTS_J2L__
      _ctsabi INT8 CTS_J2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_J3H__
      _ctsabi INT8 CTS_J3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J3Hf(INT8 CTS_arg);
      #ifdef      __CTS_J3L__
      _ctsabi INT8 CTS_J3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_J4H__
      _ctsabi INT8 CTS_J4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J4Hf(INT8 CTS_arg);
      #ifdef      __CTS_J4L__
      _ctsabi INT8 CTS_J4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_J5H__
      _ctsabi INT8 CTS_J5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J5Hf(INT8 CTS_arg);
      #ifdef      __CTS_J5L__
      _ctsabi INT8 CTS_J5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_J6H__
      _ctsabi INT8 CTS_J6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J6Hf(INT8 CTS_arg);
      #ifdef      __CTS_J6L__
      _ctsabi INT8 CTS_J6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_J7H__
      _ctsabi INT8 CTS_J7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J7Hf(INT8 CTS_arg);
      #ifdef      __CTS_J7L__
      _ctsabi INT8 CTS_J7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_J7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_K
  #ifdef          __CTS_K0H__
      _ctsabi INT8 CTS_K0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K0Hf(INT8 CTS_arg);
      #ifdef      __CTS_K0L__
      _ctsabi INT8 CTS_K0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_K1H__
      _ctsabi INT8 CTS_K1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K1Hf(INT8 CTS_arg);
      #ifdef      __CTS_K1L__
      _ctsabi INT8 CTS_K1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_K2H__
      _ctsabi INT8 CTS_K2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K2Hf(INT8 CTS_arg);
      #ifdef      __CTS_K2L__
      _ctsabi INT8 CTS_K2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_K3H__
      _ctsabi INT8 CTS_K3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K3Hf(INT8 CTS_arg);
      #ifdef      __CTS_K3L__
      _ctsabi INT8 CTS_K3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_K4H__
      _ctsabi INT8 CTS_K4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K4Hf(INT8 CTS_arg);
      #ifdef      __CTS_K4L__
      _ctsabi INT8 CTS_K4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_K5H__
      _ctsabi INT8 CTS_K5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K5Hf(INT8 CTS_arg);
      #ifdef      __CTS_K5L__
      _ctsabi INT8 CTS_K5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_K6H__
      _ctsabi INT8 CTS_K6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K6Hf(INT8 CTS_arg);
      #ifdef      __CTS_K6L__
      _ctsabi INT8 CTS_K6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_K7H__
      _ctsabi INT8 CTS_K7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K7Hf(INT8 CTS_arg);
      #ifdef      __CTS_K7L__
      _ctsabi INT8 CTS_K7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_K7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_L
  #ifdef          __CTS_L0H__
      _ctsabi INT8 CTS_L0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L0Hf(INT8 CTS_arg);
      #ifdef      __CTS_L0L__
      _ctsabi INT8 CTS_L0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_L1H__
      _ctsabi INT8 CTS_L1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L1Hf(INT8 CTS_arg);
      #ifdef      __CTS_L1L__
      _ctsabi INT8 CTS_L1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_L2H__
      _ctsabi INT8 CTS_L2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L2Hf(INT8 CTS_arg);
      #ifdef      __CTS_L2L__
      _ctsabi INT8 CTS_L2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_L3H__
      _ctsabi INT8 CTS_L3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L3Hf(INT8 CTS_arg);
      #ifdef      __CTS_L3L__
      _ctsabi INT8 CTS_L3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_L4H__
      _ctsabi INT8 CTS_L4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L4Hf(INT8 CTS_arg);
      #ifdef      __CTS_L4L__
      _ctsabi INT8 CTS_L4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_L5H__
      _ctsabi INT8 CTS_L5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L5Hf(INT8 CTS_arg);
      #ifdef      __CTS_L5L__
      _ctsabi INT8 CTS_L5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_L6H__
      _ctsabi INT8 CTS_L6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L6Hf(INT8 CTS_arg);
      #ifdef      __CTS_L6L__
      _ctsabi INT8 CTS_L6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_L7H__
      _ctsabi INT8 CTS_L7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L7Hf(INT8 CTS_arg);
      #ifdef      __CTS_L7L__
      _ctsabi INT8 CTS_L7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_L7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_M
  #ifdef          __CTS_M0H__
      _ctsabi INT8 CTS_M0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M0Hf(INT8 CTS_arg);
      #ifdef      __CTS_M0L__
      _ctsabi INT8 CTS_M0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_M1H__
      _ctsabi INT8 CTS_M1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M1Hf(INT8 CTS_arg);
      #ifdef      __CTS_M1L__
      _ctsabi INT8 CTS_M1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_M2H__
      _ctsabi INT8 CTS_M2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M2Hf(INT8 CTS_arg);
      #ifdef      __CTS_M2L__
      _ctsabi INT8 CTS_M2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_M3H__
      _ctsabi INT8 CTS_M3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M3Hf(INT8 CTS_arg);
      #ifdef      __CTS_M3L__
      _ctsabi INT8 CTS_M3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_M4H__
      _ctsabi INT8 CTS_M4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M4Hf(INT8 CTS_arg);
      #ifdef      __CTS_M4L__
      _ctsabi INT8 CTS_M4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_M5H__
      _ctsabi INT8 CTS_M5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M5Hf(INT8 CTS_arg);
      #ifdef      __CTS_M5L__
      _ctsabi INT8 CTS_M5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_M6H__
      _ctsabi INT8 CTS_M6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M6Hf(INT8 CTS_arg);
      #ifdef      __CTS_M6L__
      _ctsabi INT8 CTS_M6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_M7H__
      _ctsabi INT8 CTS_M7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M7Hf(INT8 CTS_arg);
      #ifdef      __CTS_M7L__
      _ctsabi INT8 CTS_M7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_M7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_N
  #ifdef          __CTS_N0H__
      _ctsabi INT8 CTS_N0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N0Hf(INT8 CTS_arg);
      #ifdef      __CTS_N0L__
      _ctsabi INT8 CTS_N0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_N1H__
      _ctsabi INT8 CTS_N1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N1Hf(INT8 CTS_arg);
      #ifdef      __CTS_N1L__
      _ctsabi INT8 CTS_N1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_N2H__
      _ctsabi INT8 CTS_N2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N2Hf(INT8 CTS_arg);
      #ifdef      __CTS_N2L__
      _ctsabi INT8 CTS_N2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_N3H__
      _ctsabi INT8 CTS_N3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N3Hf(INT8 CTS_arg);
      #ifdef      __CTS_N3L__
      _ctsabi INT8 CTS_N3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_N4H__
      _ctsabi INT8 CTS_N4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N4Hf(INT8 CTS_arg);
      #ifdef      __CTS_N4L__
      _ctsabi INT8 CTS_N4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_N5H__
      _ctsabi INT8 CTS_N5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N5Hf(INT8 CTS_arg);
      #ifdef      __CTS_N5L__
      _ctsabi INT8 CTS_N5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_N6H__
      _ctsabi INT8 CTS_N6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N6Hf(INT8 CTS_arg);
      #ifdef      __CTS_N6L__
      _ctsabi INT8 CTS_N6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_N7H__
      _ctsabi INT8 CTS_N7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N7Hf(INT8 CTS_arg);
      #ifdef      __CTS_N7L__
      _ctsabi INT8 CTS_N7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_N7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_O
  //_P
  #ifdef          __CTS_P0H__
      _ctsabi INT8 CTS_P0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P0Hf(INT8 CTS_arg);
      #ifdef      __CTS_P0L__
      _ctsabi INT8 CTS_P0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_P1H__
      _ctsabi INT8 CTS_P1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P1Hf(INT8 CTS_arg);
      #ifdef      __CTS_P1L__
      _ctsabi INT8 CTS_P1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_P2H__
      _ctsabi INT8 CTS_P2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P2Hf(INT8 CTS_arg);
      #ifdef      __CTS_P2L__
      _ctsabi INT8 CTS_P2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_P3H__
      _ctsabi INT8 CTS_P3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P3Hf(INT8 CTS_arg);
      #ifdef      __CTS_P3L__
      _ctsabi INT8 CTS_P3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_P4H__
      _ctsabi INT8 CTS_P4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P4Hf(INT8 CTS_arg);
      #ifdef      __CTS_P4L__
      _ctsabi INT8 CTS_P4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_P5H__
      _ctsabi INT8 CTS_P5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P5Hf(INT8 CTS_arg);
      #ifdef      __CTS_P5L__
      _ctsabi INT8 CTS_P5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_P6H__
      _ctsabi INT8 CTS_P6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P6Hf(INT8 CTS_arg);
      #ifdef      __CTS_P6L__
      _ctsabi INT8 CTS_P6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_P7H__
      _ctsabi INT8 CTS_P7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P7Hf(INT8 CTS_arg);
      #ifdef      __CTS_P7L__
      _ctsabi INT8 CTS_P7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_P7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_Q
  #ifdef          __CTS_Q0H__
      _ctsabi INT8 CTS_Q0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q0Hf(INT8 CTS_arg);
      #ifdef      __CTS_Q0L__
      _ctsabi INT8 CTS_Q0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_Q1H__
      _ctsabi INT8 CTS_Q1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q1Hf(INT8 CTS_arg);
      #ifdef      __CTS_Q1L__
      _ctsabi INT8 CTS_Q1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_Q2H__
      _ctsabi INT8 CTS_Q2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q2Hf(INT8 CTS_arg);
      #ifdef      __CTS_Q2L__
      _ctsabi INT8 CTS_Q2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_Q3H__
      _ctsabi INT8 CTS_Q3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q3Hf(INT8 CTS_arg);
      #ifdef      __CTS_Q3L__
      _ctsabi INT8 CTS_Q3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_Q4H__
      _ctsabi INT8 CTS_Q4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q4Hf(INT8 CTS_arg);
      #ifdef      __CTS_Q4L__
      _ctsabi INT8 CTS_Q4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_Q5H__
      _ctsabi INT8 CTS_Q5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q5Hf(INT8 CTS_arg);
      #ifdef      __CTS_Q5L__
      _ctsabi INT8 CTS_Q5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_Q6H__
      _ctsabi INT8 CTS_Q6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q6Hf(INT8 CTS_arg);
      #ifdef      __CTS_Q6L__
      _ctsabi INT8 CTS_Q6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_Q7H__
      _ctsabi INT8 CTS_Q7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q7Hf(INT8 CTS_arg);
      #ifdef      __CTS_Q7L__
      _ctsabi INT8 CTS_Q7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_Q7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_R
  #ifdef          __CTS_R0H__
      _ctsabi INT8 CTS_R0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R0Hf(INT8 CTS_arg);
      #ifdef      __CTS_R0L__
      _ctsabi INT8 CTS_R0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_R1H__
      _ctsabi INT8 CTS_R1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R1Hf(INT8 CTS_arg);
      #ifdef      __CTS_R1L__
      _ctsabi INT8 CTS_R1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_R2H__
      _ctsabi INT8 CTS_R2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R2Hf(INT8 CTS_arg);
      #ifdef      __CTS_R2L__
      _ctsabi INT8 CTS_R2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_R3H__
      _ctsabi INT8 CTS_R3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R3Hf(INT8 CTS_arg);
      #ifdef      __CTS_R3L__
      _ctsabi INT8 CTS_R3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_R4H__
      _ctsabi INT8 CTS_R4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R4Hf(INT8 CTS_arg);
      #ifdef      __CTS_R4L__
      _ctsabi INT8 CTS_R4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_R5H__
      _ctsabi INT8 CTS_R5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R5Hf(INT8 CTS_arg);
      #ifdef      __CTS_R5L__
      _ctsabi INT8 CTS_R5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_R6H__
      _ctsabi INT8 CTS_R6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R6Hf(INT8 CTS_arg);
      #ifdef      __CTS_R6L__
      _ctsabi INT8 CTS_R6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_R7H__
      _ctsabi INT8 CTS_R7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R7Hf(INT8 CTS_arg);
      #ifdef      __CTS_R7L__
      _ctsabi INT8 CTS_R7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_R7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_S
  #ifdef          __CTS_S0H__
      _ctsabi INT8 CTS_S0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S0Hf(INT8 CTS_arg);
      #ifdef      __CTS_S0L__
      _ctsabi INT8 CTS_S0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_S1H__
      _ctsabi INT8 CTS_S1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S1Hf(INT8 CTS_arg);
      #ifdef      __CTS_S1L__
      _ctsabi INT8 CTS_S1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_S2H__
      _ctsabi INT8 CTS_S2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S2Hf(INT8 CTS_arg);
      #ifdef      __CTS_S2L__
      _ctsabi INT8 CTS_S2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_S3H__
      _ctsabi INT8 CTS_S3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S3Hf(INT8 CTS_arg);
      #ifdef      __CTS_S3L__
      _ctsabi INT8 CTS_S3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_S4H__
      _ctsabi INT8 CTS_S4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S4Hf(INT8 CTS_arg);
      #ifdef      __CTS_S4L__
      _ctsabi INT8 CTS_S4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_S5H__
      _ctsabi INT8 CTS_S5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S5Hf(INT8 CTS_arg);
      #ifdef      __CTS_S5L__
      _ctsabi INT8 CTS_S5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_S6H__
      _ctsabi INT8 CTS_S6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S6Hf(INT8 CTS_arg);
      #ifdef      __CTS_S6L__
      _ctsabi INT8 CTS_S6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_S7H__
      _ctsabi INT8 CTS_S7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S7Hf(INT8 CTS_arg);
      #ifdef      __CTS_S7L__
      _ctsabi INT8 CTS_S7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_S7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_T
  #ifdef          __CTS_T0H__
      _ctsabi INT8 CTS_T0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T0Hf(INT8 CTS_arg);
      #ifdef      __CTS_T0L__
      _ctsabi INT8 CTS_T0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_T1H__
      _ctsabi INT8 CTS_T1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T1Hf(INT8 CTS_arg);
      #ifdef      __CTS_T1L__
      _ctsabi INT8 CTS_T1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_T2H__
      _ctsabi INT8 CTS_T2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T2Hf(INT8 CTS_arg);
      #ifdef      __CTS_T2L__
      _ctsabi INT8 CTS_T2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_T3H__
      _ctsabi INT8 CTS_T3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T3Hf(INT8 CTS_arg);
      #ifdef      __CTS_T3L__
      _ctsabi INT8 CTS_T3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_T4H__
      _ctsabi INT8 CTS_T4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T4Hf(INT8 CTS_arg);
      #ifdef      __CTS_T4L__
      _ctsabi INT8 CTS_T4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_T5H__
      _ctsabi INT8 CTS_T5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T5Hf(INT8 CTS_arg);
      #ifdef      __CTS_T5L__
      _ctsabi INT8 CTS_T5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_T6H__
      _ctsabi INT8 CTS_T6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T6Hf(INT8 CTS_arg);
      #ifdef      __CTS_T6L__
      _ctsabi INT8 CTS_T6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_T7H__
      _ctsabi INT8 CTS_T7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T7Hf(INT8 CTS_arg);
      #ifdef      __CTS_T7L__
      _ctsabi INT8 CTS_T7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_T7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_U
  #ifdef          __CTS_U0H__
      _ctsabi INT8 CTS_U0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U0Hf(INT8 CTS_arg);
      #ifdef      __CTS_U0L__
      _ctsabi INT8 CTS_U0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_U1H__
      _ctsabi INT8 CTS_U1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U1Hf(INT8 CTS_arg);
      #ifdef      __CTS_U1L__
      _ctsabi INT8 CTS_U1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_U2H__
      _ctsabi INT8 CTS_U2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U2Hf(INT8 CTS_arg);
      #ifdef      __CTS_U2L__
      _ctsabi INT8 CTS_U2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_U3H__
      _ctsabi INT8 CTS_U3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U3Hf(INT8 CTS_arg);
      #ifdef      __CTS_U3L__
      _ctsabi INT8 CTS_U3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_U4H__
      _ctsabi INT8 CTS_U4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U4Hf(INT8 CTS_arg);
      #ifdef      __CTS_U4L__
      _ctsabi INT8 CTS_U4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_U5H__
      _ctsabi INT8 CTS_U5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U5Hf(INT8 CTS_arg);
      #ifdef      __CTS_U5L__
      _ctsabi INT8 CTS_U5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_U6H__
      _ctsabi INT8 CTS_U6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U6Hf(INT8 CTS_arg);
      #ifdef      __CTS_U6L__
      _ctsabi INT8 CTS_U6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_U7H__
      _ctsabi INT8 CTS_U7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U7Hf(INT8 CTS_arg);
      #ifdef      __CTS_U7L__
      _ctsabi INT8 CTS_U7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_U7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_V
  #ifdef          __CTS_V0H__
      _ctsabi INT8 CTS_V0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V0Hf(INT8 CTS_arg);
      #ifdef      __CTS_V0L__
      _ctsabi INT8 CTS_V0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_V1H__
      _ctsabi INT8 CTS_V1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V1Hf(INT8 CTS_arg);
      #ifdef      __CTS_V1L__
      _ctsabi INT8 CTS_V1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_V2H__
      _ctsabi INT8 CTS_V2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V2Hf(INT8 CTS_arg);
      #ifdef      __CTS_V2L__
      _ctsabi INT8 CTS_V2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_V3H__
      _ctsabi INT8 CTS_V3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V3Hf(INT8 CTS_arg);
      #ifdef      __CTS_V3L__
      _ctsabi INT8 CTS_V3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_V4H__
      _ctsabi INT8 CTS_V4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V4Hf(INT8 CTS_arg);
      #ifdef      __CTS_V4L__
      _ctsabi INT8 CTS_V4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_V5H__
      _ctsabi INT8 CTS_V5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V5Hf(INT8 CTS_arg);
      #ifdef      __CTS_V5L__
      _ctsabi INT8 CTS_V5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_V6H__
      _ctsabi INT8 CTS_V6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V6Hf(INT8 CTS_arg);
      #ifdef      __CTS_V6L__
      _ctsabi INT8 CTS_V6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_V7H__
      _ctsabi INT8 CTS_V7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V7Hf(INT8 CTS_arg);
      #ifdef      __CTS_V7L__
      _ctsabi INT8 CTS_V7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_V7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_W
  #ifdef          __CTS_W0H__
      _ctsabi INT8 CTS_W0HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W0Hf(INT8 CTS_arg);
      #ifdef      __CTS_W0L__
      _ctsabi INT8 CTS_W0LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W0Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_W1H__
      _ctsabi INT8 CTS_W1HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W1Hf(INT8 CTS_arg);
      #ifdef      __CTS_W1L__
      _ctsabi INT8 CTS_W1LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W1Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_W2H__
      _ctsabi INT8 CTS_W2HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W2Hf(INT8 CTS_arg);
      #ifdef      __CTS_W2L__
      _ctsabi INT8 CTS_W2LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W2Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_W3H__
      _ctsabi INT8 CTS_W3HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W3Hf(INT8 CTS_arg);
      #ifdef      __CTS_W3L__
      _ctsabi INT8 CTS_W3LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W3Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_W4H__
      _ctsabi INT8 CTS_W4HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W4Hf(INT8 CTS_arg);
      #ifdef      __CTS_W4L__
      _ctsabi INT8 CTS_W4LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W4Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_W5H__
      _ctsabi INT8 CTS_W5HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W5Hf(INT8 CTS_arg);
      #ifdef      __CTS_W5L__
      _ctsabi INT8 CTS_W5LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W5Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_W6H__
      _ctsabi INT8 CTS_W6HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W6Hf(INT8 CTS_arg);
      #ifdef      __CTS_W6L__
      _ctsabi INT8 CTS_W6LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W6Lf(INT8 CTS_arg);
      #endif
  #endif
  #ifdef          __CTS_W7H__
      _ctsabi INT8 CTS_W7HS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W7Hf(INT8 CTS_arg);
      #ifdef      __CTS_W7L__
      _ctsabi INT8 CTS_W7LS(INT8 CTS_arg);
      _ctsabi INT8 CTS_W7Lf(INT8 CTS_arg);
      #endif
  #endif


  //_X
  //_Y
  //_Z



#endif /*CTS_LowTypes_H*/
