/***********************************************************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2009 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
*********************************************************************************************************************//*!
*
* @file   ATL_Timer.h
*
* @brief  Functions prototypes, constants, variables and macros for control and configuration of the HW timer 
*
* @version 1.0.18.0
* 
* @date Jun-9-2010
* 
*
***********************************************************************************************************************/

#if TSS_USE_ATL_LOW_LEVEL

  #ifndef __ATL_Timer_H__
    #define __ATL_Timer_H__
    
    extern UINT8 atl_u8HWTimerFlag;  /* Extern variable flag that tereminates if there is been a timeout fault */

    /*********** HW Timer Availability Macros **********/

    #define MTIMSC_CHK           0x01
    #define MTIM1SC_CHK          0x02
    #define TPMSC_CHK            0x03
    #define TPM1SC_CHK           0x04
    #define TPM2SC_CHK           0x05
    #define TPM3SC_CHK           0x06
    #define TPM4SC_CHK           0x07
    #define FTMSC_CHK            0x08
    #define FTM1SC_CHK           0x09
    #define FTM2SC_CHK           0x0A
    #define FTM3SC_CHK           0x0B
    #define FTM4SC_CHK           0x0C
    
    /*******************************************************
     ************ Validation of Timer Setttings ************
     *******************************************************/
    
    #if TSS_USE_ATL_LOW_LEVEL
      #ifndef ATL_HW_TIMER
          #error "TSS - Not defined ATL_HW_TIMER"
      #endif
    #endif
    
    /*******************************************************
     ************ HW Timer Constants Definitions ***********
     *******************************************************/

    /* Timer name convert macros */
    #define ATL_HW_TIMER_TO_SC(reg)            reg##SC
    #define ATL_GET_HW_TIMER_SC(name)          ATL_HW_TIMER_TO_SC(name)

    /* Addresses of all the configuration timer registers */
    #define ATL_HW_TIMER_ADDRESS               &ATL_GET_HW_TIMER_SC(ATL_HW_TIMER)  /* The address of the Timer is assigned by the compiler */

    /* Timer Availability Macros */
    #define ATL_HW_TIMER2NAME_RESULT(res)      res##SC_CHK
    #define ATL_HW_TIMER2NAME_CONV(text)       ATL_HW_TIMER2NAME_RESULT(text)
    #define ATL_HW_TIMER_CHK(name)             ATL_HW_TIMER2NAME_CONV(name)

    /*******************************************************
     **** HW Timer Overflow Interrupt Vector definition ****
     *******************************************************/
    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == MTIMSC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vmtim
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == MTIM1SC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vmtim1
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == TPMSC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vtpmovf
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == TPM1SC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vtpm1ovf
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == TPM2SC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vtpm2ovf
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == TPM3SC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vtpm3ovf
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == TPM4SC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vtpm4ovf
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == FTMSC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vftmovf
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == FTM1SC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vftm1ovf
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == FTM2SC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vftm2ovf
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == FTM3SC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vftm3ovf
    #endif    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == FTM4SC_CHK) 
      #define ATL_HW_TIMER_VECTOR              VectorNumber_Vftm4ovf
    #endif    
    
    /************** MCU Exceptions solving *************/
    
    /* QD4 exception */
    #ifdef TPMSC_TOF_MASK
      #ifndef TPM1SC_TOF_MASK
        #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == TPM1SC_CHK)
          #undef ATL_HW_TIMER
          #define ATL_HW_TIMER                 TPM       
        #endif
      #endif
    #endif

    /********* Specific Timer related macros ***********/
    
    #if (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == MTIMSC_CHK) || (ATL_HW_TIMER_CHK(ATL_HW_TIMER) == MTIM1SC_CHK)
      
      /* MTIM HW Timer configuration values */
      #define ATL_HW_MTIM_IE                   0x40U 
      #define ATL_HW_MTIM_FLAG                 0x80U 
      #define ATL_HW_MTIM_ON                   0xEFU 
      #define ATL_HW_MTIM_OFF                  0x10U 
      #define ATL_HW_MTIM_CNT_AND_FLAG_RESET   0x20U 

      #define ATL_HW_MTIM_PRESCALE_MASK        0x0FU 

      #define ATL_HW_MTIM_SC                   *(volatile UINT8  *)(ATL_HW_TIMER_ADDRESS+0) 
      #define ATL_HW_MTIM_CLK                  *(volatile UINT8  *)(ATL_HW_TIMER_ADDRESS+1)
      #define ATL_HW_MTIM_CNT                  *(volatile UINT8  *)(ATL_HW_TIMER_ADDRESS+2)
      #define ATL_HW_MTIM_MOD                  *(volatile UINT8  *)(ATL_HW_TIMER_ADDRESS+3)

      /*******************************************************
       ******************* MTIM HW Timer Macros **************
       *******************************************************/

      #define ATL_HW_TIMER_SET_PRESCALE(x)     (ATL_HW_MTIM_CLK = ((UINT8)(ATL_HW_MTIM_CLK & ((UINT8)(~(UINT8)ATL_HW_MTIM_PRESCALE_MASK)))) | (x))   /*Changed due to MISRA*/
      
      #define ATL_HW_TIMER_ENABLE_INT()        (ATL_HW_MTIM_SC |= ATL_HW_MTIM_IE)
      #define ATL_HW_TIMER_DISABLE_INT()       ATL_HW_MTIM_SC &= !ATL_HW_MTIM_IE
      #define ATL_HW_TIMER_SET_MOD(x)          (ATL_HW_MTIM_MOD = x)
      #define ATL_HW_TIMER_GET_MOD()           ATL_HW_MTIM_MOD
      #define ATL_HW_TIMER_START()             (ATL_HW_MTIM_SC &= ATL_HW_MTIM_ON)
      #define ATL_HW_TIMER_STOP()              (ATL_HW_MTIM_SC |= ATL_HW_MTIM_OFF)
      #define ATL_HW_TIMER_RESET()             ATL_HW_MTIM_SC |= ATL_HW_MTIM_CNT_AND_FLAG_RESET
      #define ATL_HW_TIMER_GET_LOWCNT()        ATL_HW_MTIM_CNT             
      #define ATL_HW_TIMER_GET_CNT()           ATL_HW_MTIM_CNT

      #define ATL_HW_TIMER_CLEARFLAG()         ATL_HW_MTIM_SC |= ATL_HW_MTIM_CNT_AND_FLAG_RESET;
      #define ATL_HW_TIMER_OVF_FLAG()          (ATL_HW_MTIM_SC & ATL_HW_MTIM_FLAG)
      
    #else 

      /* HW Timer configuration values */
      #define ATL_HW_TIMER_PRESCALE_MASK       0x07U
      #define ATL_HW_TIMER_IE                  0x40U
      #define ATL_HW_TIMER_FLAG                0x80U
      #define ATL_HW_TIMER_ON                  0x08U
      #define ATL_HW_TIMER_OFF                 0xE7U
      #define ATL_HW_TIMER_FLAG_ACK            0x7FU

      #define ATL_HW_TIMER_SC                  *(volatile UINT8  *)(ATL_HW_TIMER_ADDRESS+0) 
      #define ATL_HW_TIMER_CNT                 *(volatile UINT16 *)(ATL_HW_TIMER_ADDRESS+1)
      #define ATL_HW_TIMER_CNTH                *(volatile UINT8  *)(ATL_HW_TIMER_ADDRESS+1)
      #define ATL_HW_TIMER_CNTL                *(volatile UINT8  *)(ATL_HW_TIMER_ADDRESS+2)
      #define ATL_HW_TIMER_MOD                 *(volatile UINT16 *)(ATL_HW_TIMER_ADDRESS+3)
      #define ATL_HW_TIMER_MODH                *(volatile UINT8  *)(ATL_HW_TIMER_ADDRESS+3)
      #define ATL_HW_TIMER_MODL                *(volatile UINT8  *)(ATL_HW_TIMER_ADDRESS+4)

      /*******************************************************
       ************* TPM/FTM HW Timer Tasks Macros ***********
       *******************************************************/
      
      #define ATL_HW_TIMER_SET_PRESCALE(x)     (ATL_HW_TIMER_SC = (UINT8)((ATL_HW_TIMER_SC & (~ATL_HW_TIMER_PRESCALE_MASK)) | (x)))   /*Changed due to MISRA*/
      #define ATL_HW_TIMER_ENABLE_INT()        (ATL_HW_TIMER_SC |= ATL_HW_TIMER_IE)
      #define ATL_HW_TIMER_DISABLE_INT()       ATL_HW_TIMER_SC &= !ATL_HW_TIMER_IE
      #define ATL_HW_TIMER_SET_MOD(x)          (ATL_HW_TIMER_MOD = x)
      #define ATL_HW_TIMER_GET_MOD()           ATL_HW_TIMER_MOD
      #define ATL_HW_TIMER_START()             (ATL_HW_TIMER_SC |= ATL_HW_TIMER_ON)
      #define ATL_HW_TIMER_STOP()              (ATL_HW_TIMER_SC &= ATL_HW_TIMER_OFF)
      #define ATL_HW_TIMER_RESET()             (ATL_HW_TIMER_CNT = 0x0000U)
      #define ATL_HW_TIMER_GET_LOWCNT()        ATL_HW_TIMER_CNTL             
      #define ATL_HW_TIMER_GET_HICNT()         ATL_HW_TIMER_CNTH             
      #define ATL_HW_TIMER_GET_CNT()           ATL_HW_TIMER_CNT

      #define ATL_HW_TIMER_CLEARFLAG()         ATL_HW_TIMER_SC &= ATL_HW_TIMER_FLAG_ACK;
      #define ATL_HW_TIMER_OVF_FLAG()          (ATL_HW_TIMER_SC & ATL_HW_TIMER_FLAG)

    #endif

  #endif /* End of __ATL_Timer_H__ */

#endif /* End of TSS_USE_ATL_LOW_LEVEL */
