/*****************************************************************************/
/*                                 Includes
/*****************************************************************************/

  #include "Pedometer.h"
  
/*****************************************************************************/
/*                                  Globals
/*****************************************************************************/

  #define PEDOMETER_WINDOW_XPOS  40
  #define PEDOMETER_WINDOW_YPOS  12
  
/*****************************************************************************/
/*                                  Globals
/*****************************************************************************/

 
 UINT32 u32Steps_Counter;
 UINT8 MMA7660_InterruptSucceded=0;
 UINT8 first;                    
                                                               
 INT8 X,Y,Z; //Test var Erase

/*****************************************************************************/
/*                                Pedometer Init
/*****************************************************************************/

void vfnPedometer_Init (void){
 
  SOPT3_IICPS=0;                                //IIC pins on PTF3 & PTF4
  IRQSC = IRQSC_IRQPE_MASK | IRQSC_IRQIE_MASK;  //IRQ Enabled
  /* Display Steps */
  Display_Number(u32Steps_Counter,PEDOMETER_WINDOW_XPOS,PEDOMETER_WINDOW_YPOS,5);
  vfnIICV1Init();                               //IIC Init
  vfnMMA7660Init();                             //Acelerometer Init

}

/*****************************************************************************/
/*                                 GET STEPS
/*****************************************************************************/

void vfnPedometer_Get_Steps (void){

  static UINT8 u8Valid_Step=0;
  INT8 i8Acelerometer_Data[3]; 
  UINT8 u8Acelerometer_Index;
 
  while(IIC_BUSY);//Waits until IIC isn't busy
  do{
  i8Acelerometer_Data[0]=MMA7660Read(MMA7660_Xaxisout);
  }
  
  while(i8Acelerometer_Data[0]&0x40);//Checks Alert Bit, if set, reads again
  do{
  i8Acelerometer_Data[1]=MMA7660Read(MMA7660_Yaxisout);
  }
  
  while(i8Acelerometer_Data[1]&0x40);//Checks Alert Bit, if set, reads again
  do{
  i8Acelerometer_Data[2]=MMA7660Read(MMA7660_Zaxisout);  
  }while(i8Acelerometer_Data[2]&0x40);//Checks Alert Bit, if set, reads again
 
 
  for(u8Acelerometer_Index=0;u8Acelerometer_Index<3;u8Acelerometer_Index++){
    if((i8Acelerometer_Data[u8Acelerometer_Index] & 0x20)){     //Check for sign
     
      /**************************For Complement 2 Sign Mode**************************/
      i8Acelerometer_Data[u8Acelerometer_Index]&=0x1F;
      i8Acelerometer_Data[u8Acelerometer_Index]|=0xE0;
          
    }
  }  
 
  /* Test routine Erase */
 
  X=i8Acelerometer_Data[0];
  Y=i8Acelerometer_Data[1];
  Z=i8Acelerometer_Data[2];
 
  /* STEP DETECTED */
  if(first==True){
    first=False;
  }else{
    
  if(i8Acelerometer_Data[0]<=(X_TRESHOLD) && u8Valid_Step==1 && i8Acelerometer_Data[2]>=(Z_TRESHOLD)){

    u32Steps_Counter++;
    u8Valid_Step=0;
   
    Display_Number(u32Steps_Counter,PEDOMETER_WINDOW_XPOS,PEDOMETER_WINDOW_YPOS,5);
  
  }else if(i8Acelerometer_Data[0]>(X_TRESHOLD) && i8Acelerometer_Data[2]<(Z_TRESHOLD)){
    
    u8Valid_Step=1;
  }
  }
}

/*****************************************************************************/
/*                            PEDOMETER MAIN ROUTINE
/*****************************************************************************/

void vfnPedometer_Handler (void){
 
  UINT32 u32PreviousCounterStatus;
 
  /* Init Pedometer */
  vfnPedometer_Init();  //Erase
 
  /* Main Periodical Routine */
  while (gu8ButtonStatus!=BUTTON_EXIT){

    TSS_Task();  //Touch Sensing Periodical Task
  
    /* Acelerometer Interrupt */
    if(MMA7660_InterruptSucceded){
      MMA7660_InterruptSucceded=False;
      vfnPedometer_Get_Steps();
    }
  }
 
  IRQSC=0; 
  u32PreviousCounterStatus=u32StepsCountSDHandler(LOAD_STEPS);
  /* Save Changes */
  if(u32PreviousCounterStatus!=u32Steps_Counter)
  u32StepsCountSDHandler(SAVE_STEPS);
 
}
  
/*****************************************************************************/
/*                                 Functions
/*****************************************************************************/
 
UINT32 u32StepsCountSDHandler (UINT8 u8Task){

  UINT8 u8SD_Status;
  UINT8 u8ReadBuffer[512];
  UINT8 u8StepctrSeparator[2];
  UINT32 u32StepctrValue;
  
  /* Check for SD */
  if(!SD_PRESENT){ 
  
    /* Open Steps File */
    u8SD_Status=FAT_FileOpen(STEPS_FILE,READ);

    /* Steps File not Found */
    if(u8SD_Status==FILE_NOT_FOUND){
      FAT_FileOpen(STEPS_FILE,CREATE);         
      FAT_FileClose();
      u32StepctrValue=0;
    }
   
    /* Steps File Found */
    if(u8SD_Status == FILE_FOUND){
      
      switch (u8Task){
        
        /* LOAD STEPS ROUTINE */
        case LOAD_STEPS:
        u8SD_Status=FAT_FileOpen(STEPS_FILE,READ);
        if(u8SD_Status==FILE_FOUND){
          FAT_FileRead((UINT8*)u8ReadBuffer);
          u32StepctrValue=u8ReadBuffer[0];
          u32StepctrValue=u32StepctrValue<<8;
          u32StepctrValue|=u8ReadBuffer[1];
        }
        break;
      
        /* SAVE STEPS ROUTINE */
        case SAVE_STEPS:
        u8SD_Status=FAT_FileOpen(STEPS_FILE,OVERWRITE);
        if(u8SD_Status==FILE_FOUND){
          u32StepctrValue=u32Steps_Counter;
          u8StepctrSeparator[1]=(UINT8)u32StepctrValue;
          u32StepctrValue=u32StepctrValue>>8;
          u8StepctrSeparator[0]=(UINT8)u32StepctrValue;
          FAT_FileWrite((UINT8*)u8StepctrSeparator,2);
          u32StepctrValue=0;
          FAT_FileClose();
        }
        break;
      
        default:
        break;
      }
    
    }  
  
  }
  return u32StepctrValue;
}                             