/*****************************************************************************/
/*                         Freescale Semiconductor                           */
/*****************************************************************************/
/* File Type: Header                                                         */
/* File Name: Numbers.h                                                      */
/* Description: HEX code to write numbers on a NewHeaven TFT display         */
/* Author: Jos Santiago Lpez Ramrez                                       */
/* Date: 27/09/10                                                            */
/*****************************************************************************/

#include "FslTypes.h"
#include "TFT.h"


#ifndef _Numbers_H_
  #define _Numbers_H_
   
  
  /**************************************************************************/
  /*                                Arrays                                  */
  /**************************************************************************/
  
//Displays a 11X20 Pixels one
extern const UINT8 one[];

//Displays a 11X20 Pixels two
extern const UINT8 two[];

//Displays a 11X20 Pixels three
extern const UINT8 three[];

//Displays a 11X20 Pixels four
extern const UINT8 four[];

//Displays a 11X20 Pixels five
extern const UINT8 five[];

//Displays a 11X20 Pixels six
extern const UINT8 six[];

//Displays a 11X20 Pixels seven
extern const UINT8 seven[];

//Displays a 11X20 Pixels eight
extern const UINT8 eight[];

//Displays a 11X20 Pixels nine
extern const UINT8 nine[];

//Displays a 11X20 Pixels zero
extern const UINT8 zero[];

  /**************************************************************************/
  /*                         Function Declarations                          */
  /**************************************************************************/
        
        /**
     * \brief  This function dislplays the value of "number" on the TFT display
     * \author Jos Santiago Lpez Ramrez
     * \param  UINT32 number: Value to be displayed on Decimal base (3 digits maximum)
     * \param  UINT8 xspos: Starting position on X
     * \param  UINT8 yspos: Starting position on y
     * \param  UINT8 u8DigitstoDisplay: quantity of digits to be displayed
     * \return void
     * \todo   
     * \warning 
     */ 
      void Display_Number (UINT32 number, UINT8 xspos, UINT8 yspos, UINT8 u8DigitstoDisplay);

#endif
