/************************************************************************************************/
/*                                      Includes Section                                        */
/************************************************************************************************/
#include "ADC_DAC.h"

/************************************************************************************************/
/*                                     Constants Section                                        */
/************************************************************************************************/

/************************************************************************************************/
/*                                Function Prototipes Section                                   */
/************************************************************************************************/


/************************************************************************************************/
/*                                Global Variables Section                                      */
/************************************************************************************************/


/************************************************************************************************/
/*                                      Functions Section                                       */
/************************************************************************************************/

void ADC_Init(void)
{
	SCGC1 |= SCGC1_ADC_MASK;                //Enable ADC module
	
	ADCCFG1 = 0;
	ADCCFG1_ADLPC = 0;                      //normal operation
	ADCCFG1_ADIV =   0;                     //input clock / 1
	ADCCFG1_ADLSMP = 0;                     //Short sample
	ADCCFG1_MODE = 3;                       //16 bit resolution, single-ended
	ADCCFG1_ADICLK = 0;                     //ADC clock = bus clock
	
	ADCCFG2 = 0;
	ADCCFG2_ADACKEN = 1;                    //asynchronous clock enable
	ADCCFG2_ADHSC = 0;                      //normal speed
	ADCCFG2_ADLSTS = 3;                     //2 ADClocks extra
	
	ADCSC2 = 0x00;                          //VREFH and VREFL
	
	ADCSC3_ADCO = 0;                        //single convertion
	ADCSC3_AVGE = 0;                        //hardware average disabled
	ADCSC3_AVGS = 0;                        //4 samples averaged
	
	ADCSC1A = 0x04;                         //select channel 4
}

/************************************************************************************************/

void DAC_Init(void)
{
     SCGC1 |= SCGC1_DAC_MASK;
     
     DACS = 0x00;
     DACC0 = 0xA0;
     DACC0_DACRFS = 1;             //Select external voltage reference
     
     DACC1 = 0x00;
     DACDAT0H = 0x00;
     DACDAT0L = 0x00;
}





