#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCG.h"
#include "Display.h"
#include "VREF.h"
#include "DAC.h"
#include "OPAMP.h"
#include "ADC.h"
#include "PDB.h"


void main(void) 
{
  EnableInterrupts; /* enable interrupts */
  vfnMCG_Init();
  vfnSCIInit();

  /**Step1: Enabled VREF to source internal peripherals */
  vfnVREF_Init(_IntUseOnly);
  
  /**Step2: Sine wave to exit from DAC output*/
  vfnDACFillBuffer();
  vfnDACInit(gu8DACConfig1, gu8DACConfig2);
  vfnDACSetPointer (0,15);
  
  /**Step4: Amplify DAC output with the OPAMP */
  vfnOPAMPInit ();
  vfnOPAMPConfig (OPAMP0);

  /**Step5: Configure ADC to be triggered by the PDB module */
  vfnADC_Init();
  vfnADConfigChannel(1);
  vfnADCHWTrigger(ADC_HWTRG_PDB);
  
  /**Step6: Configure back-to-back operation */
  vfnPDBInit();
  vfnPDBConfig(PDB_CONTINUOUS_MODE);
 
   /**Step7: Configure all the ADC channels */
   ADCSC1A = ADC_DACO_CH;		
   ADCSC1B = ADC_OPAMP0_CH;		
   ADCSC1C = ADC_DACO_CH;		
   ADCSC1D = ADC_OPAMP0_CH;		
   ADCSC1E = ADC_DACO_CH;		
   ADCSC1F=  ADC_OPAMP0_CH;		
   ADCSC1G = ADC_DACO_CH;		
   ADCSC1H = (ADC_OPAMP0_CH | ADCSC1H_AIENH_MASK);		
  
   /**Step8: PDB counter starts counting (software trigger the PDB)*/
   PDB_TRIGGER; 
  
  for(;;) 
  {
 
	if (ADC_COCO)
    {
    	ADC_COCO_CLEAR;
  	    vfnGraphicWords(&sADC.gu16LatestResult[0]);   	
    }
	  __RESET_WATCHDOG(); /* feeds the dog */
  }
}
