/****************************************************************************************************/
/**
\file       PDB.c
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June, 2010	        
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	  */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	  */
/* product.                                                                                      	  */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/


/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "PDB.h"
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
struct tPDB sPDB;
/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
UINT16 gu16PDBDelayBuffer[ ] = {750,1500,2250,3000};
/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief 	
* \param      
* \return   
* \todo     
*/
/****************************************************************************************************/
void vfnPDBInit (void)
{
   sPDB.gu16Modulus = 3005;	
   sPDB.gu16DACDelay = 3000;
   sPDB.gu16DelayA = 350;
   sPDB.gu16IntDelay = 1500;
}
/****************************************************************************************************/
/**
* \brief 	
* \param      
* \return   
* \todo     
*/
/****************************************************************************************************/
void vfnPDBConfig (UINT8 u8Mode)
{
	
	  PDBMOD = sPDB.gu16Modulus;
	  DACINT = sPDB.gu16DACDelay;
	  PDBIDLY = sPDB.gu16IntDelay;
	  PDBDLYA = sPDB.gu16DelayA;
	  
	  PDBSC_LDOK = 1   ;// Load value of PDBDLYn from buffers to registers
	  
	  PDBC1 = PDB_TRG_SOFTWARE | PDB_PSL_64;
	  PDBC1_CONT = u8Mode;
	  
	  
	  PDBSC = PDBSC_DACTOE_MASK | PDBSC_TOS1_MASK | PDBSC_PDBIE_MASK | PDBSC_PDBIF_MASK;
	  
	  PDBC2 = 0xFE ;     //Back to back triggers ADC conversion. SW trigger not yet started
	  PDBCHEN = 0xFF;   // Eneable output to related ADC n channels
	  
	  PDBSC_PDBEN =1 ;  // Enable PDB module
}

void vfnPDBFillBuffer (UINT16* u16NewData)
{
  PDBDLYA = *u16NewData;
  u16NewData ++;
  PDBDLYB = *u16NewData;
  u16NewData ++;
  PDBDLYC = *u16NewData;
  u16NewData ++;
  PDBDLYD = *u16NewData;
}

__interrupt VectorNumber_Vpdb void PDB_ISR (void)
{
	PDBSC_PDBIF = 1;
	PDB_INTERRUPT_EVENT;
}
