/****************************************************************************************************/
/**
\file       VREF.c
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010	        
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	  */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	  */
/* product.                                                                                      	  */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/


/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "VREF.h"
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief 	
* \param      
* \return   
* \todo     
*/
/****************************************************************************************************/
void vfnVREF_Init (unsigned char u8Mode)
{
  /** 1 Turn on voltage reference module */
  VREFSC_VREFEN = 1;

  /** 2 Configure Bandgap mode & wait until the modules stabilizes */
  VREFSC_MODE = _Bandgap;
  while (!VREFSC_VREFST) __RESET_WATCHDOG();

  /** 3 Configure selected mode */
  if (u8Mode == _IntUseOnly || u8Mode == _IntExtUse)
  {
    VREFSC_MODE = u8Mode;
  }
}
