
/****************************************************************************************************/
/**
\file       SCI.h
\brief      
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __SCI_H__H
#define __SCI_H__H

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "derivative.h"
#include "FslTypes.h"

/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
    typedef enum
    {
      SCIRxOk,
      SCIRxOverrun,
      SCITxMsg,
      SCITxInProgress,
      SCIStatusFlag4,
      SCIStatusFlag5,
      SCIStatusFlag6,
      SCIStatusFlag7,
    }__SCIStatusBits__;

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/
extern UINT8 gu8SCIStatus;
extern UINT8 gu8SCIRxData;
/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
    #define SCIBusClock           24000000

	#define SCI115200bps          (unsigned int)((unsigned long)(SCIBusClock) / (unsigned long)(1843200))    //115200* 16
    #define SCI57600bps           (unsigned int)((unsigned long)(SCIBusClock) / (unsigned long)(921600))    //57600 * 16
    #define SCI38400bps           (unsigned int)((unsigned long)(SCIBusClock) / (unsigned long)(614400))    //38400 * 16
    #define SCI19200bps           (unsigned int)((unsigned long)(SCIBusClock) / (unsigned long)(307200))    //19200 * 16
    #define SCI9600bps            (unsigned int)((unsigned long)(SCIBusClock) / (unsigned long)(153600))    // 9600 * 16
    #define SCI4800bps            (unsigned int)((unsigned long)(SCIBusClock) / (unsigned long)(76800))     // 4800 * 16

    #define SCIBaudRate           SCI115200bps
    
    #define SCI_OK                1
    #define SCI_ERROR             0

	#define SCI_Rx_EVENT()				EVENT(gu8SCIStatus,SCIRxOk)
	#define SCI_Rx_CLEAR_EVENT()		CLEAR(gu8SCIStatus,SCIRxOk)
	#define SCI_Rx						COMPARE(gu8SCIStatus,SCIRxOk)

	#define SCI_RxOverrun_EVENT()		EVENT(gu8SCIStatus,SCIRxOk)
	#define SCI_RxOverrun_CLEAR_EVENT()	CLEAR(gu8SCIStatus,SCIRxOk)
	#define SCI_RxOverrun				COMPARE(gu8SCIStatus,SCIRxOk)

	#define SCI_TxMsg_EVENT()			EVENT(gu8SCIStatus,SCITxMsg)
	#define SCI_TxMsg_CLEAR_EVENT()		CLEAR(gu8SCIStatus,SCITxMsg)
	#define SCI_TxMsg					COMPARE(gu8SCIStatus,SCITxMsg)
	
	#define SCI_TxInProgress_EVENT()		EVENT(gu8SCIStatus,SCITxInProgress)
	#define SCI_TxInProgress_CLEAR_EVENT()	CLEAR(gu8SCIStatus,SCITxInProgress)
	#define SCI_TxInProgress				COMPARE(gu8SCIStatus,SCITxInProgress)

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
void vfnSCIInit(void);
UINT8 u8fnSCITxData(UINT8 lu8SCIData);
void vfnSCITxMsg(UINT8* lu8pSCIData, UINT16 lu16SCIDataSize);

/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* __SCI_H__H */
