/****************************************************************************************************/
/**
\file       ADC.c
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010	        
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	  */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	  */
/* product.                                                                                      	  */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connection with product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/


/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "ADC.h"
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/
#define ONE_VOLT			(10000 << 1)
/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
struct tADCChannel sADCChannels[ADC_CHANNELS_USED];
struct tADC sADC; 
/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief  Set up the channels, mode, clock, etc.. for the ADC
* \param        
* \return   
* \todo  differential or single mode ADCSC1n_DIFF 
*/

/****************************************************************************************************/
void vfnADC_Init (void)
{
	/**Enable ADC interrupts on all ADC control registers*/
	ADCSC1A |= ADCSC1A_AIENA_MASK;
	ADCSC1B |= ADCSC1B_AIENB_MASK;
	ADCSC1C |= ADCSC1C_AIENC_MASK;
	ADCSC1D |= ADCSC1D_AIEND_MASK;
										
	/** 16 bit resolution, bus clock divided by 4 */
    ADCCFG1 = _16B_MASK | ADCCFG1_ADIV_MASK;
   
    /** High conversion speed */
    ADCCFG2 = ADCCFG2_ADHSC_MASK;
	
	sADCChannels[0].u8Channel = ADC_CH4;
	sADCChannels[0].u8ControlRegister = ADC_CRA;
	sADCChannels[0].u8Control1 = ADC_COMPARE | ADC_GREATER_THAN;
	sADCChannels[0].u8Control2 = ADC_HW_AVERAGE | ADC_32SAMPLES;
	sADCChannels[0].u16CompareValue1 = ONE_VOLT;
    
    sADCChannels[1].u8Channel = ADC_DACO_CH;
    sADCChannels[1].u8Control1 = 0;
    sADCChannels[1].u8Control2 = 0;
    
    sADCChannels[2].u8Channel = ADC_OPAMP0_CH;
    sADCChannels[2].u8Control1 = 0;
    sADCChannels[2].u8Control2 = ADC_HW_AVERAGE | ADC_32SAMPLES;
}

/****************************************************************************************************/
/**
* \brief  Set up the channels, mode, average, compare, etc.. for the ADC
* \param        
* \return   
* \todo     
*/

/****************************************************************************************************/
void vfnADConfigChannel (UINT8 lu8ChannelIndex)
{
	 sADC.gu8ActualChannel = lu8ChannelIndex;
	 ADCSC2 = sADCChannels[lu8ChannelIndex].u8Control1;
	 ADCSC3 = sADCChannels[lu8ChannelIndex].u8Control2;
	 ADCCV1 = sADCChannels[lu8ChannelIndex].u16CompareValue1;
	 ADCCV2 = sADCChannels[lu8ChannelIndex].u16CompareValue2;
}
/****************************************************************************************************/
/**
* \brief  Enable hardware trigger
* \param  UINT8 lu8Trigger: possible hardware triggers    
* 							ADC_HWTRG_PDB --> Programmable Delay Block 
*  							ADC_HWTRG_TOD --> Time of Day
* \return   
* \todo     
*/

/****************************************************************************************************/
void vfnADCHWTrigger (UINT8 lu8Trigger)
{
	ADCSC2_ADTRG = 1;
	SIMIPS_ADCTRS = lu8Trigger;
}
/****************************************************************************************************/
/**
* \brief  Enable hardware trigger
* \param  UINT8 lu8Trigger: possible hardware triggers    
* 							ADC_HWTRG_TOD --> Time of Day
*  							ADC_HWTRG_TPM --> Timer Pulse-With Modulator   
* \return   
* \todo     
*/
/****************************************************************************************************/
__interrupt VectorNumber_Vadc void ADC_ISR (void)
{
    sADC.gu16LatestResult[0] = ADCRA;
    sADC.gu16LatestResult[1] = ADCRB;
    sADC.gu16LatestResult[2] = ADCRC;
    sADC.gu16LatestResult[3] = ADCRD;            
    ADC_COCO_EVENT;
}
