/*******************************************************************************
* NXP Semiconductors
* (c) Copyright 2016 NXP Semiconductors
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. NXP neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED 
TO THE PROJECT BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. 
IN NO EVENT SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THIS AGREEMENT. 
CUSTOMER agrees to hold NXP harmless against any and all claims demands 
or actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result 
of the advise or assistance supplied CUSTOMER in connection with product, 
services or goods supplied under this Agreement.
********************************************************************************
* File:             main.c
* Owner:            nxa13250(Vlna Peter)
* Version:          1.0
* Date:             Aug-31-2016
* Classification:   General Business Information
* Brief:            DRUN mode with max core frequency(200MHz) generated from PPL0
*                   STCU2 online BIST example code
********************************************************************************
********************************************************************************
* Detailed Description:
*
* 
* ------------------------------------------------------------------------------
* Test HW:  MPC57xx
* Maskset:  1N83M (cut 2.0B)
* Target :  internal_FLASH
* Fsys:     200MHz PLL0 as system clock
********************************************************************************
Revision History:
1.0     Oct-19-2015     b21190(Vlna Peter)  Initial Version
1.1	Nov-11-2015	b21190(Vlna Peter)  Added PPL0 200MHz as system clock
1.2	Dec-02-2015	b21190(Vlna Peter)  Added Flash controller init
1.3     May-24-2016	nxa13250(Vlna Peter)Added Online BIST
*******************************************************************************/

/*******************************************************************************
* Includes                                                                     
*******************************************************************************/
#include "MPC5746R_501.h"

/*******************************************************************************
* Constants and macros
*******************************************************************************/
#define 	DRUN_MODE 	0x3


/*******************************************************************************
* External objects
*******************************************************************************/

/*******************************************************************************
* Global variables
*******************************************************************************/
unsigned int Online_LBIST_Result;
unsigned int Online_MBIST_Result_low;
unsigned int Online_MBIST_Result_medium;
int i=0;



/*******************************************************************************
* Local functions
*******************************************************************************/

/*******************************************************************************
Function Name : Sys_Init
Engineer      : nxa13250
Date          : Nov-11-2015
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Clock settings (XOSC- 20MHz)
Issues        : NONE
*******************************************************************************/
void Sys_Init(void)
{
    //Configure RunPeripheralConfiguration registers in ME_RUN_PC0
    MC_ME.RUN_PC[0].B.DRUN = 1;			//Enable DRUN mode for all peripherals using ME_RUN_PC[0]
    
    //Enable external oscilator
    MC_ME.DRUN_MC.B.XOSCON = 1;   

    // Set PLL0 as system clock
    MC_ME.DRUN_MC.B.SYSCLK = 0x2;
    MC_ME.DRUN_MC.B.PLL0ON = 1;             //Enable PLL0 for DRUN mode
    MC_ME.DRUN_MC.B.PLL1ON = 1;             //Enable PLL1 for DRUN mode
    
    //  System clock dividers //
    
    //  Enable system clock divider /1 -> 200MHz
    //            Enable divider | divide by 1  
    MC_CGM.SC_DC0.R = 0x80000000 | 0x0;
    
    // SXBAR clock devider = 2 -> 200MHz/2 = 100MHz
    //            Enable divider | divide by 2  
    MC_CGM.SC_DC1.R = 0x80000000 | 0x10000;

    // PBRIDGE clock devider = 4 -> 200MHz/4 = 50MHz
    //            Enable divider | divide by 4   
    MC_CGM.SC_DC2.R = 0x80000000 | 0x30000;


    //  AUX_0 clock dividers //
     MC_CGM.AC0_SC.B.SELCTL =0x2;		//connect PLL0 to AXU_0
    
    // PER_CLK clock devider = 3 -> 200MHz/3 = 66MHz
    //             Enable divider | divide by 3
    MC_CGM.AC0_DC0.R = 0x80000000 | 0x20000;

    // AC0_SC clock devider = 13 -> 200MHz/13 = 15MHz
    //             Enable divider | divide by 13  
    MC_CGM.AC0_DC1.R = 0x80000000 | 0xC0000;

    // SAR ADC clock devider = 3 -> 200MHz/3 = 66.6MHz
    //             Enable divider | divide by 3  
    MC_CGM.AC0_DC2.R = 0x80000000 | 0x20000;

    // DSPI_CLK0 clock devider = 3 -> 200MHz/3 = 66.6MHz
    //             Enable divider | divide by 3  
    MC_CGM.AC0_DC3.R = 0x80000000 | 0x20000;

    // DSPI_CLK1 clock devider = 3 -> 200MHz/3 = 66.6MHz
    //             Enable divider | divide by 3  
    MC_CGM.AC0_DC4.R = 0x80000000 | 0x20000;
   

    // AUX_1 clock dividers //
    
    // PD LFAST PLL/BD LFAST PLL/SIPI_CLK_OUT clock devider = 8 -> 200MHz/8 = 25MHz
    //             Enable divider | divide by 8  
    MC_CGM.AC1_DC0.R = 0x80000000 | 0x70000;


    // AUX_2 clock dividers //
    
    // SENT_CLK clock devider = 3 -> 200MHz/3 = 66.6MHz
    //             Enable divider | divide by 3  
    MC_CGM.AC2_DC0.R = 0x80000000 | 0x20000;

    
    //AUX Clock Selector 3 setup
    
    //	AUX Clock Selector 3 setup - source for PLL0 module
    MC_CGM.AC3_SC.B.SELCTL =1;			//connect (8..40MHz) XTALL to the PLL0 input
    						//0=IRC   1=XOSC
   
    //  AUX_4 clock dividers //

    //AUX Clock Selector 4 setup - source for PLL1 module
    MC_CGM.AC4_SC.B.SELCTL =3;			//connect PLL0 to AUX4


    //  AUX_5 clock dividers //

    MC_CGM.AC5_SC.B.SELCTL =2;			//connect PLL0 on AUX_5
    // eTPU clock devider = 1 -> 200MHz/1 = 200MHz
    //            Enable divider | divide by 1   
    MC_CGM.AC5_DC0.R = 0x80000000 | 0x00000;
    
    // eMIOS clock devider = 2 -> 200MHz/2 = 100MHz
    //            Enable divider | divide by 5   
    MC_CGM.AC5_DC1.R = 0x80000000 | 0x10000;	//eMIOS

    
    //  AUX_6 clock dividers //
        
    // CLKOUT
    MC_CGM.AC6_SC.R = 0x02000000;           	//connect PPL0 to AUX_6
    // CLKOUT_0 clock devider = 20 -> 200MHz/20 = 10MHz
    //            Enable divider | divide by 20  
    MC_CGM.AC6_DC0.R = 0x80000000 | 0x140000;


    //  AUX_8 clock dividers //    

    // FlexCAN clock devider = 5 -> 200MHz/5 = 40MHz
    //            Enable divider | divide by 5   
    MC_CGM.AC8_DC0.R = 0x80000000 | 0x40000;
    MC_CGM.AC8_SC.B.SELCTL =2;			//connect PLL0 on AUX_8

    
    //  AUX_9 clock dividers //
    //  RTI_CLK //
    MC_CGM.AC9_SC.B.SELCTL =2;			//connect XTAL on AUX_9
  

    //  AUX_10 clock dividers //

    MC_CGM.AC10_SC.B.SELCTL =2;			//connect PLL0 on AUX_10
    // TXCLK_REF_CLK clock devider = 5 -> 200MHz/4 = 50MHz
    //            Enable divider | divide by 4   
    MC_CGM.AC10_DC0.R = 0x80000000 | 0x30000;


    // Set PLL0 to 200MHz with 20MHz XOSC (PLL0 VCO frequency  600  1250 MHz)
    PLLDIG.PLL0CR.B.CLKCFG = 0;			//Bypass mode with PLL0 off
    // RFDPHI1 = 10, RFDPHI = 4, PREDIV = 2, MFD = 80 (0x50h)
    PLLDIG.PLL0DV.R = 0x50000000 |0x00040000 |0x00002000 |0x0050; //predefined PLL0 divider register

    // Set PLL1 to 200MHz with PLL0_PHI (20MHz) as input (PLL1 VCO frequency  600  1250 MHz)
    PLLDIG.PLL1CR.B.CLKCFG = 0;			//PLL1 on
    //                RFDPHI = 4, MFD = 40 (0x28h)
    PLLDIG.PLL1DV.R = 0x00040000 |0x0028; //predefined PLL0 divider register
         
    //Mode transition to apply the PLL0 setup and set Normal mode with PLL running
    MC_ME.MCTL.R = 0x30005AF0;              //DRUN Mode & Key 
    MC_ME.MCTL.R = 0x3000A50F;              //DRUN Mode & Key

    while(!MC_ME.GS.B.S_PLL0);              //ME_GS Wait for PLL stabilization.
    while(MC_ME.GS.B.S_MTRANS);             //Waiting for end of transaction
    while(MC_ME.GS.B.S_CURRENT_MODE != DRUN_MODE);  // ME_GS Check DRUN mode has successfully been entered
}//Sys_Init

/*******************************************************************************
Function Name : SUIL2_Init
Engineer      : nxa13250
Date          : Nov-09-2015
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : SIUL2 initialization (ports), setting PB6(B9) as output for clock measurement
Issues        : NONE
*******************************************************************************/
void SUIL2_Init(void)
{
   SIUL2.MSCR0_255[145].R = 0x22800007;   	/* PJ1 as CLK_OUT (on EVB it is PJ1)*/
}//SUIL2_Init

/*******************************************************************************
Function Name : STCU2_check
Engineer      : nxa13250
Date          : Jun-01-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Write on-line unlock keys to the STCU 
Issues        : NONE
*******************************************************************************/
void STCU2_Online_BIST_check (void)
{
/* ONLINE RESULTS CHECK --- ONLINE RESULTS CHECK --- ONLINE RESULTS CHECK ---ONLINE RESULTS CHECK --- */
/* Read On-Line LBIST END Flag register (LBESW)to determine if we have completed On-line LBIST */
    if (STCU2.LBESW.R !=0)
    {
/*At least one On line logic BIST partition has completed self test*/
/*Store results from LBSSW register  for later analysis*/
	Online_LBIST_Result = STCU2.LBSSW.R;
    }
/* Read On-Line MBIST END Flag registers (MBExSW) to determine if we have completed On-line MBIST */
    if (STCU2.MBELSW.R!=0 || STCU2.MBEMSW.R!=0)
    {
/*At least one On line Memory BIST partition has completed self test*/
/*Store results from LBSSW register  for later analysis*/
	Online_MBIST_Result_low = STCU2.MBSLSW.R;
	Online_MBIST_Result_medium = STCU2.MBSMSW.R;
    }
    
}//STCU2_Online_BIST_check
/*******************************************************************************
Function Name : STCU2_unlock
Engineer      : nxa13250
Date          : Jun-01-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Write on-line unlock keys to the STCU 
Issues        : NONE
*******************************************************************************/
void STCU2_unlock (void)
{
    STCU2.SKC.R = 0x753F924E;   
    STCU2.SKC.R = 0x8AC06DB1;
  
}//STCU2_unlock
/*******************************************************************************
Function Name : MBIST_Config
Engineer      : nxa13250
Date          : Jun-01-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : MBIST preparation and configurtion
Issues        : NONE
*******************************************************************************/
void MBIST_Config(void)
{
/* MBIST Config - MBIST Will run first */

/* Configure MBIST Control registers */ 
    STCU2.MB_CTRL[0].R = 0x91000000;        /* MBIST CTRL00 Run concurrently, next in sequence is MBIST 1 */
    STCU2.MB_CTRL[1].R = 0x92000000;        /* MBIST CTRL01 Run concurrently, next in sequence is MBIST 2 */ 
    STCU2.MB_CTRL[2].R = 0x93000000;        /* MBIST CTRL02 Run concurrently, next in sequence is MBIST 3 */
    STCU2.MB_CTRL[3].R = 0x94000000;        /* MBIST CTRL03 Run concurrently, next in sequence is MBIST 4 */
    STCU2.MB_CTRL[4].R = 0x95000000;        /* MBIST CTRL04 Run concurrently, next in sequence is MBIST 5 */
    STCU2.MB_CTRL[5].R = 0x96000000;        /* MBIST CTRL05 Run concurrently, next in sequence is MBIST 6 */
    STCU2.MB_CTRL[6].R = 0x97000000;        /* MBIST CTRL06 Run concurrently, next in sequence is MBIST 7 */
    STCU2.MB_CTRL[7].R = 0x98000000;        /* MBIST CTRL07 Run concurrently, next in sequence is MBIST 8 */
    STCU2.MB_CTRL[8].R = 0x99000000;        /* MBIST CTRL08 Run concurrently, next in sequence is MBIST 9 */
    STCU2.MB_CTRL[9].R = 0x9A000000;        /* MBIST CTRL09 Run concurrently, next in sequence is MBIST 10 */
    STCU2.MB_CTRL[10].R = 0x9B000000;       /* MBIST CTRL10 Run concurrently, next in sequence is MBIST 11 */
    STCU2.MB_CTRL[11].R = 0x9C000000;       /* MBIST CTRL11 Run concurrently, next in sequence is MBIST 12 */
    STCU2.MB_CTRL[12].R = 0x9D000000;       /* MBIST CTRL12 Run concurrently, next in sequence is MBIST 13 */
    STCU2.MB_CTRL[13].R = 0x9E000000;       /* MBIST CTRL13 Run concurrently, next in sequence is MBIST 14 */
    STCU2.MB_CTRL[14].R = 0x9F000000;       /* MBIST CTRL14 Run concurrently, next in sequence is MBIST 15 */
    STCU2.MB_CTRL[15].R = 0xA0000000;       /* MBIST CTRL15 Run concurrently, next in sequence is MBIST 16 */
    STCU2.MB_CTRL[16].R = 0xA1000000;       /* MBIST CTRL16 Run concurrently, next in sequence is MBIST 17 */
    STCU2.MB_CTRL[17].R = 0xA2000000;       /* MBIST CTRL17 Run concurrently, next in sequence is MBIST 18 */
    STCU2.MB_CTRL[18].R = 0xA3000000;       /* MBIST CTRL18 Run concurrently, next in sequence is MBIST 19 */
    STCU2.MB_CTRL[19].R = 0xA4000000;       /* MBIST CTRL19 Run concurrently, next in sequence is MBIST 20 */
    STCU2.MB_CTRL[20].R = 0xA5000000;       /* MBIST CTRL20 Run concurrently, next in sequence is MBIST 21 */

/* Write key 2 to service the watchdog */
    STCU2.SKC.R = 0x8AC06DB1; 

    STCU2.MB_CTRL[21].R = 0xA6000000;       /* MBIST CTRL21 Run concurrently, next in sequence is MBIST 22 */
    STCU2.MB_CTRL[22].R = 0xA7000000;       /* MBIST CTRL22 Run concurrently, next in sequence is MBIST 23 */
    STCU2.MB_CTRL[23].R = 0xA8000000;       /* MBIST CTRL23 Run concurrently, next in sequence is MBIST 24 */
    STCU2.MB_CTRL[24].R = 0xA9000000;       /* MBIST CTRL24 Run concurrently, next in sequence is MBIST 25 */
    STCU2.MB_CTRL[25].R = 0xAA000000;       /* MBIST CTRL25 Run concurrently, next in sequence is MBIST 26 */
    STCU2.MB_CTRL[26].R = 0xAB000000;       /* MBIST CTRL26 Run concurrently, next in sequence is MBIST 27 */
    STCU2.MB_CTRL[27].R = 0xAC000000;       /* MBIST CTRL27 Run concurrently, next in sequence is MBIST 28 */
    STCU2.MB_CTRL[28].R = 0xAD000000;       /* MBIST CTRL28 Run concurrently, next in sequence is MBIST 29 */
    STCU2.MB_CTRL[29].R = 0xAE000000;       /* MBIST CTRL29 Run concurrently, next in sequence is MBIST 30 */
    STCU2.MB_CTRL[30].R = 0xAF000000;       /* MBIST CTRL30 Run concurrently, next in sequence is MBIST 31 */
    STCU2.MB_CTRL[31].R = 0xB0000000;       /* MBIST CTRL31 Run concurrently, next in sequence is MBIST 32 */
    STCU2.MB_CTRL[32].R = 0xB1000000;       /* MBIST CTRL32 Run concurrently, next in sequence is MBIST 33 */
    STCU2.MB_CTRL[33].R = 0xB2000000;       /* MBIST CTRL33 Run concurrently, next in sequence is MBIST 34 */
    STCU2.MB_CTRL[34].R = 0xB3000000;       /* MBIST CTRL34 Run concurrently, next in sequence is MBIST 35 */
    STCU2.MB_CTRL[35].R = 0xB4000000;       /* MBIST CTRL35 Run concurrently, next in sequence is MBIST 36 */
    STCU2.MB_CTRL[36].R = 0xB5000000;       /* MBIST CTRL36 Run concurrently, next in sequence is MBIST 37 */
    STCU2.MB_CTRL[37].R = 0xB6000000;       /* MBIST CTRL37 Run concurrently, next in sequence is MBIST 38 */
    STCU2.MB_CTRL[38].R = 0xB7000000;       /* MBIST CTRL38 Run concurrently, next in sequence is MBIST 39 */

/* Write key 2 to service the watchdog */
    STCU2.SKC.R = 0x8AC06DB1; 

    STCU2.MB_CTRL[39].R = 0xB8000000;       /* MBIST CTRL39 Run concurrently, next in sequence is MBIST 40 */
    STCU2.MB_CTRL[40].R = 0xB9000000;       /* MBIST CTRL40 Run concurrently, next in sequence is MBIST 41 */
    STCU2.MB_CTRL[41].R = 0xBA000000;       /* MBIST CTRL41 Run concurrently, next in sequence is MBIST 42 */
    STCU2.MB_CTRL[42].R = 0xBB000000;       /* MBIST CTRL42 Run concurrently, next in sequence is MBIST 43 */
    STCU2.MB_CTRL[43].R = 0xBC000000;       /* MBIST CTRL43 Run concurrently, next in sequence is MBIST 44 */
    STCU2.MB_CTRL[44].R = 0xBD000000;       /* MBIST CTRL44 Run concurrently, next in sequence is MBIST 45 */
    STCU2.MB_CTRL[45].R = 0xBE000000;       /* MBIST CTRL45 Run concurrently, next in sequence is MBIST 46 */
    STCU2.MB_CTRL[46].R = 0x00000000;       /* MBIST CTRL46 Run sequentially, next in sequence is LBIST 0 */    

/* Write key 2 to service the watchdog */
    STCU2.SKC.R = 0x8AC06DB1; 
   
}//Online_BIST

/*******************************************************************************
Function Name : LBIST_Config
Engineer      : nxa13250
Date          : Jun-02-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Configure LBIST tests 
Issues        : NONE
*******************************************************************************/
void LBIST_Config (void)
{
/* Configure Online LBIST partition coverage 					*/
/* Configure LBIST for 90% coverage using KEYOFF #define 		*/

    /* Write key 2 to service the watchdog */
    STCU2.SKC.R = 0x8AC06DB1;

    STCU2.LB[0].CTRL.R = 0x0103000F;       /* LBIST CTRL0 Run sequentially, next in sequence is LBIST 1 */
    STCU2.LB[0].PCS.R = 0x00000866;        /* LBIST 0 pattern count */
    STCU2.LB[0].MISRELSW.R = 0xFDC31B19;   /* STCU2 On-Line LBIST MISR Expected Low Register */
    STCU2.LB[0].MISREHSW.R = 0x18F2A1F5;   /* STCU2 On-Line LBIST MISR Expected High Register */

    /* Write key 2 to service the watchdog */
    STCU2.SKC.R = 0x8AC06DB1;

    STCU2.LB[1].CTRL.R = 0x0203000F;       /* LBIST CTRL1 Run sequentially, next in sequence is LBIST 2 */
    STCU2.LB[1].PCS.R = 0x000007D0;        /* LBIST 1 pattern count */
    STCU2.LB[1].MISRELSW.R = 0xD8E3627D;   /* LBIST MISREL Expected Low */
    STCU2.LB[1].MISREHSW.R = 0xAC001775;   /* LBIST MISREH Expected High */

    /* Write key 2 to service the watchdog */
    STCU2.SKC.R = 0x8AC06DB1;

    STCU2.LB[2].CTRL.R = 0x0303000F;       /* LBIST CTRL2 Run sequentially, next in sequence is LBIST 3 */
    STCU2.LB[2].PCS.R = 0x00000834;        /* LBIST 2 pattern count */
    STCU2.LB[2].MISRELSW.R = 0x4A32B225;   /* LBIST MISREL Expected Low */
    STCU2.LB[2].MISREHSW.R = 0x765D7C3D;   /* LBIST MISREH Expected High */

    /* Write key 2 to service the watchdog */
    STCU2.SKC.R = 0x8AC06DB1;

    STCU2.LB[3].CTRL.R = 0x7F03000F;       /* LBIST CTRL3 Run sequentially */ 
    STCU2.LB[3].PCS.R = 0x00000ABE;        /* LBIST 3 pattern count */
    STCU2.LB[3].MISRELSW.R = 0xEED3E3B7;   /* LBIST MISREL Expected Low */
    STCU2.LB[3].MISREHSW.R = 0xB489FD55;   /* LBIST MISREH Expected High */

    /* Write key 2 to service the watchdog */
    STCU2.SKC.R = 0x8AC06DB1;

}//STCU2LBIST_Config

/*******************************************************************************
Function Name : Online_BIST
Engineer      : nxa13250
Date          : May-24-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Online BISTs sequence
Issues        : NONE
*******************************************************************************/
void Online_BIST(void)
{
   STCU2_unlock();
   
   /* Check and/or clean-up the bit WRP into the STCU2_CFG register to open the IPS access on the STCU2 On-Line Self-Test registers*/
   while(STCU2.CFG.B.WRP != 0);

   /* Program the Reset management during on-Line LBIST execution setting the STCU2_LBRMSW register */
   STCU2.LBRMSW.R = 0xF;	//  Global functional reset is pulsed at the end of LBISTx run
   
   /* Overwrite/Program the STCU2_MB_CTRL registers of each NMCUT to be executed */
   MBIST_Config();
   /* Overwrite/Program the STCU2_MB_CTRL registers of each NMCUT to be executed */
   LBIST_Config();

   /* Write key 2 to service the watchdog */
   STCU2.SKC.R = 0x8AC06DB1;

   /* Set Watchdog timeout Config */
   STCU2.WDG.R = 0xFFFFFFFF;                  /* Watchdog time out to Max value */ 

   /* Overwrite/Program the STCU2_CFG register in order to define */
   STCU2.CFG.B.CLK_CFG = 0;	// Logic, Memory Bist and STCU2 core CLK Clock configuration
   STCU2.CFG.B.MBU = 1;		// 
   STCU2.CFG.B.PMOSEN = 0;	// 
   STCU2.CFG.B.WRP = 0;		// Write Protection
   STCU2.CFG.B.PTR = 0x10;	// Start with LBIST_0 pointer (0x0)

//   STCU2.PLL_CFG.B.PLLODF = 2;
//   STCU2.PLL_CFG.B.PLLIDF = 1;
//   STCU2.PLL_CFG.B.PLLLDF = 0x19;

   STCU2.MBUFML.R = 0x0;           /* Configure all faults as recoverable in this example */
   STCU2.MBUFMM.R = 0x0;           /* Configure all faults as recoverable in this example */

   /* Configure LBIST recoverable/unrecoverable fault handling  */
   STCU2.LBUFM.R = 0x0;                  /* Configure all faults as recoverable in this example */
   /*  Configure LBIST error recoverable/unrecoverable fault handling  */
   STCU2.ERR_FM.R = 0x0;                  /* Configure all faults as recoverable in this example */
      
   /* Write key 2 to service the watchdog */
   STCU2.SKC.R = 0x8AC06DB1;

   /* Program the RUNSW bit into the STCU2_RUNSW register to enable the On-Line
      Self-Test execution; the L/MBSWPLLEN bits to enable the PLL lock signal monitor
      during L/MBIST execution and the L/MBIE to enable the related Interrupt requests. */
   
   /* Start the BIST sequence */
   STCU2.RUNSW.R = 0x00000301;

   while(STCU2.RUNSW.B.RUNSW == 1);
     
}//Online_BIST

/*******************************************************************************
Function Name : Flash_Controller_Init
Engineer      : nxa13250
Date          : Dec-02-2015
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Flash controler wait-states settings
Issues        : NONE
*******************************************************************************/
void Flash_Controller_Init(void)
{
    // Wait-state settings for 200MHz as system frequency
    PFLASH.PFCR1.B.RWSC = 0x5;			/* Read Wait State Control */
    PFLASH.PFCR1.B.APC = 0x2;			/* Address Pipeline Control */
}//Flash_Controller_Init

/*******************************************************************************
Function Name : FCCU_clear_faults
Engineer      : nxa13250
Date          : Jan-05-2016
Parameters    : NONE
Modifies      : NONE
Returns       : NONE
Notes         : Example function for FCCU fault clearing
Issues        : NONE
*******************************************************************************/
void FCCU_clear_faults(void)
{
  /* 1. Write the proper key into the FCCU_NCFK register */
  //Non-critical fault key = AB34_98FEh
  FCCU.NCFK.R = 0xAB3498FE;

  /* 2. Clear the status (flag) bit NCFSx => the opcode OP12 is automatically set into the FCCU_CTRL.OPR field */
  /* Read all NCFS registers to clear all faults.*/
  /* For details which faults can be cleared see Table 7-36. FCCU Non-Critical Faults Mapping in RM */
  FCCU.NCF_S[0].R = 0xFFFFFFFF;		// read FCCU.NCF_S0 register  
    
  /* Verify if state change was sucessful */
  while (FCCU.CTRL.B.OPS != 0x3);	//Operation status succesfull

  /* NCFS_1 register clear */
  FCCU.NCFK.R = 0xAB3498FE;		//Non-critical fault key = AB34_98FEh
  FCCU.NCF_S[1].R = 0xFFFFFFFF;		// clear FCCU.NCF_S1 register
  /* Verify if state change was sucessful */
  while (FCCU.CTRL.B.OPS != 0x3);	//Operation status succesfull

  /* NCFS_2 register clear */
  FCCU.NCFK.R = 0xAB3498FE;		//Non-critical fault key = AB34_98FEh
  FCCU.NCF_S[2].R = 0xFFFFFFFF;		// clear FCCU.NCF_S2 register
  /* Verify if state change was sucessful */
  while (FCCU.CTRL.B.OPS != 0x3);	//Operation status succesfull
  
}//FCCU_clear_faults

/*******************************************************************************
* Global functions
*******************************************************************************/
void main (void)
{
  FCCU_clear_faults();
  Flash_Controller_Init();
  Sys_Init();
  SUIL2_Init();
  STCU2_Online_BIST_check();
  while(i==0);
  Online_BIST();   //configured according RM and Matterhorn BIST app note
  while(1);

}//main
