/**************************************************************************
 * FILE NAME: MPC5746R.h                     COPYRIGHT (c) Freescale 2015 *
 * REVISION:  5.0.1                                   All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the MPC5746R.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 0.1      M.D.      27-FEB-13     -First release.                       *
 *                                                                        *
 * 0.2      M.D.      01-MAR-13     -PASS module PG.LOCK3 changed bit     *
 *                                   256LCK_U to L256LCK_U                *
 *                                  -SIUL2 module MSCR changed to array   *
 *                                   MSCR0_255[256] & MSCR512_955[484]    *
 *                                  -eTPU_CCCR module ENG1_C needed ';'   *
 *                                  -Memory definitions for SMPU added '_'*    
 *                                                                        *
 * 0.3      M.D.      23-AUG-13     -Regenerated per RM v3                *
 *                                    -eMIOS module is omitted            * 
 *                                                                        *
 * 0.4      M.D.      25-FEB-14     -Updated SIUL2_MSCR register array to *
 *                                   include registers MSCR996 & MSCR998  *
 *                                  -Updated ADC_2 base address definition*
 *                                   from 0xFFEEC000UL to 0xFFEE8000UL    *    
 *                                                                        * 
 * 4.0      M.D.      25-FEB-14     -Regenerated per RM v4				  *
 *                                                                        * 
 * 5.0      M.D.      09-MAR-15     -Regenerated per RM v5                *
 *                                                                        * 
 * 5.0.1    M.D.      09-MAR-15     -Regenerated CAN module per RM v5     *
 *                                                                        * 
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _mpc5746r_H_
#define _mpc5746r_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

typedef union ADC_MCR_union_tag {      /* Main Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t OWREN:1;                 /* Overwrite enable. */
    vuint32_t WLSIDE:1;                /* Write Left/Right aligned. */
    vuint32_t MODE:1;                  /* One_Shot/Scan. */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t NSTART:1;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t JSTART:1;                /* Injection start. */
    vuint32_t  :2;
    vuint32_t CTUEN:1;                 /* Crosstrigger Unit Enable. */
    vuint32_t CTU_MODE:1;              /* Crosstrigger Unit MODE bit */
    vuint32_t STCL:1;                  /* Self Testing Configuration Lock. */
    vuint32_t  :6;
    vuint32_t ADCLKSEL:1;              /* Analog Clock frequency Selector. */
    vuint32_t ABORT_CHAIN:1;           /* Abort Chain. */
    vuint32_t ABORT:1;                 /* Abort Conversion. */
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t  :2;
    vuint32_t REFSEL:2;                /* Reference voltage selection for ADC analog part. */
    vuint32_t PWDN:1;                  /* Power-down enable. */
  } B;
} ADC_MCR_tag;

typedef union ADC_MSR_union_tag {      /* Main Status register */
  vuint32_t R;
  struct {
    vuint32_t CALIBRTD:1;              /* This bit indicates the ADC calibration status. */
    vuint32_t  :6;
    vuint32_t NSTART:1;                /* This status bit is used to signal that a Normal conversion is ongoing. */
    vuint32_t JABORT:1;
    vuint32_t  :2;
    vuint32_t JSTART:1;                /* This status bit is used to signal that an Injected conversion is ongoing. */
    vuint32_t  :1;
    vuint32_t SELF_TEST_S:1;           /* This status bit signals that self test conversion is ongoing. */
    vuint32_t  :1;
    vuint32_t CTUSTART:1;              /* This status bit is used to signal that a CTU conversion is ongoing. */
    vuint32_t CHADDR:7;                /* Channel under measure address. */
    vuint32_t  :3;
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t  :2;
    vuint32_t ADCSTATUS:3;             /* Status of the ADC. */
  } B;
} ADC_MSR_tag;

typedef union ADC_ISR_union_tag {      /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t EOCTU:1;
    vuint32_t JEOC:1;                  /* End of injected channel conversion. */
    vuint32_t JECH:1;                  /* End of injected chain conversion. */
    vuint32_t EOC:1;                   /* End of channel conversion. */
    vuint32_t ECH:1;                   /* End of chain conversion. */
  } B;
} ADC_ISR_tag;

typedef union ADC_CEOCFR0_union_tag {  /* Channel Pending register 0 */
  vuint32_t R;
  struct {
    vuint32_t EOCCH31:1;               /* EOC Channel 31. */
    vuint32_t EOCCH30:1;               /* EOC Channel 30. */
    vuint32_t EOCCH29:1;               /* EOC Channel 29. */
    vuint32_t EOCCH28:1;               /* EOC Channel 28. */
    vuint32_t EOCCH27:1;               /* EOC Channel 27. */
    vuint32_t EOCCH26:1;               /* EOC Channel 26. */
    vuint32_t EOCCH25:1;               /* EOC Channel 25. */
    vuint32_t EOCCH24:1;               /* EOC Channel 24. */
    vuint32_t EOCCH23:1;               /* EOC Channel 23. */
    vuint32_t EOCCH22:1;               /* EOC Channel 22. */
    vuint32_t EOCCH21:1;               /* EOC Channel 21. */
    vuint32_t EOCCH20:1;               /* EOC Channel 20. */
    vuint32_t EOCCH19:1;               /* EOC Channel 19. */
    vuint32_t EOCCH18:1;               /* EOC Channel 18. */
    vuint32_t EOCCH17:1;               /* EOC Channel 17. */
    vuint32_t EOCCH16:1;               /* EOC Channel 16. */
    vuint32_t EOCCH15:1;               /* EOC Channel 15. */
    vuint32_t EOCCH14:1;               /* EOC Channel 14. */
    vuint32_t EOCCH13:1;               /* EOC Channel 13. */
    vuint32_t EOCCH12:1;               /* EOC Channel 12. */
    vuint32_t EOCCH11:1;               /* EOC Channel 11. */
    vuint32_t EOCCH10:1;               /* EOC Channel 10. */
    vuint32_t EOCCH9:1;                /* EOC Channel 9. */
    vuint32_t EOCCH8:1;                /* EOC Channel 8. */
    vuint32_t EOCCH7:1;                /* EOC Channel 7. */
    vuint32_t EOCCH6:1;                /* EOC Channel 6. */
    vuint32_t EOCCH5:1;                /* EOC Channel 5. */
    vuint32_t EOCCH4:1;                /* EOC Channel 4. */
    vuint32_t EOCCH3:1;                /* EOC Channel 3. */
    vuint32_t EOCCH2:1;                /* EOC Channel 2. */
    vuint32_t EOCCH1:1;                /* EOC Channel 1. */
    vuint32_t EOCCH0:1;                /* EOC Channel 0. */
  } B;
} ADC_CEOCFR0_tag;

typedef union ADC_CEOCFR1_union_tag {  /* Channel Pending register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t EOCCH47:1;               /* EOC Channel 47. */
    vuint32_t EOCCH46:1;               /* EOC Channel 46. */
    vuint32_t EOCCH45:1;               /* EOC Channel 45. */
    vuint32_t EOCCH44:1;               /* EOC Channel 44. */
    vuint32_t EOCCH43:1;               /* EOC Channel 43. */
    vuint32_t EOCCH42:1;               /* EOC Channel 42. */
    vuint32_t EOCCH41:1;               /* EOC Channel 41. */
    vuint32_t EOCCH40:1;               /* EOC Channel 40. */
    vuint32_t EOCCH39:1;               /* EOC Channel 39. */
    vuint32_t EOCCH38:1;               /* EOC Channel 38. */
    vuint32_t EOCCH37:1;               /* EOC Channel 37. */
    vuint32_t EOCCH36:1;               /* EOC Channel 36. */
    vuint32_t EOCCH35:1;               /* EOC Channel 35. */
    vuint32_t EOCCH34:1;               /* EOC Channel 34. */
    vuint32_t EOCCH33:1;               /* EOC Channel 33. */
    vuint32_t EOCCH32:1;               /* EOC Channel 32. */
  } B;
} ADC_CEOCFR1_tag;

typedef union ADC_CEOCFR2_union_tag {  /* Channel Pending register 2 */
  vuint32_t R;
  struct {
    vuint32_t EOCCH95:1;               /* EOC Channel 95. */
    vuint32_t EOCCH94:1;               /* EOC Channel 94. */
    vuint32_t EOCCH93:1;               /* EOC Channel 93. */
    vuint32_t EOCCH92:1;               /* EOC Channel 92. */
    vuint32_t EOCCH91:1;               /* EOC Channel 91. */
    vuint32_t EOCCH90:1;               /* EOC Channel 90. */
    vuint32_t EOCCH89:1;               /* EOC Channel 89. */
    vuint32_t EOCCH88:1;               /* EOC Channel 88. */
    vuint32_t EOCCH87:1;               /* EOC Channel 87. */
    vuint32_t EOCCH86:1;               /* EOC Channel 86. */
    vuint32_t EOCCH85:1;               /* EOC Channel 85. */
    vuint32_t EOCCH84:1;               /* EOC Channel 84. */
    vuint32_t EOCCH83:1;               /* EOC Channel 83. */
    vuint32_t EOCCH82:1;               /* EOC Channel 82. */
    vuint32_t EOCCH81:1;               /* EOC Channel 81. */
    vuint32_t EOCCH80:1;               /* EOC Channel 80. */
    vuint32_t EOCCH79:1;               /* EOC Channel 79. */
    vuint32_t EOCCH78:1;               /* EOC Channel 78. */
    vuint32_t EOCCH77:1;               /* EOC Channel 77. */
    vuint32_t EOCCH76:1;               /* EOC Channel 76. */
    vuint32_t EOCCH75:1;               /* EOC Channel 75. */
    vuint32_t EOCCH74:1;               /* EOC Channel 74. */
    vuint32_t EOCCH73:1;               /* EOC Channel 73. */
    vuint32_t EOCCH72:1;               /* EOC Channel 72. */
    vuint32_t EOCCH71:1;               /* EOC Channel 71. */
    vuint32_t EOCCH70:1;               /* EOC Channel 70. */
    vuint32_t EOCCH69:1;               /* EOC Channel 69. */
    vuint32_t EOCCH68:1;               /* EOC Channel 68. */
    vuint32_t EOCCH67:1;               /* EOC Channel 67. */
    vuint32_t EOCCH66:1;               /* EOC Channel 66. */
    vuint32_t EOCCH65:1;               /* EOC Channel 65. */
    vuint32_t EOCCH64:1;               /* EOC Channel 64. */
  } B;
} ADC_CEOCFR2_tag;

typedef union ADC_IMR_union_tag {      /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t  :1;
    vuint32_t  :10;
    vuint32_t MSKEOCTU:1;              /* Mask bit for EOCTU. */
    vuint32_t MSKJEOC:1;               /* Mask bit for JEOC. */
    vuint32_t MSKJECH:1;               /* Mask bit for JECH. */
    vuint32_t MSKEOC:1;                /* Mask bit for EOC. */
    vuint32_t MSKECH:1;                /* Mask bit for ECH. */
  } B;
} ADC_IMR_tag;

typedef union ADC_CIMR0_union_tag {    /* Channel Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CIM31:1;                 /* Channel 31 interrupt enable. */
    vuint32_t CIM30:1;                 /* Channel 30 interrupt enable. */
    vuint32_t CIM29:1;                 /* Channel 29 interrupt enable. */
    vuint32_t CIM28:1;                 /* Channel 28 interrupt enable. */
    vuint32_t CIM27:1;                 /* Channel 27 interrupt enable. */
    vuint32_t CIM26:1;                 /* Channel 26 interrupt enable. */
    vuint32_t CIM25:1;                 /* Channel 25 interrupt enable. */
    vuint32_t CIM24:1;                 /* Channel 24 interrupt enable. */
    vuint32_t CIM23:1;                 /* Channel 23 interrupt enable. */
    vuint32_t CIM22:1;                 /* Channel 22 interrupt enable. */
    vuint32_t CIM21:1;                 /* Channel 21 interrupt enable. */
    vuint32_t CIM20:1;                 /* Channel 20 interrupt enable. */
    vuint32_t CIM19:1;                 /* Channel 19 interrupt enable. */
    vuint32_t CIM18:1;                 /* Channel 18 interrupt enable. */
    vuint32_t CIM17:1;                 /* Channel 17 interrupt enable. */
    vuint32_t CIM16:1;                 /* Channel 16 interrupt enable. */
    vuint32_t CIM15:1;                 /* Channel 15 interrupt enable. */
    vuint32_t CIM14:1;                 /* Channel 14 interrupt enable. */
    vuint32_t CIM13:1;                 /* Channel 13 interrupt enable. */
    vuint32_t CIM12:1;                 /* Channel 12 interrupt enable. */
    vuint32_t CIM11:1;                 /* Channel 11 interrupt enable. */
    vuint32_t CIM10:1;                 /* Channel 10 interrupt enable. */
    vuint32_t CIM9:1;                  /* Channel 9 interrupt enable. */
    vuint32_t CIM8:1;                  /* Channel 8 interrupt enable. */
    vuint32_t CIM7:1;                  /* Channel 7 interrupt enable. */
    vuint32_t CIM6:1;                  /* Channel 6 interrupt enable. */
    vuint32_t CIM5:1;                  /* Channel 5 interrupt enable. */
    vuint32_t CIM4:1;                  /* Channel 4 interrupt enable. */
    vuint32_t CIM3:1;                  /* Channel 3 interrupt enable. */
    vuint32_t CIM2:1;                  /* Channel 2 interrupt enable. */
    vuint32_t CIM1:1;                  /* Channel 1 interrupt enable. */
    vuint32_t CIM0:1;                  /* Channel 0 interrupt enable. */
  } B;
} ADC_CIMR0_tag;

typedef union ADC_CIMR1_union_tag {    /* Channel Interrupt Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CIM47:1;                 /* Channel 47 interrupt enable. */
    vuint32_t CIM46:1;                 /* Channel 46 interrupt enable. */
    vuint32_t CIM45:1;                 /* Channel 45 interrupt enable. */
    vuint32_t CIM44:1;                 /* Channel 44 interrupt enable. */
    vuint32_t CIM43:1;                 /* Channel 43 interrupt enable. */
    vuint32_t CIM42:1;                 /* Channel 42 interrupt enable. */
    vuint32_t CIM41:1;                 /* Channel 41 interrupt enable. */
    vuint32_t CIM40:1;                 /* Channel 40 interrupt enable. */
    vuint32_t CIM39:1;                 /* Channel 39 interrupt enable. */
    vuint32_t CIM38:1;                 /* Channel 38 interrupt enable. */
    vuint32_t CIM37:1;                 /* Channel 37 interrupt enable. */
    vuint32_t CIM36:1;                 /* Channel 36 interrupt enable. */
    vuint32_t CIM35:1;                 /* Channel 35 interrupt enable. */
    vuint32_t CIM34:1;                 /* Channel 34 interrupt enable. */
    vuint32_t CIM33:1;                 /* Channel 33 interrupt enable. */
    vuint32_t CIM32:1;                 /* Channel 32 interrupt enable. */
  } B;
} ADC_CIMR1_tag;

typedef union ADC_CIMR2_union_tag {    /* Channel Interrupt Mask Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CIM95:1;                 /* Channel 95 interrupt enable. */
    vuint32_t CIM94:1;                 /* Channel 94 interrupt enable. */
    vuint32_t CIM93:1;                 /* Channel 93 interrupt enable. */
    vuint32_t CIM92:1;                 /* Channel 92 interrupt enable. */
    vuint32_t CIM91:1;                 /* Channel 91 interrupt enable. */
    vuint32_t CIM90:1;                 /* Channel 90 interrupt enable. */
    vuint32_t CIM89:1;                 /* Channel 89 interrupt enable. */
    vuint32_t CIM88:1;                 /* Channel 88 interrupt enable. */
    vuint32_t CIM87:1;                 /* Channel 87 interrupt enable. */
    vuint32_t CIM86:1;                 /* Channel 86 interrupt enable. */
    vuint32_t CIM85:1;                 /* Channel 85 interrupt enable. */
    vuint32_t CIM84:1;                 /* Channel 84 interrupt enable. */
    vuint32_t CIM83:1;                 /* Channel 83 interrupt enable. */
    vuint32_t CIM82:1;                 /* Channel 82 interrupt enable. */
    vuint32_t CIM81:1;                 /* Channel 81 interrupt enable. */
    vuint32_t CIM80:1;                 /* Channel 80 interrupt enable. */
    vuint32_t CIM79:1;                 /* Channel 79 interrupt enable. */
    vuint32_t CIM78:1;                 /* Channel 78 interrupt enable. */
    vuint32_t CIM77:1;                 /* Channel 77 interrupt enable. */
    vuint32_t CIM76:1;                 /* Channel 76 interrupt enable. */
    vuint32_t CIM75:1;                 /* Channel 75 interrupt enable. */
    vuint32_t CIM74:1;                 /* Channel 74 interrupt enable. */
    vuint32_t CIM73:1;                 /* Channel 73 interrupt enable. */
    vuint32_t CIM72:1;                 /* Channel 72 interrupt enable. */
    vuint32_t CIM71:1;                 /* Channel 71 interrupt enable. */
    vuint32_t CIM70:1;                 /* Channel 70 interrupt enable. */
    vuint32_t CIM69:1;                 /* Channel 69 interrupt enable. */
    vuint32_t CIM68:1;                 /* Channel 68 interrupt enable. */
    vuint32_t CIM67:1;                 /* Channel 67 interrupt enable. */
    vuint32_t CIM66:1;                 /* Channel 66 interrupt enable. */
    vuint32_t CIM65:1;                 /* Channel 65 interrupt enable. */
    vuint32_t CIM64:1;                 /* Channel 64 interrupt enable. */
  } B;
} ADC_CIMR2_tag;

typedef union ADC_WTISR_union_tag {    /* Watchdog Threshold Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t WDG3H:1;
    vuint32_t WDG3L:1;
    vuint32_t WDG2H:1;
    vuint32_t WDG2L:1;
    vuint32_t WDG1H:1;
    vuint32_t WDG1L:1;
    vuint32_t WDG0H:1;
    vuint32_t WDG0L:1;
  } B;
} ADC_WTISR_tag;

typedef union ADC_WTIMR_union_tag {    /* Watchdog Threshold Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t MSKWDG3H:1;
    vuint32_t MSKWDG3L:1;
    vuint32_t MSKWDG2H:1;
    vuint32_t MSKWDG2L:1;
    vuint32_t MSKWDG1H:1;
    vuint32_t MSKWDG1L:1;
    vuint32_t MSKWDG0H:1;
    vuint32_t MSKWDG0L:1;
  } B;
} ADC_WTIMR_tag;

typedef union ADC_DMAE_union_tag {     /* DMA Enable register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t DCLR:1;                  /* DMA Clear sequence enable. */
    vuint32_t DMAEN:1;                 /* DMA global enable. */
  } B;
} ADC_DMAE_tag;

typedef union ADC_DMAR0_union_tag {    /* DMA Channel Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t DMA31:1;                 /* DMA enable for channel 31. */
    vuint32_t DMA30:1;                 /* DMA enable for channel 30. */
    vuint32_t DMA29:1;                 /* DMA enable for channel 29. */
    vuint32_t DMA28:1;                 /* DMA enable for channel 28. */
    vuint32_t DMA27:1;                 /* DMA enable for channel 27. */
    vuint32_t DMA26:1;                 /* DMA enable for channel 26. */
    vuint32_t DMA25:1;                 /* DMA enable for channel 25. */
    vuint32_t DMA24:1;                 /* DMA enable for channel 24. */
    vuint32_t DMA23:1;                 /* DMA enable for channel 23. */
    vuint32_t DMA22:1;                 /* DMA enable for channel 22. */
    vuint32_t DMA21:1;                 /* DMA enable for channel 21. */
    vuint32_t DMA20:1;                 /* DMA enable for channel 20. */
    vuint32_t DMA19:1;                 /* DMA enable for channel 19. */
    vuint32_t DMA18:1;                 /* DMA enable for channel 18. */
    vuint32_t DMA17:1;                 /* DMA enable for channel 17. */
    vuint32_t DMA16:1;                 /* DMA enable for channel 16. */
    vuint32_t DMA15:1;                 /* DMA enable for channel 15. */
    vuint32_t DMA14:1;                 /* DMA enable for channel 14. */
    vuint32_t DMA13:1;                 /* DMA enable for channel 13. */
    vuint32_t DMA12:1;                 /* DMA enable for channel 12. */
    vuint32_t DMA11:1;                 /* DMA enable for channel 11. */
    vuint32_t DMA10:1;                 /* DMA enable for channel 10. */
    vuint32_t DMA9:1;                  /* DMA enable for channel 9. */
    vuint32_t DMA8:1;                  /* DMA enable for channel 8. */
    vuint32_t DMA7:1;                  /* DMA enable for channel 7. */
    vuint32_t DMA6:1;                  /* DMA enable for channel 6. */
    vuint32_t DMA5:1;                  /* DMA enable for channel 5. */
    vuint32_t DMA4:1;                  /* DMA enable for channel 4. */
    vuint32_t DMA3:1;                  /* DMA enable for channel 3. */
    vuint32_t DMA2:1;                  /* DMA enable for channel 2. */
    vuint32_t DMA1:1;                  /* DMA enable for channel 1. */
    vuint32_t DMA0:1;                  /* DMA enable for channel 0. */
  } B;
} ADC_DMAR0_tag;

typedef union ADC_DMAR1_union_tag {    /* DMA Channel Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DMA47:1;                 /* DMA enable for channel 47. */
    vuint32_t DMA46:1;                 /* DMA enable for channel 46. */
    vuint32_t DMA45:1;                 /* DMA enable for channel 45. */
    vuint32_t DMA44:1;                 /* DMA enable for channel 44. */
    vuint32_t DMA43:1;                 /* DMA enable for channel 43. */
    vuint32_t DMA42:1;                 /* DMA enable for channel 42. */
    vuint32_t DMA41:1;                 /* DMA enable for channel 41. */
    vuint32_t DMA40:1;                 /* DMA enable for channel 40. */
    vuint32_t DMA39:1;                 /* DMA enable for channel 39. */
    vuint32_t DMA38:1;                 /* DMA enable for channel 38. */
    vuint32_t DMA37:1;                 /* DMA enable for channel 37. */
    vuint32_t DMA36:1;                 /* DMA enable for channel 36. */
    vuint32_t DMA35:1;                 /* DMA enable for channel 35. */
    vuint32_t DMA34:1;                 /* DMA enable for channel 34. */
    vuint32_t DMA33:1;                 /* DMA enable for channel 33. */
    vuint32_t DMA32:1;                 /* DMA enable for channel 32. */
  } B;
} ADC_DMAR1_tag;

typedef union ADC_DMAR2_union_tag {    /* DMA Channel Select Register 2 */
  vuint32_t R;
  struct {
    vuint32_t DMA95:1;                 /* DMA enable for channel 95. */
    vuint32_t DMA94:1;                 /* DMA enable for channel 94. */
    vuint32_t DMA93:1;                 /* DMA enable for channel 93. */
    vuint32_t DMA92:1;                 /* DMA enable for channel 92. */
    vuint32_t DMA91:1;                 /* DMA enable for channel 91. */
    vuint32_t DMA90:1;                 /* DMA enable for channel 90. */
    vuint32_t DMA89:1;                 /* DMA enable for channel 89. */
    vuint32_t DMA88:1;                 /* DMA enable for channel 88. */
    vuint32_t DMA87:1;                 /* DMA enable for channel 87. */
    vuint32_t DMA86:1;                 /* DMA enable for channel 86. */
    vuint32_t DMA85:1;                 /* DMA enable for channel 85. */
    vuint32_t DMA84:1;                 /* DMA enable for channel 84. */
    vuint32_t DMA83:1;                 /* DMA enable for channel 83. */
    vuint32_t DMA82:1;                 /* DMA enable for channel 82. */
    vuint32_t DMA81:1;                 /* DMA enable for channel 81. */
    vuint32_t DMA80:1;                 /* DMA enable for channel 80. */
    vuint32_t DMA79:1;                 /* DMA enable for channel 79. */
    vuint32_t DMA78:1;                 /* DMA enable for channel 78. */
    vuint32_t DMA77:1;                 /* DMA enable for channel 77. */
    vuint32_t DMA76:1;                 /* DMA enable for channel 76. */
    vuint32_t DMA75:1;                 /* DMA enable for channel 75. */
    vuint32_t DMA74:1;                 /* DMA enable for channel 74. */
    vuint32_t DMA73:1;                 /* DMA enable for channel 73. */
    vuint32_t DMA72:1;                 /* DMA enable for channel 72. */
    vuint32_t DMA71:1;                 /* DMA enable for channel 71. */
    vuint32_t DMA70:1;                 /* DMA enable for channel 70. */
    vuint32_t DMA69:1;                 /* DMA enable for channel 69. */
    vuint32_t DMA68:1;                 /* DMA enable for channel 68. */
    vuint32_t DMA67:1;                 /* DMA enable for channel 67. */
    vuint32_t DMA66:1;                 /* DMA enable for channel 66. */
    vuint32_t DMA65:1;                 /* DMA enable for channel 65. */
    vuint32_t DMA64:1;                 /* DMA enable for channel 64. */
  } B;
} ADC_DMAR2_tag;

typedef union ADC_THRHLR_union_tag {   /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t  :4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR_tag;

typedef union ADC_PSCR_union_tag {     /* Presampling Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t PREVAL2:2;               /* Internal voltage selection for Presampling */
    vuint32_t PREVAL1:2;               /* Internal voltage selection for Presampling. */
    vuint32_t PREVAL0:2;               /* Internal voltage selection for Presampling. */
    vuint32_t PRECONV:1;               /* Convert Presampled value */
  } B;
} ADC_PSCR_tag;

typedef union ADC_PSR0_union_tag {     /* Presampling register 0 */
  vuint32_t R;
  struct {
    vuint32_t PRES31:1;                /* Presampling enable for channel 31. */
    vuint32_t PRES30:1;                /* Presampling enable for channel 30. */
    vuint32_t PRES29:1;                /* Presampling enable for channel 29. */
    vuint32_t PRES28:1;                /* Presampling enable for channel 28. */
    vuint32_t PRES27:1;                /* Presampling enable for channel 27. */
    vuint32_t PRES26:1;                /* Presampling enable for channel 26. */
    vuint32_t PRES25:1;                /* Presampling enable for channel 25. */
    vuint32_t PRES24:1;                /* Presampling enable for channel 24. */
    vuint32_t PRES23:1;                /* Presampling enable for channel 23. */
    vuint32_t PRES22:1;                /* Presampling enable for channel 22. */
    vuint32_t PRES21:1;                /* Presampling enable for channel 21. */
    vuint32_t PRES20:1;                /* Presampling enable for channel 20. */
    vuint32_t PRES19:1;                /* Presampling enable for channel 19. */
    vuint32_t PRES18:1;                /* Presampling enable for channel 18. */
    vuint32_t PRES17:1;                /* Presampling enable for channel 17. */
    vuint32_t PRES16:1;                /* Presampling enable for channel 16. */
    vuint32_t PRES15:1;                /* Presampling enable for channel 15. */
    vuint32_t PRES14:1;                /* Presampling enable for channel 14. */
    vuint32_t PRES13:1;                /* Presampling enable for channel 13. */
    vuint32_t PRES12:1;                /* Presampling enable for channel 12. */
    vuint32_t PRES11:1;                /* Presampling enable for channel 11. */
    vuint32_t PRES10:1;                /* Presampling enable for channel 10. */
    vuint32_t PRES9:1;                 /* Presampling enable for channel 9. */
    vuint32_t PRES8:1;                 /* Presampling enable for channel 8. */
    vuint32_t PRES7:1;                 /* Presampling enable for channel 7. */
    vuint32_t PRES6:1;                 /* Presampling enable for channel 6. */
    vuint32_t PRES5:1;                 /* Presampling enable for channel 5. */
    vuint32_t PRES4:1;                 /* Presampling enable for channel 4. */
    vuint32_t PRES3:1;                 /* Presampling enable for channel 3. */
    vuint32_t PRES2:1;                 /* Presampling enable for channel 2. */
    vuint32_t PRES1:1;                 /* Presampling enable for channel 1. */
    vuint32_t PRES0:1;                 /* Presampling enable for channel 0. */
  } B;
} ADC_PSR0_tag;

typedef union ADC_PSR1_union_tag {     /* Presampling register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t PRES47:1;                /* Presampling enable for channel 47. */
    vuint32_t PRES46:1;                /* Presampling enable for channel 46. */
    vuint32_t PRES45:1;                /* Presampling enable for channel 45. */
    vuint32_t PRES44:1;                /* Presampling enable for channel 44. */
    vuint32_t PRES43:1;                /* Presampling enable for channel 43. */
    vuint32_t PRES42:1;                /* Presampling enable for channel 42. */
    vuint32_t PRES41:1;                /* Presampling enable for channel 41. */
    vuint32_t PRES40:1;                /* Presampling enable for channel 40. */
    vuint32_t PRES39:1;                /* Presampling enable for channel 39. */
    vuint32_t PRES38:1;                /* Presampling enable for channel 38. */
    vuint32_t PRES37:1;                /* Presampling enable for channel 37. */
    vuint32_t PRES36:1;                /* Presampling enable for channel 36. */
    vuint32_t PRES35:1;                /* Presampling enable for channel 35. */
    vuint32_t PRES34:1;                /* Presampling enable for channel 34. */
    vuint32_t PRES33:1;                /* Presampling enable for channel 33. */
    vuint32_t PRES32:1;                /* Presampling enable for channel 32. */
  } B;
} ADC_PSR1_tag;

typedef union ADC_PSR2_union_tag {     /* Presampling register 2 */
  vuint32_t R;
  struct {
    vuint32_t PRES95:1;                /* Presampling enable for channel 95. */
    vuint32_t PRES94:1;                /* Presampling enable for channel 94. */
    vuint32_t PRES93:1;                /* Presampling enable for channel 93. */
    vuint32_t PRES92:1;                /* Presampling enable for channel 92. */
    vuint32_t PRES91:1;                /* Presampling enable for channel 91. */
    vuint32_t PRES90:1;                /* Presampling enable for channel 90. */
    vuint32_t PRES89:1;                /* Presampling enable for channel 89. */
    vuint32_t PRES88:1;                /* Presampling enable for channel 88. */
    vuint32_t PRES87:1;                /* Presampling enable for channel 87. */
    vuint32_t PRES86:1;                /* Presampling enable for channel 86. */
    vuint32_t PRES85:1;                /* Presampling enable for channel 85. */
    vuint32_t PRES84:1;                /* Presampling enable for channel 84. */
    vuint32_t PRES83:1;                /* Presampling enable for channel 83. */
    vuint32_t PRES82:1;                /* Presampling enable for channel 82. */
    vuint32_t PRES81:1;                /* Presampling enable for channel 81. */
    vuint32_t PRES80:1;                /* Presampling enable for channel 80. */
    vuint32_t PRES79:1;                /* Presampling enable for channel 79. */
    vuint32_t PRES78:1;                /* Presampling enable for channel 78. */
    vuint32_t PRES77:1;                /* Presampling enable for channel 77. */
    vuint32_t PRES76:1;                /* Presampling enable for channel 76. */
    vuint32_t PRES75:1;                /* Presampling enable for channel 75. */
    vuint32_t PRES74:1;                /* Presampling enable for channel 74. */
    vuint32_t PRES73:1;                /* Presampling enable for channel 73. */
    vuint32_t PRES72:1;                /* Presampling enable for channel 72. */
    vuint32_t PRES71:1;                /* Presampling enable for channel 71. */
    vuint32_t PRES70:1;                /* Presampling enable for channel 70. */
    vuint32_t PRES69:1;                /* Presampling enable for channel 69. */
    vuint32_t PRES68:1;                /* Presampling enable for channel 68. */
    vuint32_t PRES67:1;                /* Presampling enable for channel 67. */
    vuint32_t PRES66:1;                /* Presampling enable for channel 66. */
    vuint32_t PRES65:1;                /* Presampling enable for channel 65. */
    vuint32_t PRES64:1;                /* Presampling enable for channel 64. */
  } B;
} ADC_PSR2_tag;

typedef union ADC_CTR0_union_tag {     /* Conversion Timing Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR0_tag;

typedef union ADC_CTR1_union_tag {     /* Conversion Timing Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR1_tag;

typedef union ADC_CTR2_union_tag {     /* Conversion Timing Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR2_tag;

typedef union ADC_NCMR0_union_tag {    /* Normal Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CH31:1;                  /* Normal sampling enable for channel 31. */
    vuint32_t CH30:1;                  /* Normal sampling enable for channel 30. */
    vuint32_t CH29:1;                  /* Normal sampling enable for channel 29. */
    vuint32_t CH28:1;                  /* Normal sampling enable for channel 28. */
    vuint32_t CH27:1;                  /* Normal sampling enable for channel 27. */
    vuint32_t CH26:1;                  /* Normal sampling enable for channel 26. */
    vuint32_t CH25:1;                  /* Normal sampling enable for channel 25. */
    vuint32_t CH24:1;                  /* Normal sampling enable for channel 24. */
    vuint32_t CH23:1;                  /* Normal sampling enable for channel 23. */
    vuint32_t CH22:1;                  /* Normal sampling enable for channel 22. */
    vuint32_t CH21:1;                  /* Normal sampling enable for channel 21. */
    vuint32_t CH20:1;                  /* Normal sampling enable for channel 20. */
    vuint32_t CH19:1;                  /* Normal sampling enable for channel 19. */
    vuint32_t CH18:1;                  /* Normal sampling enable for channel 18. */
    vuint32_t CH17:1;                  /* Normal sampling enable for channel 17. */
    vuint32_t CH16:1;                  /* Normal sampling enable for channel 16. */
    vuint32_t CH15:1;                  /* Normal sampling enable for channel 15. */
    vuint32_t CH14:1;                  /* Normal sampling enable for channel 14. */
    vuint32_t CH13:1;                  /* Normal sampling enable for channel 13. */
    vuint32_t CH12:1;                  /* Normal sampling enable for channel 12. */
    vuint32_t CH11:1;                  /* Normal sampling enable for channel 11. */
    vuint32_t CH10:1;                  /* Normal sampling enable for channel 10. */
    vuint32_t CH9:1;                   /* Normal sampling enable for channel 9. */
    vuint32_t CH8:1;                   /* Normal sampling enable for channel 8. */
    vuint32_t CH7:1;                   /* Normal sampling enable for channel 7. */
    vuint32_t CH6:1;                   /* Normal sampling enable for channel 6. */
    vuint32_t CH5:1;                   /* Normal sampling enable for channel 5. */
    vuint32_t CH4:1;                   /* Normal sampling enable for channel 4. */
    vuint32_t CH3:1;                   /* Normal sampling enable for channel 3. */
    vuint32_t CH2:1;                   /* Normal sampling enable for channel 2. */
    vuint32_t CH1:1;                   /* Normal sampling enable for channel 1. */
    vuint32_t CH0:1;                   /* Normal sampling enable for channel 0. */
  } B;
} ADC_NCMR0_tag;

typedef union ADC_NCMR1_union_tag {    /* Normal Conversion Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CH47:1;                  /* Normal sampling enable for channel 47. */
    vuint32_t CH46:1;                  /* Normal sampling enable for channel 46. */
    vuint32_t CH45:1;                  /* Normal sampling enable for channel 45. */
    vuint32_t CH44:1;                  /* Normal sampling enable for channel 44. */
    vuint32_t CH43:1;                  /* Normal sampling enable for channel 43. */
    vuint32_t CH42:1;                  /* Normal sampling enable for channel 42. */
    vuint32_t CH41:1;                  /* Normal sampling enable for channel 41. */
    vuint32_t CH40:1;                  /* Normal sampling enable for channel 40. */
    vuint32_t CH39:1;                  /* Normal sampling enable for channel 39. */
    vuint32_t CH38:1;                  /* Normal sampling enable for channel 38. */
    vuint32_t CH37:1;                  /* Normal sampling enable for channel 37. */
    vuint32_t CH36:1;                  /* Normal sampling enable for channel 36. */
    vuint32_t CH35:1;                  /* Normal sampling enable for channel 35. */
    vuint32_t CH34:1;                  /* Normal sampling enable for channel 34. */
    vuint32_t CH33:1;                  /* Normal sampling enable for channel 33. */
    vuint32_t CH32:1;                  /* Normal sampling enable for channel 32. */
  } B;
} ADC_NCMR1_tag;

typedef union ADC_NCMR2_union_tag {    /* Normal Conversion Mask Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CH95:1;                  /* Normal sampling enable for channel 95. */
    vuint32_t CH94:1;                  /* Normal sampling enable for channel 94. */
    vuint32_t CH93:1;                  /* Normal sampling enable for channel 93. */
    vuint32_t CH92:1;                  /* Normal sampling enable for channel 92. */
    vuint32_t CH91:1;                  /* Normal sampling enable for channel 91. */
    vuint32_t CH90:1;                  /* Normal sampling enable for channel 90. */
    vuint32_t CH89:1;                  /* Normal sampling enable for channel 89. */
    vuint32_t CH88:1;                  /* Normal sampling enable for channel 88. */
    vuint32_t CH87:1;                  /* Normal sampling enable for channel 87. */
    vuint32_t CH86:1;                  /* Normal sampling enable for channel 86. */
    vuint32_t CH85:1;                  /* Normal sampling enable for channel 85. */
    vuint32_t CH84:1;                  /* Normal sampling enable for channel 84. */
    vuint32_t CH83:1;                  /* Normal sampling enable for channel 83. */
    vuint32_t CH82:1;                  /* Normal sampling enable for channel 82. */
    vuint32_t CH81:1;                  /* Normal sampling enable for channel 81. */
    vuint32_t CH80:1;                  /* Normal sampling enable for channel 80. */
    vuint32_t CH79:1;                  /* Normal sampling enable for channel 79. */
    vuint32_t CH78:1;                  /* Normal sampling enable for channel 78. */
    vuint32_t CH77:1;                  /* Normal sampling enable for channel 77. */
    vuint32_t CH76:1;                  /* Normal sampling enable for channel 76. */
    vuint32_t CH75:1;                  /* Normal sampling enable for channel 75. */
    vuint32_t CH74:1;                  /* Normal sampling enable for channel 74. */
    vuint32_t CH73:1;                  /* Normal sampling enable for channel 73. */
    vuint32_t CH72:1;                  /* Normal sampling enable for channel 72. */
    vuint32_t CH71:1;                  /* Normal sampling enable for channel 71. */
    vuint32_t CH70:1;                  /* Normal sampling enable for channel 70. */
    vuint32_t CH69:1;                  /* Normal sampling enable for channel 69. */
    vuint32_t CH68:1;                  /* Normal sampling enable for channel 68. */
    vuint32_t CH67:1;                  /* Normal sampling enable for channel 67. */
    vuint32_t CH66:1;                  /* Normal sampling enable for channel 66. */
    vuint32_t CH65:1;                  /* Normal sampling enable for channel 65. */
    vuint32_t CH64:1;                  /* Normal sampling enable for channel 64. */
  } B;
} ADC_NCMR2_tag;

typedef union ADC_JCMR0_union_tag {    /* Injected Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CH31:1;                  /* Injected sampling enable for channel 31. */
    vuint32_t CH30:1;                  /* Injected sampling enable for channel 30. */
    vuint32_t CH29:1;                  /* Injected sampling enable for channel 29. */
    vuint32_t CH28:1;                  /* Injected sampling enable for channel 28. */
    vuint32_t CH27:1;                  /* Injected sampling enable for channel 27. */
    vuint32_t CH26:1;                  /* Injected sampling enable for channel 26. */
    vuint32_t CH25:1;                  /* Injected sampling enable for channel 25. */
    vuint32_t CH24:1;                  /* Injected sampling enable for channel 24. */
    vuint32_t CH23:1;                  /* Injected sampling enable for channel 23. */
    vuint32_t CH22:1;                  /* Injected sampling enable for channel 22. */
    vuint32_t CH21:1;                  /* Injected sampling enable for channel 21. */
    vuint32_t CH20:1;                  /* Injected sampling enable for channel 20. */
    vuint32_t CH19:1;                  /* Injected sampling enable for channel 19. */
    vuint32_t CH18:1;                  /* Injected sampling enable for channel 18. */
    vuint32_t CH17:1;                  /* Injected sampling enable for channel 17. */
    vuint32_t CH16:1;                  /* Injected sampling enable for channel 16. */
    vuint32_t CH15:1;                  /* Injected sampling enable for channel 15. */
    vuint32_t CH14:1;                  /* Injected sampling enable for channel 14. */
    vuint32_t CH13:1;                  /* Injected sampling enable for channel 13. */
    vuint32_t CH12:1;                  /* Injected sampling enable for channel 12. */
    vuint32_t CH11:1;                  /* Injected sampling enable for channel 11. */
    vuint32_t CH10:1;                  /* Injected sampling enable for channel 10. */
    vuint32_t CH9:1;                   /* Injected sampling enable for channel 9. */
    vuint32_t CH8:1;                   /* Injected sampling enable for channel 8. */
    vuint32_t CH7:1;                   /* Injected sampling enable for channel 7. */
    vuint32_t CH6:1;                   /* Injected sampling enable for channel 6. */
    vuint32_t CH5:1;                   /* Injected sampling enable for channel 5. */
    vuint32_t CH4:1;                   /* Injected sampling enable for channel 4. */
    vuint32_t CH3:1;                   /* Injected sampling enable for channel 3. */
    vuint32_t CH2:1;                   /* Injected sampling enable for channel 2. */
    vuint32_t CH1:1;                   /* Injected sampling enable for channel 1. */
    vuint32_t CH0:1;                   /* Injected sampling enable for channel 0. */
  } B;
} ADC_JCMR0_tag;

typedef union ADC_JCMR1_union_tag {    /* Injected Conversion Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CH47:1;                  /* Injected sampling enable for channel 47. */
    vuint32_t CH46:1;                  /* Injected sampling enable for channel 46. */
    vuint32_t CH45:1;                  /* Injected sampling enable for channel 45. */
    vuint32_t CH44:1;                  /* Injected sampling enable for channel 44. */
    vuint32_t CH43:1;                  /* Injected sampling enable for channel 43. */
    vuint32_t CH42:1;                  /* Injected sampling enable for channel 42. */
    vuint32_t CH41:1;                  /* Injected sampling enable for channel 41. */
    vuint32_t CH40:1;                  /* Injected sampling enable for channel 40. */
    vuint32_t CH39:1;                  /* Injected sampling enable for channel 39. */
    vuint32_t CH38:1;                  /* Injected sampling enable for channel 38. */
    vuint32_t CH37:1;                  /* Injected sampling enable for channel 37. */
    vuint32_t CH36:1;                  /* Injected sampling enable for channel 36. */
    vuint32_t CH35:1;                  /* Injected sampling enable for channel 35. */
    vuint32_t CH34:1;                  /* Injected sampling enable for channel 34. */
    vuint32_t CH33:1;                  /* Injected sampling enable for channel 33. */
    vuint32_t CH32:1;                  /* Injected sampling enable for channel 32. */
  } B;
} ADC_JCMR1_tag;

typedef union ADC_JCMR2_union_tag {    /* Injected Conversion Mask Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CH95:1;                  /* Injected sampling enable for channel 95. */
    vuint32_t CH94:1;                  /* Injected sampling enable for channel 94. */
    vuint32_t CH93:1;                  /* Injected sampling enable for channel 93. */
    vuint32_t CH92:1;                  /* Injected sampling enable for channel 92. */
    vuint32_t CH91:1;                  /* Injected sampling enable for channel 91. */
    vuint32_t CH90:1;                  /* Injected sampling enable for channel 90. */
    vuint32_t CH89:1;                  /* Injected sampling enable for channel 89. */
    vuint32_t CH88:1;                  /* Injected sampling enable for channel 88. */
    vuint32_t CH87:1;                  /* Injected sampling enable for channel 87. */
    vuint32_t CH86:1;                  /* Injected sampling enable for channel 86. */
    vuint32_t CH85:1;                  /* Injected sampling enable for channel 85. */
    vuint32_t CH84:1;                  /* Injected sampling enable for channel 84. */
    vuint32_t CH83:1;                  /* Injected sampling enable for channel 83. */
    vuint32_t CH82:1;                  /* Injected sampling enable for channel 82. */
    vuint32_t CH81:1;                  /* Injected sampling enable for channel 81. */
    vuint32_t CH80:1;                  /* Injected sampling enable for channel 80. */
    vuint32_t CH79:1;                  /* Injected sampling enable for channel 79. */
    vuint32_t CH78:1;                  /* Injected sampling enable for channel 78. */
    vuint32_t CH77:1;                  /* Injected sampling enable for channel 77. */
    vuint32_t CH76:1;                  /* Injected sampling enable for channel 76. */
    vuint32_t CH75:1;                  /* Injected sampling enable for channel 75. */
    vuint32_t CH74:1;                  /* Injected sampling enable for channel 74. */
    vuint32_t CH73:1;                  /* Injected sampling enable for channel 73. */
    vuint32_t CH72:1;                  /* Injected sampling enable for channel 72. */
    vuint32_t CH71:1;                  /* Injected sampling enable for channel 71. */
    vuint32_t CH70:1;                  /* Injected sampling enable for channel 70. */
    vuint32_t CH69:1;                  /* Injected sampling enable for channel 69. */
    vuint32_t CH68:1;                  /* Injected sampling enable for channel 68. */
    vuint32_t CH67:1;                  /* Injected sampling enable for channel 67. */
    vuint32_t CH66:1;                  /* Injected sampling enable for channel 66. */
    vuint32_t CH65:1;                  /* Injected sampling enable for channel 65. */
    vuint32_t CH64:1;                  /* Injected sampling enable for channel 64. */
  } B;
} ADC_JCMR2_tag;

typedef union ADC_DSDR_union_tag {     /* Decode Signals Delay Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DSD:16;
  } B;
} ADC_DSDR_tag;

typedef union ADC_PDEDR_union_tag {    /* Power Down Exit Delay Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t PDED:8;
  } B;
} ADC_PDEDR_tag;

    /* Note on CDR registers: There are only some CDR implemented         */
    /*  In order to make the CDR easily addressable, these are defined     */
    /*  as an array (ie ADC.CDR[x].R). This means you have to be careful    */
    /*  when addressing these registers in order not to access a PCTL that  */
    /*  is not implemented. Following are available: 0-47, 64-95 */

typedef union ADC_CDR_union_tag {      /* Channel Data Register n (Precision Channels) */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t VALID:1;                 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
    vuint32_t OVERW:1;                 /* Overwrite data */
    vuint32_t RESULT:2;
    vuint32_t CDATA:16;                /* Converted Data 11:0. */
  } B;
} ADC_CDR_tag;

typedef union ADC_CWSELR0_union_tag {  /* Channel Watchdog Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH7:4;              /* Channel Watchdog select for channel 7. */
    vuint32_t WSEL_CH6:4;              /* Channel Watchdog select for channel 6. */
    vuint32_t WSEL_CH5:4;              /* Channel Watchdog select for channel 5. */
    vuint32_t WSEL_CH4:4;              /* Channel Watchdog select for channel 4. */
    vuint32_t WSEL_CH3:4;              /* Channel Watchdog select for channel 3. */
    vuint32_t WSEL_CH2:4;              /* Channel Watchdog select for channel 2. */
    vuint32_t WSEL_CH1:4;              /* Channel Watchdog select for channel 1. */
    vuint32_t WSEL_CH0:4;              /* Channel Watchdog select for channel 0. */
  } B;
} ADC_CWSELR0_tag;

typedef union ADC_CWSELR1_union_tag {  /* Channel Watchdog Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH15:4;             /* Channel Watchdog select for channel 15. */
    vuint32_t WSEL_CH14:4;             /* Channel Watchdog select for channel 14. */
    vuint32_t WSEL_CH13:4;             /* Channel Watchdog select for channel 13. */
    vuint32_t WSEL_CH12:4;             /* Channel Watchdog select for channel 12. */
    vuint32_t WSEL_CH11:4;             /* Channel Watchdog select for channel 11. */
    vuint32_t WSEL_CH10:4;             /* Channel Watchdog select for channel 10. */
    vuint32_t WSEL_CH9:4;              /* Channel Watchdog select for channel 9. */
    vuint32_t WSEL_CH8:4;              /* Channel Watchdog select for channel 8. */
  } B;
} ADC_CWSELR1_tag;

typedef union ADC_CWSELR2_union_tag {  /* Channel Watchdog Select Register 2 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH23:4;             /* Channel Watchdog select for channel 23. */
    vuint32_t WSEL_CH22:4;             /* Channel Watchdog select for channel 22. */
    vuint32_t WSEL_CH21:4;             /* Channel Watchdog select for channel 21. */
    vuint32_t WSEL_CH20:4;             /* Channel Watchdog select for channel 20. */
    vuint32_t WSEL_CH19:4;             /* Channel Watchdog select for channel 19. */
    vuint32_t WSEL_CH18:4;             /* Channel Watchdog select for channel 18. */
    vuint32_t WSEL_CH17:4;             /* Channel Watchdog select for channel 17. */
    vuint32_t WSEL_CH16:4;             /* Channel Watchdog select for channel 16. */
  } B;
} ADC_CWSELR2_tag;

typedef union ADC_CWSELR3_union_tag {  /* Channel Watchdog Select Register 3 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH31:4;             /* Channel Watchdog select for channel 31. */
    vuint32_t WSEL_CH30:4;             /* Channel Watchdog select for channel 30. */
    vuint32_t WSEL_CH29:4;             /* Channel Watchdog select for channel 29. */
    vuint32_t WSEL_CH28:4;             /* Channel Watchdog select for channel 28. */
    vuint32_t WSEL_CH27:4;             /* Channel Watchdog select for channel 27. */
    vuint32_t WSEL_CH26:4;             /* Channel Watchdog select for channel 26. */
    vuint32_t WSEL_CH25:4;             /* Channel Watchdog select for channel 25. */
    vuint32_t WSEL_CH24:4;             /* Channel Watchdog select for channel 24. */
  } B;
} ADC_CWSELR3_tag;

typedef union ADC_CWSELR4_union_tag {  /* Channel Watchdog Select Register 4 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH39:4;             /* Channel Watchdog select for channel 39. */
    vuint32_t WSEL_CH38:4;             /* Channel Watchdog select for channel 38. */
    vuint32_t WSEL_CH37:4;             /* Channel Watchdog select for channel 37. */
    vuint32_t WSEL_CH36:4;             /* Channel Watchdog select for channel 36. */
    vuint32_t WSEL_CH35:4;             /* Channel Watchdog select for channel 35. */
    vuint32_t WSEL_CH34:4;             /* Channel Watchdog select for channel 34. */
    vuint32_t WSEL_CH33:4;             /* Channel Watchdog select for channel 33. */
    vuint32_t WSEL_CH32:4;             /* Channel Watchdog select for channel 32. */
  } B;
} ADC_CWSELR4_tag;

typedef union ADC_CWSELR8_union_tag {  /* Channel Watchdog Select Register 8 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH71:4;             /* Channel Watchdog select for channel 71. */
    vuint32_t WSEL_CH70:4;             /* Channel Watchdog select for channel 70. */
    vuint32_t WSEL_CH69:4;             /* Channel Watchdog select for channel 69. */
    vuint32_t WSEL_CH68:4;             /* Channel Watchdog select for channel 68. */
    vuint32_t WSEL_CH67:4;             /* Channel Watchdog select for channel 67. */
    vuint32_t WSEL_CH66:4;             /* Channel Watchdog select for channel 66. */
    vuint32_t WSEL_CH65:4;             /* Channel Watchdog select for channel 65. */
    vuint32_t WSEL_CH64:4;             /* Channel Watchdog select for channel 64. */
  } B;
} ADC_CWSELR8_tag;

typedef union ADC_CWSELR9_union_tag {  /* Channel Watchdog Select Register 9 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH79:4;             /* Channel Watchdog select for channel 79. */
    vuint32_t WSEL_CH78:4;             /* Channel Watchdog select for channel 78. */
    vuint32_t WSEL_CH77:4;             /* Channel Watchdog select for channel 77. */
    vuint32_t WSEL_CH76:4;             /* Channel Watchdog select for channel 76. */
    vuint32_t WSEL_CH75:4;             /* Channel Watchdog select for channel 75. */
    vuint32_t WSEL_CH74:4;             /* Channel Watchdog select for channel 74. */
    vuint32_t WSEL_CH73:4;             /* Channel Watchdog select for channel 73. */
    vuint32_t WSEL_CH72:4;             /* Channel Watchdog select for channel 72. */
  } B;
} ADC_CWSELR9_tag;

typedef union ADC_CWSELR10_union_tag { /* Channel Watchdog Select Register 10 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH87:4;             /* Channel Watchdog select for channel 87. */
    vuint32_t WSEL_CH86:4;             /* Channel Watchdog select for channel 86. */
    vuint32_t WSEL_CH85:4;             /* Channel Watchdog select for channel 85. */
    vuint32_t WSEL_CH84:4;             /* Channel Watchdog select for channel 84. */
    vuint32_t WSEL_CH83:4;             /* Channel Watchdog select for channel 83. */
    vuint32_t WSEL_CH82:4;             /* Channel Watchdog select for channel 82. */
    vuint32_t WSEL_CH81:4;             /* Channel Watchdog select for channel 81. */
    vuint32_t WSEL_CH80:4;             /* Channel Watchdog select for channel 80. */
  } B;
} ADC_CWSELR10_tag;

typedef union ADC_CWSELR11_union_tag { /* Channel Watchdog Select Register 11 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH95:4;             /* Channel Watchdog select for channel 95. */
    vuint32_t WSEL_CH94:4;             /* Channel Watchdog select for channel 94. */
    vuint32_t WSEL_CH93:4;             /* Channel Watchdog select for channel 93. */
    vuint32_t WSEL_CH92:4;             /* Channel Watchdog select for channel 92. */
    vuint32_t WSEL_CH91:4;             /* Channel Watchdog select for channel 91. */
    vuint32_t WSEL_CH90:4;             /* Channel Watchdog select for channel 90. */
    vuint32_t WSEL_CH89:4;             /* Channel Watchdog select for channel 89. */
    vuint32_t WSEL_CH88:4;             /* Channel Watchdog select for channel 88. */
  } B;
} ADC_CWSELR11_tag;

typedef union ADC_CWENR0_union_tag {   /* Channel Watchdog Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CWEN31:1;                /* Watchdog enable for channel 31. */
    vuint32_t CWEN30:1;                /* Watchdog enable for channel 30. */
    vuint32_t CWEN29:1;                /* Watchdog enable for channel 29. */
    vuint32_t CWEN28:1;                /* Watchdog enable for channel 28. */
    vuint32_t CWEN27:1;                /* Watchdog enable for channel 27. */
    vuint32_t CWEN26:1;                /* Watchdog enable for channel 26. */
    vuint32_t CWEN25:1;                /* Watchdog enable for channel 25. */
    vuint32_t CWEN24:1;                /* Watchdog enable for channel 24. */
    vuint32_t CWEN23:1;                /* Watchdog enable for channel 23. */
    vuint32_t CWEN22:1;                /* Watchdog enable for channel 22. */
    vuint32_t CWEN21:1;                /* Watchdog enable for channel 21. */
    vuint32_t CWEN20:1;                /* Watchdog enable for channel 20. */
    vuint32_t CWEN19:1;                /* Watchdog enable for channel 19. */
    vuint32_t CWEN18:1;                /* Watchdog enable for channel 18. */
    vuint32_t CWEN17:1;                /* Watchdog enable for channel 17. */
    vuint32_t CWEN16:1;                /* Watchdog enable for channel 16. */
    vuint32_t CWEN15:1;                /* Watchdog enable for channel 15. */
    vuint32_t CWEN14:1;                /* Watchdog enable for channel 14. */
    vuint32_t CWEN13:1;                /* Watchdog enable for channel 13. */
    vuint32_t CWEN12:1;                /* Watchdog enable for channel 12. */
    vuint32_t CWEN11:1;                /* Watchdog enable for channel 11. */
    vuint32_t CWEN10:1;                /* Watchdog enable for channel 10. */
    vuint32_t CWEN9:1;                 /* Watchdog enable for channel 9. */
    vuint32_t CWEN8:1;                 /* Watchdog enable for channel 8. */
    vuint32_t CWEN7:1;                 /* Watchdog enable for channel 7. */
    vuint32_t CWEN6:1;                 /* Watchdog enable for channel 6. */
    vuint32_t CWEN5:1;                 /* Watchdog enable for channel 5. */
    vuint32_t CWEN4:1;                 /* Watchdog enable for channel 4. */
    vuint32_t CWEN3:1;                 /* Watchdog enable for channel 3. */
    vuint32_t CWEN2:1;                 /* Watchdog enable for channel 2. */
    vuint32_t CWEN1:1;                 /* Watchdog enable for channel 1. */
    vuint32_t CWEN0:1;                 /* Watchdog enable for channel 0. */
  } B;
} ADC_CWENR0_tag;

typedef union ADC_CWENR1_union_tag {   /* Channel Watchdog Enable Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CWEN47:1;                /* Watchdog enable for channel 47. */
    vuint32_t CWEN46:1;                /* Watchdog enable for channel 46. */
    vuint32_t CWEN45:1;                /* Watchdog enable for channel 45. */
    vuint32_t CWEN44:1;                /* Watchdog enable for channel 44. */
    vuint32_t CWEN43:1;                /* Watchdog enable for channel 43. */
    vuint32_t CWEN42:1;                /* Watchdog enable for channel 42. */
    vuint32_t CWEN41:1;                /* Watchdog enable for channel 41. */
    vuint32_t CWEN40:1;                /* Watchdog enable for channel 40. */
    vuint32_t CWEN39:1;                /* Watchdog enable for channel 39. */
    vuint32_t CWEN38:1;                /* Watchdog enable for channel 38. */
    vuint32_t CWEN37:1;                /* Watchdog enable for channel 37. */
    vuint32_t CWEN36:1;                /* Watchdog enable for channel 36. */
    vuint32_t CWEN35:1;                /* Watchdog enable for channel 35. */
    vuint32_t CWEN34:1;                /* Watchdog enable for channel 34. */
    vuint32_t CWEN33:1;                /* Watchdog enable for channel 33. */
    vuint32_t CWEN32:1;                /* Watchdog enable for channel 32. */
  } B;
} ADC_CWENR1_tag;

typedef union ADC_CWENR2_union_tag {   /* Channel Watchdog Enable Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CWEN95:1;                /* Watchdog enable for channel 95. */
    vuint32_t CWEN94:1;                /* Watchdog enable for channel 94. */
    vuint32_t CWEN93:1;                /* Watchdog enable for channel 93. */
    vuint32_t CWEN92:1;                /* Watchdog enable for channel 92. */
    vuint32_t CWEN91:1;                /* Watchdog enable for channel 91. */
    vuint32_t CWEN90:1;                /* Watchdog enable for channel 90. */
    vuint32_t CWEN89:1;                /* Watchdog enable for channel 89. */
    vuint32_t CWEN88:1;                /* Watchdog enable for channel 88. */
    vuint32_t CWEN87:1;                /* Watchdog enable for channel 87. */
    vuint32_t CWEN86:1;                /* Watchdog enable for channel 86. */
    vuint32_t CWEN85:1;                /* Watchdog enable for channel 85. */
    vuint32_t CWEN84:1;                /* Watchdog enable for channel 84. */
    vuint32_t CWEN83:1;                /* Watchdog enable for channel 83. */
    vuint32_t CWEN82:1;                /* Watchdog enable for channel 82. */
    vuint32_t CWEN81:1;                /* Watchdog enable for channel 81. */
    vuint32_t CWEN80:1;                /* Watchdog enable for channel 80. */
    vuint32_t CWEN79:1;                /* Watchdog enable for channel 79. */
    vuint32_t CWEN78:1;                /* Watchdog enable for channel 78. */
    vuint32_t CWEN77:1;                /* Watchdog enable for channel 77. */
    vuint32_t CWEN76:1;                /* Watchdog enable for channel 76. */
    vuint32_t CWEN75:1;                /* Watchdog enable for channel 75. */
    vuint32_t CWEN74:1;                /* Watchdog enable for channel 74. */
    vuint32_t CWEN73:1;                /* Watchdog enable for channel 73. */
    vuint32_t CWEN72:1;                /* Watchdog enable for channel 72. */
    vuint32_t CWEN71:1;                /* Watchdog enable for channel 71. */
    vuint32_t CWEN70:1;                /* Watchdog enable for channel 70. */
    vuint32_t CWEN69:1;                /* Watchdog enable for channel 69. */
    vuint32_t CWEN68:1;                /* Watchdog enable for channel 68. */
    vuint32_t CWEN67:1;                /* Watchdog enable for channel 67. */
    vuint32_t CWEN66:1;                /* Watchdog enable for channel 66. */
    vuint32_t CWEN65:1;                /* Watchdog enable for channel 65. */
    vuint32_t CWEN64:1;                /* Watchdog enable for channel 64. */
  } B;
} ADC_CWENR2_tag;

typedef union ADC_AWORR0_union_tag {   /* Analog Watchdog Out of Range Register 0 */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH31:1;             /* Analog watchdog out of range for channel 31. */
    vuint32_t AWOR_CH30:1;             /* Analog watchdog out of range for channel 30. */
    vuint32_t AWOR_CH29:1;             /* Analog watchdog out of range for channel 29. */
    vuint32_t AWOR_CH28:1;             /* Analog watchdog out of range for channel 28. */
    vuint32_t AWOR_CH27:1;             /* Analog watchdog out of range for channel 27. */
    vuint32_t AWOR_CH26:1;             /* Analog watchdog out of range for channel 26. */
    vuint32_t AWOR_CH25:1;             /* Analog watchdog out of range for channel 25. */
    vuint32_t AWOR_CH24:1;             /* Analog watchdog out of range for channel 24. */
    vuint32_t AWOR_CH23:1;             /* Analog watchdog out of range for channel 23. */
    vuint32_t AWOR_CH22:1;             /* Analog watchdog out of range for channel 22. */
    vuint32_t AWOR_CH21:1;             /* Analog watchdog out of range for channel 21. */
    vuint32_t AWOR_CH20:1;             /* Analog watchdog out of range for channel 20. */
    vuint32_t AWOR_CH19:1;             /* Analog watchdog out of range for channel 19. */
    vuint32_t AWOR_CH18:1;             /* Analog watchdog out of range for channel 18. */
    vuint32_t AWOR_CH17:1;             /* Analog watchdog out of range for channel 17. */
    vuint32_t AWOR_CH16:1;             /* Analog watchdog out of range for channel 16. */
    vuint32_t AWOR_CH15:1;             /* Analog watchdog out of range for channel 15. */
    vuint32_t AWOR_CH14:1;             /* Analog watchdog out of range for channel 14. */
    vuint32_t AWOR_CH13:1;             /* Analog watchdog out of range for channel 13. */
    vuint32_t AWOR_CH12:1;             /* Analog watchdog out of range for channel 12. */
    vuint32_t AWOR_CH11:1;             /* Analog watchdog out of range for channel 11. */
    vuint32_t AWOR_CH10:1;             /* Analog watchdog out of range for channel 10. */
    vuint32_t AWOR_CH9:1;              /* Analog watchdog out of range for channel 9. */
    vuint32_t AWOR_CH8:1;              /* Analog watchdog out of range for channel 8. */
    vuint32_t AWOR_CH7:1;              /* Analog watchdog out of range for channel 7. */
    vuint32_t AWOR_CH6:1;              /* Analog watchdog out of range for channel 6. */
    vuint32_t AWOR_CH5:1;              /* Analog watchdog out of range for channel 5. */
    vuint32_t AWOR_CH4:1;              /* Analog watchdog out of range for channel 4. */
    vuint32_t AWOR_CH3:1;              /* Analog watchdog out of range for channel 3. */
    vuint32_t AWOR_CH2:1;              /* Analog watchdog out of range for channel 2. */
    vuint32_t AWOR_CH1:1;              /* Analog watchdog out of range for channel 1. */
    vuint32_t AWOR_CH0:1;              /* Analog watchdog out of range for channel 0. */
  } B;
} ADC_AWORR0_tag;

typedef union ADC_AWORR1_union_tag {   /* Analog Watchdog Out of Range Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t AWOR_CH47:1;             /* Analog watchdog out of range for channel 47. */
    vuint32_t AWOR_CH46:1;             /* Analog watchdog out of range for channel 46. */
    vuint32_t AWOR_CH45:1;             /* Analog watchdog out of range for channel 45. */
    vuint32_t AWOR_CH44:1;             /* Analog watchdog out of range for channel 44. */
    vuint32_t AWOR_CH43:1;             /* Analog watchdog out of range for channel 43. */
    vuint32_t AWOR_CH42:1;             /* Analog watchdog out of range for channel 42. */
    vuint32_t AWOR_CH41:1;             /* Analog watchdog out of range for channel 41. */
    vuint32_t AWOR_CH40:1;             /* Analog watchdog out of range for channel 40. */
    vuint32_t AWOR_CH39:1;             /* Analog watchdog out of range for channel 39. */
    vuint32_t AWOR_CH38:1;             /* Analog watchdog out of range for channel 38. */
    vuint32_t AWOR_CH37:1;             /* Analog watchdog out of range for channel 37. */
    vuint32_t AWOR_CH36:1;             /* Analog watchdog out of range for channel 36. */
    vuint32_t AWOR_CH35:1;             /* Analog watchdog out of range for channel 35. */
    vuint32_t AWOR_CH34:1;             /* Analog watchdog out of range for channel 34. */
    vuint32_t AWOR_CH33:1;             /* Analog watchdog out of range for channel 33. */
    vuint32_t AWOR_CH32:1;             /* Analog watchdog out of range for channel 32. */
  } B;
} ADC_AWORR1_tag;

typedef union ADC_AWORR2_union_tag {   /* Analog Watchdog Out of Range Register 2 */
  vuint32_t R;
  struct {
    vuint32_t AWOR_CH95:1;             /* Analog watchdog out of range for channel 95. */
    vuint32_t AWOR_CH94:1;             /* Analog watchdog out of range for channel 94. */
    vuint32_t AWOR_CH93:1;             /* Analog watchdog out of range for channel 93. */
    vuint32_t AWOR_CH92:1;             /* Analog watchdog out of range for channel 92. */
    vuint32_t AWOR_CH91:1;             /* Analog watchdog out of range for channel 91. */
    vuint32_t AWOR_CH90:1;             /* Analog watchdog out of range for channel 90. */
    vuint32_t AWOR_CH89:1;             /* Analog watchdog out of range for channel 89. */
    vuint32_t AWOR_CH88:1;             /* Analog watchdog out of range for channel 88. */
    vuint32_t AWOR_CH87:1;             /* Analog watchdog out of range for channel 87. */
    vuint32_t AWOR_CH86:1;             /* Analog watchdog out of range for channel 86. */
    vuint32_t AWOR_CH85:1;             /* Analog watchdog out of range for channel 85. */
    vuint32_t AWOR_CH84:1;             /* Analog watchdog out of range for channel 84. */
    vuint32_t AWOR_CH83:1;             /* Analog watchdog out of range for channel 83. */
    vuint32_t AWOR_CH82:1;             /* Analog watchdog out of range for channel 82. */
    vuint32_t AWOR_CH81:1;             /* Analog watchdog out of range for channel 81. */
    vuint32_t AWOR_CH80:1;             /* Analog watchdog out of range for channel 80. */
    vuint32_t AWOR_CH79:1;             /* Analog watchdog out of range for channel 79. */
    vuint32_t AWOR_CH78:1;             /* Analog watchdog out of range for channel 78. */
    vuint32_t AWOR_CH77:1;             /* Analog watchdog out of range for channel 77. */
    vuint32_t AWOR_CH76:1;             /* Analog watchdog out of range for channel 76. */
    vuint32_t AWOR_CH75:1;             /* Analog watchdog out of range for channel 75. */
    vuint32_t AWOR_CH74:1;             /* Analog watchdog out of range for channel 74. */
    vuint32_t AWOR_CH73:1;             /* Analog watchdog out of range for channel 73. */
    vuint32_t AWOR_CH72:1;             /* Analog watchdog out of range for channel 72. */
    vuint32_t AWOR_CH71:1;             /* Analog watchdog out of range for channel 71. */
    vuint32_t AWOR_CH70:1;             /* Analog watchdog out of range for channel 70. */
    vuint32_t AWOR_CH69:1;             /* Analog watchdog out of range for channel 69. */
    vuint32_t AWOR_CH68:1;             /* Analog watchdog out of range for channel 68. */
    vuint32_t AWOR_CH67:1;             /* Analog watchdog out of range for channel 67. */
    vuint32_t AWOR_CH66:1;             /* Analog watchdog out of range for channel 66. */
    vuint32_t AWOR_CH65:1;             /* Analog watchdog out of range for channel 65. */
    vuint32_t AWOR_CH64:1;             /* Analog watchdog out of range for channel 64. */
  } B;
} ADC_AWORR2_tag;

typedef union ADC_STCR1_union_tag {    /* Self Test Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INPSAMP_C:8;
    vuint32_t  :8;
    vuint32_t INPSAMP_S:8;
    vuint32_t  :8;
  } B;
} ADC_STCR1_tag;

typedef union ADC_STCR2_union_tag {    /* Self Test Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t MSKWDSERR:1;
    vuint32_t SERR:1;
    vuint32_t MSKWDTERR:1;             /* Interrupt enable (STSR[WDTERR] status bit) */
    vuint32_t  :1;
    vuint32_t MSKST_EOC:1;             /* Interrupt Enable bit for STSR2[ST_EOC] */
    vuint32_t  :4;
    vuint32_t MSKWDG_EOA_C:1;          /* Interrupt enable (WDG_EOA_C status bit) */
    vuint32_t  :1;
    vuint32_t MSKWDG_EOA_S:1;          /* Interrupt enable (WDG_EOA_S status bit) */
    vuint32_t MSKERR_C:1;              /* Interrupt enable (ERR_C status bit) */
    vuint32_t  :1;
    vuint32_t MSKERR_S2:1;             /* Interrupt enable (ERR_S2 status bit) */
    vuint32_t MSKERR_S1:1;             /* Interrupt enable (ERR_S1 status bit) */
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t EN:1;                    /* Self testing channel enable. The TEST conversions are enabled. */
    vuint32_t  :2;
    vuint32_t FMA_WDSERR:1;            /* Fault mapping for the Watchdog Sequence error. */
    vuint32_t FMA_WDTERR:1;            /* Fault mapping for the Watchdog Timer error. */
    vuint32_t FMA_C:1;                 /* Fault mapping for self test algorithm C. */
    vuint32_t  :1;
    vuint32_t FMA_S:1;                 /* Fault mapping for the self test algorithm BGAP. */
  } B;
} ADC_STCR2_tag;

typedef union ADC_STCR3_union_tag {    /* Self Test Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t ALG:2;                   /* Algorithm scheduling. */
    vuint32_t  :3;
    vuint32_t MSTEP:5;
  } B;
} ADC_STCR3_tag;

typedef union ADC_STBRR_union_tag {    /* Self Test Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t WDT:3;
    vuint32_t  :8;
    vuint32_t BR:8;                    /* Baud rate for the selected algorithm in SCAN mode (MCR[MODE] = 1). */
  } B;
} ADC_STBRR_tag;

typedef union ADC_STSR1_union_tag {    /* Self Test Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t WDSERR:1;
    vuint32_t  :1;
    vuint32_t WDTERR:1;
    vuint32_t OVERWR:1;                /* Overwrite error. */
    vuint32_t ST_EOC:1;                /* Self Test EOC Bit. */
    vuint32_t  :4;
    vuint32_t WDG_EOA_C:1;
    vuint32_t  :1;
    vuint32_t WDG_EOA_S:1;
    vuint32_t ERR_C:1;
    vuint32_t  :1;
    vuint32_t ERR_S2:1;
    vuint32_t ERR_S1:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t STEP_C:5;                /* Step of the algorithm C when an ERR_C has occurred. */
    vuint32_t  :5;
  } B;
} ADC_STSR1_tag;

typedef union ADC_STSR2_union_tag {    /* Self Test Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t OVFL:1;                  /* Overflow Bit */
    vuint32_t  :3;
    vuint32_t DATA1:12;                /* Test channel converted data when the ERR_S1 has occurred. */
    vuint32_t  :4;
    vuint32_t DATA0:12;                /* Test channel converted data when the ERR_S1 has occurred. */
  } B;
} ADC_STSR2_tag;

typedef union ADC_STSR3_union_tag {    /* Self Test Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t DATA1:12;                /* Test channel converted data when the ERR_S2 has occurred. */
    vuint32_t  :4;
    vuint32_t  :12;
  } B;
} ADC_STSR3_tag;

typedef union ADC_STSR4_union_tag {    /* Self Test Status Register 4 */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t DATA1:12;                /* Test channel converted data when the ERR_C has occurred. */
    vuint32_t  :4;
    vuint32_t  :12;
  } B;
} ADC_STSR4_tag;

typedef union ADC_STDR1_union_tag {    /* Self Test Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t VALID:1;                 /* Valid data. */
    vuint32_t OWERWR:1;                /* Overwrite data. */
    vuint32_t  :6;
    vuint32_t TCDATA:12;               /* Test channel converted data. */
  } B;
} ADC_STDR1_tag;

typedef union ADC_STDR2_union_tag {    /* Self Test Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t FDATA:12;
    vuint32_t VALID:1;                 /* Valid data. */
    vuint32_t OWERWR:1;                /* Overwrite data. */
    vuint32_t  :6;
    vuint32_t IDATA:12;
  } B;
} ADC_STDR2_tag;

typedef union ADC_STAW0R_union_tag {   /* Self Test Analog Watchdog Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t WDTE:1;                  /* Watchdog timer enable (related to the algorithm S) */
    vuint32_t  :2;
    vuint32_t THRH:12;                 /* High threshold value for Algorithm S step 0 */
    vuint32_t  :4;
    vuint32_t THRL:12;                 /* Low threshold value for Algorithm S step 0 */
  } B;
} ADC_STAW0R_tag;

typedef union ADC_STAW1AR_union_tag {  /* Self Test Analog Watchdog Register 1A */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable related to the algorithm S (step1). */
    vuint32_t  :3;
    vuint32_t THRH:12;                 /* High threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
    vuint32_t  :4;
    vuint32_t THRL:12;                 /* Low threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
  } B;
} ADC_STAW1AR_tag;

typedef union ADC_STAW1BR_union_tag {  /* Self Test Analog Watchdog Register 1B */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t THRH:12;                 /* High threshold value (fractional part) for test channel for algorithm S (step 1)(unsigned coding). */
    vuint32_t  :4;
    vuint32_t THRL:12;                 /* Low threshold value (fractional part) for test channel for algorithm S (step 1) (unsigned coding). */
  } B;
} ADC_STAW1BR_tag;

typedef union ADC_STAW2R_union_tag {   /* Self Test Analog Watchdog Register 2 */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable related to the algorithm S (step2). */
    vuint32_t  :19;
    vuint32_t THRL:12;                 /* Low threshold value for channel x (unsigned coding). If the analog watchdog is enabled, the STSR1[ERR_S2] status bit is set if STDR1[TCDATA] < THRL. */
  } B;
} ADC_STAW2R_tag;

typedef union ADC_STAW4R_union_tag {   /* Self Test Analog Watchdog Register 4 */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable (related to the algorithm C) */
    vuint32_t WDTE:1;                  /* Watchdog timer enable (related to the algorithm C). */
    vuint32_t  :2;
    vuint32_t THRH:12;                 /* High threshold value for channel sampled for Algorithm C. */
    vuint32_t  :4;
    vuint32_t THRL:12;                 /* Low threshold value for channel sampled for the C self test algorithm. */
  } B;
} ADC_STAW4R_tag;

typedef union ADC_STAW5R_union_tag {   /* Self Test Analog Watchdog Register 5 */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t THRH:12;                 /* High threshold value for the algorithm C (step1 to step CS-1). */
    vuint32_t  :4;
    vuint32_t THRL:12;                 /* Low threshold value for the algorithm C (step1 to step CS-1). */
  } B;
} ADC_STAW5R_tag;

typedef union ADC_CALBISTREG_union_tag { /* Calibration, BIST Control and status Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t TSAMP:2;                 /* Test Sample period in Calibration, BIST and Offset calculation process. */
    vuint32_t ACC_C:1;
    vuint32_t ACC_B:2;
    vuint32_t  :8;
    vuint32_t C_T_BUSY:1;
    vuint32_t  :1;
    vuint32_t  :6;
    vuint32_t  :1;
    vuint32_t NR_SMPL:2;               /* Number of Samples for averaging. */
    vuint32_t AVG_EN:1;                /* Average Enable (for Calibration only). */
    vuint32_t TEST_FAIL:1;             /* Test Fail. */
    vuint32_t ACC_A:2;
    vuint32_t TEST_EN:1;               /* Enable the test. */
  } B;
} ADC_CALBISTREG_tag;

typedef union ADC_OFSGNUSR_union_tag { /* Offset and Gain User Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t GAIN_USER:10;
    vuint32_t  :8;
    vuint32_t OFFSET_USER:8;
  } B;
} ADC_OFSGNUSR_tag;

typedef union ADC_ALTR_union_tag {     /* Alternate Result register */
  vuint32_t R;
  struct {
    vuint32_t ACC_D:16;
    vuint32_t  :1;
    vuint32_t  :15;
  } B;
} ADC_ALTR_tag;

struct ADC_tag {
  ADC_MCR_tag MCR;                     /* Main Configuration Register */
  ADC_MSR_tag MSR;                     /* Main Status register */
  uint8_t ADC_reserved0[8];
  ADC_ISR_tag ISR;                     /* Interrupt Status Register */
  ADC_CEOCFR0_tag CEOCFR0;             /* Channel Pending register 0 */
  ADC_CEOCFR1_tag CEOCFR1;             /* Channel Pending register 1 */
  ADC_CEOCFR2_tag CEOCFR2;             /* Channel Pending register 2 */
  ADC_IMR_tag IMR;                     /* Interrupt Mask Register */
  ADC_CIMR0_tag CIMR0;                 /* Channel Interrupt Mask Register 0 */
  ADC_CIMR1_tag CIMR1;                 /* Channel Interrupt Mask Register 1 */
  ADC_CIMR2_tag CIMR2;                 /* Channel Interrupt Mask Register 2 */
  ADC_WTISR_tag WTISR;                 /* Watchdog Threshold Interrupt Status Register */
  ADC_WTIMR_tag WTIMR;                 /* Watchdog Threshold Interrupt Mask Register */
  uint8_t ADC_reserved1[8];
  ADC_DMAE_tag DMAE;                   /* DMA Enable register */
  ADC_DMAR0_tag DMAR0;                 /* DMA Channel Select Register 0 */
  ADC_DMAR1_tag DMAR1;                 /* DMA Channel Select Register 1 */
  ADC_DMAR2_tag DMAR2;                 /* DMA Channel Select Register 2 */
  uint8_t ADC_reserved2[16];
  ADC_THRHLR_tag THRHLR[4];            /* Threshold Register */
  uint8_t ADC_reserved3[16];
  ADC_PSCR_tag PSCR;                   /* Presampling Control Register */
  ADC_PSR0_tag PSR0;                   /* Presampling register 0 */
  ADC_PSR1_tag PSR1;                   /* Presampling register 1 */
  ADC_PSR2_tag PSR2;                   /* Presampling register 2 */
  uint8_t ADC_reserved4[4];
  ADC_CTR0_tag CTR0;                   /* Conversion Timing Register 0 */
  ADC_CTR1_tag CTR1;                   /* Conversion Timing Register 1 */
  ADC_CTR2_tag CTR2;                   /* Conversion Timing Register 2 */
  uint8_t ADC_reserved5[4];
  ADC_NCMR0_tag NCMR0;                 /* Normal Conversion Mask Register 0 */
  ADC_NCMR1_tag NCMR1;                 /* Normal Conversion Mask Register 1 */
  ADC_NCMR2_tag NCMR2;                 /* Normal Conversion Mask Register 2 */
  uint8_t ADC_reserved6[4];
  ADC_JCMR0_tag JCMR0;                 /* Injected Conversion Mask Register 0 */
  ADC_JCMR1_tag JCMR1;                 /* Injected Conversion Mask Register 1 */
  ADC_JCMR2_tag JCMR2;                 /* Injected Conversion Mask Register 2 */
  uint8_t ADC_reserved7[4];
  ADC_DSDR_tag DSDR;                   /* Decode Signals Delay Register */
  ADC_PDEDR_tag PDEDR;                 /* Power Down Exit Delay Register */
  uint8_t ADC_reserved8[52];
  ADC_CDR_tag CDR[96];                 /* Channel Data Register n (Precision Channels) */
  uint8_t ADC_reserved9[48];
  ADC_CWSELR0_tag CWSELR0;             /* Channel Watchdog Select Register 0 */
  ADC_CWSELR1_tag CWSELR1;             /* Channel Watchdog Select Register 1 */
  ADC_CWSELR2_tag CWSELR2;             /* Channel Watchdog Select Register 2 */
  ADC_CWSELR3_tag CWSELR3;             /* Channel Watchdog Select Register 3 */
  ADC_CWSELR4_tag CWSELR4;             /* Channel Watchdog Select Register 4 */
  uint8_t ADC_reserved10[12];
  ADC_CWSELR8_tag CWSELR8;             /* Channel Watchdog Select Register 8 */
  ADC_CWSELR9_tag CWSELR9;             /* Channel Watchdog Select Register 9 */
  ADC_CWSELR10_tag CWSELR10;           /* Channel Watchdog Select Register 10 */
  ADC_CWSELR11_tag CWSELR11;           /* Channel Watchdog Select Register 11 */
  ADC_CWENR0_tag CWENR0;               /* Channel Watchdog Enable Register 0 */
  ADC_CWENR1_tag CWENR1;               /* Channel Watchdog Enable Register 1 */
  ADC_CWENR2_tag CWENR2;               /* Channel Watchdog Enable Register 2 */
  uint8_t ADC_reserved11[4];
  ADC_AWORR0_tag AWORR0;               /* Analog Watchdog Out of Range Register 0 */
  ADC_AWORR1_tag AWORR1;               /* Analog Watchdog Out of Range Register 1 */
  ADC_AWORR2_tag AWORR2;               /* Analog Watchdog Out of Range Register 2 */
  uint8_t ADC_reserved12[68];
  ADC_STCR1_tag STCR1;                 /* Self Test Configuration Register 1 */
  ADC_STCR2_tag STCR2;                 /* Self Test Configuration Register 2 */
  ADC_STCR3_tag STCR3;                 /* Self Test Configuration Register 3 */
  ADC_STBRR_tag STBRR;                 /* Self Test Baud Rate Register */
  ADC_STSR1_tag STSR1;                 /* Self Test Status Register 1 */
  ADC_STSR2_tag STSR2;                 /* Self Test Status Register 2 */
  ADC_STSR3_tag STSR3;                 /* Self Test Status Register 3 */
  ADC_STSR4_tag STSR4;                 /* Self Test Status Register 4 */
  uint8_t ADC_reserved13[16];
  ADC_STDR1_tag STDR1;                 /* Self Test Data Register 1 */
  ADC_STDR2_tag STDR2;                 /* Self Test Data Register 2 */
  uint8_t ADC_reserved14[8];
  ADC_STAW0R_tag STAW0R;               /* Self Test Analog Watchdog Register 0 */
  ADC_STAW1AR_tag STAW1AR;             /* Self Test Analog Watchdog Register 1A */
  ADC_STAW1BR_tag STAW1BR;             /* Self Test Analog Watchdog Register 1B */
  ADC_STAW2R_tag STAW2R;               /* Self Test Analog Watchdog Register 2 */
  uint8_t ADC_reserved15[4];
  ADC_STAW4R_tag STAW4R;               /* Self Test Analog Watchdog Register 4 */
  ADC_STAW5R_tag STAW5R;               /* Self Test Analog Watchdog Register 5 */
  uint8_t ADC_reserved16[4];
  ADC_CALBISTREG_tag CALBISTREG;       /* Calibration, BIST Control and status Register */
  uint8_t ADC_reserved17[4];
  ADC_OFSGNUSR_tag OFSGNUSR;           /* Offset and Gain User Register */
  uint8_t ADC_reserved18[12];
  ADC_ALTR_tag ALTR;                   /* Alternate Result register */
};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

typedef union AIPS_MPRA_union_tag {    /* Master Privilege Register A */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MTR0:1;                  /* Master 0 Trusted For Read */
    vuint32_t MTW0:1;                  /* Master 0 Trusted For Writes */
    vuint32_t MPL0:1;                  /* Master 0 Privilege Level */
    vuint32_t  :1;
    vuint32_t MTR1:1;                  /* Master 1 trusted for read */
    vuint32_t MTW1:1;                  /* Master 1 trusted for writes */
    vuint32_t MPL1:1;                  /* Master 1 privilege level */
    vuint32_t  :4;
    vuint32_t  :1;
    vuint32_t MTR3:1;                  /* Master 3 Trusted For Read */
    vuint32_t MTW3:1;                  /* Master 3 Trusted For Writes */
    vuint32_t MPL3:1;                  /* Master 3 Privilege Level */
    vuint32_t  :1;
    vuint32_t MTR4:1;                  /* Master 4 Trusted For Read */
    vuint32_t MTW4:1;                  /* Master 4 Trusted For Writes */
    vuint32_t MPL4:1;                  /* Master 4 Privilege Level */
    vuint32_t  :4;
    vuint32_t  :4;
    vuint32_t  :1;
    vuint32_t MTR7:1;                  /* Master 7 trusted for read */
    vuint32_t MTW7:1;                  /* Master 7 trusted for writes */
    vuint32_t MPL7:1;                  /* Master 7 privilege level */
  } B;
} AIPS_MPRA_tag;

typedef union AIPS_PACR_union_tag {    /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACR_tag;

typedef union AIPS_OPACR_union_tag {   /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t  :1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACR_tag;

struct AIPS_tag {
  AIPS_MPRA_tag MPRA;                  /* Master Privilege Register A */
  uint8_t AIPS_reserved0[252];
  AIPS_PACR_tag PACR[8];               /* Peripheral Access Control Register */
  uint8_t AIPS_reserved1[32];
  AIPS_OPACR_tag OPACR[32];            /* Off-Platform Peripheral Access Control Register */
};


/* ============================================================================
   =============================== Module: BCTU ===============================
   ============================================================================ */

typedef union BCTU_MCR_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze mode - for debug operation. */
    vuint32_t  :2;
    vuint32_t GTRGEN:1;                /* Global Trigger Enable. */
    vuint32_t  :6;
    vuint32_t DMA3:1;                  /* ADC3DR data transferring by DMA. */
    vuint32_t DMA2:1;                  /* ADC2DR data transferring by DMA. */
    vuint32_t DMA1:1;                  /* ADC1DR data transferring by DMA. */
    vuint32_t DMA0:1;                  /* ADC0DR data transferring by DMA. */
    vuint32_t  :8;
    vuint32_t TRGEN:1;                 /* Trigger interrupt request enable. */
    vuint32_t  :1;
    vuint32_t LIST_IEN:1;              /* LIST interrupt enable. */
    vuint32_t  :1;
    vuint32_t IEN3:1;                  /* Interrupt enable bit for ADC3DR new data. */
    vuint32_t IEN2:1;                  /* Interrupt enable bit for ADC2DR new data. */
    vuint32_t IEN1:1;                  /* Interrupt enable bit for ADC1DR new data. */
    vuint32_t IEN0:1;                  /* Interrupt enable bit for ADC0DR new data. */
  } B;
} BCTU_MCR_tag;

typedef union BCTU_MSR_union_tag {     /* Module Status register */
  vuint32_t R;
  struct {
    vuint32_t TRGF_CLR:1;              /* TRGF clear */
    vuint32_t  :3;
    vuint32_t LIST3_Last_CLR:1;
    vuint32_t LIST2_Last_CLR:1;
    vuint32_t LIST1_Last_CLR:1;
    vuint32_t LIST0_Last_CLR:1;
    vuint32_t DATAOVR3_CLR:1;          /* Clears DATAOVR3 flag */
    vuint32_t DATAOVR2_CLR:1;          /* Clears DATAOVR2 flag */
    vuint32_t DATAOVR1_CLR:1;          /* Clears DATAOVR1 flag */
    vuint32_t DATAOVR0_CLR:1;          /* Clears DATAOVR0 flag */
    vuint32_t NDATA3_CLR:1;
    vuint32_t NDATA2_CLR:1;            /* Clears NDATA2 flag */
    vuint32_t NDATA1_CLR:1;            /* Clears NDATA1 flag */
    vuint32_t NDATA0_CLR:1;            /* Clears NDATA0 flag */
    vuint32_t TRGF:1;                  /* Trigger Flag */
    vuint32_t  :3;
    vuint32_t LIST3_Last:1;
    vuint32_t LIST2_Last:1;
    vuint32_t LIST1_Last:1;
    vuint32_t LIST0_Last:1;
    vuint32_t DATAOVR3:1;
    vuint32_t DATAOVR2:1;
    vuint32_t DATAOVR1:1;
    vuint32_t DATAOVR0:1;
    vuint32_t NDATA3:1;
    vuint32_t NDATA2:1;
    vuint32_t NDATA1:1;
    vuint32_t NDATA0:1;
  } B;
} BCTU_MSR_tag;

typedef union BCTU_TRGCFG_TRGCFG_union_tag { /* Trigger Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t LOOP:1;                  /* LOOP bit */
    vuint32_t  :7;
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t CCP:4;                   /* Conversion Configuration Pointer (CCP) */
    vuint32_t TRIGEN:1;                /* Trigger enable */
    vuint32_t TRG_FLAG:1;
    vuint32_t TRS:1;                   /* Trigger resolution */
    vuint32_t  :1;
    vuint32_t ADC_SEL3:1;
    vuint32_t ADC_SEL2:1;
    vuint32_t ADC_SEL1:1;
    vuint32_t ADC_SEL0:1;
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t CHANNEL_VALUE_OR_LADDR:7; /* Channel Value or List Address Value. */
  } B;
} BCTU_TRGCFG_TRGCFG_tag;

typedef struct BCTU_TRGCFG_struct_tag {
  BCTU_TRGCFG_TRGCFG_tag TRGCFG;       /* Trigger Configuration Register */
} BCTU_TRGCFG_tag;

typedef union BCTU_WRPROT_union_tag {  /* Write Protection register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t PROTEC_CODE:4;           /* The Protection code sets protection for the write protected registers */
  } B;
} BCTU_WRPROT_tag;

typedef union BCTU_SFTRGR1_union_tag { /* Software Trigger register 1 */
  vuint32_t R;
  struct {
    vuint32_t SFTRG31:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG30:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG29:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG28:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG27:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG26:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG25:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG24:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG23:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG22:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG21:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG20:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG19:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG18:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG17:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG16:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG15:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG14:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG13:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG12:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG11:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG10:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG9:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG8:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG7:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG6:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG5:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG4:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG3:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG2:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG1:1;                /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG0:1;                /* Software trigger to start an ADC conversion. */
  } B;
} BCTU_SFTRGR1_tag;

typedef union BCTU_SFTRGR3_union_tag { /* Software Trigger register 1 */
  vuint32_t R;
  struct {
    vuint32_t SFTRG95:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG94:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG93:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG92:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG91:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG90:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG89:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG88:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG87:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG86:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG85:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG84:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG83:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG82:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG81:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG80:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG79:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG78:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG77:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG76:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG75:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG74:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG73:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG72:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG71:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG70:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG69:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG68:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG67:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG66:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG65:1;               /* Software trigger to start an ADC conversion. */
    vuint32_t SFTRG64:1;               /* Software trigger to start an ADC conversion. */
  } B;
} BCTU_SFTRGR3_tag;

typedef union BCTU_ADC0DR_union_tag {  /* ADC0 Result Data register */
  vuint32_t R;
  struct {
    vuint32_t TRG_SRC:8;
    vuint32_t CH:8;
    vuint32_t LIST:1;
    vuint32_t LAST:1;
    vuint32_t  :2;
    vuint32_t ADC_DATA:12;
  } B;
} BCTU_ADC0DR_tag;

typedef union BCTU_ADC1DR_union_tag {  /* ADC1 result data register */
  vuint32_t R;
  struct {
    vuint32_t TRG_SRC:8;
    vuint32_t CH:8;
    vuint32_t LIST:1;
    vuint32_t LAST:1;
    vuint32_t  :2;
    vuint32_t ADC_DATA:12;
  } B;
} BCTU_ADC1DR_tag;

typedef union BCTU_ADC2DR_union_tag {  /* ADC2 result data register */
  vuint32_t R;
  struct {
    vuint32_t TRG_SRC:8;
    vuint32_t CH:8;
    vuint32_t LIST:1;
    vuint32_t LAST:1;
    vuint32_t  :2;
    vuint32_t ADC_DATA:12;
  } B;
} BCTU_ADC2DR_tag;

typedef union BCTU_ADC3DR_union_tag {  /* ADC3 result data register */
  vuint32_t R;
  struct {
    vuint32_t TRG_SRC:8;
    vuint32_t CH:8;
    vuint32_t LIST:1;
    vuint32_t LAST:1;
    vuint32_t  :2;
    vuint32_t ADC_DATA:12;
  } B;
} BCTU_ADC3DR_tag;

typedef union BCTU_LISTSTAR_union_tag { /* LIST Size Status register */
  vuint32_t R;
  struct {
    vuint32_t  :24;                    /* Reserved. */
    vuint32_t LISTSZ:8;                /* Size of the LIST in number of elements. */
  } B;
} BCTU_LISTSTAR_tag;

typedef union BCTU_LISTCHR_LISTCHR_union_tag { /* LIST Channel Address Register */
  vuint32_t R;
  struct {
    vuint32_t LAST_y:1;                /* Last channel in the list of channels. */
    vuint32_t  :3;
    vuint32_t TAG_y:4;                 /* TAG for the n LIST element */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t ADC_CH_y:7;              /* ADC channel selection. */
    vuint32_t LAST_y_plus_1:1;         /* Second to last channel in the list of channels. */
    vuint32_t  :3;
    vuint32_t TAG_y_plus_1:4;          /* TAG for the [y+1] LIST element. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t ADC_CHL_y_plus_1:7;      /* ADC channel selection. */
  } B;
} BCTU_LISTCHR_LISTCHR_tag;

typedef struct BCTU_LISTCHR_struct_tag {
  BCTU_LISTCHR_LISTCHR_tag LISTCHR;    /* LIST Channel Address Register */
} BCTU_LISTCHR_tag;

typedef union BCTU_CCR_CCR_union_tag { /* Conversion configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t DEST:2;                  /* Destination selection */
    vuint32_t  :4;                     /* Reserved */
    vuint32_t TAG:4;                   /* The TAG field is used in the Parallel Side Port as the TAG bits. */
  } B;
} BCTU_CCR_CCR_tag;

typedef struct BCTU_CCR_struct_tag {
  BCTU_CCR_CCR_tag CCR;                /* Conversion configuration register */
} BCTU_CCR_tag;

struct BCTU_tag {
  BCTU_MCR_tag MCR;                    /* Module Configuration Register */
  uint32_t BCTU_reserved0[7];
  BCTU_MSR_tag MSR;                    /* Module Status register */
  uint32_t BCTU_reserved1[15];
  BCTU_TRGCFG_tag TRGCFG[32];
  uint32_t BCTU_reserved2[400];
  BCTU_WRPROT_tag WRPROT;              /* Write Protection register */
  uint32_t BCTU_reserved3[3];
  BCTU_SFTRGR1_tag SFTRGR1;            /* Software Trigger register 1 */
  uint32_t BCTU_reserved4[7];
  BCTU_SFTRGR3_tag SFTRGR3;            /* Software Trigger register 1 */
  uint32_t BCTU_reserved5[7];
  BCTU_ADC0DR_tag ADC0DR;              /* ADC0 Result Data register */
  uint32_t BCTU_reserved6[3];
  BCTU_ADC1DR_tag ADC1DR;              /* ADC1 result data register */
  uint32_t BCTU_reserved7[3];
  BCTU_ADC2DR_tag ADC2DR;              /* ADC2 result data register */
  uint32_t BCTU_reserved8[3];
  BCTU_ADC3DR_tag ADC3DR;              /* ADC3 result data register */
  uint32_t BCTU_reserved9[3];
  BCTU_LISTSTAR_tag LISTSTAR;          /* LIST Size Status register */
  uint32_t BCTU_reserved10[3];
  BCTU_LISTCHR_tag LISTCHR[32];
  BCTU_CCR_tag CCR[11];
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

typedef union C55FMC_MCR_union_tag {   /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RVE:1;                   /* Read Voltage Error */
    vuint32_t RRE:1;                   /* Read Reference Error */
    vuint32_t AEE:1;                   /* Address Encode Error */
    vuint32_t EEE:1;                   /* ECC after ECC Error */
    vuint32_t  :12;
    vuint32_t EER:1;                   /* ECC Event Error */
    vuint32_t RWE:1;                   /* Read-While-Write Event Error */
    vuint32_t SBC:1;                   /* Single Bit Correction */
    vuint32_t  :1;
    vuint32_t PEAS:1;                  /* Program Access Space */
    vuint32_t DONE:1;                  /* State Machine Status */
    vuint32_t PEG:1;                   /* Program/Erase Good */
    vuint32_t PECIE:1;                 /* Program/Erase Complete Interrupt Enable */
    vuint32_t  :3;
    vuint32_t PGM:1;                   /* Program */
    vuint32_t PSUS:1;                  /* Program Suspend */
    vuint32_t ERS:1;                   /* Erase */
    vuint32_t ESUS:1;                  /* Erase Suspend */
    vuint32_t EHV:1;                   /* Enable High Voltage */
  } B;
} C55FMC_MCR_tag;

typedef union C55FMC_MCRE_union_tag {  /* Extended Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HT:1;                    /* High Temperature Enabled. */
    vuint32_t  :2;
    vuint32_t n256K:5;
    vuint32_t n64Kh:3;
    vuint32_t n32Kh:2;
    vuint32_t n16Kh:3;
    vuint32_t n64Km:3;
    vuint32_t n32Km:2;
    vuint32_t n16Km:3;
    vuint32_t n64Kl:3;
    vuint32_t n32Kl:2;
    vuint32_t n16Kl:3;
  } B;
} C55FMC_MCRE_tag;

typedef union C55FMC_LOCK0_union_tag { /* Lock 0 register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;                /* UTest NVM Lock. */
    vuint32_t  :1;
    vuint32_t LOWLOCK:14;              /* Low Block Lock */
    vuint32_t MIDLOCK:16;              /* Mid Block Lock */
  } B;
} C55FMC_LOCK0_tag;

typedef union C55FMC_LOCK1_union_tag { /* Lock 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHLOCK:16;             /* High Block Lock */
  } B;
} C55FMC_LOCK1_tag;

typedef union C55FMC_LOCK2_union_tag { /* Lock 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:32;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK2_tag;

typedef union C55FMC_LOCK3_union_tag { /* Lock 3 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t A256KLOCK:16;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK3_tag;

typedef union C55FMC_SEL0_union_tag {  /* Select 0 register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t LOWSEL:14;               /* LOW Block Select. */
    vuint32_t MIDSEL:16;               /* Mid Block Select. */
  } B;
} C55FMC_SEL0_tag;

typedef union C55FMC_SEL1_union_tag {  /* Select 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHSEL:16;              /* High Block Select. */
  } B;
} C55FMC_SEL1_tag;

typedef union C55FMC_SEL2_union_tag {  /* Select 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:32;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL2_tag;

typedef union C55FMC_SEL3_union_tag {  /* Select 3 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t A256KSEL:16;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL3_tag;

typedef union C55FMC_ADR_union_tag {   /* Address register */
  vuint32_t R;
  struct {
    vuint32_t SAD:1;
    vuint32_t aH:1;
    vuint32_t aM:1;
    vuint32_t aL:1;
    vuint32_t a256k:1;
    vuint32_t a64k:1;
    vuint32_t a32k:1;
    vuint32_t a16k:1;
    vuint32_t ADDR:21;
    vuint32_t  :3;
  } B;
} C55FMC_ADR_tag;

typedef union C55FMC_UT0_union_tag {   /* UTest 0 register */
  vuint32_t R;
  struct {
    vuint32_t UTE:1;
    vuint32_t SBCE:1;
    vuint32_t  :11;
    vuint32_t CPR:1;
    vuint32_t CPA:1;
    vuint32_t CPE:1;
    vuint32_t  :6;
    vuint32_t NAIBP:1;
    vuint32_t AIBPE:1;
    vuint32_t  :1;
    vuint32_t AISUS:1;
    vuint32_t MRE:1;
    vuint32_t MRV:1;
    vuint32_t  :1;
    vuint32_t AIS:1;
    vuint32_t AIE:1;
    vuint32_t AID:1;
  } B;
} C55FMC_UT0_tag;

typedef union C55FMC_UM_union_tag {    /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t MISR:32;
  } B;
} C55FMC_UM_tag;

typedef union C55FMC_UM9_union_tag {   /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t MISR:1;                  /* MISR[288]. */
  } B;
} C55FMC_UM9_tag;

typedef union C55FMC_OPP0_union_tag {  /* Over-Program Protection 0 register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t LOWOPP:14;               /* Low Block Over-Program Protection[13:0]. */
    vuint32_t MIDOPP:16;               /* Mid Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP0_tag;

typedef union C55FMC_OPP1_union_tag {  /* Over-Program Protection 1 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHOPP:16;              /* High Block Over-Program Protection[15:0]. */
  } B;
} C55FMC_OPP1_tag;

typedef union C55FMC_OPP2_union_tag {  /* Over-Program Protection 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KOPP:32;             /* 256K Block Over-Program Protection[31:0]. */
  } B;
} C55FMC_OPP2_tag;

typedef union C55FMC_OPP3_union_tag {  /* Over-Program Protection 3 register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t A256KOPP:16;             /* 256K Block Over-Program Protection[47:32]. */
  } B;
} C55FMC_OPP3_tag;

struct C55FMC_tag {
  C55FMC_MCR_tag MCR;                  /* Module Configuration Register */
  uint8_t C55FMC_reserved0[4];
  C55FMC_MCRE_tag MCRE;                /* Extended Module Configuration Register */
  uint8_t C55FMC_reserved1[4];
  C55FMC_LOCK0_tag LOCK0;              /* Lock 0 register */
  C55FMC_LOCK1_tag LOCK1;              /* Lock 1 register */
  C55FMC_LOCK2_tag LOCK2;              /* Lock 2 register */
  C55FMC_LOCK3_tag LOCK3;              /* Lock 3 register */
  uint8_t C55FMC_reserved2[24];
  C55FMC_SEL0_tag SEL0;                /* Select 0 register */
  C55FMC_SEL1_tag SEL1;                /* Select 1 register */
  C55FMC_SEL2_tag SEL2;                /* Select 2 register */
  C55FMC_SEL3_tag SEL3;                /* Select 3 register */
  uint8_t C55FMC_reserved3[8];
  C55FMC_ADR_tag ADR;                  /* Address register */
  C55FMC_UT0_tag UT0;                  /* UTest 0 register */
  C55FMC_UM_tag UM[9];                 /* UMISR register */
  C55FMC_UM9_tag UM9;                  /* UMISR register */
  C55FMC_OPP0_tag OPP0;                /* Over-Program Protection 0 register */
  C55FMC_OPP1_tag OPP1;                /* Over-Program Protection 1 register */
  C55FMC_OPP2_tag OPP2;                /* Over-Program Protection 2 register */
  C55FMC_OPP3_tag OPP3;                /* Over-Program Protection 3 register */
};


/* ============================================================================
   =============================== Module: CAN ================================
   ============================================================================ */

typedef union CAN_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t  :1;
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SUPV:1;                  /* Supervisor Mode */
    vuint32_t  :1;
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t DMA:1;                   /* DMA Enable */
    vuint32_t  :1;
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t FDEN:1;                  /* CAN FD operation enable */
    vuint32_t  :1;
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t  :1;
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
  } B;
} CAN_MCR_tag;

typedef union CAN_CTRL1_union_tag {    /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t BOFFMSK:1;               /* Bus Off Interrupt Mask */
    vuint32_t ERRMSK:1;                /* Error Interrupt Mask */
    vuint32_t  :1;
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t PROPSEG:3;               /* Propagation Segment */
  } B;
} CAN_CTRL1_tag;

typedef union CAN_TIMER_union_tag {    /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TIMER:16;                /* Timer Value */
  } B;
} CAN_TIMER_tag;

typedef union CAN_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} CAN_RXMGMASK_tag;

typedef union CAN_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} CAN_RX14MASK_tag;

typedef union CAN_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} CAN_RX15MASK_tag;

typedef union CAN_ECR_union_tag {      /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t RXERRCNT_FAST:8;         /* Receive Error Counter for fast bits */
    vuint32_t TXERRCNT_FAST:8;         /* Transmit Error Counter for fast bits */
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
  } B;
} CAN_ECR_tag;

typedef union CAN_ESR1_union_tag {     /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t BIT1ERR_FAST:1;          /* Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BIT0ERR_FAST:1;          /* Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t  :1;
    vuint32_t CRCERR_FAST:1;           /* Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set */
    vuint32_t FRMERR_FAST:1;           /* Form Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t STFERR_FAST:1;           /* Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t  :4;
    vuint32_t ERROVR:1;                /* Error Overrun bit */
    vuint32_t ERRINT_FAST:1;           /* Error Interrupt for errors detected in the Data Phase of CAN FD frames with the BRS bit set */
    vuint32_t BOFFDONEINT:1;           /* Bus Off Done Interrupt */
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t IDLE:1;
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t  :1;
  } B;
} CAN_ESR1_tag;

typedef union CAN_IMASK2_union_tag {   /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32M:32;           /* Buffer MB i Mask */
  } B;
} CAN_IMASK2_tag;

typedef union CAN_IMASK1_union_tag {   /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO0M:32;            /* Buffer MB i Mask */
  } B;
} CAN_IMASK1_tag;

typedef union CAN_IFLAG2_union_tag {   /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUF63TO32I:32;           /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG2_tag;

typedef union CAN_IFLAG1_union_tag {   /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or "reserved" */
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or Clear FIFO bit */
  } B;
} CAN_IFLAG1_tag;

typedef union CAN_CTRL2_union_tag {    /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t ERRMSK_FAST:1;           /* Error Interrupt Mask for errors detected in the Data Phase of fast CAN FD frames */
    vuint32_t BOFFDONEMSK:1;           /* Bus Off Done Interrupt Mask */
    vuint32_t ECRWRE:1;                /* Error-correction Configuration Register Write Enable */
    vuint32_t WRMFRZ:1;                /* Write-Access To Memory In Freeze Mode */
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t  :1;
    vuint32_t  :15;
  } B;
} CAN_CTRL2_tag;

typedef union CAN_ESR2_union_tag {     /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t  :9;
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t  :1;
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t  :13;
  } B;
} CAN_ESR2_tag;

typedef union CAN_CRCR_union_tag {     /* CRC Register */
  vuint32_t R;
  struct {
    vuint32_t  :9;
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t  :1;
    vuint32_t TXCRC:15;                /* Transmitted CRC value */
  } B;
} CAN_CRCR_tag;

typedef union CAN_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} CAN_RXFGMASK_tag;

typedef union CAN_RXFIR_union_tag {    /* Rx FIFO Information Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
  } B;
} CAN_RXFIR_tag;

typedef union CAN_CBT_union_tag {      /* CAN Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t BTF:1;                   /* Bit Timing Format Enable */
    vuint32_t EPRESDIV:10;             /* Extended Prescaler Division Factor */
    vuint32_t  :1;
    vuint32_t ERJW:4;                  /* Extended Resync Jump Width */
    vuint32_t EPROPSEG:6;              /* Extended Propagation Segment */
    vuint32_t EPSEG1:5;                /* Extended Phase Segment 1 */
    vuint32_t EPSEG2:5;                /* Extended Phase Segment 2 */
  } B;
} CAN_CBT_tag;

typedef union CAN_IMASK3_union_tag {   /* Interrupt Masks 3 Register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64M:32;           /* Buffer MB i Mask */
  } B;
} CAN_IMASK3_tag;

typedef union CAN_IFLAG3_union_tag {   /* Interrupt Flags 3 Register */
  vuint32_t R;
  struct {
    vuint32_t BUF95TO64:32;            /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG3_tag;

typedef union CAN_MB_CS_union_tag {    /* Message Buffer 0 CS Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t CODE:4;                  /* Message Buffer Code */
    vuint32_t  :1;
    vuint32_t SRR:1;                   /* Substitute Remote Request. Contains a fixed recessive bit. */
    vuint32_t IDE:1;                   /* ID Extended. One/zero for extended/standard format frame. */
    vuint32_t RTR:1;                   /* Remote Transmission Request. One/zero for remote/data frame. */
    vuint32_t DLC:4;                   /* Length of the data to be stored/transmitted. */
    vuint32_t TIMESTAMP:16;            /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
  } B;
} CAN_MB_CS_tag;

typedef union CAN_MB_ID_union_tag {    /* Message Buffer 0 ID Register */
  vuint32_t R;
  struct {
    vuint32_t PRIO:3;                  /* Local Priority */
    vuint32_t ID_STD:11;               /* Frame Identifier Standard */
    vuint32_t ID_EXT:18;               /* Frame Identifier Extended */
  } B;
} CAN_MB_ID_tag;

typedef union CAN_MB_DATA_union_tag {
  vuint8_t B[8];
  vuint16_t H[4];
  vuint32_t W[2];
} CAN_MB_DATA_tag;

typedef struct CAN_MB_struct_tag {
  CAN_MB_CS_tag CS;                    /* Message Buffer 0 CS Register */
  CAN_MB_ID_tag ID;                    /* Message Buffer 0 ID Register */
  CAN_MB_DATA_tag DATA;
} CAN_MB_tag;

typedef union CAN_RXIMR_union_tag {    /* Rx Individual Mask Registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} CAN_RXIMR_tag;

typedef union CAN_MECR_union_tag {     /* Memory Error Control Register */
  vuint32_t R;
  struct {
    vuint32_t ECRWRDIS:1;              /* Error Configuration Register Write Disable */
    vuint32_t  :11;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t HAERRIE:1;               /* Host Access Error Injection Enable */
    vuint32_t FAERRIE:1;               /* FlexCAN Access Error Injection Enable */
    vuint32_t EXTERRIE:1;              /* Extended Error Injection Enable */
    vuint32_t  :3;
    vuint32_t RERRDIS:1;               /* Error Report Disable */
    vuint32_t ECCDIS:1;                /* Error Correction Disable */
    vuint32_t NCEFAFRZ:1;              /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
    vuint32_t  :7;
  } B;
} CAN_MECR_tag;

typedef union CAN_ERRIAR_union_tag {   /* Error Injection Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t INJADDR:14;              /* Error Injection Address */
  } B;
} CAN_ERRIAR_tag;

typedef union CAN_ERRIDPR_union_tag {  /* Error Injection Data Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data flip pattern */
  } B;
} CAN_ERRIDPR_tag;

typedef union CAN_ERRIPPR_union_tag {  /* Error Injection Parity Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t PFLIP3:5;                /* Parity Flip Pattern For Byte 3 (most significant) */
    vuint32_t  :3;
    vuint32_t PFLIP2:5;                /* Parity Flip Pattern For Byte 2 */
    vuint32_t  :3;
    vuint32_t PFLIP1:5;                /* Parity Flip Pattern For Byte 1 */
    vuint32_t  :3;
    vuint32_t PFLIP0:5;                /* Parity Flip Pattern For Byte 0 (Least Significant) */
  } B;
} CAN_ERRIPPR_tag;

typedef union CAN_RERRAR_union_tag {   /* Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t NCE:1;                   /* Non-Correctable Error */
    vuint32_t  :5;
    vuint32_t SAID:3;
    vuint32_t  :2;
    vuint32_t ERRADDR:14;              /* Address Where The Error Was Detected */
  } B;
} CAN_RERRAR_tag;

typedef union CAN_RERRDR_union_tag {   /* Error Report Data Register */
  vuint32_t R;
  struct {
    vuint32_t RDATA:32;                /* Raw data word read from memory with error */
  } B;
} CAN_RERRDR_tag;

typedef union CAN_RERRSYNR_union_tag { /* Error Report Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t BE3:1;                   /* Byte Enabled For Byte 3 (Most Significant) */
    vuint32_t  :2;
    vuint32_t SYND3:5;                 /* Error Syndrome For Byte 3 (Most Significant) */
    vuint32_t BE2:1;                   /* Byte Enabled For Byte 2 */
    vuint32_t  :2;
    vuint32_t SYND2:5;                 /* Error Syndrome For Byte 2 */
    vuint32_t BE1:1;                   /* Byte Enabled For Byte 1 */
    vuint32_t  :2;
    vuint32_t SYND1:5;                 /* Error Syndrome for Byte 1 */
    vuint32_t BE0:1;                   /* Byte Enabled For Byte 0 (least significant) */
    vuint32_t  :2;
    vuint32_t SYND0:5;                 /* Error Syndrome For Byte 0 (least significant) */
  } B;
} CAN_RERRSYNR_tag;

typedef union CAN_ERRSR_union_tag {    /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t HANCEIF:1;               /* Host Access With Non-Correctable Error Interrupt Flag */
    vuint32_t FANCEIF:1;               /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
    vuint32_t  :1;
    vuint32_t CEIF:1;                  /* Correctable Error Interrupt Flag */
    vuint32_t  :12;
    vuint32_t HANCEIOF:1;              /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t FANCEIOF:1;              /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t  :1;
    vuint32_t CEIOF:1;                 /* Correctable Error Interrupt Overrun Flag */
  } B;
} CAN_ERRSR_tag;

typedef union CAN_FDCTRL_union_tag {   /* CAN FD Control Register */
  vuint32_t R;
  struct {
    vuint32_t FDRATE:1;                /* Bit Rate Switch Enable */
    vuint32_t  :4;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t MBDSR2:2;                /* Message Buffer Data Size for Region 2 */
    vuint32_t  :1;
    vuint32_t MBDSR1:2;                /* Message Buffer Data Size for Region 1 */
    vuint32_t  :1;
    vuint32_t MBDSR0:2;                /* Message Buffer Data Size for Region 0 */
    vuint32_t TDCEN:1;                 /* Transceiver Delay Compensation Enable */
    vuint32_t TDCFAIL:1;               /* Transceiver Delay Compensation Fail */
    vuint32_t  :1;
    vuint32_t TDCOFF:5;                /* Transceiver Delay Compensation Offset */
    vuint32_t  :2;
    vuint32_t TDCVAL:6;                /* Transceiver Delay Compensation Value */
  } B;
} CAN_FDCTRL_tag;

typedef union CAN_FDCBT_union_tag {    /* CAN FD Bit Timing Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t FPRESDIV:10;             /* Fast Prescaler Division Factor */
    vuint32_t  :2;
    vuint32_t FRJW:2;                  /* Fast Resync Jump Width */
    vuint32_t  :1;
    vuint32_t FPROPSEG:5;              /* Fast Propagation Segment */
    vuint32_t  :2;
    vuint32_t FPSEG1:3;                /* Fast Phase Segment 1 */
    vuint32_t  :2;
    vuint32_t FPSEG2:3;                /* Fast Phase Segment 2 */
  } B;
} CAN_FDCBT_tag;

typedef union CAN_FDCRC_union_tag {    /* CAN FD CRC Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t FD_MBCRC:7;              /* CRC Mailbox Number for FD_TXCRC */
    vuint32_t  :3;
    vuint32_t FD_TXCRC:21;             /* Extended Transmitted CRC value */
  } B;
} CAN_FDCRC_tag;

struct CAN_tag {
  CAN_MCR_tag MCR;                     /* Module Configuration Register */
  CAN_CTRL1_tag CTRL1;                 /* Control 1 register */
  CAN_TIMER_tag TIMER;                 /* Free Running Timer */
  uint8_t CAN_reserved0[4];
  CAN_RXMGMASK_tag RXMGMASK;           /* Rx Mailboxes Global Mask Register */
  CAN_RX14MASK_tag RX14MASK;           /* Rx 14 Mask register */
  CAN_RX15MASK_tag RX15MASK;           /* Rx 15 Mask register */
  CAN_ECR_tag ECR;                     /* Error Counter */
  CAN_ESR1_tag ESR1;                   /* Error and Status 1 register */
  CAN_IMASK2_tag IMASK2;               /* Interrupt Masks 2 register */
  CAN_IMASK1_tag IMASK1;               /* Interrupt Masks 1 register */
  CAN_IFLAG2_tag IFLAG2;               /* Interrupt Flags 2 register */
  CAN_IFLAG1_tag IFLAG1;               /* Interrupt Flags 1 register */
  CAN_CTRL2_tag CTRL2;                 /* Control 2 register */
  CAN_ESR2_tag ESR2;                   /* Error and Status 2 register */
  uint8_t CAN_reserved1[8];
  CAN_CRCR_tag CRCR;                   /* CRC Register */
  CAN_RXFGMASK_tag RXFGMASK;           /* Rx FIFO Global Mask register */
  CAN_RXFIR_tag RXFIR;                 /* Rx FIFO Information Register */
  CAN_CBT_tag CBT;                     /* CAN Bit Timing Register */
  uint8_t CAN_reserved2[24];
  CAN_IMASK3_tag IMASK3;               /* Interrupt Masks 3 Register */
  uint8_t CAN_reserved3[4];
  CAN_IFLAG3_tag IFLAG3;               /* Interrupt Flags 3 Register */
  uint8_t CAN_reserved4[8];
  CAN_MB_tag MB[64];
  uint8_t CAN_reserved5[1024];
  CAN_RXIMR_tag RXIMR[96];             /* Rx Individual Mask Registers */
  uint8_t CAN_reserved6[224];
  CAN_MECR_tag MECR;                   /* Memory Error Control Register */
  CAN_ERRIAR_tag ERRIAR;               /* Error Injection Address Register */
  CAN_ERRIDPR_tag ERRIDPR;             /* Error Injection Data Pattern Register */
  CAN_ERRIPPR_tag ERRIPPR;             /* Error Injection Parity Pattern Register */
  CAN_RERRAR_tag RERRAR;               /* Error Report Address Register */
  CAN_RERRDR_tag RERRDR;               /* Error Report Data Register */
  CAN_RERRSYNR_tag RERRSYNR;           /* Error Report Syndrome Register */
  CAN_ERRSR_tag ERRSR;                 /* Error Status Register */
  uint8_t CAN_reserved7[256];
  CAN_FDCTRL_tag FDCTRL;               /* CAN FD Control Register */
  CAN_FDCBT_tag FDCBT;                 /* CAN FD Bit Timing Register */
  CAN_FDCRC_tag FDCRC;                 /* CAN FD CRC Register */
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

typedef union CMU_CSR_union_tag {      /* CMU Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t SFM:1;                   /* Start frequency measure. */
    vuint32_t  :13;
    vuint32_t CKSEL1:2;                /* Frequency measure clock selection bit. */
    vuint32_t  :5;
    vuint32_t RCDIV:2;                 /* CLKMT0_RMN division factor. */
    vuint32_t CME:1;                   /* CLKMN1 monitor enable. */
  } B;
} CMU_CSR_tag;

typedef union CMU_FDR_union_tag {      /* CMU Frequency Display Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t FD:20;                   /* Measured frequency bits. */
  } B;
} CMU_FDR_tag;

typedef union CMU_HFREFR_union_tag {   /* CMU High Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t HFREF:12;                /* High Frequency reference value. */
  } B;
} CMU_HFREFR_tag;

typedef union CMU_LFREFR_union_tag {   /* CMU Low Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t LFREF:12;                /* Low Frequency reference value. */
  } B;
} CMU_LFREFR_tag;

typedef union CMU_ISR_union_tag {      /* CMU Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t  :1;
    vuint32_t FHHI:1;                  /* CLKMN1 frequency higher than high reference event status. */
    vuint32_t FLLI:1;                  /* CLKMN1 frequency less than low reference event status. */
    vuint32_t OLRI:1;                  /* Oscillator frequency less than f CLKMT0_RMN * 2RCDIVevent status. */
  } B;
} CMU_ISR_tag;

typedef union CMU_MDR_union_tag {      /* CMU Measurement Duration Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t MD:20;                   /* Measurement duration bits */
  } B;
} CMU_MDR_tag;

struct CMU_tag {
  CMU_CSR_tag CSR;                     /* CMU Control Status Register */
  CMU_FDR_tag FDR;                     /* CMU Frequency Display Register */
  CMU_HFREFR_tag HFREFR;               /* CMU High Frequency Reference Register CLKMN1 */
  CMU_LFREFR_tag LFREFR;               /* CMU Low Frequency Reference Register CLKMN1 */
  CMU_ISR_tag ISR;                     /* CMU Interrupt Status Register */
  uint8_t CMU_reserved0[4];
  CMU_MDR_tag MDR;                     /* CMU Measurement Duration Register */
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

typedef union CRC_CFG_union_tag {      /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t  :18;
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t INV:1;                   /* Inversion selection */
  } B;
} CRC_CFG_tag;

typedef union CRC_INP_union_tag {      /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_INP_tag;

typedef union CRC_CSTAT_union_tag {    /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CSTAT_tag;

typedef union CRC_OUTP_union_tag {     /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_OUTP_tag;

struct CRC_tag {
  CRC_CFG_tag CFG;                     /* Configuration Register */
  CRC_INP_tag INP;                     /* Input Register */
  CRC_CSTAT_tag CSTAT;                 /* Current Status Register */
  CRC_OUTP_tag OUTP;                   /* Output Register */
};


/* ============================================================================
   =============================== Module: DECFILTER ==========================
   ============================================================================ */

typedef union DECFILTER_MCR_union_tag { /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FREN:1;                  /* Freeze Enable */
    vuint32_t  :1;
    vuint32_t FRZ:1;                   /* Freeze Mode */
    vuint32_t SRES:1;                  /* Software-reset bit */
    vuint32_t CASCD:2;                 /* Cascade Mode Configuration */
    vuint32_t IDEN:1;                  /* Input Data Interrupt Enable */
    vuint32_t ODEN:1;                  /* Output Data Interrupt Enable */
    vuint32_t ERREN:1;                 /* Error Interrupt Enable */
    vuint32_t  :1;
    vuint32_t FTYPE:2;                 /* Filter Type Selection bits */
    vuint32_t  :1;
    vuint32_t SCAL:2;                  /* Filter Scaling Factor */
    vuint32_t IDIS:1;                  /* Input Disable */
    vuint32_t SAT:1;                   /* Saturation Enable */
    vuint32_t ISEL:1;                  /* Input Selection */
    vuint32_t  :1;
    vuint32_t DEC_RATE:4;              /* Decimation Rate Selection */
    vuint32_t SDIE:1;                  /* Integrator Data Interrupt Enable */
    vuint32_t DSEL:1;                  /* DMA Selection */
    vuint32_t IBIE:1;                  /* Input Buffer Interrupt Request Enable */
    vuint32_t OBIE:1;                  /* Output Buffer Interrupt Request Enable */
    vuint32_t  :4;
  } B;
} DECFILTER_MCR_tag;

typedef union DECFILTER_MSR_union_tag { /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t BSY:1;                   /* Decimation Filter Busy indication */
    vuint32_t  :1;
    vuint32_t DEC_COUNTER:4;           /* Decimation Counter */
    vuint32_t IDFC:1;                  /* Input Data Flag Clear bit */
    vuint32_t ODFC:1;                  /* Output Data Flag Clear bit */
    vuint32_t  :1;
    vuint32_t IBIC:1;                  /* Input Buffer Interrupt Request Clear bit */
    vuint32_t OBIC:1;                  /* Output Buffer Interrupt Request Clear bit */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t OVFC:1;                  /* OVF Clear bit */
    vuint32_t OVRC:1;                  /* OVR Clear bit */
    vuint32_t IVRC:1;                  /* IVR Clear bit */
    vuint32_t  :6;
    vuint32_t IDF:1;                   /* Input Data Flag */
    vuint32_t ODF:1;                   /* Output Data Flag */
    vuint32_t  :1;
    vuint32_t IBIF:1;                  /* Input Buffer Interrupt Request Flag */
    vuint32_t OBIF:1;                  /* Output Buffer Interrupt Request Flag */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t OVF:1;                   /* Filter Overflow Flag */
    vuint32_t OVR:1;                   /* Output Interface Buffer Overrun */
    vuint32_t IVR:1;                   /* Input Interface Buffer Overrun */
  } B;
} DECFILTER_MSR_tag;

typedef union DECFILTER_MXCR_union_tag { /* Module Extended Config Register */
  vuint32_t R;
  struct {
    vuint32_t SDMAE:1;                 /* Integrator DMA Enable */
    vuint32_t SSIG:1;                  /* Integrator Signal operation selection */
    vuint32_t SSAT:1;                  /* Integrator Saturated operation selection */
    vuint32_t SCSAT:1;                 /* Integrator Counter Saturated operation selection */
    vuint32_t  :10;
    vuint32_t SRQ:1;                   /* Integrator Output Request */
    vuint32_t SZRO:1;                  /* Integrator Zero */
    vuint32_t SISEL:1;                 /* Integrator Input Selection */
    vuint32_t  :1;
    vuint32_t SZROSEL:2;               /* Integrator Zero Control Mode Selection */
    vuint32_t  :2;
    vuint32_t SHLTSEL:2;               /* Integrator Halt Control Selection */
    vuint32_t  :1;
    vuint32_t SRQSEL:3;                /* Integrator Output Read Request Mode Selection */
    vuint32_t  :2;
    vuint32_t SENSEL:2;                /* Integrator Enable Control Selection */
  } B;
} DECFILTER_MXCR_tag;

typedef union DECFILTER_MXSR_union_tag { /* Module Extended Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t SDFC:1;                  /* Integrator Output Data Flag Clear bit */
    vuint32_t  :2;
    vuint32_t SSEC:1;                  /* Integrator Sum Exception Clear bit */
    vuint32_t SCEC:1;                  /* Integrator Count Exception Clear bit */
    vuint32_t  :1;
    vuint32_t SSOVFC:1;                /* Integrator Sum Overflow Clear bit */
    vuint32_t SCOVFC:1;                /* Integrator Count Overflow Clear bit */
    vuint32_t SVRC:1;                  /* SVR Clear bit */
    vuint32_t  :7;
    vuint32_t SDF:1;                   /* Integrator Data Flag */
    vuint32_t  :2;
    vuint32_t SSE:1;                   /* Integrator Sum Exception flag */
    vuint32_t SCE:1;                   /* Integrator Count Exception flag */
    vuint32_t  :1;
    vuint32_t SSOVF:1;                 /* Integrator Sum Overflow Flag */
    vuint32_t SCOVF:1;                 /* Integrator Count Overflow Flag */
    vuint32_t SVR:1;                   /* Integrator Data Overrun */
  } B;
} DECFILTER_MXSR_tag;

typedef union DECFILTER_IB_union_tag { /* Interface Input Buffer */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t INTAG:4;                 /* Decimation filter input tag bits */
    vuint32_t  :6;
    vuint32_t PREFILL:1;               /* Decimation Filter Prefill/Filter control bit */
    vuint32_t FLUSH:1;                 /* Decimation Filter Flush control bit */
    vuint32_t INPBUF:16;               /* Input Buffer Data */
  } B;
} DECFILTER_IB_tag;

typedef union DECFILTER_OB_union_tag { /* Interface Output Buffer */
  vuint32_t R;
  struct {
    vuint32_t  :11;
    vuint32_t  :1;
    vuint32_t OUTTAG:4;                /* Decimation filter output tag bits */
    vuint32_t OUTBUF:16;               /* Output Buffer Data */
  } B;
} DECFILTER_OB_tag;

typedef union DECFILTER_COEF_union_tag { /* Filter Coefficient */
  vuint32_t R;
  struct {
    vuint32_t COEFnSIGNR:8;            /* COEFn sign repeated */
    vuint32_t COEFn:24;                /* Coefficient n field */
  } B;
} DECFILTER_COEF_tag;

typedef union DECFILTER_TAP_union_tag { /* Filter TAP */
  vuint32_t R;
  struct {
    vuint32_t TAPnSIGNR:8;             /* TAPn sign repeated */
    vuint32_t TAPn:24;                 /* TAPn Register */
  } B;
} DECFILTER_TAP_tag;

typedef union DECFILTER_FINTVAL_union_tag { /* Final Integer Value Register */
  vuint32_t R;
  struct {
    vuint32_t SUM_VALUE:32;            /* Integration Sum Value */
  } B;
} DECFILTER_FINTVAL_tag;

typedef union DECFILTER_FINTCNT_union_tag { /* Final Integer Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Integration Count Value */
  } B;
} DECFILTER_FINTCNT_tag;

typedef union DECFILTER_CINTVAL_union_tag { /* Current Integer Value Register */
  vuint32_t R;
  struct {
    vuint32_t SUM_VALUE:32;            /* Integration Sum Value */
  } B;
} DECFILTER_CINTVAL_tag;

typedef union DECFILTER_CINTCNT_union_tag { /* Current Integer Count Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT:32;                /* Integration Count Value */
  } B;
} DECFILTER_CINTCNT_tag;

struct DECFILTER_tag {
  DECFILTER_MCR_tag MCR;               /* Module Configuration Register */
  DECFILTER_MSR_tag MSR;               /* Module Status Register */
  DECFILTER_MXCR_tag MXCR;             /* Module Extended Config Register */
  DECFILTER_MXSR_tag MXSR;             /* Module Extended Status Register */
  DECFILTER_IB_tag IB;                 /* Interface Input Buffer */
  DECFILTER_OB_tag OB;                 /* Interface Output Buffer */
  uint8_t DECFILTER_reserved0[8];
  DECFILTER_COEF_tag COEF[9];          /* Filter Coefficient */
  uint8_t DECFILTER_reserved1[52];
  DECFILTER_TAP_tag TAP[8];            /* Filter TAP */
  uint8_t DECFILTER_reserved2[72];
  DECFILTER_FINTVAL_tag FINTVAL;       /* Final Integer Value Register */
  DECFILTER_FINTCNT_tag FINTCNT;       /* Final Integer Count Register */
  DECFILTER_CINTVAL_tag CINTVAL;       /* Current Integer Value Register */
  DECFILTER_CINTCNT_tag CINTCNT;       /* Current Integer Count Register */
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

typedef union DMA_CR_union_tag {       /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t CX:1;                    /* Cancel Transfer */
    vuint32_t ECX:1;                   /* Error Cancel Transfer */
    vuint32_t GRP3PRI:2;               /* Channel Group 3 Priority */
    vuint32_t GRP2PRI:2;               /* Channel Group 2 Priority */
    vuint32_t GRP1PRI:2;               /* Channel Group 1 Priority */
    vuint32_t GRP0PRI:2;               /* Channel Group 0 Priority */
    vuint32_t EMLM:1;                  /* Enable Minor Loop Mapping. */
    vuint32_t CLM:1;                   /* Continuous Link Mode */
    vuint32_t HALT:1;                  /* Halt DMA Operations */
    vuint32_t HOE:1;                   /* Halt On Error */
    vuint32_t ERGA:1;                  /* Enable Round Robin Group Arbitration */
    vuint32_t ERCA:1;                  /* Enable Round Robin Channel Arbitration */
    vuint32_t EDBG:1;                  /* Enable Debug */
    vuint32_t EBW:1;                   /* Enable Buffered Writes */
  } B;
} DMA_CR_tag;

typedef union DMA_ES_union_tag {       /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :13;
    vuint32_t UCE:1;                   /* Uncorrectable ECC error during channel execution. */
    vuint32_t ECX:1;                   /* Transfer Canceled. */
    vuint32_t GPE:1;                   /* Group Priority Error. */
    vuint32_t CPE:1;                   /* Channel Priority Error. */
    vuint32_t ERRCHN:6;                /* Error/Cancelled Channel Number. */
    vuint32_t SAE:1;                   /* Source Address Error. */
    vuint32_t SOE:1;                   /* Source Offset Error */
    vuint32_t DAE:1;                   /* Destination Address Error. */
    vuint32_t DOE:1;                   /* Destination Offset Error. */
    vuint32_t NCE:1;                   /* NBYTES/CITER Configuration Error. */
    vuint32_t SGE:1;                   /* Scatter/Gather Configuration Error. */
    vuint32_t SBE:1;                   /* Source Bus Error. */
    vuint32_t DBE:1;                   /* Destination Bus Error. */
  } B;
} DMA_ES_tag;

typedef union DMA_ERQH_union_tag {     /* Enable Request Register High */
  vuint32_t R;
  struct {
    vuint32_t ERQ63:1;                 /* Enable DMA Request 63 */
    vuint32_t ERQ62:1;                 /* Enable DMA Request 62 */
    vuint32_t ERQ61:1;                 /* Enable DMA Request 61 */
    vuint32_t ERQ60:1;                 /* Enable DMA Request 60 */
    vuint32_t ERQ59:1;                 /* Enable DMA Request 59 */
    vuint32_t ERQ58:1;                 /* Enable DMA Request 58 */
    vuint32_t ERQ57:1;                 /* Enable DMA Request 57 */
    vuint32_t ERQ56:1;                 /* Enable DMA Request 56 */
    vuint32_t ERQ55:1;                 /* Enable DMA Request 55 */
    vuint32_t ERQ54:1;                 /* Enable DMA Request 54 */
    vuint32_t ERQ53:1;                 /* Enable DMA Request 53 */
    vuint32_t ERQ52:1;                 /* Enable DMA Request 52 */
    vuint32_t ERQ51:1;                 /* Enable DMA Request 51 */
    vuint32_t ERQ50:1;                 /* Enable DMA Request 50 */
    vuint32_t ERQ49:1;                 /* Enable DMA Request 49 */
    vuint32_t ERQ48:1;                 /* Enable DMA Request 48 */
    vuint32_t ERQ47:1;                 /* Enable DMA Request 47 */
    vuint32_t ERQ46:1;                 /* Enable DMA Request 46 */
    vuint32_t ERQ45:1;                 /* Enable DMA Request 45 */
    vuint32_t ERQ44:1;                 /* Enable DMA Request 44 */
    vuint32_t ERQ43:1;                 /* Enable DMA Request 43 */
    vuint32_t ERQ42:1;                 /* Enable DMA Request 42 */
    vuint32_t ERQ41:1;                 /* Enable DMA Request 41 */
    vuint32_t ERQ40:1;                 /* Enable DMA Request 40 */
    vuint32_t ERQ39:1;                 /* Enable DMA Request 39 */
    vuint32_t ERQ38:1;                 /* Enable DMA Request 38 */
    vuint32_t ERQ37:1;                 /* Enable DMA Request 37 */
    vuint32_t ERQ36:1;                 /* Enable DMA Request 36 */
    vuint32_t ERQ35:1;                 /* Enable DMA Request 35 */
    vuint32_t ERQ34:1;                 /* Enable DMA Request 34 */
    vuint32_t ERQ33:1;                 /* Enable DMA Request 33 */
    vuint32_t ERQ32:1;                 /* Enable DMA Request 32 */
  } B;
} DMA_ERQH_tag;

typedef union DMA_ERQL_union_tag {     /* Enable Request Register Low */
  vuint32_t R;
  struct {
    vuint32_t ERQ31:1;                 /* Enable DMA Request 31 */
    vuint32_t ERQ30:1;                 /* Enable DMA Request 30 */
    vuint32_t ERQ29:1;                 /* Enable DMA Request 29 */
    vuint32_t ERQ28:1;                 /* Enable DMA Request 28 */
    vuint32_t ERQ27:1;                 /* Enable DMA Request 27 */
    vuint32_t ERQ26:1;                 /* Enable DMA Request 26 */
    vuint32_t ERQ25:1;                 /* Enable DMA Request 25 */
    vuint32_t ERQ24:1;                 /* Enable DMA Request 24 */
    vuint32_t ERQ23:1;                 /* Enable DMA Request 23 */
    vuint32_t ERQ22:1;                 /* Enable DMA Request 22 */
    vuint32_t ERQ21:1;                 /* Enable DMA Request 21 */
    vuint32_t ERQ20:1;                 /* Enable DMA Request 20 */
    vuint32_t ERQ19:1;                 /* Enable DMA Request 19 */
    vuint32_t ERQ18:1;                 /* Enable DMA Request 18 */
    vuint32_t ERQ17:1;                 /* Enable DMA Request 17 */
    vuint32_t ERQ16:1;                 /* Enable DMA Request 16 */
    vuint32_t ERQ15:1;                 /* Enable DMA Request 15 */
    vuint32_t ERQ14:1;                 /* Enable DMA Request 14 */
    vuint32_t ERQ13:1;                 /* Enable DMA Request 13 */
    vuint32_t ERQ12:1;                 /* Enable DMA Request 12 */
    vuint32_t ERQ11:1;                 /* Enable DMA Request 11 */
    vuint32_t ERQ10:1;                 /* Enable DMA Request 10 */
    vuint32_t ERQ9:1;                  /* Enable DMA Request 9 */
    vuint32_t ERQ8:1;                  /* Enable DMA Request 8 */
    vuint32_t ERQ7:1;                  /* Enable DMA Request 7 */
    vuint32_t ERQ6:1;                  /* Enable DMA Request 6 */
    vuint32_t ERQ5:1;                  /* Enable DMA Request 5 */
    vuint32_t ERQ4:1;                  /* Enable DMA Request 4 */
    vuint32_t ERQ3:1;                  /* Enable DMA Request 3 */
    vuint32_t ERQ2:1;                  /* Enable DMA Request 2 */
    vuint32_t ERQ1:1;                  /* Enable DMA Request 1 */
    vuint32_t ERQ0:1;                  /* Enable DMA Request 0 */
  } B;
} DMA_ERQL_tag;

typedef union DMA_EEIH_union_tag {     /* Enable Error Interrupt Register High */
  vuint32_t R;
  struct {
    vuint32_t EEI63:1;                 /* Enable Error Interrupt 63 */
    vuint32_t EEI62:1;                 /* Enable Error Interrupt 62 */
    vuint32_t EEI61:1;                 /* Enable Error Interrupt 61 */
    vuint32_t EEI60:1;                 /* Enable Error Interrupt 60 */
    vuint32_t EEI59:1;                 /* Enable Error Interrupt 59 */
    vuint32_t EEI58:1;                 /* Enable Error Interrupt 58 */
    vuint32_t EEI57:1;                 /* Enable Error Interrupt 57 */
    vuint32_t EEI56:1;                 /* Enable Error Interrupt 56 */
    vuint32_t EEI55:1;                 /* Enable Error Interrupt 55 */
    vuint32_t EEI54:1;                 /* Enable Error Interrupt 54 */
    vuint32_t EEI53:1;                 /* Enable Error Interrupt 53 */
    vuint32_t EEI52:1;                 /* Enable Error Interrupt 52 */
    vuint32_t EEI51:1;                 /* Enable Error Interrupt 51 */
    vuint32_t EEI50:1;                 /* Enable Error Interrupt 50 */
    vuint32_t EEI49:1;                 /* Enable Error Interrupt 49 */
    vuint32_t EEI48:1;                 /* Enable Error Interrupt 48 */
    vuint32_t EEI47:1;                 /* Enable Error Interrupt 47 */
    vuint32_t EEI46:1;                 /* Enable Error Interrupt 46 */
    vuint32_t EEI45:1;                 /* Enable Error Interrupt 45 */
    vuint32_t EEI44:1;                 /* Enable Error Interrupt 44 */
    vuint32_t EEI43:1;                 /* Enable Error Interrupt 43 */
    vuint32_t EEI42:1;                 /* Enable Error Interrupt 42 */
    vuint32_t EEI41:1;                 /* Enable Error Interrupt 41 */
    vuint32_t EEI40:1;                 /* Enable Error Interrupt 40 */
    vuint32_t EEI39:1;                 /* Enable Error Interrupt 39 */
    vuint32_t EEI38:1;                 /* Enable ErrorInterrupt 38 */
    vuint32_t EEI37:1;                 /* Enable Error Interrupt 37 */
    vuint32_t EEI36:1;                 /* Enable Error Interrupt 36 */
    vuint32_t EEI35:1;                 /* Enable Error Interrupt 35 */
    vuint32_t EEI34:1;                 /* Enable Error Interrupt 34 */
    vuint32_t EEI33:1;                 /* Enable Error Interrupt 33 */
    vuint32_t EEI32:1;                 /* Enable Error Interrupt 32 */
  } B;
} DMA_EEIH_tag;

typedef union DMA_EEIL_union_tag {     /* Enable Error Interrupt Register Low */
  vuint32_t R;
  struct {
    vuint32_t EEI31:1;                 /* Enable Error Interrupt 31 */
    vuint32_t EEI30:1;                 /* Enable Error Interrupt 30 */
    vuint32_t EEI29:1;                 /* Enable Error Interrupt 29 */
    vuint32_t EEI28:1;                 /* Enable Error Interrupt 28 */
    vuint32_t EEI27:1;                 /* Enable Error Interrupt 27 */
    vuint32_t EEI26:1;                 /* Enable Error Interrupt 26 */
    vuint32_t EEI25:1;                 /* Enable Error Interrupt 25 */
    vuint32_t EEI24:1;                 /* Enable Error Interrupt 24 */
    vuint32_t EEI23:1;                 /* Enable Error Interrupt 23 */
    vuint32_t EEI22:1;                 /* Enable Error Interrupt 22 */
    vuint32_t EEI21:1;                 /* Enable Error Interrupt 21 */
    vuint32_t EEI20:1;                 /* Enable Error Interrupt 20 */
    vuint32_t EEI19:1;                 /* Enable Error Interrupt 19 */
    vuint32_t EEI18:1;                 /* Enable Error Interrupt 18 */
    vuint32_t EEI17:1;                 /* Enable Error Interrupt 17 */
    vuint32_t EEI16:1;                 /* Enable Error Interrupt 16 */
    vuint32_t EEI15:1;                 /* Enable Error Interrupt 15 */
    vuint32_t EEI14:1;                 /* Enable Error Interrupt 14 */
    vuint32_t EEI13:1;                 /* Enable Error Interrupt 13 */
    vuint32_t EEI12:1;                 /* Enable Error Interrupt 12 */
    vuint32_t EEI11:1;                 /* Enable Error Interrupt 11 */
    vuint32_t EEI10:1;                 /* Enable Error Interrupt 10 */
    vuint32_t EEI9:1;                  /* Enable Error Interrupt 9 */
    vuint32_t EEI8:1;                  /* Enable Error Interrupt 8 */
    vuint32_t EEI7:1;                  /* Enable Error Interrupt 7 */
    vuint32_t EEI6:1;                  /* Enable ErrorInterrupt 6 */
    vuint32_t EEI5:1;                  /* Enable Error Interrupt 5 */
    vuint32_t EEI4:1;                  /* Enable Error Interrupt 4 */
    vuint32_t EEI3:1;                  /* Enable Error Interrupt 3 */
    vuint32_t EEI2:1;                  /* Enable Error Interrupt 2 */
    vuint32_t EEI1:1;                  /* Enable Error Interrupt 1 */
    vuint32_t EEI0:1;                  /* Enable Error Interrupt 0 */
  } B;
} DMA_EEIL_tag;

typedef union DMA_SERQ_union_tag {     /* Set Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SERQ:7;                   /* Set Enable Request. */
  } B;
} DMA_SERQ_tag;

typedef union DMA_CERQ_union_tag {     /* Clear Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable. */
    vuint8_t CERQ:7;                   /* Clear enable request. */
  } B;
} DMA_CERQ_tag;

typedef union DMA_SEEI_union_tag {     /* Set Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SEEI:7;                   /* Set enable error interrupt */
  } B;
} DMA_SEEI_tag;

typedef union DMA_CEEI_union_tag {     /* Clear Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CEEI:7;                   /* Clear Enable Error Interrupt. */
  } B;
} DMA_CEEI_tag;

typedef union DMA_CINT_union_tag {     /* Clear Interrupt Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable. */
    vuint8_t CINT:7;                   /* Clear Interrupt Request. */
  } B;
} DMA_CINT_tag;

typedef union DMA_CERR_union_tag {     /* Clear Error Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable. */
    vuint8_t CERR:7;                   /* Clear Error Indicator. */
  } B;
} DMA_CERR_tag;

typedef union DMA_SSRT_union_tag {     /* Set START Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable. */
    vuint8_t SSRT:7;                   /* Set START Bit */
  } B;
} DMA_SSRT_tag;

typedef union DMA_CDNE_union_tag {     /* Clear DONE Status Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable. */
    vuint8_t CDNE:7;                   /* Clear DONE Status Bit. */
  } B;
} DMA_CDNE_tag;

typedef union DMA_INTH_union_tag {     /* Interrupt Request Register High */
  vuint32_t R;
  struct {
    vuint32_t INT63:1;                 /* Interrupt Request 63 */
    vuint32_t INT62:1;                 /* Interrupt Request 62 */
    vuint32_t INT61:1;                 /* Interrupt Request 61 */
    vuint32_t INT60:1;                 /* Interrupt Request 60 */
    vuint32_t INT59:1;                 /* Interrupt Request 59 */
    vuint32_t INT58:1;                 /* Interrupt Request 58 */
    vuint32_t INT57:1;                 /* Interrupt Request 57 */
    vuint32_t INT56:1;                 /* Interrupt Request 56 */
    vuint32_t INT55:1;                 /* Interrupt Request 55 */
    vuint32_t INT54:1;                 /* Interrupt Request 54 */
    vuint32_t INT53:1;                 /* Interrupt Request 53 */
    vuint32_t INT52:1;                 /* Interrupt Request 52 */
    vuint32_t INT51:1;                 /* Interrupt Request 51 */
    vuint32_t INT50:1;                 /* Interrupt Request 50 */
    vuint32_t INT49:1;                 /* Interrupt Request 49 */
    vuint32_t INT48:1;                 /* Interrupt Request 48 */
    vuint32_t INT47:1;                 /* Interrupt Request 47 */
    vuint32_t INT46:1;                 /* Interrupt Request 46 */
    vuint32_t INT45:1;                 /* Interrupt Request 45 */
    vuint32_t INT44:1;                 /* Interrupt Request 44 */
    vuint32_t INT43:1;                 /* Interrupt Request 43 */
    vuint32_t INT42:1;                 /* Interrupt Request 42 */
    vuint32_t INT41:1;                 /* Interrupt Request 41 */
    vuint32_t INT40:1;                 /* Interrupt Request 40 */
    vuint32_t INT39:1;                 /* Interrupt Request 30 */
    vuint32_t INT38:1;                 /* Interrupt Request 38 */
    vuint32_t INT37:1;                 /* Interrupt Request 37 */
    vuint32_t INT36:1;                 /* Interrupt Request 36 */
    vuint32_t INT35:1;                 /* Interrupt Request 35 */
    vuint32_t INT34:1;                 /* Interrupt Request 34 */
    vuint32_t INT33:1;                 /* Interrupt Request 33 */
    vuint32_t INT32:1;                 /* Interrupt Request 32 */
  } B;
} DMA_INTH_tag;

typedef union DMA_INTL_union_tag {     /* Interrupt Request Register Low */
  vuint32_t R;
  struct {
    vuint32_t INT31:1;                 /* Interrupt Request 31 */
    vuint32_t INT30:1;                 /* Interrupt Request 30 */
    vuint32_t INT29:1;                 /* Interrupt Request 29 */
    vuint32_t INT28:1;                 /* Interrupt Request 28 */
    vuint32_t INT27:1;                 /* Interrupt Request 27 */
    vuint32_t INT26:1;                 /* Interrupt Request 26 */
    vuint32_t INT25:1;                 /* Interrupt Request 25 */
    vuint32_t INT24:1;                 /* Interrupt Request 24 */
    vuint32_t INT23:1;                 /* Interrupt Request 23 */
    vuint32_t INT22:1;                 /* Interrupt Request 22 */
    vuint32_t INT21:1;                 /* Interrupt Request 21 */
    vuint32_t INT20:1;                 /* Interrupt Request 20 */
    vuint32_t INT19:1;                 /* Interrupt Request 19 */
    vuint32_t INT18:1;                 /* Interrupt Request 18 */
    vuint32_t INT17:1;                 /* Interrupt Request 17 */
    vuint32_t INT16:1;                 /* Interrupt Request 16 */
    vuint32_t INT15:1;                 /* Interrupt Request 15 */
    vuint32_t INT14:1;                 /* Interrupt Request 14 */
    vuint32_t INT13:1;                 /* Interrupt Request 13 */
    vuint32_t INT12:1;                 /* Interrupt Request 12 */
    vuint32_t INT11:1;                 /* Interrupt Request 11 */
    vuint32_t INT10:1;                 /* Interrupt Request 10 */
    vuint32_t INT9:1;                  /* Interrupt Request 9 */
    vuint32_t INT8:1;                  /* Interrupt Request 8 */
    vuint32_t INT7:1;                  /* Interrupt Request 7 */
    vuint32_t INT6:1;                  /* Interrupt Request 6 */
    vuint32_t INT5:1;                  /* Interrupt Request 5 */
    vuint32_t INT4:1;                  /* Interrupt Request 4 */
    vuint32_t INT3:1;                  /* Interrupt Request 3 */
    vuint32_t INT2:1;                  /* Interrupt Request 2 */
    vuint32_t INT1:1;                  /* Interrupt Request 1 */
    vuint32_t INT0:1;                  /* Interrupt Request 0 */
  } B;
} DMA_INTL_tag;

typedef union DMA_ERRH_union_tag {     /* Enable Error Interrupt Register High */
  vuint32_t R;
  struct {
    vuint32_t ERR63:1;                 /* Error In Channel 63 */
    vuint32_t ERR62:1;                 /* Error In Channel 62 */
    vuint32_t ERR61:1;                 /* Error In Channel 61 */
    vuint32_t ERR60:1;                 /* Error In Channel 60 */
    vuint32_t ERR59:1;                 /* Error In Channel 59 */
    vuint32_t ERR58:1;                 /* Error In Channel 58 */
    vuint32_t ERR57:1;                 /* Error In Channel 57 */
    vuint32_t ERR56:1;                 /* Error In Channel 56 */
    vuint32_t ERR55:1;                 /* Error In Channel 55 */
    vuint32_t ERR54:1;                 /* Error In Channel 54 */
    vuint32_t ERR53:1;                 /* Error In Channel 53 */
    vuint32_t ERR52:1;                 /* Error In Channel 52 */
    vuint32_t ERR51:1;                 /* Error In Channel 51 */
    vuint32_t ERR50:1;                 /* Error In Channel 50 */
    vuint32_t ERR49:1;                 /* Error In Channel 49 */
    vuint32_t ERR48:1;                 /* Error In Channel 48 */
    vuint32_t ERR47:1;                 /* Error In Channel 47 */
    vuint32_t ERR46:1;                 /* Error In Channel 46 */
    vuint32_t ERR45:1;                 /* Error In Channel 45 */
    vuint32_t ERR44:1;                 /* Error In Channel 44 */
    vuint32_t ERR43:1;                 /* Error In Channel 43 */
    vuint32_t ERR42:1;                 /* Error In Channel 42 */
    vuint32_t ERR41:1;                 /* Error In Channel 41 */
    vuint32_t ERR40:1;                 /* Error In Channel 40 */
    vuint32_t ERR39:1;                 /* Error In Channel 39 */
    vuint32_t ERR38:1;                 /* Error In Channel 38 */
    vuint32_t ERR37:1;                 /* Error In Channel 37 */
    vuint32_t ERR36:1;                 /* Error In Channel 36 */
    vuint32_t ERR35:1;                 /* Error In Channel 35 */
    vuint32_t ERR34:1;                 /* Error In Channel 34 */
    vuint32_t ERR33:1;                 /* Error In Channel 33 */
    vuint32_t ERR32:1;                 /* Error In Channel 32 */
  } B;
} DMA_ERRH_tag;

typedef union DMA_ERRL_union_tag {     /* Enable Error Interrupt RegisterLow */
  vuint32_t R;
  struct {
    vuint32_t ERR31:1;                 /* Error In Channel 31 */
    vuint32_t ERR30:1;                 /* Error In Channel 30 */
    vuint32_t ERR29:1;                 /* Error In Channel 29 */
    vuint32_t ERR28:1;                 /* Error In Channel 28 */
    vuint32_t ERR27:1;                 /* Error In Channel 27 */
    vuint32_t ERR26:1;                 /* Error In Channel 26 */
    vuint32_t ERR25:1;                 /* Error In Channel 25 */
    vuint32_t ERR24:1;                 /* Error In Channel 24 */
    vuint32_t ERR23:1;                 /* Error In Channel 23 */
    vuint32_t ERR22:1;                 /* Error In Channel 22 */
    vuint32_t ERR21:1;                 /* Error In Channel 21 */
    vuint32_t ERR20:1;                 /* Error In Channel 20 */
    vuint32_t ERR19:1;                 /* Error In Channel 19 */
    vuint32_t ERR18:1;                 /* Error In Channel 18 */
    vuint32_t ERR17:1;                 /* Error In Channel 17 */
    vuint32_t ERR16:1;                 /* Error In Channel 16 */
    vuint32_t ERR15:1;                 /* Error In Channel 15 */
    vuint32_t ERR14:1;                 /* Error In Channel 14 */
    vuint32_t ERR13:1;                 /* Error In Channel 13 */
    vuint32_t ERR12:1;                 /* Error In Channel 12 */
    vuint32_t ERR11:1;                 /* Error In Channel 11 */
    vuint32_t ERR10:1;                 /* Error In Channel 10 */
    vuint32_t ERR9:1;                  /* Error In Channel 9 */
    vuint32_t ERR8:1;                  /* Error In Channel 8 */
    vuint32_t ERR7:1;                  /* Error In Channel 7 */
    vuint32_t ERR6:1;                  /* Error In Channel 6 */
    vuint32_t ERR5:1;                  /* Error In Channel 5 */
    vuint32_t ERR4:1;                  /* Error In Channel 4 */
    vuint32_t ERR3:1;                  /* Error In Channel 3 */
    vuint32_t ERR2:1;                  /* Error In Channel 2 */
    vuint32_t ERR1:1;                  /* Error In Channel 1 */
    vuint32_t ERR0:1;                  /* Error In Channel 0 */
  } B;
} DMA_ERRL_tag;

typedef union DMA_HRSH_union_tag {     /* Hardware Request Status Register High */
  vuint32_t R;
  struct {
    vuint32_t HRS63:1;                 /* Hardware Request Status Channel 63 */
    vuint32_t HRS62:1;                 /* Hardware Request Status Channel 62 */
    vuint32_t HRS61:1;                 /* Hardware Request Status Channel 61 */
    vuint32_t HRS60:1;                 /* Hardware Request Status Channel 60 */
    vuint32_t HRS59:1;                 /* Hardware Request Status Channel 59 */
    vuint32_t HRS58:1;                 /* Hardware Request Status Channel 58 */
    vuint32_t HRS57:1;                 /* Hardware Request Status Channel 57 */
    vuint32_t HRS56:1;                 /* Hardware Request Status Channel 56 */
    vuint32_t HRS55:1;                 /* Hardware Request Status Channel 55 */
    vuint32_t HRS54:1;                 /* Hardware Request Status Channel 54 */
    vuint32_t HRS53:1;                 /* Hardware Request Status Channel 53 */
    vuint32_t HRS52:1;                 /* Hardware Request Status Channel 52 */
    vuint32_t HRS51:1;                 /* Hardware Request Status Channel 51 */
    vuint32_t HRS50:1;                 /* Hardware Request Status Channel 50 */
    vuint32_t HRS49:1;                 /* Hardware Request Status Channel 49 */
    vuint32_t HRS48:1;                 /* Hardware Request Status Channel 48 */
    vuint32_t HRS47:1;                 /* Hardware Request Status Channel 47 */
    vuint32_t HRS46:1;                 /* Hardware Request Status Channel 46 */
    vuint32_t HRS45:1;                 /* Hardware Request Status Channel 45 */
    vuint32_t HRS44:1;                 /* Hardware Request Status Channel 44 */
    vuint32_t HRS43:1;                 /* Hardware Request Status Channel 43 */
    vuint32_t HRS42:1;                 /* Hardware Request Status Channel 42 */
    vuint32_t HRS41:1;                 /* Hardware Request Status Channel 41 */
    vuint32_t HRS40:1;                 /* Hardware Request Status Channel 40 */
    vuint32_t HRS39:1;                 /* Hardware Request Status Channel 39 */
    vuint32_t HRS38:1;                 /* Hardware Request Status Channel 38 */
    vuint32_t HRS37:1;                 /* Hardware Request Status Channel 37 */
    vuint32_t HRS36:1;                 /* Hardware Request Status Channel 36 */
    vuint32_t HRS35:1;                 /* Hardware Request Status Channel 35 */
    vuint32_t HRS34:1;                 /* Hardware Request Status Channel 34 */
    vuint32_t HRS33:1;                 /* Hardware Request Status Channel 33 */
    vuint32_t HRS32:1;                 /* Hardware Request Status Channel 32 */
  } B;
} DMA_HRSH_tag;

typedef union DMA_HRSL_union_tag {     /* Hardware Request Status Register Low */
  vuint32_t R;
  struct {
    vuint32_t HRS31:1;                 /* Hardware Request Status Channel 31 */
    vuint32_t HRS30:1;                 /* Hardware Request Status Channel 30 */
    vuint32_t HRS29:1;                 /* Hardware Request Status Channel 29 */
    vuint32_t HRS28:1;                 /* Hardware Request Status Channel 28 */
    vuint32_t HRS27:1;                 /* Hardware Request Status Channel 27 */
    vuint32_t HRS26:1;                 /* Hardware Request Status Channel 26 */
    vuint32_t HRS25:1;                 /* Hardware Request Status Channel 25 */
    vuint32_t HRS24:1;                 /* Hardware Request Status Channel 24 */
    vuint32_t HRS23:1;                 /* Hardware Request Status Channel 23 */
    vuint32_t HRS22:1;                 /* Hardware Request Status Channel 22 */
    vuint32_t HRS21:1;                 /* Hardware Request Status Channel 21 */
    vuint32_t HRS20:1;                 /* Hardware Request Status Channel 20 */
    vuint32_t HRS19:1;                 /* Hardware Request Status Channel 19 */
    vuint32_t HRS18:1;                 /* Hardware Request Status Channel 18 */
    vuint32_t HRS17:1;                 /* Hardware Request Status Channel 17 */
    vuint32_t HRS16:1;                 /* Hardware Request Status Channel 16 */
    vuint32_t HRS15:1;                 /* Hardware Request Status Channel 15 */
    vuint32_t HRS14:1;                 /* Hardware Request Status Channel 14 */
    vuint32_t HRS13:1;                 /* Hardware Request Status Channel 13 */
    vuint32_t HRS12:1;                 /* Hardware Request Status Channel 12 */
    vuint32_t HRS11:1;                 /* Hardware Request Status Channel 11 */
    vuint32_t HRS10:1;                 /* Hardware Request Status Channel 10 */
    vuint32_t HRS9:1;                  /* Hardware Request Status Channel 9 */
    vuint32_t HRS8:1;                  /* Hardware Request Status Channel 8 */
    vuint32_t HRS7:1;                  /* Hardware Request Status Channel 7 */
    vuint32_t HRS6:1;                  /* Hardware Request Status Channel 6 */
    vuint32_t HRS5:1;                  /* Hardware Request Status Channel 5 */
    vuint32_t HRS4:1;                  /* Hardware Request Status Channel 4 */
    vuint32_t HRS3:1;                  /* Hardware Request Status Channel 3 */
    vuint32_t HRS2:1;                  /* Hardware Request Status Channel 2 */
    vuint32_t HRS1:1;                  /* Hardware Request Status Channel 1 */
    vuint32_t HRS0:1;                  /* Hardware Request Status Channel 0 */
  } B;
} DMA_HRSL_tag;

typedef union DMA_DCHPRI_union_tag {   /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t GRPPRI:2;                 /* Channel n Current Group Priority */
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
  } B;
} DMA_DCHPRI_tag;

typedef union DMA_DCHMID_union_tag {   /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t EMI:1;                    /* Enable Master ID replication. */
    vuint8_t PAL:1;                    /* Privileged Access Level. */
    vuint8_t  :2;
    vuint8_t MID:4;                    /* Master ID. */
  } B;
} DMA_DCHMID_tag;

typedef union DMA_TCD_WORD_0_union_tag { /* TCD Source Address */
  vuint32_t R;
  struct {
    vuint32_t SADDR:32;                /* Source Address. */
  } B;
} DMA_TCD_WORD_0_tag;

typedef union DMA_TCD_WORD_1_union_tag { /* TCD Transfer Attributes */
  vuint32_t R;
  struct {
    vuint32_t SMOD:5;                  /* Source Address Modulo. */
    vuint32_t SSIZE:3;                 /* Source data transfer size. */
    vuint32_t DMOD:5;                  /* Destination Address Modulo. */
    vuint32_t DSIZE:3;                 /* Destination data transfer size */
    vuint32_t SOFF:16;                 /* Source address signed offset. */
  } B;
} DMA_TCD_WORD_1_tag;

typedef union DMA_TCD_WORD_2_MLOOP_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source minor loop offset enable. */
    vuint32_t DMLOE:1;                 /* Destination minor loop offset enable. */
    vuint32_t MLOFF:20;                /* Inner "minor" byte transfer count or Minor loop offset. */
    vuint32_t NBYTES:10;               /* Inner "Minor" Byte Transfer Count */
  } B;
} DMA_TCD_WORD_2_MLOOP_tag;

typedef union DMA_TCD_WORD_2_NBYTES_union_tag { /* TCD Number of bytes to be transferred */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:32;               /* Inner "Minor" Byte Transfer Count */
  } B;
} DMA_TCD_WORD_2_NBYTES_tag;

typedef union DMA_TCD_WORD_2_union_tag {
  DMA_TCD_WORD_2_MLOOP_tag MLOOP;      /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
  DMA_TCD_WORD_2_NBYTES_tag NBYTES;    /* TCD Number of bytes to be transferred */
} DMA_TCD_WORD_2_tag;

typedef union DMA_TCD_WORD_3_union_tag { /* TCD Last Source Address Adjustment */
  vuint32_t R;
  struct {
    vuint32_t SLAST:32;                /* Last Source Address Adjustment */
  } B;
} DMA_TCD_WORD_3_tag;

typedef union DMA_TCD_WORD_4_union_tag { /* TCD Destination Address */
  vuint32_t R;
  struct {
    vuint32_t DADDR:32;                /* Destination Address. */
  } B;
} DMA_TCD_WORD_4_tag;

typedef union DMA_TCD_WORD_5_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint32_t R;
  struct {
    vuint32_t CITER_E_LINK:1;          /* Enable channel-to-channel linking on minor-loop complete. */
    vuint32_t LINKCH_CITER:6;          /* Current "major" iteration count or Link channel number. */
    vuint32_t CITER:9;                 /* Current Major Iteration Count */
    vuint32_t DOFF:16;                 /* Destination address signed offset. */
  } B;
} DMA_TCD_WORD_5_tag;

typedef union DMA_TCD_WORD_6_union_tag { /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  vuint32_t R;
  struct {
    vuint32_t DLAST_SGA:32;            /* Last destination address adjustment or the memory address for the next transfer control descriptor to be loaded into this channel (scatter/gather). */
  } B;
} DMA_TCD_WORD_6_tag;

typedef union DMA_TCD_WORD_7_union_tag { /* TCD Control and Status */
  vuint32_t R;
  struct {
    vuint32_t BITER_E_LINK:1;          /* Enable channel-to-channel linking on minor loop complete. */
    vuint32_t BITER_BITER_LINKCH:6;    /* "Beginning major iteration count" or "Beginning Link channel number". */
    vuint32_t BITER:9;                 /* Beginning "major" iteration count. */
    vuint32_t BWC:2;                   /* Bandwidth Control. */
    vuint32_t MAJOR_LINKCH:6;          /* Link Channel Number. */
    vuint32_t DONE:1;                  /* Channel Done. */
    vuint32_t ACTIVE:1;                /* Channel Active. */
    vuint32_t MAJOR_E_LINK:1;          /* Enable channel-to-channel linking on major loop complete. */
    vuint32_t E_SG:1;                  /* Enable Scatter/Cather Processing. */
    vuint32_t DREQ:1;                  /* Disable Request. */
    vuint32_t INT_HALF:1;              /* Enable an interrupt when major counter is half complete. */
    vuint32_t INT_MAJOR:1;             /* Enable an interrupt when major iteration count completes. */
    vuint32_t START:1;                 /* Channel Start. */
  } B;
} DMA_TCD_WORD_7_tag;

typedef struct DMA_TCD_struct_tag {
  DMA_TCD_WORD_0_tag WORD_0;           /* TCD Source Address */
  DMA_TCD_WORD_1_tag WORD_1;           /* TCD Transfer Attributes */
  DMA_TCD_WORD_2_tag WORD_2;
  DMA_TCD_WORD_3_tag WORD_3;           /* TCD Last Source Address Adjustment */
  DMA_TCD_WORD_4_tag WORD_4;           /* TCD Destination Address */
  DMA_TCD_WORD_5_tag WORD_5;           /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  DMA_TCD_WORD_6_tag WORD_6;           /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  DMA_TCD_WORD_7_tag WORD_7;           /* TCD Control and Status */
} DMA_TCD_tag;

struct DMA_tag {
  DMA_CR_tag CR;                       /* Control Register */
  DMA_ES_tag ES;                       /* Error Status Register */
  DMA_ERQH_tag ERQH;                   /* Enable Request Register High */
  DMA_ERQL_tag ERQL;                   /* Enable Request Register Low */
  DMA_EEIH_tag EEIH;                   /* Enable Error Interrupt Register High */
  DMA_EEIL_tag EEIL;                   /* Enable Error Interrupt Register Low */
  DMA_SERQ_tag SERQ;                   /* Set Enable Request Register */
  DMA_CERQ_tag CERQ;                   /* Clear Enable Request Register */
  DMA_SEEI_tag SEEI;                   /* Set Enable Error Interrupt Register */
  DMA_CEEI_tag CEEI;                   /* Clear Enable Error Interrupt Register */
  DMA_CINT_tag CINT;                   /* Clear Interrupt Request Register */
  DMA_CERR_tag CERR;                   /* Clear Error Register */
  DMA_SSRT_tag SSRT;                   /* Set START Bit Register */
  DMA_CDNE_tag CDNE;                   /* Clear DONE Status Bit Register */
  DMA_INTH_tag INTH;                   /* Interrupt Request Register High */
  DMA_INTL_tag INTL;                   /* Interrupt Request Register Low */
  DMA_ERRH_tag ERRH;                   /* Enable Error Interrupt Register High */
  DMA_ERRL_tag ERRL;                   /* Enable Error Interrupt RegisterLow */
  DMA_HRSH_tag HRSH;                   /* Hardware Request Status Register High */
  DMA_HRSL_tag HRSL;                   /* Hardware Request Status Register Low */
  uint8_t DMA_reserved0[200];
  DMA_DCHPRI_tag DCHPRI[64];           /* Channel n Priority Register */
  DMA_DCHMID_tag DCHMID[64];           /* Channel n Master ID Register */
  uint8_t DMA_reserved1[3712];
  DMA_TCD_tag TCD[64];
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

typedef union DMAMUX_CHCFG_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
  } B;
} DMAMUX_CHCFG_tag;

struct DMAMUX_tag {
  DMAMUX_CHCFG_tag CHCFG[16];          /* Channel Configuration register */
};


/* ============================================================================
   =============================== Module: DSPI ===============================
   ============================================================================ */

typedef union DSPI_MCR_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTR:1;                  /* Master/Slave Mode Select */
    vuint32_t CONT_SCKE:1;             /* Continuous SCK Enable */
    vuint32_t DCONF:2;                 /* DSPI Configuration */
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t MTFE:1;                  /* Modified Timing Format Enable */
    vuint32_t PCSSE:1;                 /* Peripheral Chip Select Strobe Enable */
    vuint32_t ROOE:1;                  /* Receive FIFO Overflow Overwrite Enable */
    vuint32_t  :2;
    vuint32_t PCSIS:6;                 /* Peripheral Chip Select x Inactive State */
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t DIS_TXF:1;               /* Disable Transmit FIFO */
    vuint32_t DIS_RXF:1;               /* Disable Receive FIFO */
    vuint32_t CLR_TXF:1;               /* Clear TX FIFO */
    vuint32_t CLR_RXF:1;
    vuint32_t SMPL_PT:2;               /* Sample Point */
    vuint32_t  :4;
    vuint32_t XSPI:1;                  /* Extended SPI Mode */
    vuint32_t FCPCS:1;                 /* Fast Continuous PCS Mode. */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t HALT:1;                  /* Halt */
  } B;
} DSPI_MCR_tag;

typedef union DSPI_TCR_union_tag {     /* Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t SPI_TCNT:16;             /* SPI Transfer Counter */
    vuint32_t  :16;
  } B;
} DSPI_TCR_tag;

typedef union DSPI_MODE_CTAR_union_tag { /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t DBR:1;                   /* Double Baud Rate */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t BR:4;                    /* Baud Rate Scaler */
  } B;
} DSPI_MODE_CTAR_tag;

typedef union DSPI_MODE_CTAR_SLAVE_union_tag { /* Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t FMSZ:5;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t FMSZ5:1;                 /* MSB of Frame Size when DSI is used in 64-bit Mode */
    vuint32_t  :22;
  } B;
} DSPI_MODE_CTAR_SLAVE_tag;

typedef union DSPI_MODE_union_tag {
  DSPI_MODE_CTAR_tag CTAR[8];          /* Clock and Transfer Attributes Register (In Master Mode) */
  DSPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[2]; /* Clock and Transfer Attributes Register (In Slave Mode) */
} DSPI_MODE_tag;

typedef union DSPI_SR_union_tag {      /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t TCF:1;                   /* Transfer Complete Flag */
    vuint32_t TXRXS:1;                 /* TX and RX Status */
    vuint32_t SPITCF:1;                /* SPI Frame Transfer Complete Flag. */
    vuint32_t EOQF:1;                  /* End of Queue Flag */
    vuint32_t TFUF:1;                  /* Transmit FIFO Underflow Flag */
    vuint32_t DSITCF:1;                /* DSI Frame Transfer Complete Flag. */
    vuint32_t TFFF:1;                  /* Transmit FIFO Fill Flag */
    vuint32_t BSYF:1;                  /* Busy Flag. */
    vuint32_t CMDTCF:1;                /* Command Transfer Complete Flag. */
    vuint32_t DPEF:1;                  /* DSI Parity Error Flag */
    vuint32_t SPEF:1;                  /* SPI Parity Error Flag */
    vuint32_t DDIF:1;                  /* DSI Data Received with Active Bits */
    vuint32_t RFOF:1;                  /* Receive FIFO Overflow Flag */
    vuint32_t TFIWF:1;                 /* Tranmit FIFO Invalid Write Flag */
    vuint32_t RFDF:1;                  /* Receive FIFO Drain Flag */
    vuint32_t CMDFFF:1;                /* Command FIFO Fill Flag */
    vuint32_t TXCTR:4;                 /* TX FIFO Counter */
    vuint32_t TXNXTPTR:4;              /* Transmit Next Pointer */
    vuint32_t RXCTR:4;                 /* RX FIFO Counter */
    vuint32_t POPNXTPTR:4;             /* Pop Next Pointer */
  } B;
} DSPI_SR_tag;

typedef union DSPI_RSER_union_tag {    /* DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TCF_RE:1;                /* Transmission Complete Request Enable */
    vuint32_t CMDFFF_RE:1;             /* Command FIFO Fill Flag Request Enable. */
    vuint32_t SPITCF_RE:1;             /* SPI Frame Transmission Complete Request Enable. */
    vuint32_t EOQF_RE:1;               /* Finished Request Enable */
    vuint32_t TFUF_RE:1;               /* Transmit FIFO Underflow Request Enable */
    vuint32_t DSITCF_RE:1;             /* DSI Frame Transmission Complete Request Enable. */
    vuint32_t TFFF_RE:1;               /* Transmit FIFO Fill Request Enable */
    vuint32_t TFFF_DIRS:1;             /* Transmit FIFO Fill DMA or Interrupt Request Select */
    vuint32_t CMDTCF_RE:1;             /* Command Transmission Complete Request Enable. */
    vuint32_t DPEF_RE:1;               /* DSI Parity Error Request Enable */
    vuint32_t SPEF_RE:1;               /* SPI Parity Error Request Enable */
    vuint32_t DDIF_RE:1;               /* DSI data received with active bits Request Enable */
    vuint32_t RFOF_RE:1;               /* Receive FIFO Overflow Request Enable */
    vuint32_t TFIWF_RE:1;              /* Transmit FIFO Invalid Write Request Enable. */
    vuint32_t RFDF_RE:1;               /* Receive FIFO Drain Request Enable */
    vuint32_t RFDF_DIRS:1;             /* Receive FIFO Drain DMA or Interrupt Request Select */
    vuint32_t CMDFFF_DIRS:1;           /* Command FIFO Fill DMA or Interrupt Request Select */
    vuint32_t DDIF_DIRS:1;             /* DSI data received with active bits - DMA or Interrupt Request Select. */
    vuint32_t  :14;
  } B;
} DSPI_RSER_tag;

typedef union DSPI_PUSHR_PUSHR_union_tag { /* PUSH TX FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t CONT:1;                  /* Continuous Peripheral Chip Select Enable */
    vuint32_t CTAS:3;                  /* Clock and Transfer Attributes Select */
    vuint32_t EOQ:1;                   /* End Of Queue */
    vuint32_t CTCNT:1;                 /* Clear Transfer Counter */
    vuint32_t PE_MASC:1;               /* Parity Enable or Mask T ASC delay in the current frame */
    vuint32_t PP_MCSC:1;               /* Parity Polarity or Mask T CSC delay in the next frame */
    vuint32_t  :2;
    vuint32_t PCS:6;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_PUSHR_PUSHR_tag;

typedef union DSPI_PUSHR_PUSHR_SLAVE_union_tag { /* PUSH TX FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_PUSHR_PUSHR_SLAVE_tag;

typedef union DSPI_PUSHR_union_tag {
  DSPI_PUSHR_PUSHR_tag PUSHR;          /* PUSH TX FIFO Register In Master Mode */
  DSPI_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* PUSH TX FIFO Register In Slave Mode */
} DSPI_PUSHR_tag;

typedef union DSPI_POPR_union_tag {    /* POP RX FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Received Data */
  } B;
} DSPI_POPR_tag;

typedef union DSPI_TXFR_union_tag {    /* Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXCMD_TXDATA:16;         /* Transmit Command or Transmit Data */
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} DSPI_TXFR_tag;

typedef union DSPI_RXFR_union_tag {    /* Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Receive Data */
  } B;
} DSPI_RXFR_tag;

typedef union DSPI_DSICR0_union_tag {  /* DSI Configuration Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MTOE:1;                  /* Multiple Transfer Operation Enable */
    vuint32_t FMSZ4:1;                 /* MSB of the frame size in master mode. */
    vuint32_t MTOCNT:6;                /* Multiple Transfer Operation Count */
    vuint32_t FMSZ5:1;                 /* MSB of the frame size in master mode when DSI is used in 64-bit mode. */
    vuint32_t  :1;
    vuint32_t ITSB:1;                  /* Interleaved TSB mode. */
    vuint32_t TSBC:1;                  /* Timed Serial Bus Configuration. */
    vuint32_t TXSS:1;                  /* Transmit Data Source Select. */
    vuint32_t  :2;
    vuint32_t CID:1;                   /* Change In Data Transfer Enable */
    vuint32_t DCONT:1;                 /* DSI Continuous Peripheral Chip Select Enable */
    vuint32_t DSICTAS:3;               /* DSI Clock and Transfer Attributes Select */
    vuint32_t DMS:1;                   /* Data Match Stop */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t DPCSx:8;                 /* DSI Peripheral Chip Select 0-7 */
  } B;
} DSPI_DSICR0_tag;

typedef union DSPI_SDR0_union_tag {    /* DSI Serialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t SER_DATA:32;             /* Serialized Data */
  } B;
} DSPI_SDR0_tag;

typedef union DSPI_ASDR0_union_tag {   /* DSI Alternate Serialization Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t ASER_DATA:32;            /* Alternate Serialized Data */
  } B;
} DSPI_ASDR0_tag;

typedef union DSPI_COMPR0_union_tag {  /* DSI Transmit Comparison Register 0 */
  vuint32_t R;
  struct {
    vuint32_t COMP_DATA:32;            /* Compare Data */
  } B;
} DSPI_COMPR0_tag;

typedef union DSPI_DSICR1_union_tag {  /* DSI Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t TSBCNT:6;                /* Timed Serial Bus Operation Count */
    vuint32_t  :3;
    vuint32_t CSI_PRTY:1;              /* CSI Priority */
    vuint32_t CSE:1;                   /* Command Select Enable */
    vuint32_t DSI64E:1;                /* DSI 64-bit Mode Enable */
    vuint32_t DSE1:1;                  /* Data Select Enable 1 */
    vuint32_t DSE0:1;                  /* Data Select Enable 0 */
    vuint32_t  :8;
    vuint32_t DPCS1_x:8;               /* DSI Peripheral Chip Select 0-7 */
  } B;
} DSPI_DSICR1_tag;

typedef union DSPI_SSR0_union_tag {    /* DSI Serialization Source Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t SS:32;                   /* Source Select */
  } B;
} DSPI_SSR0_tag;

typedef union DSPI_SDR1_union_tag {    /* DSI Serialization Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t SER_DATA:32;             /* Serialized Data */
  } B;
} DSPI_SDR1_tag;

typedef union DSPI_ASDR1_union_tag {   /* DSI Alternate Serialization Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t ASER_DATA:32;            /* Alternate Serialized Data */
  } B;
} DSPI_ASDR1_tag;

typedef union DSPI_COMPR1_union_tag {  /* DSI Transmit Comparison Register 1 */
  vuint32_t R;
  struct {
    vuint32_t COMP_DATA:32;            /* Compare Data */
  } B;
} DSPI_COMPR1_tag;

typedef union DSPI_DDR1_union_tag {    /* DSI Deserialization Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DESER_DATA:32;           /* Deserialized Data */
  } B;
} DSPI_DDR1_tag;

typedef union DSPI_SSR1_union_tag {    /* DSI Serialization Source Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t SS:32;                   /* Source Select */
  } B;
} DSPI_SSR1_tag;

typedef union DSPI_DIMR1_union_tag {   /* DSI Deserialized Data Interrupt Mask Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MASK:32;                 /* Mask */
  } B;
} DSPI_DIMR1_tag;

typedef union DSPI_DPIR1_union_tag {   /* DSI Deserialized Data Polarity Interrupt Register 1 */
  vuint32_t R;
  struct {
    vuint32_t DP:32;                   /* Data Polarity */
  } B;
} DSPI_DPIR1_tag;

typedef union DSPI_CTARE_union_tag {   /* Clock and Transfer Attributes Register Extended */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t FMSZE:1;                 /* Frame Size Extended */
    vuint32_t  :5;
    vuint32_t DTCP:11;                 /* Data Transfer Count Preload */
  } B;
} DSPI_CTARE_tag;

typedef union DSPI_SREX_union_tag {    /* Status Register Extended */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t RXCTR4:1;                /* RX FIFO Counter[4] */
    vuint32_t  :2;
    vuint32_t TXCTR4:1;                /* TX FIFO Counter[4] */
    vuint32_t  :2;
    vuint32_t CMDCTR:5;                /* CMD FIFO Counter */
    vuint32_t CMDNXTPTR:4;             /* Command Next Pointer */
  } B;
} DSPI_SREX_tag;

typedef union DSPI_TRIG_union_tag {    /* Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t ENABLE:1;                /* Trigger Register Enable */
    vuint32_t  :27;
    vuint32_t  :1;
    vuint32_t ASDR_WT:1;               /* ASDR Write Trigger Enable */
    vuint32_t CID:1;                   /* Change In Data Transfer Enable */
    vuint32_t  :1;
  } B;
} DSPI_TRIG_tag;

typedef union DSPI_TSL_union_tag {     /* Time Slot Length Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t TS3_LEN:7;               /* Time Slot 3 Length */
    vuint32_t  :1;
    vuint32_t TS2_LEN:7;               /* Time Slot 2 Length */
    vuint32_t  :1;
    vuint32_t TS1_LEN:7;               /* Time Slot 1 Length */
    vuint32_t  :1;
    vuint32_t TS0_LEN:7;               /* Time Slot 0 Length */
  } B;
} DSPI_TSL_tag;

typedef union DSPI_TS_CONF_union_tag { /* Time Slot Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TS3:4;                   /* Time Slot 3 */
    vuint32_t TS2:4;                   /* Time Slot 2 */
    vuint32_t TS1:4;                   /* Time Slot 1 */
    vuint32_t TS0:4;                   /* Time Slot 0 */
  } B;
} DSPI_TS_CONF_tag;

struct DSPI_tag {
  DSPI_MCR_tag MCR;                    /* Module Configuration Register */
  uint8_t DSPI_reserved0[4];
  DSPI_TCR_tag TCR;                    /* Transfer Count Register */
  DSPI_MODE_tag MODE;
  DSPI_SR_tag SR;                      /* Status Register */
  DSPI_RSER_tag RSER;                  /* DMA/Interrupt Request Select and Enable Register */
  DSPI_PUSHR_tag PUSHR;
  DSPI_POPR_tag POPR;                  /* POP RX FIFO Register */
  DSPI_TXFR_tag TXFR[4];               /* Transmit FIFO Registers */
  uint8_t DSPI_reserved1[48];
  DSPI_RXFR_tag RXFR[4];               /* Receive FIFO Registers */
  uint8_t DSPI_reserved2[48];
  DSPI_DSICR0_tag DSICR0;              /* DSI Configuration Register 0 */
  DSPI_SDR0_tag SDR0;                  /* DSI Serialization Data Register 0 */
  DSPI_ASDR0_tag ASDR0;                /* DSI Alternate Serialization Data Register 0 */
  DSPI_COMPR0_tag COMPR0;              /* DSI Transmit Comparison Register 0 */
  uint8_t DSPI_reserved3[4];
  DSPI_DSICR1_tag DSICR1;              /* DSI Configuration Register 1 */
  DSPI_SSR0_tag SSR0;                  /* DSI Serialization Source Select Register 0 */
  uint8_t DSPI_reserved4[24];
  DSPI_SDR1_tag SDR1;                  /* DSI Serialization Data Register 1 */
  DSPI_ASDR1_tag ASDR1;                /* DSI Alternate Serialization Data Register 1 */
  DSPI_COMPR1_tag COMPR1;              /* DSI Transmit Comparison Register 1 */
  DSPI_DDR1_tag DDR1;                  /* DSI Deserialization Data Register 1 */
  DSPI_SSR1_tag SSR1;                  /* DSI Serialization Source Select Register 1 */
  uint8_t DSPI_reserved5[16];
  DSPI_DIMR1_tag DIMR1;                /* DSI Deserialized Data Interrupt Mask Register 1 */
  DSPI_DPIR1_tag DPIR1;                /* DSI Deserialized Data Polarity Interrupt Register 1 */
  DSPI_CTARE_tag CTARE[8];             /* Clock and Transfer Attributes Register Extended */
  DSPI_SREX_tag SREX;                  /* Status Register Extended */
  DSPI_TRIG_tag TRIG;                  /* Trigger Register */
  uint8_t DSPI_reserved6[12];
  DSPI_TSL_tag TSL;                    /* Time Slot Length Register */
  DSPI_TS_CONF_tag TS_CONF;            /* Time Slot Configuration Register */
};


/* ============================================================================
   =============================== Module: DTS ================================
   ============================================================================ */

typedef union DTS_ENABLE_union_tag {   /* Output Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t DTS_EN_B:1;
    vuint32_t DTS_EN:1;
  } B;
} DTS_ENABLE_tag;

typedef union DTS_STARTUP_union_tag {  /* Startup Register */
  vuint32_t R;
  struct {
    vuint32_t AD:32;
  } B;
} DTS_STARTUP_tag;

typedef union DTS_SEMAPHORE_union_tag { /* Semaphore Register */
  vuint32_t R;
  struct {
    vuint32_t ST:32;
  } B;
} DTS_SEMAPHORE_tag;

typedef union DTS_SEMAPHORE_B_union_tag { /* Semaphore Extension */
  vuint32_t R;
  struct {
    vuint32_t ST_B:32;
  } B;
} DTS_SEMAPHORE_B_tag;

struct DTS_tag {
  DTS_ENABLE_tag ENABLE;               /* Output Enable Register */
  DTS_STARTUP_tag STARTUP;             /* Startup Register */
  DTS_SEMAPHORE_tag SEMAPHORE;         /* Semaphore Register */
  DTS_SEMAPHORE_B_tag SEMAPHORE_B;     /* Semaphore Extension */
};


/* ============================================================================
   =============================== Module: EIM ================================
   ============================================================================ */

typedef union EIM_EIMCR_union_tag {    /* Error Injection Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t GEIEN:1;                 /* Global Error Injection Enable */
  } B;
} EIM_EIMCR_tag;

typedef union EIM_EICHEN_union_tag {   /* Error Injection Channel Enable register */
  vuint32_t R;
  struct {
    vuint32_t EICH0EN:1;               /* Error Injection Channel 0 Enable */
    vuint32_t  :31;
  } B;
} EIM_EICHEN_tag;

typedef union EIM_EICHD_WORD0_union_tag { /* Error Injection Channel Descriptor, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:8;           /* Checkbit Mask */
    vuint32_t  :24;
  } B;
} EIM_EICHD_WORD0_tag;

typedef union EIM_EICHD_WORD1_union_tag { /* Error Injection Channel Descriptor, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_EICHD_WORD1_tag;

typedef union EIM_EICHD_WORD2_union_tag { /* Error Injection Channel Descriptor, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_EICHD_WORD2_tag;

struct EIM_tag {
  EIM_EIMCR_tag EIMCR;                 /* Error Injection Module Configuration Register */
  EIM_EICHEN_tag EICHEN;               /* Error Injection Channel Enable register */
  uint8_t EIM_reserved0[248];
  EIM_EICHD_WORD0_tag EICHD_WORD0;     /* Error Injection Channel Descriptor, Word0 */
  EIM_EICHD_WORD1_tag EICHD_WORD1;     /* Error Injection Channel Descriptor, Word1 */
  EIM_EICHD_WORD2_tag EICHD_WORD2;     /* Error Injection Channel Descriptor, Word2 */
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

typedef union FCCU_CTRL_union_tag {    /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t FILTER_BYPASS:1;
    vuint32_t FILTER_WIDTH:2;
    vuint32_t  :19;
    vuint32_t DEBUG:1;
    vuint32_t NVML:1;
    vuint32_t OPS:2;
    vuint32_t  :1;
    vuint32_t OPR:5;
  } B;
} FCCU_CTRL_tag;

typedef union FCCU_CTRLK_union_tag {   /* CTRL Key Register */
  vuint32_t R;
  struct {
    vuint32_t CTRLK:32;
  } B;
} FCCU_CTRLK_tag;

typedef union FCCU_CFG_union_tag {     /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t FCCU_SET_AFTER_RESET:1;
    vuint32_t FCCU_SET_CLEAR:2;
    vuint32_t RCCE1:1;
    vuint32_t RCCE0:1;
    vuint32_t  :4;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t SM:1;
    vuint32_t PS:1;
    vuint32_t FOM:3;
    vuint32_t  :6;
  } B;
} FCCU_CFG_tag;

typedef union FCCU_NCF_CFG_union_tag { /* NCF Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t NCFC31:1;
    vuint32_t NCFC30:1;
    vuint32_t NCFC29:1;
    vuint32_t NCFC28:1;
    vuint32_t NCFC27:1;
    vuint32_t NCFC26:1;
    vuint32_t NCFC25:1;
    vuint32_t NCFC24:1;
    vuint32_t NCFC23:1;
    vuint32_t NCFC22:1;
    vuint32_t NCFC21:1;
    vuint32_t NCFC20:1;
    vuint32_t NCFC19:1;
    vuint32_t NCFC18:1;
    vuint32_t NCFC17:1;
    vuint32_t NCFC16:1;
    vuint32_t NCFC15:1;
    vuint32_t NCFC14:1;
    vuint32_t NCFC13:1;
    vuint32_t NCFC12:1;
    vuint32_t NCFC11:1;
    vuint32_t NCFC10:1;
    vuint32_t NCFC9:1;
    vuint32_t NCFC8:1;
    vuint32_t NCFC7:1;
    vuint32_t NCFC6:1;
    vuint32_t NCFC5:1;
    vuint32_t NCFC4:1;
    vuint32_t NCFC3:1;
    vuint32_t NCFC2:1;
    vuint32_t NCFC1:1;
    vuint32_t NCFC0:1;
  } B;
} FCCU_NCF_CFG_tag;

typedef union FCCU_NCFS_CFG_union_tag { /* NCFS Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t NCFSC31:1;
    vuint32_t NCFSC30:1;
    vuint32_t NCFSC29:1;
    vuint32_t NCFSC28:1;
    vuint32_t NCFSC27:1;
    vuint32_t NCFSC26:1;
    vuint32_t NCFSC25:1;
    vuint32_t NCFSC24:1;
    vuint32_t NCFSC23:1;
    vuint32_t NCFSC22:1;
    vuint32_t NCFSC21:1;
    vuint32_t NCFSC20:1;
    vuint32_t NCFSC19:1;
    vuint32_t NCFSC18:1;
    vuint32_t NCFSC17:1;
    vuint32_t NCFSC16:1;
    vuint32_t NCFSC15:1;
    vuint32_t NCFSC14:1;
    vuint32_t NCFSC13:1;
    vuint32_t NCFSC12:1;
    vuint32_t NCFSC11:1;
    vuint32_t NCFSC10:1;
    vuint32_t NCFSC9:1;
    vuint32_t NCFSC8:1;
    vuint32_t NCFSC7:1;
    vuint32_t NCFSC6:1;
    vuint32_t NCFSC5:1;
    vuint32_t NCFSC4:1;
    vuint32_t NCFSC3:1;
    vuint32_t NCFSC2:1;
    vuint32_t NCFSC1:1;
    vuint32_t NCFSC0:1;
  } B;
} FCCU_NCFS_CFG_tag;

typedef union FCCU_NCF_S_union_tag {   /* NCF Status Register */
  vuint32_t R;
  struct {
    vuint32_t NCFS31:1;
    vuint32_t NCFS30:1;
    vuint32_t NCFS29:1;
    vuint32_t NCFS28:1;
    vuint32_t NCFS27:1;
    vuint32_t NCFS26:1;
    vuint32_t NCFS25:1;
    vuint32_t NCFS24:1;
    vuint32_t NCFS23:1;
    vuint32_t NCFS22:1;
    vuint32_t NCFS21:1;
    vuint32_t NCFS20:1;
    vuint32_t NCFS19:1;
    vuint32_t NCFS18:1;
    vuint32_t NCFS17:1;
    vuint32_t NCFS16:1;
    vuint32_t NCFS15:1;
    vuint32_t NCFS14:1;
    vuint32_t NCFS13:1;
    vuint32_t NCFS12:1;
    vuint32_t NCFS11:1;
    vuint32_t NCFS10:1;
    vuint32_t NCFS9:1;
    vuint32_t NCFS8:1;
    vuint32_t NCFS7:1;
    vuint32_t NCFS6:1;
    vuint32_t NCFS5:1;
    vuint32_t NCFS4:1;
    vuint32_t NCFS3:1;
    vuint32_t NCFS2:1;
    vuint32_t NCFS1:1;
    vuint32_t NCFS0:1;
  } B;
} FCCU_NCF_S_tag;

typedef union FCCU_NCFK_union_tag {    /* NCF Key Register */
  vuint32_t R;
  struct {
    vuint32_t NCFK:32;
  } B;
} FCCU_NCFK_tag;

typedef union FCCU_NCF_E_union_tag {   /* NCF Enable Register */
  vuint32_t R;
  struct {
    vuint32_t NCFE31:1;
    vuint32_t NCFE30:1;
    vuint32_t NCFE29:1;
    vuint32_t NCFE28:1;
    vuint32_t NCFE27:1;
    vuint32_t NCFE26:1;
    vuint32_t NCFE25:1;
    vuint32_t NCFE24:1;
    vuint32_t NCFE23:1;
    vuint32_t NCFE22:1;
    vuint32_t NCFE21:1;
    vuint32_t NCFE20:1;
    vuint32_t NCFE19:1;
    vuint32_t NCFE18:1;
    vuint32_t NCFE17:1;
    vuint32_t NCFE16:1;
    vuint32_t NCFE15:1;
    vuint32_t NCFE14:1;
    vuint32_t NCFE13:1;
    vuint32_t NCFE12:1;
    vuint32_t NCFE11:1;
    vuint32_t NCFE10:1;
    vuint32_t NCFE9:1;
    vuint32_t NCFE8:1;
    vuint32_t NCFE7:1;
    vuint32_t NCFE6:1;
    vuint32_t NCFE5:1;
    vuint32_t NCFE4:1;
    vuint32_t NCFE3:1;
    vuint32_t NCFE2:1;
    vuint32_t NCFE1:1;
    vuint32_t NCFE0:1;
  } B;
} FCCU_NCF_E_tag;

typedef union FCCU_NCF_TOE_union_tag { /* NCF Time-out Enable Register */
  vuint32_t R;
  struct {
    vuint32_t NCFTOE31:1;
    vuint32_t NCFTOE30:1;
    vuint32_t NCFTOE29:1;
    vuint32_t NCFTOE28:1;
    vuint32_t NCFTOE27:1;
    vuint32_t NCFTOE26:1;
    vuint32_t NCFTOE25:1;
    vuint32_t NCFTOE24:1;
    vuint32_t NCFTOE23:1;
    vuint32_t NCFTOE22:1;
    vuint32_t NCFTOE21:1;
    vuint32_t NCFTOE20:1;
    vuint32_t NCFTOE19:1;
    vuint32_t NCFTOE18:1;
    vuint32_t NCFTOE17:1;
    vuint32_t NCFTOE16:1;
    vuint32_t NCFTOE15:1;
    vuint32_t NCFTOE14:1;
    vuint32_t NCFTOE13:1;
    vuint32_t NCFTOE12:1;
    vuint32_t NCFTOE11:1;
    vuint32_t NCFTOE10:1;
    vuint32_t NCFTOE9:1;
    vuint32_t NCFTOE8:1;
    vuint32_t NCFTOE7:1;
    vuint32_t NCFTOE6:1;
    vuint32_t NCFTOE5:1;
    vuint32_t NCFTOE4:1;
    vuint32_t NCFTOE3:1;
    vuint32_t NCFTOE2:1;
    vuint32_t NCFTOE1:1;
    vuint32_t NCFTOE0:1;
  } B;
} FCCU_NCF_TOE_tag;

typedef union FCCU_NCF_TO_union_tag {  /* NCF Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t TO:32;
  } B;
} FCCU_NCF_TO_tag;

typedef union FCCU_CFG_TO_union_tag {  /* CFG Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t TO:3;
  } B;
} FCCU_CFG_TO_tag;

typedef union FCCU_EINOUT_union_tag {  /* IO Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t EIN1:1;
    vuint32_t EIN0:1;
    vuint32_t  :2;
    vuint32_t EOUT1:1;
    vuint32_t EOUT0:1;
  } B;
} FCCU_EINOUT_tag;

typedef union FCCU_STAT_union_tag {    /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t PhysicErrorPin:2;
    vuint32_t ESTAT:1;
    vuint32_t STATUS:3;
  } B;
} FCCU_STAT_tag;

typedef union FCCU_N2AF_STATUS_union_tag { /* NA Freeze Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t NAFS:8;
  } B;
} FCCU_N2AF_STATUS_tag;

typedef union FCCU_A2FF_STATUS_union_tag { /* AF Freeze Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t AF_SRC:2;
    vuint32_t AFFS:8;
  } B;
} FCCU_A2FF_STATUS_tag;

typedef union FCCU_N2FF_STATUS_union_tag { /* NF Freeze Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t NF_SRC:2;
    vuint32_t NFFS:8;
  } B;
} FCCU_N2FF_STATUS_tag;

typedef union FCCU_F2A_STATUS_union_tag { /* FA Freeze Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t FAFS:9;
  } B;
} FCCU_F2A_STATUS_tag;

typedef union FCCU_SCFS_union_tag {    /* SC Freeze Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t RCCS1:1;
    vuint32_t RCCS0:1;
  } B;
} FCCU_SCFS_tag;

typedef union FCCU_NCFF_union_tag {    /* NCF Fake Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;
    vuint32_t FNCFC:7;
  } B;
} FCCU_NCFF_tag;

typedef union FCCU_IRQ_STAT_union_tag { /* IRQ Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t NMI_STAT:1;
    vuint32_t ALRM_STAT:1;
    vuint32_t CFG_TO_STAT:1;
  } B;
} FCCU_IRQ_STAT_tag;

typedef union FCCU_IRQ_EN_union_tag {  /* IRQ Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t CFG_TO_IEN:1;
  } B;
} FCCU_IRQ_EN_tag;

typedef union FCCU_XTMR_union_tag {    /* XTMR Register */
  vuint32_t R;
  struct {
    vuint32_t XTMR:32;
  } B;
} FCCU_XTMR_tag;

typedef union FCCU_MCS_union_tag {     /* MCS Register */
  vuint32_t R;
  struct {
    vuint32_t VL3:1;
    vuint32_t FS3:1;
    vuint32_t  :2;
    vuint32_t MCS3:4;
    vuint32_t VL2:1;
    vuint32_t FS2:1;
    vuint32_t  :2;
    vuint32_t MCS2:4;
    vuint32_t VL1:1;
    vuint32_t FS1:1;
    vuint32_t  :2;
    vuint32_t MCS1:4;
    vuint32_t VL0:1;
    vuint32_t FS0:1;
    vuint32_t  :2;
    vuint32_t MCS0:4;
  } B;
} FCCU_MCS_tag;

typedef union FCCU_TRANS_LOCK_union_tag { /* Transient Lock Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t TRANSKEY:9;
  } B;
} FCCU_TRANS_LOCK_tag;

typedef union FCCU_PERMNT_LOCK_union_tag { /* Permanent Lock Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t PERMNTKEY:9;
  } B;
} FCCU_PERMNT_LOCK_tag;

typedef union FCCU_DELTA_T_union_tag { /* Delta T Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t  :14;
    vuint32_t  :2;
    vuint32_t DELTA_T:14;
  } B;
} FCCU_DELTA_T_tag;

typedef union FCCU_IRQ_ALARM_EN_union_tag { /* IRQ Alarm Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IRQEN31:1;
    vuint32_t IRQEN30:1;
    vuint32_t IRQEN29:1;
    vuint32_t IRQEN28:1;
    vuint32_t IRQEN27:1;
    vuint32_t IRQEN26:1;
    vuint32_t IRQEN25:1;
    vuint32_t IRQEN24:1;
    vuint32_t IRQEN23:1;
    vuint32_t IRQEN22:1;
    vuint32_t IRQEN21:1;
    vuint32_t IRQEN20:1;
    vuint32_t IRQEN19:1;
    vuint32_t IRQEN18:1;
    vuint32_t IRQEN17:1;
    vuint32_t IRQEN16:1;
    vuint32_t IRQEN15:1;
    vuint32_t IRQEN14:1;
    vuint32_t IRQEN13:1;
    vuint32_t IRQEN12:1;
    vuint32_t IRQEN11:1;
    vuint32_t IRQEN10:1;
    vuint32_t IRQEN9:1;
    vuint32_t IRQEN8:1;
    vuint32_t IRQEN7:1;
    vuint32_t IRQEN6:1;
    vuint32_t IRQEN5:1;
    vuint32_t IRQEN4:1;
    vuint32_t IRQEN3:1;
    vuint32_t IRQEN2:1;
    vuint32_t IRQEN1:1;
    vuint32_t IRQEN0:1;
  } B;
} FCCU_IRQ_ALARM_EN_tag;

typedef union FCCU_NMI_EN_union_tag {  /* NMI Enable Register */
  vuint32_t R;
  struct {
    vuint32_t NMIEN31:1;
    vuint32_t NMIEN30:1;
    vuint32_t NMIEN29:1;
    vuint32_t NMIEN28:1;
    vuint32_t NMIEN27:1;
    vuint32_t NMIEN26:1;
    vuint32_t NMIEN25:1;
    vuint32_t NMIEN24:1;
    vuint32_t NMIEN23:1;
    vuint32_t NMIEN22:1;
    vuint32_t NMIEN21:1;
    vuint32_t NMIEN20:1;
    vuint32_t NMIEN19:1;
    vuint32_t NMIEN18:1;
    vuint32_t NMIEN17:1;
    vuint32_t NMIEN16:1;
    vuint32_t NMIEN15:1;
    vuint32_t NMIEN14:1;
    vuint32_t NMIEN13:1;
    vuint32_t NMIEN12:1;
    vuint32_t NMIEN11:1;
    vuint32_t NMIEN10:1;
    vuint32_t NMIEN9:1;
    vuint32_t NMIEN8:1;
    vuint32_t NMIEN7:1;
    vuint32_t NMIEN6:1;
    vuint32_t NMIEN5:1;
    vuint32_t NMIEN4:1;
    vuint32_t NMIEN3:1;
    vuint32_t NMIEN2:1;
    vuint32_t NMIEN1:1;
    vuint32_t NMIEN0:1;
  } B;
} FCCU_NMI_EN_tag;

typedef union FCCU_EOUT_SIG_EN_union_tag { /* EOUT Signaling Enable Register */
  vuint32_t R;
  struct {
    vuint32_t EOUTEN31:1;
    vuint32_t EOUTEN30:1;
    vuint32_t EOUTEN29:1;
    vuint32_t EOUTEN28:1;
    vuint32_t EOUTEN27:1;
    vuint32_t EOUTEN26:1;
    vuint32_t EOUTEN25:1;
    vuint32_t EOUTEN24:1;
    vuint32_t EOUTEN23:1;
    vuint32_t EOUTEN22:1;
    vuint32_t EOUTEN21:1;
    vuint32_t EOUTEN20:1;
    vuint32_t EOUTEN19:1;
    vuint32_t EOUTEN18:1;
    vuint32_t EOUTEN17:1;
    vuint32_t EOUTEN16:1;
    vuint32_t EOUTEN15:1;
    vuint32_t EOUTEN14:1;
    vuint32_t EOUTEN13:1;
    vuint32_t EOUTEN12:1;
    vuint32_t EOUTEN11:1;
    vuint32_t EOUTEN10:1;
    vuint32_t EOUTEN9:1;
    vuint32_t EOUTEN8:1;
    vuint32_t EOUTEN7:1;
    vuint32_t EOUTEN6:1;
    vuint32_t EOUTEN5:1;
    vuint32_t EOUTEN4:1;
    vuint32_t EOUTEN3:1;
    vuint32_t EOUTEN2:1;
    vuint32_t EOUTEN1:1;
    vuint32_t EOUTEN0:1;
  } B;
} FCCU_EOUT_SIG_EN_tag;

struct FCCU_tag {
  FCCU_CTRL_tag CTRL;                  /* Control Register */
  FCCU_CTRLK_tag CTRLK;                /* CTRL Key Register */
  FCCU_CFG_tag CFG;                    /* Configuration Register */
  uint8_t FCCU_reserved0[16];
  FCCU_NCF_CFG_tag NCF_CFG[3];         /* NCF Configuration Register */
  uint8_t FCCU_reserved1[36];
  FCCU_NCFS_CFG_tag NCFS_CFG[6];       /* NCFS Configuration Register */
  uint8_t FCCU_reserved2[28];
  FCCU_NCF_S_tag NCF_S[3];             /* NCF Status Register */
  uint8_t FCCU_reserved3[4];
  FCCU_NCFK_tag NCFK;                  /* NCF Key Register */
  FCCU_NCF_E_tag NCF_E[3];             /* NCF Enable Register */
  uint8_t FCCU_reserved4[4];
  FCCU_NCF_TOE_tag NCF_TOE[3];         /* NCF Time-out Enable Register */
  uint8_t FCCU_reserved5[4];
  FCCU_NCF_TO_tag NCF_TO;              /* NCF Time-out Register */
  FCCU_CFG_TO_tag CFG_TO;              /* CFG Timeout Register */
  FCCU_EINOUT_tag EINOUT;              /* IO Control Register */
  FCCU_STAT_tag STAT;                  /* Status Register */
  FCCU_N2AF_STATUS_tag N2AF_STATUS;    /* NA Freeze Status Register */
  FCCU_A2FF_STATUS_tag A2FF_STATUS;    /* AF Freeze Status Register */
  FCCU_N2FF_STATUS_tag N2FF_STATUS;    /* NF Freeze Status Register */
  FCCU_F2A_STATUS_tag F2A_STATUS;      /* FA Freeze Status Register */
  FCCU_SCFS_tag SCFS;                  /* SC Freeze Status Register */
  uint8_t FCCU_reserved6[4];
  FCCU_NCFF_tag NCFF;                  /* NCF Fake Register */
  FCCU_IRQ_STAT_tag IRQ_STAT;          /* IRQ Status Register */
  FCCU_IRQ_EN_tag IRQ_EN;              /* IRQ Enable Register */
  FCCU_XTMR_tag XTMR;                  /* XTMR Register */
  FCCU_MCS_tag MCS;                    /* MCS Register */
  FCCU_TRANS_LOCK_tag TRANS_LOCK;      /* Transient Lock Register */
  FCCU_PERMNT_LOCK_tag PERMNT_LOCK;    /* Permanent Lock Register */
  FCCU_DELTA_T_tag DELTA_T;            /* Delta T Register */
  FCCU_IRQ_ALARM_EN_tag IRQ_ALARM_EN[3]; /* IRQ Alarm Enable Register */
  uint8_t FCCU_reserved7[4];
  FCCU_NMI_EN_tag NMI_EN[3];           /* NMI Enable Register */
  uint8_t FCCU_reserved8[4];
  FCCU_EOUT_SIG_EN_tag EOUT_SIG_EN[3]; /* EOUT Signaling Enable Register */
};


/* ============================================================================
   =============================== Module: FEC ================================
   ============================================================================ */

typedef union FEC_EIR_union_tag {      /* Interrupt Event Register */
  vuint32_t R;
  struct {
    vuint32_t HBERR:1;
    vuint32_t BABR:1;
    vuint32_t BABT:1;
    vuint32_t GRA:1;
    vuint32_t TXF:1;
    vuint32_t TXB:1;
    vuint32_t RXF:1;
    vuint32_t RXB:1;
    vuint32_t MII:1;
    vuint32_t EBERR:1;
    vuint32_t LC:1;
    vuint32_t RL:1;
    vuint32_t UN:1;
    vuint32_t  :19;
  } B;
} FEC_EIR_tag;

typedef union FEC_EIMR_union_tag {     /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t HBERR:1;
    vuint32_t BABR:1;
    vuint32_t BABT:1;
    vuint32_t GRA:1;
    vuint32_t TXF:1;
    vuint32_t TXB:1;
    vuint32_t RXF:1;
    vuint32_t RXB:1;
    vuint32_t MII:1;
    vuint32_t EBERR:1;
    vuint32_t LC:1;
    vuint32_t RL:1;
    vuint32_t UN:1;
    vuint32_t  :19;
  } B;
} FEC_EIMR_tag;

typedef union FEC_RDAR_union_tag {     /* Receive Descriptor Active Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t RDAR:1;
    vuint32_t  :24;
  } B;
} FEC_RDAR_tag;

typedef union FEC_TDAR_union_tag {     /* Transmit Descriptor Active Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t TDAR:1;
    vuint32_t  :24;
  } B;
} FEC_TDAR_tag;

typedef union FEC_ECR_union_tag {      /* Ethernet Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :23;
    vuint32_t  :1;
    vuint32_t ETHER_EN:1;
    vuint32_t RESET:1;
  } B;
} FEC_ECR_tag;

typedef union FEC_MMFR_union_tag {     /* MII Management Frame Register */
  vuint32_t R;
  struct {
    vuint32_t ST:2;
    vuint32_t OP:2;
    vuint32_t PA:5;
    vuint32_t RA:5;
    vuint32_t TA:2;
    vuint32_t DATA:16;
  } B;
} FEC_MMFR_tag;

typedef union FEC_MSCR_union_tag {     /* MII Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t DIS_PRE:1;
    vuint32_t MII_SPEED:6;
    vuint32_t  :1;
  } B;
} FEC_MSCR_tag;

typedef union FEC_MIBC_union_tag {     /* MIB Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIB_DIS:1;
    vuint32_t MIB_IDLE:1;
    vuint32_t  :30;
  } B;
} FEC_MIBC_tag;

typedef union FEC_RCR_union_tag {      /* Receive Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t MAX_FL:11;
    vuint32_t  :4;
    vuint32_t RMII_ECHO:1;
    vuint32_t RMII_LOOP:1;
    vuint32_t RMII_10T:1;
    vuint32_t RMII_MODE:1;
    vuint32_t  :2;
    vuint32_t FCE:1;
    vuint32_t BC_REJ:1;
    vuint32_t PROM:1;
    vuint32_t MII_MODE:1;
    vuint32_t DRT:1;
    vuint32_t LOOP:1;
  } B;
} FEC_RCR_tag;

typedef union FEC_TCR_union_tag {      /* Transmit Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t RFC_PAUSE:1;
    vuint32_t TFC_PAUSE:1;
    vuint32_t FDEN:1;
    vuint32_t HBC:1;
    vuint32_t GTS:1;
  } B;
} FEC_TCR_tag;

typedef union FEC_PALR_union_tag {     /* Physical Address Low Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR1:32;
  } B;
} FEC_PALR_tag;

typedef union FEC_PAUR_union_tag {     /* Physical Address High Register and Type Field */
  vuint32_t R;
  struct {
    vuint32_t PADDR2:16;
    vuint32_t TYPE:16;
  } B;
} FEC_PAUR_tag;

typedef union FEC_OPD_union_tag {      /* Opcode/Pause Duration */
  vuint32_t R;
  struct {
    vuint32_t OPCODE:16;
    vuint32_t PAUSE_DUR:16;
  } B;
} FEC_OPD_tag;

typedef union FEC_IAUR_union_tag {     /* Descriptor Individual Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR1:32;
  } B;
} FEC_IAUR_tag;

typedef union FEC_IALR_union_tag {     /* Descriptor Individual Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR2:32;
  } B;
} FEC_IALR_tag;

typedef union FEC_GAUR_union_tag {     /* Descriptor Group Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR1:32;
  } B;
} FEC_GAUR_tag;

typedef union FEC_GALR_union_tag {     /* Descriptor Group Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR2:32;
  } B;
} FEC_GALR_tag;

typedef union FEC_TFWR_union_tag {     /* Transmit FIFO Watermark */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t TFWR:2;
  } B;
} FEC_TFWR_tag;

typedef union FEC_FRBR_union_tag {     /* FIFO Receive Bound Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t  :1;
    vuint32_t R_BOUND:8;
    vuint32_t  :2;
  } B;
} FEC_FRBR_tag;

typedef union FEC_FRSR_union_tag {     /* FIFO Receive Start Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t  :1;
    vuint32_t R_FSTART:8;
    vuint32_t  :2;
  } B;
} FEC_FRSR_tag;

typedef union FEC_ERDSR_union_tag {    /* Receive Descriptor Ring Start Register */
  vuint32_t R;
  struct {
    vuint32_t R_DES_START:30;
    vuint32_t  :2;
  } B;
} FEC_ERDSR_tag;

typedef union FEC_ETDSR_union_tag {    /* Transmit Buffer Descriptor Ring Start Register */
  vuint32_t R;
  struct {
    vuint32_t X_DES_START:30;
    vuint32_t  :2;
  } B;
} FEC_ETDSR_tag;

typedef union FEC_EMRBR_union_tag {    /* Receive Buffer Size Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t R_BUF_SIZE:7;
    vuint32_t  :4;
  } B;
} FEC_EMRBR_tag;

typedef union FEC_RMON_T_DROP_union_tag { /* Count of frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_DROP:32;
  } B;
} FEC_RMON_T_DROP_tag;

typedef union FEC_RMON_T_PACKETS_union_tag { /* RMON Tx packet count */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_PACKETS:32;
  } B;
} FEC_RMON_T_PACKETS_tag;

typedef union FEC_RMON_T_BC_PKT_union_tag { /* RMON Tx broadcast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_BC_PKT:32;
  } B;
} FEC_RMON_T_BC_PKT_tag;

typedef union FEC_RMON_T_MC_PKT_union_tag { /* RMON Tx multicast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_MC_PKT:32;
  } B;
} FEC_RMON_T_MC_PKT_tag;

typedef union FEC_RMON_T_CRC_ALIGN_union_tag { /* RMON Tx packets with CRC/align error */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_CRC_ALIGN:32;
  } B;
} FEC_RMON_T_CRC_ALIGN_tag;

typedef union FEC_RMON_T_UNDERSIZE_union_tag { /* RMON Tx packets < 64 bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_UNDERSIZE:32;
  } B;
} FEC_RMON_T_UNDERSIZE_tag;

typedef union FEC_RMON_T_OVERSIZE_union_tag { /* RMON Tx packets > MAX_FL bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_OVERSIZE:32;
  } B;
} FEC_RMON_T_OVERSIZE_tag;

typedef union FEC_RMON_T_FRAG_union_tag { /* RMON Tx packets < 64 bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_FRAG:32;
  } B;
} FEC_RMON_T_FRAG_tag;

typedef union FEC_RMON_T_JAB_union_tag { /* RMON Tx packets > MAX_FL bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_JAB:32;
  } B;
} FEC_RMON_T_JAB_tag;

typedef union FEC_RMON_T_COL_union_tag { /* RMON Tx collision count */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_COL:32;
  } B;
} FEC_RMON_T_COL_tag;

typedef union FEC_RMON_T_P64_union_tag { /* RMON Tx 64 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P64:32;
  } B;
} FEC_RMON_T_P64_tag;

typedef union FEC_RMON_T_P65TO127_union_tag { /* RMON Tx 65 to 127 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P65TO127:32;
  } B;
} FEC_RMON_T_P65TO127_tag;

typedef union FEC_RMON_T_P128TO255_union_tag { /* RMON Tx 128 to 255 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P128TO255:32;
  } B;
} FEC_RMON_T_P128TO255_tag;

typedef union FEC_RMON_T_P256TO511_union_tag { /* RMON Tx 256 to 511 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P256TO511:32;
  } B;
} FEC_RMON_T_P256TO511_tag;

typedef union FEC_RMON_T_P512TO1023_union_tag { /* RMON Tx 512 to 1023 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P512TO1023:32;
  } B;
} FEC_RMON_T_P512TO1023_tag;

typedef union FEC_RMON_T_P1024TO2047_union_tag { /* RMON Tx 1024 to 2047 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P1024TO2047:32;
  } B;
} FEC_RMON_T_P1024TO2047_tag;

typedef union FEC_RMON_T_P_GTE2048_union_tag { /* RMON Tx packets with > 2048 bytes */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_P_GTE2048:32;
  } B;
} FEC_RMON_T_P_GTE2048_tag;

typedef union FEC_RMON_T_OCTETS_union_tag { /* RMON Tx Octets */
  vuint32_t R;
  struct {
    vuint32_t RMON_T_OCTETS:32;
  } B;
} FEC_RMON_T_OCTETS_tag;

typedef union FEC_IEEE_T_DROP_union_tag { /* Count of transmitted frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_DROP:32;
  } B;
} FEC_IEEE_T_DROP_tag;

typedef union FEC_IEEE_T_FRAME_OK_union_tag { /* Frames transmitted OK */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_FRAME_OK:32;
  } B;
} FEC_IEEE_T_FRAME_OK_tag;

typedef union FEC_IEEE_T_1COL_union_tag { /* Frames transmitted with single collision */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_1COL:32;
  } B;
} FEC_IEEE_T_1COL_tag;

typedef union FEC_IEEE_T_MCOL_union_tag { /* Frames transmitted with multiple collisions */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_MCOL:32;
  } B;
} FEC_IEEE_T_MCOL_tag;

typedef union FEC_IEEE_T_DEF_union_tag { /* Frames transmitted after deferral delay */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_DEF:32;
  } B;
} FEC_IEEE_T_DEF_tag;

typedef union FEC_IEEE_T_LCOL_union_tag { /* Frames transmitted with late collision */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_LCOL:32;
  } B;
} FEC_IEEE_T_LCOL_tag;

typedef union FEC_IEEE_T_EXCOL_union_tag { /* Frames transmitted with excessive collisions */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_EXCOL:32;
  } B;
} FEC_IEEE_T_EXCOL_tag;

typedef union FEC_IEEE_T_MACERR_union_tag { /* Frames transmitted with Tx FIFO underrun */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_MACERR:32;
  } B;
} FEC_IEEE_T_MACERR_tag;

typedef union FEC_IEEE_T_CSERR_union_tag { /* Frames transmitted with carrier sense error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_CSERR:32;
  } B;
} FEC_IEEE_T_CSERR_tag;

typedef union FEC_IEEE_T_SQE_union_tag { /* Frames transmitted with SQE error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_SQE:32;
  } B;
} FEC_IEEE_T_SQE_tag;

typedef union FEC_IEEE_T_FDXFC_union_tag { /* Flow control pause frames transmitted */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_FDXFC:32;
  } B;
} FEC_IEEE_T_FDXFC_tag;

typedef union FEC_IEEE_T_OCTETS_OK_union_tag { /* Octet count for frames transmitted without error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_T_OCTETS_OK:32;
  } B;
} FEC_IEEE_T_OCTETS_OK_tag;

typedef union FEC_RMON_R_DROP_union_tag { /* Count of received frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_DROP:32;
  } B;
} FEC_RMON_R_DROP_tag;

typedef union FEC_RMON_R_PACKETS_union_tag { /* RMON Rx packet count */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_PACKETS:32;
  } B;
} FEC_RMON_R_PACKETS_tag;

typedef union FEC_RMON_R_BC_PKT_union_tag { /* RMON Rx broadcast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_BC_PKT:32;
  } B;
} FEC_RMON_R_BC_PKT_tag;

typedef union FEC_RMON_R_MC_PKT_union_tag { /* RMON Rx multicast packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_MC_PKT:32;
  } B;
} FEC_RMON_R_MC_PKT_tag;

typedef union FEC_RMON_R_CRC_ALIGN_union_tag { /* RMON Rx packets with CRC/Align error */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_CRC_ALIGN:32;
  } B;
} FEC_RMON_R_CRC_ALIGN_tag;

typedef union FEC_RMON_R_UNDERSIZE_union_tag { /* RMON Rx packets < 64 bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_UNDERSIZE:32;
  } B;
} FEC_RMON_R_UNDERSIZE_tag;

typedef union FEC_RMON_R_OVERSIZE_union_tag { /* RMON Rx packets > MAX_FL bytes, good CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_OVERSIZE:32;
  } B;
} FEC_RMON_R_OVERSIZE_tag;

typedef union FEC_RMON_R_FRAG_union_tag { /* RMON Rx packets < 64 bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_FRAG:32;
  } B;
} FEC_RMON_R_FRAG_tag;

typedef union FEC_RMON_R_JAB_union_tag { /* RMON Rx packets > MAX_FL bytes, bad CRC */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_JAB:32;
  } B;
} FEC_RMON_R_JAB_tag;

typedef union FEC_RMON_R_RESVD_0_union_tag { /* Reserved */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_RESVD_0:32;
  } B;
} FEC_RMON_R_RESVD_0_tag;

typedef union FEC_RMON_R_P64_union_tag { /* RMON Rx 64 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P64:32;
  } B;
} FEC_RMON_R_P64_tag;

typedef union FEC_RMON_R_P65TO127_union_tag { /* RMON Rx 65 to 127 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P65TO127:32;
  } B;
} FEC_RMON_R_P65TO127_tag;

typedef union FEC_RMON_R_P128TO255_union_tag { /* RMON Rx 128 to 255 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P128TO255:32;
  } B;
} FEC_RMON_R_P128TO255_tag;

typedef union FEC_RMON_R_P256TO511_union_tag { /* RMON Rx 256 to 511 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P256TO511:32;
  } B;
} FEC_RMON_R_P256TO511_tag;

typedef union FEC_RMON_R_P512TO1023_union_tag { /* RMON Rx 512 to 1023 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P512TO1023:32;
  } B;
} FEC_RMON_R_P512TO1023_tag;

typedef union FEC_RMON_R_P1024TO2047_union_tag { /* RMON Rx 1024 to 2047 byte packets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P1024TO2047:32;
  } B;
} FEC_RMON_R_P1024TO2047_tag;

typedef union FEC_RMON_R_P_GTE2048_union_tag { /* RMON Rx packets with > 2048 bytes */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_P_GTE2048:32;
  } B;
} FEC_RMON_R_P_GTE2048_tag;

typedef union FEC_RMON_R_OCTETS_union_tag { /* RMON Rx octets */
  vuint32_t R;
  struct {
    vuint32_t RMON_R_OCTETS:32;
  } B;
} FEC_RMON_R_OCTETS_tag;

typedef union FEC_IEEE_R_DROP_union_tag { /* Count of received frames not counted correctly */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_DROP:32;
  } B;
} FEC_IEEE_R_DROP_tag;

typedef union FEC_IEEE_R_FRAME_OK_union_tag { /* Frames received OK */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_FRAME_OK:32;
  } B;
} FEC_IEEE_R_FRAME_OK_tag;

typedef union FEC_IEEE_R_CRC_union_tag { /* Frames received with CRC error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_CRC:32;
  } B;
} FEC_IEEE_R_CRC_tag;

typedef union FEC_IEEE_R_ALIGN_union_tag { /* Frames received with alignment error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_ALIGN:32;
  } B;
} FEC_IEEE_R_ALIGN_tag;

typedef union FEC_IEEE_R_MACERR_union_tag { /* Receive FIFO overflow count */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_MACERR:32;
  } B;
} FEC_IEEE_R_MACERR_tag;

typedef union FEC_IEEE_R_FDXFC_union_tag { /* Flow control pause frames received */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_FDXFC:32;
  } B;
} FEC_IEEE_R_FDXFC_tag;

typedef union FEC_IEEE_R_OCTETS_OK_union_tag { /* Octet count for frames received without error */
  vuint32_t R;
  struct {
    vuint32_t IEEE_R_OCTETS_OK:32;
  } B;
} FEC_IEEE_R_OCTETS_OK_tag;

struct FEC_tag {
  uint8_t FEC_reserved0[4];
  FEC_EIR_tag EIR;                     /* Interrupt Event Register */
  FEC_EIMR_tag EIMR;                   /* Interrupt Mask Register */
  uint8_t FEC_reserved1[4];
  FEC_RDAR_tag RDAR;                   /* Receive Descriptor Active Register */
  FEC_TDAR_tag TDAR;                   /* Transmit Descriptor Active Register */
  uint8_t FEC_reserved2[12];
  FEC_ECR_tag ECR;                     /* Ethernet Control Register */
  uint8_t FEC_reserved3[24];
  FEC_MMFR_tag MMFR;                   /* MII Management Frame Register */
  FEC_MSCR_tag MSCR;                   /* MII Speed Control Register */
  uint8_t FEC_reserved4[28];
  FEC_MIBC_tag MIBC;                   /* MIB Control Register */
  uint8_t FEC_reserved5[28];
  FEC_RCR_tag RCR;                     /* Receive Control Register */
  uint8_t FEC_reserved6[60];
  FEC_TCR_tag TCR;                     /* Transmit Control Register */
  uint8_t FEC_reserved7[28];
  FEC_PALR_tag PALR;                   /* Physical Address Low Register */
  FEC_PAUR_tag PAUR;                   /* Physical Address High Register and Type Field */
  FEC_OPD_tag OPD;                     /* Opcode/Pause Duration */
  uint8_t FEC_reserved8[40];
  FEC_IAUR_tag IAUR;                   /* Descriptor Individual Upper Address Register */
  FEC_IALR_tag IALR;                   /* Descriptor Individual Lower Address Register */
  FEC_GAUR_tag GAUR;                   /* Descriptor Group Upper Address Register */
  FEC_GALR_tag GALR;                   /* Descriptor Group Lower Address Register */
  uint8_t FEC_reserved9[28];
  FEC_TFWR_tag TFWR;                   /* Transmit FIFO Watermark */
  uint8_t FEC_reserved10[4];
  FEC_FRBR_tag FRBR;                   /* FIFO Receive Bound Register */
  FEC_FRSR_tag FRSR;                   /* FIFO Receive Start Register */
  uint8_t FEC_reserved11[44];
  FEC_ERDSR_tag ERDSR;                 /* Receive Descriptor Ring Start Register */
  FEC_ETDSR_tag ETDSR;                 /* Transmit Buffer Descriptor Ring Start Register */
  FEC_EMRBR_tag EMRBR;                 /* Receive Buffer Size Register */
  uint8_t FEC_reserved12[116];
  FEC_RMON_T_DROP_tag RMON_T_DROP;     /* Count of frames not counted correctly */
  FEC_RMON_T_PACKETS_tag RMON_T_PACKETS; /* RMON Tx packet count */
  FEC_RMON_T_BC_PKT_tag RMON_T_BC_PKT; /* RMON Tx broadcast packets */
  FEC_RMON_T_MC_PKT_tag RMON_T_MC_PKT; /* RMON Tx multicast packets */
  FEC_RMON_T_CRC_ALIGN_tag RMON_T_CRC_ALIGN; /* RMON Tx packets with CRC/align error */
  FEC_RMON_T_UNDERSIZE_tag RMON_T_UNDERSIZE; /* RMON Tx packets < 64 bytes, good CRC */
  FEC_RMON_T_OVERSIZE_tag RMON_T_OVERSIZE; /* RMON Tx packets > MAX_FL bytes, good CRC */
  FEC_RMON_T_FRAG_tag RMON_T_FRAG;     /* RMON Tx packets < 64 bytes, bad CRC */
  FEC_RMON_T_JAB_tag RMON_T_JAB;       /* RMON Tx packets > MAX_FL bytes, bad CRC */
  FEC_RMON_T_COL_tag RMON_T_COL;       /* RMON Tx collision count */
  FEC_RMON_T_P64_tag RMON_T_P64;       /* RMON Tx 64 byte packets */
  FEC_RMON_T_P65TO127_tag RMON_T_P65TO127; /* RMON Tx 65 to 127 byte packets */
  FEC_RMON_T_P128TO255_tag RMON_T_P128TO255; /* RMON Tx 128 to 255 byte packets */
  FEC_RMON_T_P256TO511_tag RMON_T_P256TO511; /* RMON Tx 256 to 511 byte packets */
  FEC_RMON_T_P512TO1023_tag RMON_T_P512TO1023; /* RMON Tx 512 to 1023 byte packets */
  FEC_RMON_T_P1024TO2047_tag RMON_T_P1024TO2047; /* RMON Tx 1024 to 2047 byte packets */
  FEC_RMON_T_P_GTE2048_tag RMON_T_P_GTE2048; /* RMON Tx packets with > 2048 bytes */
  FEC_RMON_T_OCTETS_tag RMON_T_OCTETS; /* RMON Tx Octets */
  FEC_IEEE_T_DROP_tag IEEE_T_DROP;     /* Count of transmitted frames not counted correctly */
  FEC_IEEE_T_FRAME_OK_tag IEEE_T_FRAME_OK; /* Frames transmitted OK */
  FEC_IEEE_T_1COL_tag IEEE_T_1COL;     /* Frames transmitted with single collision */
  FEC_IEEE_T_MCOL_tag IEEE_T_MCOL;     /* Frames transmitted with multiple collisions */
  FEC_IEEE_T_DEF_tag IEEE_T_DEF;       /* Frames transmitted after deferral delay */
  FEC_IEEE_T_LCOL_tag IEEE_T_LCOL;     /* Frames transmitted with late collision */
  FEC_IEEE_T_EXCOL_tag IEEE_T_EXCOL;   /* Frames transmitted with excessive collisions */
  FEC_IEEE_T_MACERR_tag IEEE_T_MACERR; /* Frames transmitted with Tx FIFO underrun */
  FEC_IEEE_T_CSERR_tag IEEE_T_CSERR;   /* Frames transmitted with carrier sense error */
  FEC_IEEE_T_SQE_tag IEEE_T_SQE;       /* Frames transmitted with SQE error */
  FEC_IEEE_T_FDXFC_tag IEEE_T_FDXFC;   /* Flow control pause frames transmitted */
  FEC_IEEE_T_OCTETS_OK_tag IEEE_T_OCTETS_OK; /* Octet count for frames transmitted without error */
  uint8_t FEC_reserved13[8];
  FEC_RMON_R_DROP_tag RMON_R_DROP;     /* Count of received frames not counted correctly */
  FEC_RMON_R_PACKETS_tag RMON_R_PACKETS; /* RMON Rx packet count */
  FEC_RMON_R_BC_PKT_tag RMON_R_BC_PKT; /* RMON Rx broadcast packets */
  FEC_RMON_R_MC_PKT_tag RMON_R_MC_PKT; /* RMON Rx multicast packets */
  FEC_RMON_R_CRC_ALIGN_tag RMON_R_CRC_ALIGN; /* RMON Rx packets with CRC/Align error */
  FEC_RMON_R_UNDERSIZE_tag RMON_R_UNDERSIZE; /* RMON Rx packets < 64 bytes, good CRC */
  FEC_RMON_R_OVERSIZE_tag RMON_R_OVERSIZE; /* RMON Rx packets > MAX_FL bytes, good CRC */
  FEC_RMON_R_FRAG_tag RMON_R_FRAG;     /* RMON Rx packets < 64 bytes, bad CRC */
  FEC_RMON_R_JAB_tag RMON_R_JAB;       /* RMON Rx packets > MAX_FL bytes, bad CRC */
  FEC_RMON_R_RESVD_0_tag RMON_R_RESVD_0; /* Reserved */
  FEC_RMON_R_P64_tag RMON_R_P64;       /* RMON Rx 64 byte packets */
  FEC_RMON_R_P65TO127_tag RMON_R_P65TO127; /* RMON Rx 65 to 127 byte packets */
  FEC_RMON_R_P128TO255_tag RMON_R_P128TO255; /* RMON Rx 128 to 255 byte packets */
  FEC_RMON_R_P256TO511_tag RMON_R_P256TO511; /* RMON Rx 256 to 511 byte packets */
  FEC_RMON_R_P512TO1023_tag RMON_R_P512TO1023; /* RMON Rx 512 to 1023 byte packets */
  FEC_RMON_R_P1024TO2047_tag RMON_R_P1024TO2047; /* RMON Rx 1024 to 2047 byte packets */
  FEC_RMON_R_P_GTE2048_tag RMON_R_P_GTE2048; /* RMON Rx packets with > 2048 bytes */
  FEC_RMON_R_OCTETS_tag RMON_R_OCTETS; /* RMON Rx octets */
  FEC_IEEE_R_DROP_tag IEEE_R_DROP;     /* Count of received frames not counted correctly */
  FEC_IEEE_R_FRAME_OK_tag IEEE_R_FRAME_OK; /* Frames received OK */
  FEC_IEEE_R_CRC_tag IEEE_R_CRC;       /* Frames received with CRC error */
  FEC_IEEE_R_ALIGN_tag IEEE_R_ALIGN;   /* Frames received with alignment error */
  FEC_IEEE_R_MACERR_tag IEEE_R_MACERR; /* Receive FIFO overflow count */
  FEC_IEEE_R_FDXFC_tag IEEE_R_FDXFC;   /* Flow control pause frames received */
  FEC_IEEE_R_OCTETS_OK_tag IEEE_R_OCTETS_OK; /* Octet count for frames received without error */
};


/* ============================================================================
   =============================== Module: IGF ================================
   ============================================================================ */

typedef union IGF_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR_tag;

typedef union IGF_MSR0_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR0_tag;

typedef union IGF_PRESR0_union_tag {   /* Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t FPRE:9;                  /* Filter prescaler */
  } B;
} IGF_PRESR0_tag;

typedef union IGF_RTHR0_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR0_tag;

typedef union IGF_FTHR0_union_tag {    /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR0_tag;

typedef union IGF_MCR1_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR1_tag;

typedef union IGF_MSR1_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR1_tag;

typedef union IGF_RTHR1_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR1_tag;

typedef union IGF_FTHR1_union_tag {    /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR1_tag;

typedef union IGF_MCR2_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR2_tag;

typedef union IGF_MSR2_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR2_tag;

typedef union IGF_RTHR2_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR2_tag;

typedef union IGF_FTHR2_union_tag {    /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR2_tag;

typedef union IGF_MCR3_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR3_tag;

typedef union IGF_MSR3_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR3_tag;

typedef union IGF_RTHR3_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR3_tag;

typedef union IGF_FTHR3_union_tag {    /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR3_tag;

typedef union IGF_MCR4_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR4_tag;

typedef union IGF_MSR4_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR4_tag;

typedef union IGF_RTHR4_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR4_tag;

typedef union IGF_FTHR4_union_tag {    /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR4_tag;

typedef union IGF_MCR5_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR5_tag;

typedef union IGF_MSR5_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR5_tag;

typedef union IGF_RTHR5_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR5_tag;

typedef union IGF_FTHR5_union_tag {    /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR5_tag;

typedef union IGF_MCR6_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR6_tag;

typedef union IGF_MSR6_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR6_tag;

typedef union IGF_RTHR6_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR6_tag;

typedef union IGF_FTHR6_union_tag {    /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR6_tag;

typedef union IGF_MCR7_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR7_tag;

typedef union IGF_MSR7_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR7_tag;

typedef union IGF_RTHR7_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR7_tag;

typedef union IGF_FTHR7_union_tag {    /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR7_tag;

typedef union IGF_MCR8_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR8_tag;

typedef union IGF_MSR8_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR8_tag;

typedef union IGF_RTHR8_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR8_tag;

typedef union IGF_FTHR8_union_tag {    /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR8_tag;

typedef union IGF_MCR9_union_tag {     /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR9_tag;

typedef union IGF_MSR9_union_tag {     /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR9_tag;

typedef union IGF_RTHR9_union_tag {    /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR9_tag;

typedef union IGF_FTHR9_union_tag {    /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR9_tag;

typedef union IGF_MCR10_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR10_tag;

typedef union IGF_MSR10_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR10_tag;

typedef union IGF_RTHR10_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR10_tag;

typedef union IGF_FTHR10_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR10_tag;

typedef union IGF_MCR11_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR11_tag;

typedef union IGF_MSR11_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR11_tag;

typedef union IGF_RTHR11_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR11_tag;

typedef union IGF_FTHR11_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR11_tag;

typedef union IGF_MCR12_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR12_tag;

typedef union IGF_MSR12_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR12_tag;

typedef union IGF_RTHR12_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR12_tag;

typedef union IGF_FTHR12_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR12_tag;

typedef union IGF_MCR13_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR13_tag;

typedef union IGF_MSR13_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR13_tag;

typedef union IGF_RTHR13_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR13_tag;

typedef union IGF_FTHR13_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR13_tag;

typedef union IGF_MCR14_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR14_tag;

typedef union IGF_MSR14_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR14_tag;

typedef union IGF_RTHR14_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR14_tag;

typedef union IGF_FTHR14_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR14_tag;

typedef union IGF_MCR15_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR15_tag;

typedef union IGF_MSR15_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR15_tag;

typedef union IGF_RTHR15_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR15_tag;

typedef union IGF_FTHR15_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR15_tag;

typedef union IGF_MCR16_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR16_tag;

typedef union IGF_MSR16_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR16_tag;

typedef union IGF_RTHR16_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR16_tag;

typedef union IGF_FTHR16_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR16_tag;

typedef union IGF_MCR17_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR17_tag;

typedef union IGF_MSR17_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR17_tag;

typedef union IGF_RTHR17_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR17_tag;

typedef union IGF_FTHR17_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR17_tag;

typedef union IGF_MCR18_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR18_tag;

typedef union IGF_MSR18_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR18_tag;

typedef union IGF_RTHR18_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR18_tag;

typedef union IGF_FTHR18_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR18_tag;

typedef union IGF_MCR19_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR19_tag;

typedef union IGF_MSR19_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR19_tag;

typedef union IGF_RTHR19_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR19_tag;

typedef union IGF_FTHR19_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR19_tag;

typedef union IGF_MCR20_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR20_tag;

typedef union IGF_MSR20_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR20_tag;

typedef union IGF_RTHR20_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR20_tag;

typedef union IGF_FTHR20_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR20_tag;

typedef union IGF_MCR21_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR21_tag;

typedef union IGF_MSR21_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR21_tag;

typedef union IGF_RTHR21_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR21_tag;

typedef union IGF_FTHR21_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR21_tag;

typedef union IGF_MCR22_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR22_tag;

typedef union IGF_MSR22_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR22_tag;

typedef union IGF_RTHR22_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR22_tag;

typedef union IGF_FTHR22_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR22_tag;

typedef union IGF_MCR23_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR23_tag;

typedef union IGF_MSR23_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR23_tag;

typedef union IGF_RTHR23_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR23_tag;

typedef union IGF_FTHR23_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR23_tag;

typedef union IGF_MCR24_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR24_tag;

typedef union IGF_MSR24_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR24_tag;

typedef union IGF_RTHR24_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR24_tag;

typedef union IGF_FTHR24_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR24_tag;

typedef union IGF_MCR25_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR25_tag;

typedef union IGF_MSR25_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR25_tag;

typedef union IGF_RTHR25_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR25_tag;

typedef union IGF_FTHR25_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR25_tag;

typedef union IGF_MCR26_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR26_tag;

typedef union IGF_MSR26_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR26_tag;

typedef union IGF_RTHR26_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR26_tag;

typedef union IGF_FTHR26_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR26_tag;

typedef union IGF_MCR27_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR27_tag;

typedef union IGF_MSR27_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR27_tag;

typedef union IGF_RTHR27_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR27_tag;

typedef union IGF_FTHR27_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR27_tag;

typedef union IGF_MCR28_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR28_tag;

typedef union IGF_MSR28_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR28_tag;

typedef union IGF_RTHR28_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR28_tag;

typedef union IGF_FTHR28_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR28_tag;

typedef union IGF_MCR29_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR29_tag;

typedef union IGF_MSR29_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR29_tag;

typedef union IGF_RTHR29_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR29_tag;

typedef union IGF_FTHR29_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR29_tag;

typedef union IGF_MCR30_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR30_tag;

typedef union IGF_MSR30_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR30_tag;

typedef union IGF_RTHR30_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR30_tag;

typedef union IGF_FTHR30_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR30_tag;

typedef union IGF_MCR31_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze bit for debug operation */
    vuint32_t FBP:1;                   /* Force Bypass */
    vuint32_t FOH:1;                   /* Force filter output high */
    vuint32_t FOL:1;                   /* Force filter output low */
    vuint32_t  :16;
    vuint32_t IMM:1;                   /* Immediate edge propagation control bit */
    vuint32_t PSSEL:1;                 /* Prescaler selection bit */
    vuint32_t POL:1;                   /* Output polarity bit */
    vuint32_t FGEN:1;                  /* Filter global enable */
    vuint32_t  :1;
    vuint32_t FFM:2;                   /* Falling edge filter type selection */
    vuint32_t  :1;
    vuint32_t RFM:2;                   /* Rising edge filter type selection */
  } B;
} IGF_MCR31_tag;

typedef union IGF_MSR31_union_tag {    /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WEDGE:1;                 /* Filter is active waiting for an edge */
    vuint32_t FEDGE:1;                 /* Filter is active processing an edge */
    vuint32_t RNDET:1;                 /* Rise noise detected bit */
    vuint32_t FNDET:1;                 /* Fall noise detected bit */
    vuint32_t FLI:1;                   /* Filter input */
    vuint32_t FLO:1;                   /* Filter output */
  } B;
} IGF_MSR31_tag;

typedef union IGF_RTHR31_union_tag {   /* Rising edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RTH:24;                  /* Rising edge threshold */
  } B;
} IGF_RTHR31_tag;

typedef union IGF_FTHR31_union_tag {   /* Falling edge Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t FTH:24;                  /* Falling edge threshold */
  } B;
} IGF_FTHR31_tag;

struct IGF_tag {
  IGF_MCR_tag MCR;                     /* Module Configuration Register */
  IGF_MSR0_tag MSR0;                   /* Module Status Register */
  uint8_t IGF_reserved0[8];
  IGF_PRESR0_tag PRESR0;               /* Prescaler Register */
  uint8_t IGF_reserved1[8];
  IGF_RTHR0_tag RTHR0;                 /* Rising edge Threshold Register */
  IGF_FTHR0_tag FTHR0;                 /* Falling edge Threshold Register */
  uint8_t IGF_reserved2[28];
  IGF_MCR1_tag MCR1;                   /* Module Configuration Register */
  IGF_MSR1_tag MSR1;                   /* Module Status Register */
  uint8_t IGF_reserved3[20];
  IGF_RTHR1_tag RTHR1;                 /* Rising edge Threshold Register */
  IGF_FTHR1_tag FTHR1;                 /* Falling edge Threshold Register */
  uint8_t IGF_reserved4[28];
  IGF_MCR2_tag MCR2;                   /* Module Configuration Register */
  IGF_MSR2_tag MSR2;                   /* Module Status Register */
  uint8_t IGF_reserved5[20];
  IGF_RTHR2_tag RTHR2;                 /* Rising edge Threshold Register */
  IGF_FTHR2_tag FTHR2;                 /* Falling edge Threshold Register */
  uint8_t IGF_reserved6[28];
  IGF_MCR3_tag MCR3;                   /* Module Configuration Register */
  IGF_MSR3_tag MSR3;                   /* Module Status Register */
  uint8_t IGF_reserved7[20];
  IGF_RTHR3_tag RTHR3;                 /* Rising edge Threshold Register */
  IGF_FTHR3_tag FTHR3;                 /* Falling edge Threshold Register */
  uint8_t IGF_reserved8[28];
  IGF_MCR4_tag MCR4;                   /* Module Configuration Register */
  IGF_MSR4_tag MSR4;                   /* Module Status Register */
  uint8_t IGF_reserved9[20];
  IGF_RTHR4_tag RTHR4;                 /* Rising edge Threshold Register */
  IGF_FTHR4_tag FTHR4;                 /* Falling edge Threshold Register */
  uint8_t IGF_reserved10[28];
  IGF_MCR5_tag MCR5;                   /* Module Configuration Register */
  IGF_MSR5_tag MSR5;                   /* Module Status Register */
  uint8_t IGF_reserved11[20];
  IGF_RTHR5_tag RTHR5;                 /* Rising edge Threshold Register */
  IGF_FTHR5_tag FTHR5;                 /* Falling edge Threshold Register */
  uint8_t IGF_reserved12[28];
  IGF_MCR6_tag MCR6;                   /* Module Configuration Register */
  IGF_MSR6_tag MSR6;                   /* Module Status Register */
  uint8_t IGF_reserved13[20];
  IGF_RTHR6_tag RTHR6;                 /* Rising edge Threshold Register */
  IGF_FTHR6_tag FTHR6;                 /* Falling edge Threshold Register */
  uint8_t IGF_reserved14[28];
  IGF_MCR7_tag MCR7;                   /* Module Configuration Register */
  IGF_MSR7_tag MSR7;                   /* Module Status Register */
  uint8_t IGF_reserved15[20];
  IGF_RTHR7_tag RTHR7;                 /* Rising edge Threshold Register */
  IGF_FTHR7_tag FTHR7;                 /* Falling edge Threshold Register */
  uint8_t IGF_reserved16[28];
  IGF_MCR8_tag MCR8;                   /* Module Configuration Register */
  IGF_MSR8_tag MSR8;                   /* Module Status Register */
  uint8_t IGF_reserved17[20];
  IGF_RTHR8_tag RTHR8;                 /* Rising edge Threshold Register */
  IGF_FTHR8_tag FTHR8;                 /* Falling edge Threshold Register */
  uint8_t IGF_reserved18[28];
  IGF_MCR9_tag MCR9;                   /* Module Configuration Register */
  IGF_MSR9_tag MSR9;                   /* Module Status Register */
  uint8_t IGF_reserved19[20];
  IGF_RTHR9_tag RTHR9;                 /* Rising edge Threshold Register */
  IGF_FTHR9_tag FTHR9;                 /* Falling edge Threshold Register */
  uint8_t IGF_reserved20[28];
  IGF_MCR10_tag MCR10;                 /* Module Configuration Register */
  IGF_MSR10_tag MSR10;                 /* Module Status Register */
  uint8_t IGF_reserved21[20];
  IGF_RTHR10_tag RTHR10;               /* Rising edge Threshold Register */
  IGF_FTHR10_tag FTHR10;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved22[28];
  IGF_MCR11_tag MCR11;                 /* Module Configuration Register */
  IGF_MSR11_tag MSR11;                 /* Module Status Register */
  uint8_t IGF_reserved23[20];
  IGF_RTHR11_tag RTHR11;               /* Rising edge Threshold Register */
  IGF_FTHR11_tag FTHR11;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved24[28];
  IGF_MCR12_tag MCR12;                 /* Module Configuration Register */
  IGF_MSR12_tag MSR12;                 /* Module Status Register */
  uint8_t IGF_reserved25[20];
  IGF_RTHR12_tag RTHR12;               /* Rising edge Threshold Register */
  IGF_FTHR12_tag FTHR12;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved26[28];
  IGF_MCR13_tag MCR13;                 /* Module Configuration Register */
  IGF_MSR13_tag MSR13;                 /* Module Status Register */
  uint8_t IGF_reserved27[20];
  IGF_RTHR13_tag RTHR13;               /* Rising edge Threshold Register */
  IGF_FTHR13_tag FTHR13;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved28[28];
  IGF_MCR14_tag MCR14;                 /* Module Configuration Register */
  IGF_MSR14_tag MSR14;                 /* Module Status Register */
  uint8_t IGF_reserved29[20];
  IGF_RTHR14_tag RTHR14;               /* Rising edge Threshold Register */
  IGF_FTHR14_tag FTHR14;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved30[28];
  IGF_MCR15_tag MCR15;                 /* Module Configuration Register */
  IGF_MSR15_tag MSR15;                 /* Module Status Register */
  uint8_t IGF_reserved31[20];
  IGF_RTHR15_tag RTHR15;               /* Rising edge Threshold Register */
  IGF_FTHR15_tag FTHR15;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved32[28];
  IGF_MCR16_tag MCR16;                 /* Module Configuration Register */
  IGF_MSR16_tag MSR16;                 /* Module Status Register */
  uint8_t IGF_reserved33[20];
  IGF_RTHR16_tag RTHR16;               /* Rising edge Threshold Register */
  IGF_FTHR16_tag FTHR16;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved34[28];
  IGF_MCR17_tag MCR17;                 /* Module Configuration Register */
  IGF_MSR17_tag MSR17;                 /* Module Status Register */
  uint8_t IGF_reserved35[20];
  IGF_RTHR17_tag RTHR17;               /* Rising edge Threshold Register */
  IGF_FTHR17_tag FTHR17;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved36[28];
  IGF_MCR18_tag MCR18;                 /* Module Configuration Register */
  IGF_MSR18_tag MSR18;                 /* Module Status Register */
  uint8_t IGF_reserved37[20];
  IGF_RTHR18_tag RTHR18;               /* Rising edge Threshold Register */
  IGF_FTHR18_tag FTHR18;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved38[28];
  IGF_MCR19_tag MCR19;                 /* Module Configuration Register */
  IGF_MSR19_tag MSR19;                 /* Module Status Register */
  uint8_t IGF_reserved39[20];
  IGF_RTHR19_tag RTHR19;               /* Rising edge Threshold Register */
  IGF_FTHR19_tag FTHR19;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved40[28];
  IGF_MCR20_tag MCR20;                 /* Module Configuration Register */
  IGF_MSR20_tag MSR20;                 /* Module Status Register */
  uint8_t IGF_reserved41[20];
  IGF_RTHR20_tag RTHR20;               /* Rising edge Threshold Register */
  IGF_FTHR20_tag FTHR20;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved42[28];
  IGF_MCR21_tag MCR21;                 /* Module Configuration Register */
  IGF_MSR21_tag MSR21;                 /* Module Status Register */
  uint8_t IGF_reserved43[20];
  IGF_RTHR21_tag RTHR21;               /* Rising edge Threshold Register */
  IGF_FTHR21_tag FTHR21;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved44[28];
  IGF_MCR22_tag MCR22;                 /* Module Configuration Register */
  IGF_MSR22_tag MSR22;                 /* Module Status Register */
  uint8_t IGF_reserved45[20];
  IGF_RTHR22_tag RTHR22;               /* Rising edge Threshold Register */
  IGF_FTHR22_tag FTHR22;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved46[28];
  IGF_MCR23_tag MCR23;                 /* Module Configuration Register */
  IGF_MSR23_tag MSR23;                 /* Module Status Register */
  uint8_t IGF_reserved47[20];
  IGF_RTHR23_tag RTHR23;               /* Rising edge Threshold Register */
  IGF_FTHR23_tag FTHR23;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved48[28];
  IGF_MCR24_tag MCR24;                 /* Module Configuration Register */
  IGF_MSR24_tag MSR24;                 /* Module Status Register */
  uint8_t IGF_reserved49[20];
  IGF_RTHR24_tag RTHR24;               /* Rising edge Threshold Register */
  IGF_FTHR24_tag FTHR24;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved50[28];
  IGF_MCR25_tag MCR25;                 /* Module Configuration Register */
  IGF_MSR25_tag MSR25;                 /* Module Status Register */
  uint8_t IGF_reserved51[20];
  IGF_RTHR25_tag RTHR25;               /* Rising edge Threshold Register */
  IGF_FTHR25_tag FTHR25;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved52[28];
  IGF_MCR26_tag MCR26;                 /* Module Configuration Register */
  IGF_MSR26_tag MSR26;                 /* Module Status Register */
  uint8_t IGF_reserved53[20];
  IGF_RTHR26_tag RTHR26;               /* Rising edge Threshold Register */
  IGF_FTHR26_tag FTHR26;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved54[28];
  IGF_MCR27_tag MCR27;                 /* Module Configuration Register */
  IGF_MSR27_tag MSR27;                 /* Module Status Register */
  uint8_t IGF_reserved55[20];
  IGF_RTHR27_tag RTHR27;               /* Rising edge Threshold Register */
  IGF_FTHR27_tag FTHR27;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved56[28];
  IGF_MCR28_tag MCR28;                 /* Module Configuration Register */
  IGF_MSR28_tag MSR28;                 /* Module Status Register */
  uint8_t IGF_reserved57[20];
  IGF_RTHR28_tag RTHR28;               /* Rising edge Threshold Register */
  IGF_FTHR28_tag FTHR28;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved58[28];
  IGF_MCR29_tag MCR29;                 /* Module Configuration Register */
  IGF_MSR29_tag MSR29;                 /* Module Status Register */
  uint8_t IGF_reserved59[20];
  IGF_RTHR29_tag RTHR29;               /* Rising edge Threshold Register */
  IGF_FTHR29_tag FTHR29;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved60[28];
  IGF_MCR30_tag MCR30;                 /* Module Configuration Register */
  IGF_MSR30_tag MSR30;                 /* Module Status Register */
  uint8_t IGF_reserved61[20];
  IGF_RTHR30_tag RTHR30;               /* Rising edge Threshold Register */
  IGF_FTHR30_tag FTHR30;               /* Falling edge Threshold Register */
  uint8_t IGF_reserved62[28];
  IGF_MCR31_tag MCR31;                 /* Module Configuration Register */
  IGF_MSR31_tag MSR31;                 /* Module Status Register */
  uint8_t IGF_reserved63[20];
  IGF_RTHR31_tag RTHR31;               /* Rising edge Threshold Register */
  IGF_FTHR31_tag FTHR31;               /* Falling edge Threshold Register */
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

typedef union INTC_BCR_union_tag {     /* INTC Block Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :19;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t HVEN1:1;
    vuint32_t  :3;
    vuint32_t HVEN0:1;
  } B;
} INTC_BCR_tag;

typedef union INTC_MPROT_union_tag {   /* INTC Master Protection Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t ID:2;
    vuint32_t  :3;
    vuint32_t MPROT:1;
  } B;
} INTC_MPROT_tag;

typedef union INTC_CPR_union_tag {     /* INTC Current Priority Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t PRI:6;
  } B;
} INTC_CPR_tag;

typedef union INTC_IACKR_union_tag {   /* INTC Interrupt Acknowledge Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t VTBA:20;
    vuint32_t INTVEC:10;
    vuint32_t  :2;
  } B;
} INTC_IACKR_tag;

typedef union INTC_EOIR_union_tag {    /* INTC End Of Interrupt Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t EOI:32;
  } B;
} INTC_EOIR_tag;

typedef union INTC_SSCIR_union_tag {   /* INTC Software Set/Clear Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t  :6;
    vuint8_t SET:1;
    vuint8_t CLR:1;
  } B;
} INTC_SSCIR_tag;

typedef union INTC_PSR_union_tag {     /* INTC Priority Select Register */
  vuint16_t R;
  struct {
    vuint16_t PRC_SELN0:1;
    vuint16_t PRC_SELN1:1;
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :3;
    vuint16_t SWTN:1;
    vuint16_t  :2;
    vuint16_t PRIN:6;
  } B;
} INTC_PSR_tag;

typedef union INTC_CHANNEL_MMRC_union_tag { /* INTC Monitor Mode Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t MM:2;
  } B;
} INTC_CHANNEL_MMRC_tag;

typedef union INTC_CHANNEL_HIPRIC_union_tag { /* INTC HIPRI Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t IRQ:10;
  } B;
} INTC_CHANNEL_HIPRIC_tag;

typedef union INTC_CHANNEL_LATC_union_tag { /* INTC LAT Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t LAT:24;
  } B;
} INTC_CHANNEL_LATC_tag;

typedef union INTC_CHANNEL_TIMERC_union_tag { /* INTC Timer Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t TIMER:24;
  } B;
} INTC_CHANNEL_TIMERC_tag;

typedef struct INTC_CHANNEL_struct_tag {
  INTC_CHANNEL_MMRC_tag MMRC;          /* INTC Monitor Mode Register 0 */
  INTC_CHANNEL_HIPRIC_tag HIPRIC[4];   /* INTC HIPRI Register */
  INTC_CHANNEL_LATC_tag LATC[4];       /* INTC LAT Register */
  INTC_CHANNEL_TIMERC_tag TIMERC[4];   /* INTC Timer Register */
} INTC_CHANNEL_tag;

struct INTC_tag {
  INTC_BCR_tag BCR;                    /* INTC Block Configuration Register */
  INTC_MPROT_tag MPROT;                /* INTC Master Protection Register */
  uint8_t INTC_reserved0[8];
  INTC_CPR_tag CPR[2];                 /* INTC Current Priority Register for Processor 0 */
  uint8_t INTC_reserved1[8];
  INTC_IACKR_tag IACKR[2];             /* INTC Interrupt Acknowledge Register for Processor 0 */
  uint8_t INTC_reserved2[8];
  INTC_EOIR_tag EOIR[2];               /* INTC End Of Interrupt Register for Processor 0 */
  uint8_t INTC_reserved3[8];
  INTC_SSCIR_tag SSCIR[32];            /* INTC Software Set/Clear Interrupt Register */
  INTC_PSR_tag PSR[1024];              /* INTC Priority Select Register */
  uint8_t INTC_reserved4[1952];
  INTC_CHANNEL_tag CHANNEL[2];
};


/* ============================================================================
   =============================== Module: IRCOSC =============================
   ============================================================================ */

typedef union IRCOSC_CTL_union_tag {   /* IRCOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t USER_TRIM:5;
    vuint32_t  :3;
    vuint32_t  :5;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t  :5;
  } B;
} IRCOSC_CTL_tag;

struct IRCOSC_tag {
  IRCOSC_CTL_tag CTL;                  /* IRCOSC Control Register */
};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

typedef union JDC_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t JIN_IEN:1;
    vuint32_t  :15;
    vuint32_t JOUT_IEN:1;
  } B;
} JDC_MCR_tag;

typedef union JDC_MSR_union_tag {      /* Module Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t JIN_RDY:1;
    vuint32_t  :1;
    vuint32_t JIN_INT:1;
    vuint32_t  :13;
    vuint32_t JOUT_RDY:1;
    vuint32_t  :1;
    vuint32_t JOUT_INT:1;
  } B;
} JDC_MSR_tag;

typedef union JDC_JOUT_IPS_union_tag { /* JTAG Output Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JOUT_IPS_tag;

typedef union JDC_JIN_IPS_union_tag {  /* JTAG Input Data Register */
  vuint32_t R;
  struct {
    vuint32_t Data:32;
  } B;
} JDC_JIN_IPS_tag;

struct JDC_tag {
  JDC_MCR_tag MCR;                     /* Module Configuration Register */
  JDC_MSR_tag MSR;                     /* Module Status Register */
  JDC_JOUT_IPS_tag JOUT_IPS;           /* JTAG Output Data Register */
  JDC_JIN_IPS_tag JIN_IPS;             /* JTAG Input Data Register */
};


/* ============================================================================
   =============================== Module: JTAGM ==============================
   ============================================================================ */

typedef union JTAGM_MCR_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SWRESET:1;
    vuint32_t  :17;
    vuint32_t inter_jtag_frame_timer:6;
    vuint32_t  :1;
    vuint32_t SIE:1;
    vuint32_t IIE:1;
    vuint32_t TCKSEL:3;
    vuint32_t jtagm_JCOMP:1;
    vuint32_t DTM:1;
  } B;
} JTAGM_MCR_tag;

typedef union JTAGM_SR_union_tag {     /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :6;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t JTAGEN:1;
    vuint32_t  :1;
    vuint32_t JTAGSAFE:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t TOOL:1;
    vuint32_t  :2;
    vuint32_t SPU_INT_CLR:1;
    vuint32_t SPU_INT:1;
    vuint32_t  :1;
    vuint32_t Nexus_err:1;
    vuint32_t Idle:1;
    vuint32_t NR:1;
    vuint32_t  :8;
  } B;
} JTAGM_SR_tag;

typedef union JTAGM_DOR0_union_tag {   /* Data Out Register 0 */
  vuint32_t R;
  struct {
    vuint32_t TMS_HIGH:32;
  } B;
} JTAGM_DOR0_tag;

typedef union JTAGM_DOR1_union_tag {   /* Data Out Register 1 */
  vuint32_t R;
  struct {
    vuint32_t TMS_LOW:28;
    vuint32_t  :4;
  } B;
} JTAGM_DOR1_tag;

typedef union JTAGM_DOR2_union_tag {   /* Data Out Register 2 */
  vuint32_t R;
  struct {
    vuint32_t TDI_HIGH:32;
  } B;
} JTAGM_DOR2_tag;

typedef union JTAGM_DOR3_union_tag {   /* Data Out Register 3 */
  vuint32_t R;
  struct {
    vuint32_t TDI_LOW:28;
    vuint32_t  :3;
    vuint32_t Send:1;
  } B;
} JTAGM_DOR3_tag;

typedef union JTAGM_DIR0_union_tag {   /* Data Input Register 0 */
  vuint32_t R;
  struct {
    vuint32_t TDO_LOW:32;
  } B;
} JTAGM_DIR0_tag;

typedef union JTAGM_DIR1_union_tag {   /* Data Input Register 1 */
  vuint32_t R;
  struct {
    vuint32_t TDO_HIGH:28;
    vuint32_t  :4;
  } B;
} JTAGM_DIR1_tag;

struct JTAGM_tag {
  JTAGM_MCR_tag MCR;                   /* Module Configuration Register */
  JTAGM_SR_tag SR;                     /* Status Register */
  JTAGM_DOR0_tag DOR0;                 /* Data Out Register 0 */
  JTAGM_DOR1_tag DOR1;                 /* Data Out Register 1 */
  JTAGM_DOR2_tag DOR2;                 /* Data Out Register 2 */
  JTAGM_DOR3_tag DOR3;                 /* Data Out Register 3 */
  uint8_t JTAGM_reserved0[4];
  JTAGM_DIR0_tag DIR0;                 /* Data Input Register 0 */
  JTAGM_DIR1_tag DIR1;                 /* Data Input Register 1 */
};


/* ============================================================================
   =============================== Module: LFAST ==============================
   ============================================================================ */

typedef union LFAST_MCR_union_tag {    /* LFAST Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSEN:1;
    vuint32_t  :6;
    vuint32_t IPGDBG:1;
    vuint32_t  :7;
    vuint32_t LSSEL:1;
    vuint32_t DRFEN:1;
    vuint32_t RXEN:1;
    vuint32_t TXEN:1;
    vuint32_t  :8;
    vuint32_t TXARBD:1;
    vuint32_t CTSEN:1;
    vuint32_t  :1;
    vuint32_t DRFRST:1;
    vuint32_t DATAEN:1;
  } B;
} LFAST_MCR_tag;

typedef union LFAST_SCR_union_tag {    /* LFAST Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t DRMD:1;
    vuint32_t  :7;
    vuint32_t RDR:1;
    vuint32_t  :7;
    vuint32_t TDR:1;
  } B;
} LFAST_SCR_tag;

typedef union LFAST_COCR_union_tag {   /* LFAST Correlator Control Register */
  vuint32_t R;
  struct {
    vuint32_t SMPSEL:8;
    vuint32_t  :6;
    vuint32_t  :2;
    vuint32_t  :12;
    vuint32_t CORRTH:3;
    vuint32_t PHSSEL:1;
  } B;
} LFAST_COCR_tag;

typedef union LFAST_TMCR_union_tag {   /* LFAST Test Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t CLKTST:1;
    vuint32_t LPON:1;
    vuint32_t  :5;
    vuint32_t LPMOD:3;
    vuint32_t LPFRMTH:16;
  } B;
} LFAST_TMCR_tag;

typedef union LFAST_ALCR_union_tag {   /* LFAST Auto Loopback Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t LPCNTEN:1;
    vuint32_t LPFMCNT:16;
  } B;
} LFAST_ALCR_tag;

typedef union LFAST_RCDCR_union_tag {  /* LFAST Rate Change Delay Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DRCNT:4;
    vuint32_t  :16;
  } B;
} LFAST_RCDCR_tag;

typedef union LFAST_SLCR_union_tag {   /* LFAST Wakeup Delay Control Register */
  vuint32_t R;
  struct {
    vuint32_t HSCNT:8;
    vuint32_t  :4;
    vuint32_t LSCNT:4;
    vuint32_t HWKCNT:8;
    vuint32_t  :4;
    vuint32_t LWKCNT:4;
  } B;
} LFAST_SLCR_tag;

typedef union LFAST_ICR_union_tag {    /* LFAST ICLC Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t ICLCSEQ:1;
    vuint32_t SNDICLC:1;
    vuint32_t  :8;
    vuint32_t ICLCPLD:8;
  } B;
} LFAST_ICR_tag;

typedef union LFAST_PICR_union_tag {   /* LFAST Ping Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t PNGREQ:1;
    vuint32_t PNGAUTO:1;
    vuint32_t  :7;
    vuint32_t PNGPYLD:8;
  } B;
} LFAST_PICR_tag;

typedef union LFAST_RFCR_union_tag {   /* LFAST Rx FIFO CTS Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t RCTSMX:6;
    vuint32_t  :10;
    vuint32_t RCTSMN:6;
  } B;
} LFAST_RFCR_tag;

typedef union LFAST_TIER_union_tag {   /* LFAST Tx Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t TXIIE:1;
    vuint32_t TXOVIE:1;
    vuint32_t  :11;
    vuint32_t TXPNGIE:1;
    vuint32_t  :1;
    vuint32_t TXUNSIE:1;
    vuint32_t TXICLCIE:1;
    vuint32_t TXDTIE:1;
  } B;
} LFAST_TIER_tag;

typedef union LFAST_RIER_union_tag {   /* LFAST Rx Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RXUOIE:1;
    vuint32_t RXMNIE:1;
    vuint32_t RXMXIE:1;
    vuint32_t RXUFIE:1;
    vuint32_t RXOFIE:1;
    vuint32_t RXSZIE:1;
    vuint32_t RXICIE:1;
    vuint32_t RXLCEIE:1;
    vuint32_t  :12;
    vuint32_t RXCTSIE:1;
    vuint32_t RXDIE:1;
    vuint32_t RXUNSIE:1;
    vuint32_t  :1;
  } B;
} LFAST_RIER_tag;

typedef union LFAST_RIIER_union_tag {  /* LFAST Rx ICLC Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t ICPFIE:1;
    vuint32_t ICPSIE:1;
    vuint32_t ICPRIE:1;
    vuint32_t ICTOIE:1;
    vuint32_t ICLPIE:1;
    vuint32_t ICCTIE:1;
    vuint32_t ICTDIE:1;
    vuint32_t ICTEIE:1;
    vuint32_t ICRFIE:1;
    vuint32_t ICRSIE:1;
    vuint32_t ICTFIE:1;
    vuint32_t ICTSIE:1;
    vuint32_t ICPOFIE:1;
    vuint32_t ICPONIE:1;
  } B;
} LFAST_RIIER_tag;

typedef union LFAST_PLLCR_union_tag {  /* LFAST PLL Control Register */
  vuint32_t R;
  struct {
    vuint32_t IPTMOD:3;
    vuint32_t  :11;
    vuint32_t SWPOFF:1;
    vuint32_t SWPON:1;
    vuint32_t REFINV:1;
    vuint32_t LPCFG:2;
    vuint32_t  :2;
    vuint32_t PLCKCW:2;
    vuint32_t FDIVEN:1;
    vuint32_t FBDIV:6;
    vuint32_t PREDIV:2;
  } B;
} LFAST_PLLCR_tag;

typedef union LFAST_LCR_union_tag {    /* LFAST LVDS Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t SWWKLD:1;
    vuint32_t SWSLPLD:1;
    vuint32_t SWWKLR:1;
    vuint32_t SWSLPLR:1;
    vuint32_t SWOFFLD:1;
    vuint32_t SWONLD:1;
    vuint32_t SWOFFLR:1;
    vuint32_t SWONLR:1;
    vuint32_t LVRXOFF:1;
    vuint32_t LVTXOE:1;
    vuint32_t TXCMUX:1;
    vuint32_t LVRFEN:1;
    vuint32_t LVLPEN:1;                /* Tx LVDS internal loopback enable */
    vuint32_t  :5;
    vuint32_t LVRXOP_TR:1;
    vuint32_t  :1;
    vuint32_t LVRXOP_BR:1;
    vuint32_t LVTXOP:1;
    vuint32_t LVCKSS:1;                /* LVDS Clock Sync Select */
    vuint32_t LVCKP:1;
  } B;
} LFAST_LCR_tag;

typedef union LFAST_UNSTCR_union_tag { /* LFAST Unsolicited Tx Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t USNDRQ:1;
    vuint32_t  :9;
    vuint32_t UNSHDR:7;
  } B;
} LFAST_UNSTCR_tag;

typedef union LFAST_UNSTDR_union_tag { /* LFAST Unsolicited Tx Data Registers */
  vuint32_t R;
  struct {
    vuint32_t UNTXD:32;
  } B;
} LFAST_UNSTDR_tag;

typedef union LFAST_GSR_union_tag {    /* LFAST Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t DUALMD:1;
    vuint32_t  :12;
    vuint32_t LRMD:1;
    vuint32_t LDSM:1;
    vuint32_t DRSM:1;
    vuint32_t  :11;
    vuint32_t LPTXDN:1;
    vuint32_t LPFPDV:1;
    vuint32_t LPCPDV:1;
    vuint32_t LPCHDV:1;
    vuint32_t LPCSDV:1;
  } B;
} LFAST_GSR_tag;

typedef union LFAST_PISR_union_tag {   /* LFAST Ping Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RXPNGD:8;
  } B;
} LFAST_PISR_tag;

typedef union LFAST_DFSR_union_tag {   /* LFAST Data Frame Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t RXDCNT:6;
    vuint32_t  :5;
    vuint32_t RXFCNT:3;
    vuint32_t  :2;
    vuint32_t TXDCNT:6;
    vuint32_t  :5;
    vuint32_t TXFCNT:3;
  } B;
} LFAST_DFSR_tag;

typedef union LFAST_TISR_union_tag {   /* LFAST Tx Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t TXIEF:1;
    vuint32_t TXOVF:1;
    vuint32_t  :11;
    vuint32_t TXPNGF:1;
    vuint32_t  :1;
    vuint32_t TXUNSF:1;
    vuint32_t TXICLCF:1;
    vuint32_t TXDTF:1;
  } B;
} LFAST_TISR_tag;

typedef union LFAST_RISR_union_tag {   /* LFAST Rx Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t RXUOF:1;
    vuint32_t RXMNF:1;
    vuint32_t RXMXF:1;
    vuint32_t RXUFF:1;
    vuint32_t RXOFF:1;
    vuint32_t RXSZF:1;
    vuint32_t RXICF:1;
    vuint32_t RXLCEF:1;
    vuint32_t  :12;
    vuint32_t RXCTSF:1;
    vuint32_t RXDF:1;
    vuint32_t RXUNSF:1;
    vuint32_t  :1;
  } B;
} LFAST_RISR_tag;

typedef union LFAST_RIISR_union_tag {  /* LFAST Rx ICLC Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;
    vuint32_t ICPFF:1;
    vuint32_t ICPSF:1;
    vuint32_t ICPRF:1;
    vuint32_t ICTOF:1;
    vuint32_t ICLPF:1;
    vuint32_t ICCTF:1;
    vuint32_t ICTDF:1;
    vuint32_t ICTEF:1;
    vuint32_t ICRFF:1;
    vuint32_t ICRSF:1;
    vuint32_t ICTFF:1;
    vuint32_t ICTSF:1;
    vuint32_t ICPOFF:1;
    vuint32_t ICPONF:1;
  } B;
} LFAST_RIISR_tag;

typedef union LFAST_PLLLSR_union_tag { /* LFAST PLL and LVDS Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t PLLDIS:1;
    vuint32_t PLDCR:1;
    vuint32_t  :12;
    vuint32_t LRSLPS:1;
    vuint32_t LDSLPS:1;
    vuint32_t LDPDS:1;
    vuint32_t LRPDS:1;
  } B;
} LFAST_PLLLSR_tag;

typedef union LFAST_UNSRSR_union_tag { /* LFAST Unsolicited Rx Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t URXDV:1;
    vuint32_t  :5;
    vuint32_t URPCNT:3;
  } B;
} LFAST_UNSRSR_tag;

typedef union LFAST_UNSRDR_union_tag { /* LFAST Unsolicited Rx Data Register */
  vuint32_t R;
  struct {
    vuint32_t UNRXD:32;
  } B;
} LFAST_UNSRDR_tag;

struct LFAST_tag {
  LFAST_MCR_tag MCR;                   /* LFAST Mode Configuration Register */
  LFAST_SCR_tag SCR;                   /* LFAST Speed Control Register */
  LFAST_COCR_tag COCR;                 /* LFAST Correlator Control Register */
  LFAST_TMCR_tag TMCR;                 /* LFAST Test Mode Control Register */
  LFAST_ALCR_tag ALCR;                 /* LFAST Auto Loopback Control Register */
  LFAST_RCDCR_tag RCDCR;               /* LFAST Rate Change Delay Control Register */
  LFAST_SLCR_tag SLCR;                 /* LFAST Wakeup Delay Control Register */
  LFAST_ICR_tag ICR;                   /* LFAST ICLC Control Register */
  LFAST_PICR_tag PICR;                 /* LFAST Ping Control Register */
  uint8_t LFAST_reserved0[8];
  LFAST_RFCR_tag RFCR;                 /* LFAST Rx FIFO CTS Control Register */
  LFAST_TIER_tag TIER;                 /* LFAST Tx Interrupt Enable Register */
  LFAST_RIER_tag RIER;                 /* LFAST Rx Interrupt Enable Register */
  LFAST_RIIER_tag RIIER;               /* LFAST Rx ICLC Interrupt Enable Register */
  LFAST_PLLCR_tag PLLCR;               /* LFAST PLL Control Register */
  LFAST_LCR_tag LCR;                   /* LFAST LVDS Control Register */
  LFAST_UNSTCR_tag UNSTCR;             /* LFAST Unsolicited Tx Control Register */
  LFAST_UNSTDR_tag UNSTDR[9];          /* LFAST Unsolicited Tx Data Registers */
  uint8_t LFAST_reserved1[20];
  LFAST_GSR_tag GSR;                   /* LFAST Global Status Register */
  LFAST_PISR_tag PISR;                 /* LFAST Ping Status Register */
  uint8_t LFAST_reserved2[12];
  LFAST_DFSR_tag DFSR;                 /* LFAST Data Frame Status Register */
  LFAST_TISR_tag TISR;                 /* LFAST Tx Interrupt Status Register */
  LFAST_RISR_tag RISR;                 /* LFAST Rx Interrupt Status Register */
  LFAST_RIISR_tag RIISR;               /* LFAST Rx ICLC Interrupt Status Register */
  LFAST_PLLLSR_tag PLLLSR;             /* LFAST PLL and LVDS Status Register */
  LFAST_UNSRSR_tag UNSRSR;             /* LFAST Unsolicited Rx Status Register */
  LFAST_UNSRDR_tag UNSRDR[9];          /* LFAST Unsolicited Rx Data Register */
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

typedef union LINFlexD_LINCR1_union_tag { /* LIN Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CCD:1;
    vuint32_t CFD:1;
    vuint32_t LASE:1;
    vuint32_t AUTOWU:1;
    vuint32_t MBL:4;
    vuint32_t BF:1;
    vuint32_t  :1;
    vuint32_t LBKM:1;
    vuint32_t MME:1;
    vuint32_t SSBL:1;
    vuint32_t RBLM:1;
    vuint32_t SLEEP:1;
    vuint32_t INIT:1;
  } B;
} LINFlexD_LINCR1_tag;

typedef union LINFlexD_LINIER_union_tag { /* LIN Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SZIE:1;
    vuint32_t OCIE:1;
    vuint32_t BEIE:1;
    vuint32_t CEIE:1;
    vuint32_t HEIE:1;
    vuint32_t  :2;
    vuint32_t FEIE:1;
    vuint32_t BOIE:1;
    vuint32_t LSIE:1;
    vuint32_t WUIE:1;
    vuint32_t DBFIE:1;
    vuint32_t DBEIETOIE:1;
    vuint32_t DRIE:1;
    vuint32_t DTIE:1;
    vuint32_t HRIE:1;
  } B;
} LINFlexD_LINIER_tag;

typedef union LINFlexD_LINSR_union_tag { /* LIN Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t AUTOSYNC_COMP:1;
    vuint32_t RDC:3;
    vuint32_t LINS:4;                  /* LIN state */
    vuint32_t  :2;
    vuint32_t RMB:1;
    vuint32_t DRBNE:1;
    vuint32_t RXbusy:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t DBFF:1;
    vuint32_t DBEF:1;
    vuint32_t DRF:1;
    vuint32_t DTF:1;
    vuint32_t HRF:1;
  } B;
} LINFlexD_LINSR_tag;

typedef union LINFlexD_LINESR_union_tag { /* LIN Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t BEF:1;
    vuint32_t CEF:1;
    vuint32_t SFEF:1;
    vuint32_t SDEF:1;
    vuint32_t IDPEF:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t  :6;
    vuint32_t NF:1;
  } B;
} LINFlexD_LINESR_tag;

typedef union LINFlexD_UARTCR_union_tag { /* UART Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIS:1;
    vuint32_t CSP:3;
    vuint32_t OSR:4;
    vuint32_t ROSE:1;
    vuint32_t NEF:3;
    vuint32_t DTU_PCETX:1;             /* Disable Timeout in UART mode */
    vuint32_t SBUR:2;
    vuint32_t WLS:1;
    vuint32_t TDFL_TFC:3;
    vuint32_t RDFL_RFC:3;
    vuint32_t RFBM:1;
    vuint32_t TFBM:1;
    vuint32_t WL1:1;
    vuint32_t PC1:1;
    vuint32_t RxEn:1;
    vuint32_t TxEn:1;
    vuint32_t PC0:1;
    vuint32_t PCE:1;
    vuint32_t WL0:1;
    vuint32_t UART:1;
  } B;
} LINFlexD_UARTCR_tag;

typedef union LINFlexD_UARTSR_union_tag { /* UART Mode Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t PE:4;
    vuint32_t RMB:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t RFNE:1;
    vuint32_t TO:1;
    vuint32_t DRFRFE:1;
    vuint32_t DTFTFF:1;
    vuint32_t NF:1;
  } B;
} LINFlexD_UARTSR_tag;

typedef union LINFlexD_LINTCSR_union_tag { /* LIN Time-Out Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t MODE:1;
    vuint32_t IOT:1;
    vuint32_t TOCE:1;
    vuint32_t CNT:8;
  } B;
} LINFlexD_LINTCSR_tag;

typedef union LINFlexD_LINOCR_union_tag { /* LIN Output Compare Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t OC2:8;
    vuint32_t OC1:8;
  } B;
} LINFlexD_LINOCR_tag;

typedef union LINFlexD_LINTOCR_union_tag { /* LIN Time-Out Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t RTO:4;
    vuint32_t  :1;
    vuint32_t HTO:7;
  } B;
} LINFlexD_LINTOCR_tag;

typedef union LINFlexD_LINFBRR_union_tag { /* LIN Fractional Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t FBR:4;
  } B;
} LINFlexD_LINFBRR_tag;

typedef union LINFlexD_LINIBRR_union_tag { /* LIN Integer Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t IBR:20;
  } B;
} LINFlexD_LINIBRR_tag;

typedef union LINFlexD_LINCFR_union_tag { /* LIN Checksum Field Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t CF:8;
  } B;
} LINFlexD_LINCFR_tag;

typedef union LINFlexD_LINCR2_union_tag { /* LIN Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t TBDE:1;
    vuint32_t IOBE:1;
    vuint32_t IOPE:1;
    vuint32_t WURQ:1;
    vuint32_t DDRQ:1;
    vuint32_t DTRQ:1;
    vuint32_t ABRQ:1;
    vuint32_t HTRQ:1;
    vuint32_t  :8;
  } B;
} LINFlexD_LINCR2_tag;

typedef union LINFlexD_BIDR_union_tag { /* Buffer Identifier Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DFL:6;
    vuint32_t DIR:1;
    vuint32_t CCS:1;
    vuint32_t  :2;
    vuint32_t ID:6;
  } B;
} LINFlexD_BIDR_tag;

typedef union LINFlexD_BDRL_union_tag { /* Buffer Data Register Least Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA3:8;
    vuint32_t DATA2:8;
    vuint32_t DATA1:8;
    vuint32_t DATA0:8;
  } B;
} LINFlexD_BDRL_tag;

typedef union LINFlexD_BDRM_union_tag { /* Buffer Data Register Most Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA7:8;
    vuint32_t DATA6:8;
    vuint32_t DATA5:8;
    vuint32_t DATA4:8;
  } B;
} LINFlexD_BDRM_tag;

typedef union LINFlexD_IFER_union_tag { /* Identifier Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t FACT:16;
  } B;
} LINFlexD_IFER_tag;

typedef union LINFlexD_IFMI_union_tag { /* Identifier Filter Match Index */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t IFMI:5;
  } B;
} LINFlexD_IFMI_tag;

typedef union LINFlexD_IFMR_union_tag { /* Identifier Filter Mode Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t IFM:8;
  } B;
} LINFlexD_IFMR_tag;

typedef union LINFlexD_IFCR_union_tag { /* Identifier Filter Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DFL:6;                   /* Data Field Length */
    vuint32_t DIR:1;                   /* Direction */
    vuint32_t CCS:1;                   /* Classic Checksum */
    vuint32_t  :2;
    vuint32_t ID:6;                    /* Identifier */
  } B;
} LINFlexD_IFCR_tag;

typedef union LINFlexD_GCR_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t TDFBM:1;
    vuint32_t RDFBM:1;
    vuint32_t TDLIS:1;
    vuint32_t RDLIS:1;
    vuint32_t STOP:1;
    vuint32_t SR:1;
  } B;
} LINFlexD_GCR_tag;

typedef union LINFlexD_UARTPTO_union_tag { /* UART Preset Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t PTO:12;
  } B;
} LINFlexD_UARTPTO_tag;

typedef union LINFlexD_UARTCTO_union_tag { /* UART Current Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t CTO:12;
  } B;
} LINFlexD_UARTCTO_tag;

typedef union LINFlexD_DMATXE_union_tag { /* DMA Tx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DTE:16;
  } B;
} LINFlexD_DMATXE_tag;

typedef union LINFlexD_DMARXE_union_tag { /* DMA Rx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DRE:16;
  } B;
} LINFlexD_DMARXE_tag;

struct LINFlexD_tag {
  LINFlexD_LINCR1_tag LINCR1;          /* LIN Control Register 1 */
  LINFlexD_LINIER_tag LINIER;          /* LIN Interrupt enable register */
  LINFlexD_LINSR_tag LINSR;            /* LIN Status Register */
  LINFlexD_LINESR_tag LINESR;          /* LIN Error Status Register */
  LINFlexD_UARTCR_tag UARTCR;          /* UART Mode Control Register */
  LINFlexD_UARTSR_tag UARTSR;          /* UART Mode Status Register */
  LINFlexD_LINTCSR_tag LINTCSR;        /* LIN Time-Out Control Status Register */
  LINFlexD_LINOCR_tag LINOCR;          /* LIN Output Compare Register */
  LINFlexD_LINTOCR_tag LINTOCR;        /* LIN Time-Out Control Register */
  LINFlexD_LINFBRR_tag LINFBRR;        /* LIN Fractional Baud Rate Register */
  LINFlexD_LINIBRR_tag LINIBRR;        /* LIN Integer Baud Rate Register */
  LINFlexD_LINCFR_tag LINCFR;          /* LIN Checksum Field Register */
  LINFlexD_LINCR2_tag LINCR2;          /* LIN Control Register 2 */
  LINFlexD_BIDR_tag BIDR;              /* Buffer Identifier Register */
  LINFlexD_BDRL_tag BDRL;              /* Buffer Data Register Least Significant */
  LINFlexD_BDRM_tag BDRM;              /* Buffer Data Register Most Significant */
  LINFlexD_IFER_tag IFER;              /* Identifier Filter Enable Register */
  LINFlexD_IFMI_tag IFMI;              /* Identifier Filter Match Index */
  LINFlexD_IFMR_tag IFMR;              /* Identifier Filter Mode Register */
  LINFlexD_IFCR_tag IFCR[16];          /* Identifier Filter Control Register */
  LINFlexD_GCR_tag GCR;                /* Global Control Register */
  LINFlexD_UARTPTO_tag UARTPTO;        /* UART Preset Timeout Register */
  LINFlexD_UARTCTO_tag UARTCTO;        /* UART Current Timeout Register */
  LINFlexD_DMATXE_tag DMATXE;          /* DMA Tx Enable Register */
  LINFlexD_DMARXE_tag DMARXE;          /* DMA Rx Enable Register */
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

typedef union MC_CGM_PCS_SDUR_union_tag { /* PCS Switch Duration */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} MC_CGM_PCS_SDUR_tag;

typedef union MC_CGM_PCS_DIVC1_union_tag { /* PCS Divider Change for external crystal oscillator */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t  :8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC1_tag;

typedef union MC_CGM_PCS_DIVE1_union_tag { /* PCS Divider End for external crystal oscillator */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE1_tag;

typedef union MC_CGM_PCS_DIVS1_union_tag { /* PCS Divider Start for external crystal oscillator */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS1_tag;

typedef union MC_CGM_PCS_DIVC2_union_tag { /* PCS Divider Change for PLL0 PHI */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t  :8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC2_tag;

typedef union MC_CGM_PCS_DIVE2_union_tag { /* PCS Divider End for PLL0 PHI */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE2_tag;

typedef union MC_CGM_PCS_DIVS2_union_tag { /* PCS Divider Start for PLL0 PHI */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS2_tag;

typedef union MC_CGM_PCS_DIVC4_union_tag { /* PCS Divider Change for PLL1 PHI */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t  :8;
    vuint32_t RATE:8;
  } B;
} MC_CGM_PCS_DIVC4_tag;

typedef union MC_CGM_PCS_DIVE4_union_tag { /* PCS Divider End for PLL1 PHI */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVE:20;
  } B;
} MC_CGM_PCS_DIVE4_tag;

typedef union MC_CGM_PCS_DIVS4_union_tag { /* PCS Divider Start for PLL1 PHI */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t DIVS:20;
  } B;
} MC_CGM_PCS_DIVS4_tag;

typedef union MC_CGM_SC_DIV_RC_union_tag { /* System Clock Divider Ratio Change Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t SYS_DIV_RATIO_CHNG:1;
  } B;
} MC_CGM_SC_DIV_RC_tag;

typedef union MC_CGM_DIV_UPD_TYPE_union_tag { /* Divider Update Type */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_TYPE:1;
    vuint32_t  :20;
    vuint32_t AUX10_UPD_TYPE:1;
    vuint32_t AUX9_UPD_TYPE:1;
    vuint32_t AUX8_UPD_TYPE:1;
    vuint32_t  :1;
    vuint32_t AUX6_UPD_TYPE:1;
    vuint32_t AUX5_UPD_TYPE:1;
    vuint32_t  :2;
    vuint32_t AUX2_UPD_TYPE:1;
    vuint32_t AUX1_UPD_TYPE:1;
    vuint32_t AUX0_UPD_TYPE:1;
  } B;
} MC_CGM_DIV_UPD_TYPE_tag;

typedef union MC_CGM_DIV_UPD_TRIG_union_tag { /* Divider Update Trigger */
  vuint32_t R;
  struct {
    vuint32_t DIV_UPD_TRIGGER:32;
  } B;
} MC_CGM_DIV_UPD_TRIG_tag;

typedef union MC_CGM_DIV_UPD_STAT_union_tag { /* Divider Update Status */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_STAT:1;
    vuint32_t  :20;
    vuint32_t AUX10_UPD_STAT:1;
    vuint32_t AUX9_UPD_STAT:1;
    vuint32_t AUX8_UPD_STAT:1;
    vuint32_t  :1;
    vuint32_t AUX6_UPD_STAT:1;
    vuint32_t AUX5_UPD_STAT:1;
    vuint32_t  :2;
    vuint32_t AUX2_UPD_STAT:1;
    vuint32_t AUX1_UPD_STAT:1;
    vuint32_t AUX0_UPD_STAT:1;
  } B;
} MC_CGM_DIV_UPD_STAT_tag;

typedef union MC_CGM_SC_SS_union_tag { /* System Clock Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :4;
    vuint32_t SWTRG:3;
    vuint32_t SWIP:1;
    vuint32_t  :16;
  } B;
} MC_CGM_SC_SS_tag;

typedef union MC_CGM_SC_DC0_union_tag { /* System Clock Divider Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_SC_DC0_tag;

typedef union MC_CGM_SC_DC1_union_tag { /* System Clock Divider Configuration 1 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_SC_DC1_tag;

typedef union MC_CGM_SC_DC2_union_tag { /* System Clock Divider Configuration 2 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_SC_DC2_tag;

typedef union MC_CGM_AC0_SC_union_tag { /* Aux Clock 0 Select Control */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC0_SC_tag;

typedef union MC_CGM_AC0_SS_union_tag { /* Aux Clock 0 Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC0_SS_tag;

typedef union MC_CGM_AC0_DC0_union_tag { /* Aux Clock 0 Divider Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :11;
    vuint32_t DIV:4;
    vuint32_t  :16;
  } B;
} MC_CGM_AC0_DC0_tag;

typedef union MC_CGM_AC0_DC1_union_tag { /* Aux Clock 0 Divider Configuration 1 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :8;
    vuint32_t DIV:7;
    vuint32_t  :16;
  } B;
} MC_CGM_AC0_DC1_tag;

typedef union MC_CGM_AC0_DC2_union_tag { /* Aux Clock 0 Divider Configuration 2 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :8;
    vuint32_t DIV:7;
    vuint32_t  :16;
  } B;
} MC_CGM_AC0_DC2_tag;

typedef union MC_CGM_AC0_DC3_union_tag { /* Aux Clock 0 Divider Configuration 3 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :2;
    vuint32_t DIV:13;
    vuint32_t  :14;
    vuint32_t DIV_FMT:2;
  } B;
} MC_CGM_AC0_DC3_tag;

typedef union MC_CGM_AC0_DC4_union_tag { /* Aux Clock 0 Divider Configuration 4 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC0_DC4_tag;

typedef union MC_CGM_AC1_SC_union_tag { /* Aux Clock 1 Select Control */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC1_SC_tag;

typedef union MC_CGM_AC1_SS_union_tag { /* Aux Clock 1 Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC1_SS_tag;

typedef union MC_CGM_AC1_DC0_union_tag { /* Aux Clock 1 Divider Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :8;
    vuint32_t DIV:7;
    vuint32_t  :16;
  } B;
} MC_CGM_AC1_DC0_tag;

typedef union MC_CGM_AC2_SC_union_tag { /* Aux Clock 2 Select Control */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC2_SC_tag;

typedef union MC_CGM_AC2_SS_union_tag { /* Aux Clock 2 Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC2_SS_tag;

typedef union MC_CGM_AC2_DC0_union_tag { /* Aux Clock 2 Divider Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC2_DC0_tag;

typedef union MC_CGM_AC3_SC_union_tag { /* Aux Clock 3 Select Control */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC3_SC_tag;

typedef union MC_CGM_AC3_SS_union_tag { /* Aux Clock 3 Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC3_SS_tag;

typedef union MC_CGM_AC4_SC_union_tag { /* Aux Clock 4 Select Control */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC4_SC_tag;

typedef union MC_CGM_AC4_SS_union_tag { /* Aux Clock 4 Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC4_SS_tag;

typedef union MC_CGM_AC5_SC_union_tag { /* Aux Clock 5 Select Control */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC5_SC_tag;

typedef union MC_CGM_AC5_SS_union_tag { /* Aux Clock 5 Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC5_SS_tag;

typedef union MC_CGM_AC5_DC0_union_tag { /* Aux Clock 5 Divider Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_DC0_tag;

typedef union MC_CGM_AC5_DC1_union_tag { /* Aux Clock 5 Divider Configuration 1 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC5_DC1_tag;

typedef union MC_CGM_AC6_SC_union_tag { /* Aux Clock 6 Select Control */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC6_SC_tag;

typedef union MC_CGM_AC6_SS_union_tag { /* Aux Clock 6 Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC6_SS_tag;

typedef union MC_CGM_AC6_DC0_union_tag { /* Aux Clock 6 Divider Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC6_DC0_tag;

typedef union MC_CGM_AC8_SC_union_tag { /* Aux Clock 8 Select Control */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC8_SC_tag;

typedef union MC_CGM_AC8_SS_union_tag { /* Aux Clock 8 Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC8_SS_tag;

typedef union MC_CGM_AC8_DC0_union_tag { /* Aux Clock 8 Divider Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC8_DC0_tag;

typedef union MC_CGM_AC9_SC_union_tag { /* Aux Clock 9 Select Control */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC9_SC_tag;

typedef union MC_CGM_AC9_SS_union_tag { /* Aux Clock 9 Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC9_SS_tag;

typedef union MC_CGM_AC9_DC0_union_tag { /* Aux Clock 9 Divider Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :9;
    vuint32_t DIV:6;
    vuint32_t  :16;
  } B;
} MC_CGM_AC9_DC0_tag;

typedef union MC_CGM_AC10_SC_union_tag { /* Aux Clock 10 Select Control */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELCTL:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC10_SC_tag;

typedef union MC_CGM_AC10_SS_union_tag { /* Aux Clock 10 Select Status */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t SELSTAT:4;
    vuint32_t  :24;
  } B;
} MC_CGM_AC10_SS_tag;

typedef union MC_CGM_AC10_DC0_union_tag { /* Aux Clock 10 Divider Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t  :11;
    vuint32_t DIV:4;
    vuint32_t  :16;
  } B;
} MC_CGM_AC10_DC0_tag;

struct MC_CGM_tag {
  MC_CGM_PCS_SDUR_tag PCS_SDUR;        /* PCS Switch Duration */
  uint8_t MC_CGM_reserved0[3];
  MC_CGM_PCS_DIVC1_tag PCS_DIVC1;      /* PCS Divider Change for external crystal oscillator */
  MC_CGM_PCS_DIVE1_tag PCS_DIVE1;      /* PCS Divider End for external crystal oscillator */
  MC_CGM_PCS_DIVS1_tag PCS_DIVS1;      /* PCS Divider Start for external crystal oscillator */
  MC_CGM_PCS_DIVC2_tag PCS_DIVC2;      /* PCS Divider Change for PLL0 PHI */
  MC_CGM_PCS_DIVE2_tag PCS_DIVE2;      /* PCS Divider End for PLL0 PHI */
  MC_CGM_PCS_DIVS2_tag PCS_DIVS2;      /* PCS Divider Start for PLL0 PHI */
  uint8_t MC_CGM_reserved1[12];
  MC_CGM_PCS_DIVC4_tag PCS_DIVC4;      /* PCS Divider Change for PLL1 PHI */
  MC_CGM_PCS_DIVE4_tag PCS_DIVE4;      /* PCS Divider End for PLL1 PHI */
  MC_CGM_PCS_DIVS4_tag PCS_DIVS4;      /* PCS Divider Start for PLL1 PHI */
  uint8_t MC_CGM_reserved2[156];
  MC_CGM_SC_DIV_RC_tag SC_DIV_RC;      /* System Clock Divider Ratio Change Register */
  MC_CGM_DIV_UPD_TYPE_tag DIV_UPD_TYPE; /* Divider Update Type */
  MC_CGM_DIV_UPD_TRIG_tag DIV_UPD_TRIG; /* Divider Update Trigger */
  MC_CGM_DIV_UPD_STAT_tag DIV_UPD_STAT; /* Divider Update Status */
  uint8_t MC_CGM_reserved3[4];
  MC_CGM_SC_SS_tag SC_SS;              /* System Clock Select Status */
  MC_CGM_SC_DC0_tag SC_DC0;            /* System Clock Divider Configuration 0 */
  MC_CGM_SC_DC1_tag SC_DC1;            /* System Clock Divider Configuration 1 */
  MC_CGM_SC_DC2_tag SC_DC2;            /* System Clock Divider Configuration 2 */
  uint8_t MC_CGM_reserved4[12];
  MC_CGM_AC0_SC_tag AC0_SC;            /* Aux Clock 0 Select Control */
  MC_CGM_AC0_SS_tag AC0_SS;            /* Aux Clock 0 Select Status */
  MC_CGM_AC0_DC0_tag AC0_DC0;          /* Aux Clock 0 Divider Configuration 0 */
  MC_CGM_AC0_DC1_tag AC0_DC1;          /* Aux Clock 0 Divider Configuration 1 */
  MC_CGM_AC0_DC2_tag AC0_DC2;          /* Aux Clock 0 Divider Configuration 2 */
  MC_CGM_AC0_DC3_tag AC0_DC3;          /* Aux Clock 0 Divider Configuration 3 */
  MC_CGM_AC0_DC4_tag AC0_DC4;          /* Aux Clock 0 Divider Configuration 4 */
  uint8_t MC_CGM_reserved5[4];
  MC_CGM_AC1_SC_tag AC1_SC;            /* Aux Clock 1 Select Control */
  MC_CGM_AC1_SS_tag AC1_SS;            /* Aux Clock 1 Select Status */
  MC_CGM_AC1_DC0_tag AC1_DC0;          /* Aux Clock 1 Divider Configuration 0 */
  uint8_t MC_CGM_reserved6[20];
  MC_CGM_AC2_SC_tag AC2_SC;            /* Aux Clock 2 Select Control */
  MC_CGM_AC2_SS_tag AC2_SS;            /* Aux Clock 2 Select Status */
  MC_CGM_AC2_DC0_tag AC2_DC0;          /* Aux Clock 2 Divider Configuration 0 */
  uint8_t MC_CGM_reserved7[20];
  MC_CGM_AC3_SC_tag AC3_SC;            /* Aux Clock 3 Select Control */
  MC_CGM_AC3_SS_tag AC3_SS;            /* Aux Clock 3 Select Status */
  uint8_t MC_CGM_reserved8[24];
  MC_CGM_AC4_SC_tag AC4_SC;            /* Aux Clock 4 Select Control */
  MC_CGM_AC4_SS_tag AC4_SS;            /* Aux Clock 4 Select Status */
  uint8_t MC_CGM_reserved9[24];
  MC_CGM_AC5_SC_tag AC5_SC;            /* Aux Clock 5 Select Control */
  MC_CGM_AC5_SS_tag AC5_SS;            /* Aux Clock 5 Select Status */
  MC_CGM_AC5_DC0_tag AC5_DC0;          /* Aux Clock 5 Divider Configuration 0 */
  MC_CGM_AC5_DC1_tag AC5_DC1;          /* Aux Clock 5 Divider Configuration 1 */
  uint8_t MC_CGM_reserved10[16];
  MC_CGM_AC6_SC_tag AC6_SC;            /* Aux Clock 6 Select Control */
  MC_CGM_AC6_SS_tag AC6_SS;            /* Aux Clock 6 Select Status */
  MC_CGM_AC6_DC0_tag AC6_DC0;          /* Aux Clock 6 Divider Configuration 0 */
  uint8_t MC_CGM_reserved11[52];
  MC_CGM_AC8_SC_tag AC8_SC;            /* Aux Clock 8 Select Control */
  MC_CGM_AC8_SS_tag AC8_SS;            /* Aux Clock 8 Select Status */
  MC_CGM_AC8_DC0_tag AC8_DC0;          /* Aux Clock 8 Divider Configuration 0 */
  uint8_t MC_CGM_reserved12[20];
  MC_CGM_AC9_SC_tag AC9_SC;            /* Aux Clock 9 Select Control */
  MC_CGM_AC9_SS_tag AC9_SS;            /* Aux Clock 9 Select Status */
  MC_CGM_AC9_DC0_tag AC9_DC0;          /* Aux Clock 9 Divider Configuration 0 */
  uint8_t MC_CGM_reserved13[20];
  MC_CGM_AC10_SC_tag AC10_SC;          /* Aux Clock 10 Select Control */
  MC_CGM_AC10_SS_tag AC10_SS;          /* Aux Clock 10 Select Status */
  MC_CGM_AC10_DC0_tag AC10_DC0;        /* Aux Clock 10 Divider Configuration 0 */
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

typedef union MC_ME_GS_union_tag {     /* Global Status */
  vuint32_t R;
  struct {
    vuint32_t S_CURRENT_MODE:4;
    vuint32_t S_MTRANS:1;
    vuint32_t  :1;
    vuint32_t  :2;
    vuint32_t S_PDO:1;
    vuint32_t  :2;
    vuint32_t S_MVR:1;
    vuint32_t  :2;
    vuint32_t S_FLA:2;
    vuint32_t  :8;
    vuint32_t S_PLL1:1;
    vuint32_t S_PLL0:1;
    vuint32_t S_XOSC:1;
    vuint32_t S_IRC:1;
    vuint32_t S_SYSCLK:4;
  } B;
} MC_ME_GS_tag;

typedef union MC_ME_MCTL_union_tag {   /* Mode Control */
  vuint32_t R;
  struct {
    vuint32_t TARGET_MODE:4;
    vuint32_t  :12;
    vuint32_t KEY:16;
  } B;
} MC_ME_MCTL_tag;

typedef union MC_ME_ME_union_tag {     /* Mode Enable */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RESET_DEST:1;
    vuint32_t  :4;
    vuint32_t STOP0:1;
    vuint32_t  :1;
    vuint32_t HALT0:1;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RESET_FUNC:1;
  } B;
} MC_ME_ME_tag;

typedef union MC_ME_IS_union_tag {     /* Interrupt Status */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t I_ICONF_CC:1;
    vuint32_t I_CONF_CU:1;
    vuint32_t I_ICONF:1;
    vuint32_t I_IMODE:1;
    vuint32_t I_SAFE:1;
    vuint32_t I_MTC:1;
  } B;
} MC_ME_IS_tag;

typedef union MC_ME_IM_union_tag {     /* Interrupt Mask */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t M_ICONF_CC:1;
    vuint32_t M_ICONF_CU:1;
    vuint32_t M_ICONF:1;
    vuint32_t M_IMODE:1;
    vuint32_t M_SAFE:1;
    vuint32_t M_MTC:1;
  } B;
} MC_ME_IM_tag;

typedef union MC_ME_IMTS_union_tag {   /* Invalid Mode Transition Status */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t S_MRIG:1;
    vuint32_t S_MTI:1;
    vuint32_t S_MRI:1;
    vuint32_t S_DMA:1;
    vuint32_t S_NMA:1;
    vuint32_t S_SEA:1;
  } B;
} MC_ME_IMTS_tag;

typedef union MC_ME_DMTS_union_tag {   /* Debug Mode Transition Status */
  vuint32_t R;
  struct {
    vuint32_t PREVIOUS_MODE:4;
    vuint32_t  :4;
    vuint32_t MPH_BUSY:1;
    vuint32_t  :2;
    vuint32_t PMC_PROG:1;
    vuint32_t DBG_MODE:1;
    vuint32_t CCKL_PROG:1;
    vuint32_t PCS_PROG:1;
    vuint32_t SMR:1;
    vuint32_t CDP_PRPH_0_255:1;
    vuint32_t VREG_CSRC_SC:1;
    vuint32_t CSRC_CSRC_SC:1;
    vuint32_t IRC_SC:1;
    vuint32_t SCSRC_SC:1;
    vuint32_t SYSCLK_SW:1;
    vuint32_t  :1;
    vuint32_t FLASH_SC:1;
    vuint32_t CDP_PRPH_244_255:1;
    vuint32_t CDP_PRPH_192_223:1;
    vuint32_t CDP_PRPH_160_191:1;
    vuint32_t CDP_PRPH_128_159:1;
    vuint32_t CDP_PRPH_96_127:1;
    vuint32_t CDP_PRPH_64_95:1;
    vuint32_t CDP_PRPH_32_63:1;
    vuint32_t CDP_PRPH_0_31:1;
  } B;
} MC_ME_DMTS_tag;

typedef union MC_ME_RESET_MC_union_tag { /* RESET Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RESET_MC_tag;

typedef union MC_ME_TEST_MC_union_tag { /* TEST Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL10N:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_TEST_MC_tag;

typedef union MC_ME_SAFE_MC_union_tag { /* SAFE Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_SAFE_MC_tag;

typedef union MC_ME_DRUN_MC_union_tag { /* DRUN Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_DRUN_MC_tag;

typedef union MC_ME_RUN0_MC_union_tag { /* RUN0 Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RUN0_MC_tag;

typedef union MC_ME_RUN1_MC_union_tag { /* RUN1 Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RUN1_MC_tag;

typedef union MC_ME_RUN2_MC_union_tag { /* RUN2 Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RUN2_MC_tag;

typedef union MC_ME_RUN3_MC_union_tag { /* RUN3 Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RUN3_MC_tag;

typedef union MC_ME_HALT0_MC_union_tag { /* HALT0 Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_HALT0_MC_tag;

typedef union MC_ME_STOP0_MC_union_tag { /* STOP0 Mode Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PWRLVL:3;
    vuint32_t  :4;
    vuint32_t PDO:1;
    vuint32_t  :2;
    vuint32_t MVRON:1;
    vuint32_t  :2;
    vuint32_t FLAON:2;
    vuint32_t  :8;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_STOP0_MC_tag;

typedef union MC_ME_PS0_union_tag {    /* Peripheral Status 0 */
  vuint32_t R;
  struct {
    vuint32_t S_PIT_RTI_1:1;
    vuint32_t S_PIT_RTI_0:1;
    vuint32_t S_DECFILT_0:1;
    vuint32_t S_DECFILT_1:1;
    vuint32_t  :12;
    vuint32_t S_SIUL2_0:1;
    vuint32_t  :3;
    vuint32_t S_SIPI_0:1;
    vuint32_t  :1;
    vuint32_t S_LFAST_0:1;
    vuint32_t  :9;
  } B;
} MC_ME_PS0_tag;

typedef union MC_ME_PS1_union_tag {    /* Peripheral Status 1 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t S_ADCSD_0:1;
    vuint32_t S_ADCSD_2:1;
    vuint32_t  :13;
    vuint32_t S_JTAGM_0:1;
    vuint32_t  :6;
    vuint32_t S_CRC_0:1;
    vuint32_t  :1;
    vuint32_t S_DMA_CH_MUX0_2:1;
    vuint32_t  :4;
  } B;
} MC_ME_PS1_tag;

typedef union MC_ME_PS2_union_tag {    /* Peripheral Status 2 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t S_LINFLEX_0:1;
    vuint32_t S_LINFLEX_2:1;
    vuint32_t  :5;
    vuint32_t S_LINFLEX_M0:1;
    vuint32_t  :1;
    vuint32_t S_FLEXCAN_0:1;
    vuint32_t  :1;
    vuint32_t S_FLEXCAN_2:1;
    vuint32_t  :9;
    vuint32_t S_ADCSAR_0:1;
    vuint32_t  :1;
    vuint32_t S_ADCSAR_2:1;
    vuint32_t  :5;
  } B;
} MC_ME_PS2_tag;

typedef union MC_ME_PS3_union_tag {    /* Peripheral Status 3 */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t S_SENT_0:1;
    vuint32_t  :1;
    vuint32_t S_EMIOS_0:1;
    vuint32_t  :2;
    vuint32_t S_DSPI_0:1;
    vuint32_t S_DSPI_2:1;
    vuint32_t S_DSPI_4:1;
    vuint32_t S_DSPI_M0:1;
  } B;
} MC_ME_PS3_tag;

typedef union MC_ME_PS4_union_tag {    /* Peripheral Status 4 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t S_DMA_CH_MUX3:1;
    vuint32_t  :15;
  } B;
} MC_ME_PS4_tag;

typedef union MC_ME_PS5_union_tag {    /* Peripheral Status 5 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t ADC_SD1:1;
    vuint32_t  :21;
    vuint32_t CRC_1:1;
    vuint32_t  :6;
  } B;
} MC_ME_PS5_tag;

typedef union MC_ME_PS6_union_tag {    /* Peripheral Status 6 */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t LINFLEX_1:1;
    vuint32_t LINFLEX_3:1;
    vuint32_t  :5;
    vuint32_t LINFLEX_M1:1;
    vuint32_t  :2;
    vuint32_t FLEXCAN1:1;
    vuint32_t  :1;
    vuint32_t FLEXCAN3:1;
    vuint32_t ETPU:1;
    vuint32_t REACM:1;
    vuint32_t ETPU_SPRAM0:1;
    vuint32_t ETPU_SPRAM1:1;
    vuint32_t ETPU_SCRAM0:1;
    vuint32_t ETPU_SCRAM1:1;
    vuint32_t  :3;
    vuint32_t ADCSAR_1:1;
    vuint32_t IGF:1;
    vuint32_t ADCSAR_3:1;
    vuint32_t  :4;
  } B;
} MC_ME_PS6_tag;

typedef union MC_ME_PS7_union_tag {    /* Peripheral Status 7 */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t BCTU_1:1;
    vuint32_t  :18;
    vuint32_t SENT_1:1;
    vuint32_t  :1;
    vuint32_t EMIOS_1:1;
    vuint32_t  :2;
    vuint32_t DSPI_1:1;
    vuint32_t DSPI_3:1;
    vuint32_t DSPI_M1:1;
    vuint32_t  :1;
  } B;
} MC_ME_PS7_tag;

typedef union MC_ME_RUN_PC_union_tag { /* Run Peripheral Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RESET:1;
  } B;
} MC_ME_RUN_PC_tag;

typedef union MC_ME_LP_PC_union_tag {  /* Low-Power Peripheral Configuration 0 */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t STOP0:1;
    vuint32_t  :1;
    vuint32_t HATL0:1;
    vuint32_t  :8;
  } B;
} MC_ME_LP_PC_tag;

    /* Note on PCTL registers: There are only some PCTL implemented          */
    /*  In order to make the PCTL easily addressable, these are defined      */
    /*  as an array (ie MC_ME.PCTL[x].R). This means you have to be careful  */
    /*  when addressing these registers in order not to access a PCTL that   */
    /*  is not implemented. Following are available: 9, 11, 15, 28-31, 36,   */
    /*  38, 45, 59-60, 69, 71, 81, 83, 85, 91-92, 96-99, 102, 104, 143, 166, */
    /*  188, 196-198, 202-208, 210, 213, 219-220, 225-227, 230, 232, 251     */

typedef union MC_ME_PCTL_union_tag {
  vuint8_t R;
  struct {
    vuint8_t  :1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL_tag;

typedef union MC_ME_CS_union_tag {     /* Core Status */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t S_CORE2:1;
    vuint32_t S_CORE1:1;
    vuint32_t S_CORE0:1;
  } B;
} MC_ME_CS_tag;

typedef union MC_ME_CCTL_union_tag {   /* CORE1 Control */
  vuint16_t R;
  struct {
    vuint16_t  :5;
    vuint16_t STOP0:1;
    vuint16_t  :1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL_tag;

typedef union MC_ME_CADDR0_union_tag { /* CORE1 Address */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t  :1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR0_tag;

typedef union MC_ME_CADDR1_union_tag { /* CORE0 Address */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t  :1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR1_tag;

typedef union MC_ME_CADDR2_union_tag { /* CORE2 Address */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR2_tag;

struct MC_ME_tag {
  MC_ME_GS_tag GS;                     /* Global Status */
  MC_ME_MCTL_tag MCTL;                 /* Mode Control */
  MC_ME_ME_tag ME;                     /* Mode Enable */
  MC_ME_IS_tag IS;                     /* Interrupt Status */
  MC_ME_IM_tag IM;                     /* Interrupt Mask */
  MC_ME_IMTS_tag IMTS;                 /* Invalid Mode Transition Status */
  MC_ME_DMTS_tag DMTS;                 /* Debug Mode Transition Status */
  uint8_t MC_ME_reserved0[4];
  MC_ME_RESET_MC_tag RESET_MC;         /* RESET Mode Configuration */
  MC_ME_TEST_MC_tag TEST_MC;           /* TEST Mode Configuration */
  MC_ME_SAFE_MC_tag SAFE_MC;           /* SAFE Mode Configuration */
  MC_ME_DRUN_MC_tag DRUN_MC;           /* DRUN Mode Configuration */
  MC_ME_RUN0_MC_tag RUN0_MC;           /* RUN0 Mode Configuration */
  MC_ME_RUN1_MC_tag RUN1_MC;           /* RUN1 Mode Configuration */
  MC_ME_RUN2_MC_tag RUN2_MC;           /* RUN2 Mode Configuration */
  MC_ME_RUN3_MC_tag RUN3_MC;           /* RUN3 Mode Configuration */
  MC_ME_HALT0_MC_tag HALT0_MC;         /* HALT0 Mode Configuration */
  uint8_t MC_ME_reserved1[4];
  MC_ME_STOP0_MC_tag STOP0_MC;         /* STOP0 Mode Configuration */
  uint8_t MC_ME_reserved2[20];
  MC_ME_PS0_tag PS0;                   /* Peripheral Status 0 */
  MC_ME_PS1_tag PS1;                   /* Peripheral Status 1 */
  MC_ME_PS2_tag PS2;                   /* Peripheral Status 2 */
  MC_ME_PS3_tag PS3;                   /* Peripheral Status 3 */
  MC_ME_PS4_tag PS4;                   /* Peripheral Status 4 */
  MC_ME_PS5_tag PS5;                   /* Peripheral Status 5 */
  MC_ME_PS6_tag PS6;                   /* Peripheral Status 6 */
  MC_ME_PS7_tag PS7;                   /* Peripheral Status 7 */
  MC_ME_RUN_PC_tag RUN_PC[8];          /* Run Peripheral Configuration 0 */
  MC_ME_LP_PC_tag LP_PC[8];            /* Low-Power Peripheral Configuration 0 */
  MC_ME_PCTL_tag PCTL[252];
  uint8_t MC_ME_reserved3[4];
  MC_ME_CS_tag CS;                     /* Core Status */
  MC_ME_CCTL_tag CCTL[3];              /* CORE1 Control */
  uint8_t MC_ME_reserved4[22];
  MC_ME_CADDR0_tag CADDR0;             /* CORE1 Address */
  MC_ME_CADDR1_tag CADDR1;             /* CORE0 Address */
  MC_ME_CADDR2_tag CADDR2;             /* CORE2 Address */
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

typedef union MC_PCU_PSTAT_union_tag { /* Power Domain Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t PD0:1;
  } B;
} MC_PCU_PSTAT_tag;

struct MC_PCU_tag {
  uint8_t MC_PCU_reserved0[64];
  MC_PCU_PSTAT_tag PSTAT;              /* Power Domain Status Register */
};


/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

typedef union MC_RGM_DES_union_tag {   /* 'Destructive' Event Status */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t F_PMC:1;                 /* Flag for PMC self test failure after boot up (POR) */
    vuint32_t F_VOR:1;                 /* Flag for Voltage Out of Range */
    vuint32_t F_TSR:1;                 /* Flag for Temperature sensor */
    vuint32_t  :12;
    vuint32_t F_JTAG:1;                /* Flag for JTAG destructive reset */
    vuint32_t F_FIF:1;                 /* Flag for Flash Initialization Failure */
    vuint32_t F_EDR:1;                 /* Flag for 'Functional' reset Escalation */
    vuint32_t  :1;
    vuint32_t F_SSR:1;                 /* Flag for SSCM security reset */
    vuint32_t F_SUF:1;                 /* Flag for STCU Unrecoverable Fault */
    vuint32_t F_FFRR:1;                /* Flag for FCCU Failure to React reset */
    vuint32_t F_SOFT_DEST:1;           /* Flag for Software destructive reset */
    vuint32_t  :1;
    vuint32_t F_PORST:1;               /* Flag for External PowerOn reset */
    vuint32_t F_POR:1;                 /* Flag for Power-On reset */
  } B;
} MC_RGM_DES_tag;

typedef union MC_RGM_DERD_union_tag {  /* 'Destructive' Event Reset Disable */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t D_PMC_STF:1;             /* Disable PMC Self_Test Failure */
    vuint32_t D_VOR:1;
    vuint32_t D_TSR:1;
    vuint32_t  :12;
    vuint32_t D_JTAG:1;
    vuint32_t D_FIF:1;
    vuint32_t D_EDR:1;
    vuint32_t  :2;
    vuint32_t D_SUF:1;
    vuint32_t D_FFRR:1;
    vuint32_t D_SOFT_DEST:1;
    vuint32_t  :1;
    vuint32_t D_PORST:1;
    vuint32_t  :1;
  } B;
} MC_RGM_DERD_tag;

typedef union MC_RGM_DEAR_union_tag {  /* 'Destructive' Event Alternate Request */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t AR_TSR:1;
    vuint32_t  :21;
    vuint32_t AR_PORST:1;
    vuint32_t  :1;
  } B;
} MC_RGM_DEAR_tag;

typedef union MC_RGM_DBRE_union_tag {  /* 'Destructive' Bidirectional Reset Enable */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t BE_PMC_STF:1;            /* Bidirectional Reset Enables for PMC Selt Test Failure 'Destructive' Reset */
    vuint32_t BE_VOR:1;
    vuint32_t BE_TSR:1;
    vuint32_t  :12;
    vuint32_t BE_JTAG:1;
    vuint32_t BE_FIF:1;
    vuint32_t BE_EDR:1;
    vuint32_t  :2;
    vuint32_t BE_SUF:1;
    vuint32_t BE_FFRR:1;
    vuint32_t BE_SOFT_DEST:1;
    vuint32_t  :1;
    vuint32_t BE_PORST:1;
    vuint32_t BE_POR:1;
  } B;
} MC_RGM_DBRE_tag;

typedef union MC_RGM_FES_union_tag {   /* 'Functional' Event Status */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t F_VOR_FUNC:1;
    vuint32_t F_TSR_FUNC:1;
    vuint32_t  :12;
    vuint32_t F_JTAG_FUNC:1;
    vuint32_t  :3;
    vuint32_t F_FCCU_SOFT:1;
    vuint32_t F_FCCU_HARD:1;
    vuint32_t  :1;
    vuint32_t F_SOFT_FUNC:1;
    vuint32_t F_ST_DONE:1;
    vuint32_t  :1;
    vuint32_t F_EXR:1;
  } B;
} MC_RGM_FES_tag;

typedef union MC_RGM_FERD_union_tag {  /* 'Functional' Event Reset Disable */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t D_VOR_FUNC:1;            /* Disable Voltage Out of Range 'Functional' Reset */
    vuint32_t D_TSR_FUNC:1;
    vuint32_t  :12;
    vuint32_t D_JTAG_FUNC:1;           /* Disable JTAG 'Functional' Reset */
    vuint32_t  :3;
    vuint32_t D_FCCU_SOFT:1;
    vuint32_t D_FCCU_HARD:1;
    vuint32_t  :1;
    vuint32_t D_SOFT_FUNC:1;
    vuint32_t D_ST_DONE:1;
    vuint32_t  :2;
  } B;
} MC_RGM_FERD_tag;

typedef union MC_RGM_FEAR_union_tag {  /* 'Functional' Event Alternate Request */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t AR_VOR_FUNC:1;
    vuint32_t AR_TSR_FUNC:1;
    vuint32_t  :23;
  } B;
} MC_RGM_FEAR_tag;

typedef union MC_RGM_FBRE_union_tag {  /* 'Functional' Bidirectional Reset Enable */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t BE_VOR_FUNC:1;
    vuint32_t BE_TSR_FUNC:1;           /* Bidirectional Reset Enable for Temperature Sensor 'Functional' Reset */
    vuint32_t  :12;
    vuint32_t BE_JTAG_FUNC:1;
    vuint32_t  :3;
    vuint32_t BE_FCCU_SOFT:1;
    vuint32_t BE_FCCU_HARD:1;
    vuint32_t  :1;
    vuint32_t BE_SOFT_FUNC:1;
    vuint32_t BE_ST_DONE:1;
    vuint32_t  :1;
    vuint32_t BE_RESET:1;
  } B;
} MC_RGM_FBRE_tag;

typedef union MC_RGM_FESS_union_tag {  /* 'Functional' Event Short Sequence */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t SS_VOR_FUNC:1;
    vuint32_t SS_TSR_FUNC:1;
    vuint32_t  :12;
    vuint32_t SS_JTAG_FUNC:1;
    vuint32_t  :3;
    vuint32_t SS_FCCU_SOFT:1;
    vuint32_t SS_FCCU_HARD:1;
    vuint32_t  :1;
    vuint32_t SS_SOFT_FUNC:1;
    vuint32_t SS_ST_DONE:1;
    vuint32_t  :1;
    vuint32_t SS_EXR:1;
  } B;
} MC_RGM_FESS_tag;

typedef union MC_RGM_FRET_union_tag {  /* Functional Reset Threshold */
  vuint8_t R;
  struct {
    vuint8_t  :4;
    vuint8_t FRET:4;
  } B;
} MC_RGM_FRET_tag;

typedef union MC_RGM_DRET_union_tag {  /* 'Destructive' Reset Threshold */
  vuint8_t R;
  struct {
    vuint8_t  :4;
    vuint8_t DRET:4;
  } B;
} MC_RGM_DRET_tag;

struct MC_RGM_tag {
  MC_RGM_DES_tag DES;                  /* 'Destructive' Event Status */
  uint8_t MC_RGM_reserved0[12];
  MC_RGM_DERD_tag DERD;                /* 'Destructive' Event Reset Disable */
  uint8_t MC_RGM_reserved1[12];
  MC_RGM_DEAR_tag DEAR;                /* 'Destructive' Event Alternate Request */
  uint8_t MC_RGM_reserved2[12];
  MC_RGM_DBRE_tag DBRE;                /* 'Destructive' Bidirectional Reset Enable */
  uint8_t MC_RGM_reserved3[716];
  MC_RGM_FES_tag FES;                  /* 'Functional' Event Status */
  uint8_t MC_RGM_reserved4[12];
  MC_RGM_FERD_tag FERD;                /* 'Functional' Event Reset Disable */
  uint8_t MC_RGM_reserved5[12];
  MC_RGM_FEAR_tag FEAR;                /* 'Functional' Event Alternate Request */
  uint8_t MC_RGM_reserved6[12];
  MC_RGM_FBRE_tag FBRE;                /* 'Functional' Bidirectional Reset Enable */
  uint8_t MC_RGM_reserved7[12];
  MC_RGM_FESS_tag FESS;                /* 'Functional' Event Short Sequence */
  uint8_t MC_RGM_reserved8[704];
  MC_RGM_FRET_tag FRET;                /* Functional Reset Threshold */
  uint8_t MC_RGM_reserved9[3];
  MC_RGM_DRET_tag DRET;                /* 'Destructive' Reset Threshold */
};


/* ============================================================================
   =============================== Module: MEMU ===============================
   ============================================================================ */

typedef union MEMU_CTRL_union_tag {    /* Control register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SWR:1;
    vuint32_t  :15;
  } B;
} MEMU_CTRL_tag;

typedef union MEMU_ERR_FLAG_union_tag { /* Error flag register */
  vuint32_t R;
  struct {
    vuint32_t  :11;
    vuint32_t PR_CE:1;
    vuint32_t PR_UCE:1;
    vuint32_t PR_CEO:1;
    vuint32_t PR_UCO:1;
    vuint32_t PR_EBO:1;
    vuint32_t  :3;
    vuint32_t F_CE:1;
    vuint32_t F_UCE:1;
    vuint32_t F_CEO:1;
    vuint32_t F_UCO:1;
    vuint32_t F_EBO:1;
    vuint32_t  :3;
    vuint32_t SR_CE:1;
    vuint32_t SR_UCE:1;
    vuint32_t SR_CEO:1;
    vuint32_t SR_UCO:1;
    vuint32_t SR_EBO:1;
  } B;
} MEMU_ERR_FLAG_tag;

typedef union MEMU_DEBUG_union_tag {   /* Debug register */
  vuint32_t R;
  struct {
    vuint32_t  :11;
    vuint32_t FR_PR_CE:1;
    vuint32_t FR_PR_UCE:1;
    vuint32_t FR_PR_CEO:1;
    vuint32_t FR_PR_UCO:1;
    vuint32_t FR_PR_EBO:1;
    vuint32_t  :3;
    vuint32_t FR_F_CE:1;
    vuint32_t FR_F_UCE:1;
    vuint32_t FR_F_CEO:1;
    vuint32_t FR_F_UCO:1;
    vuint32_t FR_F_EBO:1;
    vuint32_t  :3;
    vuint32_t FR_SR_CE:1;
    vuint32_t FR_SR_UCE:1;
    vuint32_t FR_SR_CEO:1;
    vuint32_t FR_SR_UCO:1;
    vuint32_t FR_SR_EBO:1;
  } B;
} MEMU_DEBUG_tag;

typedef union MEMU_SYS_RAM_CERR_STS_union_tag { /* System RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_SYS_RAM_CERR_STS_tag;

typedef union MEMU_SYS_RAM_CERR_ADDR_union_tag { /* System RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_SYS_RAM_CERR_ADDR_tag;

typedef struct MEMU_SYS_RAM_CERR_struct_tag {
  MEMU_SYS_RAM_CERR_STS_tag STS;       /* System RAM correctable error reporting table status register */
  MEMU_SYS_RAM_CERR_ADDR_tag ADDR;     /* System RAM correctable error reporting table address register */
} MEMU_SYS_RAM_CERR_tag;

typedef union MEMU_SYS_RAM_UNCERR_STS_union_tag { /* System RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :31;
  } B;
} MEMU_SYS_RAM_UNCERR_STS_tag;

typedef union MEMU_SYS_RAM_UNCERR_ADDR_union_tag { /* System RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_SYS_RAM_UNCERR_ADDR_tag;

typedef union MEMU_SYS_RAM_OFLW_union_tag { /* System RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_SYS_RAM_OFLW_tag;

typedef union MEMU_PERIPH_RAM_CERR_STS_union_tag { /* Peripheral RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_PERIPH_RAM_CERR_STS_tag;

typedef union MEMU_PERIPH_RAM_CERR_ADDR_union_tag { /* Peripheral RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_PERIPH_RAM_CERR_ADDR_tag;

typedef struct MEMU_PERIPH_RAM_CERR_struct_tag {
  MEMU_PERIPH_RAM_CERR_STS_tag STS;    /* Peripheral RAM correctable error reporting table status register */
  MEMU_PERIPH_RAM_CERR_ADDR_tag ADDR;  /* Peripheral RAM correctable error reporting table address register */
} MEMU_PERIPH_RAM_CERR_tag;

typedef union MEMU_PERIPH_RAM_UNCERR_STS_union_tag { /* Peripheral RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :31;
  } B;
} MEMU_PERIPH_RAM_UNCERR_STS_tag;

typedef union MEMU_PERIPH_RAM_UNCERR_ADDR_union_tag { /* Peripheral RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_PERIPH_RAM_UNCERR_ADDR_tag;

typedef union MEMU_PERIPH_RAM_OFLW0_union_tag { /* Peripheral RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_PERIPH_RAM_OFLW0_tag;

typedef union MEMU_FLASH_CERR_STS_union_tag { /* Flash memory correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_FLASH_CERR_STS_tag;

typedef union MEMU_FLASH_CERR_ADDR_union_tag { /* Flash memory correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_FLASH_CERR_ADDR_tag;

typedef struct MEMU_FLASH_CERR_struct_tag {
  MEMU_FLASH_CERR_STS_tag STS;         /* Flash memory correctable error reporting table status register */
  MEMU_FLASH_CERR_ADDR_tag ADDR;       /* Flash memory correctable error reporting table address register */
} MEMU_FLASH_CERR_tag;

typedef union MEMU_FLASH_UNCERR_STS_union_tag { /* Flash memory uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t  :31;
  } B;
} MEMU_FLASH_UNCERR_STS_tag;

typedef union MEMU_FLASH_UNCERR_ADDR_union_tag { /* Flash memory uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_FLASH_UNCERR_ADDR_tag;

typedef union MEMU_FLASH_OFLW0_union_tag { /* Flash memory concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_FLASH_OFLW0_tag;

struct MEMU_tag {
  MEMU_CTRL_tag CTRL;                  /* Control register */
  MEMU_ERR_FLAG_tag ERR_FLAG;          /* Error flag register */
  uint8_t MEMU_reserved0[4];
  MEMU_DEBUG_tag DEBUG;                /* Debug register */
  uint8_t MEMU_reserved1[16];
  MEMU_SYS_RAM_CERR_tag SYS_RAM_CERR[10];
  MEMU_SYS_RAM_UNCERR_STS_tag SYS_RAM_UNCERR_STS; /* System RAM uncorrectable error reporting table status register */
  MEMU_SYS_RAM_UNCERR_ADDR_tag SYS_RAM_UNCERR_ADDR; /* System RAM uncorrectable error reporting table address register */
  MEMU_SYS_RAM_OFLW_tag SYS_RAM_OFLW[1]; /* System RAM concurrent overflow register */
  uint8_t MEMU_reserved2[1444];
  MEMU_PERIPH_RAM_CERR_tag PERIPH_RAM_CERR[2];
  MEMU_PERIPH_RAM_UNCERR_STS_tag PERIPH_RAM_UNCERR_STS; /* Peripheral RAM uncorrectable error reporting table status register */
  MEMU_PERIPH_RAM_UNCERR_ADDR_tag PERIPH_RAM_UNCERR_ADDR; /* Peripheral RAM uncorrectable error reporting table address register */
  MEMU_PERIPH_RAM_OFLW0_tag PERIPH_RAM_OFLW0; /* Peripheral RAM concurrent overflow register */
  uint8_t MEMU_reserved3[1508];
  MEMU_FLASH_CERR_tag FLASH_CERR[20];
  MEMU_FLASH_UNCERR_STS_tag FLASH_UNCERR_STS; /* Flash memory uncorrectable error reporting table status register */
  MEMU_FLASH_UNCERR_ADDR_tag FLASH_UNCERR_ADDR; /* Flash memory uncorrectable error reporting table address register */
  MEMU_FLASH_OFLW0_tag FLASH_OFLW0;    /* Flash memory concurrent overflow register */
};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

typedef union PASS_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t CNS:1;
    vuint32_t JUN:1;
    vuint32_t  :1;
    vuint32_t  :26;
    vuint32_t LIFE:3;
  } B;
} PASS_LCSTAT_tag;

typedef union PASS_CHSEL_union_tag {   /* Challenge Selector Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t GRP:3;
  } B;
} PASS_CHSEL_tag;

typedef union PASS_CSTAT_union_tag {   /* Challenge Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t CMST:4;
  } B;
} PASS_CSTAT_tag;

typedef union PASS_CIN_union_tag {     /* Challenge Input Register */
  vuint32_t R;
  struct {
    vuint32_t PW32:32;
  } B;
} PASS_CIN_tag;

typedef union PASS_PG_LOCK0_union_tag { /* Password Group n - Lock 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;
    vuint32_t ATSL:1;
    vuint32_t LOWLOCK:14;
    vuint32_t MIDLOCK:16;
  } B;
} PASS_PG_LOCK0_tag;

typedef union PASS_PG_LOCK1_union_tag { /* Password Group n - Lock 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t HIGHLOCK:16;
  } B;
} PASS_PG_LOCK1_tag;

typedef union PASS_PG_LOCK2_union_tag { /* Password Group n - Lock 2 Status Register */
  vuint32_t R;
  struct {
    vuint32_t L_256LCK:32;
  } B;
} PASS_PG_LOCK2_tag;

typedef union PASS_PG_LOCK3_union_tag { /* Password Group n - Lock 3 Status Register */
  vuint32_t R;
  struct {
    vuint32_t PGL:1;
    vuint32_t DBL:1;
    vuint32_t MO:1;
    vuint32_t  :1;
    vuint32_t MSTR:4;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t RL2:1;
    vuint32_t RL1:1;
    vuint32_t RL0:1;
    vuint32_t U_256LCK:16;
  } B;
} PASS_PG_LOCK3_tag;

typedef struct PASS_PG_struct_tag {
  PASS_PG_LOCK0_tag LOCK0;             /* Password Group n - Lock 0 Status Register */
  PASS_PG_LOCK1_tag LOCK1;             /* Password Group n - Lock 1 Status Register */
  PASS_PG_LOCK2_tag LOCK2;             /* Password Group n - Lock 2 Status Register */
  PASS_PG_LOCK3_tag LOCK3;             /* Password Group n - Lock 3 Status Register */
} PASS_PG_tag;

struct PASS_tag {
  PASS_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
  uint8_t PASS_reserved0[4];
  PASS_CHSEL_tag CHSEL;                /* Challenge Selector Register */
  uint8_t PASS_reserved1[4];
  PASS_CSTAT_tag CSTAT;                /* Challenge Status Register */
  uint8_t PASS_reserved2[12];
  PASS_CIN_tag CIN[8];                 /* Challenge Input Register */
  uint8_t PASS_reserved3[192];
  PASS_PG_tag PG[4];
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

typedef union PCM_FBOMCR_union_tag {   /* FEC Burst Optimization Master Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t ACCERR:1;
    vuint32_t WBEN:1;
    vuint32_t RBEN:1;
    vuint32_t FXSBE:8;
  } B;
} PCM_FBOMCR_tag;

typedef union PCM_IAHB_BE1_union_tag { /* Bus Bridge Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t  :3;
    vuint32_t  :5;
    vuint32_t PRE_S0:1;                /* Pending read enable (PRE) S0 */
    vuint32_t BRE_S0:1;                /* Burst read enable (BRE) S0. */
    vuint32_t BWE_S0:1;                /* Burst write enable (BWE) S0. */
    vuint32_t  :5;
    vuint32_t PRE_M3:1;                /* Pending read enable (PRE) M3. */
    vuint32_t BRE_M3:1;                /* Burst read enable (BRE) M3. */
    vuint32_t BWE_M3:1;                /* Burst write enable (BWE) M3. */
  } B;
} PCM_IAHB_BE1_tag;

typedef union PCM_IAHB_BE2_union_tag { /* Bus Bridge Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t PRE_SIPI:1;              /* Pending read enable (PRE) SIPI. */
    vuint32_t BRE_SIPI:1;              /* Burst read enable (BRE) SIPI. */
    vuint32_t BWE_SIPI:1;              /* Burst write enable (BWE) SIPI. */
    vuint32_t  :5;
    vuint32_t  :3;
    vuint32_t  :5;
    vuint32_t PRE_FEC:1;               /* Pending read enable (PRE) FEC. */
    vuint32_t BRE_FEC:1;               /* Burst read enable (BRE) FEC. */
    vuint32_t BWE_FEC:1;               /* Burst write enable (BWE) FEC. */
  } B;
} PCM_IAHB_BE2_tag;

typedef union PCM_IPS_CGM_EN0_union_tag { /* IPS Clock Gating Module Enable 0 Register */
  vuint32_t R;
  struct {
    vuint32_t  :7;
    vuint32_t IPS_CGM_MPU1:1;
    vuint32_t  :3;
    vuint32_t IPS_CGM_AXBS1:1;
    vuint32_t  :3;
    vuint32_t IPS_CGM_INTC:1;
    vuint32_t  :3;
    vuint32_t IPS_CGM_MPU0:1;
    vuint32_t  :3;
    vuint32_t IPS_CGM_AXBS0:1;
    vuint32_t  :3;
    vuint32_t IPS_CGM_PRAM:1;
    vuint32_t  :3;
    vuint32_t IPS_CGM_PFLASH:1;
  } B;
} PCM_IPS_CGM_EN0_tag;

struct PCM_tag {
  PCM_FBOMCR_tag FBOMCR;               /* FEC Burst Optimization Master Control Register */
  PCM_IAHB_BE1_tag IAHB_BE1;           /* Bus Bridge Configuration Register 1 */
  PCM_IAHB_BE2_tag IAHB_BE2;           /* Bus Bridge Configuration Register 2 */
  PCM_IPS_CGM_EN0_tag IPS_CGM_EN0;     /* IPS Clock Gating Module Enable 0 Register */
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

typedef union PFLASH_PFCR1_union_tag { /* Platform Flash Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t P0_M15PFE:1;
    vuint32_t P0_M14PFE:1;
    vuint32_t P0_M13PFE:1;
    vuint32_t P0_M12PFE:1;
    vuint32_t P0_M11PFE:1;
    vuint32_t P0_M10PFE:1;
    vuint32_t P0_M9PFE:1;
    vuint32_t P0_M8PFE:1;
    vuint32_t P0_M7PFE:1;
    vuint32_t P0_M6PFE:1;
    vuint32_t P0_M5PFE:1;
    vuint32_t P0_M4PFE:1;
    vuint32_t P0_M3PFE:1;
    vuint32_t P0_M2PFE:1;
    vuint32_t P0_M1PFE:1;
    vuint32_t P0_M0PFE:1;
    vuint32_t APC:3;
    vuint32_t RWSC:5;
    vuint32_t  :1;
    vuint32_t P0_DPFEN:1;
    vuint32_t  :1;
    vuint32_t P0_IPFEN:1;
    vuint32_t  :1;
    vuint32_t P0_PFLIM:2;
    vuint32_t P0_BFEN:1;
  } B;
} PFLASH_PFCR1_tag;

typedef union PFLASH_PFCR2_union_tag { /* Platform Flash Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t P1_M15PFE:1;
    vuint32_t P1_M14PFE:1;
    vuint32_t P1_M13PFE:1;
    vuint32_t P1_M12PFE:1;
    vuint32_t P1_M11PFE:1;
    vuint32_t P1_M10PFE:1;
    vuint32_t P1_M9PFE:1;
    vuint32_t P1_M8PFE:1;
    vuint32_t P1_M7PFE:1;
    vuint32_t P1_M6PFE:1;
    vuint32_t P1_M5PFE:1;
    vuint32_t P1_M4PFE:1;
    vuint32_t P1_M3PFE:1;
    vuint32_t P1_M2PFE:1;
    vuint32_t P1_M1PFE:1;
    vuint32_t P1_M0PFE:1;
    vuint32_t  :9;
    vuint32_t P1_DPFEN:1;
    vuint32_t  :1;
    vuint32_t P1_IPFEN:1;
    vuint32_t  :1;
    vuint32_t P1_PFLIM:2;
    vuint32_t P1_BFEN:1;
  } B;
} PFLASH_PFCR2_tag;

typedef union PFLASH_PFCR3_union_tag { /* Platform Flash Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t P0_WCFG:2;
    vuint32_t P1_WCFG:2;
    vuint32_t  :2;
    vuint32_t  :5;
    vuint32_t BDRM:1;
    vuint32_t  :3;
    vuint32_t BAF_DIS:1;
    vuint32_t ARBM:2;
    vuint32_t  :2;
    vuint32_t  :11;
    vuint32_t DERR_SUP:1;
  } B;
} PFLASH_PFCR3_tag;

typedef union PFLASH_PFAPR_union_tag { /* Platform Flash Access Protection Register */
  vuint32_t R;
  struct {
    vuint32_t M0AP:2;
    vuint32_t M1AP:2;
    vuint32_t M2AP:2;
    vuint32_t M3AP:2;
    vuint32_t M4AP:2;
    vuint32_t M5AP:2;
    vuint32_t M6AP:2;
    vuint32_t M7AP:2;
    vuint32_t M8AP:2;
    vuint32_t M9AP:2;
    vuint32_t M10AP:2;
    vuint32_t M11AP:2;
    vuint32_t M12AP:2;
    vuint32_t M13AP:2;
    vuint32_t M14AP:2;
    vuint32_t M15AP:2;
  } B;
} PFLASH_PFAPR_tag;

typedef union PFLASH_PFCRCR_union_tag { /* Platform Flash Remap Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :23;
    vuint32_t SAFE_CAL:1;
    vuint32_t  :3;
    vuint32_t IRMEN:1;
    vuint32_t  :3;
    vuint32_t GRMEN:1;
  } B;
} PFLASH_PFCRCR_tag;

typedef union PFLASH_PFCRDE_union_tag { /* Platform Flash Remap Descriptor Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CRD0EN:1;
    vuint32_t CRD1EN:1;
    vuint32_t CRD2EN:1;
    vuint32_t CRD3EN:1;
    vuint32_t CRD4EN:1;
    vuint32_t CRD5EN:1;
    vuint32_t CRD6EN:1;
    vuint32_t CRD7EN:1;
    vuint32_t CRD8EN:1;
    vuint32_t CRD9EN:1;
    vuint32_t CRD10EN:1;
    vuint32_t CRD11EN:1;
    vuint32_t CRD12EN:1;
    vuint32_t CRD13EN:1;
    vuint32_t CRD14EN:1;
    vuint32_t CRD15EN:1;
    vuint32_t CRD16EN:1;
    vuint32_t CRD17EN:1;
    vuint32_t CRD18EN:1;
    vuint32_t CRD19EN:1;
    vuint32_t CRD20EN:1;
    vuint32_t CRD21EN:1;
    vuint32_t CRD22EN:1;
    vuint32_t CRD23EN:1;
    vuint32_t CRD24EN:1;
    vuint32_t CRD25EN:1;
    vuint32_t CRD26EN:1;
    vuint32_t CRD27EN:1;
    vuint32_t CRD28EN:1;
    vuint32_t CRD29EN:1;
    vuint32_t CRD30EN:1;
    vuint32_t CRD31EN:1;
  } B;
} PFLASH_PFCRDE_tag;

typedef union PFLASH_PFCRD_Word0_union_tag { /* Platform Flash Calibration Region Descriptor n Word0 */
  vuint32_t R;
  struct {
    vuint32_t LSTARTADDR:28;
    vuint32_t  :4;
  } B;
} PFLASH_PFCRD_Word0_tag;

typedef union PFLASH_PFCRD_Word1_union_tag { /* Platform Flash Calibration Region Descriptor n Word1 */
  vuint32_t R;
  struct {
    vuint32_t PSTARTADDR:28;
    vuint32_t  :4;
  } B;
} PFLASH_PFCRD_Word1_tag;

typedef union PFLASH_PFCRD_Word2_union_tag { /* Platform Flash Calibration Region Descriptor n Word2 */
  vuint32_t R;
  struct {
    vuint32_t M0EN:1;
    vuint32_t M1EN:1;
    vuint32_t M2EN:1;
    vuint32_t M3EN:1;
    vuint32_t M4EN:1;
    vuint32_t M5EN:1;
    vuint32_t M6EN:1;
    vuint32_t M7EN:1;
    vuint32_t M8EN:1;
    vuint32_t M9EN:1;
    vuint32_t M10EN:1;
    vuint32_t M11EN:1;
    vuint32_t M12EN:1;
    vuint32_t M13EN:1;
    vuint32_t M14EN:1;
    vuint32_t M15EN:1;
    vuint32_t  :11;
    vuint32_t CRDSize:5;
  } B;
} PFLASH_PFCRD_Word2_tag;

typedef struct PFLASH_PFCRD_struct_tag {
  PFLASH_PFCRD_Word0_tag Word0;        /* Platform Flash Calibration Region Descriptor n Word0 */
  PFLASH_PFCRD_Word1_tag Word1;        /* Platform Flash Calibration Region Descriptor n Word1 */
  PFLASH_PFCRD_Word2_tag Word2;        /* Platform Flash Calibration Region Descriptor n Word2 */
  uint8_t PFCRD_reserved0[4];
} PFLASH_PFCRD_tag;

struct PFLASH_tag {
  PFLASH_PFCR1_tag PFCR1;              /* Platform Flash Configuration Register 1 */
  PFLASH_PFCR2_tag PFCR2;              /* Platform Flash Configuration Register 2 */
  PFLASH_PFCR3_tag PFCR3;              /* Platform Flash Configuration Register 3 */
  PFLASH_PFAPR_tag PFAPR;              /* Platform Flash Access Protection Register */
  PFLASH_PFCRCR_tag PFCRCR;            /* Platform Flash Remap Control Register */
  PFLASH_PFCRDE_tag PFCRDE;            /* Platform Flash Remap Descriptor Enable Register */
  uint8_t PFLASH_reserved0[232];
  PFLASH_PFCRD_tag PFCRD[32];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

typedef union PIT_MCR_union_tag {      /* PIT Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t MDIS_RTI:1;              /* Module Disable - RTI section */
    vuint32_t MDIS:1;                  /* Module Disable - (PIT section) */
    vuint32_t FRZ:1;                   /* Freeze */
  } B;
} PIT_MCR_tag;

typedef union PIT_LTMR64H_union_tag {  /* PIT Upper Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTH:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64H_tag;

typedef union PIT_LTMR64L_union_tag {  /* PIT Lower Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTL:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64L_tag;

typedef union PIT_RTI_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_RTI_LDVAL_tag;

typedef union PIT_RTI_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_RTI_CVAL_tag;

typedef union PIT_RTI_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TEN:1;                   /* Timer Enable Bit */
  } B;
} PIT_RTI_TCTRL_tag;

typedef union PIT_RTI_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t TIF:1;                   /* Timer Interrupt Flag. */
  } B;
} PIT_RTI_TFLG_tag;

typedef union PIT_TIMER_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_TIMER_LDVAL_tag;

typedef union PIT_TIMER_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_TIMER_CVAL_tag;

typedef union PIT_TIMER_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t CHN:1;                   /* Chain Mode */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TEN:1;                   /* Timer Enable */
  } B;
} PIT_TIMER_TCTRL_tag;

typedef union PIT_TIMER_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t TIF:1;                   /* Timer Interrupt Flag */
  } B;
} PIT_TIMER_TFLG_tag;

typedef struct PIT_TIMER_struct_tag {
  PIT_TIMER_LDVAL_tag LDVAL;           /* Timer Load Value Register */
  uint32_t TIMER_reserved0[3];
  PIT_TIMER_CVAL_tag CVAL;             /* Current Timer Value Register */
  uint32_t TIMER_reserved1[3];
  PIT_TIMER_TCTRL_tag TCTRL;           /* Timer Control Register */
  uint32_t TIMER_reserved2[3];
  PIT_TIMER_TFLG_tag TFLG;             /* Timer Flag Register */
} PIT_TIMER_tag;

struct PIT_tag {
  PIT_MCR_tag MCR;                     /* PIT Module Control Register */
  uint32_t PIT_reserved0[223];
  PIT_LTMR64H_tag LTMR64H;             /* PIT Upper Lifetime Timer Register */
  uint32_t PIT_reserved1[3];
  PIT_LTMR64L_tag LTMR64L;             /* PIT Lower Lifetime Timer Register */
  uint32_t PIT_reserved2[11];
  PIT_RTI_LDVAL_tag RTI_LDVAL;         /* Timer Load Value Register */
  uint32_t PIT_reserved3[3];
  PIT_RTI_CVAL_tag RTI_CVAL;           /* Current Timer Value Register */
  uint32_t PIT_reserved4[3];
  PIT_RTI_TCTRL_tag RTI_TCTRL;         /* Timer Control Register */
  uint32_t PIT_reserved5[3];
  PIT_RTI_TFLG_tag RTI_TFLG;           /* Timer Flag Register */
  uint32_t PIT_reserved6[3];
  PIT_TIMER_tag TIMER[8];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

typedef union PLLDIG_PLL0CR_union_tag { /* PLLDIG PLL0 Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t  :1;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t EXPDIE:1;                /* External Power Down Cycle Complete indication interrupt enable. */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
  } B;
} PLLDIG_PLL0CR_tag;

typedef union PLLDIG_PLL0SR_union_tag { /* PLLDIG PLL0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t EXTPDF:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t LOCK:1;
    vuint32_t  :1;
    vuint32_t  :1;
  } B;
} PLLDIG_PLL0SR_tag;

typedef union PLLDIG_PLL0DV_union_tag { /* PLLDIG PLL0 Divider Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t RFDPHI1:4;               /* PHI1 reduced frequency divider. */
    vuint32_t  :5;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t  :1;
    vuint32_t PREDIV:3;                /* Input clock predivider. */
    vuint32_t  :5;
    vuint32_t MFD:7;                   /* Loop multiplication factor divider. */
  } B;
} PLLDIG_PLL0DV_tag;

typedef union PLLDIG_PLL1CR_union_tag { /* PLLDIG PLL1 Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t  :1;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t EXPDIE:1;                /* External Power Down Cycle Complete indication interrupt enable. */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
  } B;
} PLLDIG_PLL1CR_tag;

typedef union PLLDIG_PLL1SR_union_tag { /* PLLDIG PLL1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t EXTPDF:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t LOCK:1;
    vuint32_t  :1;
    vuint32_t  :1;
  } B;
} PLLDIG_PLL1SR_tag;

typedef union PLLDIG_PLL1DV_union_tag { /* PLLDIG PLL1 Divider Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t  :5;
    vuint32_t  :4;
    vuint32_t MFD:7;                   /* Loop multiplication factor divider. */
  } B;
} PLLDIG_PLL1DV_tag;

typedef union PLLDIG_PLL1FM_union_tag { /* PLLDIG PLL1 Frequency Modulation Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t MODEN:1;                 /* Modulation enable. */
    vuint32_t MODSEL:1;                /* Modulation selection. */
    vuint32_t MODPRD:13;               /* Modulation period. */
    vuint32_t  :1;
    vuint32_t INCSTP:15;               /* Increment step. */
  } B;
} PLLDIG_PLL1FM_tag;

typedef union PLLDIG_PLL1FD_union_tag { /* PLLDIG PLL1 Fractional Divide Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t FDEN:1;                  /* Fractional Divide Enable */
    vuint32_t  :12;
    vuint32_t DTHDIS:2;                /* Dither Disable. */
    vuint32_t  :4;
    vuint32_t FRCDIV:12;
  } B;
} PLLDIG_PLL1FD_tag;

struct PLLDIG_tag {
  PLLDIG_PLL0CR_tag PLL0CR;            /* PLLDIG PLL0 Control Register */
  PLLDIG_PLL0SR_tag PLL0SR;            /* PLLDIG PLL0 Status Register */
  PLLDIG_PLL0DV_tag PLL0DV;            /* PLLDIG PLL0 Divider Register */
  uint8_t PLLDIG_reserved0[20];
  PLLDIG_PLL1CR_tag PLL1CR;            /* PLLDIG PLL1 Control Register */
  PLLDIG_PLL1SR_tag PLL1SR;            /* PLLDIG PLL1 Status Register */
  PLLDIG_PLL1DV_tag PLL1DV;            /* PLLDIG PLL1 Divider Register */
  PLLDIG_PLL1FM_tag PLL1FM;            /* PLLDIG PLL1 Frequency Modulation Register */
  PLLDIG_PLL1FD_tag PLL1FD;            /* PLLDIG PLL1 Fractional Divide Register */
};


/* ============================================================================
   =============================== Module: PMC ================================
   ============================================================================ */

typedef union PMC_TS_IER_union_tag {   /* Temperature Sensor Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TS_EN:1;                 /* Temperature Sensor interrupts Enable */
    vuint32_t  :25;
    vuint32_t  :1;
    vuint32_t TS1_2IE:1;               /* Temperature Sensor 1 input 2 Interrupt Enable. */
    vuint32_t TS1_0IE:1;               /* Temperature Sensor 1 input 0 Interrupt Enable. */
    vuint32_t  :1;
    vuint32_t TS0_2IE:1;               /* Temperature Sensor 0 input 2 Interrupt Enable. */
    vuint32_t TS0_0IE:1;               /* Temperature Sensor 0 input 0 Interrupt Enable. */
  } B;
} PMC_TS_IER_tag;

typedef union PMC_ESR_TD_union_tag {   /* Temperature Event Status register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t  :1;
    vuint32_t TEMP1_2:1;
    vuint32_t TEMP1_0:1;
    vuint32_t  :1;
    vuint32_t TEMP0_2:1;
    vuint32_t TEMP0_0:1;
  } B;
} PMC_ESR_TD_tag;

typedef union PMC_REE_TD_union_tag {   /* Temperature Reset Event Enable register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t  :1;
    vuint32_t TEMP1_2:1;
    vuint32_t TEMP1_0:1;
    vuint32_t  :1;
    vuint32_t TEMP0_2:1;
    vuint32_t TEMP0_0:1;
  } B;
} PMC_REE_TD_tag;

typedef union PMC_RES_TD_union_tag {   /* Temperature Reset Event Selection register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t  :1;
    vuint32_t TEMP1_2:1;               /* TEMP1_2 Reset Event Select. */
    vuint32_t TEMP1_0:1;               /* TEMP1_0 Reset Event Select. */
    vuint32_t  :1;
    vuint32_t TEMP0_2:1;               /* TEMP0_2 Reset Event Select. */
    vuint32_t TEMP0_0:1;               /* TEMP0_0 Reset Event Select. */
  } B;
} PMC_RES_TD_tag;

typedef union PMC_CTL_TD_union_tag {   /* Temperature detector configuration register */
  vuint32_t R;
  struct {
    vuint32_t  :17;                    /* Reserved */
    vuint32_t  :5;
    vuint32_t TS1_EN:1;
    vuint32_t  :1;
    vuint32_t  :1;                     /* Reserved */
    vuint32_t  :5;
    vuint32_t TS0_EN:1;
    vuint32_t  :1;
  } B;
} PMC_CTL_TD_tag;

typedef union PMC_TS_FIR_union_tag {   /* Temperature Fault Injection Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t TSNS_FAULT:1;            /* Temperature Sensor Fault injection. */
  } B;
} PMC_TS_FIR_tag;

typedef union PMC_SELF_TEST_UM_VD_REG_union_tag { /* Voltage Detect User Mode Test Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t ST_RESULT:1;
    vuint32_t ST_DONE:1;
    vuint32_t  :8;
    vuint32_t ST_MODE:2;               /* Self Test mode bits for testing of LVDs and HVDs. */
    vuint32_t VD_ST_CTRL:6;
  } B;
} PMC_SELF_TEST_UM_VD_REG_tag;

typedef union PMC_FIR_union_tag {      /* FCCU Fault Injection Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t STEST_FAULT:1;
    vuint32_t  :1;
    vuint32_t HVD_FAULT:1;             /* High Voltage Detect Fault injection. */
    vuint32_t LVD_FAULT:1;             /* Low Voltage Detect Fault injection. */
  } B;
} PMC_FIR_tag;

typedef union PMC_LVD_HVD_INTR_ENB_union_tag { /* LVD HVD Interrupt Enable Control Register */
  vuint32_t R;
  struct {
    vuint32_t PMC_ENABLE:1;            /* PMC Enable Control */
    vuint32_t  :15;
    vuint32_t  :1;
    vuint32_t LVD_PMC:1;               /* LVD_PMC Control */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LVD_SAR_ADC:1;           /* LVD_SAR_ADC Control */
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LVD_IO:1;                /* LVD_IO Control */
    vuint32_t HVD_FLASH:1;             /* HVD FLASH Control */
    vuint32_t LVD_FLASH:1;             /* LVD FLASH Control */
    vuint32_t HVD_HV:1;                /* HVD HV Control */
    vuint32_t HVD_CORE:1;              /* HVD Core Control */
    vuint32_t LVD_CORE_HOT:1;          /* LVD Core Hot Control */
    vuint32_t LVD_CORE_COLD:1;         /* LVD Core Cold Control */
  } B;
} PMC_LVD_HVD_INTR_ENB_tag;

typedef union PMC_LVD_HVD_EVENT_STATUS_union_tag { /* LVD HVD Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t LVD_BUDDY:1;
    vuint32_t  :1;
    vuint32_t LVD_PMC:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LVD_SAR_ADC:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t LVD_IO:1;
    vuint32_t HVD_FLASH:1;
    vuint32_t LVD_FLASH:1;
    vuint32_t HVD_HV:1;
    vuint32_t HVD_CORE:1;
    vuint32_t LVD_CORE_HOT:1;
    vuint32_t LVD_CORE_COLD:1;
  } B;
} PMC_LVD_HVD_EVENT_STATUS_tag;

typedef union PMC_REE_union_tag {      /* Reset Enable Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t LVD_PMC:1;
    vuint32_t  :3;                     /* Reserved. Read only zero. */
    vuint32_t LVD_SAR_ADC:1;           /* Reset Enable/Disable Control */
    vuint32_t  :3;                     /* Read */
    vuint32_t LVD_IO:1;
    vuint32_t HVD_FLASH:1;             /* Reset Enable/Disable Control */
    vuint32_t LVD_FLASH:1;             /* Reset Enable/Disable Control */
    vuint32_t HVD_HV:1;                /* Reset Enable/Disable Control */
    vuint32_t HVD_CORE:1;              /* Reset Enable/Disable Control */
    vuint32_t LVD_CORE_HOT:1;          /* Reset Enable/Disable Control */
    vuint32_t LVD_CORE_COLD:1;         /* Reset Enable/Disable Control */
  } B;
} PMC_REE_tag;

typedef union PMC_RES_union_tag {      /* Reset Type ( Destructive / Functional) Selection Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t LVD_PMC:1;
    vuint32_t  :3;
    vuint32_t LVD_SAR_ADC:1;
    vuint32_t  :3;
    vuint32_t LVD_IO:1;
    vuint32_t HVD_FLASH:1;
    vuint32_t LVD_FLASH:1;
    vuint32_t HVD_HV:1;
    vuint32_t HVD_CORE:1;
    vuint32_t LVD_CORE_HOT:1;
    vuint32_t LVD_CORE_COLD:1;         /* LVD Core Enable Disable Bit */
  } B;
} PMC_RES_tag;

typedef union PMC_ADC_CS_union_tag {   /* ADC Channel Select Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t STND_BY_RAM_BO_CLR:1;
    vuint32_t STND_BY_RAM_BR_DETCT:1;
    vuint32_t  :2;
    vuint32_t ADC_CHSE:6;
  } B;
} PMC_ADC_CS_tag;

struct PMC_tag {
  uint8_t PMC_reserved0[164];
  PMC_TS_IER_tag TS_IER;               /* Temperature Sensor Interrupt Enable Register */
  PMC_ESR_TD_tag ESR_TD;               /* Temperature Event Status register */
  PMC_REE_TD_tag REE_TD;               /* Temperature Reset Event Enable register */
  PMC_RES_TD_tag RES_TD;               /* Temperature Reset Event Selection register */
  PMC_CTL_TD_tag CTL_TD;               /* Temperature detector configuration register */
  uint8_t PMC_reserved1[8];
  PMC_TS_FIR_tag TS_FIR;               /* Temperature Fault Injection Register */
  uint8_t PMC_reserved2[12];
  PMC_SELF_TEST_UM_VD_REG_tag SELF_TEST_UM_VD_REG; /* Voltage Detect User Mode Test Register */
  PMC_FIR_tag FIR;                     /* FCCU Fault Injection Register */
  PMC_LVD_HVD_INTR_ENB_tag LVD_HVD_INTR_ENB; /* LVD HVD Interrupt Enable Control Register */
  PMC_LVD_HVD_EVENT_STATUS_tag LVD_HVD_EVENT_STATUS; /* LVD HVD Event Status Register */
  PMC_REE_tag REE;                     /* Reset Enable Control Register */
  PMC_RES_tag RES;                     /* Reset Type ( Destructive / Functional) Selection Register */
  PMC_ADC_CS_tag ADC_CS;               /* ADC Channel Select Register */
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

typedef union PRAMC_PRCR1_union_tag {  /* Platform RAM Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t PRI:2;                   /* AHB port arbitration mode. */
    vuint32_t P1_BO_DIS:1;             /* Port p1 read burst optimization disable. */
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t  :5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR1_tag;

struct PRAMC_tag {
  PRAMC_PRCR1_tag PRCR1;               /* Platform RAM Configuration Register 1 */
};


/* ============================================================================
   =============================== Module: REACM2 =============================
   ============================================================================ */

typedef union REACM2_MCR_union_tag {   /* Module Configuration */
  vuint32_t R;
  struct {
    vuint32_t OVRC:1;                  /* Overrun Detection Flag Clear */
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze Control */
    vuint32_t  :1;
    vuint32_t FREN:1;                  /* Freeze Enable */
    vuint32_t TPREN:1;                 /* Timer Prescaler Enable */
    vuint32_t HPREN:1;                 /* Hold Timer Prescaler Enable */
    vuint32_t GIEN:1;                  /* Global Interrupt Enable */
    vuint32_t OVREN:1;                 /* Overrun Detection Interrupt Enable */
    vuint32_t  :23;
  } B;
} REACM2_MCR_tag;

typedef union REACM2_TCR_union_tag {   /* Timer Configuration */
  vuint32_t R;
  struct {
    vuint32_t  :4;
    vuint32_t HPRE:12;                 /* Hold Timer Prescaler */
    vuint32_t  :8;
    vuint32_t TPRE:8;                  /* Timer Prescaler */
  } B;
} REACM2_TCR_tag;

typedef union REACM2_THRR_union_tag {  /* Threshold Router Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t WREN1:1;                 /* Write Enable Bit for THRADC1 */
    vuint32_t WREN0:1;                 /* Write Enable Bit for THRADC0 */
    vuint32_t  :12;
    vuint32_t THRADC1:4;               /* ADC result Router value for Threshold Bank address one */
    vuint32_t  :4;
    vuint32_t THRADC0:4;               /* ADC result Router for Threshold Bank address zero */
  } B;
} REACM2_THRR_tag;

typedef union REACM2_SINR_union_tag {  /* ADC Sensor Input Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t ADC_TAG:4;               /* TAG value */
    vuint32_t ADC_RESULT:16;           /* ADC conversion result value */
  } B;
} REACM2_SINR_tag;

typedef union REACM2_PCR_union_tag {   /* Period Generator Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t PERPRESC:8;              /* Period prescaler rate value */
    vuint32_t PER:16;                  /* Period time value */
  } B;
} REACM2_PCR_tag;

typedef union REACM2_PSCR_union_tag {  /* Period Shift Delay Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t DLY:16;                  /* Delay value between two consecutive channel period pulses */
  } B;
} REACM2_PSCR_tag;

typedef union REACM2_GEFR_union_tag {  /* Global Error Flag Register */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun Detection Flag */
    vuint32_t  :21;
    vuint32_t EF9:1;                   /* Error Flag */
    vuint32_t EF8:1;                   /* Error Flag */
    vuint32_t EF7:1;                   /* Error Flag */
    vuint32_t EF6:1;                   /* Error Flag */
    vuint32_t EF5:1;                   /* Error Flag */
    vuint32_t EF4:1;                   /* Error Flag */
    vuint32_t EF3:1;                   /* Error Flag */
    vuint32_t EF2:1;                   /* Error Flag */
    vuint32_t EF1:1;                   /* Error Flag */
    vuint32_t EF0:1;                   /* Error Flag */
  } B;
} REACM2_GEFR_tag;

typedef union REACM2_CH_CR_union_tag { /* Channel n Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t CHEN:2;                  /* Channel Enable Bits */
    vuint32_t SWMC:1;                  /* Software Modulation Control bit */
    vuint32_t MAXLEN:1;                /* ADC result Maximum Limit Interrupt Enable bit */
    vuint32_t OCDFEN:1;                /* OCDF Interrupt Enable bit */
    vuint32_t SCDFEN:1;                /* SCDF Interrupt Enable bit */
    vuint32_t TAEREN:1;                /* TAER Interrupt Enable bit */
    vuint32_t SQEREN:1;                /* Modulation Word Sequence Error Interrupt Enable */
    vuint32_t RAEREN:1;                /* Resource Allocation Error Interrupt Enable */
    vuint32_t DMAEN:1;                 /* Direct Memory Access Enable bit */
    vuint32_t CHOFF:1;                 /* Output Disable bit */
    vuint32_t SDCM:1;                  /* Short Detection Counting Mode */
    vuint32_t  :1;
    vuint32_t DOFF:3;                  /* Drive Off Control field */
    vuint32_t  :5;
    vuint32_t BSB:3;                   /* Bank Support Bits */
    vuint32_t  :3;
    vuint32_t MODULATION_ADDR:5;       /* Address for Modulation Control Bank */
  } B;
} REACM2_CH_CR_tag;

typedef union REACM2_CH_SR_union_tag { /* Channel n Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t MODACT:1;                /* Modulation Active Flag */
    vuint32_t MAXL:1;                  /* ADC Maximum Limit Detection Flag */
    vuint32_t OCDF:1;                  /* Open Circuit Detection Flag */
    vuint32_t SCDF:1;                  /* Short Circuit Detection Flag */
    vuint32_t TAER:1;                  /* Timer Allocation Error */
    vuint32_t SQER:1;                  /* Modulation Word Sequence Error Flag */
    vuint32_t RAER:1;                  /* Resource Allocation Error Flag */
    vuint32_t CHOUT:3;                 /* Channel Output Monitoring bits */
    vuint32_t  :7;
    vuint32_t MAXLC:1;                 /* ADC Maximum Limit Flag Clear */
    vuint32_t OCDFC:1;                 /* Open Circuit Detection Flag Clear */
    vuint32_t SCDFC:1;                 /* Short Circuit Detection Flag clear */
    vuint32_t TAERC:1;                 /* TAER Clear bit */
    vuint32_t SQERC:1;                 /* Modulation Word Sequence Error Flag clear */
    vuint32_t RAERC:1;                 /* Resource Allocation Error Flag clear */
    vuint32_t  :1;
    vuint32_t MODULATION_POINTER:6;    /* Modulation bank address generated by the channel */
  } B;
} REACM2_CH_SR_tag;

typedef union REACM2_CH_RR_union_tag { /* Channel n Router Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t ADCR:4;                  /* ADC result router field */
    vuint32_t  :12;
    vuint32_t CHIR:4;                  /* Channel Input router field */
  } B;
} REACM2_CH_RR_tag;

typedef struct REACM2_CH_struct_tag {
  REACM2_CH_CR_tag CR;                 /* Channel n Configuration Register */
  REACM2_CH_SR_tag SR;                 /* Channel n Status Register */
  REACM2_CH_RR_tag RR;                 /* Channel n Router Register */
  uint8_t CH_reserved0[4];
} REACM2_CH_tag;

typedef union REACM2_STBK_union_tag {  /* Shared Timer Bank */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SHARED_TIMER:16;         /* Timer Value */
  } B;
} REACM2_STBK_tag;

typedef union REACM2_HOTBK_union_tag { /* Hold Timer Bank */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t HOLD_TIM:12;             /* Hold Timer Value */
  } B;
} REACM2_HOTBK_tag;

typedef union REACM2_THBK_union_tag {  /* Threshold Bank */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t THRESHOLD_VALUE:16;      /* Threshold Value */
  } B;
} REACM2_THBK_tag;

typedef union REACM2_ADCMAX_union_tag { /* ADC Result Maximum Limit Check */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t ADC_MAX_LIMIT:16;        /* Maximum Limit allowed for the ADC result */
  } B;
} REACM2_ADCMAX_tag;

typedef union REACM2_RANGE_PWD_union_tag { /* Modulation Range Pulse Width */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t RANGE_PWD:12;            /* Range Pulse Width */
  } B;
} REACM2_RANGE_PWD_tag;

typedef union REACM2_MIN_PWD_union_tag { /* Modulation Minimum Pulse Width */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t MIN_PWD:12;              /* Minimum Pulse Width */
  } B;
} REACM2_MIN_PWD_tag;

typedef union REACM2_MWBK_union_tag {  /* Modulation Control Word Bank */
  vuint32_t R;
  struct {
    vuint32_t LOOP:1;                  /* Loop Control Bit */
    vuint32_t IOSS:1;                  /* Initial Output State Selection */
    vuint32_t DMA:1;                   /* DMA bit */
    vuint32_t MM:2;                    /* Modulation Mode */
    vuint32_t  :1;
    vuint32_t SM:2;                    /* Sequencer Mode */
    vuint32_t  :1;
    vuint32_t HOD:3;                   /* High Output Drive */
    vuint32_t  :1;
    vuint32_t LOD:3;                   /* Low Output Drive */
    vuint32_t  :2;
    vuint32_t THRESPT:5;               /* Threshold Pointer */
    vuint32_t  :1;
    vuint32_t STPT:3;                  /* Shared Timer Pointer */
    vuint32_t  :2;
    vuint32_t HDOFFTPT:3;              /* Hold on/off Pointer */
  } B;
} REACM2_MWBK_tag;

struct REACM2_tag {
  REACM2_MCR_tag MCR;                  /* Module Configuration */
  REACM2_TCR_tag TCR;                  /* Timer Configuration */
  REACM2_THRR_tag THRR;                /* Threshold Router Register */
  uint8_t REACM2_reserved0[4];
  REACM2_SINR_tag SINR;                /* ADC Sensor Input Register */
  REACM2_PCR_tag PCR;                  /* Period Generator Configuration Register */
  REACM2_PSCR_tag PSCR;                /* Period Shift Delay Configuration Register */
  uint8_t REACM2_reserved1[4];
  REACM2_GEFR_tag GEFR;                /* Global Error Flag Register */
  uint8_t REACM2_reserved2[220];
  REACM2_CH_tag CH[10];
  uint8_t REACM2_reserved3[352];
  REACM2_STBK_tag STBK[5];             /* Shared Timer Bank */
  uint8_t REACM2_reserved4[108];
  REACM2_HOTBK_tag HOTBK[5];           /* Hold Timer Bank */
  uint8_t REACM2_reserved5[108];
  REACM2_THBK_tag THBK[32];            /* Threshold Bank */
  uint8_t REACM2_reserved6[384];
  REACM2_ADCMAX_tag ADCMAX;            /* ADC Result Maximum Limit Check */
  uint8_t REACM2_reserved7[124];
  REACM2_RANGE_PWD_tag RANGE_PWD;      /* Modulation Range Pulse Width */
  uint8_t REACM2_reserved8[60];
  REACM2_MIN_PWD_tag MIN_PWD;          /* Modulation Minimum Pulse Width */
  uint8_t REACM2_reserved9[60];
  REACM2_MWBK_tag MWBK[32];            /* Modulation Control Word Bank */
};


/* ============================================================================
   =============================== Module: SDADC ==============================
   ============================================================================ */

typedef union SDADC_MCR_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;
    vuint32_t PDR:5;
    vuint32_t  :1;
    vuint32_t PGAN:3;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t EMSEL:1;
    vuint32_t HPFEN:1;
    vuint32_t WDGEN:1;
    vuint32_t TRIGEDSEL:2;
    vuint32_t TRIGEN:1;
    vuint32_t  :2;
    vuint32_t TRIGSEL:2;
    vuint32_t FRZ:1;
    vuint32_t  :2;
    vuint32_t VCOMSEL:1;
    vuint32_t WRMODE:1;
    vuint32_t GECEN:1;                 /* Accurate Gain Error Mode Enable */
    vuint32_t MODE:1;
    vuint32_t EN:1;
  } B;
} SDADC_MCR_tag;

typedef union SDADC_CSR_union_tag {    /* Channel Selection Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t BIASEN:8;
    vuint32_t  :5;
    vuint32_t ANCHSEL_WRAP:3;
    vuint32_t  :5;
    vuint32_t ANCHSEL:3;
  } B;
} SDADC_CSR_tag;

typedef union SDADC_RKR_union_tag {    /* Reset Key Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t RESET_KEY:16;
  } B;
} SDADC_RKR_tag;

typedef union SDADC_SFR_union_tag {    /* Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :13;
    vuint32_t ANCHSEL_CNT:3;
    vuint32_t  :7;
    vuint32_t DFEF:1;
    vuint32_t  :3;
    vuint32_t WTHH:1;
    vuint32_t WTHL:1;
    vuint32_t CDVF:1;
    vuint32_t DFORF:1;
    vuint32_t DFFF:1;
  } B;
} SDADC_SFR_tag;

typedef union SDADC_RSER_union_tag {   /* Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :14;
    vuint32_t WTHDIRS:1;
    vuint32_t DFFDIRS:1;
    vuint32_t GDIGE:1;
    vuint32_t  :11;
    vuint32_t WTHDIRE:1;
    vuint32_t CDVEE:1;
    vuint32_t DFORIE:1;
    vuint32_t DFFDIRE:1;
  } B;
} SDADC_RSER_tag;

typedef union SDADC_OSDR_union_tag {   /* Output Settling Delay Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t OSD:8;
  } B;
} SDADC_OSDR_tag;

typedef union SDADC_FCR_union_tag {    /* FIFO Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t FTHLD:4;
    vuint32_t  :4;
    vuint32_t FOWEN:1;
    vuint32_t FSIZE:2;
    vuint32_t FE:1;
  } B;
} SDADC_FCR_tag;

typedef union SDADC_STKR_union_tag {   /* Software Trigger Key Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t ST_KEY:16;
  } B;
} SDADC_STKR_tag;

typedef union SDADC_CDR_union_tag {    /* Converted Data Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CDATA:16;
  } B;
} SDADC_CDR_tag;

typedef union SDADC_WTHHLR_union_tag { /* WDG Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t THRH:16;
    vuint32_t THRL:16;
  } B;
} SDADC_WTHHLR_tag;

struct SDADC_tag {
  SDADC_MCR_tag MCR;                   /* Module Configuration Register */
  SDADC_CSR_tag CSR;                   /* Channel Selection Register */
  SDADC_RKR_tag RKR;                   /* Reset Key Register */
  SDADC_SFR_tag SFR;                   /* Status Flag Register */
  SDADC_RSER_tag RSER;                 /* Request Select and Enable Register */
  SDADC_OSDR_tag OSDR;                 /* Output Settling Delay Register */
  SDADC_FCR_tag FCR;                   /* FIFO Control Register */
  SDADC_STKR_tag STKR;                 /* Software Trigger Key Register */
  SDADC_CDR_tag CDR;                   /* Converted Data Register */
  SDADC_WTHHLR_tag WTHHLR;             /* WDG Threshold Register */
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

typedef union SEMA42_GATE_union_tag {  /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t  :4;
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
  } B;
} SEMA42_GATE_tag;

typedef union SEMA42_RSTGT_R_union_tag { /* Reset Gate Read */
  vuint16_t R;
  struct {
    vuint16_t  :2;
    vuint16_t RSTGSM:2;
    vuint16_t RSTGMS:4;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_R_tag;

typedef union SEMA42_RSTGT_W_union_tag { /* Reset Gate Write */
  vuint16_t R;
  struct {
    vuint16_t RSTGDP:8;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_W_tag;

typedef union SEMA42_RSTGT_union_tag {
  SEMA42_RSTGT_R_tag R;                /* Reset Gate Read */
  SEMA42_RSTGT_W_tag W;                /* Reset Gate Write */
} SEMA42_RSTGT_tag;

struct SEMA42_tag {
  SEMA42_GATE_tag GATE[16];            /* Gate Register */
  uint8_t SEMA42_reserved0[48];
  SEMA42_RSTGT_tag RSTGT;
};


/* ============================================================================
   =============================== Module: SIPI ===============================
   ============================================================================ */

typedef union SIPI_CCR0_union_tag {    /* SIPI Channel Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;                    /* Streaming Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR0_tag;

typedef union SIPI_CSR0_union_tag {    /* SIPI Channel Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR0_tag;

typedef union SIPI_CIR0_union_tag {    /* SIPI Channel Interrupt Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;                  /* Write Acknowledge Interrupt Enable. */
    vuint32_t RAIE:1;                  /* Read Answer Interrupt Enable. */
    vuint32_t TCIE:1;                  /* Trigger Command Interrupt Enable. */
    vuint32_t TOIE:1;                  /* Timeout Error Interrupt Enabled. */
    vuint32_t TIDIE:1;                 /* Transaction ID Error Interrupt Enable. */
    vuint32_t ACKIE:1;                 /* Acknowledge Error Interrupt Enable. */
  } B;
} SIPI_CIR0_tag;

typedef union SIPI_CTOR0_union_tag {   /* SIPI Channel Timeout Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR0_tag;

typedef union SIPI_CCRC0_union_tag {   /* SIPI Channel CRC Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC0_tag;

typedef union SIPI_CAR0_union_tag {    /* SIPI Channel Address Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR0_tag;

typedef union SIPI_CDR0_union_tag {    /* SIPI Channel Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR0_tag;

typedef union SIPI_CCR1_union_tag {    /* SIPI Channel Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR1_tag;

typedef union SIPI_CSR1_union_tag {    /* SIPI Channel Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR1_tag;

typedef union SIPI_CIR1_union_tag {    /* SIPI Channel Interrupt Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR1_tag;

typedef union SIPI_CTOR1_union_tag {   /* SIPI Channel Timeout Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR1_tag;

typedef union SIPI_CCRC1_union_tag {   /* SIPI Channel CRC Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC1_tag;

typedef union SIPI_CAR1_union_tag {    /* SIPI Channel Address Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR1_tag;

typedef union SIPI_CDR1_union_tag {    /* SIPI Channel Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR1_tag;

typedef union SIPI_CCR2_union_tag {    /* SIPI Channel Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR2_tag;

typedef union SIPI_CSR2_union_tag {    /* SIPI Channel Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR2_tag;

typedef union SIPI_CIR2_union_tag {    /* SIPI Channel Interrupt Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR2_tag;

typedef union SIPI_CTOR2_union_tag {   /* SIPI Channel Timeout Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;
  } B;
} SIPI_CTOR2_tag;

typedef union SIPI_CCRC2_union_tag {   /* SIPI Channel CRC Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC2_tag;

typedef union SIPI_CAR2_union_tag {    /* SIPI Channel Address Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR2_tag;

typedef union SIPI_CDR2_union_tag {    /* SIPI Channel Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CDR2:32;
  } B;
} SIPI_CDR2_tag;

typedef union SIPI_CCR3_union_tag {    /* SIPI Channel Control Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t  :8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;                    /* Streaming Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR3_tag;

typedef union SIPI_CSR3_union_tag {    /* SIPI Channel Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t  :2;
  } B;
} SIPI_CSR3_tag;

typedef union SIPI_CIR3_union_tag {    /* SIPI Channel Interrupt Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR3_tag;

typedef union SIPI_CTOR3_union_tag {   /* SIPI Channel Timeout Register 3 */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR3_tag;

typedef union SIPI_CCRC3_union_tag {   /* SIPI Channel CRC Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC3_tag;

typedef union SIPI_CAR3_union_tag {    /* SIPI Channel Address Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR3_tag;

typedef union SIPI_CDR3_union_tag {    /* SIPI Channel Data Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR3_tag;

typedef union SIPI_MCR_union_tag {     /* SIPI Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t  :1;
    vuint32_t HALT:1;                  /* Halt Mode Enable */
    vuint32_t  :2;
    vuint32_t PRSCLR:11;               /* Timeout counter prescaler */
    vuint32_t AID:2;                   /* Address Increment/Decrement */
    vuint32_t  :3;
    vuint32_t CRCIE:1;                 /* CRC Error Interrupt Enable */
    vuint32_t MCRIE:1;                 /* Max Count Reached Interrupt Enable */
    vuint32_t  :4;
    vuint32_t CHNSB:1;                 /* Channel coding select bit. */
    vuint32_t TEN:1;                   /* Target Enable */
    vuint32_t INIT:1;                  /* Initialization Mode */
    vuint32_t MOEN:1;                  /* Module Enable */
    vuint32_t SR:1;                    /* Soft Reset */
  } B;
} SIPI_MCR_tag;

typedef union SIPI_SR_union_tag {      /* SIPI Status Register */
  vuint32_t R;
  struct {
    vuint32_t FRZACK:1;
    vuint32_t LPMACK:1;                /* Low Power Mode Acknowledge. */
    vuint32_t  :19;
    vuint32_t GCRCE:1;
    vuint32_t MCR:1;                   /* Maximum Count Reached. */
    vuint32_t  :1;
    vuint32_t TE:4;
    vuint32_t STATE:4;
  } B;
} SIPI_SR_tag;

typedef union SIPI_MAXCR_union_tag {   /* SIPI Max Count Register */
  vuint32_t R;
  struct {
    vuint32_t MXCNT:30;
    vuint32_t  :2;
  } B;
} SIPI_MAXCR_tag;

typedef union SIPI_ARR_union_tag {     /* SIPI Address Reload Register */
  vuint32_t R;
  struct {
    vuint32_t ADRLD:30;
    vuint32_t  :2;
  } B;
} SIPI_ARR_tag;

typedef union SIPI_ACR_union_tag {     /* SIPI Address Count Register */
  vuint32_t R;
  struct {
    vuint32_t ADCNT:30;                /* Feflects the count value of address counter at target node. */
    vuint32_t  :2;
  } B;
} SIPI_ACR_tag;

typedef union SIPI_ERR_union_tag {     /* SIPI Error Register */
  vuint32_t R;
  struct {
    vuint32_t  :5;
    vuint32_t TOE3:1;
    vuint32_t TIDE3:1;
    vuint32_t ACKE3:1;
    vuint32_t  :5;
    vuint32_t TOE2:1;
    vuint32_t TIDE2:1;
    vuint32_t ACKE2:1;
    vuint32_t  :5;
    vuint32_t TOE1:1;
    vuint32_t TIDE1:1;
    vuint32_t ACKE1:1;
    vuint32_t  :5;
    vuint32_t TOE0:1;
    vuint32_t TIDE0:1;
    vuint32_t ACKE0:1;
  } B;
} SIPI_ERR_tag;

struct SIPI_tag {
  SIPI_CCR0_tag CCR0;                  /* SIPI Channel Control Register 0 */
  SIPI_CSR0_tag CSR0;                  /* SIPI Channel Status Register 0 */
  uint8_t SIPI_reserved0[4];
  SIPI_CIR0_tag CIR0;                  /* SIPI Channel Interrupt Register 0 */
  SIPI_CTOR0_tag CTOR0;                /* SIPI Channel Timeout Register 0 */
  SIPI_CCRC0_tag CCRC0;                /* SIPI Channel CRC Register 0 */
  SIPI_CAR0_tag CAR0;                  /* SIPI Channel Address Register 0 */
  SIPI_CDR0_tag CDR0;                  /* SIPI Channel Data Register 0 */
  SIPI_CCR1_tag CCR1;                  /* SIPI Channel Control Register 1 */
  SIPI_CSR1_tag CSR1;                  /* SIPI Channel Status Register 1 */
  uint8_t SIPI_reserved1[4];
  SIPI_CIR1_tag CIR1;                  /* SIPI Channel Interrupt Register 1 */
  SIPI_CTOR1_tag CTOR1;                /* SIPI Channel Timeout Register 1 */
  SIPI_CCRC1_tag CCRC1;                /* SIPI Channel CRC Register 1 */
  SIPI_CAR1_tag CAR1;                  /* SIPI Channel Address Register 1 */
  SIPI_CDR1_tag CDR1;                  /* SIPI Channel Data Register 1 */
  SIPI_CCR2_tag CCR2;                  /* SIPI Channel Control Register 2 */
  SIPI_CSR2_tag CSR2;                  /* SIPI Channel Status Register 2 */
  uint8_t SIPI_reserved2[4];
  SIPI_CIR2_tag CIR2;                  /* SIPI Channel Interrupt Register 2 */
  SIPI_CTOR2_tag CTOR2;                /* SIPI Channel Timeout Register 2 */
  SIPI_CCRC2_tag CCRC2;                /* SIPI Channel CRC Register 2 */
  SIPI_CAR2_tag CAR2;                  /* SIPI Channel Address Register 2 */
  SIPI_CDR2_tag CDR2[8];               /* SIPI Channel Data Register 2 */
  SIPI_CCR3_tag CCR3;                  /* SIPI Channel Control Register 3 */
  SIPI_CSR3_tag CSR3;                  /* SIPI Channel Status Register 3 */
  uint8_t SIPI_reserved3[4];
  SIPI_CIR3_tag CIR3;                  /* SIPI Channel Interrupt Register 3 */
  SIPI_CTOR3_tag CTOR3;                /* SIPI Channel Timeout Register 3 */
  SIPI_CCRC3_tag CCRC3;                /* SIPI Channel CRC Register 3 */
  SIPI_CAR3_tag CAR3;                  /* SIPI Channel Address Register 3 */
  SIPI_CDR3_tag CDR3;                  /* SIPI Channel Data Register 3 */
  SIPI_MCR_tag MCR;                    /* SIPI Module Configuration Register */
  SIPI_SR_tag SR;                      /* SIPI Status Register */
  SIPI_MAXCR_tag MAXCR;                /* SIPI Max Count Register */
  SIPI_ARR_tag ARR;                    /* SIPI Address Reload Register */
  SIPI_ACR_tag ACR;                    /* SIPI Address Count Register */
  SIPI_ERR_tag ERR;                    /* SIPI Error Register */
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

typedef union SIUL2_MIDR1_union_tag {  /* SIUL2 MCU ID Register #1 */
  vuint32_t R;
  struct {
    vuint32_t PARTNUM:16;              /* MCU Part Number */
    vuint32_t ED:1;
    vuint32_t PKG:5;                   /* Package Settings */
    vuint32_t  :2;
    vuint32_t MAJOR_MASK:4;            /* Major Mask Revision. 0x1 for Cut2.0B of this device. */
    vuint32_t MINOR_MASK:4;            /* Minor Mask Revision. 0x1 for Cut2.0B of this device. */
  } B;
} SIUL2_MIDR1_tag;

typedef union SIUL2_MIDR2_union_tag {  /* SIUL2 MCU ID Register #2 */
  vuint32_t R;
  struct {
    vuint32_t SF:1;                    /* Manufacturer */
    vuint32_t FLASH_SIZE_1:4;          /* Coarse granularity for flash memory size */
    vuint32_t FLASH_SIZE_2:4;          /* Fine granularity for flash memory size */
    vuint32_t  :7;
    vuint32_t PARTNUM:8;               /* ASCII character in MCU Part Number */
    vuint32_t  :8;
  } B;
} SIUL2_MIDR2_tag;

typedef union SIUL2_DISR0_union_tag {  /* SIUL2 DMA/Interrupt Status Flag Register0 */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t EIF10:1;                 /* External Interrupt Status Flag 10 */
    vuint32_t EIF9:1;                  /* External Interrupt Status Flag 9 */
    vuint32_t EIF8:1;                  /* External Interrupt Status Flag 8 */
    vuint32_t EIF7:1;                  /* External Interrupt Status Flag 7 */
    vuint32_t EIF6:1;                  /* External Interrupt Status Flag 6 */
    vuint32_t EIF5:1;                  /* External Interrupt Status Flag 5 */
    vuint32_t EIF4:1;                  /* External Interrupt Status Flag 4 */
    vuint32_t EIF3:1;                  /* External Interrupt Status Flag 3 */
    vuint32_t EIF2:1;                  /* External Interrupt Status Flag 2 */
    vuint32_t EIF1:1;                  /* External Interrupt Status Flag 1 */
    vuint32_t EIF0:1;                  /* External Interrupt Status Flag 0 */
  } B;
} SIUL2_DISR0_tag;

typedef union SIUL2_DIRER0_union_tag { /* SIUL2 DMA/Interrupt Request Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t EIRE10:1;
    vuint32_t EIRE9:1;
    vuint32_t EIRE8:1;
    vuint32_t EIRE7:1;
    vuint32_t EIRE6:1;
    vuint32_t EIRE5:1;
    vuint32_t EIRE4:1;
    vuint32_t EIRE3:1;
    vuint32_t EIRE2:1;
    vuint32_t EIRE1:1;
    vuint32_t EIRE0:1;
  } B;
} SIUL2_DIRER0_tag;

typedef union SIUL2_DIRSR0_union_tag { /* SIUL2 DMA/Interrupt Request Select Register0 */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t DIRSR10:1;
    vuint32_t DIRSR9:1;
    vuint32_t DIRSR8:1;
    vuint32_t DIRSR7:1;
    vuint32_t DIRSR6:1;
    vuint32_t DIRSR5:1;
    vuint32_t DIRSR4:1;
    vuint32_t DIRSR3:1;
    vuint32_t DIRSR2:1;
    vuint32_t DIRSR1:1;
    vuint32_t DIRSR0:1;
  } B;
} SIUL2_DIRSR0_tag;

typedef union SIUL2_IREER0_union_tag { /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t IREE10:1;
    vuint32_t IREE9:1;
    vuint32_t IREE8:1;
    vuint32_t IREE7:1;
    vuint32_t IREE6:1;
    vuint32_t IREE5:1;
    vuint32_t IREE4:1;
    vuint32_t IREE3:1;
    vuint32_t IREE2:1;
    vuint32_t IREE1:1;
    vuint32_t IREE0:1;
  } B;
} SIUL2_IREER0_tag;

typedef union SIUL2_IFEER0_union_tag { /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t IFEE10:1;
    vuint32_t IFEE9:1;
    vuint32_t IFEE8:1;
    vuint32_t IFEE7:1;
    vuint32_t IFEE6:1;
    vuint32_t IFEE5:1;
    vuint32_t IFEE4:1;
    vuint32_t IFEE3:1;
    vuint32_t IFEE2:1;
    vuint32_t IFEE1:1;
    vuint32_t IFEE0:1;
  } B;
} SIUL2_IFEER0_tag;

typedef union SIUL2_IFER0_union_tag {  /* SIUL2 Interrupt Filter Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t IFE10:1;
    vuint32_t IFE9:1;
    vuint32_t IFE8:1;
    vuint32_t IFE7:1;
    vuint32_t IFE6:1;
    vuint32_t IFE5:1;
    vuint32_t IFE4:1;
    vuint32_t IFE3:1;
    vuint32_t IFE2:1;
    vuint32_t IFE1:1;
    vuint32_t IFE0:1;
  } B;
} SIUL2_IFER0_tag;

typedef union SIUL2_IFMCR_union_tag {  /* SIUL2 Interrupt Filter Maximum Counter Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t MAXCNT:4;                /* Maximum Interrupt Filter Counter setting */
  } B;
} SIUL2_IFMCR_tag;

typedef union SIUL2_IFCPR_union_tag {  /* SIUL2 Interrupt Filter Clock Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t IFCP:4;                  /* Interrupt Filter Clock Prescaler setting */
  } B;
} SIUL2_IFCPR_tag;

typedef union SIUL2_SCR0_union_tag {   /* SoC Configuration Register 0 */
  vuint16_t R;
  struct {
    vuint16_t FEC_MODE:1;
    vuint16_t  :15;
  } B;
} SIUL2_SCR0_tag;

typedef union SIUL2_MSCR0_255_union_tag { /* SIUL2 Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t OERC:2;                  /* Output Edge Rate Control */
    vuint32_t  :2;
    vuint32_t ODC:2;                   /* Output Drive Control */
    vuint32_t SMC:1;                   /* Safe Mode Control */
    vuint32_t APC:1;                   /* Analog Pad Control */
    vuint32_t ILS:2;                   /* Input Level Selection */
    vuint32_t IBE:1;                   /* Input Buffer Enable */
    vuint32_t HYS:1;                   /* Input Hysteresis */
    vuint32_t WPDE:1;                  /* Weak Pulldown Enable */
    vuint32_t WPUE:1;                  /* Weak Pullup Enable */
    vuint32_t  :8;
    vuint32_t SSS:8;                   /* Source Signal Select */
  } B;
} SIUL2_MSCR0_255_tag;

typedef union SIUL2_MSCR512_995_union_tag { /* SIUL2 Input Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;
    vuint32_t SSS:8;                   /* Source Signal Select */
  } B;
} SIUL2_MSCR512_995_tag;

typedef union SIUL2_GPR0_union_tag {   /* General Purpose Register 0 */
  vuint32_t R;
  struct {
    vuint32_t GPI243_STR1:1;
    vuint32_t GPI243_STR0:1;
    vuint32_t GPI243_SEL1:1;
    vuint32_t GPI243_SEL0:1;
    vuint32_t GPI242_STR1:1;
    vuint32_t GPI242_STR0:1;
    vuint32_t GPI242_SEL1:1;
    vuint32_t GPI242_SEL0:1;
    vuint32_t GPI241_STR1:1;
    vuint32_t GPI241_STR0:1;
    vuint32_t GPI241_SEL1:1;
    vuint32_t GPI241_SEL0:1;
    vuint32_t GPI240_STR1:1;
    vuint32_t GPI240_STR0:1;
    vuint32_t GPI240_SEL1:1;
    vuint32_t GPI240_SEL0:1;
    vuint32_t GPI227_STR1:1;
    vuint32_t GPI227_STR0:1;
    vuint32_t GPI227_SEL1:1;
    vuint32_t GPI227_SEL0:1;
    vuint32_t GPI226_STR1:1;
    vuint32_t GPI226_STR0:1;
    vuint32_t GPI226_SEL1:1;
    vuint32_t GPI226_SEL0:1;
    vuint32_t GPI225_STR1:1;
    vuint32_t GPI225_STR0:1;
    vuint32_t GPI225_SEL1:1;
    vuint32_t GPI225_SEL0:1;
    vuint32_t GPI224_STR1:1;
    vuint32_t GPI224_STR0:1;
    vuint32_t GPI224_SEL1:1;
    vuint32_t GPI224_SEL0:1;
  } B;
} SIUL2_GPR0_tag;

typedef union SIUL2_GPR1_union_tag {   /* General Purpose Register 1 */
  vuint32_t R;
  struct {
    vuint32_t GPI251_STR1:1;
    vuint32_t GPI251_STR0:1;
    vuint32_t GPI251_SEL1:1;
    vuint32_t GPI251_SEL0:1;
    vuint32_t GPI250_STR1:1;
    vuint32_t GPI250_STR0:1;
    vuint32_t GPI250_SEL1:1;
    vuint32_t GPI250_SEL0:1;
    vuint32_t GPI249_STR1:1;
    vuint32_t GPI249_STR0:1;
    vuint32_t GPI249_SEL1:1;
    vuint32_t GPI249_SEL0:1;
    vuint32_t GPI248_STR1:1;
    vuint32_t GPI248_STR0:1;
    vuint32_t GPI248_SEL1:1;
    vuint32_t GPI248_SEL0:1;
    vuint32_t GPI247_STR1:1;
    vuint32_t GPI247_STR0:1;
    vuint32_t GPI247_SEL1:1;
    vuint32_t GPI247_SEL0:1;
    vuint32_t GPI246_STR1:1;
    vuint32_t GPI246_STR0:1;
    vuint32_t GPI246_SEL1:1;
    vuint32_t GPI246_SEL0:1;
    vuint32_t GPI245_STR1:1;
    vuint32_t GPI245_STR0:1;
    vuint32_t GPI245_SEL1:1;
    vuint32_t GPI245_SEL0:1;
    vuint32_t GPI244_STR1:1;
    vuint32_t GPI244_STR0:1;
    vuint32_t GPI244_SEL1:1;
    vuint32_t GPI244_SEL0:1;
  } B;
} SIUL2_GPR1_tag;

typedef union SIUL2_GPR2_union_tag {   /* General Purpose Register 2 */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t GPI255_STR1:1;
    vuint32_t GPI255_STR0:1;
    vuint32_t GPI255_SEL1:1;
    vuint32_t GPI255_SEL0:1;
    vuint32_t GPI254_STR1:1;
    vuint32_t GPI254_STR0:1;
    vuint32_t GPI254_SEL1:1;
    vuint32_t GPI254_SEL0:1;
    vuint32_t GPI253_STR1:1;
    vuint32_t GPI253_STR0:1;
    vuint32_t GPI253_SEL1:1;
    vuint32_t GPI253_SEL0:1;
    vuint32_t GPI252_STR1:1;
    vuint32_t GPI252_STR0:1;
    vuint32_t GPI252_SEL1:1;
    vuint32_t GPI252_SEL0:1;
  } B;
} SIUL2_GPR2_tag;

typedef union SIUL2_GPDO_union_tag {   /* SIUL2 GPIO Pad Data Output Register */
  vuint8_t R;
  struct {
    vuint8_t  :7;
    vuint8_t PDO:1;                    /* Pad Data Out */
  } B;
} SIUL2_GPDO_tag;

typedef union SIUL2_GPDI_union_tag {   /* SIUL2 GPIO Pad Data Input Register */
  vuint8_t R;
  struct {
    vuint8_t  :7;
    vuint8_t PDI:1;                    /* Pad Data In */
  } B;
} SIUL2_GPDI_tag;

typedef union SIUL2_PGPDO_union_tag {  /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO_tag;

typedef union SIUL2_PGPDI_union_tag {  /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI_tag;

typedef union SIUL2_MPGPDO_union_tag { /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
  vuint32_t R;
  struct {
    vuint32_t MASK:16;                 /* Mask Field */
    vuint32_t MPPDO:16;                /* Masked Parallel Pad Data Out */
  } B;
} SIUL2_MPGPDO_tag;

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  SIUL2_MIDR1_tag MIDR1;               /* SIUL2 MCU ID Register #1 */
  SIUL2_MIDR2_tag MIDR2;               /* SIUL2 MCU ID Register #2 */
  uint8_t SIUL2_reserved1[4];
  SIUL2_DISR0_tag DISR0;               /* SIUL2 DMA/Interrupt Status Flag Register0 */
  uint8_t SIUL2_reserved2[4];
  SIUL2_DIRER0_tag DIRER0;             /* SIUL2 DMA/Interrupt Request Enable Register0 */
  uint8_t SIUL2_reserved3[4];
  SIUL2_DIRSR0_tag DIRSR0;             /* SIUL2 DMA/Interrupt Request Select Register0 */
  uint8_t SIUL2_reserved4[4];
  SIUL2_IREER0_tag IREER0;             /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved5[4];
  SIUL2_IFEER0_tag IFEER0;             /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved6[4];
  SIUL2_IFER0_tag IFER0;               /* SIUL2 Interrupt Filter Enable Register 0 */
  uint8_t SIUL2_reserved7[4];
  SIUL2_IFMCR_tag IFMCR[32];           /* SIUL2 Interrupt Filter Maximum Counter Register */
  SIUL2_IFCPR_tag IFCPR;               /* SIUL2 Interrupt Filter Clock Prescaler Register */
  uint8_t SIUL2_reserved8[60];
  SIUL2_SCR0_tag SCR0[1];              /* SoC Configuration Register 0 */
  uint8_t SIUL2_reserved9[318];
  SIUL2_MSCR0_255_tag MSCR0_255[256];  /* SIUL2 Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved10[1024];
  SIUL2_MSCR512_995_tag MSCR512_995[484]; /* SIUL2 Input Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved11[112];
  SIUL2_GPR0_tag GPR0;                 /* General Purpose Register 0 */
  SIUL2_GPR1_tag GPR1;                 /* General Purpose Register 1 */
  SIUL2_GPR2_tag GPR2;                 /* General Purpose Register 2 */
  uint8_t SIUL2_reserved12[180];
  SIUL2_GPDO_tag GPDO[256];            /* SIUL2 GPIO Pad Data Output Register */
  uint8_t SIUL2_reserved13[256];
  SIUL2_GPDI_tag GPDI[256];            /* SIUL2 GPIO Pad Data Input Register */
  uint8_t SIUL2_reserved14[256];
  SIUL2_PGPDO_tag PGPDO[16];           /* SIUL2 Parallel GPIO Pad Data Out Register */
  uint8_t SIUL2_reserved15[32];
  SIUL2_PGPDI_tag PGPDI[16];           /* SIUL2 Parallel GPIO Pad Data In Register */
  uint8_t SIUL2_reserved16[32];
  SIUL2_MPGPDO_tag MPGPDO[16];         /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

typedef union SMPU_CESR0_union_tag {   /* Control/Error Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MERR:16;                 /* Master n error, where the bus master number matches the bit number */
    vuint32_t  :1;
    vuint32_t  :11;
    vuint32_t HRL:3;                   /* Hardware revision level */
    vuint32_t GVLD:1;                  /* Global Valid (global enable/disable for the SMPU) */
  } B;
} SMPU_CESR0_tag;

typedef union SMPU_CESR1_union_tag {   /* Control/Error Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MEOVR:16;                /* Master n error overrun, where the bus master number matches the bit number */
    vuint32_t  :1;
    vuint32_t  :11;
    vuint32_t NRGD:4;                  /* Number of region descriptors */
  } B;
} SMPU_CESR1_tag;

typedef union SMPU_ERROR_EAR_union_tag { /* Error Address Register, Bus Master n */
  vuint32_t R;
  struct {
    vuint32_t EADDR:32;                /* Error address */
  } B;
} SMPU_ERROR_EAR_tag;

typedef union SMPU_ERROR_EDR_union_tag { /* Error Detail Register, Bus Master n */
  vuint32_t R;
  struct {
    vuint32_t EACD:24;                 /* Error access control detail */
    vuint32_t  :1;
    vuint32_t EATTR:2;                 /* Error attributes */
    vuint32_t ERW:1;                   /* Error read/write */
    vuint32_t EMN:4;                   /* Error master number */
  } B;
} SMPU_ERROR_EDR_tag;

typedef struct SMPU_ERROR_struct_tag {
  SMPU_ERROR_EAR_tag EAR;              /* Error Address Register, Bus Master n */
  SMPU_ERROR_EDR_tag EDR;              /* Error Detail Register, Bus Master n */
} SMPU_ERROR_tag;

typedef union SMPU_RGD_WORD0_union_tag { /* Region Descriptor n, Word 0 */
  vuint32_t R;
  struct {
    vuint32_t SRTADDR:32;              /* Start address */
  } B;
} SMPU_RGD_WORD0_tag;

typedef union SMPU_RGD_WORD1_union_tag { /* Region Descriptor n, Word 1 */
  vuint32_t R;
  struct {
    vuint32_t ENDADDR:32;              /* End address */
  } B;
} SMPU_RGD_WORD1_tag;

typedef union SMPU_RGD_WORD2_union_tag { /* Region Descriptor n, Word 2 */
  vuint32_t R;
  struct {
    vuint32_t M0P:2;                   /* Bus master 0 permissions */
    vuint32_t M1P:2;                   /* Bus master 1 permissions */
    vuint32_t M2P:2;                   /* Bus master 2 permissions */
    vuint32_t M3P:2;                   /* Bus master 3 permissions */
    vuint32_t M4P:2;                   /* Bus master 4 permissions */
    vuint32_t M5P:2;                   /* Bus master 5 permissions */
    vuint32_t M6P:2;                   /* Bus master 6 permissions */
    vuint32_t M7P:2;                   /* Bus master 7 permissions */
    vuint32_t M8P:2;                   /* Bus master 8 permissions */
    vuint32_t M9P:2;                   /* Bus master 9 permissions */
    vuint32_t M10P:2;                  /* Bus master 10 permissions */
    vuint32_t M11P:2;                  /* Bus master 11 permissions */
    vuint32_t M12P:2;                  /* Bus master 12 permissions */
    vuint32_t M13P:2;                  /* Bus master 13 permissions */
    vuint32_t M14P:2;                  /* Bus master 14 permissions */
    vuint32_t M15P:2;                  /* Bus master 15 permissions */
  } B;
} SMPU_RGD_WORD2_tag;

typedef union SMPU_RGD_WORD3_union_tag { /* Region Descriptor n, Word 3 */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t RO:1;                    /* Read-Only */
    vuint32_t  :1;
    vuint32_t CI:1;                    /* Cache Inhibit */
    vuint32_t VLD:1;                   /* Valid */
  } B;
} SMPU_RGD_WORD3_tag;

typedef struct SMPU_RGD_struct_tag {
  SMPU_RGD_WORD0_tag WORD0;            /* Region Descriptor n, Word 0 */
  SMPU_RGD_WORD1_tag WORD1;            /* Region Descriptor n, Word 1 */
  SMPU_RGD_WORD2_tag WORD2;            /* Region Descriptor n, Word 2 */
  SMPU_RGD_WORD3_tag WORD3;            /* Region Descriptor n, Word 3 */
} SMPU_RGD_tag;

struct SMPU_tag {
  SMPU_CESR0_tag CESR0;                /* Control/Error Status Register 0 */
  SMPU_CESR1_tag CESR1;                /* Control/Error Status Register 1 */
  uint8_t SMPU_reserved0[248];
  SMPU_ERROR_tag ERROR[16];
  uint8_t SMPU_reserved1[640];
  SMPU_RGD_tag RGD[12];
};


/* ============================================================================
   =============================== Module: SRX ================================
   ============================================================================ */

typedef union SRX_GBL_CTRL_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t TSPRSC:8;
    vuint32_t  :8;
    vuint32_t NIB_LEN_VAR_LIMIT:1;     /* Decides the allowable jitter/clock drift limit for nibble length measurement. */
    vuint32_t  :5;
    vuint32_t FMDUIE:1;
    vuint32_t SMDUIE:1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t FAST_CLR:1;
    vuint32_t  :1;
    vuint32_t DBG_FRZ:1;
    vuint32_t  :1;
    vuint32_t SENT_EN:1;
  } B;
} SRX_GBL_CTRL_tag;

typedef union SRX_CHNL_EN_union_tag {  /* Channel Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t EN_CH:6;
  } B;
} SRX_CHNL_EN_tag;

typedef union SRX_GBL_STATUS_union_tag { /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t FMDU:1;
    vuint32_t SMDU:1;
    vuint32_t  :8;
  } B;
} SRX_GBL_STATUS_tag;

typedef union SRX_FMSG_RDY_union_tag { /* Fast Message Ready Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t F_RDY:6;
  } B;
} SRX_FMSG_RDY_tag;

typedef union SRX_SMSG_RDY_union_tag { /* Slow Serial Message Ready Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t S_RDY:6;
  } B;
} SRX_SMSG_RDY_tag;

typedef union SRX_DATA_CTRL1_union_tag { /* Data Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t NIBBCH0:3;
    vuint32_t  :1;
    vuint32_t NIBBCH1:3;
    vuint32_t  :1;
    vuint32_t NIBBCH2:3;
    vuint32_t  :1;
    vuint32_t NIBBCH3:3;
    vuint32_t  :1;
    vuint32_t NIBBCH4:3;
    vuint32_t  :1;
    vuint32_t NIBBCH5:3;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t  :3;
  } B;
} SRX_DATA_CTRL1_tag;

typedef union SRX_FDMA_CTRL_union_tag { /* Fast Message DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t FDMA_EN:6;
  } B;
} SRX_FDMA_CTRL_tag;

typedef union SRX_SDMA_CTRL_union_tag { /* Slow Serial Message DMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t SDMA_EN:6;
  } B;
} SRX_SDMA_CTRL_tag;

typedef union SRX_FRDY_IE_union_tag {  /* Fast Message Ready Interrupt Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t FRDY_IE:6;
  } B;
} SRX_FRDY_IE_tag;

typedef union SRX_SRDY_IE_union_tag {  /* Slow Serial Message Ready Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t SRDY_IE:6;
  } B;
} SRX_SRDY_IE_tag;

typedef union SRX_DMA_FMSG_DATA_union_tag { /* DMA Fast Message Data Read Register */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t SCNIB:4;
    vuint32_t DNIB1:4;
    vuint32_t DNIB2:4;
    vuint32_t DNIB3:4;
    vuint32_t DNIB4:4;
    vuint32_t DNIB5:4;
    vuint32_t DNIB6:4;
  } B;
} SRX_DMA_FMSG_DATA_tag;

typedef union SRX_DMA_FMSG_CRC_union_tag { /* DMA Fast Message CRC Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t CRC4b:4;
    vuint32_t  :16;
  } B;
} SRX_DMA_FMSG_CRC_tag;

typedef union SRX_DMA_FMSG_TS_union_tag { /* DMA Fast Message Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_DMA_FMSG_TS_tag;

typedef union SRX_DMA_SMSG_BIT3_union_tag { /* DMA Slow Serial Message Bit3 Read Register */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t TYPE:1;
    vuint32_t  :16;
    vuint32_t CFG:1;
    vuint32_t ID7_4_ID3_0:4;
    vuint32_t  :1;
    vuint32_t ID3_0_DATA15_12:4;
    vuint32_t  :1;
  } B;
} SRX_DMA_SMSG_BIT3_tag;

typedef union SRX_DMA_SMSG_BIT2_union_tag { /* DMA Slow Serial Message Bit2 Read Register */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t SMCRC:6;
    vuint32_t  :4;
    vuint32_t DATA:12;
  } B;
} SRX_DMA_SMSG_BIT2_tag;

typedef union SRX_DMA_SMSG_TS_union_tag { /* DMA Slow Serial Message Time Stamp Read Register */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_DMA_SMSG_TS_tag;

typedef union SRX_CH_CLK_CTRL_union_tag { /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t CM_PRSC:15;
    vuint32_t COMP_EN:1;
    vuint32_t  :1;
    vuint32_t PRSC:14;
  } B;
} SRX_CH_CLK_CTRL_tag;

typedef union SRX_CH_STATUS_union_tag { /* Channel 'n' Status Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t BUS_IDLE:1;
    vuint32_t  :3;
    vuint32_t CAL_RESYNC:1;
    vuint32_t CAL_20_25:1;
    vuint32_t SMSG_OFLW:1;
    vuint32_t FMSG_OFLW:1;
    vuint32_t  :1;
    vuint32_t PP_DIAG_ERR:1;
    vuint32_t CAL_LEN_ERR:1;
    vuint32_t CAL_DIAG_ERR:1;
    vuint32_t NIB_VAL_ERR:1;
    vuint32_t SMSG_CRC_ERR:1;
    vuint32_t FMSG_CRC_ERR:1;
    vuint32_t NUM_EDGES_ERR:1;
    vuint32_t  :16;
  } B;
} SRX_CH_STATUS_tag;

typedef union SRX_CH_CONFIG_union_tag { /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t BUS_IDLE_CNT:4;
    vuint32_t IE_CAL_RESYNC:1;
    vuint32_t IE_CAL_20_25:1;
    vuint32_t IE_SMSG_OFLW:1;
    vuint32_t IE_FMSG_OFLW:1;
    vuint32_t FCRC_CHK_OFF:1;
    vuint32_t IE_PP_DIAG_ERR:1;
    vuint32_t IE_CAL_LEN_ERR:1;
    vuint32_t IE_CAL_DIAG_ERR:1;
    vuint32_t IE_NIB_VAL_ERR:1;
    vuint32_t IE_SMSG_CRC_ERR:1;
    vuint32_t IE_FMSG_CRC_ERR:1;
    vuint32_t IE_NUM_EDGES_ERR:1;
    vuint32_t DCHNG_INT:1;
    vuint32_t CAL_RNG:1;
    vuint32_t PP_CHKSEL:1;
    vuint32_t FCRC_TYPE:1;
    vuint32_t FCRC_SC_EN:1;
    vuint32_t SCRC_TYPE:1;
    vuint32_t PAUSE_EN:1;
    vuint32_t SUCC_CAL_CHK:1;
    vuint32_t FIL_CNT:8;
  } B;
} SRX_CH_CONFIG_tag;

typedef struct SRX_CH_struct_tag {
  SRX_CH_CLK_CTRL_tag CLK_CTRL;        /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
  SRX_CH_STATUS_tag STATUS;            /* Channel 'n' Status Register (n=0 to (CH-1)) */
  SRX_CH_CONFIG_tag CONFIG;            /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
  uint8_t CH_reserved0[4];
} SRX_CH_tag;

typedef union SRX_CHANNEL_FMSG_DATA_union_tag { /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t SCNIB:4;
    vuint32_t DNIB1:4;
    vuint32_t DNIB2:4;
    vuint32_t DNIB3:4;
    vuint32_t DNIB4:4;
    vuint32_t DNIB5:4;
    vuint32_t DNIB6:4;
  } B;
} SRX_CHANNEL_FMSG_DATA_tag;

typedef union SRX_CHANNEL_FMSG_CRC_union_tag { /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t  :12;
    vuint32_t CRC4b:4;
    vuint32_t  :16;
  } B;
} SRX_CHANNEL_FMSG_CRC_tag;

typedef union SRX_CHANNEL_FMSG_TS_union_tag { /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_CHANNEL_FMSG_TS_tag;

typedef union SRX_CHANNEL_SMSG_BIT3_union_tag { /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t CHNUM:4;
    vuint32_t TYPE:1;
    vuint32_t  :16;
    vuint32_t CFG:1;
    vuint32_t ID7_4_ID3_0:4;
    vuint32_t  :1;
    vuint32_t ID3_0_DATA15_12:4;
    vuint32_t  :1;
  } B;
} SRX_CHANNEL_SMSG_BIT3_tag;

typedef union SRX_CHANNEL_SMSG_BIT2_union_tag { /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t  :10;
    vuint32_t SMCRC:6;
    vuint32_t  :4;
    vuint32_t DATA:12;
  } B;
} SRX_CHANNEL_SMSG_BIT2_tag;

typedef union SRX_CHANNEL_SMSG_TS_union_tag { /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
  vuint32_t R;
  struct {
    vuint32_t TS:32;
  } B;
} SRX_CHANNEL_SMSG_TS_tag;

typedef struct SRX_CHANNEL_struct_tag {
  SRX_CHANNEL_FMSG_DATA_tag FMSG_DATA; /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
  SRX_CHANNEL_FMSG_CRC_tag FMSG_CRC;   /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
  SRX_CHANNEL_FMSG_TS_tag FMSG_TS;     /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
  SRX_CHANNEL_SMSG_BIT3_tag SMSG_BIT3; /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
  SRX_CHANNEL_SMSG_BIT2_tag SMSG_BIT2; /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
  SRX_CHANNEL_SMSG_TS_tag SMSG_TS;     /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
} SRX_CHANNEL_tag;

struct SRX_tag {
  SRX_GBL_CTRL_tag GBL_CTRL;           /* Global Control Register */
  SRX_CHNL_EN_tag CHNL_EN;             /* Channel Enable Register */
  SRX_GBL_STATUS_tag GBL_STATUS;       /* Global Status Register */
  SRX_FMSG_RDY_tag FMSG_RDY;           /* Fast Message Ready Status Register */
  SRX_SMSG_RDY_tag SMSG_RDY;           /* Slow Serial Message Ready Status Register */
  uint8_t SRX_reserved0[4];
  SRX_DATA_CTRL1_tag DATA_CTRL1;       /* Data Control Register 1 */
  uint8_t SRX_reserved1[12];
  SRX_FDMA_CTRL_tag FDMA_CTRL;         /* Fast Message DMA Control Register */
  SRX_SDMA_CTRL_tag SDMA_CTRL;         /* Slow Serial Message DMA Control Register */
  uint8_t SRX_reserved2[4];
  SRX_FRDY_IE_tag FRDY_IE;             /* Fast Message Ready Interrupt Control Register */
  SRX_SRDY_IE_tag SRDY_IE;             /* Slow Serial Message Ready Interrupt Enable Register */
  uint8_t SRX_reserved3[4];
  SRX_DMA_FMSG_DATA_tag DMA_FMSG_DATA; /* DMA Fast Message Data Read Register */
  SRX_DMA_FMSG_CRC_tag DMA_FMSG_CRC;   /* DMA Fast Message CRC Read Register */
  SRX_DMA_FMSG_TS_tag DMA_FMSG_TS;     /* DMA Fast Message Time Stamp Read Register */
  uint8_t SRX_reserved4[4];
  SRX_DMA_SMSG_BIT3_tag DMA_SMSG_BIT3; /* DMA Slow Serial Message Bit3 Read Register */
  SRX_DMA_SMSG_BIT2_tag DMA_SMSG_BIT2; /* DMA Slow Serial Message Bit2 Read Register */
  SRX_DMA_SMSG_TS_tag DMA_SMSG_TS;     /* DMA Slow Serial Message Time Stamp Read Register */
  uint8_t SRX_reserved5[4];
  SRX_CH_tag CH[6];
  uint8_t SRX_reserved6[160];
  SRX_CHANNEL_tag CHANNEL[6];
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

typedef union SSCM_STATUS_union_tag {  /* SSCM System Status */
  vuint16_t R;
  struct {
    vuint16_t  :1;
    vuint16_t CER:1;                   /* Configuration Error */
    vuint16_t CERS:1;                  /* Configuration Error for Safe DCF Clients */
    vuint16_t NXEN1:1;                 /* Processor 1 Nexus enable status */
    vuint16_t NXEN:1;                  /* Processor 0 Nexus enable status */
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t BMODE:3;                 /* Device Boot Mode */
    vuint16_t VLE:1;                   /* Variable Length Instruction Mode */
    vuint16_t  :1;
    vuint16_t  :1;
    vuint16_t  :2;
  } B;
} SSCM_STATUS_tag;

typedef union SSCM_MEMCONFIG_union_tag { /* SSCM System Memory and ID Register */
  vuint16_t R;
  struct {
    vuint16_t JPIN:10;
    vuint16_t  :1;
    vuint16_t MREV:4;                  /* Minor Mask Revision */
    vuint16_t  :1;
  } B;
} SSCM_MEMCONFIG_tag;

typedef union SSCM_PSA_union_tag {     /* Processor Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t SADR:32;                 /* Processor Start Address */
  } B;
} SSCM_PSA_tag;

typedef union SSCM_LCSTAT_union_tag {  /* Life Cycle Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :22;
    vuint32_t  :2;
    vuint32_t  :5;
    vuint32_t LC:3;                    /* Life Cycle */
  } B;
} SSCM_LCSTAT_tag;

struct SSCM_tag {
  SSCM_STATUS_tag STATUS;              /* SSCM System Status */
  SSCM_MEMCONFIG_tag MEMCONFIG;        /* SSCM System Memory and ID Register */
  uint8_t SSCM_reserved0[36];
  SSCM_PSA_tag PSA;                    /* Processor Start Address Register */
  uint8_t SSCM_reserved1[8];
  SSCM_LCSTAT_tag LCSTAT;              /* Life Cycle Status Register */
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

typedef union STCU2_RUN_union_tag {    /* STCU2 Run Register */
  vuint32_t R;
  struct {
    vuint32_t  :21;
    vuint32_t BYP:1;
    vuint32_t MBPLLEN:1;
    vuint32_t LBPLLEN:1;
    vuint32_t  :7;
    vuint32_t RUN:1;
  } B;
} STCU2_RUN_tag;

typedef union STCU2_RUNSW_union_tag {  /* STCU2 Run Software Register */
  vuint32_t R;
  struct {
    vuint32_t  :20;
    vuint32_t MBIE:1;
    vuint32_t LBIE:1;
    vuint32_t MBSWPLLEN:1;
    vuint32_t LBSWPLLEN:1;
    vuint32_t  :6;
    vuint32_t RUNSW_ABORT:1;
    vuint32_t RUNSW:1;
  } B;
} STCU2_RUNSW_tag;

typedef union STCU2_SKC_union_tag {    /* STCU2 SK Code Register */
  vuint32_t R;
  struct {
    vuint32_t SKC:32;
  } B;
} STCU2_SKC_tag;

typedef union STCU2_CFG_union_tag {    /* STCU2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PTR:7;
    vuint32_t  :8;
    vuint32_t  :7;
    vuint32_t WRP:1;
    vuint32_t  :2;
    vuint32_t  :1;
    vuint32_t PMOSEN:1;
    vuint32_t MBU:1;
    vuint32_t CLK_CFG:3;
  } B;
} STCU2_CFG_tag;

typedef union STCU2_PLL_CFG_union_tag { /* STCU2 PLL Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :2;
    vuint32_t PLLODF:6;
    vuint32_t  :5;
    vuint32_t PLLIDF:3;
    vuint32_t  :9;
    vuint32_t PLLLDF:7;
  } B;
} STCU2_PLL_CFG_tag;

typedef union STCU2_WDG_union_tag {    /* STCU2 Watchdog Register Granularity */
  vuint32_t R;
  struct {
    vuint32_t WDGEOC:32;
  } B;
} STCU2_WDG_tag;

typedef union STCU2_INT_FLG_union_tag { /* STCU2 Interrupt Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :30;
    vuint32_t MBIFLG:1;
    vuint32_t LBIFLG:1;
  } B;
} STCU2_INT_FLG_tag;

typedef union STCU2_ERR_STAT_union_tag { /* STCU2 Error Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t ABORTHW:1;
    vuint32_t ABORTSW:1;
    vuint32_t  :3;
    vuint32_t LOCKESW:1;
    vuint32_t WDTOSW:1;
    vuint32_t  :1;
    vuint32_t ENGESW:1;
    vuint32_t INVPSW:1;
    vuint32_t  :6;
    vuint32_t UFSF:1;
    vuint32_t RFSF:1;
    vuint32_t  :3;
    vuint32_t LOCKE:1;
    vuint32_t WDTO:1;
    vuint32_t  :1;
    vuint32_t ENGE:1;
    vuint32_t INVP:1;
  } B;
} STCU2_ERR_STAT_tag;

typedef union STCU2_ERR_FM_union_tag { /* STCU2 Error FM Register */
  vuint32_t R;
  struct {
    vuint32_t  :27;
    vuint32_t LOCKEUFM:1;
    vuint32_t WDTOUFM:1;
    vuint32_t  :1;
    vuint32_t ENGEUFM:1;
    vuint32_t INVPUFM:1;
  } B;
} STCU2_ERR_FM_tag;

typedef union STCU2_LBS_union_tag {    /* STCU2 Off-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t LBS3:1;
    vuint32_t LBS2:1;
    vuint32_t LBS1:1;
    vuint32_t LBS0:1;
  } B;
} STCU2_LBS_tag;

typedef union STCU2_LBE_union_tag {    /* STCU2 Off-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t LBE3:1;
    vuint32_t LBE2:1;
    vuint32_t LBE1:1;
    vuint32_t LBE0:1;
  } B;
} STCU2_LBE_tag;

typedef union STCU2_LBSSW_union_tag {  /* STCU2 On-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t LBSSW3:1;
    vuint32_t LBSSW2:1;
    vuint32_t LBSSW1:1;
    vuint32_t LBSSW0:1;
  } B;
} STCU2_LBSSW_tag;

typedef union STCU2_LBESW_union_tag {  /* STCU2 On-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t LBESW3:1;
    vuint32_t LBESW2:1;
    vuint32_t LBESW1:1;
    vuint32_t LBESW0:1;
  } B;
} STCU2_LBESW_tag;

typedef union STCU2_LBRMSW_union_tag { /* STCU2 On-Line LBIST Reset Management */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t LBRMSW3:1;
    vuint32_t LBRMSW2:1;
    vuint32_t LBRMSW1:1;
    vuint32_t LBRMSW0:1;
  } B;
} STCU2_LBRMSW_tag;

typedef union STCU2_LBUFM_union_tag {  /* STCU2 LBIST Unrecoverable FM Register */
  vuint32_t R;
  struct {
    vuint32_t  :28;
    vuint32_t LBUFM3:1;
    vuint32_t LBUFM2:1;
    vuint32_t LBUFM1:1;
    vuint32_t LBUFM0:1;
  } B;
} STCU2_LBUFM_tag;

typedef union STCU2_MBSL_union_tag {   /* STCU2 Off-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBS31:1;
    vuint32_t MBS30:1;
    vuint32_t MBS29:1;
    vuint32_t MBS28:1;
    vuint32_t MBS27:1;
    vuint32_t MBS26:1;
    vuint32_t MBS25:1;
    vuint32_t MBS24:1;
    vuint32_t MBS23:1;
    vuint32_t MBS22:1;
    vuint32_t MBS21:1;
    vuint32_t MBS20:1;
    vuint32_t MBS19:1;
    vuint32_t MBS18:1;
    vuint32_t MBS17:1;
    vuint32_t MBS16:1;
    vuint32_t MBS15:1;
    vuint32_t MBS14:1;
    vuint32_t MBS13:1;
    vuint32_t MBS12:1;
    vuint32_t MBS11:1;
    vuint32_t MBS10:1;
    vuint32_t MBS9:1;
    vuint32_t MBS8:1;
    vuint32_t MBS7:1;
    vuint32_t MBS6:1;
    vuint32_t MBS5:1;
    vuint32_t MBS4:1;
    vuint32_t MBS3:1;
    vuint32_t MBS2:1;
    vuint32_t MBS1:1;
    vuint32_t MBS0:1;
  } B;
} STCU2_MBSL_tag;

typedef union STCU2_MBSM_union_tag {   /* STCU2 Off-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t MBS46:1;
    vuint32_t MBS45:1;
    vuint32_t MBS44:1;
    vuint32_t MBS43:1;
    vuint32_t MBS42:1;
    vuint32_t MBS41:1;
    vuint32_t MBS40:1;
    vuint32_t MBS39:1;
    vuint32_t MBS38:1;
    vuint32_t MBS37:1;
    vuint32_t MBS36:1;
    vuint32_t MBS35:1;
    vuint32_t MBS34:1;
    vuint32_t MBS33:1;
    vuint32_t MBS32:1;
  } B;
} STCU2_MBSM_tag;

typedef union STCU2_MBSH_union_tag {   /* STCU2 Off-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} STCU2_MBSH_tag;

typedef union STCU2_MBEL_union_tag {   /* STCU2 Off-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBE31:1;
    vuint32_t MBE30:1;
    vuint32_t MBE29:1;
    vuint32_t MBE28:1;
    vuint32_t MBE27:1;
    vuint32_t MBE26:1;
    vuint32_t MBE25:1;
    vuint32_t MBE24:1;
    vuint32_t MBE23:1;
    vuint32_t MBE22:1;
    vuint32_t MBE21:1;
    vuint32_t MBE20:1;
    vuint32_t MBE19:1;
    vuint32_t MBE18:1;
    vuint32_t MBE17:1;
    vuint32_t MBE16:1;
    vuint32_t MBE15:1;
    vuint32_t MBE14:1;
    vuint32_t MBE13:1;
    vuint32_t MBE12:1;
    vuint32_t MBE11:1;
    vuint32_t MBE10:1;
    vuint32_t MBE9:1;
    vuint32_t MBE8:1;
    vuint32_t MBE7:1;
    vuint32_t MBE6:1;
    vuint32_t MBE5:1;
    vuint32_t MBE4:1;
    vuint32_t MBE3:1;
    vuint32_t MBE2:1;
    vuint32_t MBE1:1;
    vuint32_t MBE0:1;
  } B;
} STCU2_MBEL_tag;

typedef union STCU2_MBEM_union_tag {   /* STCU2 Off-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t MBE46:1;
    vuint32_t MBE45:1;
    vuint32_t MBE44:1;
    vuint32_t MBE43:1;
    vuint32_t MBE42:1;
    vuint32_t MBE41:1;
    vuint32_t MBE40:1;
    vuint32_t MBE39:1;
    vuint32_t MBE38:1;
    vuint32_t MBE37:1;
    vuint32_t MBE36:1;
    vuint32_t MBE35:1;
    vuint32_t MBE34:1;
    vuint32_t MBE33:1;
    vuint32_t MBE32:1;
  } B;
} STCU2_MBEM_tag;

typedef union STCU2_MBEH_union_tag {   /* STCU2 Off-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} STCU2_MBEH_tag;

typedef union STCU2_MBSLSW_union_tag { /* STCU2 On-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW31:1;
    vuint32_t MBSSW30:1;
    vuint32_t MBSSW29:1;
    vuint32_t MBSSW28:1;
    vuint32_t MBSSW27:1;
    vuint32_t MBSSW26:1;
    vuint32_t MBSSW25:1;
    vuint32_t MBSSW24:1;
    vuint32_t MBSSW23:1;
    vuint32_t MBSSW22:1;
    vuint32_t MBSSW21:1;
    vuint32_t MBSSW20:1;
    vuint32_t MBSSW19:1;
    vuint32_t MBSSW18:1;
    vuint32_t MBSSW17:1;
    vuint32_t MBSSW16:1;
    vuint32_t MBSSW15:1;
    vuint32_t MBSSW14:1;
    vuint32_t MBSSW13:1;
    vuint32_t MBSSW12:1;
    vuint32_t MBSSW11:1;
    vuint32_t MBSSW10:1;
    vuint32_t MBSSW9:1;
    vuint32_t MBSSW8:1;
    vuint32_t MBSSW7:1;
    vuint32_t MBSSW6:1;
    vuint32_t MBSSW5:1;
    vuint32_t MBSSW4:1;
    vuint32_t MBSSW3:1;
    vuint32_t MBSSW2:1;
    vuint32_t MBSSW1:1;
    vuint32_t MBSSW0:1;
  } B;
} STCU2_MBSLSW_tag;

typedef union STCU2_MBSMSW_union_tag { /* STCU2 On-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t MBSSW46:1;
    vuint32_t MBSSW45:1;
    vuint32_t MBSSW44:1;
    vuint32_t MBSSW43:1;
    vuint32_t MBSSW42:1;
    vuint32_t MBSSW41:1;
    vuint32_t MBSSW40:1;
    vuint32_t MBSSW39:1;
    vuint32_t MBSSW38:1;
    vuint32_t MBSSW37:1;
    vuint32_t MBSSW36:1;
    vuint32_t MBSSW35:1;
    vuint32_t MBSSW34:1;
    vuint32_t MBSSW33:1;
    vuint32_t MBSSW32:1;
  } B;
} STCU2_MBSMSW_tag;

typedef union STCU2_MBSHSW_union_tag { /* STCU2 On-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} STCU2_MBSHSW_tag;

typedef union STCU2_MBELSW_union_tag { /* STCU2 On-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW31:1;
    vuint32_t MBESW30:1;
    vuint32_t MBESW29:1;
    vuint32_t MBESW28:1;
    vuint32_t MBESW27:1;
    vuint32_t MBESW26:1;
    vuint32_t MBESW25:1;
    vuint32_t MBESW24:1;
    vuint32_t MBESW23:1;
    vuint32_t MBESW22:1;
    vuint32_t MBESW21:1;
    vuint32_t MBESW20:1;
    vuint32_t MBESW19:1;
    vuint32_t MBESW18:1;
    vuint32_t MBESW17:1;
    vuint32_t MBESW16:1;
    vuint32_t MBESW15:1;
    vuint32_t MBESW14:1;
    vuint32_t MBESW13:1;
    vuint32_t MBESW12:1;
    vuint32_t MBESW11:1;
    vuint32_t MBESW10:1;
    vuint32_t MBESW9:1;
    vuint32_t MBESW8:1;
    vuint32_t MBESW7:1;
    vuint32_t MBESW6:1;
    vuint32_t MBESW5:1;
    vuint32_t MBESW4:1;
    vuint32_t MBESW3:1;
    vuint32_t MBESW2:1;
    vuint32_t MBESW1:1;
    vuint32_t MBESW0:1;
  } B;
} STCU2_MBELSW_tag;

typedef union STCU2_MBEMSW_union_tag { /* STCU2 On-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t MBESW46:1;
    vuint32_t MBESW45:1;
    vuint32_t MBESW44:1;
    vuint32_t MBESW43:1;
    vuint32_t MBESW42:1;
    vuint32_t MBESW41:1;
    vuint32_t MBESW40:1;
    vuint32_t MBESW39:1;
    vuint32_t MBESW38:1;
    vuint32_t MBESW37:1;
    vuint32_t MBESW36:1;
    vuint32_t MBESW35:1;
    vuint32_t MBESW34:1;
    vuint32_t MBESW33:1;
    vuint32_t MBESW32:1;
  } B;
} STCU2_MBEMSW_tag;

typedef union STCU2_MBEHSW_union_tag { /* STCU2 On-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} STCU2_MBEHSW_tag;

typedef union STCU2_MBUFML_union_tag { /* STCU2 MBIST Unrecoverable FM Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM31:1;
    vuint32_t MBUFM30:1;
    vuint32_t MBUFM29:1;
    vuint32_t MBUFM28:1;
    vuint32_t MBUFM27:1;
    vuint32_t MBUFM26:1;
    vuint32_t MBUFM25:1;
    vuint32_t MBUFM24:1;
    vuint32_t MBUFM23:1;
    vuint32_t MBUFM22:1;
    vuint32_t MBUFM21:1;
    vuint32_t MBUFM20:1;
    vuint32_t MBUFM19:1;
    vuint32_t MBUFM18:1;
    vuint32_t MBUFM17:1;
    vuint32_t MBUFM16:1;
    vuint32_t MBUFM15:1;
    vuint32_t MBUFM14:1;
    vuint32_t MBUFM13:1;
    vuint32_t MBUFM12:1;
    vuint32_t MBUFM11:1;
    vuint32_t MBUFM10:1;
    vuint32_t MBUFM9:1;
    vuint32_t MBUFM8:1;
    vuint32_t MBUFM7:1;
    vuint32_t MBUFM6:1;
    vuint32_t MBUFM5:1;
    vuint32_t MBUFM4:1;
    vuint32_t MBUFM3:1;
    vuint32_t MBUFM2:1;
    vuint32_t MBUFM1:1;
    vuint32_t MBUFM0:1;
  } B;
} STCU2_MBUFML_tag;

typedef union STCU2_MBUFMM_union_tag { /* STCU2 MBIST Unrecoverable FM Medium Register */
  vuint32_t R;
  struct {
    vuint32_t  :17;
    vuint32_t MBUFM46:1;
    vuint32_t MBUFM45:1;
    vuint32_t MBUFM44:1;
    vuint32_t MBUFM43:1;
    vuint32_t MBUFM42:1;
    vuint32_t MBUFM41:1;
    vuint32_t MBUFM40:1;
    vuint32_t MBUFM39:1;
    vuint32_t MBUFM38:1;
    vuint32_t MBUFM37:1;
    vuint32_t MBUFM36:1;
    vuint32_t MBUFM35:1;
    vuint32_t MBUFM34:1;
    vuint32_t MBUFM33:1;
    vuint32_t MBUFM32:1;
  } B;
} STCU2_MBUFMM_tag;

typedef union STCU2_MBUFMH_union_tag { /* STCU2 MBIST Unrecoverable FM High Register */
  vuint32_t R;
  struct {
    vuint32_t  :32;
  } B;
} STCU2_MBUFMH_tag;

typedef union STCU2_LB_CTRL_union_tag { /* STCU2 LBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t PTR:7;
    vuint32_t  :4;
    vuint32_t PRPGEN:1;
    vuint32_t SHS:3;
    vuint32_t SCEN_OFF:4;
    vuint32_t SCEN_ON:4;
    vuint32_t  :1;
    vuint32_t PFT:1;
    vuint32_t  :1;
    vuint32_t CWS:5;
  } B;
} STCU2_LB_CTRL_tag;

typedef union STCU2_LB_PCS_union_tag { /* STCU2 LBIST PC Stop Register */
  vuint32_t R;
  struct {
    vuint32_t  :6;
    vuint32_t PCS:26;
  } B;
} STCU2_LB_PCS_tag;

typedef union STCU2_LB_PRPGL_union_tag { /* STCU2 LBIST PRPG Low Register */
  vuint32_t R;
  struct {
    vuint32_t PRPGx:32;
  } B;
} STCU2_LB_PRPGL_tag;

typedef union STCU2_LB_PRPGH_union_tag { /* STCU2 LBIST PRPG High Register */
  vuint32_t R;
  struct {
    vuint32_t PRPGx:32;
  } B;
} STCU2_LB_PRPGH_tag;

typedef union STCU2_LB_MISREL_union_tag { /* STCU2 Off-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_MISREL_tag;

typedef union STCU2_LB_MISREH_union_tag { /* STCU2 Off-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_MISREH_tag;

typedef union STCU2_LB_MISRRL_union_tag { /* STCU2 Off-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_MISRRL_tag;

typedef union STCU2_LB_MISRRH_union_tag { /* STCU2 Off-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_MISRRH_tag;

typedef union STCU2_LB_MISRELSW_union_tag { /* STCU2 On-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_MISRELSW_tag;

typedef union STCU2_LB_MISREHSW_union_tag { /* STCU2 On-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_MISREHSW_tag;

typedef union STCU2_LB_MISRRLSW_union_tag { /* STCU2 On-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_MISRRLSW_tag;

typedef union STCU2_LB_MISRRHSW_union_tag { /* STCU2 On-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_MISRRHSW_tag;

typedef struct STCU2_LB_struct_tag {
  STCU2_LB_CTRL_tag CTRL;              /* STCU2 LBIST Control Register */
  STCU2_LB_PCS_tag PCS;                /* STCU2 LBIST PC Stop Register */
  STCU2_LB_PRPGL_tag PRPGL;            /* STCU2 LBIST PRPG Low Register */
  STCU2_LB_PRPGH_tag PRPGH;            /* STCU2 LBIST PRPG High Register */
  STCU2_LB_MISREL_tag MISREL;          /* STCU2 Off-Line LBIST MISR Expected Low Register */
  STCU2_LB_MISREH_tag MISREH;          /* STCU2 Off-Line LBIST MISR Expected High Register */
  STCU2_LB_MISRRL_tag MISRRL;          /* STCU2 Off-Line LBIST MISR Read Low Register */
  STCU2_LB_MISRRH_tag MISRRH;          /* STCU2 Off-Line LBIST MISR Read High Register */
  STCU2_LB_MISRELSW_tag MISRELSW;      /* STCU2 On-Line LBIST MISR Expected Low Register */
  STCU2_LB_MISREHSW_tag MISREHSW;      /* STCU2 On-Line LBIST MISR Expected High Register */
  STCU2_LB_MISRRLSW_tag MISRRLSW;      /* STCU2 On-Line LBIST MISR Read Low Register */
  STCU2_LB_MISRRHSW_tag MISRRHSW;      /* STCU2 On-Line LBIST MISR Read High Register */
  uint8_t LB_reserved0[16];
} STCU2_LB_tag;

typedef union STCU2_MB_CTRL_union_tag { /* STCU2 MBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t  :24;
  } B;
} STCU2_MB_CTRL_tag;

struct STCU2_tag {
  STCU2_RUN_tag RUN;                   /* STCU2 Run Register */
  STCU2_RUNSW_tag RUNSW;               /* STCU2 Run Software Register */
  STCU2_SKC_tag SKC;                   /* STCU2 SK Code Register */
  STCU2_CFG_tag CFG;                   /* STCU2 Configuration Register */
  STCU2_PLL_CFG_tag PLL_CFG;           /* STCU2 PLL Configuration Register */
  STCU2_WDG_tag WDG;                   /* STCU2 Watchdog Register Granularity */
  STCU2_INT_FLG_tag INT_FLG;           /* STCU2 Interrupt Flag Register */
  uint8_t STCU2_reserved0[8];
  STCU2_ERR_STAT_tag ERR_STAT;         /* STCU2 Error Register */
  STCU2_ERR_FM_tag ERR_FM;             /* STCU2 Error FM Register */
  STCU2_LBS_tag LBS;                   /* STCU2 Off-Line LBIST Status Register */
  STCU2_LBE_tag LBE;                   /* STCU2 Off-Line LBIST End Flag Register */
  STCU2_LBSSW_tag LBSSW;               /* STCU2 On-Line LBIST Status Register */
  STCU2_LBESW_tag LBESW;               /* STCU2 On-Line LBIST End Flag Register */
  STCU2_LBRMSW_tag LBRMSW;             /* STCU2 On-Line LBIST Reset Management */
  STCU2_LBUFM_tag LBUFM;               /* STCU2 LBIST Unrecoverable FM Register */
  STCU2_MBSL_tag MBSL;                 /* STCU2 Off-Line MBIST Status Low Register */
  STCU2_MBSM_tag MBSM;                 /* STCU2 Off-Line MBIST Status Medium Register */
  STCU2_MBSH_tag MBSH;                 /* STCU2 Off-Line MBIST Status High Register */
  STCU2_MBEL_tag MBEL;                 /* STCU2 Off-Line MBIST End Flag Low Register */
  STCU2_MBEM_tag MBEM;                 /* STCU2 Off-Line MBIST End Flag Medium Register */
  STCU2_MBEH_tag MBEH;                 /* STCU2 Off-Line MBIST End Flag High Register */
  STCU2_MBSLSW_tag MBSLSW;             /* STCU2 On-Line MBIST Status Low Register */
  STCU2_MBSMSW_tag MBSMSW;             /* STCU2 On-Line MBIST Status Medium Register */
  STCU2_MBSHSW_tag MBSHSW;             /* STCU2 On-Line MBIST Status High Register */
  STCU2_MBELSW_tag MBELSW;             /* STCU2 On-Line MBIST End Flag Low Register */
  STCU2_MBEMSW_tag MBEMSW;             /* STCU2 On-Line MBIST End Flag Medium Register */
  STCU2_MBEHSW_tag MBEHSW;             /* STCU2 On-Line MBIST End Flag High Register */
  STCU2_MBUFML_tag MBUFML;             /* STCU2 MBIST Unrecoverable FM Low Register */
  STCU2_MBUFMM_tag MBUFMM;             /* STCU2 MBIST Unrecoverable FM Medium Register */
  STCU2_MBUFMH_tag MBUFMH;             /* STCU2 MBIST Unrecoverable FM High Register */
  uint8_t STCU2_reserved1[128];
  STCU2_LB_tag LB[4];
  uint8_t STCU2_reserved2[1024];
  STCU2_MB_CTRL_tag MB_CTRL[47];       /* STCU2 MBIST Control Register */
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

typedef union STM_CR_union_tag {       /* STM Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t CPS:8;                   /* Counter Prescaler. */
    vuint32_t  :6;
    vuint32_t FRZ:1;                   /* Freeze. */
    vuint32_t TEN:1;                   /* Timer counter Enabled. */
  } B;
} STM_CR_tag;

typedef union STM_CNT_union_tag {      /* STM Count Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Timer count value used as the time base for all channels. */
  } B;
} STM_CNT_tag;

typedef union STM_CHANNEL_CCR_union_tag { /* STM Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t CEN:1;                   /* Channel Enable */
  } B;
} STM_CHANNEL_CCR_tag;

typedef union STM_CHANNEL_CIR_union_tag { /* STM Channel Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t CIF:1;                   /* Channel Interrupt Flag */
  } B;
} STM_CHANNEL_CIR_tag;

typedef union STM_CHANNEL_CMP_union_tag { /* STM Channel Compare Register */
  vuint32_t R;
  struct {
    vuint32_t CMP:32;                  /* Compare value for channel n. */
  } B;
} STM_CHANNEL_CMP_tag;

typedef struct STM_CHANNEL_struct_tag {
  STM_CHANNEL_CCR_tag CCR;             /* STM Channel Control Register */
  STM_CHANNEL_CIR_tag CIR;             /* STM Channel Interrupt Register */
  STM_CHANNEL_CMP_tag CMP;             /* STM Channel Compare Register */
  uint8_t CHANNEL_reserved0[4];
} STM_CHANNEL_tag;

struct STM_tag {
  STM_CR_tag CR;                       /* STM Control Register */
  STM_CNT_tag CNT;                     /* STM Count Register */
  uint8_t STM_reserved0[8];
  STM_CHANNEL_tag CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

typedef union SWT_CR_union_tag {       /* SWT Control Register */
  vuint32_t R;
  struct {
    vuint32_t MAP0:1;
    vuint32_t MAP1:1;
    vuint32_t MAP2:1;
    vuint32_t MAP3:1;
    vuint32_t MAP4:1;
    vuint32_t MAP5:1;
    vuint32_t MAP6:1;
    vuint32_t MAP7:1;
    vuint32_t  :13;
    vuint32_t SMD:2;                   /* Service Mode. */
    vuint32_t RIA:1;
    vuint32_t WND:1;
    vuint32_t ITR:1;
    vuint32_t HLK:1;
    vuint32_t SLK:1;
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t STP:1;
    vuint32_t FRZ:1;
    vuint32_t WEN:1;
  } B;
} SWT_CR_tag;

typedef union SWT_IR_union_tag {       /* SWT Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t  :31;
    vuint32_t TIF:1;                   /* Time-out Interrupt Flag */
  } B;
} SWT_IR_tag;

typedef union SWT_TO_union_tag {       /* SWT Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t WTO:32;
  } B;
} SWT_TO_tag;

typedef union SWT_WN_union_tag {       /* SWT Window Register */
  vuint32_t R;
  struct {
    vuint32_t WST:32;                  /* Window Start Value */
  } B;
} SWT_WN_tag;

typedef union SWT_SR_union_tag {       /* SWT Service Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t WSC:16;                  /* Watchdog Service Code */
  } B;
} SWT_SR_tag;

typedef union SWT_CO_union_tag {       /* SWT Counter Output Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;
  } B;
} SWT_CO_tag;

typedef union SWT_SK_union_tag {       /* SWT Service Key Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;
    vuint32_t SK:16;                   /* Service Key */
  } B;
} SWT_SK_tag;

struct SWT_tag {
  SWT_CR_tag CR;                       /* SWT Control Register */
  SWT_IR_tag IR;                       /* SWT Interrupt Register */
  SWT_TO_tag TO;                       /* SWT Time-out Register */
  SWT_WN_tag WN;                       /* SWT Window Register */
  SWT_SR_tag SR;                       /* SWT Service Register */
  SWT_CO_tag CO;                       /* SWT Counter Output Register */
  SWT_SK_tag SK;                       /* SWT Service Key Register */
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

typedef union TDM_TDRSR_union_tag {    /* TDR Status Register */
  vuint32_t R;
  struct {
    vuint32_t  :26;
    vuint32_t TDRSR5:1;
    vuint32_t TDRSR4:1;
    vuint32_t TDRSR3:1;
    vuint32_t TDRSR2:1;
    vuint32_t TDRSR1:1;
    vuint32_t TDRSR0:1;
  } B;
} TDM_TDRSR_tag;

typedef union TDM_LFPAR_union_tag {    /* Last Flash Programmed Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;
    vuint32_t LFPAR:24;
  } B;
} TDM_LFPAR_tag;

typedef union TDM_DBA_union_tag {      /* Diary Base Address */
  vuint32_t R;
  struct {
    vuint32_t DBA:32;
  } B;
} TDM_DBA_tag;

typedef union TDM_STO_KEY_union_tag {  /* Software Tamper Override Key Region */
  vuint32_t R;
  struct {
    vuint32_t STO_KEY:32;
  } B;
} TDM_STO_KEY_tag;

struct TDM_tag {
  TDM_TDRSR_tag TDRSR;                 /* TDR Status Register */
  TDM_LFPAR_tag LFPAR;                 /* Last Flash Programmed Address Register */
  TDM_DBA_tag DBA;                     /* Diary Base Address */
  uint8_t TDM_reserved0[4];
  TDM_STO_KEY_tag STO_KEY[6];          /* Software Tamper Override Key Region */
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

typedef union WKPU_NSR_union_tag {     /* NMI Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t NIF0:1;                  /* NMI Status Flag 0 (safety core) */
    vuint32_t NOVF0:1;                 /* NMI Overrun Status Flag 0 (safety core) */
    vuint32_t  :6;
    vuint32_t NIF1:1;                  /* NMI Status Flag 1 (Core 1) */
    vuint32_t NOVF1:1;                 /* NMI Overrun Status Flag 1 (Core 1) */
    vuint32_t  :6;
    vuint32_t  :8;
    vuint32_t  :8;
  } B;
} WKPU_NSR_tag;

typedef union WKPU_NCR_union_tag {     /* NMI Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t NLOCK0:1;                /* NMI Configuration Lock Register 0 */
    vuint32_t NDSS0:2;                 /* NMI Destination Source Select 0 */
    vuint32_t NWRE0:1;                 /* NMI Wakeup Request Enable 0 */
    vuint32_t  :1;
    vuint32_t NREE0:1;                 /* NMI Rising-edge Events Enable 0 */
    vuint32_t NFEE0:1;                 /* NMI Falling-edge Events Enable 0 */
    vuint32_t NFE0:1;                  /* NMI Filter Enable */
    vuint32_t NLOCK1:1;                /* NMI Configuration Lock Register 1 */
    vuint32_t NDSS1:2;                 /* NMI Destination Source Select 1 */
    vuint32_t NWRE1:1;                 /* NMI Wakeup Request Enable 1 */
    vuint32_t  :1;
    vuint32_t NREE1:1;                 /* NMI Rising-edge Events Enable 1 */
    vuint32_t NFEE1:1;                 /* NMI Falling-edge Events Enable 1 */
    vuint32_t  :1;
    vuint32_t  :8;
    vuint32_t  :8;
  } B;
} WKPU_NCR_tag;

struct WKPU_tag {
  WKPU_NSR_tag NSR;                    /* NMI Status Flag Register */
  uint8_t WKPU_reserved0[4];
  WKPU_NCR_tag NCR;                    /* NMI Configuration Register */
};


/* ============================================================================
   =============================== Module: XBAR ===============================
   ============================================================================ */

typedef union XBAR_PORT_PRS_union_tag { /* Priority Registers Slave */
  vuint32_t R;
  struct {
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t M4:3;                    /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M3:3;                    /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M2:3;                    /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M1:3;                    /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t  :1;
    vuint32_t M0:3;                    /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
  } B;
} XBAR_PORT_PRS_tag;

typedef union XBAR_PORT_CRS_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t RO:1;                    /* Read Only */
    vuint32_t  :1;
    vuint32_t  :20;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t  :2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t  :1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} XBAR_PORT_CRS_tag;

typedef struct XBAR_PORT_struct_tag {
  XBAR_PORT_PRS_tag PRS;               /* Priority Registers Slave */
  uint32_t PORT_reserved0[15];
  XBAR_PORT_CRS_tag CRS;               /* Control Register */
  uint32_t PORT_reserved1[59];
} XBAR_PORT_tag;

typedef union XBAR_MGPCR_MGPCR_union_tag { /* Master General Purpose Control Register */
  vuint32_t R;
  struct {
    vuint32_t  :29;
    vuint32_t AULB:3;                  /* Arbitrates On Undefined Length Bursts */
  } B;
} XBAR_MGPCR_MGPCR_tag;

typedef struct XBAR_MGPCR_struct_tag {
  XBAR_MGPCR_MGPCR_tag MGPCR;          /* Master General Purpose Control Register */
  uint32_t MGPCR_reserved0[63];
} XBAR_MGPCR_tag;

struct XBAR_tag {
  XBAR_PORT_tag PORT[8];
  XBAR_MGPCR_tag MGPCR[8];
};


/* ============================================================================
   =============================== Module: XOSC ===============================
   ============================================================================ */

typedef union XOSC_CTL_union_tag {     /* XOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t OSCBYP:1;
    vuint32_t  :2;
    vuint32_t  :5;
    vuint32_t EOCV:8;                  /* End of Count Value */
    vuint32_t M_OSC:1;                 /* Crystal oscillator clock interrupt mask */
    vuint32_t  :2;
    vuint32_t  :5;
    vuint32_t I_OSC:1;
    vuint32_t  :3;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
    vuint32_t  :1;
  } B;
} XOSC_CTL_tag;

struct XOSC_tag {
  XOSC_CTL_tag CTL;                    /* XOSC Control Register */
};


/* ============================================================================
   =============================== Module: eMIOS ==============================
   ============================================================================ */

typedef union eMIOS_MCR_union_tag {    /* eMIOS Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t MDIS:1;                  /* Module Disable bit. */
    vuint32_t FRZ:1;                   /* Freeze bit. */
    vuint32_t GTBE:1;                  /* Global Time Base Enable bit. */
    vuint32_t ETB:1;                   /* External Time Base bit */
    vuint32_t GPREN:1;                 /* Global Prescaler Enable bit. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t SRV:4;                   /* Server Time Slot bits. */
    vuint32_t GPRE:8;                  /* Global Prescaler bits. */
    vuint32_t  :8;                     /* Reserved. */
  } B;
} eMIOS_MCR_tag;

typedef union eMIOS_GFLAG_union_tag {  /* eMIOS Global FLAG Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t F23_F0:24;               /* Channel [n] mirrored FLAG bit. */
  } B;
} eMIOS_GFLAG_tag;

typedef union eMIOS_OUDIS_union_tag {  /* eMIOS Output Update Disable register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t OU23_OU0:24;             /* Channel [n] Output Update Disable bit. */
  } B;
} eMIOS_OUDIS_tag;

typedef union eMIOS_UCDIS_union_tag {  /* eMIOS Disable Channel register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t CHDIS23_CHDIS0:24;       /* Enable Channel n bit. */
  } B;
} eMIOS_UCDIS_tag;

typedef union eMIOS_A8_union_tag {     /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A8_tag;

typedef union eMIOS_B8_union_tag {     /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B8_tag;

typedef union eMIOS_CNT8_union_tag {   /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT8_tag;

typedef union eMIOS_C8_union_tag {     /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C8_tag;

typedef union eMIOS_S8_union_tag {     /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S8_tag;

typedef union eMIOS_ALTA8_union_tag {  /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA8_tag;

typedef union eMIOS_A9_union_tag {     /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A9_tag;

typedef union eMIOS_B9_union_tag {     /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B9_tag;

typedef union eMIOS_CNT9_union_tag {   /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT9_tag;

typedef union eMIOS_C9_union_tag {     /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C9_tag;

typedef union eMIOS_S9_union_tag {     /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S9_tag;

typedef union eMIOS_ALTA9_union_tag {  /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA9_tag;

typedef union eMIOS_A10_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A10_tag;

typedef union eMIOS_B10_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B10_tag;

typedef union eMIOS_CNT10_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT10_tag;

typedef union eMIOS_C10_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C10_tag;

typedef union eMIOS_S10_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S10_tag;

typedef union eMIOS_ALTA10_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA10_tag;

typedef union eMIOS_A11_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A11_tag;

typedef union eMIOS_B11_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B11_tag;

typedef union eMIOS_CNT11_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT11_tag;

typedef union eMIOS_C11_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C11_tag;

typedef union eMIOS_S11_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S11_tag;

typedef union eMIOS_ALTA11_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA11_tag;

typedef union eMIOS_A12_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A12_tag;

typedef union eMIOS_B12_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B12_tag;

typedef union eMIOS_CNT12_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT12_tag;

typedef union eMIOS_C12_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C12_tag;

typedef union eMIOS_S12_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S12_tag;

typedef union eMIOS_ALTA12_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA12_tag;

typedef union eMIOS_A13_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A13_tag;

typedef union eMIOS_B13_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B13_tag;

typedef union eMIOS_CNT13_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT13_tag;

typedef union eMIOS_C13_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C13_tag;

typedef union eMIOS_S13_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S13_tag;

typedef union eMIOS_ALTA13_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA13_tag;

typedef union eMIOS_A14_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A14_tag;

typedef union eMIOS_B14_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B14_tag;

typedef union eMIOS_CNT14_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT14_tag;

typedef union eMIOS_C14_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C14_tag;

typedef union eMIOS_S14_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S14_tag;

typedef union eMIOS_ALTA14_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA14_tag;

typedef union eMIOS_A15_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A15_tag;

typedef union eMIOS_B15_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B15_tag;

typedef union eMIOS_CNT15_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT15_tag;

typedef union eMIOS_C15_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C15_tag;

typedef union eMIOS_S15_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S15_tag;

typedef union eMIOS_ALTA15_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA15_tag;

typedef union eMIOS_A16_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A16_tag;

typedef union eMIOS_B16_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B16_tag;

typedef union eMIOS_CNT16_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT16_tag;

typedef union eMIOS_C16_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C16_tag;

typedef union eMIOS_S16_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S16_tag;

typedef union eMIOS_ALTA16_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA16_tag;

typedef union eMIOS_A17_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A17_tag;

typedef union eMIOS_B17_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B17_tag;

typedef union eMIOS_CNT17_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT17_tag;

typedef union eMIOS_C17_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C17_tag;

typedef union eMIOS_S17_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S17_tag;

typedef union eMIOS_ALTA17_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA17_tag;

typedef union eMIOS_A18_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A18_tag;

typedef union eMIOS_B18_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B18_tag;

typedef union eMIOS_CNT18_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT18_tag;

typedef union eMIOS_C18_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C18_tag;

typedef union eMIOS_S18_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S18_tag;

typedef union eMIOS_ALTA18_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA18_tag;

typedef union eMIOS_A19_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A19_tag;

typedef union eMIOS_B19_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B19_tag;

typedef union eMIOS_CNT19_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT19_tag;

typedef union eMIOS_C19_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C19_tag;

typedef union eMIOS_S19_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S19_tag;

typedef union eMIOS_ALTA19_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA19_tag;

typedef union eMIOS_A20_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A20_tag;

typedef union eMIOS_B20_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B20_tag;

typedef union eMIOS_CNT20_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT20_tag;

typedef union eMIOS_C20_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C20_tag;

typedef union eMIOS_S20_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S20_tag;

typedef union eMIOS_ALTA20_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA20_tag;

typedef union eMIOS_A21_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A21_tag;

typedef union eMIOS_B21_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B21_tag;

typedef union eMIOS_CNT21_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT21_tag;

typedef union eMIOS_C21_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C21_tag;

typedef union eMIOS_S21_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S21_tag;

typedef union eMIOS_ALTA21_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA21_tag;

typedef union eMIOS_A22_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A22_tag;

typedef union eMIOS_B22_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B22_tag;

typedef union eMIOS_CNT22_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT22_tag;

typedef union eMIOS_C22_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C22_tag;

typedef union eMIOS_S22_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S22_tag;

typedef union eMIOS_ALTA22_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA22_tag;

typedef union eMIOS_A23_union_tag {    /* eMIOS UC A register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t A:24;
  } B;
} eMIOS_A23_tag;

typedef union eMIOS_B23_union_tag {    /* eMIOS UC B register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t B:24;                    /* See text above register figure. */
  } B;
} eMIOS_B23_tag;

typedef union eMIOS_CNT23_union_tag {  /* eMIOS CNT register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t C:24;                    /* The C field contains the value of the internal counter. */
  } B;
} eMIOS_CNT23_tag;

typedef union eMIOS_C23_union_tag {    /* eMIOS UC Control register n */
  vuint32_t R;
  struct {
    vuint32_t FREN:1;                  /* Freeze Enable bit. */
    vuint32_t ODIS:1;                  /* Output Disable bit. */
    vuint32_t ODISSL:2;                /* Output Disable select bits. */
    vuint32_t UCPRE:2;                 /* Prescaler bits. */
    vuint32_t UCPREN:1;                /* Prescaler Enable bit. */
    vuint32_t DMA:1;                   /* Direct Memory Access bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t IF:4;                    /* Input Filter bits. */
    vuint32_t FCK:1;                   /* Filter Clock select bit. */
    vuint32_t FEN:1;                   /* FLAG Enable bit. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FORCMA:1;                /* Force Match A bit. */
    vuint32_t FORCMB:1;                /* Force Match B bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t BSL:2;                   /* Bus Select bits. */
    vuint32_t EDSEL:1;                 /* Edge Selection bit. */
    vuint32_t EDPOL:1;                 /* Edge Polarity bit. */
    vuint32_t MODE:7;                  /* Mode selection bits. */
  } B;
} eMIOS_C23_tag;

typedef union eMIOS_S23_union_tag {    /* eMIOS UC Status register n */
  vuint32_t R;
  struct {
    vuint32_t OVR:1;                   /* Overrun bit. */
    vuint32_t  :15;                    /* Reserved. */
    vuint32_t OVFL:1;                  /* Overflow bit. */
    vuint32_t  :12;                    /* Reserved. */
    vuint32_t UCIN:1;                  /* Unified Channel Input pin bit. */
    vuint32_t UCOUT:1;                 /* Unified Channel Output pin bit. */
    vuint32_t FLAG:1;                  /* FLAG bit. */
  } B;
} eMIOS_S23_tag;

typedef union eMIOS_ALTA23_union_tag { /* eMIOS Alternate Address register n */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ALTA:24;                 /* See text above register figure. */
  } B;
} eMIOS_ALTA23_tag;

struct eMIOS_tag {
  eMIOS_MCR_tag MCR;                   /* eMIOS Module Configuration Register */
  uint32_t eMIOS_reserved0[3];
  eMIOS_GFLAG_tag GFLAG;               /* eMIOS Global FLAG Register */
  uint32_t eMIOS_reserved1[3];
  eMIOS_OUDIS_tag OUDIS;               /* eMIOS Output Update Disable register */
  uint32_t eMIOS_reserved2[3];
  eMIOS_UCDIS_tag UCDIS;               /* eMIOS Disable Channel register */
  uint32_t eMIOS_reserved3[275];
  eMIOS_A8_tag A8;                     /* eMIOS UC A register n */
  uint32_t eMIOS_reserved4[3];
  eMIOS_B8_tag B8;                     /* eMIOS UC B register n */
  uint32_t eMIOS_reserved5[3];
  eMIOS_CNT8_tag CNT8;                 /* eMIOS CNT register n */
  uint32_t eMIOS_reserved6[3];
  eMIOS_C8_tag C8;                     /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved7[3];
  eMIOS_S8_tag S8;                     /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved8[3];
  eMIOS_ALTA8_tag ALTA8;               /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved9[11];
  eMIOS_A9_tag A9;                     /* eMIOS UC A register n */
  uint32_t eMIOS_reserved10[3];
  eMIOS_B9_tag B9;                     /* eMIOS UC B register n */
  uint32_t eMIOS_reserved11[3];
  eMIOS_CNT9_tag CNT9;                 /* eMIOS CNT register n */
  uint32_t eMIOS_reserved12[3];
  eMIOS_C9_tag C9;                     /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved13[3];
  eMIOS_S9_tag S9;                     /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved14[3];
  eMIOS_ALTA9_tag ALTA9;               /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved15[11];
  eMIOS_A10_tag A10;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved16[3];
  eMIOS_B10_tag B10;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved17[3];
  eMIOS_CNT10_tag CNT10;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved18[3];
  eMIOS_C10_tag C10;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved19[3];
  eMIOS_S10_tag S10;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved20[3];
  eMIOS_ALTA10_tag ALTA10;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved21[11];
  eMIOS_A11_tag A11;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved22[3];
  eMIOS_B11_tag B11;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved23[3];
  eMIOS_CNT11_tag CNT11;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved24[3];
  eMIOS_C11_tag C11;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved25[3];
  eMIOS_S11_tag S11;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved26[3];
  eMIOS_ALTA11_tag ALTA11;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved27[11];
  eMIOS_A12_tag A12;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved28[3];
  eMIOS_B12_tag B12;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved29[3];
  eMIOS_CNT12_tag CNT12;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved30[3];
  eMIOS_C12_tag C12;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved31[3];
  eMIOS_S12_tag S12;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved32[3];
  eMIOS_ALTA12_tag ALTA12;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved33[11];
  eMIOS_A13_tag A13;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved34[3];
  eMIOS_B13_tag B13;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved35[3];
  eMIOS_CNT13_tag CNT13;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved36[3];
  eMIOS_C13_tag C13;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved37[3];
  eMIOS_S13_tag S13;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved38[3];
  eMIOS_ALTA13_tag ALTA13;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved39[11];
  eMIOS_A14_tag A14;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved40[3];
  eMIOS_B14_tag B14;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved41[3];
  eMIOS_CNT14_tag CNT14;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved42[3];
  eMIOS_C14_tag C14;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved43[3];
  eMIOS_S14_tag S14;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved44[3];
  eMIOS_ALTA14_tag ALTA14;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved45[11];
  eMIOS_A15_tag A15;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved46[3];
  eMIOS_B15_tag B15;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved47[3];
  eMIOS_CNT15_tag CNT15;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved48[3];
  eMIOS_C15_tag C15;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved49[3];
  eMIOS_S15_tag S15;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved50[3];
  eMIOS_ALTA15_tag ALTA15;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved51[11];
  eMIOS_A16_tag A16;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved52[3];
  eMIOS_B16_tag B16;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved53[3];
  eMIOS_CNT16_tag CNT16;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved54[3];
  eMIOS_C16_tag C16;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved55[3];
  eMIOS_S16_tag S16;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved56[3];
  eMIOS_ALTA16_tag ALTA16;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved57[11];
  eMIOS_A17_tag A17;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved58[3];
  eMIOS_B17_tag B17;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved59[3];
  eMIOS_CNT17_tag CNT17;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved60[3];
  eMIOS_C17_tag C17;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved61[3];
  eMIOS_S17_tag S17;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved62[3];
  eMIOS_ALTA17_tag ALTA17;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved63[11];
  eMIOS_A18_tag A18;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved64[3];
  eMIOS_B18_tag B18;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved65[3];
  eMIOS_CNT18_tag CNT18;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved66[3];
  eMIOS_C18_tag C18;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved67[3];
  eMIOS_S18_tag S18;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved68[3];
  eMIOS_ALTA18_tag ALTA18;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved69[11];
  eMIOS_A19_tag A19;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved70[3];
  eMIOS_B19_tag B19;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved71[3];
  eMIOS_CNT19_tag CNT19;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved72[3];
  eMIOS_C19_tag C19;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved73[3];
  eMIOS_S19_tag S19;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved74[3];
  eMIOS_ALTA19_tag ALTA19;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved75[11];
  eMIOS_A20_tag A20;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved76[3];
  eMIOS_B20_tag B20;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved77[3];
  eMIOS_CNT20_tag CNT20;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved78[3];
  eMIOS_C20_tag C20;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved79[3];
  eMIOS_S20_tag S20;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved80[3];
  eMIOS_ALTA20_tag ALTA20;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved81[11];
  eMIOS_A21_tag A21;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved82[3];
  eMIOS_B21_tag B21;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved83[3];
  eMIOS_CNT21_tag CNT21;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved84[3];
  eMIOS_C21_tag C21;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved85[3];
  eMIOS_S21_tag S21;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved86[3];
  eMIOS_ALTA21_tag ALTA21;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved87[11];
  eMIOS_A22_tag A22;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved88[3];
  eMIOS_B22_tag B22;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved89[3];
  eMIOS_CNT22_tag CNT22;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved90[3];
  eMIOS_C22_tag C22;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved91[3];
  eMIOS_S22_tag S22;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved92[3];
  eMIOS_ALTA22_tag ALTA22;             /* eMIOS Alternate Address register n */
  uint32_t eMIOS_reserved93[11];
  eMIOS_A23_tag A23;                   /* eMIOS UC A register n */
  uint32_t eMIOS_reserved94[3];
  eMIOS_B23_tag B23;                   /* eMIOS UC B register n */
  uint32_t eMIOS_reserved95[3];
  eMIOS_CNT23_tag CNT23;               /* eMIOS CNT register n */
  uint32_t eMIOS_reserved96[3];
  eMIOS_C23_tag C23;                   /* eMIOS UC Control register n */
  uint32_t eMIOS_reserved97[3];
  eMIOS_S23_tag S23;                   /* eMIOS UC Status register n */
  uint32_t eMIOS_reserved98[3];
  eMIOS_ALTA23_tag ALTA23;             /* eMIOS Alternate Address register n */
};


/* ============================================================================
   =============================== Module: eTPU_CCCR ==========================
   ============================================================================ */

typedef union eTPU_CCCR_ENG1_C_CR_union_tag { /* eTPU Channel n Configuration Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t CIE:1;                   /* Channel Interrupt Enable (see the eTPU Channel Interrupt Enable Register (ETPUCIER)). */
    vuint32_t DTRE:1;                  /* Channel Data Transfer Request Enable (see the "Channel Interrupt and Data Transfer Requests" section). */
    vuint32_t CPR:2;                   /* Channel Priority. */
    vuint32_t T4DIS:1;                 /* T4 channel action Disable. */
    vuint32_t SSMAE:1;                 /* Shared Subsystem Microengine Access Enable. */
    vuint32_t ETPD:1;                  /* Entry Table Pin Direction. */
    vuint32_t ETCS:1;                  /* Entry Table Condition Select. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t CFS:5;                   /* Channel Function Select. */
    vuint32_t ODIS:1;                  /* Output Disable. */
    vuint32_t OPOL:1;                  /* Output Polarity. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t CPBA:11;                 /* Channel n Parameter Base Address. */
  } B;
} eTPU_CCCR_ENG1_C_CR_tag;

typedef union eTPU_CCCR_ENG1_C_SCR_union_tag { /* eTPU Channel n Status Control Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t CIS:1;                   /* Channel Interrupt Status. */
    vuint32_t CIOS:1;                  /* Channel Interrupt Overflow Status. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t DTRS:1;                  /* Data Transfer Request Status. */
    vuint32_t DTROS:1;                 /* Data Transfer Request Overflow Status. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t IPS:1;                   /* Channel Input Pin State. */
    vuint32_t OPS:1;                   /* Channel Output Pin State. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t  :11;                    /* Reserved. */
    vuint32_t FM:2;                    /* Channel Function Mode. */
  } B;
} eTPU_CCCR_ENG1_C_SCR_tag;

typedef union eTPU_CCCR_ENG1_C_HSRR_union_tag { /* eTPU Channel n Host Service Request Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t  :29;                    /* Reserved. */
    vuint32_t HSR:3;                   /* Host Service Request */
  } B;
} eTPU_CCCR_ENG1_C_HSRR_tag;

typedef struct eTPU_CCCR_ENG1_C_struct_tag {
  eTPU_CCCR_ENG1_C_CR_tag CR;          /* eTPU Channel n Configuration Register for Engine 1 */
  uint32_t ENG1_C_reserved0[3];
  eTPU_CCCR_ENG1_C_SCR_tag SCR;        /* eTPU Channel n Status Control Register for Engine 1 */
  uint32_t ENG1_C_reserved1[3];
  eTPU_CCCR_ENG1_C_HSRR_tag HSRR;      /* eTPU Channel n Host Service Request Register for Engine 1 */
  uint32_t ENG1_C_reserved2[1];
} eTPU_CCCR_ENG1_C_tag;

typedef union eTPU_CCCR_ENG2_C_CR_union_tag { /* eTPU Channel n Configuration Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t CIE:1;                   /* Channel Interrupt Enable (see the Channel Interrupts ad Data Transfer Requests section). */
    vuint32_t DTRE:1;                  /* Channel Data Transfer Request Enable (see the "Channel Interrupt and Data Transfer Requests" section). */
    vuint32_t CPR:2;                   /* Channel Priority. */
    vuint32_t T4DIS:1;                 /* T4 channel action Disable. */
    vuint32_t SSMAE:1;                 /* Shared Subsystem Microengine Access Enable. */
    vuint32_t ETPD:1;                  /* Entry Table Pin Direction. */
    vuint32_t ETCS:1;                  /* Entry Table Condition Select. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t CFS:5;                   /* Channel Function Select. */
    vuint32_t ODIS:1;                  /* Output Disable. */
    vuint32_t OPOL:1;                  /* Output Polarity. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t CPBA:11;                 /* Channel n Parameter Base Address. */
  } B;
} eTPU_CCCR_ENG2_C_CR_tag;

typedef union eTPU_CCCR_ENG2_C_SCR_union_tag { /* eTPU Channel n Status Control Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t CIS:1;                   /* Channel Interrupt Status. */
    vuint32_t CIOS:1;                  /* Channel Interrupt Overflow Status. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t DTRS:1;                  /* Data Transfer Request Status. */
    vuint32_t DTROS:1;                 /* Data Transfer Request Overflow Status. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t IPS:1;                   /* Channel Input Pin State. */
    vuint32_t OPS:1;                   /* Channel Output Pin State. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t  :11;                    /* Reserved. */
    vuint32_t FM:2;                    /* Channel Function Mode. */
  } B;
} eTPU_CCCR_ENG2_C_SCR_tag;

typedef union eTPU_CCCR_ENG2_C_HSRR_union_tag { /* eTPU Channel n Host Service Request Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t  :29;                    /* Reserved. */
    vuint32_t HSR:3;                   /* Host Service Request */
  } B;
} eTPU_CCCR_ENG2_C_HSRR_tag;

typedef struct eTPU_CCCR_ENG2_C_struct_tag {
  eTPU_CCCR_ENG2_C_CR_tag CR;          /* eTPU Channel n Configuration Register for Engine 2 */
  uint32_t ENG2_C_reserved0[3];
  eTPU_CCCR_ENG2_C_SCR_tag SCR;        /* eTPU Channel n Status Control Register for Engine 2 */
  uint32_t ENG2_C_reserved1[3];
  eTPU_CCCR_ENG2_C_HSRR_tag HSRR;      /* eTPU Channel n Host Service Request Register for Engine 2 */
  uint32_t ENG2_C_reserved2[1];
} eTPU_CCCR_ENG2_C_tag;

struct eTPU_CCCR_tag {
  uint32_t eTPU_CCCR_reserved0[1024];
  eTPU_CCCR_ENG1_C_tag ENG1_C[32];
  uint32_t eTPU_CCCR_reserved1[512];
  eTPU_CCCR_ENG2_C_tag ENG2_C[32];
};


/* ============================================================================
   =============================== Module: eTPU_ER ============================
   ============================================================================ */

typedef union eTPU_ER_WDTR_ENG1_union_tag { /* eTPU Watchdog Timer Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t WDM:2;                   /* Watchdog Mode. */
    vuint32_t  :1;
    vuint32_t WMO:1;                   /* Watchdog Monitor Operation. */
    vuint32_t  :12;
    vuint32_t WDCNT:16;                /* Watchdog Count. */
  } B;
} eTPU_ER_WDTR_ENG1_tag;

typedef union eTPU_ER_IDLER_ENG1_union_tag { /* eTPU Idle Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t IDLE_CNT:31;             /* Idle Count. */
    vuint32_t ICLR:1;                  /* Idle Clear. */
  } B;
} eTPU_ER_IDLER_ENG1_tag;

typedef union eTPU_ER_WDTR_ENG2_union_tag { /* eTPU Watchdog Timer Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t WDM:2;                   /* Watchdog Mode. */
    vuint32_t  :1;
    vuint32_t WMO:1;                   /* Watchdog Monitor Operation. */
    vuint32_t  :12;
    vuint32_t WDCNT:16;                /* Watchdog Count. */
  } B;
} eTPU_ER_WDTR_ENG2_tag;

typedef union eTPU_ER_IDLER_ENG2_union_tag { /* eTPU Idle Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t IDLE_CNT:31;             /* Idle Count. */
    vuint32_t ICLR:1;                  /* Idle Clear. */
  } B;
} eTPU_ER_IDLER_ENG2_tag;

struct eTPU_ER_tag {
  uint32_t eTPU_ER_reserved0[96];
  eTPU_ER_WDTR_ENG1_tag WDTR_ENG1;     /* eTPU Watchdog Timer Register for Engine 1 */
  uint32_t eTPU_ER_reserved1[7];
  eTPU_ER_IDLER_ENG1_tag IDLER_ENG1;   /* eTPU Idle Register for Engine 1 */
  uint32_t eTPU_ER_reserved2[7];
  eTPU_ER_WDTR_ENG2_tag WDTR_ENG2;     /* eTPU Watchdog Timer Register for Engine 2 */
  uint32_t eTPU_ER_reserved3[7];
  eTPU_ER_IDLER_ENG2_tag IDLER_ENG2;   /* eTPU Idle Register for Engine 2 */
};


/* ============================================================================
   =============================== Module: eTPU_GCR ===========================
   ============================================================================ */

typedef union eTPU_GCR_CISR_ENG1_union_tag { /* eTPU Channel Interrupt Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t CISn:32;                 /* Channel n Interrupt Status. */
  } B;
} eTPU_GCR_CISR_ENG1_tag;

typedef union eTPU_GCR_CISR_ENG2_union_tag { /* eTPU Channel Interrupt Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t CISn:32;                 /* Channel n Interrupt Status. */
  } B;
} eTPU_GCR_CISR_ENG2_tag;

typedef union eTPU_GCR_CDTRSR_ENG1_union_tag { /* eTPU Channel Data Transfer Request Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t DTRSn:32;                /* Channel n Data Transfer Request Status. */
  } B;
} eTPU_GCR_CDTRSR_ENG1_tag;

typedef union eTPU_GCR_CDTRSR_ENG2_union_tag { /* eTPU Channel Data Transfer Request Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t DTRSn:32;                /* Channel n Data Transfer Request Status. */
  } B;
} eTPU_GCR_CDTRSR_ENG2_tag;

typedef union eTPU_GCR_CIOSR_ENG1_union_tag { /* eTPU Channel Interrupt Overflow Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t CIOSn:32;                /* Channel n Interrupt Overflow Status */
  } B;
} eTPU_GCR_CIOSR_ENG1_tag;

typedef union eTPU_GCR_CIOSR_ENG2_union_tag { /* eTPU Channel Interrupt Overflow Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t CIOSn:32;                /* Channel n Interrupt Overflow Status */
  } B;
} eTPU_GCR_CIOSR_ENG2_tag;

typedef union eTPU_GCR_CDTROSR_ENG1_union_tag { /* eTPU Channel Data Transfer Request Overflow Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t DTROSn:32;               /* Channel n Data Transfer Request Overflow Status. */
  } B;
} eTPU_GCR_CDTROSR_ENG1_tag;

typedef union eTPU_GCR_CDTROSR_ENG2_union_tag { /* eTPU Channel Data Transfer Request Overflow Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t DTROSn:32;               /* Channel n Data Transfer Request Overflow Status. */
  } B;
} eTPU_GCR_CDTROSR_ENG2_tag;

typedef union eTPU_GCR_CIER_ENG1_union_tag { /* eTPU Channel Interrupt Enable Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t CIEn:32;                 /* Channel n Interrupt Enable. */
  } B;
} eTPU_GCR_CIER_ENG1_tag;

typedef union eTPU_GCR_CIER_ENG2_union_tag { /* eTPU Channel Interrupt Enable Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t CIEn:32;                 /* Channel n Interrupt Enable. */
  } B;
} eTPU_GCR_CIER_ENG2_tag;

typedef union eTPU_GCR_CDTRER_ENG1_union_tag { /* eTPU Channel Data Transfer Request Enable Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t DTREn:32;                /* Channel n Data Transfer Request Enable. */
  } B;
} eTPU_GCR_CDTRER_ENG1_tag;

typedef union eTPU_GCR_CDTRER_ENG2_union_tag { /* eTPU Channel Data Transfer Request Enable Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t DTREn:32;                /* Channel n Data Transfer Request Enable. */
  } B;
} eTPU_GCR_CDTRER_ENG2_tag;

typedef union eTPU_GCR_WDSR_ENG1_union_tag { /* eTPU Watchdog Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t WDSn:32;                 /* Channel n Watchdog Status. For details about Watchdog mechanism, see the Watchdog section. */
  } B;
} eTPU_GCR_WDSR_ENG1_tag;

typedef union eTPU_GCR_WDSR_ENG2_union_tag { /* eTPU Watchdog Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t WDSn:32;                 /* Channel n Watchdog Status. For details about Watchdog mechanism, see the Watchdog section. */
  } B;
} eTPU_GCR_WDSR_ENG2_tag;

typedef union eTPU_GCR_CPSSR_ENG1_union_tag { /* eTPU Channel Pending Service Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t SRn:32;                  /* Pending Service Request n. */
  } B;
} eTPU_GCR_CPSSR_ENG1_tag;

typedef union eTPU_GCR_CPSSR_ENG2_union_tag { /* eTPU Channel Pending Service Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t SRn:32;                  /* Pending Service Request n. */
  } B;
} eTPU_GCR_CPSSR_ENG2_tag;

typedef union eTPU_GCR_CSSR_ENG1_union_tag { /* eTPU Channel Service Status Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t SSn:32;                  /* Service Status n. */
  } B;
} eTPU_GCR_CSSR_ENG1_tag;

typedef union eTPU_GCR_CSSR_ENG2_union_tag { /* eTPU Channel Service Status Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t SSn:32;                  /* Service Status n. */
  } B;
} eTPU_GCR_CSSR_ENG2_tag;

struct eTPU_GCR_tag {
  uint32_t eTPU_GCR_reserved0[512];
  eTPU_GCR_CISR_ENG1_tag CISR_ENG1;    /* eTPU Channel Interrupt Status Register for Engine 1 */
  uint32_t eTPU_GCR_reserved1[3];
  eTPU_GCR_CISR_ENG2_tag CISR_ENG2;    /* eTPU Channel Interrupt Status Register for Engine 2 */
  uint32_t eTPU_GCR_reserved2[11];
  eTPU_GCR_CDTRSR_ENG1_tag CDTRSR_ENG1; /* eTPU Channel Data Transfer Request Status Register for Engine 1 */
  uint32_t eTPU_GCR_reserved3[3];
  eTPU_GCR_CDTRSR_ENG2_tag CDTRSR_ENG2; /* eTPU Channel Data Transfer Request Status Register for Engine 2 */
  uint32_t eTPU_GCR_reserved4[11];
  eTPU_GCR_CIOSR_ENG1_tag CIOSR_ENG1;  /* eTPU Channel Interrupt Overflow Status Register for Engine 1 */
  uint32_t eTPU_GCR_reserved5[3];
  eTPU_GCR_CIOSR_ENG2_tag CIOSR_ENG2;  /* eTPU Channel Interrupt Overflow Status Register for Engine 2 */
  uint32_t eTPU_GCR_reserved6[11];
  eTPU_GCR_CDTROSR_ENG1_tag CDTROSR_ENG1; /* eTPU Channel Data Transfer Request Overflow Status Register for Engine 1 */
  uint32_t eTPU_GCR_reserved7[3];
  eTPU_GCR_CDTROSR_ENG2_tag CDTROSR_ENG2; /* eTPU Channel Data Transfer Request Overflow Status Register for Engine 2 */
  uint32_t eTPU_GCR_reserved8[11];
  eTPU_GCR_CIER_ENG1_tag CIER_ENG1;    /* eTPU Channel Interrupt Enable Register for Engine 1 */
  uint32_t eTPU_GCR_reserved9[3];
  eTPU_GCR_CIER_ENG2_tag CIER_ENG2;    /* eTPU Channel Interrupt Enable Register for Engine 2 */
  uint32_t eTPU_GCR_reserved10[11];
  eTPU_GCR_CDTRER_ENG1_tag CDTRER_ENG1; /* eTPU Channel Data Transfer Request Enable Register for Engine 1 */
  uint32_t eTPU_GCR_reserved11[3];
  eTPU_GCR_CDTRER_ENG2_tag CDTRER_ENG2; /* eTPU Channel Data Transfer Request Enable Register for Engine 2 */
  uint32_t eTPU_GCR_reserved12[11];
  eTPU_GCR_WDSR_ENG1_tag WDSR_ENG1;    /* eTPU Watchdog Status Register for Engine 1 */
  uint32_t eTPU_GCR_reserved13[3];
  eTPU_GCR_WDSR_ENG2_tag WDSR_ENG2;    /* eTPU Watchdog Status Register for Engine 2 */
  uint32_t eTPU_GCR_reserved14[27];
  eTPU_GCR_CPSSR_ENG1_tag CPSSR_ENG1;  /* eTPU Channel Pending Service Status Register for Engine 1 */
  uint32_t eTPU_GCR_reserved15[3];
  eTPU_GCR_CPSSR_ENG2_tag CPSSR_ENG2;  /* eTPU Channel Pending Service Status Register for Engine 2 */
  uint32_t eTPU_GCR_reserved16[11];
  eTPU_GCR_CSSR_ENG1_tag CSSR_ENG1;    /* eTPU Channel Service Status Register for Engine 1 */
  uint32_t eTPU_GCR_reserved17[3];
  eTPU_GCR_CSSR_ENG2_tag CSSR_ENG2;    /* eTPU Channel Service Status Register for Engine 2 */
};


/* ============================================================================
   =============================== Module: eTPU_LMR ===========================
   ============================================================================ */

typedef union eTPU_LMR_ENG1_LM_CR_union_tag { /* eTPU Latency Monitor Configuration Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t LMM:2;                   /* Latency Monitor Mode. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t SRSEL:3;                 /* Service Request Selection */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t MONCHAN:5;               /* Monitored Channel. */
    vuint32_t MAXLAT:16;               /* Maximum Latency. */
  } B;
} eTPU_LMR_ENG1_LM_CR_tag;

typedef union eTPU_LMR_ENG1_LM_MR_union_tag { /* eTPU Latency Monitor Measure Register for Engine 1 */
  vuint32_t R;
  struct {
    vuint32_t  :16;                    /* Reserved. */
    vuint32_t LATENCY:15;              /* Latency measurement. */
    vuint32_t LTC:1;                   /* Latency measurement clear */
  } B;
} eTPU_LMR_ENG1_LM_MR_tag;

typedef struct eTPU_LMR_ENG1_LM_struct_tag {
  eTPU_LMR_ENG1_LM_CR_tag CR;          /* eTPU Latency Monitor Configuration Register for Engine 1 */
  uint32_t ENG1_LM_reserved0[3];
  eTPU_LMR_ENG1_LM_MR_tag MR;          /* eTPU Latency Monitor Measure Register for Engine 1 */
} eTPU_LMR_ENG1_LM_tag;

typedef union eTPU_LMR_ENG2_LM_CR_union_tag { /* eTPU Latency Monitor Configuration Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t LMM:2;                   /* Latency Monitor Mode. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t SRSEL:3;                 /* Service Request Selection */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t MONCHAN:5;               /* Monitored Channel. */
    vuint32_t MAXLAT:16;               /* Maximum Latency. */
  } B;
} eTPU_LMR_ENG2_LM_CR_tag;

typedef union eTPU_LMR_ENG2_LM_MR_union_tag { /* eTPU Latency Monitor Measure Register for Engine 2 */
  vuint32_t R;
  struct {
    vuint32_t  :16;                    /* Reserved. */
    vuint32_t LATENCY:15;              /* Latency measurement. */
    vuint32_t LTC:1;                   /* Latency measurement clear. */
  } B;
} eTPU_LMR_ENG2_LM_MR_tag;

typedef struct eTPU_LMR_ENG2_LM_struct_tag {
  eTPU_LMR_ENG2_LM_CR_tag CR;          /* eTPU Latency Monitor Configuration Register for Engine 2 */
  uint32_t ENG2_LM_reserved0[3];
  eTPU_LMR_ENG2_LM_MR_tag MR;          /* eTPU Latency Monitor Measure Register for Engine 2 */
} eTPU_LMR_ENG2_LM_tag;

struct eTPU_LMR_tag {
  uint32_t eTPU_LMR_reserved0[128];
  eTPU_LMR_ENG1_LM_tag ENG1_LM[6];
  uint32_t eTPU_LMR_reserved1[16];
  eTPU_LMR_ENG2_LM_tag ENG2_LM[6];
};


/* ============================================================================
   =============================== Module: eTPU_MESR ==========================
   ============================================================================ */

typedef union eTPU_MESR_MECR_union_tag { /* eTPU Memory Error Control Register */
  vuint32_t R;
  struct {
    vuint32_t FME:1;                   /* Field Modification Enable. */
    vuint32_t  :14;                    /* Reserved. */
    vuint32_t MECIE:1;                 /* Memory Error Correction Interrupt Enable. */
    vuint32_t HDEIE:1;                 /* Host Data Error Injection Enable */
    vuint32_t MDEIE:1;                 /* Microengine(s) Data Error Injection Enable. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t DTEND:1;                 /* Thread End on Data Non-correctable Error. */
    vuint32_t DRDIS:1;                 /* Data Error Report Disable. */
    vuint32_t DEDD:1;                  /* Data Error Detection Disable. */
    vuint32_t CEIE:1;                  /* Code Error Injection Enable. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t CTEND:1;                 /* Thread End on Code Non-correctable Error. */
    vuint32_t CRDIS:1;                 /* Code Error Report Disable. */
    vuint32_t CEDD:1;                  /* Code Error Detection Disable. */
  } B;
} eTPU_MESR_MECR_tag;

typedef union eTPU_MESR_DEIAR_union_tag { /* eTPU Data Error Injection Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :18;                    /* Reserved. */
    vuint32_t INJ_ADDR:12;             /* Injection Address. */
    vuint32_t  :2;                     /* Reserved. */
  } B;
} eTPU_MESR_DEIAR_tag;

typedef union eTPU_MESR_DEIDPR_union_tag { /* eTPU Data Error Injection Data Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data Flip bits. */
  } B;
} eTPU_MESR_DEIDPR_tag;

typedef union eTPU_MESR_DEIPPR_union_tag { /* eTPU Data Error Injection Parity Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t PFLIP_19_15:5;           /* Parity Flip bits. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t PFLIP_14_10:5;           /* Parity Flip bits. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t PFLIP_9_5:5;             /* Parity Flip bits. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t PFLIP_4_0:5;             /* Parity Flip bits. */
  } B;
} eTPU_MESR_DEIPPR_tag;

typedef union eTPU_MESR_DERAR_union_tag { /* eTPU Data Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ACC:2;               /* Error Access Source Indication. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t ERR_CHANNEL:5;           /* Error Channel Access Indication. */
    vuint32_t  :10;                    /* Reserved. */
    vuint32_t ERR_ADDR:12;             /* Error Address. */
    vuint32_t  :2;                     /* Reserved. */
  } B;
} eTPU_MESR_DERAR_tag;

typedef union eTPU_MESR_DERDR_union_tag { /* eTPU Data Error Report Data Register */
  vuint32_t R;
  struct {
    vuint32_t DATA:32;                 /* DATA. */
  } B;
} eTPU_MESR_DERDR_tag;

typedef union eTPU_MESR_DERSR_union_tag { /* eTPU Data Error Report Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t BE3:1;                   /* Byte Enable 3. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SYND3:5;                 /* Error Syndrome 3. */
    vuint32_t BE2:1;                   /* Byte Enable 2. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SYND2:5;                 /* Error Syndrome 2. */
    vuint32_t BE1:1;                   /* Byte Enable 1. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SYND1:5;                 /* Error Syndrome 1. */
    vuint32_t BE0:1;                   /* Byte Enable 0. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SYND0:5;                 /* Error Syndrome 0. */
  } B;
} eTPU_MESR_DERSR_tag;

typedef union eTPU_MESR_MESR_union_tag { /* eTPU Memory Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t DCERR:1;                 /* Data Correctable Error flag. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t DCOVR:1;                 /* Data Correctable Overrun flag. */
    vuint32_t CCERR:1;                 /* Code Error flag. */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t CCOVR:1;                 /* Code Correctable Overrun flag */
    vuint32_t DNCERR:1;                /* Data Non-Correctable Error flag */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t DNCOVR:1;                /* Data Non-Correctable Overrun flag. */
    vuint32_t CNCERR:1;                /* Code Non-Correctable Error flag */
    vuint32_t  :6;                     /* Reserved. */
    vuint32_t CNCOVR:1;                /* Code Non-Correctable Overrun flag. */
  } B;
} eTPU_MESR_MESR_tag;

typedef union eTPU_MESR_CEIAR_union_tag { /* eTPU Code Error Injection Address Register */
  vuint32_t R;
  struct {
    vuint32_t  :16;                    /* Reserved. */
    vuint32_t INJ_ADDR:14;             /* Injection Address. */
    vuint32_t  :2;                     /* Reserved. */
  } B;
} eTPU_MESR_CEIAR_tag;

typedef union eTPU_MESR_CEIDPR_union_tag { /* eTPU Code Error Injection Data Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data Flip bits. */
  } B;
} eTPU_MESR_CEIDPR_tag;

typedef union eTPU_MESR_CEIPPR_union_tag { /* eTPU Code Error Injection Parity Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;                    /* Reserved. */
    vuint32_t PFLIP:7;                 /* Parity Flip bits. */
  } B;
} eTPU_MESR_CEIPPR_tag;

typedef union eTPU_MESR_CERAR_union_tag { /* eTPU Code Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ACC:2;               /* Error Access Source Indication. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t ERR_CHANNEL:5;           /* Error Channel Access Indication. */
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t ERR_ADDR:14;             /* Error Address. */
    vuint32_t  :2;                     /* Reserved. */
  } B;
} eTPU_MESR_CERAR_tag;

typedef union eTPU_MESR_CERDR_union_tag { /* eTPU Code Error Report Data Register */
  vuint32_t R;
  struct {
    vuint32_t CODE:32;                 /* CODE[31-0]. */
  } B;
} eTPU_MESR_CERDR_tag;

typedef union eTPU_MESR_CERSR_union_tag { /* eTPU Code Error Report Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t  :25;                    /* Reserved. */
    vuint32_t SYND:7;                  /* Error Syndrome. */
  } B;
} eTPU_MESR_CERSR_tag;

typedef union eTPU_MESR_CEFR_union_tag { /* eTPU Code Error Fix Register */
  vuint32_t R;
  struct {
    vuint32_t CFIXM:2;                 /* Code Fix Mode. */
    vuint32_t  :14;                    /* Reserved. */
    vuint32_t CFIX_ADDR:14;            /* Code Fix Address. */
    vuint32_t  :2;                     /* Reserved. */
  } B;
} eTPU_MESR_CEFR_tag;

struct eTPU_MESR_tag {
  uint8_t eTPU_MESR_reserved0[256];
  eTPU_MESR_MECR_tag MECR;             /* eTPU Memory Error Control Register */
  eTPU_MESR_DEIAR_tag DEIAR;           /* eTPU Data Error Injection Address Register */
  eTPU_MESR_DEIDPR_tag DEIDPR;         /* eTPU Data Error Injection Data Pattern Register */
  eTPU_MESR_DEIPPR_tag DEIPPR;         /* eTPU Data Error Injection Parity Pattern Register */
  eTPU_MESR_DERAR_tag DERAR;           /* eTPU Data Error Report Address Register */
  eTPU_MESR_DERDR_tag DERDR;           /* eTPU Data Error Report Data Register */
  eTPU_MESR_DERSR_tag DERSR;           /* eTPU Data Error Report Syndrome Register */
  uint8_t eTPU_MESR_reserved1[4];
  eTPU_MESR_MESR_tag MESR;             /* eTPU Memory Error Status Register */
  eTPU_MESR_CEIAR_tag CEIAR;           /* eTPU Code Error Injection Address Register */
  eTPU_MESR_CEIDPR_tag CEIDPR;         /* eTPU Code Error Injection Data Pattern Register */
  eTPU_MESR_CEIPPR_tag CEIPPR;         /* eTPU Code Error Injection Parity Pattern Register */
  eTPU_MESR_CERAR_tag CERAR;           /* eTPU Code Error Report Address Register */
  eTPU_MESR_CERDR_tag CERDR;           /* eTPU Code Error Report Data Register */
  eTPU_MESR_CERSR_tag CERSR;           /* eTPU Code Error Report Syndrome Register */
  eTPU_MESR_CEFR_tag CEFR;             /* eTPU Code Error Fix Register */
};


/* ============================================================================
   =============================== Module: eTPU_SCR ===========================
   ============================================================================ */

typedef union eTPU_SCR_MCR_union_tag { /* eTPU Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t GEC:1;                   /* Global Exception Clear. */
    vuint32_t SDMERR:1;                /* SDM Read Error */
    vuint32_t WDTO1:1;                 /* Watchdog 1 Timeout. */
    vuint32_t WDTO2:1;                 /* Watchdog 2 Timeout. */
    vuint32_t MGE1:1;                  /* Microcode Global Exception Engine 1. */
    vuint32_t MGE2:1;                  /* Microcode Global Exception Engine 2. */
    vuint32_t ILF1:1;                  /* Illegal Instruction Flag for Engine 1. */
    vuint32_t ILF2:1;                  /* Illegal Instruction Flag for Engine 2. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t SCMSIZE:5;               /* SCM Size = 64 Kbytes. */
    vuint32_t LTO1:1;                  /* Latency Timeout for Engine 1. */
    vuint32_t LTO2:1;                  /* Latency Timeout for Engine 2. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SCMMISC:1;               /* SCM MISC Complete flag. */
    vuint32_t SCMMISF:1;               /* SCM MISC Flag. */
    vuint32_t SCMMISEN:1;              /* SCM MISC Enable. */
    vuint32_t SCMERR:1;                /* SCM Read Error. */
    vuint32_t  :1;
    vuint32_t VIS:1;                   /* SCM Visibility Bit. */
    vuint32_t  :5;                     /* Reserved. */
    vuint32_t GTBE:1;                  /* Global Time Base Enable. */
  } B;
} eTPU_SCR_MCR_tag;

typedef union eTPU_SCR_CDCR_union_tag { /* eTPU Coherent Dual-Parameter Controller Register */
  vuint32_t R;
  struct {
    vuint32_t STS:1;                   /* Start Bit. */
    vuint32_t CTBASE:5;                /* Channel Transfer Base. */
    vuint32_t PBBASE:10;               /* Parameter Buffer Base Address. */
    vuint32_t PWIDTH:1;                /* Parameter Width Selection. */
    vuint32_t PARM0:7;                 /* Channel Parameter number 0. */
    vuint32_t WR:1;                    /* Read/Write selection. */
    vuint32_t PARM1:7;                 /* Channel Parameter number 1. */
  } B;
} eTPU_SCR_CDCR_tag;

typedef union eTPU_SCR_MISCCMPR_union_tag { /* eTPU MISC Compare Register */
  vuint32_t R;
  struct {
    vuint32_t ETPUMISCCMP:32;          /* Expected Multiple Input Signature Register value. */
  } B;
} eTPU_SCR_MISCCMPR_tag;

typedef union eTPU_SCR_SCMOFFDATAR_union_tag { /* eTPU SCM Off-range Data Register */
  vuint32_t R;
  struct {
    vuint32_t ETPUSCMOFFDATAR:32;      /* SCM Off-range read data value. */
  } B;
} eTPU_SCR_SCMOFFDATAR_tag;

typedef union eTPU_SCR_ECR_ENG1_union_tag { /* eTPU Engine 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FEND:1;                  /* Force End. */
    vuint32_t MDIS:1;                  /* Module Disable Bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t STF:1;                   /* Stop Flag Bit. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t HLTF:1;                  /* Halt Mode Flag. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FCSS:1;                  /* Filter Clock Source Selection */
    vuint32_t FPSCK:3;                 /* Filter Prescaler Clock Control. */
    vuint32_t CDFC:2;                  /* Channel Digital Filter Control. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t ERBA:5;                  /* Engine Relative Base Address. */
    vuint32_t SPPDIS:1;                /* Schedule Priority Passing Disable. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t ETB:5;                   /* Entry Table Base. */
  } B;
} eTPU_SCR_ECR_ENG1_tag;

typedef union eTPU_SCR_ECR_ENG2_union_tag { /* eTPU Engine 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FEND:1;                  /* Force End. */
    vuint32_t MDIS:1;                  /* Module Disable Bit. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t STF:1;                   /* Stop Flag Bit. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t HLTF:1;                  /* Halt Mode Flag. */
    vuint32_t  :3;                     /* Reserved. */
    vuint32_t FCSS:1;                  /* Filter Clock Source Selection */
    vuint32_t FPSCK:3;                 /* Filter Prescaler Clock Control. */
    vuint32_t CDFC:2;                  /* Channel Digital Filter Control. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t ERBA:5;                  /* Engine Relative Base Address. */
    vuint32_t SPPDIS:1;                /* Schedule Priority Passing Disable. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t ETB:5;                   /* Entry Table Base. */
  } B;
} eTPU_SCR_ECR_ENG2_tag;

struct eTPU_SCR_tag {
  eTPU_SCR_MCR_tag MCR;                /* eTPU Module Configuration Register */
  eTPU_SCR_CDCR_tag CDCR;              /* eTPU Coherent Dual-Parameter Controller Register */
  uint8_t eTPU_SCR_reserved0[4];
  eTPU_SCR_MISCCMPR_tag MISCCMPR;      /* eTPU MISC Compare Register */
  eTPU_SCR_SCMOFFDATAR_tag SCMOFFDATAR; /* eTPU SCM Off-range Data Register */
  eTPU_SCR_ECR_ENG1_tag ECR_ENG1;      /* eTPU Engine 1 Configuration Register */
  eTPU_SCR_ECR_ENG2_tag ECR_ENG2;      /* eTPU Engine 2 Configuration Register */
};


/* ============================================================================
   =============================== Module: eTPU_SSIR ==========================
   ============================================================================ */

typedef union eTPU_SSIR_ETPUSSSIR_union_tag { /* eTPU Shared Subsystem n Integration Register */
  vuint32_t R;
  struct {
    vuint32_t  :24;                    /* Reserved. */
    vuint32_t LENG:2;                  /* Link Engine. */
    vuint32_t  :1;                     /* Reserved. */
    vuint32_t LCHAN:5;                 /* Link Channel. */
  } B;
} eTPU_SSIR_ETPUSSSIR_tag;

struct eTPU_SSIR_tag {
  uint8_t eTPU_SSIR_reserved0[3072];
  eTPU_SSIR_ETPUSSSIR_tag ETPUSSSIR[10]; /* eTPU Shared Subsystem n Integration Register */
};


/* ============================================================================
   =============================== Module: eTPU_TBR ===========================
   ============================================================================ */

typedef union eTPU_TBR_TBCR_ENG1_union_tag { /* eTPU Engine 1 Time Base Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t TCR2CTL:3;               /* TCR2 Clock/Gate Control. */
    vuint32_t TCRCF:2;                 /* TCRCLK Signal Filter Control. */
    vuint32_t AM:2;                    /* Angle Mode Selection. */
    vuint32_t ATGC:1;                  /* Angle Tick Generator Clock. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t TCR2P:6;                 /* Timer Count Register 2 Prescaler Control. */
    vuint32_t TCR1CTL:2;               /* TCR1 Clock/Gate Control. */
    vuint32_t TCR1CS:1;                /* TCR1 Clock Source */
    vuint32_t  :5;                     /* Reserved. */
    vuint32_t TCR1P:8;                 /* Timer Count Register 1 Prescaler Control. */
  } B;
} eTPU_TBR_TBCR_ENG1_tag;

typedef union eTPU_TBR_TB1R_ENG1_union_tag { /* eTPU Engine 1 Time Base 1 (TCR1) Visibility Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t TCR1:24;                 /* TCR1 value. */
  } B;
} eTPU_TBR_TB1R_ENG1_tag;

typedef union eTPU_TBR_TB2R_ENG1_union_tag { /* eTPU Engine 1 Time Base 2 (TCR2) Visibility Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t TCR2:24;                 /* TCR2 value. */
  } B;
} eTPU_TBR_TB2R_ENG1_tag;

typedef union eTPU_TBR_STAC_ENG1_union_tag { /* eTPU Engine 1 STAC Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REN1:1;                  /* TCR1 Resource Client/Server Operation Enable Bit. */
    vuint32_t RSC1:1;                  /* TCR1 Resource Server/Client Assignment Bits. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SERVER_ID1:4;            /* STAC ID 1. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t SRV1:4;                  /* TCR1 Resource Server. */
    vuint32_t REN2:1;                  /* TCR2 Resource Client/Server Operation Enable Bit. */
    vuint32_t RSC2:1;                  /* TCR2 Resource Server/Client Assignment Bits. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SERVER_ID2:4;            /* STAC ID 2. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t SRV2:4;                  /* TCR2 Resource Server. */
  } B;
} eTPU_TBR_STAC_ENG1_tag;

typedef union eTPU_TBR_TBCR_ENG2_union_tag { /* eTPU Engine 2 Time Base Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t TCR2CTL:3;               /* TCR2 Clock/Gate Control. */
    vuint32_t TCRCF:2;                 /* TCRCLK Signal Filter Control. */
    vuint32_t AM:2;                    /* Angle Mode Selection. */
    vuint32_t ATGC:1;                  /* Angle Tick Generator Clock. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t TCR2P:6;                 /* Timer Count Register 2 Prescaler Control. */
    vuint32_t TCR1CTL:2;               /* TCR1 Clock/Gate Control. */
    vuint32_t TCR1CS:1;                /* TCR1 Clock Source */
    vuint32_t  :5;                     /* Reserved. */
    vuint32_t TCR1P:8;                 /* Timer Count Register 1 Prescaler Control. */
  } B;
} eTPU_TBR_TBCR_ENG2_tag;

typedef union eTPU_TBR_TB1R_ENG2_union_tag { /* eTPU Engine 2 Time Base 1 (TCR1) Visibility Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t TCR1:24;                 /* TCR1 value. */
  } B;
} eTPU_TBR_TB1R_ENG2_tag;

typedef union eTPU_TBR_TB2R_ENG2_union_tag { /* eTPU Engine 2 Time Base 2 (TCR2) Visibility Register */
  vuint32_t R;
  struct {
    vuint32_t  :8;                     /* Reserved. */
    vuint32_t TCR2:24;                 /* TCR2 value. */
  } B;
} eTPU_TBR_TB2R_ENG2_tag;

typedef union eTPU_TBR_STAC_ENG2_union_tag { /* eTPU Engine 2 STAC Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t REN1:1;                  /* TCR1 Resource Client/Server Operation Enable Bit. */
    vuint32_t RSC1:1;                  /* TCR1 Resource Server/Client Assignment Bits. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SERVER_ID1:4;            /* STAC ID 1. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t SRV1:4;                  /* TCR1 Resource Server. */
    vuint32_t REN2:1;                  /* TCR2 Resource Client/Server Operation Enable Bit. */
    vuint32_t RSC2:1;                  /* TCR2 Resource Server/Client Assignment Bits. */
    vuint32_t  :2;                     /* Reserved. */
    vuint32_t SERVER_ID2:4;            /* STAC ID 2. */
    vuint32_t  :4;                     /* Reserved. */
    vuint32_t SRV2:4;                  /* TCR2 Resource Server. */
  } B;
} eTPU_TBR_STAC_ENG2_tag;

struct eTPU_TBR_tag {
  uint8_t eTPU_TBR_reserved0[32];
  eTPU_TBR_TBCR_ENG1_tag TBCR_ENG1;    /* eTPU Engine 1 Time Base Configuration Register */
  eTPU_TBR_TB1R_ENG1_tag TB1R_ENG1;    /* eTPU Engine 1 Time Base 1 (TCR1) Visibility Register */
  eTPU_TBR_TB2R_ENG1_tag TB2R_ENG1;    /* eTPU Engine 1 Time Base 2 (TCR2) Visibility Register */
  eTPU_TBR_STAC_ENG1_tag STAC_ENG1;    /* eTPU Engine 1 STAC Configuration Register */
  uint8_t eTPU_TBR_reserved1[16];
  eTPU_TBR_TBCR_ENG2_tag TBCR_ENG2;    /* eTPU Engine 2 Time Base Configuration Register */
  eTPU_TBR_TB1R_ENG2_tag TB1R_ENG2;    /* eTPU Engine 2 Time Base 1 (TCR1) Visibility Register */
  eTPU_TBR_TB2R_ENG2_tag TB2R_ENG2;    /* eTPU Engine 2 Time Base 2 (TCR2) Visibility Register */
  eTPU_TBR_STAC_ENG2_tag STAC_ENG2;    /* eTPU Engine 2 STAC Configuration Register */
};
#define SRAM0_START 0x40000000UL;
#define ADC_0 (*(volatile struct ADC_tag *) 0xFFEE0000UL)
#define ADC_1 (*(volatile struct ADC_tag *) 0xFBEE4000UL)
#define ADC_2 (*(volatile struct ADC_tag *) 0xFFEE8000UL)
#define ADC_3 (*(volatile struct ADC_tag *) 0xFBEEC000UL)
#define AIPS_A (*(volatile struct AIPS_tag *) 0xFC000000UL)
#define AIPS_B (*(volatile struct AIPS_tag *) 0xF8000000UL)
#define BCTU (*(volatile struct BCTU_tag *) 0xFFC10000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CAN_0 (*(volatile struct CAN_tag *) 0xFFEB4000UL)
#define CAN_1 (*(volatile struct CAN_tag *) 0xFBEB4000UL)
#define CAN_2 (*(volatile struct CAN_tag *) 0xFFEB8000UL)
#define CAN_3 (*(volatile struct CAN_tag *) 0xFBEBC000UL)
#define CMU_ADCSD (*(volatile struct CMU_tag *) 0xFBFB0300UL)
#define CMU_AIPS (*(volatile struct CMU_tag *) 0xFBFB0280UL)
#define CMU_CLKOUT (*(volatile struct CMU_tag *) 0xFBFB04C0UL)
#define CMU_FXBAR (*(volatile struct CMU_tag *) 0xFBFB0200UL)
#define CMU_PER (*(volatile struct CMU_tag *) 0xFBFB02C0UL)
#define CMU_PLL (*(volatile struct CMU_tag *) 0xFBFB0500UL)
#define CMU_SARADC (*(volatile struct CMU_tag *) 0xFBFB0340UL)
#define CMU_SENT (*(volatile struct CMU_tag *) 0xFBFB0380UL)
#define CMU_SXBAR (*(volatile struct CMU_tag *) 0xFBFB0240UL)
#define CMU_eMIOS (*(volatile struct CMU_tag *) 0xFBFB0400UL)
#define CMU_eTPU2 (*(volatile struct CMU_tag *) 0xFBFB0440UL)
#define CRC_0 (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define CRC_1 (*(volatile struct CRC_tag *) 0xFBF64000UL)
#define DECFILTER_0 (*(volatile struct DECFILTER_tag *) 0xFFF88000UL)
#define DECFILTER_1 (*(volatile struct DECFILTER_tag *) 0xFFF8C000UL)
#define DMA_0 (*(volatile struct DMA_tag *) 0xFC0A0000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFFF6C200UL)
#define DMAMUX_2 (*(volatile struct DMAMUX_tag *) 0xFFF6C400UL)
#define DMAMUX_3 (*(volatile struct DMAMUX_tag *) 0xFBFC0000UL)
#define DSPI_0 (*(volatile struct DSPI_tag *) 0xFFE70000UL)
#define DSPI_1 (*(volatile struct DSPI_tag *) 0xFBE70000UL)
#define DSPI_2 (*(volatile struct DSPI_tag *) 0xFFE74000UL)
#define DSPI_3 (*(volatile struct DSPI_tag *) 0xFBE74000UL)
#define DSPI_4 (*(volatile struct DSPI_tag *) 0xFFE78000UL)
#define DSPI_M0 (*(volatile struct DSPI_tag *) 0xFFE7C000UL)
#define DSPI_M1 (*(volatile struct DSPI_tag *) 0xFBE78000UL)
#define DTS (*(volatile struct DTS_tag *) 0xFFF38000UL)
#define EIM (*(volatile struct EIM_tag *) 0xFC07C000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FEC (*(volatile struct FEC_tag *) 0xFC0B0000UL)
#define IGF (*(volatile struct IGF_tag *) 0xFFCE8000UL)
#define INTC_0 (*(volatile struct INTC_tag *) 0xFC040000UL)
#define IRCOSC (*(volatile struct IRCOSC_tag *) 0xFFFB0000UL)
#define JDC (*(volatile struct JDC_tag *) 0xFFF3C000UL)
#define JTAGM (*(volatile struct JTAGM_tag *) 0xFFF48000UL)
#define LFAST (*(volatile struct LFAST_tag *) 0xFFFD8000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFFE8C000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFBE8C000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define LINFlexD_3 (*(volatile struct LINFlexD_tag *) 0xFBE90000UL)
#define LINFlexD_M0 (*(volatile struct LINFlexD_tag *) 0xFFEA8000UL)
#define LINFlexD_M1 (*(volatile struct LINFlexD_tag *) 0xFBEA8000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0700UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0xFFFA8000UL)
#define MEMU (*(volatile struct MEMU_tag *) 0xFFF50000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT_0 (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PIT_1 (*(volatile struct PIT_tag *) 0xFFF80000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0100UL)
#define PMC (*(volatile struct PMC_tag *) 0xFFFA0400UL)
#define PRAMC (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define REACM2 (*(volatile struct REACM2_tag *) 0xFFCC4000UL)
#define SDADC_0 (*(volatile struct SDADC_tag *) 0xFFF0C000UL)
#define SDADC_1 (*(volatile struct SDADC_tag *) 0xFBF0C000UL)
#define SDADC_2 (*(volatile struct SDADC_tag *) 0xFFF10000UL)
#define SDADC_3 (*(volatile struct SDADC_tag *) 0xFBF10000UL)
#define SDADC_4 (*(volatile struct SDADC_tag *) 0xFFF14000UL)
#define SDADC_5 (*(volatile struct SDADC_tag *) 0xFBF14000UL)
#define SDADC_6 (*(volatile struct SDADC_tag *) 0xFFF18000UL)
#define SDADC_7 (*(volatile struct SDADC_tag *) 0xFBF18000UL)
#define SDADC_8 (*(volatile struct SDADC_tag *) 0xFFF1C000UL)
#define SDADC_9 (*(volatile struct SDADC_tag *) 0xFBF1C000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIPI (*(volatile struct SIPI_tag *) 0xFFFD0000UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SRX_0 (*(volatile struct SRX_tag *) 0xFFE5C000UL)
#define SRX_1 (*(volatile struct SRX_tag *) 0xFBE5C000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SWT_3 (*(volatile struct SWT_tag *) 0xFC05C000UL)
#define TDM (*(volatile struct TDM_tag *) 0xFFF34000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define XBAR_0 (*(volatile struct XBAR_tag *) 0xFC004000UL)
#define XBAR_1 (*(volatile struct XBAR_tag *) 0xFC008000UL)
#define XOSC (*(volatile struct XOSC_tag *) 0xFFFB0080UL)
#define eMIOS_0 (*(volatile struct eMIOS_tag *) 0xFFE64000UL)
#define eMIOS_0_UC08 (*(volatile struct eMIOS_tag *) 0xFFE64340UL)
#define eMIOS_0_UC09 (*(volatile struct eMIOS_tag *) 0xFFE64360UL)
#define eMIOS_0_UC10 (*(volatile struct eMIOS_tag *) 0xFFE64380UL)
#define eMIOS_0_UC11 (*(volatile struct eMIOS_tag *) 0xFFE643A0UL)
#define eMIOS_0_UC12 (*(volatile struct eMIOS_tag *) 0xFFE643C0UL)
#define eMIOS_0_UC13 (*(volatile struct eMIOS_tag *) 0xFFE643E0UL)
#define eMIOS_0_UC14 (*(volatile struct eMIOS_tag *) 0xFFE64400UL)
#define eMIOS_0_UC15 (*(volatile struct eMIOS_tag *) 0xFFE64420UL)
#define eMIOS_0_UC16 (*(volatile struct eMIOS_tag *) 0xFFE64440UL)
#define eMIOS_0_UC17 (*(volatile struct eMIOS_tag *) 0xFFE64460UL)
#define eMIOS_0_UC18 (*(volatile struct eMIOS_tag *) 0xFFE64480UL)
#define eMIOS_0_UC19 (*(volatile struct eMIOS_tag *) 0xFFE644A0UL)
#define eMIOS_0_UC20 (*(volatile struct eMIOS_tag *) 0xFFE644C0UL)
#define eMIOS_0_UC21 (*(volatile struct eMIOS_tag *) 0xFFE644E0UL)
#define eMIOS_0_UC22 (*(volatile struct eMIOS_tag *) 0xFFE64500UL)
#define eMIOS_0_UC23 (*(volatile struct eMIOS_tag *) 0xFFE64520UL)
#define eMIOS_1 (*(volatile struct eMIOS_tag *) 0xFBE64000UL)
#define eMIOS_1_UC08 (*(volatile struct eMIOS_tag *) 0xFBE64340UL)
#define eMIOS_1_UC09 (*(volatile struct eMIOS_tag *) 0xFBE64360UL)
#define eMIOS_1_UC10 (*(volatile struct eMIOS_tag *) 0xFBE64380UL)
#define eMIOS_1_UC11 (*(volatile struct eMIOS_tag *) 0xFBE643A0UL)
#define eMIOS_1_UC12 (*(volatile struct eMIOS_tag *) 0xFBE643C0UL)
#define eMIOS_1_UC13 (*(volatile struct eMIOS_tag *) 0xFBE643E0UL)
#define eMIOS_1_UC14 (*(volatile struct eMIOS_tag *) 0xFBE64400UL)
#define eMIOS_1_UC15 (*(volatile struct eMIOS_tag *) 0xFBE64420UL)
#define eMIOS_1_UC16 (*(volatile struct eMIOS_tag *) 0xFBE64440UL)
#define eMIOS_1_UC17 (*(volatile struct eMIOS_tag *) 0xFBE64460UL)
#define eMIOS_1_UC18 (*(volatile struct eMIOS_tag *) 0xFBE64480UL)
#define eMIOS_1_UC19 (*(volatile struct eMIOS_tag *) 0xFBE644A0UL)
#define eMIOS_1_UC20 (*(volatile struct eMIOS_tag *) 0xFBE644C0UL)
#define eMIOS_1_UC21 (*(volatile struct eMIOS_tag *) 0xFBE644E0UL)
#define eMIOS_1_UC22 (*(volatile struct eMIOS_tag *) 0xFBE64500UL)
#define eMIOS_1_UC23 (*(volatile struct eMIOS_tag *) 0xFBE64520UL)
#define eTPU_CCCR_0 (*(volatile struct eTPU_CCCR_tag *) 0xFFCC0400UL)
#define eTPU_ER_0 (*(volatile struct eTPU_ER_tag *) 0xFFCC0060UL)
#define eTPU_GCR_0 (*(volatile struct eTPU_GCR_tag *) 0xFFCC0200UL)
#define eTPU_LMR_0 (*(volatile struct eTPU_LMR_tag *) 0xFFCC0080UL)
#define eTPU_MESR_0 (*(volatile struct eTPU_MESR_tag *) 0xFFCC0100UL)
#define eTPU_SCR_0 (*(volatile struct eTPU_SCR_tag *) 0xFFCC0000UL)
#define eTPU_SSIR_0 (*(volatile struct eTPU_SSIR_tag *) 0xFFCC0C00UL)
#define eTPU_TBR_0 (*(volatile struct eTPU_TBR_tag *) 0xFFCC0020UL)

/* ADC */
#define ADC_0_MCR            ADC_0.MCR.R                   /* Main Configuration Register */
#define ADC_0_MSR            ADC_0.MSR.R                   /* Main Status register */
#define ADC_0_ISR            ADC_0.ISR.R                   /* Interrupt Status Register */
#define ADC_0_CEOCFR0        ADC_0.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_0_CEOCFR1        ADC_0.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_0_CEOCFR2        ADC_0.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_0_IMR            ADC_0.IMR.R                   /* Interrupt Mask Register */
#define ADC_0_CIMR0          ADC_0.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_0_CIMR1          ADC_0.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_0_CIMR2          ADC_0.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_0_WTISR          ADC_0.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_0_WTIMR          ADC_0.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_0_DMAE           ADC_0.DMAE.R                  /* DMA Enable register */
#define ADC_0_DMAR0          ADC_0.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_0_DMAR1          ADC_0.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_0_DMAR2          ADC_0.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_0_THRHLR0        ADC_0.THRHLR[0].R             /* Threshold Register */
#define ADC_0_THRHLR1        ADC_0.THRHLR[1].R             /* Threshold Register */
#define ADC_0_THRHLR2        ADC_0.THRHLR[2].R             /* Threshold Register */
#define ADC_0_THRHLR3        ADC_0.THRHLR[3].R             /* Threshold Register */
#define ADC_0_PSCR           ADC_0.PSCR.R                  /* Presampling Control Register */
#define ADC_0_PSR0           ADC_0.PSR0.R                  /* Presampling register 0 */
#define ADC_0_PSR1           ADC_0.PSR1.R                  /* Presampling register 1 */
#define ADC_0_PSR2           ADC_0.PSR2.R                  /* Presampling register 2 */
#define ADC_0_CTR0           ADC_0.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_0_CTR1           ADC_0.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_0_CTR2           ADC_0.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_0_NCMR0          ADC_0.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_0_NCMR1          ADC_0.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_0_NCMR2          ADC_0.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_0_JCMR0          ADC_0.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_0_JCMR1          ADC_0.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_0_JCMR2          ADC_0.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_0_DSDR           ADC_0.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_0_PDEDR          ADC_0.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_0_CDR0           ADC_0.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR1           ADC_0.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR2           ADC_0.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR3           ADC_0.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR4           ADC_0.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR5           ADC_0.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR6           ADC_0.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR7           ADC_0.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR8           ADC_0.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR9           ADC_0.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR10          ADC_0.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR11          ADC_0.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR12          ADC_0.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR13          ADC_0.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR14          ADC_0.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR15          ADC_0.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR16          ADC_0.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR17          ADC_0.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR18          ADC_0.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR19          ADC_0.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR20          ADC_0.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR21          ADC_0.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR22          ADC_0.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR23          ADC_0.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR24          ADC_0.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR25          ADC_0.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR26          ADC_0.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR27          ADC_0.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR28          ADC_0.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR29          ADC_0.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR30          ADC_0.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR31          ADC_0.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR32          ADC_0.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR33          ADC_0.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR34          ADC_0.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR35          ADC_0.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR36          ADC_0.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR37          ADC_0.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR38          ADC_0.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR39          ADC_0.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR40          ADC_0.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR41          ADC_0.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR42          ADC_0.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR43          ADC_0.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR44          ADC_0.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR45          ADC_0.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR46          ADC_0.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR47          ADC_0.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_0_CDR48          ADC_0.CDR[48].R               /*  */
#define ADC_0_CDR49          ADC_0.CDR[49].R               /*  */
#define ADC_0_CDR50          ADC_0.CDR[50].R               /*  */
#define ADC_0_CDR51          ADC_0.CDR[51].R               /*  */
#define ADC_0_CDR52          ADC_0.CDR[52].R               /*  */
#define ADC_0_CDR53          ADC_0.CDR[53].R               /*  */
#define ADC_0_CDR54          ADC_0.CDR[54].R               /*  */
#define ADC_0_CDR55          ADC_0.CDR[55].R               /*  */
#define ADC_0_CDR56          ADC_0.CDR[56].R               /*  */
#define ADC_0_CDR57          ADC_0.CDR[57].R               /*  */
#define ADC_0_CDR58          ADC_0.CDR[58].R               /*  */
#define ADC_0_CDR59          ADC_0.CDR[59].R               /*  */
#define ADC_0_CDR60          ADC_0.CDR[60].R               /*  */
#define ADC_0_CDR61          ADC_0.CDR[61].R               /*  */
#define ADC_0_CDR62          ADC_0.CDR[62].R               /*  */
#define ADC_0_CDR63          ADC_0.CDR[63].R               /*  */
#define ADC_0_CDR64          ADC_0.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR65          ADC_0.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR66          ADC_0.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR67          ADC_0.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR68          ADC_0.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR69          ADC_0.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR70          ADC_0.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR71          ADC_0.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR72          ADC_0.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR73          ADC_0.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR74          ADC_0.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR75          ADC_0.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR76          ADC_0.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR77          ADC_0.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR78          ADC_0.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR79          ADC_0.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR80          ADC_0.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR81          ADC_0.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR82          ADC_0.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR83          ADC_0.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR84          ADC_0.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR85          ADC_0.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR86          ADC_0.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR87          ADC_0.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR88          ADC_0.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR89          ADC_0.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR90          ADC_0.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR91          ADC_0.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR92          ADC_0.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR93          ADC_0.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR94          ADC_0.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CDR95          ADC_0.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_0_CWSELR0        ADC_0.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_0_CWSELR1        ADC_0.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_0_CWSELR2        ADC_0.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_0_CWSELR3        ADC_0.CWSELR3.R               /* Channel Watchdog Select Register 3 */
#define ADC_0_CWSELR4        ADC_0.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_0_CWSELR8        ADC_0.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_0_CWSELR9        ADC_0.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_0_CWSELR10       ADC_0.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_0_CWSELR11       ADC_0.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_0_CWENR0         ADC_0.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_0_CWENR1         ADC_0.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_0_CWENR2         ADC_0.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_0_AWORR0         ADC_0.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_0_AWORR1         ADC_0.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_0_AWORR2         ADC_0.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_0_STCR1          ADC_0.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_0_STCR2          ADC_0.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_0_STCR3          ADC_0.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_0_STBRR          ADC_0.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_0_STSR1          ADC_0.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_0_STSR2          ADC_0.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_0_STSR3          ADC_0.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_0_STSR4          ADC_0.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_0_STDR1          ADC_0.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_0_STDR2          ADC_0.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_0_STAW0R         ADC_0.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_0_STAW1AR        ADC_0.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_0_STAW1BR        ADC_0.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_0_STAW2R         ADC_0.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_0_STAW4R         ADC_0.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_0_STAW5R         ADC_0.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_0_CALBISTREG     ADC_0.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_0_OFSGNUSR       ADC_0.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_0_ALTR           ADC_0.ALTR.R                  /* Alternate Result register */

#define ADC_1_MCR            ADC_1.MCR.R                   /* Main Configuration Register */
#define ADC_1_MSR            ADC_1.MSR.R                   /* Main Status register */
#define ADC_1_ISR            ADC_1.ISR.R                   /* Interrupt Status Register */
#define ADC_1_CEOCFR0        ADC_1.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_1_CEOCFR1        ADC_1.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_1_CEOCFR2        ADC_1.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_1_IMR            ADC_1.IMR.R                   /* Interrupt Mask Register */
#define ADC_1_CIMR0          ADC_1.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_1_CIMR1          ADC_1.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_1_CIMR2          ADC_1.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_1_WTISR          ADC_1.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_1_WTIMR          ADC_1.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_1_DMAE           ADC_1.DMAE.R                  /* DMA Enable register */
#define ADC_1_DMAR0          ADC_1.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_1_DMAR1          ADC_1.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_1_DMAR2          ADC_1.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_1_THRHLR0        ADC_1.THRHLR[0].R             /* Threshold Register */
#define ADC_1_THRHLR1        ADC_1.THRHLR[1].R             /* Threshold Register */
#define ADC_1_THRHLR2        ADC_1.THRHLR[2].R             /* Threshold Register */
#define ADC_1_THRHLR3        ADC_1.THRHLR[3].R             /* Threshold Register */
#define ADC_1_PSCR           ADC_1.PSCR.R                  /* Presampling Control Register */
#define ADC_1_PSR0           ADC_1.PSR0.R                  /* Presampling register 0 */
#define ADC_1_PSR1           ADC_1.PSR1.R                  /* Presampling register 1 */
#define ADC_1_PSR2           ADC_1.PSR2.R                  /* Presampling register 2 */
#define ADC_1_CTR0           ADC_1.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_1_CTR1           ADC_1.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_1_CTR2           ADC_1.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_1_NCMR0          ADC_1.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_1_NCMR1          ADC_1.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_1_NCMR2          ADC_1.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_1_JCMR0          ADC_1.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_1_JCMR1          ADC_1.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_1_JCMR2          ADC_1.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_1_DSDR           ADC_1.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_1_PDEDR          ADC_1.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_1_CDR0           ADC_1.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR1           ADC_1.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR2           ADC_1.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR3           ADC_1.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR4           ADC_1.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR5           ADC_1.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR6           ADC_1.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR7           ADC_1.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR8           ADC_1.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR9           ADC_1.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR10          ADC_1.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR11          ADC_1.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR12          ADC_1.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR13          ADC_1.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR14          ADC_1.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR15          ADC_1.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR16          ADC_1.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR17          ADC_1.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR18          ADC_1.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR19          ADC_1.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR20          ADC_1.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR21          ADC_1.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR22          ADC_1.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR23          ADC_1.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR24          ADC_1.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR25          ADC_1.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR26          ADC_1.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR27          ADC_1.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR28          ADC_1.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR29          ADC_1.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR30          ADC_1.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR31          ADC_1.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR32          ADC_1.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR33          ADC_1.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR34          ADC_1.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR35          ADC_1.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR36          ADC_1.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR37          ADC_1.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR38          ADC_1.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR39          ADC_1.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR40          ADC_1.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR41          ADC_1.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR42          ADC_1.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR43          ADC_1.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR44          ADC_1.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR45          ADC_1.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR46          ADC_1.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR47          ADC_1.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_1_CDR48          ADC_1.CDR[48].R               /*  */
#define ADC_1_CDR49          ADC_1.CDR[49].R               /*  */
#define ADC_1_CDR50          ADC_1.CDR[50].R               /*  */
#define ADC_1_CDR51          ADC_1.CDR[51].R               /*  */
#define ADC_1_CDR52          ADC_1.CDR[52].R               /*  */
#define ADC_1_CDR53          ADC_1.CDR[53].R               /*  */
#define ADC_1_CDR54          ADC_1.CDR[54].R               /*  */
#define ADC_1_CDR55          ADC_1.CDR[55].R               /*  */
#define ADC_1_CDR56          ADC_1.CDR[56].R               /*  */
#define ADC_1_CDR57          ADC_1.CDR[57].R               /*  */
#define ADC_1_CDR58          ADC_1.CDR[58].R               /*  */
#define ADC_1_CDR59          ADC_1.CDR[59].R               /*  */
#define ADC_1_CDR60          ADC_1.CDR[60].R               /*  */
#define ADC_1_CDR61          ADC_1.CDR[61].R               /*  */
#define ADC_1_CDR62          ADC_1.CDR[62].R               /*  */
#define ADC_1_CDR63          ADC_1.CDR[63].R               /*  */
#define ADC_1_CDR64          ADC_1.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR65          ADC_1.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR66          ADC_1.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR67          ADC_1.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR68          ADC_1.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR69          ADC_1.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR70          ADC_1.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR71          ADC_1.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR72          ADC_1.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR73          ADC_1.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR74          ADC_1.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR75          ADC_1.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR76          ADC_1.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR77          ADC_1.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR78          ADC_1.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR79          ADC_1.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR80          ADC_1.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR81          ADC_1.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR82          ADC_1.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR83          ADC_1.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR84          ADC_1.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR85          ADC_1.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR86          ADC_1.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR87          ADC_1.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR88          ADC_1.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR89          ADC_1.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR90          ADC_1.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR91          ADC_1.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR92          ADC_1.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR93          ADC_1.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR94          ADC_1.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CDR95          ADC_1.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_1_CWSELR0        ADC_1.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_1_CWSELR1        ADC_1.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_1_CWSELR2        ADC_1.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_1_CWSELR3        ADC_1.CWSELR3.R               /* Channel Watchdog Select Register 3 */
#define ADC_1_CWSELR4        ADC_1.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_1_CWSELR8        ADC_1.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_1_CWSELR9        ADC_1.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_1_CWSELR10       ADC_1.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_1_CWSELR11       ADC_1.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_1_CWENR0         ADC_1.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_1_CWENR1         ADC_1.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_1_CWENR2         ADC_1.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_1_AWORR0         ADC_1.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_1_AWORR1         ADC_1.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_1_AWORR2         ADC_1.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_1_STCR1          ADC_1.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_1_STCR2          ADC_1.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_1_STCR3          ADC_1.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_1_STBRR          ADC_1.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_1_STSR1          ADC_1.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_1_STSR2          ADC_1.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_1_STSR3          ADC_1.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_1_STSR4          ADC_1.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_1_STDR1          ADC_1.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_1_STDR2          ADC_1.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_1_STAW0R         ADC_1.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_1_STAW1AR        ADC_1.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_1_STAW1BR        ADC_1.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_1_STAW2R         ADC_1.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_1_STAW4R         ADC_1.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_1_STAW5R         ADC_1.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_1_CALBISTREG     ADC_1.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_1_OFSGNUSR       ADC_1.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_1_ALTR           ADC_1.ALTR.R                  /* Alternate Result register */

#define ADC_2_MCR            ADC_2.MCR.R                   /* Main Configuration Register */
#define ADC_2_MSR            ADC_2.MSR.R                   /* Main Status register */
#define ADC_2_ISR            ADC_2.ISR.R                   /* Interrupt Status Register */
#define ADC_2_CEOCFR0        ADC_2.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_2_CEOCFR1        ADC_2.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_2_CEOCFR2        ADC_2.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_2_IMR            ADC_2.IMR.R                   /* Interrupt Mask Register */
#define ADC_2_CIMR0          ADC_2.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_2_CIMR1          ADC_2.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_2_CIMR2          ADC_2.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_2_WTISR          ADC_2.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_2_WTIMR          ADC_2.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_2_DMAE           ADC_2.DMAE.R                  /* DMA Enable register */
#define ADC_2_DMAR0          ADC_2.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_2_DMAR1          ADC_2.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_2_DMAR2          ADC_2.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_2_THRHLR0        ADC_2.THRHLR[0].R             /* Threshold Register */
#define ADC_2_THRHLR1        ADC_2.THRHLR[1].R             /* Threshold Register */
#define ADC_2_THRHLR2        ADC_2.THRHLR[2].R             /* Threshold Register */
#define ADC_2_THRHLR3        ADC_2.THRHLR[3].R             /* Threshold Register */
#define ADC_2_PSCR           ADC_2.PSCR.R                  /* Presampling Control Register */
#define ADC_2_PSR0           ADC_2.PSR0.R                  /* Presampling register 0 */
#define ADC_2_PSR1           ADC_2.PSR1.R                  /* Presampling register 1 */
#define ADC_2_PSR2           ADC_2.PSR2.R                  /* Presampling register 2 */
#define ADC_2_CTR0           ADC_2.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_2_CTR1           ADC_2.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_2_CTR2           ADC_2.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_2_NCMR0          ADC_2.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_2_NCMR1          ADC_2.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_2_NCMR2          ADC_2.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_2_JCMR0          ADC_2.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_2_JCMR1          ADC_2.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_2_JCMR2          ADC_2.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_2_DSDR           ADC_2.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_2_PDEDR          ADC_2.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_2_CDR0           ADC_2.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR1           ADC_2.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR2           ADC_2.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR3           ADC_2.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR4           ADC_2.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR5           ADC_2.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR6           ADC_2.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR7           ADC_2.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR8           ADC_2.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR9           ADC_2.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR10          ADC_2.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR11          ADC_2.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR12          ADC_2.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR13          ADC_2.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR14          ADC_2.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR15          ADC_2.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR16          ADC_2.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR17          ADC_2.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR18          ADC_2.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR19          ADC_2.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR20          ADC_2.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR21          ADC_2.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR22          ADC_2.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR23          ADC_2.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR24          ADC_2.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR25          ADC_2.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR26          ADC_2.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR27          ADC_2.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR28          ADC_2.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR29          ADC_2.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR30          ADC_2.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR31          ADC_2.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR32          ADC_2.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR33          ADC_2.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR34          ADC_2.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR35          ADC_2.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR36          ADC_2.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR37          ADC_2.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR38          ADC_2.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR39          ADC_2.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR40          ADC_2.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR41          ADC_2.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR42          ADC_2.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR43          ADC_2.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR44          ADC_2.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR45          ADC_2.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR46          ADC_2.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR47          ADC_2.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_2_CDR48          ADC_2.CDR[48].R               /*  */
#define ADC_2_CDR49          ADC_2.CDR[49].R               /*  */
#define ADC_2_CDR50          ADC_2.CDR[50].R               /*  */
#define ADC_2_CDR51          ADC_2.CDR[51].R               /*  */
#define ADC_2_CDR52          ADC_2.CDR[52].R               /*  */
#define ADC_2_CDR53          ADC_2.CDR[53].R               /*  */
#define ADC_2_CDR54          ADC_2.CDR[54].R               /*  */
#define ADC_2_CDR55          ADC_2.CDR[55].R               /*  */
#define ADC_2_CDR56          ADC_2.CDR[56].R               /*  */
#define ADC_2_CDR57          ADC_2.CDR[57].R               /*  */
#define ADC_2_CDR58          ADC_2.CDR[58].R               /*  */
#define ADC_2_CDR59          ADC_2.CDR[59].R               /*  */
#define ADC_2_CDR60          ADC_2.CDR[60].R               /*  */
#define ADC_2_CDR61          ADC_2.CDR[61].R               /*  */
#define ADC_2_CDR62          ADC_2.CDR[62].R               /*  */
#define ADC_2_CDR63          ADC_2.CDR[63].R               /*  */
#define ADC_2_CDR64          ADC_2.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR65          ADC_2.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR66          ADC_2.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR67          ADC_2.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR68          ADC_2.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR69          ADC_2.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR70          ADC_2.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR71          ADC_2.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR72          ADC_2.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR73          ADC_2.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR74          ADC_2.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR75          ADC_2.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR76          ADC_2.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR77          ADC_2.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR78          ADC_2.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR79          ADC_2.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR80          ADC_2.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR81          ADC_2.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR82          ADC_2.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR83          ADC_2.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR84          ADC_2.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR85          ADC_2.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR86          ADC_2.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR87          ADC_2.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR88          ADC_2.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR89          ADC_2.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR90          ADC_2.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR91          ADC_2.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR92          ADC_2.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR93          ADC_2.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR94          ADC_2.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CDR95          ADC_2.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_2_CWSELR0        ADC_2.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_2_CWSELR1        ADC_2.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_2_CWSELR2        ADC_2.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_2_CWSELR3        ADC_2.CWSELR3.R               /* Channel Watchdog Select Register 3 */
#define ADC_2_CWSELR4        ADC_2.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_2_CWSELR8        ADC_2.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_2_CWSELR9        ADC_2.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_2_CWSELR10       ADC_2.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_2_CWSELR11       ADC_2.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_2_CWENR0         ADC_2.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_2_CWENR1         ADC_2.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_2_CWENR2         ADC_2.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_2_AWORR0         ADC_2.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_2_AWORR1         ADC_2.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_2_AWORR2         ADC_2.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_2_STCR1          ADC_2.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_2_STCR2          ADC_2.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_2_STCR3          ADC_2.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_2_STBRR          ADC_2.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_2_STSR1          ADC_2.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_2_STSR2          ADC_2.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_2_STSR3          ADC_2.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_2_STSR4          ADC_2.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_2_STDR1          ADC_2.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_2_STDR2          ADC_2.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_2_STAW0R         ADC_2.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_2_STAW1AR        ADC_2.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_2_STAW1BR        ADC_2.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_2_STAW2R         ADC_2.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_2_STAW4R         ADC_2.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_2_STAW5R         ADC_2.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_2_CALBISTREG     ADC_2.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_2_OFSGNUSR       ADC_2.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_2_ALTR           ADC_2.ALTR.R                  /* Alternate Result register */

#define ADC_3_MCR            ADC_3.MCR.R                   /* Main Configuration Register */
#define ADC_3_MSR            ADC_3.MSR.R                   /* Main Status register */
#define ADC_3_ISR            ADC_3.ISR.R                   /* Interrupt Status Register */
#define ADC_3_CEOCFR0        ADC_3.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_3_CEOCFR1        ADC_3.CEOCFR1.R               /* Channel Pending register 1 */
#define ADC_3_CEOCFR2        ADC_3.CEOCFR2.R               /* Channel Pending register 2 */
#define ADC_3_IMR            ADC_3.IMR.R                   /* Interrupt Mask Register */
#define ADC_3_CIMR0          ADC_3.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_3_CIMR1          ADC_3.CIMR1.R                 /* Channel Interrupt Mask Register 1 */
#define ADC_3_CIMR2          ADC_3.CIMR2.R                 /* Channel Interrupt Mask Register 2 */
#define ADC_3_WTISR          ADC_3.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_3_WTIMR          ADC_3.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_3_DMAE           ADC_3.DMAE.R                  /* DMA Enable register */
#define ADC_3_DMAR0          ADC_3.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_3_DMAR1          ADC_3.DMAR1.R                 /* DMA Channel Select Register 1 */
#define ADC_3_DMAR2          ADC_3.DMAR2.R                 /* DMA Channel Select Register 2 */
#define ADC_3_THRHLR0        ADC_3.THRHLR[0].R             /* Threshold Register */
#define ADC_3_THRHLR1        ADC_3.THRHLR[1].R             /* Threshold Register */
#define ADC_3_THRHLR2        ADC_3.THRHLR[2].R             /* Threshold Register */
#define ADC_3_THRHLR3        ADC_3.THRHLR[3].R             /* Threshold Register */
#define ADC_3_PSCR           ADC_3.PSCR.R                  /* Presampling Control Register */
#define ADC_3_PSR0           ADC_3.PSR0.R                  /* Presampling register 0 */
#define ADC_3_PSR1           ADC_3.PSR1.R                  /* Presampling register 1 */
#define ADC_3_PSR2           ADC_3.PSR2.R                  /* Presampling register 2 */
#define ADC_3_CTR0           ADC_3.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_3_CTR1           ADC_3.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_3_CTR2           ADC_3.CTR2.R                  /* Conversion Timing Register 2 */
#define ADC_3_NCMR0          ADC_3.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_3_NCMR1          ADC_3.NCMR1.R                 /* Normal Conversion Mask Register 1 */
#define ADC_3_NCMR2          ADC_3.NCMR2.R                 /* Normal Conversion Mask Register 2 */
#define ADC_3_JCMR0          ADC_3.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_3_JCMR1          ADC_3.JCMR1.R                 /* Injected Conversion Mask Register 1 */
#define ADC_3_JCMR2          ADC_3.JCMR2.R                 /* Injected Conversion Mask Register 2 */
#define ADC_3_DSDR           ADC_3.DSDR.R                  /* Decode Signals Delay Register */
#define ADC_3_PDEDR          ADC_3.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_3_CDR0           ADC_3.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR1           ADC_3.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR2           ADC_3.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR3           ADC_3.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR4           ADC_3.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR5           ADC_3.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR6           ADC_3.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR7           ADC_3.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR8           ADC_3.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR9           ADC_3.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR10          ADC_3.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR11          ADC_3.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR12          ADC_3.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR13          ADC_3.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR14          ADC_3.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR15          ADC_3.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR16          ADC_3.CDR[16].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR17          ADC_3.CDR[17].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR18          ADC_3.CDR[18].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR19          ADC_3.CDR[19].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR20          ADC_3.CDR[20].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR21          ADC_3.CDR[21].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR22          ADC_3.CDR[22].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR23          ADC_3.CDR[23].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR24          ADC_3.CDR[24].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR25          ADC_3.CDR[25].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR26          ADC_3.CDR[26].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR27          ADC_3.CDR[27].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR28          ADC_3.CDR[28].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR29          ADC_3.CDR[29].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR30          ADC_3.CDR[30].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR31          ADC_3.CDR[31].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR32          ADC_3.CDR[32].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR33          ADC_3.CDR[33].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR34          ADC_3.CDR[34].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR35          ADC_3.CDR[35].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR36          ADC_3.CDR[36].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR37          ADC_3.CDR[37].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR38          ADC_3.CDR[38].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR39          ADC_3.CDR[39].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR40          ADC_3.CDR[40].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR41          ADC_3.CDR[41].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR42          ADC_3.CDR[42].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR43          ADC_3.CDR[43].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR44          ADC_3.CDR[44].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR45          ADC_3.CDR[45].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR46          ADC_3.CDR[46].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR47          ADC_3.CDR[47].R               /* Channel Data Register n (Internal Channels) */
#define ADC_3_CDR48          ADC_3.CDR[48].R               /*  */
#define ADC_3_CDR49          ADC_3.CDR[49].R               /*  */
#define ADC_3_CDR50          ADC_3.CDR[50].R               /*  */
#define ADC_3_CDR51          ADC_3.CDR[51].R               /*  */
#define ADC_3_CDR52          ADC_3.CDR[52].R               /*  */
#define ADC_3_CDR53          ADC_3.CDR[53].R               /*  */
#define ADC_3_CDR54          ADC_3.CDR[54].R               /*  */
#define ADC_3_CDR55          ADC_3.CDR[55].R               /*  */
#define ADC_3_CDR56          ADC_3.CDR[56].R               /*  */
#define ADC_3_CDR57          ADC_3.CDR[57].R               /*  */
#define ADC_3_CDR58          ADC_3.CDR[58].R               /*  */
#define ADC_3_CDR59          ADC_3.CDR[59].R               /*  */
#define ADC_3_CDR60          ADC_3.CDR[60].R               /*  */
#define ADC_3_CDR61          ADC_3.CDR[61].R               /*  */
#define ADC_3_CDR62          ADC_3.CDR[62].R               /*  */
#define ADC_3_CDR63          ADC_3.CDR[63].R               /*  */
#define ADC_3_CDR64          ADC_3.CDR[64].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR65          ADC_3.CDR[65].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR66          ADC_3.CDR[66].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR67          ADC_3.CDR[67].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR68          ADC_3.CDR[68].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR69          ADC_3.CDR[69].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR70          ADC_3.CDR[70].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR71          ADC_3.CDR[71].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR72          ADC_3.CDR[72].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR73          ADC_3.CDR[73].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR74          ADC_3.CDR[74].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR75          ADC_3.CDR[75].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR76          ADC_3.CDR[76].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR77          ADC_3.CDR[77].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR78          ADC_3.CDR[78].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR79          ADC_3.CDR[79].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR80          ADC_3.CDR[80].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR81          ADC_3.CDR[81].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR82          ADC_3.CDR[82].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR83          ADC_3.CDR[83].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR84          ADC_3.CDR[84].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR85          ADC_3.CDR[85].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR86          ADC_3.CDR[86].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR87          ADC_3.CDR[87].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR88          ADC_3.CDR[88].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR89          ADC_3.CDR[89].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR90          ADC_3.CDR[90].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR91          ADC_3.CDR[91].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR92          ADC_3.CDR[92].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR93          ADC_3.CDR[93].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR94          ADC_3.CDR[94].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CDR95          ADC_3.CDR[95].R               /* Channel Data Register n (External Channels) */
#define ADC_3_CWSELR0        ADC_3.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_3_CWSELR1        ADC_3.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_3_CWSELR2        ADC_3.CWSELR2.R               /* Channel Watchdog Select Register 2 */
#define ADC_3_CWSELR3        ADC_3.CWSELR3.R               /* Channel Watchdog Select Register 3 */
#define ADC_3_CWSELR4        ADC_3.CWSELR4.R               /* Channel Watchdog Select Register 4 */
#define ADC_3_CWSELR8        ADC_3.CWSELR8.R               /* Channel Watchdog Select Register 8 */
#define ADC_3_CWSELR9        ADC_3.CWSELR9.R               /* Channel Watchdog Select Register 9 */
#define ADC_3_CWSELR10       ADC_3.CWSELR10.R              /* Channel Watchdog Select Register 10 */
#define ADC_3_CWSELR11       ADC_3.CWSELR11.R              /* Channel Watchdog Select Register 11 */
#define ADC_3_CWENR0         ADC_3.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_3_CWENR1         ADC_3.CWENR1.R                /* Channel Watchdog Enable Register 1 */
#define ADC_3_CWENR2         ADC_3.CWENR2.R                /* Channel Watchdog Enable Register 2 */
#define ADC_3_AWORR0         ADC_3.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_3_AWORR1         ADC_3.AWORR1.R                /* Analog Watchdog Out of Range Register 1 */
#define ADC_3_AWORR2         ADC_3.AWORR2.R                /* Analog Watchdog Out of Range Register 2 */
#define ADC_3_STCR1          ADC_3.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_3_STCR2          ADC_3.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_3_STCR3          ADC_3.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_3_STBRR          ADC_3.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_3_STSR1          ADC_3.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_3_STSR2          ADC_3.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_3_STSR3          ADC_3.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_3_STSR4          ADC_3.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_3_STDR1          ADC_3.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_3_STDR2          ADC_3.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_3_STAW0R         ADC_3.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_3_STAW1AR        ADC_3.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_3_STAW1BR        ADC_3.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_3_STAW2R         ADC_3.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_3_STAW4R         ADC_3.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_3_STAW5R         ADC_3.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_3_CALBISTREG     ADC_3.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_3_OFSGNUSR       ADC_3.OFSGNUSR.R              /* Offset and Gain User Register */
#define ADC_3_ALTR           ADC_3.ALTR.R                  /* Alternate Result register */

/* AIPS */
#define AIPS_A_MPRA          AIPS_A.MPRA.R                 /* Master Privilege Register A */
#define AIPS_A_PACRA         AIPS_A.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRB         AIPS_A.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRC         AIPS_A.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRD         AIPS_A.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_A_PACR_Reserved AIPS_A.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRF         AIPS_A.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRG         AIPS_A.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_A_PACRH         AIPS_A.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_A_OPACRA        AIPS_A.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRB        AIPS_A.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRC        AIPS_A.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRD        AIPS_A.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRE        AIPS_A.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRF        AIPS_A.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRG        AIPS_A.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRH        AIPS_A.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRI        AIPS_A.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRJ        AIPS_A.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRK        AIPS_A.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRL        AIPS_A.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRM        AIPS_A.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRN        AIPS_A.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRO        AIPS_A.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRP        AIPS_A.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRQ        AIPS_A.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRR        AIPS_A.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRS        AIPS_A.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRT        AIPS_A.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRU        AIPS_A.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRV        AIPS_A.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRW        AIPS_A.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRX        AIPS_A.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRY        AIPS_A.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRZ        AIPS_A.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAA       AIPS_A.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAB       AIPS_A.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAC       AIPS_A.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAD       AIPS_A.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAE       AIPS_A.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_A_OPACRAF       AIPS_A.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

#define AIPS_B_MPRA          AIPS_B.MPRA.R                 /* Master Privilege Register A */
#define AIPS_B_PACRA         AIPS_B.PACR[0].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRB         AIPS_B.PACR[1].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRC         AIPS_B.PACR[2].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRD         AIPS_B.PACR[3].R              /* Peripheral Access Control Register */
#define AIPS_B_PACR_Reserved AIPS_B.PACR[4].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRF         AIPS_B.PACR[5].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRG         AIPS_B.PACR[6].R              /* Peripheral Access Control Register */
#define AIPS_B_PACRH         AIPS_B.PACR[7].R              /* Peripheral Access Control Register */
#define AIPS_B_OPACRA        AIPS_B.OPACR[0].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRB        AIPS_B.OPACR[1].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRC        AIPS_B.OPACR[2].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRD        AIPS_B.OPACR[3].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRE        AIPS_B.OPACR[4].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRF        AIPS_B.OPACR[5].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRG        AIPS_B.OPACR[6].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRH        AIPS_B.OPACR[7].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRI        AIPS_B.OPACR[8].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRJ        AIPS_B.OPACR[9].R             /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRK        AIPS_B.OPACR[10].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRL        AIPS_B.OPACR[11].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRM        AIPS_B.OPACR[12].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRN        AIPS_B.OPACR[13].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRO        AIPS_B.OPACR[14].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRP        AIPS_B.OPACR[15].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRQ        AIPS_B.OPACR[16].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRR        AIPS_B.OPACR[17].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRS        AIPS_B.OPACR[18].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRT        AIPS_B.OPACR[19].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRU        AIPS_B.OPACR[20].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRV        AIPS_B.OPACR[21].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRW        AIPS_B.OPACR[22].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRX        AIPS_B.OPACR[23].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRY        AIPS_B.OPACR[24].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRZ        AIPS_B.OPACR[25].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAA       AIPS_B.OPACR[26].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAB       AIPS_B.OPACR[27].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAC       AIPS_B.OPACR[28].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAD       AIPS_B.OPACR[29].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAE       AIPS_B.OPACR[30].R            /* Off-Platform Peripheral Access Control Register */
#define AIPS_B_OPACRAF       AIPS_B.OPACR[31].R            /* Off-Platform Peripheral Access Control Register */

/* BCTU */
#define BCTU_MCR             BCTU.MCR.R                    /* Module Configuration Register */
#define BCTU_MSR             BCTU.MSR.R                    /* Module Status register */
#define BCTU_TRGCFG_0        BCTU.TRGCFG[0].TRGCFG.R       /* Trigger Configuration Register */
#define BCTU_TRGCFG_1        BCTU.TRGCFG[1].TRGCFG.R       /* Trigger Configuration Register */
#define BCTU_TRGCFG_2        BCTU.TRGCFG[2].TRGCFG.R       /* Trigger Configuration Register */
#define BCTU_TRGCFG_3        BCTU.TRGCFG[3].TRGCFG.R       /* Trigger Configuration Register */
#define BCTU_TRGCFG_4        BCTU.TRGCFG[4].TRGCFG.R       /* Trigger Configuration Register */
#define BCTU_TRGCFG_5        BCTU.TRGCFG[5].TRGCFG.R       /* Trigger Configuration Register */
#define BCTU_TRGCFG_6        BCTU.TRGCFG[6].TRGCFG.R       /* Trigger Configuration Register */
#define BCTU_TRGCFG_7        BCTU.TRGCFG[7].TRGCFG.R       /* Trigger Configuration Register */
#define BCTU_TRGCFG_8        BCTU.TRGCFG[8].TRGCFG.R       /* Trigger Configuration Register */
#define BCTU_TRGCFG_9        BCTU.TRGCFG[9].TRGCFG.R       /* Trigger Configuration Register */
#define BCTU_TRGCFG_10       BCTU.TRGCFG[10].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_11       BCTU.TRGCFG[11].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_12       BCTU.TRGCFG[12].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_13       BCTU.TRGCFG[13].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_14       BCTU.TRGCFG[14].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_15       BCTU.TRGCFG[15].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_16       BCTU.TRGCFG[16].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_17       BCTU.TRGCFG[17].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_18       BCTU.TRGCFG[18].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_19       BCTU.TRGCFG[19].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_20       BCTU.TRGCFG[20].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_21       BCTU.TRGCFG[21].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_22       BCTU.TRGCFG[22].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_23       BCTU.TRGCFG[23].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_24       BCTU.TRGCFG[24].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_25       BCTU.TRGCFG[25].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_26       BCTU.TRGCFG[26].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_27       BCTU.TRGCFG[27].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_28       BCTU.TRGCFG[28].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_29       BCTU.TRGCFG[29].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_30       BCTU.TRGCFG[30].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_TRGCFG_31       BCTU.TRGCFG[31].TRGCFG.R      /* Trigger Configuration Register */
#define BCTU_WRPROT          BCTU.WRPROT.R                 /* Write Protection register */
#define BCTU_SFTRGR1         BCTU.SFTRGR1.R                /* Software Trigger register 1 */
#define BCTU_SFTRGR3         BCTU.SFTRGR3.R                /* Software Trigger register 1 */
#define BCTU_ADC0DR          BCTU.ADC0DR.R                 /* ADC0 Result Data register */
#define BCTU_ADC1DR          BCTU.ADC1DR.R                 /* ADC1 result data register */
#define BCTU_ADC2DR          BCTU.ADC2DR.R                 /* ADC2 result data register */
#define BCTU_ADC3DR          BCTU.ADC3DR.R                 /* ADC3 result data register */
#define BCTU_LISTSTAR        BCTU.LISTSTAR.R               /* LIST Size Status register */
#define BCTU_LISTCHR_0       BCTU.LISTCHR[0].LISTCHR.R     /* LIST Channel Address Register */
#define BCTU_LISTCHR_1       BCTU.LISTCHR[1].LISTCHR.R     /* LIST Channel Address Register */
#define BCTU_LISTCHR_2       BCTU.LISTCHR[2].LISTCHR.R     /* LIST Channel Address Register */
#define BCTU_LISTCHR_3       BCTU.LISTCHR[3].LISTCHR.R     /* LIST Channel Address Register */
#define BCTU_LISTCHR_4       BCTU.LISTCHR[4].LISTCHR.R     /* LIST Channel Address Register */
#define BCTU_LISTCHR_5       BCTU.LISTCHR[5].LISTCHR.R     /* LIST Channel Address Register */
#define BCTU_LISTCHR_6       BCTU.LISTCHR[6].LISTCHR.R     /* LIST Channel Address Register */
#define BCTU_LISTCHR_7       BCTU.LISTCHR[7].LISTCHR.R     /* LIST Channel Address Register */
#define BCTU_LISTCHR_8       BCTU.LISTCHR[8].LISTCHR.R     /* LIST Channel Address Register */
#define BCTU_LISTCHR_9       BCTU.LISTCHR[9].LISTCHR.R     /* LIST Channel Address Register */
#define BCTU_LISTCHR_10      BCTU.LISTCHR[10].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_11      BCTU.LISTCHR[11].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_12      BCTU.LISTCHR[12].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_13      BCTU.LISTCHR[13].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_14      BCTU.LISTCHR[14].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_15      BCTU.LISTCHR[15].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_16      BCTU.LISTCHR[16].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_17      BCTU.LISTCHR[17].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_18      BCTU.LISTCHR[18].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_19      BCTU.LISTCHR[19].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_20      BCTU.LISTCHR[20].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_21      BCTU.LISTCHR[21].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_22      BCTU.LISTCHR[22].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_23      BCTU.LISTCHR[23].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_24      BCTU.LISTCHR[24].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_25      BCTU.LISTCHR[25].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_26      BCTU.LISTCHR[26].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_27      BCTU.LISTCHR[27].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_28      BCTU.LISTCHR[28].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_29      BCTU.LISTCHR[29].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_30      BCTU.LISTCHR[30].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_LISTCHR_31      BCTU.LISTCHR[31].LISTCHR.R    /* LIST Channel Address Register */
#define BCTU_CCR_0           BCTU.CCR[0].CCR.R             /* Conversion configuration register */
#define BCTU_CCR_1           BCTU.CCR[1].CCR.R             /* Conversion configuration register */
#define BCTU_CCR_2           BCTU.CCR[2].CCR.R             /* Conversion configuration register */
#define BCTU_CCR_3           BCTU.CCR[3].CCR.R             /* Conversion configuration register */
#define BCTU_CCR_4           BCTU.CCR[4].CCR.R             /* Conversion configuration register */
#define BCTU_CCR_5           BCTU.CCR[5].CCR.R             /* Conversion configuration register */
#define BCTU_CCR_6           BCTU.CCR[6].CCR.R             /* Conversion configuration register */
#define BCTU_CCR_7           BCTU.CCR[7].CCR.R             /* Conversion configuration register */
#define BCTU_CCR_8           BCTU.CCR[8].CCR.R             /* Conversion configuration register */
#define BCTU_CCR_9           BCTU.CCR[9].CCR.R             /* Conversion configuration register */
#define BCTU_CCR_10          BCTU.CCR[10].CCR.R            /* Conversion configuration register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */

/* CAN */
#define CAN_0_MCR            CAN_0.MCR.R                   /* Module Configuration Register */
#define CAN_0_CTRL1          CAN_0.CTRL1.R                 /* Control 1 register */
#define CAN_0_TIMER          CAN_0.TIMER.R                 /* Free Running Timer */
#define CAN_0_RXMGMASK       CAN_0.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_0_RX14MASK       CAN_0.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_0_RX15MASK       CAN_0.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_0_ECR            CAN_0.ECR.R                   /* Error Counter */
#define CAN_0_ESR1           CAN_0.ESR1.R                  /* Error and Status 1 register */
#define CAN_0_IMASK2         CAN_0.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_0_IMASK1         CAN_0.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_0_IFLAG2         CAN_0.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_0_IFLAG1         CAN_0.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_0_CTRL2          CAN_0.CTRL2.R                 /* Control 2 register */
#define CAN_0_ESR2           CAN_0.ESR2.R                  /* Error and Status 2 register */
#define CAN_0_CRCR           CAN_0.CRCR.R                  /* CRC Register */
#define CAN_0_RXFGMASK       CAN_0.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_0_RXFIR          CAN_0.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_0_CBT            CAN_0.CBT.R                   /* CAN Bit Timing Register */
#define CAN_0_IMASK3         CAN_0.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_0_IFLAG3         CAN_0.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_0_CS0            CAN_0.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_0_ID0            CAN_0.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_0_B0             CAN_0.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_0_H0             CAN_0.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_0_W0             CAN_0.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_0_CS1            CAN_0.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_0_ID1            CAN_0.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_0_B1             CAN_0.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_0_H1             CAN_0.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_0_W1             CAN_0.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_0_CS2            CAN_0.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_0_ID2            CAN_0.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_0_B2             CAN_0.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_0_H2             CAN_0.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_0_W2             CAN_0.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_0_CS3            CAN_0.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_0_ID3            CAN_0.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_0_B3             CAN_0.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_0_H3             CAN_0.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_0_W3             CAN_0.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_0_CS4            CAN_0.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_0_ID4            CAN_0.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_0_B4             CAN_0.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_0_H4             CAN_0.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_0_W4             CAN_0.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_0_CS5            CAN_0.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_0_ID5            CAN_0.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_0_B5             CAN_0.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_0_H5             CAN_0.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_0_W5             CAN_0.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_0_CS6            CAN_0.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_0_ID6            CAN_0.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_0_B6             CAN_0.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_0_H6             CAN_0.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_0_W6             CAN_0.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_0_CS7            CAN_0.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_0_ID7            CAN_0.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_0_B7             CAN_0.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_0_H7             CAN_0.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_0_W7             CAN_0.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_0_CS8            CAN_0.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_0_ID8            CAN_0.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_0_B8             CAN_0.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_0_H8             CAN_0.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_0_W8             CAN_0.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_0_CS9            CAN_0.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_0_ID9            CAN_0.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_0_B9             CAN_0.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_0_H9             CAN_0.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_0_W9             CAN_0.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_0_CS10           CAN_0.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_0_ID10           CAN_0.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_0_B10            CAN_0.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_0_H10            CAN_0.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_0_W10            CAN_0.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_0_CS11           CAN_0.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_0_ID11           CAN_0.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_0_B11            CAN_0.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_0_H11            CAN_0.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_0_W11            CAN_0.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_0_CS12           CAN_0.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_0_ID12           CAN_0.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_0_B12            CAN_0.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_0_H12            CAN_0.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_0_W12            CAN_0.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_0_CS13           CAN_0.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_0_ID13           CAN_0.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_0_B13            CAN_0.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_0_H13            CAN_0.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_0_W13            CAN_0.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_0_CS14           CAN_0.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_0_ID14           CAN_0.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_0_B14            CAN_0.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_0_H14            CAN_0.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_0_W14            CAN_0.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_0_CS15           CAN_0.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_0_ID15           CAN_0.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_0_B15            CAN_0.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_0_H15            CAN_0.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_0_W15            CAN_0.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_0_CS16           CAN_0.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_0_ID16           CAN_0.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_0_B16            CAN_0.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_0_H16            CAN_0.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_0_W16            CAN_0.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_0_CS17           CAN_0.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_0_ID17           CAN_0.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_0_B17            CAN_0.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_0_H17            CAN_0.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_0_W17            CAN_0.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_0_CS18           CAN_0.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_0_ID18           CAN_0.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_0_B18            CAN_0.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_0_H18            CAN_0.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_0_W18            CAN_0.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_0_CS19           CAN_0.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_0_ID19           CAN_0.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_0_B19            CAN_0.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_0_H19            CAN_0.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_0_W19            CAN_0.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_0_CS20           CAN_0.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_0_ID20           CAN_0.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_0_B20            CAN_0.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_0_H20            CAN_0.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_0_W20            CAN_0.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_0_CS21           CAN_0.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_0_ID21           CAN_0.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_0_B21            CAN_0.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_0_H21            CAN_0.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_0_W21            CAN_0.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_0_CS22           CAN_0.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_0_ID22           CAN_0.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_0_B22            CAN_0.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_0_H22            CAN_0.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_0_W22            CAN_0.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_0_CS23           CAN_0.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_0_ID23           CAN_0.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_0_B23            CAN_0.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_0_H23            CAN_0.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_0_W23            CAN_0.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_0_CS24           CAN_0.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_0_ID24           CAN_0.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_0_B24            CAN_0.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_0_H24            CAN_0.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_0_W24            CAN_0.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_0_CS25           CAN_0.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_0_ID25           CAN_0.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_0_B25            CAN_0.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_0_H25            CAN_0.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_0_W25            CAN_0.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_0_CS26           CAN_0.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_0_ID26           CAN_0.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_0_B26            CAN_0.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_0_H26            CAN_0.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_0_W26            CAN_0.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_0_CS27           CAN_0.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_0_ID27           CAN_0.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_0_B27            CAN_0.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_0_H27            CAN_0.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_0_W27            CAN_0.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_0_CS28           CAN_0.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_0_ID28           CAN_0.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_0_B28            CAN_0.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_0_H28            CAN_0.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_0_W28            CAN_0.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_0_CS29           CAN_0.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_0_ID29           CAN_0.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_0_B29            CAN_0.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_0_H29            CAN_0.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_0_W29            CAN_0.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_0_CS30           CAN_0.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_0_ID30           CAN_0.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_0_B30            CAN_0.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_0_H30            CAN_0.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_0_W30            CAN_0.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_0_CS31           CAN_0.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_0_ID31           CAN_0.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_0_B31            CAN_0.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_0_H31            CAN_0.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_0_W31            CAN_0.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_0_CS32           CAN_0.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_0_ID32           CAN_0.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_0_B32            CAN_0.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_0_H32            CAN_0.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_0_W32            CAN_0.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_0_CS33           CAN_0.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_0_ID33           CAN_0.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_0_B33            CAN_0.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_0_H33            CAN_0.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_0_W33            CAN_0.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_0_CS34           CAN_0.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_0_ID34           CAN_0.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_0_B34            CAN_0.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_0_H34            CAN_0.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_0_W34            CAN_0.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_0_CS35           CAN_0.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_0_ID35           CAN_0.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_0_B35            CAN_0.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_0_H35            CAN_0.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_0_W35            CAN_0.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_0_CS36           CAN_0.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_0_ID36           CAN_0.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_0_B36            CAN_0.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_0_H36            CAN_0.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_0_W36            CAN_0.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_0_CS37           CAN_0.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_0_ID37           CAN_0.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_0_B37            CAN_0.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_0_H37            CAN_0.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_0_W37            CAN_0.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_0_CS38           CAN_0.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_0_ID38           CAN_0.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_0_B38            CAN_0.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_0_H38            CAN_0.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_0_W38            CAN_0.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_0_CS39           CAN_0.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_0_ID39           CAN_0.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_0_B39            CAN_0.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_0_H39            CAN_0.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_0_W39            CAN_0.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_0_CS40           CAN_0.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_0_ID40           CAN_0.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_0_B40            CAN_0.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_0_H40            CAN_0.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_0_W40            CAN_0.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_0_CS41           CAN_0.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_0_ID41           CAN_0.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_0_B41            CAN_0.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_0_H41            CAN_0.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_0_W41            CAN_0.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_0_CS42           CAN_0.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_0_ID42           CAN_0.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_0_B42            CAN_0.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_0_H42            CAN_0.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_0_W42            CAN_0.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_0_CS43           CAN_0.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_0_ID43           CAN_0.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_0_B43            CAN_0.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_0_H43            CAN_0.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_0_W43            CAN_0.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_0_CS44           CAN_0.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_0_ID44           CAN_0.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_0_B44            CAN_0.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_0_H44            CAN_0.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_0_W44            CAN_0.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_0_CS45           CAN_0.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_0_ID45           CAN_0.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_0_B45            CAN_0.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_0_H45            CAN_0.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_0_W45            CAN_0.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_0_CS46           CAN_0.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_0_ID46           CAN_0.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_0_B46            CAN_0.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_0_H46            CAN_0.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_0_W46            CAN_0.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_0_CS47           CAN_0.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_0_ID47           CAN_0.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_0_B47            CAN_0.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_0_H47            CAN_0.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_0_W47            CAN_0.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_0_CS48           CAN_0.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_0_ID48           CAN_0.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_0_B48            CAN_0.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_0_H48            CAN_0.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_0_W48            CAN_0.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_0_CS49           CAN_0.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_0_ID49           CAN_0.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_0_B49            CAN_0.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_0_H49            CAN_0.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_0_W49            CAN_0.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_0_CS50           CAN_0.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_0_ID50           CAN_0.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_0_B50            CAN_0.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_0_H50            CAN_0.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_0_W50            CAN_0.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_0_CS51           CAN_0.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_0_ID51           CAN_0.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_0_B51            CAN_0.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_0_H51            CAN_0.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_0_W51            CAN_0.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_0_CS52           CAN_0.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_0_ID52           CAN_0.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_0_B52            CAN_0.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_0_H52            CAN_0.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_0_W52            CAN_0.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_0_CS53           CAN_0.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_0_ID53           CAN_0.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_0_B53            CAN_0.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_0_H53            CAN_0.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_0_W53            CAN_0.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_0_CS54           CAN_0.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_0_ID54           CAN_0.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_0_B54            CAN_0.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_0_H54            CAN_0.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_0_W54            CAN_0.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_0_CS55           CAN_0.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_0_ID55           CAN_0.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_0_B55            CAN_0.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_0_H55            CAN_0.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_0_W55            CAN_0.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_0_CS56           CAN_0.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_0_ID56           CAN_0.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_0_B56            CAN_0.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_0_H56            CAN_0.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_0_W56            CAN_0.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_0_CS57           CAN_0.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_0_ID57           CAN_0.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_0_B57            CAN_0.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_0_H57            CAN_0.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_0_W57            CAN_0.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_0_CS58           CAN_0.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_0_ID58           CAN_0.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_0_B58            CAN_0.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_0_H58            CAN_0.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_0_W58            CAN_0.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_0_CS59           CAN_0.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_0_ID59           CAN_0.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_0_B59            CAN_0.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_0_H59            CAN_0.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_0_W59            CAN_0.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_0_CS60           CAN_0.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_0_ID60           CAN_0.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_0_B60            CAN_0.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_0_H60            CAN_0.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_0_W60            CAN_0.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_0_CS61           CAN_0.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_0_ID61           CAN_0.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_0_B61            CAN_0.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_0_H61            CAN_0.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_0_W61            CAN_0.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_0_CS62           CAN_0.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_0_ID62           CAN_0.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_0_B62            CAN_0.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_0_H62            CAN_0.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_0_W62            CAN_0.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_0_CS63           CAN_0.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_0_ID63           CAN_0.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_0_B63            CAN_0.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_0_H63            CAN_0.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_0_W63            CAN_0.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_0_RXIMR0         CAN_0.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR1         CAN_0.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR2         CAN_0.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR3         CAN_0.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR4         CAN_0.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR5         CAN_0.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR6         CAN_0.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR7         CAN_0.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR8         CAN_0.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR9         CAN_0.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR10        CAN_0.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR11        CAN_0.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR12        CAN_0.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR13        CAN_0.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR14        CAN_0.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR15        CAN_0.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR16        CAN_0.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR17        CAN_0.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR18        CAN_0.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR19        CAN_0.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR20        CAN_0.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR21        CAN_0.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR22        CAN_0.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR23        CAN_0.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR24        CAN_0.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR25        CAN_0.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR26        CAN_0.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR27        CAN_0.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR28        CAN_0.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR29        CAN_0.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR30        CAN_0.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR31        CAN_0.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR32        CAN_0.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR33        CAN_0.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR34        CAN_0.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR35        CAN_0.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR36        CAN_0.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR37        CAN_0.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR38        CAN_0.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR39        CAN_0.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR40        CAN_0.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR41        CAN_0.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR42        CAN_0.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR43        CAN_0.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR44        CAN_0.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR45        CAN_0.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR46        CAN_0.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR47        CAN_0.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR48        CAN_0.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR49        CAN_0.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR50        CAN_0.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR51        CAN_0.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR52        CAN_0.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR53        CAN_0.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR54        CAN_0.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR55        CAN_0.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR56        CAN_0.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR57        CAN_0.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR58        CAN_0.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR59        CAN_0.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR60        CAN_0.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR61        CAN_0.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR62        CAN_0.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR63        CAN_0.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR64        CAN_0.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR65        CAN_0.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR66        CAN_0.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR67        CAN_0.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR68        CAN_0.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR69        CAN_0.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR70        CAN_0.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR71        CAN_0.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR72        CAN_0.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR73        CAN_0.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR74        CAN_0.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR75        CAN_0.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR76        CAN_0.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR77        CAN_0.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR78        CAN_0.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR79        CAN_0.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR80        CAN_0.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR81        CAN_0.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR82        CAN_0.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR83        CAN_0.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR84        CAN_0.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR85        CAN_0.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR86        CAN_0.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR87        CAN_0.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR88        CAN_0.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR89        CAN_0.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR90        CAN_0.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR91        CAN_0.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR92        CAN_0.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR93        CAN_0.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR94        CAN_0.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR95        CAN_0.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_0_MECR           CAN_0.MECR.R                  /* Memory Error Control Register */
#define CAN_0_ERRIAR         CAN_0.ERRIAR.R                /* Error Injection Address Register */
#define CAN_0_ERRIDPR        CAN_0.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_0_ERRIPPR        CAN_0.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_0_RERRAR         CAN_0.RERRAR.R                /* Error Report Address Register */
#define CAN_0_RERRDR         CAN_0.RERRDR.R                /* Error Report Data Register */
#define CAN_0_RERRSYNR       CAN_0.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_0_ERRSR          CAN_0.ERRSR.R                 /* Error Status Register */
#define CAN_0_FDCTRL         CAN_0.FDCTRL.R                /* CAN FD Control Register */
#define CAN_0_FDCBT          CAN_0.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_0_FDCRC          CAN_0.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_1_MCR            CAN_1.MCR.R                   /* Module Configuration Register */
#define CAN_1_CTRL1          CAN_1.CTRL1.R                 /* Control 1 register */
#define CAN_1_TIMER          CAN_1.TIMER.R                 /* Free Running Timer */
#define CAN_1_RXMGMASK       CAN_1.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_1_RX14MASK       CAN_1.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_1_RX15MASK       CAN_1.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_1_ECR            CAN_1.ECR.R                   /* Error Counter */
#define CAN_1_ESR1           CAN_1.ESR1.R                  /* Error and Status 1 register */
#define CAN_1_IMASK2         CAN_1.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_1_IMASK1         CAN_1.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_1_IFLAG2         CAN_1.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_1_IFLAG1         CAN_1.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_1_CTRL2          CAN_1.CTRL2.R                 /* Control 2 register */
#define CAN_1_ESR2           CAN_1.ESR2.R                  /* Error and Status 2 register */
#define CAN_1_CRCR           CAN_1.CRCR.R                  /* CRC Register */
#define CAN_1_RXFGMASK       CAN_1.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_1_RXFIR          CAN_1.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_1_CBT            CAN_1.CBT.R                   /* CAN Bit Timing Register */
#define CAN_1_IMASK3         CAN_1.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_1_IFLAG3         CAN_1.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_1_CS0            CAN_1.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_1_ID0            CAN_1.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_1_B0             CAN_1.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_1_H0             CAN_1.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_1_W0             CAN_1.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_1_CS1            CAN_1.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_1_ID1            CAN_1.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_1_B1             CAN_1.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_1_H1             CAN_1.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_1_W1             CAN_1.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_1_CS2            CAN_1.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_1_ID2            CAN_1.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_1_B2             CAN_1.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_1_H2             CAN_1.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_1_W2             CAN_1.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_1_CS3            CAN_1.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_1_ID3            CAN_1.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_1_B3             CAN_1.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_1_H3             CAN_1.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_1_W3             CAN_1.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_1_CS4            CAN_1.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_1_ID4            CAN_1.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_1_B4             CAN_1.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_1_H4             CAN_1.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_1_W4             CAN_1.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_1_CS5            CAN_1.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_1_ID5            CAN_1.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_1_B5             CAN_1.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_1_H5             CAN_1.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_1_W5             CAN_1.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_1_CS6            CAN_1.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_1_ID6            CAN_1.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_1_B6             CAN_1.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_1_H6             CAN_1.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_1_W6             CAN_1.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_1_CS7            CAN_1.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_1_ID7            CAN_1.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_1_B7             CAN_1.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_1_H7             CAN_1.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_1_W7             CAN_1.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_1_CS8            CAN_1.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_1_ID8            CAN_1.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_1_B8             CAN_1.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_1_H8             CAN_1.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_1_W8             CAN_1.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_1_CS9            CAN_1.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_1_ID9            CAN_1.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_1_B9             CAN_1.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_1_H9             CAN_1.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_1_W9             CAN_1.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_1_CS10           CAN_1.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_1_ID10           CAN_1.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_1_B10            CAN_1.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_1_H10            CAN_1.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_1_W10            CAN_1.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_1_CS11           CAN_1.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_1_ID11           CAN_1.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_1_B11            CAN_1.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_1_H11            CAN_1.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_1_W11            CAN_1.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_1_CS12           CAN_1.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_1_ID12           CAN_1.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_1_B12            CAN_1.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_1_H12            CAN_1.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_1_W12            CAN_1.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_1_CS13           CAN_1.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_1_ID13           CAN_1.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_1_B13            CAN_1.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_1_H13            CAN_1.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_1_W13            CAN_1.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_1_CS14           CAN_1.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_1_ID14           CAN_1.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_1_B14            CAN_1.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_1_H14            CAN_1.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_1_W14            CAN_1.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_1_CS15           CAN_1.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_1_ID15           CAN_1.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_1_B15            CAN_1.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_1_H15            CAN_1.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_1_W15            CAN_1.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_1_CS16           CAN_1.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_1_ID16           CAN_1.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_1_B16            CAN_1.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_1_H16            CAN_1.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_1_W16            CAN_1.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_1_CS17           CAN_1.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_1_ID17           CAN_1.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_1_B17            CAN_1.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_1_H17            CAN_1.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_1_W17            CAN_1.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_1_CS18           CAN_1.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_1_ID18           CAN_1.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_1_B18            CAN_1.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_1_H18            CAN_1.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_1_W18            CAN_1.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_1_CS19           CAN_1.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_1_ID19           CAN_1.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_1_B19            CAN_1.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_1_H19            CAN_1.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_1_W19            CAN_1.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_1_CS20           CAN_1.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_1_ID20           CAN_1.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_1_B20            CAN_1.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_1_H20            CAN_1.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_1_W20            CAN_1.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_1_CS21           CAN_1.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_1_ID21           CAN_1.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_1_B21            CAN_1.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_1_H21            CAN_1.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_1_W21            CAN_1.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_1_CS22           CAN_1.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_1_ID22           CAN_1.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_1_B22            CAN_1.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_1_H22            CAN_1.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_1_W22            CAN_1.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_1_CS23           CAN_1.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_1_ID23           CAN_1.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_1_B23            CAN_1.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_1_H23            CAN_1.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_1_W23            CAN_1.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_1_CS24           CAN_1.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_1_ID24           CAN_1.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_1_B24            CAN_1.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_1_H24            CAN_1.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_1_W24            CAN_1.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_1_CS25           CAN_1.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_1_ID25           CAN_1.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_1_B25            CAN_1.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_1_H25            CAN_1.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_1_W25            CAN_1.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_1_CS26           CAN_1.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_1_ID26           CAN_1.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_1_B26            CAN_1.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_1_H26            CAN_1.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_1_W26            CAN_1.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_1_CS27           CAN_1.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_1_ID27           CAN_1.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_1_B27            CAN_1.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_1_H27            CAN_1.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_1_W27            CAN_1.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_1_CS28           CAN_1.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_1_ID28           CAN_1.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_1_B28            CAN_1.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_1_H28            CAN_1.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_1_W28            CAN_1.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_1_CS29           CAN_1.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_1_ID29           CAN_1.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_1_B29            CAN_1.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_1_H29            CAN_1.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_1_W29            CAN_1.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_1_CS30           CAN_1.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_1_ID30           CAN_1.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_1_B30            CAN_1.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_1_H30            CAN_1.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_1_W30            CAN_1.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_1_CS31           CAN_1.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_1_ID31           CAN_1.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_1_B31            CAN_1.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_1_H31            CAN_1.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_1_W31            CAN_1.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_1_CS32           CAN_1.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_1_ID32           CAN_1.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_1_B32            CAN_1.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_1_H32            CAN_1.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_1_W32            CAN_1.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_1_CS33           CAN_1.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_1_ID33           CAN_1.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_1_B33            CAN_1.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_1_H33            CAN_1.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_1_W33            CAN_1.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_1_CS34           CAN_1.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_1_ID34           CAN_1.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_1_B34            CAN_1.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_1_H34            CAN_1.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_1_W34            CAN_1.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_1_CS35           CAN_1.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_1_ID35           CAN_1.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_1_B35            CAN_1.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_1_H35            CAN_1.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_1_W35            CAN_1.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_1_CS36           CAN_1.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_1_ID36           CAN_1.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_1_B36            CAN_1.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_1_H36            CAN_1.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_1_W36            CAN_1.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_1_CS37           CAN_1.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_1_ID37           CAN_1.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_1_B37            CAN_1.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_1_H37            CAN_1.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_1_W37            CAN_1.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_1_CS38           CAN_1.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_1_ID38           CAN_1.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_1_B38            CAN_1.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_1_H38            CAN_1.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_1_W38            CAN_1.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_1_CS39           CAN_1.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_1_ID39           CAN_1.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_1_B39            CAN_1.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_1_H39            CAN_1.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_1_W39            CAN_1.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_1_CS40           CAN_1.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_1_ID40           CAN_1.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_1_B40            CAN_1.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_1_H40            CAN_1.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_1_W40            CAN_1.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_1_CS41           CAN_1.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_1_ID41           CAN_1.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_1_B41            CAN_1.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_1_H41            CAN_1.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_1_W41            CAN_1.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_1_CS42           CAN_1.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_1_ID42           CAN_1.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_1_B42            CAN_1.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_1_H42            CAN_1.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_1_W42            CAN_1.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_1_CS43           CAN_1.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_1_ID43           CAN_1.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_1_B43            CAN_1.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_1_H43            CAN_1.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_1_W43            CAN_1.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_1_CS44           CAN_1.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_1_ID44           CAN_1.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_1_B44            CAN_1.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_1_H44            CAN_1.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_1_W44            CAN_1.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_1_CS45           CAN_1.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_1_ID45           CAN_1.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_1_B45            CAN_1.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_1_H45            CAN_1.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_1_W45            CAN_1.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_1_CS46           CAN_1.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_1_ID46           CAN_1.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_1_B46            CAN_1.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_1_H46            CAN_1.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_1_W46            CAN_1.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_1_CS47           CAN_1.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_1_ID47           CAN_1.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_1_B47            CAN_1.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_1_H47            CAN_1.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_1_W47            CAN_1.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_1_CS48           CAN_1.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_1_ID48           CAN_1.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_1_B48            CAN_1.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_1_H48            CAN_1.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_1_W48            CAN_1.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_1_CS49           CAN_1.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_1_ID49           CAN_1.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_1_B49            CAN_1.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_1_H49            CAN_1.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_1_W49            CAN_1.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_1_CS50           CAN_1.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_1_ID50           CAN_1.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_1_B50            CAN_1.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_1_H50            CAN_1.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_1_W50            CAN_1.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_1_CS51           CAN_1.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_1_ID51           CAN_1.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_1_B51            CAN_1.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_1_H51            CAN_1.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_1_W51            CAN_1.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_1_CS52           CAN_1.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_1_ID52           CAN_1.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_1_B52            CAN_1.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_1_H52            CAN_1.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_1_W52            CAN_1.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_1_CS53           CAN_1.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_1_ID53           CAN_1.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_1_B53            CAN_1.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_1_H53            CAN_1.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_1_W53            CAN_1.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_1_CS54           CAN_1.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_1_ID54           CAN_1.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_1_B54            CAN_1.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_1_H54            CAN_1.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_1_W54            CAN_1.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_1_CS55           CAN_1.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_1_ID55           CAN_1.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_1_B55            CAN_1.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_1_H55            CAN_1.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_1_W55            CAN_1.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_1_CS56           CAN_1.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_1_ID56           CAN_1.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_1_B56            CAN_1.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_1_H56            CAN_1.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_1_W56            CAN_1.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_1_CS57           CAN_1.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_1_ID57           CAN_1.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_1_B57            CAN_1.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_1_H57            CAN_1.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_1_W57            CAN_1.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_1_CS58           CAN_1.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_1_ID58           CAN_1.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_1_B58            CAN_1.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_1_H58            CAN_1.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_1_W58            CAN_1.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_1_CS59           CAN_1.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_1_ID59           CAN_1.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_1_B59            CAN_1.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_1_H59            CAN_1.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_1_W59            CAN_1.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_1_CS60           CAN_1.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_1_ID60           CAN_1.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_1_B60            CAN_1.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_1_H60            CAN_1.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_1_W60            CAN_1.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_1_CS61           CAN_1.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_1_ID61           CAN_1.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_1_B61            CAN_1.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_1_H61            CAN_1.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_1_W61            CAN_1.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_1_CS62           CAN_1.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_1_ID62           CAN_1.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_1_B62            CAN_1.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_1_H62            CAN_1.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_1_W62            CAN_1.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_1_CS63           CAN_1.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_1_ID63           CAN_1.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_1_B63            CAN_1.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_1_H63            CAN_1.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_1_W63            CAN_1.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_1_RXIMR0         CAN_1.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR1         CAN_1.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR2         CAN_1.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR3         CAN_1.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR4         CAN_1.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR5         CAN_1.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR6         CAN_1.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR7         CAN_1.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR8         CAN_1.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR9         CAN_1.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR10        CAN_1.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR11        CAN_1.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR12        CAN_1.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR13        CAN_1.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR14        CAN_1.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR15        CAN_1.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR16        CAN_1.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR17        CAN_1.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR18        CAN_1.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR19        CAN_1.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR20        CAN_1.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR21        CAN_1.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR22        CAN_1.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR23        CAN_1.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR24        CAN_1.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR25        CAN_1.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR26        CAN_1.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR27        CAN_1.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR28        CAN_1.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR29        CAN_1.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR30        CAN_1.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR31        CAN_1.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR32        CAN_1.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR33        CAN_1.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR34        CAN_1.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR35        CAN_1.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR36        CAN_1.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR37        CAN_1.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR38        CAN_1.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR39        CAN_1.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR40        CAN_1.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR41        CAN_1.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR42        CAN_1.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR43        CAN_1.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR44        CAN_1.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR45        CAN_1.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR46        CAN_1.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR47        CAN_1.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR48        CAN_1.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR49        CAN_1.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR50        CAN_1.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR51        CAN_1.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR52        CAN_1.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR53        CAN_1.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR54        CAN_1.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR55        CAN_1.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR56        CAN_1.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR57        CAN_1.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR58        CAN_1.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR59        CAN_1.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR60        CAN_1.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR61        CAN_1.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR62        CAN_1.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR63        CAN_1.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR64        CAN_1.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR65        CAN_1.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR66        CAN_1.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR67        CAN_1.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR68        CAN_1.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR69        CAN_1.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR70        CAN_1.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR71        CAN_1.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR72        CAN_1.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR73        CAN_1.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR74        CAN_1.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR75        CAN_1.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR76        CAN_1.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR77        CAN_1.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR78        CAN_1.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR79        CAN_1.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR80        CAN_1.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR81        CAN_1.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR82        CAN_1.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR83        CAN_1.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR84        CAN_1.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR85        CAN_1.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR86        CAN_1.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR87        CAN_1.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR88        CAN_1.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR89        CAN_1.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR90        CAN_1.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR91        CAN_1.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR92        CAN_1.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR93        CAN_1.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR94        CAN_1.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR95        CAN_1.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_1_MECR           CAN_1.MECR.R                  /* Memory Error Control Register */
#define CAN_1_ERRIAR         CAN_1.ERRIAR.R                /* Error Injection Address Register */
#define CAN_1_ERRIDPR        CAN_1.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_1_ERRIPPR        CAN_1.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_1_RERRAR         CAN_1.RERRAR.R                /* Error Report Address Register */
#define CAN_1_RERRDR         CAN_1.RERRDR.R                /* Error Report Data Register */
#define CAN_1_RERRSYNR       CAN_1.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_1_ERRSR          CAN_1.ERRSR.R                 /* Error Status Register */
#define CAN_1_FDCTRL         CAN_1.FDCTRL.R                /* CAN FD Control Register */
#define CAN_1_FDCBT          CAN_1.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_1_FDCRC          CAN_1.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_2_MCR            CAN_2.MCR.R                   /* Module Configuration Register */
#define CAN_2_CTRL1          CAN_2.CTRL1.R                 /* Control 1 register */
#define CAN_2_TIMER          CAN_2.TIMER.R                 /* Free Running Timer */
#define CAN_2_RXMGMASK       CAN_2.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_2_RX14MASK       CAN_2.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_2_RX15MASK       CAN_2.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_2_ECR            CAN_2.ECR.R                   /* Error Counter */
#define CAN_2_ESR1           CAN_2.ESR1.R                  /* Error and Status 1 register */
#define CAN_2_IMASK2         CAN_2.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_2_IMASK1         CAN_2.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_2_IFLAG2         CAN_2.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_2_IFLAG1         CAN_2.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_2_CTRL2          CAN_2.CTRL2.R                 /* Control 2 register */
#define CAN_2_ESR2           CAN_2.ESR2.R                  /* Error and Status 2 register */
#define CAN_2_CRCR           CAN_2.CRCR.R                  /* CRC Register */
#define CAN_2_RXFGMASK       CAN_2.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_2_RXFIR          CAN_2.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_2_CBT            CAN_2.CBT.R                   /* CAN Bit Timing Register */
#define CAN_2_IMASK3         CAN_2.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_2_IFLAG3         CAN_2.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_2_CS0            CAN_2.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_2_ID0            CAN_2.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_2_B0             CAN_2.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_2_H0             CAN_2.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_2_W0             CAN_2.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_2_CS1            CAN_2.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_2_ID1            CAN_2.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_2_B1             CAN_2.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_2_H1             CAN_2.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_2_W1             CAN_2.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_2_CS2            CAN_2.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_2_ID2            CAN_2.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_2_B2             CAN_2.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_2_H2             CAN_2.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_2_W2             CAN_2.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_2_CS3            CAN_2.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_2_ID3            CAN_2.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_2_B3             CAN_2.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_2_H3             CAN_2.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_2_W3             CAN_2.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_2_CS4            CAN_2.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_2_ID4            CAN_2.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_2_B4             CAN_2.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_2_H4             CAN_2.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_2_W4             CAN_2.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_2_CS5            CAN_2.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_2_ID5            CAN_2.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_2_B5             CAN_2.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_2_H5             CAN_2.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_2_W5             CAN_2.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_2_CS6            CAN_2.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_2_ID6            CAN_2.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_2_B6             CAN_2.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_2_H6             CAN_2.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_2_W6             CAN_2.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_2_CS7            CAN_2.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_2_ID7            CAN_2.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_2_B7             CAN_2.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_2_H7             CAN_2.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_2_W7             CAN_2.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_2_CS8            CAN_2.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_2_ID8            CAN_2.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_2_B8             CAN_2.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_2_H8             CAN_2.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_2_W8             CAN_2.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_2_CS9            CAN_2.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_2_ID9            CAN_2.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_2_B9             CAN_2.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_2_H9             CAN_2.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_2_W9             CAN_2.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_2_CS10           CAN_2.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_2_ID10           CAN_2.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_2_B10            CAN_2.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_2_H10            CAN_2.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_2_W10            CAN_2.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_2_CS11           CAN_2.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_2_ID11           CAN_2.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_2_B11            CAN_2.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_2_H11            CAN_2.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_2_W11            CAN_2.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_2_CS12           CAN_2.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_2_ID12           CAN_2.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_2_B12            CAN_2.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_2_H12            CAN_2.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_2_W12            CAN_2.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_2_CS13           CAN_2.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_2_ID13           CAN_2.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_2_B13            CAN_2.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_2_H13            CAN_2.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_2_W13            CAN_2.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_2_CS14           CAN_2.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_2_ID14           CAN_2.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_2_B14            CAN_2.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_2_H14            CAN_2.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_2_W14            CAN_2.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_2_CS15           CAN_2.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_2_ID15           CAN_2.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_2_B15            CAN_2.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_2_H15            CAN_2.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_2_W15            CAN_2.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_2_CS16           CAN_2.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_2_ID16           CAN_2.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_2_B16            CAN_2.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_2_H16            CAN_2.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_2_W16            CAN_2.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_2_CS17           CAN_2.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_2_ID17           CAN_2.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_2_B17            CAN_2.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_2_H17            CAN_2.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_2_W17            CAN_2.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_2_CS18           CAN_2.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_2_ID18           CAN_2.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_2_B18            CAN_2.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_2_H18            CAN_2.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_2_W18            CAN_2.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_2_CS19           CAN_2.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_2_ID19           CAN_2.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_2_B19            CAN_2.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_2_H19            CAN_2.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_2_W19            CAN_2.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_2_CS20           CAN_2.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_2_ID20           CAN_2.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_2_B20            CAN_2.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_2_H20            CAN_2.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_2_W20            CAN_2.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_2_CS21           CAN_2.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_2_ID21           CAN_2.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_2_B21            CAN_2.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_2_H21            CAN_2.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_2_W21            CAN_2.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_2_CS22           CAN_2.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_2_ID22           CAN_2.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_2_B22            CAN_2.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_2_H22            CAN_2.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_2_W22            CAN_2.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_2_CS23           CAN_2.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_2_ID23           CAN_2.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_2_B23            CAN_2.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_2_H23            CAN_2.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_2_W23            CAN_2.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_2_CS24           CAN_2.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_2_ID24           CAN_2.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_2_B24            CAN_2.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_2_H24            CAN_2.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_2_W24            CAN_2.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_2_CS25           CAN_2.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_2_ID25           CAN_2.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_2_B25            CAN_2.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_2_H25            CAN_2.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_2_W25            CAN_2.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_2_CS26           CAN_2.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_2_ID26           CAN_2.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_2_B26            CAN_2.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_2_H26            CAN_2.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_2_W26            CAN_2.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_2_CS27           CAN_2.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_2_ID27           CAN_2.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_2_B27            CAN_2.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_2_H27            CAN_2.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_2_W27            CAN_2.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_2_CS28           CAN_2.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_2_ID28           CAN_2.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_2_B28            CAN_2.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_2_H28            CAN_2.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_2_W28            CAN_2.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_2_CS29           CAN_2.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_2_ID29           CAN_2.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_2_B29            CAN_2.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_2_H29            CAN_2.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_2_W29            CAN_2.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_2_CS30           CAN_2.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_2_ID30           CAN_2.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_2_B30            CAN_2.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_2_H30            CAN_2.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_2_W30            CAN_2.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_2_CS31           CAN_2.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_2_ID31           CAN_2.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_2_B31            CAN_2.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_2_H31            CAN_2.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_2_W31            CAN_2.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_2_CS32           CAN_2.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_2_ID32           CAN_2.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_2_B32            CAN_2.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_2_H32            CAN_2.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_2_W32            CAN_2.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_2_CS33           CAN_2.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_2_ID33           CAN_2.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_2_B33            CAN_2.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_2_H33            CAN_2.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_2_W33            CAN_2.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_2_CS34           CAN_2.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_2_ID34           CAN_2.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_2_B34            CAN_2.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_2_H34            CAN_2.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_2_W34            CAN_2.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_2_CS35           CAN_2.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_2_ID35           CAN_2.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_2_B35            CAN_2.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_2_H35            CAN_2.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_2_W35            CAN_2.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_2_CS36           CAN_2.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_2_ID36           CAN_2.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_2_B36            CAN_2.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_2_H36            CAN_2.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_2_W36            CAN_2.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_2_CS37           CAN_2.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_2_ID37           CAN_2.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_2_B37            CAN_2.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_2_H37            CAN_2.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_2_W37            CAN_2.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_2_CS38           CAN_2.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_2_ID38           CAN_2.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_2_B38            CAN_2.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_2_H38            CAN_2.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_2_W38            CAN_2.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_2_CS39           CAN_2.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_2_ID39           CAN_2.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_2_B39            CAN_2.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_2_H39            CAN_2.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_2_W39            CAN_2.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_2_CS40           CAN_2.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_2_ID40           CAN_2.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_2_B40            CAN_2.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_2_H40            CAN_2.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_2_W40            CAN_2.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_2_CS41           CAN_2.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_2_ID41           CAN_2.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_2_B41            CAN_2.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_2_H41            CAN_2.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_2_W41            CAN_2.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_2_CS42           CAN_2.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_2_ID42           CAN_2.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_2_B42            CAN_2.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_2_H42            CAN_2.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_2_W42            CAN_2.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_2_CS43           CAN_2.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_2_ID43           CAN_2.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_2_B43            CAN_2.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_2_H43            CAN_2.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_2_W43            CAN_2.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_2_CS44           CAN_2.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_2_ID44           CAN_2.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_2_B44            CAN_2.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_2_H44            CAN_2.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_2_W44            CAN_2.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_2_CS45           CAN_2.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_2_ID45           CAN_2.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_2_B45            CAN_2.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_2_H45            CAN_2.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_2_W45            CAN_2.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_2_CS46           CAN_2.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_2_ID46           CAN_2.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_2_B46            CAN_2.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_2_H46            CAN_2.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_2_W46            CAN_2.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_2_CS47           CAN_2.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_2_ID47           CAN_2.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_2_B47            CAN_2.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_2_H47            CAN_2.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_2_W47            CAN_2.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_2_CS48           CAN_2.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_2_ID48           CAN_2.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_2_B48            CAN_2.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_2_H48            CAN_2.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_2_W48            CAN_2.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_2_CS49           CAN_2.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_2_ID49           CAN_2.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_2_B49            CAN_2.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_2_H49            CAN_2.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_2_W49            CAN_2.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_2_CS50           CAN_2.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_2_ID50           CAN_2.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_2_B50            CAN_2.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_2_H50            CAN_2.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_2_W50            CAN_2.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_2_CS51           CAN_2.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_2_ID51           CAN_2.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_2_B51            CAN_2.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_2_H51            CAN_2.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_2_W51            CAN_2.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_2_CS52           CAN_2.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_2_ID52           CAN_2.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_2_B52            CAN_2.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_2_H52            CAN_2.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_2_W52            CAN_2.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_2_CS53           CAN_2.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_2_ID53           CAN_2.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_2_B53            CAN_2.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_2_H53            CAN_2.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_2_W53            CAN_2.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_2_CS54           CAN_2.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_2_ID54           CAN_2.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_2_B54            CAN_2.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_2_H54            CAN_2.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_2_W54            CAN_2.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_2_CS55           CAN_2.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_2_ID55           CAN_2.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_2_B55            CAN_2.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_2_H55            CAN_2.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_2_W55            CAN_2.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_2_CS56           CAN_2.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_2_ID56           CAN_2.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_2_B56            CAN_2.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_2_H56            CAN_2.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_2_W56            CAN_2.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_2_CS57           CAN_2.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_2_ID57           CAN_2.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_2_B57            CAN_2.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_2_H57            CAN_2.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_2_W57            CAN_2.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_2_CS58           CAN_2.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_2_ID58           CAN_2.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_2_B58            CAN_2.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_2_H58            CAN_2.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_2_W58            CAN_2.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_2_CS59           CAN_2.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_2_ID59           CAN_2.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_2_B59            CAN_2.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_2_H59            CAN_2.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_2_W59            CAN_2.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_2_CS60           CAN_2.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_2_ID60           CAN_2.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_2_B60            CAN_2.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_2_H60            CAN_2.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_2_W60            CAN_2.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_2_CS61           CAN_2.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_2_ID61           CAN_2.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_2_B61            CAN_2.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_2_H61            CAN_2.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_2_W61            CAN_2.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_2_CS62           CAN_2.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_2_ID62           CAN_2.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_2_B62            CAN_2.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_2_H62            CAN_2.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_2_W62            CAN_2.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_2_CS63           CAN_2.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_2_ID63           CAN_2.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_2_B63            CAN_2.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_2_H63            CAN_2.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_2_W63            CAN_2.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_2_RXIMR0         CAN_2.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR1         CAN_2.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR2         CAN_2.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR3         CAN_2.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR4         CAN_2.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR5         CAN_2.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR6         CAN_2.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR7         CAN_2.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR8         CAN_2.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR9         CAN_2.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR10        CAN_2.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR11        CAN_2.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR12        CAN_2.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR13        CAN_2.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR14        CAN_2.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR15        CAN_2.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR16        CAN_2.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR17        CAN_2.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR18        CAN_2.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR19        CAN_2.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR20        CAN_2.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR21        CAN_2.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR22        CAN_2.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR23        CAN_2.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR24        CAN_2.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR25        CAN_2.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR26        CAN_2.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR27        CAN_2.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR28        CAN_2.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR29        CAN_2.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR30        CAN_2.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR31        CAN_2.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR32        CAN_2.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR33        CAN_2.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR34        CAN_2.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR35        CAN_2.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR36        CAN_2.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR37        CAN_2.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR38        CAN_2.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR39        CAN_2.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR40        CAN_2.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR41        CAN_2.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR42        CAN_2.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR43        CAN_2.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR44        CAN_2.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR45        CAN_2.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR46        CAN_2.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR47        CAN_2.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR48        CAN_2.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR49        CAN_2.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR50        CAN_2.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR51        CAN_2.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR52        CAN_2.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR53        CAN_2.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR54        CAN_2.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR55        CAN_2.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR56        CAN_2.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR57        CAN_2.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR58        CAN_2.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR59        CAN_2.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR60        CAN_2.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR61        CAN_2.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR62        CAN_2.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR63        CAN_2.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR64        CAN_2.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR65        CAN_2.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR66        CAN_2.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR67        CAN_2.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR68        CAN_2.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR69        CAN_2.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR70        CAN_2.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR71        CAN_2.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR72        CAN_2.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR73        CAN_2.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR74        CAN_2.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR75        CAN_2.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR76        CAN_2.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR77        CAN_2.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR78        CAN_2.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR79        CAN_2.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR80        CAN_2.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR81        CAN_2.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR82        CAN_2.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR83        CAN_2.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR84        CAN_2.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR85        CAN_2.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR86        CAN_2.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR87        CAN_2.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR88        CAN_2.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR89        CAN_2.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR90        CAN_2.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR91        CAN_2.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR92        CAN_2.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR93        CAN_2.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR94        CAN_2.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR95        CAN_2.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_2_MECR           CAN_2.MECR.R                  /* Memory Error Control Register */
#define CAN_2_ERRIAR         CAN_2.ERRIAR.R                /* Error Injection Address Register */
#define CAN_2_ERRIDPR        CAN_2.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_2_ERRIPPR        CAN_2.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_2_RERRAR         CAN_2.RERRAR.R                /* Error Report Address Register */
#define CAN_2_RERRDR         CAN_2.RERRDR.R                /* Error Report Data Register */
#define CAN_2_RERRSYNR       CAN_2.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_2_ERRSR          CAN_2.ERRSR.R                 /* Error Status Register */
#define CAN_2_FDCTRL         CAN_2.FDCTRL.R                /* CAN FD Control Register */
#define CAN_2_FDCBT          CAN_2.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_2_FDCRC          CAN_2.FDCRC.R                 /* CAN FD CRC Register */

#define CAN_3_MCR            CAN_3.MCR.R                   /* Module Configuration Register */
#define CAN_3_CTRL1          CAN_3.CTRL1.R                 /* Control 1 register */
#define CAN_3_TIMER          CAN_3.TIMER.R                 /* Free Running Timer */
#define CAN_3_RXMGMASK       CAN_3.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_3_RX14MASK       CAN_3.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_3_RX15MASK       CAN_3.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_3_ECR            CAN_3.ECR.R                   /* Error Counter */
#define CAN_3_ESR1           CAN_3.ESR1.R                  /* Error and Status 1 register */
#define CAN_3_IMASK2         CAN_3.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_3_IMASK1         CAN_3.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_3_IFLAG2         CAN_3.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_3_IFLAG1         CAN_3.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_3_CTRL2          CAN_3.CTRL2.R                 /* Control 2 register */
#define CAN_3_ESR2           CAN_3.ESR2.R                  /* Error and Status 2 register */
#define CAN_3_CRCR           CAN_3.CRCR.R                  /* CRC Register */
#define CAN_3_RXFGMASK       CAN_3.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_3_RXFIR          CAN_3.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_3_CBT            CAN_3.CBT.R                   /* CAN Bit Timing Register */
#define CAN_3_IMASK3         CAN_3.IMASK3.R                /* Interrupt Masks 3 Register */
#define CAN_3_IFLAG3         CAN_3.IFLAG3.R                /* Interrupt Flags 3 Register */
#define CAN_3_CS0            CAN_3.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_3_ID0            CAN_3.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_3_B0             CAN_3.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_3_H0             CAN_3.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_3_W0             CAN_3.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_3_CS1            CAN_3.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_3_ID1            CAN_3.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_3_B1             CAN_3.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_3_H1             CAN_3.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_3_W1             CAN_3.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_3_CS2            CAN_3.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_3_ID2            CAN_3.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_3_B2             CAN_3.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_3_H2             CAN_3.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_3_W2             CAN_3.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_3_CS3            CAN_3.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_3_ID3            CAN_3.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_3_B3             CAN_3.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_3_H3             CAN_3.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_3_W3             CAN_3.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_3_CS4            CAN_3.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_3_ID4            CAN_3.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_3_B4             CAN_3.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_3_H4             CAN_3.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_3_W4             CAN_3.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_3_CS5            CAN_3.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_3_ID5            CAN_3.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_3_B5             CAN_3.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_3_H5             CAN_3.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_3_W5             CAN_3.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_3_CS6            CAN_3.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_3_ID6            CAN_3.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_3_B6             CAN_3.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_3_H6             CAN_3.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_3_W6             CAN_3.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_3_CS7            CAN_3.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_3_ID7            CAN_3.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_3_B7             CAN_3.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_3_H7             CAN_3.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_3_W7             CAN_3.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_3_CS8            CAN_3.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_3_ID8            CAN_3.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_3_B8             CAN_3.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_3_H8             CAN_3.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_3_W8             CAN_3.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_3_CS9            CAN_3.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_3_ID9            CAN_3.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_3_B9             CAN_3.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_3_H9             CAN_3.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_3_W9             CAN_3.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_3_CS10           CAN_3.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_3_ID10           CAN_3.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_3_B10            CAN_3.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_3_H10            CAN_3.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_3_W10            CAN_3.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_3_CS11           CAN_3.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_3_ID11           CAN_3.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_3_B11            CAN_3.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_3_H11            CAN_3.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_3_W11            CAN_3.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_3_CS12           CAN_3.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_3_ID12           CAN_3.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_3_B12            CAN_3.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_3_H12            CAN_3.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_3_W12            CAN_3.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_3_CS13           CAN_3.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_3_ID13           CAN_3.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_3_B13            CAN_3.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_3_H13            CAN_3.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_3_W13            CAN_3.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_3_CS14           CAN_3.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_3_ID14           CAN_3.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_3_B14            CAN_3.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_3_H14            CAN_3.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_3_W14            CAN_3.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_3_CS15           CAN_3.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_3_ID15           CAN_3.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_3_B15            CAN_3.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_3_H15            CAN_3.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_3_W15            CAN_3.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_3_CS16           CAN_3.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_3_ID16           CAN_3.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_3_B16            CAN_3.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_3_H16            CAN_3.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_3_W16            CAN_3.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_3_CS17           CAN_3.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_3_ID17           CAN_3.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_3_B17            CAN_3.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_3_H17            CAN_3.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_3_W17            CAN_3.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_3_CS18           CAN_3.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_3_ID18           CAN_3.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_3_B18            CAN_3.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_3_H18            CAN_3.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_3_W18            CAN_3.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_3_CS19           CAN_3.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_3_ID19           CAN_3.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_3_B19            CAN_3.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_3_H19            CAN_3.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_3_W19            CAN_3.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_3_CS20           CAN_3.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_3_ID20           CAN_3.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_3_B20            CAN_3.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_3_H20            CAN_3.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_3_W20            CAN_3.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_3_CS21           CAN_3.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_3_ID21           CAN_3.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_3_B21            CAN_3.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_3_H21            CAN_3.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_3_W21            CAN_3.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_3_CS22           CAN_3.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_3_ID22           CAN_3.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_3_B22            CAN_3.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_3_H22            CAN_3.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_3_W22            CAN_3.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_3_CS23           CAN_3.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_3_ID23           CAN_3.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_3_B23            CAN_3.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_3_H23            CAN_3.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_3_W23            CAN_3.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_3_CS24           CAN_3.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_3_ID24           CAN_3.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_3_B24            CAN_3.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_3_H24            CAN_3.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_3_W24            CAN_3.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_3_CS25           CAN_3.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_3_ID25           CAN_3.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_3_B25            CAN_3.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_3_H25            CAN_3.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_3_W25            CAN_3.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_3_CS26           CAN_3.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_3_ID26           CAN_3.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_3_B26            CAN_3.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_3_H26            CAN_3.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_3_W26            CAN_3.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_3_CS27           CAN_3.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_3_ID27           CAN_3.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_3_B27            CAN_3.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_3_H27            CAN_3.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_3_W27            CAN_3.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_3_CS28           CAN_3.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_3_ID28           CAN_3.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_3_B28            CAN_3.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_3_H28            CAN_3.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_3_W28            CAN_3.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_3_CS29           CAN_3.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_3_ID29           CAN_3.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_3_B29            CAN_3.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_3_H29            CAN_3.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_3_W29            CAN_3.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_3_CS30           CAN_3.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_3_ID30           CAN_3.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_3_B30            CAN_3.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_3_H30            CAN_3.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_3_W30            CAN_3.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_3_CS31           CAN_3.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_3_ID31           CAN_3.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_3_B31            CAN_3.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_3_H31            CAN_3.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_3_W31            CAN_3.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_3_CS32           CAN_3.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_3_ID32           CAN_3.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_3_B32            CAN_3.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_3_H32            CAN_3.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_3_W32            CAN_3.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_3_CS33           CAN_3.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_3_ID33           CAN_3.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_3_B33            CAN_3.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_3_H33            CAN_3.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_3_W33            CAN_3.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_3_CS34           CAN_3.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_3_ID34           CAN_3.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_3_B34            CAN_3.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_3_H34            CAN_3.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_3_W34            CAN_3.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_3_CS35           CAN_3.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_3_ID35           CAN_3.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_3_B35            CAN_3.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_3_H35            CAN_3.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_3_W35            CAN_3.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_3_CS36           CAN_3.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_3_ID36           CAN_3.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_3_B36            CAN_3.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_3_H36            CAN_3.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_3_W36            CAN_3.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_3_CS37           CAN_3.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_3_ID37           CAN_3.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_3_B37            CAN_3.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_3_H37            CAN_3.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_3_W37            CAN_3.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_3_CS38           CAN_3.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_3_ID38           CAN_3.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_3_B38            CAN_3.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_3_H38            CAN_3.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_3_W38            CAN_3.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_3_CS39           CAN_3.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_3_ID39           CAN_3.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_3_B39            CAN_3.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_3_H39            CAN_3.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_3_W39            CAN_3.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_3_CS40           CAN_3.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_3_ID40           CAN_3.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_3_B40            CAN_3.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_3_H40            CAN_3.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_3_W40            CAN_3.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_3_CS41           CAN_3.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_3_ID41           CAN_3.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_3_B41            CAN_3.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_3_H41            CAN_3.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_3_W41            CAN_3.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_3_CS42           CAN_3.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_3_ID42           CAN_3.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_3_B42            CAN_3.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_3_H42            CAN_3.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_3_W42            CAN_3.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_3_CS43           CAN_3.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_3_ID43           CAN_3.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_3_B43            CAN_3.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_3_H43            CAN_3.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_3_W43            CAN_3.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_3_CS44           CAN_3.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_3_ID44           CAN_3.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_3_B44            CAN_3.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_3_H44            CAN_3.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_3_W44            CAN_3.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_3_CS45           CAN_3.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_3_ID45           CAN_3.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_3_B45            CAN_3.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_3_H45            CAN_3.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_3_W45            CAN_3.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_3_CS46           CAN_3.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_3_ID46           CAN_3.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_3_B46            CAN_3.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_3_H46            CAN_3.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_3_W46            CAN_3.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_3_CS47           CAN_3.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_3_ID47           CAN_3.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_3_B47            CAN_3.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_3_H47            CAN_3.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_3_W47            CAN_3.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_3_CS48           CAN_3.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_3_ID48           CAN_3.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_3_B48            CAN_3.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_3_H48            CAN_3.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_3_W48            CAN_3.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_3_CS49           CAN_3.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_3_ID49           CAN_3.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_3_B49            CAN_3.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_3_H49            CAN_3.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_3_W49            CAN_3.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_3_CS50           CAN_3.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_3_ID50           CAN_3.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_3_B50            CAN_3.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_3_H50            CAN_3.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_3_W50            CAN_3.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_3_CS51           CAN_3.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_3_ID51           CAN_3.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_3_B51            CAN_3.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_3_H51            CAN_3.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_3_W51            CAN_3.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_3_CS52           CAN_3.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_3_ID52           CAN_3.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_3_B52            CAN_3.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_3_H52            CAN_3.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_3_W52            CAN_3.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_3_CS53           CAN_3.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_3_ID53           CAN_3.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_3_B53            CAN_3.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_3_H53            CAN_3.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_3_W53            CAN_3.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_3_CS54           CAN_3.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_3_ID54           CAN_3.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_3_B54            CAN_3.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_3_H54            CAN_3.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_3_W54            CAN_3.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_3_CS55           CAN_3.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_3_ID55           CAN_3.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_3_B55            CAN_3.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_3_H55            CAN_3.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_3_W55            CAN_3.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_3_CS56           CAN_3.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_3_ID56           CAN_3.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_3_B56            CAN_3.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_3_H56            CAN_3.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_3_W56            CAN_3.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_3_CS57           CAN_3.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_3_ID57           CAN_3.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_3_B57            CAN_3.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_3_H57            CAN_3.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_3_W57            CAN_3.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_3_CS58           CAN_3.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_3_ID58           CAN_3.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_3_B58            CAN_3.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_3_H58            CAN_3.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_3_W58            CAN_3.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_3_CS59           CAN_3.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_3_ID59           CAN_3.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_3_B59            CAN_3.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_3_H59            CAN_3.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_3_W59            CAN_3.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_3_CS60           CAN_3.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_3_ID60           CAN_3.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_3_B60            CAN_3.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_3_H60            CAN_3.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_3_W60            CAN_3.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_3_CS61           CAN_3.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_3_ID61           CAN_3.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_3_B61            CAN_3.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_3_H61            CAN_3.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_3_W61            CAN_3.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_3_CS62           CAN_3.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_3_ID62           CAN_3.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_3_B62            CAN_3.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_3_H62            CAN_3.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_3_W62            CAN_3.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_3_CS63           CAN_3.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_3_ID63           CAN_3.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_3_B63            CAN_3.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_3_H63            CAN_3.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_3_W63            CAN_3.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_3_RXIMR0         CAN_3.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR1         CAN_3.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR2         CAN_3.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR3         CAN_3.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR4         CAN_3.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR5         CAN_3.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR6         CAN_3.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR7         CAN_3.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR8         CAN_3.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR9         CAN_3.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR10        CAN_3.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR11        CAN_3.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR12        CAN_3.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR13        CAN_3.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR14        CAN_3.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR15        CAN_3.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR16        CAN_3.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR17        CAN_3.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR18        CAN_3.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR19        CAN_3.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR20        CAN_3.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR21        CAN_3.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR22        CAN_3.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR23        CAN_3.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR24        CAN_3.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR25        CAN_3.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR26        CAN_3.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR27        CAN_3.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR28        CAN_3.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR29        CAN_3.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR30        CAN_3.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR31        CAN_3.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR32        CAN_3.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR33        CAN_3.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR34        CAN_3.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR35        CAN_3.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR36        CAN_3.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR37        CAN_3.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR38        CAN_3.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR39        CAN_3.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR40        CAN_3.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR41        CAN_3.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR42        CAN_3.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR43        CAN_3.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR44        CAN_3.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR45        CAN_3.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR46        CAN_3.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR47        CAN_3.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR48        CAN_3.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR49        CAN_3.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR50        CAN_3.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR51        CAN_3.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR52        CAN_3.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR53        CAN_3.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR54        CAN_3.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR55        CAN_3.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR56        CAN_3.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR57        CAN_3.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR58        CAN_3.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR59        CAN_3.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR60        CAN_3.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR61        CAN_3.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR62        CAN_3.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR63        CAN_3.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR64        CAN_3.RXIMR[64].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR65        CAN_3.RXIMR[65].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR66        CAN_3.RXIMR[66].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR67        CAN_3.RXIMR[67].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR68        CAN_3.RXIMR[68].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR69        CAN_3.RXIMR[69].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR70        CAN_3.RXIMR[70].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR71        CAN_3.RXIMR[71].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR72        CAN_3.RXIMR[72].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR73        CAN_3.RXIMR[73].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR74        CAN_3.RXIMR[74].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR75        CAN_3.RXIMR[75].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR76        CAN_3.RXIMR[76].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR77        CAN_3.RXIMR[77].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR78        CAN_3.RXIMR[78].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR79        CAN_3.RXIMR[79].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR80        CAN_3.RXIMR[80].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR81        CAN_3.RXIMR[81].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR82        CAN_3.RXIMR[82].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR83        CAN_3.RXIMR[83].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR84        CAN_3.RXIMR[84].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR85        CAN_3.RXIMR[85].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR86        CAN_3.RXIMR[86].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR87        CAN_3.RXIMR[87].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR88        CAN_3.RXIMR[88].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR89        CAN_3.RXIMR[89].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR90        CAN_3.RXIMR[90].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR91        CAN_3.RXIMR[91].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR92        CAN_3.RXIMR[92].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR93        CAN_3.RXIMR[93].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR94        CAN_3.RXIMR[94].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR95        CAN_3.RXIMR[95].R             /* Rx Individual Mask Registers */
#define CAN_3_MECR           CAN_3.MECR.R                  /* Memory Error Control Register */
#define CAN_3_ERRIAR         CAN_3.ERRIAR.R                /* Error Injection Address Register */
#define CAN_3_ERRIDPR        CAN_3.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_3_ERRIPPR        CAN_3.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_3_RERRAR         CAN_3.RERRAR.R                /* Error Report Address Register */
#define CAN_3_RERRDR         CAN_3.RERRDR.R                /* Error Report Data Register */
#define CAN_3_RERRSYNR       CAN_3.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_3_ERRSR          CAN_3.ERRSR.R                 /* Error Status Register */
#define CAN_3_FDCTRL         CAN_3.FDCTRL.R                /* CAN FD Control Register */
#define CAN_3_FDCBT          CAN_3.FDCBT.R                 /* CAN FD Bit Timing Register */
#define CAN_3_FDCRC          CAN_3.FDCRC.R                 /* CAN FD CRC Register */

/* CMU */
#define CMU_ADCSD_CSR        CMU_ADCSD.CSR.R               /* CMU Control Status Register */
#define CMU_ADCSD_FDR        CMU_ADCSD.FDR.R               /* CMU Frequency Display Register */
#define CMU_ADCSD_HFREFR     CMU_ADCSD.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_ADCSD_LFREFR     CMU_ADCSD.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_ADCSD_ISR        CMU_ADCSD.ISR.R               /* CMU Interrupt Status Register */
#define CMU_ADCSD_MDR        CMU_ADCSD.MDR.R               /* CMU Measurement Duration Register */

#define CMU_AIPS_CSR         CMU_AIPS.CSR.R                /* CMU Control Status Register */
#define CMU_AIPS_FDR         CMU_AIPS.FDR.R                /* CMU Frequency Display Register */
#define CMU_AIPS_HFREFR      CMU_AIPS.HFREFR.R             /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_AIPS_LFREFR      CMU_AIPS.LFREFR.R             /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_AIPS_ISR         CMU_AIPS.ISR.R                /* CMU Interrupt Status Register */
#define CMU_AIPS_MDR         CMU_AIPS.MDR.R                /* CMU Measurement Duration Register */

#define CMU_CLKOUT_CSR       CMU_CLKOUT.CSR.R              /* CMU Control Status Register */
#define CMU_CLKOUT_FDR       CMU_CLKOUT.FDR.R              /* CMU Frequency Display Register */
#define CMU_CLKOUT_HFREFR    CMU_CLKOUT.HFREFR.R           /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_CLKOUT_LFREFR    CMU_CLKOUT.LFREFR.R           /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_CLKOUT_ISR       CMU_CLKOUT.ISR.R              /* CMU Interrupt Status Register */
#define CMU_CLKOUT_MDR       CMU_CLKOUT.MDR.R              /* CMU Measurement Duration Register */

#define CMU_FXBAR_CSR        CMU_FXBAR.CSR.R               /* CMU Control Status Register */
#define CMU_FXBAR_FDR        CMU_FXBAR.FDR.R               /* CMU Frequency Display Register */
#define CMU_FXBAR_HFREFR     CMU_FXBAR.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_FXBAR_LFREFR     CMU_FXBAR.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_FXBAR_ISR        CMU_FXBAR.ISR.R               /* CMU Interrupt Status Register */
#define CMU_FXBAR_MDR        CMU_FXBAR.MDR.R               /* CMU Measurement Duration Register */

#define CMU_PER_CSR          CMU_PER.CSR.R                 /* CMU Control Status Register */
#define CMU_PER_FDR          CMU_PER.FDR.R                 /* CMU Frequency Display Register */
#define CMU_PER_HFREFR       CMU_PER.HFREFR.R              /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PER_LFREFR       CMU_PER.LFREFR.R              /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PER_ISR          CMU_PER.ISR.R                 /* CMU Interrupt Status Register */
#define CMU_PER_MDR          CMU_PER.MDR.R                 /* CMU Measurement Duration Register */

#define CMU_PLL_CSR          CMU_PLL.CSR.R                 /* CMU Control Status Register */
#define CMU_PLL_FDR          CMU_PLL.FDR.R                 /* CMU Frequency Display Register */
#define CMU_PLL_HFREFR       CMU_PLL.HFREFR.R              /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PLL_LFREFR       CMU_PLL.LFREFR.R              /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PLL_ISR          CMU_PLL.ISR.R                 /* CMU Interrupt Status Register */
#define CMU_PLL_MDR          CMU_PLL.MDR.R                 /* CMU Measurement Duration Register */

#define CMU_SARADC_CSR       CMU_SARADC.CSR.R              /* CMU Control Status Register */
#define CMU_SARADC_FDR       CMU_SARADC.FDR.R              /* CMU Frequency Display Register */
#define CMU_SARADC_HFREFR    CMU_SARADC.HFREFR.R           /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_SARADC_LFREFR    CMU_SARADC.LFREFR.R           /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_SARADC_ISR       CMU_SARADC.ISR.R              /* CMU Interrupt Status Register */
#define CMU_SARADC_MDR       CMU_SARADC.MDR.R              /* CMU Measurement Duration Register */

#define CMU_SENT_CSR         CMU_SENT.CSR.R                /* CMU Control Status Register */
#define CMU_SENT_FDR         CMU_SENT.FDR.R                /* CMU Frequency Display Register */
#define CMU_SENT_HFREFR      CMU_SENT.HFREFR.R             /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_SENT_LFREFR      CMU_SENT.LFREFR.R             /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_SENT_ISR         CMU_SENT.ISR.R                /* CMU Interrupt Status Register */
#define CMU_SENT_MDR         CMU_SENT.MDR.R                /* CMU Measurement Duration Register */

#define CMU_SXBAR_CSR        CMU_SXBAR.CSR.R               /* CMU Control Status Register */
#define CMU_SXBAR_FDR        CMU_SXBAR.FDR.R               /* CMU Frequency Display Register */
#define CMU_SXBAR_HFREFR     CMU_SXBAR.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_SXBAR_LFREFR     CMU_SXBAR.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_SXBAR_ISR        CMU_SXBAR.ISR.R               /* CMU Interrupt Status Register */
#define CMU_SXBAR_MDR        CMU_SXBAR.MDR.R               /* CMU Measurement Duration Register */

#define CMU_eMIOS_CSR        CMU_eMIOS.CSR.R               /* CMU Control Status Register */
#define CMU_eMIOS_FDR        CMU_eMIOS.FDR.R               /* CMU Frequency Display Register */
#define CMU_eMIOS_HFREFR     CMU_eMIOS.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_eMIOS_LFREFR     CMU_eMIOS.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_eMIOS_ISR        CMU_eMIOS.ISR.R               /* CMU Interrupt Status Register */
#define CMU_eMIOS_MDR        CMU_eMIOS.MDR.R               /* CMU Measurement Duration Register */

#define CMU_eTPU2_CSR        CMU_eTPU2.CSR.R               /* CMU Control Status Register */
#define CMU_eTPU2_FDR        CMU_eTPU2.FDR.R               /* CMU Frequency Display Register */
#define CMU_eTPU2_HFREFR     CMU_eTPU2.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_eTPU2_LFREFR     CMU_eTPU2.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_eTPU2_ISR        CMU_eTPU2.ISR.R               /* CMU Interrupt Status Register */
#define CMU_eTPU2_MDR        CMU_eTPU2.MDR.R               /* CMU Measurement Duration Register */

/* CRC */
#define CRC_0_CFG            CRC_0.CFG.R                   /* Configuration Register */
#define CRC_0_INP            CRC_0.INP.R                   /* Input Register */
#define CRC_0_CSTAT          CRC_0.CSTAT.R                 /* Current Status Register */
#define CRC_0_OUTP           CRC_0.OUTP.R                  /* Output Register */

#define CRC_1_CFG            CRC_1.CFG.R                   /* Configuration Register */
#define CRC_1_INP            CRC_1.INP.R                   /* Input Register */
#define CRC_1_CSTAT          CRC_1.CSTAT.R                 /* Current Status Register */
#define CRC_1_OUTP           CRC_1.OUTP.R                  /* Output Register */

/* DECFILTER */
#define DECFILTER_0_MCR      DECFILTER_0.MCR.R             /* Module Configuration Register */
#define DECFILTER_0_MSR      DECFILTER_0.MSR.R             /* Module Status Register */
#define DECFILTER_0_MXCR     DECFILTER_0.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_0_MXSR     DECFILTER_0.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_0_IB       DECFILTER_0.IB.R              /* Interface Input Buffer */
#define DECFILTER_0_OB       DECFILTER_0.OB.R              /* Interface Output Buffer */
#define DECFILTER_0_COEF0    DECFILTER_0.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_0_COEF1    DECFILTER_0.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_0_COEF2    DECFILTER_0.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_0_COEF3    DECFILTER_0.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_0_COEF4    DECFILTER_0.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_0_COEF5    DECFILTER_0.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_0_COEF6    DECFILTER_0.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_0_COEF7    DECFILTER_0.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_0_COEF8    DECFILTER_0.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_0_TAP0     DECFILTER_0.TAP[0].R          /* Filter TAP */
#define DECFILTER_0_TAP1     DECFILTER_0.TAP[1].R          /* Filter TAP */
#define DECFILTER_0_TAP2     DECFILTER_0.TAP[2].R          /* Filter TAP */
#define DECFILTER_0_TAP3     DECFILTER_0.TAP[3].R          /* Filter TAP */
#define DECFILTER_0_TAP4     DECFILTER_0.TAP[4].R          /* Filter TAP */
#define DECFILTER_0_TAP5     DECFILTER_0.TAP[5].R          /* Filter TAP */
#define DECFILTER_0_TAP6     DECFILTER_0.TAP[6].R          /* Filter TAP */
#define DECFILTER_0_TAP7     DECFILTER_0.TAP[7].R          /* Filter TAP */
#define DECFILTER_0_FINTVAL  DECFILTER_0.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_0_FINTCNT  DECFILTER_0.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_0_CINTVAL  DECFILTER_0.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_0_CINTCNT  DECFILTER_0.CINTCNT.R         /* Current Integer Count Register */

#define DECFILTER_1_MCR      DECFILTER_1.MCR.R             /* Module Configuration Register */
#define DECFILTER_1_MSR      DECFILTER_1.MSR.R             /* Module Status Register */
#define DECFILTER_1_MXCR     DECFILTER_1.MXCR.R            /* Module Extended Config Register */
#define DECFILTER_1_MXSR     DECFILTER_1.MXSR.R            /* Module Extended Status Register */
#define DECFILTER_1_IB       DECFILTER_1.IB.R              /* Interface Input Buffer */
#define DECFILTER_1_OB       DECFILTER_1.OB.R              /* Interface Output Buffer */
#define DECFILTER_1_COEF0    DECFILTER_1.COEF[0].R         /* Filter Coefficient */
#define DECFILTER_1_COEF1    DECFILTER_1.COEF[1].R         /* Filter Coefficient */
#define DECFILTER_1_COEF2    DECFILTER_1.COEF[2].R         /* Filter Coefficient */
#define DECFILTER_1_COEF3    DECFILTER_1.COEF[3].R         /* Filter Coefficient */
#define DECFILTER_1_COEF4    DECFILTER_1.COEF[4].R         /* Filter Coefficient */
#define DECFILTER_1_COEF5    DECFILTER_1.COEF[5].R         /* Filter Coefficient */
#define DECFILTER_1_COEF6    DECFILTER_1.COEF[6].R         /* Filter Coefficient */
#define DECFILTER_1_COEF7    DECFILTER_1.COEF[7].R         /* Filter Coefficient */
#define DECFILTER_1_COEF8    DECFILTER_1.COEF[8].R         /* Filter Coefficient */
#define DECFILTER_1_TAP0     DECFILTER_1.TAP[0].R          /* Filter TAP */
#define DECFILTER_1_TAP1     DECFILTER_1.TAP[1].R          /* Filter TAP */
#define DECFILTER_1_TAP2     DECFILTER_1.TAP[2].R          /* Filter TAP */
#define DECFILTER_1_TAP3     DECFILTER_1.TAP[3].R          /* Filter TAP */
#define DECFILTER_1_TAP4     DECFILTER_1.TAP[4].R          /* Filter TAP */
#define DECFILTER_1_TAP5     DECFILTER_1.TAP[5].R          /* Filter TAP */
#define DECFILTER_1_TAP6     DECFILTER_1.TAP[6].R          /* Filter TAP */
#define DECFILTER_1_TAP7     DECFILTER_1.TAP[7].R          /* Filter TAP */
#define DECFILTER_1_FINTVAL  DECFILTER_1.FINTVAL.R         /* Final Integer Value Register */
#define DECFILTER_1_FINTCNT  DECFILTER_1.FINTCNT.R         /* Final Integer Count Register */
#define DECFILTER_1_CINTVAL  DECFILTER_1.CINTVAL.R         /* Current Integer Value Register */
#define DECFILTER_1_CINTCNT  DECFILTER_1.CINTCNT.R         /* Current Integer Count Register */

/* DMA */
#define DMA_0_CR             DMA_0.CR.R                    /* Control Register */
#define DMA_0_ES             DMA_0.ES.R                    /* Error Status Register */
#define DMA_0_ERQH           DMA_0.ERQH.R                  /* Enable Request Register High */
#define DMA_0_ERQL           DMA_0.ERQL.R                  /* Enable Request Register Low */
#define DMA_0_EEIH           DMA_0.EEIH.R                  /* Enable Error Interrupt Register High */
#define DMA_0_EEIL           DMA_0.EEIL.R                  /* Enable Error Interrupt Register Low */
#define DMA_0_SERQ           DMA_0.SERQ.R                  /* Set Enable Request Register */
#define DMA_0_CERQ           DMA_0.CERQ.R                  /* Clear Enable Request Register */
#define DMA_0_SEEI           DMA_0.SEEI.R                  /* Set Enable Error Interrupt Register */
#define DMA_0_CEEI           DMA_0.CEEI.R                  /* Clear Enable Error Interrupt Register */
#define DMA_0_CINT           DMA_0.CINT.R                  /* Clear Interrupt Request Register */
#define DMA_0_CERR           DMA_0.CERR.R                  /* Clear Error Register */
#define DMA_0_SSRT           DMA_0.SSRT.R                  /* Set START Bit Register */
#define DMA_0_CDNE           DMA_0.CDNE.R                  /* Clear DONE Status Bit Register */
#define DMA_0_INTH           DMA_0.INTH.R                  /* Interrupt Request Register High */
#define DMA_0_INTL           DMA_0.INTL.R                  /* Interrupt Request Register Low */
#define DMA_0_ERRH           DMA_0.ERRH.R                  /* Enable Error Interrupt Register High */
#define DMA_0_ERRL           DMA_0.ERRL.R                  /* Enable Error Interrupt RegisterLow */
#define DMA_0_HRSH           DMA_0.HRSH.R                  /* Hardware Request Status Register High */
#define DMA_0_HRSL           DMA_0.HRSL.R                  /* Hardware Request Status Register Low */
#define DMA_0_DCHPRI0        DMA_0.DCHPRI[0].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI1        DMA_0.DCHPRI[1].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI2        DMA_0.DCHPRI[2].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI3        DMA_0.DCHPRI[3].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI4        DMA_0.DCHPRI[4].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI5        DMA_0.DCHPRI[5].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI6        DMA_0.DCHPRI[6].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI7        DMA_0.DCHPRI[7].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI8        DMA_0.DCHPRI[8].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI9        DMA_0.DCHPRI[9].R             /* Channel n Priority Register */
#define DMA_0_DCHPRI10       DMA_0.DCHPRI[10].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI11       DMA_0.DCHPRI[11].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI12       DMA_0.DCHPRI[12].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI13       DMA_0.DCHPRI[13].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI14       DMA_0.DCHPRI[14].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI15       DMA_0.DCHPRI[15].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI16       DMA_0.DCHPRI[16].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI17       DMA_0.DCHPRI[17].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI18       DMA_0.DCHPRI[18].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI19       DMA_0.DCHPRI[19].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI20       DMA_0.DCHPRI[20].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI21       DMA_0.DCHPRI[21].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI22       DMA_0.DCHPRI[22].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI23       DMA_0.DCHPRI[23].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI24       DMA_0.DCHPRI[24].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI25       DMA_0.DCHPRI[25].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI26       DMA_0.DCHPRI[26].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI27       DMA_0.DCHPRI[27].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI28       DMA_0.DCHPRI[28].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI29       DMA_0.DCHPRI[29].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI30       DMA_0.DCHPRI[30].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI31       DMA_0.DCHPRI[31].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI32       DMA_0.DCHPRI[32].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI33       DMA_0.DCHPRI[33].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI34       DMA_0.DCHPRI[34].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI35       DMA_0.DCHPRI[35].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI36       DMA_0.DCHPRI[36].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI37       DMA_0.DCHPRI[37].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI38       DMA_0.DCHPRI[38].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI39       DMA_0.DCHPRI[39].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI40       DMA_0.DCHPRI[40].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI41       DMA_0.DCHPRI[41].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI42       DMA_0.DCHPRI[42].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI43       DMA_0.DCHPRI[43].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI44       DMA_0.DCHPRI[44].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI45       DMA_0.DCHPRI[45].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI46       DMA_0.DCHPRI[46].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI47       DMA_0.DCHPRI[47].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI48       DMA_0.DCHPRI[48].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI49       DMA_0.DCHPRI[49].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI50       DMA_0.DCHPRI[50].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI51       DMA_0.DCHPRI[51].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI52       DMA_0.DCHPRI[52].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI53       DMA_0.DCHPRI[53].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI54       DMA_0.DCHPRI[54].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI55       DMA_0.DCHPRI[55].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI56       DMA_0.DCHPRI[56].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI57       DMA_0.DCHPRI[57].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI58       DMA_0.DCHPRI[58].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI59       DMA_0.DCHPRI[59].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI60       DMA_0.DCHPRI[60].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI61       DMA_0.DCHPRI[61].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI62       DMA_0.DCHPRI[62].R            /* Channel n Priority Register */
#define DMA_0_DCHPRI63       DMA_0.DCHPRI[63].R            /* Channel n Priority Register */
#define DMA_0_DCHMID0        DMA_0.DCHMID[0].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID1        DMA_0.DCHMID[1].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID2        DMA_0.DCHMID[2].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID3        DMA_0.DCHMID[3].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID4        DMA_0.DCHMID[4].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID5        DMA_0.DCHMID[5].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID6        DMA_0.DCHMID[6].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID7        DMA_0.DCHMID[7].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID8        DMA_0.DCHMID[8].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID9        DMA_0.DCHMID[9].R             /* Channel n Master ID Register */
#define DMA_0_DCHMID10       DMA_0.DCHMID[10].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID11       DMA_0.DCHMID[11].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID12       DMA_0.DCHMID[12].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID13       DMA_0.DCHMID[13].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID14       DMA_0.DCHMID[14].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID15       DMA_0.DCHMID[15].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID16       DMA_0.DCHMID[16].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID17       DMA_0.DCHMID[17].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID18       DMA_0.DCHMID[18].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID19       DMA_0.DCHMID[19].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID20       DMA_0.DCHMID[20].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID21       DMA_0.DCHMID[21].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID22       DMA_0.DCHMID[22].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID23       DMA_0.DCHMID[23].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID24       DMA_0.DCHMID[24].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID25       DMA_0.DCHMID[25].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID26       DMA_0.DCHMID[26].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID27       DMA_0.DCHMID[27].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID28       DMA_0.DCHMID[28].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID29       DMA_0.DCHMID[29].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID30       DMA_0.DCHMID[30].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID31       DMA_0.DCHMID[31].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID32       DMA_0.DCHMID[32].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID33       DMA_0.DCHMID[33].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID34       DMA_0.DCHMID[34].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID35       DMA_0.DCHMID[35].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID36       DMA_0.DCHMID[36].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID37       DMA_0.DCHMID[37].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID38       DMA_0.DCHMID[38].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID39       DMA_0.DCHMID[39].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID40       DMA_0.DCHMID[40].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID41       DMA_0.DCHMID[41].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID42       DMA_0.DCHMID[42].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID43       DMA_0.DCHMID[43].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID44       DMA_0.DCHMID[44].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID45       DMA_0.DCHMID[45].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID46       DMA_0.DCHMID[46].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID47       DMA_0.DCHMID[47].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID48       DMA_0.DCHMID[48].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID49       DMA_0.DCHMID[49].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID50       DMA_0.DCHMID[50].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID51       DMA_0.DCHMID[51].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID52       DMA_0.DCHMID[52].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID53       DMA_0.DCHMID[53].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID54       DMA_0.DCHMID[54].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID55       DMA_0.DCHMID[55].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID56       DMA_0.DCHMID[56].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID57       DMA_0.DCHMID[57].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID58       DMA_0.DCHMID[58].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID59       DMA_0.DCHMID[59].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID60       DMA_0.DCHMID[60].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID61       DMA_0.DCHMID[61].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID62       DMA_0.DCHMID[62].R            /* Channel n Master ID Register */
#define DMA_0_DCHMID63       DMA_0.DCHMID[63].R            /* Channel n Master ID Register */
#define DMA_0_TCD0_WORD_0    DMA_0.TCD[0].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD0_WORD_1    DMA_0.TCD[0].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD0_WORD_2_MLOOP DMA_0.TCD[0].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD0_WORD_2_NBYTES DMA_0.TCD[0].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD0_WORD_3    DMA_0.TCD[0].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD0_WORD_4    DMA_0.TCD[0].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD0_WORD_5    DMA_0.TCD[0].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD0_WORD_6    DMA_0.TCD[0].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD0_WORD_7    DMA_0.TCD[0].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD1_WORD_0    DMA_0.TCD[1].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD1_WORD_1    DMA_0.TCD[1].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD1_WORD_2_MLOOP DMA_0.TCD[1].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD1_WORD_2_NBYTES DMA_0.TCD[1].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD1_WORD_3    DMA_0.TCD[1].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD1_WORD_4    DMA_0.TCD[1].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD1_WORD_5    DMA_0.TCD[1].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD1_WORD_6    DMA_0.TCD[1].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD1_WORD_7    DMA_0.TCD[1].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD2_WORD_0    DMA_0.TCD[2].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD2_WORD_1    DMA_0.TCD[2].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD2_WORD_2_MLOOP DMA_0.TCD[2].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD2_WORD_2_NBYTES DMA_0.TCD[2].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD2_WORD_3    DMA_0.TCD[2].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD2_WORD_4    DMA_0.TCD[2].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD2_WORD_5    DMA_0.TCD[2].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD2_WORD_6    DMA_0.TCD[2].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD2_WORD_7    DMA_0.TCD[2].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD3_WORD_0    DMA_0.TCD[3].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD3_WORD_1    DMA_0.TCD[3].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD3_WORD_2_MLOOP DMA_0.TCD[3].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD3_WORD_2_NBYTES DMA_0.TCD[3].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD3_WORD_3    DMA_0.TCD[3].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD3_WORD_4    DMA_0.TCD[3].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD3_WORD_5    DMA_0.TCD[3].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD3_WORD_6    DMA_0.TCD[3].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD3_WORD_7    DMA_0.TCD[3].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD4_WORD_0    DMA_0.TCD[4].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD4_WORD_1    DMA_0.TCD[4].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD4_WORD_2_MLOOP DMA_0.TCD[4].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD4_WORD_2_NBYTES DMA_0.TCD[4].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD4_WORD_3    DMA_0.TCD[4].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD4_WORD_4    DMA_0.TCD[4].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD4_WORD_5    DMA_0.TCD[4].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD4_WORD_6    DMA_0.TCD[4].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD4_WORD_7    DMA_0.TCD[4].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD5_WORD_0    DMA_0.TCD[5].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD5_WORD_1    DMA_0.TCD[5].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD5_WORD_2_MLOOP DMA_0.TCD[5].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD5_WORD_2_NBYTES DMA_0.TCD[5].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD5_WORD_3    DMA_0.TCD[5].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD5_WORD_4    DMA_0.TCD[5].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD5_WORD_5    DMA_0.TCD[5].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD5_WORD_6    DMA_0.TCD[5].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD5_WORD_7    DMA_0.TCD[5].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD6_WORD_0    DMA_0.TCD[6].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD6_WORD_1    DMA_0.TCD[6].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD6_WORD_2_MLOOP DMA_0.TCD[6].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD6_WORD_2_NBYTES DMA_0.TCD[6].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD6_WORD_3    DMA_0.TCD[6].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD6_WORD_4    DMA_0.TCD[6].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD6_WORD_5    DMA_0.TCD[6].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD6_WORD_6    DMA_0.TCD[6].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD6_WORD_7    DMA_0.TCD[6].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD7_WORD_0    DMA_0.TCD[7].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD7_WORD_1    DMA_0.TCD[7].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD7_WORD_2_MLOOP DMA_0.TCD[7].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD7_WORD_2_NBYTES DMA_0.TCD[7].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD7_WORD_3    DMA_0.TCD[7].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD7_WORD_4    DMA_0.TCD[7].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD7_WORD_5    DMA_0.TCD[7].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD7_WORD_6    DMA_0.TCD[7].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD7_WORD_7    DMA_0.TCD[7].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD8_WORD_0    DMA_0.TCD[8].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD8_WORD_1    DMA_0.TCD[8].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD8_WORD_2_MLOOP DMA_0.TCD[8].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD8_WORD_2_NBYTES DMA_0.TCD[8].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD8_WORD_3    DMA_0.TCD[8].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD8_WORD_4    DMA_0.TCD[8].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD8_WORD_5    DMA_0.TCD[8].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD8_WORD_6    DMA_0.TCD[8].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD8_WORD_7    DMA_0.TCD[8].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD9_WORD_0    DMA_0.TCD[9].WORD_0.R         /* TCD Source Address */
#define DMA_0_TCD9_WORD_1    DMA_0.TCD[9].WORD_1.R         /* TCD Transfer Attributes */
#define DMA_0_TCD9_WORD_2_MLOOP DMA_0.TCD[9].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD9_WORD_2_NBYTES DMA_0.TCD[9].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD9_WORD_3    DMA_0.TCD[9].WORD_3.R         /* TCD Last Source Address Adjustment */
#define DMA_0_TCD9_WORD_4    DMA_0.TCD[9].WORD_4.R         /* TCD Destination Address */
#define DMA_0_TCD9_WORD_5    DMA_0.TCD[9].WORD_5.R         /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD9_WORD_6    DMA_0.TCD[9].WORD_6.R         /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD9_WORD_7    DMA_0.TCD[9].WORD_7.R         /* TCD Control and Status */
#define DMA_0_TCD10_WORD_0   DMA_0.TCD[10].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD10_WORD_1   DMA_0.TCD[10].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD10_WORD_2_MLOOP DMA_0.TCD[10].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD10_WORD_2_NBYTES DMA_0.TCD[10].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD10_WORD_3   DMA_0.TCD[10].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD10_WORD_4   DMA_0.TCD[10].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD10_WORD_5   DMA_0.TCD[10].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD10_WORD_6   DMA_0.TCD[10].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD10_WORD_7   DMA_0.TCD[10].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD11_WORD_0   DMA_0.TCD[11].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD11_WORD_1   DMA_0.TCD[11].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD11_WORD_2_MLOOP DMA_0.TCD[11].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD11_WORD_2_NBYTES DMA_0.TCD[11].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD11_WORD_3   DMA_0.TCD[11].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD11_WORD_4   DMA_0.TCD[11].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD11_WORD_5   DMA_0.TCD[11].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD11_WORD_6   DMA_0.TCD[11].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD11_WORD_7   DMA_0.TCD[11].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD12_WORD_0   DMA_0.TCD[12].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD12_WORD_1   DMA_0.TCD[12].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD12_WORD_2_MLOOP DMA_0.TCD[12].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD12_WORD_2_NBYTES DMA_0.TCD[12].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD12_WORD_3   DMA_0.TCD[12].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD12_WORD_4   DMA_0.TCD[12].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD12_WORD_5   DMA_0.TCD[12].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD12_WORD_6   DMA_0.TCD[12].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD12_WORD_7   DMA_0.TCD[12].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD13_WORD_0   DMA_0.TCD[13].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD13_WORD_1   DMA_0.TCD[13].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD13_WORD_2_MLOOP DMA_0.TCD[13].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD13_WORD_2_NBYTES DMA_0.TCD[13].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD13_WORD_3   DMA_0.TCD[13].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD13_WORD_4   DMA_0.TCD[13].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD13_WORD_5   DMA_0.TCD[13].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD13_WORD_6   DMA_0.TCD[13].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD13_WORD_7   DMA_0.TCD[13].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD14_WORD_0   DMA_0.TCD[14].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD14_WORD_1   DMA_0.TCD[14].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD14_WORD_2_MLOOP DMA_0.TCD[14].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD14_WORD_2_NBYTES DMA_0.TCD[14].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD14_WORD_3   DMA_0.TCD[14].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD14_WORD_4   DMA_0.TCD[14].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD14_WORD_5   DMA_0.TCD[14].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD14_WORD_6   DMA_0.TCD[14].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD14_WORD_7   DMA_0.TCD[14].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD15_WORD_0   DMA_0.TCD[15].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD15_WORD_1   DMA_0.TCD[15].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD15_WORD_2_MLOOP DMA_0.TCD[15].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD15_WORD_2_NBYTES DMA_0.TCD[15].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD15_WORD_3   DMA_0.TCD[15].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD15_WORD_4   DMA_0.TCD[15].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD15_WORD_5   DMA_0.TCD[15].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD15_WORD_6   DMA_0.TCD[15].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD15_WORD_7   DMA_0.TCD[15].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD16_WORD_0   DMA_0.TCD[16].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD16_WORD_1   DMA_0.TCD[16].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD16_WORD_2_MLOOP DMA_0.TCD[16].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD16_WORD_2_NBYTES DMA_0.TCD[16].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD16_WORD_3   DMA_0.TCD[16].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD16_WORD_4   DMA_0.TCD[16].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD16_WORD_5   DMA_0.TCD[16].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD16_WORD_6   DMA_0.TCD[16].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD16_WORD_7   DMA_0.TCD[16].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD17_WORD_0   DMA_0.TCD[17].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD17_WORD_1   DMA_0.TCD[17].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD17_WORD_2_MLOOP DMA_0.TCD[17].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD17_WORD_2_NBYTES DMA_0.TCD[17].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD17_WORD_3   DMA_0.TCD[17].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD17_WORD_4   DMA_0.TCD[17].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD17_WORD_5   DMA_0.TCD[17].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD17_WORD_6   DMA_0.TCD[17].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD17_WORD_7   DMA_0.TCD[17].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD18_WORD_0   DMA_0.TCD[18].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD18_WORD_1   DMA_0.TCD[18].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD18_WORD_2_MLOOP DMA_0.TCD[18].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD18_WORD_2_NBYTES DMA_0.TCD[18].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD18_WORD_3   DMA_0.TCD[18].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD18_WORD_4   DMA_0.TCD[18].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD18_WORD_5   DMA_0.TCD[18].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD18_WORD_6   DMA_0.TCD[18].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD18_WORD_7   DMA_0.TCD[18].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD19_WORD_0   DMA_0.TCD[19].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD19_WORD_1   DMA_0.TCD[19].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD19_WORD_2_MLOOP DMA_0.TCD[19].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD19_WORD_2_NBYTES DMA_0.TCD[19].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD19_WORD_3   DMA_0.TCD[19].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD19_WORD_4   DMA_0.TCD[19].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD19_WORD_5   DMA_0.TCD[19].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD19_WORD_6   DMA_0.TCD[19].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD19_WORD_7   DMA_0.TCD[19].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD20_WORD_0   DMA_0.TCD[20].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD20_WORD_1   DMA_0.TCD[20].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD20_WORD_2_MLOOP DMA_0.TCD[20].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD20_WORD_2_NBYTES DMA_0.TCD[20].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD20_WORD_3   DMA_0.TCD[20].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD20_WORD_4   DMA_0.TCD[20].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD20_WORD_5   DMA_0.TCD[20].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD20_WORD_6   DMA_0.TCD[20].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD20_WORD_7   DMA_0.TCD[20].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD21_WORD_0   DMA_0.TCD[21].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD21_WORD_1   DMA_0.TCD[21].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD21_WORD_2_MLOOP DMA_0.TCD[21].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD21_WORD_2_NBYTES DMA_0.TCD[21].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD21_WORD_3   DMA_0.TCD[21].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD21_WORD_4   DMA_0.TCD[21].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD21_WORD_5   DMA_0.TCD[21].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD21_WORD_6   DMA_0.TCD[21].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD21_WORD_7   DMA_0.TCD[21].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD22_WORD_0   DMA_0.TCD[22].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD22_WORD_1   DMA_0.TCD[22].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD22_WORD_2_MLOOP DMA_0.TCD[22].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD22_WORD_2_NBYTES DMA_0.TCD[22].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD22_WORD_3   DMA_0.TCD[22].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD22_WORD_4   DMA_0.TCD[22].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD22_WORD_5   DMA_0.TCD[22].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD22_WORD_6   DMA_0.TCD[22].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD22_WORD_7   DMA_0.TCD[22].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD23_WORD_0   DMA_0.TCD[23].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD23_WORD_1   DMA_0.TCD[23].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD23_WORD_2_MLOOP DMA_0.TCD[23].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD23_WORD_2_NBYTES DMA_0.TCD[23].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD23_WORD_3   DMA_0.TCD[23].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD23_WORD_4   DMA_0.TCD[23].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD23_WORD_5   DMA_0.TCD[23].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD23_WORD_6   DMA_0.TCD[23].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD23_WORD_7   DMA_0.TCD[23].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD24_WORD_0   DMA_0.TCD[24].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD24_WORD_1   DMA_0.TCD[24].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD24_WORD_2_MLOOP DMA_0.TCD[24].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD24_WORD_2_NBYTES DMA_0.TCD[24].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD24_WORD_3   DMA_0.TCD[24].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD24_WORD_4   DMA_0.TCD[24].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD24_WORD_5   DMA_0.TCD[24].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD24_WORD_6   DMA_0.TCD[24].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD24_WORD_7   DMA_0.TCD[24].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD25_WORD_0   DMA_0.TCD[25].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD25_WORD_1   DMA_0.TCD[25].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD25_WORD_2_MLOOP DMA_0.TCD[25].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD25_WORD_2_NBYTES DMA_0.TCD[25].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD25_WORD_3   DMA_0.TCD[25].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD25_WORD_4   DMA_0.TCD[25].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD25_WORD_5   DMA_0.TCD[25].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD25_WORD_6   DMA_0.TCD[25].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD25_WORD_7   DMA_0.TCD[25].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD26_WORD_0   DMA_0.TCD[26].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD26_WORD_1   DMA_0.TCD[26].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD26_WORD_2_MLOOP DMA_0.TCD[26].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD26_WORD_2_NBYTES DMA_0.TCD[26].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD26_WORD_3   DMA_0.TCD[26].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD26_WORD_4   DMA_0.TCD[26].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD26_WORD_5   DMA_0.TCD[26].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD26_WORD_6   DMA_0.TCD[26].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD26_WORD_7   DMA_0.TCD[26].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD27_WORD_0   DMA_0.TCD[27].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD27_WORD_1   DMA_0.TCD[27].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD27_WORD_2_MLOOP DMA_0.TCD[27].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD27_WORD_2_NBYTES DMA_0.TCD[27].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD27_WORD_3   DMA_0.TCD[27].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD27_WORD_4   DMA_0.TCD[27].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD27_WORD_5   DMA_0.TCD[27].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD27_WORD_6   DMA_0.TCD[27].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD27_WORD_7   DMA_0.TCD[27].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD28_WORD_0   DMA_0.TCD[28].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD28_WORD_1   DMA_0.TCD[28].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD28_WORD_2_MLOOP DMA_0.TCD[28].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD28_WORD_2_NBYTES DMA_0.TCD[28].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD28_WORD_3   DMA_0.TCD[28].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD28_WORD_4   DMA_0.TCD[28].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD28_WORD_5   DMA_0.TCD[28].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD28_WORD_6   DMA_0.TCD[28].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD28_WORD_7   DMA_0.TCD[28].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD29_WORD_0   DMA_0.TCD[29].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD29_WORD_1   DMA_0.TCD[29].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD29_WORD_2_MLOOP DMA_0.TCD[29].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD29_WORD_2_NBYTES DMA_0.TCD[29].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD29_WORD_3   DMA_0.TCD[29].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD29_WORD_4   DMA_0.TCD[29].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD29_WORD_5   DMA_0.TCD[29].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD29_WORD_6   DMA_0.TCD[29].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD29_WORD_7   DMA_0.TCD[29].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD30_WORD_0   DMA_0.TCD[30].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD30_WORD_1   DMA_0.TCD[30].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD30_WORD_2_MLOOP DMA_0.TCD[30].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD30_WORD_2_NBYTES DMA_0.TCD[30].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD30_WORD_3   DMA_0.TCD[30].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD30_WORD_4   DMA_0.TCD[30].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD30_WORD_5   DMA_0.TCD[30].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD30_WORD_6   DMA_0.TCD[30].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD30_WORD_7   DMA_0.TCD[30].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD31_WORD_0   DMA_0.TCD[31].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD31_WORD_1   DMA_0.TCD[31].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD31_WORD_2_MLOOP DMA_0.TCD[31].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD31_WORD_2_NBYTES DMA_0.TCD[31].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD31_WORD_3   DMA_0.TCD[31].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD31_WORD_4   DMA_0.TCD[31].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD31_WORD_5   DMA_0.TCD[31].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD31_WORD_6   DMA_0.TCD[31].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD31_WORD_7   DMA_0.TCD[31].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD32_WORD_0   DMA_0.TCD[32].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD32_WORD_1   DMA_0.TCD[32].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD32_WORD_2_MLOOP DMA_0.TCD[32].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD32_WORD_2_NBYTES DMA_0.TCD[32].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD32_WORD_3   DMA_0.TCD[32].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD32_WORD_4   DMA_0.TCD[32].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD32_WORD_5   DMA_0.TCD[32].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD32_WORD_6   DMA_0.TCD[32].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD32_WORD_7   DMA_0.TCD[32].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD33_WORD_0   DMA_0.TCD[33].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD33_WORD_1   DMA_0.TCD[33].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD33_WORD_2_MLOOP DMA_0.TCD[33].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD33_WORD_2_NBYTES DMA_0.TCD[33].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD33_WORD_3   DMA_0.TCD[33].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD33_WORD_4   DMA_0.TCD[33].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD33_WORD_5   DMA_0.TCD[33].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD33_WORD_6   DMA_0.TCD[33].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD33_WORD_7   DMA_0.TCD[33].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD34_WORD_0   DMA_0.TCD[34].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD34_WORD_1   DMA_0.TCD[34].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD34_WORD_2_MLOOP DMA_0.TCD[34].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD34_WORD_2_NBYTES DMA_0.TCD[34].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD34_WORD_3   DMA_0.TCD[34].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD34_WORD_4   DMA_0.TCD[34].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD34_WORD_5   DMA_0.TCD[34].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD34_WORD_6   DMA_0.TCD[34].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD34_WORD_7   DMA_0.TCD[34].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD35_WORD_0   DMA_0.TCD[35].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD35_WORD_1   DMA_0.TCD[35].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD35_WORD_2_MLOOP DMA_0.TCD[35].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD35_WORD_2_NBYTES DMA_0.TCD[35].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD35_WORD_3   DMA_0.TCD[35].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD35_WORD_4   DMA_0.TCD[35].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD35_WORD_5   DMA_0.TCD[35].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD35_WORD_6   DMA_0.TCD[35].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD35_WORD_7   DMA_0.TCD[35].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD36_WORD_0   DMA_0.TCD[36].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD36_WORD_1   DMA_0.TCD[36].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD36_WORD_2_MLOOP DMA_0.TCD[36].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD36_WORD_2_NBYTES DMA_0.TCD[36].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD36_WORD_3   DMA_0.TCD[36].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD36_WORD_4   DMA_0.TCD[36].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD36_WORD_5   DMA_0.TCD[36].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD36_WORD_6   DMA_0.TCD[36].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD36_WORD_7   DMA_0.TCD[36].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD37_WORD_0   DMA_0.TCD[37].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD37_WORD_1   DMA_0.TCD[37].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD37_WORD_2_MLOOP DMA_0.TCD[37].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD37_WORD_2_NBYTES DMA_0.TCD[37].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD37_WORD_3   DMA_0.TCD[37].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD37_WORD_4   DMA_0.TCD[37].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD37_WORD_5   DMA_0.TCD[37].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD37_WORD_6   DMA_0.TCD[37].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD37_WORD_7   DMA_0.TCD[37].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD38_WORD_0   DMA_0.TCD[38].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD38_WORD_1   DMA_0.TCD[38].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD38_WORD_2_MLOOP DMA_0.TCD[38].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD38_WORD_2_NBYTES DMA_0.TCD[38].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD38_WORD_3   DMA_0.TCD[38].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD38_WORD_4   DMA_0.TCD[38].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD38_WORD_5   DMA_0.TCD[38].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD38_WORD_6   DMA_0.TCD[38].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD38_WORD_7   DMA_0.TCD[38].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD39_WORD_0   DMA_0.TCD[39].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD39_WORD_1   DMA_0.TCD[39].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD39_WORD_2_MLOOP DMA_0.TCD[39].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD39_WORD_2_NBYTES DMA_0.TCD[39].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD39_WORD_3   DMA_0.TCD[39].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD39_WORD_4   DMA_0.TCD[39].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD39_WORD_5   DMA_0.TCD[39].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD39_WORD_6   DMA_0.TCD[39].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD39_WORD_7   DMA_0.TCD[39].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD40_WORD_0   DMA_0.TCD[40].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD40_WORD_1   DMA_0.TCD[40].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD40_WORD_2_MLOOP DMA_0.TCD[40].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD40_WORD_2_NBYTES DMA_0.TCD[40].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD40_WORD_3   DMA_0.TCD[40].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD40_WORD_4   DMA_0.TCD[40].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD40_WORD_5   DMA_0.TCD[40].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD40_WORD_6   DMA_0.TCD[40].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD40_WORD_7   DMA_0.TCD[40].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD41_WORD_0   DMA_0.TCD[41].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD41_WORD_1   DMA_0.TCD[41].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD41_WORD_2_MLOOP DMA_0.TCD[41].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD41_WORD_2_NBYTES DMA_0.TCD[41].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD41_WORD_3   DMA_0.TCD[41].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD41_WORD_4   DMA_0.TCD[41].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD41_WORD_5   DMA_0.TCD[41].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD41_WORD_6   DMA_0.TCD[41].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD41_WORD_7   DMA_0.TCD[41].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD42_WORD_0   DMA_0.TCD[42].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD42_WORD_1   DMA_0.TCD[42].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD42_WORD_2_MLOOP DMA_0.TCD[42].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD42_WORD_2_NBYTES DMA_0.TCD[42].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD42_WORD_3   DMA_0.TCD[42].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD42_WORD_4   DMA_0.TCD[42].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD42_WORD_5   DMA_0.TCD[42].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD42_WORD_6   DMA_0.TCD[42].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD42_WORD_7   DMA_0.TCD[42].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD43_WORD_0   DMA_0.TCD[43].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD43_WORD_1   DMA_0.TCD[43].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD43_WORD_2_MLOOP DMA_0.TCD[43].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD43_WORD_2_NBYTES DMA_0.TCD[43].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD43_WORD_3   DMA_0.TCD[43].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD43_WORD_4   DMA_0.TCD[43].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD43_WORD_5   DMA_0.TCD[43].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD43_WORD_6   DMA_0.TCD[43].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD43_WORD_7   DMA_0.TCD[43].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD44_WORD_0   DMA_0.TCD[44].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD44_WORD_1   DMA_0.TCD[44].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD44_WORD_2_MLOOP DMA_0.TCD[44].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD44_WORD_2_NBYTES DMA_0.TCD[44].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD44_WORD_3   DMA_0.TCD[44].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD44_WORD_4   DMA_0.TCD[44].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD44_WORD_5   DMA_0.TCD[44].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD44_WORD_6   DMA_0.TCD[44].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD44_WORD_7   DMA_0.TCD[44].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD45_WORD_0   DMA_0.TCD[45].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD45_WORD_1   DMA_0.TCD[45].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD45_WORD_2_MLOOP DMA_0.TCD[45].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD45_WORD_2_NBYTES DMA_0.TCD[45].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD45_WORD_3   DMA_0.TCD[45].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD45_WORD_4   DMA_0.TCD[45].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD45_WORD_5   DMA_0.TCD[45].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD45_WORD_6   DMA_0.TCD[45].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD45_WORD_7   DMA_0.TCD[45].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD46_WORD_0   DMA_0.TCD[46].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD46_WORD_1   DMA_0.TCD[46].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD46_WORD_2_MLOOP DMA_0.TCD[46].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD46_WORD_2_NBYTES DMA_0.TCD[46].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD46_WORD_3   DMA_0.TCD[46].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD46_WORD_4   DMA_0.TCD[46].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD46_WORD_5   DMA_0.TCD[46].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD46_WORD_6   DMA_0.TCD[46].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD46_WORD_7   DMA_0.TCD[46].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD47_WORD_0   DMA_0.TCD[47].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD47_WORD_1   DMA_0.TCD[47].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD47_WORD_2_MLOOP DMA_0.TCD[47].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD47_WORD_2_NBYTES DMA_0.TCD[47].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD47_WORD_3   DMA_0.TCD[47].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD47_WORD_4   DMA_0.TCD[47].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD47_WORD_5   DMA_0.TCD[47].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD47_WORD_6   DMA_0.TCD[47].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD47_WORD_7   DMA_0.TCD[47].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD48_WORD_0   DMA_0.TCD[48].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD48_WORD_1   DMA_0.TCD[48].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD48_WORD_2_MLOOP DMA_0.TCD[48].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD48_WORD_2_NBYTES DMA_0.TCD[48].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD48_WORD_3   DMA_0.TCD[48].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD48_WORD_4   DMA_0.TCD[48].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD48_WORD_5   DMA_0.TCD[48].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD48_WORD_6   DMA_0.TCD[48].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD48_WORD_7   DMA_0.TCD[48].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD49_WORD_0   DMA_0.TCD[49].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD49_WORD_1   DMA_0.TCD[49].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD49_WORD_2_MLOOP DMA_0.TCD[49].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD49_WORD_2_NBYTES DMA_0.TCD[49].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD49_WORD_3   DMA_0.TCD[49].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD49_WORD_4   DMA_0.TCD[49].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD49_WORD_5   DMA_0.TCD[49].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD49_WORD_6   DMA_0.TCD[49].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD49_WORD_7   DMA_0.TCD[49].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD50_WORD_0   DMA_0.TCD[50].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD50_WORD_1   DMA_0.TCD[50].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD50_WORD_2_MLOOP DMA_0.TCD[50].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD50_WORD_2_NBYTES DMA_0.TCD[50].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD50_WORD_3   DMA_0.TCD[50].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD50_WORD_4   DMA_0.TCD[50].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD50_WORD_5   DMA_0.TCD[50].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD50_WORD_6   DMA_0.TCD[50].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD50_WORD_7   DMA_0.TCD[50].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD51_WORD_0   DMA_0.TCD[51].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD51_WORD_1   DMA_0.TCD[51].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD51_WORD_2_MLOOP DMA_0.TCD[51].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD51_WORD_2_NBYTES DMA_0.TCD[51].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD51_WORD_3   DMA_0.TCD[51].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD51_WORD_4   DMA_0.TCD[51].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD51_WORD_5   DMA_0.TCD[51].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD51_WORD_6   DMA_0.TCD[51].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD51_WORD_7   DMA_0.TCD[51].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD52_WORD_0   DMA_0.TCD[52].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD52_WORD_1   DMA_0.TCD[52].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD52_WORD_2_MLOOP DMA_0.TCD[52].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD52_WORD_2_NBYTES DMA_0.TCD[52].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD52_WORD_3   DMA_0.TCD[52].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD52_WORD_4   DMA_0.TCD[52].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD52_WORD_5   DMA_0.TCD[52].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD52_WORD_6   DMA_0.TCD[52].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD52_WORD_7   DMA_0.TCD[52].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD53_WORD_0   DMA_0.TCD[53].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD53_WORD_1   DMA_0.TCD[53].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD53_WORD_2_MLOOP DMA_0.TCD[53].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD53_WORD_2_NBYTES DMA_0.TCD[53].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD53_WORD_3   DMA_0.TCD[53].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD53_WORD_4   DMA_0.TCD[53].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD53_WORD_5   DMA_0.TCD[53].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD53_WORD_6   DMA_0.TCD[53].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD53_WORD_7   DMA_0.TCD[53].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD54_WORD_0   DMA_0.TCD[54].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD54_WORD_1   DMA_0.TCD[54].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD54_WORD_2_MLOOP DMA_0.TCD[54].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD54_WORD_2_NBYTES DMA_0.TCD[54].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD54_WORD_3   DMA_0.TCD[54].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD54_WORD_4   DMA_0.TCD[54].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD54_WORD_5   DMA_0.TCD[54].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD54_WORD_6   DMA_0.TCD[54].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD54_WORD_7   DMA_0.TCD[54].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD55_WORD_0   DMA_0.TCD[55].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD55_WORD_1   DMA_0.TCD[55].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD55_WORD_2_MLOOP DMA_0.TCD[55].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD55_WORD_2_NBYTES DMA_0.TCD[55].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD55_WORD_3   DMA_0.TCD[55].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD55_WORD_4   DMA_0.TCD[55].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD55_WORD_5   DMA_0.TCD[55].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD55_WORD_6   DMA_0.TCD[55].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD55_WORD_7   DMA_0.TCD[55].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD56_WORD_0   DMA_0.TCD[56].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD56_WORD_1   DMA_0.TCD[56].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD56_WORD_2_MLOOP DMA_0.TCD[56].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD56_WORD_2_NBYTES DMA_0.TCD[56].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD56_WORD_3   DMA_0.TCD[56].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD56_WORD_4   DMA_0.TCD[56].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD56_WORD_5   DMA_0.TCD[56].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD56_WORD_6   DMA_0.TCD[56].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD56_WORD_7   DMA_0.TCD[56].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD57_WORD_0   DMA_0.TCD[57].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD57_WORD_1   DMA_0.TCD[57].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD57_WORD_2_MLOOP DMA_0.TCD[57].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD57_WORD_2_NBYTES DMA_0.TCD[57].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD57_WORD_3   DMA_0.TCD[57].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD57_WORD_4   DMA_0.TCD[57].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD57_WORD_5   DMA_0.TCD[57].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD57_WORD_6   DMA_0.TCD[57].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD57_WORD_7   DMA_0.TCD[57].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD58_WORD_0   DMA_0.TCD[58].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD58_WORD_1   DMA_0.TCD[58].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD58_WORD_2_MLOOP DMA_0.TCD[58].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD58_WORD_2_NBYTES DMA_0.TCD[58].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD58_WORD_3   DMA_0.TCD[58].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD58_WORD_4   DMA_0.TCD[58].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD58_WORD_5   DMA_0.TCD[58].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD58_WORD_6   DMA_0.TCD[58].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD58_WORD_7   DMA_0.TCD[58].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD59_WORD_0   DMA_0.TCD[59].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD59_WORD_1   DMA_0.TCD[59].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD59_WORD_2_MLOOP DMA_0.TCD[59].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD59_WORD_2_NBYTES DMA_0.TCD[59].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD59_WORD_3   DMA_0.TCD[59].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD59_WORD_4   DMA_0.TCD[59].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD59_WORD_5   DMA_0.TCD[59].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD59_WORD_6   DMA_0.TCD[59].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD59_WORD_7   DMA_0.TCD[59].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD60_WORD_0   DMA_0.TCD[60].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD60_WORD_1   DMA_0.TCD[60].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD60_WORD_2_MLOOP DMA_0.TCD[60].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD60_WORD_2_NBYTES DMA_0.TCD[60].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD60_WORD_3   DMA_0.TCD[60].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD60_WORD_4   DMA_0.TCD[60].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD60_WORD_5   DMA_0.TCD[60].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD60_WORD_6   DMA_0.TCD[60].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD60_WORD_7   DMA_0.TCD[60].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD61_WORD_0   DMA_0.TCD[61].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD61_WORD_1   DMA_0.TCD[61].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD61_WORD_2_MLOOP DMA_0.TCD[61].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD61_WORD_2_NBYTES DMA_0.TCD[61].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD61_WORD_3   DMA_0.TCD[61].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD61_WORD_4   DMA_0.TCD[61].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD61_WORD_5   DMA_0.TCD[61].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD61_WORD_6   DMA_0.TCD[61].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD61_WORD_7   DMA_0.TCD[61].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD62_WORD_0   DMA_0.TCD[62].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD62_WORD_1   DMA_0.TCD[62].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD62_WORD_2_MLOOP DMA_0.TCD[62].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD62_WORD_2_NBYTES DMA_0.TCD[62].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD62_WORD_3   DMA_0.TCD[62].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD62_WORD_4   DMA_0.TCD[62].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD62_WORD_5   DMA_0.TCD[62].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD62_WORD_6   DMA_0.TCD[62].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD62_WORD_7   DMA_0.TCD[62].WORD_7.R        /* TCD Control and Status */
#define DMA_0_TCD63_WORD_0   DMA_0.TCD[63].WORD_0.R        /* TCD Source Address */
#define DMA_0_TCD63_WORD_1   DMA_0.TCD[63].WORD_1.R        /* TCD Transfer Attributes */
#define DMA_0_TCD63_WORD_2_MLOOP DMA_0.TCD[63].WORD_2.MLOOP.R /* TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
#define DMA_0_TCD63_WORD_2_NBYTES DMA_0.TCD[63].WORD_2.NBYTES.R /* TCD Number of bytes to be transferred */
#define DMA_0_TCD63_WORD_3   DMA_0.TCD[63].WORD_3.R        /* TCD Last Source Address Adjustment */
#define DMA_0_TCD63_WORD_4   DMA_0.TCD[63].WORD_4.R        /* TCD Destination Address */
#define DMA_0_TCD63_WORD_5   DMA_0.TCD[63].WORD_5.R        /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_0_TCD63_WORD_6   DMA_0.TCD[63].WORD_6.R        /* TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_0_TCD63_WORD_7   DMA_0.TCD[63].WORD_7.R        /* TCD Control and Status */

/* DMAMUX */
#define DMAMUX_0_CHCFG0      DMAMUX_0.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG1      DMAMUX_0.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG2      DMAMUX_0.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG3      DMAMUX_0.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG4      DMAMUX_0.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG5      DMAMUX_0.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG6      DMAMUX_0.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG7      DMAMUX_0.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG8      DMAMUX_0.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG9      DMAMUX_0.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG10     DMAMUX_0.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG11     DMAMUX_0.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG12     DMAMUX_0.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG13     DMAMUX_0.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG14     DMAMUX_0.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG15     DMAMUX_0.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_1_CHCFG0      DMAMUX_1.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG1      DMAMUX_1.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG2      DMAMUX_1.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG3      DMAMUX_1.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG4      DMAMUX_1.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG5      DMAMUX_1.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG6      DMAMUX_1.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG7      DMAMUX_1.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG8      DMAMUX_1.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG9      DMAMUX_1.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG10     DMAMUX_1.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG11     DMAMUX_1.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG12     DMAMUX_1.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG13     DMAMUX_1.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG14     DMAMUX_1.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG15     DMAMUX_1.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_2_CHCFG0      DMAMUX_2.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG1      DMAMUX_2.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG2      DMAMUX_2.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG3      DMAMUX_2.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG4      DMAMUX_2.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG5      DMAMUX_2.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG6      DMAMUX_2.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG7      DMAMUX_2.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG8      DMAMUX_2.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG9      DMAMUX_2.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG10     DMAMUX_2.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG11     DMAMUX_2.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG12     DMAMUX_2.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG13     DMAMUX_2.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG14     DMAMUX_2.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG15     DMAMUX_2.CHCFG[15].R          /* Channel Configuration register */

#define DMAMUX_3_CHCFG0      DMAMUX_3.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG1      DMAMUX_3.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG2      DMAMUX_3.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG3      DMAMUX_3.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG4      DMAMUX_3.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG5      DMAMUX_3.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG6      DMAMUX_3.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG7      DMAMUX_3.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG8      DMAMUX_3.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG9      DMAMUX_3.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG10     DMAMUX_3.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG11     DMAMUX_3.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG12     DMAMUX_3.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG13     DMAMUX_3.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG14     DMAMUX_3.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG15     DMAMUX_3.CHCFG[15].R          /* Channel Configuration register */

/* DSPI */
#define DSPI_0_MCR           DSPI_0.MCR.R                  /* Module Configuration Register */
#define DSPI_0_TCR           DSPI_0.TCR.R                  /* Transfer Count Register */
#define DSPI_0_CTAR0         DSPI_0.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR1         DSPI_0.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR2         DSPI_0.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR3         DSPI_0.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR4         DSPI_0.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR5         DSPI_0.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR6         DSPI_0.MODE.CTAR[6].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR7         DSPI_0.MODE.CTAR[7].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR0_SLAVE   DSPI_0.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_0_CTAR1_SLAVE   DSPI_0.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_0_SR            DSPI_0.SR.R                   /* Status Register */
#define DSPI_0_RSER          DSPI_0.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_0_PUSHR         DSPI_0.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_0_PUSHR_SLAVE   DSPI_0.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_0_POPR          DSPI_0.POPR.R                 /* POP RX FIFO Register */
#define DSPI_0_TXFR0         DSPI_0.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_0_TXFR1         DSPI_0.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_0_TXFR2         DSPI_0.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_0_TXFR3         DSPI_0.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_0_RXFR0         DSPI_0.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_0_RXFR1         DSPI_0.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_0_RXFR2         DSPI_0.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_0_RXFR3         DSPI_0.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_0_DSICR0        DSPI_0.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_0_SDR0          DSPI_0.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_0_ASDR0         DSPI_0.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_0_COMPR0        DSPI_0.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_0_DSICR1        DSPI_0.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_0_SSR0          DSPI_0.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_0_SDR1          DSPI_0.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_0_ASDR1         DSPI_0.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_0_COMPR1        DSPI_0.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_0_DDR1          DSPI_0.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_0_SSR1          DSPI_0.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_0_DIMR1         DSPI_0.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_0_DPIR1         DSPI_0.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_0_CTARE0        DSPI_0.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE1        DSPI_0.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE2        DSPI_0.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE3        DSPI_0.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE4        DSPI_0.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE5        DSPI_0.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE6        DSPI_0.CTARE[6].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE7        DSPI_0.CTARE[7].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_0_SREX          DSPI_0.SREX.R                 /* Status Register Extended */
#define DSPI_0_TRIG          DSPI_0.TRIG.R                 /* Trigger Register */
#define DSPI_0_TSL           DSPI_0.TSL.R                  /* Time Slot Length Register */
#define DSPI_0_TS_CONF       DSPI_0.TS_CONF.R              /* Time Slot Configuration Register */

#define DSPI_1_MCR           DSPI_1.MCR.R                  /* Module Configuration Register */
#define DSPI_1_TCR           DSPI_1.TCR.R                  /* Transfer Count Register */
#define DSPI_1_CTAR0         DSPI_1.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR1         DSPI_1.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR2         DSPI_1.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR3         DSPI_1.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR4         DSPI_1.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR5         DSPI_1.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR6         DSPI_1.MODE.CTAR[6].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR7         DSPI_1.MODE.CTAR[7].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR0_SLAVE   DSPI_1.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_1_CTAR1_SLAVE   DSPI_1.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_1_SR            DSPI_1.SR.R                   /* Status Register */
#define DSPI_1_RSER          DSPI_1.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_1_PUSHR         DSPI_1.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_1_PUSHR_SLAVE   DSPI_1.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_1_POPR          DSPI_1.POPR.R                 /* POP RX FIFO Register */
#define DSPI_1_TXFR0         DSPI_1.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_1_TXFR1         DSPI_1.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_1_TXFR2         DSPI_1.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_1_TXFR3         DSPI_1.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_1_RXFR0         DSPI_1.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_1_RXFR1         DSPI_1.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_1_RXFR2         DSPI_1.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_1_RXFR3         DSPI_1.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_1_DSICR0        DSPI_1.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_1_SDR0          DSPI_1.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_1_ASDR0         DSPI_1.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_1_COMPR0        DSPI_1.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_1_DSICR1        DSPI_1.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_1_SSR0          DSPI_1.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_1_SDR1          DSPI_1.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_1_ASDR1         DSPI_1.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_1_COMPR1        DSPI_1.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_1_DDR1          DSPI_1.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_1_SSR1          DSPI_1.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_1_DIMR1         DSPI_1.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_1_DPIR1         DSPI_1.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_1_CTARE0        DSPI_1.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE1        DSPI_1.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE2        DSPI_1.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE3        DSPI_1.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE4        DSPI_1.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE5        DSPI_1.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE6        DSPI_1.CTARE[6].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE7        DSPI_1.CTARE[7].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_1_SREX          DSPI_1.SREX.R                 /* Status Register Extended */
#define DSPI_1_TRIG          DSPI_1.TRIG.R                 /* Trigger Register */
#define DSPI_1_TSL           DSPI_1.TSL.R                  /* Time Slot Length Register */
#define DSPI_1_TS_CONF       DSPI_1.TS_CONF.R              /* Time Slot Configuration Register */

#define DSPI_2_MCR           DSPI_2.MCR.R                  /* Module Configuration Register */
#define DSPI_2_TCR           DSPI_2.TCR.R                  /* Transfer Count Register */
#define DSPI_2_CTAR0         DSPI_2.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR1         DSPI_2.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR2         DSPI_2.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR3         DSPI_2.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR4         DSPI_2.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR5         DSPI_2.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR6         DSPI_2.MODE.CTAR[6].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR7         DSPI_2.MODE.CTAR[7].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR0_SLAVE   DSPI_2.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_2_CTAR1_SLAVE   DSPI_2.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_2_SR            DSPI_2.SR.R                   /* Status Register */
#define DSPI_2_RSER          DSPI_2.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_2_PUSHR         DSPI_2.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_2_PUSHR_SLAVE   DSPI_2.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_2_POPR          DSPI_2.POPR.R                 /* POP RX FIFO Register */
#define DSPI_2_TXFR0         DSPI_2.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_2_TXFR1         DSPI_2.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_2_TXFR2         DSPI_2.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_2_TXFR3         DSPI_2.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_2_RXFR0         DSPI_2.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_2_RXFR1         DSPI_2.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_2_RXFR2         DSPI_2.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_2_RXFR3         DSPI_2.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_2_DSICR0        DSPI_2.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_2_SDR0          DSPI_2.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_2_ASDR0         DSPI_2.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_2_COMPR0        DSPI_2.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_2_DSICR1        DSPI_2.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_2_SSR0          DSPI_2.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_2_SDR1          DSPI_2.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_2_ASDR1         DSPI_2.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_2_COMPR1        DSPI_2.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_2_DDR1          DSPI_2.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_2_SSR1          DSPI_2.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_2_DIMR1         DSPI_2.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_2_DPIR1         DSPI_2.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_2_CTARE0        DSPI_2.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE1        DSPI_2.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE2        DSPI_2.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE3        DSPI_2.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE4        DSPI_2.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE5        DSPI_2.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE6        DSPI_2.CTARE[6].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE7        DSPI_2.CTARE[7].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_2_SREX          DSPI_2.SREX.R                 /* Status Register Extended */
#define DSPI_2_TRIG          DSPI_2.TRIG.R                 /* Trigger Register */
#define DSPI_2_TSL           DSPI_2.TSL.R                  /* Time Slot Length Register */
#define DSPI_2_TS_CONF       DSPI_2.TS_CONF.R              /* Time Slot Configuration Register */

#define DSPI_3_MCR           DSPI_3.MCR.R                  /* Module Configuration Register */
#define DSPI_3_TCR           DSPI_3.TCR.R                  /* Transfer Count Register */
#define DSPI_3_CTAR0         DSPI_3.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR1         DSPI_3.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR2         DSPI_3.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR3         DSPI_3.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR4         DSPI_3.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR5         DSPI_3.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR6         DSPI_3.MODE.CTAR[6].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR7         DSPI_3.MODE.CTAR[7].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR0_SLAVE   DSPI_3.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_3_CTAR1_SLAVE   DSPI_3.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_3_SR            DSPI_3.SR.R                   /* Status Register */
#define DSPI_3_RSER          DSPI_3.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_3_PUSHR         DSPI_3.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_3_PUSHR_SLAVE   DSPI_3.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_3_POPR          DSPI_3.POPR.R                 /* POP RX FIFO Register */
#define DSPI_3_TXFR0         DSPI_3.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_3_TXFR1         DSPI_3.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_3_TXFR2         DSPI_3.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_3_TXFR3         DSPI_3.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_3_RXFR0         DSPI_3.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_3_RXFR1         DSPI_3.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_3_RXFR2         DSPI_3.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_3_RXFR3         DSPI_3.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_3_DSICR0        DSPI_3.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_3_SDR0          DSPI_3.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_3_ASDR0         DSPI_3.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_3_COMPR0        DSPI_3.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_3_DSICR1        DSPI_3.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_3_SSR0          DSPI_3.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_3_SDR1          DSPI_3.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_3_ASDR1         DSPI_3.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_3_COMPR1        DSPI_3.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_3_DDR1          DSPI_3.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_3_SSR1          DSPI_3.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_3_DIMR1         DSPI_3.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_3_DPIR1         DSPI_3.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_3_CTARE0        DSPI_3.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE1        DSPI_3.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE2        DSPI_3.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE3        DSPI_3.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE4        DSPI_3.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE5        DSPI_3.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE6        DSPI_3.CTARE[6].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE7        DSPI_3.CTARE[7].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_3_SREX          DSPI_3.SREX.R                 /* Status Register Extended */
#define DSPI_3_TRIG          DSPI_3.TRIG.R                 /* Trigger Register */
#define DSPI_3_TSL           DSPI_3.TSL.R                  /* Time Slot Length Register */
#define DSPI_3_TS_CONF       DSPI_3.TS_CONF.R              /* Time Slot Configuration Register */

#define DSPI_4_MCR           DSPI_4.MCR.R                  /* Module Configuration Register */
#define DSPI_4_TCR           DSPI_4.TCR.R                  /* Transfer Count Register */
#define DSPI_4_CTAR0         DSPI_4.MODE.CTAR[0].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR1         DSPI_4.MODE.CTAR[1].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR2         DSPI_4.MODE.CTAR[2].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR3         DSPI_4.MODE.CTAR[3].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR4         DSPI_4.MODE.CTAR[4].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR5         DSPI_4.MODE.CTAR[5].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR6         DSPI_4.MODE.CTAR[6].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR7         DSPI_4.MODE.CTAR[7].R         /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR0_SLAVE   DSPI_4.MODE.CTAR_SLAVE[0].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_4_CTAR1_SLAVE   DSPI_4.MODE.CTAR_SLAVE[1].R   /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_4_SR            DSPI_4.SR.R                   /* Status Register */
#define DSPI_4_RSER          DSPI_4.RSER.R                 /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_4_PUSHR         DSPI_4.PUSHR.PUSHR.R          /* PUSH TX FIFO Register In Master Mode */
#define DSPI_4_PUSHR_SLAVE   DSPI_4.PUSHR.PUSHR_SLAVE.R    /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_4_POPR          DSPI_4.POPR.R                 /* POP RX FIFO Register */
#define DSPI_4_TXFR0         DSPI_4.TXFR[0].R              /* Transmit FIFO Registers */
#define DSPI_4_TXFR1         DSPI_4.TXFR[1].R              /* Transmit FIFO Registers */
#define DSPI_4_TXFR2         DSPI_4.TXFR[2].R              /* Transmit FIFO Registers */
#define DSPI_4_TXFR3         DSPI_4.TXFR[3].R              /* Transmit FIFO Registers */
#define DSPI_4_RXFR0         DSPI_4.RXFR[0].R              /* Receive FIFO Registers */
#define DSPI_4_RXFR1         DSPI_4.RXFR[1].R              /* Receive FIFO Registers */
#define DSPI_4_RXFR2         DSPI_4.RXFR[2].R              /* Receive FIFO Registers */
#define DSPI_4_RXFR3         DSPI_4.RXFR[3].R              /* Receive FIFO Registers */
#define DSPI_4_DSICR0        DSPI_4.DSICR0.R               /* DSI Configuration Register 0 */
#define DSPI_4_SDR0          DSPI_4.SDR0.R                 /* DSI Serialization Data Register 0 */
#define DSPI_4_ASDR0         DSPI_4.ASDR0.R                /* DSI Alternate Serialization Data Register 0 */
#define DSPI_4_COMPR0        DSPI_4.COMPR0.R               /* DSI Transmit Comparison Register 0 */
#define DSPI_4_DSICR1        DSPI_4.DSICR1.R               /* DSI Configuration Register 1 */
#define DSPI_4_SSR0          DSPI_4.SSR0.R                 /* DSI Serialization Source Select Register 0 */
#define DSPI_4_SDR1          DSPI_4.SDR1.R                 /* DSI Serialization Data Register 1 */
#define DSPI_4_ASDR1         DSPI_4.ASDR1.R                /* DSI Alternate Serialization Data Register 1 */
#define DSPI_4_COMPR1        DSPI_4.COMPR1.R               /* DSI Transmit Comparison Register 1 */
#define DSPI_4_DDR1          DSPI_4.DDR1.R                 /* DSI Deserialization Data Register 1 */
#define DSPI_4_SSR1          DSPI_4.SSR1.R                 /* DSI Serialization Source Select Register 1 */
#define DSPI_4_DIMR1         DSPI_4.DIMR1.R                /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_4_DPIR1         DSPI_4.DPIR1.R                /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_4_CTARE0        DSPI_4.CTARE[0].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE1        DSPI_4.CTARE[1].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE2        DSPI_4.CTARE[2].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE3        DSPI_4.CTARE[3].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE4        DSPI_4.CTARE[4].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE5        DSPI_4.CTARE[5].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE6        DSPI_4.CTARE[6].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE7        DSPI_4.CTARE[7].R             /* Clock and Transfer Attributes Register Extended */
#define DSPI_4_SREX          DSPI_4.SREX.R                 /* Status Register Extended */
#define DSPI_4_TRIG          DSPI_4.TRIG.R                 /* Trigger Register */
#define DSPI_4_TSL           DSPI_4.TSL.R                  /* Time Slot Length Register */
#define DSPI_4_TS_CONF       DSPI_4.TS_CONF.R              /* Time Slot Configuration Register */

#define DSPI_M0_MCR          DSPI_M0.MCR.R                 /* Module Configuration Register */
#define DSPI_M0_TCR          DSPI_M0.TCR.R                 /* Transfer Count Register */
#define DSPI_M0_CTAR0        DSPI_M0.MODE.CTAR[0].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR1        DSPI_M0.MODE.CTAR[1].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR2        DSPI_M0.MODE.CTAR[2].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR3        DSPI_M0.MODE.CTAR[3].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR4        DSPI_M0.MODE.CTAR[4].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR5        DSPI_M0.MODE.CTAR[5].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR6        DSPI_M0.MODE.CTAR[6].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR7        DSPI_M0.MODE.CTAR[7].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M0_CTAR0_SLAVE  DSPI_M0.MODE.CTAR_SLAVE[0].R  /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_M0_CTAR1_SLAVE  DSPI_M0.MODE.CTAR_SLAVE[1].R  /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_M0_SR           DSPI_M0.SR.R                  /* Status Register */
#define DSPI_M0_RSER         DSPI_M0.RSER.R                /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_M0_PUSHR        DSPI_M0.PUSHR.PUSHR.R         /* PUSH TX FIFO Register In Master Mode */
#define DSPI_M0_PUSHR_SLAVE  DSPI_M0.PUSHR.PUSHR_SLAVE.R   /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_M0_POPR         DSPI_M0.POPR.R                /* POP RX FIFO Register */
#define DSPI_M0_TXFR0        DSPI_M0.TXFR[0].R             /* Transmit FIFO Registers */
#define DSPI_M0_TXFR1        DSPI_M0.TXFR[1].R             /* Transmit FIFO Registers */
#define DSPI_M0_TXFR2        DSPI_M0.TXFR[2].R             /* Transmit FIFO Registers */
#define DSPI_M0_TXFR3        DSPI_M0.TXFR[3].R             /* Transmit FIFO Registers */
#define DSPI_M0_RXFR0        DSPI_M0.RXFR[0].R             /* Receive FIFO Registers */
#define DSPI_M0_RXFR1        DSPI_M0.RXFR[1].R             /* Receive FIFO Registers */
#define DSPI_M0_RXFR2        DSPI_M0.RXFR[2].R             /* Receive FIFO Registers */
#define DSPI_M0_RXFR3        DSPI_M0.RXFR[3].R             /* Receive FIFO Registers */
#define DSPI_M0_DSICR0       DSPI_M0.DSICR0.R              /* DSI Configuration Register 0 */
#define DSPI_M0_SDR0         DSPI_M0.SDR0.R                /* DSI Serialization Data Register 0 */
#define DSPI_M0_ASDR0        DSPI_M0.ASDR0.R               /* DSI Alternate Serialization Data Register 0 */
#define DSPI_M0_COMPR0       DSPI_M0.COMPR0.R              /* DSI Transmit Comparison Register 0 */
#define DSPI_M0_DSICR1       DSPI_M0.DSICR1.R              /* DSI Configuration Register 1 */
#define DSPI_M0_SSR0         DSPI_M0.SSR0.R                /* DSI Serialization Source Select Register 0 */
#define DSPI_M0_SDR1         DSPI_M0.SDR1.R                /* DSI Serialization Data Register 1 */
#define DSPI_M0_ASDR1        DSPI_M0.ASDR1.R               /* DSI Alternate Serialization Data Register 1 */
#define DSPI_M0_COMPR1       DSPI_M0.COMPR1.R              /* DSI Transmit Comparison Register 1 */
#define DSPI_M0_DDR1         DSPI_M0.DDR1.R                /* DSI Deserialization Data Register 1 */
#define DSPI_M0_SSR1         DSPI_M0.SSR1.R                /* DSI Serialization Source Select Register 1 */
#define DSPI_M0_DIMR1        DSPI_M0.DIMR1.R               /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_M0_DPIR1        DSPI_M0.DPIR1.R               /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_M0_CTARE0       DSPI_M0.CTARE[0].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE1       DSPI_M0.CTARE[1].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE2       DSPI_M0.CTARE[2].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE3       DSPI_M0.CTARE[3].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE4       DSPI_M0.CTARE[4].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE5       DSPI_M0.CTARE[5].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE6       DSPI_M0.CTARE[6].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_CTARE7       DSPI_M0.CTARE[7].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M0_SREX         DSPI_M0.SREX.R                /* Status Register Extended */
#define DSPI_M0_TRIG         DSPI_M0.TRIG.R                /* Trigger Register */
#define DSPI_M0_TSL          DSPI_M0.TSL.R                 /* Time Slot Length Register */
#define DSPI_M0_TS_CONF      DSPI_M0.TS_CONF.R             /* Time Slot Configuration Register */

#define DSPI_M1_MCR          DSPI_M1.MCR.R                 /* Module Configuration Register */
#define DSPI_M1_TCR          DSPI_M1.TCR.R                 /* Transfer Count Register */
#define DSPI_M1_CTAR0        DSPI_M1.MODE.CTAR[0].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR1        DSPI_M1.MODE.CTAR[1].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR2        DSPI_M1.MODE.CTAR[2].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR3        DSPI_M1.MODE.CTAR[3].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR4        DSPI_M1.MODE.CTAR[4].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR5        DSPI_M1.MODE.CTAR[5].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR6        DSPI_M1.MODE.CTAR[6].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR7        DSPI_M1.MODE.CTAR[7].R        /* Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_M1_CTAR0_SLAVE  DSPI_M1.MODE.CTAR_SLAVE[0].R  /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_M1_CTAR1_SLAVE  DSPI_M1.MODE.CTAR_SLAVE[1].R  /* Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_M1_SR           DSPI_M1.SR.R                  /* Status Register */
#define DSPI_M1_RSER         DSPI_M1.RSER.R                /* DMA/Interrupt Request Select and Enable Register */
#define DSPI_M1_PUSHR        DSPI_M1.PUSHR.PUSHR.R         /* PUSH TX FIFO Register In Master Mode */
#define DSPI_M1_PUSHR_SLAVE  DSPI_M1.PUSHR.PUSHR_SLAVE.R   /* PUSH TX FIFO Register In Slave Mode */
#define DSPI_M1_POPR         DSPI_M1.POPR.R                /* POP RX FIFO Register */
#define DSPI_M1_TXFR0        DSPI_M1.TXFR[0].R             /* Transmit FIFO Registers */
#define DSPI_M1_TXFR1        DSPI_M1.TXFR[1].R             /* Transmit FIFO Registers */
#define DSPI_M1_TXFR2        DSPI_M1.TXFR[2].R             /* Transmit FIFO Registers */
#define DSPI_M1_TXFR3        DSPI_M1.TXFR[3].R             /* Transmit FIFO Registers */
#define DSPI_M1_RXFR0        DSPI_M1.RXFR[0].R             /* Receive FIFO Registers */
#define DSPI_M1_RXFR1        DSPI_M1.RXFR[1].R             /* Receive FIFO Registers */
#define DSPI_M1_RXFR2        DSPI_M1.RXFR[2].R             /* Receive FIFO Registers */
#define DSPI_M1_RXFR3        DSPI_M1.RXFR[3].R             /* Receive FIFO Registers */
#define DSPI_M1_DSICR0       DSPI_M1.DSICR0.R              /* DSI Configuration Register 0 */
#define DSPI_M1_SDR0         DSPI_M1.SDR0.R                /* DSI Serialization Data Register 0 */
#define DSPI_M1_ASDR0        DSPI_M1.ASDR0.R               /* DSI Alternate Serialization Data Register 0 */
#define DSPI_M1_COMPR0       DSPI_M1.COMPR0.R              /* DSI Transmit Comparison Register 0 */
#define DSPI_M1_DSICR1       DSPI_M1.DSICR1.R              /* DSI Configuration Register 1 */
#define DSPI_M1_SSR0         DSPI_M1.SSR0.R                /* DSI Serialization Source Select Register 0 */
#define DSPI_M1_SDR1         DSPI_M1.SDR1.R                /* DSI Serialization Data Register 1 */
#define DSPI_M1_ASDR1        DSPI_M1.ASDR1.R               /* DSI Alternate Serialization Data Register 1 */
#define DSPI_M1_COMPR1       DSPI_M1.COMPR1.R              /* DSI Transmit Comparison Register 1 */
#define DSPI_M1_DDR1         DSPI_M1.DDR1.R                /* DSI Deserialization Data Register 1 */
#define DSPI_M1_SSR1         DSPI_M1.SSR1.R                /* DSI Serialization Source Select Register 1 */
#define DSPI_M1_DIMR1        DSPI_M1.DIMR1.R               /* DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_M1_DPIR1        DSPI_M1.DPIR1.R               /* DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_M1_CTARE0       DSPI_M1.CTARE[0].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE1       DSPI_M1.CTARE[1].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE2       DSPI_M1.CTARE[2].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE3       DSPI_M1.CTARE[3].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE4       DSPI_M1.CTARE[4].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE5       DSPI_M1.CTARE[5].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE6       DSPI_M1.CTARE[6].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_CTARE7       DSPI_M1.CTARE[7].R            /* Clock and Transfer Attributes Register Extended */
#define DSPI_M1_SREX         DSPI_M1.SREX.R                /* Status Register Extended */
#define DSPI_M1_TRIG         DSPI_M1.TRIG.R                /* Trigger Register */
#define DSPI_M1_TSL          DSPI_M1.TSL.R                 /* Time Slot Length Register */
#define DSPI_M1_TS_CONF      DSPI_M1.TS_CONF.R             /* Time Slot Configuration Register */

/* DTS */
#define DTS_ENABLE           DTS.ENABLE.R                  /* Output Enable Register */
#define DTS_STARTUP          DTS.STARTUP.R                 /* Startup Register */
#define DTS_SEMAPHORE        DTS.SEMAPHORE.R               /* Semaphore Register */
#define DTS_SEMAPHORE_B      DTS.SEMAPHORE_B.R             /* Semaphore Extension */

/* EIM */
#define EIM_EIMCR            EIM.EIMCR.R                   /* Error Injection Module Configuration Register */
#define EIM_EICHEN           EIM.EICHEN.R                  /* Error Injection Channel Enable register */
#define EIM_EICHD0_WORD0     EIM.EICHD_WORD0.R             /* Error Injection Channel Descriptor, Word0 */
#define EIM_EICHD0_WORD1     EIM.EICHD_WORD1.R             /* Error Injection Channel Descriptor, Word1 */
#define EIM_EICHD0_WORD2     EIM.EICHD_WORD2.R             /* Error Injection Channel Descriptor, Word2 */

/* FCCU */
#define FCCU_CTRL            FCCU.CTRL.R                   /* Control Register */
#define FCCU_CTRLK           FCCU.CTRLK.R                  /* CTRL Key Register */
#define FCCU_CFG             FCCU.CFG.R                    /* Configuration Register */
#define FCCU_NCF_CFG0        FCCU.NCF_CFG[0].R             /* NCF Configuration Register */
#define FCCU_NCF_CFG1        FCCU.NCF_CFG[1].R             /* NCF Configuration Register */
#define FCCU_NCF_CFG2        FCCU.NCF_CFG[2].R             /* NCF Configuration Register */
#define FCCU_NCFS_CFG0       FCCU.NCFS_CFG[0].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG1       FCCU.NCFS_CFG[1].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG2       FCCU.NCFS_CFG[2].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG3       FCCU.NCFS_CFG[3].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG4       FCCU.NCFS_CFG[4].R            /* NCFS Configuration Register */
#define FCCU_NCFS_CFG5       FCCU.NCFS_CFG[5].R            /* NCFS Configuration Register */
#define FCCU_NCF_S0          FCCU.NCF_S[0].R               /* NCF Status Register */
#define FCCU_NCF_S1          FCCU.NCF_S[1].R               /* NCF Status Register */
#define FCCU_NCF_S2          FCCU.NCF_S[2].R               /* NCF Status Register */
#define FCCU_NCFK            FCCU.NCFK.R                   /* NCF Key Register */
#define FCCU_NCF_E0          FCCU.NCF_E[0].R               /* NCF Enable Register */
#define FCCU_NCF_E1          FCCU.NCF_E[1].R               /* NCF Enable Register */
#define FCCU_NCF_E2          FCCU.NCF_E[2].R               /* NCF Enable Register */
#define FCCU_NCF_TOE0        FCCU.NCF_TOE[0].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TOE1        FCCU.NCF_TOE[1].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TOE2        FCCU.NCF_TOE[2].R             /* NCF Time-out Enable Register */
#define FCCU_NCF_TO          FCCU.NCF_TO.R                 /* NCF Time-out Register */
#define FCCU_CFG_TO          FCCU.CFG_TO.R                 /* CFG Timeout Register */
#define FCCU_EINOUT          FCCU.EINOUT.R                 /* IO Control Register */
#define FCCU_STAT            FCCU.STAT.R                   /* Status Register */
#define FCCU_N2AF_STATUS     FCCU.N2AF_STATUS.R            /* NA Freeze Status Register */
#define FCCU_A2FF_STATUS     FCCU.A2FF_STATUS.R            /* AF Freeze Status Register */
#define FCCU_N2FF_STATUS     FCCU.N2FF_STATUS.R            /* NF Freeze Status Register */
#define FCCU_F2A_STATUS      FCCU.F2A_STATUS.R             /* FA Freeze Status Register */
#define FCCU_SCFS            FCCU.SCFS.R                   /* SC Freeze Status Register */
#define FCCU_NCFF            FCCU.NCFF.R                   /* NCF Fake Register */
#define FCCU_IRQ_STAT        FCCU.IRQ_STAT.R               /* IRQ Status Register */
#define FCCU_IRQ_EN          FCCU.IRQ_EN.R                 /* IRQ Enable Register */
#define FCCU_XTMR            FCCU.XTMR.R                   /* XTMR Register */
#define FCCU_MCS             FCCU.MCS.R                    /* MCS Register */
#define FCCU_TRANS_LOCK      FCCU.TRANS_LOCK.R             /* Transient Lock Register */
#define FCCU_PERMNT_LOCK     FCCU.PERMNT_LOCK.R            /* Permanent Lock Register */
#define FCCU_DELTA_T         FCCU.DELTA_T.R                /* Delta T Register */
#define FCCU_IRQ_ALARM_EN0   FCCU.IRQ_ALARM_EN[0].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN1   FCCU.IRQ_ALARM_EN[1].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN2   FCCU.IRQ_ALARM_EN[2].R        /* IRQ Alarm Enable Register */
#define FCCU_NMI_EN0         FCCU.NMI_EN[0].R              /* NMI Enable Register */
#define FCCU_NMI_EN1         FCCU.NMI_EN[1].R              /* NMI Enable Register */
#define FCCU_NMI_EN2         FCCU.NMI_EN[2].R              /* NMI Enable Register */
#define FCCU_EOUT_SIG_EN0    FCCU.EOUT_SIG_EN[0].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN1    FCCU.EOUT_SIG_EN[1].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN2    FCCU.EOUT_SIG_EN[2].R         /* EOUT Signaling Enable Register */

/* FEC */
#define FEC_EIR              FEC.EIR.R                     /* Interrupt Event Register */
#define FEC_EIMR             FEC.EIMR.R                    /* Interrupt Mask Register */
#define FEC_RDAR             FEC.RDAR.R                    /* Receive Descriptor Active Register */
#define FEC_TDAR             FEC.TDAR.R                    /* Transmit Descriptor Active Register */
#define FEC_ECR              FEC.ECR.R                     /* Ethernet Control Register */
#define FEC_MMFR             FEC.MMFR.R                    /* MII Management Frame Register */
#define FEC_MSCR             FEC.MSCR.R                    /* MII Speed Control Register */
#define FEC_MIBC             FEC.MIBC.R                    /* MIB Control Register */
#define FEC_RCR              FEC.RCR.R                     /* Receive Control Register */
#define FEC_TCR              FEC.TCR.R                     /* Transmit Control Register */
#define FEC_PALR             FEC.PALR.R                    /* Physical Address Low Register */
#define FEC_PAUR             FEC.PAUR.R                    /* Physical Address High Register and Type Field */
#define FEC_OPD              FEC.OPD.R                     /* Opcode/Pause Duration */
#define FEC_IAUR             FEC.IAUR.R                    /* Descriptor Individual Upper Address Register */
#define FEC_IALR             FEC.IALR.R                    /* Descriptor Individual Lower Address Register */
#define FEC_GAUR             FEC.GAUR.R                    /* Descriptor Group Upper Address Register */
#define FEC_GALR             FEC.GALR.R                    /* Descriptor Group Lower Address Register */
#define FEC_TFWR             FEC.TFWR.R                    /* Transmit FIFO Watermark */
#define FEC_FRBR             FEC.FRBR.R                    /* FIFO Receive Bound Register */
#define FEC_FRSR             FEC.FRSR.R                    /* FIFO Receive Start Register */
#define FEC_ERDSR            FEC.ERDSR.R                   /* Receive Descriptor Ring Start Register */
#define FEC_ETDSR            FEC.ETDSR.R                   /* Transmit Buffer Descriptor Ring Start Register */
#define FEC_EMRBR            FEC.EMRBR.R                   /* Receive Buffer Size Register */
#define FEC_RMON_T_DROP      FEC.RMON_T_DROP.R             /* Count of frames not counted correctly */
#define FEC_RMON_T_PACKETS   FEC.RMON_T_PACKETS.R          /* RMON Tx packet count */
#define FEC_RMON_T_BC_PKT    FEC.RMON_T_BC_PKT.R           /* RMON Tx broadcast packets */
#define FEC_RMON_T_MC_PKT    FEC.RMON_T_MC_PKT.R           /* RMON Tx multicast packets */
#define FEC_RMON_T_CRC_ALIGN FEC.RMON_T_CRC_ALIGN.R        /* RMON Tx packets with CRC/align error */
#define FEC_RMON_T_UNDERSIZE FEC.RMON_T_UNDERSIZE.R        /* RMON Tx packets < 64 bytes, good CRC */
#define FEC_RMON_T_OVERSIZE  FEC.RMON_T_OVERSIZE.R         /* RMON Tx packets > MAX_FL bytes, good CRC */
#define FEC_RMON_T_FRAG      FEC.RMON_T_FRAG.R             /* RMON Tx packets < 64 bytes, bad CRC */
#define FEC_RMON_T_JAB       FEC.RMON_T_JAB.R              /* RMON Tx packets > MAX_FL bytes, bad CRC */
#define FEC_RMON_T_COL       FEC.RMON_T_COL.R              /* RMON Tx collision count */
#define FEC_RMON_T_P64       FEC.RMON_T_P64.R              /* RMON Tx 64 byte packets */
#define FEC_RMON_T_P65TO127  FEC.RMON_T_P65TO127.R         /* RMON Tx 65 to 127 byte packets */
#define FEC_RMON_T_P128TO255 FEC.RMON_T_P128TO255.R        /* RMON Tx 128 to 255 byte packets */
#define FEC_RMON_T_P256TO511 FEC.RMON_T_P256TO511.R        /* RMON Tx 256 to 511 byte packets */
#define FEC_RMON_T_P512TO1023 FEC.RMON_T_P512TO1023.R      /* RMON Tx 512 to 1023 byte packets */
#define FEC_RMON_T_P1024TO2047 FEC.RMON_T_P1024TO2047.R    /* RMON Tx 1024 to 2047 byte packets */
#define FEC_RMON_T_P_GTE2048 FEC.RMON_T_P_GTE2048.R        /* RMON Tx packets with > 2048 bytes */
#define FEC_RMON_T_OCTETS    FEC.RMON_T_OCTETS.R           /* RMON Tx Octets */
#define FEC_IEEE_T_DROP      FEC.IEEE_T_DROP.R             /* Count of transmitted frames not counted correctly */
#define FEC_IEEE_T_FRAME_OK  FEC.IEEE_T_FRAME_OK.R         /* Frames transmitted OK */
#define FEC_IEEE_T_1COL      FEC.IEEE_T_1COL.R             /* Frames transmitted with single collision */
#define FEC_IEEE_T_MCOL      FEC.IEEE_T_MCOL.R             /* Frames transmitted with multiple collisions */
#define FEC_IEEE_T_DEF       FEC.IEEE_T_DEF.R              /* Frames transmitted after deferral delay */
#define FEC_IEEE_T_LCOL      FEC.IEEE_T_LCOL.R             /* Frames transmitted with late collision */
#define FEC_IEEE_T_EXCOL     FEC.IEEE_T_EXCOL.R            /* Frames transmitted with excessive collisions */
#define FEC_IEEE_T_MACERR    FEC.IEEE_T_MACERR.R           /* Frames transmitted with Tx FIFO underrun */
#define FEC_IEEE_T_CSERR     FEC.IEEE_T_CSERR.R            /* Frames transmitted with carrier sense error */
#define FEC_IEEE_T_SQE       FEC.IEEE_T_SQE.R              /* Frames transmitted with SQE error */
#define FEC_IEEE_T_FDXFC     FEC.IEEE_T_FDXFC.R            /* Flow control pause frames transmitted */
#define FEC_IEEE_T_OCTETS_OK FEC.IEEE_T_OCTETS_OK.R        /* Octet count for frames transmitted without error */
#define FEC_RMON_R_DROP      FEC.RMON_R_DROP.R             /* Count of received frames not counted correctly */
#define FEC_RMON_R_PACKETS   FEC.RMON_R_PACKETS.R          /* RMON Rx packet count */
#define FEC_RMON_R_BC_PKT    FEC.RMON_R_BC_PKT.R           /* RMON Rx broadcast packets */
#define FEC_RMON_R_MC_PKT    FEC.RMON_R_MC_PKT.R           /* RMON Rx multicast packets */
#define FEC_RMON_R_CRC_ALIGN FEC.RMON_R_CRC_ALIGN.R        /* RMON Rx packets with CRC/Align error */
#define FEC_RMON_R_UNDERSIZE FEC.RMON_R_UNDERSIZE.R        /* RMON Rx packets < 64 bytes, good CRC */
#define FEC_RMON_R_OVERSIZE  FEC.RMON_R_OVERSIZE.R         /* RMON Rx packets > MAX_FL bytes, good CRC */
#define FEC_RMON_R_FRAG      FEC.RMON_R_FRAG.R             /* RMON Rx packets < 64 bytes, bad CRC */
#define FEC_RMON_R_JAB       FEC.RMON_R_JAB.R              /* RMON Rx packets > MAX_FL bytes, bad CRC */
#define FEC_RMON_R_RESVD_0   FEC.RMON_R_RESVD_0.R          /* Reserved */
#define FEC_RMON_R_P64       FEC.RMON_R_P64.R              /* RMON Rx 64 byte packets */
#define FEC_RMON_R_P65TO127  FEC.RMON_R_P65TO127.R         /* RMON Rx 65 to 127 byte packets */
#define FEC_RMON_R_P128TO255 FEC.RMON_R_