
MEMORY {
// Memory map for the MPC5746R

// Flash blocks.
// UTEST starts at 0x00400000.
// Small blocks start at 0x00f9c000.
// Large blocks start at 0x01000000.
// Place boot header at the beginning of small flash blocks.
    flash_rsvd1  : ORIGIN = 0x00400000, LENGTH = 0x00b9c000
    flash_memory : ORIGIN = 0x00f9c000,	LENGTH = 0x003e4000
    flash_rsvd2  : ORIGIN = .,          LENGTH = 0 

// 256K of system SRAM starting at 0x40000000
    dram_rsvd1   : ORIGIN = 0x40000000, LENGTH = 0x100 // reserved for interrupt vectors
    dram_reset   : ORIGIN = .,	        LENGTH = 0
    dram_memory  : ORIGIN = .,          LENGTH = 256K-0x100
    dram_rsvd2   : ORIGIN = .,          LENGTH = 0
}
DEFAULTS {
    stack_reserve = 16k
    heap_reserve = 8k
}
//
// Program layout for running out of RAM.
//
//

SECTIONS
{
    .PPC.EMB.sdata0 	            	    	    ABS : > dram_memory
    .PPC.EMB.sbss0                            CLEAR ABS : > .

    .boot_header					: > .
    .text  			            		: > dram_memory
    .vletext 				    		: > .
    .syscall 				    		: > .
    .secinfo 				    		: > .
    .rodata 				    		: > .
    .toc 				    		: > .
    .sdata2 				    		: > .
    .opd 				    		: > .
    .fixaddr			 	   		: > .
    .fixtype						: > .

    .sdabase 		        	      ALIGN(16) : > dram_memory	
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 		  				: > .
    .ghcovfz 					  CLEAR	: > .
    .ghcovcz 					  CLEAR	: > .
    .ghcovdz 					  CLEAR	: > .

    .heap                  ALIGN(16) PAD(heap_reserve)  : > dram_memory
    .stack                 ALIGN(16) PAD(stack_reserve) : > .

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(dram_rsvd1);
    __ghs_ramend    = MEMENDADDR(dram_memory);
    __ghs_romstart  = MEMADDR(flash_rsvd1);
    __ghs_romend    = MEMENDADDR(flash_rsvd2);
    
}
