/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _GENFSK_LL_H_
#define _GENFSK_LL_H_

#include "EmbeddedTypes.h"

/*!
 * @addtogroup genfsk_ll
 * @{
 */

/*! @file */

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/*! @brief GENFSK Timer invalid ID. */
#define gGENFSK_InvalidTimerId_c          (0xFF)
/*! @brief GENFSK Timer guard time in microseconds. */
#define gGENFSK_MinSetupTime_c            (20)
/*! @brief GENFSK Timer Overflow value. */
#define gGENFSK_OverflowTimerUnit         (0x1000000UL)
     
/*!
 * @brief GENFSK interrupts definition.
 *
 * Definition of the interrupt processing to be done for GENFSK.
 */
enum _GENFSK_interrupt_flags
{
   gGENFSK_SeqEndIrqFlag = GENFSK_IRQ_CTRL_SEQ_END_IRQ_MASK,
   gGENFSK_TxIrqFlag = GENFSK_IRQ_CTRL_TX_IRQ_MASK,
   gGENFSK_RxIrqFlag = GENFSK_IRQ_CTRL_RX_IRQ_MASK,
   gGENFSK_NtwAdrIrqFlag = GENFSK_IRQ_CTRL_NTW_ADR_IRQ_MASK,
   gGENFSK_T1IrqFlag = GENFSK_IRQ_CTRL_T1_IRQ_MASK,
   gGENFSK_T2IrqFlag = GENFSK_IRQ_CTRL_T2_IRQ_MASK,
   gGENFSK_PllUnlockIrqFlag = GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_MASK,
   gGENFSK_WakeIrqFlag = GENFSK_IRQ_CTRL_WAKE_IRQ_MASK,
   gGENFSK_RxWatermarkIrqFlag = GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_MASK,
   gGENFSK_AllIrqFlags = GENFSK_IRQ_CTRL_SEQ_END_IRQ_MASK | GENFSK_IRQ_CTRL_TX_IRQ_MASK | GENFSK_IRQ_CTRL_RX_IRQ_MASK |
                         GENFSK_IRQ_CTRL_NTW_ADR_IRQ_MASK | GENFSK_IRQ_CTRL_T1_IRQ_MASK | GENFSK_IRQ_CTRL_T2_IRQ_MASK |
                         GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_MASK | GENFSK_IRQ_CTRL_WAKE_IRQ_MASK | GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_MASK                        
};

/*!
 * @brief GENFSK interrupts definition.
 *
 * Definition of the interrupts available in GENFSK LL.
 */
enum _GENFSK_interrupt_enable
{
   gGENFSK_SeqEndIrqEnable = GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_MASK,
   gGENFSK_TxIrqEnable = GENFSK_IRQ_CTRL_TX_IRQ_EN_MASK,
   gGENFSK_RxIrqEnable = GENFSK_IRQ_CTRL_RX_IRQ_EN_MASK,
   gGENFSK_NtwAdrIrqEnable = GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_MASK,
   gGENFSK_T1IrqEnable = GENFSK_IRQ_CTRL_T1_IRQ_EN_MASK,
   gGENFSK_T2IrqEnable = GENFSK_IRQ_CTRL_T2_IRQ_EN_MASK,
   gGENFSK_PllUnlockIrqEnable = GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_MASK,
   gGENFSK_WakeIrqEnable = GENFSK_IRQ_CTRL_WAKE_IRQ_EN_MASK,
   gGENFSK_RxWatermarkIrqEnable = GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_MASK,
   gGENFSK_AllIrqEnable = GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_MASK | GENFSK_IRQ_CTRL_TX_IRQ_EN_MASK | GENFSK_IRQ_CTRL_RX_IRQ_EN_MASK |
                         GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_MASK | GENFSK_IRQ_CTRL_T1_IRQ_EN_MASK | GENFSK_IRQ_CTRL_T2_IRQ_EN_MASK |
                         GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_MASK | GENFSK_IRQ_CTRL_WAKE_IRQ_EN_MASK | GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_MASK                            
};

/*! @brief GENFSK LL internal states. */
typedef enum _GENFSK_LL_state
{    
    gGENFSK_LL_NoInit = 0U,
    gGENFSK_LL_Idle = 1U,
    gGENFSK_LL_BusyRx = 2U,
    gGENFSK_LL_BusyTx = 3U,
    gGENFSK_LL_BusyPendingRx = 4U,
    gGENFSK_LL_BusyPendingTx = 5U
} GENFSK_LL_state_t;

/*! @brief GENFSK LL task event flags. */ 
typedef enum
{
    gGenfskTxEventFlag_c = (1<<0),
    gGenfskRxEventFlag_c = (1<<1),
    gGenfskH0FailEventFlag_c  = (1<<2),
    gGenfskLengthFailEventFlag_c  = (1<<3),
    gGenfskH1FailEventFlag_c  = (1<<4),
    gGenfskNwkAddressMatchEventFlag_c  = (1<<5),
    gGenfskRxPllUnlockEventFlag_c  = (1<<6),
    gGenfskTxPllUnlockEventFlag_c  = (1<<7),
    gGenfskWakeEventFlag_c  = (1<<8)
}GENFSK_LL_event_flags_t;

/*! @brief GENFSK timeout callback. */
typedef void (*genfskTimeCallback_t) (void);

/*! @brief GENFSK timer ID type. */
typedef uint8_t genfskTimerId_t;

/*! @brief GENFSK time structure. */
typedef struct _GENFSK_TimeEvent
{
    GENFSK_timestamp_t    timestamp;
    genfskTimeCallback_t  callback;
} GENFSK_TimeEvent_t;

/*! @brief GENFSK RX local structure. */
typedef struct _GENFSK_RxLocalStruct
{
    uint8_t *rxPacketBuffer;
    uint16_t rxMaxPacketLength;
} GENFSK_RxLocalStruct_t;

/*! @brief GENFSK saved registers structure.*/
typedef struct _GENFSK_RegsStruct
{
    uint32_t irqCtrl;
    uint32_t xcvrCtrl;
    uint32_t xcvrCfg;
    uint32_t channelNum;
    uint32_t txPower;
    uint32_t ntwAdrCtrl;
    uint32_t ntwAdr0;
    uint32_t ntwAdr1;
    uint32_t ntwAdr2;
    uint32_t ntwAdr3;
    uint32_t packetCfg;
    uint32_t h0Cfg;
    uint32_t h1Cfg;
    uint32_t crcCfg;
    uint32_t crcInit;
    uint32_t crcPoly;
    uint32_t crcXorOut;
    uint32_t whitenCfg;
    uint32_t whitenPoly;
    uint32_t whitenSzThr;
    uint32_t bitRate;  
} GENFSK_RegsStruct_t;

/*! @brief GENFSK local structure. */
typedef struct _GENFSK_LocalStruct
{
    GENFSK_LL_state_t genfskState;
    GENFSK_RxLocalStruct_t genfskRxLocal;
    GENFSK_radio_config_t radioConfig;    
    GENFSK_RegsStruct_t genfskRegs;
    uint8_t syncAddrSizeBytes;
    genfskPacketType_t packetType;    
    genfskCrcComputeMode_t crcEnable;
    genfskCrcRecvInvalid_t crcRecvInvalid;
    genfskWhitenMode_t whitenEnable;
    genfskPacketReceivedCallBack_t packetReceivedcallback;
    genfskEventNotifyCallBack_t eventNotifyCallback;
    uint32_t enabledEvents;
} GENFSK_LocalStruct_t;

/*! @brief GENFSK instance status. */
typedef uint8_t GENFSK_InstanceStatus_t;

/*! @} */

#endif /* _GENFSK_LL_H_ */
