/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    MKW40Z160RM, Rev. 1.1, 4/2015
**     Version:             rev. 1.0, 2015-09-23
**     Build:               b151201
**
**     Abstract:
**         This header file implements peripheral memory map for MKW41Z4
**         processor.
**
**     Copyright (c) 1997 - 2015 Freescale Semiconductor, Inc.
**     All Rights Reserved.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2015-09-23)
**         Initial version.
**
** ###################################################################
*/

/*!
 * @file MKW41Z4.h
 * @version 1.0
 * @date 2015-09-23
 * @brief Peripheral memory map for MKW41Z4
 *
 * This header file implements peripheral memory map for MKW41Z4 processor.
 */


/* ----------------------------------------------------------------------------
   -- MCU activation
   ---------------------------------------------------------------------------- */

/* Prevention from multiple including the same memory map */
#if !defined(MCU_MKW41Z4)  /* Check if memory map has not been already included */
#define MCU_MKW41Z4

/* Check if another memory map has not been also included */
#if (defined(MCU_ACTIVE))
  #error MKW41Z4 memory map: There is already included another memory map. Only one memory map can be included.
#endif /* (defined(MCU_ACTIVE)) */
#define MCU_ACTIVE

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
typedef enum {
  INT_Initial_Stack_Pointer    = 0,                /**< Initial Stack Pointer */
  INT_Initial_Program_Counter  = 1,                /**< Initial Program Counter */
  INT_NMI                      = 2,                /**< Non-maskable Interrupt (NMI) */
  INT_Hard_Fault               = 3,                /**< Hard Fault */
  INT_Reserved4                = 4,                /**< Reserved interrupt */
  INT_Reserved5                = 5,                /**< Reserved interrupt */
  INT_Reserved6                = 6,                /**< Reserved interrupt */
  INT_Reserved7                = 7,                /**< Reserved interrupt */
  INT_Reserved8                = 8,                /**< Reserved interrupt */
  INT_Reserved9                = 9,                /**< Reserved interrupt */
  INT_Reserved10               = 10,               /**< Reserved interrupt */
  INT_SVCall                   = 11,               /**< Supervisor call (SVCall) */
  INT_Reserved12               = 12,               /**< Reserved interrupt */
  INT_Reserved13               = 13,               /**< Reserved interrupt */
  INT_PendableSrvReq           = 14,               /**< Pendable request for system service (PendableSrvReq) */
  INT_SysTick                  = 15,               /**< System tick timer (SysTick) */
  INT_DMA0                     = 16,               /**< DMA channel 0 transfer complete */
  INT_DMA1                     = 17,               /**< DMA channel 1 transfer complete */
  INT_DMA2                     = 18,               /**< DMA channel 2 transfer complete */
  INT_DMA3                     = 19,               /**< DMA channel 3 transfer complete */
  INT_Reserved20               = 20,               /**< Reserved interrupt */
  INT_FTFA                     = 21,               /**< Command complete and read collision */
  INT_LVD_LVW_DCDC             = 22,               /**< Low-voltage detect, low-voltage warning, DCDC */
  INT_LLWU                     = 23,               /**< Low leakage wakeup Unit */
  INT_I2C0                     = 24,               /**< I2C0 interrupt */
  INT_I2C1                     = 25,               /**< I2C1 interrupt */
  INT_SPI0                     = 26,               /**< SPI0 single interrupt vector for all sources */
  INT_TSI0                     = 27,               /**< TSI0 single interrupt vector for all sources */
  INT_LPUART0                  = 28,               /**< LPUART0 status and error */
  INT_TRNG0                    = 29,               /**< TRNG0 interrupt */
  INT_CMT                      = 30,               /**< CMT interrupt */
  INT_ADC0                     = 31,               /**< ADC0 interrupt */
  INT_CMP0                     = 32,               /**< CMP0 interrupt */
  INT_TPM0                     = 33,               /**< TPM0 single interrupt vector for all sources */
  INT_TPM1                     = 34,               /**< TPM1 single interrupt vector for all sources */
  INT_TPM2                     = 35,               /**< TPM2 single interrupt vector for all sources */
  INT_RTC                      = 36,               /**< RTC alarm */
  INT_RTC_Seconds              = 37,               /**< RTC seconds */
  INT_PIT                      = 38,               /**< PIT interrupt */
  INT_LTC0                     = 39,               /**< LTC0 interrupt */
  INT_Radio_0                  = 40,               /**< BTLE, ZIGBEE, ANT, GENFSK interrupt 0 */
  INT_DAC0                     = 41,               /**< DAC0 interrupt */
  INT_Radio_1                  = 42,               /**< BTLE, ZIGBEE, ANT, GENFSK interrupt 1 */
  INT_MCG                      = 43,               /**< MCG interrupt */
  INT_LPTMR0                   = 44,               /**< LPTMR0 interrupt */
  INT_SPI1                     = 45,               /**< SPI1 single interrupt vector for all sources */
  INT_PORTA                    = 46,               /**< PORTA Pin detect */
  INT_PORTB_PORTC              = 47                /**< PORTB and PORTC Pin detect */
} IRQInterruptIndex;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup edma_request
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the DMA hardware request
 *
 * Defines the structure for the DMA hardware request collections. The user can configure the
 * hardware request into DMAMUX to trigger the DMA transfer accordingly. The index
 * of the hardware request varies according  to the to SoC.
 */
typedef enum _dma_request_source
{
  kDmaRequestMux0Disable          = 0|0x100U,    /**< DMAMUX TriggerDisabled. */
  kDmaRequestMux0Reserved1        = 1|0x100U,    /**< Reserved1 */
  kDmaRequestMux0LPUART0Rx        = 2|0x100U,    /**< LPUART0 Receive. */
  kDmaRequestMux0LPUART0Tx        = 3|0x100U,    /**< LPUART0 Transmit. */
  kDmaRequestMux0Reserved4        = 4|0x100U,    /**< Reserved4 */
  kDmaRequestMux0Reserved5        = 5|0x100U,    /**< Reserved5 */
  kDmaRequestMux0Reserved6        = 6|0x100U,    /**< Reserved6 */
  kDmaRequestMux0Reserved7        = 7|0x100U,    /**< Reserved7 */
  kDmaRequestMux0Reserved8        = 8|0x100U,    /**< Reserved8 */
  kDmaRequestMux0Reserved9        = 9|0x100U,    /**< Reserved9 */
  kDmaRequestMux0Reserved10       = 10|0x100U,   /**< Reserved10 */
  kDmaRequestMux0Reserved11       = 11|0x100U,   /**< Reserved11 */
  kDmaRequestMux0Reserved12       = 12|0x100U,   /**< Reserved12 */
  kDmaRequestMux0Reserved13       = 13|0x100U,   /**< Reserved13 */
  kDmaRequestMux0Reserved14       = 14|0x100U,   /**< Reserved14 */
  kDmaRequestMux0Reserved15       = 15|0x100U,   /**< Reserved15 */
  kDmaRequestMux0SPI0Rx           = 16|0x100U,   /**< SPI0 Receive. */
  kDmaRequestMux0SPI0Tx           = 17|0x100U,   /**< SPI0 Transmit. */
  kDmaRequestMux0SPI1Rx           = 18|0x100U,   /**< SPI1 Receive. */
  kDmaRequestMux0SPI1Tx           = 19|0x100U,   /**< SPI1 Transmit. */
  kDmaRequestMux0AESAInputFIFO    = 20|0x100U,   /**< AESA Input FIFO. */
  kDmaRequestMux0AESAOutputFIFO   = 21|0x100U,   /**< AESA Output FIFO. */
  kDmaRequestMux0I2C0             = 22|0x100U,   /**< I2C0. */
  kDmaRequestMux0I2C1             = 23|0x100U,   /**< I2C1. */
  kDmaRequestMux0TPM0Channel0     = 24|0x100U,   /**< TPM0 C0V. */
  kDmaRequestMux0TPM0Channel1     = 25|0x100U,   /**< TPM0 C1V. */
  kDmaRequestMux0TPM0Channel2     = 26|0x100U,   /**< TPM0 C2V. */
  kDmaRequestMux0TPM0Channel3     = 27|0x100U,   /**< TPM0 C3V. */
  kDmaRequestMux0Reserved28       = 28|0x100U,   /**< Reserved28 */
  kDmaRequestMux0Reserved29       = 29|0x100U,   /**< Reserved29 */
  kDmaRequestMux0Reserved30       = 30|0x100U,   /**< Reserved30 */
  kDmaRequestMux0Reserved31       = 31|0x100U,   /**< Reserved31 */
  kDmaRequestMux0TPM1Channel0     = 32|0x100U,   /**< TPM1 C0V. */
  kDmaRequestMux0TPM1Channel1     = 33|0x100U,   /**< TPM1 C1V. */
  kDmaRequestMux0TPM2Channel0     = 34|0x100U,   /**< TPM2 C0V. */
  kDmaRequestMux0TPM2Channel1     = 35|0x100U,   /**< TPM2 C1V. */
  kDmaRequestMux0Reserved36       = 36|0x100U,   /**< Reserved36 */
  kDmaRequestMux0Reserved37       = 37|0x100U,   /**< Reserved37 */
  kDmaRequestMux0Reserved38       = 38|0x100U,   /**< Reserved38 */
  kDmaRequestMux0Reserved39       = 39|0x100U,   /**< Reserved39 */
  kDmaRequestMux0ADC0             = 40|0x100U,   /**< ADC0. */
  kDmaRequestMux0Reserved41       = 41|0x100U,   /**< Reserved41 */
  kDmaRequestMux0CMP0             = 42|0x100U,   /**< CMP0. */
  kDmaRequestMux0Reserved43       = 43|0x100U,   /**< Reserved43 */
  kDmaRequestMux0Reserved44       = 44|0x100U,   /**< Reserved44 */
  kDmaRequestMux0DAC0             = 45|0x100U,   /**< DAC0. */
  kDmaRequestMux0Reserved46       = 46|0x100U,   /**< Reserved46 */
  kDmaRequestMux0CMT              = 47|0x100U,   /**< CMT. */
  kDmaRequestMux0Reserved48       = 48|0x100U,   /**< Reserved48 */
  kDmaRequestMux0PortA            = 49|0x100U,   /**< PTA. */
  kDmaRequestMux0PortB            = 50|0x100U,   /**< PTB. */
  kDmaRequestMux0PortC            = 51|0x100U,   /**< PTC. */
  kDmaRequestMux0Reserved52       = 52|0x100U,   /**< Reserved52 */
  kDmaRequestMux0Reserved53       = 53|0x100U,   /**< Reserved53 */
  kDmaRequestMux0TPM0Overflow     = 54|0x100U,   /**< TPM0. */
  kDmaRequestMux0TPM1Overflow     = 55|0x100U,   /**< TPM1. */
  kDmaRequestMux0TPM2Overflow     = 56|0x100U,   /**< TPM2. */
  kDmaRequestMux0TSI0             = 57|0x100U,   /**< TSI0. */
  kDmaRequestMux0Reserved58       = 58|0x100U,   /**< Reserved58 */
  kDmaRequestMux0Reserved59       = 59|0x100U,   /**< Reserved59 */
  kDmaRequestMux0AlwaysOn60       = 60|0x100U,   /**< DMAMUX Always Enabled slot. */
  kDmaRequestMux0AlwaysOn61       = 61|0x100U,   /**< DMAMUX Always Enabled slot. */
  kDmaRequestMux0AlwaysOn62       = 62|0x100U,   /**< DMAMUX Always Enabled slot. */
  kDmaRequestMux0AlwaysOn63       = 63|0x100U,   /**< DMAMUX Always Enabled slot. */
} dma_request_source_t;

/* @} */


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Peripheral type defines
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_defines Peripheral type defines
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma push
  #pragma anon_unions
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral ADC
 * @{
 */

/** ADC - Peripheral register structure */
typedef struct ADC_MemMap {
  uint32_t SC1[2];                                 /**< ADC Status and Control Registers 1, array offset: 0x0, array step: 0x4 */
  uint32_t CFG1;                                   /**< ADC Configuration Register 1, offset: 0x8 */
  uint32_t CFG2;                                   /**< ADC Configuration Register 2, offset: 0xC */
  uint32_t R[2];                                   /**< ADC Data Result Register, array offset: 0x10, array step: 0x4 */
  uint32_t CV1;                                    /**< Compare Value Registers, offset: 0x18 */
  uint32_t CV2;                                    /**< Compare Value Registers, offset: 0x1C */
  uint32_t SC2;                                    /**< Status and Control Register 2, offset: 0x20 */
  uint32_t SC3;                                    /**< Status and Control Register 3, offset: 0x24 */
  uint32_t OFS;                                    /**< ADC Offset Correction Register, offset: 0x28 */
  uint32_t PG;                                     /**< ADC Plus-Side Gain Register, offset: 0x2C */
  uint32_t MG;                                     /**< ADC Minus-Side Gain Register, offset: 0x30 */
  uint32_t CLPD;                                   /**< ADC Plus-Side General Calibration Value Register, offset: 0x34 */
  uint32_t CLPS;                                   /**< ADC Plus-Side General Calibration Value Register, offset: 0x38 */
  uint32_t CLP4;                                   /**< ADC Plus-Side General Calibration Value Register, offset: 0x3C */
  uint32_t CLP3;                                   /**< ADC Plus-Side General Calibration Value Register, offset: 0x40 */
  uint32_t CLP2;                                   /**< ADC Plus-Side General Calibration Value Register, offset: 0x44 */
  uint32_t CLP1;                                   /**< ADC Plus-Side General Calibration Value Register, offset: 0x48 */
  uint32_t CLP0;                                   /**< ADC Plus-Side General Calibration Value Register, offset: 0x4C */
  uint8_t RESERVED_0[4];
  uint32_t CLMD;                                   /**< ADC Minus-Side General Calibration Value Register, offset: 0x54 */
  uint32_t CLMS;                                   /**< ADC Minus-Side General Calibration Value Register, offset: 0x58 */
  uint32_t CLM4;                                   /**< ADC Minus-Side General Calibration Value Register, offset: 0x5C */
  uint32_t CLM3;                                   /**< ADC Minus-Side General Calibration Value Register, offset: 0x60 */
  uint32_t CLM2;                                   /**< ADC Minus-Side General Calibration Value Register, offset: 0x64 */
  uint32_t CLM1;                                   /**< ADC Minus-Side General Calibration Value Register, offset: 0x68 */
  uint32_t CLM0;                                   /**< ADC Minus-Side General Calibration Value Register, offset: 0x6C */
} volatile *ADC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ADC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Accessor_Macros ADC - Register accessor macros
 * @{
 */


/* ADC - Register accessors */
#define ADC_SC1_REG(base,index)                  ((base)->SC1[index])
#define ADC_CFG1_REG(base)                       ((base)->CFG1)
#define ADC_CFG2_REG(base)                       ((base)->CFG2)
#define ADC_R_REG(base,index)                    ((base)->R[index])
#define ADC_CV1_REG(base)                        ((base)->CV1)
#define ADC_CV2_REG(base)                        ((base)->CV2)
#define ADC_SC2_REG(base)                        ((base)->SC2)
#define ADC_SC3_REG(base)                        ((base)->SC3)
#define ADC_OFS_REG(base)                        ((base)->OFS)
#define ADC_PG_REG(base)                         ((base)->PG)
#define ADC_MG_REG(base)                         ((base)->MG)
#define ADC_CLPD_REG(base)                       ((base)->CLPD)
#define ADC_CLPS_REG(base)                       ((base)->CLPS)
#define ADC_CLP4_REG(base)                       ((base)->CLP4)
#define ADC_CLP3_REG(base)                       ((base)->CLP3)
#define ADC_CLP2_REG(base)                       ((base)->CLP2)
#define ADC_CLP1_REG(base)                       ((base)->CLP1)
#define ADC_CLP0_REG(base)                       ((base)->CLP0)
#define ADC_CLMD_REG(base)                       ((base)->CLMD)
#define ADC_CLMS_REG(base)                       ((base)->CLMS)
#define ADC_CLM4_REG(base)                       ((base)->CLM4)
#define ADC_CLM3_REG(base)                       ((base)->CLM3)
#define ADC_CLM2_REG(base)                       ((base)->CLM2)
#define ADC_CLM1_REG(base)                       ((base)->CLM1)
#define ADC_CLM0_REG(base)                       ((base)->CLM0)

/*!
 * @}
 */ /* end of group ADC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name SC1 - ADC Status and Control Registers 1 */
#define ADC_SC1_ADCH_MASK                        (0x1FU)
#define ADC_SC1_ADCH_SHIFT                       (0U)
#define ADC_SC1_ADCH(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC1_ADCH_SHIFT)) & ADC_SC1_ADCH_MASK)
#define ADC_SC1_DIFF_MASK                        (0x20U)
#define ADC_SC1_DIFF_SHIFT                       (5U)
#define ADC_SC1_AIEN_MASK                        (0x40U)
#define ADC_SC1_AIEN_SHIFT                       (6U)
#define ADC_SC1_COCO_MASK                        (0x80U)
#define ADC_SC1_COCO_SHIFT                       (7U)

/* The count of ADC_SC1 */
#define ADC_SC1_COUNT                            (2U)

/*! @name CFG1 - ADC Configuration Register 1 */
#define ADC_CFG1_ADICLK_MASK                     (0x3U)
#define ADC_CFG1_ADICLK_SHIFT                    (0U)
#define ADC_CFG1_ADICLK(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG1_ADICLK_SHIFT)) & ADC_CFG1_ADICLK_MASK)
#define ADC_CFG1_MODE_MASK                       (0xCU)
#define ADC_CFG1_MODE_SHIFT                      (2U)
#define ADC_CFG1_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG1_MODE_SHIFT)) & ADC_CFG1_MODE_MASK)
#define ADC_CFG1_ADLSMP_MASK                     (0x10U)
#define ADC_CFG1_ADLSMP_SHIFT                    (4U)
#define ADC_CFG1_ADIV_MASK                       (0x60U)
#define ADC_CFG1_ADIV_SHIFT                      (5U)
#define ADC_CFG1_ADIV(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG1_ADIV_SHIFT)) & ADC_CFG1_ADIV_MASK)
#define ADC_CFG1_ADLPC_MASK                      (0x80U)
#define ADC_CFG1_ADLPC_SHIFT                     (7U)

/*! @name CFG2 - ADC Configuration Register 2 */
#define ADC_CFG2_ADLSTS_MASK                     (0x3U)
#define ADC_CFG2_ADLSTS_SHIFT                    (0U)
#define ADC_CFG2_ADLSTS(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG2_ADLSTS_SHIFT)) & ADC_CFG2_ADLSTS_MASK)
#define ADC_CFG2_ADHSC_MASK                      (0x4U)
#define ADC_CFG2_ADHSC_SHIFT                     (2U)
#define ADC_CFG2_ADACKEN_MASK                    (0x8U)
#define ADC_CFG2_ADACKEN_SHIFT                   (3U)
#define ADC_CFG2_MUXSEL_MASK                     (0x10U)
#define ADC_CFG2_MUXSEL_SHIFT                    (4U)

/*! @name R - ADC Data Result Register */
#define ADC_R_D_MASK                             (0xFFFFU)
#define ADC_R_D_SHIFT                            (0U)
#define ADC_R_D(x)                               (((uint32_t)(((uint32_t)(x)) << ADC_R_D_SHIFT)) & ADC_R_D_MASK)

/* The count of ADC_R */
#define ADC_R_COUNT                              (2U)

/*! @name CV1 - Compare Value Registers */
#define ADC_CV1_CV_MASK                          (0xFFFFU)
#define ADC_CV1_CV_SHIFT                         (0U)
#define ADC_CV1_CV(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV1_CV_SHIFT)) & ADC_CV1_CV_MASK)

/*! @name CV2 - Compare Value Registers */
#define ADC_CV2_CV_MASK                          (0xFFFFU)
#define ADC_CV2_CV_SHIFT                         (0U)
#define ADC_CV2_CV(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV2_CV_SHIFT)) & ADC_CV2_CV_MASK)

/*! @name SC2 - Status and Control Register 2 */
#define ADC_SC2_REFSEL_MASK                      (0x3U)
#define ADC_SC2_REFSEL_SHIFT                     (0U)
#define ADC_SC2_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_SC2_REFSEL_SHIFT)) & ADC_SC2_REFSEL_MASK)
#define ADC_SC2_DMAEN_MASK                       (0x4U)
#define ADC_SC2_DMAEN_SHIFT                      (2U)
#define ADC_SC2_ACREN_MASK                       (0x8U)
#define ADC_SC2_ACREN_SHIFT                      (3U)
#define ADC_SC2_ACFGT_MASK                       (0x10U)
#define ADC_SC2_ACFGT_SHIFT                      (4U)
#define ADC_SC2_ACFE_MASK                        (0x20U)
#define ADC_SC2_ACFE_SHIFT                       (5U)
#define ADC_SC2_ADTRG_MASK                       (0x40U)
#define ADC_SC2_ADTRG_SHIFT                      (6U)
#define ADC_SC2_ADACT_MASK                       (0x80U)
#define ADC_SC2_ADACT_SHIFT                      (7U)

/*! @name SC3 - Status and Control Register 3 */
#define ADC_SC3_AVGS_MASK                        (0x3U)
#define ADC_SC3_AVGS_SHIFT                       (0U)
#define ADC_SC3_AVGS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_SC3_AVGS_SHIFT)) & ADC_SC3_AVGS_MASK)
#define ADC_SC3_AVGE_MASK                        (0x4U)
#define ADC_SC3_AVGE_SHIFT                       (2U)
#define ADC_SC3_ADCO_MASK                        (0x8U)
#define ADC_SC3_ADCO_SHIFT                       (3U)
#define ADC_SC3_CALF_MASK                        (0x40U)
#define ADC_SC3_CALF_SHIFT                       (6U)
#define ADC_SC3_CAL_MASK                         (0x80U)
#define ADC_SC3_CAL_SHIFT                        (7U)

/*! @name OFS - ADC Offset Correction Register */
#define ADC_OFS_OFS_MASK                         (0xFFFFU)
#define ADC_OFS_OFS_SHIFT                        (0U)
#define ADC_OFS_OFS(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_OFS_OFS_SHIFT)) & ADC_OFS_OFS_MASK)

/*! @name PG - ADC Plus-Side Gain Register */
#define ADC_PG_PG_MASK                           (0xFFFFU)
#define ADC_PG_PG_SHIFT                          (0U)
#define ADC_PG_PG(x)                             (((uint32_t)(((uint32_t)(x)) << ADC_PG_PG_SHIFT)) & ADC_PG_PG_MASK)

/*! @name MG - ADC Minus-Side Gain Register */
#define ADC_MG_MG_MASK                           (0xFFFFU)
#define ADC_MG_MG_SHIFT                          (0U)
#define ADC_MG_MG(x)                             (((uint32_t)(((uint32_t)(x)) << ADC_MG_MG_SHIFT)) & ADC_MG_MG_MASK)

/*! @name CLPD - ADC Plus-Side General Calibration Value Register */
#define ADC_CLPD_CLPD_MASK                       (0x3FU)
#define ADC_CLPD_CLPD_SHIFT                      (0U)
#define ADC_CLPD_CLPD(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLPD_CLPD_SHIFT)) & ADC_CLPD_CLPD_MASK)

/*! @name CLPS - ADC Plus-Side General Calibration Value Register */
#define ADC_CLPS_CLPS_MASK                       (0x3FU)
#define ADC_CLPS_CLPS_SHIFT                      (0U)
#define ADC_CLPS_CLPS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLPS_CLPS_SHIFT)) & ADC_CLPS_CLPS_MASK)

/*! @name CLP4 - ADC Plus-Side General Calibration Value Register */
#define ADC_CLP4_CLP4_MASK                       (0x3FFU)
#define ADC_CLP4_CLP4_SHIFT                      (0U)
#define ADC_CLP4_CLP4(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLP4_CLP4_SHIFT)) & ADC_CLP4_CLP4_MASK)

/*! @name CLP3 - ADC Plus-Side General Calibration Value Register */
#define ADC_CLP3_CLP3_MASK                       (0x1FFU)
#define ADC_CLP3_CLP3_SHIFT                      (0U)
#define ADC_CLP3_CLP3(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLP3_CLP3_SHIFT)) & ADC_CLP3_CLP3_MASK)

/*! @name CLP2 - ADC Plus-Side General Calibration Value Register */
#define ADC_CLP2_CLP2_MASK                       (0xFFU)
#define ADC_CLP2_CLP2_SHIFT                      (0U)
#define ADC_CLP2_CLP2(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLP2_CLP2_SHIFT)) & ADC_CLP2_CLP2_MASK)

/*! @name CLP1 - ADC Plus-Side General Calibration Value Register */
#define ADC_CLP1_CLP1_MASK                       (0x7FU)
#define ADC_CLP1_CLP1_SHIFT                      (0U)
#define ADC_CLP1_CLP1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLP1_CLP1_SHIFT)) & ADC_CLP1_CLP1_MASK)

/*! @name CLP0 - ADC Plus-Side General Calibration Value Register */
#define ADC_CLP0_CLP0_MASK                       (0x3FU)
#define ADC_CLP0_CLP0_SHIFT                      (0U)
#define ADC_CLP0_CLP0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLP0_CLP0_SHIFT)) & ADC_CLP0_CLP0_MASK)

/*! @name CLMD - ADC Minus-Side General Calibration Value Register */
#define ADC_CLMD_CLMD_MASK                       (0x3FU)
#define ADC_CLMD_CLMD_SHIFT                      (0U)
#define ADC_CLMD_CLMD(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLMD_CLMD_SHIFT)) & ADC_CLMD_CLMD_MASK)

/*! @name CLMS - ADC Minus-Side General Calibration Value Register */
#define ADC_CLMS_CLMS_MASK                       (0x3FU)
#define ADC_CLMS_CLMS_SHIFT                      (0U)
#define ADC_CLMS_CLMS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLMS_CLMS_SHIFT)) & ADC_CLMS_CLMS_MASK)

/*! @name CLM4 - ADC Minus-Side General Calibration Value Register */
#define ADC_CLM4_CLM4_MASK                       (0x3FFU)
#define ADC_CLM4_CLM4_SHIFT                      (0U)
#define ADC_CLM4_CLM4(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLM4_CLM4_SHIFT)) & ADC_CLM4_CLM4_MASK)

/*! @name CLM3 - ADC Minus-Side General Calibration Value Register */
#define ADC_CLM3_CLM3_MASK                       (0x1FFU)
#define ADC_CLM3_CLM3_SHIFT                      (0U)
#define ADC_CLM3_CLM3(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLM3_CLM3_SHIFT)) & ADC_CLM3_CLM3_MASK)

/*! @name CLM2 - ADC Minus-Side General Calibration Value Register */
#define ADC_CLM2_CLM2_MASK                       (0xFFU)
#define ADC_CLM2_CLM2_SHIFT                      (0U)
#define ADC_CLM2_CLM2(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLM2_CLM2_SHIFT)) & ADC_CLM2_CLM2_MASK)

/*! @name CLM1 - ADC Minus-Side General Calibration Value Register */
#define ADC_CLM1_CLM1_MASK                       (0x7FU)
#define ADC_CLM1_CLM1_SHIFT                      (0U)
#define ADC_CLM1_CLM1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLM1_CLM1_SHIFT)) & ADC_CLM1_CLM1_MASK)

/*! @name CLM0 - ADC Minus-Side General Calibration Value Register */
#define ADC_CLM0_CLM0_MASK                       (0x3FU)
#define ADC_CLM0_CLM0_SHIFT                      (0U)
#define ADC_CLM0_CLM0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CLM0_CLM0_SHIFT)) & ADC_CLM0_CLM0_MASK)


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral ADC0 base pointer */
#define ADC0_BASE_PTR                            ((ADC_MemMapPtr)0x4003B000u)
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { ADC0_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ADC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Accessor_Macros ADC - Register accessor macros
 * @{
 */


/* ADC - Register instance definitions */
/* ADC0 */
#define ADC0_SC1A                                ADC_SC1_REG(ADC0_BASE_PTR,0)
#define ADC0_SC1B                                ADC_SC1_REG(ADC0_BASE_PTR,1)
#define ADC0_CFG1                                ADC_CFG1_REG(ADC0_BASE_PTR)
#define ADC0_CFG2                                ADC_CFG2_REG(ADC0_BASE_PTR)
#define ADC0_RA                                  ADC_R_REG(ADC0_BASE_PTR,0)
#define ADC0_RB                                  ADC_R_REG(ADC0_BASE_PTR,1)
#define ADC0_CV1                                 ADC_CV1_REG(ADC0_BASE_PTR)
#define ADC0_CV2                                 ADC_CV2_REG(ADC0_BASE_PTR)
#define ADC0_SC2                                 ADC_SC2_REG(ADC0_BASE_PTR)
#define ADC0_SC3                                 ADC_SC3_REG(ADC0_BASE_PTR)
#define ADC0_OFS                                 ADC_OFS_REG(ADC0_BASE_PTR)
#define ADC0_PG                                  ADC_PG_REG(ADC0_BASE_PTR)
#define ADC0_MG                                  ADC_MG_REG(ADC0_BASE_PTR)
#define ADC0_CLPD                                ADC_CLPD_REG(ADC0_BASE_PTR)
#define ADC0_CLPS                                ADC_CLPS_REG(ADC0_BASE_PTR)
#define ADC0_CLP4                                ADC_CLP4_REG(ADC0_BASE_PTR)
#define ADC0_CLP3                                ADC_CLP3_REG(ADC0_BASE_PTR)
#define ADC0_CLP2                                ADC_CLP2_REG(ADC0_BASE_PTR)
#define ADC0_CLP1                                ADC_CLP1_REG(ADC0_BASE_PTR)
#define ADC0_CLP0                                ADC_CLP0_REG(ADC0_BASE_PTR)
#define ADC0_CLMD                                ADC_CLMD_REG(ADC0_BASE_PTR)
#define ADC0_CLMS                                ADC_CLMS_REG(ADC0_BASE_PTR)
#define ADC0_CLM4                                ADC_CLM4_REG(ADC0_BASE_PTR)
#define ADC0_CLM3                                ADC_CLM3_REG(ADC0_BASE_PTR)
#define ADC0_CLM2                                ADC_CLM2_REG(ADC0_BASE_PTR)
#define ADC0_CLM1                                ADC_CLM1_REG(ADC0_BASE_PTR)
#define ADC0_CLM0                                ADC_CLM0_REG(ADC0_BASE_PTR)

/* ADC - Register array accessors */
#define ADC0_SC1(index)                          ADC_SC1_REG(ADC0_BASE_PTR,index)
#define ADC0_R(index)                            ADC_R_REG(ADC0_BASE_PTR,index)

/*!
 * @}
 */ /* end of group ADC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ADC_Peripheral */


/* ----------------------------------------------------------------------------
   -- ANT
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANT_Peripheral ANT
 * @{
 */

/** ANT - Peripheral register structure */
typedef struct ANT_MemMap {
  uint32_t IRQ_CTRL;                               /**< IRQ CONTROL, offset: 0x0 */
  uint32_t EVENT_TMR;                              /**< EVENT TIMER, offset: 0x4 */
  uint32_t T1_CMP;                                 /**< T1 COMPARE, offset: 0x8 */
  uint32_t T2_CMP;                                 /**< T2 COMPARE, offset: 0xC */
  uint32_t TIMESTAMP;                              /**< TIMESTAMP, offset: 0x10 */
  uint32_t XCVR_CTRL;                              /**< TRANSCEIVER CONTROL, offset: 0x14 */
  uint32_t XCVR_STS;                               /**< TRANSCEIVER STATUS, offset: 0x18 */
  uint32_t XCVR_CFG;                               /**< TRANSCEIVER CONFIGURATION, offset: 0x1C */
  uint32_t CHANNEL_NUM;                            /**< CHANNEL NUMBER, offset: 0x20 */
  uint32_t TX_POWER;                               /**< TRANSMIT POWER, offset: 0x24 */
  uint32_t NTW_ADR_CTRL;                           /**< NETWORK ADDRESS CONTROL, offset: 0x28 */
  uint32_t NTW_ADR_0;                              /**< NETWORK ADDRESS 0, offset: 0x2C */
  uint32_t NTW_ADR_1;                              /**< NETWORK ADDRESS 1, offset: 0x30 */
  uint32_t NTW_ADR_2;                              /**< NETWORK ADDRESS 2, offset: 0x34 */
  uint32_t NTW_ADR_3;                              /**< NETWORK ADDRESS 3, offset: 0x38 */
  uint32_t RX_WATERMARK;                           /**< RX WATERMARK, offset: 0x3C */
  uint32_t DSM_CTRL;                               /**< DSM CONTROL, offset: 0x40 */
  uint32_t PART_ID;                                /**< PART ID, offset: 0x44 */
  uint8_t RESERVED_0[184];
  uint16_t PACKET_BUFFER[64];                      /**< PACKET BUFFER, array offset: 0x100, array step: 0x2 */
} volatile *ANT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ANT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANT_Register_Accessor_Macros ANT - Register accessor macros
 * @{
 */


/* ANT - Register accessors */
#define ANT_IRQ_CTRL_REG(base)                   ((base)->IRQ_CTRL)
#define ANT_EVENT_TMR_REG(base)                  ((base)->EVENT_TMR)
#define ANT_T1_CMP_REG(base)                     ((base)->T1_CMP)
#define ANT_T2_CMP_REG(base)                     ((base)->T2_CMP)
#define ANT_TIMESTAMP_REG(base)                  ((base)->TIMESTAMP)
#define ANT_XCVR_CTRL_REG(base)                  ((base)->XCVR_CTRL)
#define ANT_XCVR_STS_REG(base)                   ((base)->XCVR_STS)
#define ANT_XCVR_CFG_REG(base)                   ((base)->XCVR_CFG)
#define ANT_CHANNEL_NUM_REG(base)                ((base)->CHANNEL_NUM)
#define ANT_TX_POWER_REG(base)                   ((base)->TX_POWER)
#define ANT_NTW_ADR_CTRL_REG(base)               ((base)->NTW_ADR_CTRL)
#define ANT_NTW_ADR_0_REG(base)                  ((base)->NTW_ADR_0)
#define ANT_NTW_ADR_1_REG(base)                  ((base)->NTW_ADR_1)
#define ANT_NTW_ADR_2_REG(base)                  ((base)->NTW_ADR_2)
#define ANT_NTW_ADR_3_REG(base)                  ((base)->NTW_ADR_3)
#define ANT_RX_WATERMARK_REG(base)               ((base)->RX_WATERMARK)
#define ANT_DSM_CTRL_REG(base)                   ((base)->DSM_CTRL)
#define ANT_PART_ID_REG(base)                    ((base)->PART_ID)
#define ANT_PACKET_BUFFER_REG(base,index)        ((base)->PACKET_BUFFER[index])

/*!
 * @}
 */ /* end of group ANT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ANT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANT_Register_Masks ANT Register Masks
 * @{
 */

/*! @name IRQ_CTRL - IRQ CONTROL */
#define ANT_IRQ_CTRL_SEQ_END_IRQ_MASK            (0x1U)
#define ANT_IRQ_CTRL_SEQ_END_IRQ_SHIFT           (0U)
#define ANT_IRQ_CTRL_TX_IRQ_MASK                 (0x2U)
#define ANT_IRQ_CTRL_TX_IRQ_SHIFT                (1U)
#define ANT_IRQ_CTRL_RX_IRQ_MASK                 (0x4U)
#define ANT_IRQ_CTRL_RX_IRQ_SHIFT                (2U)
#define ANT_IRQ_CTRL_NTW_ADR_IRQ_MASK            (0x8U)
#define ANT_IRQ_CTRL_NTW_ADR_IRQ_SHIFT           (3U)
#define ANT_IRQ_CTRL_T1_IRQ_MASK                 (0x10U)
#define ANT_IRQ_CTRL_T1_IRQ_SHIFT                (4U)
#define ANT_IRQ_CTRL_T2_IRQ_MASK                 (0x20U)
#define ANT_IRQ_CTRL_T2_IRQ_SHIFT                (5U)
#define ANT_IRQ_CTRL_PLL_UNLOCK_IRQ_MASK         (0x40U)
#define ANT_IRQ_CTRL_PLL_UNLOCK_IRQ_SHIFT        (6U)
#define ANT_IRQ_CTRL_WAKE_IRQ_MASK               (0x80U)
#define ANT_IRQ_CTRL_WAKE_IRQ_SHIFT              (7U)
#define ANT_IRQ_CTRL_RX_WATERMARK_IRQ_MASK       (0x100U)
#define ANT_IRQ_CTRL_RX_WATERMARK_IRQ_SHIFT      (8U)
#define ANT_IRQ_CTRL_TSM_IRQ_MASK                (0x200U)
#define ANT_IRQ_CTRL_TSM_IRQ_SHIFT               (9U)
#define ANT_IRQ_CTRL_SEQ_END_IRQ_EN_MASK         (0x10000U)
#define ANT_IRQ_CTRL_SEQ_END_IRQ_EN_SHIFT        (16U)
#define ANT_IRQ_CTRL_TX_IRQ_EN_MASK              (0x20000U)
#define ANT_IRQ_CTRL_TX_IRQ_EN_SHIFT             (17U)
#define ANT_IRQ_CTRL_RX_IRQ_EN_MASK              (0x40000U)
#define ANT_IRQ_CTRL_RX_IRQ_EN_SHIFT             (18U)
#define ANT_IRQ_CTRL_NTW_ADR_IRQ_EN_MASK         (0x80000U)
#define ANT_IRQ_CTRL_NTW_ADR_IRQ_EN_SHIFT        (19U)
#define ANT_IRQ_CTRL_T1_IRQ_EN_MASK              (0x100000U)
#define ANT_IRQ_CTRL_T1_IRQ_EN_SHIFT             (20U)
#define ANT_IRQ_CTRL_T2_IRQ_EN_MASK              (0x200000U)
#define ANT_IRQ_CTRL_T2_IRQ_EN_SHIFT             (21U)
#define ANT_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_MASK      (0x400000U)
#define ANT_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_SHIFT     (22U)
#define ANT_IRQ_CTRL_WAKE_IRQ_EN_MASK            (0x800000U)
#define ANT_IRQ_CTRL_WAKE_IRQ_EN_SHIFT           (23U)
#define ANT_IRQ_CTRL_RX_WATERMARK_IRQ_EN_MASK    (0x1000000U)
#define ANT_IRQ_CTRL_RX_WATERMARK_IRQ_EN_SHIFT   (24U)
#define ANT_IRQ_CTRL_TSM_IRQ_EN_MASK             (0x2000000U)
#define ANT_IRQ_CTRL_TSM_IRQ_EN_SHIFT            (25U)
#define ANT_IRQ_CTRL_ANT_IRQ_EN_MASK             (0x4000000U)
#define ANT_IRQ_CTRL_ANT_IRQ_EN_SHIFT            (26U)
#define ANT_IRQ_CTRL_CRC_IGNORE_MASK             (0x8000000U)
#define ANT_IRQ_CTRL_CRC_IGNORE_SHIFT            (27U)
#define ANT_IRQ_CTRL_CRC_VALID_MASK              (0x80000000U)
#define ANT_IRQ_CTRL_CRC_VALID_SHIFT             (31U)

/*! @name EVENT_TMR - EVENT TIMER */
#define ANT_EVENT_TMR_EVENT_TMR_MASK             (0xFFFFFFU)
#define ANT_EVENT_TMR_EVENT_TMR_SHIFT            (0U)
#define ANT_EVENT_TMR_EVENT_TMR(x)               (((uint32_t)(((uint32_t)(x)) << ANT_EVENT_TMR_EVENT_TMR_SHIFT)) & ANT_EVENT_TMR_EVENT_TMR_MASK)
#define ANT_EVENT_TMR_EVENT_TMR_LD_MASK          (0x1000000U)
#define ANT_EVENT_TMR_EVENT_TMR_LD_SHIFT         (24U)
#define ANT_EVENT_TMR_EVENT_TMR_ADD_MASK         (0x2000000U)
#define ANT_EVENT_TMR_EVENT_TMR_ADD_SHIFT        (25U)

/*! @name T1_CMP - T1 COMPARE */
#define ANT_T1_CMP_T1_CMP_MASK                   (0xFFFFFFU)
#define ANT_T1_CMP_T1_CMP_SHIFT                  (0U)
#define ANT_T1_CMP_T1_CMP(x)                     (((uint32_t)(((uint32_t)(x)) << ANT_T1_CMP_T1_CMP_SHIFT)) & ANT_T1_CMP_T1_CMP_MASK)
#define ANT_T1_CMP_T1_CMP_EN_MASK                (0x1000000U)
#define ANT_T1_CMP_T1_CMP_EN_SHIFT               (24U)

/*! @name T2_CMP - T2 COMPARE */
#define ANT_T2_CMP_T2_CMP_MASK                   (0xFFFFFFU)
#define ANT_T2_CMP_T2_CMP_SHIFT                  (0U)
#define ANT_T2_CMP_T2_CMP(x)                     (((uint32_t)(((uint32_t)(x)) << ANT_T2_CMP_T2_CMP_SHIFT)) & ANT_T2_CMP_T2_CMP_MASK)
#define ANT_T2_CMP_T2_CMP_EN_MASK                (0x1000000U)
#define ANT_T2_CMP_T2_CMP_EN_SHIFT               (24U)

/*! @name TIMESTAMP - TIMESTAMP */
#define ANT_TIMESTAMP_TIMESTAMP_MASK             (0xFFFFFFU)
#define ANT_TIMESTAMP_TIMESTAMP_SHIFT            (0U)
#define ANT_TIMESTAMP_TIMESTAMP(x)               (((uint32_t)(((uint32_t)(x)) << ANT_TIMESTAMP_TIMESTAMP_SHIFT)) & ANT_TIMESTAMP_TIMESTAMP_MASK)

/*! @name XCVR_CTRL - TRANSCEIVER CONTROL */
#define ANT_XCVR_CTRL_SEQCMD_MASK                (0xFU)
#define ANT_XCVR_CTRL_SEQCMD_SHIFT               (0U)
#define ANT_XCVR_CTRL_SEQCMD(x)                  (((uint32_t)(((uint32_t)(x)) << ANT_XCVR_CTRL_SEQCMD_SHIFT)) & ANT_XCVR_CTRL_SEQCMD_MASK)
#define ANT_XCVR_CTRL_TX_PKT_LENGTH_MASK         (0x3F00U)
#define ANT_XCVR_CTRL_TX_PKT_LENGTH_SHIFT        (8U)
#define ANT_XCVR_CTRL_TX_PKT_LENGTH(x)           (((uint32_t)(((uint32_t)(x)) << ANT_XCVR_CTRL_TX_PKT_LENGTH_SHIFT)) & ANT_XCVR_CTRL_TX_PKT_LENGTH_MASK)
#define ANT_XCVR_CTRL_RX_PKT_LENGTH_MASK         (0x3F0000U)
#define ANT_XCVR_CTRL_RX_PKT_LENGTH_SHIFT        (16U)
#define ANT_XCVR_CTRL_RX_PKT_LENGTH(x)           (((uint32_t)(((uint32_t)(x)) << ANT_XCVR_CTRL_RX_PKT_LENGTH_SHIFT)) & ANT_XCVR_CTRL_RX_PKT_LENGTH_MASK)
#define ANT_XCVR_CTRL_CMDDEC_CS_MASK             (0x7000000U)
#define ANT_XCVR_CTRL_CMDDEC_CS_SHIFT            (24U)
#define ANT_XCVR_CTRL_CMDDEC_CS(x)               (((uint32_t)(((uint32_t)(x)) << ANT_XCVR_CTRL_CMDDEC_CS_SHIFT)) & ANT_XCVR_CTRL_CMDDEC_CS_MASK)
#define ANT_XCVR_CTRL_XCVR_BUSY_MASK             (0x80000000U)
#define ANT_XCVR_CTRL_XCVR_BUSY_SHIFT            (31U)

/*! @name XCVR_STS - TRANSCEIVER STATUS */
#define ANT_XCVR_STS_TX_START_T1_PEND_MASK       (0x1U)
#define ANT_XCVR_STS_TX_START_T1_PEND_SHIFT      (0U)
#define ANT_XCVR_STS_TX_START_T2_PEND_MASK       (0x2U)
#define ANT_XCVR_STS_TX_START_T2_PEND_SHIFT      (1U)
#define ANT_XCVR_STS_TX_IN_WARMUP_MASK           (0x4U)
#define ANT_XCVR_STS_TX_IN_WARMUP_SHIFT          (2U)
#define ANT_XCVR_STS_TX_IN_PROGRESS_MASK         (0x8U)
#define ANT_XCVR_STS_TX_IN_PROGRESS_SHIFT        (3U)
#define ANT_XCVR_STS_TX_IN_WARMDN_MASK           (0x10U)
#define ANT_XCVR_STS_TX_IN_WARMDN_SHIFT          (4U)
#define ANT_XCVR_STS_RX_START_T1_PEND_MASK       (0x20U)
#define ANT_XCVR_STS_RX_START_T1_PEND_SHIFT      (5U)
#define ANT_XCVR_STS_RX_START_T2_PEND_MASK       (0x40U)
#define ANT_XCVR_STS_RX_START_T2_PEND_SHIFT      (6U)
#define ANT_XCVR_STS_RX_STOP_T1_PEND_MASK        (0x80U)
#define ANT_XCVR_STS_RX_STOP_T1_PEND_SHIFT       (7U)
#define ANT_XCVR_STS_RX_STOP_T2_PEND_MASK        (0x100U)
#define ANT_XCVR_STS_RX_STOP_T2_PEND_SHIFT       (8U)
#define ANT_XCVR_STS_RX_IN_WARMUP_MASK           (0x200U)
#define ANT_XCVR_STS_RX_IN_WARMUP_SHIFT          (9U)
#define ANT_XCVR_STS_RX_IN_SEARCH_MASK           (0x400U)
#define ANT_XCVR_STS_RX_IN_SEARCH_SHIFT          (10U)
#define ANT_XCVR_STS_RX_IN_PROGRESS_MASK         (0x800U)
#define ANT_XCVR_STS_RX_IN_PROGRESS_SHIFT        (11U)
#define ANT_XCVR_STS_RX_IN_WARMDN_MASK           (0x1000U)
#define ANT_XCVR_STS_RX_IN_WARMDN_SHIFT          (12U)
#define ANT_XCVR_STS_CRC_VALID_MASK              (0x8000U)
#define ANT_XCVR_STS_CRC_VALID_SHIFT             (15U)
#define ANT_XCVR_STS_RSSI_MASK                   (0xFF0000U)
#define ANT_XCVR_STS_RSSI_SHIFT                  (16U)
#define ANT_XCVR_STS_RSSI(x)                     (((uint32_t)(((uint32_t)(x)) << ANT_XCVR_STS_RSSI_SHIFT)) & ANT_XCVR_STS_RSSI_MASK)

/*! @name XCVR_CFG - TRANSCEIVER CONFIGURATION */
#define ANT_XCVR_CFG_TX_WHITEN_DIS_MASK          (0x1U)
#define ANT_XCVR_CFG_TX_WHITEN_DIS_SHIFT         (0U)
#define ANT_XCVR_CFG_RX_DEWHITEN_DIS_MASK        (0x2U)
#define ANT_XCVR_CFG_RX_DEWHITEN_DIS_SHIFT       (1U)
#define ANT_XCVR_CFG_SW_CRC_EN_MASK              (0x4U)
#define ANT_XCVR_CFG_SW_CRC_EN_SHIFT             (2U)
#define ANT_XCVR_CFG_PREAMBLE_SZ_MASK            (0x30U)
#define ANT_XCVR_CFG_PREAMBLE_SZ_SHIFT           (4U)
#define ANT_XCVR_CFG_PREAMBLE_SZ(x)              (((uint32_t)(((uint32_t)(x)) << ANT_XCVR_CFG_PREAMBLE_SZ_SHIFT)) & ANT_XCVR_CFG_PREAMBLE_SZ_MASK)
#define ANT_XCVR_CFG_TX_WARMUP_MASK              (0xFF00U)
#define ANT_XCVR_CFG_TX_WARMUP_SHIFT             (8U)
#define ANT_XCVR_CFG_TX_WARMUP(x)                (((uint32_t)(((uint32_t)(x)) << ANT_XCVR_CFG_TX_WARMUP_SHIFT)) & ANT_XCVR_CFG_TX_WARMUP_MASK)
#define ANT_XCVR_CFG_RX_WARMUP_MASK              (0xFF0000U)
#define ANT_XCVR_CFG_RX_WARMUP_SHIFT             (16U)
#define ANT_XCVR_CFG_RX_WARMUP(x)                (((uint32_t)(((uint32_t)(x)) << ANT_XCVR_CFG_RX_WARMUP_SHIFT)) & ANT_XCVR_CFG_RX_WARMUP_MASK)

/*! @name CHANNEL_NUM - CHANNEL NUMBER */
#define ANT_CHANNEL_NUM_CHANNEL_NUM_MASK         (0x7FU)
#define ANT_CHANNEL_NUM_CHANNEL_NUM_SHIFT        (0U)
#define ANT_CHANNEL_NUM_CHANNEL_NUM(x)           (((uint32_t)(((uint32_t)(x)) << ANT_CHANNEL_NUM_CHANNEL_NUM_SHIFT)) & ANT_CHANNEL_NUM_CHANNEL_NUM_MASK)

/*! @name TX_POWER - TRANSMIT POWER */
#define ANT_TX_POWER_TX_POWER_MASK               (0x3FU)
#define ANT_TX_POWER_TX_POWER_SHIFT              (0U)
#define ANT_TX_POWER_TX_POWER(x)                 (((uint32_t)(((uint32_t)(x)) << ANT_TX_POWER_TX_POWER_SHIFT)) & ANT_TX_POWER_TX_POWER_MASK)

/*! @name NTW_ADR_CTRL - NETWORK ADDRESS CONTROL */
#define ANT_NTW_ADR_CTRL_NTW_ADR_EN_MASK         (0xFU)
#define ANT_NTW_ADR_CTRL_NTW_ADR_EN_SHIFT        (0U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_EN(x)           (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_CTRL_NTW_ADR_EN_SHIFT)) & ANT_NTW_ADR_CTRL_NTW_ADR_EN_MASK)
#define ANT_NTW_ADR_CTRL_NTW_ADR_MCH_MASK        (0xF0U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_MCH_SHIFT       (4U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_MCH(x)          (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_CTRL_NTW_ADR_MCH_SHIFT)) & ANT_NTW_ADR_CTRL_NTW_ADR_MCH_MASK)
#define ANT_NTW_ADR_CTRL_NTW_ADR0_SZ_MASK        (0x300U)
#define ANT_NTW_ADR_CTRL_NTW_ADR0_SZ_SHIFT       (8U)
#define ANT_NTW_ADR_CTRL_NTW_ADR0_SZ(x)          (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_CTRL_NTW_ADR0_SZ_SHIFT)) & ANT_NTW_ADR_CTRL_NTW_ADR0_SZ_MASK)
#define ANT_NTW_ADR_CTRL_NTW_ADR1_SZ_MASK        (0xC00U)
#define ANT_NTW_ADR_CTRL_NTW_ADR1_SZ_SHIFT       (10U)
#define ANT_NTW_ADR_CTRL_NTW_ADR1_SZ(x)          (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_CTRL_NTW_ADR1_SZ_SHIFT)) & ANT_NTW_ADR_CTRL_NTW_ADR1_SZ_MASK)
#define ANT_NTW_ADR_CTRL_NTW_ADR2_SZ_MASK        (0x3000U)
#define ANT_NTW_ADR_CTRL_NTW_ADR2_SZ_SHIFT       (12U)
#define ANT_NTW_ADR_CTRL_NTW_ADR2_SZ(x)          (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_CTRL_NTW_ADR2_SZ_SHIFT)) & ANT_NTW_ADR_CTRL_NTW_ADR2_SZ_MASK)
#define ANT_NTW_ADR_CTRL_NTW_ADR3_SZ_MASK        (0xC000U)
#define ANT_NTW_ADR_CTRL_NTW_ADR3_SZ_SHIFT       (14U)
#define ANT_NTW_ADR_CTRL_NTW_ADR3_SZ(x)          (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_CTRL_NTW_ADR3_SZ_SHIFT)) & ANT_NTW_ADR_CTRL_NTW_ADR3_SZ_MASK)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR0_MASK       (0x70000U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR0_SHIFT      (16U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR0(x)         (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_CTRL_NTW_ADR_THR0_SHIFT)) & ANT_NTW_ADR_CTRL_NTW_ADR_THR0_MASK)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR1_MASK       (0x700000U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR1_SHIFT      (20U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR1(x)         (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_CTRL_NTW_ADR_THR1_SHIFT)) & ANT_NTW_ADR_CTRL_NTW_ADR_THR1_MASK)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR2_MASK       (0x7000000U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR2_SHIFT      (24U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR2(x)         (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_CTRL_NTW_ADR_THR2_SHIFT)) & ANT_NTW_ADR_CTRL_NTW_ADR_THR2_MASK)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR3_MASK       (0x70000000U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR3_SHIFT      (28U)
#define ANT_NTW_ADR_CTRL_NTW_ADR_THR3(x)         (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_CTRL_NTW_ADR_THR3_SHIFT)) & ANT_NTW_ADR_CTRL_NTW_ADR_THR3_MASK)

/*! @name NTW_ADR_0 - NETWORK ADDRESS 0 */
#define ANT_NTW_ADR_0_NTW_ADR_0_MASK             (0xFFFFFFFFU)
#define ANT_NTW_ADR_0_NTW_ADR_0_SHIFT            (0U)
#define ANT_NTW_ADR_0_NTW_ADR_0(x)               (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_0_NTW_ADR_0_SHIFT)) & ANT_NTW_ADR_0_NTW_ADR_0_MASK)

/*! @name NTW_ADR_1 - NETWORK ADDRESS 1 */
#define ANT_NTW_ADR_1_NTW_ADR_1_MASK             (0xFFFFFFFFU)
#define ANT_NTW_ADR_1_NTW_ADR_1_SHIFT            (0U)
#define ANT_NTW_ADR_1_NTW_ADR_1(x)               (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_1_NTW_ADR_1_SHIFT)) & ANT_NTW_ADR_1_NTW_ADR_1_MASK)

/*! @name NTW_ADR_2 - NETWORK ADDRESS 2 */
#define ANT_NTW_ADR_2_NTW_ADR_2_MASK             (0xFFFFFFFFU)
#define ANT_NTW_ADR_2_NTW_ADR_2_SHIFT            (0U)
#define ANT_NTW_ADR_2_NTW_ADR_2(x)               (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_2_NTW_ADR_2_SHIFT)) & ANT_NTW_ADR_2_NTW_ADR_2_MASK)

/*! @name NTW_ADR_3 - NETWORK ADDRESS 3 */
#define ANT_NTW_ADR_3_NTW_ADR_3_MASK             (0xFFFFFFFFU)
#define ANT_NTW_ADR_3_NTW_ADR_3_SHIFT            (0U)
#define ANT_NTW_ADR_3_NTW_ADR_3(x)               (((uint32_t)(((uint32_t)(x)) << ANT_NTW_ADR_3_NTW_ADR_3_SHIFT)) & ANT_NTW_ADR_3_NTW_ADR_3_MASK)

/*! @name RX_WATERMARK - RX WATERMARK */
#define ANT_RX_WATERMARK_RX_WATERMARK_MASK       (0x7FU)
#define ANT_RX_WATERMARK_RX_WATERMARK_SHIFT      (0U)
#define ANT_RX_WATERMARK_RX_WATERMARK(x)         (((uint32_t)(((uint32_t)(x)) << ANT_RX_WATERMARK_RX_WATERMARK_SHIFT)) & ANT_RX_WATERMARK_RX_WATERMARK_MASK)
#define ANT_RX_WATERMARK_BYTE_COUNTER_MASK       (0x7F0000U)
#define ANT_RX_WATERMARK_BYTE_COUNTER_SHIFT      (16U)
#define ANT_RX_WATERMARK_BYTE_COUNTER(x)         (((uint32_t)(((uint32_t)(x)) << ANT_RX_WATERMARK_BYTE_COUNTER_SHIFT)) & ANT_RX_WATERMARK_BYTE_COUNTER_MASK)

/*! @name DSM_CTRL - DSM CONTROL */
#define ANT_DSM_CTRL_ANT_SLEEP_EN_MASK           (0x1U)
#define ANT_DSM_CTRL_ANT_SLEEP_EN_SHIFT          (0U)

/*! @name PART_ID - PART ID */
#define ANT_PART_ID_PART_ID_MASK                 (0xFFU)
#define ANT_PART_ID_PART_ID_SHIFT                (0U)
#define ANT_PART_ID_PART_ID(x)                   (((uint32_t)(((uint32_t)(x)) << ANT_PART_ID_PART_ID_SHIFT)) & ANT_PART_ID_PART_ID_MASK)

/*! @name PACKET_BUFFER - PACKET BUFFER */
#define ANT_PACKET_BUFFER_PACKET_BUFFER_MASK     (0xFFFFU)
#define ANT_PACKET_BUFFER_PACKET_BUFFER_SHIFT    (0U)
#define ANT_PACKET_BUFFER_PACKET_BUFFER(x)       (((uint16_t)(((uint16_t)(x)) << ANT_PACKET_BUFFER_PACKET_BUFFER_SHIFT)) & ANT_PACKET_BUFFER_PACKET_BUFFER_MASK)

/* The count of ANT_PACKET_BUFFER */
#define ANT_PACKET_BUFFER_COUNT                  (64U)


/*!
 * @}
 */ /* end of group ANT_Register_Masks */


/* ANT - Peripheral instance base addresses */
/** Peripheral ANT_REGS base pointer */
#define ANT_BASE_PTR                             ((ANT_MemMapPtr)0x4005E000u)
/** Array initializer of ANT peripheral base pointers */
#define ANT_BASE_PTRS                            { ANT_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ANT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ANT_Register_Accessor_Macros ANT - Register accessor macros
 * @{
 */


/* ANT - Register instance definitions */
/* ANT_REGS */
#define ANT_IRQ_CTRL                             ANT_IRQ_CTRL_REG(ANT_BASE_PTR)
#define ANT_EVENT_TMR                            ANT_EVENT_TMR_REG(ANT_BASE_PTR)
#define ANT_T1_CMP                               ANT_T1_CMP_REG(ANT_BASE_PTR)
#define ANT_T2_CMP                               ANT_T2_CMP_REG(ANT_BASE_PTR)
#define ANT_TIMESTAMP                            ANT_TIMESTAMP_REG(ANT_BASE_PTR)
#define ANT_XCVR_CTRL                            ANT_XCVR_CTRL_REG(ANT_BASE_PTR)
#define ANT_XCVR_STS                             ANT_XCVR_STS_REG(ANT_BASE_PTR)
#define ANT_XCVR_CFG                             ANT_XCVR_CFG_REG(ANT_BASE_PTR)
#define ANT_CHANNEL_NUM                          ANT_CHANNEL_NUM_REG(ANT_BASE_PTR)
#define ANT_TX_POWER                             ANT_TX_POWER_REG(ANT_BASE_PTR)
#define ANT_NTW_ADR_CTRL                         ANT_NTW_ADR_CTRL_REG(ANT_BASE_PTR)
#define ANT_NTW_ADR_0                            ANT_NTW_ADR_0_REG(ANT_BASE_PTR)
#define ANT_NTW_ADR_1                            ANT_NTW_ADR_1_REG(ANT_BASE_PTR)
#define ANT_NTW_ADR_2                            ANT_NTW_ADR_2_REG(ANT_BASE_PTR)
#define ANT_NTW_ADR_3                            ANT_NTW_ADR_3_REG(ANT_BASE_PTR)
#define ANT_RX_WATERMARK                         ANT_RX_WATERMARK_REG(ANT_BASE_PTR)
#define ANT_DSM_CTRL                             ANT_DSM_CTRL_REG(ANT_BASE_PTR)
#define ANT_PART_ID                              ANT_PART_ID_REG(ANT_BASE_PTR)
#define ANT_PACKET_BUFFER_0                      ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,0)
#define ANT_PACKET_BUFFER_1                      ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,1)
#define ANT_PACKET_BUFFER_2                      ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,2)
#define ANT_PACKET_BUFFER_3                      ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,3)
#define ANT_PACKET_BUFFER_4                      ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,4)
#define ANT_PACKET_BUFFER_5                      ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,5)
#define ANT_PACKET_BUFFER_6                      ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,6)
#define ANT_PACKET_BUFFER_7                      ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,7)
#define ANT_PACKET_BUFFER_8                      ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,8)
#define ANT_PACKET_BUFFER_9                      ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,9)
#define ANT_PACKET_BUFFER_10                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,10)
#define ANT_PACKET_BUFFER_11                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,11)
#define ANT_PACKET_BUFFER_12                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,12)
#define ANT_PACKET_BUFFER_13                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,13)
#define ANT_PACKET_BUFFER_14                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,14)
#define ANT_PACKET_BUFFER_15                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,15)
#define ANT_PACKET_BUFFER_16                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,16)
#define ANT_PACKET_BUFFER_17                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,17)
#define ANT_PACKET_BUFFER_18                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,18)
#define ANT_PACKET_BUFFER_19                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,19)
#define ANT_PACKET_BUFFER_20                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,20)
#define ANT_PACKET_BUFFER_21                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,21)
#define ANT_PACKET_BUFFER_22                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,22)
#define ANT_PACKET_BUFFER_23                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,23)
#define ANT_PACKET_BUFFER_24                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,24)
#define ANT_PACKET_BUFFER_25                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,25)
#define ANT_PACKET_BUFFER_26                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,26)
#define ANT_PACKET_BUFFER_27                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,27)
#define ANT_PACKET_BUFFER_28                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,28)
#define ANT_PACKET_BUFFER_29                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,29)
#define ANT_PACKET_BUFFER_30                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,30)
#define ANT_PACKET_BUFFER_31                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,31)
#define ANT_PACKET_BUFFER_32                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,32)
#define ANT_PACKET_BUFFER_33                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,33)
#define ANT_PACKET_BUFFER_34                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,34)
#define ANT_PACKET_BUFFER_35                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,35)
#define ANT_PACKET_BUFFER_36                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,36)
#define ANT_PACKET_BUFFER_37                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,37)
#define ANT_PACKET_BUFFER_38                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,38)
#define ANT_PACKET_BUFFER_39                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,39)
#define ANT_PACKET_BUFFER_40                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,40)
#define ANT_PACKET_BUFFER_41                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,41)
#define ANT_PACKET_BUFFER_42                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,42)
#define ANT_PACKET_BUFFER_43                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,43)
#define ANT_PACKET_BUFFER_44                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,44)
#define ANT_PACKET_BUFFER_45                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,45)
#define ANT_PACKET_BUFFER_46                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,46)
#define ANT_PACKET_BUFFER_47                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,47)
#define ANT_PACKET_BUFFER_48                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,48)
#define ANT_PACKET_BUFFER_49                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,49)
#define ANT_PACKET_BUFFER_50                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,50)
#define ANT_PACKET_BUFFER_51                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,51)
#define ANT_PACKET_BUFFER_52                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,52)
#define ANT_PACKET_BUFFER_53                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,53)
#define ANT_PACKET_BUFFER_54                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,54)
#define ANT_PACKET_BUFFER_55                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,55)
#define ANT_PACKET_BUFFER_56                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,56)
#define ANT_PACKET_BUFFER_57                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,57)
#define ANT_PACKET_BUFFER_58                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,58)
#define ANT_PACKET_BUFFER_59                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,59)
#define ANT_PACKET_BUFFER_60                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,60)
#define ANT_PACKET_BUFFER_61                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,61)
#define ANT_PACKET_BUFFER_62                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,62)
#define ANT_PACKET_BUFFER_63                     ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,63)

/* ANT - Register array accessors */
#define ANT_PACKET_BUFFER(index)                 ANT_PACKET_BUFFER_REG(ANT_BASE_PTR,index)

/*!
 * @}
 */ /* end of group ANT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ANT_Peripheral */


/* ----------------------------------------------------------------------------
   -- BP
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BP_Peripheral BP
 * @{
 */

/** BP - Peripheral register structure */
typedef struct BP_MemMap {
  uint32_t CTRL;                                   /**< FlashPatch Control Register, offset: 0x0 */
  uint8_t RESERVED_0[4];
  uint32_t COMP[2];                                /**< FlashPatch Comparator Register 0..FlashPatch Comparator Register 1, array offset: 0x8, array step: 0x4 */
  uint8_t RESERVED_1[4032];
  uint32_t PID4;                                   /**< Peripheral Identification Register 4., offset: 0xFD0 */
  uint32_t PID5;                                   /**< Peripheral Identification Register 5., offset: 0xFD4 */
  uint32_t PID6;                                   /**< Peripheral Identification Register 6., offset: 0xFD8 */
  uint32_t PID7;                                   /**< Peripheral Identification Register 7., offset: 0xFDC */
  uint32_t PID0;                                   /**< Peripheral Identification Register 0., offset: 0xFE0 */
  uint32_t PID1;                                   /**< Peripheral Identification Register 1., offset: 0xFE4 */
  uint32_t PID2;                                   /**< Peripheral Identification Register 2., offset: 0xFE8 */
  uint32_t PID3;                                   /**< Peripheral Identification Register 3., offset: 0xFEC */
  uint32_t CID0;                                   /**< Component Identification Register 0., offset: 0xFF0 */
  uint32_t CID1;                                   /**< Component Identification Register 1., offset: 0xFF4 */
  uint32_t CID2;                                   /**< Component Identification Register 2., offset: 0xFF8 */
  uint32_t CID3;                                   /**< Component Identification Register 3., offset: 0xFFC */
} volatile *BP_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- BP - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BP_Register_Accessor_Macros BP - Register accessor macros
 * @{
 */


/* BP - Register accessors */
#define BP_CTRL_REG(base)                        ((base)->CTRL)
#define BP_COMP_REG(base,index)                  ((base)->COMP[index])
#define BP_PID4_REG(base)                        ((base)->PID4)
#define BP_PID5_REG(base)                        ((base)->PID5)
#define BP_PID6_REG(base)                        ((base)->PID6)
#define BP_PID7_REG(base)                        ((base)->PID7)
#define BP_PID0_REG(base)                        ((base)->PID0)
#define BP_PID1_REG(base)                        ((base)->PID1)
#define BP_PID2_REG(base)                        ((base)->PID2)
#define BP_PID3_REG(base)                        ((base)->PID3)
#define BP_CID0_REG(base)                        ((base)->CID0)
#define BP_CID1_REG(base)                        ((base)->CID1)
#define BP_CID2_REG(base)                        ((base)->CID2)
#define BP_CID3_REG(base)                        ((base)->CID3)

/*!
 * @}
 */ /* end of group BP_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- BP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BP_Register_Masks BP Register Masks
 * @{
 */

/* The count of BP_COMP */
#define BP_COMP_COUNT                            (2U)


/*!
 * @}
 */ /* end of group BP_Register_Masks */


/* BP - Peripheral instance base addresses */
/** Peripheral BP base pointer */
#define BP_BASE_PTR                              ((BP_MemMapPtr)0xE0002000u)
/** Array initializer of BP peripheral base pointers */
#define BP_BASE_PTRS                             { BP_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- BP - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BP_Register_Accessor_Macros BP - Register accessor macros
 * @{
 */


/* BP - Register instance definitions */
/* BP */
#define BP_CTRL                                  BP_CTRL_REG(BP_BASE_PTR)
#define BP_COMP0                                 BP_COMP_REG(BP_BASE_PTR,0)
#define BP_COMP1                                 BP_COMP_REG(BP_BASE_PTR,1)
#define BP_PID4                                  BP_PID4_REG(BP_BASE_PTR)
#define BP_PID5                                  BP_PID5_REG(BP_BASE_PTR)
#define BP_PID6                                  BP_PID6_REG(BP_BASE_PTR)
#define BP_PID7                                  BP_PID7_REG(BP_BASE_PTR)
#define BP_PID0                                  BP_PID0_REG(BP_BASE_PTR)
#define BP_PID1                                  BP_PID1_REG(BP_BASE_PTR)
#define BP_PID2                                  BP_PID2_REG(BP_BASE_PTR)
#define BP_PID3                                  BP_PID3_REG(BP_BASE_PTR)
#define BP_CID0                                  BP_CID0_REG(BP_BASE_PTR)
#define BP_CID1                                  BP_CID1_REG(BP_BASE_PTR)
#define BP_CID2                                  BP_CID2_REG(BP_BASE_PTR)
#define BP_CID3                                  BP_CID3_REG(BP_BASE_PTR)

/* BP - Register array accessors */
#define BP_COMP(index)                           BP_COMP_REG(BP_BASE_PTR,index)

/*!
 * @}
 */ /* end of group BP_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group BP_Peripheral */


/* ----------------------------------------------------------------------------
   -- BTLE_RF
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BTLE_RF_Peripheral BTLE_RF
 * @{
 */

/** BTLE_RF - Peripheral register structure */
typedef struct BTLE_RF_MemMap {
  uint8_t RESERVED_0[1536];
  uint16_t BLE_PART_ID;                            /**< BLUETOOTH LOW ENERGY PART ID, offset: 0x600 */
  uint8_t RESERVED_1[2];
  uint16_t DSM_STATUS;                             /**< BLE DSM STATUS, offset: 0x604 */
  uint8_t RESERVED_2[2];
  uint16_t MISC_CTRL;                              /**< BLUETOOTH LOW ENERGY MISCELLANEOUS CONTROL, offset: 0x608 */
} volatile *BTLE_RF_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- BTLE_RF - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BTLE_RF_Register_Accessor_Macros BTLE_RF - Register accessor macros
 * @{
 */


/* BTLE_RF - Register accessors */
#define BTLE_RF_BLE_PART_ID_REG(base)            ((base)->BLE_PART_ID)
#define BTLE_RF_DSM_STATUS_REG(base)             ((base)->DSM_STATUS)
#define BTLE_RF_MISC_CTRL_REG(base)              ((base)->MISC_CTRL)

/*!
 * @}
 */ /* end of group BTLE_RF_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- BTLE_RF Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BTLE_RF_Register_Masks BTLE_RF Register Masks
 * @{
 */

/*! @name BLE_PART_ID - BLUETOOTH LOW ENERGY PART ID */
#define BTLE_RF_BLE_PART_ID_BLE_PART_ID_MASK     (0xFFFFU)
#define BTLE_RF_BLE_PART_ID_BLE_PART_ID_SHIFT    (0U)
#define BTLE_RF_BLE_PART_ID_BLE_PART_ID(x)       (((uint16_t)(((uint16_t)(x)) << BTLE_RF_BLE_PART_ID_BLE_PART_ID_SHIFT)) & BTLE_RF_BLE_PART_ID_BLE_PART_ID_MASK)

/*! @name DSM_STATUS - BLE DSM STATUS */
#define BTLE_RF_DSM_STATUS_ORF_SYSCLK_REQ_MASK   (0x1U)
#define BTLE_RF_DSM_STATUS_ORF_SYSCLK_REQ_SHIFT  (0U)
#define BTLE_RF_DSM_STATUS_RIF_LL_ACTIVE_MASK    (0x2U)
#define BTLE_RF_DSM_STATUS_RIF_LL_ACTIVE_SHIFT   (1U)
#define BTLE_RF_DSM_STATUS_XCVR_BUSY_MASK        (0x4U)
#define BTLE_RF_DSM_STATUS_XCVR_BUSY_SHIFT       (2U)

/*! @name MISC_CTRL - BLUETOOTH LOW ENERGY MISCELLANEOUS CONTROL */
#define BTLE_RF_MISC_CTRL_TSM_INTR_EN_MASK       (0x2U)
#define BTLE_RF_MISC_CTRL_TSM_INTR_EN_SHIFT      (1U)


/*!
 * @}
 */ /* end of group BTLE_RF_Register_Masks */


/* BTLE_RF - Peripheral instance base addresses */
/** Peripheral BTLE_RF_regs base pointer */
#define BTLE_RF_BASE_PTR                         ((BTLE_RF_MemMapPtr)0x4005B000u)
/** Array initializer of BTLE_RF peripheral base pointers */
#define BTLE_RF_BASE_PTRS                        { BTLE_RF_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- BTLE_RF - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BTLE_RF_Register_Accessor_Macros BTLE_RF - Register accessor macros
 * @{
 */


/* BTLE_RF - Register instance definitions */
/* BTLE_RF_regs */
#define BTLE_RF_BLE_PART_ID                      BTLE_RF_BLE_PART_ID_REG(BTLE_RF_BASE_PTR)
#define BTLE_RF_DSM_STATUS                       BTLE_RF_DSM_STATUS_REG(BTLE_RF_BASE_PTR)
#define BTLE_RF_MISC_CTRL                        BTLE_RF_MISC_CTRL_REG(BTLE_RF_BASE_PTR)

/*!
 * @}
 */ /* end of group BTLE_RF_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group BTLE_RF_Peripheral */


/* ----------------------------------------------------------------------------
   -- CMP
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Peripheral CMP
 * @{
 */

/** CMP - Peripheral register structure */
typedef struct CMP_MemMap {
  uint8_t CR0;                                     /**< CMP Control Register 0, offset: 0x0 */
  uint8_t CR1;                                     /**< CMP Control Register 1, offset: 0x1 */
  uint8_t FPR;                                     /**< CMP Filter Period Register, offset: 0x2 */
  uint8_t SCR;                                     /**< CMP Status and Control Register, offset: 0x3 */
  uint8_t DACCR;                                   /**< DAC Control Register, offset: 0x4 */
  uint8_t MUXCR;                                   /**< MUX Control Register, offset: 0x5 */
} volatile *CMP_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CMP - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Accessor_Macros CMP - Register accessor macros
 * @{
 */


/* CMP - Register accessors */
#define CMP_CR0_REG(base)                        ((base)->CR0)
#define CMP_CR1_REG(base)                        ((base)->CR1)
#define CMP_FPR_REG(base)                        ((base)->FPR)
#define CMP_SCR_REG(base)                        ((base)->SCR)
#define CMP_DACCR_REG(base)                      ((base)->DACCR)
#define CMP_MUXCR_REG(base)                      ((base)->MUXCR)

/*!
 * @}
 */ /* end of group CMP_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CMP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Masks CMP Register Masks
 * @{
 */

/*! @name CR0 - CMP Control Register 0 */
#define CMP_CR0_HYSTCTR_MASK                     (0x3U)
#define CMP_CR0_HYSTCTR_SHIFT                    (0U)
#define CMP_CR0_HYSTCTR(x)                       (((uint8_t)(((uint8_t)(x)) << CMP_CR0_HYSTCTR_SHIFT)) & CMP_CR0_HYSTCTR_MASK)
#define CMP_CR0_FILTER_CNT_MASK                  (0x70U)
#define CMP_CR0_FILTER_CNT_SHIFT                 (4U)
#define CMP_CR0_FILTER_CNT(x)                    (((uint8_t)(((uint8_t)(x)) << CMP_CR0_FILTER_CNT_SHIFT)) & CMP_CR0_FILTER_CNT_MASK)

/*! @name CR1 - CMP Control Register 1 */
#define CMP_CR1_EN_MASK                          (0x1U)
#define CMP_CR1_EN_SHIFT                         (0U)
#define CMP_CR1_OPE_MASK                         (0x2U)
#define CMP_CR1_OPE_SHIFT                        (1U)
#define CMP_CR1_COS_MASK                         (0x4U)
#define CMP_CR1_COS_SHIFT                        (2U)
#define CMP_CR1_INV_MASK                         (0x8U)
#define CMP_CR1_INV_SHIFT                        (3U)
#define CMP_CR1_PMODE_MASK                       (0x10U)
#define CMP_CR1_PMODE_SHIFT                      (4U)
#define CMP_CR1_TRIGM_MASK                       (0x20U)
#define CMP_CR1_TRIGM_SHIFT                      (5U)
#define CMP_CR1_WE_MASK                          (0x40U)
#define CMP_CR1_WE_SHIFT                         (6U)
#define CMP_CR1_SE_MASK                          (0x80U)
#define CMP_CR1_SE_SHIFT                         (7U)

/*! @name FPR - CMP Filter Period Register */
#define CMP_FPR_FILT_PER_MASK                    (0xFFU)
#define CMP_FPR_FILT_PER_SHIFT                   (0U)
#define CMP_FPR_FILT_PER(x)                      (((uint8_t)(((uint8_t)(x)) << CMP_FPR_FILT_PER_SHIFT)) & CMP_FPR_FILT_PER_MASK)

/*! @name SCR - CMP Status and Control Register */
#define CMP_SCR_COUT_MASK                        (0x1U)
#define CMP_SCR_COUT_SHIFT                       (0U)
#define CMP_SCR_CFF_MASK                         (0x2U)
#define CMP_SCR_CFF_SHIFT                        (1U)
#define CMP_SCR_CFR_MASK                         (0x4U)
#define CMP_SCR_CFR_SHIFT                        (2U)
#define CMP_SCR_IEF_MASK                         (0x8U)
#define CMP_SCR_IEF_SHIFT                        (3U)
#define CMP_SCR_IER_MASK                         (0x10U)
#define CMP_SCR_IER_SHIFT                        (4U)
#define CMP_SCR_DMAEN_MASK                       (0x40U)
#define CMP_SCR_DMAEN_SHIFT                      (6U)

/*! @name DACCR - DAC Control Register */
#define CMP_DACCR_VOSEL_MASK                     (0x3FU)
#define CMP_DACCR_VOSEL_SHIFT                    (0U)
#define CMP_DACCR_VOSEL(x)                       (((uint8_t)(((uint8_t)(x)) << CMP_DACCR_VOSEL_SHIFT)) & CMP_DACCR_VOSEL_MASK)
#define CMP_DACCR_VRSEL_MASK                     (0x40U)
#define CMP_DACCR_VRSEL_SHIFT                    (6U)
#define CMP_DACCR_DACEN_MASK                     (0x80U)
#define CMP_DACCR_DACEN_SHIFT                    (7U)

/*! @name MUXCR - MUX Control Register */
#define CMP_MUXCR_MSEL_MASK                      (0x7U)
#define CMP_MUXCR_MSEL_SHIFT                     (0U)
#define CMP_MUXCR_MSEL(x)                        (((uint8_t)(((uint8_t)(x)) << CMP_MUXCR_MSEL_SHIFT)) & CMP_MUXCR_MSEL_MASK)
#define CMP_MUXCR_PSEL_MASK                      (0x38U)
#define CMP_MUXCR_PSEL_SHIFT                     (3U)
#define CMP_MUXCR_PSEL(x)                        (((uint8_t)(((uint8_t)(x)) << CMP_MUXCR_PSEL_SHIFT)) & CMP_MUXCR_PSEL_MASK)
#define CMP_MUXCR_PSTM_MASK                      (0x80U)
#define CMP_MUXCR_PSTM_SHIFT                     (7U)


/*!
 * @}
 */ /* end of group CMP_Register_Masks */


/* CMP - Peripheral instance base addresses */
/** Peripheral CMP0 base pointer */
#define CMP0_BASE_PTR                            ((CMP_MemMapPtr)0x40073000u)
/** Array initializer of CMP peripheral base pointers */
#define CMP_BASE_PTRS                            { CMP0_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- CMP - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Accessor_Macros CMP - Register accessor macros
 * @{
 */


/* CMP - Register instance definitions */
/* CMP0 */
#define CMP0_CR0                                 CMP_CR0_REG(CMP0_BASE_PTR)
#define CMP0_CR1                                 CMP_CR1_REG(CMP0_BASE_PTR)
#define CMP0_FPR                                 CMP_FPR_REG(CMP0_BASE_PTR)
#define CMP0_SCR                                 CMP_SCR_REG(CMP0_BASE_PTR)
#define CMP0_DACCR                               CMP_DACCR_REG(CMP0_BASE_PTR)
#define CMP0_MUXCR                               CMP_MUXCR_REG(CMP0_BASE_PTR)

/*!
 * @}
 */ /* end of group CMP_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CMP_Peripheral */


/* ----------------------------------------------------------------------------
   -- CMT
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMT_Peripheral CMT
 * @{
 */

/** CMT - Peripheral register structure */
typedef struct CMT_MemMap {
  uint8_t CGH1;                                    /**< CMT Carrier Generator High Data Register 1, offset: 0x0 */
  uint8_t CGL1;                                    /**< CMT Carrier Generator Low Data Register 1, offset: 0x1 */
  uint8_t CGH2;                                    /**< CMT Carrier Generator High Data Register 2, offset: 0x2 */
  uint8_t CGL2;                                    /**< CMT Carrier Generator Low Data Register 2, offset: 0x3 */
  uint8_t OC;                                      /**< CMT Output Control Register, offset: 0x4 */
  uint8_t MSC;                                     /**< CMT Modulator Status and Control Register, offset: 0x5 */
  uint8_t CMD1;                                    /**< CMT Modulator Data Register Mark High, offset: 0x6 */
  uint8_t CMD2;                                    /**< CMT Modulator Data Register Mark Low, offset: 0x7 */
  uint8_t CMD3;                                    /**< CMT Modulator Data Register Space High, offset: 0x8 */
  uint8_t CMD4;                                    /**< CMT Modulator Data Register Space Low, offset: 0x9 */
  uint8_t PPS;                                     /**< CMT Primary Prescaler Register, offset: 0xA */
  uint8_t DMA;                                     /**< CMT Direct Memory Access Register, offset: 0xB */
} volatile *CMT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CMT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMT_Register_Accessor_Macros CMT - Register accessor macros
 * @{
 */


/* CMT - Register accessors */
#define CMT_CGH1_REG(base)                       ((base)->CGH1)
#define CMT_CGL1_REG(base)                       ((base)->CGL1)
#define CMT_CGH2_REG(base)                       ((base)->CGH2)
#define CMT_CGL2_REG(base)                       ((base)->CGL2)
#define CMT_OC_REG(base)                         ((base)->OC)
#define CMT_MSC_REG(base)                        ((base)->MSC)
#define CMT_CMD1_REG(base)                       ((base)->CMD1)
#define CMT_CMD2_REG(base)                       ((base)->CMD2)
#define CMT_CMD3_REG(base)                       ((base)->CMD3)
#define CMT_CMD4_REG(base)                       ((base)->CMD4)
#define CMT_PPS_REG(base)                        ((base)->PPS)
#define CMT_DMA_REG(base)                        ((base)->DMA)

/*!
 * @}
 */ /* end of group CMT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CMT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMT_Register_Masks CMT Register Masks
 * @{
 */

/*! @name CGH1 - CMT Carrier Generator High Data Register 1 */
#define CMT_CGH1_PH_MASK                         (0xFFU)
#define CMT_CGH1_PH_SHIFT                        (0U)
#define CMT_CGH1_PH(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CGH1_PH_SHIFT)) & CMT_CGH1_PH_MASK)

/*! @name CGL1 - CMT Carrier Generator Low Data Register 1 */
#define CMT_CGL1_PL_MASK                         (0xFFU)
#define CMT_CGL1_PL_SHIFT                        (0U)
#define CMT_CGL1_PL(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CGL1_PL_SHIFT)) & CMT_CGL1_PL_MASK)

/*! @name CGH2 - CMT Carrier Generator High Data Register 2 */
#define CMT_CGH2_SH_MASK                         (0xFFU)
#define CMT_CGH2_SH_SHIFT                        (0U)
#define CMT_CGH2_SH(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CGH2_SH_SHIFT)) & CMT_CGH2_SH_MASK)

/*! @name CGL2 - CMT Carrier Generator Low Data Register 2 */
#define CMT_CGL2_SL_MASK                         (0xFFU)
#define CMT_CGL2_SL_SHIFT                        (0U)
#define CMT_CGL2_SL(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CGL2_SL_SHIFT)) & CMT_CGL2_SL_MASK)

/*! @name OC - CMT Output Control Register */
#define CMT_OC_IROPEN_MASK                       (0x20U)
#define CMT_OC_IROPEN_SHIFT                      (5U)
#define CMT_OC_CMTPOL_MASK                       (0x40U)
#define CMT_OC_CMTPOL_SHIFT                      (6U)
#define CMT_OC_IROL_MASK                         (0x80U)
#define CMT_OC_IROL_SHIFT                        (7U)

/*! @name MSC - CMT Modulator Status and Control Register */
#define CMT_MSC_MCGEN_MASK                       (0x1U)
#define CMT_MSC_MCGEN_SHIFT                      (0U)
#define CMT_MSC_EOCIE_MASK                       (0x2U)
#define CMT_MSC_EOCIE_SHIFT                      (1U)
#define CMT_MSC_FSK_MASK                         (0x4U)
#define CMT_MSC_FSK_SHIFT                        (2U)
#define CMT_MSC_BASE_MASK                        (0x8U)
#define CMT_MSC_BASE_SHIFT                       (3U)
#define CMT_MSC_EXSPC_MASK                       (0x10U)
#define CMT_MSC_EXSPC_SHIFT                      (4U)
#define CMT_MSC_CMTDIV_MASK                      (0x60U)
#define CMT_MSC_CMTDIV_SHIFT                     (5U)
#define CMT_MSC_CMTDIV(x)                        (((uint8_t)(((uint8_t)(x)) << CMT_MSC_CMTDIV_SHIFT)) & CMT_MSC_CMTDIV_MASK)
#define CMT_MSC_EOCF_MASK                        (0x80U)
#define CMT_MSC_EOCF_SHIFT                       (7U)

/*! @name CMD1 - CMT Modulator Data Register Mark High */
#define CMT_CMD1_MB_MASK                         (0xFFU)
#define CMT_CMD1_MB_SHIFT                        (0U)
#define CMT_CMD1_MB(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CMD1_MB_SHIFT)) & CMT_CMD1_MB_MASK)

/*! @name CMD2 - CMT Modulator Data Register Mark Low */
#define CMT_CMD2_MB_MASK                         (0xFFU)
#define CMT_CMD2_MB_SHIFT                        (0U)
#define CMT_CMD2_MB(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CMD2_MB_SHIFT)) & CMT_CMD2_MB_MASK)

/*! @name CMD3 - CMT Modulator Data Register Space High */
#define CMT_CMD3_SB_MASK                         (0xFFU)
#define CMT_CMD3_SB_SHIFT                        (0U)
#define CMT_CMD3_SB(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CMD3_SB_SHIFT)) & CMT_CMD3_SB_MASK)

/*! @name CMD4 - CMT Modulator Data Register Space Low */
#define CMT_CMD4_SB_MASK                         (0xFFU)
#define CMT_CMD4_SB_SHIFT                        (0U)
#define CMT_CMD4_SB(x)                           (((uint8_t)(((uint8_t)(x)) << CMT_CMD4_SB_SHIFT)) & CMT_CMD4_SB_MASK)

/*! @name PPS - CMT Primary Prescaler Register */
#define CMT_PPS_PPSDIV_MASK                      (0xFU)
#define CMT_PPS_PPSDIV_SHIFT                     (0U)
#define CMT_PPS_PPSDIV(x)                        (((uint8_t)(((uint8_t)(x)) << CMT_PPS_PPSDIV_SHIFT)) & CMT_PPS_PPSDIV_MASK)

/*! @name DMA - CMT Direct Memory Access Register */
#define CMT_DMA_DMA_MASK                         (0x1U)
#define CMT_DMA_DMA_SHIFT                        (0U)


/*!
 * @}
 */ /* end of group CMT_Register_Masks */


/* CMT - Peripheral instance base addresses */
/** Peripheral CMT base pointer */
#define CMT_BASE_PTR                             ((CMT_MemMapPtr)0x40062000u)
/** Array initializer of CMT peripheral base pointers */
#define CMT_BASE_PTRS                            { CMT_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- CMT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMT_Register_Accessor_Macros CMT - Register accessor macros
 * @{
 */


/* CMT - Register instance definitions */
/* CMT */
#define CMT_CGH1                                 CMT_CGH1_REG(CMT_BASE_PTR)
#define CMT_CGL1                                 CMT_CGL1_REG(CMT_BASE_PTR)
#define CMT_CGH2                                 CMT_CGH2_REG(CMT_BASE_PTR)
#define CMT_CGL2                                 CMT_CGL2_REG(CMT_BASE_PTR)
#define CMT_OC                                   CMT_OC_REG(CMT_BASE_PTR)
#define CMT_MSC                                  CMT_MSC_REG(CMT_BASE_PTR)
#define CMT_CMD1                                 CMT_CMD1_REG(CMT_BASE_PTR)
#define CMT_CMD2                                 CMT_CMD2_REG(CMT_BASE_PTR)
#define CMT_CMD3                                 CMT_CMD3_REG(CMT_BASE_PTR)
#define CMT_CMD4                                 CMT_CMD4_REG(CMT_BASE_PTR)
#define CMT_PPS                                  CMT_PPS_REG(CMT_BASE_PTR)
#define CMT_DMA                                  CMT_DMA_REG(CMT_BASE_PTR)

/*!
 * @}
 */ /* end of group CMT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CMT_Peripheral */


/* ----------------------------------------------------------------------------
   -- CoreDebug
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CoreDebug_Peripheral CoreDebug
 * @{
 */

/** CoreDebug - Peripheral register structure */
typedef struct CoreDebug_MemMap {
  union {                                          /* offset: 0x0 */
    uint32_t base_DHCSR_Read;                        /**< Debug Halting Control and Status Register, offset: 0x0 */
    uint32_t base_DHCSR_Write;                       /**< Debug Halting Control and Status Register, offset: 0x0 */
  };
  uint32_t base_DCRSR;                             /**< Debug Core Register Selector Register, offset: 0x4 */
  uint32_t base_DCRDR;                             /**< Debug Core Register Data Register, offset: 0x8 */
  uint32_t base_DEMCR;                             /**< Debug Exception and Monitor Control Register, offset: 0xC */
} volatile *CoreDebug_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CoreDebug - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CoreDebug_Register_Accessor_Macros CoreDebug - Register accessor macros
 * @{
 */


/* CoreDebug - Register accessors */
#define CoreDebug_base_DHCSR_Read_REG(base)      ((base)->base_DHCSR_Read)
#define CoreDebug_base_DHCSR_Write_REG(base)     ((base)->base_DHCSR_Write)
#define CoreDebug_base_DCRSR_REG(base)           ((base)->base_DCRSR)
#define CoreDebug_base_DCRDR_REG(base)           ((base)->base_DCRDR)
#define CoreDebug_base_DEMCR_REG(base)           ((base)->base_DEMCR)

/*!
 * @}
 */ /* end of group CoreDebug_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CoreDebug Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CoreDebug_Register_Masks CoreDebug Register Masks
 * @{
 */


/*!
 * @}
 */ /* end of group CoreDebug_Register_Masks */


/* CoreDebug - Peripheral instance base addresses */
/** Peripheral CoreDebug base pointer */
#define CoreDebug_BASE_PTR                       ((CoreDebug_MemMapPtr)0xE000EDF0u)
/** Array initializer of CoreDebug peripheral base pointers */
#define CoreDebug_BASE_PTRS                      { CoreDebug_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- CoreDebug - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CoreDebug_Register_Accessor_Macros CoreDebug - Register accessor macros
 * @{
 */


/* CoreDebug - Register instance definitions */
/* CoreDebug */
#define DHCSR_Read                               CoreDebug_base_DHCSR_Read_REG(CoreDebug_BASE_PTR)
#define DHCSR_Write                              CoreDebug_base_DHCSR_Write_REG(CoreDebug_BASE_PTR)
#define DCRSR                                    CoreDebug_base_DCRSR_REG(CoreDebug_BASE_PTR)
#define DCRDR                                    CoreDebug_base_DCRDR_REG(CoreDebug_BASE_PTR)
#define DEMCR                                    CoreDebug_base_DEMCR_REG(CoreDebug_BASE_PTR)

/*!
 * @}
 */ /* end of group CoreDebug_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CoreDebug_Peripheral */


/* ----------------------------------------------------------------------------
   -- DAC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Peripheral DAC
 * @{
 */

/** DAC - Peripheral register structure */
typedef struct DAC_MemMap {
  struct {                                         /* offset: 0x0, array step: 0x2 */
    uint8_t DATL;                                    /**< DAC Data Low Register, array offset: 0x0, array step: 0x2 */
    uint8_t DATH;                                    /**< DAC Data High Register, array offset: 0x1, array step: 0x2 */
  } DAT[2];
  uint8_t RESERVED_0[28];
  uint8_t SR;                                      /**< DAC Status Register, offset: 0x20 */
  uint8_t C0;                                      /**< DAC Control Register, offset: 0x21 */
  uint8_t C1;                                      /**< DAC Control Register 1, offset: 0x22 */
  uint8_t C2;                                      /**< DAC Control Register 2, offset: 0x23 */
} volatile *DAC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DAC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Register_Accessor_Macros DAC - Register accessor macros
 * @{
 */


/* DAC - Register accessors */
#define DAC_DATL_REG(base,index)                 ((base)->DAT[index].DATL)
#define DAC_DATH_REG(base,index)                 ((base)->DAT[index].DATH)
#define DAC_SR_REG(base)                         ((base)->SR)
#define DAC_C0_REG(base)                         ((base)->C0)
#define DAC_C1_REG(base)                         ((base)->C1)
#define DAC_C2_REG(base)                         ((base)->C2)

/*!
 * @}
 */ /* end of group DAC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DAC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Register_Masks DAC Register Masks
 * @{
 */

/*! @name DATL - DAC Data Low Register */
#define DAC_DATL_DATA0_MASK                      (0xFFU)
#define DAC_DATL_DATA0_SHIFT                     (0U)
#define DAC_DATL_DATA0(x)                        (((uint8_t)(((uint8_t)(x)) << DAC_DATL_DATA0_SHIFT)) & DAC_DATL_DATA0_MASK)

/* The count of DAC_DATL */
#define DAC_DATL_COUNT                           (2U)

/*! @name DATH - DAC Data High Register */
#define DAC_DATH_DATA1_MASK                      (0xFU)
#define DAC_DATH_DATA1_SHIFT                     (0U)
#define DAC_DATH_DATA1(x)                        (((uint8_t)(((uint8_t)(x)) << DAC_DATH_DATA1_SHIFT)) & DAC_DATH_DATA1_MASK)

/* The count of DAC_DATH */
#define DAC_DATH_COUNT                           (2U)

/*! @name SR - DAC Status Register */
#define DAC_SR_DACBFRPBF_MASK                    (0x1U)
#define DAC_SR_DACBFRPBF_SHIFT                   (0U)
#define DAC_SR_DACBFRPTF_MASK                    (0x2U)
#define DAC_SR_DACBFRPTF_SHIFT                   (1U)
#define DAC_SR_DACBFWMF_MASK                     (0x4U)
#define DAC_SR_DACBFWMF_SHIFT                    (2U)

/*! @name C0 - DAC Control Register */
#define DAC_C0_DACBBIEN_MASK                     (0x1U)
#define DAC_C0_DACBBIEN_SHIFT                    (0U)
#define DAC_C0_DACBTIEN_MASK                     (0x2U)
#define DAC_C0_DACBTIEN_SHIFT                    (1U)
#define DAC_C0_DACBWIEN_MASK                     (0x4U)
#define DAC_C0_DACBWIEN_SHIFT                    (2U)
#define DAC_C0_LPEN_MASK                         (0x8U)
#define DAC_C0_LPEN_SHIFT                        (3U)
#define DAC_C0_DACSWTRG_MASK                     (0x10U)
#define DAC_C0_DACSWTRG_SHIFT                    (4U)
#define DAC_C0_DACTRGSEL_MASK                    (0x20U)
#define DAC_C0_DACTRGSEL_SHIFT                   (5U)
#define DAC_C0_DACRFS_MASK                       (0x40U)
#define DAC_C0_DACRFS_SHIFT                      (6U)
#define DAC_C0_DACEN_MASK                        (0x80U)
#define DAC_C0_DACEN_SHIFT                       (7U)

/*! @name C1 - DAC Control Register 1 */
#define DAC_C1_DACBFEN_MASK                      (0x1U)
#define DAC_C1_DACBFEN_SHIFT                     (0U)
#define DAC_C1_DACBFMD_MASK                      (0x4U)
#define DAC_C1_DACBFMD_SHIFT                     (2U)
#define DAC_C1_DACBFWM_MASK                      (0x18U)
#define DAC_C1_DACBFWM_SHIFT                     (3U)
#define DAC_C1_DACBFWM(x)                        (((uint8_t)(((uint8_t)(x)) << DAC_C1_DACBFWM_SHIFT)) & DAC_C1_DACBFWM_MASK)
#define DAC_C1_DMAEN_MASK                        (0x80U)
#define DAC_C1_DMAEN_SHIFT                       (7U)

/*! @name C2 - DAC Control Register 2 */
#define DAC_C2_DACBFUP_MASK                      (0x1U)
#define DAC_C2_DACBFUP_SHIFT                     (0U)
#define DAC_C2_DACBFRP_MASK                      (0x10U)
#define DAC_C2_DACBFRP_SHIFT                     (4U)


/*!
 * @}
 */ /* end of group DAC_Register_Masks */


/* DAC - Peripheral instance base addresses */
/** Peripheral DAC0 base pointer */
#define DAC0_BASE_PTR                            ((DAC_MemMapPtr)0x4003F000u)
/** Array initializer of DAC peripheral base pointers */
#define DAC_BASE_PTRS                            { DAC0_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- DAC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Register_Accessor_Macros DAC - Register accessor macros
 * @{
 */


/* DAC - Register instance definitions */
/* DAC0 */
#define DAC0_DAT0L                               DAC_DATL_REG(DAC0_BASE_PTR,0)
#define DAC0_DAT0H                               DAC_DATH_REG(DAC0_BASE_PTR,0)
#define DAC0_DAT1L                               DAC_DATL_REG(DAC0_BASE_PTR,1)
#define DAC0_DAT1H                               DAC_DATH_REG(DAC0_BASE_PTR,1)
#define DAC0_SR                                  DAC_SR_REG(DAC0_BASE_PTR)
#define DAC0_C0                                  DAC_C0_REG(DAC0_BASE_PTR)
#define DAC0_C1                                  DAC_C1_REG(DAC0_BASE_PTR)
#define DAC0_C2                                  DAC_C2_REG(DAC0_BASE_PTR)

/* DAC - Register array accessors */
#define DAC0_DATL(index)                         DAC_DATL_REG(DAC0_BASE_PTR,index)
#define DAC0_DATH(index)                         DAC_DATH_REG(DAC0_BASE_PTR,index)

/*!
 * @}
 */ /* end of group DAC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DAC_Peripheral */


/* ----------------------------------------------------------------------------
   -- DCDC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCDC_Peripheral DCDC
 * @{
 */

/** DCDC - Peripheral register structure */
typedef struct DCDC_MemMap {
  uint32_t REG0;                                   /**< DCDC REGISTER 0, offset: 0x0 */
  uint32_t REG1;                                   /**< DCDC REGISTER 1, offset: 0x4 */
  uint32_t REG2;                                   /**< DCDC REGISTER 2, offset: 0x8 */
  uint32_t REG3;                                   /**< DCDC REGISTER 3, offset: 0xC */
  uint32_t REG4;                                   /**< DCDC REGISTER 4, offset: 0x10 */
  uint8_t RESERVED_0[4];
  uint32_t REG6;                                   /**< DCDC REGISTER 6, offset: 0x18 */
  uint32_t REG7;                                   /**< DCDC REGISTER 7, offset: 0x1C */
} volatile *DCDC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DCDC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCDC_Register_Accessor_Macros DCDC - Register accessor macros
 * @{
 */


/* DCDC - Register accessors */
#define DCDC_REG0_REG(base)                      ((base)->REG0)
#define DCDC_REG1_REG(base)                      ((base)->REG1)
#define DCDC_REG2_REG(base)                      ((base)->REG2)
#define DCDC_REG3_REG(base)                      ((base)->REG3)
#define DCDC_REG4_REG(base)                      ((base)->REG4)
#define DCDC_REG6_REG(base)                      ((base)->REG6)
#define DCDC_REG7_REG(base)                      ((base)->REG7)

/*!
 * @}
 */ /* end of group DCDC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DCDC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCDC_Register_Masks DCDC Register Masks
 * @{
 */

/*! @name REG0 - DCDC REGISTER 0 */
#define DCDC_REG0_DCDC_DISABLE_AUTO_CLK_SWITCH_MASK (0x2U)
#define DCDC_REG0_DCDC_DISABLE_AUTO_CLK_SWITCH_SHIFT (1U)
#define DCDC_REG0_DCDC_SEL_CLK_MASK              (0x4U)
#define DCDC_REG0_DCDC_SEL_CLK_SHIFT             (2U)
#define DCDC_REG0_DCDC_PWD_OSC_INT_MASK          (0x8U)
#define DCDC_REG0_DCDC_PWD_OSC_INT_SHIFT         (3U)
#define DCDC_REG0_DCDC_LP_DF_CMP_ENABLE_MASK     (0x200U)
#define DCDC_REG0_DCDC_LP_DF_CMP_ENABLE_SHIFT    (9U)
#define DCDC_REG0_DCDC_VBAT_DIV_CTRL_MASK        (0xC00U)
#define DCDC_REG0_DCDC_VBAT_DIV_CTRL_SHIFT       (10U)
#define DCDC_REG0_DCDC_VBAT_DIV_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_VBAT_DIV_CTRL_SHIFT)) & DCDC_REG0_DCDC_VBAT_DIV_CTRL_MASK)
#define DCDC_REG0_DCDC_LP_STATE_HYS_L_MASK       (0x60000U)
#define DCDC_REG0_DCDC_LP_STATE_HYS_L_SHIFT      (17U)
#define DCDC_REG0_DCDC_LP_STATE_HYS_L(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_LP_STATE_HYS_L_SHIFT)) & DCDC_REG0_DCDC_LP_STATE_HYS_L_MASK)
#define DCDC_REG0_DCDC_LP_STATE_HYS_H_MASK       (0x180000U)
#define DCDC_REG0_DCDC_LP_STATE_HYS_H_SHIFT      (19U)
#define DCDC_REG0_DCDC_LP_STATE_HYS_H(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG0_DCDC_LP_STATE_HYS_H_SHIFT)) & DCDC_REG0_DCDC_LP_STATE_HYS_H_MASK)
#define DCDC_REG0_HYST_LP_COMP_ADJ_MASK          (0x200000U)
#define DCDC_REG0_HYST_LP_COMP_ADJ_SHIFT         (21U)
#define DCDC_REG0_HYST_LP_CMP_DISABLE_MASK       (0x400000U)
#define DCDC_REG0_HYST_LP_CMP_DISABLE_SHIFT      (22U)
#define DCDC_REG0_OFFSET_RSNS_LP_ADJ_MASK        (0x800000U)
#define DCDC_REG0_OFFSET_RSNS_LP_ADJ_SHIFT       (23U)
#define DCDC_REG0_OFFSET_RSNS_LP_DISABLE_MASK    (0x1000000U)
#define DCDC_REG0_OFFSET_RSNS_LP_DISABLE_SHIFT   (24U)
#define DCDC_REG0_DCDC_LESS_I_MASK               (0x2000000U)
#define DCDC_REG0_DCDC_LESS_I_SHIFT              (25U)
#define DCDC_REG0_PWD_CMP_OFFSET_MASK            (0x4000000U)
#define DCDC_REG0_PWD_CMP_OFFSET_SHIFT           (26U)
#define DCDC_REG0_DCDC_XTALOK_DISABLE_MASK       (0x8000000U)
#define DCDC_REG0_DCDC_XTALOK_DISABLE_SHIFT      (27U)
#define DCDC_REG0_PSWITCH_STATUS_MASK            (0x10000000U)
#define DCDC_REG0_PSWITCH_STATUS_SHIFT           (28U)
#define DCDC_REG0_VLPS_CONFIG_DCDC_HP_MASK       (0x20000000U)
#define DCDC_REG0_VLPS_CONFIG_DCDC_HP_SHIFT      (29U)
#define DCDC_REG0_VLPR_VLPW_CONFIG_DCDC_HP_MASK  (0x40000000U)
#define DCDC_REG0_VLPR_VLPW_CONFIG_DCDC_HP_SHIFT (30U)
#define DCDC_REG0_DCDC_STS_DC_OK_MASK            (0x80000000U)
#define DCDC_REG0_DCDC_STS_DC_OK_SHIFT           (31U)

/*! @name REG1 - DCDC REGISTER 1 */
#define DCDC_REG1_POSLIMIT_BUCK_IN_MASK          (0x7FU)
#define DCDC_REG1_POSLIMIT_BUCK_IN_SHIFT         (0U)
#define DCDC_REG1_POSLIMIT_BUCK_IN(x)            (((uint32_t)(((uint32_t)(x)) << DCDC_REG1_POSLIMIT_BUCK_IN_SHIFT)) & DCDC_REG1_POSLIMIT_BUCK_IN_MASK)
#define DCDC_REG1_POSLIMIT_BOOST_IN_MASK         (0x3F80U)
#define DCDC_REG1_POSLIMIT_BOOST_IN_SHIFT        (7U)
#define DCDC_REG1_POSLIMIT_BOOST_IN(x)           (((uint32_t)(((uint32_t)(x)) << DCDC_REG1_POSLIMIT_BOOST_IN_SHIFT)) & DCDC_REG1_POSLIMIT_BOOST_IN_MASK)
#define DCDC_REG1_DCDC_LOOPCTRL_CM_HST_THRESH_MASK (0x200000U)
#define DCDC_REG1_DCDC_LOOPCTRL_CM_HST_THRESH_SHIFT (21U)
#define DCDC_REG1_DCDC_LOOPCTRL_DF_HST_THRESH_MASK (0x400000U)
#define DCDC_REG1_DCDC_LOOPCTRL_DF_HST_THRESH_SHIFT (22U)
#define DCDC_REG1_DCDC_LOOPCTRL_EN_CM_HYST_MASK  (0x800000U)
#define DCDC_REG1_DCDC_LOOPCTRL_EN_CM_HYST_SHIFT (23U)
#define DCDC_REG1_DCDC_LOOPCTRL_EN_DF_HYST_MASK  (0x1000000U)
#define DCDC_REG1_DCDC_LOOPCTRL_EN_DF_HYST_SHIFT (24U)

/*! @name REG2 - DCDC REGISTER 2 */
#define DCDC_REG2_DCDC_LOOPCTRL_HYST_SIGN_MASK   (0x2000U)
#define DCDC_REG2_DCDC_LOOPCTRL_HYST_SIGN_SHIFT  (13U)
#define DCDC_REG2_DCDC_BATTMONITOR_EN_BATADJ_MASK (0x8000U)
#define DCDC_REG2_DCDC_BATTMONITOR_EN_BATADJ_SHIFT (15U)
#define DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL_MASK (0x3FF0000U)
#define DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL_SHIFT (16U)
#define DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL(x)   (((uint32_t)(((uint32_t)(x)) << DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL_SHIFT)) & DCDC_REG2_DCDC_BATTMONITOR_BATT_VAL_MASK)

/*! @name REG3 - DCDC REGISTER 3 */
#define DCDC_REG3_DCDC_VDD1P8CTRL_TRG_MASK       (0x3FU)
#define DCDC_REG3_DCDC_VDD1P8CTRL_TRG_SHIFT      (0U)
#define DCDC_REG3_DCDC_VDD1P8CTRL_TRG(x)         (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_VDD1P8CTRL_TRG_SHIFT)) & DCDC_REG3_DCDC_VDD1P8CTRL_TRG_MASK)
#define DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_MASK  (0x7C0U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_SHIFT (6U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK(x)    (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_SHIFT)) & DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BUCK_MASK)
#define DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST_MASK (0xF800U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST_SHIFT (11U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST(x)   (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST_SHIFT)) & DCDC_REG3_DCDC_VDD1P5CTRL_TRG_BOOST_MASK)
#define DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN_MASK     (0x1E0000U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN_SHIFT    (17U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN(x)       (((uint32_t)(((uint32_t)(x)) << DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN_SHIFT)) & DCDC_REG3_DCDC_VDD1P5CTRL_ADJTN_MASK)
#define DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_PULSED_MASK (0x200000U)
#define DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_PULSED_SHIFT (21U)
#define DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_PULSED_MASK (0x400000U)
#define DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_PULSED_SHIFT (22U)
#define DCDC_REG3_DCDC_MINPWR_HALF_FETS_PULSED_MASK (0x800000U)
#define DCDC_REG3_DCDC_MINPWR_HALF_FETS_PULSED_SHIFT (23U)
#define DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_MASK    (0x1000000U)
#define DCDC_REG3_DCDC_MINPWR_DC_HALFCLK_SHIFT   (24U)
#define DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_MASK   (0x2000000U)
#define DCDC_REG3_DCDC_MINPWR_DOUBLE_FETS_SHIFT  (25U)
#define DCDC_REG3_DCDC_MINPWR_HALF_FETS_MASK     (0x4000000U)
#define DCDC_REG3_DCDC_MINPWR_HALF_FETS_SHIFT    (26U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_DISABLE_STEP_MASK (0x20000000U)
#define DCDC_REG3_DCDC_VDD1P5CTRL_DISABLE_STEP_SHIFT (29U)
#define DCDC_REG3_DCDC_VDD1P8CTRL_DISABLE_STEP_MASK (0x40000000U)
#define DCDC_REG3_DCDC_VDD1P8CTRL_DISABLE_STEP_SHIFT (30U)

/*! @name REG4 - DCDC REGISTER 4 */
#define DCDC_REG4_DCDC_SW_SHUTDOWN_MASK          (0x1U)
#define DCDC_REG4_DCDC_SW_SHUTDOWN_SHIFT         (0U)
#define DCDC_REG4_UNLOCK_MASK                    (0xFFFF0000U)
#define DCDC_REG4_UNLOCK_SHIFT                   (16U)
#define DCDC_REG4_UNLOCK(x)                      (((uint32_t)(((uint32_t)(x)) << DCDC_REG4_UNLOCK_SHIFT)) & DCDC_REG4_UNLOCK_MASK)

/*! @name REG6 - DCDC REGISTER 6 */
#define DCDC_REG6_PSWITCH_INT_RISE_EN_MASK       (0x1U)
#define DCDC_REG6_PSWITCH_INT_RISE_EN_SHIFT      (0U)
#define DCDC_REG6_PSWITCH_INT_FALL_EN_MASK       (0x2U)
#define DCDC_REG6_PSWITCH_INT_FALL_EN_SHIFT      (1U)
#define DCDC_REG6_PSWITCH_INT_CLEAR_MASK         (0x4U)
#define DCDC_REG6_PSWITCH_INT_CLEAR_SHIFT        (2U)
#define DCDC_REG6_PSWITCH_INT_MUTE_MASK          (0x8U)
#define DCDC_REG6_PSWITCH_INT_MUTE_SHIFT         (3U)
#define DCDC_REG6_PSWITCH_INT_STS_MASK           (0x80000000U)
#define DCDC_REG6_PSWITCH_INT_STS_SHIFT          (31U)

/*! @name REG7 - DCDC REGISTER 7 */
#define DCDC_REG7_INTEGRATOR_VALUE_MASK          (0x7FFFFU)
#define DCDC_REG7_INTEGRATOR_VALUE_SHIFT         (0U)
#define DCDC_REG7_INTEGRATOR_VALUE(x)            (((uint32_t)(((uint32_t)(x)) << DCDC_REG7_INTEGRATOR_VALUE_SHIFT)) & DCDC_REG7_INTEGRATOR_VALUE_MASK)
#define DCDC_REG7_INTEGRATOR_VALUE_SEL_MASK      (0x80000U)
#define DCDC_REG7_INTEGRATOR_VALUE_SEL_SHIFT     (19U)
#define DCDC_REG7_PULSE_RUN_SPEEDUP_MASK         (0x100000U)
#define DCDC_REG7_PULSE_RUN_SPEEDUP_SHIFT        (20U)


/*!
 * @}
 */ /* end of group DCDC_Register_Masks */


/* DCDC - Peripheral instance base addresses */
/** Peripheral DCDC base pointer */
#define DCDC_BASE_PTR                            ((DCDC_MemMapPtr)0x4005A000u)
/** Array initializer of DCDC peripheral base pointers */
#define DCDC_BASE_PTRS                           { DCDC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- DCDC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DCDC_Register_Accessor_Macros DCDC - Register accessor macros
 * @{
 */


/* DCDC - Register instance definitions */
/* DCDC */
#define DCDC_REG0                                DCDC_REG0_REG(DCDC_BASE_PTR)
#define DCDC_REG1                                DCDC_REG1_REG(DCDC_BASE_PTR)
#define DCDC_REG2                                DCDC_REG2_REG(DCDC_BASE_PTR)
#define DCDC_REG3                                DCDC_REG3_REG(DCDC_BASE_PTR)
#define DCDC_REG4                                DCDC_REG4_REG(DCDC_BASE_PTR)
#define DCDC_REG6                                DCDC_REG6_REG(DCDC_BASE_PTR)
#define DCDC_REG7                                DCDC_REG7_REG(DCDC_BASE_PTR)

/*!
 * @}
 */ /* end of group DCDC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DCDC_Peripheral */


/* ----------------------------------------------------------------------------
   -- DMA
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral DMA
 * @{
 */

/** DMA - Peripheral register structure */
typedef struct DMA_MemMap {
  uint32_t CR;                                     /**< Control Register, offset: 0x0 */
  uint32_t ES;                                     /**< Error Status Register, offset: 0x4 */
  uint8_t RESERVED_0[4];
  uint32_t ERQ;                                    /**< Enable Request Register, offset: 0xC */
  uint8_t RESERVED_1[4];
  uint32_t EEI;                                    /**< Enable Error Interrupt Register, offset: 0x14 */
  uint8_t CEEI;                                    /**< Clear Enable Error Interrupt Register, offset: 0x18 */
  uint8_t SEEI;                                    /**< Set Enable Error Interrupt Register, offset: 0x19 */
  uint8_t CERQ;                                    /**< Clear Enable Request Register, offset: 0x1A */
  uint8_t SERQ;                                    /**< Set Enable Request Register, offset: 0x1B */
  uint8_t CDNE;                                    /**< Clear DONE Status Bit Register, offset: 0x1C */
  uint8_t SSRT;                                    /**< Set START Bit Register, offset: 0x1D */
  uint8_t CERR;                                    /**< Clear Error Register, offset: 0x1E */
  uint8_t CINT;                                    /**< Clear Interrupt Request Register, offset: 0x1F */
  uint8_t RESERVED_2[4];
  uint32_t INT;                                    /**< Interrupt Request Register, offset: 0x24 */
  uint8_t RESERVED_3[4];
  uint32_t ERR;                                    /**< Error Register, offset: 0x2C */
  uint8_t RESERVED_4[4];
  uint32_t HRS;                                    /**< Hardware Request Status Register, offset: 0x34 */
  uint8_t RESERVED_5[12];
  uint32_t EARS;                                   /**< Enable Asynchronous Request in Stop Register, offset: 0x44 */
  uint8_t RESERVED_6[184];
  uint8_t DCHPRI3;                                 /**< Channel n Priority Register, offset: 0x100 */
  uint8_t DCHPRI2;                                 /**< Channel n Priority Register, offset: 0x101 */
  uint8_t DCHPRI1;                                 /**< Channel n Priority Register, offset: 0x102 */
  uint8_t DCHPRI0;                                 /**< Channel n Priority Register, offset: 0x103 */
  uint8_t RESERVED_7[3836];
  struct {                                         /* offset: 0x1000, array step: 0x20 */
    uint32_t SADDR;                                  /**< TCD Source Address, array offset: 0x1000, array step: 0x20 */
    uint16_t SOFF;                                   /**< TCD Signed Source Address Offset, array offset: 0x1004, array step: 0x20 */
    uint16_t ATTR;                                   /**< TCD Transfer Attributes, array offset: 0x1006, array step: 0x20 */
    union {                                          /* offset: 0x1008, array step: 0x20 */
      uint32_t NBYTES_MLNO;                            /**< TCD Minor Byte Count (Minor Loop Mapping Disabled), array offset: 0x1008, array step: 0x20 */
      uint32_t NBYTES_MLOFFNO;                         /**< TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled), array offset: 0x1008, array step: 0x20 */
      uint32_t NBYTES_MLOFFYES;                        /**< TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled), array offset: 0x1008, array step: 0x20 */
    };
    uint32_t SLAST;                                  /**< TCD Last Source Address Adjustment, array offset: 0x100C, array step: 0x20 */
    uint32_t DADDR;                                  /**< TCD Destination Address, array offset: 0x1010, array step: 0x20 */
    uint16_t DOFF;                                   /**< TCD Signed Destination Address Offset, array offset: 0x1014, array step: 0x20 */
    union {                                          /* offset: 0x1016, array step: 0x20 */
      uint16_t CITER_ELINKNO;                          /**< TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled), array offset: 0x1016, array step: 0x20 */
      uint16_t CITER_ELINKYES;                         /**< TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled), array offset: 0x1016, array step: 0x20 */
    };
    uint32_t DLAST_SGA;                              /**< TCD Last Destination Address Adjustment/Scatter Gather Address, array offset: 0x1018, array step: 0x20 */
    uint16_t CSR;                                    /**< TCD Control and Status, array offset: 0x101C, array step: 0x20 */
    union {                                          /* offset: 0x101E, array step: 0x20 */
      uint16_t BITER_ELINKNO;                          /**< TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled), array offset: 0x101E, array step: 0x20 */
      uint16_t BITER_ELINKYES;                         /**< TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled), array offset: 0x101E, array step: 0x20 */
    };
  } TCD[4];
} volatile *DMA_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DMA - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Accessor_Macros DMA - Register accessor macros
 * @{
 */


/* DMA - Register accessors */
#define DMA_CR_REG(base)                         ((base)->CR)
#define DMA_ES_REG(base)                         ((base)->ES)
#define DMA_ERQ_REG(base)                        ((base)->ERQ)
#define DMA_EEI_REG(base)                        ((base)->EEI)
#define DMA_CEEI_REG(base)                       ((base)->CEEI)
#define DMA_SEEI_REG(base)                       ((base)->SEEI)
#define DMA_CERQ_REG(base)                       ((base)->CERQ)
#define DMA_SERQ_REG(base)                       ((base)->SERQ)
#define DMA_CDNE_REG(base)                       ((base)->CDNE)
#define DMA_SSRT_REG(base)                       ((base)->SSRT)
#define DMA_CERR_REG(base)                       ((base)->CERR)
#define DMA_CINT_REG(base)                       ((base)->CINT)
#define DMA_INT_REG(base)                        ((base)->INT)
#define DMA_ERR_REG(base)                        ((base)->ERR)
#define DMA_HRS_REG(base)                        ((base)->HRS)
#define DMA_EARS_REG(base)                       ((base)->EARS)
#define DMA_DCHPRI3_REG(base)                    ((base)->DCHPRI3)
#define DMA_DCHPRI2_REG(base)                    ((base)->DCHPRI2)
#define DMA_DCHPRI1_REG(base)                    ((base)->DCHPRI1)
#define DMA_DCHPRI0_REG(base)                    ((base)->DCHPRI0)
#define DMA_SADDR_REG(base,index)                ((base)->TCD[index].SADDR)
#define DMA_SOFF_REG(base,index)                 ((base)->TCD[index].SOFF)
#define DMA_ATTR_REG(base,index)                 ((base)->TCD[index].ATTR)
#define DMA_NBYTES_MLNO_REG(base,index)          ((base)->TCD[index].NBYTES_MLNO)
#define DMA_NBYTES_MLOFFNO_REG(base,index)       ((base)->TCD[index].NBYTES_MLOFFNO)
#define DMA_NBYTES_MLOFFYES_REG(base,index)      ((base)->TCD[index].NBYTES_MLOFFYES)
#define DMA_SLAST_REG(base,index)                ((base)->TCD[index].SLAST)
#define DMA_DADDR_REG(base,index)                ((base)->TCD[index].DADDR)
#define DMA_DOFF_REG(base,index)                 ((base)->TCD[index].DOFF)
#define DMA_CITER_ELINKNO_REG(base,index)        ((base)->TCD[index].CITER_ELINKNO)
#define DMA_CITER_ELINKYES_REG(base,index)       ((base)->TCD[index].CITER_ELINKYES)
#define DMA_DLAST_SGA_REG(base,index)            ((base)->TCD[index].DLAST_SGA)
#define DMA_CSR_REG(base,index)                  ((base)->TCD[index].CSR)
#define DMA_BITER_ELINKNO_REG(base,index)        ((base)->TCD[index].BITER_ELINKNO)
#define DMA_BITER_ELINKYES_REG(base,index)       ((base)->TCD[index].BITER_ELINKYES)

/*!
 * @}
 */ /* end of group DMA_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name CR - Control Register */
#define DMA_CR_EDBG_MASK                         (0x2U)
#define DMA_CR_EDBG_SHIFT                        (1U)
#define DMA_CR_ERCA_MASK                         (0x4U)
#define DMA_CR_ERCA_SHIFT                        (2U)
#define DMA_CR_HOE_MASK                          (0x10U)
#define DMA_CR_HOE_SHIFT                         (4U)
#define DMA_CR_HALT_MASK                         (0x20U)
#define DMA_CR_HALT_SHIFT                        (5U)
#define DMA_CR_CLM_MASK                          (0x40U)
#define DMA_CR_CLM_SHIFT                         (6U)
#define DMA_CR_EMLM_MASK                         (0x80U)
#define DMA_CR_EMLM_SHIFT                        (7U)
#define DMA_CR_ECX_MASK                          (0x10000U)
#define DMA_CR_ECX_SHIFT                         (16U)
#define DMA_CR_CX_MASK                           (0x20000U)
#define DMA_CR_CX_SHIFT                          (17U)

/*! @name ES - Error Status Register */
#define DMA_ES_DBE_MASK                          (0x1U)
#define DMA_ES_DBE_SHIFT                         (0U)
#define DMA_ES_SBE_MASK                          (0x2U)
#define DMA_ES_SBE_SHIFT                         (1U)
#define DMA_ES_SGE_MASK                          (0x4U)
#define DMA_ES_SGE_SHIFT                         (2U)
#define DMA_ES_NCE_MASK                          (0x8U)
#define DMA_ES_NCE_SHIFT                         (3U)
#define DMA_ES_DOE_MASK                          (0x10U)
#define DMA_ES_DOE_SHIFT                         (4U)
#define DMA_ES_DAE_MASK                          (0x20U)
#define DMA_ES_DAE_SHIFT                         (5U)
#define DMA_ES_SOE_MASK                          (0x40U)
#define DMA_ES_SOE_SHIFT                         (6U)
#define DMA_ES_SAE_MASK                          (0x80U)
#define DMA_ES_SAE_SHIFT                         (7U)
#define DMA_ES_ERRCHN_MASK                       (0x300U)
#define DMA_ES_ERRCHN_SHIFT                      (8U)
#define DMA_ES_ERRCHN(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_ES_ERRCHN_SHIFT)) & DMA_ES_ERRCHN_MASK)
#define DMA_ES_CPE_MASK                          (0x4000U)
#define DMA_ES_CPE_SHIFT                         (14U)
#define DMA_ES_ECX_MASK                          (0x10000U)
#define DMA_ES_ECX_SHIFT                         (16U)
#define DMA_ES_VLD_MASK                          (0x80000000U)
#define DMA_ES_VLD_SHIFT                         (31U)

/*! @name ERQ - Enable Request Register */
#define DMA_ERQ_ERQ0_MASK                        (0x1U)
#define DMA_ERQ_ERQ0_SHIFT                       (0U)
#define DMA_ERQ_ERQ1_MASK                        (0x2U)
#define DMA_ERQ_ERQ1_SHIFT                       (1U)
#define DMA_ERQ_ERQ2_MASK                        (0x4U)
#define DMA_ERQ_ERQ2_SHIFT                       (2U)
#define DMA_ERQ_ERQ3_MASK                        (0x8U)
#define DMA_ERQ_ERQ3_SHIFT                       (3U)

/*! @name EEI - Enable Error Interrupt Register */
#define DMA_EEI_EEI0_MASK                        (0x1U)
#define DMA_EEI_EEI0_SHIFT                       (0U)
#define DMA_EEI_EEI1_MASK                        (0x2U)
#define DMA_EEI_EEI1_SHIFT                       (1U)
#define DMA_EEI_EEI2_MASK                        (0x4U)
#define DMA_EEI_EEI2_SHIFT                       (2U)
#define DMA_EEI_EEI3_MASK                        (0x8U)
#define DMA_EEI_EEI3_SHIFT                       (3U)

/*! @name CEEI - Clear Enable Error Interrupt Register */
#define DMA_CEEI_CEEI_MASK                       (0x3U)
#define DMA_CEEI_CEEI_SHIFT                      (0U)
#define DMA_CEEI_CEEI(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CEEI_CEEI_SHIFT)) & DMA_CEEI_CEEI_MASK)
#define DMA_CEEI_CAEE_MASK                       (0x40U)
#define DMA_CEEI_CAEE_SHIFT                      (6U)
#define DMA_CEEI_NOP_MASK                        (0x80U)
#define DMA_CEEI_NOP_SHIFT                       (7U)

/*! @name SEEI - Set Enable Error Interrupt Register */
#define DMA_SEEI_SEEI_MASK                       (0x3U)
#define DMA_SEEI_SEEI_SHIFT                      (0U)
#define DMA_SEEI_SEEI(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_SEEI_SEEI_SHIFT)) & DMA_SEEI_SEEI_MASK)
#define DMA_SEEI_SAEE_MASK                       (0x40U)
#define DMA_SEEI_SAEE_SHIFT                      (6U)
#define DMA_SEEI_NOP_MASK                        (0x80U)
#define DMA_SEEI_NOP_SHIFT                       (7U)

/*! @name CERQ - Clear Enable Request Register */
#define DMA_CERQ_CERQ_MASK                       (0x3U)
#define DMA_CERQ_CERQ_SHIFT                      (0U)
#define DMA_CERQ_CERQ(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CERQ_CERQ_SHIFT)) & DMA_CERQ_CERQ_MASK)
#define DMA_CERQ_CAER_MASK                       (0x40U)
#define DMA_CERQ_CAER_SHIFT                      (6U)
#define DMA_CERQ_NOP_MASK                        (0x80U)
#define DMA_CERQ_NOP_SHIFT                       (7U)

/*! @name SERQ - Set Enable Request Register */
#define DMA_SERQ_SERQ_MASK                       (0x3U)
#define DMA_SERQ_SERQ_SHIFT                      (0U)
#define DMA_SERQ_SERQ(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_SERQ_SERQ_SHIFT)) & DMA_SERQ_SERQ_MASK)
#define DMA_SERQ_SAER_MASK                       (0x40U)
#define DMA_SERQ_SAER_SHIFT                      (6U)
#define DMA_SERQ_NOP_MASK                        (0x80U)
#define DMA_SERQ_NOP_SHIFT                       (7U)

/*! @name CDNE - Clear DONE Status Bit Register */
#define DMA_CDNE_CDNE_MASK                       (0x3U)
#define DMA_CDNE_CDNE_SHIFT                      (0U)
#define DMA_CDNE_CDNE(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CDNE_CDNE_SHIFT)) & DMA_CDNE_CDNE_MASK)
#define DMA_CDNE_CADN_MASK                       (0x40U)
#define DMA_CDNE_CADN_SHIFT                      (6U)
#define DMA_CDNE_NOP_MASK                        (0x80U)
#define DMA_CDNE_NOP_SHIFT                       (7U)

/*! @name SSRT - Set START Bit Register */
#define DMA_SSRT_SSRT_MASK                       (0x3U)
#define DMA_SSRT_SSRT_SHIFT                      (0U)
#define DMA_SSRT_SSRT(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_SSRT_SSRT_SHIFT)) & DMA_SSRT_SSRT_MASK)
#define DMA_SSRT_SAST_MASK                       (0x40U)
#define DMA_SSRT_SAST_SHIFT                      (6U)
#define DMA_SSRT_NOP_MASK                        (0x80U)
#define DMA_SSRT_NOP_SHIFT                       (7U)

/*! @name CERR - Clear Error Register */
#define DMA_CERR_CERR_MASK                       (0x3U)
#define DMA_CERR_CERR_SHIFT                      (0U)
#define DMA_CERR_CERR(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CERR_CERR_SHIFT)) & DMA_CERR_CERR_MASK)
#define DMA_CERR_CAEI_MASK                       (0x40U)
#define DMA_CERR_CAEI_SHIFT                      (6U)
#define DMA_CERR_NOP_MASK                        (0x80U)
#define DMA_CERR_NOP_SHIFT                       (7U)

/*! @name CINT - Clear Interrupt Request Register */
#define DMA_CINT_CINT_MASK                       (0x3U)
#define DMA_CINT_CINT_SHIFT                      (0U)
#define DMA_CINT_CINT(x)                         (((uint8_t)(((uint8_t)(x)) << DMA_CINT_CINT_SHIFT)) & DMA_CINT_CINT_MASK)
#define DMA_CINT_CAIR_MASK                       (0x40U)
#define DMA_CINT_CAIR_SHIFT                      (6U)
#define DMA_CINT_NOP_MASK                        (0x80U)
#define DMA_CINT_NOP_SHIFT                       (7U)

/*! @name INT - Interrupt Request Register */
#define DMA_INT_INT0_MASK                        (0x1U)
#define DMA_INT_INT0_SHIFT                       (0U)
#define DMA_INT_INT1_MASK                        (0x2U)
#define DMA_INT_INT1_SHIFT                       (1U)
#define DMA_INT_INT2_MASK                        (0x4U)
#define DMA_INT_INT2_SHIFT                       (2U)
#define DMA_INT_INT3_MASK                        (0x8U)
#define DMA_INT_INT3_SHIFT                       (3U)

/*! @name ERR - Error Register */
#define DMA_ERR_ERR0_MASK                        (0x1U)
#define DMA_ERR_ERR0_SHIFT                       (0U)
#define DMA_ERR_ERR1_MASK                        (0x2U)
#define DMA_ERR_ERR1_SHIFT                       (1U)
#define DMA_ERR_ERR2_MASK                        (0x4U)
#define DMA_ERR_ERR2_SHIFT                       (2U)
#define DMA_ERR_ERR3_MASK                        (0x8U)
#define DMA_ERR_ERR3_SHIFT                       (3U)

/*! @name HRS - Hardware Request Status Register */
#define DMA_HRS_HRS0_MASK                        (0x1U)
#define DMA_HRS_HRS0_SHIFT                       (0U)
#define DMA_HRS_HRS1_MASK                        (0x2U)
#define DMA_HRS_HRS1_SHIFT                       (1U)
#define DMA_HRS_HRS2_MASK                        (0x4U)
#define DMA_HRS_HRS2_SHIFT                       (2U)
#define DMA_HRS_HRS3_MASK                        (0x8U)
#define DMA_HRS_HRS3_SHIFT                       (3U)

/*! @name EARS - Enable Asynchronous Request in Stop Register */
#define DMA_EARS_EDREQ_0_MASK                    (0x1U)
#define DMA_EARS_EDREQ_0_SHIFT                   (0U)
#define DMA_EARS_EDREQ_1_MASK                    (0x2U)
#define DMA_EARS_EDREQ_1_SHIFT                   (1U)
#define DMA_EARS_EDREQ_2_MASK                    (0x4U)
#define DMA_EARS_EDREQ_2_SHIFT                   (2U)
#define DMA_EARS_EDREQ_3_MASK                    (0x8U)
#define DMA_EARS_EDREQ_3_SHIFT                   (3U)

/*! @name DCHPRI3 - Channel n Priority Register */
#define DMA_DCHPRI3_CHPRI_MASK                   (0x3U)
#define DMA_DCHPRI3_CHPRI_SHIFT                  (0U)
#define DMA_DCHPRI3_CHPRI(x)                     (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI3_CHPRI_SHIFT)) & DMA_DCHPRI3_CHPRI_MASK)
#define DMA_DCHPRI3_DPA_MASK                     (0x40U)
#define DMA_DCHPRI3_DPA_SHIFT                    (6U)
#define DMA_DCHPRI3_ECP_MASK                     (0x80U)
#define DMA_DCHPRI3_ECP_SHIFT                    (7U)

/*! @name DCHPRI2 - Channel n Priority Register */
#define DMA_DCHPRI2_CHPRI_MASK                   (0x3U)
#define DMA_DCHPRI2_CHPRI_SHIFT                  (0U)
#define DMA_DCHPRI2_CHPRI(x)                     (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI2_CHPRI_SHIFT)) & DMA_DCHPRI2_CHPRI_MASK)
#define DMA_DCHPRI2_DPA_MASK                     (0x40U)
#define DMA_DCHPRI2_DPA_SHIFT                    (6U)
#define DMA_DCHPRI2_ECP_MASK                     (0x80U)
#define DMA_DCHPRI2_ECP_SHIFT                    (7U)

/*! @name DCHPRI1 - Channel n Priority Register */
#define DMA_DCHPRI1_CHPRI_MASK                   (0x3U)
#define DMA_DCHPRI1_CHPRI_SHIFT                  (0U)
#define DMA_DCHPRI1_CHPRI(x)                     (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI1_CHPRI_SHIFT)) & DMA_DCHPRI1_CHPRI_MASK)
#define DMA_DCHPRI1_DPA_MASK                     (0x40U)
#define DMA_DCHPRI1_DPA_SHIFT                    (6U)
#define DMA_DCHPRI1_ECP_MASK                     (0x80U)
#define DMA_DCHPRI1_ECP_SHIFT                    (7U)

/*! @name DCHPRI0 - Channel n Priority Register */
#define DMA_DCHPRI0_CHPRI_MASK                   (0x3U)
#define DMA_DCHPRI0_CHPRI_SHIFT                  (0U)
#define DMA_DCHPRI0_CHPRI(x)                     (((uint8_t)(((uint8_t)(x)) << DMA_DCHPRI0_CHPRI_SHIFT)) & DMA_DCHPRI0_CHPRI_MASK)
#define DMA_DCHPRI0_DPA_MASK                     (0x40U)
#define DMA_DCHPRI0_DPA_SHIFT                    (6U)
#define DMA_DCHPRI0_ECP_MASK                     (0x80U)
#define DMA_DCHPRI0_ECP_SHIFT                    (7U)

/*! @name SADDR - TCD Source Address */
#define DMA_SADDR_SADDR_MASK                     (0xFFFFFFFFU)
#define DMA_SADDR_SADDR_SHIFT                    (0U)
#define DMA_SADDR_SADDR(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_SADDR_SADDR_SHIFT)) & DMA_SADDR_SADDR_MASK)

/* The count of DMA_SADDR */
#define DMA_SADDR_COUNT                          (4U)

/*! @name SOFF - TCD Signed Source Address Offset */
#define DMA_SOFF_SOFF_MASK                       (0xFFFFU)
#define DMA_SOFF_SOFF_SHIFT                      (0U)
#define DMA_SOFF_SOFF(x)                         (((uint16_t)(((uint16_t)(x)) << DMA_SOFF_SOFF_SHIFT)) & DMA_SOFF_SOFF_MASK)

/* The count of DMA_SOFF */
#define DMA_SOFF_COUNT                           (4U)

/*! @name ATTR - TCD Transfer Attributes */
#define DMA_ATTR_DSIZE_MASK                      (0x7U)
#define DMA_ATTR_DSIZE_SHIFT                     (0U)
#define DMA_ATTR_DSIZE(x)                        (((uint16_t)(((uint16_t)(x)) << DMA_ATTR_DSIZE_SHIFT)) & DMA_ATTR_DSIZE_MASK)
#define DMA_ATTR_DMOD_MASK                       (0xF8U)
#define DMA_ATTR_DMOD_SHIFT                      (3U)
#define DMA_ATTR_DMOD(x)                         (((uint16_t)(((uint16_t)(x)) << DMA_ATTR_DMOD_SHIFT)) & DMA_ATTR_DMOD_MASK)
#define DMA_ATTR_SSIZE_MASK                      (0x700U)
#define DMA_ATTR_SSIZE_SHIFT                     (8U)
#define DMA_ATTR_SSIZE(x)                        (((uint16_t)(((uint16_t)(x)) << DMA_ATTR_SSIZE_SHIFT)) & DMA_ATTR_SSIZE_MASK)
#define DMA_ATTR_SMOD_MASK                       (0xF800U)
#define DMA_ATTR_SMOD_SHIFT                      (11U)
#define DMA_ATTR_SMOD(x)                         (((uint16_t)(((uint16_t)(x)) << DMA_ATTR_SMOD_SHIFT)) & DMA_ATTR_SMOD_MASK)

/* The count of DMA_ATTR */
#define DMA_ATTR_COUNT                           (4U)

/*! @name NBYTES_MLNO - TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_NBYTES_MLNO_NBYTES_MASK              (0xFFFFFFFFU)
#define DMA_NBYTES_MLNO_NBYTES_SHIFT             (0U)
#define DMA_NBYTES_MLNO_NBYTES(x)                (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLNO_NBYTES_SHIFT)) & DMA_NBYTES_MLNO_NBYTES_MASK)

/* The count of DMA_NBYTES_MLNO */
#define DMA_NBYTES_MLNO_COUNT                    (4U)

/*! @name NBYTES_MLOFFNO - TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
#define DMA_NBYTES_MLOFFNO_NBYTES_MASK           (0x3FFFFFFFU)
#define DMA_NBYTES_MLOFFNO_NBYTES_SHIFT          (0U)
#define DMA_NBYTES_MLOFFNO_NBYTES(x)             (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLOFFNO_NBYTES_SHIFT)) & DMA_NBYTES_MLOFFNO_NBYTES_MASK)
#define DMA_NBYTES_MLOFFNO_DMLOE_MASK            (0x40000000U)
#define DMA_NBYTES_MLOFFNO_DMLOE_SHIFT           (30U)
#define DMA_NBYTES_MLOFFNO_SMLOE_MASK            (0x80000000U)
#define DMA_NBYTES_MLOFFNO_SMLOE_SHIFT           (31U)

/* The count of DMA_NBYTES_MLOFFNO */
#define DMA_NBYTES_MLOFFNO_COUNT                 (4U)

/*! @name NBYTES_MLOFFYES - TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
#define DMA_NBYTES_MLOFFYES_NBYTES_MASK          (0x3FFU)
#define DMA_NBYTES_MLOFFYES_NBYTES_SHIFT         (0U)
#define DMA_NBYTES_MLOFFYES_NBYTES(x)            (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLOFFYES_NBYTES_SHIFT)) & DMA_NBYTES_MLOFFYES_NBYTES_MASK)
#define DMA_NBYTES_MLOFFYES_MLOFF_MASK           (0x3FFFFC00U)
#define DMA_NBYTES_MLOFFYES_MLOFF_SHIFT          (10U)
#define DMA_NBYTES_MLOFFYES_MLOFF(x)             (((uint32_t)(((uint32_t)(x)) << DMA_NBYTES_MLOFFYES_MLOFF_SHIFT)) & DMA_NBYTES_MLOFFYES_MLOFF_MASK)
#define DMA_NBYTES_MLOFFYES_DMLOE_MASK           (0x40000000U)
#define DMA_NBYTES_MLOFFYES_DMLOE_SHIFT          (30U)
#define DMA_NBYTES_MLOFFYES_SMLOE_MASK           (0x80000000U)
#define DMA_NBYTES_MLOFFYES_SMLOE_SHIFT          (31U)

/* The count of DMA_NBYTES_MLOFFYES */
#define DMA_NBYTES_MLOFFYES_COUNT                (4U)

/*! @name SLAST - TCD Last Source Address Adjustment */
#define DMA_SLAST_SLAST_MASK                     (0xFFFFFFFFU)
#define DMA_SLAST_SLAST_SHIFT                    (0U)
#define DMA_SLAST_SLAST(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_SLAST_SLAST_SHIFT)) & DMA_SLAST_SLAST_MASK)

/* The count of DMA_SLAST */
#define DMA_SLAST_COUNT                          (4U)

/*! @name DADDR - TCD Destination Address */
#define DMA_DADDR_DADDR_MASK                     (0xFFFFFFFFU)
#define DMA_DADDR_DADDR_SHIFT                    (0U)
#define DMA_DADDR_DADDR(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_DADDR_DADDR_SHIFT)) & DMA_DADDR_DADDR_MASK)

/* The count of DMA_DADDR */
#define DMA_DADDR_COUNT                          (4U)

/*! @name DOFF - TCD Signed Destination Address Offset */
#define DMA_DOFF_DOFF_MASK                       (0xFFFFU)
#define DMA_DOFF_DOFF_SHIFT                      (0U)
#define DMA_DOFF_DOFF(x)                         (((uint16_t)(((uint16_t)(x)) << DMA_DOFF_DOFF_SHIFT)) & DMA_DOFF_DOFF_MASK)

/* The count of DMA_DOFF */
#define DMA_DOFF_COUNT                           (4U)

/*! @name CITER_ELINKNO - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_CITER_ELINKNO_CITER_MASK             (0x7FFFU)
#define DMA_CITER_ELINKNO_CITER_SHIFT            (0U)
#define DMA_CITER_ELINKNO_CITER(x)               (((uint16_t)(((uint16_t)(x)) << DMA_CITER_ELINKNO_CITER_SHIFT)) & DMA_CITER_ELINKNO_CITER_MASK)
#define DMA_CITER_ELINKNO_ELINK_MASK             (0x8000U)
#define DMA_CITER_ELINKNO_ELINK_SHIFT            (15U)

/* The count of DMA_CITER_ELINKNO */
#define DMA_CITER_ELINKNO_COUNT                  (4U)

/*! @name CITER_ELINKYES - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_CITER_ELINKYES_CITER_MASK            (0x1FFU)
#define DMA_CITER_ELINKYES_CITER_SHIFT           (0U)
#define DMA_CITER_ELINKYES_CITER(x)              (((uint16_t)(((uint16_t)(x)) << DMA_CITER_ELINKYES_CITER_SHIFT)) & DMA_CITER_ELINKYES_CITER_MASK)
#define DMA_CITER_ELINKYES_LINKCH_MASK           (0x600U)
#define DMA_CITER_ELINKYES_LINKCH_SHIFT          (9U)
#define DMA_CITER_ELINKYES_LINKCH(x)             (((uint16_t)(((uint16_t)(x)) << DMA_CITER_ELINKYES_LINKCH_SHIFT)) & DMA_CITER_ELINKYES_LINKCH_MASK)
#define DMA_CITER_ELINKYES_ELINK_MASK            (0x8000U)
#define DMA_CITER_ELINKYES_ELINK_SHIFT           (15U)

/* The count of DMA_CITER_ELINKYES */
#define DMA_CITER_ELINKYES_COUNT                 (4U)

/*! @name DLAST_SGA - TCD Last Destination Address Adjustment/Scatter Gather Address */
#define DMA_DLAST_SGA_DLASTSGA_MASK              (0xFFFFFFFFU)
#define DMA_DLAST_SGA_DLASTSGA_SHIFT             (0U)
#define DMA_DLAST_SGA_DLASTSGA(x)                (((uint32_t)(((uint32_t)(x)) << DMA_DLAST_SGA_DLASTSGA_SHIFT)) & DMA_DLAST_SGA_DLASTSGA_MASK)

/* The count of DMA_DLAST_SGA */
#define DMA_DLAST_SGA_COUNT                      (4U)

/*! @name CSR - TCD Control and Status */
#define DMA_CSR_START_MASK                       (0x1U)
#define DMA_CSR_START_SHIFT                      (0U)
#define DMA_CSR_INTMAJOR_MASK                    (0x2U)
#define DMA_CSR_INTMAJOR_SHIFT                   (1U)
#define DMA_CSR_INTHALF_MASK                     (0x4U)
#define DMA_CSR_INTHALF_SHIFT                    (2U)
#define DMA_CSR_DREQ_MASK                        (0x8U)
#define DMA_CSR_DREQ_SHIFT                       (3U)
#define DMA_CSR_ESG_MASK                         (0x10U)
#define DMA_CSR_ESG_SHIFT                        (4U)
#define DMA_CSR_MAJORELINK_MASK                  (0x20U)
#define DMA_CSR_MAJORELINK_SHIFT                 (5U)
#define DMA_CSR_ACTIVE_MASK                      (0x40U)
#define DMA_CSR_ACTIVE_SHIFT                     (6U)
#define DMA_CSR_DONE_MASK                        (0x80U)
#define DMA_CSR_DONE_SHIFT                       (7U)
#define DMA_CSR_MAJORLINKCH_MASK                 (0x300U)
#define DMA_CSR_MAJORLINKCH_SHIFT                (8U)
#define DMA_CSR_MAJORLINKCH(x)                   (((uint16_t)(((uint16_t)(x)) << DMA_CSR_MAJORLINKCH_SHIFT)) & DMA_CSR_MAJORLINKCH_MASK)
#define DMA_CSR_BWC_MASK                         (0xC000U)
#define DMA_CSR_BWC_SHIFT                        (14U)
#define DMA_CSR_BWC(x)                           (((uint16_t)(((uint16_t)(x)) << DMA_CSR_BWC_SHIFT)) & DMA_CSR_BWC_MASK)

/* The count of DMA_CSR */
#define DMA_CSR_COUNT                            (4U)

/*! @name BITER_ELINKNO - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
#define DMA_BITER_ELINKNO_BITER_MASK             (0x7FFFU)
#define DMA_BITER_ELINKNO_BITER_SHIFT            (0U)
#define DMA_BITER_ELINKNO_BITER(x)               (((uint16_t)(((uint16_t)(x)) << DMA_BITER_ELINKNO_BITER_SHIFT)) & DMA_BITER_ELINKNO_BITER_MASK)
#define DMA_BITER_ELINKNO_ELINK_MASK             (0x8000U)
#define DMA_BITER_ELINKNO_ELINK_SHIFT            (15U)

/* The count of DMA_BITER_ELINKNO */
#define DMA_BITER_ELINKNO_COUNT                  (4U)

/*! @name BITER_ELINKYES - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
#define DMA_BITER_ELINKYES_BITER_MASK            (0x1FFU)
#define DMA_BITER_ELINKYES_BITER_SHIFT           (0U)
#define DMA_BITER_ELINKYES_BITER(x)              (((uint16_t)(((uint16_t)(x)) << DMA_BITER_ELINKYES_BITER_SHIFT)) & DMA_BITER_ELINKYES_BITER_MASK)
#define DMA_BITER_ELINKYES_LINKCH_MASK           (0x600U)
#define DMA_BITER_ELINKYES_LINKCH_SHIFT          (9U)
#define DMA_BITER_ELINKYES_LINKCH(x)             (((uint16_t)(((uint16_t)(x)) << DMA_BITER_ELINKYES_LINKCH_SHIFT)) & DMA_BITER_ELINKYES_LINKCH_MASK)
#define DMA_BITER_ELINKYES_ELINK_MASK            (0x8000U)
#define DMA_BITER_ELINKYES_ELINK_SHIFT           (15U)

/* The count of DMA_BITER_ELINKYES */
#define DMA_BITER_ELINKYES_COUNT                 (4U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
/** Peripheral DMA base pointer */
#define DMA_BASE_PTR                             ((DMA_MemMapPtr)0x40008000u)
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS                            { DMA_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- DMA - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Accessor_Macros DMA - Register accessor macros
 * @{
 */


/* DMA - Register instance definitions */
/* DMA */
#define DMA_CR                                   DMA_CR_REG(DMA_BASE_PTR)
#define DMA_ES                                   DMA_ES_REG(DMA_BASE_PTR)
#define DMA_ERQ                                  DMA_ERQ_REG(DMA_BASE_PTR)
#define DMA_EEI                                  DMA_EEI_REG(DMA_BASE_PTR)
#define DMA_CEEI                                 DMA_CEEI_REG(DMA_BASE_PTR)
#define DMA_SEEI                                 DMA_SEEI_REG(DMA_BASE_PTR)
#define DMA_CERQ                                 DMA_CERQ_REG(DMA_BASE_PTR)
#define DMA_SERQ                                 DMA_SERQ_REG(DMA_BASE_PTR)
#define DMA_CDNE                                 DMA_CDNE_REG(DMA_BASE_PTR)
#define DMA_SSRT                                 DMA_SSRT_REG(DMA_BASE_PTR)
#define DMA_CERR                                 DMA_CERR_REG(DMA_BASE_PTR)
#define DMA_CINT                                 DMA_CINT_REG(DMA_BASE_PTR)
#define DMA_INT                                  DMA_INT_REG(DMA_BASE_PTR)
#define DMA_ERR                                  DMA_ERR_REG(DMA_BASE_PTR)
#define DMA_HRS                                  DMA_HRS_REG(DMA_BASE_PTR)
#define DMA_EARS                                 DMA_EARS_REG(DMA_BASE_PTR)
#define DMA_DCHPRI3                              DMA_DCHPRI3_REG(DMA_BASE_PTR)
#define DMA_DCHPRI2                              DMA_DCHPRI2_REG(DMA_BASE_PTR)
#define DMA_DCHPRI1                              DMA_DCHPRI1_REG(DMA_BASE_PTR)
#define DMA_DCHPRI0                              DMA_DCHPRI0_REG(DMA_BASE_PTR)
#define DMA_TCD0_SADDR                           DMA_SADDR_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_SOFF                            DMA_SOFF_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_ATTR                            DMA_ATTR_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_SLAST                           DMA_SLAST_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_DADDR                           DMA_DADDR_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_DOFF                            DMA_DOFF_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_DLASTSGA                        DMA_DLAST_SGA_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_CSR                             DMA_CSR_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA_BASE_PTR,0)
#define DMA_TCD0_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA_BASE_PTR,0)
#define DMA_TCD1_SADDR                           DMA_SADDR_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_SOFF                            DMA_SOFF_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_ATTR                            DMA_ATTR_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_SLAST                           DMA_SLAST_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_DADDR                           DMA_DADDR_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_DOFF                            DMA_DOFF_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_DLASTSGA                        DMA_DLAST_SGA_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_CSR                             DMA_CSR_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA_BASE_PTR,1)
#define DMA_TCD1_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA_BASE_PTR,1)
#define DMA_TCD2_SADDR                           DMA_SADDR_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_SOFF                            DMA_SOFF_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_ATTR                            DMA_ATTR_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_SLAST                           DMA_SLAST_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_DADDR                           DMA_DADDR_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_DOFF                            DMA_DOFF_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_DLASTSGA                        DMA_DLAST_SGA_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_CSR                             DMA_CSR_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA_BASE_PTR,2)
#define DMA_TCD2_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA_BASE_PTR,2)
#define DMA_TCD3_SADDR                           DMA_SADDR_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_SOFF                            DMA_SOFF_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_ATTR                            DMA_ATTR_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_SLAST                           DMA_SLAST_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_DADDR                           DMA_DADDR_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_DOFF                            DMA_DOFF_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_DLASTSGA                        DMA_DLAST_SGA_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_CSR                             DMA_CSR_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA_BASE_PTR,3)
#define DMA_TCD3_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA_BASE_PTR,3)

/* DMA - Register array accessors */
#define DMA_SADDR(index)                         DMA_SADDR_REG(DMA_BASE_PTR,index)
#define DMA_SOFF(index)                          DMA_SOFF_REG(DMA_BASE_PTR,index)
#define DMA_ATTR(index)                          DMA_ATTR_REG(DMA_BASE_PTR,index)
#define DMA_NBYTES_MLNO(index)                   DMA_NBYTES_MLNO_REG(DMA_BASE_PTR,index)
#define DMA_NBYTES_MLOFFNO(index)                DMA_NBYTES_MLOFFNO_REG(DMA_BASE_PTR,index)
#define DMA_NBYTES_MLOFFYES(index)               DMA_NBYTES_MLOFFYES_REG(DMA_BASE_PTR,index)
#define DMA_SLAST(index)                         DMA_SLAST_REG(DMA_BASE_PTR,index)
#define DMA_DADDR(index)                         DMA_DADDR_REG(DMA_BASE_PTR,index)
#define DMA_DOFF(index)                          DMA_DOFF_REG(DMA_BASE_PTR,index)
#define DMA_CITER_ELINKNO(index)                 DMA_CITER_ELINKNO_REG(DMA_BASE_PTR,index)
#define DMA_CITER_ELINKYES(index)                DMA_CITER_ELINKYES_REG(DMA_BASE_PTR,index)
#define DMA_DLAST_SGA(index)                     DMA_DLAST_SGA_REG(DMA_BASE_PTR,index)
#define DMA_CSR(index)                           DMA_CSR_REG(DMA_BASE_PTR,index)
#define DMA_BITER_ELINKNO(index)                 DMA_BITER_ELINKNO_REG(DMA_BASE_PTR,index)
#define DMA_BITER_ELINKYES(index)                DMA_BITER_ELINKYES_REG(DMA_BASE_PTR,index)

/*!
 * @}
 */ /* end of group DMA_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DMA_Peripheral */


/* ----------------------------------------------------------------------------
   -- DMAMUX
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Peripheral DMAMUX
 * @{
 */

/** DMAMUX - Peripheral register structure */
typedef struct DMAMUX_MemMap {
  uint8_t CHCFG[4];                                /**< Channel Configuration register, array offset: 0x0, array step: 0x1 */
} volatile *DMAMUX_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DMAMUX - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Register_Accessor_Macros DMAMUX - Register accessor macros
 * @{
 */


/* DMAMUX - Register accessors */
#define DMAMUX_CHCFG_REG(base,index)             ((base)->CHCFG[index])

/*!
 * @}
 */ /* end of group DMAMUX_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DMAMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Register_Masks DMAMUX Register Masks
 * @{
 */

/*! @name CHCFG - Channel Configuration register */
#define DMAMUX_CHCFG_SOURCE_MASK                 (0x3FU)
#define DMAMUX_CHCFG_SOURCE_SHIFT                (0U)
#define DMAMUX_CHCFG_SOURCE(x)                   (((uint8_t)(((uint8_t)(x)) << DMAMUX_CHCFG_SOURCE_SHIFT)) & DMAMUX_CHCFG_SOURCE_MASK)
#define DMAMUX_CHCFG_TRIG_MASK                   (0x40U)
#define DMAMUX_CHCFG_TRIG_SHIFT                  (6U)
#define DMAMUX_CHCFG_ENBL_MASK                   (0x80U)
#define DMAMUX_CHCFG_ENBL_SHIFT                  (7U)

/* The count of DMAMUX_CHCFG */
#define DMAMUX_CHCFG_COUNT                       (4U)


/*!
 * @}
 */ /* end of group DMAMUX_Register_Masks */


/* DMAMUX - Peripheral instance base addresses */
/** Peripheral DMAMUX0 base pointer */
#define DMAMUX0_BASE_PTR                         ((DMAMUX_MemMapPtr)0x40021000u)
/** Array initializer of DMAMUX peripheral base pointers */
#define DMAMUX_BASE_PTRS                         { DMAMUX0_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- DMAMUX - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Register_Accessor_Macros DMAMUX - Register accessor macros
 * @{
 */


/* DMAMUX - Register instance definitions */
/* DMAMUX0 */
#define DMAMUX0_CHCFG0                           DMAMUX_CHCFG_REG(DMAMUX0_BASE_PTR,0)
#define DMAMUX0_CHCFG1                           DMAMUX_CHCFG_REG(DMAMUX0_BASE_PTR,1)
#define DMAMUX0_CHCFG2                           DMAMUX_CHCFG_REG(DMAMUX0_BASE_PTR,2)
#define DMAMUX0_CHCFG3                           DMAMUX_CHCFG_REG(DMAMUX0_BASE_PTR,3)

/* DMAMUX - Register array accessors */
#define DMAMUX0_CHCFG(index)                     DMAMUX_CHCFG_REG(DMAMUX0_BASE_PTR,index)

/*!
 * @}
 */ /* end of group DMAMUX_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DMAMUX_Peripheral */


/* ----------------------------------------------------------------------------
   -- DWT
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DWT_Peripheral DWT
 * @{
 */

/** DWT - Peripheral register structure */
typedef struct DWT_MemMap {
  uint32_t CTRL;                                   /**< Control Register, offset: 0x0 */
  uint8_t RESERVED_0[24];
  uint32_t PCSR;                                   /**< Program Counter Sample Register, offset: 0x1C */
  struct {                                         /* offset: 0x20, array step: 0x10 */
    uint32_t COMP;                                   /**< Comparator Register 0..Comparator Register 1, array offset: 0x20, array step: 0x10 */
    uint32_t MASK;                                   /**< Mask Register 0..Mask Register 1, array offset: 0x24, array step: 0x10 */
    uint32_t FUNCTION;                               /**< Function Register 0..Function Register 1, array offset: 0x28, array step: 0x10 */
    uint8_t RESERVED_0[4];
  } COMPARATOR[2];
} volatile *DWT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DWT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DWT_Register_Accessor_Macros DWT - Register accessor macros
 * @{
 */


/* DWT - Register accessors */
#define DWT_CTRL_REG(base)                       ((base)->CTRL)
#define DWT_PCSR_REG(base)                       ((base)->PCSR)
#define DWT_COMP_REG(base,index)                 ((base)->COMPARATOR[index].COMP)
#define DWT_MASK_REG(base,index)                 ((base)->COMPARATOR[index].MASK)
#define DWT_FUNCTION_REG(base,index)             ((base)->COMPARATOR[index].FUNCTION)

/*!
 * @}
 */ /* end of group DWT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DWT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DWT_Register_Masks DWT Register Masks
 * @{
 */

/* The count of DWT_COMP */
#define DWT_COMP_COUNT                           (2U)

/* The count of DWT_MASK */
#define DWT_MASK_COUNT                           (2U)

/* The count of DWT_FUNCTION */
#define DWT_FUNCTION_COUNT                       (2U)


/*!
 * @}
 */ /* end of group DWT_Register_Masks */


/* DWT - Peripheral instance base addresses */
/** Peripheral DWT base pointer */
#define DWT_BASE_PTR                             ((DWT_MemMapPtr)0xE0001000u)
/** Array initializer of DWT peripheral base pointers */
#define DWT_BASE_PTRS                            { DWT_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- DWT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DWT_Register_Accessor_Macros DWT - Register accessor macros
 * @{
 */


/* DWT - Register instance definitions */
/* DWT */
#define DWT_CTRL                                 DWT_CTRL_REG(DWT_BASE_PTR)
#define DWT_PCSR                                 DWT_PCSR_REG(DWT_BASE_PTR)
#define DWT_COMP0                                DWT_COMP_REG(DWT_BASE_PTR,0)
#define DWT_MASK0                                DWT_MASK_REG(DWT_BASE_PTR,0)
#define DWT_FUNCTION0                            DWT_FUNCTION_REG(DWT_BASE_PTR,0)
#define DWT_COMP1                                DWT_COMP_REG(DWT_BASE_PTR,1)
#define DWT_MASK1                                DWT_MASK_REG(DWT_BASE_PTR,1)
#define DWT_FUNCTION1                            DWT_FUNCTION_REG(DWT_BASE_PTR,1)

/* DWT - Register array accessors */
#define DWT_COMP(index)                          DWT_COMP_REG(DWT_BASE_PTR,index)
#define DWT_MASK(index)                          DWT_MASK_REG(DWT_BASE_PTR,index)
#define DWT_FUNCTION(index)                      DWT_FUNCTION_REG(DWT_BASE_PTR,index)

/*!
 * @}
 */ /* end of group DWT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DWT_Peripheral */


/* ----------------------------------------------------------------------------
   -- FGPIO
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FGPIO_Peripheral FGPIO
 * @{
 */

/** FGPIO - Peripheral register structure */
typedef struct FGPIO_MemMap {
  uint32_t PDOR;                                   /**< Port Data Output Register, offset: 0x0 */
  uint32_t PSOR;                                   /**< Port Set Output Register, offset: 0x4 */
  uint32_t PCOR;                                   /**< Port Clear Output Register, offset: 0x8 */
  uint32_t PTOR;                                   /**< Port Toggle Output Register, offset: 0xC */
  uint32_t PDIR;                                   /**< Port Data Input Register, offset: 0x10 */
  uint32_t PDDR;                                   /**< Port Data Direction Register, offset: 0x14 */
} volatile *FGPIO_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- FGPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FGPIO_Register_Accessor_Macros FGPIO - Register accessor macros
 * @{
 */


/* FGPIO - Register accessors */
#define FGPIO_PDOR_REG(base)                     ((base)->PDOR)
#define FGPIO_PSOR_REG(base)                     ((base)->PSOR)
#define FGPIO_PCOR_REG(base)                     ((base)->PCOR)
#define FGPIO_PTOR_REG(base)                     ((base)->PTOR)
#define FGPIO_PDIR_REG(base)                     ((base)->PDIR)
#define FGPIO_PDDR_REG(base)                     ((base)->PDDR)

/*!
 * @}
 */ /* end of group FGPIO_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- FGPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FGPIO_Register_Masks FGPIO Register Masks
 * @{
 */

/*! @name PDOR - Port Data Output Register */
#define FGPIO_PDOR_PDO_MASK                      (0xFFFFFFFFU)
#define FGPIO_PDOR_PDO_SHIFT                     (0U)
#define FGPIO_PDOR_PDO(x)                        (((uint32_t)(((uint32_t)(x)) << FGPIO_PDOR_PDO_SHIFT)) & FGPIO_PDOR_PDO_MASK)

/*! @name PSOR - Port Set Output Register */
#define FGPIO_PSOR_PTSO_MASK                     (0xFFFFFFFFU)
#define FGPIO_PSOR_PTSO_SHIFT                    (0U)
#define FGPIO_PSOR_PTSO(x)                       (((uint32_t)(((uint32_t)(x)) << FGPIO_PSOR_PTSO_SHIFT)) & FGPIO_PSOR_PTSO_MASK)

/*! @name PCOR - Port Clear Output Register */
#define FGPIO_PCOR_PTCO_MASK                     (0xFFFFFFFFU)
#define FGPIO_PCOR_PTCO_SHIFT                    (0U)
#define FGPIO_PCOR_PTCO(x)                       (((uint32_t)(((uint32_t)(x)) << FGPIO_PCOR_PTCO_SHIFT)) & FGPIO_PCOR_PTCO_MASK)

/*! @name PTOR - Port Toggle Output Register */
#define FGPIO_PTOR_PTTO_MASK                     (0xFFFFFFFFU)
#define FGPIO_PTOR_PTTO_SHIFT                    (0U)
#define FGPIO_PTOR_PTTO(x)                       (((uint32_t)(((uint32_t)(x)) << FGPIO_PTOR_PTTO_SHIFT)) & FGPIO_PTOR_PTTO_MASK)

/*! @name PDIR - Port Data Input Register */
#define FGPIO_PDIR_PDI_MASK                      (0xFFFFFFFFU)
#define FGPIO_PDIR_PDI_SHIFT                     (0U)
#define FGPIO_PDIR_PDI(x)                        (((uint32_t)(((uint32_t)(x)) << FGPIO_PDIR_PDI_SHIFT)) & FGPIO_PDIR_PDI_MASK)

/*! @name PDDR - Port Data Direction Register */
#define FGPIO_PDDR_PDD_MASK                      (0xFFFFFFFFU)
#define FGPIO_PDDR_PDD_SHIFT                     (0U)
#define FGPIO_PDDR_PDD(x)                        (((uint32_t)(((uint32_t)(x)) << FGPIO_PDDR_PDD_SHIFT)) & FGPIO_PDDR_PDD_MASK)


/*!
 * @}
 */ /* end of group FGPIO_Register_Masks */


/* FGPIO - Peripheral instance base addresses */
/** Peripheral FGPIOA base pointer */
#define FGPIOA_BASE_PTR                          ((FGPIO_MemMapPtr)0xF8000000u)
/** Peripheral FGPIOB base pointer */
#define FGPIOB_BASE_PTR                          ((FGPIO_MemMapPtr)0xF8000040u)
/** Peripheral FGPIOC base pointer */
#define FGPIOC_BASE_PTR                          ((FGPIO_MemMapPtr)0xF8000080u)
/** Array initializer of FGPIO peripheral base pointers */
#define FGPIO_BASE_PTRS                          { FGPIOA_BASE_PTR, FGPIOB_BASE_PTR, FGPIOC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- FGPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FGPIO_Register_Accessor_Macros FGPIO - Register accessor macros
 * @{
 */


/* FGPIO - Register instance definitions */
/* FGPIOA */
#define FGPIOA_PDOR                              FGPIO_PDOR_REG(FGPIOA_BASE_PTR)
#define FGPIOA_PSOR                              FGPIO_PSOR_REG(FGPIOA_BASE_PTR)
#define FGPIOA_PCOR                              FGPIO_PCOR_REG(FGPIOA_BASE_PTR)
#define FGPIOA_PTOR                              FGPIO_PTOR_REG(FGPIOA_BASE_PTR)
#define FGPIOA_PDIR                              FGPIO_PDIR_REG(FGPIOA_BASE_PTR)
#define FGPIOA_PDDR                              FGPIO_PDDR_REG(FGPIOA_BASE_PTR)
/* FGPIOB */
#define FGPIOB_PDOR                              FGPIO_PDOR_REG(FGPIOB_BASE_PTR)
#define FGPIOB_PSOR                              FGPIO_PSOR_REG(FGPIOB_BASE_PTR)
#define FGPIOB_PCOR                              FGPIO_PCOR_REG(FGPIOB_BASE_PTR)
#define FGPIOB_PTOR                              FGPIO_PTOR_REG(FGPIOB_BASE_PTR)
#define FGPIOB_PDIR                              FGPIO_PDIR_REG(FGPIOB_BASE_PTR)
#define FGPIOB_PDDR                              FGPIO_PDDR_REG(FGPIOB_BASE_PTR)
/* FGPIOC */
#define FGPIOC_PDOR                              FGPIO_PDOR_REG(FGPIOC_BASE_PTR)
#define FGPIOC_PSOR                              FGPIO_PSOR_REG(FGPIOC_BASE_PTR)
#define FGPIOC_PCOR                              FGPIO_PCOR_REG(FGPIOC_BASE_PTR)
#define FGPIOC_PTOR                              FGPIO_PTOR_REG(FGPIOC_BASE_PTR)
#define FGPIOC_PDIR                              FGPIO_PDIR_REG(FGPIOC_BASE_PTR)
#define FGPIOC_PDDR                              FGPIO_PDDR_REG(FGPIOC_BASE_PTR)

/*!
 * @}
 */ /* end of group FGPIO_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group FGPIO_Peripheral */


/* ----------------------------------------------------------------------------
   -- FTFA
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFA_Peripheral FTFA
 * @{
 */

/** FTFA - Peripheral register structure */
typedef struct FTFA_MemMap {
  uint8_t FSTAT;                                   /**< Flash Status Register, offset: 0x0 */
  uint8_t FCNFG;                                   /**< Flash Configuration Register, offset: 0x1 */
  uint8_t FSEC;                                    /**< Flash Security Register, offset: 0x2 */
  uint8_t FOPT;                                    /**< Flash Option Register, offset: 0x3 */
  uint8_t FCCOB3;                                  /**< Flash Common Command Object Registers, offset: 0x4 */
  uint8_t FCCOB2;                                  /**< Flash Common Command Object Registers, offset: 0x5 */
  uint8_t FCCOB1;                                  /**< Flash Common Command Object Registers, offset: 0x6 */
  uint8_t FCCOB0;                                  /**< Flash Common Command Object Registers, offset: 0x7 */
  uint8_t FCCOB7;                                  /**< Flash Common Command Object Registers, offset: 0x8 */
  uint8_t FCCOB6;                                  /**< Flash Common Command Object Registers, offset: 0x9 */
  uint8_t FCCOB5;                                  /**< Flash Common Command Object Registers, offset: 0xA */
  uint8_t FCCOB4;                                  /**< Flash Common Command Object Registers, offset: 0xB */
  uint8_t FCCOBB;                                  /**< Flash Common Command Object Registers, offset: 0xC */
  uint8_t FCCOBA;                                  /**< Flash Common Command Object Registers, offset: 0xD */
  uint8_t FCCOB9;                                  /**< Flash Common Command Object Registers, offset: 0xE */
  uint8_t FCCOB8;                                  /**< Flash Common Command Object Registers, offset: 0xF */
  uint8_t FPROT3;                                  /**< Program Flash Protection Registers, offset: 0x10 */
  uint8_t FPROT2;                                  /**< Program Flash Protection Registers, offset: 0x11 */
  uint8_t FPROT1;                                  /**< Program Flash Protection Registers, offset: 0x12 */
  uint8_t FPROT0;                                  /**< Program Flash Protection Registers, offset: 0x13 */
  uint8_t RESERVED_0[4];
  uint8_t XACCH3;                                  /**< Execute-only Access Registers, offset: 0x18 */
  uint8_t XACCH2;                                  /**< Execute-only Access Registers, offset: 0x19 */
  uint8_t XACCH1;                                  /**< Execute-only Access Registers, offset: 0x1A */
  uint8_t XACCH0;                                  /**< Execute-only Access Registers, offset: 0x1B */
  uint8_t XACCL3;                                  /**< Execute-only Access Registers, offset: 0x1C */
  uint8_t XACCL2;                                  /**< Execute-only Access Registers, offset: 0x1D */
  uint8_t XACCL1;                                  /**< Execute-only Access Registers, offset: 0x1E */
  uint8_t XACCL0;                                  /**< Execute-only Access Registers, offset: 0x1F */
  uint8_t SACCH3;                                  /**< Supervisor-only Access Registers, offset: 0x20 */
  uint8_t SACCH2;                                  /**< Supervisor-only Access Registers, offset: 0x21 */
  uint8_t SACCH1;                                  /**< Supervisor-only Access Registers, offset: 0x22 */
  uint8_t SACCH0;                                  /**< Supervisor-only Access Registers, offset: 0x23 */
  uint8_t SACCL3;                                  /**< Supervisor-only Access Registers, offset: 0x24 */
  uint8_t SACCL2;                                  /**< Supervisor-only Access Registers, offset: 0x25 */
  uint8_t SACCL1;                                  /**< Supervisor-only Access Registers, offset: 0x26 */
  uint8_t SACCL0;                                  /**< Supervisor-only Access Registers, offset: 0x27 */
  uint8_t FACSS;                                   /**< Flash Access Segment Size Register, offset: 0x28 */
  uint8_t RESERVED_1[2];
  uint8_t FACSN;                                   /**< Flash Access Segment Number Register, offset: 0x2B */
} volatile *FTFA_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- FTFA - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFA_Register_Accessor_Macros FTFA - Register accessor macros
 * @{
 */


/* FTFA - Register accessors */
#define FTFA_FSTAT_REG(base)                     ((base)->FSTAT)
#define FTFA_FCNFG_REG(base)                     ((base)->FCNFG)
#define FTFA_FSEC_REG(base)                      ((base)->FSEC)
#define FTFA_FOPT_REG(base)                      ((base)->FOPT)
#define FTFA_FCCOB3_REG(base)                    ((base)->FCCOB3)
#define FTFA_FCCOB2_REG(base)                    ((base)->FCCOB2)
#define FTFA_FCCOB1_REG(base)                    ((base)->FCCOB1)
#define FTFA_FCCOB0_REG(base)                    ((base)->FCCOB0)
#define FTFA_FCCOB7_REG(base)                    ((base)->FCCOB7)
#define FTFA_FCCOB6_REG(base)                    ((base)->FCCOB6)
#define FTFA_FCCOB5_REG(base)                    ((base)->FCCOB5)
#define FTFA_FCCOB4_REG(base)                    ((base)->FCCOB4)
#define FTFA_FCCOBB_REG(base)                    ((base)->FCCOBB)
#define FTFA_FCCOBA_REG(base)                    ((base)->FCCOBA)
#define FTFA_FCCOB9_REG(base)                    ((base)->FCCOB9)
#define FTFA_FCCOB8_REG(base)                    ((base)->FCCOB8)
#define FTFA_FPROT3_REG(base)                    ((base)->FPROT3)
#define FTFA_FPROT2_REG(base)                    ((base)->FPROT2)
#define FTFA_FPROT1_REG(base)                    ((base)->FPROT1)
#define FTFA_FPROT0_REG(base)                    ((base)->FPROT0)
#define FTFA_XACCH3_REG(base)                    ((base)->XACCH3)
#define FTFA_XACCH2_REG(base)                    ((base)->XACCH2)
#define FTFA_XACCH1_REG(base)                    ((base)->XACCH1)
#define FTFA_XACCH0_REG(base)                    ((base)->XACCH0)
#define FTFA_XACCL3_REG(base)                    ((base)->XACCL3)
#define FTFA_XACCL2_REG(base)                    ((base)->XACCL2)
#define FTFA_XACCL1_REG(base)                    ((base)->XACCL1)
#define FTFA_XACCL0_REG(base)                    ((base)->XACCL0)
#define FTFA_SACCH3_REG(base)                    ((base)->SACCH3)
#define FTFA_SACCH2_REG(base)                    ((base)->SACCH2)
#define FTFA_SACCH1_REG(base)                    ((base)->SACCH1)
#define FTFA_SACCH0_REG(base)                    ((base)->SACCH0)
#define FTFA_SACCL3_REG(base)                    ((base)->SACCL3)
#define FTFA_SACCL2_REG(base)                    ((base)->SACCL2)
#define FTFA_SACCL1_REG(base)                    ((base)->SACCL1)
#define FTFA_SACCL0_REG(base)                    ((base)->SACCL0)
#define FTFA_FACSS_REG(base)                     ((base)->FACSS)
#define FTFA_FACSN_REG(base)                     ((base)->FACSN)

/*!
 * @}
 */ /* end of group FTFA_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- FTFA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFA_Register_Masks FTFA Register Masks
 * @{
 */

/*! @name FSTAT - Flash Status Register */
#define FTFA_FSTAT_MGSTAT0_MASK                  (0x1U)
#define FTFA_FSTAT_MGSTAT0_SHIFT                 (0U)
#define FTFA_FSTAT_FPVIOL_MASK                   (0x10U)
#define FTFA_FSTAT_FPVIOL_SHIFT                  (4U)
#define FTFA_FSTAT_ACCERR_MASK                   (0x20U)
#define FTFA_FSTAT_ACCERR_SHIFT                  (5U)
#define FTFA_FSTAT_RDCOLERR_MASK                 (0x40U)
#define FTFA_FSTAT_RDCOLERR_SHIFT                (6U)
#define FTFA_FSTAT_CCIF_MASK                     (0x80U)
#define FTFA_FSTAT_CCIF_SHIFT                    (7U)

/*! @name FCNFG - Flash Configuration Register */
#define FTFA_FCNFG_ERSSUSP_MASK                  (0x10U)
#define FTFA_FCNFG_ERSSUSP_SHIFT                 (4U)
#define FTFA_FCNFG_ERSAREQ_MASK                  (0x20U)
#define FTFA_FCNFG_ERSAREQ_SHIFT                 (5U)
#define FTFA_FCNFG_RDCOLLIE_MASK                 (0x40U)
#define FTFA_FCNFG_RDCOLLIE_SHIFT                (6U)
#define FTFA_FCNFG_CCIE_MASK                     (0x80U)
#define FTFA_FCNFG_CCIE_SHIFT                    (7U)

/*! @name FSEC - Flash Security Register */
#define FTFA_FSEC_SEC_MASK                       (0x3U)
#define FTFA_FSEC_SEC_SHIFT                      (0U)
#define FTFA_FSEC_SEC(x)                         (((uint8_t)(((uint8_t)(x)) << FTFA_FSEC_SEC_SHIFT)) & FTFA_FSEC_SEC_MASK)
#define FTFA_FSEC_FSLACC_MASK                    (0xCU)
#define FTFA_FSEC_FSLACC_SHIFT                   (2U)
#define FTFA_FSEC_FSLACC(x)                      (((uint8_t)(((uint8_t)(x)) << FTFA_FSEC_FSLACC_SHIFT)) & FTFA_FSEC_FSLACC_MASK)
#define FTFA_FSEC_MEEN_MASK                      (0x30U)
#define FTFA_FSEC_MEEN_SHIFT                     (4U)
#define FTFA_FSEC_MEEN(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_FSEC_MEEN_SHIFT)) & FTFA_FSEC_MEEN_MASK)
#define FTFA_FSEC_KEYEN_MASK                     (0xC0U)
#define FTFA_FSEC_KEYEN_SHIFT                    (6U)
#define FTFA_FSEC_KEYEN(x)                       (((uint8_t)(((uint8_t)(x)) << FTFA_FSEC_KEYEN_SHIFT)) & FTFA_FSEC_KEYEN_MASK)

/*! @name FOPT - Flash Option Register */
#define FTFA_FOPT_OPT_MASK                       (0xFFU)
#define FTFA_FOPT_OPT_SHIFT                      (0U)
#define FTFA_FOPT_OPT(x)                         (((uint8_t)(((uint8_t)(x)) << FTFA_FOPT_OPT_SHIFT)) & FTFA_FOPT_OPT_MASK)

/*! @name FCCOB3 - Flash Common Command Object Registers */
#define FTFA_FCCOB3_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOB3_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOB3_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOB3_CCOBn_SHIFT)) & FTFA_FCCOB3_CCOBn_MASK)

/*! @name FCCOB2 - Flash Common Command Object Registers */
#define FTFA_FCCOB2_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOB2_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOB2_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOB2_CCOBn_SHIFT)) & FTFA_FCCOB2_CCOBn_MASK)

/*! @name FCCOB1 - Flash Common Command Object Registers */
#define FTFA_FCCOB1_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOB1_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOB1_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOB1_CCOBn_SHIFT)) & FTFA_FCCOB1_CCOBn_MASK)

/*! @name FCCOB0 - Flash Common Command Object Registers */
#define FTFA_FCCOB0_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOB0_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOB0_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOB0_CCOBn_SHIFT)) & FTFA_FCCOB0_CCOBn_MASK)

/*! @name FCCOB7 - Flash Common Command Object Registers */
#define FTFA_FCCOB7_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOB7_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOB7_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOB7_CCOBn_SHIFT)) & FTFA_FCCOB7_CCOBn_MASK)

/*! @name FCCOB6 - Flash Common Command Object Registers */
#define FTFA_FCCOB6_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOB6_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOB6_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOB6_CCOBn_SHIFT)) & FTFA_FCCOB6_CCOBn_MASK)

/*! @name FCCOB5 - Flash Common Command Object Registers */
#define FTFA_FCCOB5_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOB5_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOB5_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOB5_CCOBn_SHIFT)) & FTFA_FCCOB5_CCOBn_MASK)

/*! @name FCCOB4 - Flash Common Command Object Registers */
#define FTFA_FCCOB4_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOB4_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOB4_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOB4_CCOBn_SHIFT)) & FTFA_FCCOB4_CCOBn_MASK)

/*! @name FCCOBB - Flash Common Command Object Registers */
#define FTFA_FCCOBB_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOBB_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOBB_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOBB_CCOBn_SHIFT)) & FTFA_FCCOBB_CCOBn_MASK)

/*! @name FCCOBA - Flash Common Command Object Registers */
#define FTFA_FCCOBA_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOBA_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOBA_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOBA_CCOBn_SHIFT)) & FTFA_FCCOBA_CCOBn_MASK)

/*! @name FCCOB9 - Flash Common Command Object Registers */
#define FTFA_FCCOB9_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOB9_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOB9_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOB9_CCOBn_SHIFT)) & FTFA_FCCOB9_CCOBn_MASK)

/*! @name FCCOB8 - Flash Common Command Object Registers */
#define FTFA_FCCOB8_CCOBn_MASK                   (0xFFU)
#define FTFA_FCCOB8_CCOBn_SHIFT                  (0U)
#define FTFA_FCCOB8_CCOBn(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FCCOB8_CCOBn_SHIFT)) & FTFA_FCCOB8_CCOBn_MASK)

/*! @name FPROT3 - Program Flash Protection Registers */
#define FTFA_FPROT3_PROT_MASK                    (0xFFU)
#define FTFA_FPROT3_PROT_SHIFT                   (0U)
#define FTFA_FPROT3_PROT(x)                      (((uint8_t)(((uint8_t)(x)) << FTFA_FPROT3_PROT_SHIFT)) & FTFA_FPROT3_PROT_MASK)

/*! @name FPROT2 - Program Flash Protection Registers */
#define FTFA_FPROT2_PROT_MASK                    (0xFFU)
#define FTFA_FPROT2_PROT_SHIFT                   (0U)
#define FTFA_FPROT2_PROT(x)                      (((uint8_t)(((uint8_t)(x)) << FTFA_FPROT2_PROT_SHIFT)) & FTFA_FPROT2_PROT_MASK)

/*! @name FPROT1 - Program Flash Protection Registers */
#define FTFA_FPROT1_PROT_MASK                    (0xFFU)
#define FTFA_FPROT1_PROT_SHIFT                   (0U)
#define FTFA_FPROT1_PROT(x)                      (((uint8_t)(((uint8_t)(x)) << FTFA_FPROT1_PROT_SHIFT)) & FTFA_FPROT1_PROT_MASK)

/*! @name FPROT0 - Program Flash Protection Registers */
#define FTFA_FPROT0_PROT_MASK                    (0xFFU)
#define FTFA_FPROT0_PROT_SHIFT                   (0U)
#define FTFA_FPROT0_PROT(x)                      (((uint8_t)(((uint8_t)(x)) << FTFA_FPROT0_PROT_SHIFT)) & FTFA_FPROT0_PROT_MASK)

/*! @name XACCH3 - Execute-only Access Registers */
#define FTFA_XACCH3_XA_MASK                      (0xFFU)
#define FTFA_XACCH3_XA_SHIFT                     (0U)
#define FTFA_XACCH3_XA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_XACCH3_XA_SHIFT)) & FTFA_XACCH3_XA_MASK)

/*! @name XACCH2 - Execute-only Access Registers */
#define FTFA_XACCH2_XA_MASK                      (0xFFU)
#define FTFA_XACCH2_XA_SHIFT                     (0U)
#define FTFA_XACCH2_XA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_XACCH2_XA_SHIFT)) & FTFA_XACCH2_XA_MASK)

/*! @name XACCH1 - Execute-only Access Registers */
#define FTFA_XACCH1_XA_MASK                      (0xFFU)
#define FTFA_XACCH1_XA_SHIFT                     (0U)
#define FTFA_XACCH1_XA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_XACCH1_XA_SHIFT)) & FTFA_XACCH1_XA_MASK)

/*! @name XACCH0 - Execute-only Access Registers */
#define FTFA_XACCH0_XA_MASK                      (0xFFU)
#define FTFA_XACCH0_XA_SHIFT                     (0U)
#define FTFA_XACCH0_XA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_XACCH0_XA_SHIFT)) & FTFA_XACCH0_XA_MASK)

/*! @name XACCL3 - Execute-only Access Registers */
#define FTFA_XACCL3_XA_MASK                      (0xFFU)
#define FTFA_XACCL3_XA_SHIFT                     (0U)
#define FTFA_XACCL3_XA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_XACCL3_XA_SHIFT)) & FTFA_XACCL3_XA_MASK)

/*! @name XACCL2 - Execute-only Access Registers */
#define FTFA_XACCL2_XA_MASK                      (0xFFU)
#define FTFA_XACCL2_XA_SHIFT                     (0U)
#define FTFA_XACCL2_XA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_XACCL2_XA_SHIFT)) & FTFA_XACCL2_XA_MASK)

/*! @name XACCL1 - Execute-only Access Registers */
#define FTFA_XACCL1_XA_MASK                      (0xFFU)
#define FTFA_XACCL1_XA_SHIFT                     (0U)
#define FTFA_XACCL1_XA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_XACCL1_XA_SHIFT)) & FTFA_XACCL1_XA_MASK)

/*! @name XACCL0 - Execute-only Access Registers */
#define FTFA_XACCL0_XA_MASK                      (0xFFU)
#define FTFA_XACCL0_XA_SHIFT                     (0U)
#define FTFA_XACCL0_XA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_XACCL0_XA_SHIFT)) & FTFA_XACCL0_XA_MASK)

/*! @name SACCH3 - Supervisor-only Access Registers */
#define FTFA_SACCH3_SA_MASK                      (0xFFU)
#define FTFA_SACCH3_SA_SHIFT                     (0U)
#define FTFA_SACCH3_SA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_SACCH3_SA_SHIFT)) & FTFA_SACCH3_SA_MASK)

/*! @name SACCH2 - Supervisor-only Access Registers */
#define FTFA_SACCH2_SA_MASK                      (0xFFU)
#define FTFA_SACCH2_SA_SHIFT                     (0U)
#define FTFA_SACCH2_SA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_SACCH2_SA_SHIFT)) & FTFA_SACCH2_SA_MASK)

/*! @name SACCH1 - Supervisor-only Access Registers */
#define FTFA_SACCH1_SA_MASK                      (0xFFU)
#define FTFA_SACCH1_SA_SHIFT                     (0U)
#define FTFA_SACCH1_SA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_SACCH1_SA_SHIFT)) & FTFA_SACCH1_SA_MASK)

/*! @name SACCH0 - Supervisor-only Access Registers */
#define FTFA_SACCH0_SA_MASK                      (0xFFU)
#define FTFA_SACCH0_SA_SHIFT                     (0U)
#define FTFA_SACCH0_SA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_SACCH0_SA_SHIFT)) & FTFA_SACCH0_SA_MASK)

/*! @name SACCL3 - Supervisor-only Access Registers */
#define FTFA_SACCL3_SA_MASK                      (0xFFU)
#define FTFA_SACCL3_SA_SHIFT                     (0U)
#define FTFA_SACCL3_SA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_SACCL3_SA_SHIFT)) & FTFA_SACCL3_SA_MASK)

/*! @name SACCL2 - Supervisor-only Access Registers */
#define FTFA_SACCL2_SA_MASK                      (0xFFU)
#define FTFA_SACCL2_SA_SHIFT                     (0U)
#define FTFA_SACCL2_SA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_SACCL2_SA_SHIFT)) & FTFA_SACCL2_SA_MASK)

/*! @name SACCL1 - Supervisor-only Access Registers */
#define FTFA_SACCL1_SA_MASK                      (0xFFU)
#define FTFA_SACCL1_SA_SHIFT                     (0U)
#define FTFA_SACCL1_SA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_SACCL1_SA_SHIFT)) & FTFA_SACCL1_SA_MASK)

/*! @name SACCL0 - Supervisor-only Access Registers */
#define FTFA_SACCL0_SA_MASK                      (0xFFU)
#define FTFA_SACCL0_SA_SHIFT                     (0U)
#define FTFA_SACCL0_SA(x)                        (((uint8_t)(((uint8_t)(x)) << FTFA_SACCL0_SA_SHIFT)) & FTFA_SACCL0_SA_MASK)

/*! @name FACSS - Flash Access Segment Size Register */
#define FTFA_FACSS_SGSIZE_MASK                   (0xFFU)
#define FTFA_FACSS_SGSIZE_SHIFT                  (0U)
#define FTFA_FACSS_SGSIZE(x)                     (((uint8_t)(((uint8_t)(x)) << FTFA_FACSS_SGSIZE_SHIFT)) & FTFA_FACSS_SGSIZE_MASK)

/*! @name FACSN - Flash Access Segment Number Register */
#define FTFA_FACSN_NUMSG_MASK                    (0xFFU)
#define FTFA_FACSN_NUMSG_SHIFT                   (0U)
#define FTFA_FACSN_NUMSG(x)                      (((uint8_t)(((uint8_t)(x)) << FTFA_FACSN_NUMSG_SHIFT)) & FTFA_FACSN_NUMSG_MASK)


/*!
 * @}
 */ /* end of group FTFA_Register_Masks */


/* FTFA - Peripheral instance base addresses */
/** Peripheral FTFA base pointer */
#define FTFA_BASE_PTR                            ((FTFA_MemMapPtr)0x40020000u)
/** Array initializer of FTFA peripheral base pointers */
#define FTFA_BASE_PTRS                           { FTFA_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- FTFA - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFA_Register_Accessor_Macros FTFA - Register accessor macros
 * @{
 */


/* FTFA - Register instance definitions */
/* FTFA */
#define FTFA_FSTAT                               FTFA_FSTAT_REG(FTFA_BASE_PTR)
#define FTFA_FCNFG                               FTFA_FCNFG_REG(FTFA_BASE_PTR)
#define FTFA_FSEC                                FTFA_FSEC_REG(FTFA_BASE_PTR)
#define FTFA_FOPT                                FTFA_FOPT_REG(FTFA_BASE_PTR)
#define FTFA_FCCOB3                              FTFA_FCCOB3_REG(FTFA_BASE_PTR)
#define FTFA_FCCOB2                              FTFA_FCCOB2_REG(FTFA_BASE_PTR)
#define FTFA_FCCOB1                              FTFA_FCCOB1_REG(FTFA_BASE_PTR)
#define FTFA_FCCOB0                              FTFA_FCCOB0_REG(FTFA_BASE_PTR)
#define FTFA_FCCOB7                              FTFA_FCCOB7_REG(FTFA_BASE_PTR)
#define FTFA_FCCOB6                              FTFA_FCCOB6_REG(FTFA_BASE_PTR)
#define FTFA_FCCOB5                              FTFA_FCCOB5_REG(FTFA_BASE_PTR)
#define FTFA_FCCOB4                              FTFA_FCCOB4_REG(FTFA_BASE_PTR)
#define FTFA_FCCOBB                              FTFA_FCCOBB_REG(FTFA_BASE_PTR)
#define FTFA_FCCOBA                              FTFA_FCCOBA_REG(FTFA_BASE_PTR)
#define FTFA_FCCOB9                              FTFA_FCCOB9_REG(FTFA_BASE_PTR)
#define FTFA_FCCOB8                              FTFA_FCCOB8_REG(FTFA_BASE_PTR)
#define FTFA_FPROT3                              FTFA_FPROT3_REG(FTFA_BASE_PTR)
#define FTFA_FPROT2                              FTFA_FPROT2_REG(FTFA_BASE_PTR)
#define FTFA_FPROT1                              FTFA_FPROT1_REG(FTFA_BASE_PTR)
#define FTFA_FPROT0                              FTFA_FPROT0_REG(FTFA_BASE_PTR)
#define FTFA_XACCH3                              FTFA_XACCH3_REG(FTFA_BASE_PTR)
#define FTFA_XACCH2                              FTFA_XACCH2_REG(FTFA_BASE_PTR)
#define FTFA_XACCH1                              FTFA_XACCH1_REG(FTFA_BASE_PTR)
#define FTFA_XACCH0                              FTFA_XACCH0_REG(FTFA_BASE_PTR)
#define FTFA_XACCL3                              FTFA_XACCL3_REG(FTFA_BASE_PTR)
#define FTFA_XACCL2                              FTFA_XACCL2_REG(FTFA_BASE_PTR)
#define FTFA_XACCL1                              FTFA_XACCL1_REG(FTFA_BASE_PTR)
#define FTFA_XACCL0                              FTFA_XACCL0_REG(FTFA_BASE_PTR)
#define FTFA_SACCH3                              FTFA_SACCH3_REG(FTFA_BASE_PTR)
#define FTFA_SACCH2                              FTFA_SACCH2_REG(FTFA_BASE_PTR)
#define FTFA_SACCH1                              FTFA_SACCH1_REG(FTFA_BASE_PTR)
#define FTFA_SACCH0                              FTFA_SACCH0_REG(FTFA_BASE_PTR)
#define FTFA_SACCL3                              FTFA_SACCL3_REG(FTFA_BASE_PTR)
#define FTFA_SACCL2                              FTFA_SACCL2_REG(FTFA_BASE_PTR)
#define FTFA_SACCL1                              FTFA_SACCL1_REG(FTFA_BASE_PTR)
#define FTFA_SACCL0                              FTFA_SACCL0_REG(FTFA_BASE_PTR)
#define FTFA_FACSS                               FTFA_FACSS_REG(FTFA_BASE_PTR)
#define FTFA_FACSN                               FTFA_FACSN_REG(FTFA_BASE_PTR)

/*!
 * @}
 */ /* end of group FTFA_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group FTFA_Peripheral */


/* ----------------------------------------------------------------------------
   -- GENFSK
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GENFSK_Peripheral GENFSK
 * @{
 */

/** GENFSK - Peripheral register structure */
typedef struct GENFSK_MemMap {
  uint32_t IRQ_CTRL;                               /**< IRQ CONTROL, offset: 0x0 */
  uint32_t EVENT_TMR;                              /**< EVENT TIMER, offset: 0x4 */
  uint32_t T1_CMP;                                 /**< T1 COMPARE, offset: 0x8 */
  uint32_t T2_CMP;                                 /**< T2 COMPARE, offset: 0xC */
  uint32_t TIMESTAMP;                              /**< TIMESTAMP, offset: 0x10 */
  uint32_t XCVR_CTRL;                              /**< TRANSCEIVER CONTROL, offset: 0x14 */
  uint32_t XCVR_STS;                               /**< TRANSCEIVER STATUS, offset: 0x18 */
  uint32_t XCVR_CFG;                               /**< TRANSCEIVER CONFIGURATION, offset: 0x1C */
  uint32_t CHANNEL_NUM;                            /**< CHANNEL NUMBER, offset: 0x20 */
  uint32_t TX_POWER;                               /**< TRANSMIT POWER, offset: 0x24 */
  uint32_t NTW_ADR_CTRL;                           /**< NETWORK ADDRESS CONTROL, offset: 0x28 */
  uint32_t NTW_ADR_0;                              /**< NETWORK ADDRESS 0, offset: 0x2C */
  uint32_t NTW_ADR_1;                              /**< NETWORK ADDRESS 1, offset: 0x30 */
  uint32_t NTW_ADR_2;                              /**< NETWORK ADDRESS 2, offset: 0x34 */
  uint32_t NTW_ADR_3;                              /**< NETWORK ADDRESS 3, offset: 0x38 */
  uint32_t RX_WATERMARK;                           /**< RECEIVE WATERMARK, offset: 0x3C */
  uint32_t DSM_CTRL;                               /**< DSM CONTROL, offset: 0x40 */
  uint32_t PART_ID;                                /**< PART ID, offset: 0x44 */
  uint8_t RESERVED_0[24];
  uint32_t PACKET_CFG;                             /**< PACKET CONFIGURATION, offset: 0x60 */
  uint32_t H0_CFG;                                 /**< H0 CONFIGURATION, offset: 0x64 */
  uint32_t H1_CFG;                                 /**< H1 CONFIGURATION, offset: 0x68 */
  uint32_t CRC_CFG;                                /**< CRC CONFIGURATION, offset: 0x6C */
  uint32_t CRC_INIT;                               /**< CRC INITIALIZATION, offset: 0x70 */
  uint32_t CRC_POLY;                               /**< CRC POLYNOMIAL, offset: 0x74 */
  uint32_t CRC_XOR_OUT;                            /**< CRC XOR OUT, offset: 0x78 */
  uint32_t WHITEN_CFG;                             /**< WHITENER CONFIGURATION, offset: 0x7C */
  uint32_t WHITEN_POLY;                            /**< WHITENER POLYNOMIAL, offset: 0x80 */
  uint32_t WHITEN_SZ_THR;                          /**< WHITENER SIZE THRESHOLD, offset: 0x84 */
  uint32_t BITRATE;                                /**< BIT RATE, offset: 0x88 */
  uint32_t PB_PARTITION;                           /**< PACKET BUFFER PARTITION POINT, offset: 0x8C */
} volatile *GENFSK_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- GENFSK - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GENFSK_Register_Accessor_Macros GENFSK - Register accessor macros
 * @{
 */


/* GENFSK - Register accessors */
#define GENFSK_IRQ_CTRL_REG(base)                ((base)->IRQ_CTRL)
#define GENFSK_EVENT_TMR_REG(base)               ((base)->EVENT_TMR)
#define GENFSK_T1_CMP_REG(base)                  ((base)->T1_CMP)
#define GENFSK_T2_CMP_REG(base)                  ((base)->T2_CMP)
#define GENFSK_TIMESTAMP_REG(base)               ((base)->TIMESTAMP)
#define GENFSK_XCVR_CTRL_REG(base)               ((base)->XCVR_CTRL)
#define GENFSK_XCVR_STS_REG(base)                ((base)->XCVR_STS)
#define GENFSK_XCVR_CFG_REG(base)                ((base)->XCVR_CFG)
#define GENFSK_CHANNEL_NUM_REG(base)             ((base)->CHANNEL_NUM)
#define GENFSK_TX_POWER_REG(base)                ((base)->TX_POWER)
#define GENFSK_NTW_ADR_CTRL_REG(base)            ((base)->NTW_ADR_CTRL)
#define GENFSK_NTW_ADR_0_REG(base)               ((base)->NTW_ADR_0)
#define GENFSK_NTW_ADR_1_REG(base)               ((base)->NTW_ADR_1)
#define GENFSK_NTW_ADR_2_REG(base)               ((base)->NTW_ADR_2)
#define GENFSK_NTW_ADR_3_REG(base)               ((base)->NTW_ADR_3)
#define GENFSK_RX_WATERMARK_REG(base)            ((base)->RX_WATERMARK)
#define GENFSK_DSM_CTRL_REG(base)                ((base)->DSM_CTRL)
#define GENFSK_PART_ID_REG(base)                 ((base)->PART_ID)
#define GENFSK_PACKET_CFG_REG(base)              ((base)->PACKET_CFG)
#define GENFSK_H0_CFG_REG(base)                  ((base)->H0_CFG)
#define GENFSK_H1_CFG_REG(base)                  ((base)->H1_CFG)
#define GENFSK_CRC_CFG_REG(base)                 ((base)->CRC_CFG)
#define GENFSK_CRC_INIT_REG(base)                ((base)->CRC_INIT)
#define GENFSK_CRC_POLY_REG(base)                ((base)->CRC_POLY)
#define GENFSK_CRC_XOR_OUT_REG(base)             ((base)->CRC_XOR_OUT)
#define GENFSK_WHITEN_CFG_REG(base)              ((base)->WHITEN_CFG)
#define GENFSK_WHITEN_POLY_REG(base)             ((base)->WHITEN_POLY)
#define GENFSK_WHITEN_SZ_THR_REG(base)           ((base)->WHITEN_SZ_THR)
#define GENFSK_BITRATE_REG(base)                 ((base)->BITRATE)
#define GENFSK_PB_PARTITION_REG(base)            ((base)->PB_PARTITION)

/*!
 * @}
 */ /* end of group GENFSK_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- GENFSK Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GENFSK_Register_Masks GENFSK Register Masks
 * @{
 */

/*! @name IRQ_CTRL - IRQ CONTROL */
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_MASK         (0x1U)
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_SHIFT        (0U)
#define GENFSK_IRQ_CTRL_TX_IRQ_MASK              (0x2U)
#define GENFSK_IRQ_CTRL_TX_IRQ_SHIFT             (1U)
#define GENFSK_IRQ_CTRL_RX_IRQ_MASK              (0x4U)
#define GENFSK_IRQ_CTRL_RX_IRQ_SHIFT             (2U)
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_MASK         (0x8U)
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_SHIFT        (3U)
#define GENFSK_IRQ_CTRL_T1_IRQ_MASK              (0x10U)
#define GENFSK_IRQ_CTRL_T1_IRQ_SHIFT             (4U)
#define GENFSK_IRQ_CTRL_T2_IRQ_MASK              (0x20U)
#define GENFSK_IRQ_CTRL_T2_IRQ_SHIFT             (5U)
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_MASK      (0x40U)
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_SHIFT     (6U)
#define GENFSK_IRQ_CTRL_WAKE_IRQ_MASK            (0x80U)
#define GENFSK_IRQ_CTRL_WAKE_IRQ_SHIFT           (7U)
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_MASK    (0x100U)
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_SHIFT   (8U)
#define GENFSK_IRQ_CTRL_TSM_IRQ_MASK             (0x200U)
#define GENFSK_IRQ_CTRL_TSM_IRQ_SHIFT            (9U)
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_MASK      (0x10000U)
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_SHIFT     (16U)
#define GENFSK_IRQ_CTRL_TX_IRQ_EN_MASK           (0x20000U)
#define GENFSK_IRQ_CTRL_TX_IRQ_EN_SHIFT          (17U)
#define GENFSK_IRQ_CTRL_RX_IRQ_EN_MASK           (0x40000U)
#define GENFSK_IRQ_CTRL_RX_IRQ_EN_SHIFT          (18U)
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_MASK      (0x80000U)
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_SHIFT     (19U)
#define GENFSK_IRQ_CTRL_T1_IRQ_EN_MASK           (0x100000U)
#define GENFSK_IRQ_CTRL_T1_IRQ_EN_SHIFT          (20U)
#define GENFSK_IRQ_CTRL_T2_IRQ_EN_MASK           (0x200000U)
#define GENFSK_IRQ_CTRL_T2_IRQ_EN_SHIFT          (21U)
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_MASK   (0x400000U)
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_SHIFT  (22U)
#define GENFSK_IRQ_CTRL_WAKE_IRQ_EN_MASK         (0x800000U)
#define GENFSK_IRQ_CTRL_WAKE_IRQ_EN_SHIFT        (23U)
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_MASK (0x1000000U)
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_SHIFT (24U)
#define GENFSK_IRQ_CTRL_TSM_IRQ_EN_MASK          (0x2000000U)
#define GENFSK_IRQ_CTRL_TSM_IRQ_EN_SHIFT         (25U)
#define GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN_MASK  (0x4000000U)
#define GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN_SHIFT (26U)
#define GENFSK_IRQ_CTRL_CRC_IGNORE_MASK          (0x8000000U)
#define GENFSK_IRQ_CTRL_CRC_IGNORE_SHIFT         (27U)
#define GENFSK_IRQ_CTRL_CRC_VALID_MASK           (0x80000000U)
#define GENFSK_IRQ_CTRL_CRC_VALID_SHIFT          (31U)

/*! @name EVENT_TMR - EVENT TIMER */
#define GENFSK_EVENT_TMR_EVENT_TMR_MASK          (0xFFFFFFU)
#define GENFSK_EVENT_TMR_EVENT_TMR_SHIFT         (0U)
#define GENFSK_EVENT_TMR_EVENT_TMR(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_EVENT_TMR_EVENT_TMR_SHIFT)) & GENFSK_EVENT_TMR_EVENT_TMR_MASK)
#define GENFSK_EVENT_TMR_EVENT_TMR_LD_MASK       (0x1000000U)
#define GENFSK_EVENT_TMR_EVENT_TMR_LD_SHIFT      (24U)
#define GENFSK_EVENT_TMR_EVENT_TMR_ADD_MASK      (0x2000000U)
#define GENFSK_EVENT_TMR_EVENT_TMR_ADD_SHIFT     (25U)

/*! @name T1_CMP - T1 COMPARE */
#define GENFSK_T1_CMP_T1_CMP_MASK                (0xFFFFFFU)
#define GENFSK_T1_CMP_T1_CMP_SHIFT               (0U)
#define GENFSK_T1_CMP_T1_CMP(x)                  (((uint32_t)(((uint32_t)(x)) << GENFSK_T1_CMP_T1_CMP_SHIFT)) & GENFSK_T1_CMP_T1_CMP_MASK)
#define GENFSK_T1_CMP_T1_CMP_EN_MASK             (0x1000000U)
#define GENFSK_T1_CMP_T1_CMP_EN_SHIFT            (24U)

/*! @name T2_CMP - T2 COMPARE */
#define GENFSK_T2_CMP_T2_CMP_MASK                (0xFFFFFFU)
#define GENFSK_T2_CMP_T2_CMP_SHIFT               (0U)
#define GENFSK_T2_CMP_T2_CMP(x)                  (((uint32_t)(((uint32_t)(x)) << GENFSK_T2_CMP_T2_CMP_SHIFT)) & GENFSK_T2_CMP_T2_CMP_MASK)
#define GENFSK_T2_CMP_T2_CMP_EN_MASK             (0x1000000U)
#define GENFSK_T2_CMP_T2_CMP_EN_SHIFT            (24U)

/*! @name TIMESTAMP - TIMESTAMP */
#define GENFSK_TIMESTAMP_TIMESTAMP_MASK          (0xFFFFFFU)
#define GENFSK_TIMESTAMP_TIMESTAMP_SHIFT         (0U)
#define GENFSK_TIMESTAMP_TIMESTAMP(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_TIMESTAMP_TIMESTAMP_SHIFT)) & GENFSK_TIMESTAMP_TIMESTAMP_MASK)

/*! @name XCVR_CTRL - TRANSCEIVER CONTROL */
#define GENFSK_XCVR_CTRL_SEQCMD_MASK             (0xFU)
#define GENFSK_XCVR_CTRL_SEQCMD_SHIFT            (0U)
#define GENFSK_XCVR_CTRL_SEQCMD(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CTRL_SEQCMD_SHIFT)) & GENFSK_XCVR_CTRL_SEQCMD_MASK)
#define GENFSK_XCVR_CTRL_CMDDEC_CS_MASK          (0x7000000U)
#define GENFSK_XCVR_CTRL_CMDDEC_CS_SHIFT         (24U)
#define GENFSK_XCVR_CTRL_CMDDEC_CS(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CTRL_CMDDEC_CS_SHIFT)) & GENFSK_XCVR_CTRL_CMDDEC_CS_MASK)
#define GENFSK_XCVR_CTRL_XCVR_BUSY_MASK          (0x80000000U)
#define GENFSK_XCVR_CTRL_XCVR_BUSY_SHIFT         (31U)

/*! @name XCVR_STS - TRANSCEIVER STATUS */
#define GENFSK_XCVR_STS_TX_START_T1_PEND_MASK    (0x1U)
#define GENFSK_XCVR_STS_TX_START_T1_PEND_SHIFT   (0U)
#define GENFSK_XCVR_STS_TX_START_T2_PEND_MASK    (0x2U)
#define GENFSK_XCVR_STS_TX_START_T2_PEND_SHIFT   (1U)
#define GENFSK_XCVR_STS_TX_IN_WARMUP_MASK        (0x4U)
#define GENFSK_XCVR_STS_TX_IN_WARMUP_SHIFT       (2U)
#define GENFSK_XCVR_STS_TX_IN_PROGRESS_MASK      (0x8U)
#define GENFSK_XCVR_STS_TX_IN_PROGRESS_SHIFT     (3U)
#define GENFSK_XCVR_STS_TX_IN_WARMDN_MASK        (0x10U)
#define GENFSK_XCVR_STS_TX_IN_WARMDN_SHIFT       (4U)
#define GENFSK_XCVR_STS_RX_START_T1_PEND_MASK    (0x20U)
#define GENFSK_XCVR_STS_RX_START_T1_PEND_SHIFT   (5U)
#define GENFSK_XCVR_STS_RX_START_T2_PEND_MASK    (0x40U)
#define GENFSK_XCVR_STS_RX_START_T2_PEND_SHIFT   (6U)
#define GENFSK_XCVR_STS_RX_STOP_T1_PEND_MASK     (0x80U)
#define GENFSK_XCVR_STS_RX_STOP_T1_PEND_SHIFT    (7U)
#define GENFSK_XCVR_STS_RX_STOP_T2_PEND_MASK     (0x100U)
#define GENFSK_XCVR_STS_RX_STOP_T2_PEND_SHIFT    (8U)
#define GENFSK_XCVR_STS_RX_IN_WARMUP_MASK        (0x200U)
#define GENFSK_XCVR_STS_RX_IN_WARMUP_SHIFT       (9U)
#define GENFSK_XCVR_STS_RX_IN_SEARCH_MASK        (0x400U)
#define GENFSK_XCVR_STS_RX_IN_SEARCH_SHIFT       (10U)
#define GENFSK_XCVR_STS_RX_IN_PROGRESS_MASK      (0x800U)
#define GENFSK_XCVR_STS_RX_IN_PROGRESS_SHIFT     (11U)
#define GENFSK_XCVR_STS_RX_IN_WARMDN_MASK        (0x1000U)
#define GENFSK_XCVR_STS_RX_IN_WARMDN_SHIFT       (12U)
#define GENFSK_XCVR_STS_LQI_VALID_MASK           (0x4000U)
#define GENFSK_XCVR_STS_LQI_VALID_SHIFT          (14U)
#define GENFSK_XCVR_STS_CRC_VALID_MASK           (0x8000U)
#define GENFSK_XCVR_STS_CRC_VALID_SHIFT          (15U)
#define GENFSK_XCVR_STS_RSSI_MASK                (0xFF0000U)
#define GENFSK_XCVR_STS_RSSI_SHIFT               (16U)
#define GENFSK_XCVR_STS_RSSI(x)                  (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_STS_RSSI_SHIFT)) & GENFSK_XCVR_STS_RSSI_MASK)
#define GENFSK_XCVR_STS_LQI_MASK                 (0xFF000000U)
#define GENFSK_XCVR_STS_LQI_SHIFT                (24U)
#define GENFSK_XCVR_STS_LQI(x)                   (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_STS_LQI_SHIFT)) & GENFSK_XCVR_STS_LQI_MASK)

/*! @name XCVR_CFG - TRANSCEIVER CONFIGURATION */
#define GENFSK_XCVR_CFG_TX_WHITEN_DIS_MASK       (0x1U)
#define GENFSK_XCVR_CFG_TX_WHITEN_DIS_SHIFT      (0U)
#define GENFSK_XCVR_CFG_RX_DEWHITEN_DIS_MASK     (0x2U)
#define GENFSK_XCVR_CFG_RX_DEWHITEN_DIS_SHIFT    (1U)
#define GENFSK_XCVR_CFG_SW_CRC_EN_MASK           (0x4U)
#define GENFSK_XCVR_CFG_SW_CRC_EN_SHIFT          (2U)
#define GENFSK_XCVR_CFG_PREAMBLE_SZ_MASK         (0x70U)
#define GENFSK_XCVR_CFG_PREAMBLE_SZ_SHIFT        (4U)
#define GENFSK_XCVR_CFG_PREAMBLE_SZ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_PREAMBLE_SZ_SHIFT)) & GENFSK_XCVR_CFG_PREAMBLE_SZ_MASK)
#define GENFSK_XCVR_CFG_TX_WARMUP_MASK           (0xFF00U)
#define GENFSK_XCVR_CFG_TX_WARMUP_SHIFT          (8U)
#define GENFSK_XCVR_CFG_TX_WARMUP(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_TX_WARMUP_SHIFT)) & GENFSK_XCVR_CFG_TX_WARMUP_MASK)
#define GENFSK_XCVR_CFG_RX_WARMUP_MASK           (0xFF0000U)
#define GENFSK_XCVR_CFG_RX_WARMUP_SHIFT          (16U)
#define GENFSK_XCVR_CFG_RX_WARMUP(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_RX_WARMUP_SHIFT)) & GENFSK_XCVR_CFG_RX_WARMUP_MASK)

/*! @name CHANNEL_NUM - CHANNEL NUMBER */
#define GENFSK_CHANNEL_NUM_CHANNEL_NUM_MASK      (0x7FU)
#define GENFSK_CHANNEL_NUM_CHANNEL_NUM_SHIFT     (0U)
#define GENFSK_CHANNEL_NUM_CHANNEL_NUM(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_CHANNEL_NUM_CHANNEL_NUM_SHIFT)) & GENFSK_CHANNEL_NUM_CHANNEL_NUM_MASK)

/*! @name TX_POWER - TRANSMIT POWER */
#define GENFSK_TX_POWER_TX_POWER_MASK            (0x3FU)
#define GENFSK_TX_POWER_TX_POWER_SHIFT           (0U)
#define GENFSK_TX_POWER_TX_POWER(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_TX_POWER_TX_POWER_SHIFT)) & GENFSK_TX_POWER_TX_POWER_MASK)

/*! @name NTW_ADR_CTRL - NETWORK ADDRESS CONTROL */
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_MASK      (0xFU)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_SHIFT     (0U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_EN(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_MASK     (0xF0U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_SHIFT    (4U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR0_SZ_MASK     (0x300U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR0_SZ_SHIFT    (8U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR0_SZ(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR0_SZ_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR0_SZ_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR1_SZ_MASK     (0xC00U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR1_SZ_SHIFT    (10U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR1_SZ(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR1_SZ_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR1_SZ_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR2_SZ_MASK     (0x3000U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR2_SZ_SHIFT    (12U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR2_SZ(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR2_SZ_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR2_SZ_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR3_SZ_MASK     (0xC000U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR3_SZ_SHIFT    (14U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR3_SZ(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR3_SZ_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR3_SZ_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR0_MASK    (0x70000U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR0_SHIFT   (16U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR0(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_THR0_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_THR0_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR1_MASK    (0x700000U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR1_SHIFT   (20U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR1(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_THR1_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_THR1_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR2_MASK    (0x7000000U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR2_SHIFT   (24U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR2(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_THR2_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_THR2_MASK)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR3_MASK    (0x70000000U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR3_SHIFT   (28U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR3(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_THR3_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_THR3_MASK)

/*! @name NTW_ADR_0 - NETWORK ADDRESS 0 */
#define GENFSK_NTW_ADR_0_NTW_ADR_0_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_0_NTW_ADR_0_SHIFT         (0U)
#define GENFSK_NTW_ADR_0_NTW_ADR_0(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_0_NTW_ADR_0_SHIFT)) & GENFSK_NTW_ADR_0_NTW_ADR_0_MASK)

/*! @name NTW_ADR_1 - NETWORK ADDRESS 1 */
#define GENFSK_NTW_ADR_1_NTW_ADR_1_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_1_NTW_ADR_1_SHIFT         (0U)
#define GENFSK_NTW_ADR_1_NTW_ADR_1(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_1_NTW_ADR_1_SHIFT)) & GENFSK_NTW_ADR_1_NTW_ADR_1_MASK)

/*! @name NTW_ADR_2 - NETWORK ADDRESS 2 */
#define GENFSK_NTW_ADR_2_NTW_ADR_2_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_2_NTW_ADR_2_SHIFT         (0U)
#define GENFSK_NTW_ADR_2_NTW_ADR_2(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_2_NTW_ADR_2_SHIFT)) & GENFSK_NTW_ADR_2_NTW_ADR_2_MASK)

/*! @name NTW_ADR_3 - NETWORK ADDRESS 3 */
#define GENFSK_NTW_ADR_3_NTW_ADR_3_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_3_NTW_ADR_3_SHIFT         (0U)
#define GENFSK_NTW_ADR_3_NTW_ADR_3(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_3_NTW_ADR_3_SHIFT)) & GENFSK_NTW_ADR_3_NTW_ADR_3_MASK)

/*! @name RX_WATERMARK - RECEIVE WATERMARK */
#define GENFSK_RX_WATERMARK_RX_WATERMARK_MASK    (0x1FFFU)
#define GENFSK_RX_WATERMARK_RX_WATERMARK_SHIFT   (0U)
#define GENFSK_RX_WATERMARK_RX_WATERMARK(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_WATERMARK_RX_WATERMARK_SHIFT)) & GENFSK_RX_WATERMARK_RX_WATERMARK_MASK)
#define GENFSK_RX_WATERMARK_BYTE_COUNTER_MASK    (0x1FFF0000U)
#define GENFSK_RX_WATERMARK_BYTE_COUNTER_SHIFT   (16U)
#define GENFSK_RX_WATERMARK_BYTE_COUNTER(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_WATERMARK_BYTE_COUNTER_SHIFT)) & GENFSK_RX_WATERMARK_BYTE_COUNTER_MASK)

/*! @name DSM_CTRL - DSM CONTROL */
#define GENFSK_DSM_CTRL_GENERIC_FSK_SLEEP_EN_MASK (0x1U)
#define GENFSK_DSM_CTRL_GENERIC_FSK_SLEEP_EN_SHIFT (0U)

/*! @name PART_ID - PART ID */
#define GENFSK_PART_ID_PART_ID_MASK              (0xFFU)
#define GENFSK_PART_ID_PART_ID_SHIFT             (0U)
#define GENFSK_PART_ID_PART_ID(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_PART_ID_PART_ID_SHIFT)) & GENFSK_PART_ID_PART_ID_MASK)

/*! @name PACKET_CFG - PACKET CONFIGURATION */
#define GENFSK_PACKET_CFG_LENGTH_SZ_MASK         (0x1FU)
#define GENFSK_PACKET_CFG_LENGTH_SZ_SHIFT        (0U)
#define GENFSK_PACKET_CFG_LENGTH_SZ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_LENGTH_SZ_SHIFT)) & GENFSK_PACKET_CFG_LENGTH_SZ_MASK)
#define GENFSK_PACKET_CFG_LENGTH_BIT_ORD_MASK    (0x20U)
#define GENFSK_PACKET_CFG_LENGTH_BIT_ORD_SHIFT   (5U)
#define GENFSK_PACKET_CFG_SYNC_ADDR_SZ_MASK      (0xC0U)
#define GENFSK_PACKET_CFG_SYNC_ADDR_SZ_SHIFT     (6U)
#define GENFSK_PACKET_CFG_SYNC_ADDR_SZ(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_SYNC_ADDR_SZ_SHIFT)) & GENFSK_PACKET_CFG_SYNC_ADDR_SZ_MASK)
#define GENFSK_PACKET_CFG_LENGTH_ADJ_MASK        (0x3F00U)
#define GENFSK_PACKET_CFG_LENGTH_ADJ_SHIFT       (8U)
#define GENFSK_PACKET_CFG_LENGTH_ADJ(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_LENGTH_ADJ_SHIFT)) & GENFSK_PACKET_CFG_LENGTH_ADJ_MASK)
#define GENFSK_PACKET_CFG_LENGTH_FAIL_MASK       (0x8000U)
#define GENFSK_PACKET_CFG_LENGTH_FAIL_SHIFT      (15U)
#define GENFSK_PACKET_CFG_H0_SZ_MASK             (0x1F0000U)
#define GENFSK_PACKET_CFG_H0_SZ_SHIFT            (16U)
#define GENFSK_PACKET_CFG_H0_SZ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_H0_SZ_SHIFT)) & GENFSK_PACKET_CFG_H0_SZ_MASK)
#define GENFSK_PACKET_CFG_H0_FAIL_MASK           (0x800000U)
#define GENFSK_PACKET_CFG_H0_FAIL_SHIFT          (23U)
#define GENFSK_PACKET_CFG_H1_SZ_MASK             (0x1F000000U)
#define GENFSK_PACKET_CFG_H1_SZ_SHIFT            (24U)
#define GENFSK_PACKET_CFG_H1_SZ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_H1_SZ_SHIFT)) & GENFSK_PACKET_CFG_H1_SZ_MASK)
#define GENFSK_PACKET_CFG_H1_FAIL_MASK           (0x80000000U)
#define GENFSK_PACKET_CFG_H1_FAIL_SHIFT          (31U)

/*! @name H0_CFG - H0 CONFIGURATION */
#define GENFSK_H0_CFG_H0_MATCH_MASK              (0xFFFFU)
#define GENFSK_H0_CFG_H0_MATCH_SHIFT             (0U)
#define GENFSK_H0_CFG_H0_MATCH(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_H0_CFG_H0_MATCH_SHIFT)) & GENFSK_H0_CFG_H0_MATCH_MASK)
#define GENFSK_H0_CFG_H0_MASK_MASK               (0xFFFF0000U)
#define GENFSK_H0_CFG_H0_MASK_SHIFT              (16U)
#define GENFSK_H0_CFG_H0_MASK(x)                 (((uint32_t)(((uint32_t)(x)) << GENFSK_H0_CFG_H0_MASK_SHIFT)) & GENFSK_H0_CFG_H0_MASK_MASK)

/*! @name H1_CFG - H1 CONFIGURATION */
#define GENFSK_H1_CFG_H1_MATCH_MASK              (0xFFFFU)
#define GENFSK_H1_CFG_H1_MATCH_SHIFT             (0U)
#define GENFSK_H1_CFG_H1_MATCH(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_H1_CFG_H1_MATCH_SHIFT)) & GENFSK_H1_CFG_H1_MATCH_MASK)
#define GENFSK_H1_CFG_H1_MASK_MASK               (0xFFFF0000U)
#define GENFSK_H1_CFG_H1_MASK_SHIFT              (16U)
#define GENFSK_H1_CFG_H1_MASK(x)                 (((uint32_t)(((uint32_t)(x)) << GENFSK_H1_CFG_H1_MASK_SHIFT)) & GENFSK_H1_CFG_H1_MASK_MASK)

/*! @name CRC_CFG - CRC CONFIGURATION */
#define GENFSK_CRC_CFG_CRC_SZ_MASK               (0x7U)
#define GENFSK_CRC_CFG_CRC_SZ_SHIFT              (0U)
#define GENFSK_CRC_CFG_CRC_SZ(x)                 (((uint32_t)(((uint32_t)(x)) << GENFSK_CRC_CFG_CRC_SZ_SHIFT)) & GENFSK_CRC_CFG_CRC_SZ_MASK)
#define GENFSK_CRC_CFG_CRC_START_BYTE_MASK       (0xF00U)
#define GENFSK_CRC_CFG_CRC_START_BYTE_SHIFT      (8U)
#define GENFSK_CRC_CFG_CRC_START_BYTE(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_CRC_CFG_CRC_START_BYTE_SHIFT)) & GENFSK_CRC_CFG_CRC_START_BYTE_MASK)
#define GENFSK_CRC_CFG_CRC_REF_IN_MASK           (0x10000U)
#define GENFSK_CRC_CFG_CRC_REF_IN_SHIFT          (16U)
#define GENFSK_CRC_CFG_CRC_REF_OUT_MASK          (0x20000U)
#define GENFSK_CRC_CFG_CRC_REF_OUT_SHIFT         (17U)
#define GENFSK_CRC_CFG_CRC_BYTE_ORD_MASK         (0x40000U)
#define GENFSK_CRC_CFG_CRC_BYTE_ORD_SHIFT        (18U)

/*! @name CRC_INIT - CRC INITIALIZATION */
#define GENFSK_CRC_INIT_CRC_SEED_MASK            (0xFFFFFFFFU)
#define GENFSK_CRC_INIT_CRC_SEED_SHIFT           (0U)
#define GENFSK_CRC_INIT_CRC_SEED(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_CRC_INIT_CRC_SEED_SHIFT)) & GENFSK_CRC_INIT_CRC_SEED_MASK)

/*! @name CRC_POLY - CRC POLYNOMIAL */
#define GENFSK_CRC_POLY_CRC_POLY_MASK            (0xFFFFFFFFU)
#define GENFSK_CRC_POLY_CRC_POLY_SHIFT           (0U)
#define GENFSK_CRC_POLY_CRC_POLY(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_CRC_POLY_CRC_POLY_SHIFT)) & GENFSK_CRC_POLY_CRC_POLY_MASK)

/*! @name CRC_XOR_OUT - CRC XOR OUT */
#define GENFSK_CRC_XOR_OUT_CRC_XOR_OUT_MASK      (0xFFFFFFFFU)
#define GENFSK_CRC_XOR_OUT_CRC_XOR_OUT_SHIFT     (0U)
#define GENFSK_CRC_XOR_OUT_CRC_XOR_OUT(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_CRC_XOR_OUT_CRC_XOR_OUT_SHIFT)) & GENFSK_CRC_XOR_OUT_CRC_XOR_OUT_MASK)

/*! @name WHITEN_CFG - WHITENER CONFIGURATION */
#define GENFSK_WHITEN_CFG_WHITEN_START_MASK      (0x3U)
#define GENFSK_WHITEN_CFG_WHITEN_START_SHIFT     (0U)
#define GENFSK_WHITEN_CFG_WHITEN_START(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_WHITEN_CFG_WHITEN_START_SHIFT)) & GENFSK_WHITEN_CFG_WHITEN_START_MASK)
#define GENFSK_WHITEN_CFG_WHITEN_END_MASK        (0x4U)
#define GENFSK_WHITEN_CFG_WHITEN_END_SHIFT       (2U)
#define GENFSK_WHITEN_CFG_WHITEN_B4_CRC_MASK     (0x8U)
#define GENFSK_WHITEN_CFG_WHITEN_B4_CRC_SHIFT    (3U)
#define GENFSK_WHITEN_CFG_WHITEN_POLY_TYPE_MASK  (0x10U)
#define GENFSK_WHITEN_CFG_WHITEN_POLY_TYPE_SHIFT (4U)
#define GENFSK_WHITEN_CFG_WHITEN_REF_IN_MASK     (0x20U)
#define GENFSK_WHITEN_CFG_WHITEN_REF_IN_SHIFT    (5U)
#define GENFSK_WHITEN_CFG_WHITEN_PAYLOAD_REINIT_MASK (0x40U)
#define GENFSK_WHITEN_CFG_WHITEN_PAYLOAD_REINIT_SHIFT (6U)
#define GENFSK_WHITEN_CFG_WHITEN_SIZE_MASK       (0xF00U)
#define GENFSK_WHITEN_CFG_WHITEN_SIZE_SHIFT      (8U)
#define GENFSK_WHITEN_CFG_WHITEN_SIZE(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_WHITEN_CFG_WHITEN_SIZE_SHIFT)) & GENFSK_WHITEN_CFG_WHITEN_SIZE_MASK)
#define GENFSK_WHITEN_CFG_MANCHESTER_EN_MASK     (0x1000U)
#define GENFSK_WHITEN_CFG_MANCHESTER_EN_SHIFT    (12U)
#define GENFSK_WHITEN_CFG_MANCHESTER_INV_MASK    (0x2000U)
#define GENFSK_WHITEN_CFG_MANCHESTER_INV_SHIFT   (13U)
#define GENFSK_WHITEN_CFG_MANCHESTER_START_MASK  (0x4000U)
#define GENFSK_WHITEN_CFG_MANCHESTER_START_SHIFT (14U)
#define GENFSK_WHITEN_CFG_WHITEN_INIT_MASK       (0x1FF0000U)
#define GENFSK_WHITEN_CFG_WHITEN_INIT_SHIFT      (16U)
#define GENFSK_WHITEN_CFG_WHITEN_INIT(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_WHITEN_CFG_WHITEN_INIT_SHIFT)) & GENFSK_WHITEN_CFG_WHITEN_INIT_MASK)

/*! @name WHITEN_POLY - WHITENER POLYNOMIAL */
#define GENFSK_WHITEN_POLY_WHITEN_POLY_MASK      (0x1FFU)
#define GENFSK_WHITEN_POLY_WHITEN_POLY_SHIFT     (0U)
#define GENFSK_WHITEN_POLY_WHITEN_POLY(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_WHITEN_POLY_WHITEN_POLY_SHIFT)) & GENFSK_WHITEN_POLY_WHITEN_POLY_MASK)

/*! @name WHITEN_SZ_THR - WHITENER SIZE THRESHOLD */
#define GENFSK_WHITEN_SZ_THR_WHITEN_SZ_THR_MASK  (0xFFFU)
#define GENFSK_WHITEN_SZ_THR_WHITEN_SZ_THR_SHIFT (0U)
#define GENFSK_WHITEN_SZ_THR_WHITEN_SZ_THR(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_WHITEN_SZ_THR_WHITEN_SZ_THR_SHIFT)) & GENFSK_WHITEN_SZ_THR_WHITEN_SZ_THR_MASK)
#define GENFSK_WHITEN_SZ_THR_LENGTH_MAX_MASK     (0x7F0000U)
#define GENFSK_WHITEN_SZ_THR_LENGTH_MAX_SHIFT    (16U)
#define GENFSK_WHITEN_SZ_THR_LENGTH_MAX(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_WHITEN_SZ_THR_LENGTH_MAX_SHIFT)) & GENFSK_WHITEN_SZ_THR_LENGTH_MAX_MASK)
#define GENFSK_WHITEN_SZ_THR_REC_BAD_PKT_MASK    (0x800000U)
#define GENFSK_WHITEN_SZ_THR_REC_BAD_PKT_SHIFT   (23U)

/*! @name BITRATE - BIT RATE */
#define GENFSK_BITRATE_BITRATE_MASK              (0x3U)
#define GENFSK_BITRATE_BITRATE_SHIFT             (0U)
#define GENFSK_BITRATE_BITRATE(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_BITRATE_BITRATE_SHIFT)) & GENFSK_BITRATE_BITRATE_MASK)

/*! @name PB_PARTITION - PACKET BUFFER PARTITION POINT */
#define GENFSK_PB_PARTITION_PB_PARTITION_MASK    (0x7FFU)
#define GENFSK_PB_PARTITION_PB_PARTITION_SHIFT   (0U)
#define GENFSK_PB_PARTITION_PB_PARTITION(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_PB_PARTITION_PB_PARTITION_SHIFT)) & GENFSK_PB_PARTITION_PB_PARTITION_MASK)


/*!
 * @}
 */ /* end of group GENFSK_Register_Masks */


/* GENFSK - Peripheral instance base addresses */
/** Peripheral GENFSK_REGS base pointer */
#define GENFSK_BASE_PTR                          ((GENFSK_MemMapPtr)0x4005F000u)
/** Array initializer of GENFSK peripheral base pointers */
#define GENFSK_BASE_PTRS                         { GENFSK_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- GENFSK - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GENFSK_Register_Accessor_Macros GENFSK - Register accessor macros
 * @{
 */


/* GENFSK - Register instance definitions */
/* GENFSK_REGS */
#define GENFSK_IRQ_CTRL                          GENFSK_IRQ_CTRL_REG(GENFSK_BASE_PTR)
#define GENFSK_EVENT_TMR                         GENFSK_EVENT_TMR_REG(GENFSK_BASE_PTR)
#define GENFSK_T1_CMP                            GENFSK_T1_CMP_REG(GENFSK_BASE_PTR)
#define GENFSK_T2_CMP                            GENFSK_T2_CMP_REG(GENFSK_BASE_PTR)
#define GENFSK_TIMESTAMP                         GENFSK_TIMESTAMP_REG(GENFSK_BASE_PTR)
#define GENFSK_XCVR_CTRL                         GENFSK_XCVR_CTRL_REG(GENFSK_BASE_PTR)
#define GENFSK_XCVR_STS                          GENFSK_XCVR_STS_REG(GENFSK_BASE_PTR)
#define GENFSK_XCVR_CFG                          GENFSK_XCVR_CFG_REG(GENFSK_BASE_PTR)
#define GENFSK_CHANNEL_NUM                       GENFSK_CHANNEL_NUM_REG(GENFSK_BASE_PTR)
#define GENFSK_TX_POWER                          GENFSK_TX_POWER_REG(GENFSK_BASE_PTR)
#define GENFSK_NTW_ADR_CTRL                      GENFSK_NTW_ADR_CTRL_REG(GENFSK_BASE_PTR)
#define GENFSK_NTW_ADR_0                         GENFSK_NTW_ADR_0_REG(GENFSK_BASE_PTR)
#define GENFSK_NTW_ADR_1                         GENFSK_NTW_ADR_1_REG(GENFSK_BASE_PTR)
#define GENFSK_NTW_ADR_2                         GENFSK_NTW_ADR_2_REG(GENFSK_BASE_PTR)
#define GENFSK_NTW_ADR_3                         GENFSK_NTW_ADR_3_REG(GENFSK_BASE_PTR)
#define GENFSK_RX_WATERMARK                      GENFSK_RX_WATERMARK_REG(GENFSK_BASE_PTR)
#define GENFSK_DSM_CTRL                          GENFSK_DSM_CTRL_REG(GENFSK_BASE_PTR)
#define GENFSK_PART_ID                           GENFSK_PART_ID_REG(GENFSK_BASE_PTR)
#define GENFSK_PACKET_CFG                        GENFSK_PACKET_CFG_REG(GENFSK_BASE_PTR)
#define GENFSK_H0_CFG                            GENFSK_H0_CFG_REG(GENFSK_BASE_PTR)
#define GENFSK_H1_CFG                            GENFSK_H1_CFG_REG(GENFSK_BASE_PTR)
#define GENFSK_CRC_CFG                           GENFSK_CRC_CFG_REG(GENFSK_BASE_PTR)
#define GENFSK_CRC_INIT                          GENFSK_CRC_INIT_REG(GENFSK_BASE_PTR)
#define GENFSK_CRC_POLY                          GENFSK_CRC_POLY_REG(GENFSK_BASE_PTR)
#define GENFSK_CRC_XOR_OUT                       GENFSK_CRC_XOR_OUT_REG(GENFSK_BASE_PTR)
#define GENFSK_WHITEN_CFG                        GENFSK_WHITEN_CFG_REG(GENFSK_BASE_PTR)
#define GENFSK_WHITEN_POLY                       GENFSK_WHITEN_POLY_REG(GENFSK_BASE_PTR)
#define GENFSK_WHITEN_SZ_THR                     GENFSK_WHITEN_SZ_THR_REG(GENFSK_BASE_PTR)
#define GENFSK_BITRATE                           GENFSK_BITRATE_REG(GENFSK_BASE_PTR)
#define GENFSK_PB_PARTITION                      GENFSK_PB_PARTITION_REG(GENFSK_BASE_PTR)

/*!
 * @}
 */ /* end of group GENFSK_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group GENFSK_Peripheral */


/* ----------------------------------------------------------------------------
   -- GPIO
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral GPIO
 * @{
 */

/** GPIO - Peripheral register structure */
typedef struct GPIO_MemMap {
  uint32_t PDOR;                                   /**< Port Data Output Register, offset: 0x0 */
  uint32_t PSOR;                                   /**< Port Set Output Register, offset: 0x4 */
  uint32_t PCOR;                                   /**< Port Clear Output Register, offset: 0x8 */
  uint32_t PTOR;                                   /**< Port Toggle Output Register, offset: 0xC */
  uint32_t PDIR;                                   /**< Port Data Input Register, offset: 0x10 */
  uint32_t PDDR;                                   /**< Port Data Direction Register, offset: 0x14 */
} volatile *GPIO_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- GPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Accessor_Macros GPIO - Register accessor macros
 * @{
 */


/* GPIO - Register accessors */
#define GPIO_PDOR_REG(base)                      ((base)->PDOR)
#define GPIO_PSOR_REG(base)                      ((base)->PSOR)
#define GPIO_PCOR_REG(base)                      ((base)->PCOR)
#define GPIO_PTOR_REG(base)                      ((base)->PTOR)
#define GPIO_PDIR_REG(base)                      ((base)->PDIR)
#define GPIO_PDDR_REG(base)                      ((base)->PDDR)

/*!
 * @}
 */ /* end of group GPIO_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/*! @name PDOR - Port Data Output Register */
#define GPIO_PDOR_PDO_MASK                       (0xFFFFFFFFU)
#define GPIO_PDOR_PDO_SHIFT                      (0U)
#define GPIO_PDOR_PDO(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO_SHIFT)) & GPIO_PDOR_PDO_MASK)

/*! @name PSOR - Port Set Output Register */
#define GPIO_PSOR_PTSO_MASK                      (0xFFFFFFFFU)
#define GPIO_PSOR_PTSO_SHIFT                     (0U)
#define GPIO_PSOR_PTSO(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO_SHIFT)) & GPIO_PSOR_PTSO_MASK)

/*! @name PCOR - Port Clear Output Register */
#define GPIO_PCOR_PTCO_MASK                      (0xFFFFFFFFU)
#define GPIO_PCOR_PTCO_SHIFT                     (0U)
#define GPIO_PCOR_PTCO(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO_SHIFT)) & GPIO_PCOR_PTCO_MASK)

/*! @name PTOR - Port Toggle Output Register */
#define GPIO_PTOR_PTTO_MASK                      (0xFFFFFFFFU)
#define GPIO_PTOR_PTTO_SHIFT                     (0U)
#define GPIO_PTOR_PTTO(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO_SHIFT)) & GPIO_PTOR_PTTO_MASK)

/*! @name PDIR - Port Data Input Register */
#define GPIO_PDIR_PDI_MASK                       (0xFFFFFFFFU)
#define GPIO_PDIR_PDI_SHIFT                      (0U)
#define GPIO_PDIR_PDI(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI_SHIFT)) & GPIO_PDIR_PDI_MASK)

/*! @name PDDR - Port Data Direction Register */
#define GPIO_PDDR_PDD_MASK                       (0xFFFFFFFFU)
#define GPIO_PDDR_PDD_SHIFT                      (0U)
#define GPIO_PDDR_PDD(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD_SHIFT)) & GPIO_PDDR_PDD_MASK)


/*!
 * @}
 */ /* end of group GPIO_Register_Masks */


/* GPIO - Peripheral instance base addresses */
/** Peripheral GPIOA base pointer */
#define GPIOA_BASE_PTR                           ((GPIO_MemMapPtr)0x400FF000u)
/** Peripheral GPIOB base pointer */
#define GPIOB_BASE_PTR                           ((GPIO_MemMapPtr)0x400FF040u)
/** Peripheral GPIOC base pointer */
#define GPIOC_BASE_PTR                           ((GPIO_MemMapPtr)0x400FF080u)
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS                           { GPIOA_BASE_PTR, GPIOB_BASE_PTR, GPIOC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- GPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Accessor_Macros GPIO - Register accessor macros
 * @{
 */


/* GPIO - Register instance definitions */
/* GPIOA */
#define GPIOA_PDOR                               GPIO_PDOR_REG(GPIOA_BASE_PTR)
#define GPIOA_PSOR                               GPIO_PSOR_REG(GPIOA_BASE_PTR)
#define GPIOA_PCOR                               GPIO_PCOR_REG(GPIOA_BASE_PTR)
#define GPIOA_PTOR                               GPIO_PTOR_REG(GPIOA_BASE_PTR)
#define GPIOA_PDIR                               GPIO_PDIR_REG(GPIOA_BASE_PTR)
#define GPIOA_PDDR                               GPIO_PDDR_REG(GPIOA_BASE_PTR)
/* GPIOB */
#define GPIOB_PDOR                               GPIO_PDOR_REG(GPIOB_BASE_PTR)
#define GPIOB_PSOR                               GPIO_PSOR_REG(GPIOB_BASE_PTR)
#define GPIOB_PCOR                               GPIO_PCOR_REG(GPIOB_BASE_PTR)
#define GPIOB_PTOR                               GPIO_PTOR_REG(GPIOB_BASE_PTR)
#define GPIOB_PDIR                               GPIO_PDIR_REG(GPIOB_BASE_PTR)
#define GPIOB_PDDR                               GPIO_PDDR_REG(GPIOB_BASE_PTR)
/* GPIOC */
#define GPIOC_PDOR                               GPIO_PDOR_REG(GPIOC_BASE_PTR)
#define GPIOC_PSOR                               GPIO_PSOR_REG(GPIOC_BASE_PTR)
#define GPIOC_PCOR                               GPIO_PCOR_REG(GPIOC_BASE_PTR)
#define GPIOC_PTOR                               GPIO_PTOR_REG(GPIOC_BASE_PTR)
#define GPIOC_PDIR                               GPIO_PDIR_REG(GPIOC_BASE_PTR)
#define GPIOC_PDDR                               GPIO_PDDR_REG(GPIOC_BASE_PTR)

/*!
 * @}
 */ /* end of group GPIO_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group GPIO_Peripheral */


/* ----------------------------------------------------------------------------
   -- I2C
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Peripheral I2C
 * @{
 */

/** I2C - Peripheral register structure */
typedef struct I2C_MemMap {
  uint8_t A1;                                      /**< I2C Address Register 1, offset: 0x0 */
  uint8_t F;                                       /**< I2C Frequency Divider register, offset: 0x1 */
  uint8_t C1;                                      /**< I2C Control Register 1, offset: 0x2 */
  uint8_t S;                                       /**< I2C Status register, offset: 0x3 */
  uint8_t D;                                       /**< I2C Data I/O register, offset: 0x4 */
  uint8_t C2;                                      /**< I2C Control Register 2, offset: 0x5 */
  uint8_t FLT;                                     /**< I2C Programmable Input Glitch Filter Register, offset: 0x6 */
  uint8_t RA;                                      /**< I2C Range Address register, offset: 0x7 */
  uint8_t SMB;                                     /**< I2C SMBus Control and Status register, offset: 0x8 */
  uint8_t A2;                                      /**< I2C Address Register 2, offset: 0x9 */
  uint8_t SLTH;                                    /**< I2C SCL Low Timeout Register High, offset: 0xA */
  uint8_t SLTL;                                    /**< I2C SCL Low Timeout Register Low, offset: 0xB */
  uint8_t S2;                                      /**< I2C Status register 2, offset: 0xC */
} volatile *I2C_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- I2C - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Accessor_Macros I2C - Register accessor macros
 * @{
 */


/* I2C - Register accessors */
#define I2C_A1_REG(base)                         ((base)->A1)
#define I2C_F_REG(base)                          ((base)->F)
#define I2C_C1_REG(base)                         ((base)->C1)
#define I2C_S_REG(base)                          ((base)->S)
#define I2C_D_REG(base)                          ((base)->D)
#define I2C_C2_REG(base)                         ((base)->C2)
#define I2C_FLT_REG(base)                        ((base)->FLT)
#define I2C_RA_REG(base)                         ((base)->RA)
#define I2C_SMB_REG(base)                        ((base)->SMB)
#define I2C_A2_REG(base)                         ((base)->A2)
#define I2C_SLTH_REG(base)                       ((base)->SLTH)
#define I2C_SLTL_REG(base)                       ((base)->SLTL)
#define I2C_S2_REG(base)                         ((base)->S2)

/*!
 * @}
 */ /* end of group I2C_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- I2C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Masks I2C Register Masks
 * @{
 */

/*! @name A1 - I2C Address Register 1 */
#define I2C_A1_AD_MASK                           (0xFEU)
#define I2C_A1_AD_SHIFT                          (1U)
#define I2C_A1_AD(x)                             (((uint8_t)(((uint8_t)(x)) << I2C_A1_AD_SHIFT)) & I2C_A1_AD_MASK)

/*! @name F - I2C Frequency Divider register */
#define I2C_F_ICR_MASK                           (0x3FU)
#define I2C_F_ICR_SHIFT                          (0U)
#define I2C_F_ICR(x)                             (((uint8_t)(((uint8_t)(x)) << I2C_F_ICR_SHIFT)) & I2C_F_ICR_MASK)
#define I2C_F_MULT_MASK                          (0xC0U)
#define I2C_F_MULT_SHIFT                         (6U)
#define I2C_F_MULT(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_F_MULT_SHIFT)) & I2C_F_MULT_MASK)

/*! @name C1 - I2C Control Register 1 */
#define I2C_C1_DMAEN_MASK                        (0x1U)
#define I2C_C1_DMAEN_SHIFT                       (0U)
#define I2C_C1_WUEN_MASK                         (0x2U)
#define I2C_C1_WUEN_SHIFT                        (1U)
#define I2C_C1_RSTA_MASK                         (0x4U)
#define I2C_C1_RSTA_SHIFT                        (2U)
#define I2C_C1_TXAK_MASK                         (0x8U)
#define I2C_C1_TXAK_SHIFT                        (3U)
#define I2C_C1_TX_MASK                           (0x10U)
#define I2C_C1_TX_SHIFT                          (4U)
#define I2C_C1_MST_MASK                          (0x20U)
#define I2C_C1_MST_SHIFT                         (5U)
#define I2C_C1_IICIE_MASK                        (0x40U)
#define I2C_C1_IICIE_SHIFT                       (6U)
#define I2C_C1_IICEN_MASK                        (0x80U)
#define I2C_C1_IICEN_SHIFT                       (7U)

/*! @name S - I2C Status register */
#define I2C_S_RXAK_MASK                          (0x1U)
#define I2C_S_RXAK_SHIFT                         (0U)
#define I2C_S_IICIF_MASK                         (0x2U)
#define I2C_S_IICIF_SHIFT                        (1U)
#define I2C_S_SRW_MASK                           (0x4U)
#define I2C_S_SRW_SHIFT                          (2U)
#define I2C_S_RAM_MASK                           (0x8U)
#define I2C_S_RAM_SHIFT                          (3U)
#define I2C_S_ARBL_MASK                          (0x10U)
#define I2C_S_ARBL_SHIFT                         (4U)
#define I2C_S_BUSY_MASK                          (0x20U)
#define I2C_S_BUSY_SHIFT                         (5U)
#define I2C_S_IAAS_MASK                          (0x40U)
#define I2C_S_IAAS_SHIFT                         (6U)
#define I2C_S_TCF_MASK                           (0x80U)
#define I2C_S_TCF_SHIFT                          (7U)

/*! @name D - I2C Data I/O register */
#define I2C_D_DATA_MASK                          (0xFFU)
#define I2C_D_DATA_SHIFT                         (0U)
#define I2C_D_DATA(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_D_DATA_SHIFT)) & I2C_D_DATA_MASK)

/*! @name C2 - I2C Control Register 2 */
#define I2C_C2_AD_MASK                           (0x7U)
#define I2C_C2_AD_SHIFT                          (0U)
#define I2C_C2_AD(x)                             (((uint8_t)(((uint8_t)(x)) << I2C_C2_AD_SHIFT)) & I2C_C2_AD_MASK)
#define I2C_C2_RMEN_MASK                         (0x8U)
#define I2C_C2_RMEN_SHIFT                        (3U)
#define I2C_C2_SBRC_MASK                         (0x10U)
#define I2C_C2_SBRC_SHIFT                        (4U)
#define I2C_C2_HDRS_MASK                         (0x20U)
#define I2C_C2_HDRS_SHIFT                        (5U)
#define I2C_C2_ADEXT_MASK                        (0x40U)
#define I2C_C2_ADEXT_SHIFT                       (6U)
#define I2C_C2_GCAEN_MASK                        (0x80U)
#define I2C_C2_GCAEN_SHIFT                       (7U)

/*! @name FLT - I2C Programmable Input Glitch Filter Register */
#define I2C_FLT_FLT_MASK                         (0xFU)
#define I2C_FLT_FLT_SHIFT                        (0U)
#define I2C_FLT_FLT(x)                           (((uint8_t)(((uint8_t)(x)) << I2C_FLT_FLT_SHIFT)) & I2C_FLT_FLT_MASK)
#define I2C_FLT_STARTF_MASK                      (0x10U)
#define I2C_FLT_STARTF_SHIFT                     (4U)
#define I2C_FLT_SSIE_MASK                        (0x20U)
#define I2C_FLT_SSIE_SHIFT                       (5U)
#define I2C_FLT_STOPF_MASK                       (0x40U)
#define I2C_FLT_STOPF_SHIFT                      (6U)
#define I2C_FLT_SHEN_MASK                        (0x80U)
#define I2C_FLT_SHEN_SHIFT                       (7U)

/*! @name RA - I2C Range Address register */
#define I2C_RA_RAD_MASK                          (0xFEU)
#define I2C_RA_RAD_SHIFT                         (1U)
#define I2C_RA_RAD(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_RA_RAD_SHIFT)) & I2C_RA_RAD_MASK)

/*! @name SMB - I2C SMBus Control and Status register */
#define I2C_SMB_SHTF2IE_MASK                     (0x1U)
#define I2C_SMB_SHTF2IE_SHIFT                    (0U)
#define I2C_SMB_SHTF2_MASK                       (0x2U)
#define I2C_SMB_SHTF2_SHIFT                      (1U)
#define I2C_SMB_SHTF1_MASK                       (0x4U)
#define I2C_SMB_SHTF1_SHIFT                      (2U)
#define I2C_SMB_SLTF_MASK                        (0x8U)
#define I2C_SMB_SLTF_SHIFT                       (3U)
#define I2C_SMB_TCKSEL_MASK                      (0x10U)
#define I2C_SMB_TCKSEL_SHIFT                     (4U)
#define I2C_SMB_SIICAEN_MASK                     (0x20U)
#define I2C_SMB_SIICAEN_SHIFT                    (5U)
#define I2C_SMB_ALERTEN_MASK                     (0x40U)
#define I2C_SMB_ALERTEN_SHIFT                    (6U)
#define I2C_SMB_FACK_MASK                        (0x80U)
#define I2C_SMB_FACK_SHIFT                       (7U)

/*! @name A2 - I2C Address Register 2 */
#define I2C_A2_SAD_MASK                          (0xFEU)
#define I2C_A2_SAD_SHIFT                         (1U)
#define I2C_A2_SAD(x)                            (((uint8_t)(((uint8_t)(x)) << I2C_A2_SAD_SHIFT)) & I2C_A2_SAD_MASK)

/*! @name SLTH - I2C SCL Low Timeout Register High */
#define I2C_SLTH_SSLT_MASK                       (0xFFU)
#define I2C_SLTH_SSLT_SHIFT                      (0U)
#define I2C_SLTH_SSLT(x)                         (((uint8_t)(((uint8_t)(x)) << I2C_SLTH_SSLT_SHIFT)) & I2C_SLTH_SSLT_MASK)

/*! @name SLTL - I2C SCL Low Timeout Register Low */
#define I2C_SLTL_SSLT_MASK                       (0xFFU)
#define I2C_SLTL_SSLT_SHIFT                      (0U)
#define I2C_SLTL_SSLT(x)                         (((uint8_t)(((uint8_t)(x)) << I2C_SLTL_SSLT_SHIFT)) & I2C_SLTL_SSLT_MASK)

/*! @name S2 - I2C Status register 2 */
#define I2C_S2_EMPTY_MASK                        (0x1U)
#define I2C_S2_EMPTY_SHIFT                       (0U)
#define I2C_S2_ERROR_MASK                        (0x2U)
#define I2C_S2_ERROR_SHIFT                       (1U)
#define I2C_S2_DFEN_MASK                         (0x4U)
#define I2C_S2_DFEN_SHIFT                        (2U)


/*!
 * @}
 */ /* end of group I2C_Register_Masks */


/* I2C - Peripheral instance base addresses */
/** Peripheral I2C0 base pointer */
#define I2C0_BASE_PTR                            ((I2C_MemMapPtr)0x40066000u)
/** Peripheral I2C1 base pointer */
#define I2C1_BASE_PTR                            ((I2C_MemMapPtr)0x40067000u)
/** Array initializer of I2C peripheral base pointers */
#define I2C_BASE_PTRS                            { I2C0_BASE_PTR, I2C1_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- I2C - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Accessor_Macros I2C - Register accessor macros
 * @{
 */


/* I2C - Register instance definitions */
/* I2C0 */
#define I2C0_A1                                  I2C_A1_REG(I2C0_BASE_PTR)
#define I2C0_F                                   I2C_F_REG(I2C0_BASE_PTR)
#define I2C0_C1                                  I2C_C1_REG(I2C0_BASE_PTR)
#define I2C0_S                                   I2C_S_REG(I2C0_BASE_PTR)
#define I2C0_D                                   I2C_D_REG(I2C0_BASE_PTR)
#define I2C0_C2                                  I2C_C2_REG(I2C0_BASE_PTR)
#define I2C0_FLT                                 I2C_FLT_REG(I2C0_BASE_PTR)
#define I2C0_RA                                  I2C_RA_REG(I2C0_BASE_PTR)
#define I2C0_SMB                                 I2C_SMB_REG(I2C0_BASE_PTR)
#define I2C0_A2                                  I2C_A2_REG(I2C0_BASE_PTR)
#define I2C0_SLTH                                I2C_SLTH_REG(I2C0_BASE_PTR)
#define I2C0_SLTL                                I2C_SLTL_REG(I2C0_BASE_PTR)
#define I2C0_S2                                  I2C_S2_REG(I2C0_BASE_PTR)
/* I2C1 */
#define I2C1_A1                                  I2C_A1_REG(I2C1_BASE_PTR)
#define I2C1_F                                   I2C_F_REG(I2C1_BASE_PTR)
#define I2C1_C1                                  I2C_C1_REG(I2C1_BASE_PTR)
#define I2C1_S                                   I2C_S_REG(I2C1_BASE_PTR)
#define I2C1_D                                   I2C_D_REG(I2C1_BASE_PTR)
#define I2C1_C2                                  I2C_C2_REG(I2C1_BASE_PTR)
#define I2C1_FLT                                 I2C_FLT_REG(I2C1_BASE_PTR)
#define I2C1_RA                                  I2C_RA_REG(I2C1_BASE_PTR)
#define I2C1_SMB                                 I2C_SMB_REG(I2C1_BASE_PTR)
#define I2C1_A2                                  I2C_A2_REG(I2C1_BASE_PTR)
#define I2C1_SLTH                                I2C_SLTH_REG(I2C1_BASE_PTR)
#define I2C1_SLTL                                I2C_SLTL_REG(I2C1_BASE_PTR)
#define I2C1_S2                                  I2C_S2_REG(I2C1_BASE_PTR)

/*!
 * @}
 */ /* end of group I2C_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group I2C_Peripheral */


/* ----------------------------------------------------------------------------
   -- LLWU
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Peripheral LLWU
 * @{
 */

/** LLWU - Peripheral register structure */
typedef struct LLWU_MemMap {
  uint8_t PE1;                                     /**< LLWU Pin Enable 1 register, offset: 0x0 */
  uint8_t PE2;                                     /**< LLWU Pin Enable 2 register, offset: 0x1 */
  uint8_t PE3;                                     /**< LLWU Pin Enable 3 register, offset: 0x2 */
  uint8_t PE4;                                     /**< LLWU Pin Enable 4 register, offset: 0x3 */
  uint8_t ME;                                      /**< LLWU Module Enable register, offset: 0x4 */
  uint8_t F1;                                      /**< LLWU Flag 1 register, offset: 0x5 */
  uint8_t F2;                                      /**< LLWU Flag 2 register, offset: 0x6 */
  uint8_t F3;                                      /**< LLWU Flag 3 register, offset: 0x7 */
  uint8_t FILT1;                                   /**< LLWU Pin Filter 1 register, offset: 0x8 */
  uint8_t FILT2;                                   /**< LLWU Pin Filter 2 register, offset: 0x9 */
} volatile *LLWU_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- LLWU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Register_Accessor_Macros LLWU - Register accessor macros
 * @{
 */


/* LLWU - Register accessors */
#define LLWU_PE1_REG(base)                       ((base)->PE1)
#define LLWU_PE2_REG(base)                       ((base)->PE2)
#define LLWU_PE3_REG(base)                       ((base)->PE3)
#define LLWU_PE4_REG(base)                       ((base)->PE4)
#define LLWU_ME_REG(base)                        ((base)->ME)
#define LLWU_F1_REG(base)                        ((base)->F1)
#define LLWU_F2_REG(base)                        ((base)->F2)
#define LLWU_F3_REG(base)                        ((base)->F3)
#define LLWU_FILT1_REG(base)                     ((base)->FILT1)
#define LLWU_FILT2_REG(base)                     ((base)->FILT2)

/*!
 * @}
 */ /* end of group LLWU_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- LLWU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Register_Masks LLWU Register Masks
 * @{
 */

/*! @name PE1 - LLWU Pin Enable 1 register */
#define LLWU_PE1_WUPE0_MASK                      (0x3U)
#define LLWU_PE1_WUPE0_SHIFT                     (0U)
#define LLWU_PE1_WUPE0(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE1_WUPE0_SHIFT)) & LLWU_PE1_WUPE0_MASK)
#define LLWU_PE1_WUPE1_MASK                      (0xCU)
#define LLWU_PE1_WUPE1_SHIFT                     (2U)
#define LLWU_PE1_WUPE1(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE1_WUPE1_SHIFT)) & LLWU_PE1_WUPE1_MASK)
#define LLWU_PE1_WUPE2_MASK                      (0x30U)
#define LLWU_PE1_WUPE2_SHIFT                     (4U)
#define LLWU_PE1_WUPE2(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE1_WUPE2_SHIFT)) & LLWU_PE1_WUPE2_MASK)
#define LLWU_PE1_WUPE3_MASK                      (0xC0U)
#define LLWU_PE1_WUPE3_SHIFT                     (6U)
#define LLWU_PE1_WUPE3(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE1_WUPE3_SHIFT)) & LLWU_PE1_WUPE3_MASK)

/*! @name PE2 - LLWU Pin Enable 2 register */
#define LLWU_PE2_WUPE4_MASK                      (0x3U)
#define LLWU_PE2_WUPE4_SHIFT                     (0U)
#define LLWU_PE2_WUPE4(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE2_WUPE4_SHIFT)) & LLWU_PE2_WUPE4_MASK)
#define LLWU_PE2_WUPE5_MASK                      (0xCU)
#define LLWU_PE2_WUPE5_SHIFT                     (2U)
#define LLWU_PE2_WUPE5(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE2_WUPE5_SHIFT)) & LLWU_PE2_WUPE5_MASK)
#define LLWU_PE2_WUPE6_MASK                      (0x30U)
#define LLWU_PE2_WUPE6_SHIFT                     (4U)
#define LLWU_PE2_WUPE6(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE2_WUPE6_SHIFT)) & LLWU_PE2_WUPE6_MASK)
#define LLWU_PE2_WUPE7_MASK                      (0xC0U)
#define LLWU_PE2_WUPE7_SHIFT                     (6U)
#define LLWU_PE2_WUPE7(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE2_WUPE7_SHIFT)) & LLWU_PE2_WUPE7_MASK)

/*! @name PE3 - LLWU Pin Enable 3 register */
#define LLWU_PE3_WUPE8_MASK                      (0x3U)
#define LLWU_PE3_WUPE8_SHIFT                     (0U)
#define LLWU_PE3_WUPE8(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE3_WUPE8_SHIFT)) & LLWU_PE3_WUPE8_MASK)
#define LLWU_PE3_WUPE9_MASK                      (0xCU)
#define LLWU_PE3_WUPE9_SHIFT                     (2U)
#define LLWU_PE3_WUPE9(x)                        (((uint8_t)(((uint8_t)(x)) << LLWU_PE3_WUPE9_SHIFT)) & LLWU_PE3_WUPE9_MASK)
#define LLWU_PE3_WUPE10_MASK                     (0x30U)
#define LLWU_PE3_WUPE10_SHIFT                    (4U)
#define LLWU_PE3_WUPE10(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE3_WUPE10_SHIFT)) & LLWU_PE3_WUPE10_MASK)
#define LLWU_PE3_WUPE11_MASK                     (0xC0U)
#define LLWU_PE3_WUPE11_SHIFT                    (6U)
#define LLWU_PE3_WUPE11(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE3_WUPE11_SHIFT)) & LLWU_PE3_WUPE11_MASK)

/*! @name PE4 - LLWU Pin Enable 4 register */
#define LLWU_PE4_WUPE12_MASK                     (0x3U)
#define LLWU_PE4_WUPE12_SHIFT                    (0U)
#define LLWU_PE4_WUPE12(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE4_WUPE12_SHIFT)) & LLWU_PE4_WUPE12_MASK)
#define LLWU_PE4_WUPE13_MASK                     (0xCU)
#define LLWU_PE4_WUPE13_SHIFT                    (2U)
#define LLWU_PE4_WUPE13(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE4_WUPE13_SHIFT)) & LLWU_PE4_WUPE13_MASK)
#define LLWU_PE4_WUPE14_MASK                     (0x30U)
#define LLWU_PE4_WUPE14_SHIFT                    (4U)
#define LLWU_PE4_WUPE14(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE4_WUPE14_SHIFT)) & LLWU_PE4_WUPE14_MASK)
#define LLWU_PE4_WUPE15_MASK                     (0xC0U)
#define LLWU_PE4_WUPE15_SHIFT                    (6U)
#define LLWU_PE4_WUPE15(x)                       (((uint8_t)(((uint8_t)(x)) << LLWU_PE4_WUPE15_SHIFT)) & LLWU_PE4_WUPE15_MASK)

/*! @name ME - LLWU Module Enable register */
#define LLWU_ME_WUME0_MASK                       (0x1U)
#define LLWU_ME_WUME0_SHIFT                      (0U)
#define LLWU_ME_WUME1_MASK                       (0x2U)
#define LLWU_ME_WUME1_SHIFT                      (1U)
#define LLWU_ME_WUME2_MASK                       (0x4U)
#define LLWU_ME_WUME2_SHIFT                      (2U)
#define LLWU_ME_WUME3_MASK                       (0x8U)
#define LLWU_ME_WUME3_SHIFT                      (3U)
#define LLWU_ME_WUME4_MASK                       (0x10U)
#define LLWU_ME_WUME4_SHIFT                      (4U)
#define LLWU_ME_WUME5_MASK                       (0x20U)
#define LLWU_ME_WUME5_SHIFT                      (5U)
#define LLWU_ME_WUME6_MASK                       (0x40U)
#define LLWU_ME_WUME6_SHIFT                      (6U)
#define LLWU_ME_WUME7_MASK                       (0x80U)
#define LLWU_ME_WUME7_SHIFT                      (7U)

/*! @name F1 - LLWU Flag 1 register */
#define LLWU_F1_WUF0_MASK                        (0x1U)
#define LLWU_F1_WUF0_SHIFT                       (0U)
#define LLWU_F1_WUF1_MASK                        (0x2U)
#define LLWU_F1_WUF1_SHIFT                       (1U)
#define LLWU_F1_WUF2_MASK                        (0x4U)
#define LLWU_F1_WUF2_SHIFT                       (2U)
#define LLWU_F1_WUF3_MASK                        (0x8U)
#define LLWU_F1_WUF3_SHIFT                       (3U)
#define LLWU_F1_WUF4_MASK                        (0x10U)
#define LLWU_F1_WUF4_SHIFT                       (4U)
#define LLWU_F1_WUF5_MASK                        (0x20U)
#define LLWU_F1_WUF5_SHIFT                       (5U)
#define LLWU_F1_WUF6_MASK                        (0x40U)
#define LLWU_F1_WUF6_SHIFT                       (6U)
#define LLWU_F1_WUF7_MASK                        (0x80U)
#define LLWU_F1_WUF7_SHIFT                       (7U)

/*! @name F2 - LLWU Flag 2 register */
#define LLWU_F2_WUF8_MASK                        (0x1U)
#define LLWU_F2_WUF8_SHIFT                       (0U)
#define LLWU_F2_WUF9_MASK                        (0x2U)
#define LLWU_F2_WUF9_SHIFT                       (1U)
#define LLWU_F2_WUF10_MASK                       (0x4U)
#define LLWU_F2_WUF10_SHIFT                      (2U)
#define LLWU_F2_WUF11_MASK                       (0x8U)
#define LLWU_F2_WUF11_SHIFT                      (3U)
#define LLWU_F2_WUF12_MASK                       (0x10U)
#define LLWU_F2_WUF12_SHIFT                      (4U)
#define LLWU_F2_WUF13_MASK                       (0x20U)
#define LLWU_F2_WUF13_SHIFT                      (5U)
#define LLWU_F2_WUF14_MASK                       (0x40U)
#define LLWU_F2_WUF14_SHIFT                      (6U)
#define LLWU_F2_WUF15_MASK                       (0x80U)
#define LLWU_F2_WUF15_SHIFT                      (7U)

/*! @name F3 - LLWU Flag 3 register */
#define LLWU_F3_MWUF0_MASK                       (0x1U)
#define LLWU_F3_MWUF0_SHIFT                      (0U)
#define LLWU_F3_MWUF1_MASK                       (0x2U)
#define LLWU_F3_MWUF1_SHIFT                      (1U)
#define LLWU_F3_MWUF2_MASK                       (0x4U)
#define LLWU_F3_MWUF2_SHIFT                      (2U)
#define LLWU_F3_MWUF3_MASK                       (0x8U)
#define LLWU_F3_MWUF3_SHIFT                      (3U)
#define LLWU_F3_MWUF4_MASK                       (0x10U)
#define LLWU_F3_MWUF4_SHIFT                      (4U)
#define LLWU_F3_MWUF5_MASK                       (0x20U)
#define LLWU_F3_MWUF5_SHIFT                      (5U)
#define LLWU_F3_MWUF6_MASK                       (0x40U)
#define LLWU_F3_MWUF6_SHIFT                      (6U)
#define LLWU_F3_MWUF7_MASK                       (0x80U)
#define LLWU_F3_MWUF7_SHIFT                      (7U)

/*! @name FILT1 - LLWU Pin Filter 1 register */
#define LLWU_FILT1_FILTSEL_MASK                  (0xFU)
#define LLWU_FILT1_FILTSEL_SHIFT                 (0U)
#define LLWU_FILT1_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x)) << LLWU_FILT1_FILTSEL_SHIFT)) & LLWU_FILT1_FILTSEL_MASK)
#define LLWU_FILT1_FILTE_MASK                    (0x60U)
#define LLWU_FILT1_FILTE_SHIFT                   (5U)
#define LLWU_FILT1_FILTE(x)                      (((uint8_t)(((uint8_t)(x)) << LLWU_FILT1_FILTE_SHIFT)) & LLWU_FILT1_FILTE_MASK)
#define LLWU_FILT1_FILTF_MASK                    (0x80U)
#define LLWU_FILT1_FILTF_SHIFT                   (7U)

/*! @name FILT2 - LLWU Pin Filter 2 register */
#define LLWU_FILT2_FILTSEL_MASK                  (0xFU)
#define LLWU_FILT2_FILTSEL_SHIFT                 (0U)
#define LLWU_FILT2_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x)) << LLWU_FILT2_FILTSEL_SHIFT)) & LLWU_FILT2_FILTSEL_MASK)
#define LLWU_FILT2_FILTE_MASK                    (0x60U)
#define LLWU_FILT2_FILTE_SHIFT                   (5U)
#define LLWU_FILT2_FILTE(x)                      (((uint8_t)(((uint8_t)(x)) << LLWU_FILT2_FILTE_SHIFT)) & LLWU_FILT2_FILTE_MASK)
#define LLWU_FILT2_FILTF_MASK                    (0x80U)
#define LLWU_FILT2_FILTF_SHIFT                   (7U)


/*!
 * @}
 */ /* end of group LLWU_Register_Masks */


/* LLWU - Peripheral instance base addresses */
/** Peripheral LLWU base pointer */
#define LLWU_BASE_PTR                            ((LLWU_MemMapPtr)0x4007C000u)
/** Array initializer of LLWU peripheral base pointers */
#define LLWU_BASE_PTRS                           { LLWU_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- LLWU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Register_Accessor_Macros LLWU - Register accessor macros
 * @{
 */


/* LLWU - Register instance definitions */
/* LLWU */
#define LLWU_PE1                                 LLWU_PE1_REG(LLWU_BASE_PTR)
#define LLWU_PE2                                 LLWU_PE2_REG(LLWU_BASE_PTR)
#define LLWU_PE3                                 LLWU_PE3_REG(LLWU_BASE_PTR)
#define LLWU_PE4                                 LLWU_PE4_REG(LLWU_BASE_PTR)
#define LLWU_ME                                  LLWU_ME_REG(LLWU_BASE_PTR)
#define LLWU_F1                                  LLWU_F1_REG(LLWU_BASE_PTR)
#define LLWU_F2                                  LLWU_F2_REG(LLWU_BASE_PTR)
#define LLWU_F3                                  LLWU_F3_REG(LLWU_BASE_PTR)
#define LLWU_FILT1                               LLWU_FILT1_REG(LLWU_BASE_PTR)
#define LLWU_FILT2                               LLWU_FILT2_REG(LLWU_BASE_PTR)

/*!
 * @}
 */ /* end of group LLWU_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group LLWU_Peripheral */


/* ----------------------------------------------------------------------------
   -- LPTMR
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Peripheral LPTMR
 * @{
 */

/** LPTMR - Peripheral register structure */
typedef struct LPTMR_MemMap {
  uint32_t CSR;                                    /**< Low Power Timer Control Status Register, offset: 0x0 */
  uint32_t PSR;                                    /**< Low Power Timer Prescale Register, offset: 0x4 */
  uint32_t CMR;                                    /**< Low Power Timer Compare Register, offset: 0x8 */
  uint32_t CNR;                                    /**< Low Power Timer Counter Register, offset: 0xC */
} volatile *LPTMR_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- LPTMR - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Register_Accessor_Macros LPTMR - Register accessor macros
 * @{
 */


/* LPTMR - Register accessors */
#define LPTMR_CSR_REG(base)                      ((base)->CSR)
#define LPTMR_PSR_REG(base)                      ((base)->PSR)
#define LPTMR_CMR_REG(base)                      ((base)->CMR)
#define LPTMR_CNR_REG(base)                      ((base)->CNR)

/*!
 * @}
 */ /* end of group LPTMR_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- LPTMR Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Register_Masks LPTMR Register Masks
 * @{
 */

/*! @name CSR - Low Power Timer Control Status Register */
#define LPTMR_CSR_TEN_MASK                       (0x1U)
#define LPTMR_CSR_TEN_SHIFT                      (0U)
#define LPTMR_CSR_TMS_MASK                       (0x2U)
#define LPTMR_CSR_TMS_SHIFT                      (1U)
#define LPTMR_CSR_TFC_MASK                       (0x4U)
#define LPTMR_CSR_TFC_SHIFT                      (2U)
#define LPTMR_CSR_TPP_MASK                       (0x8U)
#define LPTMR_CSR_TPP_SHIFT                      (3U)
#define LPTMR_CSR_TPS_MASK                       (0x30U)
#define LPTMR_CSR_TPS_SHIFT                      (4U)
#define LPTMR_CSR_TPS(x)                         (((uint32_t)(((uint32_t)(x)) << LPTMR_CSR_TPS_SHIFT)) & LPTMR_CSR_TPS_MASK)
#define LPTMR_CSR_TIE_MASK                       (0x40U)
#define LPTMR_CSR_TIE_SHIFT                      (6U)
#define LPTMR_CSR_TCF_MASK                       (0x80U)
#define LPTMR_CSR_TCF_SHIFT                      (7U)

/*! @name PSR - Low Power Timer Prescale Register */
#define LPTMR_PSR_PCS_MASK                       (0x3U)
#define LPTMR_PSR_PCS_SHIFT                      (0U)
#define LPTMR_PSR_PCS(x)                         (((uint32_t)(((uint32_t)(x)) << LPTMR_PSR_PCS_SHIFT)) & LPTMR_PSR_PCS_MASK)
#define LPTMR_PSR_PBYP_MASK                      (0x4U)
#define LPTMR_PSR_PBYP_SHIFT                     (2U)
#define LPTMR_PSR_PRESCALE_MASK                  (0x78U)
#define LPTMR_PSR_PRESCALE_SHIFT                 (3U)
#define LPTMR_PSR_PRESCALE(x)                    (((uint32_t)(((uint32_t)(x)) << LPTMR_PSR_PRESCALE_SHIFT)) & LPTMR_PSR_PRESCALE_MASK)

/*! @name CMR - Low Power Timer Compare Register */
#define LPTMR_CMR_COMPARE_MASK                   (0xFFFFU)
#define LPTMR_CMR_COMPARE_SHIFT                  (0U)
#define LPTMR_CMR_COMPARE(x)                     (((uint32_t)(((uint32_t)(x)) << LPTMR_CMR_COMPARE_SHIFT)) & LPTMR_CMR_COMPARE_MASK)

/*! @name CNR - Low Power Timer Counter Register */
#define LPTMR_CNR_COUNTER_MASK                   (0xFFFFU)
#define LPTMR_CNR_COUNTER_SHIFT                  (0U)
#define LPTMR_CNR_COUNTER(x)                     (((uint32_t)(((uint32_t)(x)) << LPTMR_CNR_COUNTER_SHIFT)) & LPTMR_CNR_COUNTER_MASK)


/*!
 * @}
 */ /* end of group LPTMR_Register_Masks */


/* LPTMR - Peripheral instance base addresses */
/** Peripheral LPTMR0 base pointer */
#define LPTMR0_BASE_PTR                          ((LPTMR_MemMapPtr)0x40040000u)
/** Array initializer of LPTMR peripheral base pointers */
#define LPTMR_BASE_PTRS                          { LPTMR0_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- LPTMR - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Register_Accessor_Macros LPTMR - Register accessor macros
 * @{
 */


/* LPTMR - Register instance definitions */
/* LPTMR0 */
#define LPTMR0_CSR                               LPTMR_CSR_REG(LPTMR0_BASE_PTR)
#define LPTMR0_PSR                               LPTMR_PSR_REG(LPTMR0_BASE_PTR)
#define LPTMR0_CMR                               LPTMR_CMR_REG(LPTMR0_BASE_PTR)
#define LPTMR0_CNR                               LPTMR_CNR_REG(LPTMR0_BASE_PTR)

/*!
 * @}
 */ /* end of group LPTMR_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group LPTMR_Peripheral */


/* ----------------------------------------------------------------------------
   -- LPUART
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPUART_Peripheral LPUART
 * @{
 */

/** LPUART - Peripheral register structure */
typedef struct LPUART_MemMap {
  uint32_t BAUD;                                   /**< LPUART Baud Rate Register, offset: 0x0 */
  uint32_t STAT;                                   /**< LPUART Status Register, offset: 0x4 */
  uint32_t CTRL;                                   /**< LPUART Control Register, offset: 0x8 */
  uint32_t DATA;                                   /**< LPUART Data Register, offset: 0xC */
  uint32_t MATCH;                                  /**< LPUART Match Address Register, offset: 0x10 */
} volatile *LPUART_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- LPUART - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPUART_Register_Accessor_Macros LPUART - Register accessor macros
 * @{
 */


/* LPUART - Register accessors */
#define LPUART_BAUD_REG(base)                    ((base)->BAUD)
#define LPUART_STAT_REG(base)                    ((base)->STAT)
#define LPUART_CTRL_REG(base)                    ((base)->CTRL)
#define LPUART_DATA_REG(base)                    ((base)->DATA)
#define LPUART_MATCH_REG(base)                   ((base)->MATCH)

/*!
 * @}
 */ /* end of group LPUART_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- LPUART Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPUART_Register_Masks LPUART Register Masks
 * @{
 */

/*! @name BAUD - LPUART Baud Rate Register */
#define LPUART_BAUD_SBR_MASK                     (0x1FFFU)
#define LPUART_BAUD_SBR_SHIFT                    (0U)
#define LPUART_BAUD_SBR(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_SBR_SHIFT)) & LPUART_BAUD_SBR_MASK)
#define LPUART_BAUD_SBNS_MASK                    (0x2000U)
#define LPUART_BAUD_SBNS_SHIFT                   (13U)
#define LPUART_BAUD_RXEDGIE_MASK                 (0x4000U)
#define LPUART_BAUD_RXEDGIE_SHIFT                (14U)
#define LPUART_BAUD_LBKDIE_MASK                  (0x8000U)
#define LPUART_BAUD_LBKDIE_SHIFT                 (15U)
#define LPUART_BAUD_RESYNCDIS_MASK               (0x10000U)
#define LPUART_BAUD_RESYNCDIS_SHIFT              (16U)
#define LPUART_BAUD_BOTHEDGE_MASK                (0x20000U)
#define LPUART_BAUD_BOTHEDGE_SHIFT               (17U)
#define LPUART_BAUD_MATCFG_MASK                  (0xC0000U)
#define LPUART_BAUD_MATCFG_SHIFT                 (18U)
#define LPUART_BAUD_MATCFG(x)                    (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_MATCFG_SHIFT)) & LPUART_BAUD_MATCFG_MASK)
#define LPUART_BAUD_RDMAE_MASK                   (0x200000U)
#define LPUART_BAUD_RDMAE_SHIFT                  (21U)
#define LPUART_BAUD_TDMAE_MASK                   (0x800000U)
#define LPUART_BAUD_TDMAE_SHIFT                  (23U)
#define LPUART_BAUD_OSR_MASK                     (0x1F000000U)
#define LPUART_BAUD_OSR_SHIFT                    (24U)
#define LPUART_BAUD_OSR(x)                       (((uint32_t)(((uint32_t)(x)) << LPUART_BAUD_OSR_SHIFT)) & LPUART_BAUD_OSR_MASK)
#define LPUART_BAUD_M10_MASK                     (0x20000000U)
#define LPUART_BAUD_M10_SHIFT                    (29U)
#define LPUART_BAUD_MAEN2_MASK                   (0x40000000U)
#define LPUART_BAUD_MAEN2_SHIFT                  (30U)
#define LPUART_BAUD_MAEN1_MASK                   (0x80000000U)
#define LPUART_BAUD_MAEN1_SHIFT                  (31U)

/*! @name STAT - LPUART Status Register */
#define LPUART_STAT_MA2F_MASK                    (0x4000U)
#define LPUART_STAT_MA2F_SHIFT                   (14U)
#define LPUART_STAT_MA1F_MASK                    (0x8000U)
#define LPUART_STAT_MA1F_SHIFT                   (15U)
#define LPUART_STAT_PF_MASK                      (0x10000U)
#define LPUART_STAT_PF_SHIFT                     (16U)
#define LPUART_STAT_FE_MASK                      (0x20000U)
#define LPUART_STAT_FE_SHIFT                     (17U)
#define LPUART_STAT_NF_MASK                      (0x40000U)
#define LPUART_STAT_NF_SHIFT                     (18U)
#define LPUART_STAT_OR_MASK                      (0x80000U)
#define LPUART_STAT_OR_SHIFT                     (19U)
#define LPUART_STAT_IDLE_MASK                    (0x100000U)
#define LPUART_STAT_IDLE_SHIFT                   (20U)
#define LPUART_STAT_RDRF_MASK                    (0x200000U)
#define LPUART_STAT_RDRF_SHIFT                   (21U)
#define LPUART_STAT_TC_MASK                      (0x400000U)
#define LPUART_STAT_TC_SHIFT                     (22U)
#define LPUART_STAT_TDRE_MASK                    (0x800000U)
#define LPUART_STAT_TDRE_SHIFT                   (23U)
#define LPUART_STAT_RAF_MASK                     (0x1000000U)
#define LPUART_STAT_RAF_SHIFT                    (24U)
#define LPUART_STAT_LBKDE_MASK                   (0x2000000U)
#define LPUART_STAT_LBKDE_SHIFT                  (25U)
#define LPUART_STAT_BRK13_MASK                   (0x4000000U)
#define LPUART_STAT_BRK13_SHIFT                  (26U)
#define LPUART_STAT_RWUID_MASK                   (0x8000000U)
#define LPUART_STAT_RWUID_SHIFT                  (27U)
#define LPUART_STAT_RXINV_MASK                   (0x10000000U)
#define LPUART_STAT_RXINV_SHIFT                  (28U)
#define LPUART_STAT_MSBF_MASK                    (0x20000000U)
#define LPUART_STAT_MSBF_SHIFT                   (29U)
#define LPUART_STAT_RXEDGIF_MASK                 (0x40000000U)
#define LPUART_STAT_RXEDGIF_SHIFT                (30U)
#define LPUART_STAT_LBKDIF_MASK                  (0x80000000U)
#define LPUART_STAT_LBKDIF_SHIFT                 (31U)

/*! @name CTRL - LPUART Control Register */
#define LPUART_CTRL_PT_MASK                      (0x1U)
#define LPUART_CTRL_PT_SHIFT                     (0U)
#define LPUART_CTRL_PE_MASK                      (0x2U)
#define LPUART_CTRL_PE_SHIFT                     (1U)
#define LPUART_CTRL_ILT_MASK                     (0x4U)
#define LPUART_CTRL_ILT_SHIFT                    (2U)
#define LPUART_CTRL_WAKE_MASK                    (0x8U)
#define LPUART_CTRL_WAKE_SHIFT                   (3U)
#define LPUART_CTRL_M_MASK                       (0x10U)
#define LPUART_CTRL_M_SHIFT                      (4U)
#define LPUART_CTRL_RSRC_MASK                    (0x20U)
#define LPUART_CTRL_RSRC_SHIFT                   (5U)
#define LPUART_CTRL_DOZEEN_MASK                  (0x40U)
#define LPUART_CTRL_DOZEEN_SHIFT                 (6U)
#define LPUART_CTRL_LOOPS_MASK                   (0x80U)
#define LPUART_CTRL_LOOPS_SHIFT                  (7U)
#define LPUART_CTRL_IDLECFG_MASK                 (0x700U)
#define LPUART_CTRL_IDLECFG_SHIFT                (8U)
#define LPUART_CTRL_IDLECFG(x)                   (((uint32_t)(((uint32_t)(x)) << LPUART_CTRL_IDLECFG_SHIFT)) & LPUART_CTRL_IDLECFG_MASK)
#define LPUART_CTRL_MA2IE_MASK                   (0x4000U)
#define LPUART_CTRL_MA2IE_SHIFT                  (14U)
#define LPUART_CTRL_MA1IE_MASK                   (0x8000U)
#define LPUART_CTRL_MA1IE_SHIFT                  (15U)
#define LPUART_CTRL_SBK_MASK                     (0x10000U)
#define LPUART_CTRL_SBK_SHIFT                    (16U)
#define LPUART_CTRL_RWU_MASK                     (0x20000U)
#define LPUART_CTRL_RWU_SHIFT                    (17U)
#define LPUART_CTRL_RE_MASK                      (0x40000U)
#define LPUART_CTRL_RE_SHIFT                     (18U)
#define LPUART_CTRL_TE_MASK                      (0x80000U)
#define LPUART_CTRL_TE_SHIFT                     (19U)
#define LPUART_CTRL_ILIE_MASK                    (0x100000U)
#define LPUART_CTRL_ILIE_SHIFT                   (20U)
#define LPUART_CTRL_RIE_MASK                     (0x200000U)
#define LPUART_CTRL_RIE_SHIFT                    (21U)
#define LPUART_CTRL_TCIE_MASK                    (0x400000U)
#define LPUART_CTRL_TCIE_SHIFT                   (22U)
#define LPUART_CTRL_TIE_MASK                     (0x800000U)
#define LPUART_CTRL_TIE_SHIFT                    (23U)
#define LPUART_CTRL_PEIE_MASK                    (0x1000000U)
#define LPUART_CTRL_PEIE_SHIFT                   (24U)
#define LPUART_CTRL_FEIE_MASK                    (0x2000000U)
#define LPUART_CTRL_FEIE_SHIFT                   (25U)
#define LPUART_CTRL_NEIE_MASK                    (0x4000000U)
#define LPUART_CTRL_NEIE_SHIFT                   (26U)
#define LPUART_CTRL_ORIE_MASK                    (0x8000000U)
#define LPUART_CTRL_ORIE_SHIFT                   (27U)
#define LPUART_CTRL_TXINV_MASK                   (0x10000000U)
#define LPUART_CTRL_TXINV_SHIFT                  (28U)
#define LPUART_CTRL_TXDIR_MASK                   (0x20000000U)
#define LPUART_CTRL_TXDIR_SHIFT                  (29U)
#define LPUART_CTRL_R9T8_MASK                    (0x40000000U)
#define LPUART_CTRL_R9T8_SHIFT                   (30U)
#define LPUART_CTRL_R8T9_MASK                    (0x80000000U)
#define LPUART_CTRL_R8T9_SHIFT                   (31U)

/*! @name DATA - LPUART Data Register */
#define LPUART_DATA_R0T0_MASK                    (0x1U)
#define LPUART_DATA_R0T0_SHIFT                   (0U)
#define LPUART_DATA_R1T1_MASK                    (0x2U)
#define LPUART_DATA_R1T1_SHIFT                   (1U)
#define LPUART_DATA_R2T2_MASK                    (0x4U)
#define LPUART_DATA_R2T2_SHIFT                   (2U)
#define LPUART_DATA_R3T3_MASK                    (0x8U)
#define LPUART_DATA_R3T3_SHIFT                   (3U)
#define LPUART_DATA_R4T4_MASK                    (0x10U)
#define LPUART_DATA_R4T4_SHIFT                   (4U)
#define LPUART_DATA_R5T5_MASK                    (0x20U)
#define LPUART_DATA_R5T5_SHIFT                   (5U)
#define LPUART_DATA_R6T6_MASK                    (0x40U)
#define LPUART_DATA_R6T6_SHIFT                   (6U)
#define LPUART_DATA_R7T7_MASK                    (0x80U)
#define LPUART_DATA_R7T7_SHIFT                   (7U)
#define LPUART_DATA_R8T8_MASK                    (0x100U)
#define LPUART_DATA_R8T8_SHIFT                   (8U)
#define LPUART_DATA_R9T9_MASK                    (0x200U)
#define LPUART_DATA_R9T9_SHIFT                   (9U)
#define LPUART_DATA_IDLINE_MASK                  (0x800U)
#define LPUART_DATA_IDLINE_SHIFT                 (11U)
#define LPUART_DATA_RXEMPT_MASK                  (0x1000U)
#define LPUART_DATA_RXEMPT_SHIFT                 (12U)
#define LPUART_DATA_FRETSC_MASK                  (0x2000U)
#define LPUART_DATA_FRETSC_SHIFT                 (13U)
#define LPUART_DATA_PARITYE_MASK                 (0x4000U)
#define LPUART_DATA_PARITYE_SHIFT                (14U)
#define LPUART_DATA_NOISY_MASK                   (0x8000U)
#define LPUART_DATA_NOISY_SHIFT                  (15U)

/*! @name MATCH - LPUART Match Address Register */
#define LPUART_MATCH_MA1_MASK                    (0x3FFU)
#define LPUART_MATCH_MA1_SHIFT                   (0U)
#define LPUART_MATCH_MA1(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_MATCH_MA1_SHIFT)) & LPUART_MATCH_MA1_MASK)
#define LPUART_MATCH_MA2_MASK                    (0x3FF0000U)
#define LPUART_MATCH_MA2_SHIFT                   (16U)
#define LPUART_MATCH_MA2(x)                      (((uint32_t)(((uint32_t)(x)) << LPUART_MATCH_MA2_SHIFT)) & LPUART_MATCH_MA2_MASK)


/*!
 * @}
 */ /* end of group LPUART_Register_Masks */


/* LPUART - Peripheral instance base addresses */
/** Peripheral LPUART0 base pointer */
#define LPUART0_BASE_PTR                         ((LPUART_MemMapPtr)0x40054000u)
/** Array initializer of LPUART peripheral base pointers */
#define LPUART_BASE_PTRS                         { LPUART0_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- LPUART - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPUART_Register_Accessor_Macros LPUART - Register accessor macros
 * @{
 */


/* LPUART - Register instance definitions */
/* LPUART0 */
#define LPUART0_BAUD                             LPUART_BAUD_REG(LPUART0_BASE_PTR)
#define LPUART0_STAT                             LPUART_STAT_REG(LPUART0_BASE_PTR)
#define LPUART0_CTRL                             LPUART_CTRL_REG(LPUART0_BASE_PTR)
#define LPUART0_DATA                             LPUART_DATA_REG(LPUART0_BASE_PTR)
#define LPUART0_MATCH                            LPUART_MATCH_REG(LPUART0_BASE_PTR)

/*!
 * @}
 */ /* end of group LPUART_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group LPUART_Peripheral */


/* ----------------------------------------------------------------------------
   -- LTC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LTC_Peripheral LTC
 * @{
 */

/** LTC - Peripheral register structure */
typedef struct LTC_MemMap {
  union {                                          /* offset: 0x0 */
    uint32_t MD;                                     /**< LTC Mode Register, offset: 0x0 */
  };
  uint8_t RESERVED_0[4];
  uint32_t KS;                                     /**< LTC Key Size Register, offset: 0x8 */
  uint8_t RESERVED_1[4];
  uint32_t DS;                                     /**< LTC Data Size Register, offset: 0x10 */
  uint8_t RESERVED_2[4];
  uint32_t ICVS;                                   /**< LTC ICV Size Register, offset: 0x18 */
  uint8_t RESERVED_3[20];
  uint32_t COM;                                    /**< LTC Command Register, offset: 0x30 */
  uint32_t CTL;                                    /**< LTC Control Register, offset: 0x34 */
  uint8_t RESERVED_4[8];
  uint32_t CW;                                     /**< LTC Clear Written Register, offset: 0x40 */
  uint8_t RESERVED_5[4];
  uint32_t STA;                                    /**< LTC Status Register, offset: 0x48 */
  uint32_t ESTA;                                   /**< LTC Error Status Register, offset: 0x4C */
  uint8_t RESERVED_6[8];
  uint32_t AADSZ;                                  /**< LTC AAD Size Register, offset: 0x58 */
  uint8_t RESERVED_7[164];
  uint32_t CTX[14];                                /**< LTC Context Register, array offset: 0x100, array step: 0x4 */
  uint8_t RESERVED_8[200];
  uint32_t KEY[4];                                 /**< LTC Key Registers, array offset: 0x200, array step: 0x4 */
  uint8_t RESERVED_9[736];
  uint32_t VID1;                                   /**< LTC Version ID Register, offset: 0x4F0 */
  uint32_t VID2;                                   /**< LTC Version ID 2 Register, offset: 0x4F4 */
  uint32_t CHAVID;                                 /**< LTC CHA Version ID Register, offset: 0x4F8 */
  uint8_t RESERVED_10[708];
  uint32_t FIFOSTA;                                /**< LTC FIFO Status Register, offset: 0x7C0 */
  uint8_t RESERVED_11[28];
  uint32_t IFIFO;                                  /**< LTC Input Data FIFO, offset: 0x7E0 */
  uint8_t RESERVED_12[12];
  uint32_t OFIFO;                                  /**< LTC Output Data FIFO, offset: 0x7F0 */
} volatile *LTC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- LTC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LTC_Register_Accessor_Macros LTC - Register accessor macros
 * @{
 */


/* LTC - Register accessors */
#define LTC_MD_REG(base)                         ((base)->MD)
#define LTC_KS_REG(base)                         ((base)->KS)
#define LTC_DS_REG(base)                         ((base)->DS)
#define LTC_ICVS_REG(base)                       ((base)->ICVS)
#define LTC_COM_REG(base)                        ((base)->COM)
#define LTC_CTL_REG(base)                        ((base)->CTL)
#define LTC_CW_REG(base)                         ((base)->CW)
#define LTC_STA_REG(base)                        ((base)->STA)
#define LTC_ESTA_REG(base)                       ((base)->ESTA)
#define LTC_AADSZ_REG(base)                      ((base)->AADSZ)
#define LTC_CTX_REG(base,index)                  ((base)->CTX[index])
#define LTC_KEY_REG(base,index)                  ((base)->KEY[index])
#define LTC_VID1_REG(base)                       ((base)->VID1)
#define LTC_VID2_REG(base)                       ((base)->VID2)
#define LTC_CHAVID_REG(base)                     ((base)->CHAVID)
#define LTC_FIFOSTA_REG(base)                    ((base)->FIFOSTA)
#define LTC_IFIFO_REG(base)                      ((base)->IFIFO)
#define LTC_OFIFO_REG(base)                      ((base)->OFIFO)

/*!
 * @}
 */ /* end of group LTC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- LTC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LTC_Register_Masks LTC Register Masks
 * @{
 */

/*! @name MD - LTC Mode Register */
#define LTC_MD_ENC_MASK                          (0x1U)
#define LTC_MD_ENC_SHIFT                         (0U)
#define LTC_MD_ICV_TEST_MASK                     (0x2U)
#define LTC_MD_ICV_TEST_SHIFT                    (1U)
#define LTC_MD_AS_MASK                           (0xCU)
#define LTC_MD_AS_SHIFT                          (2U)
#define LTC_MD_AS(x)                             (((uint32_t)(((uint32_t)(x)) << LTC_MD_AS_SHIFT)) & LTC_MD_AS_MASK)
#define LTC_MD_AAI_MASK                          (0x1FF0U)
#define LTC_MD_AAI_SHIFT                         (4U)
#define LTC_MD_AAI(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_MD_AAI_SHIFT)) & LTC_MD_AAI_MASK)
#define LTC_MD_ALG_MASK                          (0xFF0000U)
#define LTC_MD_ALG_SHIFT                         (16U)
#define LTC_MD_ALG(x)                            (((uint32_t)(((uint32_t)(x)) << LTC_MD_ALG_SHIFT)) & LTC_MD_ALG_MASK)

/*! @name KS - LTC Key Size Register */
#define LTC_KS_KS_MASK                           (0x1FU)
#define LTC_KS_KS_SHIFT                          (0U)
#define LTC_KS_KS(x)                             (((uint32_t)(((uint32_t)(x)) << LTC_KS_KS_SHIFT)) & LTC_KS_KS_MASK)

/*! @name DS - LTC Data Size Register */
#define LTC_DS_DS_MASK                           (0xFFFU)
#define LTC_DS_DS_SHIFT                          (0U)
#define LTC_DS_DS(x)                             (((uint32_t)(((uint32_t)(x)) << LTC_DS_DS_SHIFT)) & LTC_DS_DS_MASK)

/*! @name ICVS - LTC ICV Size Register */
#define LTC_ICVS_ICVS_MASK                       (0x1FU)
#define LTC_ICVS_ICVS_SHIFT                      (0U)
#define LTC_ICVS_ICVS(x)                         (((uint32_t)(((uint32_t)(x)) << LTC_ICVS_ICVS_SHIFT)) & LTC_ICVS_ICVS_MASK)

/*! @name COM - LTC Command Register */
#define LTC_COM_ALL_MASK                         (0x1U)
#define LTC_COM_ALL_SHIFT                        (0U)
#define LTC_COM_AES_MASK                         (0x2U)
#define LTC_COM_AES_SHIFT                        (1U)

/*! @name CTL - LTC Control Register */
#define LTC_CTL_IM_MASK                          (0x1U)
#define LTC_CTL_IM_SHIFT                         (0U)
#define LTC_CTL_IFE_MASK                         (0x100U)
#define LTC_CTL_IFE_SHIFT                        (8U)
#define LTC_CTL_IFR_MASK                         (0x200U)
#define LTC_CTL_IFR_SHIFT                        (9U)
#define LTC_CTL_OFE_MASK                         (0x1000U)
#define LTC_CTL_OFE_SHIFT                        (12U)
#define LTC_CTL_OFR_MASK                         (0x2000U)
#define LTC_CTL_OFR_SHIFT                        (13U)
#define LTC_CTL_IFS_MASK                         (0x10000U)
#define LTC_CTL_IFS_SHIFT                        (16U)
#define LTC_CTL_OFS_MASK                         (0x20000U)
#define LTC_CTL_OFS_SHIFT                        (17U)
#define LTC_CTL_KIS_MASK                         (0x100000U)
#define LTC_CTL_KIS_SHIFT                        (20U)
#define LTC_CTL_KOS_MASK                         (0x200000U)
#define LTC_CTL_KOS_SHIFT                        (21U)
#define LTC_CTL_CIS_MASK                         (0x400000U)
#define LTC_CTL_CIS_SHIFT                        (22U)
#define LTC_CTL_COS_MASK                         (0x800000U)
#define LTC_CTL_COS_SHIFT                        (23U)
#define LTC_CTL_KAL_MASK                         (0x80000000U)
#define LTC_CTL_KAL_SHIFT                        (31U)

/*! @name CW - LTC Clear Written Register */
#define LTC_CW_CM_MASK                           (0x1U)
#define LTC_CW_CM_SHIFT                          (0U)
#define LTC_CW_CDS_MASK                          (0x4U)
#define LTC_CW_CDS_SHIFT                         (2U)
#define LTC_CW_CICV_MASK                         (0x8U)
#define LTC_CW_CICV_SHIFT                        (3U)
#define LTC_CW_CCR_MASK                          (0x20U)
#define LTC_CW_CCR_SHIFT                         (5U)
#define LTC_CW_CKR_MASK                          (0x40U)
#define LTC_CW_CKR_SHIFT                         (6U)
#define LTC_CW_COF_MASK                          (0x40000000U)
#define LTC_CW_COF_SHIFT                         (30U)
#define LTC_CW_CIF_MASK                          (0x80000000U)
#define LTC_CW_CIF_SHIFT                         (31U)

/*! @name STA - LTC Status Register */
#define LTC_STA_AB_MASK                          (0x2U)
#define LTC_STA_AB_SHIFT                         (1U)
#define LTC_STA_DI_MASK                          (0x10000U)
#define LTC_STA_DI_SHIFT                         (16U)
#define LTC_STA_EI_MASK                          (0x100000U)
#define LTC_STA_EI_SHIFT                         (20U)

/*! @name ESTA - LTC Error Status Register */
#define LTC_ESTA_ERRID1_MASK                     (0xFU)
#define LTC_ESTA_ERRID1_SHIFT                    (0U)
#define LTC_ESTA_ERRID1(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_ESTA_ERRID1_SHIFT)) & LTC_ESTA_ERRID1_MASK)
#define LTC_ESTA_CL1_MASK                        (0xF00U)
#define LTC_ESTA_CL1_SHIFT                       (8U)
#define LTC_ESTA_CL1(x)                          (((uint32_t)(((uint32_t)(x)) << LTC_ESTA_CL1_SHIFT)) & LTC_ESTA_CL1_MASK)

/*! @name AADSZ - LTC AAD Size Register */
#define LTC_AADSZ_AADSZ_MASK                     (0xFU)
#define LTC_AADSZ_AADSZ_SHIFT                    (0U)
#define LTC_AADSZ_AADSZ(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_AADSZ_AADSZ_SHIFT)) & LTC_AADSZ_AADSZ_MASK)
#define LTC_AADSZ_AL_MASK                        (0x80000000U)
#define LTC_AADSZ_AL_SHIFT                       (31U)

/*! @name CTX - LTC Context Register */
#define LTC_CTX_CTX_MASK                         (0xFFFFFFFFU)
#define LTC_CTX_CTX_SHIFT                        (0U)
#define LTC_CTX_CTX(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_CTX_CTX_SHIFT)) & LTC_CTX_CTX_MASK)

/* The count of LTC_CTX */
#define LTC_CTX_COUNT                            (14U)

/*! @name KEY - LTC Key Registers */
#define LTC_KEY_KEY_MASK                         (0xFFFFFFFFU)
#define LTC_KEY_KEY_SHIFT                        (0U)
#define LTC_KEY_KEY(x)                           (((uint32_t)(((uint32_t)(x)) << LTC_KEY_KEY_SHIFT)) & LTC_KEY_KEY_MASK)

/* The count of LTC_KEY */
#define LTC_KEY_COUNT                            (4U)

/*! @name VID1 - LTC Version ID Register */
#define LTC_VID1_MIN_REV_MASK                    (0xFFU)
#define LTC_VID1_MIN_REV_SHIFT                   (0U)
#define LTC_VID1_MIN_REV(x)                      (((uint32_t)(((uint32_t)(x)) << LTC_VID1_MIN_REV_SHIFT)) & LTC_VID1_MIN_REV_MASK)
#define LTC_VID1_MAJ_REV_MASK                    (0xFF00U)
#define LTC_VID1_MAJ_REV_SHIFT                   (8U)
#define LTC_VID1_MAJ_REV(x)                      (((uint32_t)(((uint32_t)(x)) << LTC_VID1_MAJ_REV_SHIFT)) & LTC_VID1_MAJ_REV_MASK)
#define LTC_VID1_IP_ID_MASK                      (0xFFFF0000U)
#define LTC_VID1_IP_ID_SHIFT                     (16U)
#define LTC_VID1_IP_ID(x)                        (((uint32_t)(((uint32_t)(x)) << LTC_VID1_IP_ID_SHIFT)) & LTC_VID1_IP_ID_MASK)

/*! @name VID2 - LTC Version ID 2 Register */
#define LTC_VID2_ECO_REV_MASK                    (0xFFU)
#define LTC_VID2_ECO_REV_SHIFT                   (0U)
#define LTC_VID2_ECO_REV(x)                      (((uint32_t)(((uint32_t)(x)) << LTC_VID2_ECO_REV_SHIFT)) & LTC_VID2_ECO_REV_MASK)
#define LTC_VID2_ARCH_ERA_MASK                   (0xFF00U)
#define LTC_VID2_ARCH_ERA_SHIFT                  (8U)
#define LTC_VID2_ARCH_ERA(x)                     (((uint32_t)(((uint32_t)(x)) << LTC_VID2_ARCH_ERA_SHIFT)) & LTC_VID2_ARCH_ERA_MASK)

/*! @name CHAVID - LTC CHA Version ID Register */
#define LTC_CHAVID_AESREV_MASK                   (0xFU)
#define LTC_CHAVID_AESREV_SHIFT                  (0U)
#define LTC_CHAVID_AESREV(x)                     (((uint32_t)(((uint32_t)(x)) << LTC_CHAVID_AESREV_SHIFT)) & LTC_CHAVID_AESREV_MASK)
#define LTC_CHAVID_AESVID_MASK                   (0xF0U)
#define LTC_CHAVID_AESVID_SHIFT                  (4U)
#define LTC_CHAVID_AESVID(x)                     (((uint32_t)(((uint32_t)(x)) << LTC_CHAVID_AESVID_SHIFT)) & LTC_CHAVID_AESVID_MASK)

/*! @name FIFOSTA - LTC FIFO Status Register */
#define LTC_FIFOSTA_IFL_MASK                     (0x7FU)
#define LTC_FIFOSTA_IFL_SHIFT                    (0U)
#define LTC_FIFOSTA_IFL(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_FIFOSTA_IFL_SHIFT)) & LTC_FIFOSTA_IFL_MASK)
#define LTC_FIFOSTA_IFF_MASK                     (0x8000U)
#define LTC_FIFOSTA_IFF_SHIFT                    (15U)
#define LTC_FIFOSTA_OFL_MASK                     (0x7F0000U)
#define LTC_FIFOSTA_OFL_SHIFT                    (16U)
#define LTC_FIFOSTA_OFL(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_FIFOSTA_OFL_SHIFT)) & LTC_FIFOSTA_OFL_MASK)
#define LTC_FIFOSTA_OFF_MASK                     (0x80000000U)
#define LTC_FIFOSTA_OFF_SHIFT                    (31U)

/*! @name IFIFO - LTC Input Data FIFO */
#define LTC_IFIFO_IFIFO_MASK                     (0xFFFFFFFFU)
#define LTC_IFIFO_IFIFO_SHIFT                    (0U)
#define LTC_IFIFO_IFIFO(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_IFIFO_IFIFO_SHIFT)) & LTC_IFIFO_IFIFO_MASK)

/*! @name OFIFO - LTC Output Data FIFO */
#define LTC_OFIFO_OFIFO_MASK                     (0xFFFFFFFFU)
#define LTC_OFIFO_OFIFO_SHIFT                    (0U)
#define LTC_OFIFO_OFIFO(x)                       (((uint32_t)(((uint32_t)(x)) << LTC_OFIFO_OFIFO_SHIFT)) & LTC_OFIFO_OFIFO_MASK)


/*!
 * @}
 */ /* end of group LTC_Register_Masks */


/* LTC - Peripheral instance base addresses */
/** Peripheral LTC base pointer */
#define LTC_BASE_PTR                             ((LTC_MemMapPtr)0x40058000u)
/** Array initializer of LTC peripheral base pointers */
#define LTC_BASE_PTRS                            { LTC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- LTC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LTC_Register_Accessor_Macros LTC - Register accessor macros
 * @{
 */


/* LTC - Register instance definitions */
/* LTC */
#define LTC_MD                                   LTC_MD_REG(LTC_BASE_PTR)
#define LTC_KS                                   LTC_KS_REG(LTC_BASE_PTR)
#define LTC_DS                                   LTC_DS_REG(LTC_BASE_PTR)
#define LTC_ICVS                                 LTC_ICVS_REG(LTC_BASE_PTR)
#define LTC_COM                                  LTC_COM_REG(LTC_BASE_PTR)
#define LTC_CTL                                  LTC_CTL_REG(LTC_BASE_PTR)
#define LTC_CW                                   LTC_CW_REG(LTC_BASE_PTR)
#define LTC_STA                                  LTC_STA_REG(LTC_BASE_PTR)
#define LTC_ESTA                                 LTC_ESTA_REG(LTC_BASE_PTR)
#define LTC_AADSZ                                LTC_AADSZ_REG(LTC_BASE_PTR)
#define LTC_CTX_0                                LTC_CTX_REG(LTC_BASE_PTR,0)
#define LTC_CTX_1                                LTC_CTX_REG(LTC_BASE_PTR,1)
#define LTC_CTX_2                                LTC_CTX_REG(LTC_BASE_PTR,2)
#define LTC_CTX_3                                LTC_CTX_REG(LTC_BASE_PTR,3)
#define LTC_CTX_4                                LTC_CTX_REG(LTC_BASE_PTR,4)
#define LTC_CTX_5                                LTC_CTX_REG(LTC_BASE_PTR,5)
#define LTC_CTX_6                                LTC_CTX_REG(LTC_BASE_PTR,6)
#define LTC_CTX_7                                LTC_CTX_REG(LTC_BASE_PTR,7)
#define LTC_CTX_8                                LTC_CTX_REG(LTC_BASE_PTR,8)
#define LTC_CTX_9                                LTC_CTX_REG(LTC_BASE_PTR,9)
#define LTC_CTX_10                               LTC_CTX_REG(LTC_BASE_PTR,10)
#define LTC_CTX_11                               LTC_CTX_REG(LTC_BASE_PTR,11)
#define LTC_CTX_12                               LTC_CTX_REG(LTC_BASE_PTR,12)
#define LTC_CTX_13                               LTC_CTX_REG(LTC_BASE_PTR,13)
#define LTC_KEY_0                                LTC_KEY_REG(LTC_BASE_PTR,0)
#define LTC_KEY_1                                LTC_KEY_REG(LTC_BASE_PTR,1)
#define LTC_KEY_2                                LTC_KEY_REG(LTC_BASE_PTR,2)
#define LTC_KEY_3                                LTC_KEY_REG(LTC_BASE_PTR,3)
#define LTC_VID1                                 LTC_VID1_REG(LTC_BASE_PTR)
#define LTC_VID2                                 LTC_VID2_REG(LTC_BASE_PTR)
#define LTC_CHAVID                               LTC_CHAVID_REG(LTC_BASE_PTR)
#define LTC_FIFOSTA                              LTC_FIFOSTA_REG(LTC_BASE_PTR)
#define LTC_IFIFO                                LTC_IFIFO_REG(LTC_BASE_PTR)
#define LTC_OFIFO                                LTC_OFIFO_REG(LTC_BASE_PTR)

/* LTC - Register array accessors */
#define LTC_CTX(index)                           LTC_CTX_REG(LTC_BASE_PTR,index)
#define LTC_KEY(index)                           LTC_KEY_REG(LTC_BASE_PTR,index)

/*!
 * @}
 */ /* end of group LTC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group LTC_Peripheral */


/* ----------------------------------------------------------------------------
   -- MCG
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Peripheral MCG
 * @{
 */

/** MCG - Peripheral register structure */
typedef struct MCG_MemMap {
  uint8_t C1;                                      /**< MCG Control 1 Register, offset: 0x0 */
  uint8_t C2;                                      /**< MCG Control 2 Register, offset: 0x1 */
  uint8_t C3;                                      /**< MCG Control 3 Register, offset: 0x2 */
  uint8_t C4;                                      /**< MCG Control 4 Register, offset: 0x3 */
  uint8_t C5;                                      /**< MCG Control 5 Register, offset: 0x4 */
  uint8_t C6;                                      /**< MCG Control 6 Register, offset: 0x5 */
  uint8_t S;                                       /**< MCG Status Register, offset: 0x6 */
  uint8_t RESERVED_0[1];
  uint8_t SC;                                      /**< MCG Status and Control Register, offset: 0x8 */
  uint8_t RESERVED_1[1];
  uint8_t ATCVH;                                   /**< MCG Auto Trim Compare Value High Register, offset: 0xA */
  uint8_t ATCVL;                                   /**< MCG Auto Trim Compare Value Low Register, offset: 0xB */
  uint8_t C7;                                      /**< MCG Control 7 Register, offset: 0xC */
  uint8_t C8;                                      /**< MCG Control 8 Register, offset: 0xD */
} volatile *MCG_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MCG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Register_Accessor_Macros MCG - Register accessor macros
 * @{
 */


/* MCG - Register accessors */
#define MCG_C1_REG(base)                         ((base)->C1)
#define MCG_C2_REG(base)                         ((base)->C2)
#define MCG_C3_REG(base)                         ((base)->C3)
#define MCG_C4_REG(base)                         ((base)->C4)
#define MCG_C5_REG(base)                         ((base)->C5)
#define MCG_C6_REG(base)                         ((base)->C6)
#define MCG_S_REG(base)                          ((base)->S)
#define MCG_SC_REG(base)                         ((base)->SC)
#define MCG_ATCVH_REG(base)                      ((base)->ATCVH)
#define MCG_ATCVL_REG(base)                      ((base)->ATCVL)
#define MCG_C7_REG(base)                         ((base)->C7)
#define MCG_C8_REG(base)                         ((base)->C8)

/*!
 * @}
 */ /* end of group MCG_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MCG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Register_Masks MCG Register Masks
 * @{
 */

/*! @name C1 - MCG Control 1 Register */
#define MCG_C1_IREFSTEN_MASK                     (0x1U)
#define MCG_C1_IREFSTEN_SHIFT                    (0U)
#define MCG_C1_IRCLKEN_MASK                      (0x2U)
#define MCG_C1_IRCLKEN_SHIFT                     (1U)
#define MCG_C1_IREFS_MASK                        (0x4U)
#define MCG_C1_IREFS_SHIFT                       (2U)
#define MCG_C1_FRDIV_MASK                        (0x38U)
#define MCG_C1_FRDIV_SHIFT                       (3U)
#define MCG_C1_FRDIV(x)                          (((uint8_t)(((uint8_t)(x)) << MCG_C1_FRDIV_SHIFT)) & MCG_C1_FRDIV_MASK)
#define MCG_C1_CLKS_MASK                         (0xC0U)
#define MCG_C1_CLKS_SHIFT                        (6U)
#define MCG_C1_CLKS(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_C1_CLKS_SHIFT)) & MCG_C1_CLKS_MASK)

/*! @name C2 - MCG Control 2 Register */
#define MCG_C2_IRCS_MASK                         (0x1U)
#define MCG_C2_IRCS_SHIFT                        (0U)
#define MCG_C2_LP_MASK                           (0x2U)
#define MCG_C2_LP_SHIFT                          (1U)
#define MCG_C2_EREFS_MASK                        (0x4U)
#define MCG_C2_EREFS_SHIFT                       (2U)
#define MCG_C2_HGO_MASK                          (0x8U)
#define MCG_C2_HGO_SHIFT                         (3U)
#define MCG_C2_RANGE_MASK                        (0x30U)
#define MCG_C2_RANGE_SHIFT                       (4U)
#define MCG_C2_RANGE(x)                          (((uint8_t)(((uint8_t)(x)) << MCG_C2_RANGE_SHIFT)) & MCG_C2_RANGE_MASK)
#define MCG_C2_FCFTRIM_MASK                      (0x40U)
#define MCG_C2_FCFTRIM_SHIFT                     (6U)
#define MCG_C2_LOCRE0_MASK                       (0x80U)
#define MCG_C2_LOCRE0_SHIFT                      (7U)

/*! @name C3 - MCG Control 3 Register */
#define MCG_C3_SCTRIM_MASK                       (0xFFU)
#define MCG_C3_SCTRIM_SHIFT                      (0U)
#define MCG_C3_SCTRIM(x)                         (((uint8_t)(((uint8_t)(x)) << MCG_C3_SCTRIM_SHIFT)) & MCG_C3_SCTRIM_MASK)

/*! @name C4 - MCG Control 4 Register */
#define MCG_C4_SCFTRIM_MASK                      (0x1U)
#define MCG_C4_SCFTRIM_SHIFT                     (0U)
#define MCG_C4_FCTRIM_MASK                       (0x1EU)
#define MCG_C4_FCTRIM_SHIFT                      (1U)
#define MCG_C4_FCTRIM(x)                         (((uint8_t)(((uint8_t)(x)) << MCG_C4_FCTRIM_SHIFT)) & MCG_C4_FCTRIM_MASK)
#define MCG_C4_DRST_DRS_MASK                     (0x60U)
#define MCG_C4_DRST_DRS_SHIFT                    (5U)
#define MCG_C4_DRST_DRS(x)                       (((uint8_t)(((uint8_t)(x)) << MCG_C4_DRST_DRS_SHIFT)) & MCG_C4_DRST_DRS_MASK)
#define MCG_C4_DMX32_MASK                        (0x80U)
#define MCG_C4_DMX32_SHIFT                       (7U)

/*! @name C6 - MCG Control 6 Register */
#define MCG_C6_CME0_MASK                         (0x20U)
#define MCG_C6_CME0_SHIFT                        (5U)

/*! @name S - MCG Status Register */
#define MCG_S_IRCST_MASK                         (0x1U)
#define MCG_S_IRCST_SHIFT                        (0U)
#define MCG_S_OSCINIT0_MASK                      (0x2U)
#define MCG_S_OSCINIT0_SHIFT                     (1U)
#define MCG_S_CLKST_MASK                         (0xCU)
#define MCG_S_CLKST_SHIFT                        (2U)
#define MCG_S_CLKST(x)                           (((uint8_t)(((uint8_t)(x)) << MCG_S_CLKST_SHIFT)) & MCG_S_CLKST_MASK)
#define MCG_S_IREFST_MASK                        (0x10U)
#define MCG_S_IREFST_SHIFT                       (4U)

/*! @name SC - MCG Status and Control Register */
#define MCG_SC_LOCS0_MASK                        (0x1U)
#define MCG_SC_LOCS0_SHIFT                       (0U)
#define MCG_SC_FCRDIV_MASK                       (0xEU)
#define MCG_SC_FCRDIV_SHIFT                      (1U)
#define MCG_SC_FCRDIV(x)                         (((uint8_t)(((uint8_t)(x)) << MCG_SC_FCRDIV_SHIFT)) & MCG_SC_FCRDIV_MASK)
#define MCG_SC_FLTPRSRV_MASK                     (0x10U)
#define MCG_SC_FLTPRSRV_SHIFT                    (4U)
#define MCG_SC_ATMF_MASK                         (0x20U)
#define MCG_SC_ATMF_SHIFT                        (5U)
#define MCG_SC_ATMS_MASK                         (0x40U)
#define MCG_SC_ATMS_SHIFT                        (6U)
#define MCG_SC_ATME_MASK                         (0x80U)
#define MCG_SC_ATME_SHIFT                        (7U)

/*! @name ATCVH - MCG Auto Trim Compare Value High Register */
#define MCG_ATCVH_ATCVH_MASK                     (0xFFU)
#define MCG_ATCVH_ATCVH_SHIFT                    (0U)
#define MCG_ATCVH_ATCVH(x)                       (((uint8_t)(((uint8_t)(x)) << MCG_ATCVH_ATCVH_SHIFT)) & MCG_ATCVH_ATCVH_MASK)

/*! @name ATCVL - MCG Auto Trim Compare Value Low Register */
#define MCG_ATCVL_ATCVL_MASK                     (0xFFU)
#define MCG_ATCVL_ATCVL_SHIFT                    (0U)
#define MCG_ATCVL_ATCVL(x)                       (((uint8_t)(((uint8_t)(x)) << MCG_ATCVL_ATCVL_SHIFT)) & MCG_ATCVL_ATCVL_MASK)

/*! @name C7 - MCG Control 7 Register */
#define MCG_C7_OSCSEL_MASK                       (0x1U)
#define MCG_C7_OSCSEL_SHIFT                      (0U)

/*! @name C8 - MCG Control 8 Register */
#define MCG_C8_LOCS1_MASK                        (0x1U)
#define MCG_C8_LOCS1_SHIFT                       (0U)
#define MCG_C8_CME1_MASK                         (0x20U)
#define MCG_C8_CME1_SHIFT                        (5U)
#define MCG_C8_LOCRE1_MASK                       (0x80U)
#define MCG_C8_LOCRE1_SHIFT                      (7U)


/*!
 * @}
 */ /* end of group MCG_Register_Masks */


/* MCG - Peripheral instance base addresses */
/** Peripheral MCG base pointer */
#define MCG_BASE_PTR                             ((MCG_MemMapPtr)0x40064000u)
/** Array initializer of MCG peripheral base pointers */
#define MCG_BASE_PTRS                            { MCG_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- MCG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Register_Accessor_Macros MCG - Register accessor macros
 * @{
 */


/* MCG - Register instance definitions */
/* MCG */
#define MCG_C1                                   MCG_C1_REG(MCG_BASE_PTR)
#define MCG_C2                                   MCG_C2_REG(MCG_BASE_PTR)
#define MCG_C3                                   MCG_C3_REG(MCG_BASE_PTR)
#define MCG_C4                                   MCG_C4_REG(MCG_BASE_PTR)
#define MCG_C5                                   MCG_C5_REG(MCG_BASE_PTR)
#define MCG_C6                                   MCG_C6_REG(MCG_BASE_PTR)
#define MCG_S                                    MCG_S_REG(MCG_BASE_PTR)
#define MCG_SC                                   MCG_SC_REG(MCG_BASE_PTR)
#define MCG_ATCVH                                MCG_ATCVH_REG(MCG_BASE_PTR)
#define MCG_ATCVL                                MCG_ATCVL_REG(MCG_BASE_PTR)
#define MCG_C7                                   MCG_C7_REG(MCG_BASE_PTR)
#define MCG_C8                                   MCG_C8_REG(MCG_BASE_PTR)

/*!
 * @}
 */ /* end of group MCG_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MCG_Peripheral */


/* ----------------------------------------------------------------------------
   -- MCM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Peripheral MCM
 * @{
 */

/** MCM - Peripheral register structure */
typedef struct MCM_MemMap {
  uint8_t RESERVED_0[8];
  uint16_t PLASC;                                  /**< Crossbar Switch (AXBS) Slave Configuration, offset: 0x8 */
  uint16_t PLAMC;                                  /**< Crossbar Switch (AXBS) Master Configuration, offset: 0xA */
  uint32_t PLACR;                                  /**< Platform Control Register, offset: 0xC */
  uint8_t RESERVED_1[48];
  uint32_t CPO;                                    /**< Compute Operation Control Register, offset: 0x40 */
} volatile *MCM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Register_Accessor_Macros MCM - Register accessor macros
 * @{
 */


/* MCM - Register accessors */
#define MCM_PLASC_REG(base)                      ((base)->PLASC)
#define MCM_PLAMC_REG(base)                      ((base)->PLAMC)
#define MCM_PLACR_REG(base)                      ((base)->PLACR)
#define MCM_CPO_REG(base)                        ((base)->CPO)

/*!
 * @}
 */ /* end of group MCM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Register_Masks MCM Register Masks
 * @{
 */

/*! @name PLASC - Crossbar Switch (AXBS) Slave Configuration */
#define MCM_PLASC_ASC_MASK                       (0xFFU)
#define MCM_PLASC_ASC_SHIFT                      (0U)
#define MCM_PLASC_ASC(x)                         (((uint16_t)(((uint16_t)(x)) << MCM_PLASC_ASC_SHIFT)) & MCM_PLASC_ASC_MASK)

/*! @name PLAMC - Crossbar Switch (AXBS) Master Configuration */
#define MCM_PLAMC_AMC_MASK                       (0xFFU)
#define MCM_PLAMC_AMC_SHIFT                      (0U)
#define MCM_PLAMC_AMC(x)                         (((uint16_t)(((uint16_t)(x)) << MCM_PLAMC_AMC_SHIFT)) & MCM_PLAMC_AMC_MASK)

/*! @name PLACR - Platform Control Register */
#define MCM_PLACR_ARB_MASK                       (0x200U)
#define MCM_PLACR_ARB_SHIFT                      (9U)
#define MCM_PLACR_CFCC_MASK                      (0x400U)
#define MCM_PLACR_CFCC_SHIFT                     (10U)
#define MCM_PLACR_DFCDA_MASK                     (0x800U)
#define MCM_PLACR_DFCDA_SHIFT                    (11U)
#define MCM_PLACR_DFCIC_MASK                     (0x1000U)
#define MCM_PLACR_DFCIC_SHIFT                    (12U)
#define MCM_PLACR_DFCC_MASK                      (0x2000U)
#define MCM_PLACR_DFCC_SHIFT                     (13U)
#define MCM_PLACR_EFDS_MASK                      (0x4000U)
#define MCM_PLACR_EFDS_SHIFT                     (14U)
#define MCM_PLACR_DFCS_MASK                      (0x8000U)
#define MCM_PLACR_DFCS_SHIFT                     (15U)
#define MCM_PLACR_ESFC_MASK                      (0x10000U)
#define MCM_PLACR_ESFC_SHIFT                     (16U)

/*! @name CPO - Compute Operation Control Register */
#define MCM_CPO_CPOREQ_MASK                      (0x1U)
#define MCM_CPO_CPOREQ_SHIFT                     (0U)
#define MCM_CPO_CPOACK_MASK                      (0x2U)
#define MCM_CPO_CPOACK_SHIFT                     (1U)
#define MCM_CPO_CPOWOI_MASK                      (0x4U)
#define MCM_CPO_CPOWOI_SHIFT                     (2U)


/*!
 * @}
 */ /* end of group MCM_Register_Masks */


/* MCM - Peripheral instance base addresses */
/** Peripheral MCM base pointer */
#define MCM_BASE_PTR                             ((MCM_MemMapPtr)0xF0003000u)
/** Array initializer of MCM peripheral base pointers */
#define MCM_BASE_PTRS                            { MCM_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- MCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Register_Accessor_Macros MCM - Register accessor macros
 * @{
 */


/* MCM - Register instance definitions */
/* MCM */
#define MCM_PLASC                                MCM_PLASC_REG(MCM_BASE_PTR)
#define MCM_PLAMC                                MCM_PLAMC_REG(MCM_BASE_PTR)
#define MCM_PLACR                                MCM_PLACR_REG(MCM_BASE_PTR)
#define MCM_CPO                                  MCM_CPO_REG(MCM_BASE_PTR)

/*!
 * @}
 */ /* end of group MCM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MCM_Peripheral */


/* ----------------------------------------------------------------------------
   -- MTB
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTB_Peripheral MTB
 * @{
 */

/** MTB - Peripheral register structure */
typedef struct MTB_MemMap {
  uint32_t POSITION;                               /**< MTB Position Register, offset: 0x0 */
  uint32_t MASTER;                                 /**< MTB Master Register, offset: 0x4 */
  uint32_t FLOW;                                   /**< MTB Flow Register, offset: 0x8 */
  uint32_t BASE;                                   /**< MTB Base Register, offset: 0xC */
  uint8_t RESERVED_0[3824];
  uint32_t MODECTRL;                               /**< Integration Mode Control Register, offset: 0xF00 */
  uint8_t RESERVED_1[156];
  uint32_t TAGSET;                                 /**< Claim TAG Set Register, offset: 0xFA0 */
  uint32_t TAGCLEAR;                               /**< Claim TAG Clear Register, offset: 0xFA4 */
  uint8_t RESERVED_2[8];
  uint32_t LOCKACCESS;                             /**< Lock Access Register, offset: 0xFB0 */
  uint32_t LOCKSTAT;                               /**< Lock Status Register, offset: 0xFB4 */
  uint32_t AUTHSTAT;                               /**< Authentication Status Register, offset: 0xFB8 */
  uint32_t DEVICEARCH;                             /**< Device Architecture Register, offset: 0xFBC */
  uint8_t RESERVED_3[8];
  uint32_t DEVICECFG;                              /**< Device Configuration Register, offset: 0xFC8 */
  uint32_t DEVICETYPID;                            /**< Device Type Identifier Register, offset: 0xFCC */
  uint32_t PERIPHID[8];                            /**< Peripheral ID Register, array offset: 0xFD0, array step: 0x4 */
  uint32_t COMPID[4];                              /**< Component ID Register, array offset: 0xFF0, array step: 0x4 */
} volatile *MTB_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MTB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTB_Register_Accessor_Macros MTB - Register accessor macros
 * @{
 */


/* MTB - Register accessors */
#define MTB_POSITION_REG(base)                   ((base)->POSITION)
#define MTB_MASTER_REG(base)                     ((base)->MASTER)
#define MTB_FLOW_REG(base)                       ((base)->FLOW)
#define MTB_BASE_REG(base)                       ((base)->BASE)
#define MTB_MODECTRL_REG(base)                   ((base)->MODECTRL)
#define MTB_TAGSET_REG(base)                     ((base)->TAGSET)
#define MTB_TAGCLEAR_REG(base)                   ((base)->TAGCLEAR)
#define MTB_LOCKACCESS_REG(base)                 ((base)->LOCKACCESS)
#define MTB_LOCKSTAT_REG(base)                   ((base)->LOCKSTAT)
#define MTB_AUTHSTAT_REG(base)                   ((base)->AUTHSTAT)
#define MTB_DEVICEARCH_REG(base)                 ((base)->DEVICEARCH)
#define MTB_DEVICECFG_REG(base)                  ((base)->DEVICECFG)
#define MTB_DEVICETYPID_REG(base)                ((base)->DEVICETYPID)
#define MTB_PERIPHID_REG(base,index)             ((base)->PERIPHID[index])
#define MTB_COMPID_REG(base,index)               ((base)->COMPID[index])

/*!
 * @}
 */ /* end of group MTB_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MTB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTB_Register_Masks MTB Register Masks
 * @{
 */

/*! @name POSITION - MTB Position Register */
#define MTB_POSITION_WRAP_MASK                   (0x4U)
#define MTB_POSITION_WRAP_SHIFT                  (2U)
#define MTB_POSITION_POINTER_MASK                (0xFFFFFFF8U)
#define MTB_POSITION_POINTER_SHIFT               (3U)
#define MTB_POSITION_POINTER(x)                  (((uint32_t)(((uint32_t)(x)) << MTB_POSITION_POINTER_SHIFT)) & MTB_POSITION_POINTER_MASK)

/*! @name MASTER - MTB Master Register */
#define MTB_MASTER_MASK_MASK                     (0x1FU)
#define MTB_MASTER_MASK_SHIFT                    (0U)
#define MTB_MASTER_MASK(x)                       (((uint32_t)(((uint32_t)(x)) << MTB_MASTER_MASK_SHIFT)) & MTB_MASTER_MASK_MASK)
#define MTB_MASTER_TSTARTEN_MASK                 (0x20U)
#define MTB_MASTER_TSTARTEN_SHIFT                (5U)
#define MTB_MASTER_TSTOPEN_MASK                  (0x40U)
#define MTB_MASTER_TSTOPEN_SHIFT                 (6U)
#define MTB_MASTER_SFRWPRIV_MASK                 (0x80U)
#define MTB_MASTER_SFRWPRIV_SHIFT                (7U)
#define MTB_MASTER_RAMPRIV_MASK                  (0x100U)
#define MTB_MASTER_RAMPRIV_SHIFT                 (8U)
#define MTB_MASTER_HALTREQ_MASK                  (0x200U)
#define MTB_MASTER_HALTREQ_SHIFT                 (9U)
#define MTB_MASTER_EN_MASK                       (0x80000000U)
#define MTB_MASTER_EN_SHIFT                      (31U)

/*! @name FLOW - MTB Flow Register */
#define MTB_FLOW_AUTOSTOP_MASK                   (0x1U)
#define MTB_FLOW_AUTOSTOP_SHIFT                  (0U)
#define MTB_FLOW_AUTOHALT_MASK                   (0x2U)
#define MTB_FLOW_AUTOHALT_SHIFT                  (1U)
#define MTB_FLOW_WATERMARK_MASK                  (0xFFFFFFF8U)
#define MTB_FLOW_WATERMARK_SHIFT                 (3U)
#define MTB_FLOW_WATERMARK(x)                    (((uint32_t)(((uint32_t)(x)) << MTB_FLOW_WATERMARK_SHIFT)) & MTB_FLOW_WATERMARK_MASK)

/*! @name BASE - MTB Base Register */
#define MTB_BASE_BASEADDR_MASK                   (0xFFFFFFFFU)
#define MTB_BASE_BASEADDR_SHIFT                  (0U)
#define MTB_BASE_BASEADDR(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_BASE_BASEADDR_SHIFT)) & MTB_BASE_BASEADDR_MASK)

/*! @name MODECTRL - Integration Mode Control Register */
#define MTB_MODECTRL_MODECTRL_MASK               (0xFFFFFFFFU)
#define MTB_MODECTRL_MODECTRL_SHIFT              (0U)
#define MTB_MODECTRL_MODECTRL(x)                 (((uint32_t)(((uint32_t)(x)) << MTB_MODECTRL_MODECTRL_SHIFT)) & MTB_MODECTRL_MODECTRL_MASK)

/*! @name TAGSET - Claim TAG Set Register */
#define MTB_TAGSET_TAGSET_MASK                   (0xFFFFFFFFU)
#define MTB_TAGSET_TAGSET_SHIFT                  (0U)
#define MTB_TAGSET_TAGSET(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_TAGSET_TAGSET_SHIFT)) & MTB_TAGSET_TAGSET_MASK)

/*! @name TAGCLEAR - Claim TAG Clear Register */
#define MTB_TAGCLEAR_TAGCLEAR_MASK               (0xFFFFFFFFU)
#define MTB_TAGCLEAR_TAGCLEAR_SHIFT              (0U)
#define MTB_TAGCLEAR_TAGCLEAR(x)                 (((uint32_t)(((uint32_t)(x)) << MTB_TAGCLEAR_TAGCLEAR_SHIFT)) & MTB_TAGCLEAR_TAGCLEAR_MASK)

/*! @name LOCKACCESS - Lock Access Register */
#define MTB_LOCKACCESS_LOCKACCESS_MASK           (0xFFFFFFFFU)
#define MTB_LOCKACCESS_LOCKACCESS_SHIFT          (0U)
#define MTB_LOCKACCESS_LOCKACCESS(x)             (((uint32_t)(((uint32_t)(x)) << MTB_LOCKACCESS_LOCKACCESS_SHIFT)) & MTB_LOCKACCESS_LOCKACCESS_MASK)

/*! @name LOCKSTAT - Lock Status Register */
#define MTB_LOCKSTAT_LOCKSTAT_MASK               (0xFFFFFFFFU)
#define MTB_LOCKSTAT_LOCKSTAT_SHIFT              (0U)
#define MTB_LOCKSTAT_LOCKSTAT(x)                 (((uint32_t)(((uint32_t)(x)) << MTB_LOCKSTAT_LOCKSTAT_SHIFT)) & MTB_LOCKSTAT_LOCKSTAT_MASK)

/*! @name AUTHSTAT - Authentication Status Register */
#define MTB_AUTHSTAT_BIT0_MASK                   (0x1U)
#define MTB_AUTHSTAT_BIT0_SHIFT                  (0U)
#define MTB_AUTHSTAT_BIT1_MASK                   (0x2U)
#define MTB_AUTHSTAT_BIT1_SHIFT                  (1U)
#define MTB_AUTHSTAT_BIT2_MASK                   (0x4U)
#define MTB_AUTHSTAT_BIT2_SHIFT                  (2U)
#define MTB_AUTHSTAT_BIT3_MASK                   (0x8U)
#define MTB_AUTHSTAT_BIT3_SHIFT                  (3U)

/*! @name DEVICEARCH - Device Architecture Register */
#define MTB_DEVICEARCH_DEVICEARCH_MASK           (0xFFFFFFFFU)
#define MTB_DEVICEARCH_DEVICEARCH_SHIFT          (0U)
#define MTB_DEVICEARCH_DEVICEARCH(x)             (((uint32_t)(((uint32_t)(x)) << MTB_DEVICEARCH_DEVICEARCH_SHIFT)) & MTB_DEVICEARCH_DEVICEARCH_MASK)

/*! @name DEVICECFG - Device Configuration Register */
#define MTB_DEVICECFG_DEVICECFG_MASK             (0xFFFFFFFFU)
#define MTB_DEVICECFG_DEVICECFG_SHIFT            (0U)
#define MTB_DEVICECFG_DEVICECFG(x)               (((uint32_t)(((uint32_t)(x)) << MTB_DEVICECFG_DEVICECFG_SHIFT)) & MTB_DEVICECFG_DEVICECFG_MASK)

/*! @name DEVICETYPID - Device Type Identifier Register */
#define MTB_DEVICETYPID_DEVICETYPID_MASK         (0xFFFFFFFFU)
#define MTB_DEVICETYPID_DEVICETYPID_SHIFT        (0U)
#define MTB_DEVICETYPID_DEVICETYPID(x)           (((uint32_t)(((uint32_t)(x)) << MTB_DEVICETYPID_DEVICETYPID_SHIFT)) & MTB_DEVICETYPID_DEVICETYPID_MASK)

/*! @name PERIPHID - Peripheral ID Register */
#define MTB_PERIPHID_PERIPHID_MASK               (0xFFFFFFFFU)
#define MTB_PERIPHID_PERIPHID_SHIFT              (0U)
#define MTB_PERIPHID_PERIPHID(x)                 (((uint32_t)(((uint32_t)(x)) << MTB_PERIPHID_PERIPHID_SHIFT)) & MTB_PERIPHID_PERIPHID_MASK)

/* The count of MTB_PERIPHID */
#define MTB_PERIPHID_COUNT                       (8U)

/*! @name COMPID - Component ID Register */
#define MTB_COMPID_COMPID_MASK                   (0xFFFFFFFFU)
#define MTB_COMPID_COMPID_SHIFT                  (0U)
#define MTB_COMPID_COMPID(x)                     (((uint32_t)(((uint32_t)(x)) << MTB_COMPID_COMPID_SHIFT)) & MTB_COMPID_COMPID_MASK)

/* The count of MTB_COMPID */
#define MTB_COMPID_COUNT                         (4U)


/*!
 * @}
 */ /* end of group MTB_Register_Masks */


/* MTB - Peripheral instance base addresses */
/** Peripheral MTB base pointer */
#define MTB_BASE_PTR                             ((MTB_MemMapPtr)0xF0000000u)
/** Array initializer of MTB peripheral base pointers */
#define MTB_BASE_PTRS                            { MTB_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- MTB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTB_Register_Accessor_Macros MTB - Register accessor macros
 * @{
 */


/* MTB - Register instance definitions */
/* MTB */
#define MTB_POSITION                             MTB_POSITION_REG(MTB_BASE_PTR)
#define MTB_MASTER                               MTB_MASTER_REG(MTB_BASE_PTR)
#define MTB_FLOW                                 MTB_FLOW_REG(MTB_BASE_PTR)
#define MTB_BASE                                 MTB_BASE_REG(MTB_BASE_PTR)
#define MTB_MODECTRL                             MTB_MODECTRL_REG(MTB_BASE_PTR)
#define MTB_TAGSET                               MTB_TAGSET_REG(MTB_BASE_PTR)
#define MTB_TAGCLEAR                             MTB_TAGCLEAR_REG(MTB_BASE_PTR)
#define MTB_LOCKACCESS                           MTB_LOCKACCESS_REG(MTB_BASE_PTR)
#define MTB_LOCKSTAT                             MTB_LOCKSTAT_REG(MTB_BASE_PTR)
#define MTB_AUTHSTAT                             MTB_AUTHSTAT_REG(MTB_BASE_PTR)
#define MTB_DEVICEARCH                           MTB_DEVICEARCH_REG(MTB_BASE_PTR)
#define MTB_DEVICECFG                            MTB_DEVICECFG_REG(MTB_BASE_PTR)
#define MTB_DEVICETYPID                          MTB_DEVICETYPID_REG(MTB_BASE_PTR)
#define MTB_PERIPHID4                            MTB_PERIPHID_REG(MTB_BASE_PTR,0)
#define MTB_PERIPHID5                            MTB_PERIPHID_REG(MTB_BASE_PTR,1)
#define MTB_PERIPHID6                            MTB_PERIPHID_REG(MTB_BASE_PTR,2)
#define MTB_PERIPHID7                            MTB_PERIPHID_REG(MTB_BASE_PTR,3)
#define MTB_PERIPHID0                            MTB_PERIPHID_REG(MTB_BASE_PTR,4)
#define MTB_PERIPHID1                            MTB_PERIPHID_REG(MTB_BASE_PTR,5)
#define MTB_PERIPHID2                            MTB_PERIPHID_REG(MTB_BASE_PTR,6)
#define MTB_PERIPHID3                            MTB_PERIPHID_REG(MTB_BASE_PTR,7)
#define MTB_COMPID0                              MTB_COMPID_REG(MTB_BASE_PTR,0)
#define MTB_COMPID1                              MTB_COMPID_REG(MTB_BASE_PTR,1)
#define MTB_COMPID2                              MTB_COMPID_REG(MTB_BASE_PTR,2)
#define MTB_COMPID3                              MTB_COMPID_REG(MTB_BASE_PTR,3)

/* MTB - Register array accessors */
#define MTB_PERIPHID(index)                      MTB_PERIPHID_REG(MTB_BASE_PTR,index)
#define MTB_COMPID(index)                        MTB_COMPID_REG(MTB_BASE_PTR,index)

/*!
 * @}
 */ /* end of group MTB_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MTB_Peripheral */


/* ----------------------------------------------------------------------------
   -- MTBDWT
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTBDWT_Peripheral MTBDWT
 * @{
 */

/** MTBDWT - Peripheral register structure */
typedef struct MTBDWT_MemMap {
  uint32_t CTRL;                                   /**< MTB DWT Control Register, offset: 0x0 */
  uint8_t RESERVED_0[28];
  struct {                                         /* offset: 0x20, array step: 0x10 */
    uint32_t COMP;                                   /**< MTB_DWT Comparator Register, array offset: 0x20, array step: 0x10 */
    uint32_t MASK;                                   /**< MTB_DWT Comparator Mask Register, array offset: 0x24, array step: 0x10 */
    uint32_t FCT;                                    /**< MTB_DWT Comparator Function Register 0..MTB_DWT Comparator Function Register 1, array offset: 0x28, array step: 0x10 */
    uint8_t RESERVED_0[4];
  } COMPARATOR[2];
  uint8_t RESERVED_1[448];
  uint32_t TBCTRL;                                 /**< MTB_DWT Trace Buffer Control Register, offset: 0x200 */
  uint8_t RESERVED_2[3524];
  uint32_t DEVICECFG;                              /**< Device Configuration Register, offset: 0xFC8 */
  uint32_t DEVICETYPID;                            /**< Device Type Identifier Register, offset: 0xFCC */
  uint32_t PERIPHID[8];                            /**< Peripheral ID Register, array offset: 0xFD0, array step: 0x4 */
  uint32_t COMPID[4];                              /**< Component ID Register, array offset: 0xFF0, array step: 0x4 */
} volatile *MTBDWT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MTBDWT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTBDWT_Register_Accessor_Macros MTBDWT - Register accessor macros
 * @{
 */


/* MTBDWT - Register accessors */
#define MTBDWT_CTRL_REG(base)                    ((base)->CTRL)
#define MTBDWT_COMP_REG(base,index)              ((base)->COMPARATOR[index].COMP)
#define MTBDWT_MASK_REG(base,index)              ((base)->COMPARATOR[index].MASK)
#define MTBDWT_FCT_REG(base,index)               ((base)->COMPARATOR[index].FCT)
#define MTBDWT_TBCTRL_REG(base)                  ((base)->TBCTRL)
#define MTBDWT_DEVICECFG_REG(base)               ((base)->DEVICECFG)
#define MTBDWT_DEVICETYPID_REG(base)             ((base)->DEVICETYPID)
#define MTBDWT_PERIPHID_REG(base,index)          ((base)->PERIPHID[index])
#define MTBDWT_COMPID_REG(base,index)            ((base)->COMPID[index])

/*!
 * @}
 */ /* end of group MTBDWT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MTBDWT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTBDWT_Register_Masks MTBDWT Register Masks
 * @{
 */

/*! @name CTRL - MTB DWT Control Register */
#define MTBDWT_CTRL_DWTCFGCTRL_MASK              (0xFFFFFFFU)
#define MTBDWT_CTRL_DWTCFGCTRL_SHIFT             (0U)
#define MTBDWT_CTRL_DWTCFGCTRL(x)                (((uint32_t)(((uint32_t)(x)) << MTBDWT_CTRL_DWTCFGCTRL_SHIFT)) & MTBDWT_CTRL_DWTCFGCTRL_MASK)
#define MTBDWT_CTRL_NUMCMP_MASK                  (0xF0000000U)
#define MTBDWT_CTRL_NUMCMP_SHIFT                 (28U)
#define MTBDWT_CTRL_NUMCMP(x)                    (((uint32_t)(((uint32_t)(x)) << MTBDWT_CTRL_NUMCMP_SHIFT)) & MTBDWT_CTRL_NUMCMP_MASK)

/*! @name COMP - MTB_DWT Comparator Register */
#define MTBDWT_COMP_COMP_MASK                    (0xFFFFFFFFU)
#define MTBDWT_COMP_COMP_SHIFT                   (0U)
#define MTBDWT_COMP_COMP(x)                      (((uint32_t)(((uint32_t)(x)) << MTBDWT_COMP_COMP_SHIFT)) & MTBDWT_COMP_COMP_MASK)

/* The count of MTBDWT_COMP */
#define MTBDWT_COMP_COUNT                        (2U)

/*! @name MASK - MTB_DWT Comparator Mask Register */
#define MTBDWT_MASK_MASK_MASK                    (0x1FU)
#define MTBDWT_MASK_MASK_SHIFT                   (0U)
#define MTBDWT_MASK_MASK(x)                      (((uint32_t)(((uint32_t)(x)) << MTBDWT_MASK_MASK_SHIFT)) & MTBDWT_MASK_MASK_MASK)

/* The count of MTBDWT_MASK */
#define MTBDWT_MASK_COUNT                        (2U)

/*! @name FCT - MTB_DWT Comparator Function Register 0..MTB_DWT Comparator Function Register 1 */
#define MTBDWT_FCT_FUNCTION_MASK                 (0xFU)
#define MTBDWT_FCT_FUNCTION_SHIFT                (0U)
#define MTBDWT_FCT_FUNCTION(x)                   (((uint32_t)(((uint32_t)(x)) << MTBDWT_FCT_FUNCTION_SHIFT)) & MTBDWT_FCT_FUNCTION_MASK)
#define MTBDWT_FCT_DATAVMATCH_MASK               (0x100U)
#define MTBDWT_FCT_DATAVMATCH_SHIFT              (8U)
#define MTBDWT_FCT_DATAVSIZE_MASK                (0xC00U)
#define MTBDWT_FCT_DATAVSIZE_SHIFT               (10U)
#define MTBDWT_FCT_DATAVSIZE(x)                  (((uint32_t)(((uint32_t)(x)) << MTBDWT_FCT_DATAVSIZE_SHIFT)) & MTBDWT_FCT_DATAVSIZE_MASK)
#define MTBDWT_FCT_DATAVADDR0_MASK               (0xF000U)
#define MTBDWT_FCT_DATAVADDR0_SHIFT              (12U)
#define MTBDWT_FCT_DATAVADDR0(x)                 (((uint32_t)(((uint32_t)(x)) << MTBDWT_FCT_DATAVADDR0_SHIFT)) & MTBDWT_FCT_DATAVADDR0_MASK)
#define MTBDWT_FCT_MATCHED_MASK                  (0x1000000U)
#define MTBDWT_FCT_MATCHED_SHIFT                 (24U)

/* The count of MTBDWT_FCT */
#define MTBDWT_FCT_COUNT                         (2U)

/*! @name TBCTRL - MTB_DWT Trace Buffer Control Register */
#define MTBDWT_TBCTRL_ACOMP0_MASK                (0x1U)
#define MTBDWT_TBCTRL_ACOMP0_SHIFT               (0U)
#define MTBDWT_TBCTRL_ACOMP1_MASK                (0x2U)
#define MTBDWT_TBCTRL_ACOMP1_SHIFT               (1U)
#define MTBDWT_TBCTRL_NUMCOMP_MASK               (0xF0000000U)
#define MTBDWT_TBCTRL_NUMCOMP_SHIFT              (28U)
#define MTBDWT_TBCTRL_NUMCOMP(x)                 (((uint32_t)(((uint32_t)(x)) << MTBDWT_TBCTRL_NUMCOMP_SHIFT)) & MTBDWT_TBCTRL_NUMCOMP_MASK)

/*! @name DEVICECFG - Device Configuration Register */
#define MTBDWT_DEVICECFG_DEVICECFG_MASK          (0xFFFFFFFFU)
#define MTBDWT_DEVICECFG_DEVICECFG_SHIFT         (0U)
#define MTBDWT_DEVICECFG_DEVICECFG(x)            (((uint32_t)(((uint32_t)(x)) << MTBDWT_DEVICECFG_DEVICECFG_SHIFT)) & MTBDWT_DEVICECFG_DEVICECFG_MASK)

/*! @name DEVICETYPID - Device Type Identifier Register */
#define MTBDWT_DEVICETYPID_DEVICETYPID_MASK      (0xFFFFFFFFU)
#define MTBDWT_DEVICETYPID_DEVICETYPID_SHIFT     (0U)
#define MTBDWT_DEVICETYPID_DEVICETYPID(x)        (((uint32_t)(((uint32_t)(x)) << MTBDWT_DEVICETYPID_DEVICETYPID_SHIFT)) & MTBDWT_DEVICETYPID_DEVICETYPID_MASK)

/*! @name PERIPHID - Peripheral ID Register */
#define MTBDWT_PERIPHID_PERIPHID_MASK            (0xFFFFFFFFU)
#define MTBDWT_PERIPHID_PERIPHID_SHIFT           (0U)
#define MTBDWT_PERIPHID_PERIPHID(x)              (((uint32_t)(((uint32_t)(x)) << MTBDWT_PERIPHID_PERIPHID_SHIFT)) & MTBDWT_PERIPHID_PERIPHID_MASK)

/* The count of MTBDWT_PERIPHID */
#define MTBDWT_PERIPHID_COUNT                    (8U)

/*! @name COMPID - Component ID Register */
#define MTBDWT_COMPID_COMPID_MASK                (0xFFFFFFFFU)
#define MTBDWT_COMPID_COMPID_SHIFT               (0U)
#define MTBDWT_COMPID_COMPID(x)                  (((uint32_t)(((uint32_t)(x)) << MTBDWT_COMPID_COMPID_SHIFT)) & MTBDWT_COMPID_COMPID_MASK)

/* The count of MTBDWT_COMPID */
#define MTBDWT_COMPID_COUNT                      (4U)


/*!
 * @}
 */ /* end of group MTBDWT_Register_Masks */


/* MTBDWT - Peripheral instance base addresses */
/** Peripheral MTBDWT base pointer */
#define MTBDWT_BASE_PTR                          ((MTBDWT_MemMapPtr)0xF0001000u)
/** Array initializer of MTBDWT peripheral base pointers */
#define MTBDWT_BASE_PTRS                         { MTBDWT_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- MTBDWT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTBDWT_Register_Accessor_Macros MTBDWT - Register accessor macros
 * @{
 */


/* MTBDWT - Register instance definitions */
/* MTBDWT */
#define MTBDWT_CTRL                              MTBDWT_CTRL_REG(MTBDWT_BASE_PTR)
#define MTBDWT_COMP0                             MTBDWT_COMP_REG(MTBDWT_BASE_PTR,0)
#define MTBDWT_MASK0                             MTBDWT_MASK_REG(MTBDWT_BASE_PTR,0)
#define MTBDWT_FCT0                              MTBDWT_FCT_REG(MTBDWT_BASE_PTR,0)
#define MTBDWT_COMP1                             MTBDWT_COMP_REG(MTBDWT_BASE_PTR,1)
#define MTBDWT_MASK1                             MTBDWT_MASK_REG(MTBDWT_BASE_PTR,1)
#define MTBDWT_FCT1                              MTBDWT_FCT_REG(MTBDWT_BASE_PTR,1)
#define MTBDWT_TBCTRL                            MTBDWT_TBCTRL_REG(MTBDWT_BASE_PTR)
#define MTBDWT_DEVICECFG                         MTBDWT_DEVICECFG_REG(MTBDWT_BASE_PTR)
#define MTBDWT_DEVICETYPID                       MTBDWT_DEVICETYPID_REG(MTBDWT_BASE_PTR)
#define MTBDWT_PERIPHID4                         MTBDWT_PERIPHID_REG(MTBDWT_BASE_PTR,0)
#define MTBDWT_PERIPHID5                         MTBDWT_PERIPHID_REG(MTBDWT_BASE_PTR,1)
#define MTBDWT_PERIPHID6                         MTBDWT_PERIPHID_REG(MTBDWT_BASE_PTR,2)
#define MTBDWT_PERIPHID7                         MTBDWT_PERIPHID_REG(MTBDWT_BASE_PTR,3)
#define MTBDWT_PERIPHID0                         MTBDWT_PERIPHID_REG(MTBDWT_BASE_PTR,4)
#define MTBDWT_PERIPHID1                         MTBDWT_PERIPHID_REG(MTBDWT_BASE_PTR,5)
#define MTBDWT_PERIPHID2                         MTBDWT_PERIPHID_REG(MTBDWT_BASE_PTR,6)
#define MTBDWT_PERIPHID3                         MTBDWT_PERIPHID_REG(MTBDWT_BASE_PTR,7)
#define MTBDWT_COMPID0                           MTBDWT_COMPID_REG(MTBDWT_BASE_PTR,0)
#define MTBDWT_COMPID1                           MTBDWT_COMPID_REG(MTBDWT_BASE_PTR,1)
#define MTBDWT_COMPID2                           MTBDWT_COMPID_REG(MTBDWT_BASE_PTR,2)
#define MTBDWT_COMPID3                           MTBDWT_COMPID_REG(MTBDWT_BASE_PTR,3)

/* MTBDWT - Register array accessors */
#define MTBDWT_COMP(index)                       MTBDWT_COMP_REG(MTBDWT_BASE_PTR,index)
#define MTBDWT_MASK(index)                       MTBDWT_MASK_REG(MTBDWT_BASE_PTR,index)
#define MTBDWT_FCT(index)                        MTBDWT_FCT_REG(MTBDWT_BASE_PTR,index)
#define MTBDWT_PERIPHID(index)                   MTBDWT_PERIPHID_REG(MTBDWT_BASE_PTR,index)
#define MTBDWT_COMPID(index)                     MTBDWT_COMPID_REG(MTBDWT_BASE_PTR,index)

/*!
 * @}
 */ /* end of group MTBDWT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MTBDWT_Peripheral */


/* ----------------------------------------------------------------------------
   -- NV
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Peripheral NV
 * @{
 */

/** NV - Peripheral register structure */
typedef struct NV_MemMap {
  uint8_t BACKKEY3;                                /**< Backdoor Comparison Key 3., offset: 0x0 */
  uint8_t BACKKEY2;                                /**< Backdoor Comparison Key 2., offset: 0x1 */
  uint8_t BACKKEY1;                                /**< Backdoor Comparison Key 1., offset: 0x2 */
  uint8_t BACKKEY0;                                /**< Backdoor Comparison Key 0., offset: 0x3 */
  uint8_t BACKKEY7;                                /**< Backdoor Comparison Key 7., offset: 0x4 */
  uint8_t BACKKEY6;                                /**< Backdoor Comparison Key 6., offset: 0x5 */
  uint8_t BACKKEY5;                                /**< Backdoor Comparison Key 5., offset: 0x6 */
  uint8_t BACKKEY4;                                /**< Backdoor Comparison Key 4., offset: 0x7 */
  uint8_t FPROT3;                                  /**< Non-volatile P-Flash Protection 1 - Low Register, offset: 0x8 */
  uint8_t FPROT2;                                  /**< Non-volatile P-Flash Protection 1 - High Register, offset: 0x9 */
  uint8_t FPROT1;                                  /**< Non-volatile P-Flash Protection 0 - Low Register, offset: 0xA */
  uint8_t FPROT0;                                  /**< Non-volatile P-Flash Protection 0 - High Register, offset: 0xB */
  uint8_t FSEC;                                    /**< Non-volatile Flash Security Register, offset: 0xC */
  uint8_t FOPT;                                    /**< Non-volatile Flash Option Register, offset: 0xD */
} volatile *NV_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- NV - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Register_Accessor_Macros NV - Register accessor macros
 * @{
 */


/* NV - Register accessors */
#define NV_BACKKEY3_REG(base)                    ((base)->BACKKEY3)
#define NV_BACKKEY2_REG(base)                    ((base)->BACKKEY2)
#define NV_BACKKEY1_REG(base)                    ((base)->BACKKEY1)
#define NV_BACKKEY0_REG(base)                    ((base)->BACKKEY0)
#define NV_BACKKEY7_REG(base)                    ((base)->BACKKEY7)
#define NV_BACKKEY6_REG(base)                    ((base)->BACKKEY6)
#define NV_BACKKEY5_REG(base)                    ((base)->BACKKEY5)
#define NV_BACKKEY4_REG(base)                    ((base)->BACKKEY4)
#define NV_FPROT3_REG(base)                      ((base)->FPROT3)
#define NV_FPROT2_REG(base)                      ((base)->FPROT2)
#define NV_FPROT1_REG(base)                      ((base)->FPROT1)
#define NV_FPROT0_REG(base)                      ((base)->FPROT0)
#define NV_FSEC_REG(base)                        ((base)->FSEC)
#define NV_FOPT_REG(base)                        ((base)->FOPT)

/*!
 * @}
 */ /* end of group NV_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- NV Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Register_Masks NV Register Masks
 * @{
 */

/*! @name BACKKEY3 - Backdoor Comparison Key 3. */
#define NV_BACKKEY3_KEY_MASK                     (0xFFU)
#define NV_BACKKEY3_KEY_SHIFT                    (0U)
#define NV_BACKKEY3_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY3_KEY_SHIFT)) & NV_BACKKEY3_KEY_MASK)

/*! @name BACKKEY2 - Backdoor Comparison Key 2. */
#define NV_BACKKEY2_KEY_MASK                     (0xFFU)
#define NV_BACKKEY2_KEY_SHIFT                    (0U)
#define NV_BACKKEY2_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY2_KEY_SHIFT)) & NV_BACKKEY2_KEY_MASK)

/*! @name BACKKEY1 - Backdoor Comparison Key 1. */
#define NV_BACKKEY1_KEY_MASK                     (0xFFU)
#define NV_BACKKEY1_KEY_SHIFT                    (0U)
#define NV_BACKKEY1_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY1_KEY_SHIFT)) & NV_BACKKEY1_KEY_MASK)

/*! @name BACKKEY0 - Backdoor Comparison Key 0. */
#define NV_BACKKEY0_KEY_MASK                     (0xFFU)
#define NV_BACKKEY0_KEY_SHIFT                    (0U)
#define NV_BACKKEY0_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY0_KEY_SHIFT)) & NV_BACKKEY0_KEY_MASK)

/*! @name BACKKEY7 - Backdoor Comparison Key 7. */
#define NV_BACKKEY7_KEY_MASK                     (0xFFU)
#define NV_BACKKEY7_KEY_SHIFT                    (0U)
#define NV_BACKKEY7_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY7_KEY_SHIFT)) & NV_BACKKEY7_KEY_MASK)

/*! @name BACKKEY6 - Backdoor Comparison Key 6. */
#define NV_BACKKEY6_KEY_MASK                     (0xFFU)
#define NV_BACKKEY6_KEY_SHIFT                    (0U)
#define NV_BACKKEY6_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY6_KEY_SHIFT)) & NV_BACKKEY6_KEY_MASK)

/*! @name BACKKEY5 - Backdoor Comparison Key 5. */
#define NV_BACKKEY5_KEY_MASK                     (0xFFU)
#define NV_BACKKEY5_KEY_SHIFT                    (0U)
#define NV_BACKKEY5_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY5_KEY_SHIFT)) & NV_BACKKEY5_KEY_MASK)

/*! @name BACKKEY4 - Backdoor Comparison Key 4. */
#define NV_BACKKEY4_KEY_MASK                     (0xFFU)
#define NV_BACKKEY4_KEY_SHIFT                    (0U)
#define NV_BACKKEY4_KEY(x)                       (((uint8_t)(((uint8_t)(x)) << NV_BACKKEY4_KEY_SHIFT)) & NV_BACKKEY4_KEY_MASK)

/*! @name FPROT3 - Non-volatile P-Flash Protection 1 - Low Register */
#define NV_FPROT3_PROT_MASK                      (0xFFU)
#define NV_FPROT3_PROT_SHIFT                     (0U)
#define NV_FPROT3_PROT(x)                        (((uint8_t)(((uint8_t)(x)) << NV_FPROT3_PROT_SHIFT)) & NV_FPROT3_PROT_MASK)

/*! @name FPROT2 - Non-volatile P-Flash Protection 1 - High Register */
#define NV_FPROT2_PROT_MASK                      (0xFFU)
#define NV_FPROT2_PROT_SHIFT                     (0U)
#define NV_FPROT2_PROT(x)                        (((uint8_t)(((uint8_t)(x)) << NV_FPROT2_PROT_SHIFT)) & NV_FPROT2_PROT_MASK)

/*! @name FPROT1 - Non-volatile P-Flash Protection 0 - Low Register */
#define NV_FPROT1_PROT_MASK                      (0xFFU)
#define NV_FPROT1_PROT_SHIFT                     (0U)
#define NV_FPROT1_PROT(x)                        (((uint8_t)(((uint8_t)(x)) << NV_FPROT1_PROT_SHIFT)) & NV_FPROT1_PROT_MASK)

/*! @name FPROT0 - Non-volatile P-Flash Protection 0 - High Register */
#define NV_FPROT0_PROT_MASK                      (0xFFU)
#define NV_FPROT0_PROT_SHIFT                     (0U)
#define NV_FPROT0_PROT(x)                        (((uint8_t)(((uint8_t)(x)) << NV_FPROT0_PROT_SHIFT)) & NV_FPROT0_PROT_MASK)

/*! @name FSEC - Non-volatile Flash Security Register */
#define NV_FSEC_SEC_MASK                         (0x3U)
#define NV_FSEC_SEC_SHIFT                        (0U)
#define NV_FSEC_SEC(x)                           (((uint8_t)(((uint8_t)(x)) << NV_FSEC_SEC_SHIFT)) & NV_FSEC_SEC_MASK)
#define NV_FSEC_FSLACC_MASK                      (0xCU)
#define NV_FSEC_FSLACC_SHIFT                     (2U)
#define NV_FSEC_FSLACC(x)                        (((uint8_t)(((uint8_t)(x)) << NV_FSEC_FSLACC_SHIFT)) & NV_FSEC_FSLACC_MASK)
#define NV_FSEC_MEEN_MASK                        (0x30U)
#define NV_FSEC_MEEN_SHIFT                       (4U)
#define NV_FSEC_MEEN(x)                          (((uint8_t)(((uint8_t)(x)) << NV_FSEC_MEEN_SHIFT)) & NV_FSEC_MEEN_MASK)
#define NV_FSEC_KEYEN_MASK                       (0xC0U)
#define NV_FSEC_KEYEN_SHIFT                      (6U)
#define NV_FSEC_KEYEN(x)                         (((uint8_t)(((uint8_t)(x)) << NV_FSEC_KEYEN_SHIFT)) & NV_FSEC_KEYEN_MASK)

/*! @name FOPT - Non-volatile Flash Option Register */
#define NV_FOPT_LPBOOT0_MASK                     (0x1U)
#define NV_FOPT_LPBOOT0_SHIFT                    (0U)
#define NV_FOPT_NMI_DIS_MASK                     (0x4U)
#define NV_FOPT_NMI_DIS_SHIFT                    (2U)
#define NV_FOPT_RESET_PIN_CFG_MASK               (0x8U)
#define NV_FOPT_RESET_PIN_CFG_SHIFT              (3U)
#define NV_FOPT_LPBOOT1_MASK                     (0x10U)
#define NV_FOPT_LPBOOT1_SHIFT                    (4U)
#define NV_FOPT_FAST_INIT_MASK                   (0x20U)
#define NV_FOPT_FAST_INIT_SHIFT                  (5U)


/*!
 * @}
 */ /* end of group NV_Register_Masks */


/* NV - Peripheral instance base addresses */
/** Peripheral FTFA_FlashConfig base pointer */
#define FTFA_FlashConfig_BASE_PTR                ((NV_MemMapPtr)0x400u)
/** Array initializer of NV peripheral base pointers */
#define NV_BASE_PTRS                             { FTFA_FlashConfig_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- NV - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Register_Accessor_Macros NV - Register accessor macros
 * @{
 */


/* NV - Register instance definitions */
/* FTFA_FlashConfig */
#define NV_BACKKEY3                              NV_BACKKEY3_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_BACKKEY2                              NV_BACKKEY2_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_BACKKEY1                              NV_BACKKEY1_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_BACKKEY0                              NV_BACKKEY0_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_BACKKEY7                              NV_BACKKEY7_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_BACKKEY6                              NV_BACKKEY6_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_BACKKEY5                              NV_BACKKEY5_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_BACKKEY4                              NV_BACKKEY4_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_FPROT3                                NV_FPROT3_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_FPROT2                                NV_FPROT2_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_FPROT1                                NV_FPROT1_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_FPROT0                                NV_FPROT0_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_FSEC                                  NV_FSEC_REG(FTFA_FlashConfig_BASE_PTR)
#define NV_FOPT                                  NV_FOPT_REG(FTFA_FlashConfig_BASE_PTR)

/*!
 * @}
 */ /* end of group NV_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group NV_Peripheral */


/* ----------------------------------------------------------------------------
   -- NVIC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NVIC_Peripheral NVIC
 * @{
 */

/** NVIC - Peripheral register structure */
typedef struct NVIC_MemMap {
  uint32_t ISER;                                   /**< Interrupt Set Enable Register, offset: 0x0 */
  uint8_t RESERVED_0[124];
  uint32_t ICER;                                   /**< Interrupt Clear Enable Register, offset: 0x80 */
  uint8_t RESERVED_1[124];
  uint32_t ISPR;                                   /**< Interrupt Set Pending Register, offset: 0x100 */
  uint8_t RESERVED_2[124];
  uint32_t ICPR;                                   /**< Interrupt Clear Pending Register, offset: 0x180 */
  uint8_t RESERVED_3[380];
  uint32_t IP[8];                                  /**< Interrupt Priority Register 0..Interrupt Priority Register 7, array offset: 0x300, array step: 0x4 */
} volatile *NVIC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- NVIC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NVIC_Register_Accessor_Macros NVIC - Register accessor macros
 * @{
 */


/* NVIC - Register accessors */
#define NVIC_ISER_REG(base)                      ((base)->ISER)
#define NVIC_ICER_REG(base)                      ((base)->ICER)
#define NVIC_ISPR_REG(base)                      ((base)->ISPR)
#define NVIC_ICPR_REG(base)                      ((base)->ICPR)
#define NVIC_IP_REG(base,index)                  ((base)->IP[index])

/*!
 * @}
 */ /* end of group NVIC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- NVIC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NVIC_Register_Masks NVIC Register Masks
 * @{
 */

/*! @name ISER - Interrupt Set Enable Register */
#define NVIC_ISER_SETENA0_MASK                   (0x1U)
#define NVIC_ISER_SETENA0_SHIFT                  (0U)
#define NVIC_ISER_SETENA1_MASK                   (0x2U)
#define NVIC_ISER_SETENA1_SHIFT                  (1U)
#define NVIC_ISER_SETENA2_MASK                   (0x4U)
#define NVIC_ISER_SETENA2_SHIFT                  (2U)
#define NVIC_ISER_SETENA3_MASK                   (0x8U)
#define NVIC_ISER_SETENA3_SHIFT                  (3U)
#define NVIC_ISER_SETENA4_MASK                   (0x10U)
#define NVIC_ISER_SETENA4_SHIFT                  (4U)
#define NVIC_ISER_SETENA5_MASK                   (0x20U)
#define NVIC_ISER_SETENA5_SHIFT                  (5U)
#define NVIC_ISER_SETENA6_MASK                   (0x40U)
#define NVIC_ISER_SETENA6_SHIFT                  (6U)
#define NVIC_ISER_SETENA7_MASK                   (0x80U)
#define NVIC_ISER_SETENA7_SHIFT                  (7U)
#define NVIC_ISER_SETENA8_MASK                   (0x100U)
#define NVIC_ISER_SETENA8_SHIFT                  (8U)
#define NVIC_ISER_SETENA9_MASK                   (0x200U)
#define NVIC_ISER_SETENA9_SHIFT                  (9U)
#define NVIC_ISER_SETENA10_MASK                  (0x400U)
#define NVIC_ISER_SETENA10_SHIFT                 (10U)
#define NVIC_ISER_SETENA11_MASK                  (0x800U)
#define NVIC_ISER_SETENA11_SHIFT                 (11U)
#define NVIC_ISER_SETENA12_MASK                  (0x1000U)
#define NVIC_ISER_SETENA12_SHIFT                 (12U)
#define NVIC_ISER_SETENA13_MASK                  (0x2000U)
#define NVIC_ISER_SETENA13_SHIFT                 (13U)
#define NVIC_ISER_SETENA14_MASK                  (0x4000U)
#define NVIC_ISER_SETENA14_SHIFT                 (14U)
#define NVIC_ISER_SETENA15_MASK                  (0x8000U)
#define NVIC_ISER_SETENA15_SHIFT                 (15U)
#define NVIC_ISER_SETENA16_MASK                  (0x10000U)
#define NVIC_ISER_SETENA16_SHIFT                 (16U)
#define NVIC_ISER_SETENA17_MASK                  (0x20000U)
#define NVIC_ISER_SETENA17_SHIFT                 (17U)
#define NVIC_ISER_SETENA18_MASK                  (0x40000U)
#define NVIC_ISER_SETENA18_SHIFT                 (18U)
#define NVIC_ISER_SETENA19_MASK                  (0x80000U)
#define NVIC_ISER_SETENA19_SHIFT                 (19U)
#define NVIC_ISER_SETENA20_MASK                  (0x100000U)
#define NVIC_ISER_SETENA20_SHIFT                 (20U)
#define NVIC_ISER_SETENA21_MASK                  (0x200000U)
#define NVIC_ISER_SETENA21_SHIFT                 (21U)
#define NVIC_ISER_SETENA22_MASK                  (0x400000U)
#define NVIC_ISER_SETENA22_SHIFT                 (22U)
#define NVIC_ISER_SETENA23_MASK                  (0x800000U)
#define NVIC_ISER_SETENA23_SHIFT                 (23U)
#define NVIC_ISER_SETENA24_MASK                  (0x1000000U)
#define NVIC_ISER_SETENA24_SHIFT                 (24U)
#define NVIC_ISER_SETENA25_MASK                  (0x2000000U)
#define NVIC_ISER_SETENA25_SHIFT                 (25U)
#define NVIC_ISER_SETENA26_MASK                  (0x4000000U)
#define NVIC_ISER_SETENA26_SHIFT                 (26U)
#define NVIC_ISER_SETENA27_MASK                  (0x8000000U)
#define NVIC_ISER_SETENA27_SHIFT                 (27U)
#define NVIC_ISER_SETENA28_MASK                  (0x10000000U)
#define NVIC_ISER_SETENA28_SHIFT                 (28U)
#define NVIC_ISER_SETENA29_MASK                  (0x20000000U)
#define NVIC_ISER_SETENA29_SHIFT                 (29U)
#define NVIC_ISER_SETENA30_MASK                  (0x40000000U)
#define NVIC_ISER_SETENA30_SHIFT                 (30U)
#define NVIC_ISER_SETENA31_MASK                  (0x80000000U)
#define NVIC_ISER_SETENA31_SHIFT                 (31U)

/*! @name ICER - Interrupt Clear Enable Register */
#define NVIC_ICER_CLRENA0_MASK                   (0x1U)
#define NVIC_ICER_CLRENA0_SHIFT                  (0U)
#define NVIC_ICER_CLRENA1_MASK                   (0x2U)
#define NVIC_ICER_CLRENA1_SHIFT                  (1U)
#define NVIC_ICER_CLRENA2_MASK                   (0x4U)
#define NVIC_ICER_CLRENA2_SHIFT                  (2U)
#define NVIC_ICER_CLRENA3_MASK                   (0x8U)
#define NVIC_ICER_CLRENA3_SHIFT                  (3U)
#define NVIC_ICER_CLRENA4_MASK                   (0x10U)
#define NVIC_ICER_CLRENA4_SHIFT                  (4U)
#define NVIC_ICER_CLRENA5_MASK                   (0x20U)
#define NVIC_ICER_CLRENA5_SHIFT                  (5U)
#define NVIC_ICER_CLRENA6_MASK                   (0x40U)
#define NVIC_ICER_CLRENA6_SHIFT                  (6U)
#define NVIC_ICER_CLRENA7_MASK                   (0x80U)
#define NVIC_ICER_CLRENA7_SHIFT                  (7U)
#define NVIC_ICER_CLRENA8_MASK                   (0x100U)
#define NVIC_ICER_CLRENA8_SHIFT                  (8U)
#define NVIC_ICER_CLRENA9_MASK                   (0x200U)
#define NVIC_ICER_CLRENA9_SHIFT                  (9U)
#define NVIC_ICER_CLRENA10_MASK                  (0x400U)
#define NVIC_ICER_CLRENA10_SHIFT                 (10U)
#define NVIC_ICER_CLRENA11_MASK                  (0x800U)
#define NVIC_ICER_CLRENA11_SHIFT                 (11U)
#define NVIC_ICER_CLRENA12_MASK                  (0x1000U)
#define NVIC_ICER_CLRENA12_SHIFT                 (12U)
#define NVIC_ICER_CLRENA13_MASK                  (0x2000U)
#define NVIC_ICER_CLRENA13_SHIFT                 (13U)
#define NVIC_ICER_CLRENA14_MASK                  (0x4000U)
#define NVIC_ICER_CLRENA14_SHIFT                 (14U)
#define NVIC_ICER_CLRENA15_MASK                  (0x8000U)
#define NVIC_ICER_CLRENA15_SHIFT                 (15U)
#define NVIC_ICER_CLRENA16_MASK                  (0x10000U)
#define NVIC_ICER_CLRENA16_SHIFT                 (16U)
#define NVIC_ICER_CLRENA17_MASK                  (0x20000U)
#define NVIC_ICER_CLRENA17_SHIFT                 (17U)
#define NVIC_ICER_CLRENA18_MASK                  (0x40000U)
#define NVIC_ICER_CLRENA18_SHIFT                 (18U)
#define NVIC_ICER_CLRENA19_MASK                  (0x80000U)
#define NVIC_ICER_CLRENA19_SHIFT                 (19U)
#define NVIC_ICER_CLRENA20_MASK                  (0x100000U)
#define NVIC_ICER_CLRENA20_SHIFT                 (20U)
#define NVIC_ICER_CLRENA21_MASK                  (0x200000U)
#define NVIC_ICER_CLRENA21_SHIFT                 (21U)
#define NVIC_ICER_CLRENA22_MASK                  (0x400000U)
#define NVIC_ICER_CLRENA22_SHIFT                 (22U)
#define NVIC_ICER_CLRENA23_MASK                  (0x800000U)
#define NVIC_ICER_CLRENA23_SHIFT                 (23U)
#define NVIC_ICER_CLRENA24_MASK                  (0x1000000U)
#define NVIC_ICER_CLRENA24_SHIFT                 (24U)
#define NVIC_ICER_CLRENA25_MASK                  (0x2000000U)
#define NVIC_ICER_CLRENA25_SHIFT                 (25U)
#define NVIC_ICER_CLRENA26_MASK                  (0x4000000U)
#define NVIC_ICER_CLRENA26_SHIFT                 (26U)
#define NVIC_ICER_CLRENA27_MASK                  (0x8000000U)
#define NVIC_ICER_CLRENA27_SHIFT                 (27U)
#define NVIC_ICER_CLRENA28_MASK                  (0x10000000U)
#define NVIC_ICER_CLRENA28_SHIFT                 (28U)
#define NVIC_ICER_CLRENA29_MASK                  (0x20000000U)
#define NVIC_ICER_CLRENA29_SHIFT                 (29U)
#define NVIC_ICER_CLRENA30_MASK                  (0x40000000U)
#define NVIC_ICER_CLRENA30_SHIFT                 (30U)
#define NVIC_ICER_CLRENA31_MASK                  (0x80000000U)
#define NVIC_ICER_CLRENA31_SHIFT                 (31U)

/*! @name ISPR - Interrupt Set Pending Register */
#define NVIC_ISPR_SETPEND0_MASK                  (0x1U)
#define NVIC_ISPR_SETPEND0_SHIFT                 (0U)
#define NVIC_ISPR_SETPEND1_MASK                  (0x2U)
#define NVIC_ISPR_SETPEND1_SHIFT                 (1U)
#define NVIC_ISPR_SETPEND2_MASK                  (0x4U)
#define NVIC_ISPR_SETPEND2_SHIFT                 (2U)
#define NVIC_ISPR_SETPEND3_MASK                  (0x8U)
#define NVIC_ISPR_SETPEND3_SHIFT                 (3U)
#define NVIC_ISPR_SETPEND4_MASK                  (0x10U)
#define NVIC_ISPR_SETPEND4_SHIFT                 (4U)
#define NVIC_ISPR_SETPEND5_MASK                  (0x20U)
#define NVIC_ISPR_SETPEND5_SHIFT                 (5U)
#define NVIC_ISPR_SETPEND6_MASK                  (0x40U)
#define NVIC_ISPR_SETPEND6_SHIFT                 (6U)
#define NVIC_ISPR_SETPEND7_MASK                  (0x80U)
#define NVIC_ISPR_SETPEND7_SHIFT                 (7U)
#define NVIC_ISPR_SETPEND8_MASK                  (0x100U)
#define NVIC_ISPR_SETPEND8_SHIFT                 (8U)
#define NVIC_ISPR_SETPEND9_MASK                  (0x200U)
#define NVIC_ISPR_SETPEND9_SHIFT                 (9U)
#define NVIC_ISPR_SETPEND10_MASK                 (0x400U)
#define NVIC_ISPR_SETPEND10_SHIFT                (10U)
#define NVIC_ISPR_SETPEND11_MASK                 (0x800U)
#define NVIC_ISPR_SETPEND11_SHIFT                (11U)
#define NVIC_ISPR_SETPEND12_MASK                 (0x1000U)
#define NVIC_ISPR_SETPEND12_SHIFT                (12U)
#define NVIC_ISPR_SETPEND13_MASK                 (0x2000U)
#define NVIC_ISPR_SETPEND13_SHIFT                (13U)
#define NVIC_ISPR_SETPEND14_MASK                 (0x4000U)
#define NVIC_ISPR_SETPEND14_SHIFT                (14U)
#define NVIC_ISPR_SETPEND15_MASK                 (0x8000U)
#define NVIC_ISPR_SETPEND15_SHIFT                (15U)
#define NVIC_ISPR_SETPEND16_MASK                 (0x10000U)
#define NVIC_ISPR_SETPEND16_SHIFT                (16U)
#define NVIC_ISPR_SETPEND17_MASK                 (0x20000U)
#define NVIC_ISPR_SETPEND17_SHIFT                (17U)
#define NVIC_ISPR_SETPEND18_MASK                 (0x40000U)
#define NVIC_ISPR_SETPEND18_SHIFT                (18U)
#define NVIC_ISPR_SETPEND19_MASK                 (0x80000U)
#define NVIC_ISPR_SETPEND19_SHIFT                (19U)
#define NVIC_ISPR_SETPEND20_MASK                 (0x100000U)
#define NVIC_ISPR_SETPEND20_SHIFT                (20U)
#define NVIC_ISPR_SETPEND21_MASK                 (0x200000U)
#define NVIC_ISPR_SETPEND21_SHIFT                (21U)
#define NVIC_ISPR_SETPEND22_MASK                 (0x400000U)
#define NVIC_ISPR_SETPEND22_SHIFT                (22U)
#define NVIC_ISPR_SETPEND23_MASK                 (0x800000U)
#define NVIC_ISPR_SETPEND23_SHIFT                (23U)
#define NVIC_ISPR_SETPEND24_MASK                 (0x1000000U)
#define NVIC_ISPR_SETPEND24_SHIFT                (24U)
#define NVIC_ISPR_SETPEND25_MASK                 (0x2000000U)
#define NVIC_ISPR_SETPEND25_SHIFT                (25U)
#define NVIC_ISPR_SETPEND26_MASK                 (0x4000000U)
#define NVIC_ISPR_SETPEND26_SHIFT                (26U)
#define NVIC_ISPR_SETPEND27_MASK                 (0x8000000U)
#define NVIC_ISPR_SETPEND27_SHIFT                (27U)
#define NVIC_ISPR_SETPEND28_MASK                 (0x10000000U)
#define NVIC_ISPR_SETPEND28_SHIFT                (28U)
#define NVIC_ISPR_SETPEND29_MASK                 (0x20000000U)
#define NVIC_ISPR_SETPEND29_SHIFT                (29U)
#define NVIC_ISPR_SETPEND30_MASK                 (0x40000000U)
#define NVIC_ISPR_SETPEND30_SHIFT                (30U)
#define NVIC_ISPR_SETPEND31_MASK                 (0x80000000U)
#define NVIC_ISPR_SETPEND31_SHIFT                (31U)

/*! @name ICPR - Interrupt Clear Pending Register */
#define NVIC_ICPR_CLRPEND0_MASK                  (0x1U)
#define NVIC_ICPR_CLRPEND0_SHIFT                 (0U)
#define NVIC_ICPR_CLRPEND1_MASK                  (0x2U)
#define NVIC_ICPR_CLRPEND1_SHIFT                 (1U)
#define NVIC_ICPR_CLRPEND2_MASK                  (0x4U)
#define NVIC_ICPR_CLRPEND2_SHIFT                 (2U)
#define NVIC_ICPR_CLRPEND3_MASK                  (0x8U)
#define NVIC_ICPR_CLRPEND3_SHIFT                 (3U)
#define NVIC_ICPR_CLRPEND4_MASK                  (0x10U)
#define NVIC_ICPR_CLRPEND4_SHIFT                 (4U)
#define NVIC_ICPR_CLRPEND5_MASK                  (0x20U)
#define NVIC_ICPR_CLRPEND5_SHIFT                 (5U)
#define NVIC_ICPR_CLRPEND6_MASK                  (0x40U)
#define NVIC_ICPR_CLRPEND6_SHIFT                 (6U)
#define NVIC_ICPR_CLRPEND7_MASK                  (0x80U)
#define NVIC_ICPR_CLRPEND7_SHIFT                 (7U)
#define NVIC_ICPR_CLRPEND8_MASK                  (0x100U)
#define NVIC_ICPR_CLRPEND8_SHIFT                 (8U)
#define NVIC_ICPR_CLRPEND9_MASK                  (0x200U)
#define NVIC_ICPR_CLRPEND9_SHIFT                 (9U)
#define NVIC_ICPR_CLRPEND10_MASK                 (0x400U)
#define NVIC_ICPR_CLRPEND10_SHIFT                (10U)
#define NVIC_ICPR_CLRPEND11_MASK                 (0x800U)
#define NVIC_ICPR_CLRPEND11_SHIFT                (11U)
#define NVIC_ICPR_CLRPEND12_MASK                 (0x1000U)
#define NVIC_ICPR_CLRPEND12_SHIFT                (12U)
#define NVIC_ICPR_CLRPEND13_MASK                 (0x2000U)
#define NVIC_ICPR_CLRPEND13_SHIFT                (13U)
#define NVIC_ICPR_CLRPEND14_MASK                 (0x4000U)
#define NVIC_ICPR_CLRPEND14_SHIFT                (14U)
#define NVIC_ICPR_CLRPEND15_MASK                 (0x8000U)
#define NVIC_ICPR_CLRPEND15_SHIFT                (15U)
#define NVIC_ICPR_CLRPEND16_MASK                 (0x10000U)
#define NVIC_ICPR_CLRPEND16_SHIFT                (16U)
#define NVIC_ICPR_CLRPEND17_MASK                 (0x20000U)
#define NVIC_ICPR_CLRPEND17_SHIFT                (17U)
#define NVIC_ICPR_CLRPEND18_MASK                 (0x40000U)
#define NVIC_ICPR_CLRPEND18_SHIFT                (18U)
#define NVIC_ICPR_CLRPEND19_MASK                 (0x80000U)
#define NVIC_ICPR_CLRPEND19_SHIFT                (19U)
#define NVIC_ICPR_CLRPEND20_MASK                 (0x100000U)
#define NVIC_ICPR_CLRPEND20_SHIFT                (20U)
#define NVIC_ICPR_CLRPEND21_MASK                 (0x200000U)
#define NVIC_ICPR_CLRPEND21_SHIFT                (21U)
#define NVIC_ICPR_CLRPEND22_MASK                 (0x400000U)
#define NVIC_ICPR_CLRPEND22_SHIFT                (22U)
#define NVIC_ICPR_CLRPEND23_MASK                 (0x800000U)
#define NVIC_ICPR_CLRPEND23_SHIFT                (23U)
#define NVIC_ICPR_CLRPEND24_MASK                 (0x1000000U)
#define NVIC_ICPR_CLRPEND24_SHIFT                (24U)
#define NVIC_ICPR_CLRPEND25_MASK                 (0x2000000U)
#define NVIC_ICPR_CLRPEND25_SHIFT                (25U)
#define NVIC_ICPR_CLRPEND26_MASK                 (0x4000000U)
#define NVIC_ICPR_CLRPEND26_SHIFT                (26U)
#define NVIC_ICPR_CLRPEND27_MASK                 (0x8000000U)
#define NVIC_ICPR_CLRPEND27_SHIFT                (27U)
#define NVIC_ICPR_CLRPEND28_MASK                 (0x10000000U)
#define NVIC_ICPR_CLRPEND28_SHIFT                (28U)
#define NVIC_ICPR_CLRPEND29_MASK                 (0x20000000U)
#define NVIC_ICPR_CLRPEND29_SHIFT                (29U)
#define NVIC_ICPR_CLRPEND30_MASK                 (0x40000000U)
#define NVIC_ICPR_CLRPEND30_SHIFT                (30U)
#define NVIC_ICPR_CLRPEND31_MASK                 (0x80000000U)
#define NVIC_ICPR_CLRPEND31_SHIFT                (31U)

/*! @name IP - Interrupt Priority Register 0..Interrupt Priority Register 7 */
#define NVIC_IP_PRI_0_MASK                       (0xC0U)
#define NVIC_IP_PRI_0_SHIFT                      (6U)
#define NVIC_IP_PRI_0(x)                         (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_0_SHIFT)) & NVIC_IP_PRI_0_MASK)
#define NVIC_IP_PRI_28_MASK                      (0xC0U)
#define NVIC_IP_PRI_28_SHIFT                     (6U)
#define NVIC_IP_PRI_28(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_28_SHIFT)) & NVIC_IP_PRI_28_MASK)
#define NVIC_IP_PRI_24_MASK                      (0xC0U)
#define NVIC_IP_PRI_24_SHIFT                     (6U)
#define NVIC_IP_PRI_24(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_24_SHIFT)) & NVIC_IP_PRI_24_MASK)
#define NVIC_IP_PRI_20_MASK                      (0xC0U)
#define NVIC_IP_PRI_20_SHIFT                     (6U)
#define NVIC_IP_PRI_20(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_20_SHIFT)) & NVIC_IP_PRI_20_MASK)
#define NVIC_IP_PRI_4_MASK                       (0xC0U)
#define NVIC_IP_PRI_4_SHIFT                      (6U)
#define NVIC_IP_PRI_4(x)                         (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_4_SHIFT)) & NVIC_IP_PRI_4_MASK)
#define NVIC_IP_PRI_16_MASK                      (0xC0U)
#define NVIC_IP_PRI_16_SHIFT                     (6U)
#define NVIC_IP_PRI_16(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_16_SHIFT)) & NVIC_IP_PRI_16_MASK)
#define NVIC_IP_PRI_12_MASK                      (0xC0U)
#define NVIC_IP_PRI_12_SHIFT                     (6U)
#define NVIC_IP_PRI_12(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_12_SHIFT)) & NVIC_IP_PRI_12_MASK)
#define NVIC_IP_PRI_8_MASK                       (0xC0U)
#define NVIC_IP_PRI_8_SHIFT                      (6U)
#define NVIC_IP_PRI_8(x)                         (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_8_SHIFT)) & NVIC_IP_PRI_8_MASK)
#define NVIC_IP_PRI_13_MASK                      (0xC000U)
#define NVIC_IP_PRI_13_SHIFT                     (14U)
#define NVIC_IP_PRI_13(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_13_SHIFT)) & NVIC_IP_PRI_13_MASK)
#define NVIC_IP_PRI_21_MASK                      (0xC000U)
#define NVIC_IP_PRI_21_SHIFT                     (14U)
#define NVIC_IP_PRI_21(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_21_SHIFT)) & NVIC_IP_PRI_21_MASK)
#define NVIC_IP_PRI_29_MASK                      (0xC000U)
#define NVIC_IP_PRI_29_SHIFT                     (14U)
#define NVIC_IP_PRI_29(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_29_SHIFT)) & NVIC_IP_PRI_29_MASK)
#define NVIC_IP_PRI_1_MASK                       (0xC000U)
#define NVIC_IP_PRI_1_SHIFT                      (14U)
#define NVIC_IP_PRI_1(x)                         (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_1_SHIFT)) & NVIC_IP_PRI_1_MASK)
#define NVIC_IP_PRI_9_MASK                       (0xC000U)
#define NVIC_IP_PRI_9_SHIFT                      (14U)
#define NVIC_IP_PRI_9(x)                         (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_9_SHIFT)) & NVIC_IP_PRI_9_MASK)
#define NVIC_IP_PRI_17_MASK                      (0xC000U)
#define NVIC_IP_PRI_17_SHIFT                     (14U)
#define NVIC_IP_PRI_17(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_17_SHIFT)) & NVIC_IP_PRI_17_MASK)
#define NVIC_IP_PRI_25_MASK                      (0xC000U)
#define NVIC_IP_PRI_25_SHIFT                     (14U)
#define NVIC_IP_PRI_25(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_25_SHIFT)) & NVIC_IP_PRI_25_MASK)
#define NVIC_IP_PRI_5_MASK                       (0xC000U)
#define NVIC_IP_PRI_5_SHIFT                      (14U)
#define NVIC_IP_PRI_5(x)                         (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_5_SHIFT)) & NVIC_IP_PRI_5_MASK)
#define NVIC_IP_PRI_2_MASK                       (0xC00000U)
#define NVIC_IP_PRI_2_SHIFT                      (22U)
#define NVIC_IP_PRI_2(x)                         (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_2_SHIFT)) & NVIC_IP_PRI_2_MASK)
#define NVIC_IP_PRI_26_MASK                      (0xC00000U)
#define NVIC_IP_PRI_26_SHIFT                     (22U)
#define NVIC_IP_PRI_26(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_26_SHIFT)) & NVIC_IP_PRI_26_MASK)
#define NVIC_IP_PRI_18_MASK                      (0xC00000U)
#define NVIC_IP_PRI_18_SHIFT                     (22U)
#define NVIC_IP_PRI_18(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_18_SHIFT)) & NVIC_IP_PRI_18_MASK)
#define NVIC_IP_PRI_14_MASK                      (0xC00000U)
#define NVIC_IP_PRI_14_SHIFT                     (22U)
#define NVIC_IP_PRI_14(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_14_SHIFT)) & NVIC_IP_PRI_14_MASK)
#define NVIC_IP_PRI_6_MASK                       (0xC00000U)
#define NVIC_IP_PRI_6_SHIFT                      (22U)
#define NVIC_IP_PRI_6(x)                         (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_6_SHIFT)) & NVIC_IP_PRI_6_MASK)
#define NVIC_IP_PRI_30_MASK                      (0xC00000U)
#define NVIC_IP_PRI_30_SHIFT                     (22U)
#define NVIC_IP_PRI_30(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_30_SHIFT)) & NVIC_IP_PRI_30_MASK)
#define NVIC_IP_PRI_22_MASK                      (0xC00000U)
#define NVIC_IP_PRI_22_SHIFT                     (22U)
#define NVIC_IP_PRI_22(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_22_SHIFT)) & NVIC_IP_PRI_22_MASK)
#define NVIC_IP_PRI_10_MASK                      (0xC00000U)
#define NVIC_IP_PRI_10_SHIFT                     (22U)
#define NVIC_IP_PRI_10(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_10_SHIFT)) & NVIC_IP_PRI_10_MASK)
#define NVIC_IP_PRI_31_MASK                      (0xC0000000U)
#define NVIC_IP_PRI_31_SHIFT                     (30U)
#define NVIC_IP_PRI_31(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_31_SHIFT)) & NVIC_IP_PRI_31_MASK)
#define NVIC_IP_PRI_27_MASK                      (0xC0000000U)
#define NVIC_IP_PRI_27_SHIFT                     (30U)
#define NVIC_IP_PRI_27(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_27_SHIFT)) & NVIC_IP_PRI_27_MASK)
#define NVIC_IP_PRI_23_MASK                      (0xC0000000U)
#define NVIC_IP_PRI_23_SHIFT                     (30U)
#define NVIC_IP_PRI_23(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_23_SHIFT)) & NVIC_IP_PRI_23_MASK)
#define NVIC_IP_PRI_3_MASK                       (0xC0000000U)
#define NVIC_IP_PRI_3_SHIFT                      (30U)
#define NVIC_IP_PRI_3(x)                         (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_3_SHIFT)) & NVIC_IP_PRI_3_MASK)
#define NVIC_IP_PRI_19_MASK                      (0xC0000000U)
#define NVIC_IP_PRI_19_SHIFT                     (30U)
#define NVIC_IP_PRI_19(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_19_SHIFT)) & NVIC_IP_PRI_19_MASK)
#define NVIC_IP_PRI_15_MASK                      (0xC0000000U)
#define NVIC_IP_PRI_15_SHIFT                     (30U)
#define NVIC_IP_PRI_15(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_15_SHIFT)) & NVIC_IP_PRI_15_MASK)
#define NVIC_IP_PRI_11_MASK                      (0xC0000000U)
#define NVIC_IP_PRI_11_SHIFT                     (30U)
#define NVIC_IP_PRI_11(x)                        (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_11_SHIFT)) & NVIC_IP_PRI_11_MASK)
#define NVIC_IP_PRI_7_MASK                       (0xC0000000U)
#define NVIC_IP_PRI_7_SHIFT                      (30U)
#define NVIC_IP_PRI_7(x)                         (((uint32_t)(((uint32_t)(x)) << NVIC_IP_PRI_7_SHIFT)) & NVIC_IP_PRI_7_MASK)

/* The count of NVIC_IP */
#define NVIC_IP_COUNT                            (8U)


/*!
 * @}
 */ /* end of group NVIC_Register_Masks */


/* NVIC - Peripheral instance base addresses */
/** Peripheral NVIC base pointer */
#define NVIC_BASE_PTR                            ((NVIC_MemMapPtr)0xE000E100u)
/** Array initializer of NVIC peripheral base pointers */
#define NVIC_BASE_PTRS                           { NVIC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- NVIC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NVIC_Register_Accessor_Macros NVIC - Register accessor macros
 * @{
 */


/* NVIC - Register instance definitions */
/* NVIC */
#define NVIC_ISER                                NVIC_ISER_REG(NVIC_BASE_PTR)
#define NVIC_ICER                                NVIC_ICER_REG(NVIC_BASE_PTR)
#define NVIC_ISPR                                NVIC_ISPR_REG(NVIC_BASE_PTR)
#define NVIC_ICPR                                NVIC_ICPR_REG(NVIC_BASE_PTR)
#define NVIC_IPR0                                NVIC_IP_REG(NVIC_BASE_PTR,0)
#define NVIC_IPR1                                NVIC_IP_REG(NVIC_BASE_PTR,1)
#define NVIC_IPR2                                NVIC_IP_REG(NVIC_BASE_PTR,2)
#define NVIC_IPR3                                NVIC_IP_REG(NVIC_BASE_PTR,3)
#define NVIC_IPR4                                NVIC_IP_REG(NVIC_BASE_PTR,4)
#define NVIC_IPR5                                NVIC_IP_REG(NVIC_BASE_PTR,5)
#define NVIC_IPR6                                NVIC_IP_REG(NVIC_BASE_PTR,6)
#define NVIC_IPR7                                NVIC_IP_REG(NVIC_BASE_PTR,7)

/* NVIC - Register array accessors */
#define NVIC_IP(index)                           NVIC_IP_REG(NVIC_BASE_PTR,index)

/*!
 * @}
 */ /* end of group NVIC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group NVIC_Peripheral */


/* ----------------------------------------------------------------------------
   -- PIT
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Peripheral PIT
 * @{
 */

/** PIT - Peripheral register structure */
typedef struct PIT_MemMap {
  uint32_t MCR;                                    /**< PIT Module Control Register, offset: 0x0 */
  uint8_t RESERVED_0[220];
  uint32_t LTMR64H;                                /**< PIT Upper Lifetime Timer Register, offset: 0xE0 */
  uint32_t LTMR64L;                                /**< PIT Lower Lifetime Timer Register, offset: 0xE4 */
  uint8_t RESERVED_1[24];
  struct {                                         /* offset: 0x100, array step: 0x10 */
    uint32_t LDVAL;                                  /**< Timer Load Value Register, array offset: 0x100, array step: 0x10 */
    uint32_t CVAL;                                   /**< Current Timer Value Register, array offset: 0x104, array step: 0x10 */
    uint32_t TCTRL;                                  /**< Timer Control Register, array offset: 0x108, array step: 0x10 */
    uint32_t TFLG;                                   /**< Timer Flag Register, array offset: 0x10C, array step: 0x10 */
  } CHANNEL[2];
} volatile *PIT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PIT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Register_Accessor_Macros PIT - Register accessor macros
 * @{
 */


/* PIT - Register accessors */
#define PIT_MCR_REG(base)                        ((base)->MCR)
#define PIT_LTMR64H_REG(base)                    ((base)->LTMR64H)
#define PIT_LTMR64L_REG(base)                    ((base)->LTMR64L)
#define PIT_LDVAL_REG(base,index)                ((base)->CHANNEL[index].LDVAL)
#define PIT_CVAL_REG(base,index)                 ((base)->CHANNEL[index].CVAL)
#define PIT_TCTRL_REG(base,index)                ((base)->CHANNEL[index].TCTRL)
#define PIT_TFLG_REG(base,index)                 ((base)->CHANNEL[index].TFLG)

/*!
 * @}
 */ /* end of group PIT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PIT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Register_Masks PIT Register Masks
 * @{
 */

/*! @name MCR - PIT Module Control Register */
#define PIT_MCR_FRZ_MASK                         (0x1U)
#define PIT_MCR_FRZ_SHIFT                        (0U)
#define PIT_MCR_MDIS_MASK                        (0x2U)
#define PIT_MCR_MDIS_SHIFT                       (1U)

/*! @name LTMR64H - PIT Upper Lifetime Timer Register */
#define PIT_LTMR64H_LTH_MASK                     (0xFFFFFFFFU)
#define PIT_LTMR64H_LTH_SHIFT                    (0U)
#define PIT_LTMR64H_LTH(x)                       (((uint32_t)(((uint32_t)(x)) << PIT_LTMR64H_LTH_SHIFT)) & PIT_LTMR64H_LTH_MASK)

/*! @name LTMR64L - PIT Lower Lifetime Timer Register */
#define PIT_LTMR64L_LTL_MASK                     (0xFFFFFFFFU)
#define PIT_LTMR64L_LTL_SHIFT                    (0U)
#define PIT_LTMR64L_LTL(x)                       (((uint32_t)(((uint32_t)(x)) << PIT_LTMR64L_LTL_SHIFT)) & PIT_LTMR64L_LTL_MASK)

/*! @name LDVAL - Timer Load Value Register */
#define PIT_LDVAL_TSV_MASK                       (0xFFFFFFFFU)
#define PIT_LDVAL_TSV_SHIFT                      (0U)
#define PIT_LDVAL_TSV(x)                         (((uint32_t)(((uint32_t)(x)) << PIT_LDVAL_TSV_SHIFT)) & PIT_LDVAL_TSV_MASK)

/* The count of PIT_LDVAL */
#define PIT_LDVAL_COUNT                          (2U)

/*! @name CVAL - Current Timer Value Register */
#define PIT_CVAL_TVL_MASK                        (0xFFFFFFFFU)
#define PIT_CVAL_TVL_SHIFT                       (0U)
#define PIT_CVAL_TVL(x)                          (((uint32_t)(((uint32_t)(x)) << PIT_CVAL_TVL_SHIFT)) & PIT_CVAL_TVL_MASK)

/* The count of PIT_CVAL */
#define PIT_CVAL_COUNT                           (2U)

/*! @name TCTRL - Timer Control Register */
#define PIT_TCTRL_TEN_MASK                       (0x1U)
#define PIT_TCTRL_TEN_SHIFT                      (0U)
#define PIT_TCTRL_TIE_MASK                       (0x2U)
#define PIT_TCTRL_TIE_SHIFT                      (1U)
#define PIT_TCTRL_CHN_MASK                       (0x4U)
#define PIT_TCTRL_CHN_SHIFT                      (2U)

/* The count of PIT_TCTRL */
#define PIT_TCTRL_COUNT                          (2U)

/*! @name TFLG - Timer Flag Register */
#define PIT_TFLG_TIF_MASK                        (0x1U)
#define PIT_TFLG_TIF_SHIFT                       (0U)

/* The count of PIT_TFLG */
#define PIT_TFLG_COUNT                           (2U)


/*!
 * @}
 */ /* end of group PIT_Register_Masks */


/* PIT - Peripheral instance base addresses */
/** Peripheral PIT base pointer */
#define PIT_BASE_PTR                             ((PIT_MemMapPtr)0x40037000u)
/** Array initializer of PIT peripheral base pointers */
#define PIT_BASE_PTRS                            { PIT_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- PIT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Register_Accessor_Macros PIT - Register accessor macros
 * @{
 */


/* PIT - Register instance definitions */
/* PIT */
#define PIT_MCR                                  PIT_MCR_REG(PIT_BASE_PTR)
#define PIT_LTMR64H                              PIT_LTMR64H_REG(PIT_BASE_PTR)
#define PIT_LTMR64L                              PIT_LTMR64L_REG(PIT_BASE_PTR)
#define PIT_LDVAL0                               PIT_LDVAL_REG(PIT_BASE_PTR,0)
#define PIT_CVAL0                                PIT_CVAL_REG(PIT_BASE_PTR,0)
#define PIT_TCTRL0                               PIT_TCTRL_REG(PIT_BASE_PTR,0)
#define PIT_TFLG0                                PIT_TFLG_REG(PIT_BASE_PTR,0)
#define PIT_LDVAL1                               PIT_LDVAL_REG(PIT_BASE_PTR,1)
#define PIT_CVAL1                                PIT_CVAL_REG(PIT_BASE_PTR,1)
#define PIT_TCTRL1                               PIT_TCTRL_REG(PIT_BASE_PTR,1)
#define PIT_TFLG1                                PIT_TFLG_REG(PIT_BASE_PTR,1)

/* PIT - Register array accessors */
#define PIT_LDVAL(index)                         PIT_LDVAL_REG(PIT_BASE_PTR,index)
#define PIT_CVAL(index)                          PIT_CVAL_REG(PIT_BASE_PTR,index)
#define PIT_TCTRL(index)                         PIT_TCTRL_REG(PIT_BASE_PTR,index)
#define PIT_TFLG(index)                          PIT_TFLG_REG(PIT_BASE_PTR,index)

/*!
 * @}
 */ /* end of group PIT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group PIT_Peripheral */


/* ----------------------------------------------------------------------------
   -- PMC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Peripheral PMC
 * @{
 */

/** PMC - Peripheral register structure */
typedef struct PMC_MemMap {
  uint8_t LVDSC1;                                  /**< Low Voltage Detect Status And Control 1 register, offset: 0x0 */
  uint8_t LVDSC2;                                  /**< Low Voltage Detect Status And Control 2 register, offset: 0x1 */
  uint8_t REGSC;                                   /**< Regulator Status And Control register, offset: 0x2 */
} volatile *PMC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Accessor_Macros PMC - Register accessor macros
 * @{
 */


/* PMC - Register accessors */
#define PMC_LVDSC1_REG(base)                     ((base)->LVDSC1)
#define PMC_LVDSC2_REG(base)                     ((base)->LVDSC2)
#define PMC_REGSC_REG(base)                      ((base)->REGSC)

/*!
 * @}
 */ /* end of group PMC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Masks PMC Register Masks
 * @{
 */

/*! @name LVDSC1 - Low Voltage Detect Status And Control 1 register */
#define PMC_LVDSC1_LVDV_MASK                     (0x3U)
#define PMC_LVDSC1_LVDV_SHIFT                    (0U)
#define PMC_LVDSC1_LVDV(x)                       (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC1_LVDV_SHIFT)) & PMC_LVDSC1_LVDV_MASK)
#define PMC_LVDSC1_LVDRE_MASK                    (0x10U)
#define PMC_LVDSC1_LVDRE_SHIFT                   (4U)
#define PMC_LVDSC1_LVDIE_MASK                    (0x20U)
#define PMC_LVDSC1_LVDIE_SHIFT                   (5U)
#define PMC_LVDSC1_LVDACK_MASK                   (0x40U)
#define PMC_LVDSC1_LVDACK_SHIFT                  (6U)
#define PMC_LVDSC1_LVDF_MASK                     (0x80U)
#define PMC_LVDSC1_LVDF_SHIFT                    (7U)

/*! @name LVDSC2 - Low Voltage Detect Status And Control 2 register */
#define PMC_LVDSC2_LVWV_MASK                     (0x3U)
#define PMC_LVDSC2_LVWV_SHIFT                    (0U)
#define PMC_LVDSC2_LVWV(x)                       (((uint8_t)(((uint8_t)(x)) << PMC_LVDSC2_LVWV_SHIFT)) & PMC_LVDSC2_LVWV_MASK)
#define PMC_LVDSC2_LVWIE_MASK                    (0x20U)
#define PMC_LVDSC2_LVWIE_SHIFT                   (5U)
#define PMC_LVDSC2_LVWACK_MASK                   (0x40U)
#define PMC_LVDSC2_LVWACK_SHIFT                  (6U)
#define PMC_LVDSC2_LVWF_MASK                     (0x80U)
#define PMC_LVDSC2_LVWF_SHIFT                    (7U)

/*! @name REGSC - Regulator Status And Control register */
#define PMC_REGSC_BGBE_MASK                      (0x1U)
#define PMC_REGSC_BGBE_SHIFT                     (0U)
#define PMC_REGSC_REGONS_MASK                    (0x4U)
#define PMC_REGSC_REGONS_SHIFT                   (2U)
#define PMC_REGSC_ACKISO_MASK                    (0x8U)
#define PMC_REGSC_ACKISO_SHIFT                   (3U)
#define PMC_REGSC_VLPO_MASK                      (0x40U)
#define PMC_REGSC_VLPO_SHIFT                     (6U)


/*!
 * @}
 */ /* end of group PMC_Register_Masks */


/* PMC - Peripheral instance base addresses */
/** Peripheral PMC base pointer */
#define PMC_BASE_PTR                             ((PMC_MemMapPtr)0x4007D000u)
/** Array initializer of PMC peripheral base pointers */
#define PMC_BASE_PTRS                            { PMC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- PMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Accessor_Macros PMC - Register accessor macros
 * @{
 */


/* PMC - Register instance definitions */
/* PMC */
#define PMC_LVDSC1                               PMC_LVDSC1_REG(PMC_BASE_PTR)
#define PMC_LVDSC2                               PMC_LVDSC2_REG(PMC_BASE_PTR)
#define PMC_REGSC                                PMC_REGSC_REG(PMC_BASE_PTR)

/*!
 * @}
 */ /* end of group PMC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group PMC_Peripheral */


/* ----------------------------------------------------------------------------
   -- PORT
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Peripheral PORT
 * @{
 */

/** PORT - Peripheral register structure */
typedef struct PORT_MemMap {
  uint32_t PCR[32];                                /**< Pin Control Register n, array offset: 0x0, array step: 0x4 */
  uint32_t GPCLR;                                  /**< Global Pin Control Low Register, offset: 0x80 */
  uint32_t GPCHR;                                  /**< Global Pin Control High Register, offset: 0x84 */
  uint8_t RESERVED_0[24];
  uint32_t ISFR;                                   /**< Interrupt Status Flag Register, offset: 0xA0 */
} volatile *PORT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PORT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Register_Accessor_Macros PORT - Register accessor macros
 * @{
 */


/* PORT - Register accessors */
#define PORT_PCR_REG(base,index)                 ((base)->PCR[index])
#define PORT_GPCLR_REG(base)                     ((base)->GPCLR)
#define PORT_GPCHR_REG(base)                     ((base)->GPCHR)
#define PORT_ISFR_REG(base)                      ((base)->ISFR)

/*!
 * @}
 */ /* end of group PORT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PORT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Register_Masks PORT Register Masks
 * @{
 */

/*! @name PCR - Pin Control Register n */
#define PORT_PCR_PS_MASK                         (0x1U)
#define PORT_PCR_PS_SHIFT                        (0U)
#define PORT_PCR_PE_MASK                         (0x2U)
#define PORT_PCR_PE_SHIFT                        (1U)
#define PORT_PCR_SRE_MASK                        (0x4U)
#define PORT_PCR_SRE_SHIFT                       (2U)
#define PORT_PCR_PFE_MASK                        (0x10U)
#define PORT_PCR_PFE_SHIFT                       (4U)
#define PORT_PCR_DSE_MASK                        (0x40U)
#define PORT_PCR_DSE_SHIFT                       (6U)
#define PORT_PCR_MUX_MASK                        (0x700U)
#define PORT_PCR_MUX_SHIFT                       (8U)
#define PORT_PCR_MUX(x)                          (((uint32_t)(((uint32_t)(x)) << PORT_PCR_MUX_SHIFT)) & PORT_PCR_MUX_MASK)
#define PORT_PCR_IRQC_MASK                       (0xF0000U)
#define PORT_PCR_IRQC_SHIFT                      (16U)
#define PORT_PCR_IRQC(x)                         (((uint32_t)(((uint32_t)(x)) << PORT_PCR_IRQC_SHIFT)) & PORT_PCR_IRQC_MASK)
#define PORT_PCR_ISF_MASK                        (0x1000000U)
#define PORT_PCR_ISF_SHIFT                       (24U)

/* The count of PORT_PCR */
#define PORT_PCR_COUNT                           (32U)

/*! @name GPCLR - Global Pin Control Low Register */
#define PORT_GPCLR_GPWD_MASK                     (0xFFFFU)
#define PORT_GPCLR_GPWD_SHIFT                    (0U)
#define PORT_GPCLR_GPWD(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GPCLR_GPWD_SHIFT)) & PORT_GPCLR_GPWD_MASK)
#define PORT_GPCLR_GPWE_MASK                     (0xFFFF0000U)
#define PORT_GPCLR_GPWE_SHIFT                    (16U)
#define PORT_GPCLR_GPWE(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GPCLR_GPWE_SHIFT)) & PORT_GPCLR_GPWE_MASK)

/*! @name GPCHR - Global Pin Control High Register */
#define PORT_GPCHR_GPWD_MASK                     (0xFFFFU)
#define PORT_GPCHR_GPWD_SHIFT                    (0U)
#define PORT_GPCHR_GPWD(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GPCHR_GPWD_SHIFT)) & PORT_GPCHR_GPWD_MASK)
#define PORT_GPCHR_GPWE_MASK                     (0xFFFF0000U)
#define PORT_GPCHR_GPWE_SHIFT                    (16U)
#define PORT_GPCHR_GPWE(x)                       (((uint32_t)(((uint32_t)(x)) << PORT_GPCHR_GPWE_SHIFT)) & PORT_GPCHR_GPWE_MASK)

/*! @name ISFR - Interrupt Status Flag Register */
#define PORT_ISFR_ISF_MASK                       (0xFFFFFFFFU)
#define PORT_ISFR_ISF_SHIFT                      (0U)
#define PORT_ISFR_ISF(x)                         (((uint32_t)(((uint32_t)(x)) << PORT_ISFR_ISF_SHIFT)) & PORT_ISFR_ISF_MASK)


/*!
 * @}
 */ /* end of group PORT_Register_Masks */


/* PORT - Peripheral instance base addresses */
/** Peripheral PORTA base pointer */
#define PORTA_BASE_PTR                           ((PORT_MemMapPtr)0x40049000u)
/** Peripheral PORTB base pointer */
#define PORTB_BASE_PTR                           ((PORT_MemMapPtr)0x4004A000u)
/** Peripheral PORTC base pointer */
#define PORTC_BASE_PTR                           ((PORT_MemMapPtr)0x4004B000u)
/** Array initializer of PORT peripheral base pointers */
#define PORT_BASE_PTRS                           { PORTA_BASE_PTR, PORTB_BASE_PTR, PORTC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- PORT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Register_Accessor_Macros PORT - Register accessor macros
 * @{
 */


/* PORT - Register instance definitions */
/* PORTA */
#define PORTA_PCR0                               PORT_PCR_REG(PORTA_BASE_PTR,0)
#define PORTA_PCR1                               PORT_PCR_REG(PORTA_BASE_PTR,1)
#define PORTA_PCR2                               PORT_PCR_REG(PORTA_BASE_PTR,2)
#define PORTA_PCR3                               PORT_PCR_REG(PORTA_BASE_PTR,3)
#define PORTA_PCR4                               PORT_PCR_REG(PORTA_BASE_PTR,4)
#define PORTA_PCR5                               PORT_PCR_REG(PORTA_BASE_PTR,5)
#define PORTA_PCR6                               PORT_PCR_REG(PORTA_BASE_PTR,6)
#define PORTA_PCR7                               PORT_PCR_REG(PORTA_BASE_PTR,7)
#define PORTA_PCR8                               PORT_PCR_REG(PORTA_BASE_PTR,8)
#define PORTA_PCR9                               PORT_PCR_REG(PORTA_BASE_PTR,9)
#define PORTA_PCR10                              PORT_PCR_REG(PORTA_BASE_PTR,10)
#define PORTA_PCR11                              PORT_PCR_REG(PORTA_BASE_PTR,11)
#define PORTA_PCR12                              PORT_PCR_REG(PORTA_BASE_PTR,12)
#define PORTA_PCR13                              PORT_PCR_REG(PORTA_BASE_PTR,13)
#define PORTA_PCR14                              PORT_PCR_REG(PORTA_BASE_PTR,14)
#define PORTA_PCR15                              PORT_PCR_REG(PORTA_BASE_PTR,15)
#define PORTA_PCR16                              PORT_PCR_REG(PORTA_BASE_PTR,16)
#define PORTA_PCR17                              PORT_PCR_REG(PORTA_BASE_PTR,17)
#define PORTA_PCR18                              PORT_PCR_REG(PORTA_BASE_PTR,18)
#define PORTA_PCR19                              PORT_PCR_REG(PORTA_BASE_PTR,19)
#define PORTA_PCR20                              PORT_PCR_REG(PORTA_BASE_PTR,20)
#define PORTA_PCR21                              PORT_PCR_REG(PORTA_BASE_PTR,21)
#define PORTA_PCR22                              PORT_PCR_REG(PORTA_BASE_PTR,22)
#define PORTA_PCR23                              PORT_PCR_REG(PORTA_BASE_PTR,23)
#define PORTA_PCR24                              PORT_PCR_REG(PORTA_BASE_PTR,24)
#define PORTA_PCR25                              PORT_PCR_REG(PORTA_BASE_PTR,25)
#define PORTA_PCR26                              PORT_PCR_REG(PORTA_BASE_PTR,26)
#define PORTA_PCR27                              PORT_PCR_REG(PORTA_BASE_PTR,27)
#define PORTA_PCR28                              PORT_PCR_REG(PORTA_BASE_PTR,28)
#define PORTA_PCR29                              PORT_PCR_REG(PORTA_BASE_PTR,29)
#define PORTA_PCR30                              PORT_PCR_REG(PORTA_BASE_PTR,30)
#define PORTA_PCR31                              PORT_PCR_REG(PORTA_BASE_PTR,31)
#define PORTA_GPCLR                              PORT_GPCLR_REG(PORTA_BASE_PTR)
#define PORTA_GPCHR                              PORT_GPCHR_REG(PORTA_BASE_PTR)
#define PORTA_ISFR                               PORT_ISFR_REG(PORTA_BASE_PTR)
/* PORTB */
#define PORTB_PCR0                               PORT_PCR_REG(PORTB_BASE_PTR,0)
#define PORTB_PCR1                               PORT_PCR_REG(PORTB_BASE_PTR,1)
#define PORTB_PCR2                               PORT_PCR_REG(PORTB_BASE_PTR,2)
#define PORTB_PCR3                               PORT_PCR_REG(PORTB_BASE_PTR,3)
#define PORTB_PCR4                               PORT_PCR_REG(PORTB_BASE_PTR,4)
#define PORTB_PCR5                               PORT_PCR_REG(PORTB_BASE_PTR,5)
#define PORTB_PCR6                               PORT_PCR_REG(PORTB_BASE_PTR,6)
#define PORTB_PCR7                               PORT_PCR_REG(PORTB_BASE_PTR,7)
#define PORTB_PCR8                               PORT_PCR_REG(PORTB_BASE_PTR,8)
#define PORTB_PCR9                               PORT_PCR_REG(PORTB_BASE_PTR,9)
#define PORTB_PCR10                              PORT_PCR_REG(PORTB_BASE_PTR,10)
#define PORTB_PCR11                              PORT_PCR_REG(PORTB_BASE_PTR,11)
#define PORTB_PCR12                              PORT_PCR_REG(PORTB_BASE_PTR,12)
#define PORTB_PCR13                              PORT_PCR_REG(PORTB_BASE_PTR,13)
#define PORTB_PCR14                              PORT_PCR_REG(PORTB_BASE_PTR,14)
#define PORTB_PCR15                              PORT_PCR_REG(PORTB_BASE_PTR,15)
#define PORTB_PCR16                              PORT_PCR_REG(PORTB_BASE_PTR,16)
#define PORTB_PCR17                              PORT_PCR_REG(PORTB_BASE_PTR,17)
#define PORTB_PCR18                              PORT_PCR_REG(PORTB_BASE_PTR,18)
#define PORTB_PCR19                              PORT_PCR_REG(PORTB_BASE_PTR,19)
#define PORTB_PCR20                              PORT_PCR_REG(PORTB_BASE_PTR,20)
#define PORTB_PCR21                              PORT_PCR_REG(PORTB_BASE_PTR,21)
#define PORTB_PCR22                              PORT_PCR_REG(PORTB_BASE_PTR,22)
#define PORTB_PCR23                              PORT_PCR_REG(PORTB_BASE_PTR,23)
#define PORTB_PCR24                              PORT_PCR_REG(PORTB_BASE_PTR,24)
#define PORTB_PCR25                              PORT_PCR_REG(PORTB_BASE_PTR,25)
#define PORTB_PCR26                              PORT_PCR_REG(PORTB_BASE_PTR,26)
#define PORTB_PCR27                              PORT_PCR_REG(PORTB_BASE_PTR,27)
#define PORTB_PCR28                              PORT_PCR_REG(PORTB_BASE_PTR,28)
#define PORTB_PCR29                              PORT_PCR_REG(PORTB_BASE_PTR,29)
#define PORTB_PCR30                              PORT_PCR_REG(PORTB_BASE_PTR,30)
#define PORTB_PCR31                              PORT_PCR_REG(PORTB_BASE_PTR,31)
#define PORTB_GPCLR                              PORT_GPCLR_REG(PORTB_BASE_PTR)
#define PORTB_GPCHR                              PORT_GPCHR_REG(PORTB_BASE_PTR)
#define PORTB_ISFR                               PORT_ISFR_REG(PORTB_BASE_PTR)
/* PORTC */
#define PORTC_PCR0                               PORT_PCR_REG(PORTC_BASE_PTR,0)
#define PORTC_PCR1                               PORT_PCR_REG(PORTC_BASE_PTR,1)
#define PORTC_PCR2                               PORT_PCR_REG(PORTC_BASE_PTR,2)
#define PORTC_PCR3                               PORT_PCR_REG(PORTC_BASE_PTR,3)
#define PORTC_PCR4                               PORT_PCR_REG(PORTC_BASE_PTR,4)
#define PORTC_PCR5                               PORT_PCR_REG(PORTC_BASE_PTR,5)
#define PORTC_PCR6                               PORT_PCR_REG(PORTC_BASE_PTR,6)
#define PORTC_PCR7                               PORT_PCR_REG(PORTC_BASE_PTR,7)
#define PORTC_PCR8                               PORT_PCR_REG(PORTC_BASE_PTR,8)
#define PORTC_PCR9                               PORT_PCR_REG(PORTC_BASE_PTR,9)
#define PORTC_PCR10                              PORT_PCR_REG(PORTC_BASE_PTR,10)
#define PORTC_PCR11                              PORT_PCR_REG(PORTC_BASE_PTR,11)
#define PORTC_PCR12                              PORT_PCR_REG(PORTC_BASE_PTR,12)
#define PORTC_PCR13                              PORT_PCR_REG(PORTC_BASE_PTR,13)
#define PORTC_PCR14                              PORT_PCR_REG(PORTC_BASE_PTR,14)
#define PORTC_PCR15                              PORT_PCR_REG(PORTC_BASE_PTR,15)
#define PORTC_PCR16                              PORT_PCR_REG(PORTC_BASE_PTR,16)
#define PORTC_PCR17                              PORT_PCR_REG(PORTC_BASE_PTR,17)
#define PORTC_PCR18                              PORT_PCR_REG(PORTC_BASE_PTR,18)
#define PORTC_PCR19                              PORT_PCR_REG(PORTC_BASE_PTR,19)
#define PORTC_PCR20                              PORT_PCR_REG(PORTC_BASE_PTR,20)
#define PORTC_PCR21                              PORT_PCR_REG(PORTC_BASE_PTR,21)
#define PORTC_PCR22                              PORT_PCR_REG(PORTC_BASE_PTR,22)
#define PORTC_PCR23                              PORT_PCR_REG(PORTC_BASE_PTR,23)
#define PORTC_PCR24                              PORT_PCR_REG(PORTC_BASE_PTR,24)
#define PORTC_PCR25                              PORT_PCR_REG(PORTC_BASE_PTR,25)
#define PORTC_PCR26                              PORT_PCR_REG(PORTC_BASE_PTR,26)
#define PORTC_PCR27                              PORT_PCR_REG(PORTC_BASE_PTR,27)
#define PORTC_PCR28                              PORT_PCR_REG(PORTC_BASE_PTR,28)
#define PORTC_PCR29                              PORT_PCR_REG(PORTC_BASE_PTR,29)
#define PORTC_PCR30                              PORT_PCR_REG(PORTC_BASE_PTR,30)
#define PORTC_PCR31                              PORT_PCR_REG(PORTC_BASE_PTR,31)
#define PORTC_GPCLR                              PORT_GPCLR_REG(PORTC_BASE_PTR)
#define PORTC_GPCHR                              PORT_GPCHR_REG(PORTC_BASE_PTR)
#define PORTC_ISFR                               PORT_ISFR_REG(PORTC_BASE_PTR)

/* PORT - Register array accessors */
#define PORTA_PCR(index)                         PORT_PCR_REG(PORTA_BASE_PTR,index)
#define PORTB_PCR(index)                         PORT_PCR_REG(PORTB_BASE_PTR,index)
#define PORTC_PCR(index)                         PORT_PCR_REG(PORTC_BASE_PTR,index)

/*!
 * @}
 */ /* end of group PORT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group PORT_Peripheral */


/* ----------------------------------------------------------------------------
   -- RCM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RCM_Peripheral RCM
 * @{
 */

/** RCM - Peripheral register structure */
typedef struct RCM_MemMap {
  uint8_t SRS0;                                    /**< System Reset Status Register 0, offset: 0x0 */
  uint8_t SRS1;                                    /**< System Reset Status Register 1, offset: 0x1 */
  uint8_t RESERVED_0[2];
  uint8_t RPFC;                                    /**< Reset Pin Filter Control register, offset: 0x4 */
  uint8_t RPFW;                                    /**< Reset Pin Filter Width register, offset: 0x5 */
} volatile *RCM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- RCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RCM_Register_Accessor_Macros RCM - Register accessor macros
 * @{
 */


/* RCM - Register accessors */
#define RCM_SRS0_REG(base)                       ((base)->SRS0)
#define RCM_SRS1_REG(base)                       ((base)->SRS1)
#define RCM_RPFC_REG(base)                       ((base)->RPFC)
#define RCM_RPFW_REG(base)                       ((base)->RPFW)

/*!
 * @}
 */ /* end of group RCM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- RCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RCM_Register_Masks RCM Register Masks
 * @{
 */

/*! @name SRS0 - System Reset Status Register 0 */
#define RCM_SRS0_WAKEUP_MASK                     (0x1U)
#define RCM_SRS0_WAKEUP_SHIFT                    (0U)
#define RCM_SRS0_LVD_MASK                        (0x2U)
#define RCM_SRS0_LVD_SHIFT                       (1U)
#define RCM_SRS0_LOC_MASK                        (0x4U)
#define RCM_SRS0_LOC_SHIFT                       (2U)
#define RCM_SRS0_WDOG_MASK                       (0x20U)
#define RCM_SRS0_WDOG_SHIFT                      (5U)
#define RCM_SRS0_PIN_MASK                        (0x40U)
#define RCM_SRS0_PIN_SHIFT                       (6U)
#define RCM_SRS0_POR_MASK                        (0x80U)
#define RCM_SRS0_POR_SHIFT                       (7U)

/*! @name SRS1 - System Reset Status Register 1 */
#define RCM_SRS1_LOCKUP_MASK                     (0x2U)
#define RCM_SRS1_LOCKUP_SHIFT                    (1U)
#define RCM_SRS1_SW_MASK                         (0x4U)
#define RCM_SRS1_SW_SHIFT                        (2U)
#define RCM_SRS1_MDM_AP_MASK                     (0x8U)
#define RCM_SRS1_MDM_AP_SHIFT                    (3U)
#define RCM_SRS1_SACKERR_MASK                    (0x20U)
#define RCM_SRS1_SACKERR_SHIFT                   (5U)

/*! @name RPFC - Reset Pin Filter Control register */
#define RCM_RPFC_RSTFLTSRW_MASK                  (0x3U)
#define RCM_RPFC_RSTFLTSRW_SHIFT                 (0U)
#define RCM_RPFC_RSTFLTSRW(x)                    (((uint8_t)(((uint8_t)(x)) << RCM_RPFC_RSTFLTSRW_SHIFT)) & RCM_RPFC_RSTFLTSRW_MASK)
#define RCM_RPFC_RSTFLTSS_MASK                   (0x4U)
#define RCM_RPFC_RSTFLTSS_SHIFT                  (2U)

/*! @name RPFW - Reset Pin Filter Width register */
#define RCM_RPFW_RSTFLTSEL_MASK                  (0x1FU)
#define RCM_RPFW_RSTFLTSEL_SHIFT                 (0U)
#define RCM_RPFW_RSTFLTSEL(x)                    (((uint8_t)(((uint8_t)(x)) << RCM_RPFW_RSTFLTSEL_SHIFT)) & RCM_RPFW_RSTFLTSEL_MASK)


/*!
 * @}
 */ /* end of group RCM_Register_Masks */


/* RCM - Peripheral instance base addresses */
/** Peripheral RCM base pointer */
#define RCM_BASE_PTR                             ((RCM_MemMapPtr)0x4007F000u)
/** Array initializer of RCM peripheral base pointers */
#define RCM_BASE_PTRS                            { RCM_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- RCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RCM_Register_Accessor_Macros RCM - Register accessor macros
 * @{
 */


/* RCM - Register instance definitions */
/* RCM */
#define RCM_SRS0                                 RCM_SRS0_REG(RCM_BASE_PTR)
#define RCM_SRS1                                 RCM_SRS1_REG(RCM_BASE_PTR)
#define RCM_RPFC                                 RCM_RPFC_REG(RCM_BASE_PTR)
#define RCM_RPFW                                 RCM_RPFW_REG(RCM_BASE_PTR)

/*!
 * @}
 */ /* end of group RCM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group RCM_Peripheral */


/* ----------------------------------------------------------------------------
   -- ROM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ROM_Peripheral ROM
 * @{
 */

/** ROM - Peripheral register structure */
typedef struct ROM_MemMap {
  uint32_t ENTRY[3];                               /**< Entry, array offset: 0x0, array step: 0x4 */
  uint32_t TABLEMARK;                              /**< End of Table Marker Register, offset: 0xC */
  uint8_t RESERVED_0[4028];
  uint32_t SYSACCESS;                              /**< System Access Register, offset: 0xFCC */
  uint32_t PERIPHID4;                              /**< Peripheral ID Register, offset: 0xFD0 */
  uint32_t PERIPHID5;                              /**< Peripheral ID Register, offset: 0xFD4 */
  uint32_t PERIPHID6;                              /**< Peripheral ID Register, offset: 0xFD8 */
  uint32_t PERIPHID7;                              /**< Peripheral ID Register, offset: 0xFDC */
  uint32_t PERIPHID0;                              /**< Peripheral ID Register, offset: 0xFE0 */
  uint32_t PERIPHID1;                              /**< Peripheral ID Register, offset: 0xFE4 */
  uint32_t PERIPHID2;                              /**< Peripheral ID Register, offset: 0xFE8 */
  uint32_t PERIPHID3;                              /**< Peripheral ID Register, offset: 0xFEC */
  uint32_t COMPID[4];                              /**< Component ID Register, array offset: 0xFF0, array step: 0x4 */
} volatile *ROM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ROM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ROM_Register_Accessor_Macros ROM - Register accessor macros
 * @{
 */


/* ROM - Register accessors */
#define ROM_ENTRY_REG(base,index)                ((base)->ENTRY[index])
#define ROM_TABLEMARK_REG(base)                  ((base)->TABLEMARK)
#define ROM_SYSACCESS_REG(base)                  ((base)->SYSACCESS)
#define ROM_PERIPHID4_REG(base)                  ((base)->PERIPHID4)
#define ROM_PERIPHID5_REG(base)                  ((base)->PERIPHID5)
#define ROM_PERIPHID6_REG(base)                  ((base)->PERIPHID6)
#define ROM_PERIPHID7_REG(base)                  ((base)->PERIPHID7)
#define ROM_PERIPHID0_REG(base)                  ((base)->PERIPHID0)
#define ROM_PERIPHID1_REG(base)                  ((base)->PERIPHID1)
#define ROM_PERIPHID2_REG(base)                  ((base)->PERIPHID2)
#define ROM_PERIPHID3_REG(base)                  ((base)->PERIPHID3)
#define ROM_COMPID_REG(base,index)               ((base)->COMPID[index])

/*!
 * @}
 */ /* end of group ROM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ROM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ROM_Register_Masks ROM Register Masks
 * @{
 */

/*! @name ENTRY - Entry */
#define ROM_ENTRY_ENTRY_MASK                     (0xFFFFFFFFU)
#define ROM_ENTRY_ENTRY_SHIFT                    (0U)
#define ROM_ENTRY_ENTRY(x)                       (((uint32_t)(((uint32_t)(x)) << ROM_ENTRY_ENTRY_SHIFT)) & ROM_ENTRY_ENTRY_MASK)

/* The count of ROM_ENTRY */
#define ROM_ENTRY_COUNT                          (3U)

/*! @name TABLEMARK - End of Table Marker Register */
#define ROM_TABLEMARK_MARK_MASK                  (0xFFFFFFFFU)
#define ROM_TABLEMARK_MARK_SHIFT                 (0U)
#define ROM_TABLEMARK_MARK(x)                    (((uint32_t)(((uint32_t)(x)) << ROM_TABLEMARK_MARK_SHIFT)) & ROM_TABLEMARK_MARK_MASK)

/*! @name SYSACCESS - System Access Register */
#define ROM_SYSACCESS_SYSACCESS_MASK             (0xFFFFFFFFU)
#define ROM_SYSACCESS_SYSACCESS_SHIFT            (0U)
#define ROM_SYSACCESS_SYSACCESS(x)               (((uint32_t)(((uint32_t)(x)) << ROM_SYSACCESS_SYSACCESS_SHIFT)) & ROM_SYSACCESS_SYSACCESS_MASK)

/*! @name PERIPHID4 - Peripheral ID Register */
#define ROM_PERIPHID4_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID4_PERIPHID_SHIFT             (0U)
#define ROM_PERIPHID4_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID4_PERIPHID_SHIFT)) & ROM_PERIPHID4_PERIPHID_MASK)

/*! @name PERIPHID5 - Peripheral ID Register */
#define ROM_PERIPHID5_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID5_PERIPHID_SHIFT             (0U)
#define ROM_PERIPHID5_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID5_PERIPHID_SHIFT)) & ROM_PERIPHID5_PERIPHID_MASK)

/*! @name PERIPHID6 - Peripheral ID Register */
#define ROM_PERIPHID6_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID6_PERIPHID_SHIFT             (0U)
#define ROM_PERIPHID6_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID6_PERIPHID_SHIFT)) & ROM_PERIPHID6_PERIPHID_MASK)

/*! @name PERIPHID7 - Peripheral ID Register */
#define ROM_PERIPHID7_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID7_PERIPHID_SHIFT             (0U)
#define ROM_PERIPHID7_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID7_PERIPHID_SHIFT)) & ROM_PERIPHID7_PERIPHID_MASK)

/*! @name PERIPHID0 - Peripheral ID Register */
#define ROM_PERIPHID0_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID0_PERIPHID_SHIFT             (0U)
#define ROM_PERIPHID0_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID0_PERIPHID_SHIFT)) & ROM_PERIPHID0_PERIPHID_MASK)

/*! @name PERIPHID1 - Peripheral ID Register */
#define ROM_PERIPHID1_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID1_PERIPHID_SHIFT             (0U)
#define ROM_PERIPHID1_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID1_PERIPHID_SHIFT)) & ROM_PERIPHID1_PERIPHID_MASK)

/*! @name PERIPHID2 - Peripheral ID Register */
#define ROM_PERIPHID2_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID2_PERIPHID_SHIFT             (0U)
#define ROM_PERIPHID2_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID2_PERIPHID_SHIFT)) & ROM_PERIPHID2_PERIPHID_MASK)

/*! @name PERIPHID3 - Peripheral ID Register */
#define ROM_PERIPHID3_PERIPHID_MASK              (0xFFFFFFFFU)
#define ROM_PERIPHID3_PERIPHID_SHIFT             (0U)
#define ROM_PERIPHID3_PERIPHID(x)                (((uint32_t)(((uint32_t)(x)) << ROM_PERIPHID3_PERIPHID_SHIFT)) & ROM_PERIPHID3_PERIPHID_MASK)

/*! @name COMPID - Component ID Register */
#define ROM_COMPID_COMPID_MASK                   (0xFFFFFFFFU)
#define ROM_COMPID_COMPID_SHIFT                  (0U)
#define ROM_COMPID_COMPID(x)                     (((uint32_t)(((uint32_t)(x)) << ROM_COMPID_COMPID_SHIFT)) & ROM_COMPID_COMPID_MASK)

/* The count of ROM_COMPID */
#define ROM_COMPID_COUNT                         (4U)


/*!
 * @}
 */ /* end of group ROM_Register_Masks */


/* ROM - Peripheral instance base addresses */
/** Peripheral ROM base pointer */
#define ROM_BASE_PTR                             ((ROM_MemMapPtr)0xF0002000u)
/** Array initializer of ROM peripheral base pointers */
#define ROM_BASE_PTRS                            { ROM_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- ROM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ROM_Register_Accessor_Macros ROM - Register accessor macros
 * @{
 */


/* ROM - Register instance definitions */
/* ROM */
#define ROM_ENTRY0                               ROM_ENTRY_REG(ROM_BASE_PTR,0)
#define ROM_ENTRY1                               ROM_ENTRY_REG(ROM_BASE_PTR,1)
#define ROM_ENTRY2                               ROM_ENTRY_REG(ROM_BASE_PTR,2)
#define ROM_TABLEMARK                            ROM_TABLEMARK_REG(ROM_BASE_PTR)
#define ROM_SYSACCESS                            ROM_SYSACCESS_REG(ROM_BASE_PTR)
#define ROM_PERIPHID4                            ROM_PERIPHID4_REG(ROM_BASE_PTR)
#define ROM_PERIPHID5                            ROM_PERIPHID5_REG(ROM_BASE_PTR)
#define ROM_PERIPHID6                            ROM_PERIPHID6_REG(ROM_BASE_PTR)
#define ROM_PERIPHID7                            ROM_PERIPHID7_REG(ROM_BASE_PTR)
#define ROM_PERIPHID0                            ROM_PERIPHID0_REG(ROM_BASE_PTR)
#define ROM_PERIPHID1                            ROM_PERIPHID1_REG(ROM_BASE_PTR)
#define ROM_PERIPHID2                            ROM_PERIPHID2_REG(ROM_BASE_PTR)
#define ROM_PERIPHID3                            ROM_PERIPHID3_REG(ROM_BASE_PTR)
#define ROM_COMPID0                              ROM_COMPID_REG(ROM_BASE_PTR,0)
#define ROM_COMPID1                              ROM_COMPID_REG(ROM_BASE_PTR,1)
#define ROM_COMPID2                              ROM_COMPID_REG(ROM_BASE_PTR,2)
#define ROM_COMPID3                              ROM_COMPID_REG(ROM_BASE_PTR,3)

/* ROM - Register array accessors */
#define ROM_ENTRY(index)                         ROM_ENTRY_REG(ROM_BASE_PTR,index)
#define ROM_COMPID(index)                        ROM_COMPID_REG(ROM_BASE_PTR,index)

/*!
 * @}
 */ /* end of group ROM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ROM_Peripheral */


/* ----------------------------------------------------------------------------
   -- RSIM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RSIM_Peripheral RSIM
 * @{
 */

/** RSIM - Peripheral register structure */
typedef struct RSIM_MemMap {
  uint32_t CONTROL;                                /**< Radio System Control, offset: 0x0 */
  uint32_t ACTIVE_DELAY;                           /**< Radio Active Early Warning, offset: 0x4 */
  uint32_t MAC_MSB;                                /**< Radio MAC Address, offset: 0x8 */
  uint32_t MAC_LSB;                                /**< Radio MAC Address, offset: 0xC */
  uint32_t MISC;                                   /**< Radio Miscellaneous, offset: 0x10 */
  uint8_t RESERVED_0[236];
  uint32_t DSM_TIMER;                              /**< Deep Sleep Timer, offset: 0x100 */
  uint32_t DSM_CONTROL;                            /**< Deep Sleep Timer Control, offset: 0x104 */
  uint32_t DSM_OSC_OFFSET;                         /**< Deep Sleep Wakeup Time Offset, offset: 0x108 */
  uint32_t ANT_SLEEP;                              /**< ANT Link Layer Sleep Time, offset: 0x10C */
  uint32_t ANT_WAKE;                               /**< ANT Link Layer Wake Time, offset: 0x110 */
  uint32_t ZIG_SLEEP;                              /**< 802.15.4 Link Layer Sleep Time, offset: 0x114 */
  uint32_t ZIG_WAKE;                               /**< 802.15.4 Link Layer Wake Time, offset: 0x118 */
  uint32_t GEN_SLEEP;                              /**< Generic FSK Link Layer Sleep Time, offset: 0x11C */
  uint32_t GEN_WAKE;                               /**< Generic FSK Link Layer Wake Time, offset: 0x120 */
  uint32_t RF_OSC_CTRL;                            /**< Radio Oscillator Control, offset: 0x124 */
  uint32_t ANA_TEST;                               /**< Radio Analog Test Registers, offset: 0x128 */
  uint32_t ANA_TRIM;                               /**< Radio Analog Trim Registers, offset: 0x12C */
} volatile *RSIM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- RSIM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RSIM_Register_Accessor_Macros RSIM - Register accessor macros
 * @{
 */


/* RSIM - Register accessors */
#define RSIM_CONTROL_REG(base)                   ((base)->CONTROL)
#define RSIM_ACTIVE_DELAY_REG(base)              ((base)->ACTIVE_DELAY)
#define RSIM_MAC_MSB_REG(base)                   ((base)->MAC_MSB)
#define RSIM_MAC_LSB_REG(base)                   ((base)->MAC_LSB)
#define RSIM_MISC_REG(base)                      ((base)->MISC)
#define RSIM_DSM_TIMER_REG(base)                 ((base)->DSM_TIMER)
#define RSIM_DSM_CONTROL_REG(base)               ((base)->DSM_CONTROL)
#define RSIM_DSM_OSC_OFFSET_REG(base)            ((base)->DSM_OSC_OFFSET)
#define RSIM_ANT_SLEEP_REG(base)                 ((base)->ANT_SLEEP)
#define RSIM_ANT_WAKE_REG(base)                  ((base)->ANT_WAKE)
#define RSIM_ZIG_SLEEP_REG(base)                 ((base)->ZIG_SLEEP)
#define RSIM_ZIG_WAKE_REG(base)                  ((base)->ZIG_WAKE)
#define RSIM_GEN_SLEEP_REG(base)                 ((base)->GEN_SLEEP)
#define RSIM_GEN_WAKE_REG(base)                  ((base)->GEN_WAKE)
#define RSIM_RF_OSC_CTRL_REG(base)               ((base)->RF_OSC_CTRL)
#define RSIM_ANA_TEST_REG(base)                  ((base)->ANA_TEST)
#define RSIM_ANA_TRIM_REG(base)                  ((base)->ANA_TRIM)

/*!
 * @}
 */ /* end of group RSIM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- RSIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RSIM_Register_Masks RSIM Register Masks
 * @{
 */

/*! @name CONTROL - Radio System Control */
#define RSIM_CONTROL_BLE_RF_OSC_REQ_EN_MASK      (0x1U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_EN_SHIFT     (0U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_STAT_MASK    (0x2U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_STAT_SHIFT   (1U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_INT_EN_MASK  (0x10U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_INT_EN_SHIFT (4U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_INT_MASK     (0x20U)
#define RSIM_CONTROL_BLE_RF_OSC_REQ_INT_SHIFT    (5U)
#define RSIM_CONTROL_RF_OSC_EN_MASK              (0xF00U)
#define RSIM_CONTROL_RF_OSC_EN_SHIFT             (8U)
#define RSIM_CONTROL_RF_OSC_EN(x)                (((uint32_t)(((uint32_t)(x)) << RSIM_CONTROL_RF_OSC_EN_SHIFT)) & RSIM_CONTROL_RF_OSC_EN_MASK)
#define RSIM_CONTROL_RADIO_GASKET_BYPASS_OVRD_EN_MASK (0x1000U)
#define RSIM_CONTROL_RADIO_GASKET_BYPASS_OVRD_EN_SHIFT (12U)
#define RSIM_CONTROL_RADIO_GASKET_BYPASS_OVRD_MASK (0x2000U)
#define RSIM_CONTROL_RADIO_GASKET_BYPASS_OVRD_SHIFT (13U)
#define RSIM_CONTROL_IPP_OBE_3V_BLE_ACTIVE_1_MASK (0x10000U)
#define RSIM_CONTROL_IPP_OBE_3V_BLE_ACTIVE_1_SHIFT (16U)
#define RSIM_CONTROL_IPP_OBE_3V_BLE_ACTIVE_2_MASK (0x20000U)
#define RSIM_CONTROL_IPP_OBE_3V_BLE_ACTIVE_2_SHIFT (17U)
#define RSIM_CONTROL_RADIO_RAM_ACCESS_OVRD_EN_MASK (0x40000U)
#define RSIM_CONTROL_RADIO_RAM_ACCESS_OVRD_EN_SHIFT (18U)
#define RSIM_CONTROL_RADIO_RAM_ACCESS_OVRD_MASK  (0x80000U)
#define RSIM_CONTROL_RADIO_RAM_ACCESS_OVRD_SHIFT (19U)
#define RSIM_CONTROL_RSIM_DSM_EXIT_MASK          (0x100000U)
#define RSIM_CONTROL_RSIM_DSM_EXIT_SHIFT         (20U)
#define RSIM_CONTROL_RSIM_STOP_ACK_OVRD_EN_MASK  (0x400000U)
#define RSIM_CONTROL_RSIM_STOP_ACK_OVRD_EN_SHIFT (22U)
#define RSIM_CONTROL_RSIM_STOP_ACK_OVRD_MASK     (0x800000U)
#define RSIM_CONTROL_RSIM_STOP_ACK_OVRD_SHIFT    (23U)
#define RSIM_CONTROL_RF_OSC_READY_MASK           (0x1000000U)
#define RSIM_CONTROL_RF_OSC_READY_SHIFT          (24U)
#define RSIM_CONTROL_RF_OSC_READY_OVRD_EN_MASK   (0x2000000U)
#define RSIM_CONTROL_RF_OSC_READY_OVRD_EN_SHIFT  (25U)
#define RSIM_CONTROL_RF_OSC_READY_OVRD_MASK      (0x4000000U)
#define RSIM_CONTROL_RF_OSC_READY_OVRD_SHIFT     (26U)
#define RSIM_CONTROL_BLOCK_SOC_RESETS_MASK       (0x10000000U)
#define RSIM_CONTROL_BLOCK_SOC_RESETS_SHIFT      (28U)
#define RSIM_CONTROL_BLOCK_RADIO_OUTPUTS_MASK    (0x20000000U)
#define RSIM_CONTROL_BLOCK_RADIO_OUTPUTS_SHIFT   (29U)
#define RSIM_CONTROL_ALLOW_DFT_RESETS_MASK       (0x40000000U)
#define RSIM_CONTROL_ALLOW_DFT_RESETS_SHIFT      (30U)
#define RSIM_CONTROL_RADIO_RESET_BIT_MASK        (0x80000000U)
#define RSIM_CONTROL_RADIO_RESET_BIT_SHIFT       (31U)

/*! @name ACTIVE_DELAY - Radio Active Early Warning */
#define RSIM_ACTIVE_DELAY_BLE_FINE_DELAY_MASK    (0x3FU)
#define RSIM_ACTIVE_DELAY_BLE_FINE_DELAY_SHIFT   (0U)
#define RSIM_ACTIVE_DELAY_BLE_FINE_DELAY(x)      (((uint32_t)(((uint32_t)(x)) << RSIM_ACTIVE_DELAY_BLE_FINE_DELAY_SHIFT)) & RSIM_ACTIVE_DELAY_BLE_FINE_DELAY_MASK)
#define RSIM_ACTIVE_DELAY_BLE_COARSE_DELAY_MASK  (0xF0000U)
#define RSIM_ACTIVE_DELAY_BLE_COARSE_DELAY_SHIFT (16U)
#define RSIM_ACTIVE_DELAY_BLE_COARSE_DELAY(x)    (((uint32_t)(((uint32_t)(x)) << RSIM_ACTIVE_DELAY_BLE_COARSE_DELAY_SHIFT)) & RSIM_ACTIVE_DELAY_BLE_COARSE_DELAY_MASK)

/*! @name MAC_MSB - Radio MAC Address */
#define RSIM_MAC_MSB_MAC_ADDR_MSB_MASK           (0xFFU)
#define RSIM_MAC_MSB_MAC_ADDR_MSB_SHIFT          (0U)
#define RSIM_MAC_MSB_MAC_ADDR_MSB(x)             (((uint32_t)(((uint32_t)(x)) << RSIM_MAC_MSB_MAC_ADDR_MSB_SHIFT)) & RSIM_MAC_MSB_MAC_ADDR_MSB_MASK)

/*! @name MAC_LSB - Radio MAC Address */
#define RSIM_MAC_LSB_MAC_ADDR_LSB_MASK           (0xFFFFFFFFU)
#define RSIM_MAC_LSB_MAC_ADDR_LSB_SHIFT          (0U)
#define RSIM_MAC_LSB_MAC_ADDR_LSB(x)             (((uint32_t)(((uint32_t)(x)) << RSIM_MAC_LSB_MAC_ADDR_LSB_SHIFT)) & RSIM_MAC_LSB_MAC_ADDR_LSB_MASK)

/*! @name MISC - Radio Miscellaneous */
#define RSIM_MISC_ANALOG_TEST_EN_MASK            (0x1FU)
#define RSIM_MISC_ANALOG_TEST_EN_SHIFT           (0U)
#define RSIM_MISC_ANALOG_TEST_EN(x)              (((uint32_t)(((uint32_t)(x)) << RSIM_MISC_ANALOG_TEST_EN_SHIFT)) & RSIM_MISC_ANALOG_TEST_EN_MASK)
#define RSIM_MISC_RADIO_VERSION_MASK             (0xFF000000U)
#define RSIM_MISC_RADIO_VERSION_SHIFT            (24U)
#define RSIM_MISC_RADIO_VERSION(x)               (((uint32_t)(((uint32_t)(x)) << RSIM_MISC_RADIO_VERSION_SHIFT)) & RSIM_MISC_RADIO_VERSION_MASK)

/*! @name DSM_TIMER - Deep Sleep Timer */
#define RSIM_DSM_TIMER_DSM_TIMER_MASK            (0xFFFFFFU)
#define RSIM_DSM_TIMER_DSM_TIMER_SHIFT           (0U)
#define RSIM_DSM_TIMER_DSM_TIMER(x)              (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_TIMER_DSM_TIMER_SHIFT)) & RSIM_DSM_TIMER_DSM_TIMER_MASK)

/*! @name DSM_CONTROL - Deep Sleep Timer Control */
#define RSIM_DSM_CONTROL_DSM_ANT_READY_MASK      (0x1U)
#define RSIM_DSM_CONTROL_DSM_ANT_READY_SHIFT     (0U)
#define RSIM_DSM_CONTROL_ANT_DEEP_SLEEP_STATUS_MASK (0x2U)
#define RSIM_DSM_CONTROL_ANT_DEEP_SLEEP_STATUS_SHIFT (1U)
#define RSIM_DSM_CONTROL_DSM_ANT_FINISHED_MASK   (0x4U)
#define RSIM_DSM_CONTROL_DSM_ANT_FINISHED_SHIFT  (2U)
#define RSIM_DSM_CONTROL_ANT_SYSCLK_REQUEST_EN_MASK (0x8U)
#define RSIM_DSM_CONTROL_ANT_SYSCLK_REQUEST_EN_SHIFT (3U)
#define RSIM_DSM_CONTROL_ANT_SLEEP_REQUEST_MASK  (0x10U)
#define RSIM_DSM_CONTROL_ANT_SLEEP_REQUEST_SHIFT (4U)
#define RSIM_DSM_CONTROL_ANT_SYSCLK_REQ_MASK     (0x20U)
#define RSIM_DSM_CONTROL_ANT_SYSCLK_REQ_SHIFT    (5U)
#define RSIM_DSM_CONTROL_ANT_SYSCLK_INTERRUPT_EN_MASK (0x40U)
#define RSIM_DSM_CONTROL_ANT_SYSCLK_INTERRUPT_EN_SHIFT (6U)
#define RSIM_DSM_CONTROL_ANT_SYSCLK_REQ_INT_MASK (0x80U)
#define RSIM_DSM_CONTROL_ANT_SYSCLK_REQ_INT_SHIFT (7U)
#define RSIM_DSM_CONTROL_DSM_GEN_READY_MASK      (0x100U)
#define RSIM_DSM_CONTROL_DSM_GEN_READY_SHIFT     (8U)
#define RSIM_DSM_CONTROL_GEN_DEEP_SLEEP_STATUS_MASK (0x200U)
#define RSIM_DSM_CONTROL_GEN_DEEP_SLEEP_STATUS_SHIFT (9U)
#define RSIM_DSM_CONTROL_DSM_GEN_FINISHED_MASK   (0x400U)
#define RSIM_DSM_CONTROL_DSM_GEN_FINISHED_SHIFT  (10U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQUEST_EN_MASK (0x800U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQUEST_EN_SHIFT (11U)
#define RSIM_DSM_CONTROL_GEN_SLEEP_REQUEST_MASK  (0x1000U)
#define RSIM_DSM_CONTROL_GEN_SLEEP_REQUEST_SHIFT (12U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_MASK     (0x2000U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_SHIFT    (13U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN_MASK (0x4000U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_INTERRUPT_EN_SHIFT (14U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_INT_MASK (0x8000U)
#define RSIM_DSM_CONTROL_GEN_SYSCLK_REQ_INT_SHIFT (15U)
#define RSIM_DSM_CONTROL_DSM_ZIG_READY_MASK      (0x10000U)
#define RSIM_DSM_CONTROL_DSM_ZIG_READY_SHIFT     (16U)
#define RSIM_DSM_CONTROL_ZIG_DEEP_SLEEP_STATUS_MASK (0x20000U)
#define RSIM_DSM_CONTROL_ZIG_DEEP_SLEEP_STATUS_SHIFT (17U)
#define RSIM_DSM_CONTROL_DSM_ZIG_FINISHED_MASK   (0x40000U)
#define RSIM_DSM_CONTROL_DSM_ZIG_FINISHED_SHIFT  (18U)
#define RSIM_DSM_CONTROL_ZIG_SYSCLK_REQUEST_EN_MASK (0x80000U)
#define RSIM_DSM_CONTROL_ZIG_SYSCLK_REQUEST_EN_SHIFT (19U)
#define RSIM_DSM_CONTROL_ZIG_SLEEP_REQUEST_MASK  (0x100000U)
#define RSIM_DSM_CONTROL_ZIG_SLEEP_REQUEST_SHIFT (20U)
#define RSIM_DSM_CONTROL_ZIG_SYSCLK_REQ_MASK     (0x200000U)
#define RSIM_DSM_CONTROL_ZIG_SYSCLK_REQ_SHIFT    (21U)
#define RSIM_DSM_CONTROL_ZIG_SYSCLK_INTERRUPT_EN_MASK (0x400000U)
#define RSIM_DSM_CONTROL_ZIG_SYSCLK_INTERRUPT_EN_SHIFT (22U)
#define RSIM_DSM_CONTROL_ZIG_SYSCLK_REQ_INT_MASK (0x800000U)
#define RSIM_DSM_CONTROL_ZIG_SYSCLK_REQ_INT_SHIFT (23U)
#define RSIM_DSM_CONTROL_DSM_TIMER_CLR_MASK      (0x8000000U)
#define RSIM_DSM_CONTROL_DSM_TIMER_CLR_SHIFT     (27U)
#define RSIM_DSM_CONTROL_DSM_TIMER_EN_MASK       (0x80000000U)
#define RSIM_DSM_CONTROL_DSM_TIMER_EN_SHIFT      (31U)

/*! @name DSM_OSC_OFFSET - Deep Sleep Wakeup Time Offset */
#define RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME_MASK (0x3FFU)
#define RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME_SHIFT (0U)
#define RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME(x) (((uint32_t)(((uint32_t)(x)) << RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME_SHIFT)) & RSIM_DSM_OSC_OFFSET_DSM_OSC_STABILIZE_TIME_MASK)

/*! @name ANT_SLEEP - ANT Link Layer Sleep Time */
#define RSIM_ANT_SLEEP_ANT_SLEEP_TIME_MASK       (0xFFFFFFU)
#define RSIM_ANT_SLEEP_ANT_SLEEP_TIME_SHIFT      (0U)
#define RSIM_ANT_SLEEP_ANT_SLEEP_TIME(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_ANT_SLEEP_ANT_SLEEP_TIME_SHIFT)) & RSIM_ANT_SLEEP_ANT_SLEEP_TIME_MASK)

/*! @name ANT_WAKE - ANT Link Layer Wake Time */
#define RSIM_ANT_WAKE_ANT_WAKE_TIME_MASK         (0xFFFFFFU)
#define RSIM_ANT_WAKE_ANT_WAKE_TIME_SHIFT        (0U)
#define RSIM_ANT_WAKE_ANT_WAKE_TIME(x)           (((uint32_t)(((uint32_t)(x)) << RSIM_ANT_WAKE_ANT_WAKE_TIME_SHIFT)) & RSIM_ANT_WAKE_ANT_WAKE_TIME_MASK)

/*! @name ZIG_SLEEP - 802.15.4 Link Layer Sleep Time */
#define RSIM_ZIG_SLEEP_ZIG_SLEEP_TIME_MASK       (0xFFFFFFU)
#define RSIM_ZIG_SLEEP_ZIG_SLEEP_TIME_SHIFT      (0U)
#define RSIM_ZIG_SLEEP_ZIG_SLEEP_TIME(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_ZIG_SLEEP_ZIG_SLEEP_TIME_SHIFT)) & RSIM_ZIG_SLEEP_ZIG_SLEEP_TIME_MASK)

/*! @name ZIG_WAKE - 802.15.4 Link Layer Wake Time */
#define RSIM_ZIG_WAKE_ZIG_WAKE_TIME_MASK         (0xFFFFFFU)
#define RSIM_ZIG_WAKE_ZIG_WAKE_TIME_SHIFT        (0U)
#define RSIM_ZIG_WAKE_ZIG_WAKE_TIME(x)           (((uint32_t)(((uint32_t)(x)) << RSIM_ZIG_WAKE_ZIG_WAKE_TIME_SHIFT)) & RSIM_ZIG_WAKE_ZIG_WAKE_TIME_MASK)

/*! @name GEN_SLEEP - Generic FSK Link Layer Sleep Time */
#define RSIM_GEN_SLEEP_GEN_SLEEP_TIME_MASK       (0xFFFFFFU)
#define RSIM_GEN_SLEEP_GEN_SLEEP_TIME_SHIFT      (0U)
#define RSIM_GEN_SLEEP_GEN_SLEEP_TIME(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_GEN_SLEEP_GEN_SLEEP_TIME_SHIFT)) & RSIM_GEN_SLEEP_GEN_SLEEP_TIME_MASK)

/*! @name GEN_WAKE - Generic FSK Link Layer Wake Time */
#define RSIM_GEN_WAKE_GEN_WAKE_TIME_MASK         (0xFFFFFFU)
#define RSIM_GEN_WAKE_GEN_WAKE_TIME_SHIFT        (0U)
#define RSIM_GEN_WAKE_GEN_WAKE_TIME(x)           (((uint32_t)(((uint32_t)(x)) << RSIM_GEN_WAKE_GEN_WAKE_TIME_SHIFT)) & RSIM_GEN_WAKE_GEN_WAKE_TIME_MASK)

/*! @name RF_OSC_CTRL - Radio Oscillator Control */
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL_MASK (0x3U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL_SHIFT (0U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL(x) (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_ALC_COUNT_SEL_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_ON_MASK     (0x4U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ALC_ON_SHIFT    (2U)
#define RSIM_RF_OSC_CTRL_RF_OSC_BYPASS_EN_MASK   (0x8U)
#define RSIM_RF_OSC_CTRL_RF_OSC_BYPASS_EN_SHIFT  (3U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS_MASK  (0x1F0U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS_SHIFT (4U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS(x)    (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_COMP_BIAS_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN_MASK (0x200U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DC_COUP_MODE_EN_SHIFT (9U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DIAGSEL_MASK    (0x400U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DIAGSEL_SHIFT   (10U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DIG_CLK_ON_MASK (0x800U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_DIG_CLK_ON_SHIFT (11U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_GM_MASK         (0x1F000U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_GM_SHIFT        (12U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_GM(x)           (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_GM_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_GM_MASK)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_MASK    (0x20000U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_SHIFT   (17U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_ON_MASK (0x40000U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_ON_OVRD_ON_SHIFT (18U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL_MASK (0x300000U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL_SHIFT (20U)
#define RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL(x) (((uint32_t)(((uint32_t)(x)) << RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL_SHIFT)) & RSIM_RF_OSC_CTRL_BB_XTAL_READY_COUNT_SEL_MASK)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL_MASK (0x8000000U)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_RF_EN_SEL_SHIFT (27U)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_MASK (0x10000000U)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_SHIFT (28U)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN_MASK (0x20000000U)
#define RSIM_RF_OSC_CTRL_RADIO_EXT_OSC_OVRD_EN_SHIFT (29U)
#define RSIM_RF_OSC_CTRL_RADIO_RF_ABORT_OVRD_MASK (0x40000000U)
#define RSIM_RF_OSC_CTRL_RADIO_RF_ABORT_OVRD_SHIFT (30U)
#define RSIM_RF_OSC_CTRL_RADIO_RF_ABORT_OVRD_EN_MASK (0x80000000U)
#define RSIM_RF_OSC_CTRL_RADIO_RF_ABORT_OVRD_EN_SHIFT (31U)

/*! @name ANA_TEST - Radio Analog Test Registers */
#define RSIM_ANA_TEST_BB_LDO_LS_BYP_MASK         (0x1U)
#define RSIM_ANA_TEST_BB_LDO_LS_BYP_SHIFT        (0U)
#define RSIM_ANA_TEST_BB_LDO_LS_DIAGSEL_MASK     (0x2U)
#define RSIM_ANA_TEST_BB_LDO_LS_DIAGSEL_SHIFT    (1U)
#define RSIM_ANA_TEST_BB_LDO_XO_BYP_ON_MASK      (0x4U)
#define RSIM_ANA_TEST_BB_LDO_XO_BYP_ON_SHIFT     (2U)
#define RSIM_ANA_TEST_BB_LDO_XO_DIAGSEL_MASK     (0x8U)
#define RSIM_ANA_TEST_BB_LDO_XO_DIAGSEL_SHIFT    (3U)
#define RSIM_ANA_TEST_BB_XTAL_TEST_MASK          (0x10U)
#define RSIM_ANA_TEST_BB_XTAL_TEST_SHIFT         (4U)
#define RSIM_ANA_TEST_BG_DIAGBUF_MASK            (0x20U)
#define RSIM_ANA_TEST_BG_DIAGBUF_SHIFT           (5U)
#define RSIM_ANA_TEST_BG_DIAGSEL_MASK            (0x40U)
#define RSIM_ANA_TEST_BG_DIAGSEL_SHIFT           (6U)
#define RSIM_ANA_TEST_BG_STARTUPFORCE_MASK       (0x80U)
#define RSIM_ANA_TEST_BG_STARTUPFORCE_SHIFT      (7U)
#define RSIM_ANA_TEST_DIAG_1234_ON_MASK          (0x100U)
#define RSIM_ANA_TEST_DIAG_1234_ON_SHIFT         (8U)
#define RSIM_ANA_TEST_DIAG2SOCADC_DEC_MASK       (0x600U)
#define RSIM_ANA_TEST_DIAG2SOCADC_DEC_SHIFT      (9U)
#define RSIM_ANA_TEST_DIAG2SOCADC_DEC(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TEST_DIAG2SOCADC_DEC_SHIFT)) & RSIM_ANA_TEST_DIAG2SOCADC_DEC_MASK)
#define RSIM_ANA_TEST_DIAG2SOCADC_DEC_ON_MASK    (0x800U)
#define RSIM_ANA_TEST_DIAG2SOCADC_DEC_ON_SHIFT   (11U)
#define RSIM_ANA_TEST_DIAGCODE_MASK              (0x7000U)
#define RSIM_ANA_TEST_DIAGCODE_SHIFT             (12U)
#define RSIM_ANA_TEST_DIAGCODE(x)                (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TEST_DIAGCODE_SHIFT)) & RSIM_ANA_TEST_DIAGCODE_MASK)

/*! @name ANA_TRIM - Radio Analog Trim Registers */
#define RSIM_ANA_TRIM_BB_LDO_LS_SPARE_MASK       (0x3U)
#define RSIM_ANA_TRIM_BB_LDO_LS_SPARE_SHIFT      (0U)
#define RSIM_ANA_TRIM_BB_LDO_LS_SPARE(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_LDO_LS_SPARE_SHIFT)) & RSIM_ANA_TRIM_BB_LDO_LS_SPARE_MASK)
#define RSIM_ANA_TRIM_BB_LDO_LS_TRIM_MASK        (0x38U)
#define RSIM_ANA_TRIM_BB_LDO_LS_TRIM_SHIFT       (3U)
#define RSIM_ANA_TRIM_BB_LDO_LS_TRIM(x)          (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_LDO_LS_TRIM_SHIFT)) & RSIM_ANA_TRIM_BB_LDO_LS_TRIM_MASK)
#define RSIM_ANA_TRIM_BB_LDO_XO_SPARE_MASK       (0xC0U)
#define RSIM_ANA_TRIM_BB_LDO_XO_SPARE_SHIFT      (6U)
#define RSIM_ANA_TRIM_BB_LDO_XO_SPARE(x)         (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_LDO_XO_SPARE_SHIFT)) & RSIM_ANA_TRIM_BB_LDO_XO_SPARE_MASK)
#define RSIM_ANA_TRIM_BB_LDO_XO_TRIM_MASK        (0x700U)
#define RSIM_ANA_TRIM_BB_LDO_XO_TRIM_SHIFT       (8U)
#define RSIM_ANA_TRIM_BB_LDO_XO_TRIM(x)          (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_LDO_XO_TRIM_SHIFT)) & RSIM_ANA_TRIM_BB_LDO_XO_TRIM_MASK)
#define RSIM_ANA_TRIM_BB_XTAL_SPARE_MASK         (0xF800U)
#define RSIM_ANA_TRIM_BB_XTAL_SPARE_SHIFT        (11U)
#define RSIM_ANA_TRIM_BB_XTAL_SPARE(x)           (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_XTAL_SPARE_SHIFT)) & RSIM_ANA_TRIM_BB_XTAL_SPARE_MASK)
#define RSIM_ANA_TRIM_BB_XTAL_TRIM_MASK          (0xFF0000U)
#define RSIM_ANA_TRIM_BB_XTAL_TRIM_SHIFT         (16U)
#define RSIM_ANA_TRIM_BB_XTAL_TRIM(x)            (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BB_XTAL_TRIM_SHIFT)) & RSIM_ANA_TRIM_BB_XTAL_TRIM_MASK)
#define RSIM_ANA_TRIM_BG_1V_TRIM_MASK            (0xF000000U)
#define RSIM_ANA_TRIM_BG_1V_TRIM_SHIFT           (24U)
#define RSIM_ANA_TRIM_BG_1V_TRIM(x)              (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BG_1V_TRIM_SHIFT)) & RSIM_ANA_TRIM_BG_1V_TRIM_MASK)
#define RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM_MASK      (0xF0000000U)
#define RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM_SHIFT     (28U)
#define RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM(x)        (((uint32_t)(((uint32_t)(x)) << RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM_SHIFT)) & RSIM_ANA_TRIM_BG_IBIAS_5U_TRIM_MASK)


/*!
 * @}
 */ /* end of group RSIM_Register_Masks */


/* RSIM - Peripheral instance base addresses */
/** Peripheral RSIM_REGS base pointer */
#define RSIM_BASE_PTR                            ((RSIM_MemMapPtr)0x40059000u)
/** Array initializer of RSIM peripheral base pointers */
#define RSIM_BASE_PTRS                           { RSIM_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- RSIM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RSIM_Register_Accessor_Macros RSIM - Register accessor macros
 * @{
 */


/* RSIM - Register instance definitions */
/* RSIM_REGS */
#define RSIM_CONTROL                             RSIM_CONTROL_REG(RSIM_BASE_PTR)
#define RSIM_ACTIVE_DELAY                        RSIM_ACTIVE_DELAY_REG(RSIM_BASE_PTR)
#define RSIM_MAC_MSB                             RSIM_MAC_MSB_REG(RSIM_BASE_PTR)
#define RSIM_MAC_LSB                             RSIM_MAC_LSB_REG(RSIM_BASE_PTR)
#define RSIM_MISC                                RSIM_MISC_REG(RSIM_BASE_PTR)
#define RSIM_DSM_TIMER                           RSIM_DSM_TIMER_REG(RSIM_BASE_PTR)
#define RSIM_DSM_CONTROL                         RSIM_DSM_CONTROL_REG(RSIM_BASE_PTR)
#define RSIM_DSM_OSC_OFFSET                      RSIM_DSM_OSC_OFFSET_REG(RSIM_BASE_PTR)
#define RSIM_ANT_SLEEP                           RSIM_ANT_SLEEP_REG(RSIM_BASE_PTR)
#define RSIM_ANT_WAKE                            RSIM_ANT_WAKE_REG(RSIM_BASE_PTR)
#define RSIM_ZIG_SLEEP                           RSIM_ZIG_SLEEP_REG(RSIM_BASE_PTR)
#define RSIM_ZIG_WAKE                            RSIM_ZIG_WAKE_REG(RSIM_BASE_PTR)
#define RSIM_GEN_SLEEP                           RSIM_GEN_SLEEP_REG(RSIM_BASE_PTR)
#define RSIM_GEN_WAKE                            RSIM_GEN_WAKE_REG(RSIM_BASE_PTR)
#define RSIM_RF_OSC_CTRL                         RSIM_RF_OSC_CTRL_REG(RSIM_BASE_PTR)
#define RSIM_ANA_TEST                            RSIM_ANA_TEST_REG(RSIM_BASE_PTR)
#define RSIM_ANA_TRIM                            RSIM_ANA_TRIM_REG(RSIM_BASE_PTR)

/*!
 * @}
 */ /* end of group RSIM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group RSIM_Peripheral */


/* ----------------------------------------------------------------------------
   -- RTC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Peripheral RTC
 * @{
 */

/** RTC - Peripheral register structure */
typedef struct RTC_MemMap {
  uint32_t TSR;                                    /**< RTC Time Seconds Register, offset: 0x0 */
  uint32_t TPR;                                    /**< RTC Time Prescaler Register, offset: 0x4 */
  uint32_t TAR;                                    /**< RTC Time Alarm Register, offset: 0x8 */
  uint32_t TCR;                                    /**< RTC Time Compensation Register, offset: 0xC */
  uint32_t CR;                                     /**< RTC Control Register, offset: 0x10 */
  uint32_t SR;                                     /**< RTC Status Register, offset: 0x14 */
  uint32_t LR;                                     /**< RTC Lock Register, offset: 0x18 */
  uint32_t IER;                                    /**< RTC Interrupt Enable Register, offset: 0x1C */
} volatile *RTC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- RTC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Register_Accessor_Macros RTC - Register accessor macros
 * @{
 */


/* RTC - Register accessors */
#define RTC_TSR_REG(base)                        ((base)->TSR)
#define RTC_TPR_REG(base)                        ((base)->TPR)
#define RTC_TAR_REG(base)                        ((base)->TAR)
#define RTC_TCR_REG(base)                        ((base)->TCR)
#define RTC_CR_REG(base)                         ((base)->CR)
#define RTC_SR_REG(base)                         ((base)->SR)
#define RTC_LR_REG(base)                         ((base)->LR)
#define RTC_IER_REG(base)                        ((base)->IER)

/*!
 * @}
 */ /* end of group RTC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- RTC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Register_Masks RTC Register Masks
 * @{
 */

/*! @name TSR - RTC Time Seconds Register */
#define RTC_TSR_TSR_MASK                         (0xFFFFFFFFU)
#define RTC_TSR_TSR_SHIFT                        (0U)
#define RTC_TSR_TSR(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TSR_TSR_SHIFT)) & RTC_TSR_TSR_MASK)

/*! @name TPR - RTC Time Prescaler Register */
#define RTC_TPR_TPR_MASK                         (0xFFFFU)
#define RTC_TPR_TPR_SHIFT                        (0U)
#define RTC_TPR_TPR(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TPR_TPR_SHIFT)) & RTC_TPR_TPR_MASK)

/*! @name TAR - RTC Time Alarm Register */
#define RTC_TAR_TAR_MASK                         (0xFFFFFFFFU)
#define RTC_TAR_TAR_SHIFT                        (0U)
#define RTC_TAR_TAR(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TAR_TAR_SHIFT)) & RTC_TAR_TAR_MASK)

/*! @name TCR - RTC Time Compensation Register */
#define RTC_TCR_TCR_MASK                         (0xFFU)
#define RTC_TCR_TCR_SHIFT                        (0U)
#define RTC_TCR_TCR(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TCR_TCR_SHIFT)) & RTC_TCR_TCR_MASK)
#define RTC_TCR_CIR_MASK                         (0xFF00U)
#define RTC_TCR_CIR_SHIFT                        (8U)
#define RTC_TCR_CIR(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TCR_CIR_SHIFT)) & RTC_TCR_CIR_MASK)
#define RTC_TCR_TCV_MASK                         (0xFF0000U)
#define RTC_TCR_TCV_SHIFT                        (16U)
#define RTC_TCR_TCV(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TCR_TCV_SHIFT)) & RTC_TCR_TCV_MASK)
#define RTC_TCR_CIC_MASK                         (0xFF000000U)
#define RTC_TCR_CIC_SHIFT                        (24U)
#define RTC_TCR_CIC(x)                           (((uint32_t)(((uint32_t)(x)) << RTC_TCR_CIC_SHIFT)) & RTC_TCR_CIC_MASK)

/*! @name CR - RTC Control Register */
#define RTC_CR_SWR_MASK                          (0x1U)
#define RTC_CR_SWR_SHIFT                         (0U)
#define RTC_CR_WPE_MASK                          (0x2U)
#define RTC_CR_WPE_SHIFT                         (1U)
#define RTC_CR_SUP_MASK                          (0x4U)
#define RTC_CR_SUP_SHIFT                         (2U)
#define RTC_CR_UM_MASK                           (0x8U)
#define RTC_CR_UM_SHIFT                          (3U)
#define RTC_CR_WPS_MASK                          (0x10U)
#define RTC_CR_WPS_SHIFT                         (4U)
#define RTC_CR_OSCE_MASK                         (0x100U)
#define RTC_CR_OSCE_SHIFT                        (8U)
#define RTC_CR_CLKO_MASK                         (0x200U)
#define RTC_CR_CLKO_SHIFT                        (9U)
#define RTC_CR_SC16P_MASK                        (0x400U)
#define RTC_CR_SC16P_SHIFT                       (10U)
#define RTC_CR_SC8P_MASK                         (0x800U)
#define RTC_CR_SC8P_SHIFT                        (11U)
#define RTC_CR_SC4P_MASK                         (0x1000U)
#define RTC_CR_SC4P_SHIFT                        (12U)
#define RTC_CR_SC2P_MASK                         (0x2000U)
#define RTC_CR_SC2P_SHIFT                        (13U)

/*! @name SR - RTC Status Register */
#define RTC_SR_TIF_MASK                          (0x1U)
#define RTC_SR_TIF_SHIFT                         (0U)
#define RTC_SR_TOF_MASK                          (0x2U)
#define RTC_SR_TOF_SHIFT                         (1U)
#define RTC_SR_TAF_MASK                          (0x4U)
#define RTC_SR_TAF_SHIFT                         (2U)
#define RTC_SR_TCE_MASK                          (0x10U)
#define RTC_SR_TCE_SHIFT                         (4U)

/*! @name LR - RTC Lock Register */
#define RTC_LR_TCL_MASK                          (0x8U)
#define RTC_LR_TCL_SHIFT                         (3U)
#define RTC_LR_CRL_MASK                          (0x10U)
#define RTC_LR_CRL_SHIFT                         (4U)
#define RTC_LR_SRL_MASK                          (0x20U)
#define RTC_LR_SRL_SHIFT                         (5U)
#define RTC_LR_LRL_MASK                          (0x40U)
#define RTC_LR_LRL_SHIFT                         (6U)

/*! @name IER - RTC Interrupt Enable Register */
#define RTC_IER_TIIE_MASK                        (0x1U)
#define RTC_IER_TIIE_SHIFT                       (0U)
#define RTC_IER_TOIE_MASK                        (0x2U)
#define RTC_IER_TOIE_SHIFT                       (1U)
#define RTC_IER_TAIE_MASK                        (0x4U)
#define RTC_IER_TAIE_SHIFT                       (2U)
#define RTC_IER_TSIE_MASK                        (0x10U)
#define RTC_IER_TSIE_SHIFT                       (4U)
#define RTC_IER_WPON_MASK                        (0x80U)
#define RTC_IER_WPON_SHIFT                       (7U)


/*!
 * @}
 */ /* end of group RTC_Register_Masks */


/* RTC - Peripheral instance base addresses */
/** Peripheral RTC base pointer */
#define RTC_BASE_PTR                             ((RTC_MemMapPtr)0x4003D000u)
/** Array initializer of RTC peripheral base pointers */
#define RTC_BASE_PTRS                            { RTC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- RTC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Register_Accessor_Macros RTC - Register accessor macros
 * @{
 */


/* RTC - Register instance definitions */
/* RTC */
#define RTC_TSR                                  RTC_TSR_REG(RTC_BASE_PTR)
#define RTC_TPR                                  RTC_TPR_REG(RTC_BASE_PTR)
#define RTC_TAR                                  RTC_TAR_REG(RTC_BASE_PTR)
#define RTC_TCR                                  RTC_TCR_REG(RTC_BASE_PTR)
#define RTC_CR                                   RTC_CR_REG(RTC_BASE_PTR)
#define RTC_SR                                   RTC_SR_REG(RTC_BASE_PTR)
#define RTC_LR                                   RTC_LR_REG(RTC_BASE_PTR)
#define RTC_IER                                  RTC_IER_REG(RTC_BASE_PTR)

/*!
 * @}
 */ /* end of group RTC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group RTC_Peripheral */


/* ----------------------------------------------------------------------------
   -- SCB
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SCB_Peripheral SCB
 * @{
 */

/** SCB - Peripheral register structure */
typedef struct SCB_MemMap {
  uint8_t RESERVED_0[8];
  uint32_t ACTLR;                                  /**< Auxiliary Control Register,, offset: 0x8 */
  uint8_t RESERVED_1[3316];
  uint32_t CPUID;                                  /**< CPUID Base Register, offset: 0xD00 */
  uint32_t ICSR;                                   /**< Interrupt Control and State Register, offset: 0xD04 */
  uint32_t VTOR;                                   /**< Vector Table Offset Register, offset: 0xD08 */
  uint32_t AIRCR;                                  /**< Application Interrupt and Reset Control Register, offset: 0xD0C */
  uint32_t SCR;                                    /**< System Control Register, offset: 0xD10 */
  uint32_t CCR;                                    /**< Configuration and Control Register, offset: 0xD14 */
  uint8_t RESERVED_2[4];
  uint32_t SHPR2;                                  /**< System Handler Priority Register 2, offset: 0xD1C */
  uint32_t SHPR3;                                  /**< System Handler Priority Register 3, offset: 0xD20 */
  uint32_t SHCSR;                                  /**< System Handler Control and State Register, offset: 0xD24 */
  uint8_t RESERVED_3[8];
  uint32_t DFSR;                                   /**< Debug Fault Status Register, offset: 0xD30 */
} volatile *SCB_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- SCB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SCB_Register_Accessor_Macros SCB - Register accessor macros
 * @{
 */


/* SCB - Register accessors */
#define SCB_ACTLR_REG(base)                      ((base)->ACTLR)
#define SCB_CPUID_REG(base)                      ((base)->CPUID)
#define SCB_ICSR_REG(base)                       ((base)->ICSR)
#define SCB_VTOR_REG(base)                       ((base)->VTOR)
#define SCB_AIRCR_REG(base)                      ((base)->AIRCR)
#define SCB_SCR_REG(base)                        ((base)->SCR)
#define SCB_CCR_REG(base)                        ((base)->CCR)
#define SCB_SHPR2_REG(base)                      ((base)->SHPR2)
#define SCB_SHPR3_REG(base)                      ((base)->SHPR3)
#define SCB_SHCSR_REG(base)                      ((base)->SHCSR)
#define SCB_DFSR_REG(base)                       ((base)->DFSR)

/*!
 * @}
 */ /* end of group SCB_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- SCB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SCB_Register_Masks SCB Register Masks
 * @{
 */

/*! @name CPUID - CPUID Base Register */
#define SCB_CPUID_REVISION_MASK                  (0xFU)
#define SCB_CPUID_REVISION_SHIFT                 (0U)
#define SCB_CPUID_REVISION(x)                    (((uint32_t)(((uint32_t)(x)) << SCB_CPUID_REVISION_SHIFT)) & SCB_CPUID_REVISION_MASK)
#define SCB_CPUID_PARTNO_MASK                    (0xFFF0U)
#define SCB_CPUID_PARTNO_SHIFT                   (4U)
#define SCB_CPUID_PARTNO(x)                      (((uint32_t)(((uint32_t)(x)) << SCB_CPUID_PARTNO_SHIFT)) & SCB_CPUID_PARTNO_MASK)
#define SCB_CPUID_ARCHITECTURE_MASK              (0xF0000U)
#define SCB_CPUID_ARCHITECTURE_SHIFT             (16U)
#define SCB_CPUID_ARCHITECTURE(x)                (((uint32_t)(((uint32_t)(x)) << SCB_CPUID_ARCHITECTURE_SHIFT)) & SCB_CPUID_ARCHITECTURE_MASK)
#define SCB_CPUID_VARIANT_MASK                   (0xF00000U)
#define SCB_CPUID_VARIANT_SHIFT                  (20U)
#define SCB_CPUID_VARIANT(x)                     (((uint32_t)(((uint32_t)(x)) << SCB_CPUID_VARIANT_SHIFT)) & SCB_CPUID_VARIANT_MASK)
#define SCB_CPUID_IMPLEMENTER_MASK               (0xFF000000U)
#define SCB_CPUID_IMPLEMENTER_SHIFT              (24U)
#define SCB_CPUID_IMPLEMENTER(x)                 (((uint32_t)(((uint32_t)(x)) << SCB_CPUID_IMPLEMENTER_SHIFT)) & SCB_CPUID_IMPLEMENTER_MASK)

/*! @name ICSR - Interrupt Control and State Register */
#define SCB_ICSR_VECTPENDING_MASK                (0x3F000U)
#define SCB_ICSR_VECTPENDING_SHIFT               (12U)
#define SCB_ICSR_VECTPENDING(x)                  (((uint32_t)(((uint32_t)(x)) << SCB_ICSR_VECTPENDING_SHIFT)) & SCB_ICSR_VECTPENDING_MASK)
#define SCB_ICSR_PENDSTCLR_MASK                  (0x2000000U)
#define SCB_ICSR_PENDSTCLR_SHIFT                 (25U)
#define SCB_ICSR_PENDSTSET_MASK                  (0x4000000U)
#define SCB_ICSR_PENDSTSET_SHIFT                 (26U)
#define SCB_ICSR_PENDSVCLR_MASK                  (0x8000000U)
#define SCB_ICSR_PENDSVCLR_SHIFT                 (27U)
#define SCB_ICSR_PENDSVSET_MASK                  (0x10000000U)
#define SCB_ICSR_PENDSVSET_SHIFT                 (28U)
#define SCB_ICSR_NMIPENDSET_MASK                 (0x80000000U)
#define SCB_ICSR_NMIPENDSET_SHIFT                (31U)

/*! @name VTOR - Vector Table Offset Register */
#define SCB_VTOR_TBLOFF_MASK                     (0xFFFFFF80U)
#define SCB_VTOR_TBLOFF_SHIFT                    (7U)
#define SCB_VTOR_TBLOFF(x)                       (((uint32_t)(((uint32_t)(x)) << SCB_VTOR_TBLOFF_SHIFT)) & SCB_VTOR_TBLOFF_MASK)

/*! @name AIRCR - Application Interrupt and Reset Control Register */
#define SCB_AIRCR_VECTCLRACTIVE_MASK             (0x2U)
#define SCB_AIRCR_VECTCLRACTIVE_SHIFT            (1U)
#define SCB_AIRCR_SYSRESETREQ_MASK               (0x4U)
#define SCB_AIRCR_SYSRESETREQ_SHIFT              (2U)
#define SCB_AIRCR_ENDIANNESS_MASK                (0x8000U)
#define SCB_AIRCR_ENDIANNESS_SHIFT               (15U)
#define SCB_AIRCR_VECTKEY_MASK                   (0xFFFF0000U)
#define SCB_AIRCR_VECTKEY_SHIFT                  (16U)
#define SCB_AIRCR_VECTKEY(x)                     (((uint32_t)(((uint32_t)(x)) << SCB_AIRCR_VECTKEY_SHIFT)) & SCB_AIRCR_VECTKEY_MASK)

/*! @name SCR - System Control Register */
#define SCB_SCR_SLEEPONEXIT_MASK                 (0x2U)
#define SCB_SCR_SLEEPONEXIT_SHIFT                (1U)
#define SCB_SCR_SLEEPDEEP_MASK                   (0x4U)
#define SCB_SCR_SLEEPDEEP_SHIFT                  (2U)
#define SCB_SCR_SEVONPEND_MASK                   (0x10U)
#define SCB_SCR_SEVONPEND_SHIFT                  (4U)

/*! @name CCR - Configuration and Control Register */
#define SCB_CCR_UNALIGN_TRP_MASK                 (0x8U)
#define SCB_CCR_UNALIGN_TRP_SHIFT                (3U)
#define SCB_CCR_STKALIGN_MASK                    (0x200U)
#define SCB_CCR_STKALIGN_SHIFT                   (9U)

/*! @name SHPR2 - System Handler Priority Register 2 */
#define SCB_SHPR2_PRI_11_MASK                    (0xC0000000U)
#define SCB_SHPR2_PRI_11_SHIFT                   (30U)
#define SCB_SHPR2_PRI_11(x)                      (((uint32_t)(((uint32_t)(x)) << SCB_SHPR2_PRI_11_SHIFT)) & SCB_SHPR2_PRI_11_MASK)

/*! @name SHPR3 - System Handler Priority Register 3 */
#define SCB_SHPR3_PRI_14_MASK                    (0xC00000U)
#define SCB_SHPR3_PRI_14_SHIFT                   (22U)
#define SCB_SHPR3_PRI_14(x)                      (((uint32_t)(((uint32_t)(x)) << SCB_SHPR3_PRI_14_SHIFT)) & SCB_SHPR3_PRI_14_MASK)
#define SCB_SHPR3_PRI_15_MASK                    (0xC0000000U)
#define SCB_SHPR3_PRI_15_SHIFT                   (30U)
#define SCB_SHPR3_PRI_15(x)                      (((uint32_t)(((uint32_t)(x)) << SCB_SHPR3_PRI_15_SHIFT)) & SCB_SHPR3_PRI_15_MASK)

/*! @name SHCSR - System Handler Control and State Register */
#define SCB_SHCSR_SVCALLPENDED_MASK              (0x8000U)
#define SCB_SHCSR_SVCALLPENDED_SHIFT             (15U)

/*! @name DFSR - Debug Fault Status Register */
#define SCB_DFSR_HALTED_MASK                     (0x1U)
#define SCB_DFSR_HALTED_SHIFT                    (0U)
#define SCB_DFSR_BKPT_MASK                       (0x2U)
#define SCB_DFSR_BKPT_SHIFT                      (1U)
#define SCB_DFSR_DWTTRAP_MASK                    (0x4U)
#define SCB_DFSR_DWTTRAP_SHIFT                   (2U)
#define SCB_DFSR_VCATCH_MASK                     (0x8U)
#define SCB_DFSR_VCATCH_SHIFT                    (3U)
#define SCB_DFSR_EXTERNAL_MASK                   (0x10U)
#define SCB_DFSR_EXTERNAL_SHIFT                  (4U)


/*!
 * @}
 */ /* end of group SCB_Register_Masks */


/* SCB - Peripheral instance base addresses */
/** Peripheral SystemControl base pointer */
#define SystemControl_BASE_PTR                   ((SCB_MemMapPtr)0xE000E000u)
/** Array initializer of SCB peripheral base pointers */
#define SCB_BASE_PTRS                            { SystemControl_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- SCB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SCB_Register_Accessor_Macros SCB - Register accessor macros
 * @{
 */


/* SCB - Register instance definitions */
/* SystemControl */
#define SCB_ACTLR                                SCB_ACTLR_REG(SystemControl_BASE_PTR)
#define SCB_CPUID                                SCB_CPUID_REG(SystemControl_BASE_PTR)
#define SCB_ICSR                                 SCB_ICSR_REG(SystemControl_BASE_PTR)
#define SCB_VTOR                                 SCB_VTOR_REG(SystemControl_BASE_PTR)
#define SCB_AIRCR                                SCB_AIRCR_REG(SystemControl_BASE_PTR)
#define SCB_SCR                                  SCB_SCR_REG(SystemControl_BASE_PTR)
#define SCB_CCR                                  SCB_CCR_REG(SystemControl_BASE_PTR)
#define SCB_SHPR2                                SCB_SHPR2_REG(SystemControl_BASE_PTR)
#define SCB_SHPR3                                SCB_SHPR3_REG(SystemControl_BASE_PTR)
#define SCB_SHCSR                                SCB_SHCSR_REG(SystemControl_BASE_PTR)
#define SCB_DFSR                                 SCB_DFSR_REG(SystemControl_BASE_PTR)

/*!
 * @}
 */ /* end of group SCB_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group SCB_Peripheral */


/* ----------------------------------------------------------------------------
   -- SIM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SIM_Peripheral SIM
 * @{
 */

/** SIM - Peripheral register structure */
typedef struct SIM_MemMap {
  uint32_t SOPT1;                                  /**< System Options Register 1, offset: 0x0 */
  uint8_t RESERVED_0[4096];
  uint32_t SOPT2;                                  /**< System Options Register 2, offset: 0x1004 */
  uint8_t RESERVED_1[4];
  uint32_t SOPT4;                                  /**< System Options Register 4, offset: 0x100C */
  uint32_t SOPT5;                                  /**< System Options Register 5, offset: 0x1010 */
  uint8_t RESERVED_2[4];
  uint32_t SOPT7;                                  /**< System Options Register 7, offset: 0x1018 */
  uint8_t RESERVED_3[8];
  uint32_t SDID;                                   /**< System Device Identification Register, offset: 0x1024 */
  uint8_t RESERVED_4[12];
  uint32_t SCGC4;                                  /**< System Clock Gating Control Register 4, offset: 0x1034 */
  uint32_t SCGC5;                                  /**< System Clock Gating Control Register 5, offset: 0x1038 */
  uint32_t SCGC6;                                  /**< System Clock Gating Control Register 6, offset: 0x103C */
  uint32_t SCGC7;                                  /**< System Clock Gating Control Register 7, offset: 0x1040 */
  uint32_t CLKDIV1;                                /**< System Clock Divider Register 1, offset: 0x1044 */
  uint8_t RESERVED_5[4];
  uint32_t FCFG1;                                  /**< Flash Configuration Register 1, offset: 0x104C */
  uint32_t FCFG2;                                  /**< Flash Configuration Register 2, offset: 0x1050 */
  uint8_t RESERVED_6[4];
  uint32_t UIDMH;                                  /**< Unique Identification Register Mid-High, offset: 0x1058 */
  uint32_t UIDML;                                  /**< Unique Identification Register Mid Low, offset: 0x105C */
  uint32_t UIDL;                                   /**< Unique Identification Register Low, offset: 0x1060 */
  uint8_t RESERVED_7[156];
  uint32_t COPC;                                   /**< COP Control Register, offset: 0x1100 */
  uint32_t SRVCOP;                                 /**< Service COP, offset: 0x1104 */
} volatile *SIM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- SIM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SIM_Register_Accessor_Macros SIM - Register accessor macros
 * @{
 */


/* SIM - Register accessors */
#define SIM_SOPT1_REG(base)                      ((base)->SOPT1)
#define SIM_SOPT2_REG(base)                      ((base)->SOPT2)
#define SIM_SOPT4_REG(base)                      ((base)->SOPT4)
#define SIM_SOPT5_REG(base)                      ((base)->SOPT5)
#define SIM_SOPT7_REG(base)                      ((base)->SOPT7)
#define SIM_SDID_REG(base)                       ((base)->SDID)
#define SIM_SCGC4_REG(base)                      ((base)->SCGC4)
#define SIM_SCGC5_REG(base)                      ((base)->SCGC5)
#define SIM_SCGC6_REG(base)                      ((base)->SCGC6)
#define SIM_SCGC7_REG(base)                      ((base)->SCGC7)
#define SIM_CLKDIV1_REG(base)                    ((base)->CLKDIV1)
#define SIM_FCFG1_REG(base)                      ((base)->FCFG1)
#define SIM_FCFG2_REG(base)                      ((base)->FCFG2)
#define SIM_UIDMH_REG(base)                      ((base)->UIDMH)
#define SIM_UIDML_REG(base)                      ((base)->UIDML)
#define SIM_UIDL_REG(base)                       ((base)->UIDL)
#define SIM_COPC_REG(base)                       ((base)->COPC)
#define SIM_SRVCOP_REG(base)                     ((base)->SRVCOP)

/*!
 * @}
 */ /* end of group SIM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- SIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SIM_Register_Masks SIM Register Masks
 * @{
 */

/*! @name SOPT1 - System Options Register 1 */
#define SIM_SOPT1_OSC32KOUT_MASK                 (0x30000U)
#define SIM_SOPT1_OSC32KOUT_SHIFT                (16U)
#define SIM_SOPT1_OSC32KOUT(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_SOPT1_OSC32KOUT_SHIFT)) & SIM_SOPT1_OSC32KOUT_MASK)
#define SIM_SOPT1_OSC32KSEL_MASK                 (0xC0000U)
#define SIM_SOPT1_OSC32KSEL_SHIFT                (18U)
#define SIM_SOPT1_OSC32KSEL(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_SOPT1_OSC32KSEL_SHIFT)) & SIM_SOPT1_OSC32KSEL_MASK)

/*! @name SOPT2 - System Options Register 2 */
#define SIM_SOPT2_CLKOUTSEL_MASK                 (0xE0U)
#define SIM_SOPT2_CLKOUTSEL_SHIFT                (5U)
#define SIM_SOPT2_CLKOUTSEL(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_SOPT2_CLKOUTSEL_SHIFT)) & SIM_SOPT2_CLKOUTSEL_MASK)
#define SIM_SOPT2_TPMSRC_MASK                    (0x3000000U)
#define SIM_SOPT2_TPMSRC_SHIFT                   (24U)
#define SIM_SOPT2_TPMSRC(x)                      (((uint32_t)(((uint32_t)(x)) << SIM_SOPT2_TPMSRC_SHIFT)) & SIM_SOPT2_TPMSRC_MASK)
#define SIM_SOPT2_LPUART0SRC_MASK                (0xC000000U)
#define SIM_SOPT2_LPUART0SRC_SHIFT               (26U)
#define SIM_SOPT2_LPUART0SRC(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT2_LPUART0SRC_SHIFT)) & SIM_SOPT2_LPUART0SRC_MASK)

/*! @name SOPT4 - System Options Register 4 */
#define SIM_SOPT4_TPM1CH0SRC_MASK                (0x40000U)
#define SIM_SOPT4_TPM1CH0SRC_SHIFT               (18U)
#define SIM_SOPT4_TPM2CH0SRC_MASK                (0x100000U)
#define SIM_SOPT4_TPM2CH0SRC_SHIFT               (20U)
#define SIM_SOPT4_TPM0CLKSEL_MASK                (0x1000000U)
#define SIM_SOPT4_TPM0CLKSEL_SHIFT               (24U)
#define SIM_SOPT4_TPM1CLKSEL_MASK                (0x2000000U)
#define SIM_SOPT4_TPM1CLKSEL_SHIFT               (25U)
#define SIM_SOPT4_TPM2CLKSEL_MASK                (0x4000000U)
#define SIM_SOPT4_TPM2CLKSEL_SHIFT               (26U)

/*! @name SOPT5 - System Options Register 5 */
#define SIM_SOPT5_LPUART0TXSRC_MASK              (0x3U)
#define SIM_SOPT5_LPUART0TXSRC_SHIFT             (0U)
#define SIM_SOPT5_LPUART0TXSRC(x)                (((uint32_t)(((uint32_t)(x)) << SIM_SOPT5_LPUART0TXSRC_SHIFT)) & SIM_SOPT5_LPUART0TXSRC_MASK)
#define SIM_SOPT5_LPUART0RXSRC_MASK              (0x4U)
#define SIM_SOPT5_LPUART0RXSRC_SHIFT             (2U)
#define SIM_SOPT5_LPUART0ODE_MASK                (0x10000U)
#define SIM_SOPT5_LPUART0ODE_SHIFT               (16U)

/*! @name SOPT7 - System Options Register 7 */
#define SIM_SOPT7_ADC0TRGSEL_MASK                (0xFU)
#define SIM_SOPT7_ADC0TRGSEL_SHIFT               (0U)
#define SIM_SOPT7_ADC0TRGSEL(x)                  (((uint32_t)(((uint32_t)(x)) << SIM_SOPT7_ADC0TRGSEL_SHIFT)) & SIM_SOPT7_ADC0TRGSEL_MASK)
#define SIM_SOPT7_ADC0PRETRGSEL_MASK             (0x10U)
#define SIM_SOPT7_ADC0PRETRGSEL_SHIFT            (4U)
#define SIM_SOPT7_ADC0ALTTRGEN_MASK              (0x80U)
#define SIM_SOPT7_ADC0ALTTRGEN_SHIFT             (7U)

/*! @name SDID - System Device Identification Register */
#define SIM_SDID_PINID_MASK                      (0xFU)
#define SIM_SDID_PINID_SHIFT                     (0U)
#define SIM_SDID_PINID(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SDID_PINID_SHIFT)) & SIM_SDID_PINID_MASK)
#define SIM_SDID_DIEID_MASK                      (0xF80U)
#define SIM_SDID_DIEID_SHIFT                     (7U)
#define SIM_SDID_DIEID(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SDID_DIEID_SHIFT)) & SIM_SDID_DIEID_MASK)
#define SIM_SDID_REVID_MASK                      (0xF000U)
#define SIM_SDID_REVID_SHIFT                     (12U)
#define SIM_SDID_REVID(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SDID_REVID_SHIFT)) & SIM_SDID_REVID_MASK)
#define SIM_SDID_SRAMSIZE_MASK                   (0xF0000U)
#define SIM_SDID_SRAMSIZE_SHIFT                  (16U)
#define SIM_SDID_SRAMSIZE(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SDID_SRAMSIZE_SHIFT)) & SIM_SDID_SRAMSIZE_MASK)
#define SIM_SDID_SERIESID_MASK                   (0xF00000U)
#define SIM_SDID_SERIESID_SHIFT                  (20U)
#define SIM_SDID_SERIESID(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SDID_SERIESID_SHIFT)) & SIM_SDID_SERIESID_MASK)
#define SIM_SDID_SUBFAMID_MASK                   (0x3000000U)
#define SIM_SDID_SUBFAMID_SHIFT                  (24U)
#define SIM_SDID_SUBFAMID(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SDID_SUBFAMID_SHIFT)) & SIM_SDID_SUBFAMID_MASK)
#define SIM_SDID_FAMID_MASK                      (0xF0000000U)
#define SIM_SDID_FAMID_SHIFT                     (28U)
#define SIM_SDID_FAMID(x)                        (((uint32_t)(((uint32_t)(x)) << SIM_SDID_FAMID_SHIFT)) & SIM_SDID_FAMID_MASK)

/*! @name SCGC4 - System Clock Gating Control Register 4 */
#define SIM_SCGC4_CMT_MASK                       (0x4U)
#define SIM_SCGC4_CMT_SHIFT                      (2U)
#define SIM_SCGC4_I2C0_MASK                      (0x40U)
#define SIM_SCGC4_I2C0_SHIFT                     (6U)
#define SIM_SCGC4_I2C1_MASK                      (0x80U)
#define SIM_SCGC4_I2C1_SHIFT                     (7U)
#define SIM_SCGC4_CMP_MASK                       (0x80000U)
#define SIM_SCGC4_CMP_SHIFT                      (19U)
#define SIM_SCGC4_VREF_MASK                      (0x100000U)
#define SIM_SCGC4_VREF_SHIFT                     (20U)

/*! @name SCGC5 - System Clock Gating Control Register 5 */
#define SIM_SCGC5_LPTMR_MASK                     (0x1U)
#define SIM_SCGC5_LPTMR_SHIFT                    (0U)
#define SIM_SCGC5_TSI_MASK                       (0x20U)
#define SIM_SCGC5_TSI_SHIFT                      (5U)
#define SIM_SCGC5_PORTA_MASK                     (0x200U)
#define SIM_SCGC5_PORTA_SHIFT                    (9U)
#define SIM_SCGC5_PORTB_MASK                     (0x400U)
#define SIM_SCGC5_PORTB_SHIFT                    (10U)
#define SIM_SCGC5_PORTC_MASK                     (0x800U)
#define SIM_SCGC5_PORTC_SHIFT                    (11U)
#define SIM_SCGC5_LPUART0_MASK                   (0x100000U)
#define SIM_SCGC5_LPUART0_SHIFT                  (20U)
#define SIM_SCGC5_LTC_MASK                       (0x1000000U)
#define SIM_SCGC5_LTC_SHIFT                      (24U)
#define SIM_SCGC5_RSIM_MASK                      (0x2000000U)
#define SIM_SCGC5_RSIM_SHIFT                     (25U)
#define SIM_SCGC5_DCDC_MASK                      (0x4000000U)
#define SIM_SCGC5_DCDC_SHIFT                     (26U)
#define SIM_SCGC5_BTLL_MASK                      (0x8000000U)
#define SIM_SCGC5_BTLL_SHIFT                     (27U)
#define SIM_SCGC5_PHYDIG_MASK                    (0x10000000U)
#define SIM_SCGC5_PHYDIG_SHIFT                   (28U)
#define SIM_SCGC5_ZigBee_MASK                    (0x20000000U)
#define SIM_SCGC5_ZigBee_SHIFT                   (29U)
#define SIM_SCGC5_ANT_MASK                       (0x40000000U)
#define SIM_SCGC5_ANT_SHIFT                      (30U)
#define SIM_SCGC5_GEN_FSK_MASK                   (0x80000000U)
#define SIM_SCGC5_GEN_FSK_SHIFT                  (31U)

/*! @name SCGC6 - System Clock Gating Control Register 6 */
#define SIM_SCGC6_FTF_MASK                       (0x1U)
#define SIM_SCGC6_FTF_SHIFT                      (0U)
#define SIM_SCGC6_DMAMUX_MASK                    (0x2U)
#define SIM_SCGC6_DMAMUX_SHIFT                   (1U)
#define SIM_SCGC6_TRNG_MASK                      (0x200U)
#define SIM_SCGC6_TRNG_SHIFT                     (9U)
#define SIM_SCGC6_SPI0_MASK                      (0x1000U)
#define SIM_SCGC6_SPI0_SHIFT                     (12U)
#define SIM_SCGC6_SPI1_MASK                      (0x2000U)
#define SIM_SCGC6_SPI1_SHIFT                     (13U)
#define SIM_SCGC6_PIT_MASK                       (0x800000U)
#define SIM_SCGC6_PIT_SHIFT                      (23U)
#define SIM_SCGC6_TPM0_MASK                      (0x1000000U)
#define SIM_SCGC6_TPM0_SHIFT                     (24U)
#define SIM_SCGC6_TPM1_MASK                      (0x2000000U)
#define SIM_SCGC6_TPM1_SHIFT                     (25U)
#define SIM_SCGC6_TPM2_MASK                      (0x4000000U)
#define SIM_SCGC6_TPM2_SHIFT                     (26U)
#define SIM_SCGC6_ADC0_MASK                      (0x8000000U)
#define SIM_SCGC6_ADC0_SHIFT                     (27U)
#define SIM_SCGC6_RTC_MASK                       (0x20000000U)
#define SIM_SCGC6_RTC_SHIFT                      (29U)
#define SIM_SCGC6_DAC0_MASK                      (0x80000000U)
#define SIM_SCGC6_DAC0_SHIFT                     (31U)

/*! @name SCGC7 - System Clock Gating Control Register 7 */
#define SIM_SCGC7_DMA_MASK                       (0x100U)
#define SIM_SCGC7_DMA_SHIFT                      (8U)

/*! @name CLKDIV1 - System Clock Divider Register 1 */
#define SIM_CLKDIV1_OUTDIV4_MASK                 (0x70000U)
#define SIM_CLKDIV1_OUTDIV4_SHIFT                (16U)
#define SIM_CLKDIV1_OUTDIV4(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_CLKDIV1_OUTDIV4_SHIFT)) & SIM_CLKDIV1_OUTDIV4_MASK)
#define SIM_CLKDIV1_OUTDIV1_MASK                 (0xF0000000U)
#define SIM_CLKDIV1_OUTDIV1_SHIFT                (28U)
#define SIM_CLKDIV1_OUTDIV1(x)                   (((uint32_t)(((uint32_t)(x)) << SIM_CLKDIV1_OUTDIV1_SHIFT)) & SIM_CLKDIV1_OUTDIV1_MASK)

/*! @name FCFG1 - Flash Configuration Register 1 */
#define SIM_FCFG1_FLASHDIS_MASK                  (0x1U)
#define SIM_FCFG1_FLASHDIS_SHIFT                 (0U)
#define SIM_FCFG1_FLASHDOZE_MASK                 (0x2U)
#define SIM_FCFG1_FLASHDOZE_SHIFT                (1U)
#define SIM_FCFG1_PFSIZE_MASK                    (0xF000000U)
#define SIM_FCFG1_PFSIZE_SHIFT                   (24U)
#define SIM_FCFG1_PFSIZE(x)                      (((uint32_t)(((uint32_t)(x)) << SIM_FCFG1_PFSIZE_SHIFT)) & SIM_FCFG1_PFSIZE_MASK)

/*! @name FCFG2 - Flash Configuration Register 2 */
#define SIM_FCFG2_MAXADDR1_MASK                  (0x7F0000U)
#define SIM_FCFG2_MAXADDR1_SHIFT                 (16U)
#define SIM_FCFG2_MAXADDR1(x)                    (((uint32_t)(((uint32_t)(x)) << SIM_FCFG2_MAXADDR1_SHIFT)) & SIM_FCFG2_MAXADDR1_MASK)
#define SIM_FCFG2_MAXADDR0_MASK                  (0x7F000000U)
#define SIM_FCFG2_MAXADDR0_SHIFT                 (24U)
#define SIM_FCFG2_MAXADDR0(x)                    (((uint32_t)(((uint32_t)(x)) << SIM_FCFG2_MAXADDR0_SHIFT)) & SIM_FCFG2_MAXADDR0_MASK)

/*! @name UIDMH - Unique Identification Register Mid-High */
#define SIM_UIDMH_UID_MASK                       (0xFFFFU)
#define SIM_UIDMH_UID_SHIFT                      (0U)
#define SIM_UIDMH_UID(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_UIDMH_UID_SHIFT)) & SIM_UIDMH_UID_MASK)

/*! @name UIDML - Unique Identification Register Mid Low */
#define SIM_UIDML_UID_MASK                       (0xFFFFFFFFU)
#define SIM_UIDML_UID_SHIFT                      (0U)
#define SIM_UIDML_UID(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_UIDML_UID_SHIFT)) & SIM_UIDML_UID_MASK)

/*! @name UIDL - Unique Identification Register Low */
#define SIM_UIDL_UID_MASK                        (0xFFFFFFFFU)
#define SIM_UIDL_UID_SHIFT                       (0U)
#define SIM_UIDL_UID(x)                          (((uint32_t)(((uint32_t)(x)) << SIM_UIDL_UID_SHIFT)) & SIM_UIDL_UID_MASK)

/*! @name COPC - COP Control Register */
#define SIM_COPC_COPW_MASK                       (0x1U)
#define SIM_COPC_COPW_SHIFT                      (0U)
#define SIM_COPC_COPCLKS_MASK                    (0x2U)
#define SIM_COPC_COPCLKS_SHIFT                   (1U)
#define SIM_COPC_COPT_MASK                       (0xCU)
#define SIM_COPC_COPT_SHIFT                      (2U)
#define SIM_COPC_COPT(x)                         (((uint32_t)(((uint32_t)(x)) << SIM_COPC_COPT_SHIFT)) & SIM_COPC_COPT_MASK)
#define SIM_COPC_COPSTPEN_MASK                   (0x10U)
#define SIM_COPC_COPSTPEN_SHIFT                  (4U)
#define SIM_COPC_COPDBGEN_MASK                   (0x20U)
#define SIM_COPC_COPDBGEN_SHIFT                  (5U)
#define SIM_COPC_COPCLKSEL_MASK                  (0xC0U)
#define SIM_COPC_COPCLKSEL_SHIFT                 (6U)
#define SIM_COPC_COPCLKSEL(x)                    (((uint32_t)(((uint32_t)(x)) << SIM_COPC_COPCLKSEL_SHIFT)) & SIM_COPC_COPCLKSEL_MASK)

/*! @name SRVCOP - Service COP */
#define SIM_SRVCOP_SRVCOP_MASK                   (0xFFU)
#define SIM_SRVCOP_SRVCOP_SHIFT                  (0U)
#define SIM_SRVCOP_SRVCOP(x)                     (((uint32_t)(((uint32_t)(x)) << SIM_SRVCOP_SRVCOP_SHIFT)) & SIM_SRVCOP_SRVCOP_MASK)


/*!
 * @}
 */ /* end of group SIM_Register_Masks */


/* SIM - Peripheral instance base addresses */
/** Peripheral SIM base pointer */
#define SIM_BASE_PTR                             ((SIM_MemMapPtr)0x40047000u)
/** Array initializer of SIM peripheral base pointers */
#define SIM_BASE_PTRS                            { SIM_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- SIM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SIM_Register_Accessor_Macros SIM - Register accessor macros
 * @{
 */


/* SIM - Register instance definitions */
/* SIM */
#define SIM_SOPT1                                SIM_SOPT1_REG(SIM_BASE_PTR)
#define SIM_SOPT2                                SIM_SOPT2_REG(SIM_BASE_PTR)
#define SIM_SOPT4                                SIM_SOPT4_REG(SIM_BASE_PTR)
#define SIM_SOPT5                                SIM_SOPT5_REG(SIM_BASE_PTR)
#define SIM_SOPT7                                SIM_SOPT7_REG(SIM_BASE_PTR)
#define SIM_SDID                                 SIM_SDID_REG(SIM_BASE_PTR)
#define SIM_SCGC4                                SIM_SCGC4_REG(SIM_BASE_PTR)
#define SIM_SCGC5                                SIM_SCGC5_REG(SIM_BASE_PTR)
#define SIM_SCGC6                                SIM_SCGC6_REG(SIM_BASE_PTR)
#define SIM_SCGC7                                SIM_SCGC7_REG(SIM_BASE_PTR)
#define SIM_CLKDIV1                              SIM_CLKDIV1_REG(SIM_BASE_PTR)
#define SIM_FCFG1                                SIM_FCFG1_REG(SIM_BASE_PTR)
#define SIM_FCFG2                                SIM_FCFG2_REG(SIM_BASE_PTR)
#define SIM_UIDMH                                SIM_UIDMH_REG(SIM_BASE_PTR)
#define SIM_UIDML                                SIM_UIDML_REG(SIM_BASE_PTR)
#define SIM_UIDL                                 SIM_UIDL_REG(SIM_BASE_PTR)
#define SIM_COPC                                 SIM_COPC_REG(SIM_BASE_PTR)
#define SIM_SRVCOP                               SIM_SRVCOP_REG(SIM_BASE_PTR)

/*!
 * @}
 */ /* end of group SIM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group SIM_Peripheral */


/* ----------------------------------------------------------------------------
   -- SMC
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMC_Peripheral SMC
 * @{
 */

/** SMC - Peripheral register structure */
typedef struct SMC_MemMap {
  uint8_t PMPROT;                                  /**< Power Mode Protection register, offset: 0x0 */
  uint8_t PMCTRL;                                  /**< Power Mode Control register, offset: 0x1 */
  uint8_t STOPCTRL;                                /**< Stop Control Register, offset: 0x2 */
  uint8_t PMSTAT;                                  /**< Power Mode Status register, offset: 0x3 */
} volatile *SMC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- SMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMC_Register_Accessor_Macros SMC - Register accessor macros
 * @{
 */


/* SMC - Register accessors */
#define SMC_PMPROT_REG(base)                     ((base)->PMPROT)
#define SMC_PMCTRL_REG(base)                     ((base)->PMCTRL)
#define SMC_STOPCTRL_REG(base)                   ((base)->STOPCTRL)
#define SMC_PMSTAT_REG(base)                     ((base)->PMSTAT)

/*!
 * @}
 */ /* end of group SMC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- SMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMC_Register_Masks SMC Register Masks
 * @{
 */

/*! @name PMPROT - Power Mode Protection register */
#define SMC_PMPROT_AVLLS_MASK                    (0x2U)
#define SMC_PMPROT_AVLLS_SHIFT                   (1U)
#define SMC_PMPROT_ALLS_MASK                     (0x8U)
#define SMC_PMPROT_ALLS_SHIFT                    (3U)
#define SMC_PMPROT_AVLP_MASK                     (0x20U)
#define SMC_PMPROT_AVLP_SHIFT                    (5U)

/*! @name PMCTRL - Power Mode Control register */
#define SMC_PMCTRL_STOPM_MASK                    (0x7U)
#define SMC_PMCTRL_STOPM_SHIFT                   (0U)
#define SMC_PMCTRL_STOPM(x)                      (((uint8_t)(((uint8_t)(x)) << SMC_PMCTRL_STOPM_SHIFT)) & SMC_PMCTRL_STOPM_MASK)
#define SMC_PMCTRL_STOPA_MASK                    (0x8U)
#define SMC_PMCTRL_STOPA_SHIFT                   (3U)
#define SMC_PMCTRL_RUNM_MASK                     (0x60U)
#define SMC_PMCTRL_RUNM_SHIFT                    (5U)
#define SMC_PMCTRL_RUNM(x)                       (((uint8_t)(((uint8_t)(x)) << SMC_PMCTRL_RUNM_SHIFT)) & SMC_PMCTRL_RUNM_MASK)

/*! @name STOPCTRL - Stop Control Register */
#define SMC_STOPCTRL_LLSM_MASK                   (0x7U)
#define SMC_STOPCTRL_LLSM_SHIFT                  (0U)
#define SMC_STOPCTRL_LLSM(x)                     (((uint8_t)(((uint8_t)(x)) << SMC_STOPCTRL_LLSM_SHIFT)) & SMC_STOPCTRL_LLSM_MASK)
#define SMC_STOPCTRL_PORPO_MASK                  (0x20U)
#define SMC_STOPCTRL_PORPO_SHIFT                 (5U)
#define SMC_STOPCTRL_PSTOPO_MASK                 (0xC0U)
#define SMC_STOPCTRL_PSTOPO_SHIFT                (6U)
#define SMC_STOPCTRL_PSTOPO(x)                   (((uint8_t)(((uint8_t)(x)) << SMC_STOPCTRL_PSTOPO_SHIFT)) & SMC_STOPCTRL_PSTOPO_MASK)

/*! @name PMSTAT - Power Mode Status register */
#define SMC_PMSTAT_PMSTAT_MASK                   (0xFFU)
#define SMC_PMSTAT_PMSTAT_SHIFT                  (0U)
#define SMC_PMSTAT_PMSTAT(x)                     (((uint8_t)(((uint8_t)(x)) << SMC_PMSTAT_PMSTAT_SHIFT)) & SMC_PMSTAT_PMSTAT_MASK)


/*!
 * @}
 */ /* end of group SMC_Register_Masks */


/* SMC - Peripheral instance base addresses */
/** Peripheral SMC base pointer */
#define SMC_BASE_PTR                             ((SMC_MemMapPtr)0x4007E000u)
/** Array initializer of SMC peripheral base pointers */
#define SMC_BASE_PTRS                            { SMC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- SMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMC_Register_Accessor_Macros SMC - Register accessor macros
 * @{
 */


/* SMC - Register instance definitions */
/* SMC */
#define SMC_PMPROT                               SMC_PMPROT_REG(SMC_BASE_PTR)
#define SMC_PMCTRL                               SMC_PMCTRL_REG(SMC_BASE_PTR)
#define SMC_STOPCTRL                             SMC_STOPCTRL_REG(SMC_BASE_PTR)
#define SMC_PMSTAT                               SMC_PMSTAT_REG(SMC_BASE_PTR)

/*!
 * @}
 */ /* end of group SMC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group SMC_Peripheral */


/* ----------------------------------------------------------------------------
   -- SPI
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Peripheral SPI
 * @{
 */

/** SPI - Peripheral register structure */
typedef struct SPI_MemMap {
  uint32_t MCR;                                    /**< Module Configuration Register, offset: 0x0 */
  uint8_t RESERVED_0[4];
  uint32_t TCR;                                    /**< Transfer Count Register, offset: 0x8 */
  union {                                          /* offset: 0xC */
    uint32_t CTAR[2];                                /**< Clock and Transfer Attributes Register (In Master Mode), array offset: 0xC, array step: 0x4 */
    uint32_t CTAR_SLAVE[1];                          /**< Clock and Transfer Attributes Register (In Slave Mode), array offset: 0xC, array step: 0x4 */
  };
  uint8_t RESERVED_1[24];
  uint32_t SR;                                     /**< Status Register, offset: 0x2C */
  uint32_t RSER;                                   /**< DMA/Interrupt Request Select and Enable Register, offset: 0x30 */
  union {                                          /* offset: 0x34 */
    uint32_t PUSHR;                                  /**< PUSH TX FIFO Register In Master Mode, offset: 0x34 */
    uint32_t PUSHR_SLAVE;                            /**< PUSH TX FIFO Register In Slave Mode, offset: 0x34 */
  };
  uint32_t POPR;                                   /**< POP RX FIFO Register, offset: 0x38 */
  uint32_t TXFR0;                                  /**< Transmit FIFO Registers, offset: 0x3C */
  uint32_t TXFR1;                                  /**< Transmit FIFO Registers, offset: 0x40 */
  uint32_t TXFR2;                                  /**< Transmit FIFO Registers, offset: 0x44 */
  uint32_t TXFR3;                                  /**< Transmit FIFO Registers, offset: 0x48 */
  uint8_t RESERVED_2[48];
  uint32_t RXFR0;                                  /**< Receive FIFO Registers, offset: 0x7C */
  uint32_t RXFR1;                                  /**< Receive FIFO Registers, offset: 0x80 */
  uint32_t RXFR2;                                  /**< Receive FIFO Registers, offset: 0x84 */
  uint32_t RXFR3;                                  /**< Receive FIFO Registers, offset: 0x88 */
} volatile *SPI_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- SPI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Register_Accessor_Macros SPI - Register accessor macros
 * @{
 */


/* SPI - Register accessors */
#define SPI_MCR_REG(base)                        ((base)->MCR)
#define SPI_TCR_REG(base)                        ((base)->TCR)
#define SPI_CTAR_REG(base,index2)                ((base)->CTAR[index2])
#define SPI_CTAR_SLAVE_REG(base,index2)          ((base)->CTAR_SLAVE[index2])
#define SPI_SR_REG(base)                         ((base)->SR)
#define SPI_RSER_REG(base)                       ((base)->RSER)
#define SPI_PUSHR_REG(base)                      ((base)->PUSHR)
#define SPI_PUSHR_SLAVE_REG(base)                ((base)->PUSHR_SLAVE)
#define SPI_POPR_REG(base)                       ((base)->POPR)
#define SPI_TXFR0_REG(base)                      ((base)->TXFR0)
#define SPI_TXFR1_REG(base)                      ((base)->TXFR1)
#define SPI_TXFR2_REG(base)                      ((base)->TXFR2)
#define SPI_TXFR3_REG(base)                      ((base)->TXFR3)
#define SPI_RXFR0_REG(base)                      ((base)->RXFR0)
#define SPI_RXFR1_REG(base)                      ((base)->RXFR1)
#define SPI_RXFR2_REG(base)                      ((base)->RXFR2)
#define SPI_RXFR3_REG(base)                      ((base)->RXFR3)

/*!
 * @}
 */ /* end of group SPI_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- SPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Register_Masks SPI Register Masks
 * @{
 */

/*! @name MCR - Module Configuration Register */
#define SPI_MCR_HALT_MASK                        (0x1U)
#define SPI_MCR_HALT_SHIFT                       (0U)
#define SPI_MCR_SMPL_PT_MASK                     (0x300U)
#define SPI_MCR_SMPL_PT_SHIFT                    (8U)
#define SPI_MCR_SMPL_PT(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_MCR_SMPL_PT_SHIFT)) & SPI_MCR_SMPL_PT_MASK)
#define SPI_MCR_CLR_RXF_MASK                     (0x400U)
#define SPI_MCR_CLR_RXF_SHIFT                    (10U)
#define SPI_MCR_CLR_TXF_MASK                     (0x800U)
#define SPI_MCR_CLR_TXF_SHIFT                    (11U)
#define SPI_MCR_DIS_RXF_MASK                     (0x1000U)
#define SPI_MCR_DIS_RXF_SHIFT                    (12U)
#define SPI_MCR_DIS_TXF_MASK                     (0x2000U)
#define SPI_MCR_DIS_TXF_SHIFT                    (13U)
#define SPI_MCR_MDIS_MASK                        (0x4000U)
#define SPI_MCR_MDIS_SHIFT                       (14U)
#define SPI_MCR_DOZE_MASK                        (0x8000U)
#define SPI_MCR_DOZE_SHIFT                       (15U)
#define SPI_MCR_PCSIS_MASK                       (0xF0000U)
#define SPI_MCR_PCSIS_SHIFT                      (16U)
#define SPI_MCR_PCSIS(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_MCR_PCSIS_SHIFT)) & SPI_MCR_PCSIS_MASK)
#define SPI_MCR_ROOE_MASK                        (0x1000000U)
#define SPI_MCR_ROOE_SHIFT                       (24U)
#define SPI_MCR_MTFE_MASK                        (0x4000000U)
#define SPI_MCR_MTFE_SHIFT                       (26U)
#define SPI_MCR_FRZ_MASK                         (0x8000000U)
#define SPI_MCR_FRZ_SHIFT                        (27U)
#define SPI_MCR_DCONF_MASK                       (0x30000000U)
#define SPI_MCR_DCONF_SHIFT                      (28U)
#define SPI_MCR_DCONF(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_MCR_DCONF_SHIFT)) & SPI_MCR_DCONF_MASK)
#define SPI_MCR_CONT_SCKE_MASK                   (0x40000000U)
#define SPI_MCR_CONT_SCKE_SHIFT                  (30U)
#define SPI_MCR_MSTR_MASK                        (0x80000000U)
#define SPI_MCR_MSTR_SHIFT                       (31U)

/*! @name TCR - Transfer Count Register */
#define SPI_TCR_SPI_TCNT_MASK                    (0xFFFF0000U)
#define SPI_TCR_SPI_TCNT_SHIFT                   (16U)
#define SPI_TCR_SPI_TCNT(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_TCR_SPI_TCNT_SHIFT)) & SPI_TCR_SPI_TCNT_MASK)

/*! @name CTAR - Clock and Transfer Attributes Register (In Master Mode) */
#define SPI_CTAR_BR_MASK                         (0xFU)
#define SPI_CTAR_BR_SHIFT                        (0U)
#define SPI_CTAR_BR(x)                           (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_BR_SHIFT)) & SPI_CTAR_BR_MASK)
#define SPI_CTAR_DT_MASK                         (0xF0U)
#define SPI_CTAR_DT_SHIFT                        (4U)
#define SPI_CTAR_DT(x)                           (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_DT_SHIFT)) & SPI_CTAR_DT_MASK)
#define SPI_CTAR_ASC_MASK                        (0xF00U)
#define SPI_CTAR_ASC_SHIFT                       (8U)
#define SPI_CTAR_ASC(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_ASC_SHIFT)) & SPI_CTAR_ASC_MASK)
#define SPI_CTAR_CSSCK_MASK                      (0xF000U)
#define SPI_CTAR_CSSCK_SHIFT                     (12U)
#define SPI_CTAR_CSSCK(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_CSSCK_SHIFT)) & SPI_CTAR_CSSCK_MASK)
#define SPI_CTAR_PBR_MASK                        (0x30000U)
#define SPI_CTAR_PBR_SHIFT                       (16U)
#define SPI_CTAR_PBR(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_PBR_SHIFT)) & SPI_CTAR_PBR_MASK)
#define SPI_CTAR_PDT_MASK                        (0xC0000U)
#define SPI_CTAR_PDT_SHIFT                       (18U)
#define SPI_CTAR_PDT(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_PDT_SHIFT)) & SPI_CTAR_PDT_MASK)
#define SPI_CTAR_PASC_MASK                       (0x300000U)
#define SPI_CTAR_PASC_SHIFT                      (20U)
#define SPI_CTAR_PASC(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_PASC_SHIFT)) & SPI_CTAR_PASC_MASK)
#define SPI_CTAR_PCSSCK_MASK                     (0xC00000U)
#define SPI_CTAR_PCSSCK_SHIFT                    (22U)
#define SPI_CTAR_PCSSCK(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_PCSSCK_SHIFT)) & SPI_CTAR_PCSSCK_MASK)
#define SPI_CTAR_LSBFE_MASK                      (0x1000000U)
#define SPI_CTAR_LSBFE_SHIFT                     (24U)
#define SPI_CTAR_CPHA_MASK                       (0x2000000U)
#define SPI_CTAR_CPHA_SHIFT                      (25U)
#define SPI_CTAR_CPOL_MASK                       (0x4000000U)
#define SPI_CTAR_CPOL_SHIFT                      (26U)
#define SPI_CTAR_FMSZ_MASK                       (0x78000000U)
#define SPI_CTAR_FMSZ_SHIFT                      (27U)
#define SPI_CTAR_FMSZ(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_FMSZ_SHIFT)) & SPI_CTAR_FMSZ_MASK)
#define SPI_CTAR_DBR_MASK                        (0x80000000U)
#define SPI_CTAR_DBR_SHIFT                       (31U)

/* The count of SPI_CTAR */
#define SPI_CTAR_COUNT                           (2U)

/*! @name CTAR_SLAVE - Clock and Transfer Attributes Register (In Slave Mode) */
#define SPI_CTAR_SLAVE_CPHA_MASK                 (0x2000000U)
#define SPI_CTAR_SLAVE_CPHA_SHIFT                (25U)
#define SPI_CTAR_SLAVE_CPOL_MASK                 (0x4000000U)
#define SPI_CTAR_SLAVE_CPOL_SHIFT                (26U)
#define SPI_CTAR_SLAVE_FMSZ_MASK                 (0x78000000U)
#define SPI_CTAR_SLAVE_FMSZ_SHIFT                (27U)
#define SPI_CTAR_SLAVE_FMSZ(x)                   (((uint32_t)(((uint32_t)(x)) << SPI_CTAR_SLAVE_FMSZ_SHIFT)) & SPI_CTAR_SLAVE_FMSZ_MASK)

/* The count of SPI_CTAR_SLAVE */
#define SPI_CTAR_SLAVE_COUNT                     (1U)

/*! @name SR - Status Register */
#define SPI_SR_POPNXTPTR_MASK                    (0xFU)
#define SPI_SR_POPNXTPTR_SHIFT                   (0U)
#define SPI_SR_POPNXTPTR(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_SR_POPNXTPTR_SHIFT)) & SPI_SR_POPNXTPTR_MASK)
#define SPI_SR_RXCTR_MASK                        (0xF0U)
#define SPI_SR_RXCTR_SHIFT                       (4U)
#define SPI_SR_RXCTR(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_SR_RXCTR_SHIFT)) & SPI_SR_RXCTR_MASK)
#define SPI_SR_TXNXTPTR_MASK                     (0xF00U)
#define SPI_SR_TXNXTPTR_SHIFT                    (8U)
#define SPI_SR_TXNXTPTR(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_SR_TXNXTPTR_SHIFT)) & SPI_SR_TXNXTPTR_MASK)
#define SPI_SR_TXCTR_MASK                        (0xF000U)
#define SPI_SR_TXCTR_SHIFT                       (12U)
#define SPI_SR_TXCTR(x)                          (((uint32_t)(((uint32_t)(x)) << SPI_SR_TXCTR_SHIFT)) & SPI_SR_TXCTR_MASK)
#define SPI_SR_RFDF_MASK                         (0x20000U)
#define SPI_SR_RFDF_SHIFT                        (17U)
#define SPI_SR_RFOF_MASK                         (0x80000U)
#define SPI_SR_RFOF_SHIFT                        (19U)
#define SPI_SR_TFFF_MASK                         (0x2000000U)
#define SPI_SR_TFFF_SHIFT                        (25U)
#define SPI_SR_TFUF_MASK                         (0x8000000U)
#define SPI_SR_TFUF_SHIFT                        (27U)
#define SPI_SR_EOQF_MASK                         (0x10000000U)
#define SPI_SR_EOQF_SHIFT                        (28U)
#define SPI_SR_TXRXS_MASK                        (0x40000000U)
#define SPI_SR_TXRXS_SHIFT                       (30U)
#define SPI_SR_TCF_MASK                          (0x80000000U)
#define SPI_SR_TCF_SHIFT                         (31U)

/*! @name RSER - DMA/Interrupt Request Select and Enable Register */
#define SPI_RSER_RFDF_DIRS_MASK                  (0x10000U)
#define SPI_RSER_RFDF_DIRS_SHIFT                 (16U)
#define SPI_RSER_RFDF_RE_MASK                    (0x20000U)
#define SPI_RSER_RFDF_RE_SHIFT                   (17U)
#define SPI_RSER_RFOF_RE_MASK                    (0x80000U)
#define SPI_RSER_RFOF_RE_SHIFT                   (19U)
#define SPI_RSER_TFFF_DIRS_MASK                  (0x1000000U)
#define SPI_RSER_TFFF_DIRS_SHIFT                 (24U)
#define SPI_RSER_TFFF_RE_MASK                    (0x2000000U)
#define SPI_RSER_TFFF_RE_SHIFT                   (25U)
#define SPI_RSER_TFUF_RE_MASK                    (0x8000000U)
#define SPI_RSER_TFUF_RE_SHIFT                   (27U)
#define SPI_RSER_EOQF_RE_MASK                    (0x10000000U)
#define SPI_RSER_EOQF_RE_SHIFT                   (28U)
#define SPI_RSER_TCF_RE_MASK                     (0x80000000U)
#define SPI_RSER_TCF_RE_SHIFT                    (31U)

/*! @name PUSHR - PUSH TX FIFO Register In Master Mode */
#define SPI_PUSHR_TXDATA_MASK                    (0xFFFFU)
#define SPI_PUSHR_TXDATA_SHIFT                   (0U)
#define SPI_PUSHR_TXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_TXDATA_SHIFT)) & SPI_PUSHR_TXDATA_MASK)
#define SPI_PUSHR_PCS_MASK                       (0xF0000U)
#define SPI_PUSHR_PCS_SHIFT                      (16U)
#define SPI_PUSHR_PCS(x)                         (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_PCS_SHIFT)) & SPI_PUSHR_PCS_MASK)
#define SPI_PUSHR_CTCNT_MASK                     (0x4000000U)
#define SPI_PUSHR_CTCNT_SHIFT                    (26U)
#define SPI_PUSHR_EOQ_MASK                       (0x8000000U)
#define SPI_PUSHR_EOQ_SHIFT                      (27U)
#define SPI_PUSHR_CTAS_MASK                      (0x70000000U)
#define SPI_PUSHR_CTAS_SHIFT                     (28U)
#define SPI_PUSHR_CTAS(x)                        (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_CTAS_SHIFT)) & SPI_PUSHR_CTAS_MASK)
#define SPI_PUSHR_CONT_MASK                      (0x80000000U)
#define SPI_PUSHR_CONT_SHIFT                     (31U)

/*! @name PUSHR_SLAVE - PUSH TX FIFO Register In Slave Mode */
#define SPI_PUSHR_SLAVE_TXDATA_MASK              (0xFFFFU)
#define SPI_PUSHR_SLAVE_TXDATA_SHIFT             (0U)
#define SPI_PUSHR_SLAVE_TXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_PUSHR_SLAVE_TXDATA_SHIFT)) & SPI_PUSHR_SLAVE_TXDATA_MASK)

/*! @name POPR - POP RX FIFO Register */
#define SPI_POPR_RXDATA_MASK                     (0xFFFFFFFFU)
#define SPI_POPR_RXDATA_SHIFT                    (0U)
#define SPI_POPR_RXDATA(x)                       (((uint32_t)(((uint32_t)(x)) << SPI_POPR_RXDATA_SHIFT)) & SPI_POPR_RXDATA_MASK)

/*! @name TXFR0 - Transmit FIFO Registers */
#define SPI_TXFR0_TXDATA_MASK                    (0xFFFFU)
#define SPI_TXFR0_TXDATA_SHIFT                   (0U)
#define SPI_TXFR0_TXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_TXFR0_TXDATA_SHIFT)) & SPI_TXFR0_TXDATA_MASK)
#define SPI_TXFR0_TXCMD_TXDATA_MASK              (0xFFFF0000U)
#define SPI_TXFR0_TXCMD_TXDATA_SHIFT             (16U)
#define SPI_TXFR0_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_TXFR0_TXCMD_TXDATA_SHIFT)) & SPI_TXFR0_TXCMD_TXDATA_MASK)

/*! @name TXFR1 - Transmit FIFO Registers */
#define SPI_TXFR1_TXDATA_MASK                    (0xFFFFU)
#define SPI_TXFR1_TXDATA_SHIFT                   (0U)
#define SPI_TXFR1_TXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_TXFR1_TXDATA_SHIFT)) & SPI_TXFR1_TXDATA_MASK)
#define SPI_TXFR1_TXCMD_TXDATA_MASK              (0xFFFF0000U)
#define SPI_TXFR1_TXCMD_TXDATA_SHIFT             (16U)
#define SPI_TXFR1_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_TXFR1_TXCMD_TXDATA_SHIFT)) & SPI_TXFR1_TXCMD_TXDATA_MASK)

/*! @name TXFR2 - Transmit FIFO Registers */
#define SPI_TXFR2_TXDATA_MASK                    (0xFFFFU)
#define SPI_TXFR2_TXDATA_SHIFT                   (0U)
#define SPI_TXFR2_TXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_TXFR2_TXDATA_SHIFT)) & SPI_TXFR2_TXDATA_MASK)
#define SPI_TXFR2_TXCMD_TXDATA_MASK              (0xFFFF0000U)
#define SPI_TXFR2_TXCMD_TXDATA_SHIFT             (16U)
#define SPI_TXFR2_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_TXFR2_TXCMD_TXDATA_SHIFT)) & SPI_TXFR2_TXCMD_TXDATA_MASK)

/*! @name TXFR3 - Transmit FIFO Registers */
#define SPI_TXFR3_TXDATA_MASK                    (0xFFFFU)
#define SPI_TXFR3_TXDATA_SHIFT                   (0U)
#define SPI_TXFR3_TXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_TXFR3_TXDATA_SHIFT)) & SPI_TXFR3_TXDATA_MASK)
#define SPI_TXFR3_TXCMD_TXDATA_MASK              (0xFFFF0000U)
#define SPI_TXFR3_TXCMD_TXDATA_SHIFT             (16U)
#define SPI_TXFR3_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x)) << SPI_TXFR3_TXCMD_TXDATA_SHIFT)) & SPI_TXFR3_TXCMD_TXDATA_MASK)

/*! @name RXFR0 - Receive FIFO Registers */
#define SPI_RXFR0_RXDATA_MASK                    (0xFFFFFFFFU)
#define SPI_RXFR0_RXDATA_SHIFT                   (0U)
#define SPI_RXFR0_RXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RXFR0_RXDATA_SHIFT)) & SPI_RXFR0_RXDATA_MASK)

/*! @name RXFR1 - Receive FIFO Registers */
#define SPI_RXFR1_RXDATA_MASK                    (0xFFFFFFFFU)
#define SPI_RXFR1_RXDATA_SHIFT                   (0U)
#define SPI_RXFR1_RXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RXFR1_RXDATA_SHIFT)) & SPI_RXFR1_RXDATA_MASK)

/*! @name RXFR2 - Receive FIFO Registers */
#define SPI_RXFR2_RXDATA_MASK                    (0xFFFFFFFFU)
#define SPI_RXFR2_RXDATA_SHIFT                   (0U)
#define SPI_RXFR2_RXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RXFR2_RXDATA_SHIFT)) & SPI_RXFR2_RXDATA_MASK)

/*! @name RXFR3 - Receive FIFO Registers */
#define SPI_RXFR3_RXDATA_MASK                    (0xFFFFFFFFU)
#define SPI_RXFR3_RXDATA_SHIFT                   (0U)
#define SPI_RXFR3_RXDATA(x)                      (((uint32_t)(((uint32_t)(x)) << SPI_RXFR3_RXDATA_SHIFT)) & SPI_RXFR3_RXDATA_MASK)


/*!
 * @}
 */ /* end of group SPI_Register_Masks */


/* SPI - Peripheral instance base addresses */
/** Peripheral SPI0 base pointer */
#define SPI0_BASE_PTR                            ((SPI_MemMapPtr)0x4002C000u)
/** Peripheral SPI1 base pointer */
#define SPI1_BASE_PTR                            ((SPI_MemMapPtr)0x4002D000u)
/** Array initializer of SPI peripheral base pointers */
#define SPI_BASE_PTRS                            { SPI0_BASE_PTR, SPI1_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- SPI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Register_Accessor_Macros SPI - Register accessor macros
 * @{
 */


/* SPI - Register instance definitions */
/* SPI0 */
#define SPI0_MCR                                 SPI_MCR_REG(SPI0_BASE_PTR)
#define SPI0_TCR                                 SPI_TCR_REG(SPI0_BASE_PTR)
#define SPI0_CTAR0                               SPI_CTAR_REG(SPI0_BASE_PTR,0)
#define SPI0_CTAR0_SLAVE                         SPI_CTAR_SLAVE_REG(SPI0_BASE_PTR,0)
#define SPI0_CTAR1                               SPI_CTAR_REG(SPI0_BASE_PTR,1)
#define SPI0_SR                                  SPI_SR_REG(SPI0_BASE_PTR)
#define SPI0_RSER                                SPI_RSER_REG(SPI0_BASE_PTR)
#define SPI0_PUSHR                               SPI_PUSHR_REG(SPI0_BASE_PTR)
#define SPI0_PUSHR_SLAVE                         SPI_PUSHR_SLAVE_REG(SPI0_BASE_PTR)
#define SPI0_POPR                                SPI_POPR_REG(SPI0_BASE_PTR)
#define SPI0_TXFR0                               SPI_TXFR0_REG(SPI0_BASE_PTR)
#define SPI0_TXFR1                               SPI_TXFR1_REG(SPI0_BASE_PTR)
#define SPI0_TXFR2                               SPI_TXFR2_REG(SPI0_BASE_PTR)
#define SPI0_TXFR3                               SPI_TXFR3_REG(SPI0_BASE_PTR)
#define SPI0_RXFR0                               SPI_RXFR0_REG(SPI0_BASE_PTR)
#define SPI0_RXFR1                               SPI_RXFR1_REG(SPI0_BASE_PTR)
#define SPI0_RXFR2                               SPI_RXFR2_REG(SPI0_BASE_PTR)
#define SPI0_RXFR3                               SPI_RXFR3_REG(SPI0_BASE_PTR)
/* SPI1 */
#define SPI1_MCR                                 SPI_MCR_REG(SPI1_BASE_PTR)
#define SPI1_TCR                                 SPI_TCR_REG(SPI1_BASE_PTR)
#define SPI1_CTAR0                               SPI_CTAR_REG(SPI1_BASE_PTR,0)
#define SPI1_CTAR0_SLAVE                         SPI_CTAR_SLAVE_REG(SPI1_BASE_PTR,0)
#define SPI1_CTAR1                               SPI_CTAR_REG(SPI1_BASE_PTR,1)
#define SPI1_SR                                  SPI_SR_REG(SPI1_BASE_PTR)
#define SPI1_RSER                                SPI_RSER_REG(SPI1_BASE_PTR)
#define SPI1_PUSHR                               SPI_PUSHR_REG(SPI1_BASE_PTR)
#define SPI1_PUSHR_SLAVE                         SPI_PUSHR_SLAVE_REG(SPI1_BASE_PTR)
#define SPI1_POPR                                SPI_POPR_REG(SPI1_BASE_PTR)
#define SPI1_TXFR0                               SPI_TXFR0_REG(SPI1_BASE_PTR)
#define SPI1_TXFR1                               SPI_TXFR1_REG(SPI1_BASE_PTR)
#define SPI1_TXFR2                               SPI_TXFR2_REG(SPI1_BASE_PTR)
#define SPI1_TXFR3                               SPI_TXFR3_REG(SPI1_BASE_PTR)
#define SPI1_RXFR0                               SPI_RXFR0_REG(SPI1_BASE_PTR)
#define SPI1_RXFR1                               SPI_RXFR1_REG(SPI1_BASE_PTR)
#define SPI1_RXFR2                               SPI_RXFR2_REG(SPI1_BASE_PTR)
#define SPI1_RXFR3                               SPI_RXFR3_REG(SPI1_BASE_PTR)

/* SPI - Register array accessors */
#define SPI0_CTAR(index2)                        SPI_CTAR_REG(SPI0_BASE_PTR,index2)
#define SPI1_CTAR(index2)                        SPI_CTAR_REG(SPI1_BASE_PTR,index2)
#define SPI0_CTAR_SLAVE(index2)                  SPI_CTAR_SLAVE_REG(SPI0_BASE_PTR,index2)
#define SPI1_CTAR_SLAVE(index2)                  SPI_CTAR_SLAVE_REG(SPI1_BASE_PTR,index2)

/*!
 * @}
 */ /* end of group SPI_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group SPI_Peripheral */


/* ----------------------------------------------------------------------------
   -- SysTick
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SysTick_Peripheral SysTick
 * @{
 */

/** SysTick - Peripheral register structure */
typedef struct SysTick_MemMap {
  uint32_t CSR;                                    /**< SysTick Control and Status Register, offset: 0x0 */
  uint32_t RVR;                                    /**< SysTick Reload Value Register, offset: 0x4 */
  uint32_t CVR;                                    /**< SysTick Current Value Register, offset: 0x8 */
  uint32_t CALIB;                                  /**< SysTick Calibration Value Register, offset: 0xC */
} volatile *SysTick_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- SysTick - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SysTick_Register_Accessor_Macros SysTick - Register accessor macros
 * @{
 */


/* SysTick - Register accessors */
#define SysTick_CSR_REG(base)                    ((base)->CSR)
#define SysTick_RVR_REG(base)                    ((base)->RVR)
#define SysTick_CVR_REG(base)                    ((base)->CVR)
#define SysTick_CALIB_REG(base)                  ((base)->CALIB)

/*!
 * @}
 */ /* end of group SysTick_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- SysTick Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SysTick_Register_Masks SysTick Register Masks
 * @{
 */

/*! @name CSR - SysTick Control and Status Register */
#define SysTick_CSR_ENABLE_MASK                  (0x1U)
#define SysTick_CSR_ENABLE_SHIFT                 (0U)
#define SysTick_CSR_TICKINT_MASK                 (0x2U)
#define SysTick_CSR_TICKINT_SHIFT                (1U)
#define SysTick_CSR_CLKSOURCE_MASK               (0x4U)
#define SysTick_CSR_CLKSOURCE_SHIFT              (2U)
#define SysTick_CSR_COUNTFLAG_MASK               (0x10000U)
#define SysTick_CSR_COUNTFLAG_SHIFT              (16U)

/*! @name RVR - SysTick Reload Value Register */
#define SysTick_RVR_RELOAD_MASK                  (0xFFFFFFU)
#define SysTick_RVR_RELOAD_SHIFT                 (0U)
#define SysTick_RVR_RELOAD(x)                    (((uint32_t)(((uint32_t)(x)) << SysTick_RVR_RELOAD_SHIFT)) & SysTick_RVR_RELOAD_MASK)

/*! @name CVR - SysTick Current Value Register */
#define SysTick_CVR_CURRENT_MASK                 (0xFFFFFFU)
#define SysTick_CVR_CURRENT_SHIFT                (0U)
#define SysTick_CVR_CURRENT(x)                   (((uint32_t)(((uint32_t)(x)) << SysTick_CVR_CURRENT_SHIFT)) & SysTick_CVR_CURRENT_MASK)

/*! @name CALIB - SysTick Calibration Value Register */
#define SysTick_CALIB_TENMS_MASK                 (0xFFFFFFU)
#define SysTick_CALIB_TENMS_SHIFT                (0U)
#define SysTick_CALIB_TENMS(x)                   (((uint32_t)(((uint32_t)(x)) << SysTick_CALIB_TENMS_SHIFT)) & SysTick_CALIB_TENMS_MASK)
#define SysTick_CALIB_SKEW_MASK                  (0x40000000U)
#define SysTick_CALIB_SKEW_SHIFT                 (30U)
#define SysTick_CALIB_NOREF_MASK                 (0x80000000U)
#define SysTick_CALIB_NOREF_SHIFT                (31U)


/*!
 * @}
 */ /* end of group SysTick_Register_Masks */


/* SysTick - Peripheral instance base addresses */
/** Peripheral SysTick base pointer */
#define SysTick_BASE_PTR                         ((SysTick_MemMapPtr)0xE000E010u)
/** Array initializer of SysTick peripheral base pointers */
#define SysTick_BASE_PTRS                        { SysTick_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- SysTick - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SysTick_Register_Accessor_Macros SysTick - Register accessor macros
 * @{
 */


/* SysTick - Register instance definitions */
/* SysTick */
#define SYST_CSR                                 SysTick_CSR_REG(SysTick_BASE_PTR)
#define SYST_RVR                                 SysTick_RVR_REG(SysTick_BASE_PTR)
#define SYST_CVR                                 SysTick_CVR_REG(SysTick_BASE_PTR)
#define SYST_CALIB                               SysTick_CALIB_REG(SysTick_BASE_PTR)

/*!
 * @}
 */ /* end of group SysTick_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group SysTick_Peripheral */


/* ----------------------------------------------------------------------------
   -- TPM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TPM_Peripheral TPM
 * @{
 */

/** TPM - Peripheral register structure */
typedef struct TPM_MemMap {
  uint32_t SC;                                     /**< Status and Control, offset: 0x0 */
  uint32_t CNT;                                    /**< Counter, offset: 0x4 */
  uint32_t MOD;                                    /**< Modulo, offset: 0x8 */
  struct {                                         /* offset: 0xC, array step: 0x8 */
    uint32_t CnSC;                                   /**< Channel (n) Status and Control, array offset: 0xC, array step: 0x8 */
    uint32_t CnV;                                    /**< Channel (n) Value, array offset: 0x10, array step: 0x8 */
  } CONTROLS[4];
  uint8_t RESERVED_0[36];
  uint32_t STATUS;                                 /**< Capture and Compare Status, offset: 0x50 */
  uint8_t RESERVED_1[16];
  uint32_t COMBINE;                                /**< Combine Channel Register, offset: 0x64 */
  uint8_t RESERVED_2[8];
  uint32_t POL;                                    /**< Channel Polarity, offset: 0x70 */
  uint8_t RESERVED_3[4];
  uint32_t FILTER;                                 /**< Filter Control, offset: 0x78 */
  uint8_t RESERVED_4[4];
  uint32_t QDCTRL;                                 /**< Quadrature Decoder Control and Status, offset: 0x80 */
  uint32_t CONF;                                   /**< Configuration, offset: 0x84 */
} volatile *TPM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- TPM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TPM_Register_Accessor_Macros TPM - Register accessor macros
 * @{
 */


/* TPM - Register accessors */
#define TPM_SC_REG(base)                         ((base)->SC)
#define TPM_CNT_REG(base)                        ((base)->CNT)
#define TPM_MOD_REG(base)                        ((base)->MOD)
#define TPM_CnSC_REG(base,index)                 ((base)->CONTROLS[index].CnSC)
#define TPM_CnV_REG(base,index)                  ((base)->CONTROLS[index].CnV)
#define TPM_STATUS_REG(base)                     ((base)->STATUS)
#define TPM_COMBINE_REG(base)                    ((base)->COMBINE)
#define TPM_POL_REG(base)                        ((base)->POL)
#define TPM_FILTER_REG(base)                     ((base)->FILTER)
#define TPM_QDCTRL_REG(base)                     ((base)->QDCTRL)
#define TPM_CONF_REG(base)                       ((base)->CONF)

/*!
 * @}
 */ /* end of group TPM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- TPM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TPM_Register_Masks TPM Register Masks
 * @{
 */

/*! @name SC - Status and Control */
#define TPM_SC_PS_MASK                           (0x7U)
#define TPM_SC_PS_SHIFT                          (0U)
#define TPM_SC_PS(x)                             (((uint32_t)(((uint32_t)(x)) << TPM_SC_PS_SHIFT)) & TPM_SC_PS_MASK)
#define TPM_SC_CMOD_MASK                         (0x18U)
#define TPM_SC_CMOD_SHIFT                        (3U)
#define TPM_SC_CMOD(x)                           (((uint32_t)(((uint32_t)(x)) << TPM_SC_CMOD_SHIFT)) & TPM_SC_CMOD_MASK)
#define TPM_SC_CPWMS_MASK                        (0x20U)
#define TPM_SC_CPWMS_SHIFT                       (5U)
#define TPM_SC_TOIE_MASK                         (0x40U)
#define TPM_SC_TOIE_SHIFT                        (6U)
#define TPM_SC_TOF_MASK                          (0x80U)
#define TPM_SC_TOF_SHIFT                         (7U)
#define TPM_SC_DMA_MASK                          (0x100U)
#define TPM_SC_DMA_SHIFT                         (8U)

/*! @name CNT - Counter */
#define TPM_CNT_COUNT_MASK                       (0xFFFFU)
#define TPM_CNT_COUNT_SHIFT                      (0U)
#define TPM_CNT_COUNT(x)                         (((uint32_t)(((uint32_t)(x)) << TPM_CNT_COUNT_SHIFT)) & TPM_CNT_COUNT_MASK)

/*! @name MOD - Modulo */
#define TPM_MOD_MOD_MASK                         (0xFFFFU)
#define TPM_MOD_MOD_SHIFT                        (0U)
#define TPM_MOD_MOD(x)                           (((uint32_t)(((uint32_t)(x)) << TPM_MOD_MOD_SHIFT)) & TPM_MOD_MOD_MASK)

/*! @name CnSC - Channel (n) Status and Control */
#define TPM_CnSC_DMA_MASK                        (0x1U)
#define TPM_CnSC_DMA_SHIFT                       (0U)
#define TPM_CnSC_ELSA_MASK                       (0x4U)
#define TPM_CnSC_ELSA_SHIFT                      (2U)
#define TPM_CnSC_ELSB_MASK                       (0x8U)
#define TPM_CnSC_ELSB_SHIFT                      (3U)
#define TPM_CnSC_MSA_MASK                        (0x10U)
#define TPM_CnSC_MSA_SHIFT                       (4U)
#define TPM_CnSC_MSB_MASK                        (0x20U)
#define TPM_CnSC_MSB_SHIFT                       (5U)
#define TPM_CnSC_CHIE_MASK                       (0x40U)
#define TPM_CnSC_CHIE_SHIFT                      (6U)
#define TPM_CnSC_CHF_MASK                        (0x80U)
#define TPM_CnSC_CHF_SHIFT                       (7U)

/* The count of TPM_CnSC */
#define TPM_CnSC_COUNT                           (4U)

/*! @name CnV - Channel (n) Value */
#define TPM_CnV_VAL_MASK                         (0xFFFFU)
#define TPM_CnV_VAL_SHIFT                        (0U)
#define TPM_CnV_VAL(x)                           (((uint32_t)(((uint32_t)(x)) << TPM_CnV_VAL_SHIFT)) & TPM_CnV_VAL_MASK)

/* The count of TPM_CnV */
#define TPM_CnV_COUNT                            (4U)

/*! @name STATUS - Capture and Compare Status */
#define TPM_STATUS_CH0F_MASK                     (0x1U)
#define TPM_STATUS_CH0F_SHIFT                    (0U)
#define TPM_STATUS_CH1F_MASK                     (0x2U)
#define TPM_STATUS_CH1F_SHIFT                    (1U)
#define TPM_STATUS_CH2F_MASK                     (0x4U)
#define TPM_STATUS_CH2F_SHIFT                    (2U)
#define TPM_STATUS_CH3F_MASK                     (0x8U)
#define TPM_STATUS_CH3F_SHIFT                    (3U)
#define TPM_STATUS_TOF_MASK                      (0x100U)
#define TPM_STATUS_TOF_SHIFT                     (8U)

/*! @name COMBINE - Combine Channel Register */
#define TPM_COMBINE_COMBINE0_MASK                (0x1U)
#define TPM_COMBINE_COMBINE0_SHIFT               (0U)
#define TPM_COMBINE_COMSWAP0_MASK                (0x2U)
#define TPM_COMBINE_COMSWAP0_SHIFT               (1U)
#define TPM_COMBINE_COMBINE1_MASK                (0x100U)
#define TPM_COMBINE_COMBINE1_SHIFT               (8U)
#define TPM_COMBINE_COMSWAP1_MASK                (0x200U)
#define TPM_COMBINE_COMSWAP1_SHIFT               (9U)

/*! @name POL - Channel Polarity */
#define TPM_POL_POL0_MASK                        (0x1U)
#define TPM_POL_POL0_SHIFT                       (0U)
#define TPM_POL_POL1_MASK                        (0x2U)
#define TPM_POL_POL1_SHIFT                       (1U)
#define TPM_POL_POL2_MASK                        (0x4U)
#define TPM_POL_POL2_SHIFT                       (2U)
#define TPM_POL_POL3_MASK                        (0x8U)
#define TPM_POL_POL3_SHIFT                       (3U)

/*! @name FILTER - Filter Control */
#define TPM_FILTER_CH0FVAL_MASK                  (0xFU)
#define TPM_FILTER_CH0FVAL_SHIFT                 (0U)
#define TPM_FILTER_CH0FVAL(x)                    (((uint32_t)(((uint32_t)(x)) << TPM_FILTER_CH0FVAL_SHIFT)) & TPM_FILTER_CH0FVAL_MASK)
#define TPM_FILTER_CH1FVAL_MASK                  (0xF0U)
#define TPM_FILTER_CH1FVAL_SHIFT                 (4U)
#define TPM_FILTER_CH1FVAL(x)                    (((uint32_t)(((uint32_t)(x)) << TPM_FILTER_CH1FVAL_SHIFT)) & TPM_FILTER_CH1FVAL_MASK)
#define TPM_FILTER_CH2FVAL_MASK                  (0xF00U)
#define TPM_FILTER_CH2FVAL_SHIFT                 (8U)
#define TPM_FILTER_CH2FVAL(x)                    (((uint32_t)(((uint32_t)(x)) << TPM_FILTER_CH2FVAL_SHIFT)) & TPM_FILTER_CH2FVAL_MASK)
#define TPM_FILTER_CH3FVAL_MASK                  (0xF000U)
#define TPM_FILTER_CH3FVAL_SHIFT                 (12U)
#define TPM_FILTER_CH3FVAL(x)                    (((uint32_t)(((uint32_t)(x)) << TPM_FILTER_CH3FVAL_SHIFT)) & TPM_FILTER_CH3FVAL_MASK)

/*! @name QDCTRL - Quadrature Decoder Control and Status */
#define TPM_QDCTRL_QUADEN_MASK                   (0x1U)
#define TPM_QDCTRL_QUADEN_SHIFT                  (0U)
#define TPM_QDCTRL_TOFDIR_MASK                   (0x2U)
#define TPM_QDCTRL_TOFDIR_SHIFT                  (1U)
#define TPM_QDCTRL_QUADIR_MASK                   (0x4U)
#define TPM_QDCTRL_QUADIR_SHIFT                  (2U)
#define TPM_QDCTRL_QUADMODE_MASK                 (0x8U)
#define TPM_QDCTRL_QUADMODE_SHIFT                (3U)

/*! @name CONF - Configuration */
#define TPM_CONF_DOZEEN_MASK                     (0x20U)
#define TPM_CONF_DOZEEN_SHIFT                    (5U)
#define TPM_CONF_DBGMODE_MASK                    (0xC0U)
#define TPM_CONF_DBGMODE_SHIFT                   (6U)
#define TPM_CONF_DBGMODE(x)                      (((uint32_t)(((uint32_t)(x)) << TPM_CONF_DBGMODE_SHIFT)) & TPM_CONF_DBGMODE_MASK)
#define TPM_CONF_GTBSYNC_MASK                    (0x100U)
#define TPM_CONF_GTBSYNC_SHIFT                   (8U)
#define TPM_CONF_GTBEEN_MASK                     (0x200U)
#define TPM_CONF_GTBEEN_SHIFT                    (9U)
#define TPM_CONF_CSOT_MASK                       (0x10000U)
#define TPM_CONF_CSOT_SHIFT                      (16U)
#define TPM_CONF_CSOO_MASK                       (0x20000U)
#define TPM_CONF_CSOO_SHIFT                      (17U)
#define TPM_CONF_CROT_MASK                       (0x40000U)
#define TPM_CONF_CROT_SHIFT                      (18U)
#define TPM_CONF_CPOT_MASK                       (0x80000U)
#define TPM_CONF_CPOT_SHIFT                      (19U)
#define TPM_CONF_TRGPOL_MASK                     (0x400000U)
#define TPM_CONF_TRGPOL_SHIFT                    (22U)
#define TPM_CONF_TRGSRC_MASK                     (0x800000U)
#define TPM_CONF_TRGSRC_SHIFT                    (23U)
#define TPM_CONF_TRGSEL_MASK                     (0xF000000U)
#define TPM_CONF_TRGSEL_SHIFT                    (24U)
#define TPM_CONF_TRGSEL(x)                       (((uint32_t)(((uint32_t)(x)) << TPM_CONF_TRGSEL_SHIFT)) & TPM_CONF_TRGSEL_MASK)


/*!
 * @}
 */ /* end of group TPM_Register_Masks */


/* TPM - Peripheral instance base addresses */
/** Peripheral TPM0 base pointer */
#define TPM0_BASE_PTR                            ((TPM_MemMapPtr)0x40038000u)
/** Peripheral TPM1 base pointer */
#define TPM1_BASE_PTR                            ((TPM_MemMapPtr)0x40039000u)
/** Peripheral TPM2 base pointer */
#define TPM2_BASE_PTR                            ((TPM_MemMapPtr)0x4003A000u)
/** Array initializer of TPM peripheral base pointers */
#define TPM_BASE_PTRS                            { TPM0_BASE_PTR, TPM1_BASE_PTR, TPM2_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- TPM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TPM_Register_Accessor_Macros TPM - Register accessor macros
 * @{
 */


/* TPM - Register instance definitions */
/* TPM0 */
#define TPM0_SC                                  TPM_SC_REG(TPM0_BASE_PTR)
#define TPM0_CNT                                 TPM_CNT_REG(TPM0_BASE_PTR)
#define TPM0_MOD                                 TPM_MOD_REG(TPM0_BASE_PTR)
#define TPM0_C0SC                                TPM_CnSC_REG(TPM0_BASE_PTR,0)
#define TPM0_C0V                                 TPM_CnV_REG(TPM0_BASE_PTR,0)
#define TPM0_C1SC                                TPM_CnSC_REG(TPM0_BASE_PTR,1)
#define TPM0_C1V                                 TPM_CnV_REG(TPM0_BASE_PTR,1)
#define TPM0_C2SC                                TPM_CnSC_REG(TPM0_BASE_PTR,2)
#define TPM0_C2V                                 TPM_CnV_REG(TPM0_BASE_PTR,2)
#define TPM0_C3SC                                TPM_CnSC_REG(TPM0_BASE_PTR,3)
#define TPM0_C3V                                 TPM_CnV_REG(TPM0_BASE_PTR,3)
#define TPM0_STATUS                              TPM_STATUS_REG(TPM0_BASE_PTR)
#define TPM0_COMBINE                             TPM_COMBINE_REG(TPM0_BASE_PTR)
#define TPM0_POL                                 TPM_POL_REG(TPM0_BASE_PTR)
#define TPM0_FILTER                              TPM_FILTER_REG(TPM0_BASE_PTR)
#define TPM0_QDCTRL                              TPM_QDCTRL_REG(TPM0_BASE_PTR)
#define TPM0_CONF                                TPM_CONF_REG(TPM0_BASE_PTR)
/* TPM1 */
#define TPM1_SC                                  TPM_SC_REG(TPM1_BASE_PTR)
#define TPM1_CNT                                 TPM_CNT_REG(TPM1_BASE_PTR)
#define TPM1_MOD                                 TPM_MOD_REG(TPM1_BASE_PTR)
#define TPM1_C0SC                                TPM_CnSC_REG(TPM1_BASE_PTR,0)
#define TPM1_C0V                                 TPM_CnV_REG(TPM1_BASE_PTR,0)
#define TPM1_C1SC                                TPM_CnSC_REG(TPM1_BASE_PTR,1)
#define TPM1_C1V                                 TPM_CnV_REG(TPM1_BASE_PTR,1)
#define TPM1_STATUS                              TPM_STATUS_REG(TPM1_BASE_PTR)
#define TPM1_COMBINE                             TPM_COMBINE_REG(TPM1_BASE_PTR)
#define TPM1_POL                                 TPM_POL_REG(TPM1_BASE_PTR)
#define TPM1_FILTER                              TPM_FILTER_REG(TPM1_BASE_PTR)
#define TPM1_QDCTRL                              TPM_QDCTRL_REG(TPM1_BASE_PTR)
#define TPM1_CONF                                TPM_CONF_REG(TPM1_BASE_PTR)
/* TPM2 */
#define TPM2_SC                                  TPM_SC_REG(TPM2_BASE_PTR)
#define TPM2_CNT                                 TPM_CNT_REG(TPM2_BASE_PTR)
#define TPM2_MOD                                 TPM_MOD_REG(TPM2_BASE_PTR)
#define TPM2_C0SC                                TPM_CnSC_REG(TPM2_BASE_PTR,0)
#define TPM2_C0V                                 TPM_CnV_REG(TPM2_BASE_PTR,0)
#define TPM2_C1SC                                TPM_CnSC_REG(TPM2_BASE_PTR,1)
#define TPM2_C1V                                 TPM_CnV_REG(TPM2_BASE_PTR,1)
#define TPM2_STATUS                              TPM_STATUS_REG(TPM2_BASE_PTR)
#define TPM2_COMBINE                             TPM_COMBINE_REG(TPM2_BASE_PTR)
#define TPM2_POL                                 TPM_POL_REG(TPM2_BASE_PTR)
#define TPM2_FILTER                              TPM_FILTER_REG(TPM2_BASE_PTR)
#define TPM2_QDCTRL                              TPM_QDCTRL_REG(TPM2_BASE_PTR)
#define TPM2_CONF                                TPM_CONF_REG(TPM2_BASE_PTR)

/* TPM - Register array accessors */
#define TPM0_CnSC(index)                         TPM_CnSC_REG(TPM0_BASE_PTR,index)
#define TPM1_CnSC(index)                         TPM_CnSC_REG(TPM1_BASE_PTR,index)
#define TPM2_CnSC(index)                         TPM_CnSC_REG(TPM2_BASE_PTR,index)
#define TPM0_CnV(index)                          TPM_CnV_REG(TPM0_BASE_PTR,index)
#define TPM1_CnV(index)                          TPM_CnV_REG(TPM1_BASE_PTR,index)
#define TPM2_CnV(index)                          TPM_CnV_REG(TPM2_BASE_PTR,index)

/*!
 * @}
 */ /* end of group TPM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group TPM_Peripheral */


/* ----------------------------------------------------------------------------
   -- TRNG
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TRNG_Peripheral TRNG
 * @{
 */

/** TRNG - Peripheral register structure */
typedef struct TRNG_MemMap {
  uint32_t MCTL;                                   /**< TRNG0 Miscellaneous Control Register, offset: 0x0 */
  uint32_t SCMISC;                                 /**< TRNG0 Statistical Check Miscellaneous Register, offset: 0x4 */
  uint32_t PKRRNG;                                 /**< TRNG0 Poker Range Register, offset: 0x8 */
  union {                                          /* offset: 0xC */
    uint32_t PKRMAX;                                 /**< TRNG0 Poker Maximum Limit Register, offset: 0xC */
    uint32_t PKRSQ;                                  /**< TRNG0 Poker Square Calculation Result Register, offset: 0xC */
  };
  uint32_t SDCTL;                                  /**< TRNG0 Seed Control Register, offset: 0x10 */
  union {                                          /* offset: 0x14 */
    uint32_t SBLIM;                                  /**< TRNG0 Sparse Bit Limit Register, offset: 0x14 */
    uint32_t TOTSAM;                                 /**< TRNG0 Total Samples Register, offset: 0x14 */
  };
  uint32_t FRQMIN;                                 /**< TRNG0 Frequency Count Minimum Limit Register, offset: 0x18 */
  union {                                          /* offset: 0x1C */
    uint32_t FRQCNT;                                 /**< TRNG0 Frequency Count Register, offset: 0x1C */
    uint32_t FRQMAX;                                 /**< TRNG0 Frequency Count Maximum Limit Register, offset: 0x1C */
  };
  union {                                          /* offset: 0x20 */
    uint32_t SCMC;                                   /**< TRNG0 Statistical Check Monobit Count Register, offset: 0x20 */
    uint32_t SCML;                                   /**< TRNG0 Statistical Check Monobit Limit Register, offset: 0x20 */
  };
  union {                                          /* offset: 0x24 */
    uint32_t SCR1C;                                  /**< TRNG0 Statistical Check Run Length 1 Count Register, offset: 0x24 */
    uint32_t SCR1L;                                  /**< TRNG0 Statistical Check Run Length 1 Limit Register, offset: 0x24 */
  };
  union {                                          /* offset: 0x28 */
    uint32_t SCR2C;                                  /**< TRNG0 Statistical Check Run Length 2 Count Register, offset: 0x28 */
    uint32_t SCR2L;                                  /**< TRNG0 Statistical Check Run Length 2 Limit Register, offset: 0x28 */
  };
  union {                                          /* offset: 0x2C */
    uint32_t SCR3C;                                  /**< TRNG0 Statistical Check Run Length 3 Count Register, offset: 0x2C */
    uint32_t SCR3L;                                  /**< TRNG0 Statistical Check Run Length 3 Limit Register, offset: 0x2C */
  };
  union {                                          /* offset: 0x30 */
    uint32_t SCR4C;                                  /**< TRNG0 Statistical Check Run Length 4 Count Register, offset: 0x30 */
    uint32_t SCR4L;                                  /**< TRNG0 Statistical Check Run Length 4 Limit Register, offset: 0x30 */
  };
  union {                                          /* offset: 0x34 */
    uint32_t SCR5C;                                  /**< TRNG0 Statistical Check Run Length 5 Count Register, offset: 0x34 */
    uint32_t SCR5L;                                  /**< TRNG0 Statistical Check Run Length 5 Limit Register, offset: 0x34 */
  };
  union {                                          /* offset: 0x38 */
    uint32_t SCR6PC;                                 /**< TRNG0 Statistical Check Run Length 6+ Count Register, offset: 0x38 */
    uint32_t SCR6PL;                                 /**< TRNG0 Statistical Check Run Length 6+ Limit Register, offset: 0x38 */
  };
  uint32_t STATUS;                                 /**< TRNG0 Status Register, offset: 0x3C */
  uint32_t ENT[16];                                /**< TRNG0 Entropy Read Register, array offset: 0x40, array step: 0x4 */
  uint32_t PKRCNT10;                               /**< TRNG0 Statistical Check Poker Count 1 and 0 Register, offset: 0x80 */
  uint32_t PKRCNT32;                               /**< TRNG0 Statistical Check Poker Count 3 and 2 Register, offset: 0x84 */
  uint32_t PKRCNT54;                               /**< TRNG0 Statistical Check Poker Count 5 and 4 Register, offset: 0x88 */
  uint32_t PKRCNT76;                               /**< TRNG0 Statistical Check Poker Count 7 and 6 Register, offset: 0x8C */
  uint32_t PKRCNT98;                               /**< TRNG0 Statistical Check Poker Count 9 and 8 Register, offset: 0x90 */
  uint32_t PKRCNTBA;                               /**< TRNG0 Statistical Check Poker Count B and A Register, offset: 0x94 */
  uint32_t PKRCNTDC;                               /**< TRNG0 Statistical Check Poker Count D and C Register, offset: 0x98 */
  uint32_t PKRCNTFE;                               /**< TRNG0 Statistical Check Poker Count F and E Register, offset: 0x9C */
  uint32_t SEC_CFG;                                /**< TRNG0 Security Configuration Register, offset: 0xA0 */
  uint32_t INT_CTRL;                               /**< TRNG0 Interrupt Control Register, offset: 0xA4 */
  uint32_t INT_MASK;                               /**< TRNG0 Mask Register, offset: 0xA8 */
  uint32_t INT_STATUS;                             /**< TRNG0 Interrupt Status Register, offset: 0xAC */
  uint8_t RESERVED_0[64];
  uint32_t VID1;                                   /**< TRNG0 Version ID Register (MS), offset: 0xF0 */
  uint32_t VID2;                                   /**< TRNG0 Version ID Register (LS), offset: 0xF4 */
} volatile *TRNG_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- TRNG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TRNG_Register_Accessor_Macros TRNG - Register accessor macros
 * @{
 */


/* TRNG - Register accessors */
#define TRNG_MCTL_REG(base)                      ((base)->MCTL)
#define TRNG_SCMISC_REG(base)                    ((base)->SCMISC)
#define TRNG_PKRRNG_REG(base)                    ((base)->PKRRNG)
#define TRNG_PKRMAX_REG(base)                    ((base)->PKRMAX)
#define TRNG_PKRSQ_REG(base)                     ((base)->PKRSQ)
#define TRNG_SDCTL_REG(base)                     ((base)->SDCTL)
#define TRNG_SBLIM_REG(base)                     ((base)->SBLIM)
#define TRNG_TOTSAM_REG(base)                    ((base)->TOTSAM)
#define TRNG_FRQMIN_REG(base)                    ((base)->FRQMIN)
#define TRNG_FRQCNT_REG(base)                    ((base)->FRQCNT)
#define TRNG_FRQMAX_REG(base)                    ((base)->FRQMAX)
#define TRNG_SCMC_REG(base)                      ((base)->SCMC)
#define TRNG_SCML_REG(base)                      ((base)->SCML)
#define TRNG_SCR1C_REG(base)                     ((base)->SCR1C)
#define TRNG_SCR1L_REG(base)                     ((base)->SCR1L)
#define TRNG_SCR2C_REG(base)                     ((base)->SCR2C)
#define TRNG_SCR2L_REG(base)                     ((base)->SCR2L)
#define TRNG_SCR3C_REG(base)                     ((base)->SCR3C)
#define TRNG_SCR3L_REG(base)                     ((base)->SCR3L)
#define TRNG_SCR4C_REG(base)                     ((base)->SCR4C)
#define TRNG_SCR4L_REG(base)                     ((base)->SCR4L)
#define TRNG_SCR5C_REG(base)                     ((base)->SCR5C)
#define TRNG_SCR5L_REG(base)                     ((base)->SCR5L)
#define TRNG_SCR6PC_REG(base)                    ((base)->SCR6PC)
#define TRNG_SCR6PL_REG(base)                    ((base)->SCR6PL)
#define TRNG_STATUS_REG(base)                    ((base)->STATUS)
#define TRNG_ENT_REG(base,index)                 ((base)->ENT[index])
#define TRNG_PKRCNT10_REG(base)                  ((base)->PKRCNT10)
#define TRNG_PKRCNT32_REG(base)                  ((base)->PKRCNT32)
#define TRNG_PKRCNT54_REG(base)                  ((base)->PKRCNT54)
#define TRNG_PKRCNT76_REG(base)                  ((base)->PKRCNT76)
#define TRNG_PKRCNT98_REG(base)                  ((base)->PKRCNT98)
#define TRNG_PKRCNTBA_REG(base)                  ((base)->PKRCNTBA)
#define TRNG_PKRCNTDC_REG(base)                  ((base)->PKRCNTDC)
#define TRNG_PKRCNTFE_REG(base)                  ((base)->PKRCNTFE)
#define TRNG_SEC_CFG_REG(base)                   ((base)->SEC_CFG)
#define TRNG_INT_CTRL_REG(base)                  ((base)->INT_CTRL)
#define TRNG_INT_MASK_REG(base)                  ((base)->INT_MASK)
#define TRNG_INT_STATUS_REG(base)                ((base)->INT_STATUS)
#define TRNG_VID1_REG(base)                      ((base)->VID1)
#define TRNG_VID2_REG(base)                      ((base)->VID2)

/*!
 * @}
 */ /* end of group TRNG_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- TRNG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TRNG_Register_Masks TRNG Register Masks
 * @{
 */

/*! @name MCTL - TRNG0 Miscellaneous Control Register */
#define TRNG_MCTL_SAMP_MODE_MASK                 (0x3U)
#define TRNG_MCTL_SAMP_MODE_SHIFT                (0U)
#define TRNG_MCTL_SAMP_MODE(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_SAMP_MODE_SHIFT)) & TRNG_MCTL_SAMP_MODE_MASK)
#define TRNG_MCTL_OSC_DIV_MASK                   (0xCU)
#define TRNG_MCTL_OSC_DIV_SHIFT                  (2U)
#define TRNG_MCTL_OSC_DIV(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_MCTL_OSC_DIV_SHIFT)) & TRNG_MCTL_OSC_DIV_MASK)
#define TRNG_MCTL_UNUSED_MASK                    (0x10U)
#define TRNG_MCTL_UNUSED_SHIFT                   (4U)
#define TRNG_MCTL_TRNG_ACC_MASK                  (0x20U)
#define TRNG_MCTL_TRNG_ACC_SHIFT                 (5U)
#define TRNG_MCTL_RST_DEF_MASK                   (0x40U)
#define TRNG_MCTL_RST_DEF_SHIFT                  (6U)
#define TRNG_MCTL_FOR_SCLK_MASK                  (0x80U)
#define TRNG_MCTL_FOR_SCLK_SHIFT                 (7U)
#define TRNG_MCTL_FCT_FAIL_MASK                  (0x100U)
#define TRNG_MCTL_FCT_FAIL_SHIFT                 (8U)
#define TRNG_MCTL_FCT_VAL_MASK                   (0x200U)
#define TRNG_MCTL_FCT_VAL_SHIFT                  (9U)
#define TRNG_MCTL_ENT_VAL_MASK                   (0x400U)
#define TRNG_MCTL_ENT_VAL_SHIFT                  (10U)
#define TRNG_MCTL_TST_OUT_MASK                   (0x800U)
#define TRNG_MCTL_TST_OUT_SHIFT                  (11U)
#define TRNG_MCTL_ERR_MASK                       (0x1000U)
#define TRNG_MCTL_ERR_SHIFT                      (12U)
#define TRNG_MCTL_TSTOP_OK_MASK                  (0x2000U)
#define TRNG_MCTL_TSTOP_OK_SHIFT                 (13U)
#define TRNG_MCTL_PRGM_MASK                      (0x10000U)
#define TRNG_MCTL_PRGM_SHIFT                     (16U)

/*! @name SCMISC - TRNG0 Statistical Check Miscellaneous Register */
#define TRNG_SCMISC_LRUN_MAX_MASK                (0xFFU)
#define TRNG_SCMISC_LRUN_MAX_SHIFT               (0U)
#define TRNG_SCMISC_LRUN_MAX(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_SCMISC_LRUN_MAX_SHIFT)) & TRNG_SCMISC_LRUN_MAX_MASK)
#define TRNG_SCMISC_RTY_CT_MASK                  (0xF0000U)
#define TRNG_SCMISC_RTY_CT_SHIFT                 (16U)
#define TRNG_SCMISC_RTY_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCMISC_RTY_CT_SHIFT)) & TRNG_SCMISC_RTY_CT_MASK)

/*! @name PKRRNG - TRNG0 Poker Range Register */
#define TRNG_PKRRNG_PKR_RNG_MASK                 (0xFFFFU)
#define TRNG_PKRRNG_PKR_RNG_SHIFT                (0U)
#define TRNG_PKRRNG_PKR_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_PKRRNG_PKR_RNG_SHIFT)) & TRNG_PKRRNG_PKR_RNG_MASK)

/*! @name PKRMAX - TRNG0 Poker Maximum Limit Register */
#define TRNG_PKRMAX_PKR_MAX_MASK                 (0xFFFFFFU)
#define TRNG_PKRMAX_PKR_MAX_SHIFT                (0U)
#define TRNG_PKRMAX_PKR_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_PKRMAX_PKR_MAX_SHIFT)) & TRNG_PKRMAX_PKR_MAX_MASK)

/*! @name PKRSQ - TRNG0 Poker Square Calculation Result Register */
#define TRNG_PKRSQ_PKR_SQ_MASK                   (0xFFFFFFU)
#define TRNG_PKRSQ_PKR_SQ_SHIFT                  (0U)
#define TRNG_PKRSQ_PKR_SQ(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_PKRSQ_PKR_SQ_SHIFT)) & TRNG_PKRSQ_PKR_SQ_MASK)

/*! @name SDCTL - TRNG0 Seed Control Register */
#define TRNG_SDCTL_SAMP_SIZE_MASK                (0xFFFFU)
#define TRNG_SDCTL_SAMP_SIZE_SHIFT               (0U)
#define TRNG_SDCTL_SAMP_SIZE(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_SDCTL_SAMP_SIZE_SHIFT)) & TRNG_SDCTL_SAMP_SIZE_MASK)
#define TRNG_SDCTL_ENT_DLY_MASK                  (0xFFFF0000U)
#define TRNG_SDCTL_ENT_DLY_SHIFT                 (16U)
#define TRNG_SDCTL_ENT_DLY(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SDCTL_ENT_DLY_SHIFT)) & TRNG_SDCTL_ENT_DLY_MASK)

/*! @name SBLIM - TRNG0 Sparse Bit Limit Register */
#define TRNG_SBLIM_SB_LIM_MASK                   (0x3FFU)
#define TRNG_SBLIM_SB_LIM_SHIFT                  (0U)
#define TRNG_SBLIM_SB_LIM(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_SBLIM_SB_LIM_SHIFT)) & TRNG_SBLIM_SB_LIM_MASK)

/*! @name TOTSAM - TRNG0 Total Samples Register */
#define TRNG_TOTSAM_TOT_SAM_MASK                 (0xFFFFFU)
#define TRNG_TOTSAM_TOT_SAM_SHIFT                (0U)
#define TRNG_TOTSAM_TOT_SAM(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_TOTSAM_TOT_SAM_SHIFT)) & TRNG_TOTSAM_TOT_SAM_MASK)

/*! @name FRQMIN - TRNG0 Frequency Count Minimum Limit Register */
#define TRNG_FRQMIN_FRQ_MIN_MASK                 (0x3FFFFFU)
#define TRNG_FRQMIN_FRQ_MIN_SHIFT                (0U)
#define TRNG_FRQMIN_FRQ_MIN(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_FRQMIN_FRQ_MIN_SHIFT)) & TRNG_FRQMIN_FRQ_MIN_MASK)

/*! @name FRQCNT - TRNG0 Frequency Count Register */
#define TRNG_FRQCNT_FRQ_CT_MASK                  (0x3FFFFFU)
#define TRNG_FRQCNT_FRQ_CT_SHIFT                 (0U)
#define TRNG_FRQCNT_FRQ_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_FRQCNT_FRQ_CT_SHIFT)) & TRNG_FRQCNT_FRQ_CT_MASK)

/*! @name FRQMAX - TRNG0 Frequency Count Maximum Limit Register */
#define TRNG_FRQMAX_FRQ_MAX_MASK                 (0x3FFFFFU)
#define TRNG_FRQMAX_FRQ_MAX_SHIFT                (0U)
#define TRNG_FRQMAX_FRQ_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_FRQMAX_FRQ_MAX_SHIFT)) & TRNG_FRQMAX_FRQ_MAX_MASK)

/*! @name SCMC - TRNG0 Statistical Check Monobit Count Register */
#define TRNG_SCMC_MONO_CT_MASK                   (0xFFFFU)
#define TRNG_SCMC_MONO_CT_SHIFT                  (0U)
#define TRNG_SCMC_MONO_CT(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_SCMC_MONO_CT_SHIFT)) & TRNG_SCMC_MONO_CT_MASK)

/*! @name SCML - TRNG0 Statistical Check Monobit Limit Register */
#define TRNG_SCML_MONO_MAX_MASK                  (0xFFFFU)
#define TRNG_SCML_MONO_MAX_SHIFT                 (0U)
#define TRNG_SCML_MONO_MAX(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCML_MONO_MAX_SHIFT)) & TRNG_SCML_MONO_MAX_MASK)
#define TRNG_SCML_MONO_RNG_MASK                  (0xFFFF0000U)
#define TRNG_SCML_MONO_RNG_SHIFT                 (16U)
#define TRNG_SCML_MONO_RNG(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCML_MONO_RNG_SHIFT)) & TRNG_SCML_MONO_RNG_MASK)

/*! @name SCR1C - TRNG0 Statistical Check Run Length 1 Count Register */
#define TRNG_SCR1C_R1_0_CT_MASK                  (0x7FFFU)
#define TRNG_SCR1C_R1_0_CT_SHIFT                 (0U)
#define TRNG_SCR1C_R1_0_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR1C_R1_0_CT_SHIFT)) & TRNG_SCR1C_R1_0_CT_MASK)
#define TRNG_SCR1C_R1_1_CT_MASK                  (0x7FFF0000U)
#define TRNG_SCR1C_R1_1_CT_SHIFT                 (16U)
#define TRNG_SCR1C_R1_1_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR1C_R1_1_CT_SHIFT)) & TRNG_SCR1C_R1_1_CT_MASK)

/*! @name SCR1L - TRNG0 Statistical Check Run Length 1 Limit Register */
#define TRNG_SCR1L_RUN1_MAX_MASK                 (0x7FFFU)
#define TRNG_SCR1L_RUN1_MAX_SHIFT                (0U)
#define TRNG_SCR1L_RUN1_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR1L_RUN1_MAX_SHIFT)) & TRNG_SCR1L_RUN1_MAX_MASK)
#define TRNG_SCR1L_RUN1_RNG_MASK                 (0x7FFF0000U)
#define TRNG_SCR1L_RUN1_RNG_SHIFT                (16U)
#define TRNG_SCR1L_RUN1_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR1L_RUN1_RNG_SHIFT)) & TRNG_SCR1L_RUN1_RNG_MASK)

/*! @name SCR2C - TRNG0 Statistical Check Run Length 2 Count Register */
#define TRNG_SCR2C_R2_0_CT_MASK                  (0x3FFFU)
#define TRNG_SCR2C_R2_0_CT_SHIFT                 (0U)
#define TRNG_SCR2C_R2_0_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR2C_R2_0_CT_SHIFT)) & TRNG_SCR2C_R2_0_CT_MASK)
#define TRNG_SCR2C_R2_1_CT_MASK                  (0x3FFF0000U)
#define TRNG_SCR2C_R2_1_CT_SHIFT                 (16U)
#define TRNG_SCR2C_R2_1_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR2C_R2_1_CT_SHIFT)) & TRNG_SCR2C_R2_1_CT_MASK)

/*! @name SCR2L - TRNG0 Statistical Check Run Length 2 Limit Register */
#define TRNG_SCR2L_RUN2_MAX_MASK                 (0x3FFFU)
#define TRNG_SCR2L_RUN2_MAX_SHIFT                (0U)
#define TRNG_SCR2L_RUN2_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR2L_RUN2_MAX_SHIFT)) & TRNG_SCR2L_RUN2_MAX_MASK)
#define TRNG_SCR2L_RUN2_RNG_MASK                 (0x3FFF0000U)
#define TRNG_SCR2L_RUN2_RNG_SHIFT                (16U)
#define TRNG_SCR2L_RUN2_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR2L_RUN2_RNG_SHIFT)) & TRNG_SCR2L_RUN2_RNG_MASK)

/*! @name SCR3C - TRNG0 Statistical Check Run Length 3 Count Register */
#define TRNG_SCR3C_R3_0_CT_MASK                  (0x1FFFU)
#define TRNG_SCR3C_R3_0_CT_SHIFT                 (0U)
#define TRNG_SCR3C_R3_0_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR3C_R3_0_CT_SHIFT)) & TRNG_SCR3C_R3_0_CT_MASK)
#define TRNG_SCR3C_R3_1_CT_MASK                  (0x1FFF0000U)
#define TRNG_SCR3C_R3_1_CT_SHIFT                 (16U)
#define TRNG_SCR3C_R3_1_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR3C_R3_1_CT_SHIFT)) & TRNG_SCR3C_R3_1_CT_MASK)

/*! @name SCR3L - TRNG0 Statistical Check Run Length 3 Limit Register */
#define TRNG_SCR3L_RUN3_MAX_MASK                 (0x1FFFU)
#define TRNG_SCR3L_RUN3_MAX_SHIFT                (0U)
#define TRNG_SCR3L_RUN3_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR3L_RUN3_MAX_SHIFT)) & TRNG_SCR3L_RUN3_MAX_MASK)
#define TRNG_SCR3L_RUN3_RNG_MASK                 (0x1FFF0000U)
#define TRNG_SCR3L_RUN3_RNG_SHIFT                (16U)
#define TRNG_SCR3L_RUN3_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR3L_RUN3_RNG_SHIFT)) & TRNG_SCR3L_RUN3_RNG_MASK)

/*! @name SCR4C - TRNG0 Statistical Check Run Length 4 Count Register */
#define TRNG_SCR4C_R4_0_CT_MASK                  (0xFFFU)
#define TRNG_SCR4C_R4_0_CT_SHIFT                 (0U)
#define TRNG_SCR4C_R4_0_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR4C_R4_0_CT_SHIFT)) & TRNG_SCR4C_R4_0_CT_MASK)
#define TRNG_SCR4C_R4_1_CT_MASK                  (0xFFF0000U)
#define TRNG_SCR4C_R4_1_CT_SHIFT                 (16U)
#define TRNG_SCR4C_R4_1_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR4C_R4_1_CT_SHIFT)) & TRNG_SCR4C_R4_1_CT_MASK)

/*! @name SCR4L - TRNG0 Statistical Check Run Length 4 Limit Register */
#define TRNG_SCR4L_RUN4_MAX_MASK                 (0xFFFU)
#define TRNG_SCR4L_RUN4_MAX_SHIFT                (0U)
#define TRNG_SCR4L_RUN4_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR4L_RUN4_MAX_SHIFT)) & TRNG_SCR4L_RUN4_MAX_MASK)
#define TRNG_SCR4L_RUN4_RNG_MASK                 (0xFFF0000U)
#define TRNG_SCR4L_RUN4_RNG_SHIFT                (16U)
#define TRNG_SCR4L_RUN4_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR4L_RUN4_RNG_SHIFT)) & TRNG_SCR4L_RUN4_RNG_MASK)

/*! @name SCR5C - TRNG0 Statistical Check Run Length 5 Count Register */
#define TRNG_SCR5C_R5_0_CT_MASK                  (0x7FFU)
#define TRNG_SCR5C_R5_0_CT_SHIFT                 (0U)
#define TRNG_SCR5C_R5_0_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR5C_R5_0_CT_SHIFT)) & TRNG_SCR5C_R5_0_CT_MASK)
#define TRNG_SCR5C_R5_1_CT_MASK                  (0x7FF0000U)
#define TRNG_SCR5C_R5_1_CT_SHIFT                 (16U)
#define TRNG_SCR5C_R5_1_CT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_SCR5C_R5_1_CT_SHIFT)) & TRNG_SCR5C_R5_1_CT_MASK)

/*! @name SCR5L - TRNG0 Statistical Check Run Length 5 Limit Register */
#define TRNG_SCR5L_RUN5_MAX_MASK                 (0x7FFU)
#define TRNG_SCR5L_RUN5_MAX_SHIFT                (0U)
#define TRNG_SCR5L_RUN5_MAX(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR5L_RUN5_MAX_SHIFT)) & TRNG_SCR5L_RUN5_MAX_MASK)
#define TRNG_SCR5L_RUN5_RNG_MASK                 (0x7FF0000U)
#define TRNG_SCR5L_RUN5_RNG_SHIFT                (16U)
#define TRNG_SCR5L_RUN5_RNG(x)                   (((uint32_t)(((uint32_t)(x)) << TRNG_SCR5L_RUN5_RNG_SHIFT)) & TRNG_SCR5L_RUN5_RNG_MASK)

/*! @name SCR6PC - TRNG0 Statistical Check Run Length 6+ Count Register */
#define TRNG_SCR6PC_R6P_0_CT_MASK                (0x7FFU)
#define TRNG_SCR6PC_R6P_0_CT_SHIFT               (0U)
#define TRNG_SCR6PC_R6P_0_CT(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_SCR6PC_R6P_0_CT_SHIFT)) & TRNG_SCR6PC_R6P_0_CT_MASK)
#define TRNG_SCR6PC_R6P_1_CT_MASK                (0x7FF0000U)
#define TRNG_SCR6PC_R6P_1_CT_SHIFT               (16U)
#define TRNG_SCR6PC_R6P_1_CT(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_SCR6PC_R6P_1_CT_SHIFT)) & TRNG_SCR6PC_R6P_1_CT_MASK)

/*! @name SCR6PL - TRNG0 Statistical Check Run Length 6+ Limit Register */
#define TRNG_SCR6PL_RUN6P_MAX_MASK               (0x7FFU)
#define TRNG_SCR6PL_RUN6P_MAX_SHIFT              (0U)
#define TRNG_SCR6PL_RUN6P_MAX(x)                 (((uint32_t)(((uint32_t)(x)) << TRNG_SCR6PL_RUN6P_MAX_SHIFT)) & TRNG_SCR6PL_RUN6P_MAX_MASK)
#define TRNG_SCR6PL_RUN6P_RNG_MASK               (0x7FF0000U)
#define TRNG_SCR6PL_RUN6P_RNG_SHIFT              (16U)
#define TRNG_SCR6PL_RUN6P_RNG(x)                 (((uint32_t)(((uint32_t)(x)) << TRNG_SCR6PL_RUN6P_RNG_SHIFT)) & TRNG_SCR6PL_RUN6P_RNG_MASK)

/*! @name STATUS - TRNG0 Status Register */
#define TRNG_STATUS_TF1BR0_MASK                  (0x1U)
#define TRNG_STATUS_TF1BR0_SHIFT                 (0U)
#define TRNG_STATUS_TF1BR1_MASK                  (0x2U)
#define TRNG_STATUS_TF1BR1_SHIFT                 (1U)
#define TRNG_STATUS_TF2BR0_MASK                  (0x4U)
#define TRNG_STATUS_TF2BR0_SHIFT                 (2U)
#define TRNG_STATUS_TF2BR1_MASK                  (0x8U)
#define TRNG_STATUS_TF2BR1_SHIFT                 (3U)
#define TRNG_STATUS_TF3BR0_MASK                  (0x10U)
#define TRNG_STATUS_TF3BR0_SHIFT                 (4U)
#define TRNG_STATUS_TF3BR1_MASK                  (0x20U)
#define TRNG_STATUS_TF3BR1_SHIFT                 (5U)
#define TRNG_STATUS_TF4BR0_MASK                  (0x40U)
#define TRNG_STATUS_TF4BR0_SHIFT                 (6U)
#define TRNG_STATUS_TF4BR1_MASK                  (0x80U)
#define TRNG_STATUS_TF4BR1_SHIFT                 (7U)
#define TRNG_STATUS_TF5BR0_MASK                  (0x100U)
#define TRNG_STATUS_TF5BR0_SHIFT                 (8U)
#define TRNG_STATUS_TF5BR1_MASK                  (0x200U)
#define TRNG_STATUS_TF5BR1_SHIFT                 (9U)
#define TRNG_STATUS_TF6PBR0_MASK                 (0x400U)
#define TRNG_STATUS_TF6PBR0_SHIFT                (10U)
#define TRNG_STATUS_TF6PBR1_MASK                 (0x800U)
#define TRNG_STATUS_TF6PBR1_SHIFT                (11U)
#define TRNG_STATUS_TFSB_MASK                    (0x1000U)
#define TRNG_STATUS_TFSB_SHIFT                   (12U)
#define TRNG_STATUS_TFLR_MASK                    (0x2000U)
#define TRNG_STATUS_TFLR_SHIFT                   (13U)
#define TRNG_STATUS_TFP_MASK                     (0x4000U)
#define TRNG_STATUS_TFP_SHIFT                    (14U)
#define TRNG_STATUS_TFMB_MASK                    (0x8000U)
#define TRNG_STATUS_TFMB_SHIFT                   (15U)
#define TRNG_STATUS_RETRY_CT_MASK                (0xF0000U)
#define TRNG_STATUS_RETRY_CT_SHIFT               (16U)
#define TRNG_STATUS_RETRY_CT(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_STATUS_RETRY_CT_SHIFT)) & TRNG_STATUS_RETRY_CT_MASK)

/*! @name ENT - TRNG0 Entropy Read Register */
#define TRNG_ENT_ENT_MASK                        (0xFFFFFFFFU)
#define TRNG_ENT_ENT_SHIFT                       (0U)
#define TRNG_ENT_ENT(x)                          (((uint32_t)(((uint32_t)(x)) << TRNG_ENT_ENT_SHIFT)) & TRNG_ENT_ENT_MASK)

/* The count of TRNG_ENT */
#define TRNG_ENT_COUNT                           (16U)

/*! @name PKRCNT10 - TRNG0 Statistical Check Poker Count 1 and 0 Register */
#define TRNG_PKRCNT10_PKR_0_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNT10_PKR_0_CT_SHIFT             (0U)
#define TRNG_PKRCNT10_PKR_0_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT10_PKR_0_CT_SHIFT)) & TRNG_PKRCNT10_PKR_0_CT_MASK)
#define TRNG_PKRCNT10_PKR_1_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNT10_PKR_1_CT_SHIFT             (16U)
#define TRNG_PKRCNT10_PKR_1_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT10_PKR_1_CT_SHIFT)) & TRNG_PKRCNT10_PKR_1_CT_MASK)

/*! @name PKRCNT32 - TRNG0 Statistical Check Poker Count 3 and 2 Register */
#define TRNG_PKRCNT32_PKR_2_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNT32_PKR_2_CT_SHIFT             (0U)
#define TRNG_PKRCNT32_PKR_2_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT32_PKR_2_CT_SHIFT)) & TRNG_PKRCNT32_PKR_2_CT_MASK)
#define TRNG_PKRCNT32_PKR_3_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNT32_PKR_3_CT_SHIFT             (16U)
#define TRNG_PKRCNT32_PKR_3_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT32_PKR_3_CT_SHIFT)) & TRNG_PKRCNT32_PKR_3_CT_MASK)

/*! @name PKRCNT54 - TRNG0 Statistical Check Poker Count 5 and 4 Register */
#define TRNG_PKRCNT54_PKR_4_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNT54_PKR_4_CT_SHIFT             (0U)
#define TRNG_PKRCNT54_PKR_4_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT54_PKR_4_CT_SHIFT)) & TRNG_PKRCNT54_PKR_4_CT_MASK)
#define TRNG_PKRCNT54_PKR_5_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNT54_PKR_5_CT_SHIFT             (16U)
#define TRNG_PKRCNT54_PKR_5_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT54_PKR_5_CT_SHIFT)) & TRNG_PKRCNT54_PKR_5_CT_MASK)

/*! @name PKRCNT76 - TRNG0 Statistical Check Poker Count 7 and 6 Register */
#define TRNG_PKRCNT76_PKR_6_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNT76_PKR_6_CT_SHIFT             (0U)
#define TRNG_PKRCNT76_PKR_6_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT76_PKR_6_CT_SHIFT)) & TRNG_PKRCNT76_PKR_6_CT_MASK)
#define TRNG_PKRCNT76_PKR_7_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNT76_PKR_7_CT_SHIFT             (16U)
#define TRNG_PKRCNT76_PKR_7_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT76_PKR_7_CT_SHIFT)) & TRNG_PKRCNT76_PKR_7_CT_MASK)

/*! @name PKRCNT98 - TRNG0 Statistical Check Poker Count 9 and 8 Register */
#define TRNG_PKRCNT98_PKR_8_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNT98_PKR_8_CT_SHIFT             (0U)
#define TRNG_PKRCNT98_PKR_8_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT98_PKR_8_CT_SHIFT)) & TRNG_PKRCNT98_PKR_8_CT_MASK)
#define TRNG_PKRCNT98_PKR_9_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNT98_PKR_9_CT_SHIFT             (16U)
#define TRNG_PKRCNT98_PKR_9_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNT98_PKR_9_CT_SHIFT)) & TRNG_PKRCNT98_PKR_9_CT_MASK)

/*! @name PKRCNTBA - TRNG0 Statistical Check Poker Count B and A Register */
#define TRNG_PKRCNTBA_PKR_A_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNTBA_PKR_A_CT_SHIFT             (0U)
#define TRNG_PKRCNTBA_PKR_A_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTBA_PKR_A_CT_SHIFT)) & TRNG_PKRCNTBA_PKR_A_CT_MASK)
#define TRNG_PKRCNTBA_PKR_B_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNTBA_PKR_B_CT_SHIFT             (16U)
#define TRNG_PKRCNTBA_PKR_B_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTBA_PKR_B_CT_SHIFT)) & TRNG_PKRCNTBA_PKR_B_CT_MASK)

/*! @name PKRCNTDC - TRNG0 Statistical Check Poker Count D and C Register */
#define TRNG_PKRCNTDC_PKR_C_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNTDC_PKR_C_CT_SHIFT             (0U)
#define TRNG_PKRCNTDC_PKR_C_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTDC_PKR_C_CT_SHIFT)) & TRNG_PKRCNTDC_PKR_C_CT_MASK)
#define TRNG_PKRCNTDC_PKR_D_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNTDC_PKR_D_CT_SHIFT             (16U)
#define TRNG_PKRCNTDC_PKR_D_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTDC_PKR_D_CT_SHIFT)) & TRNG_PKRCNTDC_PKR_D_CT_MASK)

/*! @name PKRCNTFE - TRNG0 Statistical Check Poker Count F and E Register */
#define TRNG_PKRCNTFE_PKR_E_CT_MASK              (0xFFFFU)
#define TRNG_PKRCNTFE_PKR_E_CT_SHIFT             (0U)
#define TRNG_PKRCNTFE_PKR_E_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTFE_PKR_E_CT_SHIFT)) & TRNG_PKRCNTFE_PKR_E_CT_MASK)
#define TRNG_PKRCNTFE_PKR_F_CT_MASK              (0xFFFF0000U)
#define TRNG_PKRCNTFE_PKR_F_CT_SHIFT             (16U)
#define TRNG_PKRCNTFE_PKR_F_CT(x)                (((uint32_t)(((uint32_t)(x)) << TRNG_PKRCNTFE_PKR_F_CT_SHIFT)) & TRNG_PKRCNTFE_PKR_F_CT_MASK)

/*! @name SEC_CFG - TRNG0 Security Configuration Register */
#define TRNG_SEC_CFG_SH0_MASK                    (0x1U)
#define TRNG_SEC_CFG_SH0_SHIFT                   (0U)
#define TRNG_SEC_CFG_NO_PRGM_MASK                (0x2U)
#define TRNG_SEC_CFG_NO_PRGM_SHIFT               (1U)
#define TRNG_SEC_CFG_SK_VAL_MASK                 (0x4U)
#define TRNG_SEC_CFG_SK_VAL_SHIFT                (2U)

/*! @name INT_CTRL - TRNG0 Interrupt Control Register */
#define TRNG_INT_CTRL_HW_ERR_MASK                (0x1U)
#define TRNG_INT_CTRL_HW_ERR_SHIFT               (0U)
#define TRNG_INT_CTRL_ENT_VAL_MASK               (0x2U)
#define TRNG_INT_CTRL_ENT_VAL_SHIFT              (1U)
#define TRNG_INT_CTRL_FRQ_CT_FAIL_MASK           (0x4U)
#define TRNG_INT_CTRL_FRQ_CT_FAIL_SHIFT          (2U)
#define TRNG_INT_CTRL_UNUSED_MASK                (0xFFFFFFF8U)
#define TRNG_INT_CTRL_UNUSED_SHIFT               (3U)
#define TRNG_INT_CTRL_UNUSED(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_INT_CTRL_UNUSED_SHIFT)) & TRNG_INT_CTRL_UNUSED_MASK)

/*! @name INT_MASK - TRNG0 Mask Register */
#define TRNG_INT_MASK_HW_ERR_MASK                (0x1U)
#define TRNG_INT_MASK_HW_ERR_SHIFT               (0U)
#define TRNG_INT_MASK_ENT_VAL_MASK               (0x2U)
#define TRNG_INT_MASK_ENT_VAL_SHIFT              (1U)
#define TRNG_INT_MASK_FRQ_CT_FAIL_MASK           (0x4U)
#define TRNG_INT_MASK_FRQ_CT_FAIL_SHIFT          (2U)

/*! @name INT_STATUS - TRNG0 Interrupt Status Register */
#define TRNG_INT_STATUS_HW_ERR_MASK              (0x1U)
#define TRNG_INT_STATUS_HW_ERR_SHIFT             (0U)
#define TRNG_INT_STATUS_ENT_VAL_MASK             (0x2U)
#define TRNG_INT_STATUS_ENT_VAL_SHIFT            (1U)
#define TRNG_INT_STATUS_FRQ_CT_FAIL_MASK         (0x4U)
#define TRNG_INT_STATUS_FRQ_CT_FAIL_SHIFT        (2U)

/*! @name VID1 - TRNG0 Version ID Register (MS) */
#define TRNG_VID1_MIN_REV_MASK                   (0xFFU)
#define TRNG_VID1_MIN_REV_SHIFT                  (0U)
#define TRNG_VID1_MIN_REV(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_VID1_MIN_REV_SHIFT)) & TRNG_VID1_MIN_REV_MASK)
#define TRNG_VID1_MAJ_REV_MASK                   (0xFF00U)
#define TRNG_VID1_MAJ_REV_SHIFT                  (8U)
#define TRNG_VID1_MAJ_REV(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_VID1_MAJ_REV_SHIFT)) & TRNG_VID1_MAJ_REV_MASK)
#define TRNG_VID1_IP_ID_MASK                     (0xFFFF0000U)
#define TRNG_VID1_IP_ID_SHIFT                    (16U)
#define TRNG_VID1_IP_ID(x)                       (((uint32_t)(((uint32_t)(x)) << TRNG_VID1_IP_ID_SHIFT)) & TRNG_VID1_IP_ID_MASK)

/*! @name VID2 - TRNG0 Version ID Register (LS) */
#define TRNG_VID2_CONFIG_OPT_MASK                (0xFFU)
#define TRNG_VID2_CONFIG_OPT_SHIFT               (0U)
#define TRNG_VID2_CONFIG_OPT(x)                  (((uint32_t)(((uint32_t)(x)) << TRNG_VID2_CONFIG_OPT_SHIFT)) & TRNG_VID2_CONFIG_OPT_MASK)
#define TRNG_VID2_ECO_REV_MASK                   (0xFF00U)
#define TRNG_VID2_ECO_REV_SHIFT                  (8U)
#define TRNG_VID2_ECO_REV(x)                     (((uint32_t)(((uint32_t)(x)) << TRNG_VID2_ECO_REV_SHIFT)) & TRNG_VID2_ECO_REV_MASK)
#define TRNG_VID2_INTG_OPT_MASK                  (0xFF0000U)
#define TRNG_VID2_INTG_OPT_SHIFT                 (16U)
#define TRNG_VID2_INTG_OPT(x)                    (((uint32_t)(((uint32_t)(x)) << TRNG_VID2_INTG_OPT_SHIFT)) & TRNG_VID2_INTG_OPT_MASK)
#define TRNG_VID2_ERA_MASK                       (0xFF000000U)
#define TRNG_VID2_ERA_SHIFT                      (24U)
#define TRNG_VID2_ERA(x)                         (((uint32_t)(((uint32_t)(x)) << TRNG_VID2_ERA_SHIFT)) & TRNG_VID2_ERA_MASK)


/*!
 * @}
 */ /* end of group TRNG_Register_Masks */


/* TRNG - Peripheral instance base addresses */
/** Peripheral TRNG0 base pointer */
#define TRNG0_BASE_PTR                           ((TRNG_MemMapPtr)0x40029000u)
/** Array initializer of TRNG peripheral base pointers */
#define TRNG_BASE_PTRS                           { TRNG0_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- TRNG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TRNG_Register_Accessor_Macros TRNG - Register accessor macros
 * @{
 */


/* TRNG - Register instance definitions */
/* TRNG0 */
#define TRNG0_MCTL                               TRNG_MCTL_REG(TRNG0_BASE_PTR)
#define TRNG0_SCMISC                             TRNG_SCMISC_REG(TRNG0_BASE_PTR)
#define TRNG0_PKRRNG                             TRNG_PKRRNG_REG(TRNG0_BASE_PTR)
#define TRNG0_PKRMAX                             TRNG_PKRMAX_REG(TRNG0_BASE_PTR)
#define TRNG0_PKRSQ                              TRNG_PKRSQ_REG(TRNG0_BASE_PTR)
#define TRNG0_SDCTL                              TRNG_SDCTL_REG(TRNG0_BASE_PTR)
#define TRNG0_SBLIM                              TRNG_SBLIM_REG(TRNG0_BASE_PTR)
#define TRNG0_TOTSAM                             TRNG_TOTSAM_REG(TRNG0_BASE_PTR)
#define TRNG0_FRQMIN                             TRNG_FRQMIN_REG(TRNG0_BASE_PTR)
#define TRNG0_FRQCNT                             TRNG_FRQCNT_REG(TRNG0_BASE_PTR)
#define TRNG0_FRQMAX                             TRNG_FRQMAX_REG(TRNG0_BASE_PTR)
#define TRNG0_SCMC                               TRNG_SCMC_REG(TRNG0_BASE_PTR)
#define TRNG0_SCML                               TRNG_SCML_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR1C                              TRNG_SCR1C_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR1L                              TRNG_SCR1L_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR2C                              TRNG_SCR2C_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR2L                              TRNG_SCR2L_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR3C                              TRNG_SCR3C_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR3L                              TRNG_SCR3L_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR4C                              TRNG_SCR4C_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR4L                              TRNG_SCR4L_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR5C                              TRNG_SCR5C_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR5L                              TRNG_SCR5L_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR6PC                             TRNG_SCR6PC_REG(TRNG0_BASE_PTR)
#define TRNG0_SCR6PL                             TRNG_SCR6PL_REG(TRNG0_BASE_PTR)
#define TRNG0_STATUS                             TRNG_STATUS_REG(TRNG0_BASE_PTR)
#define TRNG0_ENT0                               TRNG_ENT_REG(TRNG0_BASE_PTR,0)
#define TRNG0_ENT1                               TRNG_ENT_REG(TRNG0_BASE_PTR,1)
#define TRNG0_ENT2                               TRNG_ENT_REG(TRNG0_BASE_PTR,2)
#define TRNG0_ENT3                               TRNG_ENT_REG(TRNG0_BASE_PTR,3)
#define TRNG0_ENT4                               TRNG_ENT_REG(TRNG0_BASE_PTR,4)
#define TRNG0_ENT5                               TRNG_ENT_REG(TRNG0_BASE_PTR,5)
#define TRNG0_ENT6                               TRNG_ENT_REG(TRNG0_BASE_PTR,6)
#define TRNG0_ENT7                               TRNG_ENT_REG(TRNG0_BASE_PTR,7)
#define TRNG0_ENT8                               TRNG_ENT_REG(TRNG0_BASE_PTR,8)
#define TRNG0_ENT9                               TRNG_ENT_REG(TRNG0_BASE_PTR,9)
#define TRNG0_ENT10                              TRNG_ENT_REG(TRNG0_BASE_PTR,10)
#define TRNG0_ENT11                              TRNG_ENT_REG(TRNG0_BASE_PTR,11)
#define TRNG0_ENT12                              TRNG_ENT_REG(TRNG0_BASE_PTR,12)
#define TRNG0_ENT13                              TRNG_ENT_REG(TRNG0_BASE_PTR,13)
#define TRNG0_ENT14                              TRNG_ENT_REG(TRNG0_BASE_PTR,14)
#define TRNG0_ENT15                              TRNG_ENT_REG(TRNG0_BASE_PTR,15)
#define TRNG0_PKRCNT10                           TRNG_PKRCNT10_REG(TRNG0_BASE_PTR)
#define TRNG0_PKRCNT32                           TRNG_PKRCNT32_REG(TRNG0_BASE_PTR)
#define TRNG0_PKRCNT54                           TRNG_PKRCNT54_REG(TRNG0_BASE_PTR)
#define TRNG0_PKRCNT76                           TRNG_PKRCNT76_REG(TRNG0_BASE_PTR)
#define TRNG0_PKRCNT98                           TRNG_PKRCNT98_REG(TRNG0_BASE_PTR)
#define TRNG0_PKRCNTBA                           TRNG_PKRCNTBA_REG(TRNG0_BASE_PTR)
#define TRNG0_PKRCNTDC                           TRNG_PKRCNTDC_REG(TRNG0_BASE_PTR)
#define TRNG0_PKRCNTFE                           TRNG_PKRCNTFE_REG(TRNG0_BASE_PTR)
#define TRNG0_SEC_CFG                            TRNG_SEC_CFG_REG(TRNG0_BASE_PTR)
#define TRNG0_INT_CTRL                           TRNG_INT_CTRL_REG(TRNG0_BASE_PTR)
#define TRNG0_INT_MASK                           TRNG_INT_MASK_REG(TRNG0_BASE_PTR)
#define TRNG0_INT_STATUS                         TRNG_INT_STATUS_REG(TRNG0_BASE_PTR)
#define TRNG0_VID1                               TRNG_VID1_REG(TRNG0_BASE_PTR)
#define TRNG0_VID2                               TRNG_VID2_REG(TRNG0_BASE_PTR)

/* TRNG - Register array accessors */
#define TRNG0_ENT(index)                         TRNG_ENT_REG(TRNG0_BASE_PTR,index)

/*!
 * @}
 */ /* end of group TRNG_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group TRNG_Peripheral */


/* ----------------------------------------------------------------------------
   -- TSI
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TSI_Peripheral TSI
 * @{
 */

/** TSI - Peripheral register structure */
typedef struct TSI_MemMap {
  uint32_t GENCS;                                  /**< TSI General Control and Status Register, offset: 0x0 */
  uint32_t DATA;                                   /**< TSI DATA Register, offset: 0x4 */
  uint32_t TSHD;                                   /**< TSI Threshold Register, offset: 0x8 */
} volatile *TSI_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- TSI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TSI_Register_Accessor_Macros TSI - Register accessor macros
 * @{
 */


/* TSI - Register accessors */
#define TSI_GENCS_REG(base)                      ((base)->GENCS)
#define TSI_DATA_REG(base)                       ((base)->DATA)
#define TSI_TSHD_REG(base)                       ((base)->TSHD)

/*!
 * @}
 */ /* end of group TSI_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- TSI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TSI_Register_Masks TSI Register Masks
 * @{
 */

/*! @name GENCS - TSI General Control and Status Register */
#define TSI_GENCS_CURSW_MASK                     (0x2U)
#define TSI_GENCS_CURSW_SHIFT                    (1U)
#define TSI_GENCS_EOSF_MASK                      (0x4U)
#define TSI_GENCS_EOSF_SHIFT                     (2U)
#define TSI_GENCS_SCNIP_MASK                     (0x8U)
#define TSI_GENCS_SCNIP_SHIFT                    (3U)
#define TSI_GENCS_STM_MASK                       (0x10U)
#define TSI_GENCS_STM_SHIFT                      (4U)
#define TSI_GENCS_STPE_MASK                      (0x20U)
#define TSI_GENCS_STPE_SHIFT                     (5U)
#define TSI_GENCS_TSIIEN_MASK                    (0x40U)
#define TSI_GENCS_TSIIEN_SHIFT                   (6U)
#define TSI_GENCS_TSIEN_MASK                     (0x80U)
#define TSI_GENCS_TSIEN_SHIFT                    (7U)
#define TSI_GENCS_NSCN_MASK                      (0x1F00U)
#define TSI_GENCS_NSCN_SHIFT                     (8U)
#define TSI_GENCS_NSCN(x)                        (((uint32_t)(((uint32_t)(x)) << TSI_GENCS_NSCN_SHIFT)) & TSI_GENCS_NSCN_MASK)
#define TSI_GENCS_PS_MASK                        (0xE000U)
#define TSI_GENCS_PS_SHIFT                       (13U)
#define TSI_GENCS_PS(x)                          (((uint32_t)(((uint32_t)(x)) << TSI_GENCS_PS_SHIFT)) & TSI_GENCS_PS_MASK)
#define TSI_GENCS_EXTCHRG_MASK                   (0x70000U)
#define TSI_GENCS_EXTCHRG_SHIFT                  (16U)
#define TSI_GENCS_EXTCHRG(x)                     (((uint32_t)(((uint32_t)(x)) << TSI_GENCS_EXTCHRG_SHIFT)) & TSI_GENCS_EXTCHRG_MASK)
#define TSI_GENCS_DVOLT_MASK                     (0x180000U)
#define TSI_GENCS_DVOLT_SHIFT                    (19U)
#define TSI_GENCS_DVOLT(x)                       (((uint32_t)(((uint32_t)(x)) << TSI_GENCS_DVOLT_SHIFT)) & TSI_GENCS_DVOLT_MASK)
#define TSI_GENCS_REFCHRG_MASK                   (0xE00000U)
#define TSI_GENCS_REFCHRG_SHIFT                  (21U)
#define TSI_GENCS_REFCHRG(x)                     (((uint32_t)(((uint32_t)(x)) << TSI_GENCS_REFCHRG_SHIFT)) & TSI_GENCS_REFCHRG_MASK)
#define TSI_GENCS_MODE_MASK                      (0xF000000U)
#define TSI_GENCS_MODE_SHIFT                     (24U)
#define TSI_GENCS_MODE(x)                        (((uint32_t)(((uint32_t)(x)) << TSI_GENCS_MODE_SHIFT)) & TSI_GENCS_MODE_MASK)
#define TSI_GENCS_ESOR_MASK                      (0x10000000U)
#define TSI_GENCS_ESOR_SHIFT                     (28U)
#define TSI_GENCS_OUTRGF_MASK                    (0x80000000U)
#define TSI_GENCS_OUTRGF_SHIFT                   (31U)

/*! @name DATA - TSI DATA Register */
#define TSI_DATA_TSICNT_MASK                     (0xFFFFU)
#define TSI_DATA_TSICNT_SHIFT                    (0U)
#define TSI_DATA_TSICNT(x)                       (((uint32_t)(((uint32_t)(x)) << TSI_DATA_TSICNT_SHIFT)) & TSI_DATA_TSICNT_MASK)
#define TSI_DATA_SWTS_MASK                       (0x400000U)
#define TSI_DATA_SWTS_SHIFT                      (22U)
#define TSI_DATA_DMAEN_MASK                      (0x800000U)
#define TSI_DATA_DMAEN_SHIFT                     (23U)
#define TSI_DATA_TSICH_MASK                      (0xF0000000U)
#define TSI_DATA_TSICH_SHIFT                     (28U)
#define TSI_DATA_TSICH(x)                        (((uint32_t)(((uint32_t)(x)) << TSI_DATA_TSICH_SHIFT)) & TSI_DATA_TSICH_MASK)

/*! @name TSHD - TSI Threshold Register */
#define TSI_TSHD_THRESL_MASK                     (0xFFFFU)
#define TSI_TSHD_THRESL_SHIFT                    (0U)
#define TSI_TSHD_THRESL(x)                       (((uint32_t)(((uint32_t)(x)) << TSI_TSHD_THRESL_SHIFT)) & TSI_TSHD_THRESL_MASK)
#define TSI_TSHD_THRESH_MASK                     (0xFFFF0000U)
#define TSI_TSHD_THRESH_SHIFT                    (16U)
#define TSI_TSHD_THRESH(x)                       (((uint32_t)(((uint32_t)(x)) << TSI_TSHD_THRESH_SHIFT)) & TSI_TSHD_THRESH_MASK)


/*!
 * @}
 */ /* end of group TSI_Register_Masks */


/* TSI - Peripheral instance base addresses */
/** Peripheral TSI0 base pointer */
#define TSI0_BASE_PTR                            ((TSI_MemMapPtr)0x40045000u)
/** Array initializer of TSI peripheral base pointers */
#define TSI_BASE_PTRS                            { TSI0_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- TSI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TSI_Register_Accessor_Macros TSI - Register accessor macros
 * @{
 */


/* TSI - Register instance definitions */
/* TSI0 */
#define TSI0_GENCS                               TSI_GENCS_REG(TSI0_BASE_PTR)
#define TSI0_DATA                                TSI_DATA_REG(TSI0_BASE_PTR)
#define TSI0_TSHD                                TSI_TSHD_REG(TSI0_BASE_PTR)

/*!
 * @}
 */ /* end of group TSI_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group TSI_Peripheral */


/* ----------------------------------------------------------------------------
   -- VREF
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup VREF_Peripheral VREF
 * @{
 */

/** VREF - Peripheral register structure */
typedef struct VREF_MemMap {
  uint8_t TRM;                                     /**< VREF Trim Register, offset: 0x0 */
  uint8_t SC;                                      /**< VREF Status and Control Register, offset: 0x1 */
} volatile *VREF_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- VREF - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup VREF_Register_Accessor_Macros VREF - Register accessor macros
 * @{
 */


/* VREF - Register accessors */
#define VREF_TRM_REG(base)                       ((base)->TRM)
#define VREF_SC_REG(base)                        ((base)->SC)

/*!
 * @}
 */ /* end of group VREF_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- VREF Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup VREF_Register_Masks VREF Register Masks
 * @{
 */

/*! @name TRM - VREF Trim Register */
#define VREF_TRM_TRIM_MASK                       (0x3FU)
#define VREF_TRM_TRIM_SHIFT                      (0U)
#define VREF_TRM_TRIM(x)                         (((uint8_t)(((uint8_t)(x)) << VREF_TRM_TRIM_SHIFT)) & VREF_TRM_TRIM_MASK)
#define VREF_TRM_CHOPEN_MASK                     (0x40U)
#define VREF_TRM_CHOPEN_SHIFT                    (6U)

/*! @name SC - VREF Status and Control Register */
#define VREF_SC_MODE_LV_MASK                     (0x3U)
#define VREF_SC_MODE_LV_SHIFT                    (0U)
#define VREF_SC_MODE_LV(x)                       (((uint8_t)(((uint8_t)(x)) << VREF_SC_MODE_LV_SHIFT)) & VREF_SC_MODE_LV_MASK)
#define VREF_SC_VREFST_MASK                      (0x4U)
#define VREF_SC_VREFST_SHIFT                     (2U)
#define VREF_SC_ICOMPEN_MASK                     (0x20U)
#define VREF_SC_ICOMPEN_SHIFT                    (5U)
#define VREF_SC_REGEN_MASK                       (0x40U)
#define VREF_SC_REGEN_SHIFT                      (6U)
#define VREF_SC_VREFEN_MASK                      (0x80U)
#define VREF_SC_VREFEN_SHIFT                     (7U)


/*!
 * @}
 */ /* end of group VREF_Register_Masks */


/* VREF - Peripheral instance base addresses */
/** Peripheral VREF base pointer */
#define VREF_BASE_PTR                            ((VREF_MemMapPtr)0x40074000u)
/** Array initializer of VREF peripheral base pointers */
#define VREF_BASE_PTRS                           { VREF_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- VREF - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup VREF_Register_Accessor_Macros VREF - Register accessor macros
 * @{
 */


/* VREF - Register instance definitions */
/* VREF */
#define VREF_TRM                                 VREF_TRM_REG(VREF_BASE_PTR)
#define VREF_SC                                  VREF_SC_REG(VREF_BASE_PTR)

/*!
 * @}
 */ /* end of group VREF_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group VREF_Peripheral */


/* ----------------------------------------------------------------------------
   -- XCVR_ANALOG
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_ANALOG_Peripheral XCVR_ANALOG
 * @{
 */

/** XCVR_ANALOG - Peripheral register structure */
typedef struct XCVR_ANALOG_MemMap {
  uint32_t BB_LDO_1;                               /**< RF Analog Baseband LDO Control 1, offset: 0x0 */
  uint32_t BB_LDO_2;                               /**< RF Analog Baseband LDO Control 2, offset: 0x4 */
  uint32_t RX_ADC;                                 /**< RF Analog ADC Control, offset: 0x8 */
  uint32_t RX_BBA;                                 /**< RF Analog BBA Control, offset: 0xC */
  uint32_t RX_LNA;                                 /**< RF Analog LNA Control, offset: 0x10 */
  uint32_t RX_TZA;                                 /**< RF Analog TZA Control, offset: 0x14 */
  uint32_t RX_AUXPLL;                              /**< RF Analog Aux PLL Control, offset: 0x18 */
  uint32_t SY_CTRL_1;                              /**< RF Analog Synthesizer Control 1, offset: 0x1C */
  uint32_t SY_CTRL_2;                              /**< RF Analog Synthesizer Control 2, offset: 0x20 */
  uint32_t TX_DAC_PA;                              /**< RF Analog TX HPM DAC and PA Control, offset: 0x24 */
  uint32_t BALUN_TX;                               /**< RF Analog Balun TX Mode Control, offset: 0x28 */
  uint32_t BALUN_RX;                               /**< RF Analog Balun RX Mode Control, offset: 0x2C */
  uint32_t DFT_OBSV_1;                             /**< RF Analog DFT Observation Register 1, offset: 0x30 */
  uint32_t DFT_OBSV_2;                             /**< RF Analog DFT Observation Register 2, offset: 0x34 */
} volatile *XCVR_ANALOG_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- XCVR_ANALOG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_ANALOG_Register_Accessor_Macros XCVR_ANALOG - Register accessor macros
 * @{
 */


/* XCVR_ANALOG - Register accessors */
#define XCVR_ANALOG_BB_LDO_1_REG(base)           ((base)->BB_LDO_1)
#define XCVR_ANALOG_BB_LDO_2_REG(base)           ((base)->BB_LDO_2)
#define XCVR_ANALOG_RX_ADC_REG(base)             ((base)->RX_ADC)
#define XCVR_ANALOG_RX_BBA_REG(base)             ((base)->RX_BBA)
#define XCVR_ANALOG_RX_LNA_REG(base)             ((base)->RX_LNA)
#define XCVR_ANALOG_RX_TZA_REG(base)             ((base)->RX_TZA)
#define XCVR_ANALOG_RX_AUXPLL_REG(base)          ((base)->RX_AUXPLL)
#define XCVR_ANALOG_SY_CTRL_1_REG(base)          ((base)->SY_CTRL_1)
#define XCVR_ANALOG_SY_CTRL_2_REG(base)          ((base)->SY_CTRL_2)
#define XCVR_ANALOG_TX_DAC_PA_REG(base)          ((base)->TX_DAC_PA)
#define XCVR_ANALOG_BALUN_TX_REG(base)           ((base)->BALUN_TX)
#define XCVR_ANALOG_BALUN_RX_REG(base)           ((base)->BALUN_RX)
#define XCVR_ANALOG_DFT_OBSV_1_REG(base)         ((base)->DFT_OBSV_1)
#define XCVR_ANALOG_DFT_OBSV_2_REG(base)         ((base)->DFT_OBSV_2)

/*!
 * @}
 */ /* end of group XCVR_ANALOG_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- XCVR_ANALOG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_ANALOG_Register_Masks XCVR_ANALOG Register Masks
 * @{
 */

/*! @name BB_LDO_1 - RF Analog Baseband LDO Control 1 */
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_BYP_MASK (0x1U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_BYP_SHIFT (0U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL_MASK (0x2U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_DIAGSEL_SHIFT (1U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_SPARE_MASK (0xCU)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_SPARE_SHIFT (2U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_SPARE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_TRIM_MASK (0x70U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_TRIM_SHIFT (4U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_TRIM(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_ADCDAC_TRIM_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_BYP_MASK (0x100U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_BYP_SHIFT (8U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_DIAGSEL_MASK (0x200U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_DIAGSEL_SHIFT (9U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_SPARE_MASK (0xC00U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_SPARE_SHIFT (10U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_SPARE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_TRIM_MASK (0x7000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_TRIM_SHIFT (12U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_TRIM(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_BBA_TRIM_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_BYP_MASK (0x10000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_BYP_SHIFT (16U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_DIAGSEL_MASK (0x20000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_DIAGSEL_SHIFT (17U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_SPARE_MASK (0xC0000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_SPARE_SHIFT (18U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_SPARE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_TRIM_MASK (0x700000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_TRIM_SHIFT (20U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_TRIM(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_FDBK_TRIM_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_BYP_MASK  (0x1000000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_BYP_SHIFT (24U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_DIAGSEL_MASK (0x2000000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_DIAGSEL_SHIFT (25U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_SPARE_MASK (0xC000000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_SPARE_SHIFT (26U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_SPARE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_TRIM_MASK (0x70000000U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_TRIM_SHIFT (28U)
#define XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_TRIM(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_1_BB_LDO_HF_TRIM_MASK)

/*! @name BB_LDO_2 - RF Analog Baseband LDO Control 2 */
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_BYP_MASK  (0x1U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_BYP_SHIFT (0U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_DIAGSEL_MASK (0x2U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_DIAGSEL_SHIFT (1U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_SPARE_MASK (0xCU)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_SPARE_SHIFT (2U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_SPARE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_TRIM_MASK (0x70U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_TRIM_SHIFT (4U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_TRIM(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_PD_TRIM_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCO_SPARE_MASK (0x300U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCO_SPARE_SHIFT (8U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCO_SPARE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_VCO_SPARE_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_VCO_SPARE_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_BYP_MASK (0x400U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_BYP_SHIFT (10U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL_MASK (0x800U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_DIAGSEL_SHIFT (11U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_TRIM_MASK (0x7000U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_TRIM_SHIFT (12U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_TRIM(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_TRIM_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_VCOLO_TRIM_MASK)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_DIAGSEL_MASK (0x10000U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_DIAGSEL_SHIFT (16U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_TC_MASK (0x60000U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_TC_SHIFT (17U)
#define XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_TC(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_TC_SHIFT)) & XCVR_ANALOG_BB_LDO_2_BB_LDO_VTREF_TC_MASK)

/*! @name RX_ADC - RF Analog ADC Control */
#define XCVR_ANALOG_RX_ADC_RX_ADC_BUMP_MASK      (0xFFU)
#define XCVR_ANALOG_RX_ADC_RX_ADC_BUMP_SHIFT     (0U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_BUMP(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_ADC_RX_ADC_BUMP_SHIFT)) & XCVR_ANALOG_RX_ADC_RX_ADC_BUMP_MASK)
#define XCVR_ANALOG_RX_ADC_RX_ADC_FS_SEL_MASK    (0x300U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_FS_SEL_SHIFT   (8U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_FS_SEL(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_ADC_RX_ADC_FS_SEL_SHIFT)) & XCVR_ANALOG_RX_ADC_RX_ADC_FS_SEL_MASK)
#define XCVR_ANALOG_RX_ADC_RX_ADC_I_DIAGSEL_MASK (0x400U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_I_DIAGSEL_SHIFT (10U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_Q_DIAGSEL_MASK (0x800U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_Q_DIAGSEL_SHIFT (11U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_SPARE_MASK     (0xF000U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_SPARE_SHIFT    (12U)
#define XCVR_ANALOG_RX_ADC_RX_ADC_SPARE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_ADC_RX_ADC_SPARE_SHIFT)) & XCVR_ANALOG_RX_ADC_RX_ADC_SPARE_MASK)

/*! @name RX_BBA - RF Analog BBA Control */
#define XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_MASK    (0x7U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_SHIFT   (0U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA_BW_SEL_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA_CUR_BUMP_MASK  (0x8U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_CUR_BUMP_SHIFT (3U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL1_MASK  (0x10U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL1_SHIFT (4U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL2_MASK  (0x20U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL2_SHIFT (5U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL3_MASK  (0x40U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL3_SHIFT (6U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL4_MASK  (0x80U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_DIAGSEL4_SHIFT (7U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_SPARE_MASK     (0x3F0000U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_SPARE_SHIFT    (16U)
#define XCVR_ANALOG_RX_BBA_RX_BBA_SPARE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA_SPARE_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA_SPARE_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_MASK   (0x7000000U)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_SHIFT  (24U)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA2_BW_SEL_MASK)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_SPARE_MASK    (0x70000000U)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_SPARE_SHIFT   (28U)
#define XCVR_ANALOG_RX_BBA_RX_BBA2_SPARE(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_BBA_RX_BBA2_SPARE_SHIFT)) & XCVR_ANALOG_RX_BBA_RX_BBA2_SPARE_MASK)

/*! @name RX_LNA - RF Analog LNA Control */
#define XCVR_ANALOG_RX_LNA_RX_LNA_BUMP_MASK      (0xFU)
#define XCVR_ANALOG_RX_LNA_RX_LNA_BUMP_SHIFT     (0U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_BUMP(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_LNA_RX_LNA_BUMP_SHIFT)) & XCVR_ANALOG_RX_LNA_RX_LNA_BUMP_MASK)
#define XCVR_ANALOG_RX_LNA_RX_LNA_HG_DIAGSEL_MASK (0x10U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_HG_DIAGSEL_SHIFT (4U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_HIZ_ENABLE_MASK (0x20U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_HIZ_ENABLE_SHIFT (5U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_LG_DIAGSEL_MASK (0x40U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_LG_DIAGSEL_SHIFT (6U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_SPARE_MASK     (0x300U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_SPARE_SHIFT    (8U)
#define XCVR_ANALOG_RX_LNA_RX_LNA_SPARE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_LNA_RX_LNA_SPARE_SHIFT)) & XCVR_ANALOG_RX_LNA_RX_LNA_SPARE_MASK)
#define XCVR_ANALOG_RX_LNA_RX_MIXER_BUMP_MASK    (0xF0000U)
#define XCVR_ANALOG_RX_LNA_RX_MIXER_BUMP_SHIFT   (16U)
#define XCVR_ANALOG_RX_LNA_RX_MIXER_BUMP(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_LNA_RX_MIXER_BUMP_SHIFT)) & XCVR_ANALOG_RX_LNA_RX_MIXER_BUMP_MASK)
#define XCVR_ANALOG_RX_LNA_RX_MIXER_SPARE_MASK   (0x100000U)
#define XCVR_ANALOG_RX_LNA_RX_MIXER_SPARE_SHIFT  (20U)

/*! @name RX_TZA - RF Analog TZA Control */
#define XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_MASK    (0x7U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_SHIFT   (0U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA_BW_SEL_MASK)
#define XCVR_ANALOG_RX_TZA_RX_TZA_CUR_BUMP_MASK  (0x8U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_CUR_BUMP_SHIFT (3U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_GAIN_BUMP_MASK (0x10U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_GAIN_BUMP_SHIFT (4U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_SPARE_MASK     (0x3F0000U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_SPARE_SHIFT    (16U)
#define XCVR_ANALOG_RX_TZA_RX_TZA_SPARE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_TZA_RX_TZA_SPARE_SHIFT)) & XCVR_ANALOG_RX_TZA_RX_TZA_SPARE_MASK)
#define XCVR_ANALOG_RX_TZA_RX_TZA1_DIAGSEL_MASK  (0x1000000U)
#define XCVR_ANALOG_RX_TZA_RX_TZA1_DIAGSEL_SHIFT (24U)
#define XCVR_ANALOG_RX_TZA_RX_TZA2_DIAGSEL_MASK  (0x2000000U)
#define XCVR_ANALOG_RX_TZA_RX_TZA2_DIAGSEL_SHIFT (25U)
#define XCVR_ANALOG_RX_TZA_RX_TZA3_DIAGSEL_MASK  (0x4000000U)
#define XCVR_ANALOG_RX_TZA_RX_TZA3_DIAGSEL_SHIFT (26U)
#define XCVR_ANALOG_RX_TZA_RX_TZA4_DIAGSEL_MASK  (0x8000000U)
#define XCVR_ANALOG_RX_TZA_RX_TZA4_DIAGSEL_SHIFT (27U)

/*! @name RX_AUXPLL - RF Analog Aux PLL Control */
#define XCVR_ANALOG_RX_AUXPLL_BIAS_TRIM_MASK     (0x7U)
#define XCVR_ANALOG_RX_AUXPLL_BIAS_TRIM_SHIFT    (0U)
#define XCVR_ANALOG_RX_AUXPLL_BIAS_TRIM(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_BIAS_TRIM_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_BIAS_TRIM_MASK)
#define XCVR_ANALOG_RX_AUXPLL_DIAGSEL1_MASK      (0x8U)
#define XCVR_ANALOG_RX_AUXPLL_DIAGSEL1_SHIFT     (3U)
#define XCVR_ANALOG_RX_AUXPLL_DIAGSEL2_MASK      (0x10U)
#define XCVR_ANALOG_RX_AUXPLL_DIAGSEL2_SHIFT     (4U)
#define XCVR_ANALOG_RX_AUXPLL_LF_CNTL_MASK       (0xE0U)
#define XCVR_ANALOG_RX_AUXPLL_LF_CNTL_SHIFT      (5U)
#define XCVR_ANALOG_RX_AUXPLL_LF_CNTL(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_LF_CNTL_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_LF_CNTL_MASK)
#define XCVR_ANALOG_RX_AUXPLL_SPARE_MASK         (0xF00U)
#define XCVR_ANALOG_RX_AUXPLL_SPARE_SHIFT        (8U)
#define XCVR_ANALOG_RX_AUXPLL_SPARE(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_SPARE_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_SPARE_MASK)
#define XCVR_ANALOG_RX_AUXPLL_VCO_DAC_REF_ADJUST_MASK (0xF000U)
#define XCVR_ANALOG_RX_AUXPLL_VCO_DAC_REF_ADJUST_SHIFT (12U)
#define XCVR_ANALOG_RX_AUXPLL_VCO_DAC_REF_ADJUST(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_VCO_DAC_REF_ADJUST_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_VCO_DAC_REF_ADJUST_MASK)
#define XCVR_ANALOG_RX_AUXPLL_VTUNE_TESTMODE_MASK (0x10000U)
#define XCVR_ANALOG_RX_AUXPLL_VTUNE_TESTMODE_SHIFT (16U)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_BIAST_MASK (0x300000U)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_BIAST_SHIFT (20U)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_BIAST(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_BIAST_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_BIAST_MASK)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_SPARE_MASK (0x7000000U)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_SPARE_SHIFT (24U)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_SPARE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_SPARE_SHIFT)) & XCVR_ANALOG_RX_AUXPLL_RXTX_BAL_SPARE_MASK)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_RCCAL_DIAGSEL_MASK (0x10000000U)
#define XCVR_ANALOG_RX_AUXPLL_RXTX_RCCAL_DIAGSEL_SHIFT (28U)

/*! @name SY_CTRL_1 - RF Analog Synthesizer Control 1 */
#define XCVR_ANALOG_SY_CTRL_1_SY_DIVN_SPARE_MASK (0x1U)
#define XCVR_ANALOG_SY_CTRL_1_SY_DIVN_SPARE_SHIFT (0U)
#define XCVR_ANALOG_SY_CTRL_1_SY_FCAL_SPARE_MASK (0x2U)
#define XCVR_ANALOG_SY_CTRL_1_SY_FCAL_SPARE_SHIFT (1U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_MASK (0x30U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_SHIFT (4U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_FDBK_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_MASK (0xC0U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_SHIFT (6U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_RX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_RX_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_MASK (0x300U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_SHIFT (8U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_TX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LO_BUMP_RTLO_TX_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_DIAGSEL_MASK (0x400U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_DIAGSEL_SHIFT (10U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_SPARE_MASK   (0x7000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_SPARE_SHIFT  (12U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LO_SPARE(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LO_SPARE_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LO_SPARE_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_FILT_CTRL_MASK (0x70000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_FILT_CTRL_SHIFT (16U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_FILT_CTRL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_LPF_FILT_CTRL_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_LPF_FILT_CTRL_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_SPARE_MASK  (0x80000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_LPF_SPARE_SHIFT (19U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_DIAGSEL_MASK (0x100000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_DIAGSEL_SHIFT (20U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_TUNE_MASK (0x600000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_TUNE_SHIFT (21U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_TUNE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_TUNE_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_TUNE_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_SEL_MASK (0x800000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_PCH_SEL_SHIFT (23U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_SPARE_MASK   (0x3000000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_SPARE_SHIFT  (24U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_SPARE(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_1_SY_PD_SPARE_SHIFT)) & XCVR_ANALOG_SY_CTRL_1_SY_PD_SPARE_MASK)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_VTUNE_OVERRIDE_TEST_MODE_MASK (0x10000000U)
#define XCVR_ANALOG_SY_CTRL_1_SY_PD_VTUNE_OVERRIDE_TEST_MODE_SHIFT (28U)

/*! @name SY_CTRL_2 - RF Analog Synthesizer Control 2 */
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_BIAS_MASK   (0x7U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_BIAS_SHIFT  (0U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_BIAS(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_BIAS_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_BIAS_MASK)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_DIAGSEL_MASK (0x8U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_DIAGSEL_SHIFT (3U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KV_MASK     (0x70U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KV_SHIFT    (4U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KV(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_KV_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_KV_MASK)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_MASK    (0x700U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_SHIFT   (8U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_KVM_MASK)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_PK_DET_ON_MASK (0x1000U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_PK_DET_ON_SHIFT (12U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_SPARE_MASK  (0x1C000U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_SPARE_SHIFT (14U)
#define XCVR_ANALOG_SY_CTRL_2_SY_VCO_SPARE(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_SY_CTRL_2_SY_VCO_SPARE_SHIFT)) & XCVR_ANALOG_SY_CTRL_2_SY_VCO_SPARE_MASK)

/*! @name TX_DAC_PA - RF Analog TX HPM DAC and PA Control */
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_CAP_MASK (0x3U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_CAP_SHIFT (0U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_CAP(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_CAP_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_CAP_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_IDAC_MASK (0x18U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_IDAC_SHIFT (3U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_IDAC(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_IDAC_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_IDAC_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_RLOAD_MASK (0xC0U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_RLOAD_SHIFT (6U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_RLOAD(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_RLOAD_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_BUMP_RLOAD_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_DIAGSEL_MASK (0x200U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_DIAGSEL_SHIFT (9U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_INVERT_CLK_MASK (0x400U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_INVERT_CLK_SHIFT (10U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL_MASK (0x800U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_OPAMP_DIAGSEL_SHIFT (11U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_SPARE_MASK  (0xE000U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_SPARE_SHIFT (13U)
#define XCVR_ANALOG_TX_DAC_PA_TX_DAC_SPARE(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_DAC_SPARE_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_DAC_SPARE_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_BUMP_VBIAS_MASK (0xE0000U)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_BUMP_VBIAS_SHIFT (17U)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_BUMP_VBIAS(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_PA_BUMP_VBIAS_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_PA_BUMP_VBIAS_MASK)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_DIAGSEL_MASK (0x200000U)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_DIAGSEL_SHIFT (21U)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_SPARE_MASK   (0x3800000U)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_SPARE_SHIFT  (23U)
#define XCVR_ANALOG_TX_DAC_PA_TX_PA_SPARE(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_TX_DAC_PA_TX_PA_SPARE_SHIFT)) & XCVR_ANALOG_TX_DAC_PA_TX_PA_SPARE_MASK)

/*! @name BALUN_TX - RF Analog Balun TX Mode Control */
#define XCVR_ANALOG_BALUN_TX_RXTX_BAL_TX_CODE_MASK (0xFFFFFFU)
#define XCVR_ANALOG_BALUN_TX_RXTX_BAL_TX_CODE_SHIFT (0U)
#define XCVR_ANALOG_BALUN_TX_RXTX_BAL_TX_CODE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BALUN_TX_RXTX_BAL_TX_CODE_SHIFT)) & XCVR_ANALOG_BALUN_TX_RXTX_BAL_TX_CODE_MASK)

/*! @name BALUN_RX - RF Analog Balun RX Mode Control */
#define XCVR_ANALOG_BALUN_RX_RXTX_BAL_RX_CODE_MASK (0xFFFFFFU)
#define XCVR_ANALOG_BALUN_RX_RXTX_BAL_RX_CODE_SHIFT (0U)
#define XCVR_ANALOG_BALUN_RX_RXTX_BAL_RX_CODE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_BALUN_RX_RXTX_BAL_RX_CODE_SHIFT)) & XCVR_ANALOG_BALUN_RX_RXTX_BAL_RX_CODE_MASK)

/*! @name DFT_OBSV_1 - RF Analog DFT Observation Register 1 */
#define XCVR_ANALOG_DFT_OBSV_1_DFT_FREQ_COUNTER_MASK (0x7FFFFU)
#define XCVR_ANALOG_DFT_OBSV_1_DFT_FREQ_COUNTER_SHIFT (0U)
#define XCVR_ANALOG_DFT_OBSV_1_DFT_FREQ_COUNTER(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_DFT_OBSV_1_DFT_FREQ_COUNTER_SHIFT)) & XCVR_ANALOG_DFT_OBSV_1_DFT_FREQ_COUNTER_MASK)
#define XCVR_ANALOG_DFT_OBSV_1_CTUNE_MAX_DIFF_MASK (0xFF00000U)
#define XCVR_ANALOG_DFT_OBSV_1_CTUNE_MAX_DIFF_SHIFT (20U)
#define XCVR_ANALOG_DFT_OBSV_1_CTUNE_MAX_DIFF(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_DFT_OBSV_1_CTUNE_MAX_DIFF_SHIFT)) & XCVR_ANALOG_DFT_OBSV_1_CTUNE_MAX_DIFF_MASK)

/*! @name DFT_OBSV_2 - RF Analog DFT Observation Register 2 */
#define XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_MAX_DIFF_MASK (0x1FFFFU)
#define XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_MAX_DIFF_SHIFT (0U)
#define XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_MAX_DIFF(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_MAX_DIFF_SHIFT)) & XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_MAX_DIFF_MASK)
#define XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_MAX_DIFF_CH_MASK (0x7F000000U)
#define XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_MAX_DIFF_CH_SHIFT (24U)
#define XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_MAX_DIFF_CH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_MAX_DIFF_CH_SHIFT)) & XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_MAX_DIFF_CH_MASK)
#define XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_IGNORE_FAILS_MASK (0x80000000U)
#define XCVR_ANALOG_DFT_OBSV_2_SYN_BIST_IGNORE_FAILS_SHIFT (31U)


/*!
 * @}
 */ /* end of group XCVR_ANALOG_Register_Masks */


/* XCVR_ANALOG - Peripheral instance base addresses */
/** Peripheral XCVR_ANALOG_REGS base pointer */
#define XCVR_ANA_BASE_PTR                        ((XCVR_ANALOG_MemMapPtr)0x4005C500u)
/** Array initializer of XCVR_ANALOG peripheral base pointers */
#define XCVR_ANALOG_BASE_PTRS                    { XCVR_ANA_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- XCVR_ANALOG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_ANALOG_Register_Accessor_Macros XCVR_ANALOG - Register accessor macros
 * @{
 */


/* XCVR_ANALOG - Register instance definitions */
/* XCVR_ANALOG_REGS */
#define XCVR_ANA_BB_LDO_1                        XCVR_ANALOG_BB_LDO_1_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_BB_LDO_2                        XCVR_ANALOG_BB_LDO_2_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_RX_ADC                          XCVR_ANALOG_RX_ADC_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_RX_BBA                          XCVR_ANALOG_RX_BBA_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_RX_LNA                          XCVR_ANALOG_RX_LNA_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_RX_TZA                          XCVR_ANALOG_RX_TZA_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_RX_AUXPLL                       XCVR_ANALOG_RX_AUXPLL_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_SY_CTRL_1                       XCVR_ANALOG_SY_CTRL_1_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_SY_CTRL_2                       XCVR_ANALOG_SY_CTRL_2_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_TX_DAC_PA                       XCVR_ANALOG_TX_DAC_PA_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_BALUN_TX                        XCVR_ANALOG_BALUN_TX_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_BALUN_RX                        XCVR_ANALOG_BALUN_RX_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_DFT_OBSV_1                      XCVR_ANALOG_DFT_OBSV_1_REG(XCVR_ANA_BASE_PTR)
#define XCVR_ANA_DFT_OBSV_2                      XCVR_ANALOG_DFT_OBSV_2_REG(XCVR_ANA_BASE_PTR)

/*!
 * @}
 */ /* end of group XCVR_ANALOG_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group XCVR_ANALOG_Peripheral */


/* ----------------------------------------------------------------------------
   -- XCVR_CTRL
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_CTRL_Peripheral XCVR_CTRL
 * @{
 */

/** XCVR_CTRL - Peripheral register structure */
typedef struct XCVR_CTRL_MemMap {
  uint32_t XCVR_CTRL;                              /**< TRANSCEIVER CONTROL, offset: 0x0 */
  uint32_t XCVR_STATUS;                            /**< TRANSCEIVER STATUS, offset: 0x4 */
  uint32_t BLE_ARB_CTRL;                           /**< BLE ARBITRATION CONTROL, offset: 0x8 */
  uint8_t RESERVED_0[4];
  uint32_t OVERWRITE_VER;                          /**< OVERWRITE VERSION, offset: 0x10 */
  uint32_t DMA_CTRL;                               /**< TRANSCEIVER DMA CONTROL, offset: 0x14 */
  uint32_t DMA_DATA;                               /**< TRANSCEIVER DMA DATA, offset: 0x18 */
  uint32_t DTEST_CTRL;                             /**< DIGITAL TEST MUX CONTROL, offset: 0x1C */
  uint32_t PACKET_RAM_CTRL;                        /**< PACKET RAM CONTROL, offset: 0x20 */
  uint32_t FAD_CTRL;                               /**< FAD CONTROL, offset: 0x24 */
  uint32_t LPPS_CTRL;                              /**< LOW POWER PREAMBLE SEARCH CONTROL, offset: 0x28 */
  uint32_t RF_NOT_ALLOWED_CTRL;                    /**< WIFI COEXISTENCE CONTROL, offset: 0x2C */
  uint32_t CRCW_CFG;                               /**< CRC/WHITENER CONTROL, offset: 0x30 */
  uint32_t CRC_EC_MASK;                            /**< CRC ERROR CORRECTION MASK, offset: 0x34 */
  uint32_t CRC_RES_OUT;                            /**< CRC RESULT, offset: 0x38 */
} volatile *XCVR_CTRL_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- XCVR_CTRL - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_CTRL_Register_Accessor_Macros XCVR_CTRL - Register accessor macros
 * @{
 */


/* XCVR_CTRL - Register accessors */
#define XCVR_CTRL_XCVR_CTRL_REG(base)            ((base)->XCVR_CTRL)
#define XCVR_CTRL_XCVR_STATUS_REG(base)          ((base)->XCVR_STATUS)
#define XCVR_CTRL_BLE_ARB_CTRL_REG(base)         ((base)->BLE_ARB_CTRL)
#define XCVR_CTRL_OVERWRITE_VER_REG(base)        ((base)->OVERWRITE_VER)
#define XCVR_CTRL_DMA_CTRL_REG(base)             ((base)->DMA_CTRL)
#define XCVR_CTRL_DMA_DATA_REG(base)             ((base)->DMA_DATA)
#define XCVR_CTRL_DTEST_CTRL_REG(base)           ((base)->DTEST_CTRL)
#define XCVR_CTRL_PACKET_RAM_CTRL_REG(base)      ((base)->PACKET_RAM_CTRL)
#define XCVR_CTRL_FAD_CTRL_REG(base)             ((base)->FAD_CTRL)
#define XCVR_CTRL_LPPS_CTRL_REG(base)            ((base)->LPPS_CTRL)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_REG(base)  ((base)->RF_NOT_ALLOWED_CTRL)
#define XCVR_CTRL_CRCW_CFG_REG(base)             ((base)->CRCW_CFG)
#define XCVR_CTRL_CRC_EC_MASK_REG(base)          ((base)->CRC_EC_MASK)
#define XCVR_CTRL_CRC_RES_OUT_REG(base)          ((base)->CRC_RES_OUT)

/*!
 * @}
 */ /* end of group XCVR_CTRL_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- XCVR_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_CTRL_Register_Masks XCVR_CTRL Register Masks
 * @{
 */

/*! @name XCVR_CTRL - TRANSCEIVER CONTROL */
#define XCVR_CTRL_XCVR_CTRL_PROTOCOL_MASK        (0xFU)
#define XCVR_CTRL_XCVR_CTRL_PROTOCOL_SHIFT       (0U)
#define XCVR_CTRL_XCVR_CTRL_PROTOCOL(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_XCVR_CTRL_PROTOCOL_SHIFT)) & XCVR_CTRL_XCVR_CTRL_PROTOCOL_MASK)
#define XCVR_CTRL_XCVR_CTRL_TGT_PWR_SRC_MASK     (0x70U)
#define XCVR_CTRL_XCVR_CTRL_TGT_PWR_SRC_SHIFT    (4U)
#define XCVR_CTRL_XCVR_CTRL_TGT_PWR_SRC(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_XCVR_CTRL_TGT_PWR_SRC_SHIFT)) & XCVR_CTRL_XCVR_CTRL_TGT_PWR_SRC_MASK)
#define XCVR_CTRL_XCVR_CTRL_REF_CLK_FREQ_MASK    (0x300U)
#define XCVR_CTRL_XCVR_CTRL_REF_CLK_FREQ_SHIFT   (8U)
#define XCVR_CTRL_XCVR_CTRL_REF_CLK_FREQ(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_XCVR_CTRL_REF_CLK_FREQ_SHIFT)) & XCVR_CTRL_XCVR_CTRL_REF_CLK_FREQ_MASK)
#define XCVR_CTRL_XCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN_MASK (0x800U)
#define XCVR_CTRL_XCVR_CTRL_SOC_RF_OSC_CLK_GATE_EN_SHIFT (11U)
#define XCVR_CTRL_XCVR_CTRL_DEMOD_SEL_MASK       (0x3000U)
#define XCVR_CTRL_XCVR_CTRL_DEMOD_SEL_SHIFT      (12U)
#define XCVR_CTRL_XCVR_CTRL_DEMOD_SEL(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_XCVR_CTRL_DEMOD_SEL_SHIFT)) & XCVR_CTRL_XCVR_CTRL_DEMOD_SEL_MASK)
#define XCVR_CTRL_XCVR_CTRL_RADIO0_IRQ_SEL_MASK  (0x70000U)
#define XCVR_CTRL_XCVR_CTRL_RADIO0_IRQ_SEL_SHIFT (16U)
#define XCVR_CTRL_XCVR_CTRL_RADIO0_IRQ_SEL(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_XCVR_CTRL_RADIO0_IRQ_SEL_SHIFT)) & XCVR_CTRL_XCVR_CTRL_RADIO0_IRQ_SEL_MASK)
#define XCVR_CTRL_XCVR_CTRL_RADIO1_IRQ_SEL_MASK  (0x700000U)
#define XCVR_CTRL_XCVR_CTRL_RADIO1_IRQ_SEL_SHIFT (20U)
#define XCVR_CTRL_XCVR_CTRL_RADIO1_IRQ_SEL(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_XCVR_CTRL_RADIO1_IRQ_SEL_SHIFT)) & XCVR_CTRL_XCVR_CTRL_RADIO1_IRQ_SEL_MASK)

/*! @name XCVR_STATUS - TRANSCEIVER STATUS */
#define XCVR_CTRL_XCVR_STATUS_TSM_COUNT_MASK     (0xFFU)
#define XCVR_CTRL_XCVR_STATUS_TSM_COUNT_SHIFT    (0U)
#define XCVR_CTRL_XCVR_STATUS_TSM_COUNT(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_XCVR_STATUS_TSM_COUNT_SHIFT)) & XCVR_CTRL_XCVR_STATUS_TSM_COUNT_MASK)
#define XCVR_CTRL_XCVR_STATUS_PLL_SEQ_STATE_MASK (0xF00U)
#define XCVR_CTRL_XCVR_STATUS_PLL_SEQ_STATE_SHIFT (8U)
#define XCVR_CTRL_XCVR_STATUS_PLL_SEQ_STATE(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_XCVR_STATUS_PLL_SEQ_STATE_SHIFT)) & XCVR_CTRL_XCVR_STATUS_PLL_SEQ_STATE_MASK)
#define XCVR_CTRL_XCVR_STATUS_RX_MODE_MASK       (0x1000U)
#define XCVR_CTRL_XCVR_STATUS_RX_MODE_SHIFT      (12U)
#define XCVR_CTRL_XCVR_STATUS_TX_MODE_MASK       (0x2000U)
#define XCVR_CTRL_XCVR_STATUS_TX_MODE_SHIFT      (13U)
#define XCVR_CTRL_XCVR_STATUS_BTLE_SYSCLK_REQ_MASK (0x10000U)
#define XCVR_CTRL_XCVR_STATUS_BTLE_SYSCLK_REQ_SHIFT (16U)
#define XCVR_CTRL_XCVR_STATUS_RIF_LL_ACTIVE_MASK (0x20000U)
#define XCVR_CTRL_XCVR_STATUS_RIF_LL_ACTIVE_SHIFT (17U)
#define XCVR_CTRL_XCVR_STATUS_XTAL_READY_MASK    (0x40000U)
#define XCVR_CTRL_XCVR_STATUS_XTAL_READY_SHIFT   (18U)
#define XCVR_CTRL_XCVR_STATUS_SOC_USING_RF_OSC_CLK_MASK (0x80000U)
#define XCVR_CTRL_XCVR_STATUS_SOC_USING_RF_OSC_CLK_SHIFT (19U)
#define XCVR_CTRL_XCVR_STATUS_TSM_IRQ0_MASK      (0x1000000U)
#define XCVR_CTRL_XCVR_STATUS_TSM_IRQ0_SHIFT     (24U)
#define XCVR_CTRL_XCVR_STATUS_TSM_IRQ1_MASK      (0x2000000U)
#define XCVR_CTRL_XCVR_STATUS_TSM_IRQ1_SHIFT     (25U)

/*! @name BLE_ARB_CTRL - BLE ARBITRATION CONTROL */
#define XCVR_CTRL_BLE_ARB_CTRL_BLE_RELINQUISH_MASK (0x1U)
#define XCVR_CTRL_BLE_ARB_CTRL_BLE_RELINQUISH_SHIFT (0U)
#define XCVR_CTRL_BLE_ARB_CTRL_XCVR_BUSY_MASK    (0x2U)
#define XCVR_CTRL_BLE_ARB_CTRL_XCVR_BUSY_SHIFT   (1U)

/*! @name OVERWRITE_VER - OVERWRITE VERSION */
#define XCVR_CTRL_OVERWRITE_VER_OVERWRITE_VER_MASK (0xFFU)
#define XCVR_CTRL_OVERWRITE_VER_OVERWRITE_VER_SHIFT (0U)
#define XCVR_CTRL_OVERWRITE_VER_OVERWRITE_VER(x) (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_OVERWRITE_VER_OVERWRITE_VER_SHIFT)) & XCVR_CTRL_OVERWRITE_VER_OVERWRITE_VER_MASK)

/*! @name DMA_CTRL - TRANSCEIVER DMA CONTROL */
#define XCVR_CTRL_DMA_CTRL_DMA_PAGE_MASK         (0xFU)
#define XCVR_CTRL_DMA_CTRL_DMA_PAGE_SHIFT        (0U)
#define XCVR_CTRL_DMA_CTRL_DMA_PAGE(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_DMA_CTRL_DMA_PAGE_SHIFT)) & XCVR_CTRL_DMA_CTRL_DMA_PAGE_MASK)
#define XCVR_CTRL_DMA_CTRL_SINGLE_REQ_MODE_MASK  (0x10U)
#define XCVR_CTRL_DMA_CTRL_SINGLE_REQ_MODE_SHIFT (4U)
#define XCVR_CTRL_DMA_CTRL_BYPASS_DMA_SYNC_MASK  (0x20U)
#define XCVR_CTRL_DMA_CTRL_BYPASS_DMA_SYNC_SHIFT (5U)
#define XCVR_CTRL_DMA_CTRL_DMA_TRIGGERRED_MASK   (0x40U)
#define XCVR_CTRL_DMA_CTRL_DMA_TRIGGERRED_SHIFT  (6U)
#define XCVR_CTRL_DMA_CTRL_DMA_TIMED_OUT_MASK    (0x80U)
#define XCVR_CTRL_DMA_CTRL_DMA_TIMED_OUT_SHIFT   (7U)
#define XCVR_CTRL_DMA_CTRL_DMA_TIMEOUT_MASK      (0xF00U)
#define XCVR_CTRL_DMA_CTRL_DMA_TIMEOUT_SHIFT     (8U)
#define XCVR_CTRL_DMA_CTRL_DMA_TIMEOUT(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_DMA_CTRL_DMA_TIMEOUT_SHIFT)) & XCVR_CTRL_DMA_CTRL_DMA_TIMEOUT_MASK)

/*! @name DMA_DATA - TRANSCEIVER DMA DATA */
#define XCVR_CTRL_DMA_DATA_DMA_DATA_MASK         (0xFFFFFFFFU)
#define XCVR_CTRL_DMA_DATA_DMA_DATA_SHIFT        (0U)
#define XCVR_CTRL_DMA_DATA_DMA_DATA(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_DMA_DATA_DMA_DATA_SHIFT)) & XCVR_CTRL_DMA_DATA_DMA_DATA_MASK)

/*! @name DTEST_CTRL - DIGITAL TEST MUX CONTROL */
#define XCVR_CTRL_DTEST_CTRL_DTEST_PAGE_MASK     (0x3FU)
#define XCVR_CTRL_DTEST_CTRL_DTEST_PAGE_SHIFT    (0U)
#define XCVR_CTRL_DTEST_CTRL_DTEST_PAGE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_DTEST_CTRL_DTEST_PAGE_SHIFT)) & XCVR_CTRL_DTEST_CTRL_DTEST_PAGE_MASK)
#define XCVR_CTRL_DTEST_CTRL_DTEST_EN_MASK       (0x80U)
#define XCVR_CTRL_DTEST_CTRL_DTEST_EN_SHIFT      (7U)
#define XCVR_CTRL_DTEST_CTRL_GPIO0_OVLAY_PIN_MASK (0xF00U)
#define XCVR_CTRL_DTEST_CTRL_GPIO0_OVLAY_PIN_SHIFT (8U)
#define XCVR_CTRL_DTEST_CTRL_GPIO0_OVLAY_PIN(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_DTEST_CTRL_GPIO0_OVLAY_PIN_SHIFT)) & XCVR_CTRL_DTEST_CTRL_GPIO0_OVLAY_PIN_MASK)
#define XCVR_CTRL_DTEST_CTRL_GPIO1_OVLAY_PIN_MASK (0xF000U)
#define XCVR_CTRL_DTEST_CTRL_GPIO1_OVLAY_PIN_SHIFT (12U)
#define XCVR_CTRL_DTEST_CTRL_GPIO1_OVLAY_PIN(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_DTEST_CTRL_GPIO1_OVLAY_PIN_SHIFT)) & XCVR_CTRL_DTEST_CTRL_GPIO1_OVLAY_PIN_MASK)
#define XCVR_CTRL_DTEST_CTRL_TSM_GPIO_OVLAY_MASK (0x30000U)
#define XCVR_CTRL_DTEST_CTRL_TSM_GPIO_OVLAY_SHIFT (16U)
#define XCVR_CTRL_DTEST_CTRL_TSM_GPIO_OVLAY(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_DTEST_CTRL_TSM_GPIO_OVLAY_SHIFT)) & XCVR_CTRL_DTEST_CTRL_TSM_GPIO_OVLAY_MASK)
#define XCVR_CTRL_DTEST_CTRL_DTEST_SHFT_MASK     (0x7000000U)
#define XCVR_CTRL_DTEST_CTRL_DTEST_SHFT_SHIFT    (24U)
#define XCVR_CTRL_DTEST_CTRL_DTEST_SHFT(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_DTEST_CTRL_DTEST_SHFT_SHIFT)) & XCVR_CTRL_DTEST_CTRL_DTEST_SHFT_MASK)
#define XCVR_CTRL_DTEST_CTRL_RAW_MODE_I_MASK     (0x10000000U)
#define XCVR_CTRL_DTEST_CTRL_RAW_MODE_I_SHIFT    (28U)
#define XCVR_CTRL_DTEST_CTRL_RAW_MODE_Q_MASK     (0x20000000U)
#define XCVR_CTRL_DTEST_CTRL_RAW_MODE_Q_SHIFT    (29U)

/*! @name PACKET_RAM_CTRL - PACKET RAM CONTROL */
#define XCVR_CTRL_PACKET_RAM_CTRL_DBG_PAGE_MASK  (0xFU)
#define XCVR_CTRL_PACKET_RAM_CTRL_DBG_PAGE_SHIFT (0U)
#define XCVR_CTRL_PACKET_RAM_CTRL_DBG_PAGE(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_PACKET_RAM_CTRL_DBG_PAGE_SHIFT)) & XCVR_CTRL_PACKET_RAM_CTRL_DBG_PAGE_MASK)
#define XCVR_CTRL_PACKET_RAM_CTRL_PB_PROTECT_MASK (0x10U)
#define XCVR_CTRL_PACKET_RAM_CTRL_PB_PROTECT_SHIFT (4U)
#define XCVR_CTRL_PACKET_RAM_CTRL_XCVR_RAM_ALLOW_MASK (0x20U)
#define XCVR_CTRL_PACKET_RAM_CTRL_XCVR_RAM_ALLOW_SHIFT (5U)
#define XCVR_CTRL_PACKET_RAM_CTRL_ALL_PROTOCOLS_ALLOW_MASK (0x40U)
#define XCVR_CTRL_PACKET_RAM_CTRL_ALL_PROTOCOLS_ALLOW_SHIFT (6U)
#define XCVR_CTRL_PACKET_RAM_CTRL_DBG_TRIGGERRED_MASK (0x80U)
#define XCVR_CTRL_PACKET_RAM_CTRL_DBG_TRIGGERRED_SHIFT (7U)
#define XCVR_CTRL_PACKET_RAM_CTRL_DBG_RAM_FULL_MASK (0x300U)
#define XCVR_CTRL_PACKET_RAM_CTRL_DBG_RAM_FULL_SHIFT (8U)
#define XCVR_CTRL_PACKET_RAM_CTRL_DBG_RAM_FULL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_PACKET_RAM_CTRL_DBG_RAM_FULL_SHIFT)) & XCVR_CTRL_PACKET_RAM_CTRL_DBG_RAM_FULL_MASK)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_EN_MASK (0x400U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_EN_SHIFT (10U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_MASK (0x800U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM0_CLK_ON_OVRD_SHIFT (11U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_EN_MASK (0x1000U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_EN_SHIFT (12U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_MASK (0x2000U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM1_CLK_ON_OVRD_SHIFT (13U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_EN_MASK (0x4000U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_EN_SHIFT (14U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_MASK (0x8000U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM0_CE_ON_OVRD_SHIFT (15U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_EN_MASK (0x10000U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_EN_SHIFT (16U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_MASK (0x20000U)
#define XCVR_CTRL_PACKET_RAM_CTRL_RAM1_CE_ON_OVRD_SHIFT (17U)

/*! @name FAD_CTRL - FAD CONTROL */
#define XCVR_CTRL_FAD_CTRL_FAD_EN_MASK           (0x1U)
#define XCVR_CTRL_FAD_CTRL_FAD_EN_SHIFT          (0U)
#define XCVR_CTRL_FAD_CTRL_ANTX_MASK             (0x2U)
#define XCVR_CTRL_FAD_CTRL_ANTX_SHIFT            (1U)
#define XCVR_CTRL_FAD_CTRL_ANTX_EN_MASK          (0x30U)
#define XCVR_CTRL_FAD_CTRL_ANTX_EN_SHIFT         (4U)
#define XCVR_CTRL_FAD_CTRL_ANTX_EN(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_FAD_CTRL_ANTX_EN_SHIFT)) & XCVR_CTRL_FAD_CTRL_ANTX_EN_MASK)
#define XCVR_CTRL_FAD_CTRL_ANTX_HZ_MASK          (0x40U)
#define XCVR_CTRL_FAD_CTRL_ANTX_HZ_SHIFT         (6U)
#define XCVR_CTRL_FAD_CTRL_ANTX_CTRLMODE_MASK    (0x80U)
#define XCVR_CTRL_FAD_CTRL_ANTX_CTRLMODE_SHIFT   (7U)
#define XCVR_CTRL_FAD_CTRL_ANTX_POL_MASK         (0xF00U)
#define XCVR_CTRL_FAD_CTRL_ANTX_POL_SHIFT        (8U)
#define XCVR_CTRL_FAD_CTRL_ANTX_POL(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_FAD_CTRL_ANTX_POL_SHIFT)) & XCVR_CTRL_FAD_CTRL_ANTX_POL_MASK)
#define XCVR_CTRL_FAD_CTRL_FAD_NOT_GPIO_MASK     (0xF000U)
#define XCVR_CTRL_FAD_CTRL_FAD_NOT_GPIO_SHIFT    (12U)
#define XCVR_CTRL_FAD_CTRL_FAD_NOT_GPIO(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_FAD_CTRL_FAD_NOT_GPIO_SHIFT)) & XCVR_CTRL_FAD_CTRL_FAD_NOT_GPIO_MASK)

/*! @name LPPS_CTRL - LOW POWER PREAMBLE SEARCH CONTROL */
#define XCVR_CTRL_LPPS_CTRL_LPPS_ENABLE_MASK     (0x1U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_ENABLE_SHIFT    (0U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_TZA_ALLOW_MASK  (0x2U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_TZA_ALLOW_SHIFT (1U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_BBA_ALLOW_MASK  (0x4U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_BBA_ALLOW_SHIFT (2U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_ADC_ALLOW_MASK  (0x8U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_ADC_ALLOW_SHIFT (3U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_DCOC_ALLOW_MASK (0x10U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_DCOC_ALLOW_SHIFT (4U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_PDET_ALLOW_MASK (0x20U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_PDET_ALLOW_SHIFT (5U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_SY_LO_ALLOW_MASK (0x40U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_SY_LO_ALLOW_SHIFT (6U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_SY_LO_BUF_ALLOW_MASK (0x80U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_SY_LO_BUF_ALLOW_SHIFT (7U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_RX_DIG_ALLOW_MASK (0x100U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_RX_DIG_ALLOW_SHIFT (8U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_DCOC_DIG_ALLOW_MASK (0x200U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_DCOC_DIG_ALLOW_SHIFT (9U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_START_RX_MASK   (0xFF0000U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_START_RX_SHIFT  (16U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_START_RX(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_LPPS_CTRL_LPPS_START_RX_SHIFT)) & XCVR_CTRL_LPPS_CTRL_LPPS_START_RX_MASK)
#define XCVR_CTRL_LPPS_CTRL_LPPS_DEST_RX_MASK    (0xFF000000U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_DEST_RX_SHIFT   (24U)
#define XCVR_CTRL_LPPS_CTRL_LPPS_DEST_RX(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_LPPS_CTRL_LPPS_DEST_RX_SHIFT)) & XCVR_CTRL_LPPS_CTRL_LPPS_DEST_RX_MASK)

/*! @name RF_NOT_ALLOWED_CTRL - WIFI COEXISTENCE CONTROL */
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_TX_MASK (0x1U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_TX_SHIFT (0U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_RX_MASK (0x2U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_NO_RX_SHIFT (1U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_ASSERTED_MASK (0x4U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_ASSERTED_SHIFT (2U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_TX_ABORT_MASK (0x8U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_TX_ABORT_SHIFT (3U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_RX_ABORT_MASK (0x10U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_RX_ABORT_SHIFT (4U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_MASK (0x20U)
#define XCVR_CTRL_RF_NOT_ALLOWED_CTRL_RF_NOT_ALLOWED_SHIFT (5U)

/*! @name CRCW_CFG - CRC/WHITENER CONTROL */
#define XCVR_CTRL_CRCW_CFG_CRCW_EN_MASK          (0x1U)
#define XCVR_CTRL_CRCW_CFG_CRCW_EN_SHIFT         (0U)
#define XCVR_CTRL_CRCW_CFG_CRC_ZERO_MASK         (0x2U)
#define XCVR_CTRL_CRCW_CFG_CRC_ZERO_SHIFT        (1U)
#define XCVR_CTRL_CRCW_CFG_CRC_EARLY_FAIL_MASK   (0x4U)
#define XCVR_CTRL_CRCW_CFG_CRC_EARLY_FAIL_SHIFT  (2U)
#define XCVR_CTRL_CRCW_CFG_CRC_RES_OUT_VLD_MASK  (0x8U)
#define XCVR_CTRL_CRCW_CFG_CRC_RES_OUT_VLD_SHIFT (3U)
#define XCVR_CTRL_CRCW_CFG_CRC_EC_OFFSET_MASK    (0x7FF0000U)
#define XCVR_CTRL_CRCW_CFG_CRC_EC_OFFSET_SHIFT   (16U)
#define XCVR_CTRL_CRCW_CFG_CRC_EC_OFFSET(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_CRCW_CFG_CRC_EC_OFFSET_SHIFT)) & XCVR_CTRL_CRCW_CFG_CRC_EC_OFFSET_MASK)
#define XCVR_CTRL_CRCW_CFG_CRC_EC_DONE_MASK      (0x10000000U)
#define XCVR_CTRL_CRCW_CFG_CRC_EC_DONE_SHIFT     (28U)
#define XCVR_CTRL_CRCW_CFG_CRC_EC_FAIL_MASK      (0x20000000U)
#define XCVR_CTRL_CRCW_CFG_CRC_EC_FAIL_SHIFT     (29U)

/*! @name CRC_EC_MASK - CRC ERROR CORRECTION MASK */
#define XCVR_CTRL_CRC_EC_MASK_CRC_EC_MASK_MASK   (0xFFFFFFFFU)
#define XCVR_CTRL_CRC_EC_MASK_CRC_EC_MASK_SHIFT  (0U)
#define XCVR_CTRL_CRC_EC_MASK_CRC_EC_MASK(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_CRC_EC_MASK_CRC_EC_MASK_SHIFT)) & XCVR_CTRL_CRC_EC_MASK_CRC_EC_MASK_MASK)

/*! @name CRC_RES_OUT - CRC RESULT */
#define XCVR_CTRL_CRC_RES_OUT_CRC_RES_OUT_MASK   (0xFFFFFFFFU)
#define XCVR_CTRL_CRC_RES_OUT_CRC_RES_OUT_SHIFT  (0U)
#define XCVR_CTRL_CRC_RES_OUT_CRC_RES_OUT(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_CTRL_CRC_RES_OUT_CRC_RES_OUT_SHIFT)) & XCVR_CTRL_CRC_RES_OUT_CRC_RES_OUT_MASK)


/*!
 * @}
 */ /* end of group XCVR_CTRL_Register_Masks */


/* XCVR_CTRL - Peripheral instance base addresses */
/** Peripheral XCVR_CTRL_REGS base pointer */
#define XCVR_MISC_BASE_PTR                       ((XCVR_CTRL_MemMapPtr)0x4005C280u)
/** Array initializer of XCVR_CTRL peripheral base pointers */
#define XCVR_CTRL_BASE_PTRS                      { XCVR_MISC_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- XCVR_CTRL - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_CTRL_Register_Accessor_Macros XCVR_CTRL - Register accessor macros
 * @{
 */


/* XCVR_CTRL - Register instance definitions */
/* XCVR_CTRL_REGS */
#define XCVR_MISC_XCVR_CTRL                      XCVR_CTRL_XCVR_CTRL_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_XCVR_STATUS                    XCVR_CTRL_XCVR_STATUS_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_BLE_ARB_CTRL                   XCVR_CTRL_BLE_ARB_CTRL_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_OVERWRITE_VER                  XCVR_CTRL_OVERWRITE_VER_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_DMA_CTRL                       XCVR_CTRL_DMA_CTRL_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_DMA_DATA                       XCVR_CTRL_DMA_DATA_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_DTEST_CTRL                     XCVR_CTRL_DTEST_CTRL_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_PACKET_RAM_CTRL                XCVR_CTRL_PACKET_RAM_CTRL_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_FAD_CTRL                       XCVR_CTRL_FAD_CTRL_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_LPPS_CTRL                      XCVR_CTRL_LPPS_CTRL_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_RF_NOT_ALLOWED_CTRL            XCVR_CTRL_RF_NOT_ALLOWED_CTRL_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_CRCW_CFG                       XCVR_CTRL_CRCW_CFG_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_CRC_EC_MASK                    XCVR_CTRL_CRC_EC_MASK_REG(XCVR_MISC_BASE_PTR)
#define XCVR_MISC_CRC_RES_OUT                    XCVR_CTRL_CRC_RES_OUT_REG(XCVR_MISC_BASE_PTR)

/*!
 * @}
 */ /* end of group XCVR_CTRL_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group XCVR_CTRL_Peripheral */


/* ----------------------------------------------------------------------------
   -- XCVR_PHY
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PHY_Peripheral XCVR_PHY
 * @{
 */

/** XCVR_PHY - Peripheral register structure */
typedef struct XCVR_PHY_MemMap {
  uint32_t PRE_REF0;                               /**< PREAMBLE REFERENCE WAVEFORM 0, offset: 0x0 */
  uint32_t PRE_REF1;                               /**< PREAMBLE REFERENCE WAVEFORM 1, offset: 0x4 */
  uint32_t PRE_REF2;                               /**< PREAMBLE REFERENCE WAVEFORM 2, offset: 0x8 */
  uint8_t RESERVED_0[20];
  uint32_t CFG1;                                   /**< PHY CONFIGURATION REGISTER 1, offset: 0x20 */
  uint32_t CFG2;                                   /**< PHY CONFIGURATION REGISTER 2, offset: 0x24 */
  uint32_t EL_CFG;                                 /**< PHY EARLY/LATE CONFIGURATION REGISTER, offset: 0x28 */
  uint32_t NTW_ADR_BSM;                            /**< PHY NETWORK ADDRESS FOR BSM, offset: 0x2C */
  uint32_t STATUS;                                 /**< PHY STATUS REGISTER, offset: 0x30 */
} volatile *XCVR_PHY_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- XCVR_PHY - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PHY_Register_Accessor_Macros XCVR_PHY - Register accessor macros
 * @{
 */


/* XCVR_PHY - Register accessors */
#define XCVR_PHY_PRE_REF0_REG(base)              ((base)->PRE_REF0)
#define XCVR_PHY_PRE_REF1_REG(base)              ((base)->PRE_REF1)
#define XCVR_PHY_PRE_REF2_REG(base)              ((base)->PRE_REF2)
#define XCVR_PHY_CFG1_REG(base)                  ((base)->CFG1)
#define XCVR_PHY_CFG2_REG(base)                  ((base)->CFG2)
#define XCVR_PHY_EL_CFG_REG(base)                ((base)->EL_CFG)
#define XCVR_PHY_NTW_ADR_BSM_REG(base)           ((base)->NTW_ADR_BSM)
#define XCVR_PHY_STATUS_REG(base)                ((base)->STATUS)

/*!
 * @}
 */ /* end of group XCVR_PHY_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- XCVR_PHY Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PHY_Register_Masks XCVR_PHY Register Masks
 * @{
 */

/*! @name PRE_REF0 - PREAMBLE REFERENCE WAVEFORM 0 */
#define XCVR_PHY_PRE_REF0_FSK_PREAMBLE_REF0_MASK (0xFFFFFFFFU)
#define XCVR_PHY_PRE_REF0_FSK_PREAMBLE_REF0_SHIFT (0U)
#define XCVR_PHY_PRE_REF0_FSK_PREAMBLE_REF0(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_PRE_REF0_FSK_PREAMBLE_REF0_SHIFT)) & XCVR_PHY_PRE_REF0_FSK_PREAMBLE_REF0_MASK)

/*! @name PRE_REF1 - PREAMBLE REFERENCE WAVEFORM 1 */
#define XCVR_PHY_PRE_REF1_FSK_PREAMBLE_REF1_MASK (0xFFFFFFFFU)
#define XCVR_PHY_PRE_REF1_FSK_PREAMBLE_REF1_SHIFT (0U)
#define XCVR_PHY_PRE_REF1_FSK_PREAMBLE_REF1(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_PRE_REF1_FSK_PREAMBLE_REF1_SHIFT)) & XCVR_PHY_PRE_REF1_FSK_PREAMBLE_REF1_MASK)

/*! @name PRE_REF2 - PREAMBLE REFERENCE WAVEFORM 2 */
#define XCVR_PHY_PRE_REF2_FSK_PREAMBLE_REF2_MASK (0xFFFFU)
#define XCVR_PHY_PRE_REF2_FSK_PREAMBLE_REF2_SHIFT (0U)
#define XCVR_PHY_PRE_REF2_FSK_PREAMBLE_REF2(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_PRE_REF2_FSK_PREAMBLE_REF2_SHIFT)) & XCVR_PHY_PRE_REF2_FSK_PREAMBLE_REF2_MASK)

/*! @name CFG1 - PHY CONFIGURATION REGISTER 1 */
#define XCVR_PHY_CFG1_AA_PLAYBACK_MASK           (0x2U)
#define XCVR_PHY_CFG1_AA_PLAYBACK_SHIFT          (1U)
#define XCVR_PHY_CFG1_AA_OUTPUT_SEL_MASK         (0x4U)
#define XCVR_PHY_CFG1_AA_OUTPUT_SEL_SHIFT        (2U)
#define XCVR_PHY_CFG1_FSK_BIT_INVERT_MASK        (0x8U)
#define XCVR_PHY_CFG1_FSK_BIT_INVERT_SHIFT       (3U)
#define XCVR_PHY_CFG1_RFU00_MASK                 (0x10U)
#define XCVR_PHY_CFG1_RFU00_SHIFT                (4U)
#define XCVR_PHY_CFG1_BSM_EN_BLE_MASK            (0x20U)
#define XCVR_PHY_CFG1_BSM_EN_BLE_SHIFT           (5U)
#define XCVR_PHY_CFG1_DEMOD_CLK_MODE_MASK        (0xC0U)
#define XCVR_PHY_CFG1_DEMOD_CLK_MODE_SHIFT       (6U)
#define XCVR_PHY_CFG1_DEMOD_CLK_MODE(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_CFG1_DEMOD_CLK_MODE_SHIFT)) & XCVR_PHY_CFG1_DEMOD_CLK_MODE_MASK)
#define XCVR_PHY_CFG1_CTS_THRESH_MASK            (0xFF00U)
#define XCVR_PHY_CFG1_CTS_THRESH_SHIFT           (8U)
#define XCVR_PHY_CFG1_CTS_THRESH(x)              (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_CFG1_CTS_THRESH_SHIFT)) & XCVR_PHY_CFG1_CTS_THRESH_MASK)
#define XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_MASK       (0x700000U)
#define XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_SHIFT      (20U)
#define XCVR_PHY_CFG1_FSK_FTS_TIMEOUT(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_SHIFT)) & XCVR_PHY_CFG1_FSK_FTS_TIMEOUT_MASK)
#define XCVR_PHY_CFG1_RFU01_MASK                 (0x1000000U)
#define XCVR_PHY_CFG1_RFU01_SHIFT                (24U)
#define XCVR_PHY_CFG1_RFU02_MASK                 (0x2000000U)
#define XCVR_PHY_CFG1_RFU02_SHIFT                (25U)
#define XCVR_PHY_CFG1_BLE_NTW_ADR_THR_MASK       (0x70000000U)
#define XCVR_PHY_CFG1_BLE_NTW_ADR_THR_SHIFT      (28U)
#define XCVR_PHY_CFG1_BLE_NTW_ADR_THR(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_CFG1_BLE_NTW_ADR_THR_SHIFT)) & XCVR_PHY_CFG1_BLE_NTW_ADR_THR_MASK)

/*! @name CFG2 - PHY CONFIGURATION REGISTER 2 */
#define XCVR_PHY_CFG2_PHY_FIFO_PRECHG_MASK       (0xFU)
#define XCVR_PHY_CFG2_PHY_FIFO_PRECHG_SHIFT      (0U)
#define XCVR_PHY_CFG2_PHY_FIFO_PRECHG(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_CFG2_PHY_FIFO_PRECHG_SHIFT)) & XCVR_PHY_CFG2_PHY_FIFO_PRECHG_MASK)
#define XCVR_PHY_CFG2_RFU03_MASK                 (0x10U)
#define XCVR_PHY_CFG2_RFU03_SHIFT                (4U)
#define XCVR_PHY_CFG2_RFU04_MASK                 (0x20U)
#define XCVR_PHY_CFG2_RFU04_SHIFT                (5U)
#define XCVR_PHY_CFG2_RFU05_MASK                 (0x40U)
#define XCVR_PHY_CFG2_RFU05_SHIFT                (6U)
#define XCVR_PHY_CFG2_RFU06_MASK                 (0x80U)
#define XCVR_PHY_CFG2_RFU06_SHIFT                (7U)
#define XCVR_PHY_CFG2_X2_DEMOD_GAIN_MASK         (0xF00U)
#define XCVR_PHY_CFG2_X2_DEMOD_GAIN_SHIFT        (8U)
#define XCVR_PHY_CFG2_X2_DEMOD_GAIN(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_CFG2_X2_DEMOD_GAIN_SHIFT)) & XCVR_PHY_CFG2_X2_DEMOD_GAIN_MASK)
#define XCVR_PHY_CFG2_RFU07_MASK                 (0x10000U)
#define XCVR_PHY_CFG2_RFU07_SHIFT                (16U)
#define XCVR_PHY_CFG2_RFU08_MASK                 (0x20000U)
#define XCVR_PHY_CFG2_RFU08_SHIFT                (17U)
#define XCVR_PHY_CFG2_RFU09_MASK                 (0x40000U)
#define XCVR_PHY_CFG2_RFU09_SHIFT                (18U)
#define XCVR_PHY_CFG2_RFU10_MASK                 (0x80000U)
#define XCVR_PHY_CFG2_RFU10_SHIFT                (19U)
#define XCVR_PHY_CFG2_RFU11_MASK                 (0x100000U)
#define XCVR_PHY_CFG2_RFU11_SHIFT                (20U)
#define XCVR_PHY_CFG2_RFU12_MASK                 (0x200000U)
#define XCVR_PHY_CFG2_RFU12_SHIFT                (21U)
#define XCVR_PHY_CFG2_RFU13_MASK                 (0x400000U)
#define XCVR_PHY_CFG2_RFU13_SHIFT                (22U)
#define XCVR_PHY_CFG2_RFU14_MASK                 (0x800000U)
#define XCVR_PHY_CFG2_RFU14_SHIFT                (23U)
#define XCVR_PHY_CFG2_RFU15_MASK                 (0x1000000U)
#define XCVR_PHY_CFG2_RFU15_SHIFT                (24U)
#define XCVR_PHY_CFG2_RFU16_MASK                 (0x2000000U)
#define XCVR_PHY_CFG2_RFU16_SHIFT                (25U)
#define XCVR_PHY_CFG2_CLK_ON_MASK                (0x80000000U)
#define XCVR_PHY_CFG2_CLK_ON_SHIFT               (31U)

/*! @name EL_CFG - PHY EARLY/LATE CONFIGURATION REGISTER */
#define XCVR_PHY_EL_CFG_EL_ENABLE_MASK           (0x1U)
#define XCVR_PHY_EL_CFG_EL_ENABLE_SHIFT          (0U)
#define XCVR_PHY_EL_CFG_EL_ZB_ENABLE_MASK        (0x2U)
#define XCVR_PHY_EL_CFG_EL_ZB_ENABLE_SHIFT       (1U)
#define XCVR_PHY_EL_CFG_EL_ZB_WIN_SIZE_MASK      (0x4U)
#define XCVR_PHY_EL_CFG_EL_ZB_WIN_SIZE_SHIFT     (2U)
#define XCVR_PHY_EL_CFG_EL_WIN_SIZE_MASK         (0xF00U)
#define XCVR_PHY_EL_CFG_EL_WIN_SIZE_SHIFT        (8U)
#define XCVR_PHY_EL_CFG_EL_WIN_SIZE(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_EL_CFG_EL_WIN_SIZE_SHIFT)) & XCVR_PHY_EL_CFG_EL_WIN_SIZE_MASK)
#define XCVR_PHY_EL_CFG_EL_INTERVAL_MASK         (0x3F0000U)
#define XCVR_PHY_EL_CFG_EL_INTERVAL_SHIFT        (16U)
#define XCVR_PHY_EL_CFG_EL_INTERVAL(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_EL_CFG_EL_INTERVAL_SHIFT)) & XCVR_PHY_EL_CFG_EL_INTERVAL_MASK)

/*! @name NTW_ADR_BSM - PHY NETWORK ADDRESS FOR BSM */
#define XCVR_PHY_NTW_ADR_BSM_NTW_ADR_BSM_MASK    (0xFFFFFFFFU)
#define XCVR_PHY_NTW_ADR_BSM_NTW_ADR_BSM_SHIFT   (0U)
#define XCVR_PHY_NTW_ADR_BSM_NTW_ADR_BSM(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_NTW_ADR_BSM_NTW_ADR_BSM_SHIFT)) & XCVR_PHY_NTW_ADR_BSM_NTW_ADR_BSM_MASK)

/*! @name STATUS - PHY STATUS REGISTER */
#define XCVR_PHY_STATUS_PREAMBLE_FOUND_MASK      (0x1U)
#define XCVR_PHY_STATUS_PREAMBLE_FOUND_SHIFT     (0U)
#define XCVR_PHY_STATUS_AA_SFD_MATCHED_MASK      (0x2U)
#define XCVR_PHY_STATUS_AA_SFD_MATCHED_SHIFT     (1U)
#define XCVR_PHY_STATUS_AA_MATCHED_MASK          (0xF0U)
#define XCVR_PHY_STATUS_AA_MATCHED_SHIFT         (4U)
#define XCVR_PHY_STATUS_AA_MATCHED(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_STATUS_AA_MATCHED_SHIFT)) & XCVR_PHY_STATUS_AA_MATCHED_MASK)
#define XCVR_PHY_STATUS_HAMMING_DISTANCE_MASK    (0x700U)
#define XCVR_PHY_STATUS_HAMMING_DISTANCE_SHIFT   (8U)
#define XCVR_PHY_STATUS_HAMMING_DISTANCE(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_STATUS_HAMMING_DISTANCE_SHIFT)) & XCVR_PHY_STATUS_HAMMING_DISTANCE_MASK)
#define XCVR_PHY_STATUS_DATA_FIFO_DEPTH_MASK     (0xF000U)
#define XCVR_PHY_STATUS_DATA_FIFO_DEPTH_SHIFT    (12U)
#define XCVR_PHY_STATUS_DATA_FIFO_DEPTH(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_STATUS_DATA_FIFO_DEPTH_SHIFT)) & XCVR_PHY_STATUS_DATA_FIFO_DEPTH_MASK)
#define XCVR_PHY_STATUS_CFO_ESTIMATE_MASK        (0xFF0000U)
#define XCVR_PHY_STATUS_CFO_ESTIMATE_SHIFT       (16U)
#define XCVR_PHY_STATUS_CFO_ESTIMATE(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_PHY_STATUS_CFO_ESTIMATE_SHIFT)) & XCVR_PHY_STATUS_CFO_ESTIMATE_MASK)


/*!
 * @}
 */ /* end of group XCVR_PHY_Register_Masks */


/* XCVR_PHY - Peripheral instance base addresses */
/** Peripheral XCVR_PHY_REGS base pointer */
#define XCVR_PHY_BASE_PTR                        ((XCVR_PHY_MemMapPtr)0x4005C400u)
/** Array initializer of XCVR_PHY peripheral base pointers */
#define XCVR_PHY_BASE_PTRS                       { XCVR_PHY_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- XCVR_PHY - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PHY_Register_Accessor_Macros XCVR_PHY - Register accessor macros
 * @{
 */


/* XCVR_PHY - Register instance definitions */
/* XCVR_PHY_REGS */
#define XCVR_PHY_PRE_REF0                        XCVR_PHY_PRE_REF0_REG(XCVR_PHY_BASE_PTR)
#define XCVR_PHY_PRE_REF1                        XCVR_PHY_PRE_REF1_REG(XCVR_PHY_BASE_PTR)
#define XCVR_PHY_PRE_REF2                        XCVR_PHY_PRE_REF2_REG(XCVR_PHY_BASE_PTR)
#define XCVR_PHY_CFG1                            XCVR_PHY_CFG1_REG(XCVR_PHY_BASE_PTR)
#define XCVR_PHY_CFG2                            XCVR_PHY_CFG2_REG(XCVR_PHY_BASE_PTR)
#define XCVR_PHY_EL_CFG                          XCVR_PHY_EL_CFG_REG(XCVR_PHY_BASE_PTR)
#define XCVR_PHY_NTW_ADR_BSM                     XCVR_PHY_NTW_ADR_BSM_REG(XCVR_PHY_BASE_PTR)
#define XCVR_PHY_STATUS                          XCVR_PHY_STATUS_REG(XCVR_PHY_BASE_PTR)

/*!
 * @}
 */ /* end of group XCVR_PHY_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group XCVR_PHY_Peripheral */


/* ----------------------------------------------------------------------------
   -- XCVR_PKT_RAM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PKT_RAM_Peripheral XCVR_PKT_RAM
 * @{
 */

/** XCVR_PKT_RAM - Peripheral register structure */
typedef struct XCVR_PKT_RAM_MemMap {
  uint16_t PACKET_RAM_0[544];                      /**< Shared Packet RAM for multiple Link Layer usage., array offset: 0x0, array step: 0x2 */
  uint16_t PACKET_RAM_1[544];                      /**< Shared Packet RAM for multiple Link Layer usage., array offset: 0x440, array step: 0x2 */
} volatile *XCVR_PKT_RAM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- XCVR_PKT_RAM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PKT_RAM_Register_Accessor_Macros XCVR_PKT_RAM - Register accessor macros
 * @{
 */


/* XCVR_PKT_RAM - Register accessors */
#define XCVR_PKT_RAM_PACKET_RAM_0_REG(base,index) ((base)->PACKET_RAM_0[index])
#define XCVR_PKT_RAM_PACKET_RAM_1_REG(base,index) ((base)->PACKET_RAM_1[index])

/*!
 * @}
 */ /* end of group XCVR_PKT_RAM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- XCVR_PKT_RAM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PKT_RAM_Register_Masks XCVR_PKT_RAM Register Masks
 * @{
 */

/*! @name PACKET_RAM_0 - Shared Packet RAM for multiple Link Layer usage. */
#define XCVR_PKT_RAM_PACKET_RAM_0_LSBYTE_MASK    (0xFFU)
#define XCVR_PKT_RAM_PACKET_RAM_0_LSBYTE_SHIFT   (0U)
#define XCVR_PKT_RAM_PACKET_RAM_0_LSBYTE(x)      (((uint16_t)(((uint16_t)(x)) << XCVR_PKT_RAM_PACKET_RAM_0_LSBYTE_SHIFT)) & XCVR_PKT_RAM_PACKET_RAM_0_LSBYTE_MASK)
#define XCVR_PKT_RAM_PACKET_RAM_0_MSBYTE_MASK    (0xFF00U)
#define XCVR_PKT_RAM_PACKET_RAM_0_MSBYTE_SHIFT   (8U)
#define XCVR_PKT_RAM_PACKET_RAM_0_MSBYTE(x)      (((uint16_t)(((uint16_t)(x)) << XCVR_PKT_RAM_PACKET_RAM_0_MSBYTE_SHIFT)) & XCVR_PKT_RAM_PACKET_RAM_0_MSBYTE_MASK)

/* The count of XCVR_PKT_RAM_PACKET_RAM_0 */
#define XCVR_PKT_RAM_PACKET_RAM_0_COUNT          (544U)

/*! @name PACKET_RAM_1 - Shared Packet RAM for multiple Link Layer usage. */
#define XCVR_PKT_RAM_PACKET_RAM_1_LSBYTE_MASK    (0xFFU)
#define XCVR_PKT_RAM_PACKET_RAM_1_LSBYTE_SHIFT   (0U)
#define XCVR_PKT_RAM_PACKET_RAM_1_LSBYTE(x)      (((uint16_t)(((uint16_t)(x)) << XCVR_PKT_RAM_PACKET_RAM_1_LSBYTE_SHIFT)) & XCVR_PKT_RAM_PACKET_RAM_1_LSBYTE_MASK)
#define XCVR_PKT_RAM_PACKET_RAM_1_MSBYTE_MASK    (0xFF00U)
#define XCVR_PKT_RAM_PACKET_RAM_1_MSBYTE_SHIFT   (8U)
#define XCVR_PKT_RAM_PACKET_RAM_1_MSBYTE(x)      (((uint16_t)(((uint16_t)(x)) << XCVR_PKT_RAM_PACKET_RAM_1_MSBYTE_SHIFT)) & XCVR_PKT_RAM_PACKET_RAM_1_MSBYTE_MASK)

/* The count of XCVR_PKT_RAM_PACKET_RAM_1 */
#define XCVR_PKT_RAM_PACKET_RAM_1_COUNT          (544U)


/*!
 * @}
 */ /* end of group XCVR_PKT_RAM_Register_Masks */


/* XCVR_PKT_RAM - Peripheral instance base addresses */
/** Peripheral XCVR_PKT_RAM base pointer */
#define XCVR_PKT_RAM_BASE_PTR                    ((XCVR_PKT_RAM_MemMapPtr)0x4005C700u)
/** Array initializer of XCVR_PKT_RAM peripheral base pointers */
#define XCVR_PKT_RAM_BASE_PTRS                   { XCVR_PKT_RAM_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- XCVR_PKT_RAM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PKT_RAM_Register_Accessor_Macros XCVR_PKT_RAM - Register accessor macros
 * @{
 */


/* XCVR_PKT_RAM - Register instance definitions */
/* XCVR_PKT_RAM */
#define XCVR_PKT_RAM_PACKET_RAM_0_0              XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,0)
#define XCVR_PKT_RAM_PACKET_RAM_0_1              XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,1)
#define XCVR_PKT_RAM_PACKET_RAM_0_2              XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,2)
#define XCVR_PKT_RAM_PACKET_RAM_0_3              XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,3)
#define XCVR_PKT_RAM_PACKET_RAM_0_4              XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,4)
#define XCVR_PKT_RAM_PACKET_RAM_0_5              XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,5)
#define XCVR_PKT_RAM_PACKET_RAM_0_6              XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,6)
#define XCVR_PKT_RAM_PACKET_RAM_0_7              XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,7)
#define XCVR_PKT_RAM_PACKET_RAM_0_8              XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,8)
#define XCVR_PKT_RAM_PACKET_RAM_0_9              XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,9)
#define XCVR_PKT_RAM_PACKET_RAM_0_10             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,10)
#define XCVR_PKT_RAM_PACKET_RAM_0_11             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,11)
#define XCVR_PKT_RAM_PACKET_RAM_0_12             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,12)
#define XCVR_PKT_RAM_PACKET_RAM_0_13             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,13)
#define XCVR_PKT_RAM_PACKET_RAM_0_14             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,14)
#define XCVR_PKT_RAM_PACKET_RAM_0_15             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,15)
#define XCVR_PKT_RAM_PACKET_RAM_0_16             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,16)
#define XCVR_PKT_RAM_PACKET_RAM_0_17             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,17)
#define XCVR_PKT_RAM_PACKET_RAM_0_18             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,18)
#define XCVR_PKT_RAM_PACKET_RAM_0_19             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,19)
#define XCVR_PKT_RAM_PACKET_RAM_0_20             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,20)
#define XCVR_PKT_RAM_PACKET_RAM_0_21             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,21)
#define XCVR_PKT_RAM_PACKET_RAM_0_22             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,22)
#define XCVR_PKT_RAM_PACKET_RAM_0_23             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,23)
#define XCVR_PKT_RAM_PACKET_RAM_0_24             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,24)
#define XCVR_PKT_RAM_PACKET_RAM_0_25             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,25)
#define XCVR_PKT_RAM_PACKET_RAM_0_26             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,26)
#define XCVR_PKT_RAM_PACKET_RAM_0_27             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,27)
#define XCVR_PKT_RAM_PACKET_RAM_0_28             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,28)
#define XCVR_PKT_RAM_PACKET_RAM_0_29             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,29)
#define XCVR_PKT_RAM_PACKET_RAM_0_30             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,30)
#define XCVR_PKT_RAM_PACKET_RAM_0_31             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,31)
#define XCVR_PKT_RAM_PACKET_RAM_0_32             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,32)
#define XCVR_PKT_RAM_PACKET_RAM_0_33             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,33)
#define XCVR_PKT_RAM_PACKET_RAM_0_34             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,34)
#define XCVR_PKT_RAM_PACKET_RAM_0_35             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,35)
#define XCVR_PKT_RAM_PACKET_RAM_0_36             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,36)
#define XCVR_PKT_RAM_PACKET_RAM_0_37             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,37)
#define XCVR_PKT_RAM_PACKET_RAM_0_38             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,38)
#define XCVR_PKT_RAM_PACKET_RAM_0_39             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,39)
#define XCVR_PKT_RAM_PACKET_RAM_0_40             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,40)
#define XCVR_PKT_RAM_PACKET_RAM_0_41             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,41)
#define XCVR_PKT_RAM_PACKET_RAM_0_42             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,42)
#define XCVR_PKT_RAM_PACKET_RAM_0_43             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,43)
#define XCVR_PKT_RAM_PACKET_RAM_0_44             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,44)
#define XCVR_PKT_RAM_PACKET_RAM_0_45             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,45)
#define XCVR_PKT_RAM_PACKET_RAM_0_46             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,46)
#define XCVR_PKT_RAM_PACKET_RAM_0_47             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,47)
#define XCVR_PKT_RAM_PACKET_RAM_0_48             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,48)
#define XCVR_PKT_RAM_PACKET_RAM_0_49             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,49)
#define XCVR_PKT_RAM_PACKET_RAM_0_50             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,50)
#define XCVR_PKT_RAM_PACKET_RAM_0_51             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,51)
#define XCVR_PKT_RAM_PACKET_RAM_0_52             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,52)
#define XCVR_PKT_RAM_PACKET_RAM_0_53             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,53)
#define XCVR_PKT_RAM_PACKET_RAM_0_54             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,54)
#define XCVR_PKT_RAM_PACKET_RAM_0_55             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,55)
#define XCVR_PKT_RAM_PACKET_RAM_0_56             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,56)
#define XCVR_PKT_RAM_PACKET_RAM_0_57             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,57)
#define XCVR_PKT_RAM_PACKET_RAM_0_58             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,58)
#define XCVR_PKT_RAM_PACKET_RAM_0_59             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,59)
#define XCVR_PKT_RAM_PACKET_RAM_0_60             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,60)
#define XCVR_PKT_RAM_PACKET_RAM_0_61             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,61)
#define XCVR_PKT_RAM_PACKET_RAM_0_62             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,62)
#define XCVR_PKT_RAM_PACKET_RAM_0_63             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,63)
#define XCVR_PKT_RAM_PACKET_RAM_0_64             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,64)
#define XCVR_PKT_RAM_PACKET_RAM_0_65             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,65)
#define XCVR_PKT_RAM_PACKET_RAM_0_66             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,66)
#define XCVR_PKT_RAM_PACKET_RAM_0_67             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,67)
#define XCVR_PKT_RAM_PACKET_RAM_0_68             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,68)
#define XCVR_PKT_RAM_PACKET_RAM_0_69             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,69)
#define XCVR_PKT_RAM_PACKET_RAM_0_70             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,70)
#define XCVR_PKT_RAM_PACKET_RAM_0_71             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,71)
#define XCVR_PKT_RAM_PACKET_RAM_0_72             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,72)
#define XCVR_PKT_RAM_PACKET_RAM_0_73             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,73)
#define XCVR_PKT_RAM_PACKET_RAM_0_74             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,74)
#define XCVR_PKT_RAM_PACKET_RAM_0_75             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,75)
#define XCVR_PKT_RAM_PACKET_RAM_0_76             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,76)
#define XCVR_PKT_RAM_PACKET_RAM_0_77             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,77)
#define XCVR_PKT_RAM_PACKET_RAM_0_78             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,78)
#define XCVR_PKT_RAM_PACKET_RAM_0_79             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,79)
#define XCVR_PKT_RAM_PACKET_RAM_0_80             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,80)
#define XCVR_PKT_RAM_PACKET_RAM_0_81             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,81)
#define XCVR_PKT_RAM_PACKET_RAM_0_82             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,82)
#define XCVR_PKT_RAM_PACKET_RAM_0_83             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,83)
#define XCVR_PKT_RAM_PACKET_RAM_0_84             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,84)
#define XCVR_PKT_RAM_PACKET_RAM_0_85             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,85)
#define XCVR_PKT_RAM_PACKET_RAM_0_86             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,86)
#define XCVR_PKT_RAM_PACKET_RAM_0_87             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,87)
#define XCVR_PKT_RAM_PACKET_RAM_0_88             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,88)
#define XCVR_PKT_RAM_PACKET_RAM_0_89             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,89)
#define XCVR_PKT_RAM_PACKET_RAM_0_90             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,90)
#define XCVR_PKT_RAM_PACKET_RAM_0_91             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,91)
#define XCVR_PKT_RAM_PACKET_RAM_0_92             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,92)
#define XCVR_PKT_RAM_PACKET_RAM_0_93             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,93)
#define XCVR_PKT_RAM_PACKET_RAM_0_94             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,94)
#define XCVR_PKT_RAM_PACKET_RAM_0_95             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,95)
#define XCVR_PKT_RAM_PACKET_RAM_0_96             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,96)
#define XCVR_PKT_RAM_PACKET_RAM_0_97             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,97)
#define XCVR_PKT_RAM_PACKET_RAM_0_98             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,98)
#define XCVR_PKT_RAM_PACKET_RAM_0_99             XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,99)
#define XCVR_PKT_RAM_PACKET_RAM_0_100            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,100)
#define XCVR_PKT_RAM_PACKET_RAM_0_101            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,101)
#define XCVR_PKT_RAM_PACKET_RAM_0_102            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,102)
#define XCVR_PKT_RAM_PACKET_RAM_0_103            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,103)
#define XCVR_PKT_RAM_PACKET_RAM_0_104            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,104)
#define XCVR_PKT_RAM_PACKET_RAM_0_105            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,105)
#define XCVR_PKT_RAM_PACKET_RAM_0_106            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,106)
#define XCVR_PKT_RAM_PACKET_RAM_0_107            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,107)
#define XCVR_PKT_RAM_PACKET_RAM_0_108            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,108)
#define XCVR_PKT_RAM_PACKET_RAM_0_109            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,109)
#define XCVR_PKT_RAM_PACKET_RAM_0_110            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,110)
#define XCVR_PKT_RAM_PACKET_RAM_0_111            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,111)
#define XCVR_PKT_RAM_PACKET_RAM_0_112            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,112)
#define XCVR_PKT_RAM_PACKET_RAM_0_113            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,113)
#define XCVR_PKT_RAM_PACKET_RAM_0_114            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,114)
#define XCVR_PKT_RAM_PACKET_RAM_0_115            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,115)
#define XCVR_PKT_RAM_PACKET_RAM_0_116            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,116)
#define XCVR_PKT_RAM_PACKET_RAM_0_117            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,117)
#define XCVR_PKT_RAM_PACKET_RAM_0_118            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,118)
#define XCVR_PKT_RAM_PACKET_RAM_0_119            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,119)
#define XCVR_PKT_RAM_PACKET_RAM_0_120            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,120)
#define XCVR_PKT_RAM_PACKET_RAM_0_121            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,121)
#define XCVR_PKT_RAM_PACKET_RAM_0_122            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,122)
#define XCVR_PKT_RAM_PACKET_RAM_0_123            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,123)
#define XCVR_PKT_RAM_PACKET_RAM_0_124            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,124)
#define XCVR_PKT_RAM_PACKET_RAM_0_125            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,125)
#define XCVR_PKT_RAM_PACKET_RAM_0_126            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,126)
#define XCVR_PKT_RAM_PACKET_RAM_0_127            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,127)
#define XCVR_PKT_RAM_PACKET_RAM_0_128            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,128)
#define XCVR_PKT_RAM_PACKET_RAM_0_129            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,129)
#define XCVR_PKT_RAM_PACKET_RAM_0_130            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,130)
#define XCVR_PKT_RAM_PACKET_RAM_0_131            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,131)
#define XCVR_PKT_RAM_PACKET_RAM_0_132            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,132)
#define XCVR_PKT_RAM_PACKET_RAM_0_133            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,133)
#define XCVR_PKT_RAM_PACKET_RAM_0_134            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,134)
#define XCVR_PKT_RAM_PACKET_RAM_0_135            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,135)
#define XCVR_PKT_RAM_PACKET_RAM_0_136            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,136)
#define XCVR_PKT_RAM_PACKET_RAM_0_137            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,137)
#define XCVR_PKT_RAM_PACKET_RAM_0_138            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,138)
#define XCVR_PKT_RAM_PACKET_RAM_0_139            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,139)
#define XCVR_PKT_RAM_PACKET_RAM_0_140            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,140)
#define XCVR_PKT_RAM_PACKET_RAM_0_141            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,141)
#define XCVR_PKT_RAM_PACKET_RAM_0_142            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,142)
#define XCVR_PKT_RAM_PACKET_RAM_0_143            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,143)
#define XCVR_PKT_RAM_PACKET_RAM_0_144            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,144)
#define XCVR_PKT_RAM_PACKET_RAM_0_145            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,145)
#define XCVR_PKT_RAM_PACKET_RAM_0_146            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,146)
#define XCVR_PKT_RAM_PACKET_RAM_0_147            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,147)
#define XCVR_PKT_RAM_PACKET_RAM_0_148            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,148)
#define XCVR_PKT_RAM_PACKET_RAM_0_149            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,149)
#define XCVR_PKT_RAM_PACKET_RAM_0_150            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,150)
#define XCVR_PKT_RAM_PACKET_RAM_0_151            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,151)
#define XCVR_PKT_RAM_PACKET_RAM_0_152            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,152)
#define XCVR_PKT_RAM_PACKET_RAM_0_153            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,153)
#define XCVR_PKT_RAM_PACKET_RAM_0_154            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,154)
#define XCVR_PKT_RAM_PACKET_RAM_0_155            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,155)
#define XCVR_PKT_RAM_PACKET_RAM_0_156            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,156)
#define XCVR_PKT_RAM_PACKET_RAM_0_157            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,157)
#define XCVR_PKT_RAM_PACKET_RAM_0_158            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,158)
#define XCVR_PKT_RAM_PACKET_RAM_0_159            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,159)
#define XCVR_PKT_RAM_PACKET_RAM_0_160            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,160)
#define XCVR_PKT_RAM_PACKET_RAM_0_161            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,161)
#define XCVR_PKT_RAM_PACKET_RAM_0_162            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,162)
#define XCVR_PKT_RAM_PACKET_RAM_0_163            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,163)
#define XCVR_PKT_RAM_PACKET_RAM_0_164            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,164)
#define XCVR_PKT_RAM_PACKET_RAM_0_165            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,165)
#define XCVR_PKT_RAM_PACKET_RAM_0_166            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,166)
#define XCVR_PKT_RAM_PACKET_RAM_0_167            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,167)
#define XCVR_PKT_RAM_PACKET_RAM_0_168            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,168)
#define XCVR_PKT_RAM_PACKET_RAM_0_169            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,169)
#define XCVR_PKT_RAM_PACKET_RAM_0_170            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,170)
#define XCVR_PKT_RAM_PACKET_RAM_0_171            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,171)
#define XCVR_PKT_RAM_PACKET_RAM_0_172            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,172)
#define XCVR_PKT_RAM_PACKET_RAM_0_173            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,173)
#define XCVR_PKT_RAM_PACKET_RAM_0_174            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,174)
#define XCVR_PKT_RAM_PACKET_RAM_0_175            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,175)
#define XCVR_PKT_RAM_PACKET_RAM_0_176            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,176)
#define XCVR_PKT_RAM_PACKET_RAM_0_177            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,177)
#define XCVR_PKT_RAM_PACKET_RAM_0_178            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,178)
#define XCVR_PKT_RAM_PACKET_RAM_0_179            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,179)
#define XCVR_PKT_RAM_PACKET_RAM_0_180            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,180)
#define XCVR_PKT_RAM_PACKET_RAM_0_181            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,181)
#define XCVR_PKT_RAM_PACKET_RAM_0_182            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,182)
#define XCVR_PKT_RAM_PACKET_RAM_0_183            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,183)
#define XCVR_PKT_RAM_PACKET_RAM_0_184            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,184)
#define XCVR_PKT_RAM_PACKET_RAM_0_185            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,185)
#define XCVR_PKT_RAM_PACKET_RAM_0_186            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,186)
#define XCVR_PKT_RAM_PACKET_RAM_0_187            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,187)
#define XCVR_PKT_RAM_PACKET_RAM_0_188            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,188)
#define XCVR_PKT_RAM_PACKET_RAM_0_189            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,189)
#define XCVR_PKT_RAM_PACKET_RAM_0_190            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,190)
#define XCVR_PKT_RAM_PACKET_RAM_0_191            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,191)
#define XCVR_PKT_RAM_PACKET_RAM_0_192            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,192)
#define XCVR_PKT_RAM_PACKET_RAM_0_193            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,193)
#define XCVR_PKT_RAM_PACKET_RAM_0_194            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,194)
#define XCVR_PKT_RAM_PACKET_RAM_0_195            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,195)
#define XCVR_PKT_RAM_PACKET_RAM_0_196            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,196)
#define XCVR_PKT_RAM_PACKET_RAM_0_197            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,197)
#define XCVR_PKT_RAM_PACKET_RAM_0_198            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,198)
#define XCVR_PKT_RAM_PACKET_RAM_0_199            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,199)
#define XCVR_PKT_RAM_PACKET_RAM_0_200            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,200)
#define XCVR_PKT_RAM_PACKET_RAM_0_201            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,201)
#define XCVR_PKT_RAM_PACKET_RAM_0_202            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,202)
#define XCVR_PKT_RAM_PACKET_RAM_0_203            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,203)
#define XCVR_PKT_RAM_PACKET_RAM_0_204            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,204)
#define XCVR_PKT_RAM_PACKET_RAM_0_205            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,205)
#define XCVR_PKT_RAM_PACKET_RAM_0_206            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,206)
#define XCVR_PKT_RAM_PACKET_RAM_0_207            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,207)
#define XCVR_PKT_RAM_PACKET_RAM_0_208            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,208)
#define XCVR_PKT_RAM_PACKET_RAM_0_209            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,209)
#define XCVR_PKT_RAM_PACKET_RAM_0_210            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,210)
#define XCVR_PKT_RAM_PACKET_RAM_0_211            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,211)
#define XCVR_PKT_RAM_PACKET_RAM_0_212            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,212)
#define XCVR_PKT_RAM_PACKET_RAM_0_213            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,213)
#define XCVR_PKT_RAM_PACKET_RAM_0_214            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,214)
#define XCVR_PKT_RAM_PACKET_RAM_0_215            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,215)
#define XCVR_PKT_RAM_PACKET_RAM_0_216            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,216)
#define XCVR_PKT_RAM_PACKET_RAM_0_217            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,217)
#define XCVR_PKT_RAM_PACKET_RAM_0_218            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,218)
#define XCVR_PKT_RAM_PACKET_RAM_0_219            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,219)
#define XCVR_PKT_RAM_PACKET_RAM_0_220            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,220)
#define XCVR_PKT_RAM_PACKET_RAM_0_221            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,221)
#define XCVR_PKT_RAM_PACKET_RAM_0_222            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,222)
#define XCVR_PKT_RAM_PACKET_RAM_0_223            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,223)
#define XCVR_PKT_RAM_PACKET_RAM_0_224            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,224)
#define XCVR_PKT_RAM_PACKET_RAM_0_225            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,225)
#define XCVR_PKT_RAM_PACKET_RAM_0_226            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,226)
#define XCVR_PKT_RAM_PACKET_RAM_0_227            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,227)
#define XCVR_PKT_RAM_PACKET_RAM_0_228            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,228)
#define XCVR_PKT_RAM_PACKET_RAM_0_229            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,229)
#define XCVR_PKT_RAM_PACKET_RAM_0_230            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,230)
#define XCVR_PKT_RAM_PACKET_RAM_0_231            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,231)
#define XCVR_PKT_RAM_PACKET_RAM_0_232            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,232)
#define XCVR_PKT_RAM_PACKET_RAM_0_233            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,233)
#define XCVR_PKT_RAM_PACKET_RAM_0_234            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,234)
#define XCVR_PKT_RAM_PACKET_RAM_0_235            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,235)
#define XCVR_PKT_RAM_PACKET_RAM_0_236            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,236)
#define XCVR_PKT_RAM_PACKET_RAM_0_237            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,237)
#define XCVR_PKT_RAM_PACKET_RAM_0_238            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,238)
#define XCVR_PKT_RAM_PACKET_RAM_0_239            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,239)
#define XCVR_PKT_RAM_PACKET_RAM_0_240            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,240)
#define XCVR_PKT_RAM_PACKET_RAM_0_241            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,241)
#define XCVR_PKT_RAM_PACKET_RAM_0_242            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,242)
#define XCVR_PKT_RAM_PACKET_RAM_0_243            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,243)
#define XCVR_PKT_RAM_PACKET_RAM_0_244            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,244)
#define XCVR_PKT_RAM_PACKET_RAM_0_245            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,245)
#define XCVR_PKT_RAM_PACKET_RAM_0_246            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,246)
#define XCVR_PKT_RAM_PACKET_RAM_0_247            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,247)
#define XCVR_PKT_RAM_PACKET_RAM_0_248            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,248)
#define XCVR_PKT_RAM_PACKET_RAM_0_249            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,249)
#define XCVR_PKT_RAM_PACKET_RAM_0_250            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,250)
#define XCVR_PKT_RAM_PACKET_RAM_0_251            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,251)
#define XCVR_PKT_RAM_PACKET_RAM_0_252            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,252)
#define XCVR_PKT_RAM_PACKET_RAM_0_253            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,253)
#define XCVR_PKT_RAM_PACKET_RAM_0_254            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,254)
#define XCVR_PKT_RAM_PACKET_RAM_0_255            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,255)
#define XCVR_PKT_RAM_PACKET_RAM_0_256            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,256)
#define XCVR_PKT_RAM_PACKET_RAM_0_257            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,257)
#define XCVR_PKT_RAM_PACKET_RAM_0_258            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,258)
#define XCVR_PKT_RAM_PACKET_RAM_0_259            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,259)
#define XCVR_PKT_RAM_PACKET_RAM_0_260            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,260)
#define XCVR_PKT_RAM_PACKET_RAM_0_261            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,261)
#define XCVR_PKT_RAM_PACKET_RAM_0_262            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,262)
#define XCVR_PKT_RAM_PACKET_RAM_0_263            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,263)
#define XCVR_PKT_RAM_PACKET_RAM_0_264            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,264)
#define XCVR_PKT_RAM_PACKET_RAM_0_265            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,265)
#define XCVR_PKT_RAM_PACKET_RAM_0_266            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,266)
#define XCVR_PKT_RAM_PACKET_RAM_0_267            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,267)
#define XCVR_PKT_RAM_PACKET_RAM_0_268            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,268)
#define XCVR_PKT_RAM_PACKET_RAM_0_269            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,269)
#define XCVR_PKT_RAM_PACKET_RAM_0_270            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,270)
#define XCVR_PKT_RAM_PACKET_RAM_0_271            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,271)
#define XCVR_PKT_RAM_PACKET_RAM_0_272            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,272)
#define XCVR_PKT_RAM_PACKET_RAM_0_273            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,273)
#define XCVR_PKT_RAM_PACKET_RAM_0_274            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,274)
#define XCVR_PKT_RAM_PACKET_RAM_0_275            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,275)
#define XCVR_PKT_RAM_PACKET_RAM_0_276            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,276)
#define XCVR_PKT_RAM_PACKET_RAM_0_277            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,277)
#define XCVR_PKT_RAM_PACKET_RAM_0_278            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,278)
#define XCVR_PKT_RAM_PACKET_RAM_0_279            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,279)
#define XCVR_PKT_RAM_PACKET_RAM_0_280            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,280)
#define XCVR_PKT_RAM_PACKET_RAM_0_281            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,281)
#define XCVR_PKT_RAM_PACKET_RAM_0_282            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,282)
#define XCVR_PKT_RAM_PACKET_RAM_0_283            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,283)
#define XCVR_PKT_RAM_PACKET_RAM_0_284            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,284)
#define XCVR_PKT_RAM_PACKET_RAM_0_285            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,285)
#define XCVR_PKT_RAM_PACKET_RAM_0_286            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,286)
#define XCVR_PKT_RAM_PACKET_RAM_0_287            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,287)
#define XCVR_PKT_RAM_PACKET_RAM_0_288            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,288)
#define XCVR_PKT_RAM_PACKET_RAM_0_289            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,289)
#define XCVR_PKT_RAM_PACKET_RAM_0_290            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,290)
#define XCVR_PKT_RAM_PACKET_RAM_0_291            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,291)
#define XCVR_PKT_RAM_PACKET_RAM_0_292            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,292)
#define XCVR_PKT_RAM_PACKET_RAM_0_293            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,293)
#define XCVR_PKT_RAM_PACKET_RAM_0_294            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,294)
#define XCVR_PKT_RAM_PACKET_RAM_0_295            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,295)
#define XCVR_PKT_RAM_PACKET_RAM_0_296            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,296)
#define XCVR_PKT_RAM_PACKET_RAM_0_297            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,297)
#define XCVR_PKT_RAM_PACKET_RAM_0_298            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,298)
#define XCVR_PKT_RAM_PACKET_RAM_0_299            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,299)
#define XCVR_PKT_RAM_PACKET_RAM_0_300            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,300)
#define XCVR_PKT_RAM_PACKET_RAM_0_301            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,301)
#define XCVR_PKT_RAM_PACKET_RAM_0_302            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,302)
#define XCVR_PKT_RAM_PACKET_RAM_0_303            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,303)
#define XCVR_PKT_RAM_PACKET_RAM_0_304            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,304)
#define XCVR_PKT_RAM_PACKET_RAM_0_305            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,305)
#define XCVR_PKT_RAM_PACKET_RAM_0_306            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,306)
#define XCVR_PKT_RAM_PACKET_RAM_0_307            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,307)
#define XCVR_PKT_RAM_PACKET_RAM_0_308            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,308)
#define XCVR_PKT_RAM_PACKET_RAM_0_309            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,309)
#define XCVR_PKT_RAM_PACKET_RAM_0_310            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,310)
#define XCVR_PKT_RAM_PACKET_RAM_0_311            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,311)
#define XCVR_PKT_RAM_PACKET_RAM_0_312            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,312)
#define XCVR_PKT_RAM_PACKET_RAM_0_313            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,313)
#define XCVR_PKT_RAM_PACKET_RAM_0_314            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,314)
#define XCVR_PKT_RAM_PACKET_RAM_0_315            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,315)
#define XCVR_PKT_RAM_PACKET_RAM_0_316            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,316)
#define XCVR_PKT_RAM_PACKET_RAM_0_317            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,317)
#define XCVR_PKT_RAM_PACKET_RAM_0_318            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,318)
#define XCVR_PKT_RAM_PACKET_RAM_0_319            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,319)
#define XCVR_PKT_RAM_PACKET_RAM_0_320            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,320)
#define XCVR_PKT_RAM_PACKET_RAM_0_321            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,321)
#define XCVR_PKT_RAM_PACKET_RAM_0_322            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,322)
#define XCVR_PKT_RAM_PACKET_RAM_0_323            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,323)
#define XCVR_PKT_RAM_PACKET_RAM_0_324            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,324)
#define XCVR_PKT_RAM_PACKET_RAM_0_325            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,325)
#define XCVR_PKT_RAM_PACKET_RAM_0_326            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,326)
#define XCVR_PKT_RAM_PACKET_RAM_0_327            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,327)
#define XCVR_PKT_RAM_PACKET_RAM_0_328            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,328)
#define XCVR_PKT_RAM_PACKET_RAM_0_329            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,329)
#define XCVR_PKT_RAM_PACKET_RAM_0_330            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,330)
#define XCVR_PKT_RAM_PACKET_RAM_0_331            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,331)
#define XCVR_PKT_RAM_PACKET_RAM_0_332            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,332)
#define XCVR_PKT_RAM_PACKET_RAM_0_333            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,333)
#define XCVR_PKT_RAM_PACKET_RAM_0_334            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,334)
#define XCVR_PKT_RAM_PACKET_RAM_0_335            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,335)
#define XCVR_PKT_RAM_PACKET_RAM_0_336            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,336)
#define XCVR_PKT_RAM_PACKET_RAM_0_337            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,337)
#define XCVR_PKT_RAM_PACKET_RAM_0_338            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,338)
#define XCVR_PKT_RAM_PACKET_RAM_0_339            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,339)
#define XCVR_PKT_RAM_PACKET_RAM_0_340            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,340)
#define XCVR_PKT_RAM_PACKET_RAM_0_341            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,341)
#define XCVR_PKT_RAM_PACKET_RAM_0_342            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,342)
#define XCVR_PKT_RAM_PACKET_RAM_0_343            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,343)
#define XCVR_PKT_RAM_PACKET_RAM_0_344            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,344)
#define XCVR_PKT_RAM_PACKET_RAM_0_345            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,345)
#define XCVR_PKT_RAM_PACKET_RAM_0_346            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,346)
#define XCVR_PKT_RAM_PACKET_RAM_0_347            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,347)
#define XCVR_PKT_RAM_PACKET_RAM_0_348            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,348)
#define XCVR_PKT_RAM_PACKET_RAM_0_349            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,349)
#define XCVR_PKT_RAM_PACKET_RAM_0_350            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,350)
#define XCVR_PKT_RAM_PACKET_RAM_0_351            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,351)
#define XCVR_PKT_RAM_PACKET_RAM_0_352            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,352)
#define XCVR_PKT_RAM_PACKET_RAM_0_353            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,353)
#define XCVR_PKT_RAM_PACKET_RAM_0_354            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,354)
#define XCVR_PKT_RAM_PACKET_RAM_0_355            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,355)
#define XCVR_PKT_RAM_PACKET_RAM_0_356            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,356)
#define XCVR_PKT_RAM_PACKET_RAM_0_357            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,357)
#define XCVR_PKT_RAM_PACKET_RAM_0_358            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,358)
#define XCVR_PKT_RAM_PACKET_RAM_0_359            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,359)
#define XCVR_PKT_RAM_PACKET_RAM_0_360            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,360)
#define XCVR_PKT_RAM_PACKET_RAM_0_361            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,361)
#define XCVR_PKT_RAM_PACKET_RAM_0_362            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,362)
#define XCVR_PKT_RAM_PACKET_RAM_0_363            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,363)
#define XCVR_PKT_RAM_PACKET_RAM_0_364            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,364)
#define XCVR_PKT_RAM_PACKET_RAM_0_365            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,365)
#define XCVR_PKT_RAM_PACKET_RAM_0_366            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,366)
#define XCVR_PKT_RAM_PACKET_RAM_0_367            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,367)
#define XCVR_PKT_RAM_PACKET_RAM_0_368            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,368)
#define XCVR_PKT_RAM_PACKET_RAM_0_369            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,369)
#define XCVR_PKT_RAM_PACKET_RAM_0_370            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,370)
#define XCVR_PKT_RAM_PACKET_RAM_0_371            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,371)
#define XCVR_PKT_RAM_PACKET_RAM_0_372            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,372)
#define XCVR_PKT_RAM_PACKET_RAM_0_373            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,373)
#define XCVR_PKT_RAM_PACKET_RAM_0_374            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,374)
#define XCVR_PKT_RAM_PACKET_RAM_0_375            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,375)
#define XCVR_PKT_RAM_PACKET_RAM_0_376            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,376)
#define XCVR_PKT_RAM_PACKET_RAM_0_377            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,377)
#define XCVR_PKT_RAM_PACKET_RAM_0_378            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,378)
#define XCVR_PKT_RAM_PACKET_RAM_0_379            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,379)
#define XCVR_PKT_RAM_PACKET_RAM_0_380            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,380)
#define XCVR_PKT_RAM_PACKET_RAM_0_381            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,381)
#define XCVR_PKT_RAM_PACKET_RAM_0_382            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,382)
#define XCVR_PKT_RAM_PACKET_RAM_0_383            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,383)
#define XCVR_PKT_RAM_PACKET_RAM_0_384            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,384)
#define XCVR_PKT_RAM_PACKET_RAM_0_385            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,385)
#define XCVR_PKT_RAM_PACKET_RAM_0_386            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,386)
#define XCVR_PKT_RAM_PACKET_RAM_0_387            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,387)
#define XCVR_PKT_RAM_PACKET_RAM_0_388            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,388)
#define XCVR_PKT_RAM_PACKET_RAM_0_389            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,389)
#define XCVR_PKT_RAM_PACKET_RAM_0_390            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,390)
#define XCVR_PKT_RAM_PACKET_RAM_0_391            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,391)
#define XCVR_PKT_RAM_PACKET_RAM_0_392            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,392)
#define XCVR_PKT_RAM_PACKET_RAM_0_393            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,393)
#define XCVR_PKT_RAM_PACKET_RAM_0_394            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,394)
#define XCVR_PKT_RAM_PACKET_RAM_0_395            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,395)
#define XCVR_PKT_RAM_PACKET_RAM_0_396            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,396)
#define XCVR_PKT_RAM_PACKET_RAM_0_397            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,397)
#define XCVR_PKT_RAM_PACKET_RAM_0_398            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,398)
#define XCVR_PKT_RAM_PACKET_RAM_0_399            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,399)
#define XCVR_PKT_RAM_PACKET_RAM_0_400            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,400)
#define XCVR_PKT_RAM_PACKET_RAM_0_401            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,401)
#define XCVR_PKT_RAM_PACKET_RAM_0_402            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,402)
#define XCVR_PKT_RAM_PACKET_RAM_0_403            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,403)
#define XCVR_PKT_RAM_PACKET_RAM_0_404            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,404)
#define XCVR_PKT_RAM_PACKET_RAM_0_405            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,405)
#define XCVR_PKT_RAM_PACKET_RAM_0_406            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,406)
#define XCVR_PKT_RAM_PACKET_RAM_0_407            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,407)
#define XCVR_PKT_RAM_PACKET_RAM_0_408            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,408)
#define XCVR_PKT_RAM_PACKET_RAM_0_409            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,409)
#define XCVR_PKT_RAM_PACKET_RAM_0_410            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,410)
#define XCVR_PKT_RAM_PACKET_RAM_0_411            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,411)
#define XCVR_PKT_RAM_PACKET_RAM_0_412            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,412)
#define XCVR_PKT_RAM_PACKET_RAM_0_413            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,413)
#define XCVR_PKT_RAM_PACKET_RAM_0_414            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,414)
#define XCVR_PKT_RAM_PACKET_RAM_0_415            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,415)
#define XCVR_PKT_RAM_PACKET_RAM_0_416            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,416)
#define XCVR_PKT_RAM_PACKET_RAM_0_417            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,417)
#define XCVR_PKT_RAM_PACKET_RAM_0_418            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,418)
#define XCVR_PKT_RAM_PACKET_RAM_0_419            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,419)
#define XCVR_PKT_RAM_PACKET_RAM_0_420            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,420)
#define XCVR_PKT_RAM_PACKET_RAM_0_421            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,421)
#define XCVR_PKT_RAM_PACKET_RAM_0_422            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,422)
#define XCVR_PKT_RAM_PACKET_RAM_0_423            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,423)
#define XCVR_PKT_RAM_PACKET_RAM_0_424            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,424)
#define XCVR_PKT_RAM_PACKET_RAM_0_425            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,425)
#define XCVR_PKT_RAM_PACKET_RAM_0_426            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,426)
#define XCVR_PKT_RAM_PACKET_RAM_0_427            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,427)
#define XCVR_PKT_RAM_PACKET_RAM_0_428            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,428)
#define XCVR_PKT_RAM_PACKET_RAM_0_429            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,429)
#define XCVR_PKT_RAM_PACKET_RAM_0_430            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,430)
#define XCVR_PKT_RAM_PACKET_RAM_0_431            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,431)
#define XCVR_PKT_RAM_PACKET_RAM_0_432            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,432)
#define XCVR_PKT_RAM_PACKET_RAM_0_433            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,433)
#define XCVR_PKT_RAM_PACKET_RAM_0_434            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,434)
#define XCVR_PKT_RAM_PACKET_RAM_0_435            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,435)
#define XCVR_PKT_RAM_PACKET_RAM_0_436            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,436)
#define XCVR_PKT_RAM_PACKET_RAM_0_437            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,437)
#define XCVR_PKT_RAM_PACKET_RAM_0_438            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,438)
#define XCVR_PKT_RAM_PACKET_RAM_0_439            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,439)
#define XCVR_PKT_RAM_PACKET_RAM_0_440            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,440)
#define XCVR_PKT_RAM_PACKET_RAM_0_441            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,441)
#define XCVR_PKT_RAM_PACKET_RAM_0_442            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,442)
#define XCVR_PKT_RAM_PACKET_RAM_0_443            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,443)
#define XCVR_PKT_RAM_PACKET_RAM_0_444            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,444)
#define XCVR_PKT_RAM_PACKET_RAM_0_445            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,445)
#define XCVR_PKT_RAM_PACKET_RAM_0_446            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,446)
#define XCVR_PKT_RAM_PACKET_RAM_0_447            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,447)
#define XCVR_PKT_RAM_PACKET_RAM_0_448            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,448)
#define XCVR_PKT_RAM_PACKET_RAM_0_449            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,449)
#define XCVR_PKT_RAM_PACKET_RAM_0_450            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,450)
#define XCVR_PKT_RAM_PACKET_RAM_0_451            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,451)
#define XCVR_PKT_RAM_PACKET_RAM_0_452            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,452)
#define XCVR_PKT_RAM_PACKET_RAM_0_453            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,453)
#define XCVR_PKT_RAM_PACKET_RAM_0_454            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,454)
#define XCVR_PKT_RAM_PACKET_RAM_0_455            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,455)
#define XCVR_PKT_RAM_PACKET_RAM_0_456            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,456)
#define XCVR_PKT_RAM_PACKET_RAM_0_457            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,457)
#define XCVR_PKT_RAM_PACKET_RAM_0_458            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,458)
#define XCVR_PKT_RAM_PACKET_RAM_0_459            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,459)
#define XCVR_PKT_RAM_PACKET_RAM_0_460            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,460)
#define XCVR_PKT_RAM_PACKET_RAM_0_461            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,461)
#define XCVR_PKT_RAM_PACKET_RAM_0_462            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,462)
#define XCVR_PKT_RAM_PACKET_RAM_0_463            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,463)
#define XCVR_PKT_RAM_PACKET_RAM_0_464            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,464)
#define XCVR_PKT_RAM_PACKET_RAM_0_465            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,465)
#define XCVR_PKT_RAM_PACKET_RAM_0_466            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,466)
#define XCVR_PKT_RAM_PACKET_RAM_0_467            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,467)
#define XCVR_PKT_RAM_PACKET_RAM_0_468            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,468)
#define XCVR_PKT_RAM_PACKET_RAM_0_469            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,469)
#define XCVR_PKT_RAM_PACKET_RAM_0_470            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,470)
#define XCVR_PKT_RAM_PACKET_RAM_0_471            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,471)
#define XCVR_PKT_RAM_PACKET_RAM_0_472            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,472)
#define XCVR_PKT_RAM_PACKET_RAM_0_473            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,473)
#define XCVR_PKT_RAM_PACKET_RAM_0_474            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,474)
#define XCVR_PKT_RAM_PACKET_RAM_0_475            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,475)
#define XCVR_PKT_RAM_PACKET_RAM_0_476            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,476)
#define XCVR_PKT_RAM_PACKET_RAM_0_477            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,477)
#define XCVR_PKT_RAM_PACKET_RAM_0_478            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,478)
#define XCVR_PKT_RAM_PACKET_RAM_0_479            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,479)
#define XCVR_PKT_RAM_PACKET_RAM_0_480            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,480)
#define XCVR_PKT_RAM_PACKET_RAM_0_481            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,481)
#define XCVR_PKT_RAM_PACKET_RAM_0_482            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,482)
#define XCVR_PKT_RAM_PACKET_RAM_0_483            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,483)
#define XCVR_PKT_RAM_PACKET_RAM_0_484            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,484)
#define XCVR_PKT_RAM_PACKET_RAM_0_485            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,485)
#define XCVR_PKT_RAM_PACKET_RAM_0_486            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,486)
#define XCVR_PKT_RAM_PACKET_RAM_0_487            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,487)
#define XCVR_PKT_RAM_PACKET_RAM_0_488            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,488)
#define XCVR_PKT_RAM_PACKET_RAM_0_489            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,489)
#define XCVR_PKT_RAM_PACKET_RAM_0_490            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,490)
#define XCVR_PKT_RAM_PACKET_RAM_0_491            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,491)
#define XCVR_PKT_RAM_PACKET_RAM_0_492            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,492)
#define XCVR_PKT_RAM_PACKET_RAM_0_493            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,493)
#define XCVR_PKT_RAM_PACKET_RAM_0_494            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,494)
#define XCVR_PKT_RAM_PACKET_RAM_0_495            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,495)
#define XCVR_PKT_RAM_PACKET_RAM_0_496            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,496)
#define XCVR_PKT_RAM_PACKET_RAM_0_497            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,497)
#define XCVR_PKT_RAM_PACKET_RAM_0_498            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,498)
#define XCVR_PKT_RAM_PACKET_RAM_0_499            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,499)
#define XCVR_PKT_RAM_PACKET_RAM_0_500            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,500)
#define XCVR_PKT_RAM_PACKET_RAM_0_501            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,501)
#define XCVR_PKT_RAM_PACKET_RAM_0_502            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,502)
#define XCVR_PKT_RAM_PACKET_RAM_0_503            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,503)
#define XCVR_PKT_RAM_PACKET_RAM_0_504            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,504)
#define XCVR_PKT_RAM_PACKET_RAM_0_505            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,505)
#define XCVR_PKT_RAM_PACKET_RAM_0_506            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,506)
#define XCVR_PKT_RAM_PACKET_RAM_0_507            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,507)
#define XCVR_PKT_RAM_PACKET_RAM_0_508            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,508)
#define XCVR_PKT_RAM_PACKET_RAM_0_509            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,509)
#define XCVR_PKT_RAM_PACKET_RAM_0_510            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,510)
#define XCVR_PKT_RAM_PACKET_RAM_0_511            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,511)
#define XCVR_PKT_RAM_PACKET_RAM_0_512            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,512)
#define XCVR_PKT_RAM_PACKET_RAM_0_513            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,513)
#define XCVR_PKT_RAM_PACKET_RAM_0_514            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,514)
#define XCVR_PKT_RAM_PACKET_RAM_0_515            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,515)
#define XCVR_PKT_RAM_PACKET_RAM_0_516            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,516)
#define XCVR_PKT_RAM_PACKET_RAM_0_517            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,517)
#define XCVR_PKT_RAM_PACKET_RAM_0_518            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,518)
#define XCVR_PKT_RAM_PACKET_RAM_0_519            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,519)
#define XCVR_PKT_RAM_PACKET_RAM_0_520            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,520)
#define XCVR_PKT_RAM_PACKET_RAM_0_521            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,521)
#define XCVR_PKT_RAM_PACKET_RAM_0_522            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,522)
#define XCVR_PKT_RAM_PACKET_RAM_0_523            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,523)
#define XCVR_PKT_RAM_PACKET_RAM_0_524            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,524)
#define XCVR_PKT_RAM_PACKET_RAM_0_525            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,525)
#define XCVR_PKT_RAM_PACKET_RAM_0_526            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,526)
#define XCVR_PKT_RAM_PACKET_RAM_0_527            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,527)
#define XCVR_PKT_RAM_PACKET_RAM_0_528            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,528)
#define XCVR_PKT_RAM_PACKET_RAM_0_529            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,529)
#define XCVR_PKT_RAM_PACKET_RAM_0_530            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,530)
#define XCVR_PKT_RAM_PACKET_RAM_0_531            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,531)
#define XCVR_PKT_RAM_PACKET_RAM_0_532            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,532)
#define XCVR_PKT_RAM_PACKET_RAM_0_533            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,533)
#define XCVR_PKT_RAM_PACKET_RAM_0_534            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,534)
#define XCVR_PKT_RAM_PACKET_RAM_0_535            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,535)
#define XCVR_PKT_RAM_PACKET_RAM_0_536            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,536)
#define XCVR_PKT_RAM_PACKET_RAM_0_537            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,537)
#define XCVR_PKT_RAM_PACKET_RAM_0_538            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,538)
#define XCVR_PKT_RAM_PACKET_RAM_0_539            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,539)
#define XCVR_PKT_RAM_PACKET_RAM_0_540            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,540)
#define XCVR_PKT_RAM_PACKET_RAM_0_541            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,541)
#define XCVR_PKT_RAM_PACKET_RAM_0_542            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,542)
#define XCVR_PKT_RAM_PACKET_RAM_0_543            XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,543)
#define XCVR_PKT_RAM_PACKET_RAM_1_0              XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,0)
#define XCVR_PKT_RAM_PACKET_RAM_1_1              XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,1)
#define XCVR_PKT_RAM_PACKET_RAM_1_2              XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,2)
#define XCVR_PKT_RAM_PACKET_RAM_1_3              XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,3)
#define XCVR_PKT_RAM_PACKET_RAM_1_4              XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,4)
#define XCVR_PKT_RAM_PACKET_RAM_1_5              XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,5)
#define XCVR_PKT_RAM_PACKET_RAM_1_6              XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,6)
#define XCVR_PKT_RAM_PACKET_RAM_1_7              XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,7)
#define XCVR_PKT_RAM_PACKET_RAM_1_8              XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,8)
#define XCVR_PKT_RAM_PACKET_RAM_1_9              XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,9)
#define XCVR_PKT_RAM_PACKET_RAM_1_10             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,10)
#define XCVR_PKT_RAM_PACKET_RAM_1_11             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,11)
#define XCVR_PKT_RAM_PACKET_RAM_1_12             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,12)
#define XCVR_PKT_RAM_PACKET_RAM_1_13             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,13)
#define XCVR_PKT_RAM_PACKET_RAM_1_14             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,14)
#define XCVR_PKT_RAM_PACKET_RAM_1_15             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,15)
#define XCVR_PKT_RAM_PACKET_RAM_1_16             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,16)
#define XCVR_PKT_RAM_PACKET_RAM_1_17             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,17)
#define XCVR_PKT_RAM_PACKET_RAM_1_18             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,18)
#define XCVR_PKT_RAM_PACKET_RAM_1_19             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,19)
#define XCVR_PKT_RAM_PACKET_RAM_1_20             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,20)
#define XCVR_PKT_RAM_PACKET_RAM_1_21             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,21)
#define XCVR_PKT_RAM_PACKET_RAM_1_22             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,22)
#define XCVR_PKT_RAM_PACKET_RAM_1_23             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,23)
#define XCVR_PKT_RAM_PACKET_RAM_1_24             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,24)
#define XCVR_PKT_RAM_PACKET_RAM_1_25             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,25)
#define XCVR_PKT_RAM_PACKET_RAM_1_26             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,26)
#define XCVR_PKT_RAM_PACKET_RAM_1_27             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,27)
#define XCVR_PKT_RAM_PACKET_RAM_1_28             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,28)
#define XCVR_PKT_RAM_PACKET_RAM_1_29             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,29)
#define XCVR_PKT_RAM_PACKET_RAM_1_30             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,30)
#define XCVR_PKT_RAM_PACKET_RAM_1_31             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,31)
#define XCVR_PKT_RAM_PACKET_RAM_1_32             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,32)
#define XCVR_PKT_RAM_PACKET_RAM_1_33             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,33)
#define XCVR_PKT_RAM_PACKET_RAM_1_34             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,34)
#define XCVR_PKT_RAM_PACKET_RAM_1_35             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,35)
#define XCVR_PKT_RAM_PACKET_RAM_1_36             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,36)
#define XCVR_PKT_RAM_PACKET_RAM_1_37             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,37)
#define XCVR_PKT_RAM_PACKET_RAM_1_38             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,38)
#define XCVR_PKT_RAM_PACKET_RAM_1_39             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,39)
#define XCVR_PKT_RAM_PACKET_RAM_1_40             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,40)
#define XCVR_PKT_RAM_PACKET_RAM_1_41             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,41)
#define XCVR_PKT_RAM_PACKET_RAM_1_42             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,42)
#define XCVR_PKT_RAM_PACKET_RAM_1_43             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,43)
#define XCVR_PKT_RAM_PACKET_RAM_1_44             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,44)
#define XCVR_PKT_RAM_PACKET_RAM_1_45             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,45)
#define XCVR_PKT_RAM_PACKET_RAM_1_46             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,46)
#define XCVR_PKT_RAM_PACKET_RAM_1_47             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,47)
#define XCVR_PKT_RAM_PACKET_RAM_1_48             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,48)
#define XCVR_PKT_RAM_PACKET_RAM_1_49             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,49)
#define XCVR_PKT_RAM_PACKET_RAM_1_50             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,50)
#define XCVR_PKT_RAM_PACKET_RAM_1_51             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,51)
#define XCVR_PKT_RAM_PACKET_RAM_1_52             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,52)
#define XCVR_PKT_RAM_PACKET_RAM_1_53             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,53)
#define XCVR_PKT_RAM_PACKET_RAM_1_54             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,54)
#define XCVR_PKT_RAM_PACKET_RAM_1_55             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,55)
#define XCVR_PKT_RAM_PACKET_RAM_1_56             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,56)
#define XCVR_PKT_RAM_PACKET_RAM_1_57             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,57)
#define XCVR_PKT_RAM_PACKET_RAM_1_58             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,58)
#define XCVR_PKT_RAM_PACKET_RAM_1_59             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,59)
#define XCVR_PKT_RAM_PACKET_RAM_1_60             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,60)
#define XCVR_PKT_RAM_PACKET_RAM_1_61             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,61)
#define XCVR_PKT_RAM_PACKET_RAM_1_62             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,62)
#define XCVR_PKT_RAM_PACKET_RAM_1_63             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,63)
#define XCVR_PKT_RAM_PACKET_RAM_1_64             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,64)
#define XCVR_PKT_RAM_PACKET_RAM_1_65             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,65)
#define XCVR_PKT_RAM_PACKET_RAM_1_66             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,66)
#define XCVR_PKT_RAM_PACKET_RAM_1_67             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,67)
#define XCVR_PKT_RAM_PACKET_RAM_1_68             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,68)
#define XCVR_PKT_RAM_PACKET_RAM_1_69             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,69)
#define XCVR_PKT_RAM_PACKET_RAM_1_70             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,70)
#define XCVR_PKT_RAM_PACKET_RAM_1_71             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,71)
#define XCVR_PKT_RAM_PACKET_RAM_1_72             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,72)
#define XCVR_PKT_RAM_PACKET_RAM_1_73             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,73)
#define XCVR_PKT_RAM_PACKET_RAM_1_74             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,74)
#define XCVR_PKT_RAM_PACKET_RAM_1_75             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,75)
#define XCVR_PKT_RAM_PACKET_RAM_1_76             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,76)
#define XCVR_PKT_RAM_PACKET_RAM_1_77             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,77)
#define XCVR_PKT_RAM_PACKET_RAM_1_78             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,78)
#define XCVR_PKT_RAM_PACKET_RAM_1_79             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,79)
#define XCVR_PKT_RAM_PACKET_RAM_1_80             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,80)
#define XCVR_PKT_RAM_PACKET_RAM_1_81             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,81)
#define XCVR_PKT_RAM_PACKET_RAM_1_82             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,82)
#define XCVR_PKT_RAM_PACKET_RAM_1_83             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,83)
#define XCVR_PKT_RAM_PACKET_RAM_1_84             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,84)
#define XCVR_PKT_RAM_PACKET_RAM_1_85             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,85)
#define XCVR_PKT_RAM_PACKET_RAM_1_86             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,86)
#define XCVR_PKT_RAM_PACKET_RAM_1_87             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,87)
#define XCVR_PKT_RAM_PACKET_RAM_1_88             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,88)
#define XCVR_PKT_RAM_PACKET_RAM_1_89             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,89)
#define XCVR_PKT_RAM_PACKET_RAM_1_90             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,90)
#define XCVR_PKT_RAM_PACKET_RAM_1_91             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,91)
#define XCVR_PKT_RAM_PACKET_RAM_1_92             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,92)
#define XCVR_PKT_RAM_PACKET_RAM_1_93             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,93)
#define XCVR_PKT_RAM_PACKET_RAM_1_94             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,94)
#define XCVR_PKT_RAM_PACKET_RAM_1_95             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,95)
#define XCVR_PKT_RAM_PACKET_RAM_1_96             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,96)
#define XCVR_PKT_RAM_PACKET_RAM_1_97             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,97)
#define XCVR_PKT_RAM_PACKET_RAM_1_98             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,98)
#define XCVR_PKT_RAM_PACKET_RAM_1_99             XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,99)
#define XCVR_PKT_RAM_PACKET_RAM_1_100            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,100)
#define XCVR_PKT_RAM_PACKET_RAM_1_101            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,101)
#define XCVR_PKT_RAM_PACKET_RAM_1_102            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,102)
#define XCVR_PKT_RAM_PACKET_RAM_1_103            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,103)
#define XCVR_PKT_RAM_PACKET_RAM_1_104            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,104)
#define XCVR_PKT_RAM_PACKET_RAM_1_105            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,105)
#define XCVR_PKT_RAM_PACKET_RAM_1_106            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,106)
#define XCVR_PKT_RAM_PACKET_RAM_1_107            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,107)
#define XCVR_PKT_RAM_PACKET_RAM_1_108            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,108)
#define XCVR_PKT_RAM_PACKET_RAM_1_109            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,109)
#define XCVR_PKT_RAM_PACKET_RAM_1_110            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,110)
#define XCVR_PKT_RAM_PACKET_RAM_1_111            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,111)
#define XCVR_PKT_RAM_PACKET_RAM_1_112            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,112)
#define XCVR_PKT_RAM_PACKET_RAM_1_113            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,113)
#define XCVR_PKT_RAM_PACKET_RAM_1_114            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,114)
#define XCVR_PKT_RAM_PACKET_RAM_1_115            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,115)
#define XCVR_PKT_RAM_PACKET_RAM_1_116            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,116)
#define XCVR_PKT_RAM_PACKET_RAM_1_117            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,117)
#define XCVR_PKT_RAM_PACKET_RAM_1_118            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,118)
#define XCVR_PKT_RAM_PACKET_RAM_1_119            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,119)
#define XCVR_PKT_RAM_PACKET_RAM_1_120            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,120)
#define XCVR_PKT_RAM_PACKET_RAM_1_121            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,121)
#define XCVR_PKT_RAM_PACKET_RAM_1_122            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,122)
#define XCVR_PKT_RAM_PACKET_RAM_1_123            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,123)
#define XCVR_PKT_RAM_PACKET_RAM_1_124            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,124)
#define XCVR_PKT_RAM_PACKET_RAM_1_125            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,125)
#define XCVR_PKT_RAM_PACKET_RAM_1_126            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,126)
#define XCVR_PKT_RAM_PACKET_RAM_1_127            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,127)
#define XCVR_PKT_RAM_PACKET_RAM_1_128            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,128)
#define XCVR_PKT_RAM_PACKET_RAM_1_129            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,129)
#define XCVR_PKT_RAM_PACKET_RAM_1_130            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,130)
#define XCVR_PKT_RAM_PACKET_RAM_1_131            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,131)
#define XCVR_PKT_RAM_PACKET_RAM_1_132            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,132)
#define XCVR_PKT_RAM_PACKET_RAM_1_133            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,133)
#define XCVR_PKT_RAM_PACKET_RAM_1_134            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,134)
#define XCVR_PKT_RAM_PACKET_RAM_1_135            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,135)
#define XCVR_PKT_RAM_PACKET_RAM_1_136            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,136)
#define XCVR_PKT_RAM_PACKET_RAM_1_137            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,137)
#define XCVR_PKT_RAM_PACKET_RAM_1_138            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,138)
#define XCVR_PKT_RAM_PACKET_RAM_1_139            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,139)
#define XCVR_PKT_RAM_PACKET_RAM_1_140            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,140)
#define XCVR_PKT_RAM_PACKET_RAM_1_141            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,141)
#define XCVR_PKT_RAM_PACKET_RAM_1_142            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,142)
#define XCVR_PKT_RAM_PACKET_RAM_1_143            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,143)
#define XCVR_PKT_RAM_PACKET_RAM_1_144            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,144)
#define XCVR_PKT_RAM_PACKET_RAM_1_145            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,145)
#define XCVR_PKT_RAM_PACKET_RAM_1_146            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,146)
#define XCVR_PKT_RAM_PACKET_RAM_1_147            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,147)
#define XCVR_PKT_RAM_PACKET_RAM_1_148            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,148)
#define XCVR_PKT_RAM_PACKET_RAM_1_149            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,149)
#define XCVR_PKT_RAM_PACKET_RAM_1_150            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,150)
#define XCVR_PKT_RAM_PACKET_RAM_1_151            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,151)
#define XCVR_PKT_RAM_PACKET_RAM_1_152            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,152)
#define XCVR_PKT_RAM_PACKET_RAM_1_153            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,153)
#define XCVR_PKT_RAM_PACKET_RAM_1_154            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,154)
#define XCVR_PKT_RAM_PACKET_RAM_1_155            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,155)
#define XCVR_PKT_RAM_PACKET_RAM_1_156            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,156)
#define XCVR_PKT_RAM_PACKET_RAM_1_157            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,157)
#define XCVR_PKT_RAM_PACKET_RAM_1_158            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,158)
#define XCVR_PKT_RAM_PACKET_RAM_1_159            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,159)
#define XCVR_PKT_RAM_PACKET_RAM_1_160            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,160)
#define XCVR_PKT_RAM_PACKET_RAM_1_161            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,161)
#define XCVR_PKT_RAM_PACKET_RAM_1_162            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,162)
#define XCVR_PKT_RAM_PACKET_RAM_1_163            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,163)
#define XCVR_PKT_RAM_PACKET_RAM_1_164            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,164)
#define XCVR_PKT_RAM_PACKET_RAM_1_165            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,165)
#define XCVR_PKT_RAM_PACKET_RAM_1_166            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,166)
#define XCVR_PKT_RAM_PACKET_RAM_1_167            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,167)
#define XCVR_PKT_RAM_PACKET_RAM_1_168            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,168)
#define XCVR_PKT_RAM_PACKET_RAM_1_169            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,169)
#define XCVR_PKT_RAM_PACKET_RAM_1_170            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,170)
#define XCVR_PKT_RAM_PACKET_RAM_1_171            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,171)
#define XCVR_PKT_RAM_PACKET_RAM_1_172            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,172)
#define XCVR_PKT_RAM_PACKET_RAM_1_173            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,173)
#define XCVR_PKT_RAM_PACKET_RAM_1_174            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,174)
#define XCVR_PKT_RAM_PACKET_RAM_1_175            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,175)
#define XCVR_PKT_RAM_PACKET_RAM_1_176            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,176)
#define XCVR_PKT_RAM_PACKET_RAM_1_177            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,177)
#define XCVR_PKT_RAM_PACKET_RAM_1_178            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,178)
#define XCVR_PKT_RAM_PACKET_RAM_1_179            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,179)
#define XCVR_PKT_RAM_PACKET_RAM_1_180            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,180)
#define XCVR_PKT_RAM_PACKET_RAM_1_181            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,181)
#define XCVR_PKT_RAM_PACKET_RAM_1_182            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,182)
#define XCVR_PKT_RAM_PACKET_RAM_1_183            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,183)
#define XCVR_PKT_RAM_PACKET_RAM_1_184            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,184)
#define XCVR_PKT_RAM_PACKET_RAM_1_185            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,185)
#define XCVR_PKT_RAM_PACKET_RAM_1_186            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,186)
#define XCVR_PKT_RAM_PACKET_RAM_1_187            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,187)
#define XCVR_PKT_RAM_PACKET_RAM_1_188            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,188)
#define XCVR_PKT_RAM_PACKET_RAM_1_189            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,189)
#define XCVR_PKT_RAM_PACKET_RAM_1_190            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,190)
#define XCVR_PKT_RAM_PACKET_RAM_1_191            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,191)
#define XCVR_PKT_RAM_PACKET_RAM_1_192            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,192)
#define XCVR_PKT_RAM_PACKET_RAM_1_193            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,193)
#define XCVR_PKT_RAM_PACKET_RAM_1_194            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,194)
#define XCVR_PKT_RAM_PACKET_RAM_1_195            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,195)
#define XCVR_PKT_RAM_PACKET_RAM_1_196            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,196)
#define XCVR_PKT_RAM_PACKET_RAM_1_197            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,197)
#define XCVR_PKT_RAM_PACKET_RAM_1_198            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,198)
#define XCVR_PKT_RAM_PACKET_RAM_1_199            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,199)
#define XCVR_PKT_RAM_PACKET_RAM_1_200            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,200)
#define XCVR_PKT_RAM_PACKET_RAM_1_201            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,201)
#define XCVR_PKT_RAM_PACKET_RAM_1_202            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,202)
#define XCVR_PKT_RAM_PACKET_RAM_1_203            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,203)
#define XCVR_PKT_RAM_PACKET_RAM_1_204            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,204)
#define XCVR_PKT_RAM_PACKET_RAM_1_205            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,205)
#define XCVR_PKT_RAM_PACKET_RAM_1_206            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,206)
#define XCVR_PKT_RAM_PACKET_RAM_1_207            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,207)
#define XCVR_PKT_RAM_PACKET_RAM_1_208            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,208)
#define XCVR_PKT_RAM_PACKET_RAM_1_209            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,209)
#define XCVR_PKT_RAM_PACKET_RAM_1_210            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,210)
#define XCVR_PKT_RAM_PACKET_RAM_1_211            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,211)
#define XCVR_PKT_RAM_PACKET_RAM_1_212            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,212)
#define XCVR_PKT_RAM_PACKET_RAM_1_213            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,213)
#define XCVR_PKT_RAM_PACKET_RAM_1_214            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,214)
#define XCVR_PKT_RAM_PACKET_RAM_1_215            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,215)
#define XCVR_PKT_RAM_PACKET_RAM_1_216            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,216)
#define XCVR_PKT_RAM_PACKET_RAM_1_217            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,217)
#define XCVR_PKT_RAM_PACKET_RAM_1_218            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,218)
#define XCVR_PKT_RAM_PACKET_RAM_1_219            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,219)
#define XCVR_PKT_RAM_PACKET_RAM_1_220            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,220)
#define XCVR_PKT_RAM_PACKET_RAM_1_221            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,221)
#define XCVR_PKT_RAM_PACKET_RAM_1_222            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,222)
#define XCVR_PKT_RAM_PACKET_RAM_1_223            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,223)
#define XCVR_PKT_RAM_PACKET_RAM_1_224            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,224)
#define XCVR_PKT_RAM_PACKET_RAM_1_225            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,225)
#define XCVR_PKT_RAM_PACKET_RAM_1_226            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,226)
#define XCVR_PKT_RAM_PACKET_RAM_1_227            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,227)
#define XCVR_PKT_RAM_PACKET_RAM_1_228            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,228)
#define XCVR_PKT_RAM_PACKET_RAM_1_229            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,229)
#define XCVR_PKT_RAM_PACKET_RAM_1_230            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,230)
#define XCVR_PKT_RAM_PACKET_RAM_1_231            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,231)
#define XCVR_PKT_RAM_PACKET_RAM_1_232            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,232)
#define XCVR_PKT_RAM_PACKET_RAM_1_233            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,233)
#define XCVR_PKT_RAM_PACKET_RAM_1_234            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,234)
#define XCVR_PKT_RAM_PACKET_RAM_1_235            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,235)
#define XCVR_PKT_RAM_PACKET_RAM_1_236            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,236)
#define XCVR_PKT_RAM_PACKET_RAM_1_237            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,237)
#define XCVR_PKT_RAM_PACKET_RAM_1_238            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,238)
#define XCVR_PKT_RAM_PACKET_RAM_1_239            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,239)
#define XCVR_PKT_RAM_PACKET_RAM_1_240            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,240)
#define XCVR_PKT_RAM_PACKET_RAM_1_241            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,241)
#define XCVR_PKT_RAM_PACKET_RAM_1_242            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,242)
#define XCVR_PKT_RAM_PACKET_RAM_1_243            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,243)
#define XCVR_PKT_RAM_PACKET_RAM_1_244            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,244)
#define XCVR_PKT_RAM_PACKET_RAM_1_245            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,245)
#define XCVR_PKT_RAM_PACKET_RAM_1_246            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,246)
#define XCVR_PKT_RAM_PACKET_RAM_1_247            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,247)
#define XCVR_PKT_RAM_PACKET_RAM_1_248            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,248)
#define XCVR_PKT_RAM_PACKET_RAM_1_249            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,249)
#define XCVR_PKT_RAM_PACKET_RAM_1_250            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,250)
#define XCVR_PKT_RAM_PACKET_RAM_1_251            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,251)
#define XCVR_PKT_RAM_PACKET_RAM_1_252            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,252)
#define XCVR_PKT_RAM_PACKET_RAM_1_253            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,253)
#define XCVR_PKT_RAM_PACKET_RAM_1_254            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,254)
#define XCVR_PKT_RAM_PACKET_RAM_1_255            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,255)
#define XCVR_PKT_RAM_PACKET_RAM_1_256            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,256)
#define XCVR_PKT_RAM_PACKET_RAM_1_257            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,257)
#define XCVR_PKT_RAM_PACKET_RAM_1_258            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,258)
#define XCVR_PKT_RAM_PACKET_RAM_1_259            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,259)
#define XCVR_PKT_RAM_PACKET_RAM_1_260            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,260)
#define XCVR_PKT_RAM_PACKET_RAM_1_261            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,261)
#define XCVR_PKT_RAM_PACKET_RAM_1_262            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,262)
#define XCVR_PKT_RAM_PACKET_RAM_1_263            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,263)
#define XCVR_PKT_RAM_PACKET_RAM_1_264            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,264)
#define XCVR_PKT_RAM_PACKET_RAM_1_265            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,265)
#define XCVR_PKT_RAM_PACKET_RAM_1_266            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,266)
#define XCVR_PKT_RAM_PACKET_RAM_1_267            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,267)
#define XCVR_PKT_RAM_PACKET_RAM_1_268            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,268)
#define XCVR_PKT_RAM_PACKET_RAM_1_269            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,269)
#define XCVR_PKT_RAM_PACKET_RAM_1_270            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,270)
#define XCVR_PKT_RAM_PACKET_RAM_1_271            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,271)
#define XCVR_PKT_RAM_PACKET_RAM_1_272            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,272)
#define XCVR_PKT_RAM_PACKET_RAM_1_273            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,273)
#define XCVR_PKT_RAM_PACKET_RAM_1_274            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,274)
#define XCVR_PKT_RAM_PACKET_RAM_1_275            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,275)
#define XCVR_PKT_RAM_PACKET_RAM_1_276            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,276)
#define XCVR_PKT_RAM_PACKET_RAM_1_277            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,277)
#define XCVR_PKT_RAM_PACKET_RAM_1_278            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,278)
#define XCVR_PKT_RAM_PACKET_RAM_1_279            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,279)
#define XCVR_PKT_RAM_PACKET_RAM_1_280            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,280)
#define XCVR_PKT_RAM_PACKET_RAM_1_281            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,281)
#define XCVR_PKT_RAM_PACKET_RAM_1_282            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,282)
#define XCVR_PKT_RAM_PACKET_RAM_1_283            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,283)
#define XCVR_PKT_RAM_PACKET_RAM_1_284            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,284)
#define XCVR_PKT_RAM_PACKET_RAM_1_285            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,285)
#define XCVR_PKT_RAM_PACKET_RAM_1_286            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,286)
#define XCVR_PKT_RAM_PACKET_RAM_1_287            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,287)
#define XCVR_PKT_RAM_PACKET_RAM_1_288            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,288)
#define XCVR_PKT_RAM_PACKET_RAM_1_289            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,289)
#define XCVR_PKT_RAM_PACKET_RAM_1_290            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,290)
#define XCVR_PKT_RAM_PACKET_RAM_1_291            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,291)
#define XCVR_PKT_RAM_PACKET_RAM_1_292            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,292)
#define XCVR_PKT_RAM_PACKET_RAM_1_293            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,293)
#define XCVR_PKT_RAM_PACKET_RAM_1_294            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,294)
#define XCVR_PKT_RAM_PACKET_RAM_1_295            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,295)
#define XCVR_PKT_RAM_PACKET_RAM_1_296            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,296)
#define XCVR_PKT_RAM_PACKET_RAM_1_297            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,297)
#define XCVR_PKT_RAM_PACKET_RAM_1_298            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,298)
#define XCVR_PKT_RAM_PACKET_RAM_1_299            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,299)
#define XCVR_PKT_RAM_PACKET_RAM_1_300            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,300)
#define XCVR_PKT_RAM_PACKET_RAM_1_301            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,301)
#define XCVR_PKT_RAM_PACKET_RAM_1_302            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,302)
#define XCVR_PKT_RAM_PACKET_RAM_1_303            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,303)
#define XCVR_PKT_RAM_PACKET_RAM_1_304            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,304)
#define XCVR_PKT_RAM_PACKET_RAM_1_305            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,305)
#define XCVR_PKT_RAM_PACKET_RAM_1_306            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,306)
#define XCVR_PKT_RAM_PACKET_RAM_1_307            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,307)
#define XCVR_PKT_RAM_PACKET_RAM_1_308            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,308)
#define XCVR_PKT_RAM_PACKET_RAM_1_309            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,309)
#define XCVR_PKT_RAM_PACKET_RAM_1_310            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,310)
#define XCVR_PKT_RAM_PACKET_RAM_1_311            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,311)
#define XCVR_PKT_RAM_PACKET_RAM_1_312            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,312)
#define XCVR_PKT_RAM_PACKET_RAM_1_313            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,313)
#define XCVR_PKT_RAM_PACKET_RAM_1_314            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,314)
#define XCVR_PKT_RAM_PACKET_RAM_1_315            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,315)
#define XCVR_PKT_RAM_PACKET_RAM_1_316            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,316)
#define XCVR_PKT_RAM_PACKET_RAM_1_317            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,317)
#define XCVR_PKT_RAM_PACKET_RAM_1_318            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,318)
#define XCVR_PKT_RAM_PACKET_RAM_1_319            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,319)
#define XCVR_PKT_RAM_PACKET_RAM_1_320            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,320)
#define XCVR_PKT_RAM_PACKET_RAM_1_321            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,321)
#define XCVR_PKT_RAM_PACKET_RAM_1_322            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,322)
#define XCVR_PKT_RAM_PACKET_RAM_1_323            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,323)
#define XCVR_PKT_RAM_PACKET_RAM_1_324            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,324)
#define XCVR_PKT_RAM_PACKET_RAM_1_325            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,325)
#define XCVR_PKT_RAM_PACKET_RAM_1_326            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,326)
#define XCVR_PKT_RAM_PACKET_RAM_1_327            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,327)
#define XCVR_PKT_RAM_PACKET_RAM_1_328            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,328)
#define XCVR_PKT_RAM_PACKET_RAM_1_329            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,329)
#define XCVR_PKT_RAM_PACKET_RAM_1_330            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,330)
#define XCVR_PKT_RAM_PACKET_RAM_1_331            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,331)
#define XCVR_PKT_RAM_PACKET_RAM_1_332            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,332)
#define XCVR_PKT_RAM_PACKET_RAM_1_333            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,333)
#define XCVR_PKT_RAM_PACKET_RAM_1_334            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,334)
#define XCVR_PKT_RAM_PACKET_RAM_1_335            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,335)
#define XCVR_PKT_RAM_PACKET_RAM_1_336            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,336)
#define XCVR_PKT_RAM_PACKET_RAM_1_337            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,337)
#define XCVR_PKT_RAM_PACKET_RAM_1_338            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,338)
#define XCVR_PKT_RAM_PACKET_RAM_1_339            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,339)
#define XCVR_PKT_RAM_PACKET_RAM_1_340            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,340)
#define XCVR_PKT_RAM_PACKET_RAM_1_341            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,341)
#define XCVR_PKT_RAM_PACKET_RAM_1_342            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,342)
#define XCVR_PKT_RAM_PACKET_RAM_1_343            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,343)
#define XCVR_PKT_RAM_PACKET_RAM_1_344            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,344)
#define XCVR_PKT_RAM_PACKET_RAM_1_345            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,345)
#define XCVR_PKT_RAM_PACKET_RAM_1_346            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,346)
#define XCVR_PKT_RAM_PACKET_RAM_1_347            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,347)
#define XCVR_PKT_RAM_PACKET_RAM_1_348            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,348)
#define XCVR_PKT_RAM_PACKET_RAM_1_349            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,349)
#define XCVR_PKT_RAM_PACKET_RAM_1_350            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,350)
#define XCVR_PKT_RAM_PACKET_RAM_1_351            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,351)
#define XCVR_PKT_RAM_PACKET_RAM_1_352            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,352)
#define XCVR_PKT_RAM_PACKET_RAM_1_353            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,353)
#define XCVR_PKT_RAM_PACKET_RAM_1_354            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,354)
#define XCVR_PKT_RAM_PACKET_RAM_1_355            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,355)
#define XCVR_PKT_RAM_PACKET_RAM_1_356            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,356)
#define XCVR_PKT_RAM_PACKET_RAM_1_357            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,357)
#define XCVR_PKT_RAM_PACKET_RAM_1_358            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,358)
#define XCVR_PKT_RAM_PACKET_RAM_1_359            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,359)
#define XCVR_PKT_RAM_PACKET_RAM_1_360            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,360)
#define XCVR_PKT_RAM_PACKET_RAM_1_361            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,361)
#define XCVR_PKT_RAM_PACKET_RAM_1_362            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,362)
#define XCVR_PKT_RAM_PACKET_RAM_1_363            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,363)
#define XCVR_PKT_RAM_PACKET_RAM_1_364            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,364)
#define XCVR_PKT_RAM_PACKET_RAM_1_365            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,365)
#define XCVR_PKT_RAM_PACKET_RAM_1_366            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,366)
#define XCVR_PKT_RAM_PACKET_RAM_1_367            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,367)
#define XCVR_PKT_RAM_PACKET_RAM_1_368            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,368)
#define XCVR_PKT_RAM_PACKET_RAM_1_369            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,369)
#define XCVR_PKT_RAM_PACKET_RAM_1_370            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,370)
#define XCVR_PKT_RAM_PACKET_RAM_1_371            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,371)
#define XCVR_PKT_RAM_PACKET_RAM_1_372            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,372)
#define XCVR_PKT_RAM_PACKET_RAM_1_373            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,373)
#define XCVR_PKT_RAM_PACKET_RAM_1_374            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,374)
#define XCVR_PKT_RAM_PACKET_RAM_1_375            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,375)
#define XCVR_PKT_RAM_PACKET_RAM_1_376            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,376)
#define XCVR_PKT_RAM_PACKET_RAM_1_377            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,377)
#define XCVR_PKT_RAM_PACKET_RAM_1_378            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,378)
#define XCVR_PKT_RAM_PACKET_RAM_1_379            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,379)
#define XCVR_PKT_RAM_PACKET_RAM_1_380            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,380)
#define XCVR_PKT_RAM_PACKET_RAM_1_381            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,381)
#define XCVR_PKT_RAM_PACKET_RAM_1_382            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,382)
#define XCVR_PKT_RAM_PACKET_RAM_1_383            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,383)
#define XCVR_PKT_RAM_PACKET_RAM_1_384            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,384)
#define XCVR_PKT_RAM_PACKET_RAM_1_385            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,385)
#define XCVR_PKT_RAM_PACKET_RAM_1_386            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,386)
#define XCVR_PKT_RAM_PACKET_RAM_1_387            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,387)
#define XCVR_PKT_RAM_PACKET_RAM_1_388            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,388)
#define XCVR_PKT_RAM_PACKET_RAM_1_389            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,389)
#define XCVR_PKT_RAM_PACKET_RAM_1_390            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,390)
#define XCVR_PKT_RAM_PACKET_RAM_1_391            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,391)
#define XCVR_PKT_RAM_PACKET_RAM_1_392            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,392)
#define XCVR_PKT_RAM_PACKET_RAM_1_393            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,393)
#define XCVR_PKT_RAM_PACKET_RAM_1_394            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,394)
#define XCVR_PKT_RAM_PACKET_RAM_1_395            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,395)
#define XCVR_PKT_RAM_PACKET_RAM_1_396            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,396)
#define XCVR_PKT_RAM_PACKET_RAM_1_397            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,397)
#define XCVR_PKT_RAM_PACKET_RAM_1_398            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,398)
#define XCVR_PKT_RAM_PACKET_RAM_1_399            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,399)
#define XCVR_PKT_RAM_PACKET_RAM_1_400            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,400)
#define XCVR_PKT_RAM_PACKET_RAM_1_401            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,401)
#define XCVR_PKT_RAM_PACKET_RAM_1_402            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,402)
#define XCVR_PKT_RAM_PACKET_RAM_1_403            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,403)
#define XCVR_PKT_RAM_PACKET_RAM_1_404            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,404)
#define XCVR_PKT_RAM_PACKET_RAM_1_405            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,405)
#define XCVR_PKT_RAM_PACKET_RAM_1_406            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,406)
#define XCVR_PKT_RAM_PACKET_RAM_1_407            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,407)
#define XCVR_PKT_RAM_PACKET_RAM_1_408            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,408)
#define XCVR_PKT_RAM_PACKET_RAM_1_409            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,409)
#define XCVR_PKT_RAM_PACKET_RAM_1_410            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,410)
#define XCVR_PKT_RAM_PACKET_RAM_1_411            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,411)
#define XCVR_PKT_RAM_PACKET_RAM_1_412            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,412)
#define XCVR_PKT_RAM_PACKET_RAM_1_413            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,413)
#define XCVR_PKT_RAM_PACKET_RAM_1_414            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,414)
#define XCVR_PKT_RAM_PACKET_RAM_1_415            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,415)
#define XCVR_PKT_RAM_PACKET_RAM_1_416            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,416)
#define XCVR_PKT_RAM_PACKET_RAM_1_417            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,417)
#define XCVR_PKT_RAM_PACKET_RAM_1_418            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,418)
#define XCVR_PKT_RAM_PACKET_RAM_1_419            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,419)
#define XCVR_PKT_RAM_PACKET_RAM_1_420            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,420)
#define XCVR_PKT_RAM_PACKET_RAM_1_421            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,421)
#define XCVR_PKT_RAM_PACKET_RAM_1_422            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,422)
#define XCVR_PKT_RAM_PACKET_RAM_1_423            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,423)
#define XCVR_PKT_RAM_PACKET_RAM_1_424            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,424)
#define XCVR_PKT_RAM_PACKET_RAM_1_425            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,425)
#define XCVR_PKT_RAM_PACKET_RAM_1_426            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,426)
#define XCVR_PKT_RAM_PACKET_RAM_1_427            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,427)
#define XCVR_PKT_RAM_PACKET_RAM_1_428            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,428)
#define XCVR_PKT_RAM_PACKET_RAM_1_429            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,429)
#define XCVR_PKT_RAM_PACKET_RAM_1_430            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,430)
#define XCVR_PKT_RAM_PACKET_RAM_1_431            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,431)
#define XCVR_PKT_RAM_PACKET_RAM_1_432            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,432)
#define XCVR_PKT_RAM_PACKET_RAM_1_433            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,433)
#define XCVR_PKT_RAM_PACKET_RAM_1_434            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,434)
#define XCVR_PKT_RAM_PACKET_RAM_1_435            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,435)
#define XCVR_PKT_RAM_PACKET_RAM_1_436            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,436)
#define XCVR_PKT_RAM_PACKET_RAM_1_437            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,437)
#define XCVR_PKT_RAM_PACKET_RAM_1_438            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,438)
#define XCVR_PKT_RAM_PACKET_RAM_1_439            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,439)
#define XCVR_PKT_RAM_PACKET_RAM_1_440            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,440)
#define XCVR_PKT_RAM_PACKET_RAM_1_441            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,441)
#define XCVR_PKT_RAM_PACKET_RAM_1_442            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,442)
#define XCVR_PKT_RAM_PACKET_RAM_1_443            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,443)
#define XCVR_PKT_RAM_PACKET_RAM_1_444            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,444)
#define XCVR_PKT_RAM_PACKET_RAM_1_445            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,445)
#define XCVR_PKT_RAM_PACKET_RAM_1_446            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,446)
#define XCVR_PKT_RAM_PACKET_RAM_1_447            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,447)
#define XCVR_PKT_RAM_PACKET_RAM_1_448            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,448)
#define XCVR_PKT_RAM_PACKET_RAM_1_449            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,449)
#define XCVR_PKT_RAM_PACKET_RAM_1_450            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,450)
#define XCVR_PKT_RAM_PACKET_RAM_1_451            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,451)
#define XCVR_PKT_RAM_PACKET_RAM_1_452            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,452)
#define XCVR_PKT_RAM_PACKET_RAM_1_453            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,453)
#define XCVR_PKT_RAM_PACKET_RAM_1_454            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,454)
#define XCVR_PKT_RAM_PACKET_RAM_1_455            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,455)
#define XCVR_PKT_RAM_PACKET_RAM_1_456            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,456)
#define XCVR_PKT_RAM_PACKET_RAM_1_457            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,457)
#define XCVR_PKT_RAM_PACKET_RAM_1_458            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,458)
#define XCVR_PKT_RAM_PACKET_RAM_1_459            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,459)
#define XCVR_PKT_RAM_PACKET_RAM_1_460            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,460)
#define XCVR_PKT_RAM_PACKET_RAM_1_461            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,461)
#define XCVR_PKT_RAM_PACKET_RAM_1_462            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,462)
#define XCVR_PKT_RAM_PACKET_RAM_1_463            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,463)
#define XCVR_PKT_RAM_PACKET_RAM_1_464            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,464)
#define XCVR_PKT_RAM_PACKET_RAM_1_465            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,465)
#define XCVR_PKT_RAM_PACKET_RAM_1_466            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,466)
#define XCVR_PKT_RAM_PACKET_RAM_1_467            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,467)
#define XCVR_PKT_RAM_PACKET_RAM_1_468            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,468)
#define XCVR_PKT_RAM_PACKET_RAM_1_469            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,469)
#define XCVR_PKT_RAM_PACKET_RAM_1_470            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,470)
#define XCVR_PKT_RAM_PACKET_RAM_1_471            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,471)
#define XCVR_PKT_RAM_PACKET_RAM_1_472            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,472)
#define XCVR_PKT_RAM_PACKET_RAM_1_473            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,473)
#define XCVR_PKT_RAM_PACKET_RAM_1_474            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,474)
#define XCVR_PKT_RAM_PACKET_RAM_1_475            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,475)
#define XCVR_PKT_RAM_PACKET_RAM_1_476            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,476)
#define XCVR_PKT_RAM_PACKET_RAM_1_477            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,477)
#define XCVR_PKT_RAM_PACKET_RAM_1_478            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,478)
#define XCVR_PKT_RAM_PACKET_RAM_1_479            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,479)
#define XCVR_PKT_RAM_PACKET_RAM_1_480            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,480)
#define XCVR_PKT_RAM_PACKET_RAM_1_481            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,481)
#define XCVR_PKT_RAM_PACKET_RAM_1_482            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,482)
#define XCVR_PKT_RAM_PACKET_RAM_1_483            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,483)
#define XCVR_PKT_RAM_PACKET_RAM_1_484            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,484)
#define XCVR_PKT_RAM_PACKET_RAM_1_485            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,485)
#define XCVR_PKT_RAM_PACKET_RAM_1_486            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,486)
#define XCVR_PKT_RAM_PACKET_RAM_1_487            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,487)
#define XCVR_PKT_RAM_PACKET_RAM_1_488            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,488)
#define XCVR_PKT_RAM_PACKET_RAM_1_489            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,489)
#define XCVR_PKT_RAM_PACKET_RAM_1_490            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,490)
#define XCVR_PKT_RAM_PACKET_RAM_1_491            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,491)
#define XCVR_PKT_RAM_PACKET_RAM_1_492            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,492)
#define XCVR_PKT_RAM_PACKET_RAM_1_493            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,493)
#define XCVR_PKT_RAM_PACKET_RAM_1_494            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,494)
#define XCVR_PKT_RAM_PACKET_RAM_1_495            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,495)
#define XCVR_PKT_RAM_PACKET_RAM_1_496            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,496)
#define XCVR_PKT_RAM_PACKET_RAM_1_497            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,497)
#define XCVR_PKT_RAM_PACKET_RAM_1_498            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,498)
#define XCVR_PKT_RAM_PACKET_RAM_1_499            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,499)
#define XCVR_PKT_RAM_PACKET_RAM_1_500            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,500)
#define XCVR_PKT_RAM_PACKET_RAM_1_501            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,501)
#define XCVR_PKT_RAM_PACKET_RAM_1_502            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,502)
#define XCVR_PKT_RAM_PACKET_RAM_1_503            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,503)
#define XCVR_PKT_RAM_PACKET_RAM_1_504            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,504)
#define XCVR_PKT_RAM_PACKET_RAM_1_505            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,505)
#define XCVR_PKT_RAM_PACKET_RAM_1_506            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,506)
#define XCVR_PKT_RAM_PACKET_RAM_1_507            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,507)
#define XCVR_PKT_RAM_PACKET_RAM_1_508            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,508)
#define XCVR_PKT_RAM_PACKET_RAM_1_509            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,509)
#define XCVR_PKT_RAM_PACKET_RAM_1_510            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,510)
#define XCVR_PKT_RAM_PACKET_RAM_1_511            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,511)
#define XCVR_PKT_RAM_PACKET_RAM_1_512            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,512)
#define XCVR_PKT_RAM_PACKET_RAM_1_513            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,513)
#define XCVR_PKT_RAM_PACKET_RAM_1_514            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,514)
#define XCVR_PKT_RAM_PACKET_RAM_1_515            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,515)
#define XCVR_PKT_RAM_PACKET_RAM_1_516            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,516)
#define XCVR_PKT_RAM_PACKET_RAM_1_517            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,517)
#define XCVR_PKT_RAM_PACKET_RAM_1_518            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,518)
#define XCVR_PKT_RAM_PACKET_RAM_1_519            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,519)
#define XCVR_PKT_RAM_PACKET_RAM_1_520            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,520)
#define XCVR_PKT_RAM_PACKET_RAM_1_521            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,521)
#define XCVR_PKT_RAM_PACKET_RAM_1_522            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,522)
#define XCVR_PKT_RAM_PACKET_RAM_1_523            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,523)
#define XCVR_PKT_RAM_PACKET_RAM_1_524            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,524)
#define XCVR_PKT_RAM_PACKET_RAM_1_525            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,525)
#define XCVR_PKT_RAM_PACKET_RAM_1_526            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,526)
#define XCVR_PKT_RAM_PACKET_RAM_1_527            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,527)
#define XCVR_PKT_RAM_PACKET_RAM_1_528            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,528)
#define XCVR_PKT_RAM_PACKET_RAM_1_529            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,529)
#define XCVR_PKT_RAM_PACKET_RAM_1_530            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,530)
#define XCVR_PKT_RAM_PACKET_RAM_1_531            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,531)
#define XCVR_PKT_RAM_PACKET_RAM_1_532            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,532)
#define XCVR_PKT_RAM_PACKET_RAM_1_533            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,533)
#define XCVR_PKT_RAM_PACKET_RAM_1_534            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,534)
#define XCVR_PKT_RAM_PACKET_RAM_1_535            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,535)
#define XCVR_PKT_RAM_PACKET_RAM_1_536            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,536)
#define XCVR_PKT_RAM_PACKET_RAM_1_537            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,537)
#define XCVR_PKT_RAM_PACKET_RAM_1_538            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,538)
#define XCVR_PKT_RAM_PACKET_RAM_1_539            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,539)
#define XCVR_PKT_RAM_PACKET_RAM_1_540            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,540)
#define XCVR_PKT_RAM_PACKET_RAM_1_541            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,541)
#define XCVR_PKT_RAM_PACKET_RAM_1_542            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,542)
#define XCVR_PKT_RAM_PACKET_RAM_1_543            XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,543)

/* XCVR_PKT_RAM - Register array accessors */
#define XCVR_PKT_RAM_PACKET_RAM_0(index)         XCVR_PKT_RAM_PACKET_RAM_0_REG(XCVR_PKT_RAM_BASE_PTR,index)
#define XCVR_PKT_RAM_PACKET_RAM_1(index)         XCVR_PKT_RAM_PACKET_RAM_1_REG(XCVR_PKT_RAM_BASE_PTR,index)

/*!
 * @}
 */ /* end of group XCVR_PKT_RAM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group XCVR_PKT_RAM_Peripheral */


/* ----------------------------------------------------------------------------
   -- XCVR_PLL_DIG
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PLL_DIG_Peripheral XCVR_PLL_DIG
 * @{
 */

/** XCVR_PLL_DIG - Peripheral register structure */
typedef struct XCVR_PLL_DIG_MemMap {
  uint32_t PLL_HPM_BUMP;                           /**< PLL HPM Analog Bump Control, offset: 0x0 */
  uint32_t MOD_CTRL;                               /**< PLL Modulation Control, offset: 0x4 */
  uint32_t CHAN_MAP;                               /**< PLL Channel Mapping, offset: 0x8 */
  uint32_t LOCK_DETECT;                            /**< PLL Lock Detect Control, offset: 0xC */
  uint32_t HPM_CTRL;                               /**< PLL High Port Modulator Control, offset: 0x10 */
  uint32_t HPMCAL_CTRL;                            /**< PLL High Port Calibration Control, offset: 0x14 */
  uint32_t HPM_CAL1;                               /**< PLL High Port Calibration Result 1, offset: 0x18 */
  uint32_t HPM_CAL2;                               /**< PLL High Port Calibration Result 2, offset: 0x1C */
  uint32_t HPM_SDM_RES;                            /**< PLL High Port Sigma Delta Results, offset: 0x20 */
  uint32_t LPM_CTRL;                               /**< PLL Low Port Modulator Control, offset: 0x24 */
  uint32_t LPM_SDM_CTRL1;                          /**< PLL Low Port Sigma Delta Control 1, offset: 0x28 */
  uint32_t LPM_SDM_CTRL2;                          /**< PLL Low Port Sigma Delta Control 2, offset: 0x2C */
  uint32_t LPM_SDM_CTRL3;                          /**< PLL Low Port Sigma Delta Control 3, offset: 0x30 */
  uint32_t LPM_SDM_RES1;                           /**< PLL Low Port Sigma Delta Result 1, offset: 0x34 */
  uint32_t LPM_SDM_RES2;                           /**< PLL Low Port Sigma Delta Result 2, offset: 0x38 */
  uint32_t DELAY_MATCH;                            /**< PLL Delay Matching, offset: 0x3C */
  uint32_t CTUNE_CTRL;                             /**< PLL Coarse Tune Control, offset: 0x40 */
  uint32_t CTUNE_CNT6;                             /**< PLL Coarse Tune Count 6, offset: 0x44 */
  uint32_t CTUNE_CNT5_4;                           /**< PLL Coarse Tune Counts 5 and 4, offset: 0x48 */
  uint32_t CTUNE_CNT3_2;                           /**< PLL Coarse Tune Counts 3 and 2, offset: 0x4C */
  uint32_t CTUNE_CNT1_0;                           /**< PLL Coarse Tune Counts 1 and 0, offset: 0x50 */
  uint32_t CTUNE_RES;                              /**< PLL Coarse Tune Results, offset: 0x54 */
} volatile *XCVR_PLL_DIG_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- XCVR_PLL_DIG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PLL_DIG_Register_Accessor_Macros XCVR_PLL_DIG - Register accessor macros
 * @{
 */


/* XCVR_PLL_DIG - Register accessors */
#define XCVR_PLL_DIG_PLL_HPM_BUMP_REG(base)      ((base)->PLL_HPM_BUMP)
#define XCVR_PLL_DIG_MOD_CTRL_REG(base)          ((base)->MOD_CTRL)
#define XCVR_PLL_DIG_CHAN_MAP_REG(base)          ((base)->CHAN_MAP)
#define XCVR_PLL_DIG_LOCK_DETECT_REG(base)       ((base)->LOCK_DETECT)
#define XCVR_PLL_DIG_HPM_CTRL_REG(base)          ((base)->HPM_CTRL)
#define XCVR_PLL_DIG_HPMCAL_CTRL_REG(base)       ((base)->HPMCAL_CTRL)
#define XCVR_PLL_DIG_HPM_CAL1_REG(base)          ((base)->HPM_CAL1)
#define XCVR_PLL_DIG_HPM_CAL2_REG(base)          ((base)->HPM_CAL2)
#define XCVR_PLL_DIG_HPM_SDM_RES_REG(base)       ((base)->HPM_SDM_RES)
#define XCVR_PLL_DIG_LPM_CTRL_REG(base)          ((base)->LPM_CTRL)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_REG(base)     ((base)->LPM_SDM_CTRL1)
#define XCVR_PLL_DIG_LPM_SDM_CTRL2_REG(base)     ((base)->LPM_SDM_CTRL2)
#define XCVR_PLL_DIG_LPM_SDM_CTRL3_REG(base)     ((base)->LPM_SDM_CTRL3)
#define XCVR_PLL_DIG_LPM_SDM_RES1_REG(base)      ((base)->LPM_SDM_RES1)
#define XCVR_PLL_DIG_LPM_SDM_RES2_REG(base)      ((base)->LPM_SDM_RES2)
#define XCVR_PLL_DIG_DELAY_MATCH_REG(base)       ((base)->DELAY_MATCH)
#define XCVR_PLL_DIG_CTUNE_CTRL_REG(base)        ((base)->CTUNE_CTRL)
#define XCVR_PLL_DIG_CTUNE_CNT6_REG(base)        ((base)->CTUNE_CNT6)
#define XCVR_PLL_DIG_CTUNE_CNT5_4_REG(base)      ((base)->CTUNE_CNT5_4)
#define XCVR_PLL_DIG_CTUNE_CNT3_2_REG(base)      ((base)->CTUNE_CNT3_2)
#define XCVR_PLL_DIG_CTUNE_CNT1_0_REG(base)      ((base)->CTUNE_CNT1_0)
#define XCVR_PLL_DIG_CTUNE_RES_REG(base)         ((base)->CTUNE_RES)

/*!
 * @}
 */ /* end of group XCVR_PLL_DIG_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- XCVR_PLL_DIG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PLL_DIG_Register_Masks XCVR_PLL_DIG Register Masks
 * @{
 */

/*! @name PLL_HPM_BUMP - PLL HPM Analog Bump Control */
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_VCM_TX_MASK (0x7U)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_VCM_TX_SHIFT (0U)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_VCM_TX(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_VCM_TX_SHIFT)) & XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_VCM_TX_MASK)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_VCM_CAL_MASK (0x70U)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_VCM_CAL_SHIFT (4U)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_VCM_CAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_VCM_CAL_SHIFT)) & XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_VCM_CAL_MASK)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_FDB_RES_TX_MASK (0x300U)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_FDB_RES_TX_SHIFT (8U)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_FDB_RES_TX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_FDB_RES_TX_SHIFT)) & XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_FDB_RES_TX_MASK)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_FDB_RES_CAL_MASK (0x3000U)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_FDB_RES_CAL_SHIFT (12U)
#define XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_FDB_RES_CAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_FDB_RES_CAL_SHIFT)) & XCVR_PLL_DIG_PLL_HPM_BUMP_HPM_FDB_RES_CAL_MASK)

/*! @name MOD_CTRL - PLL Modulation Control */
#define XCVR_PLL_DIG_MOD_CTRL_MODULATION_WORD_MANUAL_MASK (0x1FFFU)
#define XCVR_PLL_DIG_MOD_CTRL_MODULATION_WORD_MANUAL_SHIFT (0U)
#define XCVR_PLL_DIG_MOD_CTRL_MODULATION_WORD_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_MOD_CTRL_MODULATION_WORD_MANUAL_SHIFT)) & XCVR_PLL_DIG_MOD_CTRL_MODULATION_WORD_MANUAL_MASK)
#define XCVR_PLL_DIG_MOD_CTRL_MOD_DISABLE_MASK   (0x8000U)
#define XCVR_PLL_DIG_MOD_CTRL_MOD_DISABLE_SHIFT  (15U)
#define XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_MANUAL_MASK (0xFF0000U)
#define XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_MANUAL_SHIFT (16U)
#define XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_MANUAL(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_MANUAL_SHIFT)) & XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_MANUAL_MASK)
#define XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_DISABLE_MASK (0x8000000U)
#define XCVR_PLL_DIG_MOD_CTRL_HPM_MOD_DISABLE_SHIFT (27U)
#define XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_MANUAL_MASK (0x30000000U)
#define XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_MANUAL_SHIFT (28U)
#define XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_MANUAL_SHIFT)) & XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_MANUAL_MASK)
#define XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_DISABLE_MASK (0x80000000U)
#define XCVR_PLL_DIG_MOD_CTRL_HPM_SDM_OUT_DISABLE_SHIFT (31U)

/*! @name CHAN_MAP - PLL Channel Mapping */
#define XCVR_PLL_DIG_CHAN_MAP_CHANNEL_NUM_MASK   (0x7FU)
#define XCVR_PLL_DIG_CHAN_MAP_CHANNEL_NUM_SHIFT  (0U)
#define XCVR_PLL_DIG_CHAN_MAP_CHANNEL_NUM(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CHAN_MAP_CHANNEL_NUM_SHIFT)) & XCVR_PLL_DIG_CHAN_MAP_CHANNEL_NUM_MASK)
#define XCVR_PLL_DIG_CHAN_MAP_BOC_MASK           (0x100U)
#define XCVR_PLL_DIG_CHAN_MAP_BOC_SHIFT          (8U)
#define XCVR_PLL_DIG_CHAN_MAP_BMR_MASK           (0x200U)
#define XCVR_PLL_DIG_CHAN_MAP_BMR_SHIFT          (9U)
#define XCVR_PLL_DIG_CHAN_MAP_ZOC_MASK           (0x400U)
#define XCVR_PLL_DIG_CHAN_MAP_ZOC_SHIFT          (10U)

/*! @name LOCK_DETECT - PLL Lock Detect Control */
#define XCVR_PLL_DIG_LOCK_DETECT_CT_FAIL_MASK    (0x1U)
#define XCVR_PLL_DIG_LOCK_DETECT_CT_FAIL_SHIFT   (0U)
#define XCVR_PLL_DIG_LOCK_DETECT_CTFF_MASK       (0x2U)
#define XCVR_PLL_DIG_LOCK_DETECT_CTFF_SHIFT      (1U)
#define XCVR_PLL_DIG_LOCK_DETECT_CS_FAIL_MASK    (0x4U)
#define XCVR_PLL_DIG_LOCK_DETECT_CS_FAIL_SHIFT   (2U)
#define XCVR_PLL_DIG_LOCK_DETECT_CSFF_MASK       (0x8U)
#define XCVR_PLL_DIG_LOCK_DETECT_CSFF_SHIFT      (3U)
#define XCVR_PLL_DIG_LOCK_DETECT_FT_FAIL_MASK    (0x10U)
#define XCVR_PLL_DIG_LOCK_DETECT_FT_FAIL_SHIFT   (4U)
#define XCVR_PLL_DIG_LOCK_DETECT_FTFF_MASK       (0x20U)
#define XCVR_PLL_DIG_LOCK_DETECT_FTFF_SHIFT      (5U)
#define XCVR_PLL_DIG_LOCK_DETECT_TAFF_MASK       (0x80U)
#define XCVR_PLL_DIG_LOCK_DETECT_TAFF_SHIFT      (7U)
#define XCVR_PLL_DIG_LOCK_DETECT_CTUNE_LDF_LEV_MASK (0xF00U)
#define XCVR_PLL_DIG_LOCK_DETECT_CTUNE_LDF_LEV_SHIFT (8U)
#define XCVR_PLL_DIG_LOCK_DETECT_CTUNE_LDF_LEV(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LOCK_DETECT_CTUNE_LDF_LEV_SHIFT)) & XCVR_PLL_DIG_LOCK_DETECT_CTUNE_LDF_LEV_MASK)
#define XCVR_PLL_DIG_LOCK_DETECT_FTF_RX_THRSH_MASK (0x3F000U)
#define XCVR_PLL_DIG_LOCK_DETECT_FTF_RX_THRSH_SHIFT (12U)
#define XCVR_PLL_DIG_LOCK_DETECT_FTF_RX_THRSH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LOCK_DETECT_FTF_RX_THRSH_SHIFT)) & XCVR_PLL_DIG_LOCK_DETECT_FTF_RX_THRSH_MASK)
#define XCVR_PLL_DIG_LOCK_DETECT_FTW_RX_MASK     (0x80000U)
#define XCVR_PLL_DIG_LOCK_DETECT_FTW_RX_SHIFT    (19U)
#define XCVR_PLL_DIG_LOCK_DETECT_FTF_TX_THRSH_MASK (0x3F00000U)
#define XCVR_PLL_DIG_LOCK_DETECT_FTF_TX_THRSH_SHIFT (20U)
#define XCVR_PLL_DIG_LOCK_DETECT_FTF_TX_THRSH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LOCK_DETECT_FTF_TX_THRSH_SHIFT)) & XCVR_PLL_DIG_LOCK_DETECT_FTF_TX_THRSH_MASK)
#define XCVR_PLL_DIG_LOCK_DETECT_FTW_TX_MASK     (0x8000000U)
#define XCVR_PLL_DIG_LOCK_DETECT_FTW_TX_SHIFT    (27U)
#define XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_GO_MASK (0x10000000U)
#define XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_GO_SHIFT (28U)
#define XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_FINISHED_MASK (0x20000000U)
#define XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_FINISHED_SHIFT (29U)
#define XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME_MASK (0xC0000000U)
#define XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME_SHIFT (30U)
#define XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME_SHIFT)) & XCVR_PLL_DIG_LOCK_DETECT_FREQ_COUNT_TIME_MASK)

/*! @name HPM_CTRL - PLL High Port Modulator Control */
#define XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_MANUAL_MASK (0x3FFU)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_MANUAL_SHIFT (0U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_MANUAL_SHIFT)) & XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_MANUAL_MASK)
#define XCVR_PLL_DIG_HPM_CTRL_HPFF_MASK          (0x2000U)
#define XCVR_PLL_DIG_HPM_CTRL_HPFF_SHIFT         (13U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_OUT_INVERT_MASK (0x4000U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_OUT_INVERT_SHIFT (14U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_DISABLE_MASK (0x8000U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_SDM_IN_DISABLE_SHIFT (15U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_MASK (0x70000U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_SHIFT (16U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_SHIFT)) & XCVR_PLL_DIG_HPM_CTRL_HPM_LFSR_SIZE_MASK)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_DTH_SCL_MASK   (0x100000U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_DTH_SCL_SHIFT  (20U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_DTH_EN_MASK    (0x800000U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_DTH_EN_SHIFT   (23U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_SCALE_MASK (0x3000000U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_SCALE_SHIFT (24U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_SCALE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_SCALE_SHIFT)) & XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_SCALE_MASK)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_INVERT_MASK (0x8000000U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_INTEGER_INVERT_SHIFT (27U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_CAL_INVERT_MASK (0x10000000U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_CAL_INVERT_SHIFT (28U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_MOD_IN_INVERT_MASK (0x80000000U)
#define XCVR_PLL_DIG_HPM_CTRL_HPM_MOD_IN_INVERT_SHIFT (31U)

/*! @name HPMCAL_CTRL - PLL High Port Calibration Control */
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_MASK (0x1FFFU)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_SHIFT (0U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_SHIFT)) & XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_MASK)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_NOT_BUMPED_MASK (0x2000U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_NOT_BUMPED_SHIFT (13U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_COUNT_SCALE_MASK (0x4000U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_COUNT_SCALE_SHIFT (14U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HP_CAL_DISABLE_MASK (0x8000U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HP_CAL_DISABLE_SHIFT (15U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_MANUAL_MASK (0x1FFF0000U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_MANUAL_SHIFT (16U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_MANUAL_SHIFT)) & XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_FACTOR_MANUAL_MASK)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_ARRAY_SIZE_MASK (0x40000000U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_ARRAY_SIZE_SHIFT (30U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_TIME_MASK (0x80000000U)
#define XCVR_PLL_DIG_HPMCAL_CTRL_HPM_CAL_TIME_SHIFT (31U)

/*! @name HPM_CAL1 - PLL High Port Calibration Result 1 */
#define XCVR_PLL_DIG_HPM_CAL1_HPM_COUNT_1_MASK   (0x7FFFFU)
#define XCVR_PLL_DIG_HPM_CAL1_HPM_COUNT_1_SHIFT  (0U)
#define XCVR_PLL_DIG_HPM_CAL1_HPM_COUNT_1(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_CAL1_HPM_COUNT_1_SHIFT)) & XCVR_PLL_DIG_HPM_CAL1_HPM_COUNT_1_MASK)
#define XCVR_PLL_DIG_HPM_CAL1_CS_WT_MASK         (0x700000U)
#define XCVR_PLL_DIG_HPM_CAL1_CS_WT_SHIFT        (20U)
#define XCVR_PLL_DIG_HPM_CAL1_CS_WT(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_CAL1_CS_WT_SHIFT)) & XCVR_PLL_DIG_HPM_CAL1_CS_WT_MASK)
#define XCVR_PLL_DIG_HPM_CAL1_CS_FW_MASK         (0x7000000U)
#define XCVR_PLL_DIG_HPM_CAL1_CS_FW_SHIFT        (24U)
#define XCVR_PLL_DIG_HPM_CAL1_CS_FW(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_CAL1_CS_FW_SHIFT)) & XCVR_PLL_DIG_HPM_CAL1_CS_FW_MASK)
#define XCVR_PLL_DIG_HPM_CAL1_CS_FCNT_MASK       (0xF0000000U)
#define XCVR_PLL_DIG_HPM_CAL1_CS_FCNT_SHIFT      (28U)
#define XCVR_PLL_DIG_HPM_CAL1_CS_FCNT(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_CAL1_CS_FCNT_SHIFT)) & XCVR_PLL_DIG_HPM_CAL1_CS_FCNT_MASK)

/*! @name HPM_CAL2 - PLL High Port Calibration Result 2 */
#define XCVR_PLL_DIG_HPM_CAL2_HPM_COUNT_2_MASK   (0x7FFFFU)
#define XCVR_PLL_DIG_HPM_CAL2_HPM_COUNT_2_SHIFT  (0U)
#define XCVR_PLL_DIG_HPM_CAL2_HPM_COUNT_2(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_CAL2_HPM_COUNT_2_SHIFT)) & XCVR_PLL_DIG_HPM_CAL2_HPM_COUNT_2_MASK)
#define XCVR_PLL_DIG_HPM_CAL2_CS_RC_MASK         (0x100000U)
#define XCVR_PLL_DIG_HPM_CAL2_CS_RC_SHIFT        (20U)
#define XCVR_PLL_DIG_HPM_CAL2_CS_FT_MASK         (0x1F000000U)
#define XCVR_PLL_DIG_HPM_CAL2_CS_FT_SHIFT        (24U)
#define XCVR_PLL_DIG_HPM_CAL2_CS_FT(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_CAL2_CS_FT_SHIFT)) & XCVR_PLL_DIG_HPM_CAL2_CS_FT_MASK)

/*! @name HPM_SDM_RES - PLL High Port Sigma Delta Results */
#define XCVR_PLL_DIG_HPM_SDM_RES_HPM_NUM_SELECTED_MASK (0x3FFU)
#define XCVR_PLL_DIG_HPM_SDM_RES_HPM_NUM_SELECTED_SHIFT (0U)
#define XCVR_PLL_DIG_HPM_SDM_RES_HPM_NUM_SELECTED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_SDM_RES_HPM_NUM_SELECTED_SHIFT)) & XCVR_PLL_DIG_HPM_SDM_RES_HPM_NUM_SELECTED_MASK)
#define XCVR_PLL_DIG_HPM_SDM_RES_HPM_DENOM_MASK  (0x3FF0000U)
#define XCVR_PLL_DIG_HPM_SDM_RES_HPM_DENOM_SHIFT (16U)
#define XCVR_PLL_DIG_HPM_SDM_RES_HPM_DENOM(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_SDM_RES_HPM_DENOM_SHIFT)) & XCVR_PLL_DIG_HPM_SDM_RES_HPM_DENOM_MASK)
#define XCVR_PLL_DIG_HPM_SDM_RES_HPM_COUNT_ADJUST_MASK (0xF0000000U)
#define XCVR_PLL_DIG_HPM_SDM_RES_HPM_COUNT_ADJUST_SHIFT (28U)
#define XCVR_PLL_DIG_HPM_SDM_RES_HPM_COUNT_ADJUST(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_HPM_SDM_RES_HPM_COUNT_ADJUST_SHIFT)) & XCVR_PLL_DIG_HPM_SDM_RES_HPM_COUNT_ADJUST_MASK)

/*! @name LPM_CTRL - PLL Low Port Modulator Control */
#define XCVR_PLL_DIG_LPM_CTRL_PLL_LD_MANUAL_MASK (0x3FU)
#define XCVR_PLL_DIG_LPM_CTRL_PLL_LD_MANUAL_SHIFT (0U)
#define XCVR_PLL_DIG_LPM_CTRL_PLL_LD_MANUAL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LPM_CTRL_PLL_LD_MANUAL_SHIFT)) & XCVR_PLL_DIG_LPM_CTRL_PLL_LD_MANUAL_MASK)
#define XCVR_PLL_DIG_LPM_CTRL_PLL_LD_DISABLE_MASK (0x800U)
#define XCVR_PLL_DIG_LPM_CTRL_PLL_LD_DISABLE_SHIFT (11U)
#define XCVR_PLL_DIG_LPM_CTRL_LPFF_MASK          (0x2000U)
#define XCVR_PLL_DIG_LPM_CTRL_LPFF_SHIFT         (13U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_SDM_INV_MASK   (0x4000U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_SDM_INV_SHIFT  (14U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_DISABLE_MASK   (0x8000U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_DISABLE_SHIFT  (15U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_MASK   (0xF0000U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_SHIFT  (16U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_SHIFT)) & XCVR_PLL_DIG_LPM_CTRL_LPM_DTH_SCL_MASK)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_D_CTRL_MASK    (0x400000U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_D_CTRL_SHIFT   (22U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_D_OVRD_MASK    (0x800000U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_D_OVRD_SHIFT   (23U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_MASK     (0xF000000U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_SHIFT    (24U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_SHIFT)) & XCVR_PLL_DIG_LPM_CTRL_LPM_SCALE_MASK)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_SDM_USE_NEG_MASK (0x80000000U)
#define XCVR_PLL_DIG_LPM_CTRL_LPM_SDM_USE_NEG_SHIFT (31U)

/*! @name LPM_SDM_CTRL1 - PLL Low Port Sigma Delta Control 1 */
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_SELECTED_MASK (0x7FU)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_SELECTED_SHIFT (0U)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_SELECTED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_SELECTED_SHIFT)) & XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_SELECTED_MASK)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_HPM_ARRAY_BIAS_MASK (0x7F00U)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_HPM_ARRAY_BIAS_SHIFT (8U)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_HPM_ARRAY_BIAS(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LPM_SDM_CTRL1_HPM_ARRAY_BIAS_SHIFT)) & XCVR_PLL_DIG_LPM_SDM_CTRL1_HPM_ARRAY_BIAS_MASK)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_MASK (0x7F0000U)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_SHIFT (16U)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_SHIFT)) & XCVR_PLL_DIG_LPM_SDM_CTRL1_LPM_INTG_MASK)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_SDM_MAP_DISABLE_MASK (0x80000000U)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1_SDM_MAP_DISABLE_SHIFT (31U)

/*! @name LPM_SDM_CTRL2 - PLL Low Port Sigma Delta Control 2 */
#define XCVR_PLL_DIG_LPM_SDM_CTRL2_LPM_NUM_MASK  (0xFFFFFFFU)
#define XCVR_PLL_DIG_LPM_SDM_CTRL2_LPM_NUM_SHIFT (0U)
#define XCVR_PLL_DIG_LPM_SDM_CTRL2_LPM_NUM(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LPM_SDM_CTRL2_LPM_NUM_SHIFT)) & XCVR_PLL_DIG_LPM_SDM_CTRL2_LPM_NUM_MASK)

/*! @name LPM_SDM_CTRL3 - PLL Low Port Sigma Delta Control 3 */
#define XCVR_PLL_DIG_LPM_SDM_CTRL3_LPM_DENOM_MASK (0xFFFFFFFU)
#define XCVR_PLL_DIG_LPM_SDM_CTRL3_LPM_DENOM_SHIFT (0U)
#define XCVR_PLL_DIG_LPM_SDM_CTRL3_LPM_DENOM(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LPM_SDM_CTRL3_LPM_DENOM_SHIFT)) & XCVR_PLL_DIG_LPM_SDM_CTRL3_LPM_DENOM_MASK)

/*! @name LPM_SDM_RES1 - PLL Low Port Sigma Delta Result 1 */
#define XCVR_PLL_DIG_LPM_SDM_RES1_LPM_NUM_SELECTED_MASK (0xFFFFFFFU)
#define XCVR_PLL_DIG_LPM_SDM_RES1_LPM_NUM_SELECTED_SHIFT (0U)
#define XCVR_PLL_DIG_LPM_SDM_RES1_LPM_NUM_SELECTED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LPM_SDM_RES1_LPM_NUM_SELECTED_SHIFT)) & XCVR_PLL_DIG_LPM_SDM_RES1_LPM_NUM_SELECTED_MASK)

/*! @name LPM_SDM_RES2 - PLL Low Port Sigma Delta Result 2 */
#define XCVR_PLL_DIG_LPM_SDM_RES2_LPM_DENOM_SELECTED_MASK (0xFFFFFFFU)
#define XCVR_PLL_DIG_LPM_SDM_RES2_LPM_DENOM_SELECTED_SHIFT (0U)
#define XCVR_PLL_DIG_LPM_SDM_RES2_LPM_DENOM_SELECTED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_LPM_SDM_RES2_LPM_DENOM_SELECTED_SHIFT)) & XCVR_PLL_DIG_LPM_SDM_RES2_LPM_DENOM_SELECTED_MASK)

/*! @name DELAY_MATCH - PLL Delay Matching */
#define XCVR_PLL_DIG_DELAY_MATCH_LPM_SDM_DELAY_MASK (0xFU)
#define XCVR_PLL_DIG_DELAY_MATCH_LPM_SDM_DELAY_SHIFT (0U)
#define XCVR_PLL_DIG_DELAY_MATCH_LPM_SDM_DELAY(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_DELAY_MATCH_LPM_SDM_DELAY_SHIFT)) & XCVR_PLL_DIG_DELAY_MATCH_LPM_SDM_DELAY_MASK)
#define XCVR_PLL_DIG_DELAY_MATCH_HPM_SDM_DELAY_MASK (0xF00U)
#define XCVR_PLL_DIG_DELAY_MATCH_HPM_SDM_DELAY_SHIFT (8U)
#define XCVR_PLL_DIG_DELAY_MATCH_HPM_SDM_DELAY(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_DELAY_MATCH_HPM_SDM_DELAY_SHIFT)) & XCVR_PLL_DIG_DELAY_MATCH_HPM_SDM_DELAY_MASK)
#define XCVR_PLL_DIG_DELAY_MATCH_HPM_INTEGER_DELAY_MASK (0xF0000U)
#define XCVR_PLL_DIG_DELAY_MATCH_HPM_INTEGER_DELAY_SHIFT (16U)
#define XCVR_PLL_DIG_DELAY_MATCH_HPM_INTEGER_DELAY(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_DELAY_MATCH_HPM_INTEGER_DELAY_SHIFT)) & XCVR_PLL_DIG_DELAY_MATCH_HPM_INTEGER_DELAY_MASK)

/*! @name CTUNE_CTRL - PLL Coarse Tune Control */
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_MANUAL_MASK (0xFFFU)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_MANUAL_SHIFT (0U)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_MANUAL_SHIFT)) & XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_MANUAL_MASK)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_DISABLE_MASK (0x8000U)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_TARGET_DISABLE_SHIFT (15U)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_ADJUST_MASK (0xF0000U)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_ADJUST_SHIFT (16U)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_ADJUST(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_ADJUST_SHIFT)) & XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_ADJUST_MASK)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_MANUAL_MASK (0x7F000000U)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_MANUAL_SHIFT (24U)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_MANUAL(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_MANUAL_SHIFT)) & XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_MANUAL_MASK)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_DISABLE_MASK (0x80000000U)
#define XCVR_PLL_DIG_CTUNE_CTRL_CTUNE_DISABLE_SHIFT (31U)

/*! @name CTUNE_CNT6 - PLL Coarse Tune Count 6 */
#define XCVR_PLL_DIG_CTUNE_CNT6_CTUNE_COUNT_6_MASK (0x1FFFU)
#define XCVR_PLL_DIG_CTUNE_CNT6_CTUNE_COUNT_6_SHIFT (0U)
#define XCVR_PLL_DIG_CTUNE_CNT6_CTUNE_COUNT_6(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_CNT6_CTUNE_COUNT_6_SHIFT)) & XCVR_PLL_DIG_CTUNE_CNT6_CTUNE_COUNT_6_MASK)

/*! @name CTUNE_CNT5_4 - PLL Coarse Tune Counts 5 and 4 */
#define XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_4_MASK (0x1FFFU)
#define XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_4_SHIFT (0U)
#define XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_4(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_4_SHIFT)) & XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_4_MASK)
#define XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_5_MASK (0x1FFF0000U)
#define XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_5_SHIFT (16U)
#define XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_5(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_5_SHIFT)) & XCVR_PLL_DIG_CTUNE_CNT5_4_CTUNE_COUNT_5_MASK)

/*! @name CTUNE_CNT3_2 - PLL Coarse Tune Counts 3 and 2 */
#define XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_2_MASK (0x1FFFU)
#define XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_2_SHIFT (0U)
#define XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_2_SHIFT)) & XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_2_MASK)
#define XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_3_MASK (0x1FFF0000U)
#define XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_3_SHIFT (16U)
#define XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_3_SHIFT)) & XCVR_PLL_DIG_CTUNE_CNT3_2_CTUNE_COUNT_3_MASK)

/*! @name CTUNE_CNT1_0 - PLL Coarse Tune Counts 1 and 0 */
#define XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_0_MASK (0x1FFFU)
#define XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_0_SHIFT (0U)
#define XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_0_SHIFT)) & XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_0_MASK)
#define XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_1_MASK (0x1FFF0000U)
#define XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_1_SHIFT (16U)
#define XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_1_SHIFT)) & XCVR_PLL_DIG_CTUNE_CNT1_0_CTUNE_COUNT_1_MASK)

/*! @name CTUNE_RES - PLL Coarse Tune Results */
#define XCVR_PLL_DIG_CTUNE_RES_CTUNE_SELECTED_MASK (0x7FU)
#define XCVR_PLL_DIG_CTUNE_RES_CTUNE_SELECTED_SHIFT (0U)
#define XCVR_PLL_DIG_CTUNE_RES_CTUNE_SELECTED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_RES_CTUNE_SELECTED_SHIFT)) & XCVR_PLL_DIG_CTUNE_RES_CTUNE_SELECTED_MASK)
#define XCVR_PLL_DIG_CTUNE_RES_CTUNE_BEST_DIFF_MASK (0xFF00U)
#define XCVR_PLL_DIG_CTUNE_RES_CTUNE_BEST_DIFF_SHIFT (8U)
#define XCVR_PLL_DIG_CTUNE_RES_CTUNE_BEST_DIFF(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_RES_CTUNE_BEST_DIFF_SHIFT)) & XCVR_PLL_DIG_CTUNE_RES_CTUNE_BEST_DIFF_MASK)
#define XCVR_PLL_DIG_CTUNE_RES_CTUNE_FREQ_SELECTED_MASK (0xFFF0000U)
#define XCVR_PLL_DIG_CTUNE_RES_CTUNE_FREQ_SELECTED_SHIFT (16U)
#define XCVR_PLL_DIG_CTUNE_RES_CTUNE_FREQ_SELECTED(x) (((uint32_t)(((uint32_t)(x)) << XCVR_PLL_DIG_CTUNE_RES_CTUNE_FREQ_SELECTED_SHIFT)) & XCVR_PLL_DIG_CTUNE_RES_CTUNE_FREQ_SELECTED_MASK)


/*!
 * @}
 */ /* end of group XCVR_PLL_DIG_Register_Masks */


/* XCVR_PLL_DIG - Peripheral instance base addresses */
/** Peripheral PLL_DIG_REGS base pointer */
#define XCVR_PLL_DIG_BASE_PTR                    ((XCVR_PLL_DIG_MemMapPtr)0x4005C224u)
/** Array initializer of XCVR_PLL_DIG peripheral base pointers */
#define XCVR_PLL_DIG_BASE_PTRS                   { XCVR_PLL_DIG_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- XCVR_PLL_DIG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_PLL_DIG_Register_Accessor_Macros XCVR_PLL_DIG - Register accessor macros
 * @{
 */


/* XCVR_PLL_DIG - Register instance definitions */
/* PLL_DIG_REGS */
#define XCVR_PLL_DIG_PLL_HPM_BUMP                XCVR_PLL_DIG_PLL_HPM_BUMP_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_MOD_CTRL                    XCVR_PLL_DIG_MOD_CTRL_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_CHAN_MAP                    XCVR_PLL_DIG_CHAN_MAP_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_LOCK_DETECT                 XCVR_PLL_DIG_LOCK_DETECT_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_HPM_CTRL                    XCVR_PLL_DIG_HPM_CTRL_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_HPMCAL_CTRL                 XCVR_PLL_DIG_HPMCAL_CTRL_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_HPM_CAL1                    XCVR_PLL_DIG_HPM_CAL1_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_HPM_CAL2                    XCVR_PLL_DIG_HPM_CAL2_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_HPM_SDM_RES                 XCVR_PLL_DIG_HPM_SDM_RES_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_LPM_CTRL                    XCVR_PLL_DIG_LPM_CTRL_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_LPM_SDM_CTRL1               XCVR_PLL_DIG_LPM_SDM_CTRL1_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_LPM_SDM_CTRL2               XCVR_PLL_DIG_LPM_SDM_CTRL2_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_LPM_SDM_CTRL3               XCVR_PLL_DIG_LPM_SDM_CTRL3_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_LPM_SDM_RES1                XCVR_PLL_DIG_LPM_SDM_RES1_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_LPM_SDM_RES2                XCVR_PLL_DIG_LPM_SDM_RES2_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_DELAY_MATCH                 XCVR_PLL_DIG_DELAY_MATCH_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_CTUNE_CTRL                  XCVR_PLL_DIG_CTUNE_CTRL_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_CTUNE_CNT6                  XCVR_PLL_DIG_CTUNE_CNT6_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_CTUNE_CNT5_4                XCVR_PLL_DIG_CTUNE_CNT5_4_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_CTUNE_CNT3_2                XCVR_PLL_DIG_CTUNE_CNT3_2_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_CTUNE_CNT1_0                XCVR_PLL_DIG_CTUNE_CNT1_0_REG(XCVR_PLL_DIG_BASE_PTR)
#define XCVR_PLL_DIG_CTUNE_RES                   XCVR_PLL_DIG_CTUNE_RES_REG(XCVR_PLL_DIG_BASE_PTR)

/*!
 * @}
 */ /* end of group XCVR_PLL_DIG_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group XCVR_PLL_DIG_Peripheral */


/* ----------------------------------------------------------------------------
   -- XCVR_RX_DIG
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_RX_DIG_Peripheral XCVR_RX_DIG
 * @{
 */

/** XCVR_RX_DIG - Peripheral register structure */
typedef struct XCVR_RX_DIG_MemMap {
  uint32_t RX_DIG_CTRL;                            /**< RX Digital Control, offset: 0x0 */
  uint32_t AGC_CTRL_0;                             /**< AGC Control 0, offset: 0x4 */
  uint32_t AGC_CTRL_1;                             /**< AGC Control 1, offset: 0x8 */
  uint32_t AGC_CTRL_2;                             /**< AGC Control 2, offset: 0xC */
  uint32_t AGC_CTRL_3;                             /**< AGC Control 3, offset: 0x10 */
  uint32_t AGC_STAT;                               /**< AGC Status, offset: 0x14 */
  uint32_t RSSI_CTRL_0;                            /**< RSSI Control 0, offset: 0x18 */
  uint32_t RSSI_CTRL_1;                            /**< RSSI Control 1, offset: 0x1C */
  uint32_t RSSI_DFT;                               /**< RSSI DFT, offset: 0x20 */
  uint32_t DCOC_CTRL_0;                            /**< DCOC Control 0, offset: 0x24 */
  uint32_t DCOC_CTRL_1;                            /**< DCOC Control 1, offset: 0x28 */
  uint32_t DCOC_DAC_INIT;                          /**< DCOC DAC Initialization, offset: 0x2C */
  uint32_t DCOC_DIG_MAN;                           /**< DCOC Digital Correction Manual Override, offset: 0x30 */
  uint32_t DCOC_CAL_GAIN;                          /**< DCOC Calibration Gain, offset: 0x34 */
  uint32_t DCOC_STAT;                              /**< DCOC Status, offset: 0x38 */
  uint32_t DCOC_DC_EST;                            /**< DCOC DC Estimate, offset: 0x3C */
  uint32_t DCOC_CAL_RCP;                           /**< DCOC Calibration Reciprocals, offset: 0x40 */
  uint8_t RESERVED_0[4];
  uint32_t IQMC_CTRL;                              /**< IQMC Control, offset: 0x48 */
  uint32_t IQMC_CAL;                               /**< IQMC Calibration, offset: 0x4C */
  uint32_t LNA_GAIN_VAL_3_0;                       /**< LNA_GAIN Step Values 3..0, offset: 0x50 */
  uint32_t LNA_GAIN_VAL_7_4;                       /**< LNA_GAIN Step Values 7..4, offset: 0x54 */
  uint32_t LNA_GAIN_VAL_8;                         /**< LNA_GAIN Step Values 8, offset: 0x58 */
  uint32_t BBA_RES_TUNE_VAL_7_0;                   /**< BBA Resistor Tune Values 7..0, offset: 0x5C */
  uint32_t BBA_RES_TUNE_VAL_10_8;                  /**< BBA Resistor Tune Values 10..8, offset: 0x60 */
  uint32_t LNA_GAIN_LIN_VAL_2_0;                   /**< LNA Linear Gain Values 2..0, offset: 0x64 */
  uint32_t LNA_GAIN_LIN_VAL_5_3;                   /**< LNA Linear Gain Values 5..3, offset: 0x68 */
  uint32_t LNA_GAIN_LIN_VAL_8_6;                   /**< LNA Linear Gain Values 8..6, offset: 0x6C */
  uint32_t LNA_GAIN_LIN_VAL_9;                     /**< LNA Linear Gain Values 9, offset: 0x70 */
  uint32_t BBA_RES_TUNE_LIN_VAL_3_0;               /**< BBA Resistor Tune Values 3..0, offset: 0x74 */
  uint32_t BBA_RES_TUNE_LIN_VAL_7_4;               /**< BBA Resistor Tune Values 7..4, offset: 0x78 */
  uint32_t BBA_RES_TUNE_LIN_VAL_10_8;              /**< BBA Resistor Tune Values 10..8, offset: 0x7C */
  uint32_t AGC_GAIN_TBL_03_00;                     /**< AGC Gain Tables Step 03..00, offset: 0x80 */
  uint32_t AGC_GAIN_TBL_07_04;                     /**< AGC Gain Tables Step 07..04, offset: 0x84 */
  uint32_t AGC_GAIN_TBL_11_08;                     /**< AGC Gain Tables Step 11..08, offset: 0x88 */
  uint32_t AGC_GAIN_TBL_15_12;                     /**< AGC Gain Tables Step 15..12, offset: 0x8C */
  uint32_t AGC_GAIN_TBL_19_16;                     /**< AGC Gain Tables Step 19..16, offset: 0x90 */
  uint32_t AGC_GAIN_TBL_23_20;                     /**< AGC Gain Tables Step 23..20, offset: 0x94 */
  uint32_t AGC_GAIN_TBL_26_24;                     /**< AGC Gain Tables Step 26..24, offset: 0x98 */
  uint8_t RESERVED_1[4];
  uint32_t DCOC_OFFSET[27];                        /**< DCOC Offset, array offset: 0xA0, array step: 0x4 */
  uint32_t DCOC_BBA_STEP;                          /**< DCOC BBA DAC Step, offset: 0x10C */
  uint32_t DCOC_TZA_STEP_0;                        /**< DCOC TZA DAC Step 0, offset: 0x110 */
  uint32_t DCOC_TZA_STEP_1;                        /**< DCOC TZA DAC Step 1, offset: 0x114 */
  uint32_t DCOC_TZA_STEP_2;                        /**< DCOC TZA DAC Step 2, offset: 0x118 */
  uint32_t DCOC_TZA_STEP_3;                        /**< DCOC TZA DAC Step 3, offset: 0x11C */
  uint32_t DCOC_TZA_STEP_4;                        /**< DCOC TZA DAC Step 4, offset: 0x120 */
  uint32_t DCOC_TZA_STEP_5;                        /**< DCOC TZA DAC Step 5, offset: 0x124 */
  uint32_t DCOC_TZA_STEP_6;                        /**< DCOC TZA DAC Step 6, offset: 0x128 */
  uint32_t DCOC_TZA_STEP_7;                        /**< DCOC TZA DAC Step 7, offset: 0x12C */
  uint32_t DCOC_TZA_STEP_8;                        /**< DCOC TZA DAC Step 5, offset: 0x130 */
  uint32_t DCOC_TZA_STEP_9;                        /**< DCOC TZA DAC Step 9, offset: 0x134 */
  uint32_t DCOC_TZA_STEP_10;                       /**< DCOC TZA DAC Step 10, offset: 0x138 */
  uint8_t RESERVED_2[44];
  uint32_t DCOC_CAL_ALPHA;                         /**< DCOC Calibration Alpha, offset: 0x168 */
  uint32_t DCOC_CAL_BETA_Q;                        /**< DCOC Calibration Beta Q, offset: 0x16C */
  uint32_t DCOC_CAL_BETA_I;                        /**< DCOC Calibration Beta I, offset: 0x170 */
  uint32_t DCOC_CAL_GAMMA;                         /**< DCOC Calibration Gamma, offset: 0x174 */
  uint32_t DCOC_CAL_IIR;                           /**< DCOC Calibration IIR, offset: 0x178 */
  uint8_t RESERVED_3[4];
  uint32_t DCOC_CAL[3];                            /**< DCOC Calibration Result, array offset: 0x180, array step: 0x4 */
  uint8_t RESERVED_4[4];
  uint32_t CCA_ED_LQI_CTRL_0;                      /**< RX_DIG CCA ED LQI Control Register 0, offset: 0x190 */
  uint32_t CCA_ED_LQI_CTRL_1;                      /**< RX_DIG CCA ED LQI Control Register 1, offset: 0x194 */
  uint32_t CCA_ED_LQI_STAT_0;                      /**< RX_DIG CCA ED LQI Status Register 0, offset: 0x198 */
  uint32_t CCA_ED_LQI_STAT_1;                      /**< RX_DIG CCA ED LQI Status Register 1, offset: 0x19C */
  uint32_t RX_CHF_COEF_0;                          /**< Receive Channel Filter Coefficient 0, offset: 0x1A0 */
  uint32_t RX_CHF_COEF_1;                          /**< Receive Channel Filter Coefficient 1, offset: 0x1A4 */
  uint32_t RX_CHF_COEF_2;                          /**< Receive Channel Filter Coefficient 2, offset: 0x1A8 */
  uint32_t RX_CHF_COEF_3;                          /**< Receive Channel Filter Coefficient 3, offset: 0x1AC */
  uint32_t RX_CHF_COEF_4;                          /**< Receive Channel Filter Coefficient 4, offset: 0x1B0 */
  uint32_t RX_CHF_COEF_5;                          /**< Receive Channel Filter Coefficient 5, offset: 0x1B4 */
  uint32_t RX_CHF_COEF_6;                          /**< Receive Channel Filter Coefficient 6, offset: 0x1B8 */
  uint32_t RX_CHF_COEF_7;                          /**< Receive Channel Filter Coefficient 7, offset: 0x1BC */
  uint32_t RX_CHF_COEF_8;                          /**< Receive Channel Filter Coefficient 8, offset: 0x1C0 */
  uint32_t RX_CHF_COEF_9;                          /**< Receive Channel Filter Coefficient 9, offset: 0x1C4 */
  uint32_t RX_CHF_COEF_10;                         /**< Receive Channel Filter Coefficient 10, offset: 0x1C8 */
  uint32_t RX_CHF_COEF_11;                         /**< Receive Channel Filter Coefficient 11, offset: 0x1CC */
  uint32_t AGC_MAN_AGC_IDX;                        /**< AGC Manual AGC Index, offset: 0x1D0 */
  uint32_t DC_RESID_CTRL;                          /**< DC Residual Control, offset: 0x1D4 */
  uint32_t DC_RESID_EST;                           /**< DC Residual Estimate, offset: 0x1D8 */
  uint32_t RX_RCCAL_CTRL0;                         /**< RX RC Calibration Control0, offset: 0x1DC */
  uint32_t RX_RCCAL_CTRL1;                         /**< RX RC Calibration Control1, offset: 0x1E0 */
  uint32_t RX_RCCAL_STAT;                          /**< RX RC Calibration Status, offset: 0x1E4 */
  uint32_t AUXPLL_FCAL_CTRL;                       /**< Aux PLL Frequency Calibration Control, offset: 0x1E8 */
  uint32_t AUXPLL_FCAL_CNT6;                       /**< Aux PLL Frequency Calibration Count 6, offset: 0x1EC */
  uint32_t AUXPLL_FCAL_CNT5_4;                     /**< Aux PLL Frequency Calibration Count 5 and 4, offset: 0x1F0 */
  uint32_t AUXPLL_FCAL_CNT3_2;                     /**< Aux PLL Frequency Calibration Count 3 and 2, offset: 0x1F4 */
  uint32_t AUXPLL_FCAL_CNT1_0;                     /**< Aux PLL Frequency Calibration Count 1 and 0, offset: 0x1F8 */
  uint32_t RXDIG_DFT;                              /**< RXDIG DFT, offset: 0x1FC */
} volatile *XCVR_RX_DIG_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- XCVR_RX_DIG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_RX_DIG_Register_Accessor_Macros XCVR_RX_DIG - Register accessor macros
 * @{
 */


/* XCVR_RX_DIG - Register accessors */
#define XCVR_RX_DIG_RX_DIG_CTRL_REG(base)        ((base)->RX_DIG_CTRL)
#define XCVR_RX_DIG_AGC_CTRL_0_REG(base)         ((base)->AGC_CTRL_0)
#define XCVR_RX_DIG_AGC_CTRL_1_REG(base)         ((base)->AGC_CTRL_1)
#define XCVR_RX_DIG_AGC_CTRL_2_REG(base)         ((base)->AGC_CTRL_2)
#define XCVR_RX_DIG_AGC_CTRL_3_REG(base)         ((base)->AGC_CTRL_3)
#define XCVR_RX_DIG_AGC_STAT_REG(base)           ((base)->AGC_STAT)
#define XCVR_RX_DIG_RSSI_CTRL_0_REG(base)        ((base)->RSSI_CTRL_0)
#define XCVR_RX_DIG_RSSI_CTRL_1_REG(base)        ((base)->RSSI_CTRL_1)
#define XCVR_RX_DIG_RSSI_DFT_REG(base)           ((base)->RSSI_DFT)
#define XCVR_RX_DIG_DCOC_CTRL_0_REG(base)        ((base)->DCOC_CTRL_0)
#define XCVR_RX_DIG_DCOC_CTRL_1_REG(base)        ((base)->DCOC_CTRL_1)
#define XCVR_RX_DIG_DCOC_DAC_INIT_REG(base)      ((base)->DCOC_DAC_INIT)
#define XCVR_RX_DIG_DCOC_DIG_MAN_REG(base)       ((base)->DCOC_DIG_MAN)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_REG(base)      ((base)->DCOC_CAL_GAIN)
#define XCVR_RX_DIG_DCOC_STAT_REG(base)          ((base)->DCOC_STAT)
#define XCVR_RX_DIG_DCOC_DC_EST_REG(base)        ((base)->DCOC_DC_EST)
#define XCVR_RX_DIG_DCOC_CAL_RCP_REG(base)       ((base)->DCOC_CAL_RCP)
#define XCVR_RX_DIG_IQMC_CTRL_REG(base)          ((base)->IQMC_CTRL)
#define XCVR_RX_DIG_IQMC_CAL_REG(base)           ((base)->IQMC_CAL)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_REG(base)   ((base)->LNA_GAIN_VAL_3_0)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_REG(base)   ((base)->LNA_GAIN_VAL_7_4)
#define XCVR_RX_DIG_LNA_GAIN_VAL_8_REG(base)     ((base)->LNA_GAIN_VAL_8)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_REG(base) ((base)->BBA_RES_TUNE_VAL_7_0)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_REG(base) ((base)->BBA_RES_TUNE_VAL_10_8)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_REG(base) ((base)->LNA_GAIN_LIN_VAL_2_0)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_REG(base) ((base)->LNA_GAIN_LIN_VAL_5_3)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_REG(base) ((base)->LNA_GAIN_LIN_VAL_8_6)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_9_REG(base) ((base)->LNA_GAIN_LIN_VAL_9)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_REG(base) ((base)->BBA_RES_TUNE_LIN_VAL_3_0)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_REG(base) ((base)->BBA_RES_TUNE_LIN_VAL_7_4)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_REG(base) ((base)->BBA_RES_TUNE_LIN_VAL_10_8)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_REG(base) ((base)->AGC_GAIN_TBL_03_00)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_REG(base) ((base)->AGC_GAIN_TBL_07_04)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_REG(base) ((base)->AGC_GAIN_TBL_11_08)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_REG(base) ((base)->AGC_GAIN_TBL_15_12)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_REG(base) ((base)->AGC_GAIN_TBL_19_16)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_REG(base) ((base)->AGC_GAIN_TBL_23_20)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_REG(base) ((base)->AGC_GAIN_TBL_26_24)
#define XCVR_RX_DIG_DCOC_OFFSET_REG(base,index)  ((base)->DCOC_OFFSET[index])
#define XCVR_RX_DIG_DCOC_BBA_STEP_REG(base)      ((base)->DCOC_BBA_STEP)
#define XCVR_RX_DIG_DCOC_TZA_STEP_0_REG(base)    ((base)->DCOC_TZA_STEP_0)
#define XCVR_RX_DIG_DCOC_TZA_STEP_1_REG(base)    ((base)->DCOC_TZA_STEP_1)
#define XCVR_RX_DIG_DCOC_TZA_STEP_2_REG(base)    ((base)->DCOC_TZA_STEP_2)
#define XCVR_RX_DIG_DCOC_TZA_STEP_3_REG(base)    ((base)->DCOC_TZA_STEP_3)
#define XCVR_RX_DIG_DCOC_TZA_STEP_4_REG(base)    ((base)->DCOC_TZA_STEP_4)
#define XCVR_RX_DIG_DCOC_TZA_STEP_5_REG(base)    ((base)->DCOC_TZA_STEP_5)
#define XCVR_RX_DIG_DCOC_TZA_STEP_6_REG(base)    ((base)->DCOC_TZA_STEP_6)
#define XCVR_RX_DIG_DCOC_TZA_STEP_7_REG(base)    ((base)->DCOC_TZA_STEP_7)
#define XCVR_RX_DIG_DCOC_TZA_STEP_8_REG(base)    ((base)->DCOC_TZA_STEP_8)
#define XCVR_RX_DIG_DCOC_TZA_STEP_9_REG(base)    ((base)->DCOC_TZA_STEP_9)
#define XCVR_RX_DIG_DCOC_TZA_STEP_10_REG(base)   ((base)->DCOC_TZA_STEP_10)
#define XCVR_RX_DIG_DCOC_CAL_ALPHA_REG(base)     ((base)->DCOC_CAL_ALPHA)
#define XCVR_RX_DIG_DCOC_CAL_BETA_Q_REG(base)    ((base)->DCOC_CAL_BETA_Q)
#define XCVR_RX_DIG_DCOC_CAL_BETA_I_REG(base)    ((base)->DCOC_CAL_BETA_I)
#define XCVR_RX_DIG_DCOC_CAL_GAMMA_REG(base)     ((base)->DCOC_CAL_GAMMA)
#define XCVR_RX_DIG_DCOC_CAL_IIR_REG(base)       ((base)->DCOC_CAL_IIR)
#define XCVR_RX_DIG_DCOC_CAL_REG(base,index)     ((base)->DCOC_CAL[index])
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_REG(base)  ((base)->CCA_ED_LQI_CTRL_0)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_REG(base)  ((base)->CCA_ED_LQI_CTRL_1)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_REG(base)  ((base)->CCA_ED_LQI_STAT_0)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1_REG(base)  ((base)->CCA_ED_LQI_STAT_1)
#define XCVR_RX_DIG_RX_CHF_COEF_0_REG(base)      ((base)->RX_CHF_COEF_0)
#define XCVR_RX_DIG_RX_CHF_COEF_1_REG(base)      ((base)->RX_CHF_COEF_1)
#define XCVR_RX_DIG_RX_CHF_COEF_2_REG(base)      ((base)->RX_CHF_COEF_2)
#define XCVR_RX_DIG_RX_CHF_COEF_3_REG(base)      ((base)->RX_CHF_COEF_3)
#define XCVR_RX_DIG_RX_CHF_COEF_4_REG(base)      ((base)->RX_CHF_COEF_4)
#define XCVR_RX_DIG_RX_CHF_COEF_5_REG(base)      ((base)->RX_CHF_COEF_5)
#define XCVR_RX_DIG_RX_CHF_COEF_6_REG(base)      ((base)->RX_CHF_COEF_6)
#define XCVR_RX_DIG_RX_CHF_COEF_7_REG(base)      ((base)->RX_CHF_COEF_7)
#define XCVR_RX_DIG_RX_CHF_COEF_8_REG(base)      ((base)->RX_CHF_COEF_8)
#define XCVR_RX_DIG_RX_CHF_COEF_9_REG(base)      ((base)->RX_CHF_COEF_9)
#define XCVR_RX_DIG_RX_CHF_COEF_10_REG(base)     ((base)->RX_CHF_COEF_10)
#define XCVR_RX_DIG_RX_CHF_COEF_11_REG(base)     ((base)->RX_CHF_COEF_11)
#define XCVR_RX_DIG_AGC_MAN_AGC_IDX_REG(base)    ((base)->AGC_MAN_AGC_IDX)
#define XCVR_RX_DIG_DC_RESID_CTRL_REG(base)      ((base)->DC_RESID_CTRL)
#define XCVR_RX_DIG_DC_RESID_EST_REG(base)       ((base)->DC_RESID_EST)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_REG(base)     ((base)->RX_RCCAL_CTRL0)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_REG(base)     ((base)->RX_RCCAL_CTRL1)
#define XCVR_RX_DIG_RX_RCCAL_STAT_REG(base)      ((base)->RX_RCCAL_STAT)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_REG(base)   ((base)->AUXPLL_FCAL_CTRL)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT6_REG(base)   ((base)->AUXPLL_FCAL_CNT6)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_REG(base) ((base)->AUXPLL_FCAL_CNT5_4)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_REG(base) ((base)->AUXPLL_FCAL_CNT3_2)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_REG(base) ((base)->AUXPLL_FCAL_CNT1_0)
#define XCVR_RX_DIG_RXDIG_DFT_REG(base)          ((base)->RXDIG_DFT)

/*!
 * @}
 */ /* end of group XCVR_RX_DIG_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- XCVR_RX_DIG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_RX_DIG_Register_Masks XCVR_RX_DIG Register Masks
 * @{
 */

/*! @name RX_DIG_CTRL - RX Digital Control */
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_NEGEDGE_MASK (0x1U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_NEGEDGE_SHIFT (0U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_CH_FILT_BYPASS_MASK (0x2U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_CH_FILT_BYPASS_SHIFT (1U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_RAW_EN_MASK (0x4U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_RAW_EN_SHIFT (2U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_POL_MASK  (0x8U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_ADC_POL_SHIFT (3U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_MASK (0x70U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_SHIFT (4U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_SHIFT)) & XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_OSR_MASK)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_FSK_ZB_SEL_MASK (0x100U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_FSK_ZB_SEL_SHIFT (8U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_NORM_EN_MASK  (0x200U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_NORM_EN_SHIFT (9U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_EN_MASK  (0x400U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_EN_SHIFT (10U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_AGC_EN_MASK   (0x800U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_AGC_EN_SHIFT  (11U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_EN_MASK  (0x1000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_EN_SHIFT (12U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_CAL_EN_MASK (0x2000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DCOC_CAL_EN_SHIFT (13U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_IQ_SWAP_MASK  (0x4000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_IQ_SWAP_SHIFT (14U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DC_RESID_EN_MASK (0x8000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DC_RESID_EN_SHIFT (15U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_EN_MASK   (0x10000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_EN_SHIFT  (16U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_RATE_MASK (0x20000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_SRC_RATE_SHIFT (17U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DMA_DTEST_EN_MASK (0x40000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DMA_DTEST_EN_SHIFT (18U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_GAIN_MASK (0x1F00000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_GAIN_SHIFT (20U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_GAIN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_GAIN_SHIFT)) & XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_GAIN_MASK)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HZD_CORR_DIS_MASK (0x2000000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HZD_CORR_DIS_SHIFT (25U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HAZARD_MASK (0x10000000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_HAZARD_SHIFT (28U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_FILT_HAZARD_MASK (0x20000000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_RSSI_FILT_HAZARD_SHIFT (29U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_I_MASK (0x40000000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_I_SHIFT (30U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_Q_MASK (0x80000000U)
#define XCVR_RX_DIG_RX_DIG_CTRL_RX_DEC_FILT_SAT_Q_SHIFT (31U)

/*! @name AGC_CTRL_0 - AGC Control 0 */
#define XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_EN_MASK  (0x1U)
#define XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_EN_SHIFT (0U)
#define XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_SRC_MASK (0x6U)
#define XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_SRC_SHIFT (1U)
#define XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_SRC(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_SRC_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_0_SLOW_AGC_SRC_MASK)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_EN_MASK (0x8U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_EN_SHIFT (3U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_PRE_OR_AA_MASK (0x10U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_FREEZE_PRE_OR_AA_SHIFT (4U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_EN_MASK    (0x40U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_EN_SHIFT   (6U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_SRC_MASK   (0x80U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_SRC_SHIFT  (7U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_BBA_STEP_SZ_MASK (0xF00U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_BBA_STEP_SZ_SHIFT (8U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_BBA_STEP_SZ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_BBA_STEP_SZ_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_BBA_STEP_SZ_MASK)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_LNA_STEP_SZ_MASK (0xF000U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_LNA_STEP_SZ_SHIFT (12U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_LNA_STEP_SZ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_LNA_STEP_SZ_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_LNA_STEP_SZ_MASK)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_RSSI_THRESH_MASK (0xFF0000U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_RSSI_THRESH_SHIFT (16U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_RSSI_THRESH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_RSSI_THRESH_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_0_AGC_UP_RSSI_THRESH_MASK)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_RSSI_THRESH_MASK (0xFF000000U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_RSSI_THRESH_SHIFT (24U)
#define XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_RSSI_THRESH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_RSSI_THRESH_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_0_AGC_DOWN_RSSI_THRESH_MASK)

/*! @name AGC_CTRL_1 - AGC Control 1 */
#define XCVR_RX_DIG_AGC_CTRL_1_BBA_ALT_CODE_MASK (0xFU)
#define XCVR_RX_DIG_AGC_CTRL_1_BBA_ALT_CODE_SHIFT (0U)
#define XCVR_RX_DIG_AGC_CTRL_1_BBA_ALT_CODE(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_1_BBA_ALT_CODE_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_1_BBA_ALT_CODE_MASK)
#define XCVR_RX_DIG_AGC_CTRL_1_LNA_ALT_CODE_MASK (0xFF0U)
#define XCVR_RX_DIG_AGC_CTRL_1_LNA_ALT_CODE_SHIFT (4U)
#define XCVR_RX_DIG_AGC_CTRL_1_LNA_ALT_CODE(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_1_LNA_ALT_CODE_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_1_LNA_ALT_CODE_MASK)
#define XCVR_RX_DIG_AGC_CTRL_1_LNA_USER_GAIN_MASK (0xF000U)
#define XCVR_RX_DIG_AGC_CTRL_1_LNA_USER_GAIN_SHIFT (12U)
#define XCVR_RX_DIG_AGC_CTRL_1_LNA_USER_GAIN(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_1_LNA_USER_GAIN_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_1_LNA_USER_GAIN_MASK)
#define XCVR_RX_DIG_AGC_CTRL_1_BBA_USER_GAIN_MASK (0xF0000U)
#define XCVR_RX_DIG_AGC_CTRL_1_BBA_USER_GAIN_SHIFT (16U)
#define XCVR_RX_DIG_AGC_CTRL_1_BBA_USER_GAIN(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_1_BBA_USER_GAIN_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_1_BBA_USER_GAIN_MASK)
#define XCVR_RX_DIG_AGC_CTRL_1_USER_LNA_GAIN_EN_MASK (0x100000U)
#define XCVR_RX_DIG_AGC_CTRL_1_USER_LNA_GAIN_EN_SHIFT (20U)
#define XCVR_RX_DIG_AGC_CTRL_1_USER_BBA_GAIN_EN_MASK (0x200000U)
#define XCVR_RX_DIG_AGC_CTRL_1_USER_BBA_GAIN_EN_SHIFT (21U)
#define XCVR_RX_DIG_AGC_CTRL_1_PRESLOW_EN_MASK   (0x400000U)
#define XCVR_RX_DIG_AGC_CTRL_1_PRESLOW_EN_SHIFT  (22U)
#define XCVR_RX_DIG_AGC_CTRL_1_LNA_GAIN_SETTLE_TIME_MASK (0xFF000000U)
#define XCVR_RX_DIG_AGC_CTRL_1_LNA_GAIN_SETTLE_TIME_SHIFT (24U)
#define XCVR_RX_DIG_AGC_CTRL_1_LNA_GAIN_SETTLE_TIME(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_1_LNA_GAIN_SETTLE_TIME_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_1_LNA_GAIN_SETTLE_TIME_MASK)

/*! @name AGC_CTRL_2 - AGC Control 2 */
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_RST_MASK (0x1U)
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_RST_SHIFT (0U)
#define XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_RST_MASK (0x2U)
#define XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_RST_SHIFT (1U)
#define XCVR_RX_DIG_AGC_CTRL_2_MAN_PDET_RST_MASK (0x4U)
#define XCVR_RX_DIG_AGC_CTRL_2_MAN_PDET_RST_SHIFT (2U)
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_GAIN_SETTLE_TIME_MASK (0xFF0U)
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_GAIN_SETTLE_TIME_SHIFT (4U)
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_GAIN_SETTLE_TIME(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_2_BBA_GAIN_SETTLE_TIME_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_2_BBA_GAIN_SETTLE_TIME_MASK)
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_MASK (0x7000U)
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_SHIFT (12U)
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_LO_MASK)
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_MASK (0x38000U)
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_SHIFT (15U)
#define XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_2_BBA_PDET_SEL_HI_MASK)
#define XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_MASK (0x1C0000U)
#define XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_SHIFT (18U)
#define XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_LO_MASK)
#define XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_MASK (0xE00000U)
#define XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_SHIFT (21U)
#define XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_2_TZA_PDET_SEL_HI_MASK)
#define XCVR_RX_DIG_AGC_CTRL_2_AGC_FAST_EXPIRE_MASK (0x3F000000U)
#define XCVR_RX_DIG_AGC_CTRL_2_AGC_FAST_EXPIRE_SHIFT (24U)
#define XCVR_RX_DIG_AGC_CTRL_2_AGC_FAST_EXPIRE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_2_AGC_FAST_EXPIRE_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_2_AGC_FAST_EXPIRE_MASK)
#define XCVR_RX_DIG_AGC_CTRL_2_LNA_LG_ON_OVR_MASK (0x40000000U)
#define XCVR_RX_DIG_AGC_CTRL_2_LNA_LG_ON_OVR_SHIFT (30U)
#define XCVR_RX_DIG_AGC_CTRL_2_LNA_HG_ON_OVR_MASK (0x80000000U)
#define XCVR_RX_DIG_AGC_CTRL_2_LNA_HG_ON_OVR_SHIFT (31U)

/*! @name AGC_CTRL_3 - AGC Control 3 */
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_UNFREEZE_TIME_MASK (0x1FFFU)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_UNFREEZE_TIME_SHIFT (0U)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_UNFREEZE_TIME(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_3_AGC_UNFREEZE_TIME_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_3_AGC_UNFREEZE_TIME_MASK)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_PDET_LO_DLY_MASK (0xE000U)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_PDET_LO_DLY_SHIFT (13U)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_PDET_LO_DLY(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_3_AGC_PDET_LO_DLY_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_3_AGC_PDET_LO_DLY_MASK)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_RSSI_DELT_H2S_MASK (0x7F0000U)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_RSSI_DELT_H2S_SHIFT (16U)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_RSSI_DELT_H2S(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_3_AGC_RSSI_DELT_H2S_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_3_AGC_RSSI_DELT_H2S_MASK)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_H2S_STEP_SZ_MASK (0xF800000U)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_H2S_STEP_SZ_SHIFT (23U)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_H2S_STEP_SZ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_3_AGC_H2S_STEP_SZ_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_3_AGC_H2S_STEP_SZ_MASK)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_UP_STEP_SZ_MASK (0xF0000000U)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_UP_STEP_SZ_SHIFT (28U)
#define XCVR_RX_DIG_AGC_CTRL_3_AGC_UP_STEP_SZ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_CTRL_3_AGC_UP_STEP_SZ_SHIFT)) & XCVR_RX_DIG_AGC_CTRL_3_AGC_UP_STEP_SZ_MASK)

/*! @name AGC_STAT - AGC Status */
#define XCVR_RX_DIG_AGC_STAT_BBA_PDET_LO_STAT_MASK (0x1U)
#define XCVR_RX_DIG_AGC_STAT_BBA_PDET_LO_STAT_SHIFT (0U)
#define XCVR_RX_DIG_AGC_STAT_BBA_PDET_HI_STAT_MASK (0x2U)
#define XCVR_RX_DIG_AGC_STAT_BBA_PDET_HI_STAT_SHIFT (1U)
#define XCVR_RX_DIG_AGC_STAT_TZA_PDET_LO_STAT_MASK (0x4U)
#define XCVR_RX_DIG_AGC_STAT_TZA_PDET_LO_STAT_SHIFT (2U)
#define XCVR_RX_DIG_AGC_STAT_TZA_PDET_HI_STAT_MASK (0x8U)
#define XCVR_RX_DIG_AGC_STAT_TZA_PDET_HI_STAT_SHIFT (3U)
#define XCVR_RX_DIG_AGC_STAT_CURR_AGC_IDX_MASK   (0x1F0U)
#define XCVR_RX_DIG_AGC_STAT_CURR_AGC_IDX_SHIFT  (4U)
#define XCVR_RX_DIG_AGC_STAT_CURR_AGC_IDX(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_STAT_CURR_AGC_IDX_SHIFT)) & XCVR_RX_DIG_AGC_STAT_CURR_AGC_IDX_MASK)
#define XCVR_RX_DIG_AGC_STAT_AGC_FROZEN_MASK     (0x200U)
#define XCVR_RX_DIG_AGC_STAT_AGC_FROZEN_SHIFT    (9U)
#define XCVR_RX_DIG_AGC_STAT_RSSI_ADC_RAW_MASK   (0xFF0000U)
#define XCVR_RX_DIG_AGC_STAT_RSSI_ADC_RAW_SHIFT  (16U)
#define XCVR_RX_DIG_AGC_STAT_RSSI_ADC_RAW(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_STAT_RSSI_ADC_RAW_SHIFT)) & XCVR_RX_DIG_AGC_STAT_RSSI_ADC_RAW_MASK)

/*! @name RSSI_CTRL_0 - RSSI Control 0 */
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_USE_VALS_MASK (0x1U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_USE_VALS_SHIFT (0U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_SRC_MASK (0x6U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_SRC_SHIFT (1U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_SRC(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_SRC_SHIFT)) & XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_SRC_MASK)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_EN_MASK (0x8U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_EN_SHIFT (3U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT_MASK (0x60U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT_SHIFT (5U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT_SHIFT)) & XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_CW_WEIGHT_MASK)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG_MASK (0x300U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG_SHIFT (8U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG_SHIFT)) & XCVR_RX_DIG_RSSI_CTRL_0_RSSI_N_WINDOW_AVG_MASK)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_DELAY_MASK (0xFC00U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_DELAY_SHIFT (10U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_DELAY(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_DELAY_SHIFT)) & XCVR_RX_DIG_RSSI_CTRL_0_RSSI_HOLD_DELAY_MASK)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_MASK (0xF0000U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_SHIFT (16U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_SHIFT)) & XCVR_RX_DIG_RSSI_CTRL_0_RSSI_IIR_WEIGHT_MASK)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_VLD_SETTLE_MASK (0x700000U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_VLD_SETTLE_SHIFT (20U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_VLD_SETTLE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RSSI_CTRL_0_RSSI_VLD_SETTLE_SHIFT)) & XCVR_RX_DIG_RSSI_CTRL_0_RSSI_VLD_SETTLE_MASK)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_ADJ_MASK    (0xFF000000U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_ADJ_SHIFT   (24U)
#define XCVR_RX_DIG_RSSI_CTRL_0_RSSI_ADJ(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RSSI_CTRL_0_RSSI_ADJ_SHIFT)) & XCVR_RX_DIG_RSSI_CTRL_0_RSSI_ADJ_MASK)

/*! @name RSSI_CTRL_1 - RSSI Control 1 */
#define XCVR_RX_DIG_RSSI_CTRL_1_RSSI_OUT_MASK    (0xFF000000U)
#define XCVR_RX_DIG_RSSI_CTRL_1_RSSI_OUT_SHIFT   (24U)
#define XCVR_RX_DIG_RSSI_CTRL_1_RSSI_OUT(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RSSI_CTRL_1_RSSI_OUT_SHIFT)) & XCVR_RX_DIG_RSSI_CTRL_1_RSSI_OUT_MASK)

/*! @name RSSI_DFT - RSSI DFT */
#define XCVR_RX_DIG_RSSI_DFT_DFT_MAG_MASK        (0x1FFFU)
#define XCVR_RX_DIG_RSSI_DFT_DFT_MAG_SHIFT       (0U)
#define XCVR_RX_DIG_RSSI_DFT_DFT_MAG(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RSSI_DFT_DFT_MAG_SHIFT)) & XCVR_RX_DIG_RSSI_DFT_DFT_MAG_MASK)
#define XCVR_RX_DIG_RSSI_DFT_DFT_NOISE_MASK      (0x1FFF0000U)
#define XCVR_RX_DIG_RSSI_DFT_DFT_NOISE_SHIFT     (16U)
#define XCVR_RX_DIG_RSSI_DFT_DFT_NOISE(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RSSI_DFT_DFT_NOISE_SHIFT)) & XCVR_RX_DIG_RSSI_DFT_DFT_NOISE_MASK)

/*! @name DCOC_CTRL_0 - DCOC Control 0 */
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MIDPWR_TRK_DIS_MASK (0x1U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MIDPWR_TRK_DIS_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MAN_MASK    (0x2U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_MAN_SHIFT   (1U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_TRK_EST_OVR_MASK (0x4U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_TRK_EST_OVR_SHIFT (2U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_SRC_MASK (0x8U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_SRC_SHIFT (3U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_EN_MASK (0x10U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORRECT_EN_SHIFT (4U)
#define XCVR_RX_DIG_DCOC_CTRL_0_TRACK_FROM_ZERO_MASK (0x20U)
#define XCVR_RX_DIG_DCOC_CTRL_0_TRACK_FROM_ZERO_SHIFT (5U)
#define XCVR_RX_DIG_DCOC_CTRL_0_BBA_CORR_POL_MASK (0x40U)
#define XCVR_RX_DIG_DCOC_CTRL_0_BBA_CORR_POL_SHIFT (6U)
#define XCVR_RX_DIG_DCOC_CTRL_0_TZA_CORR_POL_MASK (0x80U)
#define XCVR_RX_DIG_DCOC_CTRL_0_TZA_CORR_POL_SHIFT (7U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CAL_DURATION_MASK (0x1F00U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CAL_DURATION_SHIFT (8U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CAL_DURATION(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CAL_DURATION_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CAL_DURATION_MASK)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_DLY_MASK (0x1F0000U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_DLY_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_DLY(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_DLY_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_DLY_MASK)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_HOLD_TIME_MASK (0x7F000000U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_HOLD_TIME_SHIFT (24U)
#define XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_HOLD_TIME(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_HOLD_TIME_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_0_DCOC_CORR_HOLD_TIME_MASK)

/*! @name DCOC_CTRL_1 - DCOC Control 1 */
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX_MASK (0x3U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_IDX_MASK)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_MASK (0x1CU)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_SHIFT (2U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_IDX_MASK)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_MASK (0xE0U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_SHIFT (5U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_IDX_MASK)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_EST_GS_CNT_MASK (0x7000U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_EST_GS_CNT_SHIFT (12U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_EST_GS_CNT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_EST_GS_CNT_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_EST_GS_CNT_MASK)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX_MASK (0x30000U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_1_DCOC_SIGN_SCALE_GS_IDX_MASK)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_MASK (0x1C0000U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_SHIFT (18U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHAC_SCALE_GS_IDX_MASK)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_MASK (0xE00000U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_SHIFT (21U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_1_DCOC_ALPHA_RADIUS_GS_IDX_MASK)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_MIN_AGC_IDX_MASK (0x1F000000U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_MIN_AGC_IDX_SHIFT (24U)
#define XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_MIN_AGC_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_MIN_AGC_IDX_SHIFT)) & XCVR_RX_DIG_DCOC_CTRL_1_DCOC_TRK_MIN_AGC_IDX_MASK)

/*! @name DCOC_DAC_INIT - DCOC DAC Initialization */
#define XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_I_MASK (0x3FU)
#define XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_I_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_I(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_I_SHIFT)) & XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_I_MASK)
#define XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_Q_MASK (0x3F00U)
#define XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_Q_SHIFT (8U)
#define XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_Q(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_Q_SHIFT)) & XCVR_RX_DIG_DCOC_DAC_INIT_BBA_DCOC_INIT_Q_MASK)
#define XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_I_MASK (0xFF0000U)
#define XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_I_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_I(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_I_SHIFT)) & XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_I_MASK)
#define XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_Q_MASK (0xFF000000U)
#define XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_Q_SHIFT (24U)
#define XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_Q(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_Q_SHIFT)) & XCVR_RX_DIG_DCOC_DAC_INIT_TZA_DCOC_INIT_Q_MASK)

/*! @name DCOC_DIG_MAN - DCOC Digital Correction Manual Override */
#define XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_I_MASK (0xFFFU)
#define XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_I_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_I(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_I_SHIFT)) & XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_I_MASK)
#define XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_Q_MASK (0xFFF0000U)
#define XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_Q_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_Q(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_Q_SHIFT)) & XCVR_RX_DIG_DCOC_DIG_MAN_DIG_DCOC_INIT_Q_MASK)

/*! @name DCOC_CAL_GAIN - DCOC Calibration Gain */
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN1_MASK (0xF00U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN1_SHIFT (8U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN1_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN1_MASK)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN1_MASK (0xF000U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN1_SHIFT (12U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN1_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN1_MASK)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN2_MASK (0xF0000U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN2_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN2_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN2_MASK)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN2_MASK (0xF00000U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN2_SHIFT (20U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN2_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN2_MASK)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN3_MASK (0xF000000U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN3_SHIFT (24U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN3_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_BBA_CAL_GAIN3_MASK)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN3_MASK (0xF0000000U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN3_SHIFT (28U)
#define XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN3_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_GAIN_DCOC_LNA_CAL_GAIN3_MASK)

/*! @name DCOC_STAT - DCOC Status */
#define XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_I_MASK    (0x3FU)
#define XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_I_SHIFT   (0U)
#define XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_I(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_I_SHIFT)) & XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_I_MASK)
#define XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_Q_MASK    (0x3F00U)
#define XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_Q_SHIFT   (8U)
#define XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_Q(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_Q_SHIFT)) & XCVR_RX_DIG_DCOC_STAT_BBA_DCOC_Q_MASK)
#define XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_I_MASK    (0xFF0000U)
#define XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_I_SHIFT   (16U)
#define XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_I(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_I_SHIFT)) & XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_I_MASK)
#define XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_Q_MASK    (0xFF000000U)
#define XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_Q_SHIFT   (24U)
#define XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_Q(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_Q_SHIFT)) & XCVR_RX_DIG_DCOC_STAT_TZA_DCOC_Q_MASK)

/*! @name DCOC_DC_EST - DCOC DC Estimate */
#define XCVR_RX_DIG_DCOC_DC_EST_DC_EST_I_MASK    (0xFFFU)
#define XCVR_RX_DIG_DCOC_DC_EST_DC_EST_I_SHIFT   (0U)
#define XCVR_RX_DIG_DCOC_DC_EST_DC_EST_I(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_DC_EST_DC_EST_I_SHIFT)) & XCVR_RX_DIG_DCOC_DC_EST_DC_EST_I_MASK)
#define XCVR_RX_DIG_DCOC_DC_EST_DC_EST_Q_MASK    (0xFFF0000U)
#define XCVR_RX_DIG_DCOC_DC_EST_DC_EST_Q_SHIFT   (16U)
#define XCVR_RX_DIG_DCOC_DC_EST_DC_EST_Q(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_DC_EST_DC_EST_Q_SHIFT)) & XCVR_RX_DIG_DCOC_DC_EST_DC_EST_Q_MASK)

/*! @name DCOC_CAL_RCP - DCOC Calibration Reciprocals */
#define XCVR_RX_DIG_DCOC_CAL_RCP_DCOC_TMP_CALC_RECIP_MASK (0x7FFU)
#define XCVR_RX_DIG_DCOC_CAL_RCP_DCOC_TMP_CALC_RECIP_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_CAL_RCP_DCOC_TMP_CALC_RECIP(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_RCP_DCOC_TMP_CALC_RECIP_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_RCP_DCOC_TMP_CALC_RECIP_MASK)
#define XCVR_RX_DIG_DCOC_CAL_RCP_ALPHA_CALC_RECIP_MASK (0x7FF0000U)
#define XCVR_RX_DIG_DCOC_CAL_RCP_ALPHA_CALC_RECIP_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_CAL_RCP_ALPHA_CALC_RECIP(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_RCP_ALPHA_CALC_RECIP_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_RCP_ALPHA_CALC_RECIP_MASK)

/*! @name IQMC_CTRL - IQMC Control */
#define XCVR_RX_DIG_IQMC_CTRL_IQMC_CAL_EN_MASK   (0x1U)
#define XCVR_RX_DIG_IQMC_CTRL_IQMC_CAL_EN_SHIFT  (0U)
#define XCVR_RX_DIG_IQMC_CTRL_IQMC_NUM_ITER_MASK (0xFF00U)
#define XCVR_RX_DIG_IQMC_CTRL_IQMC_NUM_ITER_SHIFT (8U)
#define XCVR_RX_DIG_IQMC_CTRL_IQMC_NUM_ITER(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_IQMC_CTRL_IQMC_NUM_ITER_SHIFT)) & XCVR_RX_DIG_IQMC_CTRL_IQMC_NUM_ITER_MASK)
#define XCVR_RX_DIG_IQMC_CTRL_IQMC_DC_GAIN_ADJ_MASK (0x7FF0000U)
#define XCVR_RX_DIG_IQMC_CTRL_IQMC_DC_GAIN_ADJ_SHIFT (16U)
#define XCVR_RX_DIG_IQMC_CTRL_IQMC_DC_GAIN_ADJ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_IQMC_CTRL_IQMC_DC_GAIN_ADJ_SHIFT)) & XCVR_RX_DIG_IQMC_CTRL_IQMC_DC_GAIN_ADJ_MASK)

/*! @name IQMC_CAL - IQMC Calibration */
#define XCVR_RX_DIG_IQMC_CAL_IQMC_GAIN_ADJ_MASK  (0x7FFU)
#define XCVR_RX_DIG_IQMC_CAL_IQMC_GAIN_ADJ_SHIFT (0U)
#define XCVR_RX_DIG_IQMC_CAL_IQMC_GAIN_ADJ(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_IQMC_CAL_IQMC_GAIN_ADJ_SHIFT)) & XCVR_RX_DIG_IQMC_CAL_IQMC_GAIN_ADJ_MASK)
#define XCVR_RX_DIG_IQMC_CAL_IQMC_PHASE_ADJ_MASK (0xFFF0000U)
#define XCVR_RX_DIG_IQMC_CAL_IQMC_PHASE_ADJ_SHIFT (16U)
#define XCVR_RX_DIG_IQMC_CAL_IQMC_PHASE_ADJ(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_IQMC_CAL_IQMC_PHASE_ADJ_SHIFT)) & XCVR_RX_DIG_IQMC_CAL_IQMC_PHASE_ADJ_MASK)

/*! @name LNA_GAIN_VAL_3_0 - LNA_GAIN Step Values 3..0 */
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_0_MASK (0xFFU)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_0_SHIFT (0U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_0_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_0_MASK)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_1_MASK (0xFF00U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_1_SHIFT (8U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_1_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_1_MASK)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_2_MASK (0xFF0000U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_2_SHIFT (16U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_2_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_2_MASK)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_3_MASK (0xFF000000U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_3_SHIFT (24U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_3_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_VAL_3_0_LNA_GAIN_VAL_3_MASK)

/*! @name LNA_GAIN_VAL_7_4 - LNA_GAIN Step Values 7..4 */
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_4_MASK (0xFFU)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_4_SHIFT (0U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_4(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_4_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_4_MASK)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_5_MASK (0xFF00U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_5_SHIFT (8U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_5(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_5_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_5_MASK)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_6_MASK (0xFF0000U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_6_SHIFT (16U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_6(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_6_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_6_MASK)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_7_MASK (0xFF000000U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_7_SHIFT (24U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_7(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_7_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_VAL_7_4_LNA_GAIN_VAL_7_MASK)

/*! @name LNA_GAIN_VAL_8 - LNA_GAIN Step Values 8 */
#define XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_8_MASK (0xFFU)
#define XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_8_SHIFT (0U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_8(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_8_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_8_MASK)
#define XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_9_MASK (0xFF00U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_9_SHIFT (8U)
#define XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_9(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_9_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_VAL_8_LNA_GAIN_VAL_9_MASK)

/*! @name BBA_RES_TUNE_VAL_7_0 - BBA Resistor Tune Values 7..0 */
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_0_MASK (0xFU)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_0_SHIFT (0U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_0_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_0_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_1_MASK (0xF0U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_1_SHIFT (4U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_1_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_1_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_2_MASK (0xF00U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_2_SHIFT (8U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_2_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_2_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_3_MASK (0xF000U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_3_SHIFT (12U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_3_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_3_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_4_MASK (0xF0000U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_4_SHIFT (16U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_4(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_4_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_4_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_5_MASK (0xF00000U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_5_SHIFT (20U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_5(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_5_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_5_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_6_MASK (0xF000000U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_6_SHIFT (24U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_6(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_6_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_6_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_7_MASK (0xF0000000U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_7_SHIFT (28U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_7(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_7_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_BBA_RES_TUNE_VAL_7_MASK)

/*! @name BBA_RES_TUNE_VAL_10_8 - BBA Resistor Tune Values 10..8 */
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_8_MASK (0xFU)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_8_SHIFT (0U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_8(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_8_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_8_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_9_MASK (0xF0U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_9_SHIFT (4U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_9(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_9_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_9_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_10_MASK (0xF00U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_10_SHIFT (8U)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_10(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_10_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_BBA_RES_TUNE_VAL_10_MASK)

/*! @name LNA_GAIN_LIN_VAL_2_0 - LNA Linear Gain Values 2..0 */
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_0_MASK (0x3FFU)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_0_SHIFT (0U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_0_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_0_MASK)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_1_MASK (0xFFC00U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_1_SHIFT (10U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_1_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_1_MASK)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_2_MASK (0x3FF00000U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_2_SHIFT (20U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_2_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_LNA_GAIN_LIN_VAL_2_MASK)

/*! @name LNA_GAIN_LIN_VAL_5_3 - LNA Linear Gain Values 5..3 */
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_3_MASK (0x3FFU)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_3_SHIFT (0U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_3_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_3_MASK)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_4_MASK (0xFFC00U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_4_SHIFT (10U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_4(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_4_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_4_MASK)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_5_MASK (0x3FF00000U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_5_SHIFT (20U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_5(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_5_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_LNA_GAIN_LIN_VAL_5_MASK)

/*! @name LNA_GAIN_LIN_VAL_8_6 - LNA Linear Gain Values 8..6 */
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_6_MASK (0x3FFU)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_6_SHIFT (0U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_6(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_6_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_6_MASK)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_7_MASK (0xFFC00U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_7_SHIFT (10U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_7(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_7_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_7_MASK)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_8_MASK (0x3FF00000U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_8_SHIFT (20U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_8(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_8_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_LNA_GAIN_LIN_VAL_8_MASK)

/*! @name LNA_GAIN_LIN_VAL_9 - LNA Linear Gain Values 9 */
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_9_LNA_GAIN_LIN_VAL_9_MASK (0x3FFU)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_9_LNA_GAIN_LIN_VAL_9_SHIFT (0U)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_9_LNA_GAIN_LIN_VAL_9(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_LNA_GAIN_LIN_VAL_9_LNA_GAIN_LIN_VAL_9_SHIFT)) & XCVR_RX_DIG_LNA_GAIN_LIN_VAL_9_LNA_GAIN_LIN_VAL_9_MASK)

/*! @name BBA_RES_TUNE_LIN_VAL_3_0 - BBA Resistor Tune Values 3..0 */
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_0_MASK (0xFFU)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_0_SHIFT (0U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_0_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_0_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_1_MASK (0xFF00U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_1_SHIFT (8U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_1_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_1_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_2_MASK (0xFF0000U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_2_SHIFT (16U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_2_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_2_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_3_MASK (0xFF000000U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_3_SHIFT (24U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_3_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_BBA_RES_TUNE_LIN_VAL_3_MASK)

/*! @name BBA_RES_TUNE_LIN_VAL_7_4 - BBA Resistor Tune Values 7..4 */
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_4_MASK (0xFFU)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_4_SHIFT (0U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_4(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_4_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_4_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_5_MASK (0xFF00U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_5_SHIFT (8U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_5(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_5_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_5_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_6_MASK (0xFF0000U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_6_SHIFT (16U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_6(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_6_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_6_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_7_MASK (0xFF000000U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_7_SHIFT (24U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_7(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_7_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_BBA_RES_TUNE_LIN_VAL_7_MASK)

/*! @name BBA_RES_TUNE_LIN_VAL_10_8 - BBA Resistor Tune Values 10..8 */
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_8_MASK (0x3FFU)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_8_SHIFT (0U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_8(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_8_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_8_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_9_MASK (0xFFC00U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_9_SHIFT (10U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_9(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_9_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_9_MASK)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_10_MASK (0x3FF00000U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_10_SHIFT (20U)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_10(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_10_SHIFT)) & XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_BBA_RES_TUNE_LIN_VAL_10_MASK)

/*! @name AGC_GAIN_TBL_03_00 - AGC Gain Tables Step 03..00 */
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_00_MASK (0xFU)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_00_SHIFT (0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_00(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_00_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_00_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_00_MASK (0xF0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_00_SHIFT (4U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_00(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_00_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_00_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_01_MASK (0xF00U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_01_SHIFT (8U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_01(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_01_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_01_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_01_MASK (0xF000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_01_SHIFT (12U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_01(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_01_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_01_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_02_MASK (0xF0000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_02_SHIFT (16U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_02(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_02_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_02_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_02_MASK (0xF00000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_02_SHIFT (20U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_02(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_02_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_02_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_03_MASK (0xF000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_03_SHIFT (24U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_03(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_03_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_03_00_BBA_GAIN_03_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_03_MASK (0xF0000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_03_SHIFT (28U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_03(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_03_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_03_00_LNA_GAIN_03_MASK)

/*! @name AGC_GAIN_TBL_07_04 - AGC Gain Tables Step 07..04 */
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_04_MASK (0xFU)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_04_SHIFT (0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_04(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_04_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_04_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_04_MASK (0xF0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_04_SHIFT (4U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_04(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_04_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_04_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_05_MASK (0xF00U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_05_SHIFT (8U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_05(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_05_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_05_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_05_MASK (0xF000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_05_SHIFT (12U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_05(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_05_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_05_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_06_MASK (0xF0000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_06_SHIFT (16U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_06(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_06_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_06_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_06_MASK (0xF00000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_06_SHIFT (20U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_06(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_06_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_06_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_07_MASK (0xF000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_07_SHIFT (24U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_07(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_07_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_07_04_BBA_GAIN_07_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_07_MASK (0xF0000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_07_SHIFT (28U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_07(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_07_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_07_04_LNA_GAIN_07_MASK)

/*! @name AGC_GAIN_TBL_11_08 - AGC Gain Tables Step 11..08 */
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_08_MASK (0xFU)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_08_SHIFT (0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_08(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_08_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_08_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_08_MASK (0xF0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_08_SHIFT (4U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_08(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_08_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_08_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_09_MASK (0xF00U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_09_SHIFT (8U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_09(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_09_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_09_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_09_MASK (0xF000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_09_SHIFT (12U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_09(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_09_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_09_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_10_MASK (0xF0000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_10_SHIFT (16U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_10(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_10_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_10_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_10_MASK (0xF00000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_10_SHIFT (20U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_10(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_10_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_10_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_11_MASK (0xF000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_11_SHIFT (24U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_11(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_11_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_11_08_BBA_GAIN_11_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_11_MASK (0xF0000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_11_SHIFT (28U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_11(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_11_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_11_08_LNA_GAIN_11_MASK)

/*! @name AGC_GAIN_TBL_15_12 - AGC Gain Tables Step 15..12 */
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_12_MASK (0xFU)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_12_SHIFT (0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_12(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_12_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_12_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_12_MASK (0xF0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_12_SHIFT (4U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_12(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_12_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_12_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_13_MASK (0xF00U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_13_SHIFT (8U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_13(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_13_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_13_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_13_MASK (0xF000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_13_SHIFT (12U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_13(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_13_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_13_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_14_MASK (0xF0000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_14_SHIFT (16U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_14(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_14_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_14_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_14_MASK (0xF00000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_14_SHIFT (20U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_14(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_14_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_14_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_15_MASK (0xF000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_15_SHIFT (24U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_15(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_15_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_15_12_BBA_GAIN_15_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_15_MASK (0xF0000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_15_SHIFT (28U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_15(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_15_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_15_12_LNA_GAIN_15_MASK)

/*! @name AGC_GAIN_TBL_19_16 - AGC Gain Tables Step 19..16 */
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_16_MASK (0xFU)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_16_SHIFT (0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_16(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_16_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_16_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_16_MASK (0xF0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_16_SHIFT (4U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_16(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_16_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_16_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_17_MASK (0xF00U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_17_SHIFT (8U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_17(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_17_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_17_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_17_MASK (0xF000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_17_SHIFT (12U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_17(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_17_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_17_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_18_MASK (0xF0000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_18_SHIFT (16U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_18(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_18_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_18_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_18_MASK (0xF00000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_18_SHIFT (20U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_18(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_18_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_18_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_19_MASK (0xF000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_19_SHIFT (24U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_19(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_19_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_19_16_BBA_GAIN_19_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_19_MASK (0xF0000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_19_SHIFT (28U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_19(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_19_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_19_16_LNA_GAIN_19_MASK)

/*! @name AGC_GAIN_TBL_23_20 - AGC Gain Tables Step 23..20 */
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_20_MASK (0xFU)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_20_SHIFT (0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_20(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_20_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_20_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_20_MASK (0xF0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_20_SHIFT (4U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_20(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_20_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_20_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_21_MASK (0xF00U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_21_SHIFT (8U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_21(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_21_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_21_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_21_MASK (0xF000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_21_SHIFT (12U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_21(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_21_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_21_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_22_MASK (0xF0000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_22_SHIFT (16U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_22(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_22_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_22_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_22_MASK (0xF00000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_22_SHIFT (20U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_22(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_22_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_22_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_23_MASK (0xF000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_23_SHIFT (24U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_23(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_23_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_23_20_BBA_GAIN_23_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_23_MASK (0xF0000000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_23_SHIFT (28U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_23(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_23_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_23_20_LNA_GAIN_23_MASK)

/*! @name AGC_GAIN_TBL_26_24 - AGC Gain Tables Step 26..24 */
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_24_MASK (0xFU)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_24_SHIFT (0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_24(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_24_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_24_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_24_MASK (0xF0U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_24_SHIFT (4U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_24(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_24_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_24_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_25_MASK (0xF00U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_25_SHIFT (8U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_25(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_25_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_25_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_25_MASK (0xF000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_25_SHIFT (12U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_25(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_25_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_25_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_26_MASK (0xF0000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_26_SHIFT (16U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_26(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_26_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_26_24_BBA_GAIN_26_MASK)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_26_MASK (0xF00000U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_26_SHIFT (20U)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_26(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_26_SHIFT)) & XCVR_RX_DIG_AGC_GAIN_TBL_26_24_LNA_GAIN_26_MASK)

/*! @name DCOC_OFFSET - DCOC Offset */
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_BBA_OFFSET_I_MASK (0x3FU)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_BBA_OFFSET_I_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_BBA_OFFSET_I(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_OFFSET_DCOC_BBA_OFFSET_I_SHIFT)) & XCVR_RX_DIG_DCOC_OFFSET_DCOC_BBA_OFFSET_I_MASK)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_BBA_OFFSET_Q_MASK (0x3F00U)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_BBA_OFFSET_Q_SHIFT (8U)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_BBA_OFFSET_Q(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_OFFSET_DCOC_BBA_OFFSET_Q_SHIFT)) & XCVR_RX_DIG_DCOC_OFFSET_DCOC_BBA_OFFSET_Q_MASK)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_TZA_OFFSET_I_MASK (0xFF0000U)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_TZA_OFFSET_I_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_TZA_OFFSET_I(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_OFFSET_DCOC_TZA_OFFSET_I_SHIFT)) & XCVR_RX_DIG_DCOC_OFFSET_DCOC_TZA_OFFSET_I_MASK)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_TZA_OFFSET_Q_MASK (0xFF000000U)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_TZA_OFFSET_Q_SHIFT (24U)
#define XCVR_RX_DIG_DCOC_OFFSET_DCOC_TZA_OFFSET_Q(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_OFFSET_DCOC_TZA_OFFSET_Q_SHIFT)) & XCVR_RX_DIG_DCOC_OFFSET_DCOC_TZA_OFFSET_Q_MASK)

/* The count of XCVR_RX_DIG_DCOC_OFFSET */
#define XCVR_RX_DIG_DCOC_OFFSET_COUNT            (27U)

/*! @name DCOC_BBA_STEP - DCOC BBA DAC Step */
#define XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_RECIP_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_RECIP_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_RECIP(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_RECIP_SHIFT)) & XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_RECIP_MASK)
#define XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_MASK (0x1FF0000U)
#define XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_SHIFT)) & XCVR_RX_DIG_DCOC_BBA_STEP_BBA_DCOC_STEP_MASK)

/*! @name DCOC_TZA_STEP_0 - DCOC TZA DAC Step 0 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_RCP_0_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_RCP_0_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_RCP_0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_RCP_0_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_RCP_0_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_GAIN_0_MASK (0xFFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_GAIN_0_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_GAIN_0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_GAIN_0_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_0_DCOC_TZA_STEP_GAIN_0_MASK)

/*! @name DCOC_TZA_STEP_1 - DCOC TZA DAC Step 1 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_RCP_1_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_RCP_1_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_RCP_1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_RCP_1_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_RCP_1_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_GAIN_1_MASK (0xFFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_GAIN_1_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_GAIN_1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_GAIN_1_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_1_DCOC_TZA_STEP_GAIN_1_MASK)

/*! @name DCOC_TZA_STEP_2 - DCOC TZA DAC Step 2 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_RCP_2_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_RCP_2_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_RCP_2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_RCP_2_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_RCP_2_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_GAIN_2_MASK (0xFFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_GAIN_2_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_GAIN_2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_GAIN_2_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_2_DCOC_TZA_STEP_GAIN_2_MASK)

/*! @name DCOC_TZA_STEP_3 - DCOC TZA DAC Step 3 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_RCP_3_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_RCP_3_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_RCP_3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_RCP_3_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_RCP_3_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_GAIN_3_MASK (0xFFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_GAIN_3_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_GAIN_3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_GAIN_3_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_3_DCOC_TZA_STEP_GAIN_3_MASK)

/*! @name DCOC_TZA_STEP_4 - DCOC TZA DAC Step 4 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_RCP_4_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_RCP_4_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_RCP_4(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_RCP_4_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_RCP_4_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_GAIN_4_MASK (0xFFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_GAIN_4_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_GAIN_4(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_GAIN_4_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_4_DCOC_TZA_STEP_GAIN_4_MASK)

/*! @name DCOC_TZA_STEP_5 - DCOC TZA DAC Step 5 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_RCP_5_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_RCP_5_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_RCP_5(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_RCP_5_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_RCP_5_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_GAIN_5_MASK (0xFFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_GAIN_5_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_GAIN_5(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_GAIN_5_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_5_DCOC_TZA_STEP_GAIN_5_MASK)

/*! @name DCOC_TZA_STEP_6 - DCOC TZA DAC Step 6 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_RCP_6_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_RCP_6_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_RCP_6(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_RCP_6_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_RCP_6_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_GAIN_6_MASK (0xFFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_GAIN_6_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_GAIN_6(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_GAIN_6_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_6_DCOC_TZA_STEP_GAIN_6_MASK)

/*! @name DCOC_TZA_STEP_7 - DCOC TZA DAC Step 7 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_RCP_7_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_RCP_7_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_RCP_7(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_RCP_7_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_RCP_7_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_GAIN_7_MASK (0x1FFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_GAIN_7_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_GAIN_7(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_GAIN_7_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_7_DCOC_TZA_STEP_GAIN_7_MASK)

/*! @name DCOC_TZA_STEP_8 - DCOC TZA DAC Step 5 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_RCP_8_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_RCP_8_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_RCP_8(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_RCP_8_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_RCP_8_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_GAIN_8_MASK (0x1FFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_GAIN_8_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_GAIN_8(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_GAIN_8_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_8_DCOC_TZA_STEP_GAIN_8_MASK)

/*! @name DCOC_TZA_STEP_9 - DCOC TZA DAC Step 9 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_RCP_9_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_RCP_9_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_RCP_9(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_RCP_9_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_RCP_9_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_GAIN_9_MASK (0x3FFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_GAIN_9_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_GAIN_9(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_GAIN_9_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_9_DCOC_TZA_STEP_GAIN_9_MASK)

/*! @name DCOC_TZA_STEP_10 - DCOC TZA DAC Step 10 */
#define XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_RCP_10_MASK (0x1FFFU)
#define XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_RCP_10_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_RCP_10(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_RCP_10_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_RCP_10_MASK)
#define XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_GAIN_10_MASK (0x3FFF0000U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_GAIN_10_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_GAIN_10(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_GAIN_10_SHIFT)) & XCVR_RX_DIG_DCOC_TZA_STEP_10_DCOC_TZA_STEP_GAIN_10_MASK)

/*! @name DCOC_CAL_ALPHA - DCOC Calibration Alpha */
#define XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_I_MASK (0x7FFU)
#define XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_I_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_I(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_I_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_I_MASK)
#define XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_Q_MASK (0x7FF0000U)
#define XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_Q_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_Q(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_Q_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_ALPHA_DCOC_CAL_ALPHA_Q_MASK)

/*! @name DCOC_CAL_BETA_Q - DCOC Calibration Beta Q */
#define XCVR_RX_DIG_DCOC_CAL_BETA_Q_DCOC_CAL_BETA_Q_MASK (0x1FFFFU)
#define XCVR_RX_DIG_DCOC_CAL_BETA_Q_DCOC_CAL_BETA_Q_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_CAL_BETA_Q_DCOC_CAL_BETA_Q(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_BETA_Q_DCOC_CAL_BETA_Q_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_BETA_Q_DCOC_CAL_BETA_Q_MASK)

/*! @name DCOC_CAL_BETA_I - DCOC Calibration Beta I */
#define XCVR_RX_DIG_DCOC_CAL_BETA_I_DCOC_CAL_BETA_I_MASK (0x1FFFFU)
#define XCVR_RX_DIG_DCOC_CAL_BETA_I_DCOC_CAL_BETA_I_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_CAL_BETA_I_DCOC_CAL_BETA_I(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_BETA_I_DCOC_CAL_BETA_I_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_BETA_I_DCOC_CAL_BETA_I_MASK)

/*! @name DCOC_CAL_GAMMA - DCOC Calibration Gamma */
#define XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_I_MASK (0xFFFFU)
#define XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_I_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_I(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_I_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_I_MASK)
#define XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_Q_MASK (0xFFFF0000U)
#define XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_Q_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_Q(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_Q_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_GAMMA_DCOC_CAL_GAMMA_Q_MASK)

/*! @name DCOC_CAL_IIR - DCOC Calibration IIR */
#define XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX_MASK (0x3U)
#define XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR1A_IDX_MASK)
#define XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX_MASK (0xCU)
#define XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX_SHIFT (2U)
#define XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR2A_IDX_MASK)
#define XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX_MASK (0x30U)
#define XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX_SHIFT (4U)
#define XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_IIR_DCOC_CAL_IIR3A_IDX_MASK)

/*! @name DCOC_CAL - DCOC Calibration Result */
#define XCVR_RX_DIG_DCOC_CAL_DCOC_CAL_RES_I_MASK (0xFFFU)
#define XCVR_RX_DIG_DCOC_CAL_DCOC_CAL_RES_I_SHIFT (0U)
#define XCVR_RX_DIG_DCOC_CAL_DCOC_CAL_RES_I(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_DCOC_CAL_RES_I_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_DCOC_CAL_RES_I_MASK)
#define XCVR_RX_DIG_DCOC_CAL_DCOC_CAL_RES_Q_MASK (0xFFF0000U)
#define XCVR_RX_DIG_DCOC_CAL_DCOC_CAL_RES_Q_SHIFT (16U)
#define XCVR_RX_DIG_DCOC_CAL_DCOC_CAL_RES_Q(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DCOC_CAL_DCOC_CAL_RES_Q_SHIFT)) & XCVR_RX_DIG_DCOC_CAL_DCOC_CAL_RES_Q_MASK)

/* The count of XCVR_RX_DIG_DCOC_CAL */
#define XCVR_RX_DIG_DCOC_CAL_COUNT               (3U)

/*! @name CCA_ED_LQI_CTRL_0 - RX_DIG CCA ED LQI Control Register 0 */
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CORR_THRESH_MASK (0xFFU)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CORR_THRESH_SHIFT (0U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CORR_THRESH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CORR_THRESH_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CORR_THRESH_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_CORR_CNTR_THRESH_MASK (0xFF00U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_CORR_CNTR_THRESH_SHIFT (8U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_CORR_CNTR_THRESH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_CORR_CNTR_THRESH_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_CORR_CNTR_THRESH_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CNTR_MASK (0xFF0000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CNTR_SHIFT (16U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CNTR(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CNTR_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_LQI_CNTR_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_SNR_ADJ_MASK (0x3F000000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_SNR_ADJ_SHIFT (24U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_SNR_ADJ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_SNR_ADJ_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_SNR_ADJ_MASK)

/*! @name CCA_ED_LQI_CTRL_1 - RX_DIG CCA ED LQI Control Register 1 */
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_DELAY_MASK (0x3FU)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_DELAY_SHIFT (0U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_DELAY(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_DELAY_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_DELAY_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_MASK (0x1C0U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_SHIFT (6U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_RSSI_NOISE_AVG_FACTOR_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_MASK (0xE00U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_SHIFT (9U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_WEIGHT_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_SENS_MASK (0xF000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_SENS_SHIFT (12U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_SENS(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_SENS_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_RSSI_SENS_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_DIS_MASK (0x10000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_DIS_SHIFT (16U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SEL_SNR_MODE_MASK (0x20000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SEL_SNR_MODE_SHIFT (17U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MEAS_TRANS_TO_IDLE_MASK (0x40000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MEAS_TRANS_TO_IDLE_SHIFT (18U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_CCA1_ED_EN_DIS_MASK (0x80000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_CCA1_ED_EN_DIS_SHIFT (19U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_MEAS_COMPLETE_MASK (0x100000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_MEAS_COMPLETE_SHIFT (20U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_AA_MATCH_MASK (0x200000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_MAN_AA_MATCH_SHIFT (21U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_MASK (0xF000000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_SHIFT (24U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_SNR_LQI_WEIGHT_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_BIAS_MASK (0xF0000000U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_BIAS_SHIFT (28U)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_BIAS(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_BIAS_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_LQI_BIAS_MASK)

/*! @name CCA_ED_LQI_STAT_0 - RX_DIG CCA ED LQI Status Register 0 */
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_LQI_OUT_MASK (0xFFU)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_LQI_OUT_SHIFT (0U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_LQI_OUT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_STAT_0_LQI_OUT_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_STAT_0_LQI_OUT_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_ED_OUT_MASK (0xFF00U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_ED_OUT_SHIFT (8U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_ED_OUT(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_STAT_0_ED_OUT_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_STAT_0_ED_OUT_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_SNR_OUT_MASK (0xFF0000U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_SNR_OUT_SHIFT (16U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_SNR_OUT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_STAT_0_SNR_OUT_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_STAT_0_SNR_OUT_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_CCA1_STATE_MASK (0x1000000U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_CCA1_STATE_SHIFT (24U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_MEAS_COMPLETE_MASK (0x2000000U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0_MEAS_COMPLETE_SHIFT (25U)

/*! @name CCA_ED_LQI_STAT_1 - RX_DIG CCA ED LQI Status Register 1 */
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_RSSI_MASK (0xFFU)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_RSSI_SHIFT (0U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_RSSI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_RSSI_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_RSSI_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_RSSI_AVG_MASK (0xFF00U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_RSSI_AVG_SHIFT (8U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_RSSI_AVG(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_RSSI_AVG_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_RSSI_AVG_MASK)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_SNR_AVG_MASK (0xFF0000U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_SNR_AVG_SHIFT (16U)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_SNR_AVG(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_SNR_AVG_SHIFT)) & XCVR_RX_DIG_CCA_ED_LQI_STAT_1_DFT_SNR_AVG_MASK)

/*! @name RX_CHF_COEF_0 - Receive Channel Filter Coefficient 0 */
#define XCVR_RX_DIG_RX_CHF_COEF_0_RX_CH_FILT_H0_MASK (0x3FU)
#define XCVR_RX_DIG_RX_CHF_COEF_0_RX_CH_FILT_H0_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_0_RX_CH_FILT_H0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_0_RX_CH_FILT_H0_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_0_RX_CH_FILT_H0_MASK)

/*! @name RX_CHF_COEF_1 - Receive Channel Filter Coefficient 1 */
#define XCVR_RX_DIG_RX_CHF_COEF_1_RX_CH_FILT_H1_MASK (0x3FU)
#define XCVR_RX_DIG_RX_CHF_COEF_1_RX_CH_FILT_H1_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_1_RX_CH_FILT_H1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_1_RX_CH_FILT_H1_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_1_RX_CH_FILT_H1_MASK)

/*! @name RX_CHF_COEF_2 - Receive Channel Filter Coefficient 2 */
#define XCVR_RX_DIG_RX_CHF_COEF_2_RX_CH_FILT_H2_MASK (0x7FU)
#define XCVR_RX_DIG_RX_CHF_COEF_2_RX_CH_FILT_H2_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_2_RX_CH_FILT_H2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_2_RX_CH_FILT_H2_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_2_RX_CH_FILT_H2_MASK)

/*! @name RX_CHF_COEF_3 - Receive Channel Filter Coefficient 3 */
#define XCVR_RX_DIG_RX_CHF_COEF_3_RX_CH_FILT_H3_MASK (0x7FU)
#define XCVR_RX_DIG_RX_CHF_COEF_3_RX_CH_FILT_H3_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_3_RX_CH_FILT_H3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_3_RX_CH_FILT_H3_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_3_RX_CH_FILT_H3_MASK)

/*! @name RX_CHF_COEF_4 - Receive Channel Filter Coefficient 4 */
#define XCVR_RX_DIG_RX_CHF_COEF_4_RX_CH_FILT_H4_MASK (0x7FU)
#define XCVR_RX_DIG_RX_CHF_COEF_4_RX_CH_FILT_H4_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_4_RX_CH_FILT_H4(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_4_RX_CH_FILT_H4_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_4_RX_CH_FILT_H4_MASK)

/*! @name RX_CHF_COEF_5 - Receive Channel Filter Coefficient 5 */
#define XCVR_RX_DIG_RX_CHF_COEF_5_RX_CH_FILT_H5_MASK (0x7FU)
#define XCVR_RX_DIG_RX_CHF_COEF_5_RX_CH_FILT_H5_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_5_RX_CH_FILT_H5(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_5_RX_CH_FILT_H5_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_5_RX_CH_FILT_H5_MASK)

/*! @name RX_CHF_COEF_6 - Receive Channel Filter Coefficient 6 */
#define XCVR_RX_DIG_RX_CHF_COEF_6_RX_CH_FILT_H6_MASK (0xFFU)
#define XCVR_RX_DIG_RX_CHF_COEF_6_RX_CH_FILT_H6_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_6_RX_CH_FILT_H6(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_6_RX_CH_FILT_H6_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_6_RX_CH_FILT_H6_MASK)

/*! @name RX_CHF_COEF_7 - Receive Channel Filter Coefficient 7 */
#define XCVR_RX_DIG_RX_CHF_COEF_7_RX_CH_FILT_H7_MASK (0xFFU)
#define XCVR_RX_DIG_RX_CHF_COEF_7_RX_CH_FILT_H7_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_7_RX_CH_FILT_H7(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_7_RX_CH_FILT_H7_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_7_RX_CH_FILT_H7_MASK)

/*! @name RX_CHF_COEF_8 - Receive Channel Filter Coefficient 8 */
#define XCVR_RX_DIG_RX_CHF_COEF_8_RX_CH_FILT_H8_MASK (0x1FFU)
#define XCVR_RX_DIG_RX_CHF_COEF_8_RX_CH_FILT_H8_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_8_RX_CH_FILT_H8(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_8_RX_CH_FILT_H8_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_8_RX_CH_FILT_H8_MASK)

/*! @name RX_CHF_COEF_9 - Receive Channel Filter Coefficient 9 */
#define XCVR_RX_DIG_RX_CHF_COEF_9_RX_CH_FILT_H9_MASK (0x1FFU)
#define XCVR_RX_DIG_RX_CHF_COEF_9_RX_CH_FILT_H9_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_9_RX_CH_FILT_H9(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_9_RX_CH_FILT_H9_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_9_RX_CH_FILT_H9_MASK)

/*! @name RX_CHF_COEF_10 - Receive Channel Filter Coefficient 10 */
#define XCVR_RX_DIG_RX_CHF_COEF_10_RX_CH_FILT_H10_MASK (0x3FFU)
#define XCVR_RX_DIG_RX_CHF_COEF_10_RX_CH_FILT_H10_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_10_RX_CH_FILT_H10(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_10_RX_CH_FILT_H10_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_10_RX_CH_FILT_H10_MASK)

/*! @name RX_CHF_COEF_11 - Receive Channel Filter Coefficient 11 */
#define XCVR_RX_DIG_RX_CHF_COEF_11_RX_CH_FILT_H11_MASK (0x3FFU)
#define XCVR_RX_DIG_RX_CHF_COEF_11_RX_CH_FILT_H11_SHIFT (0U)
#define XCVR_RX_DIG_RX_CHF_COEF_11_RX_CH_FILT_H11(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_CHF_COEF_11_RX_CH_FILT_H11_SHIFT)) & XCVR_RX_DIG_RX_CHF_COEF_11_RX_CH_FILT_H11_MASK)

/*! @name AGC_MAN_AGC_IDX - AGC Manual AGC Index */
#define XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_MASK (0x1F0000U)
#define XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_SHIFT (16U)
#define XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_SHIFT)) & XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_MASK)
#define XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_EN_MASK (0x1000000U)
#define XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_MAN_IDX_EN_SHIFT (24U)
#define XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_DCOC_START_PT_MASK (0x2000000U)
#define XCVR_RX_DIG_AGC_MAN_AGC_IDX_AGC_DCOC_START_PT_SHIFT (25U)

/*! @name DC_RESID_CTRL - DC Residual Control */
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_NWIN_MASK (0x7FU)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_NWIN_SHIFT (0U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_NWIN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_NWIN_SHIFT)) & XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_NWIN_MASK)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ITER_FREEZE_MASK (0xF00U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ITER_FREEZE_SHIFT (8U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ITER_FREEZE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ITER_FREEZE_SHIFT)) & XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ITER_FREEZE_MASK)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ALPHA_MASK (0x7000U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ALPHA_SHIFT (12U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ALPHA(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ALPHA_SHIFT)) & XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_ALPHA_MASK)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_DLY_MASK (0x70000U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_DLY_SHIFT (16U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_DLY(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_DLY_SHIFT)) & XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_DLY_MASK)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_EXT_DC_EN_MASK (0x100000U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_EXT_DC_EN_SHIFT (20U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_MIN_AGC_IDX_MASK (0x1F000000U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_MIN_AGC_IDX_SHIFT (24U)
#define XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_MIN_AGC_IDX(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_MIN_AGC_IDX_SHIFT)) & XCVR_RX_DIG_DC_RESID_CTRL_DC_RESID_MIN_AGC_IDX_MASK)

/*! @name DC_RESID_EST - DC Residual Estimate */
#define XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_I_MASK (0x1FFFU)
#define XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_I_SHIFT (0U)
#define XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_I(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_I_SHIFT)) & XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_I_MASK)
#define XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_Q_MASK (0x1FFF0000U)
#define XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_Q_SHIFT (16U)
#define XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_Q(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_Q_SHIFT)) & XCVR_RX_DIG_DC_RESID_EST_DC_RESID_OFFSET_Q_MASK)

/*! @name RX_RCCAL_CTRL0 - RX RC Calibration Control0 */
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_OFFSET_MASK (0xFU)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_OFFSET_SHIFT (0U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_OFFSET(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_OFFSET_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_OFFSET_MASK)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_MANUAL_MASK (0x1F0U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_MANUAL_SHIFT (4U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_MANUAL_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_MANUAL_MASK)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_DIS_MASK (0x200U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_BBA_RCCAL_DIS_SHIFT (9U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY_MASK (0x3000U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY_SHIFT (12U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_SMP_DLY_MASK)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_COMP_INV_MASK (0x8000U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_RCCAL_COMP_INV_SHIFT (15U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_OFFSET_MASK (0xF0000U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_OFFSET_SHIFT (16U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_OFFSET(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_OFFSET_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_OFFSET_MASK)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_MANUAL_MASK (0x1F00000U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_MANUAL_SHIFT (20U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_MANUAL_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_MANUAL_MASK)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_DIS_MASK (0x2000000U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0_TZA_RCCAL_DIS_SHIFT (25U)

/*! @name RX_RCCAL_CTRL1 - RX RC Calibration Control1 */
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_OFFSET_MASK (0xFU)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_OFFSET_SHIFT (0U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_OFFSET(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_OFFSET_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_OFFSET_MASK)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_MANUAL_MASK (0x1F0U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_MANUAL_SHIFT (4U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_MANUAL_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_MANUAL_MASK)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_DIS_MASK (0x200U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_ADC_RCCAL_DIS_SHIFT (9U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_OFFSET_MASK (0xF0000U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_OFFSET_SHIFT (16U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_OFFSET(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_OFFSET_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_OFFSET_MASK)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_MANUAL_MASK (0x1F00000U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_MANUAL_SHIFT (20U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_MANUAL_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_MANUAL_MASK)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_DIS_MASK (0x2000000U)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1_BBA2_RCCAL_DIS_SHIFT (25U)

/*! @name RX_RCCAL_STAT - RX RC Calibration Status */
#define XCVR_RX_DIG_RX_RCCAL_STAT_RCCAL_CODE_MASK (0x1FU)
#define XCVR_RX_DIG_RX_RCCAL_STAT_RCCAL_CODE_SHIFT (0U)
#define XCVR_RX_DIG_RX_RCCAL_STAT_RCCAL_CODE(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_STAT_RCCAL_CODE_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_STAT_RCCAL_CODE_MASK)
#define XCVR_RX_DIG_RX_RCCAL_STAT_ADC_RCCAL_MASK (0x3E0U)
#define XCVR_RX_DIG_RX_RCCAL_STAT_ADC_RCCAL_SHIFT (5U)
#define XCVR_RX_DIG_RX_RCCAL_STAT_ADC_RCCAL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_STAT_ADC_RCCAL_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_STAT_ADC_RCCAL_MASK)
#define XCVR_RX_DIG_RX_RCCAL_STAT_BBA2_RCCAL_MASK (0x7C00U)
#define XCVR_RX_DIG_RX_RCCAL_STAT_BBA2_RCCAL_SHIFT (10U)
#define XCVR_RX_DIG_RX_RCCAL_STAT_BBA2_RCCAL(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_STAT_BBA2_RCCAL_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_STAT_BBA2_RCCAL_MASK)
#define XCVR_RX_DIG_RX_RCCAL_STAT_BBA_RCCAL_MASK (0x1F0000U)
#define XCVR_RX_DIG_RX_RCCAL_STAT_BBA_RCCAL_SHIFT (16U)
#define XCVR_RX_DIG_RX_RCCAL_STAT_BBA_RCCAL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_STAT_BBA_RCCAL_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_STAT_BBA_RCCAL_MASK)
#define XCVR_RX_DIG_RX_RCCAL_STAT_TZA_RCCAL_MASK (0x3E00000U)
#define XCVR_RX_DIG_RX_RCCAL_STAT_TZA_RCCAL_SHIFT (21U)
#define XCVR_RX_DIG_RX_RCCAL_STAT_TZA_RCCAL(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RX_RCCAL_STAT_TZA_RCCAL_SHIFT)) & XCVR_RX_DIG_RX_RCCAL_STAT_TZA_RCCAL_MASK)

/*! @name AUXPLL_FCAL_CTRL - Aux PLL Frequency Calibration Control */
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MANUAL_MASK (0x7FU)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MANUAL_SHIFT (0U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MANUAL_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MANUAL_MASK)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_AUXPLL_DAC_CAL_ADJUST_DIS_MASK (0x80U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_AUXPLL_DAC_CAL_ADJUST_DIS_SHIFT (7U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_RUN_CNT_MASK (0x100U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_RUN_CNT_SHIFT (8U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_COMP_INV_MASK (0x200U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_COMP_INV_SHIFT (9U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY_MASK (0xC00U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY_SHIFT (10U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CTRL_FCAL_SMP_DLY_MASK)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MASK (0x7F0000U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_SHIFT (16U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CTRL_DAC_CAL_ADJUST_MASK)

/*! @name AUXPLL_FCAL_CNT6 - Aux PLL Frequency Calibration Count 6 */
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_COUNT_6_MASK (0x3FFU)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_COUNT_6_SHIFT (0U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_COUNT_6(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_COUNT_6_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_COUNT_6_MASK)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_BESTDIFF_MASK (0x3FF0000U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_BESTDIFF_SHIFT (16U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_BESTDIFF(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_BESTDIFF_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CNT6_FCAL_BESTDIFF_MASK)

/*! @name AUXPLL_FCAL_CNT5_4 - Aux PLL Frequency Calibration Count 5 and 4 */
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_4_MASK (0x3FFU)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_4_SHIFT (0U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_4(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_4_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_4_MASK)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_5_MASK (0x3FF0000U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_5_SHIFT (16U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_5(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_5_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_FCAL_COUNT_5_MASK)

/*! @name AUXPLL_FCAL_CNT3_2 - Aux PLL Frequency Calibration Count 3 and 2 */
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_2_MASK (0x3FFU)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_2_SHIFT (0U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_2_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_2_MASK)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_3_MASK (0x3FF0000U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_3_SHIFT (16U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_3(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_3_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_FCAL_COUNT_3_MASK)

/*! @name AUXPLL_FCAL_CNT1_0 - Aux PLL Frequency Calibration Count 1 and 0 */
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_0_MASK (0x3FFU)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_0_SHIFT (0U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_0_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_0_MASK)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_1_MASK (0x3FF0000U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_1_SHIFT (16U)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_1_SHIFT)) & XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_FCAL_COUNT_1_MASK)

/*! @name RXDIG_DFT - RXDIG DFT */
#define XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_MASK (0x7U)
#define XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_SHIFT (0U)
#define XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_SHIFT)) & XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_FREQ_MASK)
#define XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_SCALE_MASK (0x8U)
#define XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_SCALE_SHIFT (3U)
#define XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_TZA_EN_MASK (0x10U)
#define XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_TZA_EN_SHIFT (4U)
#define XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_BBA_EN_MASK (0x20U)
#define XCVR_RX_DIG_RXDIG_DFT_DFT_TONE_BBA_EN_SHIFT (5U)


/*!
 * @}
 */ /* end of group XCVR_RX_DIG_Register_Masks */


/* XCVR_RX_DIG - Peripheral instance base addresses */
/** Peripheral RX_DIG base pointer */
#define XCVR_RX_DIG_BASE_PTR                     ((XCVR_RX_DIG_MemMapPtr)0x4005C000u)
/** Array initializer of XCVR_RX_DIG peripheral base pointers */
#define XCVR_RX_DIG_BASE_PTRS                    { XCVR_RX_DIG_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- XCVR_RX_DIG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_RX_DIG_Register_Accessor_Macros XCVR_RX_DIG - Register accessor macros
 * @{
 */


/* XCVR_RX_DIG - Register instance definitions */
/* RX_DIG */
#define XCVR_RX_DIG_RX_DIG_CTRL                  XCVR_RX_DIG_RX_DIG_CTRL_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_CTRL_0                   XCVR_RX_DIG_AGC_CTRL_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_CTRL_1                   XCVR_RX_DIG_AGC_CTRL_1_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_CTRL_2                   XCVR_RX_DIG_AGC_CTRL_2_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_CTRL_3                   XCVR_RX_DIG_AGC_CTRL_3_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_STAT                     XCVR_RX_DIG_AGC_STAT_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RSSI_CTRL_0                  XCVR_RX_DIG_RSSI_CTRL_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RSSI_CTRL_1                  XCVR_RX_DIG_RSSI_CTRL_1_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RSSI_DFT                     XCVR_RX_DIG_RSSI_DFT_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_CTRL_0                  XCVR_RX_DIG_DCOC_CTRL_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_CTRL_1                  XCVR_RX_DIG_DCOC_CTRL_1_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_DAC_INIT                XCVR_RX_DIG_DCOC_DAC_INIT_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_DIG_MAN                 XCVR_RX_DIG_DCOC_DIG_MAN_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_CAL_GAIN                XCVR_RX_DIG_DCOC_CAL_GAIN_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_STAT                    XCVR_RX_DIG_DCOC_STAT_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_DC_EST                  XCVR_RX_DIG_DCOC_DC_EST_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_CAL_RCP                 XCVR_RX_DIG_DCOC_CAL_RCP_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_IQMC_CTRL                    XCVR_RX_DIG_IQMC_CTRL_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_IQMC_CAL                     XCVR_RX_DIG_IQMC_CAL_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_LNA_GAIN_VAL_3_0             XCVR_RX_DIG_LNA_GAIN_VAL_3_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_LNA_GAIN_VAL_7_4             XCVR_RX_DIG_LNA_GAIN_VAL_7_4_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_LNA_GAIN_VAL_8               XCVR_RX_DIG_LNA_GAIN_VAL_8_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0         XCVR_RX_DIG_BBA_RES_TUNE_VAL_7_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8        XCVR_RX_DIG_BBA_RES_TUNE_VAL_10_8_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0         XCVR_RX_DIG_LNA_GAIN_LIN_VAL_2_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3         XCVR_RX_DIG_LNA_GAIN_LIN_VAL_5_3_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6         XCVR_RX_DIG_LNA_GAIN_LIN_VAL_8_6_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_LNA_GAIN_LIN_VAL_9           XCVR_RX_DIG_LNA_GAIN_LIN_VAL_9_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0     XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_3_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4     XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_7_4_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8    XCVR_RX_DIG_BBA_RES_TUNE_LIN_VAL_10_8_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_GAIN_TBL_03_00           XCVR_RX_DIG_AGC_GAIN_TBL_03_00_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_GAIN_TBL_07_04           XCVR_RX_DIG_AGC_GAIN_TBL_07_04_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_GAIN_TBL_11_08           XCVR_RX_DIG_AGC_GAIN_TBL_11_08_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_GAIN_TBL_15_12           XCVR_RX_DIG_AGC_GAIN_TBL_15_12_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_GAIN_TBL_19_16           XCVR_RX_DIG_AGC_GAIN_TBL_19_16_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_GAIN_TBL_23_20           XCVR_RX_DIG_AGC_GAIN_TBL_23_20_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_GAIN_TBL_26_24           XCVR_RX_DIG_AGC_GAIN_TBL_26_24_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_OFFSET_0                XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,0)
#define XCVR_RX_DIG_DCOC_OFFSET_1                XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,1)
#define XCVR_RX_DIG_DCOC_OFFSET_2                XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,2)
#define XCVR_RX_DIG_DCOC_OFFSET_3                XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,3)
#define XCVR_RX_DIG_DCOC_OFFSET_4                XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,4)
#define XCVR_RX_DIG_DCOC_OFFSET_5                XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,5)
#define XCVR_RX_DIG_DCOC_OFFSET_6                XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,6)
#define XCVR_RX_DIG_DCOC_OFFSET_7                XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,7)
#define XCVR_RX_DIG_DCOC_OFFSET_8                XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,8)
#define XCVR_RX_DIG_DCOC_OFFSET_9                XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,9)
#define XCVR_RX_DIG_DCOC_OFFSET_10               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,10)
#define XCVR_RX_DIG_DCOC_OFFSET_11               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,11)
#define XCVR_RX_DIG_DCOC_OFFSET_12               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,12)
#define XCVR_RX_DIG_DCOC_OFFSET_13               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,13)
#define XCVR_RX_DIG_DCOC_OFFSET_14               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,14)
#define XCVR_RX_DIG_DCOC_OFFSET_15               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,15)
#define XCVR_RX_DIG_DCOC_OFFSET_16               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,16)
#define XCVR_RX_DIG_DCOC_OFFSET_17               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,17)
#define XCVR_RX_DIG_DCOC_OFFSET_18               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,18)
#define XCVR_RX_DIG_DCOC_OFFSET_19               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,19)
#define XCVR_RX_DIG_DCOC_OFFSET_20               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,20)
#define XCVR_RX_DIG_DCOC_OFFSET_21               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,21)
#define XCVR_RX_DIG_DCOC_OFFSET_22               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,22)
#define XCVR_RX_DIG_DCOC_OFFSET_23               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,23)
#define XCVR_RX_DIG_DCOC_OFFSET_24               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,24)
#define XCVR_RX_DIG_DCOC_OFFSET_25               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,25)
#define XCVR_RX_DIG_DCOC_OFFSET_26               XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,26)
#define XCVR_RX_DIG_DCOC_BBA_STEP                XCVR_RX_DIG_DCOC_BBA_STEP_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_0              XCVR_RX_DIG_DCOC_TZA_STEP_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_1              XCVR_RX_DIG_DCOC_TZA_STEP_1_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_2              XCVR_RX_DIG_DCOC_TZA_STEP_2_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_3              XCVR_RX_DIG_DCOC_TZA_STEP_3_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_4              XCVR_RX_DIG_DCOC_TZA_STEP_4_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_5              XCVR_RX_DIG_DCOC_TZA_STEP_5_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_6              XCVR_RX_DIG_DCOC_TZA_STEP_6_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_7              XCVR_RX_DIG_DCOC_TZA_STEP_7_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_8              XCVR_RX_DIG_DCOC_TZA_STEP_8_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_9              XCVR_RX_DIG_DCOC_TZA_STEP_9_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_TZA_STEP_10             XCVR_RX_DIG_DCOC_TZA_STEP_10_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_CAL_ALPHA               XCVR_RX_DIG_DCOC_CAL_ALPHA_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_CAL_BETA_Q              XCVR_RX_DIG_DCOC_CAL_BETA_Q_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_CAL_BETA_I              XCVR_RX_DIG_DCOC_CAL_BETA_I_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_CAL_GAMMA               XCVR_RX_DIG_DCOC_CAL_GAMMA_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_CAL_IIR                 XCVR_RX_DIG_DCOC_CAL_IIR_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DCOC_CAL1                    XCVR_RX_DIG_DCOC_CAL_REG(XCVR_RX_DIG_BASE_PTR,0)
#define XCVR_RX_DIG_DCOC_CAL2                    XCVR_RX_DIG_DCOC_CAL_REG(XCVR_RX_DIG_BASE_PTR,1)
#define XCVR_RX_DIG_DCOC_CAL3                    XCVR_RX_DIG_DCOC_CAL_REG(XCVR_RX_DIG_BASE_PTR,2)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_0            XCVR_RX_DIG_CCA_ED_LQI_CTRL_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_CCA_ED_LQI_CTRL_1            XCVR_RX_DIG_CCA_ED_LQI_CTRL_1_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_0            XCVR_RX_DIG_CCA_ED_LQI_STAT_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_CCA_ED_LQI_STAT_1            XCVR_RX_DIG_CCA_ED_LQI_STAT_1_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_0                XCVR_RX_DIG_RX_CHF_COEF_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_1                XCVR_RX_DIG_RX_CHF_COEF_1_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_2                XCVR_RX_DIG_RX_CHF_COEF_2_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_3                XCVR_RX_DIG_RX_CHF_COEF_3_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_4                XCVR_RX_DIG_RX_CHF_COEF_4_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_5                XCVR_RX_DIG_RX_CHF_COEF_5_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_6                XCVR_RX_DIG_RX_CHF_COEF_6_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_7                XCVR_RX_DIG_RX_CHF_COEF_7_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_8                XCVR_RX_DIG_RX_CHF_COEF_8_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_9                XCVR_RX_DIG_RX_CHF_COEF_9_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_10               XCVR_RX_DIG_RX_CHF_COEF_10_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_CHF_COEF_11               XCVR_RX_DIG_RX_CHF_COEF_11_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AGC_MAN_AGC_IDX              XCVR_RX_DIG_AGC_MAN_AGC_IDX_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DC_RESID_CTRL                XCVR_RX_DIG_DC_RESID_CTRL_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_DC_RESID_EST                 XCVR_RX_DIG_DC_RESID_EST_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_RCCAL_CTRL0               XCVR_RX_DIG_RX_RCCAL_CTRL0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_RCCAL_CTRL1               XCVR_RX_DIG_RX_RCCAL_CTRL1_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RX_RCCAL_STAT                XCVR_RX_DIG_RX_RCCAL_STAT_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AUXPLL_FCAL_CTRL             XCVR_RX_DIG_AUXPLL_FCAL_CTRL_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT6             XCVR_RX_DIG_AUXPLL_FCAL_CNT6_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4           XCVR_RX_DIG_AUXPLL_FCAL_CNT5_4_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2           XCVR_RX_DIG_AUXPLL_FCAL_CNT3_2_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0           XCVR_RX_DIG_AUXPLL_FCAL_CNT1_0_REG(XCVR_RX_DIG_BASE_PTR)
#define XCVR_RX_DIG_RXDIG_DFT                    XCVR_RX_DIG_RXDIG_DFT_REG(XCVR_RX_DIG_BASE_PTR)

/* XCVR_RX_DIG - Register array accessors */
#define XCVR_RX_DIG_DCOC_OFFSET(index)           XCVR_RX_DIG_DCOC_OFFSET_REG(XCVR_RX_DIG_BASE_PTR,index)
#define XCVR_RX_DIG_DCOC_CAL(index)              XCVR_RX_DIG_DCOC_CAL_REG(XCVR_RX_DIG_BASE_PTR,index)

/*!
 * @}
 */ /* end of group XCVR_RX_DIG_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group XCVR_RX_DIG_Peripheral */


/* ----------------------------------------------------------------------------
   -- XCVR_TSM
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_TSM_Peripheral XCVR_TSM
 * @{
 */

/** XCVR_TSM - Peripheral register structure */
typedef struct XCVR_TSM_MemMap {
  uint32_t CTRL;                                   /**< TRANSCEIVER SEQUENCE MANAGER CONTROL, offset: 0x0 */
  uint32_t END_OF_SEQ;                             /**< TSM END OF SEQUENCE, offset: 0x4 */
  uint32_t OVRD0;                                  /**< TSM OVERRIDE REGISTER 0, offset: 0x8 */
  uint32_t OVRD1;                                  /**< TSM OVERRIDE REGISTER 1, offset: 0xC */
  uint32_t OVRD2;                                  /**< TSM OVERRIDE REGISTER 2, offset: 0x10 */
  uint32_t OVRD3;                                  /**< TSM OVERRIDE REGISTER 3, offset: 0x14 */
  uint32_t PA_POWER;                               /**< PA POWER, offset: 0x18 */
  uint32_t PA_RAMP_TBL0;                           /**< PA RAMP TABLE 0, offset: 0x1C */
  uint32_t PA_RAMP_TBL1;                           /**< PA RAMP TABLE 1, offset: 0x20 */
  uint32_t RECYCLE_COUNT;                          /**< TSM RECYCLE COUNT, offset: 0x24 */
  uint32_t FAST_CTRL1;                             /**< TSM FAST WARMUP CONTROL REGISTER 1, offset: 0x28 */
  uint32_t FAST_CTRL2;                             /**< TSM FAST WARMUP CONTROL REGISTER 2, offset: 0x2C */
  uint32_t TIMING00;                               /**< TSM_TIMING00, offset: 0x30 */
  uint32_t TIMING01;                               /**< TSM_TIMING01, offset: 0x34 */
  uint32_t TIMING02;                               /**< TSM_TIMING02, offset: 0x38 */
  uint32_t TIMING03;                               /**< TSM_TIMING03, offset: 0x3C */
  uint32_t TIMING04;                               /**< TSM_TIMING04, offset: 0x40 */
  uint32_t TIMING05;                               /**< TSM_TIMING05, offset: 0x44 */
  uint32_t TIMING06;                               /**< TSM_TIMING06, offset: 0x48 */
  uint32_t TIMING07;                               /**< TSM_TIMING07, offset: 0x4C */
  uint32_t TIMING08;                               /**< TSM_TIMING08, offset: 0x50 */
  uint32_t TIMING09;                               /**< TSM_TIMING09, offset: 0x54 */
  uint32_t TIMING10;                               /**< TSM_TIMING10, offset: 0x58 */
  uint32_t TIMING11;                               /**< TSM_TIMING11, offset: 0x5C */
  uint32_t TIMING12;                               /**< TSM_TIMING12, offset: 0x60 */
  uint32_t TIMING13;                               /**< TSM_TIMING13, offset: 0x64 */
  uint32_t TIMING14;                               /**< TSM_TIMING14, offset: 0x68 */
  uint32_t TIMING15;                               /**< TSM_TIMING15, offset: 0x6C */
  uint32_t TIMING16;                               /**< TSM_TIMING16, offset: 0x70 */
  uint32_t TIMING17;                               /**< TSM_TIMING17, offset: 0x74 */
  uint32_t TIMING18;                               /**< TSM_TIMING18, offset: 0x78 */
  uint32_t TIMING19;                               /**< TSM_TIMING19, offset: 0x7C */
  uint32_t TIMING20;                               /**< TSM_TIMING20, offset: 0x80 */
  uint32_t TIMING21;                               /**< TSM_TIMING21, offset: 0x84 */
  uint32_t TIMING22;                               /**< TSM_TIMING22, offset: 0x88 */
  uint32_t TIMING23;                               /**< TSM_TIMING23, offset: 0x8C */
  uint32_t TIMING24;                               /**< TSM_TIMING24, offset: 0x90 */
  uint32_t TIMING25;                               /**< TSM_TIMING25, offset: 0x94 */
  uint32_t TIMING26;                               /**< TSM_TIMING26, offset: 0x98 */
  uint32_t TIMING27;                               /**< TSM_TIMING27, offset: 0x9C */
  uint32_t TIMING28;                               /**< TSM_TIMING28, offset: 0xA0 */
  uint32_t TIMING29;                               /**< TSM_TIMING29, offset: 0xA4 */
  uint32_t TIMING30;                               /**< TSM_TIMING30, offset: 0xA8 */
  uint32_t TIMING31;                               /**< TSM_TIMING31, offset: 0xAC */
  uint32_t TIMING32;                               /**< TSM_TIMING32, offset: 0xB0 */
  uint32_t TIMING33;                               /**< TSM_TIMING33, offset: 0xB4 */
  uint32_t TIMING34;                               /**< TSM_TIMING34, offset: 0xB8 */
  uint32_t TIMING35;                               /**< TSM_TIMING35, offset: 0xBC */
  uint32_t TIMING36;                               /**< TSM_TIMING36, offset: 0xC0 */
  uint32_t TIMING37;                               /**< TSM_TIMING37, offset: 0xC4 */
  uint32_t TIMING38;                               /**< TSM_TIMING38, offset: 0xC8 */
  uint32_t TIMING39;                               /**< TSM_TIMING39, offset: 0xCC */
  uint32_t TIMING40;                               /**< TSM_TIMING40, offset: 0xD0 */
  uint32_t TIMING41;                               /**< TSM_TIMING41, offset: 0xD4 */
  uint32_t TIMING42;                               /**< TSM_TIMING42, offset: 0xD8 */
  uint32_t TIMING43;                               /**< TSM_TIMING43, offset: 0xDC */
  uint32_t TIMING44;                               /**< TSM_TIMING44, offset: 0xE0 */
  uint32_t TIMING45;                               /**< TSM_TIMING45, offset: 0xE4 */
  uint32_t TIMING46;                               /**< TSM_TIMING46, offset: 0xE8 */
  uint32_t TIMING47;                               /**< TSM_TIMING47, offset: 0xEC */
  uint32_t TIMING48;                               /**< TSM_TIMING48, offset: 0xF0 */
  uint32_t TIMING49;                               /**< TSM_TIMING49, offset: 0xF4 */
  uint32_t TIMING50;                               /**< TSM_TIMING50, offset: 0xF8 */
  uint32_t TIMING51;                               /**< TSM_TIMING51, offset: 0xFC */
  uint32_t TIMING52;                               /**< TSM_TIMING52, offset: 0x100 */
  uint32_t TIMING53;                               /**< TSM_TIMING53, offset: 0x104 */
  uint32_t TIMING54;                               /**< TSM_TIMING54, offset: 0x108 */
  uint32_t TIMING55;                               /**< TSM_TIMING55, offset: 0x10C */
  uint32_t TIMING56;                               /**< TSM_TIMING56, offset: 0x110 */
  uint32_t TIMING57;                               /**< TSM_TIMING57, offset: 0x114 */
  uint32_t TIMING58;                               /**< TSM_TIMING58, offset: 0x118 */
} volatile *XCVR_TSM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- XCVR_TSM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_TSM_Register_Accessor_Macros XCVR_TSM - Register accessor macros
 * @{
 */


/* XCVR_TSM - Register accessors */
#define XCVR_TSM_CTRL_REG(base)                  ((base)->CTRL)
#define XCVR_TSM_END_OF_SEQ_REG(base)            ((base)->END_OF_SEQ)
#define XCVR_TSM_OVRD0_REG(base)                 ((base)->OVRD0)
#define XCVR_TSM_OVRD1_REG(base)                 ((base)->OVRD1)
#define XCVR_TSM_OVRD2_REG(base)                 ((base)->OVRD2)
#define XCVR_TSM_OVRD3_REG(base)                 ((base)->OVRD3)
#define XCVR_TSM_PA_POWER_REG(base)              ((base)->PA_POWER)
#define XCVR_TSM_PA_RAMP_TBL0_REG(base)          ((base)->PA_RAMP_TBL0)
#define XCVR_TSM_PA_RAMP_TBL1_REG(base)          ((base)->PA_RAMP_TBL1)
#define XCVR_TSM_RECYCLE_COUNT_REG(base)         ((base)->RECYCLE_COUNT)
#define XCVR_TSM_FAST_CTRL1_REG(base)            ((base)->FAST_CTRL1)
#define XCVR_TSM_FAST_CTRL2_REG(base)            ((base)->FAST_CTRL2)
#define XCVR_TSM_TIMING00_REG(base)              ((base)->TIMING00)
#define XCVR_TSM_TIMING01_REG(base)              ((base)->TIMING01)
#define XCVR_TSM_TIMING02_REG(base)              ((base)->TIMING02)
#define XCVR_TSM_TIMING03_REG(base)              ((base)->TIMING03)
#define XCVR_TSM_TIMING04_REG(base)              ((base)->TIMING04)
#define XCVR_TSM_TIMING05_REG(base)              ((base)->TIMING05)
#define XCVR_TSM_TIMING06_REG(base)              ((base)->TIMING06)
#define XCVR_TSM_TIMING07_REG(base)              ((base)->TIMING07)
#define XCVR_TSM_TIMING08_REG(base)              ((base)->TIMING08)
#define XCVR_TSM_TIMING09_REG(base)              ((base)->TIMING09)
#define XCVR_TSM_TIMING10_REG(base)              ((base)->TIMING10)
#define XCVR_TSM_TIMING11_REG(base)              ((base)->TIMING11)
#define XCVR_TSM_TIMING12_REG(base)              ((base)->TIMING12)
#define XCVR_TSM_TIMING13_REG(base)              ((base)->TIMING13)
#define XCVR_TSM_TIMING14_REG(base)              ((base)->TIMING14)
#define XCVR_TSM_TIMING15_REG(base)              ((base)->TIMING15)
#define XCVR_TSM_TIMING16_REG(base)              ((base)->TIMING16)
#define XCVR_TSM_TIMING17_REG(base)              ((base)->TIMING17)
#define XCVR_TSM_TIMING18_REG(base)              ((base)->TIMING18)
#define XCVR_TSM_TIMING19_REG(base)              ((base)->TIMING19)
#define XCVR_TSM_TIMING20_REG(base)              ((base)->TIMING20)
#define XCVR_TSM_TIMING21_REG(base)              ((base)->TIMING21)
#define XCVR_TSM_TIMING22_REG(base)              ((base)->TIMING22)
#define XCVR_TSM_TIMING23_REG(base)              ((base)->TIMING23)
#define XCVR_TSM_TIMING24_REG(base)              ((base)->TIMING24)
#define XCVR_TSM_TIMING25_REG(base)              ((base)->TIMING25)
#define XCVR_TSM_TIMING26_REG(base)              ((base)->TIMING26)
#define XCVR_TSM_TIMING27_REG(base)              ((base)->TIMING27)
#define XCVR_TSM_TIMING28_REG(base)              ((base)->TIMING28)
#define XCVR_TSM_TIMING29_REG(base)              ((base)->TIMING29)
#define XCVR_TSM_TIMING30_REG(base)              ((base)->TIMING30)
#define XCVR_TSM_TIMING31_REG(base)              ((base)->TIMING31)
#define XCVR_TSM_TIMING32_REG(base)              ((base)->TIMING32)
#define XCVR_TSM_TIMING33_REG(base)              ((base)->TIMING33)
#define XCVR_TSM_TIMING34_REG(base)              ((base)->TIMING34)
#define XCVR_TSM_TIMING35_REG(base)              ((base)->TIMING35)
#define XCVR_TSM_TIMING36_REG(base)              ((base)->TIMING36)
#define XCVR_TSM_TIMING37_REG(base)              ((base)->TIMING37)
#define XCVR_TSM_TIMING38_REG(base)              ((base)->TIMING38)
#define XCVR_TSM_TIMING39_REG(base)              ((base)->TIMING39)
#define XCVR_TSM_TIMING40_REG(base)              ((base)->TIMING40)
#define XCVR_TSM_TIMING41_REG(base)              ((base)->TIMING41)
#define XCVR_TSM_TIMING42_REG(base)              ((base)->TIMING42)
#define XCVR_TSM_TIMING43_REG(base)              ((base)->TIMING43)
#define XCVR_TSM_TIMING44_REG(base)              ((base)->TIMING44)
#define XCVR_TSM_TIMING45_REG(base)              ((base)->TIMING45)
#define XCVR_TSM_TIMING46_REG(base)              ((base)->TIMING46)
#define XCVR_TSM_TIMING47_REG(base)              ((base)->TIMING47)
#define XCVR_TSM_TIMING48_REG(base)              ((base)->TIMING48)
#define XCVR_TSM_TIMING49_REG(base)              ((base)->TIMING49)
#define XCVR_TSM_TIMING50_REG(base)              ((base)->TIMING50)
#define XCVR_TSM_TIMING51_REG(base)              ((base)->TIMING51)
#define XCVR_TSM_TIMING52_REG(base)              ((base)->TIMING52)
#define XCVR_TSM_TIMING53_REG(base)              ((base)->TIMING53)
#define XCVR_TSM_TIMING54_REG(base)              ((base)->TIMING54)
#define XCVR_TSM_TIMING55_REG(base)              ((base)->TIMING55)
#define XCVR_TSM_TIMING56_REG(base)              ((base)->TIMING56)
#define XCVR_TSM_TIMING57_REG(base)              ((base)->TIMING57)
#define XCVR_TSM_TIMING58_REG(base)              ((base)->TIMING58)

/*!
 * @}
 */ /* end of group XCVR_TSM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- XCVR_TSM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_TSM_Register_Masks XCVR_TSM Register Masks
 * @{
 */

/*! @name CTRL - TRANSCEIVER SEQUENCE MANAGER CONTROL */
#define XCVR_TSM_CTRL_FORCE_TX_EN_MASK           (0x4U)
#define XCVR_TSM_CTRL_FORCE_TX_EN_SHIFT          (2U)
#define XCVR_TSM_CTRL_FORCE_RX_EN_MASK           (0x8U)
#define XCVR_TSM_CTRL_FORCE_RX_EN_SHIFT          (3U)
#define XCVR_TSM_CTRL_PA_RAMP_SEL_MASK           (0x30U)
#define XCVR_TSM_CTRL_PA_RAMP_SEL_SHIFT          (4U)
#define XCVR_TSM_CTRL_PA_RAMP_SEL(x)             (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_CTRL_PA_RAMP_SEL_SHIFT)) & XCVR_TSM_CTRL_PA_RAMP_SEL_MASK)
#define XCVR_TSM_CTRL_DATA_PADDING_EN_MASK       (0xC0U)
#define XCVR_TSM_CTRL_DATA_PADDING_EN_SHIFT      (6U)
#define XCVR_TSM_CTRL_DATA_PADDING_EN(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_CTRL_DATA_PADDING_EN_SHIFT)) & XCVR_TSM_CTRL_DATA_PADDING_EN_MASK)
#define XCVR_TSM_CTRL_TSM_IRQ0_EN_MASK           (0x100U)
#define XCVR_TSM_CTRL_TSM_IRQ0_EN_SHIFT          (8U)
#define XCVR_TSM_CTRL_TSM_IRQ1_EN_MASK           (0x200U)
#define XCVR_TSM_CTRL_TSM_IRQ1_EN_SHIFT          (9U)
#define XCVR_TSM_CTRL_RAMP_DN_DELAY_MASK         (0xF000U)
#define XCVR_TSM_CTRL_RAMP_DN_DELAY_SHIFT        (12U)
#define XCVR_TSM_CTRL_RAMP_DN_DELAY(x)           (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_CTRL_RAMP_DN_DELAY_SHIFT)) & XCVR_TSM_CTRL_RAMP_DN_DELAY_MASK)
#define XCVR_TSM_CTRL_TX_ABORT_DIS_MASK          (0x10000U)
#define XCVR_TSM_CTRL_TX_ABORT_DIS_SHIFT         (16U)
#define XCVR_TSM_CTRL_RX_ABORT_DIS_MASK          (0x20000U)
#define XCVR_TSM_CTRL_RX_ABORT_DIS_SHIFT         (17U)
#define XCVR_TSM_CTRL_ABORT_ON_CTUNE_MASK        (0x40000U)
#define XCVR_TSM_CTRL_ABORT_ON_CTUNE_SHIFT       (18U)
#define XCVR_TSM_CTRL_ABORT_ON_CYCLE_SLIP_MASK   (0x80000U)
#define XCVR_TSM_CTRL_ABORT_ON_CYCLE_SLIP_SHIFT  (19U)
#define XCVR_TSM_CTRL_ABORT_ON_FREQ_TARG_MASK    (0x100000U)
#define XCVR_TSM_CTRL_ABORT_ON_FREQ_TARG_SHIFT   (20U)
#define XCVR_TSM_CTRL_BKPT_MASK                  (0xFF000000U)
#define XCVR_TSM_CTRL_BKPT_SHIFT                 (24U)
#define XCVR_TSM_CTRL_BKPT(x)                    (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_CTRL_BKPT_SHIFT)) & XCVR_TSM_CTRL_BKPT_MASK)

/*! @name END_OF_SEQ - TSM END OF SEQUENCE */
#define XCVR_TSM_END_OF_SEQ_END_OF_TX_WU_MASK    (0xFFU)
#define XCVR_TSM_END_OF_SEQ_END_OF_TX_WU_SHIFT   (0U)
#define XCVR_TSM_END_OF_SEQ_END_OF_TX_WU(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_END_OF_SEQ_END_OF_TX_WU_SHIFT)) & XCVR_TSM_END_OF_SEQ_END_OF_TX_WU_MASK)
#define XCVR_TSM_END_OF_SEQ_END_OF_TX_WD_MASK    (0xFF00U)
#define XCVR_TSM_END_OF_SEQ_END_OF_TX_WD_SHIFT   (8U)
#define XCVR_TSM_END_OF_SEQ_END_OF_TX_WD(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_END_OF_SEQ_END_OF_TX_WD_SHIFT)) & XCVR_TSM_END_OF_SEQ_END_OF_TX_WD_MASK)
#define XCVR_TSM_END_OF_SEQ_END_OF_RX_WU_MASK    (0xFF0000U)
#define XCVR_TSM_END_OF_SEQ_END_OF_RX_WU_SHIFT   (16U)
#define XCVR_TSM_END_OF_SEQ_END_OF_RX_WU(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_END_OF_SEQ_END_OF_RX_WU_SHIFT)) & XCVR_TSM_END_OF_SEQ_END_OF_RX_WU_MASK)
#define XCVR_TSM_END_OF_SEQ_END_OF_RX_WD_MASK    (0xFF000000U)
#define XCVR_TSM_END_OF_SEQ_END_OF_RX_WD_SHIFT   (24U)
#define XCVR_TSM_END_OF_SEQ_END_OF_RX_WD(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_END_OF_SEQ_END_OF_RX_WD_SHIFT)) & XCVR_TSM_END_OF_SEQ_END_OF_RX_WD_MASK)

/*! @name OVRD0 - TSM OVERRIDE REGISTER 0 */
#define XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_EN_MASK (0x1U)
#define XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_EN_SHIFT (0U)
#define XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_MASK    (0x2U)
#define XCVR_TSM_OVRD0_BB_LDO_HF_EN_OVRD_SHIFT   (1U)
#define XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_EN_MASK (0x4U)
#define XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_EN_SHIFT (2U)
#define XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_MASK (0x8U)
#define XCVR_TSM_OVRD0_BB_LDO_ADCDAC_EN_OVRD_SHIFT (3U)
#define XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_EN_MASK (0x10U)
#define XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_EN_SHIFT (4U)
#define XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_MASK   (0x20U)
#define XCVR_TSM_OVRD0_BB_LDO_BBA_EN_OVRD_SHIFT  (5U)
#define XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_EN_MASK (0x40U)
#define XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_EN_SHIFT (6U)
#define XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_MASK    (0x80U)
#define XCVR_TSM_OVRD0_BB_LDO_PD_EN_OVRD_SHIFT   (7U)
#define XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_EN_MASK (0x100U)
#define XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_EN_SHIFT (8U)
#define XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_MASK  (0x200U)
#define XCVR_TSM_OVRD0_BB_LDO_FDBK_EN_OVRD_SHIFT (9U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_EN_MASK (0x400U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_EN_SHIFT (10U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_MASK (0x800U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_EN_OVRD_SHIFT (11U)
#define XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_EN_MASK (0x1000U)
#define XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_EN_SHIFT (12U)
#define XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_MASK (0x2000U)
#define XCVR_TSM_OVRD0_BB_LDO_VTREF_EN_OVRD_SHIFT (13U)
#define XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_EN_MASK (0x4000U)
#define XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_EN_SHIFT (14U)
#define XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_MASK (0x8000U)
#define XCVR_TSM_OVRD0_BB_LDO_FDBK_BLEED_EN_OVRD_SHIFT (15U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_EN_MASK (0x10000U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_EN_SHIFT (16U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_MASK (0x20000U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_BLEED_EN_OVRD_SHIFT (17U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN_MASK (0x40000U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_EN_SHIFT (18U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_MASK (0x80000U)
#define XCVR_TSM_OVRD0_BB_LDO_VCOLO_FASTCHARGE_EN_OVRD_SHIFT (19U)
#define XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_EN_MASK (0x100000U)
#define XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_EN_SHIFT (20U)
#define XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_MASK (0x200000U)
#define XCVR_TSM_OVRD0_BB_XTAL_PLL_REF_CLK_EN_OVRD_SHIFT (21U)
#define XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_EN_MASK (0x400000U)
#define XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_EN_SHIFT (22U)
#define XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_MASK (0x800000U)
#define XCVR_TSM_OVRD0_BB_XTAL_DAC_REF_CLK_EN_OVRD_SHIFT (23U)
#define XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN_MASK (0x1000000U)
#define XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_EN_SHIFT (24U)
#define XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_MASK (0x2000000U)
#define XCVR_TSM_OVRD0_BB_XTAL_AUXPLL_REF_CLK_EN_OVRD_SHIFT (25U)
#define XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_EN_MASK (0x4000000U)
#define XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_EN_SHIFT (26U)
#define XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_MASK (0x8000000U)
#define XCVR_TSM_OVRD0_SY_VCO_AUTOTUNE_EN_OVRD_SHIFT (27U)
#define XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN_MASK (0x10000000U)
#define XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_EN_SHIFT (28U)
#define XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_MASK (0x20000000U)
#define XCVR_TSM_OVRD0_SY_PD_CYCLE_SLIP_LD_EN_OVRD_SHIFT (29U)
#define XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_EN_MASK    (0x40000000U)
#define XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_EN_SHIFT   (30U)
#define XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_MASK       (0x80000000U)
#define XCVR_TSM_OVRD0_SY_VCO_EN_OVRD_SHIFT      (31U)

/*! @name OVRD1 - TSM OVERRIDE REGISTER 1 */
#define XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_EN_MASK (0x1U)
#define XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_EN_SHIFT (0U)
#define XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_MASK (0x2U)
#define XCVR_TSM_OVRD1_SY_LO_RX_BUF_EN_OVRD_SHIFT (1U)
#define XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_EN_MASK (0x4U)
#define XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_EN_SHIFT (2U)
#define XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_MASK (0x8U)
#define XCVR_TSM_OVRD1_SY_LO_TX_BUF_EN_OVRD_SHIFT (3U)
#define XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_EN_MASK   (0x10U)
#define XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_EN_SHIFT  (4U)
#define XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_MASK      (0x20U)
#define XCVR_TSM_OVRD1_SY_DIVN_EN_OVRD_SHIFT     (5U)
#define XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_EN_MASK (0x40U)
#define XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_EN_SHIFT (6U)
#define XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_MASK (0x80U)
#define XCVR_TSM_OVRD1_SY_PD_FILTER_CHARGE_EN_OVRD_SHIFT (7U)
#define XCVR_TSM_OVRD1_SY_PD_EN_OVRD_EN_MASK     (0x100U)
#define XCVR_TSM_OVRD1_SY_PD_EN_OVRD_EN_SHIFT    (8U)
#define XCVR_TSM_OVRD1_SY_PD_EN_OVRD_MASK        (0x200U)
#define XCVR_TSM_OVRD1_SY_PD_EN_OVRD_SHIFT       (9U)
#define XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_EN_MASK (0x400U)
#define XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_EN_SHIFT (10U)
#define XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_MASK   (0x800U)
#define XCVR_TSM_OVRD1_SY_LO_DIVN_EN_OVRD_SHIFT  (11U)
#define XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_EN_MASK  (0x1000U)
#define XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_EN_SHIFT (12U)
#define XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_MASK     (0x2000U)
#define XCVR_TSM_OVRD1_SY_LO_RX_EN_OVRD_SHIFT    (13U)
#define XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_EN_MASK  (0x4000U)
#define XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_EN_SHIFT (14U)
#define XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_MASK     (0x8000U)
#define XCVR_TSM_OVRD1_SY_LO_TX_EN_OVRD_SHIFT    (15U)
#define XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_EN_MASK (0x10000U)
#define XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_EN_SHIFT (16U)
#define XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_MASK  (0x20000U)
#define XCVR_TSM_OVRD1_SY_DIVN_CAL_EN_OVRD_SHIFT (17U)
#define XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_EN_MASK  (0x40000U)
#define XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_EN_SHIFT (18U)
#define XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_MASK     (0x80000U)
#define XCVR_TSM_OVRD1_RX_MIXER_EN_OVRD_SHIFT    (19U)
#define XCVR_TSM_OVRD1_TX_PA_EN_OVRD_EN_MASK     (0x100000U)
#define XCVR_TSM_OVRD1_TX_PA_EN_OVRD_EN_SHIFT    (20U)
#define XCVR_TSM_OVRD1_TX_PA_EN_OVRD_MASK        (0x200000U)
#define XCVR_TSM_OVRD1_TX_PA_EN_OVRD_SHIFT       (21U)
#define XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_EN_MASK  (0x400000U)
#define XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_EN_SHIFT (22U)
#define XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_MASK     (0x800000U)
#define XCVR_TSM_OVRD1_RX_ADC_I_EN_OVRD_SHIFT    (23U)
#define XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_EN_MASK  (0x1000000U)
#define XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_EN_SHIFT (24U)
#define XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_MASK     (0x2000000U)
#define XCVR_TSM_OVRD1_RX_ADC_Q_EN_OVRD_SHIFT    (25U)
#define XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_EN_MASK (0x4000000U)
#define XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_EN_SHIFT (26U)
#define XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_MASK (0x8000000U)
#define XCVR_TSM_OVRD1_RX_ADC_RESET_EN_OVRD_SHIFT (27U)
#define XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_EN_MASK  (0x10000000U)
#define XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_EN_SHIFT (28U)
#define XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_MASK     (0x20000000U)
#define XCVR_TSM_OVRD1_RX_BBA_I_EN_OVRD_SHIFT    (29U)
#define XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_EN_MASK  (0x40000000U)
#define XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_EN_SHIFT (30U)
#define XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_MASK     (0x80000000U)
#define XCVR_TSM_OVRD1_RX_BBA_Q_EN_OVRD_SHIFT    (31U)

/*! @name OVRD2 - TSM OVERRIDE REGISTER 2 */
#define XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_EN_MASK (0x1U)
#define XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_EN_SHIFT (0U)
#define XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_MASK  (0x2U)
#define XCVR_TSM_OVRD2_RX_BBA_PDET_EN_OVRD_SHIFT (1U)
#define XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_EN_MASK (0x4U)
#define XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_EN_SHIFT (2U)
#define XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_MASK  (0x8U)
#define XCVR_TSM_OVRD2_RX_BBA_DCOC_EN_OVRD_SHIFT (3U)
#define XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_EN_MASK    (0x10U)
#define XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_EN_SHIFT   (4U)
#define XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_MASK       (0x20U)
#define XCVR_TSM_OVRD2_RX_LNA_EN_OVRD_SHIFT      (5U)
#define XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_EN_MASK  (0x40U)
#define XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_EN_SHIFT (6U)
#define XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_MASK     (0x80U)
#define XCVR_TSM_OVRD2_RX_TZA_I_EN_OVRD_SHIFT    (7U)
#define XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_EN_MASK  (0x100U)
#define XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_EN_SHIFT (8U)
#define XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_MASK     (0x200U)
#define XCVR_TSM_OVRD2_RX_TZA_Q_EN_OVRD_SHIFT    (9U)
#define XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_EN_MASK (0x400U)
#define XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_EN_SHIFT (10U)
#define XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_MASK  (0x800U)
#define XCVR_TSM_OVRD2_RX_TZA_PDET_EN_OVRD_SHIFT (11U)
#define XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_EN_MASK (0x1000U)
#define XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_EN_SHIFT (12U)
#define XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_MASK  (0x2000U)
#define XCVR_TSM_OVRD2_RX_TZA_DCOC_EN_OVRD_SHIFT (13U)
#define XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_EN_MASK   (0x4000U)
#define XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_EN_SHIFT  (14U)
#define XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_MASK      (0x8000U)
#define XCVR_TSM_OVRD2_PLL_DIG_EN_OVRD_SHIFT     (15U)
#define XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_EN_MASK    (0x10000U)
#define XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_EN_SHIFT   (16U)
#define XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_MASK       (0x20000U)
#define XCVR_TSM_OVRD2_TX_DIG_EN_OVRD_SHIFT      (17U)
#define XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_EN_MASK    (0x40000U)
#define XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_EN_SHIFT   (18U)
#define XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_MASK       (0x80000U)
#define XCVR_TSM_OVRD2_RX_DIG_EN_OVRD_SHIFT      (19U)
#define XCVR_TSM_OVRD2_RX_INIT_OVRD_EN_MASK      (0x100000U)
#define XCVR_TSM_OVRD2_RX_INIT_OVRD_EN_SHIFT     (20U)
#define XCVR_TSM_OVRD2_RX_INIT_OVRD_MASK         (0x200000U)
#define XCVR_TSM_OVRD2_RX_INIT_OVRD_SHIFT        (21U)
#define XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_EN_MASK (0x400000U)
#define XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_EN_SHIFT (22U)
#define XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_MASK  (0x800000U)
#define XCVR_TSM_OVRD2_SIGMA_DELTA_EN_OVRD_SHIFT (23U)
#define XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_EN_MASK    (0x1000000U)
#define XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_EN_SHIFT   (24U)
#define XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_MASK       (0x2000000U)
#define XCVR_TSM_OVRD2_RX_PHY_EN_OVRD_SHIFT      (25U)
#define XCVR_TSM_OVRD2_DCOC_EN_OVRD_EN_MASK      (0x4000000U)
#define XCVR_TSM_OVRD2_DCOC_EN_OVRD_EN_SHIFT     (26U)
#define XCVR_TSM_OVRD2_DCOC_EN_OVRD_MASK         (0x8000000U)
#define XCVR_TSM_OVRD2_DCOC_EN_OVRD_SHIFT        (27U)
#define XCVR_TSM_OVRD2_DCOC_INIT_OVRD_EN_MASK    (0x10000000U)
#define XCVR_TSM_OVRD2_DCOC_INIT_OVRD_EN_SHIFT   (28U)
#define XCVR_TSM_OVRD2_DCOC_INIT_OVRD_MASK       (0x20000000U)
#define XCVR_TSM_OVRD2_DCOC_INIT_OVRD_SHIFT      (29U)
#define XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_EN_MASK (0x40000000U)
#define XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_EN_SHIFT (30U)
#define XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_MASK (0x80000000U)
#define XCVR_TSM_OVRD2_FREQ_TARG_LD_EN_OVRD_SHIFT (31U)

/*! @name OVRD3 - TSM OVERRIDE REGISTER 3 */
#define XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_EN_MASK (0x1U)
#define XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_EN_SHIFT (0U)
#define XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_MASK   (0x2U)
#define XCVR_TSM_OVRD3_TSM_SPARE0_EN_OVRD_SHIFT  (1U)
#define XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_EN_MASK (0x4U)
#define XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_EN_SHIFT (2U)
#define XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_MASK   (0x8U)
#define XCVR_TSM_OVRD3_TSM_SPARE1_EN_OVRD_SHIFT  (3U)
#define XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_EN_MASK (0x10U)
#define XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_EN_SHIFT (4U)
#define XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_MASK   (0x20U)
#define XCVR_TSM_OVRD3_TSM_SPARE2_EN_OVRD_SHIFT  (5U)
#define XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_EN_MASK (0x40U)
#define XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_EN_SHIFT (6U)
#define XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_MASK   (0x80U)
#define XCVR_TSM_OVRD3_TSM_SPARE3_EN_OVRD_SHIFT  (7U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_EN_MASK (0x100U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_EN_SHIFT (8U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_MASK (0x200U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_BIAS_EN_OVRD_SHIFT (9U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_EN_MASK (0x400U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_EN_SHIFT (10U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_MASK (0x800U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_VCO_EN_OVRD_SHIFT (11U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_EN_MASK (0x1000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_EN_SHIFT (12U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_MASK (0x2000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_FCAL_EN_OVRD_SHIFT (13U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_EN_MASK (0x4000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_EN_SHIFT (14U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_MASK (0x8000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_LF_EN_OVRD_SHIFT (15U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_EN_MASK (0x10000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_EN_SHIFT (16U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_MASK (0x20000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_EN_OVRD_SHIFT (17U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN_MASK (0x40000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_EN_SHIFT (18U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_MASK (0x80000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_OVRD_SHIFT (19U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN_MASK (0x100000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_EN_SHIFT (20U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_MASK (0x200000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_ADC_BUF_EN_OVRD_SHIFT (21U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN_MASK (0x400000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_EN_SHIFT (22U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_MASK (0x800000U)
#define XCVR_TSM_OVRD3_RXTX_AUXPLL_DIG_BUF_EN_OVRD_SHIFT (23U)
#define XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_EN_MASK (0x1000000U)
#define XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_EN_SHIFT (24U)
#define XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_MASK   (0x2000000U)
#define XCVR_TSM_OVRD3_RXTX_RCCAL_EN_OVRD_SHIFT  (25U)
#define XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_EN_MASK (0x4000000U)
#define XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_EN_SHIFT (26U)
#define XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_MASK   (0x8000000U)
#define XCVR_TSM_OVRD3_TX_HPM_DAC_EN_OVRD_SHIFT  (27U)
#define XCVR_TSM_OVRD3_TX_MODE_OVRD_EN_MASK      (0x10000000U)
#define XCVR_TSM_OVRD3_TX_MODE_OVRD_EN_SHIFT     (28U)
#define XCVR_TSM_OVRD3_TX_MODE_OVRD_MASK         (0x20000000U)
#define XCVR_TSM_OVRD3_TX_MODE_OVRD_SHIFT        (29U)
#define XCVR_TSM_OVRD3_RX_MODE_OVRD_EN_MASK      (0x40000000U)
#define XCVR_TSM_OVRD3_RX_MODE_OVRD_EN_SHIFT     (30U)
#define XCVR_TSM_OVRD3_RX_MODE_OVRD_MASK         (0x80000000U)
#define XCVR_TSM_OVRD3_RX_MODE_OVRD_SHIFT        (31U)

/*! @name PA_POWER - PA POWER */
#define XCVR_TSM_PA_POWER_PA_POWER_MASK          (0x3FU)
#define XCVR_TSM_PA_POWER_PA_POWER_SHIFT         (0U)
#define XCVR_TSM_PA_POWER_PA_POWER(x)            (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_PA_POWER_PA_POWER_SHIFT)) & XCVR_TSM_PA_POWER_PA_POWER_MASK)

/*! @name PA_RAMP_TBL0 - PA RAMP TABLE 0 */
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP0_MASK      (0x3FU)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP0_SHIFT     (0U)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP0(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_PA_RAMP_TBL0_PA_RAMP0_SHIFT)) & XCVR_TSM_PA_RAMP_TBL0_PA_RAMP0_MASK)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP1_MASK      (0x3F00U)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP1_SHIFT     (8U)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP1(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_PA_RAMP_TBL0_PA_RAMP1_SHIFT)) & XCVR_TSM_PA_RAMP_TBL0_PA_RAMP1_MASK)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP2_MASK      (0x3F0000U)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP2_SHIFT     (16U)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP2(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_PA_RAMP_TBL0_PA_RAMP2_SHIFT)) & XCVR_TSM_PA_RAMP_TBL0_PA_RAMP2_MASK)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP3_MASK      (0x3F000000U)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP3_SHIFT     (24U)
#define XCVR_TSM_PA_RAMP_TBL0_PA_RAMP3(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_PA_RAMP_TBL0_PA_RAMP3_SHIFT)) & XCVR_TSM_PA_RAMP_TBL0_PA_RAMP3_MASK)

/*! @name PA_RAMP_TBL1 - PA RAMP TABLE 1 */
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP4_MASK      (0x3FU)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP4_SHIFT     (0U)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP4(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_PA_RAMP_TBL1_PA_RAMP4_SHIFT)) & XCVR_TSM_PA_RAMP_TBL1_PA_RAMP4_MASK)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP5_MASK      (0x3F00U)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP5_SHIFT     (8U)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP5(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_PA_RAMP_TBL1_PA_RAMP5_SHIFT)) & XCVR_TSM_PA_RAMP_TBL1_PA_RAMP5_MASK)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP6_MASK      (0x3F0000U)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP6_SHIFT     (16U)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP6(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_PA_RAMP_TBL1_PA_RAMP6_SHIFT)) & XCVR_TSM_PA_RAMP_TBL1_PA_RAMP6_MASK)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP7_MASK      (0x3F000000U)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP7_SHIFT     (24U)
#define XCVR_TSM_PA_RAMP_TBL1_PA_RAMP7(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_PA_RAMP_TBL1_PA_RAMP7_SHIFT)) & XCVR_TSM_PA_RAMP_TBL1_PA_RAMP7_MASK)

/*! @name RECYCLE_COUNT - TSM RECYCLE COUNT */
#define XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT0_MASK (0xFFU)
#define XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT0_SHIFT (0U)
#define XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT0_SHIFT)) & XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT0_MASK)
#define XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT1_MASK (0xFF00U)
#define XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT1_SHIFT (8U)
#define XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT1_SHIFT)) & XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT1_MASK)
#define XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT2_MASK (0xFF0000U)
#define XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT2_SHIFT (16U)
#define XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT2_SHIFT)) & XCVR_TSM_RECYCLE_COUNT_RECYCLE_COUNT2_MASK)

/*! @name FAST_CTRL1 - TSM FAST WARMUP CONTROL REGISTER 1 */
#define XCVR_TSM_FAST_CTRL1_FAST_TX_WU_EN_MASK   (0x1U)
#define XCVR_TSM_FAST_CTRL1_FAST_TX_WU_EN_SHIFT  (0U)
#define XCVR_TSM_FAST_CTRL1_FAST_RX_WU_EN_MASK   (0x2U)
#define XCVR_TSM_FAST_CTRL1_FAST_RX_WU_EN_SHIFT  (1U)
#define XCVR_TSM_FAST_CTRL1_FAST_RX2TX_EN_MASK   (0x4U)
#define XCVR_TSM_FAST_CTRL1_FAST_RX2TX_EN_SHIFT  (2U)
#define XCVR_TSM_FAST_CTRL1_FAST_WU_CLEAR_MASK   (0x8U)
#define XCVR_TSM_FAST_CTRL1_FAST_WU_CLEAR_SHIFT  (3U)
#define XCVR_TSM_FAST_CTRL1_FAST_RX2TX_START_MASK (0xFF00U)
#define XCVR_TSM_FAST_CTRL1_FAST_RX2TX_START_SHIFT (8U)
#define XCVR_TSM_FAST_CTRL1_FAST_RX2TX_START(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_FAST_CTRL1_FAST_RX2TX_START_SHIFT)) & XCVR_TSM_FAST_CTRL1_FAST_RX2TX_START_MASK)

/*! @name FAST_CTRL2 - TSM FAST WARMUP CONTROL REGISTER 2 */
#define XCVR_TSM_FAST_CTRL2_FAST_START_TX_MASK   (0xFFU)
#define XCVR_TSM_FAST_CTRL2_FAST_START_TX_SHIFT  (0U)
#define XCVR_TSM_FAST_CTRL2_FAST_START_TX(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_FAST_CTRL2_FAST_START_TX_SHIFT)) & XCVR_TSM_FAST_CTRL2_FAST_START_TX_MASK)
#define XCVR_TSM_FAST_CTRL2_FAST_DEST_TX_MASK    (0xFF00U)
#define XCVR_TSM_FAST_CTRL2_FAST_DEST_TX_SHIFT   (8U)
#define XCVR_TSM_FAST_CTRL2_FAST_DEST_TX(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_FAST_CTRL2_FAST_DEST_TX_SHIFT)) & XCVR_TSM_FAST_CTRL2_FAST_DEST_TX_MASK)
#define XCVR_TSM_FAST_CTRL2_FAST_START_RX_MASK   (0xFF0000U)
#define XCVR_TSM_FAST_CTRL2_FAST_START_RX_SHIFT  (16U)
#define XCVR_TSM_FAST_CTRL2_FAST_START_RX(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_FAST_CTRL2_FAST_START_RX_SHIFT)) & XCVR_TSM_FAST_CTRL2_FAST_START_RX_MASK)
#define XCVR_TSM_FAST_CTRL2_FAST_DEST_RX_MASK    (0xFF000000U)
#define XCVR_TSM_FAST_CTRL2_FAST_DEST_RX_SHIFT   (24U)
#define XCVR_TSM_FAST_CTRL2_FAST_DEST_RX(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_FAST_CTRL2_FAST_DEST_RX_SHIFT)) & XCVR_TSM_FAST_CTRL2_FAST_DEST_RX_MASK)

/*! @name TIMING00 - TSM_TIMING00 */
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_HI(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_LO(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING00_BB_LDO_HF_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_HI(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_LO(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING00_BB_LDO_HF_EN_RX_LO_MASK)

/*! @name TIMING01 - TSM_TIMING01 */
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING01_BB_LDO_ADCDAC_EN_RX_LO_MASK)

/*! @name TIMING02 - TSM_TIMING02 */
#define XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING02_BB_LDO_BBA_EN_RX_LO_MASK)

/*! @name TIMING03 - TSM_TIMING03 */
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_HI(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_LO(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING03_BB_LDO_PD_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_HI(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_LO(x)  (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING03_BB_LDO_PD_EN_RX_LO_MASK)

/*! @name TIMING04 - TSM_TIMING04 */
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING04_BB_LDO_FDBK_EN_RX_LO_MASK)

/*! @name TIMING05 - TSM_TIMING05 */
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING05_BB_LDO_VCOLO_EN_RX_LO_MASK)

/*! @name TIMING06 - TSM_TIMING06 */
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING06_BB_LDO_VTREF_EN_RX_LO_MASK)

/*! @name TIMING07 - TSM_TIMING07 */
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING07_BB_LDO_FDBK_BLEED_EN_RX_LO_MASK)

/*! @name TIMING08 - TSM_TIMING08 */
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING08_BB_LDO_VCOLO_BLEED_EN_RX_LO_MASK)

/*! @name TIMING09 - TSM_TIMING09 */
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING09_BB_LDO_VCOLO_FASTCHARGE_EN_RX_LO_MASK)

/*! @name TIMING10 - TSM_TIMING10 */
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING10_BB_XTAL_PLL_REF_CLK_EN_RX_LO_MASK)

/*! @name TIMING11 - TSM_TIMING11 */
#define XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING11_BB_XTAL_DAC_REF_CLK_EN_TX_LO_MASK)

/*! @name TIMING12 - TSM_TIMING12 */
#define XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING12_RXTX_AUXPLL_VCO_REF_CLK_EN_RX_LO_MASK)

/*! @name TIMING13 - TSM_TIMING13 */
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING13_SY_VCO_AUTOTUNE_EN_RX_LO_MASK)

/*! @name TIMING14 - TSM_TIMING14 */
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING14_SY_PD_CYCLE_SLIP_LD_FT_EN_RX_LO_MASK)

/*! @name TIMING15 - TSM_TIMING15 */
#define XCVR_TSM_TIMING15_SY_VCO_EN_TX_HI_MASK   (0xFFU)
#define XCVR_TSM_TIMING15_SY_VCO_EN_TX_HI_SHIFT  (0U)
#define XCVR_TSM_TIMING15_SY_VCO_EN_TX_HI(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING15_SY_VCO_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING15_SY_VCO_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING15_SY_VCO_EN_TX_LO_MASK   (0xFF00U)
#define XCVR_TSM_TIMING15_SY_VCO_EN_TX_LO_SHIFT  (8U)
#define XCVR_TSM_TIMING15_SY_VCO_EN_TX_LO(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING15_SY_VCO_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING15_SY_VCO_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING15_SY_VCO_EN_RX_HI_MASK   (0xFF0000U)
#define XCVR_TSM_TIMING15_SY_VCO_EN_RX_HI_SHIFT  (16U)
#define XCVR_TSM_TIMING15_SY_VCO_EN_RX_HI(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING15_SY_VCO_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING15_SY_VCO_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING15_SY_VCO_EN_RX_LO_MASK   (0xFF000000U)
#define XCVR_TSM_TIMING15_SY_VCO_EN_RX_LO_SHIFT  (24U)
#define XCVR_TSM_TIMING15_SY_VCO_EN_RX_LO(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING15_SY_VCO_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING15_SY_VCO_EN_RX_LO_MASK)

/*! @name TIMING16 - TSM_TIMING16 */
#define XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING16_SY_LO_RX_BUF_EN_RX_LO_MASK)

/*! @name TIMING17 - TSM_TIMING17 */
#define XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING17_SY_LO_TX_BUF_EN_TX_LO_MASK)

/*! @name TIMING18 - TSM_TIMING18 */
#define XCVR_TSM_TIMING18_SY_DIVN_EN_TX_HI_MASK  (0xFFU)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_TX_HI(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING18_SY_DIVN_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING18_SY_DIVN_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_TX_LO_MASK  (0xFF00U)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_TX_LO(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING18_SY_DIVN_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING18_SY_DIVN_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_RX_HI_MASK  (0xFF0000U)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_RX_HI(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING18_SY_DIVN_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING18_SY_DIVN_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_RX_LO_MASK  (0xFF000000U)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING18_SY_DIVN_EN_RX_LO(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING18_SY_DIVN_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING18_SY_DIVN_EN_RX_LO_MASK)

/*! @name TIMING19 - TSM_TIMING19 */
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING19_SY_PD_FILTER_CHARGE_EN_RX_LO_MASK)

/*! @name TIMING20 - TSM_TIMING20 */
#define XCVR_TSM_TIMING20_SY_PD_EN_TX_HI_MASK    (0xFFU)
#define XCVR_TSM_TIMING20_SY_PD_EN_TX_HI_SHIFT   (0U)
#define XCVR_TSM_TIMING20_SY_PD_EN_TX_HI(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING20_SY_PD_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING20_SY_PD_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING20_SY_PD_EN_TX_LO_MASK    (0xFF00U)
#define XCVR_TSM_TIMING20_SY_PD_EN_TX_LO_SHIFT   (8U)
#define XCVR_TSM_TIMING20_SY_PD_EN_TX_LO(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING20_SY_PD_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING20_SY_PD_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING20_SY_PD_EN_RX_HI_MASK    (0xFF0000U)
#define XCVR_TSM_TIMING20_SY_PD_EN_RX_HI_SHIFT   (16U)
#define XCVR_TSM_TIMING20_SY_PD_EN_RX_HI(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING20_SY_PD_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING20_SY_PD_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING20_SY_PD_EN_RX_LO_MASK    (0xFF000000U)
#define XCVR_TSM_TIMING20_SY_PD_EN_RX_LO_SHIFT   (24U)
#define XCVR_TSM_TIMING20_SY_PD_EN_RX_LO(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING20_SY_PD_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING20_SY_PD_EN_RX_LO_MASK)

/*! @name TIMING21 - TSM_TIMING21 */
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING21_SY_LO_DIVN_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING21_SY_LO_DIVN_EN_RX_LO_MASK)

/*! @name TIMING22 - TSM_TIMING22 */
#define XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_HI(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_LO(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING22_SY_LO_RX_EN_RX_LO_MASK)

/*! @name TIMING23 - TSM_TIMING23 */
#define XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_HI(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_LO(x)   (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING23_SY_LO_TX_EN_TX_LO_MASK)

/*! @name TIMING24 - TSM_TIMING24 */
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING24_SY_DIVN_CAL_EN_RX_LO_MASK)

/*! @name TIMING25 - TSM_TIMING25 */
#define XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING25_RX_LNA_MIXER_EN_RX_LO_MASK)

/*! @name TIMING26 - TSM_TIMING26 */
#define XCVR_TSM_TIMING26_TX_PA_EN_TX_HI_MASK    (0xFFU)
#define XCVR_TSM_TIMING26_TX_PA_EN_TX_HI_SHIFT   (0U)
#define XCVR_TSM_TIMING26_TX_PA_EN_TX_HI(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING26_TX_PA_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING26_TX_PA_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING26_TX_PA_EN_TX_LO_MASK    (0xFF00U)
#define XCVR_TSM_TIMING26_TX_PA_EN_TX_LO_SHIFT   (8U)
#define XCVR_TSM_TIMING26_TX_PA_EN_TX_LO(x)      (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING26_TX_PA_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING26_TX_PA_EN_TX_LO_MASK)

/*! @name TIMING27 - TSM_TIMING27 */
#define XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING27_RX_ADC_I_Q_EN_RX_LO_MASK)

/*! @name TIMING28 - TSM_TIMING28 */
#define XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING28_RX_ADC_RESET_EN_RX_LO_MASK)

/*! @name TIMING29 - TSM_TIMING29 */
#define XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING29_RX_BBA_I_Q_EN_RX_LO_MASK)

/*! @name TIMING30 - TSM_TIMING30 */
#define XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING30_RX_BBA_PDET_EN_RX_LO_MASK)

/*! @name TIMING31 - TSM_TIMING31 */
#define XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING31_RX_BBA_TZA_DCOC_EN_RX_LO_MASK)

/*! @name TIMING32 - TSM_TIMING32 */
#define XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING32_RX_TZA_I_Q_EN_RX_LO_MASK)

/*! @name TIMING33 - TSM_TIMING33 */
#define XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING33_RX_TZA_PDET_EN_RX_LO_MASK)

/*! @name TIMING34 - TSM_TIMING34 */
#define XCVR_TSM_TIMING34_PLL_DIG_EN_TX_HI_MASK  (0xFFU)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_TX_HI(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING34_PLL_DIG_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING34_PLL_DIG_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_TX_LO_MASK  (0xFF00U)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_TX_LO(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING34_PLL_DIG_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING34_PLL_DIG_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_RX_HI_MASK  (0xFF0000U)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_RX_HI(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING34_PLL_DIG_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING34_PLL_DIG_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_RX_LO_MASK  (0xFF000000U)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING34_PLL_DIG_EN_RX_LO(x)    (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING34_PLL_DIG_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING34_PLL_DIG_EN_RX_LO_MASK)

/*! @name TIMING35 - TSM_TIMING35 */
#define XCVR_TSM_TIMING35_TX_DIG_EN_TX_HI_MASK   (0xFFU)
#define XCVR_TSM_TIMING35_TX_DIG_EN_TX_HI_SHIFT  (0U)
#define XCVR_TSM_TIMING35_TX_DIG_EN_TX_HI(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING35_TX_DIG_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING35_TX_DIG_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING35_TX_DIG_EN_TX_LO_MASK   (0xFF00U)
#define XCVR_TSM_TIMING35_TX_DIG_EN_TX_LO_SHIFT  (8U)
#define XCVR_TSM_TIMING35_TX_DIG_EN_TX_LO(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING35_TX_DIG_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING35_TX_DIG_EN_TX_LO_MASK)

/*! @name TIMING36 - TSM_TIMING36 */
#define XCVR_TSM_TIMING36_RX_DIG_EN_RX_HI_MASK   (0xFF0000U)
#define XCVR_TSM_TIMING36_RX_DIG_EN_RX_HI_SHIFT  (16U)
#define XCVR_TSM_TIMING36_RX_DIG_EN_RX_HI(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING36_RX_DIG_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING36_RX_DIG_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING36_RX_DIG_EN_RX_LO_MASK   (0xFF000000U)
#define XCVR_TSM_TIMING36_RX_DIG_EN_RX_LO_SHIFT  (24U)
#define XCVR_TSM_TIMING36_RX_DIG_EN_RX_LO(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING36_RX_DIG_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING36_RX_DIG_EN_RX_LO_MASK)

/*! @name TIMING37 - TSM_TIMING37 */
#define XCVR_TSM_TIMING37_RX_INIT_RX_HI_MASK     (0xFF0000U)
#define XCVR_TSM_TIMING37_RX_INIT_RX_HI_SHIFT    (16U)
#define XCVR_TSM_TIMING37_RX_INIT_RX_HI(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING37_RX_INIT_RX_HI_SHIFT)) & XCVR_TSM_TIMING37_RX_INIT_RX_HI_MASK)
#define XCVR_TSM_TIMING37_RX_INIT_RX_LO_MASK     (0xFF000000U)
#define XCVR_TSM_TIMING37_RX_INIT_RX_LO_SHIFT    (24U)
#define XCVR_TSM_TIMING37_RX_INIT_RX_LO(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING37_RX_INIT_RX_LO_SHIFT)) & XCVR_TSM_TIMING37_RX_INIT_RX_LO_MASK)

/*! @name TIMING38 - TSM_TIMING38 */
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING38_SIGMA_DELTA_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING38_SIGMA_DELTA_EN_RX_LO_MASK)

/*! @name TIMING39 - TSM_TIMING39 */
#define XCVR_TSM_TIMING39_RX_PHY_EN_RX_HI_MASK   (0xFF0000U)
#define XCVR_TSM_TIMING39_RX_PHY_EN_RX_HI_SHIFT  (16U)
#define XCVR_TSM_TIMING39_RX_PHY_EN_RX_HI(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING39_RX_PHY_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING39_RX_PHY_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING39_RX_PHY_EN_RX_LO_MASK   (0xFF000000U)
#define XCVR_TSM_TIMING39_RX_PHY_EN_RX_LO_SHIFT  (24U)
#define XCVR_TSM_TIMING39_RX_PHY_EN_RX_LO(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING39_RX_PHY_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING39_RX_PHY_EN_RX_LO_MASK)

/*! @name TIMING40 - TSM_TIMING40 */
#define XCVR_TSM_TIMING40_DCOC_EN_RX_HI_MASK     (0xFF0000U)
#define XCVR_TSM_TIMING40_DCOC_EN_RX_HI_SHIFT    (16U)
#define XCVR_TSM_TIMING40_DCOC_EN_RX_HI(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING40_DCOC_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING40_DCOC_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING40_DCOC_EN_RX_LO_MASK     (0xFF000000U)
#define XCVR_TSM_TIMING40_DCOC_EN_RX_LO_SHIFT    (24U)
#define XCVR_TSM_TIMING40_DCOC_EN_RX_LO(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING40_DCOC_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING40_DCOC_EN_RX_LO_MASK)

/*! @name TIMING41 - TSM_TIMING41 */
#define XCVR_TSM_TIMING41_DCOC_INIT_RX_HI_MASK   (0xFF0000U)
#define XCVR_TSM_TIMING41_DCOC_INIT_RX_HI_SHIFT  (16U)
#define XCVR_TSM_TIMING41_DCOC_INIT_RX_HI(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING41_DCOC_INIT_RX_HI_SHIFT)) & XCVR_TSM_TIMING41_DCOC_INIT_RX_HI_MASK)
#define XCVR_TSM_TIMING41_DCOC_INIT_RX_LO_MASK   (0xFF000000U)
#define XCVR_TSM_TIMING41_DCOC_INIT_RX_LO_SHIFT  (24U)
#define XCVR_TSM_TIMING41_DCOC_INIT_RX_LO(x)     (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING41_DCOC_INIT_RX_LO_SHIFT)) & XCVR_TSM_TIMING41_DCOC_INIT_RX_LO_MASK)

/*! @name TIMING42 - TSM_TIMING42 */
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING42_SAR_ADC_TRIG_EN_RX_LO_MASK)

/*! @name TIMING43 - TSM_TIMING43 */
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING43_TSM_SPARE0_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING43_TSM_SPARE0_EN_RX_LO_MASK)

/*! @name TIMING44 - TSM_TIMING44 */
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING44_TSM_SPARE1_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING44_TSM_SPARE1_EN_RX_LO_MASK)

/*! @name TIMING45 - TSM_TIMING45 */
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING45_TSM_SPARE2_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING45_TSM_SPARE2_EN_RX_LO_MASK)

/*! @name TIMING46 - TSM_TIMING46 */
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING46_TSM_SPARE3_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING46_TSM_SPARE3_EN_RX_LO_MASK)

/*! @name TIMING47 - TSM_TIMING47 */
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING47_GPIO0_TRIG_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING47_GPIO0_TRIG_EN_RX_LO_MASK)

/*! @name TIMING48 - TSM_TIMING48 */
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING48_GPIO1_TRIG_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING48_GPIO1_TRIG_EN_RX_LO_MASK)

/*! @name TIMING49 - TSM_TIMING49 */
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING49_GPIO2_TRIG_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING49_GPIO2_TRIG_EN_RX_LO_MASK)

/*! @name TIMING50 - TSM_TIMING50 */
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING50_GPIO3_TRIG_EN_TX_LO_MASK)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING50_GPIO3_TRIG_EN_RX_LO_MASK)

/*! @name TIMING51 - TSM_TIMING51 */
#define XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING51_RXTX_AUXPLL_BIAS_EN_RX_LO_MASK)

/*! @name TIMING52 - TSM_TIMING52 */
#define XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING52_RXTX_AUXPLL_FCAL_EN_RX_LO_MASK)

/*! @name TIMING53 - TSM_TIMING53 */
#define XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING53_RXTX_AUXPLL_LF_PD_EN_RX_LO_MASK)

/*! @name TIMING54 - TSM_TIMING54 */
#define XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING54_RXTX_AUXPLL_PD_LF_FILTER_CHARGE_EN_RX_LO_MASK)

/*! @name TIMING55 - TSM_TIMING55 */
#define XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING55_RXTX_AUXPLL_ADC_BUF_EN_RX_LO_MASK)

/*! @name TIMING56 - TSM_TIMING56 */
#define XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING56_RXTX_AUXPLL_DIG_BUF_EN_RX_LO_MASK)

/*! @name TIMING57 - TSM_TIMING57 */
#define XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_HI_MASK (0xFF0000U)
#define XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_HI_SHIFT (16U)
#define XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_HI_SHIFT)) & XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_HI_MASK)
#define XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_LO_MASK (0xFF000000U)
#define XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_LO_SHIFT (24U)
#define XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_LO_SHIFT)) & XCVR_TSM_TIMING57_RXTX_RCCAL_EN_RX_LO_MASK)

/*! @name TIMING58 - TSM_TIMING58 */
#define XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_HI_MASK (0xFFU)
#define XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_HI_SHIFT (0U)
#define XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_HI(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_HI_SHIFT)) & XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_HI_MASK)
#define XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_LO_MASK (0xFF00U)
#define XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_LO_SHIFT (8U)
#define XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_LO(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_LO_SHIFT)) & XCVR_TSM_TIMING58_TX_HPM_DAC_EN_TX_LO_MASK)


/*!
 * @}
 */ /* end of group XCVR_TSM_Register_Masks */


/* XCVR_TSM - Peripheral instance base addresses */
/** Peripheral XCVR_TSM_REGS base pointer */
#define XCVR_TSM_BASE_PTR                        ((XCVR_TSM_MemMapPtr)0x4005C2C0u)
/** Array initializer of XCVR_TSM peripheral base pointers */
#define XCVR_TSM_BASE_PTRS                       { XCVR_TSM_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- XCVR_TSM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_TSM_Register_Accessor_Macros XCVR_TSM - Register accessor macros
 * @{
 */


/* XCVR_TSM - Register instance definitions */
/* XCVR_TSM_REGS */
#define XCVR_TSM_CTRL                            XCVR_TSM_CTRL_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_END_OF_SEQ                      XCVR_TSM_END_OF_SEQ_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_OVRD0                           XCVR_TSM_OVRD0_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_OVRD1                           XCVR_TSM_OVRD1_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_OVRD2                           XCVR_TSM_OVRD2_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_OVRD3                           XCVR_TSM_OVRD3_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_PA_POWER                        XCVR_TSM_PA_POWER_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_PA_RAMP_TBL0                    XCVR_TSM_PA_RAMP_TBL0_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_PA_RAMP_TBL1                    XCVR_TSM_PA_RAMP_TBL1_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_RECYCLE_COUNT                   XCVR_TSM_RECYCLE_COUNT_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_FAST_CTRL1                      XCVR_TSM_FAST_CTRL1_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_FAST_CTRL2                      XCVR_TSM_FAST_CTRL2_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING00                        XCVR_TSM_TIMING00_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING01                        XCVR_TSM_TIMING01_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING02                        XCVR_TSM_TIMING02_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING03                        XCVR_TSM_TIMING03_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING04                        XCVR_TSM_TIMING04_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING05                        XCVR_TSM_TIMING05_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING06                        XCVR_TSM_TIMING06_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING07                        XCVR_TSM_TIMING07_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING08                        XCVR_TSM_TIMING08_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING09                        XCVR_TSM_TIMING09_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING10                        XCVR_TSM_TIMING10_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING11                        XCVR_TSM_TIMING11_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING12                        XCVR_TSM_TIMING12_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING13                        XCVR_TSM_TIMING13_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING14                        XCVR_TSM_TIMING14_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING15                        XCVR_TSM_TIMING15_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING16                        XCVR_TSM_TIMING16_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING17                        XCVR_TSM_TIMING17_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING18                        XCVR_TSM_TIMING18_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING19                        XCVR_TSM_TIMING19_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING20                        XCVR_TSM_TIMING20_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING21                        XCVR_TSM_TIMING21_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING22                        XCVR_TSM_TIMING22_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING23                        XCVR_TSM_TIMING23_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING24                        XCVR_TSM_TIMING24_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING25                        XCVR_TSM_TIMING25_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING26                        XCVR_TSM_TIMING26_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING27                        XCVR_TSM_TIMING27_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING28                        XCVR_TSM_TIMING28_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING29                        XCVR_TSM_TIMING29_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING30                        XCVR_TSM_TIMING30_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING31                        XCVR_TSM_TIMING31_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING32                        XCVR_TSM_TIMING32_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING33                        XCVR_TSM_TIMING33_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING34                        XCVR_TSM_TIMING34_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING35                        XCVR_TSM_TIMING35_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING36                        XCVR_TSM_TIMING36_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING37                        XCVR_TSM_TIMING37_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING38                        XCVR_TSM_TIMING38_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING39                        XCVR_TSM_TIMING39_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING40                        XCVR_TSM_TIMING40_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING41                        XCVR_TSM_TIMING41_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING42                        XCVR_TSM_TIMING42_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING43                        XCVR_TSM_TIMING43_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING44                        XCVR_TSM_TIMING44_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING45                        XCVR_TSM_TIMING45_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING46                        XCVR_TSM_TIMING46_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING47                        XCVR_TSM_TIMING47_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING48                        XCVR_TSM_TIMING48_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING49                        XCVR_TSM_TIMING49_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING50                        XCVR_TSM_TIMING50_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING51                        XCVR_TSM_TIMING51_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING52                        XCVR_TSM_TIMING52_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING53                        XCVR_TSM_TIMING53_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING54                        XCVR_TSM_TIMING54_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING55                        XCVR_TSM_TIMING55_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING56                        XCVR_TSM_TIMING56_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING57                        XCVR_TSM_TIMING57_REG(XCVR_TSM_BASE_PTR)
#define XCVR_TSM_TIMING58                        XCVR_TSM_TIMING58_REG(XCVR_TSM_BASE_PTR)

/*!
 * @}
 */ /* end of group XCVR_TSM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group XCVR_TSM_Peripheral */


/* ----------------------------------------------------------------------------
   -- XCVR_TX_DIG
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_TX_DIG_Peripheral XCVR_TX_DIG
 * @{
 */

/** XCVR_TX_DIG - Peripheral register structure */
typedef struct XCVR_TX_DIG_MemMap {
  uint32_t CTRL;                                   /**< TX Digital Control, offset: 0x0 */
  uint32_t DATA_PADDING;                           /**< TX Data Padding, offset: 0x4 */
  uint32_t GFSK_CTRL;                              /**< TX GFSK Modulator Control, offset: 0x8 */
  uint32_t GFSK_COEFF2;                            /**< TX GFSK Filter Coefficients 2, offset: 0xC */
  uint32_t GFSK_COEFF1;                            /**< TX GFSK Filter Coefficients 1, offset: 0x10 */
  uint32_t FSK_SCALE;                              /**< TX FSK Modulation Levels, offset: 0x14 */
  uint32_t DFT_PATTERN;                            /**< TX DFT Modulation Pattern, offset: 0x18 */
  uint32_t RF_DFT_BIST_1;                          /**< TX DFT Control 1, offset: 0x1C */
  uint32_t RF_DFT_BIST_2;                          /**< TX DFT Control 2, offset: 0x20 */
} volatile *XCVR_TX_DIG_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- XCVR_TX_DIG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_TX_DIG_Register_Accessor_Macros XCVR_TX_DIG - Register accessor macros
 * @{
 */


/* XCVR_TX_DIG - Register accessors */
#define XCVR_TX_DIG_CTRL_REG(base)               ((base)->CTRL)
#define XCVR_TX_DIG_DATA_PADDING_REG(base)       ((base)->DATA_PADDING)
#define XCVR_TX_DIG_GFSK_CTRL_REG(base)          ((base)->GFSK_CTRL)
#define XCVR_TX_DIG_GFSK_COEFF2_REG(base)        ((base)->GFSK_COEFF2)
#define XCVR_TX_DIG_GFSK_COEFF1_REG(base)        ((base)->GFSK_COEFF1)
#define XCVR_TX_DIG_FSK_SCALE_REG(base)          ((base)->FSK_SCALE)
#define XCVR_TX_DIG_DFT_PATTERN_REG(base)        ((base)->DFT_PATTERN)
#define XCVR_TX_DIG_RF_DFT_BIST_1_REG(base)      ((base)->RF_DFT_BIST_1)
#define XCVR_TX_DIG_RF_DFT_BIST_2_REG(base)      ((base)->RF_DFT_BIST_2)

/*!
 * @}
 */ /* end of group XCVR_TX_DIG_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- XCVR_TX_DIG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_TX_DIG_Register_Masks XCVR_TX_DIG Register Masks
 * @{
 */

/*! @name CTRL - TX Digital Control */
#define XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_MASK     (0xFU)
#define XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_SHIFT    (0U)
#define XCVR_TX_DIG_CTRL_RADIO_DFT_MODE(x)       (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_SHIFT)) & XCVR_TX_DIG_CTRL_RADIO_DFT_MODE_MASK)
#define XCVR_TX_DIG_CTRL_LFSR_LENGTH_MASK        (0x70U)
#define XCVR_TX_DIG_CTRL_LFSR_LENGTH_SHIFT       (4U)
#define XCVR_TX_DIG_CTRL_LFSR_LENGTH(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_CTRL_LFSR_LENGTH_SHIFT)) & XCVR_TX_DIG_CTRL_LFSR_LENGTH_MASK)
#define XCVR_TX_DIG_CTRL_LFSR_EN_MASK            (0x80U)
#define XCVR_TX_DIG_CTRL_LFSR_EN_SHIFT           (7U)
#define XCVR_TX_DIG_CTRL_DFT_CLK_SEL_MASK        (0x700U)
#define XCVR_TX_DIG_CTRL_DFT_CLK_SEL_SHIFT       (8U)
#define XCVR_TX_DIG_CTRL_DFT_CLK_SEL(x)          (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_CTRL_DFT_CLK_SEL_SHIFT)) & XCVR_TX_DIG_CTRL_DFT_CLK_SEL_MASK)
#define XCVR_TX_DIG_CTRL_TX_DFT_EN_MASK          (0x800U)
#define XCVR_TX_DIG_CTRL_TX_DFT_EN_SHIFT         (11U)
#define XCVR_TX_DIG_CTRL_SOC_TEST_SEL_MASK       (0x3000U)
#define XCVR_TX_DIG_CTRL_SOC_TEST_SEL_SHIFT      (12U)
#define XCVR_TX_DIG_CTRL_SOC_TEST_SEL(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_CTRL_SOC_TEST_SEL_SHIFT)) & XCVR_TX_DIG_CTRL_SOC_TEST_SEL_MASK)
#define XCVR_TX_DIG_CTRL_TX_CAPTURE_POL_MASK     (0x10000U)
#define XCVR_TX_DIG_CTRL_TX_CAPTURE_POL_SHIFT    (16U)
#define XCVR_TX_DIG_CTRL_FREQ_WORD_ADJ_MASK      (0xFFC00000U)
#define XCVR_TX_DIG_CTRL_FREQ_WORD_ADJ_SHIFT     (22U)
#define XCVR_TX_DIG_CTRL_FREQ_WORD_ADJ(x)        (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_CTRL_FREQ_WORD_ADJ_SHIFT)) & XCVR_TX_DIG_CTRL_FREQ_WORD_ADJ_MASK)

/*! @name DATA_PADDING - TX Data Padding */
#define XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_0_MASK (0xFFU)
#define XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_0_SHIFT (0U)
#define XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_0_SHIFT)) & XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_0_MASK)
#define XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_1_MASK (0xFF00U)
#define XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_1_SHIFT (8U)
#define XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_1_SHIFT)) & XCVR_TX_DIG_DATA_PADDING_DATA_PADDING_PAT_1_MASK)
#define XCVR_TX_DIG_DATA_PADDING_DFT_LFSR_OUT_MASK (0x7FFF0000U)
#define XCVR_TX_DIG_DATA_PADDING_DFT_LFSR_OUT_SHIFT (16U)
#define XCVR_TX_DIG_DATA_PADDING_DFT_LFSR_OUT(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_DATA_PADDING_DFT_LFSR_OUT_SHIFT)) & XCVR_TX_DIG_DATA_PADDING_DFT_LFSR_OUT_MASK)
#define XCVR_TX_DIG_DATA_PADDING_LRM_MASK        (0x80000000U)
#define XCVR_TX_DIG_DATA_PADDING_LRM_SHIFT       (31U)

/*! @name GFSK_CTRL - TX GFSK Modulator Control */
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MULTIPLY_TABLE_MANUAL_MASK (0xFFFFU)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MULTIPLY_TABLE_MANUAL_SHIFT (0U)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MULTIPLY_TABLE_MANUAL(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_GFSK_CTRL_GFSK_MULTIPLY_TABLE_MANUAL_SHIFT)) & XCVR_TX_DIG_GFSK_CTRL_GFSK_MULTIPLY_TABLE_MANUAL_MASK)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MI_MASK       (0x30000U)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MI_SHIFT      (16U)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MI(x)         (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_GFSK_CTRL_GFSK_MI_SHIFT)) & XCVR_TX_DIG_GFSK_CTRL_GFSK_MI_MASK)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MLD_MASK      (0x100000U)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MLD_SHIFT     (20U)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_FLD_MASK      (0x200000U)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_FLD_SHIFT     (21U)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_MASK (0x7000000U)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_SHIFT (24U)
#define XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_SHIFT)) & XCVR_TX_DIG_GFSK_CTRL_GFSK_MOD_INDEX_SCALING_MASK)
#define XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_OVRD_EN_MASK (0x10000000U)
#define XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_OVRD_EN_SHIFT (28U)
#define XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_0_OVRD_MASK (0x20000000U)
#define XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_0_OVRD_SHIFT (29U)
#define XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_1_OVRD_MASK (0x40000000U)
#define XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_1_OVRD_SHIFT (30U)
#define XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_2_OVRD_MASK (0x80000000U)
#define XCVR_TX_DIG_GFSK_CTRL_TX_IMAGE_FILTER_2_OVRD_SHIFT (31U)

/*! @name GFSK_COEFF2 - TX GFSK Filter Coefficients 2 */
#define XCVR_TX_DIG_GFSK_COEFF2_GFSK_FILTER_COEFF_MANUAL2_MASK (0xFFFFFFFFU)
#define XCVR_TX_DIG_GFSK_COEFF2_GFSK_FILTER_COEFF_MANUAL2_SHIFT (0U)
#define XCVR_TX_DIG_GFSK_COEFF2_GFSK_FILTER_COEFF_MANUAL2(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_GFSK_COEFF2_GFSK_FILTER_COEFF_MANUAL2_SHIFT)) & XCVR_TX_DIG_GFSK_COEFF2_GFSK_FILTER_COEFF_MANUAL2_MASK)

/*! @name GFSK_COEFF1 - TX GFSK Filter Coefficients 1 */
#define XCVR_TX_DIG_GFSK_COEFF1_GFSK_FILTER_COEFF_MANUAL1_MASK (0xFFFFFFFFU)
#define XCVR_TX_DIG_GFSK_COEFF1_GFSK_FILTER_COEFF_MANUAL1_SHIFT (0U)
#define XCVR_TX_DIG_GFSK_COEFF1_GFSK_FILTER_COEFF_MANUAL1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_GFSK_COEFF1_GFSK_FILTER_COEFF_MANUAL1_SHIFT)) & XCVR_TX_DIG_GFSK_COEFF1_GFSK_FILTER_COEFF_MANUAL1_MASK)

/*! @name FSK_SCALE - TX FSK Modulation Levels */
#define XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_0_MASK (0x1FFFU)
#define XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_0_SHIFT (0U)
#define XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_0(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_0_SHIFT)) & XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_0_MASK)
#define XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_1_MASK (0x1FFF0000U)
#define XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_1_SHIFT (16U)
#define XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_1(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_1_SHIFT)) & XCVR_TX_DIG_FSK_SCALE_FSK_MODULATION_SCALE_1_MASK)

/*! @name DFT_PATTERN - TX DFT Modulation Pattern */
#define XCVR_TX_DIG_DFT_PATTERN_DFT_MOD_PATTERN_MASK (0xFFFFFFFFU)
#define XCVR_TX_DIG_DFT_PATTERN_DFT_MOD_PATTERN_SHIFT (0U)
#define XCVR_TX_DIG_DFT_PATTERN_DFT_MOD_PATTERN(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_DFT_PATTERN_DFT_MOD_PATTERN_SHIFT)) & XCVR_TX_DIG_DFT_PATTERN_DFT_MOD_PATTERN_MASK)

/*! @name RF_DFT_BIST_1 - TX DFT Control 1 */
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_GO_MASK (0x1U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_GO_SHIFT (0U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_FINISHED_MASK (0x2U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_FINISHED_SHIFT (1U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_RESULT_MASK (0x4U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_RESULT_SHIFT (2U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_THRSHLD_MASK (0xF0U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_THRSHLD_SHIFT (4U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_THRSHLD(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_THRSHLD_SHIFT)) & XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_BIST_THRSHLD_MASK)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_MASK (0xFF00U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_SHIFT (8U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_SHIFT)) & XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_MASK)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_CH_MASK (0x7F0000U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_CH_SHIFT (16U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_CH(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_CH_SHIFT)) & XCVR_TX_DIG_RF_DFT_BIST_1_CTUNE_MAX_DIFF_CH_MASK)
#define XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_MASK (0x7000000U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_SHIFT (24U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_SHIFT)) & XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_FREQ_MASK)
#define XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_MASK (0x70000000U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_SHIFT (28U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_SHIFT)) & XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_ENTRIES_MASK)
#define XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_EN_MASK (0x80000000U)
#define XCVR_TX_DIG_RF_DFT_BIST_1_PA_AM_MOD_EN_SHIFT (31U)

/*! @name RF_DFT_BIST_2 - TX DFT Control 2 */
#define XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_GO_MASK (0x1U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_GO_SHIFT (0U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_FINISHED_MASK (0x2U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_FINISHED_SHIFT (1U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_RESULT_MASK (0x4U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_RESULT_SHIFT (2U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_ALL_CHANNELS_MASK (0x8U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_SYN_BIST_ALL_CHANNELS_SHIFT (3U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_FREQ_COUNT_THRESHOLD_MASK (0xFF0U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_FREQ_COUNT_THRESHOLD_SHIFT (4U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_FREQ_COUNT_THRESHOLD(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_RF_DFT_BIST_2_FREQ_COUNT_THRESHOLD_SHIFT)) & XCVR_TX_DIG_RF_DFT_BIST_2_FREQ_COUNT_THRESHOLD_MASK)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_GO_MASK (0x1000U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_GO_SHIFT (12U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_FINISHED_MASK (0x2000U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_FINISHED_SHIFT (13U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_RESULT_MASK (0x4000U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_INL_BIST_RESULT_SHIFT (14U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_GO_MASK (0x10000U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_GO_SHIFT (16U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_FINISHED_MASK (0x20000U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_FINISHED_SHIFT (17U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_RESULT_MASK (0x40000U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_HPM_DNL_BIST_RESULT_SHIFT (18U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_DFT_MAX_RAM_SIZE_MASK (0x1FF00000U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_DFT_MAX_RAM_SIZE_SHIFT (20U)
#define XCVR_TX_DIG_RF_DFT_BIST_2_DFT_MAX_RAM_SIZE(x) (((uint32_t)(((uint32_t)(x)) << XCVR_TX_DIG_RF_DFT_BIST_2_DFT_MAX_RAM_SIZE_SHIFT)) & XCVR_TX_DIG_RF_DFT_BIST_2_DFT_MAX_RAM_SIZE_MASK)


/*!
 * @}
 */ /* end of group XCVR_TX_DIG_Register_Masks */


/* XCVR_TX_DIG - Peripheral instance base addresses */
/** Peripheral TX_DIG_REGS base pointer */
#define XCVR_TX_DIG_BASE_PTR                     ((XCVR_TX_DIG_MemMapPtr)0x4005C200u)
/** Array initializer of XCVR_TX_DIG peripheral base pointers */
#define XCVR_TX_DIG_BASE_PTRS                    { XCVR_TX_DIG_BASE_PTR }

/* ----------------------------------------------------------------------------
   -- XCVR_TX_DIG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup XCVR_TX_DIG_Register_Accessor_Macros XCVR_TX_DIG - Register accessor macros
 * @{
 */


/* XCVR_TX_DIG - Register instance definitions */
/* TX_DIG_REGS */
#define XCVR_TX_DIG_CTRL                         XCVR_TX_DIG_CTRL_REG(XCVR_TX_DIG_BASE_PTR)
#define XCVR_TX_DIG_DATA_PADDING                 XCVR_TX_DIG_DATA_PADDING_REG(XCVR_TX_DIG_BASE_PTR)
#define XCVR_TX_DIG_GFSK_CTRL                    XCVR_TX_DIG_GFSK_CTRL_REG(XCVR_TX_DIG_BASE_PTR)
#define XCVR_TX_DIG_GFSK_COEFF2                  XCVR_TX_DIG_GFSK_COEFF2_REG(XCVR_TX_DIG_BASE_PTR)
#define XCVR_TX_DIG_GFSK_COEFF1                  XCVR_TX_DIG_GFSK_COEFF1_REG(XCVR_TX_DIG_BASE_PTR)
#define XCVR_TX_DIG_FSK_SCALE                    XCVR_TX_DIG_FSK_SCALE_REG(XCVR_TX_DIG_BASE_PTR)
#define XCVR_TX_DIG_DFT_PATTERN                  XCVR_TX_DIG_DFT_PATTERN_REG(XCVR_TX_DIG_BASE_PTR)
#define XCVR_TX_DIG_RF_DFT_BIST_1                XCVR_TX_DIG_RF_DFT_BIST_1_REG(XCVR_TX_DIG_BASE_PTR)
#define XCVR_TX_DIG_RF_DFT_BIST_2                XCVR_TX_DIG_RF_DFT_BIST_2_REG(XCVR_TX_DIG_BASE_PTR)

/*!
 * @}
 */ /* end of group XCVR_TX_DIG_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group XCVR_TX_DIG_Peripheral */


/* ----------------------------------------------------------------------------
  