/*! *********************************************************************************
* \addtogroup HOST_BBOX_UTILITY
* @{
********************************************************************************** */
/*!
* Copyright(c) 2015, Freescale Semiconductor, Inc.
* All rights reserved.
*
* \file host_ble.c
* This file is the source file for the Host - Blackbox Utility management
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*
* o Redistributions of source code must retain the above copyright notice, this list
*   of conditions and the following disclaimer.
*
* o Redistributions in binary form must reproduce the above copyright notice, this
*   list of conditions and the following disclaimer in the documentation and/or
*   other materials provided with the distribution.
*
* o Neither the name of Freescale Semiconductor, Inc. nor the names of its
*   contributors may be used to endorse or promote products derived from this
*   software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
*(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/************************************************************************************
*************************************************************************************
* Include
*************************************************************************************
************************************************************************************/

#include "fsci_ble.h"
#include "ble_general.h"

#if gFsciIncluded_c
#include "FsciInterface.h"
#include "FsciCommunication.h"
#endif

/************************************************************************************
*************************************************************************************
* Private constants & macros
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private type definitions
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/

/* Flag which indicates if function has out parameters */
static volatile bool_t bFunctionHasOutParams = FALSE;

#if gFsciIncluded_c && gFsciHostSupport_c
extern clientPacket_t *pFsciHostSyncRsp;

#if gFsciHostSyncUseEvent_c
extern event_t         gFsciHostSyncRspEvent;
#endif
#endif

/************************************************************************************
*************************************************************************************
* Private functions prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/

bleResult_t Ble_Initialize(gapGenericCallback_t gapGenericCallback)
{
    return Ble_HostInitialize(gapGenericCallback, NULL);;
}

bleResult_t Ble_GetCmdStatus(bool_t bHasOutParams)
{
    bleResult_t result = gBleSuccess_c;
    
    /* Set out parameter flag if any */
    bFunctionHasOutParams = bHasOutParams;

    /* Wait for result from the serial interface */
    while( !pFsciHostSyncRsp )
    {
#if gFsciHostSyncUseEvent_c
        OSA_EventWait(&gFsciHostSyncRspEvent, 0x00FFFFFF, FALSE, OSA_WAIT_FOREVER ,&fsciHostSyncRspEventFlags);
#else
        FSCI_receivePacket((void*)fsciBleInterfaceId);
#endif
        
        if( NULL == pFsciHostSyncRsp )
        {
            continue;
        }

        result = (bleResult_t)pFsciHostSyncRsp->structured.payload[0];
    }
    
    /* Check status and wait for outParameters */ 
    if( gBleSuccess_c == result )
    {
        while(bFunctionHasOutParams)
        {
            FSCI_receivePacket((void*)fsciBleInterfaceId);
        }  
    }
    
    /* Free FSCI packet */
    MEM_BufferFree(pFsciHostSyncRsp);
    
    return result;
}


void Ble_OutParamsReady(void)
{
    /* Reset flag which indicates if function has out parameters */
    bFunctionHasOutParams = FALSE;
}

/*************************************************************************************
 *************************************************************************************
 * Private functions
 *************************************************************************************
 ************************************************************************************/

/*! *********************************************************************************
* @}
********************************************************************************** */
