/*! *********************************************************************************
 * \defgroup SHELL GAP
 * @{
 ********************************************************************************** */
/*!
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * \file app.h
 * This file is the interface file for the GAP Shell module
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __PER_H__
#define __PER_H__

/*************************************************************************************
**************************************************************************************
* Public macros
**************************************************************************************
*************************************************************************************/
#include "app.h"

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */
/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

#define FALSE  0
#define TRUE   1

typedef enum
{
    PER_CFG_DATA_LEN,
    PER_CFG_PAYLOAD,
    PER_CFG_TEST_DURATION,
    PER_CFG_TXDBM,
    PER_CFG_CONNDBM
} perConfigType_t;

typedef enum
{
    PER_DATA_FLAG_VALID = 0xfafafafa,
    PER_DATA_FLAG_DUMMY = 0xfbfbfbfb
} perDataFlag_t;

typedef enum
{
    PER_EVT_RX_TEST_START = gControllerReceiverTestStarted_c,
    PER_EVT_TX_TEST_START = gControllerTransmitterTestStarted_c,
    PER_EVT_TEST_END = gControllerTestEnded_c
} perTestEvtType_t;

typedef enum
{
    PER_ENDEVT_FROM_NONE,
    PER_ENDEVT_FROM_TX,
    PER_ENDEVT_FROM_RX
} perTestEndSubEvtType_t;

typedef struct
{
    uint32_t integer_val;
    uint32_t frac_val;
} perCalResult_t;

typedef struct
{
    perCalResult_t per_data[PER_TEST_RECORD_COUNT][PER_TEST_LOOP_COUNT];
    uint32_t rec_index;
    uint16_t data_crc;
    uint32_t data_flag;
} PER_Data_Store_t;

#ifdef __cplusplus
extern "C" {
#endif

typedef int32_t (*perCmdExeResultCB)(perTestEvtType_t evt_type, const perCalResult_t *per_result);

bleResult_t perTestInit(void);
bleResult_t perTriggerTestCmdCompleted(gapControllerTestEvent_t *pGenericEvent);
bleResult_t perStartRx(uint32_t ch_num);
bleResult_t perStartTx(uint32_t ch_num);
bleResult_t perConfig(perConfigType_t cfg_type, uint32_t val);
uint32_t perGetConfig(perConfigType_t cfg_type);
bleResult_t perReset(void);
void perRxTestTimerCallback(void* pParam);
bleResult_t perTestEnd(int32_t is_cal_per);
uint32_t perGetMaxTestDuration(uint32_t pkt_len);
bleResult_t perStoreFlashData(PER_Data_Store_t *per_data);
bleResult_t perReadFlashData(PER_Data_Store_t *per_data);
const PER_Data_Store_t *perGetFlashDataPtr(void);
bleResult_t perSetTxStatus(int32_t busy_or_not);
int32_t perGetTxStatus(void);
bleResult_t perSetRxStatus(int32_t busy_or_not);
int32_t perGetRxStatus(void);
bleResult_t perRegisterCmdExeRsltCB(perCmdExeResultCB cmd_rslt_cb);
bleResult_t perUnregisterCmdExeRsltCB(void);

#ifdef __cplusplus
}
#endif 


#endif /* __PER_H__ */

/*! *********************************************************************************
 * @}
 ********************************************************************************** */
