/******************************************************************************
 * (c) Copyright 2010-2013, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include "common.h"
#include "drivers.h"
#include "debug_console.h"
#include "metering_modules.h"

#if __ICCARM__
#include <yfuns.h>
#endif

void dbg_console_init(uint32_t baudrate, uint32_t sys_clk)
{
    UART_Init(UART0, UART_MODULE_INTRMODE_CONFIG(baudrate, sys_clk));
}

#if __ICCARM__

#pragma weak __write
size_t __write(int handle, const unsigned char * buffer, size_t size)
{
    if (buffer == 0)
    {
        return 0;
    }

    /* This function only writes to "standard out" and "standard err",*/
    /* for all other file handles it returns failure.*/
    if ((handle != _LLIO_STDOUT) && (handle != _LLIO_STDERR))
    {
        return _LLIO_ERROR;
    }

    RS485_PARSE_SET_TO_TRANSMITER();
    UART_Wr(UART0, buffer, size);
    RS485_PARSE_SET_TO_RECEIVER();

    return size;
}

#pragma weak __read
size_t __read(int handle, unsigned char * buffer, size_t size)
{
    /* This function only reads from "standard in", for all other file*/
    /* handles it returns failure.*/
    if (handle != _LLIO_STDIN)
    {
        return _LLIO_ERROR;
    }

    /* Receive data.*/
    UART_Rd(UART0, buffer, size);

    return size;
}

#elif (defined(__GNUC__))
#pragma weak _write
int _write (int handle, char *buffer, int size)
{
    if (buffer == 0)
    {
        /* return -1 if error */
        return -1;
    }

    /* This function only writes to "standard out" and "standard err",*/
    /* for all other file handles it returns failure.*/
    if ((handle != 1) && (handle != 2))
    {
        return -1;
    }

    RS485_PARSE_SET_TO_TRANSMITER();
    UART_Wr(UART0, buffer, size);
    RS485_PARSE_SET_TO_RECEIVER();

    return size;
}

#pragma weak _read
int _read(int handle, char *buffer, int size)
{
    /* This function only reads from "standard in", for all other file*/
    /* handles it returns failure.*/
    if (handle != 0)
    {
        return -1;
    }

    /* Receive data.*/
    UART_Rd(UART0, buffer, size);

    return size;
}
#elif (defined(__CC_ARM))
struct __FILE
{
	int handle;
	/* Whatever you require here. If the only file you are using is */
	/* standard output using printf() for debugging, no file handling */
	/* is required. */
};

/* FILE is typedef in stdio.h. */
#pragma weak __stdout
FILE __stdout;
FILE __stdin;

#pragma weak fputc
int fputc(int ch, FILE *f)
{
    RS485_PARSE_SET_TO_TRANSMITER();
    while (!UART_TxIdle(UART0))
        ;
    UART_PutChar(UART0, ch);
    RS485_PARSE_SET_TO_RECEIVER();

    return 1;
}

#pragma weak fgetc
int fgetc(FILE *f)
{
    while (!UART_RxFull(UART0))
        ;
    return UART_GetChar(UART0);
}
#endif

/*******************************************************************************
 * EOF
 ******************************************************************************/
