/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
#include "common.h"
#include "drivers.h"
#include "metering_modules.h"

/*
    This file implements the vref compensation
*/
#if POWER_METERING_ENABLE_VREF_COMP
static Frac32 base_u_gain1, base_u_gain2, base_u_gain3;
static Frac32 new_u_gain1,  new_u_gain2,  new_u_gain3;
static uint8 gain_update_flag = 0;
extern uint8 vref_k;
#endif

int32_t vref_comp_init(tMETERING_CONFIG_FLASH_DATA *config_data)
{
#if POWER_METERING_ENABLE_VREF_COMP
    gain_update_flag = 0;
    
    base_u_gain1 = new_u_gain1 = config_data->calib_data1.u_gain;
    base_u_gain2 = new_u_gain2 = config_data->calib_data2.u_gain;
    base_u_gain3 = new_u_gain3 = config_data->calib_data3.u_gain;

    if (vref_k >= 60)
    {
        /* if err so much, avoid compensation more than range */
        vref_k = (uint8)(vref_k * 0.6);
    }
#endif

/* 1.2V out on PAD */
#if POWER_METERING_USE_EXTERNAL_VREF
    VREF_Init (VREF_MODULE_CHOP_EN_ICOMP_EN_REG_EN_VREFL_EN_HPWR_CONFIG, 
                VREF_SWITCH_S1_L_S2_H_S3_H_BUFF_EN);
#else
    VREF_Init (VREF_MODULE_CHOP_EN_ICOMP_EN_REG_EN_VREFL_EN_HPWR_CONFIG, 
                VREF_SWITCH_S1_H_S2_L_S3_L_BUFF_EN);
    VREFH_Trim(config_data->vrefh);          /* VREFH trimming                     */
    VREFL_Trim(config_data->vrefl);          /* VREFL trimming                     */
#endif
    
    return 0;
}

int32_t vref_comp_deinit(void)
{
    VREF_Disable();

    return 0;
}

#if POWER_METERING_ENABLE_VREF_COMP
int32_t vref_comp_update_cablib_cfg(tMETERING_CONFIG_FLASH_DATA *config_data)
{
    if ((CALI_FLAG_FIN == config_data->calib_flag) && gain_update_flag)
    {
        gain_update_flag = 0;
        config_data->calib_data1.u_gain = new_u_gain1;
        config_data->calib_data2.u_gain = new_u_gain2;
        config_data->calib_data3.u_gain = new_u_gain3;
    }
    
    return 0;
}

/*
 Vref_k is absolte PPM value.

 ERR = vref_k * (25 - t) * 2 , both I and U added to U gain
 gain = base + err * 2500
*/
int32_t vref_comp_update_calib_gain(int32_t temp)
{
    Frac32 gain;	
    uint32 err;

    if (temp >= 0)
    {
        /* restore the original values */
        new_u_gain1 = base_u_gain1;
        new_u_gain2 = base_u_gain2;
        new_u_gain3 = base_u_gain3;
        gain_update_flag = 1;

	return 0;
    }

    /* diff_t != 0; k > 20 */
    if (vref_k > 25)
    {
        err = vref_k * ( 25 - temp) * 2;		
        gain = err * 2500;

        new_u_gain1 = base_u_gain1 + gain;
        new_u_gain2 = base_u_gain2 + gain;
        new_u_gain3 = base_u_gain3 + gain;

        gain_update_flag = 1;
    }
    
    return 0;
}
#endif

/******************************************************************************
 * End of module                                                              *
 ******************************************************************************/