/******************************************************************************
* (c) Copyright 2010-2015, Freescale Semiconductor Inc.
* ALL RIGHTS RESERVED.
***************************************************************************/
#include "common.h"
#include "drivers.h"
#include "metering_modules.h"
#include <stdint.h>
#include <stdlib.h>

/*
 This file implements temperature sensation
*/

static uint16_t temp_sense_sample_buf[POWER_METERING_TEMP_SAMPLE_NUM] = { 0 };
static uint32_t sample_cnts = 0;
static uint16_t temp_average = 0;
static int32_t  temp_update_flag = 0;

static int32_t temp_sense_update_temp_sample(void)
{
    uint16 temp_val;

    temp_val = ADC_Read(CHD);

    temp_sense_sample_buf[sample_cnts++] = temp_val;

    return 0;
}

static int temp_sense_qsort_comp(const void *a,const void *b)
{
    return *(uint16_t *)a - *(uint16_t *)b;
}

uint16_t temp_sense_get_average_adc_val(void)
{
    return temp_average;
}

int32_t temp_sense_calc_average_temp(void)
{
    uint16_t i;
    uint32_t temp_total = 0;

    temp_sense_update_temp_sample();

    if (sample_cnts >= POWER_METERING_TEMP_SAMPLE_NUM)
    {
        /* used middle 16 values */
        sample_cnts = 0;

        qsort(temp_sense_sample_buf, POWER_METERING_TEMP_SAMPLE_NUM,
              sizeof(uint16_t), temp_sense_qsort_comp);

        for (i = ((POWER_METERING_TEMP_SAMPLE_NUM >> 1) - 8);
            i < ((POWER_METERING_TEMP_SAMPLE_NUM >> 1) + 8); ++i)
        temp_total += temp_sense_sample_buf[i];

        temp_average = temp_total >> 4; /* avg = total / 16 */
    }

    return 0;
}

int32_t temp_sense_set_temp_update_flag(int32_t flag_val)
{
    temp_update_flag = flag_val;

    return 0;
}

int32_t temp_sense_get_temp_update_flag(void)
{
    return temp_update_flag;
}

/*
* get temp by adc value from temperature sensor
*  adc < temp_adc_min, temp >= 70  degree.
*  adc > temp_adc_max, temp <= -40 degree.

return temp *2;
if temp is odd, it is x.5 degree;
 else 
temp = temp / 2;
*/
int32_t temp_sense_calc_cur_temp(void)
{
    uint16_t val = 0, mid = 0, mid1 = 0, mid2 = 0;
    int32_t temp = 0;

    val = temp_average;
    if (val <= temp_adc_min)
        temp = POWER_METERING_TEMP_MAX_TEMP * 2; /* 85c */
    else if (val >= temp_adc_max)
        temp = POWER_METERING_TEMP_MIN_TEMP * 2; /* -40c */
    else {
        int32_t l = 0, u = POWER_METERING_TEMP_COMP_ARRAY_SIZE - 1, m = 0, pos = 0;
        /* (-40, 85) */
        /* Binary search */
        while (1)
        {
            if (l > u)
            {
                pos = -1;
                break;
            }
            m = (l + u) / 2;
      
            if ((adc_temp_ary[m] <= val) && (val <= adc_temp_ary[m + 1]))
            {
                pos = m;
                break;
            }
            else if (adc_temp_ary[m] < val)
                l = m + 1;
            else
                u = m - 1;
        }

        if (-1 == pos)
            return -1;

        mid = (adc_temp_ary[pos] + adc_temp_ary[pos + 1] ) >> 1;
        mid1 = (adc_temp_ary[pos] + mid ) >> 1;
        mid2 = (adc_temp_ary[pos + 1] + mid ) >> 1;

        if (val <= mid1)
            temp = (POWER_METERING_TEMP_MAX_TEMP - pos) * 2;
        else if (val <= mid2)
            temp = (POWER_METERING_TEMP_MAX_TEMP - pos) * 2 - 1;
        else
            temp = (POWER_METERING_TEMP_MAX_TEMP - 1 - pos) * 2;
    }

    return temp;
}

/******************************************************************************
* End of module                                                              *
******************************************************************************/
