/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
/*
    This file implements the RTC function for 1Hz compensation and tamper detection
*/

#ifndef __SMART_CARD_H__
#define __SMART_CARD_H__

#include "metering_modules.h"
#include <stdint.h>
#include <stdio.h>

#define sc_debug(fmt, args...)         \
        do {                    \
            if (POWER_METERING_SC_DEBUG)           \
                printf(fmt, ##args);    \
        } while (0)

#define SMART_CARD_VOLTAGE(on)           \
        {                                \
        if (on)                         \
            GPIO_Clr(GPIOA, PIN5);      \
        else                            \
            GPIO_Set(GPIOA, PIN5);      \
        }

#define SMART_CARD_RESET(x)             \
        {                                \
        if (x)                         \
            GPIO_Set(GPIOE, PIN3);      \
        else                            \
            GPIO_Clr(GPIOE, PIN3);      \
        }

#define SMART_CARD_VOLTAGE_PIN_INIT()   \
        {                               \
            PORT_Init(PORTA, PORT_MODULE_ALT1_MODE, PIN5);      \
            GPIO_Init(GPIOA, GPIO_OUT_LOGIC1_MODE,  PIN5);      \
        }

#define SMART_CARD_RESET_PIN_INIT()                             \
        {                                                       \
            PORT_Init(PORTE, PORT_MODULE_ALT1_MODE, PIN3);      \
            GPIO_Init(GPIOE, GPIO_OUT_LOGIC0_MODE, PIN3);       \
        }

#define SMART_CARD_CLK_PIN_INIT()                               \
        {                                                       \
            PORT_Init(PORTE, PORT_MODULE_ALT2_MODE, PIN5);      \
        }

#define SMART_CARD_IO_PIN_INIT()                                \
        {                                                       \
            PORT_Init(PORTK, PORT_MODULE_ALT2_MODE, PIN6);      \
        }

/* PTF0 for smart card detection */
#define SMART_CARD_DETECT_PIN     PIN2
#define SMART_CARD_DETECTED()     (!(GPIO_Get(GPIOF) & SMART_CARD_DETECT_PIN))
#define SMART_CARD_DETECT_PIN_INIT()                       \
        {                                                       \
            PORT_Init(PORTF,                                    \
                      PORT_MODULE_SMART_CARD_DETECT_ALT1_ANYEDGE_IRQ_MODE,      \
                      SMART_CARD_DETECT_PIN);                   \
            GPIO_Init(GPIOF, GPIO_INP_MODE, SMART_CARD_DETECT_PIN);             \
        }

int32_t smart_card_iso7816_evt_hdl(UART_CALLBACK_TYPE type, int32_t status);
int32_t smart_card_set_activate_flag(int32_t flag);
int32_t smart_card_get_activate_flag(void);
int32_t smart_card_deactivate(void);
int32_t smart_card_activate(void);
int32_t smart_card_init(void);
int32_t smart_card_deinit(void);

#endif /* __SMART_CARD_H__ */