/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
#include "common.h"
#include "metering_modules.h"
#include "drivers.h"
#include "iso7816/scr_ttl.h"
#include "iso7816/scr_gsm11.h"
#include "iso7816/scr_zc_t1.h"
#include <string.h>
#include <stdio.h>

/*
    This file implements esam functions
*/

static int32_t smart_card_activate_flag = 0;

uint8_t gTxBuf[32];
uint8_t gRxBuf[32];

static smartcardreader_params_t gsCReaderParams;
static smartcardreader_params_t *gsCReaderParamsPtr;
sc_adpu_command_t sc_adpu_command;
sc_adpu_response_t sc_adpu_response;

ttl_cmd_t ttl_cmd;
ttl_resp_t ttl_resp;

int32_t smart_card_iso7816_evt_hdl(UART_CALLBACK_TYPE type, int32_t status)
{
    UART_MemMapPtr ptr = gsCReaderParamsPtr->uartMemMapPtr;
    volatile uint8_t tmp = 0;

    if (UART_ER_CALLBACK == type)
    {
        tmp = UART_S1_REG(ptr);
        tmp = UART_D_REG(ptr);
    }
    else if (UART_7816_CALLBACK == type)
    {
        sc_debug("C2 0x%x\r\n", UART_C2_REG(gsCReaderParamsPtr->uartMemMapPtr));
        sc_debug("S1 0x%x\r\n", UART_S1_REG(gsCReaderParamsPtr->uartMemMapPtr));
        sc_debug("IS 0x%x\r\n", UART_IS7816_REG(gsCReaderParamsPtr->uartMemMapPtr));
        sc_debug("IE 0x%x\r\n", UART_IE7816_REG(gsCReaderParamsPtr->uartMemMapPtr));

        if (UART_IS7816_REG(ptr) & UART_IS7816_TXT_MASK)
        {
            UART_IS7816_REG(ptr) = UART_IS7816_TXT_MASK;
            gsCReaderParamsPtr->txtCrossed = 1;
        }
        
        if (UART_IS7816_REG(ptr) & UART_IS7816_RXT_MASK)
        {
            UART_IS7816_REG(ptr) = UART_IS7816_RXT_MASK;
            gsCReaderParamsPtr->rxtCrossed = 1;
        }
        
        if (UART_IS7816_REG(ptr) & UART_IS7816_GTV_MASK)
        {
            UART_IS7816_REG(ptr) = UART_IS7816_GTV_MASK;
            gsCReaderParamsPtr->error_isr_count++;    
        }
        
        if (UART_IS7816_REG(ptr) & UART_IS7816_WT_MASK)
        {  
            UART_IE7816_REG(ptr) &= ~UART_IE7816_WTE_MASK;
            scr_reset_wwt_timer(gsCReaderParamsPtr); /* reset WT timer */    
            gsCReaderParamsPtr->wwtExpired = 1;
        }
        
        if (UART_IS7816_REG(ptr) & UART_IS7816_CWT_MASK)
        {
            /* reset CWT timer otherwise this interrupt keeps coming*/
            UART_IE7816_REG(ptr) &= ~UART_IE7816_CWTE_MASK;
            scr_reset_cwt_timer(gsCReaderParamsPtr);     
            gsCReaderParamsPtr->cwtExpired = 1;
        }
        
        if (UART_IS7816_REG(ptr) & UART_IS7816_BWT_MASK)
        {
            UART_IE7816_REG(ptr) &= ~UART_IE7816_BWTE_MASK;
            scr_reset_bwt_timer(gsCReaderParamsPtr); /* reset BWT timer */    
            gsCReaderParamsPtr->bwtExpired = 1;
        }
        
        if (UART_IS7816_REG(ptr) & UART_IS7816_ADT_MASK)
        {
            UART_IE7816_REG(ptr) &= ~UART_IE7816_ADTE_MASK; 
            UART_IS7816_REG(ptr)  = UART_IS7816_ADT_MASK;
            gsCReaderParamsPtr->adtExpired = 1;
        }
        
        if (UART_IS7816_REG(ptr) & UART_IS7816_INITD_MASK)
        {
            UART_IS7816_REG(ptr) = UART_IS7816_INITD_MASK;
            UART_IE7816_REG(ptr) &= ~UART_IE7816_INITDE_MASK;   
            gsCReaderParamsPtr->initDectected = 1;
        }
    }
  
    /* Not send data by interrupt */
    if (((UART_S1_REG(ptr) & UART_S1_TC_MASK) == UART_S1_TC_MASK) &&
     ((UART_S1_REG(ptr) & UART_S1_TDRE_MASK) == UART_S1_TDRE_MASK)
     )
    {
    }

    return 0;
}

static int32_t smart_card_hardware_init(void)
{
    scr_interface_init();
    gsCReaderParamsPtr->sCClockKHz = scr_clock_init() / 1000;
    
    return 0;
}

static int32_t smart_card_emv_param_init(void)
{
    gsCReaderParamsPtr->sCPort = 0;
    gsCReaderParamsPtr->Fi = 372;
    gsCReaderParamsPtr->Di = 1;
    gsCReaderParamsPtr->currentD = 1; /* not use for ISO7816 */
    gsCReaderParamsPtr->WI = 0x02;
    gsCReaderParamsPtr->GTN = 0xFF;
    gsCReaderParamsPtr->CWI = 0x5;
    gsCReaderParamsPtr->BWI = 0x4;
    gsCReaderParamsPtr->BGI = 0x5;
    gsCReaderParamsPtr->adtExpired = 0x00;
    gsCReaderParamsPtr->ttype = kTType0;
    gsCReaderParamsPtr->t0Indicated = 1;
    gsCReaderParamsPtr->t1Indicated = 0;
    gsCReaderParamsPtr->ppsDone = 0;
    gsCReaderParamsPtr->vcc = 0x1; /* 3V */
    gsCReaderParamsPtr->IFSC = 0xFE;
    gsCReaderParamsPtr->IFSD = 0xFE;
    gsCReaderParamsPtr->uartMemMapPtr = UART1_BASE_PTR;
    gsCReaderParamsPtr->parity = kEven;
    gsCReaderParamsPtr->resetType = kColdReset;
    gsCReaderParamsPtr->txtCrossed = 0;
    gsCReaderParamsPtr->rxtCrossed = 0;
    gsCReaderParamsPtr->invalidInitChar = 0;
    gsCReaderParamsPtr->initDelayExpired = 0;
    gsCReaderParamsPtr->initDectected = 0;
    gsCReaderParamsPtr->error_isr_count = 0;

    return 0;
}

static int32_t smart_card_structure_init(void)
{
    memset(&gsCReaderParams, 0, sizeof(smartcardreader_params_t));

    memset(&sc_adpu_command, 0, sizeof(sc_adpu_command_t));
    memset(&sc_adpu_response, 0, sizeof(sc_adpu_response_t));

    gsCReaderParamsPtr = &gsCReaderParams;
    gsCReaderParamsPtr->sCClock = POWER_METERING_SMART_CARD_CLOCK_FREQ;

    smart_card_emv_param_init();

    ttl_cmd.sc_adpu_command = &sc_adpu_command;
    ttl_resp.sc_adpu_response = &sc_adpu_response;

    return 0;
}

int32_t smart_card_deactivate(void)
{
    scr_interface_deactivate(gsCReaderParamsPtr);
    slcd_disp_show_smart_card_detected(0, 0);

    return 0;
}

int32_t smart_card_set_activate_flag(int32_t flag)
{
    smart_card_activate_flag = flag;

    return 0;
}

int32_t smart_card_get_activate_flag(void)
{
    return smart_card_activate_flag;
}

int32_t smart_card_activate(void)
{
    int16_t length = 0, atrLoop = 0;

    smart_card_emv_param_init();

    scr_emv_init(gsCReaderParamsPtr);

    atrLoop = scr_receive_atr_connect(gsCReaderParamsPtr, gRxBuf);
    if (atrLoop < 0)
    {
        slcd_disp_show_smart_card_detected(0, 1);
        return -1;
    }
  
    sc_debug("ATR(%d): ", atrLoop);
    for (length = 0; length < atrLoop; length++)
    {
        sc_debug("%02x", gRxBuf[length]);
    }  
    sc_debug("\r\n");
    
    if (gsCReaderParamsPtr->t1Indicated)
    {
        gsCReaderParamsPtr->ttype = kTType1;
        scr_setup_t1(gsCReaderParamsPtr);
    }
    else
    {
        /* T=0 transport test */
        scr_setup_t0(gsCReaderParamsPtr);
    }

    scr_pps(gsCReaderParamsPtr);

    slcd_disp_show_smart_card_detected(1, 1);

    return 0;
}

int32_t smart_card_init(void)
{
    smart_card_structure_init();

    smart_card_hardware_init();

    return 0;
}

int32_t smart_card_deinit(void)
{
    TMR_Disable(CH3);

    return 0;
}
/******************************************************************************
 * End of module                                                              *
 ******************************************************************************/
