/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// ZeitControl BasicCard
#ifndef __SCR_ZC_T1_H__
#define __SCR_ZC_T1_H__

#include "common.h"
#include "metering_modules.h"
#include "drivers.h"
#include "scr_ttl.h"
#include "scr_interface.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* if print related information define to 1 to print*/
#define SC_ZC_PRINT_FILE_INFO  1
#define SC_ZC_PRINT_DATA_INFO  1

#define SC_DEFAULT_FI      372
#define SC_DEFAULT_DI      1

/* ZC card command class */
#define SC_CLA_ZC        0xC0

/* ZC card intructions */
#define SC_INS_ZC_GET_RESPONCE    0x00
#define SC_INS_ZC_ECHO            0x14
#define SC_INS_ZC_GET_EEPROM_SIZE 0x02
#define SC_INS_ZC_READ_EEPROM     0x08
#define SC_INS_ZC_SET_STATUS      0x0C

/** flags for record operations */
/** use first record */
#define SC_RECORD_NEXT             0x2UL
/** use the specified record number */
#define SC_RECORD_PREV             0x3UL
/** use currently selected record */
#define SC_RECORD_CURR          0x4UL

#if defined(__cplusplus)
extern "C" {
#endif

/* Exported macro ------------------------------------------------------------*/
extern sc_adpu_command_t sc_adpu_command;
extern sc_adpu_response_t sc_adpu_response;
extern ttl_cmd_t ttl_cmd;
extern ttl_resp_t ttl_resp;

/*!
 * @name ZC card application functions
 * @{
 */

/*!
 * @brief Get ZC card status data
 *
 * @param ttl_cmd  Terminal Transport layer command pointer
 * @param ttl_resp Terminal Transport layer response pointer
 * @return Error or success status returned by API.
 */
int32_t sc_zc_getResponse(ttl_cmd_t *ttl_cmd, ttl_resp_t * ttl_resp);

/*!
 * @brief Get ZC card ECHO data command
 *
 * @param ttl_cmd  Terminal Transport layer command pointer
 * @param ttl_resp Terminal Transport layer response pointer
 * @return Error or success status returned by API.
 */
int32_t sc_zc_echo(ttl_cmd_t *ttl_cmd, ttl_resp_t * ttl_resp);

/*!
 * @brief Get ZC card EEPROM size information
 *
 * @param ttl_cmd  Terminal Transport layer command pointer
 * @param ttl_resp Terminal Transport layer response pointer
 * @return Error or success status returned by API.
 */
int32_t sc_zc_getSize(ttl_cmd_t *ttl_cmd, ttl_resp_t * ttl_resp);

/*!
 * @brief Get ZC card read EEPROM data
 *
 * @param ttl_cmd  Terminal Transport layer command pointer
 * @param ttl_resp Terminal Transport layer response pointer
 * @return Error or success status returned by API.
 */
int32_t sc_zc_readData(ttl_cmd_t *ttl_cmd, ttl_resp_t * ttl_resp);

/*!
 * @brief Set ZC card status
 *
 * @param ttl_cmd  Terminal Transport layer command pointer
 * @param ttl_resp Terminal Transport layer response pointer
 * @return Error or success status returned by API.
 */
int32_t sc_zc_setStatus(ttl_cmd_t *ttl_cmd, ttl_resp_t * ttl_resp);

#if defined(__cplusplus)
}
#endif

#endif /* __FSL_SCR_ZC_T1_H__ */

/*******************************************************************************
 * EOF
 ******************************************************************************/
