/*
* Copyright (c) 2014, Freescale Semiconductor, Inc.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*
* o Redistributions of source code must retain the above copyright notice, this list
*   of conditions and the following disclaimer.
*
* o Redistributions in binary form must reproduce the above copyright notice, this
*   list of conditions and the following disclaimer in the documentation and/or
*   other materials provided with the distribution.
*
* o Neither the name of Freescale Semiconductor, Inc. nor the names of its
*   contributors may be used to endorse or promote products derived from this
*   software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <string.h>
#include "scr_zc_t1.h"

/*******************************************************************************
* Defines
******************************************************************************/
/*******************************************************************************
* Prototypes
******************************************************************************/

/*******************************************************************************
* Variables
******************************************************************************/

/*******************************************************************************
* Code
******************************************************************************/

/*FUNCTION**********************************************************************
 *
 * Function Name : sc_zc_getResponse
 * Description   : Get ZC card status registers 
 * This function will read ZC card status and version information
 *
 *END**************************************************************************/
int32_t sc_zc_getResponse(ttl_cmd_t *ttl_cmd, ttl_resp_t *ttl_resp)
{
    uint16_t length = 0;
    uint8_t *version;
    uint8_t i;
    

    ttl_cmd->NAD = 0;//NAD
    ttl_cmd->PCB ^= 0x40;//PCB
    ttl_cmd->LEN = 5;
    ttl_cmd->sc_adpu_command->adpuHeader.CLA = SC_CLA_ZC;
    ttl_cmd->sc_adpu_command->adpuHeader.INS = SC_INS_ZC_GET_RESPONCE;
    ttl_cmd->sc_adpu_command->adpuHeader.P1 = 0;
    ttl_cmd->sc_adpu_command->adpuHeader.P2 = 0;
    ttl_cmd->sc_adpu_command->adpuBody.LC   = 0;
    ttl_cmd->sc_adpu_command->adpuBody.LE   = 0x0c;
        
    length = sc_t1_send_command(ttl_cmd, ttl_resp);


#if  (SC_ZC_PRINT_FILE_INFO == 1)
    //only print file select report if command terminate successfully
    if(sc_adpu_response.SW1 == 0x90)
    {
        sc_debug("ZC get status command end successfully\r\n");
        sc_debug("ZC status = 0x%x\r\n", gRxBuf[3]);
        version = &(gRxBuf[4]);
        sc_debug("ZC version informaiton:");
        for(i = 0;i<length;i++)
        {
            sc_debug("%c", *version);
            version++;
            if((*version == 0x90)||(*version == 0x61)||(*version == 0x60))
            {
                break;
            }
        }
        sc_debug("\r\n");
        
    }
#endif
    
    return 0;
}

/*FUNCTION**********************************************************************
 *
 * Function Name : sc_zc_echo
 * Description   : ZC card Echo master command data  
 * This function send echo command to ZC card and expected the response from ZC card
 *
 *END**************************************************************************/
int32_t sc_zc_echo(ttl_cmd_t *ttl_cmd, ttl_resp_t *ttl_resp)
{
    uint16_t length = 0;
    uint8_t i;
    

    ttl_cmd->NAD = 0;//NAD
    ttl_cmd->PCB ^= 0x40;//PCB//PCB
    ttl_cmd->LEN = 5;
    ttl_cmd->sc_adpu_command->adpuHeader.CLA = SC_CLA_ZC;
    ttl_cmd->sc_adpu_command->adpuHeader.INS = SC_INS_ZC_ECHO;
    ttl_cmd->sc_adpu_command->adpuHeader.P1 = 0x01;
    ttl_cmd->sc_adpu_command->adpuHeader.P2 = 0;
    ttl_cmd->sc_adpu_command->adpuBody.LC = 0x0;
    ttl_cmd->sc_adpu_command->adpuBody.LE = 0x03;
    length = sc_t1_send_command(ttl_cmd, ttl_resp);


#if   (SC_ZC_PRINT_FILE_INFO == 1)
    //only print file select report if command terminate successfully
    if(sc_adpu_response.SW1 == 0x90)
    {
        sc_debug("ZC ECHO command end successfully\r\n");
        sc_debug("Data echo: ");
        for(i = 3;i<length-3;i++)
        {
            sc_debug("%02x ", gRxBuf[i]);
        }
        sc_debug("\r\n\r\n");
        
    }
#endif
    
    return 0;
}

/*FUNCTION**********************************************************************
 *
 * Function Name : sc_zc_getSize
 * Description   : ZC card get EEPROM size command  
 * This function read EEPROM size of ZC card
 *
 *END**************************************************************************/
int32_t sc_zc_getSize(ttl_cmd_t *ttl_cmd, ttl_resp_t *ttl_resp)
{
    ttl_cmd->NAD = 0;//NAD
    ttl_cmd->PCB ^= 0x40;//PCB//PCB
    ttl_cmd->LEN = 5;
    ttl_cmd->sc_adpu_command->adpuHeader.CLA= SC_CLA_ZC;
    ttl_cmd->sc_adpu_command->adpuHeader.INS= SC_INS_ZC_GET_EEPROM_SIZE;
    ttl_cmd->sc_adpu_command->adpuHeader.P1 = 0x00;
    ttl_cmd->sc_adpu_command->adpuHeader.P2 = 0x00;
    ttl_cmd->sc_adpu_command->adpuBody.LC = 0x00;
    ttl_cmd->sc_adpu_command->adpuBody.LE = 0x04;
    
    sc_t1_send_command(ttl_cmd, ttl_resp);

#if   (SC_ZC_PRINT_FILE_INFO == 1)
    //only print file select report if command terminate successfully
    if(sc_adpu_response.SW1 == 0x90)
    {
        sc_debug("ZC Get EEPRO Size command end successfully\r\n");
        sc_debug("EEPROM Start address: 0x%02x%02x\r\n", gRxBuf[3], gRxBuf[4]);
        sc_debug("EEPROM End   address: 0x%02x%02x\r\n", gRxBuf[5], gRxBuf[6]);
        
        sc_debug("\r\n\r\n");
        
    }
#endif
    
    return 0;
}

/*FUNCTION**********************************************************************
 *
 * Function Name : sc_zc_readData
 * Description   : ZC card read EEPROM data 
 * This function read EEPROM data from expected address
 *
 *END**************************************************************************/
int32_t sc_zc_readData(ttl_cmd_t *ttl_cmd, ttl_resp_t *ttl_resp)
{
    uint16_t length = 0;
    uint8_t i;
    

    ttl_cmd->NAD = 0;//NAD
    ttl_cmd->PCB ^= 0x40;//PCB
    ttl_cmd->LEN = 5;
    ttl_cmd->sc_adpu_command->adpuHeader.CLA= SC_CLA_ZC;
    ttl_cmd->sc_adpu_command->adpuHeader.INS= SC_INS_ZC_READ_EEPROM;
    ttl_cmd->sc_adpu_command->adpuHeader.P1 = 0x40;
    ttl_cmd->sc_adpu_command->adpuHeader.P2 = 0x00;
    ttl_cmd->sc_adpu_command->adpuBody.LC = 0x00;
    ttl_cmd->sc_adpu_command->adpuBody.LE = 0x05;
    length = sc_t1_send_command(ttl_cmd, ttl_resp);


#if   (SC_ZC_PRINT_FILE_INFO == 1)
    //only print file select report if command terminate successfully
    if(sc_adpu_response.SW1 == 0x90)
    {
        sc_debug("ZC ECHO command end successfully\r\n");
        sc_debug("Data echo: ");
        for(i = 3;i<length-3;i++)
        {
            sc_debug("%02x ", gRxBuf[i]);
        }
        sc_debug("\r\n\r\n");
        
    }
#endif
    
    return 0;
}

/*FUNCTION**********************************************************************
 *
 * Function Name : sc_zc_setStatus
 * Description   : ZC card set ZC status command 
 * This function set ZC card status
 *
 *END**************************************************************************/
int32_t sc_zc_setStatus(ttl_cmd_t *ttl_cmd, ttl_resp_t *ttl_resp)
{
    ttl_cmd->NAD = 0;//NAD
    ttl_cmd->PCB ^= 0x40;//PCB//PCB
    ttl_cmd->LEN = 4;
    ttl_cmd->sc_adpu_command->adpuHeader.CLA= SC_CLA_ZC;
    ttl_cmd->sc_adpu_command->adpuHeader.INS= SC_INS_ZC_SET_STATUS;
    ttl_cmd->sc_adpu_command->adpuHeader.P1 = 0x01;
    ttl_cmd->sc_adpu_command->adpuHeader.P2 = 0x00;
    ttl_cmd->sc_adpu_command->adpuBody.LC = 0x00;
    ttl_cmd->sc_adpu_command->adpuBody.LE = 0x00;
//    ttl_cmd->sc_adpu_command->adpuBody.Data[0] = 0xAD;
//    ttl_cmd->sc_adpu_command->adpuBody.Data[1] = 0xAC;
//    ttl_cmd->sc_adpu_command->adpuBody.Data[2] = 0xAB;
//    ttl_cmd->sc_adpu_command->adpuBody.Data[3] = 0xAA;
//    ttl_cmd->sc_adpu_command->adpuBody.Data[4] = 0xAF;
    sc_t1_send_command(ttl_cmd, ttl_resp);


#if   (SC_ZC_PRINT_FILE_INFO == 1)
    //only print file select report if command terminate successfully
    if(sc_adpu_response.SW1 == 0x90)
    {
        sc_debug("ZC SetStatus command end successfully\r\n");
        sc_debug("\r\n\r\n");
        
    }
#endif
    
    return 0;
}

/*******************************************************************************
 * EOF
 ******************************************************************************/

