/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
#include "common.h"
#include "metering_modules.h"
#include "drivers.h"
#include <string.h>
#include <stdio.h>

/*
    This file implements rtc event functions
*/
static int8_t key_holding_flag = 0;
static int8_t pin_pulling_flag = 0;

static void rtc_evt_rtc_event(IRTC_CALLBACK_TYPE type, void *data)
{
    static uint8_t sec_5_ind = 0;
    switch (type)
    {
    case IRTC_TAMPER0_CALLBACK:
#if POWER_METERING_ENABLE_ESD_TEST_MODE
        esd_test_handle_tamper();
#endif
        IRTC_ClrIsrFlag(IRTC_TAMPER0_MASK);
        break;
    case IRTC_TAMPER1_CALLBACK:
#if POWER_METERING_ENABLE_ESD_TEST_MODE
        esd_test_handle_tamper();
#endif
        IRTC_ClrIsrFlag(IRTC_TAMPER1_MASK);
        break;
    case IRTC_MIN_CALLBACK:
        IRTC_EnableIsr(IRTC_1HZ_MASK);
        break;
    case IRTC_128HZ_CALLBACK:
        if (key_handler_key_pressed())
        {
            IRTC_DisableIsr(IRTC_128HZ_MASK);
            key_holding_flag = 1;
        }
        break;
    case IRTC_1HZ_CALLBACK:
#if POWER_METERING_ENABLE_RTC_COMP
        /* RTC comp, frequency is 1Hz */
#endif
        if (key_handler_pin_pull_detected())
        {
            pin_pulling_flag = 1;
        }
#if POWER_METERING_SLCD_SUPPORT
        /* Display, interval is 1s */
        slcd_disp_set_refresh_flag(1);
        /* display a simple counting up value at LCD (one count per second). */
        slcd_disp_show_run_cnt();
#endif
#if POWER_METERING_ENABLE_ESD_TEST_MODE
        /* MCU toggle a LED (fast blinking). */
        LED_ToggleLED(MFUNC);
#endif
        if (SMC_MODE_VLPR == SMC_GetMode())
        {
            if (++sec_5_ind == POWER_METERING_VLPR_WAKEUP_SEC)
            {
                sec_5_ind = 0;
                IRTC_DisableIsr(IRTC_1HZ_MASK);
                work_mode_set_enter_vlps_flag(1);
            }
        }
        break;
    default:
        break;
    }
}

int32_t rtc_evt_get_key_holding_flag(void)
{
    return key_holding_flag;
}

int32_t rtc_evt_release_key_holding_flag(void)
{
    key_holding_flag = 0;

    return 0;
}

int32_t rtc_evt_get_pin_pulling_flag(void)
{
    return pin_pulling_flag;
}

int32_t rtc_evt_release_pin_pulling_flag(void)
{
    pin_pulling_flag = 0;

    return 0;
}

int32_t rtc_evt_init(void)
{
    IRTC_InstallCallback (PRI_LVL2, rtc_evt_rtc_event);

    return 0;
}

/******************************************************************************
 * End of module                                                              *
 ******************************************************************************/
