/******************************************************************************
* (c) Copyright 2010-2015, Freescale Semiconductor Inc.
* ALL RIGHTS RESERVED.
***************************************************************************/
/*
 This file implements the RTC function for 1Hz compensation and tamper detection
*/

#ifndef __RTC_COMP_H__
#define __RTC_COMP_H__

#include <stdint.h>

extern const uint16_t temp_adc_min;
extern const uint16_t temp_adc_max;
extern const uint16_t adc_temp_ary[];
extern const uint16_t rtc_comp[];

int32_t rtc_comp_init(void);
int32_t rtc_comp_deinit(void);
int32_t rtc_comp_do_comp(void);
int32_t rtc_comp_cal_ppm(double diff);
int32_t rtc_comp_cal_rtc_ext(double diff, int8_t *pinte, uint8_t *pfrac);
int32_t rtc_comp_cal_rtc(int32_t ppm, int8_t *pinte, uint8_t *pfrac);

#endif /* __RTC_FUNC_H__ */ 
