/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
/*
    This file implements the RTC function for 1Hz compensation and tamper detection
*/

#ifndef __PULSE_OUT_H__
#define __PULSE_OUT_H__

#include <stdint.h>

/* led and pulse */
#define PULSE_KWH_PIN           PIN2
#define PULSE_KVARH_PIN         PIN7
#define PULSE_MFUNC_PIN         PIN5

#define PULSE_KWH_HIGH()        { GPIO_Set(FGPIOE, PULSE_KWH_PIN); }
#define PULSE_KWH_LOW()         { GPIO_Clr(FGPIOE, PULSE_KWH_PIN); }
#define PULSE_KWH_TOGGLE()      { GPIO_Tgl(FGPIOE, PULSE_KWH_PIN); }

#define PULSE_KVARH_HIGH()      { GPIO_Set(FGPIOD, PULSE_KVARH_PIN);}
#define PULSE_KVARH_LOW()       { GPIO_Clr(FGPIOD, PULSE_KVARH_PIN);}
#define PULSE_KVARH_TOGGLE()    { GPIO_Tgl(FGPIOD, PULSE_KVARH_PIN);}

#define PULSE_MFUNC_HIGH()      { GPIO_Set(FGPIOD, PULSE_MFUNC_PIN);}
#define PULSE_MFUNC_LOW()       { GPIO_Clr(FGPIOD, PULSE_MFUNC_PIN);}
#define PULSE_MFUNC_TOGGLE()    { GPIO_Tgl(FGPIOD, PULSE_MFUNC_PIN);}

#define PULSE_KWH_PIN_INIT()                                                   \
        {                                                                      \
            PORT_Init(PORTE , PORT_MODULE_ALT1_MODE, PULSE_KWH_PIN);          \
            GPIO_Init(FGPIOE, GPIO_OUT_LOGIC0_MODE,  PULSE_KWH_PIN);          \
        }

#define PULSE_KVARH_PIN_INIT()                                                 \
        {                                                                      \
            PORT_Init(PORTD , PORT_MODULE_ALT1_MODE, PULSE_KVARH_PIN);        \
            GPIO_Init(FGPIOD, GPIO_OUT_LOGIC0_MODE,  PULSE_KVARH_PIN);        \
        }

#define PULSE_MFUNC_PIN_INIT()                                                 \
        {                                                                      \
            PORT_Init(PORTD , PORT_MODULE_ALT1_MODE, PULSE_MFUNC_PIN);        \
            GPIO_Init(FGPIOD, GPIO_OUT_LOGIC0_MODE,  PULSE_MFUNC_PIN);        \
        }

int32_t pulse_out_init(void);
int32_t pulse_out_deinit(void);
int32_t pulse_out_pulse_status_update(void);
int32_t pulse_out_update_period(void);
int32_t pulse_out_check_power_valid_cnt(void);

#endif /* __PULSE_OUT_H__ */ 
