/******************************************************************************
* (c) Copyright 2010-2015, Freescale Semiconductor Inc.
* ALL RIGHTS RESERVED.
***************************************************************************/
#include "common.h"
#include "metering_modules.h"
#include "drivers.h"

/*
 This file implements pit trigger function
*/

static void pit_trigger_callback(PIT_CALLBACK_TYPE type)
{
    switch (type)
    {
    case PIT0CH0_CALLBACK:
        break;
    case PIT0CH1_CALLBACK:
        /* RTC comp, 1s for, 60s for rtc_comp */
        temp_sense_set_temp_update_flag(1);
        break;
    case PIT1CH0_CALLBACK:
        pulse_out_update_period();
        pulse_out_pulse_status_update();
        break;
    case PIT1CH1_CALLBACK:
        break;
    default:
        break;
    }
}

void pit_trigger_init(void)
{
    PIT_InstallCallback(PRI_LVL0, pit_trigger_callback);
}

/******************************************************************************
* End of module                                                              *
******************************************************************************/
