/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
#include "common.h"
#include "metering_modules.h"
#include "drivers.h"
#include <string.h>
#include <stdio.h>

/*
    This file implements nvm data save and read functions
*/

/* put the data to the last of flash , size is 0x140 = 320 bytes */
#ifdef POWER_METERING_FLASH_CONFIG_ADDR
    #pragma location = POWER_METERING_FLASH_CONFIG_ADDR
#else
    /* .config section should be defined in icf file */
    #pragma location = ".config"
#endif
/* This variable is stored in flash */
const tMETERING_CONFIG_FLASH_DATA   nvm_metering_cfg;

/***************************************************************************//*!
 * @brief   Reads configuration data from NVM memory conditionally.
 * @param   ptr   - pointer to tCONFIG_DATA to be read
 * @return  1 - error
 *          0 - success
 * @note    Implemented as a function call.
 ******************************************************************************/
int32 nvm_config_read(void *ptr, int32_t length)
{
    tMETERING_Calib_Flag calib_flag = nvm_metering_cfg.calib_flag;
    if ((calib_flag == CALI_FLAG_FIN) ||
        (calib_flag == CALI_FLAG_DATA_READY) ||
        (calib_flag == CALI_FLAG_INIT) ||
        (calib_flag == CALI_FLAG_ITERA_INIT) ||
        (calib_flag == CALI_FLAG_ITERA)) 
    {
        memcpy ((void *)ptr, (void *)&nvm_metering_cfg, length);
        return 0;
    }

    return 1;
}

/***************************************************************************//*!
 * @brief   Writes configuration data to NVM memory.
 * @param   ptr   - pointer to tCONFIG_DATA to be saved
 * @param   flag  - configuration flag 
 * @note    Implemented as a function call.
 ******************************************************************************/
int32 nvm_config_write(const void *ptr, int32_t length)
{ 
	FTFA_EraseSector((void *)&nvm_metering_cfg);
	FTFA_WriteArray((void *)&nvm_metering_cfg, (void *)ptr, length);
        
        return 0;
}

/******************************************************************************
 * End of module                                                              *
 ******************************************************************************/