/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
#include "common.h"
#include "metering_modules.h"
#include "drivers.h"
#include <string.h>
#include <stdio.h>

#if POWER_METERING_ENABLE_CPU_LOADING_TST
/*
    This file implements cpu loading caculate functions
*/
volatile uint64_t sys_cnter_val = 0;
volatile uint64_t idle_cnter_val = 0;
static uint64_t idle_loop_counter = 0;

void loading_calc_idle_counter_start(void)
{
        SYST_ClrCntrVal();
        SYST_Enable();
}

void loading_calc_idle_counter_end(void)
{
        SYST_Disable();
        sys_cnter_val += SYST_GetCntrVal();
        if (sys_cnter_val > 0x8000000000000000)
            sys_cnter_val = 0;
        idle_loop_counter++;
        idle_cnter_val = idle_loop_counter * POWER_METERING_LOADING_IDLE_LOOP_COUNT;
}

int32_t loading_calc_init(void)
{
    /* We use system tick for cpu loading calculation */
    SYST_Init(SYST_MODULE_FREERUN_TMR_DIV16_DI_CONFIG, PRI_LVL2, NULL);

    /* clear system Timer                                                       */
    SYST_ClrCntrVal();

    return 0;
}
#endif

/******************************************************************************
 * End of module                                                              *
 ******************************************************************************/