/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************//*!
 * @file      led.h
 * @version   1.0.0.0
 * @date      March-3-2015
 * @brief     LED driver header file.
 ******************************************************************************/
#ifndef __LED_H
#define __LED_H 

#include "gpio/gpio.h"
#include "sim/sim.h"
 
/******************************************************************************
 * Configuration structure definition                                         *
 ******************************************************************************/
/* LEDs definition                                                            */
#define LED_KWH_PIN_NUM                 (2)          /* PTB2 */ 
#define LED_KVARH_PIN_NUM               (3)          /* PTB3 */ 
#define LED_MFUNC_PIN_NUM               (4)          /* PTK4 */ 

#define LED_KWH_PIN_MASK                (1 << LED_KWH_PIN_NUM)         /* PTB2 */ 
#define LED_KVARH_PIN_MASK              (1 << LED_KVARH_PIN_NUM)        /* PTB3 */ 
#define LED_MFUNC_PIN_MASK              (1 << LED_MFUNC_PIN_NUM)       /* PTK4 */

#define LED_SetKWHLEDOn                                                       \
                    {                                                         \
                        GPIO_Set  (GPIOB, LED_KWH_PIN_MASK);                           \
                    }

#define LED_SetKWHLEDOff                                                      \
                    {                                                         \
                        GPIO_Clr  (GPIOB, LED_KWH_PIN_MASK);                           \
                    }

#define LED_ToggleKWHLED                                                      \
                    {                                                         \
                        GPIO_Tgl  (GPIOB, LED_KWH_PIN_MASK);                           \
                    }

#define LED_GetKWHLEDStatus ((FGPIOB_PDOR & LED_KWH_PIN_MASK) >> LED_KWH_PIN_NUM)

/******************************************************************************/

#define LED_SetKVARHLEDOn                                                     \
                    {                                                         \
                        GPIO_Set  (GPIOB, LED_KVARH_PIN_MASK);                         \
                    }

#define LED_SetKVARHLEDOff                                                    \
                    {                                                         \
                        GPIO_Clr  (GPIOB, LED_KVARH_PIN_MASK);                         \
                    }

#define LED_ToggleKVARHLED                                                    \
                    {                                                         \
                        GPIO_Tgl  (GPIOB, LED_KVARH_PIN_MASK);                         \
                    }

#define LED_GetKVARHLEDStatus ((FGPIOB_PDOR & LED_KVARH_PIN_MASK) >> LED_KVARH_PIN_NUM)

/******************************************************************************/

#define LED_SetMFUNCLEDOn                                                     \
                    {                                                         \
                        GPIO_Set  (GPIOB, LED_MFUNC_PIN_MASK);                         \
                    }

#define LED_SetMFUNCLEDOff                                                    \
                    {                                                         \
                        GPIO_Clr  (GPIOB, LED_MFUNC_PIN_MASK);                         \
                    }

#define LED_ToggleMFUNCLED                                                    \
                    {                                                         \
                        GPIO_Tgl  (GPIOB, LED_MFUNC_PIN_MASK);                         \
                    }

#define LED_GetMFUNCLEDStatus ((FGPIOB_PDOR & LED_MFUNC_PIN_MASK) >> LED_MFUNC_PIN_NUM)

#define LED_SetLED(type, onoff) LED_Set##type##LED##onoff
#define LED_ToggleLED(type)     LED_Toggle##type##LED
#define LED_GetLEDStatus(type)  LED_Get##type##LED##Status

/******************************************************************************
 * public function prototypes                                                 *
 ******************************************************************************/
#define LED_Init()                                                            \
                    {                                                         \
                        SIM_EnableModule(PORTB);                              \
                        SIM_EnableModule(PORTB);                              \
                        PORT_Init(PORTB, PORT_MODULE_LED_MODE, LED_KWH_PIN_MASK);     \
                        PORT_Init(PORTB, PORT_MODULE_LED_MODE, LED_KVARH_PIN_MASK);   \
                        PORT_Init(PORTB, PORT_MODULE_LED_MODE, LED_MFUNC_PIN_MASK);   \
                        GPIO_Init(GPIOB, GPIO_OUT_LOGIC0_MODE, LED_KWH_PIN_MASK);     \
                        GPIO_Init(GPIOB, GPIO_OUT_LOGIC0_MODE, LED_KVARH_PIN_MASK);   \
                        GPIO_Init(GPIOB, GPIO_OUT_LOGIC0_MODE, LED_MFUNC_PIN_MASK);   \
                    }

#endif /* __LED_H */ 