/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
/*
    This file implements the RTC function for 1Hz compensation and tamper detection
*/

#ifndef __KEY_HANDLER_H__
#define __KEY_HANDLER_H__

#include "metering_modules.h"
#include <stdint.h>

#define KEY_SW4_PIN_NUM     1
#define KEY_SW5_PIN_NUM     0
#define KEY_SW3_PIN_NUM     4
#define BATTERY_PIN_NUM     4

#define KEY_SW4_PIN_MASK    (1 << KEY_SW4_PIN_NUM)
#define KEY_SW5_PIN_MASK    (1 << KEY_SW5_PIN_NUM)
#define KEY_SW3_PIN_MASK    (1 << KEY_SW3_PIN_NUM)
#define BATTERY_PIN_MASK    (1 << BATTERY_PIN_NUM)

#define KEY_SW4_PIN_INIT()                                                      \
        {                                                                       \
            PORT_Init(PORTF, PORT_MODULE_BUTTON_IRQ_MODE, KEY_SW4_PIN_MASK);    \
            GPIO_Init(GPIOF, GPIO_INP_MODE, KEY_SW4_PIN_MASK);                  \
        }

#define KEY_SW4_PRESSING() (!(GPIO_Get(GPIOF) & KEY_SW4_PIN_MASK))

#define KEY_SW5_PIN_INIT()                                                      \
        {                                                                       \
            PORT_Init(PORTF, PORT_MODULE_BUTTON_IRQ_MODE, KEY_SW5_PIN_MASK);    \
            GPIO_Init(GPIOF, GPIO_INP_MODE, KEY_SW5_PIN_MASK);                  \
        }

#define KEY_SW5_PRESSING() (!(GPIO_Get(GPIOF) & KEY_SW5_PIN_MASK))

#define KEY_SW3_PIN_INIT()                                                      \
        {                                                                       \
            PORT_Init(PORTE, PORT_MODULE_BUTTON_IRQ_MODE, KEY_SW3_PIN_MASK);    \
            GPIO_Init(GPIOE, GPIO_INP_MODE, KEY_SW3_PIN_MASK);                  \
        }

#define KEY_SW3_PRESSING() (!(GPIO_Get(GPIOE) & KEY_SW3_PIN_MASK))

#define BATTERY_PIN_INIT()                                                      \
        {                                                                       \
            PORT_Init(PORTD,                                                    \
                      PORT_MODULE_BATTERY_PIN_ALT1_ANYEDGE_IRQ_MODE,            \
                      BATTERY_PIN_MASK);                                        \
            GPIO_Init(GPIOD, GPIO_INP_MODE, BATTERY_PIN_MASK);                  \
        }

#define BATTERY_PIN_STATUS()    (!(GPIO_Get(GPIOD) & BATTERY_PIN_MASK))

int32_t key_handler_init(void);
int32_t key_handler_key_pressed(void);
int32_t key_handler_key_pressing_check(void);
int32_t key_handler_key_press_evt(void);
int32_t key_handler_pin_pull_detected(void);
int32_t key_handler_pin_pulling_check(void);
int32_t key_handler_pin_pull_evt(void);

#endif /* __KEY_HANDLER_H__ */ 