/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
/*
    This file implements the RTC function for 1Hz compensation and tamper detection
*/

#ifndef __IRDA_H__
#define __IRDA_H__

#include "metering_modules.h"
#include <stdint.h>

#define IRDA_TX_PIN_INIT()   \
        {                               \
            PORT_Init(PORTI, PORT_MODULE_ALT2_MODE, PIN3);      \
        }

#define IRDA_RX_PIN_INIT()                             \
        {                                                       \
            PORT_Init(PORTI, PORT_MODULE_ALT2_MODE, PIN2);      \
        }

/* xbar_out4 */
#define IRDA_CLK_PIN_INIT()                               \
        {                                                       \
            PORT_Init(PORTE, PORT_MODULE_ALT3_MODE, PIN0);      \
        }

#define IRDA_XFER_BLOCKING      (0)
#define IRDA_XFER_NON_BLOCKING  (1)

int32_t irda_send_b(uint8_t *buf, uint32_t len);
int32_t irda_data_sent_status(void);
uint32_t irda_send_char_nb(uint8_t ch);
int32_t irda_receive_b(uint8_t *buf, uint32_t len);
uint8_t irda_data_receive_status(void);
uint8_t irda_receive_char_nb(void);
int32_t irda_init(uint32_t rx_mode, uint32_t tx_mode);
int32_t irda_deinit(void);

#endif /* __RTC_FUNC_H__ */ 