/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
#include "common.h"
#include "metering_modules.h"
#include "drivers.h"
#include <string.h>
#include <stdio.h>

/*
    This file implements nvm data save and read functions
*/
#if POWER_METERING_ENABLE_ESD_TEST_MODE

static int32_t esd_test_init_reserve_pins(void)
{
    /* XBAR0_OUT0 */
    PORT_Init(PORTA, PORT_MODULE_ALT2_MODE, PIN7);

    /* Mag INT1 */
    PORT_Init(PORTB, PORT_MODULE_ALT1_MODE, PIN4);
    GPIO_Init(GPIOB, GPIO_OUT_LOGIC0_MODE,  PIN4);

    /* ESAM VCC */
    PORT_Init(PORTB, PORT_MODULE_ALT1_MODE, PIN5);
    GPIO_Init(GPIOB, GPIO_OUT_LOGIC0_MODE,  PIN5);

    PORT_Init(PORTB, PORT_MODULE_ALT1_MODE, PIN6);
    GPIO_Init(GPIOB, GPIO_OUT_LOGIC0_MODE,  PIN6);

    PORT_Init(PORTB, PORT_MODULE_ALT1_MODE, PIN7);
    GPIO_Init(GPIOB, GPIO_OUT_LOGIC0_MODE,  PIN7);

    PORT_Init(PORTC, PORT_MODULE_ALT1_MODE, PIN0);
    GPIO_Init(GPIOC, GPIO_OUT_LOGIC0_MODE,  PIN0);

    /* ESAM RST */
    PORT_Init(PORTC, PORT_MODULE_ALT1_MODE, PIN1);
    GPIO_Init(GPIOC, GPIO_OUT_LOGIC0_MODE,  PIN1);

    /* UART3_TX */
    PORT_Init(PORTC, PORT_MODULE_ALT2_MODE, PIN2);

    PORT_Init(PORTC, PORT_MODULE_ALT1_MODE, PIN3);
    GPIO_Init(GPIOC, GPIO_OUT_LOGIC0_MODE,  PIN3);

    PORT_Init(PORTC, PORT_MODULE_ALT1_MODE, PIN4);
    GPIO_Init(GPIOC, GPIO_OUT_LOGIC0_MODE,  PIN4);

    PORT_Init(PORTD, PORT_MODULE_ALT1_MODE, PIN0);
    GPIO_Init(GPIOD, GPIO_OUT_LOGIC0_MODE,  PIN0);

    PORT_Init(PORTD, PORT_MODULE_ALT1_MODE, PIN1);
    GPIO_Init(GPIOD, GPIO_OUT_LOGIC0_MODE,  PIN1);

    PORT_Init(PORTD, PORT_MODULE_ALT1_MODE, PIN2);
    GPIO_Init(GPIOD, GPIO_OUT_LOGIC0_MODE,  PIN2);

    PORT_Init(PORTD, PORT_MODULE_ALT1_MODE, PIN3);
    GPIO_Init(GPIOD, GPIO_OUT_LOGIC0_MODE,  PIN3);

    /* Grid voltage detection Pin */
    PORT_Init(PORTD, PORT_MODULE_ALT1_MODE, PIN4);
    GPIO_Init(GPIOD, GPIO_INP_MODE,         PIN4);

    /* ADC0_SE5a */
    PORT_Init(PORTD, PORT_MODULE_ALT0_MODE, PIN6);

    /* I2C1_SDA */
    PORT_Init(PORTJ, PORT_MODULE_ALT2_MODE, PIN0);
    /* I2C1_SCL */
    PORT_Init(PORTJ, PORT_MODULE_ALT2_MODE, PIN1);

    PORT_Init(PORTJ, PORT_MODULE_ALT1_MODE, PIN3);
    GPIO_Init(GPIOJ, GPIO_OUT_LOGIC0_MODE,  PIN3);

    PORT_Init(PORTJ, PORT_MODULE_ALT1_MODE, PIN4);
    GPIO_Init(GPIOJ, GPIO_OUT_LOGIC0_MODE,  PIN4);

    PORT_Init(PORTJ, PORT_MODULE_ALT1_MODE, PIN5);
    GPIO_Init(GPIOJ, GPIO_OUT_LOGIC0_MODE,  PIN5);

    PORT_Init(PORTJ, PORT_MODULE_ALT1_MODE, PIN6);
    GPIO_Init(GPIOJ, GPIO_OUT_LOGIC0_MODE,  PIN6);

    PORT_Init(PORTJ, PORT_MODULE_ALT1_MODE, PIN7);
    GPIO_Init(GPIOJ, GPIO_OUT_LOGIC0_MODE,  PIN7);

    return 0;
}

int32_t esd_test_handle_hardfault(void)
{
    slcd_display_show_hardfault();
    while (1)
    {
        LED_ToggleLED(KVARH);
        arch_delay(30000000);
    }
    return 0;
}

int32_t esd_test_handle_nmi(void)
{
    slcd_display_show_nmi();
    while (1)
    {
        LED_ToggleLED(KVARH);
        arch_delay(30000000);
    }
    return 0;
}

int32_t esd_test_handle_tamper(void)
{
    slcd_display_show_tamper();
    while (1)
    {
        LED_ToggleLED(KVARH);
        arch_delay(30000000);
    }
    return 0;
}

int32_t esd_test_init(void)
{
    int32_t i = 0;

    esd_test_init_reserve_pins();

    /* Toggle the LCD backlight for 3 to 5 second as a unique pattern for reset indicator */
    for (i = 0; i < 10; ++i)
    {
        slcd_disp_backlight_ctrl(1);
        slcd_disp_show_all();
        arch_delay(10000000);
        slcd_disp_backlight_ctrl(0);
        slcd_disp_clear_all();
        arch_delay(10000000);
    }

    /* Display the reset source information at LCD display */
    slcd_disp_show_reset_source();

    /* Keep the MCU waiting for a key press action from end user */
    /* We use SW5 for it, interrupt is not enabled yet, so we polling for it */
    PORT_Init(PORTF, PORT_MODULE_BUTTON_MODE, KEY_SW5_PIN_MASK);
    GPIO_Init(GPIOF, GPIO_INP_MODE,           KEY_SW5_PIN_MASK);
    
    while (GPIO_Get(GPIOF) & KEY_SW5_PIN_MASK)
        NOP();

    slcd_disp_clear_all();

    key_handler_init();
    slcd_disp_init();

    return 0;
}
#endif

/******************************************************************************
 * End of module                                                              *
 ******************************************************************************/