/******************************************************************************
* (c) Copyright 2010-2015, Freescale Semiconductor Inc.
* ALL RIGHTS RESERVED.
***************************************************************************/

#include "drivers.h"
#include "debug_console.h"
#include "metering_modules.h"
#include <stdint.h>
#include <stdio.h>

/******************************************************************************
 * HardFault handler
 ******************************************************************************/
void hardfault_isr(void)
{
    /* Mark occurence of the hard fault exception */
    metering_func_set_hardfault_flag();
#if POWER_METERING_ENABLE_ESD_TEST_MODE
    esd_test_handle_hardfault();
#endif
    /* Enter software loop to wait for watchdog reset */
    for(;;)
    {
    }
}

void nmi_isr(void)
{
#if POWER_METERING_ENABLE_ESD_TEST_MODE
    esd_test_handle_nmi();
#endif
    for(;;)
    {
    }
}

/* The main file is mainly for system init and main loop */
static void normal_hardware_init(void)
{
#if POWER_METERING_ENABLE_WATCHDOG
    /* Initialize watchdog - reset time 0.1s < tWDOG < 0.6s                     */	  
    //WDOG_Init(WDOG_MODULE_WINDOW_STOP_DI_CONFIG(WDOG_LPO_CLK, WDOG_DIV1, 600, 100));
#endif

    /* Reset pin filtered in all modes and filter clocked by LPO                */
    RCM_Init(RCM_MODULE_FILT_CLOCKED_BY_LPO_EN_IN_ALL_MODES_CONFIG);

    /* Enable PMC buffer operation also in VLPx modes                           */      
    PMC_Init(PMC_MODULE_LVDRE_ON_LVDINT_OFF_LVWINT_OFF_CONFIG(PMC_LVDL, PMC_LVW1),
             PMC_INTREG_BGEN_ON_BGBE_OFF_CONFIG,
             PRI_LVL0,
             (PMC_CALLBACK)NULL);

#if (POWER_METERING_ENABLE_CLKOUT_SRC > 0)
    /* Route core clock to PTF7                                                 */
    SIM_SelClkout(POWER_METERING_ENABLE_CLKOUT_SRC);
    PORT_Init(PORTF,PORT_MODULE_ALT3_MODE,PIN7);
#endif

    SMC_Init(SMC_MODULE_VLPS_ON_VLLS_ON_CONFIG);
    SIM_Init(SIM_MODULE_POWER_METERING_RUN_MODE_CONFIG);

#if POWER_METERING_ENABLE_OSC32K_LOAD_CAPS
    OSC32K_Disable();
    OSC32K_SetLoadCaps(OSC32K_SC2P | OSC32K_SC16P);
    OSC32K_Enable ();
#endif

    work_mode_run_mode_freq_init();

#if POWER_METERING_SET_RESET_PIN_TO_GPIOOUT
    /* RESET pin set as GPIO and driven low to improve EMC susceptibility       */
    PORT_Init(PORTE , PORT_MODULE_ALT1_MODE, RESET_PIN_MASK);
    GPIO_Init(FGPIOE, GPIO_OUT_LOGIC0_MODE , RESET_PIN_MASK);
#endif

    /* Enable PLL for AFE */
    PLL_Enable(PLL32KREF_SRC1);

    work_mode_run_mode_module_init();
}

void main (void)
{
    normal_hardware_init();

/* Clock out for debugging */
#ifdef POWER_METERING_DEBUG
    PORT_Init(PORTE,PORT_MODULE_ALT5_MODE, PIN0);
    PORT_Init(PORTE, PORT_MODULE_ALT5_MODE, PIN0);
    SIM_SelClkout(CLKOUT_SRC2);
#endif

#if POWER_METERING_ENABLE_FMSTR
    freemaster_init();
#endif

#if POWER_METERING_ENABLE_ESD_TEST_MODE
    esd_test_init();
#endif

#if POWER_METERING_ENABLE_CPU_LOADING_TST
    loading_calc_init();
#endif

    metering_func_init();

    EnableInterrupts();

#if POWER_METERING_SMART_CARD_SUPPORT
    if (SMART_CARD_DETECTED())
        smart_card_activate();
#endif

    do
    {
#if POWER_METERING_ENABLE_CPU_LOADING_TST
        loading_calc_idle_counter_start();
#endif

        if (SMC_MODE_RUN == SMC_GetMode())
        {
            if (key_handler_key_pressed())
            {
                do
                {
                    if (rtc_evt_get_key_holding_flag())
                    {
                        key_handler_key_press_evt();
                        break;
                    }
                    else
                    {
                        if (key_handler_key_pressing_check())
                        {
                            if (!key_handler_key_pressed())
                                break;
                        }
                    }
                } while (1);
                rtc_evt_release_key_holding_flag();
            }

            if (rtc_evt_get_pin_pulling_flag())
            {
                do
                {
                    if (rtc_evt_get_pin_pulling_flag())
                    {
                        key_handler_pin_pull_evt();
                        break;
                    }
                    else
                    {
                        if (key_handler_pin_pulling_check())
                        {
                            if (!key_handler_pin_pull_detected())
                                break;
                        }
                    }
                } while (1);
                rtc_evt_release_pin_pulling_flag();
            }

            /* Enter vlpr */
            if (work_mode_get_enter_vlpr_flag())
            {
                work_mode_set_enter_vlpr_flag(0);
                work_mode_enter_vlpr();
                /* Enter vlps */
                if (work_mode_get_enter_vlps_flag())
                {
                    work_mode_set_enter_vlps_flag(0);
                    work_mode_enter_vlps();
                }
            }
#if POWER_METERING_SLCD_SUPPORT
            /* Lowest priority task will be run in while of main */
            if (slcd_disp_get_refresh_flag())
            {
                slcd_disp_refresh();
                slcd_disp_set_refresh_flag(0);
            }
#endif
#if POWER_METERING_SMART_CARD_SUPPORT
            if (smart_card_get_activate_flag())
            {
                smart_card_set_activate_flag(0);
                smart_card_activate();
            }
#endif

            /* Check pulse count */
            pulse_out_check_power_valid_cnt();
      
            /* RTC comp, 1s for, 60s for rtc_comp */
            if (temp_sense_get_temp_update_flag())
            {
                temp_sense_calc_average_temp();
                rtc_comp_do_comp();
                temp_sense_set_temp_update_flag(0);
            }
      
            if (rs485_shell_get_cmd_exec_flag())
            {
                rs485_shell_set_cmd_exec_flag(0);
                rs485_shell_exec_fun();
            }
        }
        else
        {
            /* VLPR */
            /* Exit vlpr */
            if (work_mode_get_exit_vlpr_flag())
            {
                work_mode_set_exit_vlpr_flag(0);
                work_mode_exit_vlpr();
            }
#if POWER_METERING_SLCD_SUPPORT
            if (slcd_disp_get_refresh_flag())
            {
                slcd_disp_refresh_vlpr();
                slcd_disp_set_refresh_flag(0);
            }
#endif
        }
#if POWER_METERING_ENABLE_CPU_LOADING_TST
      loading_calc_idle_counter_end();
#endif
    } while (1);
}
