/*****************************************************************************
 * (c) Copyright 2010-2012, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************//*!
 * @file      spi_flash.h
 * @version   1.0.3.0
 * @date      Mar-12-2013
 * @brief     SPI driver header file.
 *
******************************************************************************/
#ifndef __SPI_FLASH_H__
#define __SPI_FLASH_H__

#include "drivers.h"
#include <stdint.h>

#define SPI_FLASH_MACRONIX_VENDER_ID    (0xC2)
#define IDCODE_LEN                      (0x5)

#define ROUND(a,b)  (((a) + (b)) & ~((b) - 1))

#ifndef min
#define min(a, b)   ((a) < (b) ? (a) : (b))
#endif
#ifndef max
#define max(a, b)   ((a) > (b) ? (a) : (b))
#endif

#define ARRAY_SIZE(x) (sizeof(x) / sizeof((x)[0]))

//#ifdef DEBUG
//#define SF_DEBUG(str) UART_PutStr(UART3, str)
//#else
#define SF_DEBUG(str)
//#endif

#define SPI_FLASH_TIMEOUT		(2000)

/* flash commands */
#define CMD_READ_ID			0x9f

#define CMD_READ_ARRAY_SLOW		0x03
#define CMD_READ_ARRAY_FAST		0x0b

#define CMD_WRITE_STATUS		0x01
#define CMD_PAGE_PROGRAM		0x02
#define CMD_WRITE_DISABLE		0x04
#define CMD_READ_STATUS			0x05
#define CMD_WRITE_ENABLE		0x06
#define CMD_ERASE_4K			0x20
#define CMD_ERASE_32K			0x52
#define CMD_ERASE_64K			0xd8
#define CMD_ERASE_CHIP			0xc7

/* flash status */
#define STATUS_WIP			0x01

#define ERASE_SECTOR_4K_SIZE            (4096)
#define ERASE_SECTOR_32K_SIZE           (32768)
#define ERASE_SECTOR_64K_SIZE           (65536)

typedef void (* SPI_FLASH_SS_CTRL)(SS_CONTROL ss_pin);
typedef void (* SPI_FLASH_SPI_COMM_BYTE)(uint8_t *txdata, uint16_t txcnt,uint8_t *rxdata, uint16_t rxcnt);

struct spi_flash {
    const char	*name;
    uint32_t    size;
    uint32_t    page_size;
    uint32_t    sector_size;
    SPI_FLASH_SS_CTRL ss_ctrl;
    SPI_FLASH_SPI_COMM_BYTE spi_comm_byte;
};

int32_t spi_flash_send_cmd(uint8_t cmd, void *response, uint32_t len);
int32_t spi_flash_write(uint32_t offset, uint32_t len, const void *buf);
int32_t spi_flash_read(uint32_t offset, uint32_t data_len, void *data);
int32_t spi_flash_erase(uint32_t offset, uint32_t len);
int32_t spi_flash_write_status(uint8_t sts_reg);
int32_t spi_flash_init(SPI_FLASH_SS_CTRL ss_ctrl, SPI_FLASH_SPI_COMM_BYTE spi_comm_byte);
int32_t spi_flash_init_macronix(struct spi_flash *flash, uint8_t *idcode);

#endif /* __SPI_FLASH_H__ */ 