/*
 * File:    pll_init.h
 * Purpose: pll_driver specific declarations
 *
 * Notes:
 */
#ifndef __MCG_H__
#define __MCG_H__
/********************************************************************/

/* For some reason CW needs to have cw.h explicitly included here for
 * the code relocation of set_sys_dividers() to work correctly even
 * though common.h should pull in cw.h.
 */
#if (defined(CW))
	#include "cw.h"
#endif

// Constants for use in pll_init
#define NO_OSCINIT 0
#define OSCINIT 1

/*
  * The MCG has multiple oscillator input clock sources. Selection is determined by MCG_C7[OSCSEL] bitfield.
  * This is just for FLL input, RTC OSC cannot be used for PLL input, for it's not in valid range
*/
#define IRC_SLOW        0
#define IRC_FAST        1
#define ERC_SLOW        2
#define ERC_FAST        3
#define ERC_FRDIV       4

#define ERC_FAST_FREQ   (8000000)
#define ERC_SLOW_FREQ   (32768)
#define IRC_FAST_FREQ   (4000000)
#define IRC_SLOW_FREQ   (32768)
      
#define CHECK_SLOW_IRC_RANGE(x) ((x > 31250) && (x < 39063))
#define CHECK_FAST_IRC_RANGE(x) ((x > 3000000) && (x < 5000000))
#define CHECK_SLOW_ERC_RANGE(x) ((x > 30000) && (x < 40000))
#define CHECK_FAST_ERC_RANGE(x) ((x > 3000000) && (x < 32000000))

#define OSC_0 0    //system OSC output from EXTAL and XTAL
#define OSC_1 1    //RTC 32kHz OSC output
#define OSC_2 2    //IRC48MHz CLK, from internal 48MHz OSC

#define LOW_POWER 0
#define HIGH_GAIN 1

#define CANNED_OSC  0
#define CRYSTAL 1

#define PLL_0 0
#define EXT_PLL 1	//USB HS PHY PLL

#define PLL_ONLY 0
#define MCGOUT 1

// MCG Mode defines
#define MCG_MODE_UNKNOWN 0
#define MCG_MODE_BLPI 1
#define MCG_MODE_FBI  2
#define MCG_MODE_FEI  3
#define MCG_MODE_FEE  4
#define MCG_MODE_FBE  5
#define MCG_MODE_BLPE 6
#define MCG_MODE_PBE  7
#define MCG_MODE_PEE  8

uint8_t fll_rtc_init(uint8_t, uint8_t);

// prototypes
void rtc_as_refclk(void);
int32_t MCG_FEE_To_FEI(int32_t slow_irc_freq);
int32_t MCG_FEI_To_FBE(int32_t crystal_val, uint8_t hgo_val, uint8_t erefs_val);
int32_t MCG_FBE_To_FEI(int32_t slow_irc_freq);
int32_t MCG_FEI_To_FBI(int32_t irc_freq, int32_t irc_type);
int32_t MCG_FBI_To_FEI(int32_t slow_irc_freq);
int32_t MCG_FBE_To_PBE(int32_t crystal_val);
int32_t MCG_PBE_To_PEE(int32_t crystal_val);
int32_t MCG_PEE_To_PBE(int32_t crystal_val);
int32_t MCG_PBE_To_FBE(int32_t crystal_val);
int32_t MCG_FBE_To_FBI(int32_t irc_freq, int32_t irc_type);
int32_t MCG_FBI_To_FBE(int32_t crystal_val, uint8_t hgo_val, uint8_t erefs_val);
int32_t MCG_FBI_To_FEE(int32_t crystal_val, uint8_t hgo_val, uint8_t erefs_val);
int32_t MCG_FBE_To_FEE(int32_t crystal_val);
int32_t MCG_FEE_To_FBE(int32_t crystal_val);
int32_t MCG_PBE_To_BLPE(int32_t crystal_val);
int32_t MCG_BLPE_To_PBE(int32_t crystal_val);
int32_t MCG_BLPE_To_FBE(int32_t crystal_val);
int32_t MCG_FBI_To_BLPI(int32_t irc_freq, int32_t irc_type);
int32_t MCG_BLPI_To_FBI(int32_t irc_freq, int32_t irc_type);
int32_t MCG_FEI_To_FEE(int32_t crystal_val, uint8_t hgo_val, uint8_t erefs_val);
int32_t MCG_FEE_To_FBI(int32_t irc_freq, int32_t irc_type);
int32_t MCG_FBE_To_BLPE(int32_t crystal_val);

int32_t MCG_GetFllFreq(int32_t fll_ref);
uint8_t MCG_GetCurMode(void);
void MCG_ClkMonitorEnable(uint8_t en_dis);

/********************************************************************/
#endif /* __MCG_H__ */
