/*
 * Comms.h
 *
 *  Created on: Mar 13, 2013
 *      Author: B34981
 */

#ifndef COMMS_H_
#define COMMS_H_

/**********************************************************************************************
* Includes
**********************************************************************************************/
#include "derivative.h"

/**********************************************************************************************
* Constants
**********************************************************************************************/


/**********************************************************************************************
* Macros
**********************************************************************************************/
/* Configurable macros */

#define BAUD_RATE					 	19200
#define LIN_MAX_DATA_BYTES   		 	0x08
#define BOOTLOADER_TRANSMIT_FRAME_ID	0x31
#define BOOTLOADER_RECEIVE_FRAME_ID		0X32


/* communication driver macros */
/* clear all status flag */
#define CLEAR_SCI_STATUS_FLAG		SCI0SR1; \
									SCI0DRL

#define BREAK_DETECT_FLAG			SCI0ASR1_BKDIF

#define DETECTED             1
#define NOT_DETECTED         0
#define LIN_PID_MASK         0x3F
#define LIN_SYNC_FIELD_VALUE 0x55
                
/**********************************************************************************************
* Types
**********************************************************************************************/
typedef struct{
	UINT8 LIN_break_detect;
	UINT8 LIN_sync_field;
	UINT8 LIN_PID;
	UINT8 LIN_data[LIN_MAX_DATA_BYTES];
	UINT8 checksum;
}LIN_FRAME;

/**********************************************************************************************
* Variables
**********************************************************************************************/


/**********************************************************************************************
* Global Variables
**********************************************************************************************/


/**********************************************************************************************
* Global Functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    Comms_Init - Initialize the serial communications driver
* @param    none
* @return   none
*
************************************************************************************************/
void Comms_Init(void);

/***********************************************************************************************
*
* @brief    Comms_Tx_Ack - Reply to received Boot Phrases depending on checksum results
* @param    ACK_OPTS ack: OK or CRC_ERROR
* @return   none
*
************************************************************************************************/  	
void Comms_Tx_Ack(enum ACK_OPTS ack);

/***********************************************************************************************
*
* @brief    Comms_Rx_Data - Poll or Interrupt that receives serial data.
* @param    none
* @return   none (Data must fill the BP structure, when BP is fill, update u8BootPhraseRcvd)
*
************************************************************************************************/ 
void Comms_Rx_Data(void);

/***********************************************************************************************
*
* @brief    Comms_Rx_Data - Poll or Interrupt that receives serial data.
* @param    none
* @return   none (Data must fill the BP structure, when BP is fill, update u8BootPhraseRcvd)
*
************************************************************************************************/ 
unsigned char Comms_Rx_Data_Polling(void);

/***********************************************************************************************
*
* @brief    Comms_Reset_Reg - Reset the modified registers to its defaut values
* @param    none
* @return   none
*
************************************************************************************************/  	
void Comms_Reset_Reg(void);

#endif /* COMMS_H_ */
