/******************************************************************************
*
* (c) Copyright 2009, Freescale & STMicroelectronics
*
***************************************************************************//*!
*
* @file     GMCLIB_ElimDcBusRip.h
*
* @author   B04459, R29302
*
* @version  1.0.8.0
*
* @date     Jan-11-2010
*
* @brief    Header file for #GMCLIB_ElimDcBusRip function.
*
*******************************************************************************
*
* Function implemented as ANSIC ISO/IEC 9899:1990, C90.
*
******************************************************************************/
#ifndef _GMCLIB_ELIMDCBUSRIP_H
#define _GMCLIB_ELIMDCBUSRIP_H

#ifndef  _MATLAB_BAM_CREATE
#include "SWLIBS_Typedefs.h"
#include "SWLIBS_Defines.h"
#include "SWLIBS_Inlines.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif


/******************************************************************************
| Defines and macros            (scope: module-local)
-----------------------------------------------------------------------------*/
/*! Function alias for #GMCLIB_ElimDcBusRipANSIC function.*/
#define GMCLIB_ElimDcBusRip(pOut, pIn, pParams) GMCLIB_ElimDcBusRipANSIC(pOut, pIn, pParams)

/*! Macro containing default values for parameter structure of #GMCLIB_ElimDcBusRip
 * function.*/
#define GMCLIB_ELIMDCBUSRIP_DEFAULT   {0,0}

/******************************************************************************
| Typedefs and structures       (scope: module-local)
-----------------------------------------------------------------------------*/

/*------------------------------------------------------------------------*//*!
@struct GMCLIB_ELIMDCBUSRIP_T "\GMCLIB_ElimDcBusRip.h"

@brief  Structure containing PWM modulation index and measured value of
        DC bus voltage for calculation of DC bus ripple elimination.

*//*-------------------------------------------------------------------------*/

typedef struct
{
    tFrac32 s32ModIndex;    /*!< Inverse Modulation Index, fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$, must be 0 or positive. */
    tFrac32 s32ArgDcBusMsr; /*!< Measured DC bus voltage, fractional format normalized to fit into \f$\left[-2^{31},2^{31}-1\right)\f$, must be 0 or positive. */
} GMCLIB_ELIMDCBUSRIP_T;

/******************************************************************************
| Exported Variables
-----------------------------------------------------------------------------*/

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/
/*!
* @ingroup GMCLIB_GROUP
*/
extern void GMCLIB_ElimDcBusRipANSIC(SWLIBS_2Syst *pOut,
                                     const SWLIBS_2Syst *const pIn,
                                     const GMCLIB_ELIMDCBUSRIP_T *const pParam);

/******************************************************************************
| Inline functions
-----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif /* _GMCLIB_ELIMDCBUSRIP_H */

