/******************************************************************************
*
* (c) Copyright 2009, Freescale & STMicroelectronics
*
***************************************************************************//*!
 *
 * @file     GFLIB_Sign.c
 *
 * @author   B04459, R29302
 * 
 * @version  1.0.13.0
 * 
 * @date     Apr-26-2010
 * 
 * @brief    Function performs calculation the Sign.  
 *                       
 *
 *******************************************************************************
 *
 * Function implemented as ANSIC ISO/IEC 9899:1990, C90. 
 *
 ******************************************************************************/
/*!
@if GFLIB_GROUP
    @addtogroup GFLIB_GROUP
@else
    @defgroup GFLIB_GROUP   GFLIB   
@endif
*/ 

#ifdef __cplusplus
extern "C" {
#endif
    
/******************************************************************************
 * Includes
 ******************************************************************************/
#include "SWLIBS_Typedefs.h"

#include "GFLIB_Sign.h"

/******************************************************************************
 * External declarations
 ******************************************************************************/

/******************************************************************************
 * Defines and macros            (scope: module-local)
 ******************************************************************************/

/******************************************************************************
 * Typedefs and structures       (scope: module-local)
 ******************************************************************************/


/******************************************************************************
 * Global variable definitions   (scope: module-exported)
 ******************************************************************************/

/******************************************************************************
 * Global variable definitions   (scope: module-local)
 ******************************************************************************/

/******************************************************************************
 * Function prototypes           (scope: module-local)
 ******************************************************************************/

/******************************************************************************
 * Function implementations      (scope: module-local)
 ******************************************************************************/

/******************************************************************************
 * Function implementations      (scope: module-exported)
 ******************************************************************************/

/**************************************************************************//*!
@brief     Sign function

@param[in]      s32In       Input signal fraction
  
@return     The GFLIB_Sign function returns the sign of the argument
        
@details    The function GFLIB_Sign calculates the sign of the input argument.
            The function return value is computed as follows. If the the input
            value is negative then the return value will be set to -1
            (0x80000000 hex), if the input value is zero, then the return value
            will be set to 0 (0x0 hex), otherwise, if the input value is
            greater than zero, the return value will be almost 1 (0x7fffffff
            hex).

            In mathematical term the function works according to the
            equation below:

              \f[
               y_{out} =
               \left\{
               \begin{array}{rl}
                   1 & \mbox{if }  x_{in} > 0 \\
                   0 & \mbox{if }  x_{in} = 0 \\
                   -1 & \mbox{if } x_{in} < 0 \\ 
                                 \end{array}
                                 \right.
              \f]                     

            where:
            - \f$y_{out}\f$ is the return value
            - \f$x_{in}\f$ is the input value provided as \c s32In parameter

@par Reentrancy:
            The function is reentrant.

@par Code Example:
\code
#include "gflib.h"

tFrac32 s32In;
tFrac32 s32Out;

void main(void)
{
    // input value = 0.5
    // output should be 0x7FFFFFFF
    s32In  = FRAC32(0.5);
    s32Out = GFLIB_Sign(s32In);
    
    // input value = 0.0
    // output should be 0x00000000
    s32In  = FRAC32(0.0);
    s32Out = GFLIB_Sign(s32In);
    
    // input value = -0.5
    // output should be 0x80000000
    s32In  = FRAC32(-0.5);
    s32Out = GFLIB_Sign(s32In);

    return;
}
\endcode

@par Performance:
            \anchor tab1_GFLIB_Sign
            <table border="1" CELLPADDING="5" align = "center">
            <caption>#GFLIB_Sign function performance</caption>
            <tr>
              <th>Code size [bytes] GHS/CW</th> <td>16/16</td>
            </tr>
            <tr>
              <th>Data size [bytes] GHS/CW</th> <td>0/0</td>
            </tr>
            <tr>
              <th>Execution clock cycles max [clk] GHS/CW</th> <td>17/14</td>
            </tr>
            <tr>
              <th>Execution clock cycles min [clk] GHS/CW</th> <td>16/12</td>
            </tr>
            </table>

******************************************************************************/

tFrac32 GFLIB_SignANSIC(tFrac32 s32In)
{
    return ((s32In < 0) ? INT32_MIN : ((s32In == 0) ? 0 : INT32_MAX));
}

#ifdef __cplusplus
}
#endif

/* End of file */
