/******************************************************************************
*
* (c) Copyright 2009, Freescale & STMicroelectronics
*
***************************************************************************//*!
*
* @file      GFLIB_LowerLimit.c
*
* @author    R29302
* 
* @version   1.0.12.0
* 
* @date      Apr-26-2010
* 
* @brief     Source file for the lower limit function.
*
********************************************************************************
*
* Function implemented as ANSIC ISO/IEC 9899:1990, C90.
*
 ******************************************************************************/
/*!
@if GFLIB_GROUP
	@addtogroup GFLIB_GROUP
@else
	@defgroup GFLIB_GROUP	GFLIB	
@endif
*/ 

#include "SWLIBS_Typedefs.h"
#include "GFLIB_LowerLimit.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
| external declarations
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| defines and macros (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| typedefs and structures (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| global variable definitions (scope: module-exported)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| global variable definitions (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function prototypes (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementations (scope: module-local)
|-----------------------------------------------------------------------------*/

/*******************************************************************************
| function implementations (scope: module-exported)
|-----------------------------------------------------------------------------*/

/***************************************************************************//*!
@brief       The function limits the input value by the defined lower limit.

@param[in]   s32In   Input value.
@param[in]   pParam  Pointer to the limits structure.
  
@return      The input value or the lower limit if the input value is
             lower than the lower limit.
        
@details     The function tests whether the input value is above the lower
             limit. If so the input value will be returned.  Otherwise, if the
             input value is below the lower limit, the lower limit will be
             returned.

             The lower limit can be found in the limits structure, supplied to
             the function as a pointer \c pParam.

@par Reentrancy:
            The function is reentrant.

@par Code Example:
\code
#include "gflib.h"

tFrac32 x;
tFrac32 y;
GFLIB_LOWERLIMIT_T LowerLimitParam;

void main(void)
{
    // 0.5 = 0x40000000
    LowerLimitParam.s32LowerLimit = FRAC32(0.5);

    // x = 0.75 = 0x60000000
    x  = FRAC32(0.75);
    // y should be 0x60000000
    y = GFLIB_LowerLimit(x, &LowerLimitParam);

    // x = -0.75 = 0xa0000000
    x  = FRAC32(-0.75);
    // y should be 0x40000000
    y = GFLIB_LowerLimit(x, &LowerLimitParam);

    // x = 0.25 = 0x20000000
    x  = FRAC32(0.25);
    // y should be 0x40000000
    y = GFLIB_LowerLimit(x, &LowerLimitParam);

    return;
}
\endcode

@par Performance:
            \anchor tab1_GFLIB_LowerLimit
            <table border="1" CELLPADDING="5" align = "center">
            <caption>#GFLIB_LowerLimit function performance</caption>
            <tr>
              <th>Code size [bytes] GHS/CW</th> <td>14/10</td>
            </tr>
            <tr>
              <th>Data size [bytes] GHS/CW</th> <td>0/0</td>
            </tr>
            <tr>
              <th>Execution clock cycles max [clk] GHS/CW</th> <td>17/16</td>
            </tr>
            <tr>
              <th>Execution clock cycles min [clk] GHS/CW</th> <td>16/12</td>
            </tr>
            </table>
******************************************************************************/

tFrac32 GFLIB_LowerLimitANSIC (tFrac32 s32In,
                               const GFLIB_LOWERLIMIT_T *const pParam)
{       	
    s32In = (s32In < pParam->s32LowerLimit) ? pParam->s32LowerLimit : s32In; 

    return s32In;
}

#ifdef __cplusplus
}
#endif

/* End of file */
