/******************************************************************************
*
* (c) Copyright 2009, Freescale & STMicroelectronics
*
***************************************************************************//*!
*
* @file     GDFLIB_FilterIIR1.h
*
* @author   Roman Filka
*
* @version  1.0.5.0
*
* @date     Feb-9-2010
*
* @brief    Header file for #GDFLIB_FilterIIR1 function.
*
*******************************************************************************
*
* Function implemented as ANSIC ISO/IEC 9899:1990, C90. 
*
******************************************************************************/
#ifndef _GDFLIB_FILTER_IIR1_H
#define _GDFLIB_FILTER_IIR1_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef  _MATLAB_BAM_CREATE    
#include "SWLIBS_Typedefs.h"
#include "SWLIBS_Inlines.h"
#include "SWLIBS_Defines.h"
#endif
     
/******************************************************************************
| Defines and macros            (scope: module-local)
-----------------------------------------------------------------------------*/
/*! Function alias for #GDFLIB_FilterIIR1InitANSIC function.*/
#define GDFLIB_FilterIIR1Init(pParam) \
    GDFLIB_FilterIIR1InitANSIC(pParam)

#define GDFLIB_Filter16IIR1Init(pParam) \
    GDFLIB_Filter16IIR1InitANSIC(pParam)
    
/*! Function alias for #GDFLIB_FilterIIR1ANSIC function.*/
#define GDFLIB_FilterIIR1(s32In,pParam)\
        GDFLIB_FilterIIR1ANSIC(s32In,pParam)

#define GDFLIB_Filter16IIR1(s16In,pParam)\
        GDFLIB_Filter16IIR1ANSIC(s16In,pParam)
        
/*! Macro containing default values of first order IIR filter structure.*/
#define GDFLIB_FILTER_IIR1_DEFAULT   {{0,0,0},{0},{0}}

/******************************************************************************
| Typedefs and structures       (scope: module-local)
-----------------------------------------------------------------------------*/
/*------------------------------------------------------------------------*//*!
@struct FILTER_IIR1_COEFF_T "\GDFLIB_FilterIIR1.h"

@brief  Sub-structure containing filter coefficients.
*//*-------------------------------------------------------------------------*/
typedef struct
{
    tFrac32 s32B0;  /*!< b0 coefficient of IIR1 filter 32bit */
    tFrac32 s32B1;  /*!< b1 coefficient of IIR1 filter 32bit */
    tFrac32 s32A1;  /*!< a1 coefficient of IIR1 filter 32bit*/
}FILTER_IIR1_COEFF_T;

typedef struct
{
    tFrac16 s16B0;  /*!< b0 coefficient of IIR1 filter 16bit */
    tFrac16 s16B1;  /*!< b1 coefficient of IIR1 filter 16bit */
    tFrac16 s16A1;  /*!< a1 coefficient of IIR1 filter 16bit*/
}FILTER_IIR1_16_COEFF_T;

/*------------------------------------------------------------------------*//*!
@struct GDFLIB_FILTER_IIR1_T "\GDFLIB_FilterIIR1.h"

@brief  Structure containing filter buffer and coefficients.
*//*-------------------------------------------------------------------------*/
typedef struct
{
    FILTER_IIR1_COEFF_T trFiltCoeff; /*!< filter coefficients substructure */
    tFrac32 s32FiltBufferX[2];  /*!< input buffer of IIR1 filter */
    tFrac32 s32FiltBufferY[2];  /*!< internal accumulator buffer */
}GDFLIB_FILTER_IIR1_T;

typedef struct
{
    FILTER_IIR1_16_COEFF_T trFiltCoeff; /*!< filter coefficients substructure */
    tFrac16 s16FiltBufferX[2];  /*!< input buffer of IIR1 filter */
    tFrac32 s32FiltBufferY[2];  /*!< internal accumulator buffer */
}GDFLIB_FILTER_IIR1_16_T;

/******************************************************************************
| Exported Variables
-----------------------------------------------------------------------------*/

/******************************************************************************
| Exported function prototypes
-----------------------------------------------------------------------------*/
// Prototype of function for clearing buffers of IIR1 filter.
extern void GDFLIB_FilterIIR1InitANSIC(GDFLIB_FILTER_IIR1_T *pParam);

// Prototype of direct form II first order IIR filter.
extern tFrac32 GDFLIB_FilterIIR1ANSIC(tFrac32 s32InErr, \
                                      GDFLIB_FILTER_IIR1_T *pParam);

// Prototype of function for clearing buffers of IIR1 filter.
extern void GDFLIB_Filter16IIR1InitANSIC(GDFLIB_FILTER_IIR1_16_T *pParam);

// Prototype of direct form II first order IIR filter.
extern tFrac16 GDFLIB_Filter16IIR1ANSIC(tFrac16 s16In, \
                                      GDFLIB_FILTER_IIR1_16_T *pParam);
                                      
/******************************************************************************
| Inline functions
-----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif

#endif /* _GDFLIB_FILTER_IIR1_H */

