/*
 * vIIC.c
 *
 *  Created on: Dec 16, 2015
 *      Author: B55840
 */

#include "vIIC.h"

/* Private Function Pretotypes */
void send_byte(unsigned char byte);
unsigned char read_byte(void);
unsigned char ACK();
void NACK();
void vIIC_start_bit();
unsigned char vIIC_stop_bit();

/* Main Functions */

void vIIC_init(void){
	TIM_init();
	SDA_OUTPUT(vIIC_PORT,SDA_PIN); // PS1 as output (SDA)
	SCL_OUTPUT(vIIC_PORT,SCL_PIN); // PS2 as output (SCL)
	WRITE_PIN(vIIC_PORT,SDA_PIN,1);
	WRITE_PIN(vIIC_PORT,SCL_PIN,1);
}

void vIIC_write_byte(unsigned char device_address, unsigned char device_register, unsigned char data){
	vIIC_start_bit();
	send_byte((device_address<<1)&0xFE); // 7bit adress and write bit
	delay_us(10);
	ACK();
	send_byte(device_register);
	delay_us(10);
	ACK();
	send_byte(data);
	delay_us(10);
	ACK();
	vIIC_stop_bit();
}

unsigned char vIIC_read_byte(unsigned char device_address,unsigned char device_register){
	unsigned char data=0;
	vIIC_start_bit();
	send_byte((device_address<<1)&0xFE);
	ACK();
	send_byte(device_register);
	ACK();
	vIIC_start_bit();
	send_byte((device_address<<1)|0x01);
	ACK();
	data = read_byte();
	NACK();
	vIIC_stop_bit();
	return data;
}


/* Private functions */

void vIIC_start_bit(){
	WRITE_PIN(vIIC_PORT,SDA_PIN,1);
	WRITE_PIN(vIIC_PORT,SCL_PIN,1);
	delay_us(2);
	WRITE_PIN(vIIC_PORT,SDA_PIN,0);
	delay_us(2);
	WRITE_PIN(vIIC_PORT,SCL_PIN,0);
}

void send_byte(unsigned char byte){
	unsigned char i = 0;
	unsigned char temp = 0;
	for(i = 8;i>0;i--){
		temp = byte >> (i-1);
		WRITE_PIN(vIIC_PORT,SDA_PIN,temp&0x01);
		delay_us(1);
		WRITE_PIN(vIIC_PORT,SCL_PIN,1);
		delay_us(2);
		WRITE_PIN(vIIC_PORT,SCL_PIN,0);
		delay_us(2);
	}
	WRITE_PIN(vIIC_PORT,SCL_PIN,0);
}

unsigned char read_byte(){
	unsigned char i =0;
	unsigned char data=0;
	unsigned char temp=0;
	SDA_INPUT(vIIC_PORT,SDA_PIN);
	for(i=0;i<8;i++){
		WRITE_PIN(vIIC_PORT,SCL_PIN,1);
		delay_us(2);
		data = data<<1;
		if(READ_PIN(vIIC_PORT,SDA_PIN)) data |=1;
		else data|=0;
		delay_us(1);
		WRITE_PIN(vIIC_PORT,SCL_PIN,0);
		delay_us(2);
	}
	SDA_OUTPUT(vIIC_PORT,SDA_PIN);
	return data;
}

unsigned char ACK(){
	unsigned char temp; // saves ack if received
	SDA_INPUT(vIIC_PORT,SDA_PIN);
	delay_us(2);
	WRITE_PIN(vIIC_PORT,SCL_PIN,1);
	delay_us(2);
	temp = READ_PIN(vIIC_PORT,SDA_PIN);
	delay_us(2);
	SDA_OUTPUT(vIIC_PORT,SDA_PIN);
	WRITE_PIN(vIIC_PORT,SDA_PIN,0); //idle state
	WRITE_PIN(vIIC_PORT,SCL_PIN,0);
	delay_us(2);
	return temp;
}

void NACK(){
	WRITE_PIN(vIIC_PORT,SDA_PIN,1);
	delay_us(2);
	WRITE_PIN(vIIC_PORT,SCL_PIN,1);
	delay_us(2);
	WRITE_PIN(vIIC_PORT,SCL_PIN,0);
	delay_us(2);
}

unsigned char vIIC_stop_bit(){
	delay_us(2);
	WRITE_PIN(vIIC_PORT,SCL_PIN,1);
	delay_us(2);
	WRITE_PIN(vIIC_PORT,SDA_PIN,1);
	delay_us(2);
}
