#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "vIIC.h"
#include "TIM.h"
unsigned char data;

void busclk_init() {						

	/********************************************/
	/************ PLL INITIALIZATION ************/
	/********************************************/
	CPMUCLKS_PLLSEL = 1;			// FBUS = FPLL/2.   FBUS = 32MHz, 
	CPMUREFDIV_REFFRQ = 1;			// Reference clock between 2MHZ and 6MHZ.	
	CPMUREFDIV_REFDIV = 0x1;		// FREF=4/(1+1) = 2MHZ		
	CPMUSYNR_VCOFRQ = 0x00;         // FVCO is between 32MHZ and 48MHZ	
	CPMUSYNR_SYNDIV = 0x7;			// FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x2x(7+1) = 32MHZ
	CPMUPOSTDIV_POSTDIV = 0x0;		// FPLL = FVCO/(POSTDIV+1).  FPLL = 32MHZ/(0+1)    FPLL = 32MHz	
	CPMUOSC_OSCE = 1;				// External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)		
	while(!CPMUIFLG_LOCK){}			// Wait for LOCK.      	
	CPMUIFLG = 0xFF;				// clear CMPMU flags

	ECLKCTL_NECLK = 0;				// BUSCLock by PS3 enabled	
}

void main(void) {
	busclk_init();
	PERS_PERS1 = 0; // PS1 set as open drain
	PERS_PERS2 = 0; // PS2 set as open drain
	PERT_PERT4 = 0; // PS1 set as open drain
	PERT_PERT5 = 0; // PS2 set as open drain
	vIIC_init();
	EnableInterrupts;
	/* include your code here */



	for(;;) {
		__RESET_WATCHDOG();	/* feeds the dog */
		//vIIC_write_byte(0x68,0x01,0x25);
		//delay_us(500);
		data = vIIC_read_byte(0x68,0x75);
		delay_us(1000);
	} /* loop forever */
	/* please make sure that you never leave main */

}
