/*
 * vIIC.h
 *
 *  Created on: Dec 16, 2015
 *      Author: B55840
 */

#include "derivative.h"
#include "TIM.h"


#ifndef VIIC_H_
#define VIIC_H_

/* CONFIG ME IF NECESSARY */
#define vIIC_PORT T
#define SDA_PIN 4
#define SCL_PIN 5


/* Macro definition */
#define SDA_INPUT_EXPANDED(port,pin)		DDR##port##_DDR##port##pin = 0;
#define SDA_OUTPUT_EXPANDED(port,pin) 	DDR##port##_DDR##port##pin = 1;
#define SCL_OUTPUT_EXPANDED(port,pin) 	DDR##port##_DDR##port##pin = 1;
#define SDA_INPUT(port,pin)		SDA_INPUT_EXPANDED(port,pin)
#define SDA_OUTPUT(port,pin)	SDA_OUTPUT_EXPANDED(port,pin)
#define SCL_OUTPUT(port,pin)	SCL_OUTPUT_EXPANDED(port,pin)
#define WRITE_PIN_EXPANDED(port,pin,value)	PT##port##_PT##port##pin = value
#define WRITE_PIN(port,pin,value) WRITE_PIN_EXPANDED(port,pin,value)
#define READ_PIN_EXPANDED(port,pin)	PT##port##_PT##port##pin
#define READ_PIN(port,pin)	READ_PIN_EXPANDED(port,pin)

/* IIC FUNCTIONS */
void vIIC_init(void);
void vIIC_write_byte(unsigned char device_address, unsigned char device_register, unsigned char data);
unsigned char vIIC_read_byte(unsigned char device_address,unsigned char device_register);


#endif /* VIIC_H_ */
