/*****************************************************************************/
/*                                                                           */
/*   FILE NAME     :  irq_init_core1.c                                       */
/*   DESCRIPTION   :  Example source for initializing the core 1 interrupts  */
/*   DATE          :  July 31, 2013                                          */
/*                                                                           */
/*****************************************************************************/

#include "../headers/project.h"
extern const uint32_t IntcIsrVectorTable[];

/*****************************************************************************/
/*            Function: Irq_Init_Core1                                       */
/*            This function intializes the INTC for core 1                   */
/*****************************************************************************/
void Irq_Init_Core1(void) {
    volatile int temp;

    /* Choose software (HVEN=0) or hardware (HVEN=1) vector mode */
    INTC_0.BCR.R &= 0xFFFFFFEF;

    /* Read IACKR before enabling interrupts */
    temp = INTC_0.IACKR1.R;
    
    /* Set INTC ISR vector table base addr. */
    INTC_0.IACKR1.R = (uint32_t) &IntcIsrVectorTable[0]; 

    /* only core 1 can write PSR registers */
    INTC_0.PSR[229].R = 0x4002; // IRQ229(PIT0 CH3)irq goes to core 1, priority 2
    INTC_0.PSR[228].R = 0x8001; // IRQ228(PIT0 CH2)irq goes to core 0, priority 1

    /* eTPU function interrupts
       priority hast values 64 down to 0
    */

    
    ///////////////////////////////IRQ num	function name		selected core	priority
    ///////////////////////////////-------------------------------------------------------------
    INTC_0.PSR[739].R = 0x4001; // IRQ739	etpu_cam_isr		1,		1
    INTC_0.PSR[741].R = 0x4001; // IRQ741	etpu_crank_isr		1,		1
    INTC_0.PSR[742].R = 0x4001; // IRQ742	etpu_tg_isr		1,		1
    INTC_0.PSR[743].R = 0x4001; // IRQ743	etpu_spark_1_isr	1,		1
    INTC_0.PSR[744].R = 0x4001; // IRQ744	etpu_spark_2_isr	1,		1
    INTC_0.PSR[745].R = 0x4001; // IRQ745	etpu_spark_3_isr	1,		1
    INTC_0.PSR[746].R = 0x4001; // IRQ746	etpu_spark_4_isr	1,		1
    INTC_0.PSR[747].R = 0x4001; // IRQ747	etpu_fuel_1_isr		1,		1
    INTC_0.PSR[748].R = 0x4001; // IRQ748	etpu_fuel_2_isr		1,		1
    INTC_0.PSR[749].R = 0x4001; // IRQ749	etpu_fuel_3_isr		1,		1
    INTC_0.PSR[750].R = 0x4001; // IRQ750	etpu_fuel_4_isr		1,		1
    INTC_0.PSR[751].R = 0x4001; // IRQ751	etpu_knock_1_isr	1,		1
    INTC_0.PSR[752].R = 0x4001; // IRQ752	etpu_knock_2_isr	1,		1
    INTC_0.PSR[755].R = 0x4001; // IRQ755	etpu_inj_1_isr		1,		1
    INTC_0.PSR[756].R = 0x4001; // IRQ756	etpu_inj_2_isr		1,		1
    
    /* Ensure INTC's current priority is 0 */
    INTC_0.CPR1.B.PRI = 0;
    
    /* Enable external interrupts */
    asm(" wrteei 1");
}

