/*************************************************************************************************/
/*                                                                                               */
/*            FSL Sample Software for Rainier                                                    */
/*                                                                                               */
/* FILE NAME     :  mcu_init.c                                                                   */
/* DESCRIPTION   :  Freescale sample source for Rainier Mode and Clock tree configuration        */
/* DATE          :  April 18, 2013                                                               */
/* AUTHOR        :                                                                               */
/*                                                                                               */
/*************************************************************************************************/

#include "../headers/project.h"
extern const uint32_t IntcIsrVectorTable[];

/*************************************************************************************************/
/*************************************************************************************************/
/****         Function: InitINTC                                                              ****/
/****         Content:  This function intializes the INTC for software vector                 ****/
/****                                                                                         ****/
/****         Argument: void                                                                  ****/
/****         Return value: void                                                              ****/
/*************************************************************************************************/
/*************************************************************************************************/
void InitINTC_core0(void) {
    volatile int temp;

    /* Read IACKR before enabling interrupts */
    temp = INTC_0.IACKR0.R;
    
    /* Set INTC ISR vector table base addr. */
    INTC_0.IACKR0.R = (uint32_t) &IntcIsrVectorTable[0]; 

}
