#/****************************************************************************/
#/*                                                                          */
#/* FILE NAME     :  ivor4_handler_core0.s                                   */
#/* DESCRIPTION   :  This file creates prolog, epilog for C ISR and enables  */
#/*                  nested interrupts.                                      */
#/* DATE          :  Apr 23, 2004                                            */
#/* AUTHOR        :  S. Mihalik                                              */
#/*                                                                          */
#/****************************************************************************/

#/****************************************************************************/
#/* 0.1.0:  2004.04.23  S. Mihalik    Initial version                        */
#/* 0.1.1:  2004.07.29  B. Terry      Modified read of IACKR using           */
#/*                                   pointer to determine vector  address   */
#/* 0.1.2   2004.07.30  G. Jackson    Added ".xcptn" section designation     */
#/*                                   for placement into mpc5500cfg.         */
#/* 0.1.3   2004.10.12  G. Jackson    Green Hills now does not require       */
#/*                                   quotation marks around the section     */
#/*                                   Added syntax to generate symbols for   */
#/*                                   debug.                                 */
#/* 0.1.4   2004.10.18  G. Jackson    Epilogue move of restoration for r3,   */
#/*                                   and r4 until after INTC_EOIR.          */
#/* 0.1.5   2006.07.19  C. Baker      Added comments                         */
#/* 0.1.6   2007.02.23  R. Moran      Modified instructions to VLE           */
#/* 0.1.7   2008.12.10  R. Moran      Update formatting                      */
#/* 0.1.8   2012.08.31  J. Circello   Incorporated new {l,st}m volatile regs */
#/* 0.1.9   2013.04.23  J. Circello   Removed mbar, reordered prolog insts   */
#/****************************************************************************/

 # Indent one space to prevent GCC warning
 # STACK FRAME DESIGN: Depth: 20 words (0x50, or 80 bytes)
 #            ************* 
 #   0x2C-50  *  GPR4-12  *
 #   0x28     *  GPR3     * 
 #   0x24     *  GPR0     * 
 #   0x20     *  XER      * 
 #   0x1C     *  CTR      * 
 #   0x18     *  LR       *  
 #   0x14     *  CR       * 
 #   0x10     *  SRR1     *  
 #   0x0C     *  SRR0     * 
 #   0x08     *  origGPR3 * 
 #   0x04     *  padding  * 
 #   0x00     *  SP       * 
 #            ************* 
 
    .global      IVOR4_Handler_core0
    .global      end_of_handler_c0

    .section    .vletext, vax
    .vle

    # On Dual Core these registers are treated as Processor 0
    .equ  INTC_IACKR, 0xfc040020        # Interrupt Acknowledge Register address
    .equ  INTC_EOIR,  0xfc040030        # End Of Interrupt Register address

    .align  4                       
IVOR4_Handler_core0:                     
prolog:                                 # PROLOGUE 
    e_stwu      r1,-0x50 (r1)           # Create stack frame and store back chain
    e_stmvsrrw      0x0c (r1)           # Save SRR[0-1] (must be done before enabling MSR[EE])
    e_stw       r3, 0x08 (r1)           # Save working register (r3)
    e_lis       r3, INTC_IACKR@ha       # Save address  of IACKR in r3
    e_lwz       r3, INTC_IACKR@l(r3)    # Save contents of IACKR in r3 (this is vector table address)
    wrteei      1                       # Set MSR[EE] (must wait a couple clocks after reading IACKR)
    e_lwz       r3, 0x0(r3)             # Read ISR address from Interrupt Vector Table using pointer
                                   
    e_stmvsprw      0x14 (r1)           # Save CR, LR, CTR, XER
    mtLR        r3                      # Copy ISR address (from IACKR) to LR for next branch
    e_stmvgprw      0x24 (r1)           # Save GPRs, r[0,3-12]
    se_blrl                             # Branch to ISR, with return to next instruction (EPILOG)

epilog:                                 # EPILOGUE - STEP 6: RESTORE CONTEXT
    e_lmvsprw       0x14 (r1)           # Restore CR, LR, CTR, XER
    e_lmvgprw       0x24 (r1)           # Restore GPRs, r[0,3-12]
    e_lis       r3, INTC_EOIR@ha        # Load upper half of EIOR address to r3
    wrteei      0                       # Disable interrupts
    e_stw       r3, INTC_EOIR@l(r3)     # Load lower half of EIOR address to r3 and
                                        #   write contents of r3 to INTC_EOIR, address 0xFFF4_8018
    e_lwz       r3, 0x08 (r1)           # Restore working register (r3) (original value)
    e_lmvsrrw       0x0c (r1)           # Restore SRR[0-1]
    e_add16i    r1, r1, 0x50            # Reclaim stack space
    se_rfi                              # End of Interrupt Handler - re-enables interrupts
#/* this lable is for calculating handler size */
end_of_handler_c0:
    
