/**************************************************************************
 * FILE NAME: MPC5746R.h                     COPYRIGHT (c) Freescale 2013 *
 * REVISION:  0.2j                                    All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the MPC5746R.                                                          *
 *========================================================================*
 * NOTE: Any release number followed by a lower case alpha character      *
 * indicates a hand edit between automated releases. Automated releases   *
 * are indicated by incrementing the numeric portion of the revision.     *
 *                                                                        * 
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE        DESCRIPTION OF CHANGE                 *
 * ---   -----------  ---------     ---------------------                 *
 * 0.1      M.D.      27-FEB-13     -First release.                       *
 *                                                                        *
 * 0.2      M.D.      01-MAR-13     -PASS module PG.LOCK3 changed bit     *
 *                                   256LCK_U to L256LCK_U                *
 *                                  -SIUL2 module MSCR changed to array   *
 *                                   MSCR0_255[256] & MSCR512_955[484]    *
 *                                  -eTPU_CCCR module ENG1_C needed ';'   *
 *                                  -Memory definitions for SMPU added '_'*
 *                                                                        *
 * 0.2a     B.T.      07-MAR-13     -PASS module, changed missed 256LCK_U *
 *                                   symbol to L256LCK_U.                 *
 *                                                                        *
 * 0.2b     B.T.      14-MAR-13     -Corrected REACM2 mapping due to RM   *
 *                                   memory map offset errors.            *
 *                                  -Corrected base address for ADC_2     *
 *                                   and ADC_3.                           *
 *                                  -Modified MC_CGM_tag to fix incorrect *
 *                                   register offsets (from RM).          *
 *                                                                        * 
 * 0.2c     B.T.      05-APR-13     -Removed trailing 'n' from all eMIOS  *
 *                                   channel registers.                   *
 *                                                                        *
 * 0.2d     B.T.      23-MAY-13     -corrected base address of SAR_ADC0   *
 *                                  -removed non-implemented SDADC blocks *
 *                                   SDADC3,4,5,6,7,8,9                   *   
 * 0.2e     B.T.      30-MAY-13     -corrected EMIOS UC_n channel address *
 *                                   offsets.                             *   
 * 0.2f     B.T.      31-MAY-13     -Added missing XBIC tag and defines   *
 *                                   for XBIC_0, XBIC_1.                  *
 *                                  -Removed MC_RGM_FBRE[BE_ESR1] bit,    * 
 *                                   marked bit location as reserved.     *
 *                                  -Removed MC_RGM_FESS[SS_ESR1] bit,    * 
 *                                   marked bit location as reserved.     *   
 * 0.2g     B.T.      14-JUN-13     -Fixed incorrect bit assignments in   * 
 *                                   MC_RGM_DES register as per TKT183624.*   
 *                                  -Removed CTAR0_SLAVE, CTAR1_SLAVE,    * 
 *                                   and PUSHR_SLAVE registers from DSPI  *
 *                                   tag as per TKT182463.                *
 *                                  -Modified FCCU, NCF_CFG, NCF_STATUS,  *
 *                                   NCF_ENABLE, NCF_TOE, IRQ_ALARM_EN,   *
 *                                   NMI_EN, EOUT_SIG_EN, and NCFS_CFG    *
 *                                   registers as per TKT183605.          *
 * 0.2h     B.T./K.I. 09-JUL-13     -corrected eTPU address issues as per *
 *                                   TKT185174.                           *
 *                                  -corrected SEMA42 RSTGT read/write    *
 *                                   address issue as per TKT184603       *
 * 0.2i     B.T.      06-AUG-13     -removed SAR ADC CWSELR5 register as  *
 *                                   per TKT192309.                       *
 * 0.2j     B.T.      28-AUG-13     -corrected CAN_0 base address as per  *
 *                                   TKT193800.                           *
 *                                  -Added missing SIUL.GPRn registers as *
 *                                   RM version 3.                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/

/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MPC5746R_H_
#define _MPC5746R_H_
#include "typedefs.h"
#ifdef  __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

struct ADC_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t OWREN:1;					 /* Overwrite enable. */
        vuint32_t WLSIDE:1;					 /* Write Left/Right aligned. */
        vuint32_t MODE:1;					 /* One_Shot/Scan. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t TRGEN:1;					 /* External trigger enable. */
        vuint32_t EDGE:1;					 /* Start trigger edge detection. */
        vuint32_t XSTRTEN:1;					 /* External Start enable. */
        vuint32_t NSTART:1;					 /* Start conversion. */
        vuint32_t  :1;					 /*  */
        vuint32_t JTRGEN:1;					 /* Injection external trigger enable. */
        vuint32_t JEDGE:1;					 /* Injection trigger edge selection. */
        vuint32_t JSTART:1;					 /* Injection start. */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t CTUEN:1;					 /* Crosstrigger Unit Enable. */
        vuint32_t CTU_MODE:1;					 /* Crosstrigger Unit MODE bit */
        vuint32_t STCL:1;					 /* Self Testing Configuration Lock. */
        vuint32_t  :6;					 /*  */
        vuint32_t ADCLKSEL:1;					 /* Analog Clock frequency Selector. */
        vuint32_t ABORT_CHAIN:1;					 /* Abort Chain. */
        vuint32_t ABORT:1;					 /* Abort Conversion. */
        vuint32_t ACKO:1;					 /* Auto clock off enable. */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t REFSEL:2;					 /* Reference voltage selection for ADC analog part. */
        vuint32_t PWDN:1;					 /* Power down enable. */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t CALIBRTD:1;					 /* This bit indicates the ADC calibration status. */
        vuint32_t  :6;					 /*  */
        vuint32_t NSTART:1;					 /* This status bit is used to signal that a Normal conversion is ongoing. */
        vuint32_t JABORT:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t JSTART:1;					 /* This status bit is used to signal that an Injected conversion is ongoing. */
        vuint32_t  :1;					 /*  */
        vuint32_t SELF_TEST_S:1;					 /* This status bit signals that self test conversion is ongoing. */
        vuint32_t  :1;					 /*  */
        vuint32_t CTUSTART:1;					 /* This status bit is used to signal that a CTU conversion is ongoing. */
        vuint32_t CHADDR:7;					 /* Channel under measure address. */
        vuint32_t  :3;					 /*  */
        vuint32_t ACKO:1;					 /* Auto clock off enable. */
        vuint32_t  :2;					 /*  */
        vuint32_t ADCSTATUS:3;					 /* Status of the ADC. */
    } B;
  } MSR;

  uint8_t ADC_reserved0[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :27;					 /*  */
        vuint32_t EOCTU:1;					 /* End of CTU conversion. */
        vuint32_t JEOC:1;					 /* End of injected channel conversion. */
        vuint32_t JECH:1;					 /* End of injected chain conversion. */
        vuint32_t EOC:1;					 /* End of channel conversion. */
        vuint32_t ECH:1;					 /* End of chain conversion. */
    } B;
  } ISR;

  union {
    vuint32_t R;
      struct {
        vuint32_t EOCCH31:1;					 /* EOC Channel 31. */
        vuint32_t EOCCH30:1;					 /* EOC Channel 30. */
        vuint32_t EOCCH29:1;					 /* EOC Channel 29. */
        vuint32_t EOCCH28:1;					 /* EOC Channel 28. */
        vuint32_t EOCCH27:1;					 /* EOC Channel 27. */
        vuint32_t EOCCH26:1;					 /* EOC Channel 26. */
        vuint32_t EOCCH25:1;					 /* EOC Channel 25. */
        vuint32_t EOCCH24:1;					 /* EOC Channel 24. */
        vuint32_t EOCCH23:1;					 /* EOC Channel 23. */
        vuint32_t EOCCH22:1;					 /* EOC Channel 22. */
        vuint32_t EOCCH21:1;					 /* EOC Channel 21. */
        vuint32_t EOCCH20:1;					 /* EOC Channel 20. */
        vuint32_t EOCCH19:1;					 /* EOC Channel 19. */
        vuint32_t EOCCH18:1;					 /* EOC Channel 18. */
        vuint32_t EOCCH17:1;					 /* EOC Channel 17. */
        vuint32_t EOCCH16:1;					 /* EOC Channel 16. */
        vuint32_t EOCCH15:1;					 /* EOC Channel 15. */
        vuint32_t EOCCH14:1;					 /* EOC Channel 14. */
        vuint32_t EOCCH13:1;					 /* EOC Channel 13. */
        vuint32_t EOCCH12:1;					 /* EOC Channel 12. */
        vuint32_t EOCCH11:1;					 /* EOC Channel 11. */
        vuint32_t EOCCH10:1;					 /* EOC Channel 10. */
        vuint32_t EOCCH9:1;					 /* EOC Channel 9. */
        vuint32_t EOCCH8:1;					 /* EOC Channel 8. */
        vuint32_t EOCCH7:1;					 /* EOC Channel 7. */
        vuint32_t EOCCH6:1;					 /* EOC Channel 6. */
        vuint32_t EOCCH5:1;					 /* EOC Channel 5. */
        vuint32_t EOCCH4:1;					 /* EOC Channel 4. */
        vuint32_t EOCCH3:1;					 /* EOC Channel 3. */
        vuint32_t EOCCH2:1;					 /* EOC Channel 2. */
        vuint32_t EOCCH1:1;					 /* EOC Channel 1. */
        vuint32_t EOCCH0:1;					 /* EOC Channel 0. */
    } B;
  } CEOCFR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t EOCCH63:1;					 /* EOC Channel 63. */
        vuint32_t EOCCH62:1;					 /* EOC Channel 62. */
        vuint32_t EOCCH61:1;					 /* EOC Channel 61. */
        vuint32_t EOCCH60:1;					 /* EOC Channel 60. */
        vuint32_t EOCCH59:1;					 /* EOC Channel 59. */
        vuint32_t EOCCH58:1;					 /* EOC Channel 58. */
        vuint32_t EOCCH57:1;					 /* EOC Channel 57. */
        vuint32_t EOCCH56:1;					 /* EOC Channel 56. */
        vuint32_t EOCCH55:1;					 /* EOC Channel 55. */
        vuint32_t EOCCH54:1;					 /* EOC Channel 54. */
        vuint32_t EOCCH53:1;					 /* EOC Channel 53. */
        vuint32_t EOCCH52:1;					 /* EOC Channel 52. */
        vuint32_t EOCCH51:1;					 /* EOC Channel 51. */
        vuint32_t EOCCH50:1;					 /* EOC Channel 50. */
        vuint32_t EOCCH49:1;					 /* EOC Channel 49. */
        vuint32_t EOCCH48:1;					 /* EOC Channel 48. */
        vuint32_t EOCCH47:1;					 /* EOC Channel 47. */
        vuint32_t EOCCH46:1;					 /* EOC Channel 46. */
        vuint32_t EOCCH45:1;					 /* EOC Channel 45. */
        vuint32_t EOCCH44:1;					 /* EOC Channel 44. */
        vuint32_t EOCCH43:1;					 /* EOC Channel 43. */
        vuint32_t EOCCH42:1;					 /* EOC Channel 42. */
        vuint32_t EOCCH41:1;					 /* EOC Channel 41. */
        vuint32_t EOCCH40:1;					 /* EOC Channel 40. */
        vuint32_t EOCCH39:1;					 /* EOC Channel 39. */
        vuint32_t EOCCH38:1;					 /* EOC Channel 38. */
        vuint32_t EOCCH37:1;					 /* EOC Channel 37. */
        vuint32_t EOCCH36:1;					 /* EOC Channel 36. */
        vuint32_t EOCCH35:1;					 /* EOC Channel 35. */
        vuint32_t EOCCH34:1;					 /* EOC Channel 34. */
        vuint32_t EOCCH33:1;					 /* EOC Channel 33. */
        vuint32_t EOCCH32:1;					 /* EOC Channel 32. */
    } B;
  } CEOCFR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t EOCCH95:1;					 /* EOC Channel 95. */
        vuint32_t EOCCH94:1;					 /* EOC Channel 94. */
        vuint32_t EOCCH93:1;					 /* EOC Channel 93. */
        vuint32_t EOCCH92:1;					 /* EOC Channel 92. */
        vuint32_t EOCCH91:1;					 /* EOC Channel 91. */
        vuint32_t EOCCH90:1;					 /* EOC Channel 90. */
        vuint32_t EOCCH89:1;					 /* EOC Channel 89. */
        vuint32_t EOCCH88:1;					 /* EOC Channel 88. */
        vuint32_t EOCCH87:1;					 /* EOC Channel 87. */
        vuint32_t EOCCH86:1;					 /* EOC Channel 86. */
        vuint32_t EOCCH85:1;					 /* EOC Channel 85. */
        vuint32_t EOCCH84:1;					 /* EOC Channel 84. */
        vuint32_t EOCCH83:1;					 /* EOC Channel 83. */
        vuint32_t EOCCH82:1;					 /* EOC Channel 82. */
        vuint32_t EOCCH81:1;					 /* EOC Channel 81. */
        vuint32_t EOCCH80:1;					 /* EOC Channel 80. */
        vuint32_t EOCCH79:1;					 /* EOC Channel 79. */
        vuint32_t EOCCH78:1;					 /* EOC Channel 78. */
        vuint32_t EOCCH77:1;					 /* EOC Channel 77. */
        vuint32_t EOCCH76:1;					 /* EOC Channel 76. */
        vuint32_t EOCCH75:1;					 /* EOC Channel 75. */
        vuint32_t EOCCH74:1;					 /* EOC Channel 74. */
        vuint32_t EOCCH73:1;					 /* EOC Channel 73. */
        vuint32_t EOCCH72:1;					 /* EOC Channel 72. */
        vuint32_t EOCCH71:1;					 /* EOC Channel 71. */
        vuint32_t EOCCH70:1;					 /* EOC Channel 70. */
        vuint32_t EOCCH69:1;					 /* EOC Channel 69. */
        vuint32_t EOCCH68:1;					 /* EOC Channel 68. */
        vuint32_t EOCCH67:1;					 /* EOC Channel 67. */
        vuint32_t EOCCH66:1;					 /* EOC Channel 66. */
        vuint32_t EOCCH65:1;					 /* EOC Channel 65. */
        vuint32_t EOCCH64:1;					 /* EOC Channel 64. */
    } B;
  } CEOCFR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :27;					 /*  */
        vuint32_t MSKEOCTU:1;					 /* Mask bit for EOCTU. */
        vuint32_t MSKJEOC:1;					 /* Mask bit for JEOC. */
        vuint32_t MSKJECH:1;					 /* Mask bit for JECH. */
        vuint32_t MSKEOC:1;					 /* Mask bit for EOC. */
        vuint32_t MSKECH:1;					 /* Mask bit for ECH. */
    } B;
  } IMR;

  union {
    vuint32_t R;
      struct {
        vuint32_t CIM31:1;					 /* Channel 31 interrupt enable. */
        vuint32_t CIM30:1;					 /* Channel 30 interrupt enable. */
        vuint32_t CIM29:1;					 /* Channel 29 interrupt enable. */
        vuint32_t CIM28:1;					 /* Channel 28 interrupt enable. */
        vuint32_t CIM27:1;					 /* Channel 27 interrupt enable. */
        vuint32_t CIM26:1;					 /* Channel 26 interrupt enable. */
        vuint32_t CIM25:1;					 /* Channel 25 interrupt enable. */
        vuint32_t CIM24:1;					 /* Channel 24 interrupt enable. */
        vuint32_t CIM23:1;					 /* Channel 23 interrupt enable. */
        vuint32_t CIM22:1;					 /* Channel 22 interrupt enable. */
        vuint32_t CIM21:1;					 /* Channel 21 interrupt enable. */
        vuint32_t CIM20:1;					 /* Channel 20 interrupt enable. */
        vuint32_t CIM19:1;					 /* Channel 19 interrupt enable. */
        vuint32_t CIM18:1;					 /* Channel 18 interrupt enable. */
        vuint32_t CIM17:1;					 /* Channel 17 interrupt enable. */
        vuint32_t CIM16:1;					 /* Channel 16 interrupt enable. */
        vuint32_t CIM15:1;					 /* Channel 15 interrupt enable. */
        vuint32_t CIM14:1;					 /* Channel 14 interrupt enable. */
        vuint32_t CIM13:1;					 /* Channel 13 interrupt enable. */
        vuint32_t CIM12:1;					 /* Channel 12 interrupt enable. */
        vuint32_t CIM11:1;					 /* Channel 11 interrupt enable. */
        vuint32_t CIM10:1;					 /* Channel 10 interrupt enable. */
        vuint32_t CIM9:1;					 /* Channel 9 interrupt enable. */
        vuint32_t CIM8:1;					 /* Channel 8 interrupt enable. */
        vuint32_t CIM7:1;					 /* Channel 7 interrupt enable. */
        vuint32_t CIM6:1;					 /* Channel 6 interrupt enable. */
        vuint32_t CIM5:1;					 /* Channel 5 interrupt enable. */
        vuint32_t CIM4:1;					 /* Channel 4 interrupt enable. */
        vuint32_t CIM3:1;					 /* Channel 3 interrupt enable. */
        vuint32_t CIM2:1;					 /* Channel 2 interrupt enable. */
        vuint32_t CIM1:1;					 /* Channel 1 interrupt enable. */
        vuint32_t CIM0:1;					 /* Channel 0 interrupt enable. */
    } B;
  } CIMR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t CIM63:1;					 /* Channel 63 interrupt enable. */
        vuint32_t CIM62:1;					 /* Channel 62 interrupt enable. */
        vuint32_t CIM61:1;					 /* Channel 61 interrupt enable. */
        vuint32_t CIM60:1;					 /* Channel 60 interrupt enable. */
        vuint32_t CIM59:1;					 /* Channel 59 interrupt enable. */
        vuint32_t CIM58:1;					 /* Channel 58 interrupt enable. */
        vuint32_t CIM57:1;					 /* Channel 57 interrupt enable. */
        vuint32_t CIM56:1;					 /* Channel 56 interrupt enable. */
        vuint32_t CIM55:1;					 /* Channel 55 interrupt enable. */
        vuint32_t CIM54:1;					 /* Channel 54 interrupt enable. */
        vuint32_t CIM53:1;					 /* Channel 53 interrupt enable. */
        vuint32_t CIM52:1;					 /* Channel 52 interrupt enable. */
        vuint32_t CIM51:1;					 /* Channel 51 interrupt enable. */
        vuint32_t CIM50:1;					 /* Channel 50 interrupt enable. */
        vuint32_t CIM49:1;					 /* Channel 49 interrupt enable. */
        vuint32_t CIM48:1;					 /* Channel 48 interrupt enable. */
        vuint32_t CIM47:1;					 /* Channel 47 interrupt enable. */
        vuint32_t CIM46:1;					 /* Channel 46 interrupt enable. */
        vuint32_t CIM45:1;					 /* Channel 45 interrupt enable. */
        vuint32_t CIM44:1;					 /* Channel 44 interrupt enable. */
        vuint32_t CIM43:1;					 /* Channel 43 interrupt enable. */
        vuint32_t CIM42:1;					 /* Channel 42 interrupt enable. */
        vuint32_t CIM41:1;					 /* Channel 41 interrupt enable. */
        vuint32_t CIM40:1;					 /* Channel 40 interrupt enable. */
        vuint32_t CIM39:1;					 /* Channel 39 interrupt enable. */
        vuint32_t CIM38:1;					 /* Channel 38 interrupt enable. */
        vuint32_t CIM37:1;					 /* Channel 37 interrupt enable. */
        vuint32_t CIM36:1;					 /* Channel 36 interrupt enable. */
        vuint32_t CIM35:1;					 /* Channel 35 interrupt enable. */
        vuint32_t CIM34:1;					 /* Channel 34 interrupt enable. */
        vuint32_t CIM33:1;					 /* Channel 33 interrupt enable. */
        vuint32_t CIM32:1;					 /* Channel 32 interrupt enable. */
    } B;
  } CIMR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t CIM95:1;					 /* Channel 95 interrupt enable. */
        vuint32_t CIM94:1;					 /* Channel 94 interrupt enable. */
        vuint32_t CIM93:1;					 /* Channel 93 interrupt enable. */
        vuint32_t CIM92:1;					 /* Channel 92 interrupt enable. */
        vuint32_t CIM91:1;					 /* Channel 91 interrupt enable. */
        vuint32_t CIM90:1;					 /* Channel 90 interrupt enable. */
        vuint32_t CIM89:1;					 /* Channel 89 interrupt enable. */
        vuint32_t CIM88:1;					 /* Channel 88 interrupt enable. */
        vuint32_t CIM87:1;					 /* Channel 87 interrupt enable. */
        vuint32_t CIM86:1;					 /* Channel 86 interrupt enable. */
        vuint32_t CIM85:1;					 /* Channel 85 interrupt enable. */
        vuint32_t CIM84:1;					 /* Channel 84 interrupt enable. */
        vuint32_t CIM83:1;					 /* Channel 83 interrupt enable. */
        vuint32_t CIM82:1;					 /* Channel 82 interrupt enable. */
        vuint32_t CIM81:1;					 /* Channel 81 interrupt enable. */
        vuint32_t CIM80:1;					 /* Channel 80 interrupt enable. */
        vuint32_t CIM79:1;					 /* Channel 79 interrupt enable. */
        vuint32_t CIM78:1;					 /* Channel 78 interrupt enable. */
        vuint32_t CIM77:1;					 /* Channel 77 interrupt enable. */
        vuint32_t CIM76:1;					 /* Channel 76 interrupt enable. */
        vuint32_t CIM75:1;					 /* Channel 75 interrupt enable. */
        vuint32_t CIM74:1;					 /* Channel 74 interrupt enable. */
        vuint32_t CIM73:1;					 /* Channel 73 interrupt enable. */
        vuint32_t CIM72:1;					 /* Channel 72 interrupt enable. */
        vuint32_t CIM71:1;					 /* Channel 71 interrupt enable. */
        vuint32_t CIM70:1;					 /* Channel 70 interrupt enable. */
        vuint32_t CIM69:1;					 /* Channel 69 interrupt enable. */
        vuint32_t CIM68:1;					 /* Channel 68 interrupt enable. */
        vuint32_t CIM67:1;					 /* Channel 67 interrupt enable. */
        vuint32_t CIM66:1;					 /* Channel 66 interrupt enable. */
        vuint32_t CIM65:1;					 /* Channel 65 interrupt enable. */
        vuint32_t CIM64:1;					 /* Channel 64 interrupt enable. */
    } B;
  } CIMR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t WDG15H:1;					 /*  */
        vuint32_t WDG15L:1;					 /*  */
        vuint32_t WDG14H:1;					 /*  */
        vuint32_t WDG14L:1;					 /*  */
        vuint32_t WDG13H:1;					 /*  */
        vuint32_t WDG13L:1;					 /*  */
        vuint32_t WDG12H:1;					 /*  */
        vuint32_t WDG12L:1;					 /*  */
        vuint32_t WDG11H:1;					 /*  */
        vuint32_t WDG11L:1;					 /*  */
        vuint32_t WDG10H:1;					 /*  */
        vuint32_t WDG10L:1;					 /*  */
        vuint32_t WDG9H:1;					 /*  */
        vuint32_t WDG9L:1;					 /*  */
        vuint32_t WDG8H:1;					 /*  */
        vuint32_t WDG8L:1;					 /*  */
        vuint32_t WDG7H:1;					 /*  */
        vuint32_t WDG7L:1;					 /*  */
        vuint32_t WDG6H:1;					 /*  */
        vuint32_t WDG6L:1;					 /*  */
        vuint32_t WDG5H:1;					 /*  */
        vuint32_t WDG5L:1;					 /*  */
        vuint32_t WDG4H:1;					 /*  */
        vuint32_t WDG4L:1;					 /*  */
        vuint32_t WDG3H:1;					 /*  */
        vuint32_t WDG3L:1;					 /*  */
        vuint32_t WDG2H:1;					 /*  */
        vuint32_t WDG2L:1;					 /*  */
        vuint32_t WDG1H:1;					 /*  */
        vuint32_t WDG1L:1;					 /*  */
        vuint32_t WDG0H:1;					 /*  */
        vuint32_t WDG0L:1;					 /*  */
    } B;
  } WTISR;

  union {
    vuint32_t R;
      struct {
        vuint32_t MSKWDG15H:1;					 /*  */
        vuint32_t MSKWDG15L:1;					 /*  */
        vuint32_t MSKWDG14H:1;					 /*  */
        vuint32_t MSKWDG14L:1;					 /*  */
        vuint32_t MSKWDG13H:1;					 /*  */
        vuint32_t MSKWDG13L:1;					 /*  */
        vuint32_t MSKWDG12H:1;					 /*  */
        vuint32_t MSKWDG12L:1;					 /*  */
        vuint32_t MSKWDG11H:1;					 /*  */
        vuint32_t MSKWDG11L:1;					 /*  */
        vuint32_t MSKWDG10H:1;					 /*  */
        vuint32_t MSKWDG10L:1;					 /*  */
        vuint32_t MSKWDG9H:1;					 /*  */
        vuint32_t MSKWDG9L:1;					 /*  */
        vuint32_t MSKWDG8H:1;					 /*  */
        vuint32_t MSKWDG8L:1;					 /*  */
        vuint32_t MSKWDG7H:1;					 /*  */
        vuint32_t MSKWDG7L:1;					 /*  */
        vuint32_t MSKWDG6H:1;					 /*  */
        vuint32_t MSKWDG6L:1;					 /*  */
        vuint32_t MSKWDG5H:1;					 /*  */
        vuint32_t MSKWDG5L:1;					 /*  */
        vuint32_t MSKWDG4H:1;					 /*  */
        vuint32_t MSKWDG4L:1;					 /*  */
        vuint32_t MSKWDG3H:1;					 /*  */
        vuint32_t MSKWDG3L:1;					 /*  */
        vuint32_t MSKWDG2H:1;					 /*  */
        vuint32_t MSKWDG2L:1;					 /*  */
        vuint32_t MSKWDG1H:1;					 /*  */
        vuint32_t MSKWDG1L:1;					 /*  */
        vuint32_t MSKWDG0H:1;					 /*  */
        vuint32_t MSKWDG0L:1;					 /*  */
    } B;
  } WTIMR;

  uint8_t ADC_reserved1[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :30;					 /*  */
        vuint32_t DCLR:1;					 /* DMA Clear sequence enable. */
        vuint32_t DMAEN:1;					 /* DMA global enable. */
    } B;
  } DMAE;

  union {
    vuint32_t R;
      struct {
        vuint32_t DMA31:1;					 /* DMA enable for channel 31. */
        vuint32_t DMA30:1;					 /* DMA enable for channel 30. */
        vuint32_t DMA29:1;					 /* DMA enable for channel 29. */
        vuint32_t DMA28:1;					 /* DMA enable for channel 28. */
        vuint32_t DMA27:1;					 /* DMA enable for channel 27. */
        vuint32_t DMA26:1;					 /* DMA enable for channel 26. */
        vuint32_t DMA25:1;					 /* DMA enable for channel 25. */
        vuint32_t DMA24:1;					 /* DMA enable for channel 24. */
        vuint32_t DMA23:1;					 /* DMA enable for channel 23. */
        vuint32_t DMA22:1;					 /* DMA enable for channel 22. */
        vuint32_t DMA21:1;					 /* DMA enable for channel 21. */
        vuint32_t DMA20:1;					 /* DMA enable for channel 20. */
        vuint32_t DMA19:1;					 /* DMA enable for channel 19. */
        vuint32_t DMA18:1;					 /* DMA enable for channel 18. */
        vuint32_t DMA17:1;					 /* DMA enable for channel 17. */
        vuint32_t DMA16:1;					 /* DMA enable for channel 16. */
        vuint32_t DMA15:1;					 /* DMA enable for channel 15. */
        vuint32_t DMA14:1;					 /* DMA enable for channel 14. */
        vuint32_t DMA13:1;					 /* DMA enable for channel 13. */
        vuint32_t DMA12:1;					 /* DMA enable for channel 12. */
        vuint32_t DMA11:1;					 /* DMA enable for channel 11. */
        vuint32_t DMA10:1;					 /* DMA enable for channel 10. */
        vuint32_t DMA9:1;					 /* DMA enable for channel 9. */
        vuint32_t DMA8:1;					 /* DMA enable for channel 8. */
        vuint32_t DMA7:1;					 /* DMA enable for channel 7. */
        vuint32_t DMA6:1;					 /* DMA enable for channel 6. */
        vuint32_t DMA5:1;					 /* DMA enable for channel 5. */
        vuint32_t DMA4:1;					 /* DMA enable for channel 4. */
        vuint32_t DMA3:1;					 /* DMA enable for channel 3. */
        vuint32_t DMA2:1;					 /* DMA enable for channel 2. */
        vuint32_t DMA1:1;					 /* DMA enable for channel 1. */
        vuint32_t DMA0:1;					 /* DMA enable for channel 0. */
    } B;
  } DMAR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t DMA63:1;					 /* DMA enable for channel 63. */
        vuint32_t DMA62:1;					 /* DMA enable for channel 62. */
        vuint32_t DMA61:1;					 /* DMA enable for channel 61. */
        vuint32_t DMA60:1;					 /* DMA enable for channel 60. */
        vuint32_t DMA59:1;					 /* DMA enable for channel 59. */
        vuint32_t DMA58:1;					 /* DMA enable for channel 58. */
        vuint32_t DMA57:1;					 /* DMA enable for channel 57. */
        vuint32_t DMA56:1;					 /* DMA enable for channel 56. */
        vuint32_t DMA55:1;					 /* DMA enable for channel 55. */
        vuint32_t DMA54:1;					 /* DMA enable for channel 54. */
        vuint32_t DMA53:1;					 /* DMA enable for channel 53. */
        vuint32_t DMA52:1;					 /* DMA enable for channel 52. */
        vuint32_t DMA51:1;					 /* DMA enable for channel 51. */
        vuint32_t DMA50:1;					 /* DMA enable for channel 50. */
        vuint32_t DMA49:1;					 /* DMA enable for channel 49. */
        vuint32_t DMA48:1;					 /* DMA enable for channel 48. */
        vuint32_t DMA47:1;					 /* DMA enable for channel 47. */
        vuint32_t DMA46:1;					 /* DMA enable for channel 46. */
        vuint32_t DMA45:1;					 /* DMA enable for channel 45. */
        vuint32_t DMA44:1;					 /* DMA enable for channel 44. */
        vuint32_t DMA43:1;					 /* DMA enable for channel 43. */
        vuint32_t DMA42:1;					 /* DMA enable for channel 42. */
        vuint32_t DMA41:1;					 /* DMA enable for channel 41. */
        vuint32_t DMA40:1;					 /* DMA enable for channel 40. */
        vuint32_t DMA39:1;					 /* DMA enable for channel 39. */
        vuint32_t DMA38:1;					 /* DMA enable for channel 38. */
        vuint32_t DMA37:1;					 /* DMA enable for channel 37. */
        vuint32_t DMA36:1;					 /* DMA enable for channel 36. */
        vuint32_t DMA35:1;					 /* DMA enable for channel 35. */
        vuint32_t DMA34:1;					 /* DMA enable for channel 34. */
        vuint32_t DMA33:1;					 /* DMA enable for channel 33. */
        vuint32_t DMA32:1;					 /* DMA enable for channel 32. */
    } B;
  } DMAR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t DMA95:1;					 /* DMA enable for channel 95. */
        vuint32_t DMA94:1;					 /* DMA enable for channel 94. */
        vuint32_t DMA93:1;					 /* DMA enable for channel 93. */
        vuint32_t DMA92:1;					 /* DMA enable for channel 92. */
        vuint32_t DMA91:1;					 /* DMA enable for channel 91. */
        vuint32_t DMA90:1;					 /* DMA enable for channel 90. */
        vuint32_t DMA89:1;					 /* DMA enable for channel 89. */
        vuint32_t DMA88:1;					 /* DMA enable for channel 88. */
        vuint32_t DMA87:1;					 /* DMA enable for channel 87. */
        vuint32_t DMA86:1;					 /* DMA enable for channel 86. */
        vuint32_t DMA85:1;					 /* DMA enable for channel 85. */
        vuint32_t DMA84:1;					 /* DMA enable for channel 84. */
        vuint32_t DMA83:1;					 /* DMA enable for channel 83. */
        vuint32_t DMA82:1;					 /* DMA enable for channel 82. */
        vuint32_t DMA81:1;					 /* DMA enable for channel 81. */
        vuint32_t DMA80:1;					 /* DMA enable for channel 80. */
        vuint32_t DMA79:1;					 /* DMA enable for channel 79. */
        vuint32_t DMA78:1;					 /* DMA enable for channel 78. */
        vuint32_t DMA77:1;					 /* DMA enable for channel 77. */
        vuint32_t DMA76:1;					 /* DMA enable for channel 76. */
        vuint32_t DMA75:1;					 /* DMA enable for channel 75. */
        vuint32_t DMA74:1;					 /* DMA enable for channel 74. */
        vuint32_t DMA73:1;					 /* DMA enable for channel 73. */
        vuint32_t DMA72:1;					 /* DMA enable for channel 72. */
        vuint32_t DMA71:1;					 /* DMA enable for channel 71. */
        vuint32_t DMA70:1;					 /* DMA enable for channel 70. */
        vuint32_t DMA69:1;					 /* DMA enable for channel 69. */
        vuint32_t DMA68:1;					 /* DMA enable for channel 68. */
        vuint32_t DMA67:1;					 /* DMA enable for channel 67. */
        vuint32_t DMA66:1;					 /* DMA enable for channel 66. */
        vuint32_t DMA65:1;					 /* DMA enable for channel 65. */
        vuint32_t DMA64:1;					 /* DMA enable for channel 64. */
    } B;
  } DMAR2;

  uint8_t ADC_reserved2[16];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t THRH:12;					 /* High threshold value for watchdog n. */
        vuint32_t  :4;					 /*  */
        vuint32_t THRL:12;					 /* Low threshold value for watchdog n. */
    } B;
  } THRHLR[4];

  uint8_t ADC_reserved3[16];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :25;					 /*  */
        vuint32_t PREVAL2:2;					 /* Internal voltage selection for Presampling */
        vuint32_t PREVAL1:2;					 /* Internal voltage selection for Presampling. */
        vuint32_t PREVAL0:2;					 /* Internal voltage selection for Presampling. */
        vuint32_t PRECONV:1;					 /* Convert Presampled value */
    } B;
  } PSCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t PRES31:1;					 /* Presampling enable for channel 31. */
        vuint32_t PRES30:1;					 /* Presampling enable for channel 30. */
        vuint32_t PRES29:1;					 /* Presampling enable for channel 29. */
        vuint32_t PRES28:1;					 /* Presampling enable for channel 28. */
        vuint32_t PRES27:1;					 /* Presampling enable for channel 27. */
        vuint32_t PRES26:1;					 /* Presampling enable for channel 26. */
        vuint32_t PRES25:1;					 /* Presampling enable for channel 25. */
        vuint32_t PRES24:1;					 /* Presampling enable for channel 24. */
        vuint32_t PRES23:1;					 /* Presampling enable for channel 23. */
        vuint32_t PRES22:1;					 /* Presampling enable for channel 22. */
        vuint32_t PRES21:1;					 /* Presampling enable for channel 21. */
        vuint32_t PRES20:1;					 /* Presampling enable for channel 20. */
        vuint32_t PRES19:1;					 /* Presampling enable for channel 19. */
        vuint32_t PRES18:1;					 /* Presampling enable for channel 18. */
        vuint32_t PRES17:1;					 /* Presampling enable for channel 17. */
        vuint32_t PRES16:1;					 /* Presampling enable for channel 16. */
        vuint32_t PRES15:1;					 /* Presampling enable for channel 15. */
        vuint32_t PRES14:1;					 /* Presampling enable for channel 14. */
        vuint32_t PRES13:1;					 /* Presampling enable for channel 13. */
        vuint32_t PRES12:1;					 /* Presampling enable for channel 12. */
        vuint32_t PRES11:1;					 /* Presampling enable for channel 11. */
        vuint32_t PRES10:1;					 /* Presampling enable for channel 10. */
        vuint32_t PRES9:1;					 /* Presampling enable for channel 9. */
        vuint32_t PRES8:1;					 /* Presampling enable for channel 8. */
        vuint32_t PRES7:1;					 /* Presampling enable for channel 7. */
        vuint32_t PRES6:1;					 /* Presampling enable for channel 6. */
        vuint32_t PRES5:1;					 /* Presampling enable for channel 5. */
        vuint32_t PRES4:1;					 /* Presampling enable for channel 4. */
        vuint32_t PRES3:1;					 /* Presampling enable for channel 3. */
        vuint32_t PRES2:1;					 /* Presampling enable for channel 2. */
        vuint32_t PRES1:1;					 /* Presampling enable for channel 1. */
        vuint32_t PRES0:1;					 /* Presampling enable for channel 0. */
    } B;
  } PSR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t PRES63:1;					 /* Presampling enable for channel 63. */
        vuint32_t PRES62:1;					 /* Presampling enable for channel 62. */
        vuint32_t PRES61:1;					 /* Presampling enable for channel 61. */
        vuint32_t PRES60:1;					 /* Presampling enable for channel 60. */
        vuint32_t PRES59:1;					 /* Presampling enable for channel 59. */
        vuint32_t PRES58:1;					 /* Presampling enable for channel 58. */
        vuint32_t PRES57:1;					 /* Presampling enable for channel 57. */
        vuint32_t PRES56:1;					 /* Presampling enable for channel 56. */
        vuint32_t PRES55:1;					 /* Presampling enable for channel 55. */
        vuint32_t PRES54:1;					 /* Presampling enable for channel 54. */
        vuint32_t PRES53:1;					 /* Presampling enable for channel 53. */
        vuint32_t PRES52:1;					 /* Presampling enable for channel 52. */
        vuint32_t PRES51:1;					 /* Presampling enable for channel 51. */
        vuint32_t PRES50:1;					 /* Presampling enable for channel 50. */
        vuint32_t PRES49:1;					 /* Presampling enable for channel 49. */
        vuint32_t PRES48:1;					 /* Presampling enable for channel 48. */
        vuint32_t PRES47:1;					 /* Presampling enable for channel 47. */
        vuint32_t PRES46:1;					 /* Presampling enable for channel 46. */
        vuint32_t PRES45:1;					 /* Presampling enable for channel 45. */
        vuint32_t PRES44:1;					 /* Presampling enable for channel 44. */
        vuint32_t PRES43:1;					 /* Presampling enable for channel 43. */
        vuint32_t PRES42:1;					 /* Presampling enable for channel 42. */
        vuint32_t PRES41:1;					 /* Presampling enable for channel 41. */
        vuint32_t PRES40:1;					 /* Presampling enable for channel 40. */
        vuint32_t PRES39:1;					 /* Presampling enable for channel 39. */
        vuint32_t PRES38:1;					 /* Presampling enable for channel 38. */
        vuint32_t PRES37:1;					 /* Presampling enable for channel 37. */
        vuint32_t PRES36:1;					 /* Presampling enable for channel 36. */
        vuint32_t PRES35:1;					 /* Presampling enable for channel 35. */
        vuint32_t PRES34:1;					 /* Presampling enable for channel 34. */
        vuint32_t PRES33:1;					 /* Presampling enable for channel 33. */
        vuint32_t PRES32:1;					 /* Presampling enable for channel 32. */
    } B;
  } PSR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t PRES95:1;					 /* Presampling enable for channel 95. */
        vuint32_t PRES94:1;					 /* Presampling enable for channel 94. */
        vuint32_t PRES93:1;					 /* Presampling enable for channel 93. */
        vuint32_t PRES92:1;					 /* Presampling enable for channel 92. */
        vuint32_t PRES91:1;					 /* Presampling enable for channel 91. */
        vuint32_t PRES90:1;					 /* Presampling enable for channel 90. */
        vuint32_t PRES89:1;					 /* Presampling enable for channel 89. */
        vuint32_t PRES88:1;					 /* Presampling enable for channel 88. */
        vuint32_t PRES87:1;					 /* Presampling enable for channel 87. */
        vuint32_t PRES86:1;					 /* Presampling enable for channel 86. */
        vuint32_t PRES85:1;					 /* Presampling enable for channel 85. */
        vuint32_t PRES84:1;					 /* Presampling enable for channel 84. */
        vuint32_t PRES83:1;					 /* Presampling enable for channel 83. */
        vuint32_t PRES82:1;					 /* Presampling enable for channel 82. */
        vuint32_t PRES81:1;					 /* Presampling enable for channel 81. */
        vuint32_t PRES80:1;					 /* Presampling enable for channel 80. */
        vuint32_t PRES79:1;					 /* Presampling enable for channel 79. */
        vuint32_t PRES78:1;					 /* Presampling enable for channel 78. */
        vuint32_t PRES77:1;					 /* Presampling enable for channel 77. */
        vuint32_t PRES76:1;					 /* Presampling enable for channel 76. */
        vuint32_t PRES75:1;					 /* Presampling enable for channel 75. */
        vuint32_t PRES74:1;					 /* Presampling enable for channel 74. */
        vuint32_t PRES73:1;					 /* Presampling enable for channel 73. */
        vuint32_t PRES72:1;					 /* Presampling enable for channel 72. */
        vuint32_t PRES71:1;					 /* Presampling enable for channel 71. */
        vuint32_t PRES70:1;					 /* Presampling enable for channel 70. */
        vuint32_t PRES69:1;					 /* Presampling enable for channel 69. */
        vuint32_t PRES68:1;					 /* Presampling enable for channel 68. */
        vuint32_t PRES67:1;					 /* Presampling enable for channel 67. */
        vuint32_t PRES66:1;					 /* Presampling enable for channel 66. */
        vuint32_t PRES65:1;					 /* Presampling enable for channel 65. */
        vuint32_t PRES64:1;					 /* Presampling enable for channel 64. */
    } B;
  } PSR2;

  uint8_t ADC_reserved4[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t INPSAMP:8;					 /* Configuration of sampling phase duration. */
    } B;
  } CTR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t INPSAMP:7;					 /* Configuration of sampling phase duration. */
        vuint32_t TSENSOR_SEL:1;					 /* Voltage Select for temperature sensor. */
    } B;
  } CTR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t INPSAMP:8;					 /* Configuration of sampling phase duration. */
    } B;
  } CTR2;

  uint8_t ADC_reserved5[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t CH31:1;					 /* Sampling enable for channel 31. */
        vuint32_t CH30:1;					 /* Sampling enable for channel 30. */
        vuint32_t CH29:1;					 /* Sampling enable for channel 29. */
        vuint32_t CH28:1;					 /* Sampling enable for channel 28. */
        vuint32_t CH27:1;					 /* Sampling enable for channel 27. */
        vuint32_t CH26:1;					 /* Sampling enable for channel 26. */
        vuint32_t CH25:1;					 /* Sampling enable for channel 25. */
        vuint32_t CH24:1;					 /* Sampling enable for channel 24. */
        vuint32_t CH23:1;					 /* Sampling enable for channel 23. */
        vuint32_t CH22:1;					 /* Sampling enable for channel 22. */
        vuint32_t CH21:1;					 /* Sampling enable for channel 21. */
        vuint32_t CH20:1;					 /* Sampling enable for channel 20. */
        vuint32_t CH19:1;					 /* Sampling enable for channel 19. */
        vuint32_t CH18:1;					 /* Sampling enable for channel 18. */
        vuint32_t CH17:1;					 /* Sampling enable for channel 17. */
        vuint32_t CH16:1;					 /* Sampling enable for channel 16. */
        vuint32_t CH15:1;					 /* Sampling enable for channel 15. */
        vuint32_t CH14:1;					 /* Sampling enable for channel 14. */
        vuint32_t CH13:1;					 /* Sampling enable for channel 13. */
        vuint32_t CH12:1;					 /* Sampling enable for channel 12. */
        vuint32_t CH11:1;					 /* Sampling enable for channel 11. */
        vuint32_t CH10:1;					 /* Sampling enable for channel 10. */
        vuint32_t CH9:1;					 /* Sampling enable for channel 9. */
        vuint32_t CH8:1;					 /* Sampling enable for channel 8. */
        vuint32_t CH7:1;					 /* Sampling enable for channel 7. */
        vuint32_t CH6:1;					 /* Sampling enable for channel 6. */
        vuint32_t CH5:1;					 /* Sampling enable for channel 5. */
        vuint32_t CH4:1;					 /* Sampling enable for channel 4. */
        vuint32_t CH3:1;					 /* Sampling enable for channel 3. */
        vuint32_t CH2:1;					 /* Sampling enable for channel 2. */
        vuint32_t CH1:1;					 /* Sampling enable for channel 1. */
        vuint32_t CH0:1;					 /* Sampling enable for channel 0. */
    } B;
  } NCMR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t CH63:1;					 /* Sampling enable for channel 63. */
        vuint32_t CH62:1;					 /* Sampling enable for channel 62. */
        vuint32_t CH61:1;					 /* Sampling enable for channel 61. */
        vuint32_t CH60:1;					 /* Sampling enable for channel 60. */
        vuint32_t CH59:1;					 /* Sampling enable for channel 59. */
        vuint32_t CH58:1;					 /* Sampling enable for channel 58. */
        vuint32_t CH57:1;					 /* Sampling enable for channel 57. */
        vuint32_t CH56:1;					 /* Sampling enable for channel 56. */
        vuint32_t CH55:1;					 /* Sampling enable for channel 55. */
        vuint32_t CH54:1;					 /* Sampling enable for channel 54. */
        vuint32_t CH53:1;					 /* Sampling enable for channel 53. */
        vuint32_t CH52:1;					 /* Sampling enable for channel 52. */
        vuint32_t CH51:1;					 /* Sampling enable for channel 51. */
        vuint32_t CH50:1;					 /* Sampling enable for channel 50. */
        vuint32_t CH49:1;					 /* Sampling enable for channel 49. */
        vuint32_t CH48:1;					 /* Sampling enable for channel 48. */
        vuint32_t CH47:1;					 /* Sampling enable for channel 47. */
        vuint32_t CH46:1;					 /* Sampling enable for channel 46. */
        vuint32_t CH45:1;					 /* Sampling enable for channel 45. */
        vuint32_t CH44:1;					 /* Sampling enable for channel 44. */
        vuint32_t CH43:1;					 /* Sampling enable for channel 43. */
        vuint32_t CH42:1;					 /* Sampling enable for channel 42. */
        vuint32_t CH41:1;					 /* Sampling enable for channel 41. */
        vuint32_t CH40:1;					 /* Sampling enable for channel 40. */
        vuint32_t CH39:1;					 /* Sampling enable for channel 39. */
        vuint32_t CH38:1;					 /* Sampling enable for channel 38. */
        vuint32_t CH37:1;					 /* Sampling enable for channel 37. */
        vuint32_t CH36:1;					 /* Sampling enable for channel 36. */
        vuint32_t CH35:1;					 /* Sampling enable for channel 35. */
        vuint32_t CH34:1;					 /* Sampling enable for channel 34. */
        vuint32_t CH33:1;					 /* Sampling enable for channel 33. */
        vuint32_t CH32:1;					 /* Sampling enable for channel 32. */
    } B;
  } NCMR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t CH95:1;					 /* Sampling enable for channel 95. */
        vuint32_t CH94:1;					 /* Sampling enable for channel 94. */
        vuint32_t CH93:1;					 /* Sampling enable for channel 93. */
        vuint32_t CH92:1;					 /* Sampling enable for channel 92. */
        vuint32_t CH91:1;					 /* Sampling enable for channel 91. */
        vuint32_t CH90:1;					 /* Sampling enable for channel 90. */
        vuint32_t CH89:1;					 /* Sampling enable for channel 89. */
        vuint32_t CH88:1;					 /* Sampling enable for channel 88. */
        vuint32_t CH87:1;					 /* Sampling enable for channel 87. */
        vuint32_t CH86:1;					 /* Sampling enable for channel 86. */
        vuint32_t CH85:1;					 /* Sampling enable for channel 85. */
        vuint32_t CH84:1;					 /* Sampling enable for channel 84. */
        vuint32_t CH83:1;					 /* Sampling enable for channel 83. */
        vuint32_t CH82:1;					 /* Sampling enable for channel 82. */
        vuint32_t CH81:1;					 /* Sampling enable for channel 81. */
        vuint32_t CH80:1;					 /* Sampling enable for channel 80. */
        vuint32_t CH79:1;					 /* Sampling enable for channel 79. */
        vuint32_t CH78:1;					 /* Sampling enable for channel 78. */
        vuint32_t CH77:1;					 /* Sampling enable for channel 77. */
        vuint32_t CH76:1;					 /* Sampling enable for channel 76. */
        vuint32_t CH75:1;					 /* Sampling enable for channel 75. */
        vuint32_t CH74:1;					 /* Sampling enable for channel 74. */
        vuint32_t CH73:1;					 /* Sampling enable for channel 73. */
        vuint32_t CH72:1;					 /* Sampling enable for channel 72. */
        vuint32_t CH71:1;					 /* Sampling enable for channel 71. */
        vuint32_t CH70:1;					 /* Sampling enable for channel 70. */
        vuint32_t CH69:1;					 /* Sampling enable for channel 69. */
        vuint32_t CH68:1;					 /* Sampling enable for channel 68. */
        vuint32_t CH67:1;					 /* Sampling enable for channel 67. */
        vuint32_t CH66:1;					 /* Sampling enable for channel 66. */
        vuint32_t CH65:1;					 /* Sampling enable for channel 65. */
        vuint32_t CH64:1;					 /* Sampling enable for channel 64. */
    } B;
  } NCMR2;

  uint8_t ADC_reserved6[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t CH31:1;					 /* Sampling enable for channel 31. */
        vuint32_t CH30:1;					 /* Sampling enable for channel 30. */
        vuint32_t CH29:1;					 /* Sampling enable for channel 29. */
        vuint32_t CH28:1;					 /* Sampling enable for channel 28. */
        vuint32_t CH27:1;					 /* Sampling enable for channel 27. */
        vuint32_t CH26:1;					 /* Sampling enable for channel 26. */
        vuint32_t CH25:1;					 /* Sampling enable for channel 25. */
        vuint32_t CH24:1;					 /* Sampling enable for channel 24. */
        vuint32_t CH23:1;					 /* Sampling enable for channel 23. */
        vuint32_t CH22:1;					 /* Sampling enable for channel 22. */
        vuint32_t CH21:1;					 /* Sampling enable for channel 21. */
        vuint32_t CH20:1;					 /* Sampling enable for channel 20. */
        vuint32_t CH19:1;					 /* Sampling enable for channel 19. */
        vuint32_t CH18:1;					 /* Sampling enable for channel 18. */
        vuint32_t CH17:1;					 /* Sampling enable for channel 17. */
        vuint32_t CH16:1;					 /* Sampling enable for channel 16. */
        vuint32_t CH15:1;					 /* Sampling enable for channel 15. */
        vuint32_t CH14:1;					 /* Sampling enable for channel 14. */
        vuint32_t CH13:1;					 /* Sampling enable for channel 13. */
        vuint32_t CH12:1;					 /* Sampling enable for channel 12. */
        vuint32_t CH11:1;					 /* Sampling enable for channel 11. */
        vuint32_t CH10:1;					 /* Sampling enable for channel 10. */
        vuint32_t CH9:1;					 /* Sampling enable for channel 9. */
        vuint32_t CH8:1;					 /* Sampling enable for channel 8. */
        vuint32_t CH7:1;					 /* Sampling enable for channel 7. */
        vuint32_t CH6:1;					 /* Sampling enable for channel 6. */
        vuint32_t CH5:1;					 /* Sampling enable for channel 5. */
        vuint32_t CH4:1;					 /* Sampling enable for channel 4. */
        vuint32_t CH3:1;					 /* Sampling enable for channel 3. */
        vuint32_t CH2:1;					 /* Sampling enable for channel 2. */
        vuint32_t CH1:1;					 /* Sampling enable for channel 1. */
        vuint32_t CH0:1;					 /* Sampling enable for channel 0. */
    } B;
  } JCMR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t CH63:1;					 /* Sampling enable for channel 63. */
        vuint32_t CH62:1;					 /* Sampling enable for channel 62. */
        vuint32_t CH61:1;					 /* Sampling enable for channel 61. */
        vuint32_t CH60:1;					 /* Sampling enable for channel 60. */
        vuint32_t CH59:1;					 /* Sampling enable for channel 59. */
        vuint32_t CH58:1;					 /* Sampling enable for channel 58. */
        vuint32_t CH57:1;					 /* Sampling enable for channel 57. */
        vuint32_t CH56:1;					 /* Sampling enable for channel 56. */
        vuint32_t CH55:1;					 /* Sampling enable for channel 55. */
        vuint32_t CH54:1;					 /* Sampling enable for channel 54. */
        vuint32_t CH53:1;					 /* Sampling enable for channel 53. */
        vuint32_t CH52:1;					 /* Sampling enable for channel 52. */
        vuint32_t CH51:1;					 /* Sampling enable for channel 51. */
        vuint32_t CH50:1;					 /* Sampling enable for channel 50. */
        vuint32_t CH49:1;					 /* Sampling enable for channel 49. */
        vuint32_t CH48:1;					 /* Sampling enable for channel 48. */
        vuint32_t CH47:1;					 /* Sampling enable for channel 47. */
        vuint32_t CH46:1;					 /* Sampling enable for channel 46. */
        vuint32_t CH45:1;					 /* Sampling enable for channel 45. */
        vuint32_t CH44:1;					 /* Sampling enable for channel 44. */
        vuint32_t CH43:1;					 /* Sampling enable for channel 43. */
        vuint32_t CH42:1;					 /* Sampling enable for channel 42. */
        vuint32_t CH41:1;					 /* Sampling enable for channel 41. */
        vuint32_t CH40:1;					 /* Sampling enable for channel 40. */
        vuint32_t CH39:1;					 /* Sampling enable for channel 39. */
        vuint32_t CH38:1;					 /* Sampling enable for channel 38. */
        vuint32_t CH37:1;					 /* Sampling enable for channel 37. */
        vuint32_t CH36:1;					 /* Sampling enable for channel 36. */
        vuint32_t CH35:1;					 /* Sampling enable for channel 35. */
        vuint32_t CH34:1;					 /* Sampling enable for channel 34. */
        vuint32_t CH33:1;					 /* Sampling enable for channel 33. */
        vuint32_t CH32:1;					 /* Sampling enable for channel 32. */
    } B;
  } JCMR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t CH95:1;					 /* Sampling enable for channel 95. */
        vuint32_t CH94:1;					 /* Sampling enable for channel 94. */
        vuint32_t CH93:1;					 /* Sampling enable for channel 93. */
        vuint32_t CH92:1;					 /* Sampling enable for channel 92. */
        vuint32_t CH91:1;					 /* Sampling enable for channel 91. */
        vuint32_t CH90:1;					 /* Sampling enable for channel 90. */
        vuint32_t CH89:1;					 /* Sampling enable for channel 89. */
        vuint32_t CH88:1;					 /* Sampling enable for channel 88. */
        vuint32_t CH87:1;					 /* Sampling enable for channel 87. */
        vuint32_t CH86:1;					 /* Sampling enable for channel 86. */
        vuint32_t CH85:1;					 /* Sampling enable for channel 85. */
        vuint32_t CH84:1;					 /* Sampling enable for channel 84. */
        vuint32_t CH83:1;					 /* Sampling enable for channel 83. */
        vuint32_t CH82:1;					 /* Sampling enable for channel 82. */
        vuint32_t CH81:1;					 /* Sampling enable for channel 81. */
        vuint32_t CH80:1;					 /* Sampling enable for channel 80. */
        vuint32_t CH79:1;					 /* Sampling enable for channel 79. */
        vuint32_t CH78:1;					 /* Sampling enable for channel 78. */
        vuint32_t CH77:1;					 /* Sampling enable for channel 77. */
        vuint32_t CH76:1;					 /* Sampling enable for channel 76. */
        vuint32_t CH75:1;					 /* Sampling enable for channel 75. */
        vuint32_t CH74:1;					 /* Sampling enable for channel 74. */
        vuint32_t CH73:1;					 /* Sampling enable for channel 73. */
        vuint32_t CH72:1;					 /* Sampling enable for channel 72. */
        vuint32_t CH71:1;					 /* Sampling enable for channel 71. */
        vuint32_t CH70:1;					 /* Sampling enable for channel 70. */
        vuint32_t CH69:1;					 /* Sampling enable for channel 69. */
        vuint32_t CH68:1;					 /* Sampling enable for channel 68. */
        vuint32_t CH67:1;					 /* Sampling enable for channel 67. */
        vuint32_t CH66:1;					 /* Sampling enable for channel 66. */
        vuint32_t CH65:1;					 /* Sampling enable for channel 65. */
        vuint32_t CH64:1;					 /* Sampling enable for channel 64. */
    } B;
  } JCMR2;

  uint8_t ADC_reserved7[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t DSD:16;					 /*  */
    } B;
  } DSDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t PDED:8;					 /*  */
    } B;
  } PDEDR;

  uint8_t ADC_reserved8[52];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR4;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR5;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR6;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR7;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR8;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR9;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR10;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR11;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR12;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR13;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR14;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR15;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR16;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR17;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR18;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR19;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR20;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR21;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR22;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR23;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR24;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR25;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR26;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR27;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR28;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR29;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR30;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR31;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR32;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR33;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR34;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR35;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR36;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR37;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR38;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR39;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR40;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR41;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR42;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR43;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR44;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR45;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR46;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR47;

  uint8_t ADC_reserved9[64];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR64;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR65;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR66;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR67;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR68;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR69;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR70;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR71;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR72;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR73;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR74;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR75;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR76;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR77;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR78;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR79;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR80;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR81;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR82;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR83;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR84;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR85;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR86;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR87;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR88;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR89;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR90;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR91;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR92;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR93;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR94;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
        vuint32_t OVERW:1;					 /* Overwrite data */
        vuint32_t RESULT:2;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t CDATA:12;					 /* Converted Data 11:0. */
    } B;
  } CDR95;

  uint8_t ADC_reserved10[48];
  union {
    vuint32_t R;
      struct {
        vuint32_t WSEL_CH7:4;					 /* Channel Watchdog select for channel 7. */
        vuint32_t WSEL_CH6:4;					 /* Channel Watchdog select for channel 6. */
        vuint32_t WSEL_CH5:4;					 /* Channel Watchdog select for channel 5. */
        vuint32_t WSEL_CH4:4;					 /* Channel Watchdog select for channel 4. */
        vuint32_t WSEL_CH3:4;					 /* Channel Watchdog select for channel 3. */
        vuint32_t WSEL_CH2:4;					 /* Channel Watchdog select for channel 2. */
        vuint32_t WSEL_CH1:4;					 /* Channel Watchdog select for channel 1. */
        vuint32_t WSEL_CH0:4;					 /* Channel Watchdog select for channel 0. */
    } B;
  } CWSELR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t WSEL_CH15:4;					 /* Channel Watchdog select for channel 15. */
        vuint32_t WSEL_CH14:4;					 /* Channel Watchdog select for channel 14. */
        vuint32_t WSEL_CH13:4;					 /* Channel Watchdog select for channel 13. */
        vuint32_t WSEL_CH12:4;					 /* Channel Watchdog select for channel 12. */
        vuint32_t WSEL_CH11:4;					 /* Channel Watchdog select for channel 11. */
        vuint32_t WSEL_CH10:4;					 /* Channel Watchdog select for channel 10. */
        vuint32_t WSEL_CH9:4;					 /* Channel Watchdog select for channel 9. */
        vuint32_t WSEL_CH8:4;					 /* Channel Watchdog select for channel 8. */
    } B;
  } CWSELR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t WSEL_CH23:4;					 /* Channel Watchdog select for channel 23. */
        vuint32_t WSEL_CH22:4;					 /* Channel Watchdog select for channel 22. */
        vuint32_t WSEL_CH21:4;					 /* Channel Watchdog select for channel 21. */
        vuint32_t WSEL_CH20:4;					 /* Channel Watchdog select for channel 20. */
        vuint32_t WSEL_CH19:4;					 /* Channel Watchdog select for channel 19. */
        vuint32_t WSEL_CH18:4;					 /* Channel Watchdog select for channel 18. */
        vuint32_t WSEL_CH17:4;					 /* Channel Watchdog select for channel 17. */
        vuint32_t WSEL_CH16:4;					 /* Channel Watchdog select for channel 16. */
    } B;
  } CWSELR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t WSEL_CH31:4;					 /* Channel Watchdog select for channel 31. */
        vuint32_t WSEL_CH30:4;					 /* Channel Watchdog select for channel 30. */
        vuint32_t WSEL_CH29:4;					 /* Channel Watchdog select for channel 29. */
        vuint32_t WSEL_CH28:4;					 /* Channel Watchdog select for channel 28. */
        vuint32_t WSEL_CH27:4;					 /* Channel Watchdog select for channel 27. */
        vuint32_t WSEL_CH26:4;					 /* Channel Watchdog select for channel 26. */
        vuint32_t WSEL_CH25:4;					 /* Channel Watchdog select for channel 25. */
        vuint32_t WSEL_CH24:4;					 /* Channel Watchdog select for channel 24. */
    } B;
  } CWSELR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t WSEL_CH39:4;					 /* Channel Watchdog select for channel 39. */
        vuint32_t WSEL_CH38:4;					 /* Channel Watchdog select for channel 38. */
        vuint32_t WSEL_CH37:4;					 /* Channel Watchdog select for channel 37. */
        vuint32_t WSEL_CH36:4;					 /* Channel Watchdog select for channel 36. */
        vuint32_t WSEL_CH35:4;					 /* Channel Watchdog select for channel 35. */
        vuint32_t WSEL_CH34:4;					 /* Channel Watchdog select for channel 34. */
        vuint32_t WSEL_CH33:4;					 /* Channel Watchdog select for channel 33. */
        vuint32_t WSEL_CH32:4;					 /* Channel Watchdog select for channel 32. */
    } B;
  } CWSELR4;

  uint8_t ADC_reserved11[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t WSEL_CH71:4;					 /* Channel Watchdog select for channel 71. */
        vuint32_t WSEL_CH70:4;					 /* Channel Watchdog select for channel 70. */
        vuint32_t WSEL_CH69:4;					 /* Channel Watchdog select for channel 69. */
        vuint32_t WSEL_CH68:4;					 /* Channel Watchdog select for channel 68. */
        vuint32_t WSEL_CH67:4;					 /* Channel Watchdog select for channel 67. */
        vuint32_t WSEL_CH66:4;					 /* Channel Watchdog select for channel 66. */
        vuint32_t WSEL_CH65:4;					 /* Channel Watchdog select for channel 65. */
        vuint32_t WSEL_CH64:4;					 /* Channel Watchdog select for channel 64. */
    } B;
  } CWSELR8;

  union {
    vuint32_t R;
      struct {
        vuint32_t WSEL_CH79:4;					 /* Channel Watchdog select for channel 79. */
        vuint32_t WSEL_CH78:4;					 /* Channel Watchdog select for channel 78. */
        vuint32_t WSEL_CH77:4;					 /* Channel Watchdog select for channel 77. */
        vuint32_t WSEL_CH76:4;					 /* Channel Watchdog select for channel 76. */
        vuint32_t WSEL_CH75:4;					 /* Channel Watchdog select for channel 75. */
        vuint32_t WSEL_CH74:4;					 /* Channel Watchdog select for channel 74. */
        vuint32_t WSEL_CH73:4;					 /* Channel Watchdog select for channel 73. */
        vuint32_t WSEL_CH72:4;					 /* Channel Watchdog select for channel 72. */
    } B;
  } CWSELR9;

  union {
    vuint32_t R;
      struct {
        vuint32_t WSEL_CH87:4;					 /* Channel Watchdog select for channel 87. */
        vuint32_t WSEL_CH86:4;					 /* Channel Watchdog select for channel 86. */
        vuint32_t WSEL_CH85:4;					 /* Channel Watchdog select for channel 85. */
        vuint32_t WSEL_CH84:4;					 /* Channel Watchdog select for channel 84. */
        vuint32_t WSEL_CH83:4;					 /* Channel Watchdog select for channel 83. */
        vuint32_t WSEL_CH82:4;					 /* Channel Watchdog select for channel 82. */
        vuint32_t WSEL_CH81:4;					 /* Channel Watchdog select for channel 81. */
        vuint32_t WSEL_CH80:4;					 /* Channel Watchdog select for channel 80. */
    } B;
  } CWSELR10;

  union {
    vuint32_t R;
      struct {
        vuint32_t WSEL_CH95:4;					 /* Channel Watchdog select for channel 95. */
        vuint32_t WSEL_CH94:4;					 /* Channel Watchdog select for channel 94. */
        vuint32_t WSEL_CH93:4;					 /* Channel Watchdog select for channel 93. */
        vuint32_t WSEL_CH92:4;					 /* Channel Watchdog select for channel 92. */
        vuint32_t WSEL_CH91:4;					 /* Channel Watchdog select for channel 91. */
        vuint32_t WSEL_CH90:4;					 /* Channel Watchdog select for channel 90. */
        vuint32_t WSEL_CH89:4;					 /* Channel Watchdog select for channel 89. */
        vuint32_t WSEL_CH88:4;					 /* Channel Watchdog select for channel 88. */
    } B;
  } CWSELR11;

  union {
    vuint32_t R;
      struct {
        vuint32_t CWEN31:1;					 /* Sampling enable for channel 31. */
        vuint32_t CWEN30:1;					 /* Sampling enable for channel 30. */
        vuint32_t CWEN29:1;					 /* Sampling enable for channel 29. */
        vuint32_t CWEN28:1;					 /* Sampling enable for channel 28. */
        vuint32_t CWEN27:1;					 /* Sampling enable for channel 27. */
        vuint32_t CWEN26:1;					 /* Sampling enable for channel 26. */
        vuint32_t CWEN25:1;					 /* Sampling enable for channel 25. */
        vuint32_t CWEN24:1;					 /* Sampling enable for channel 24. */
        vuint32_t CWEN23:1;					 /* Sampling enable for channel 23. */
        vuint32_t CWEN22:1;					 /* Sampling enable for channel 22. */
        vuint32_t CWEN21:1;					 /* Sampling enable for channel 21. */
        vuint32_t CWEN20:1;					 /* Sampling enable for channel 20. */
        vuint32_t CWEN19:1;					 /* Sampling enable for channel 19. */
        vuint32_t CWEN18:1;					 /* Sampling enable for channel 18. */
        vuint32_t CWEN17:1;					 /* Sampling enable for channel 17. */
        vuint32_t CWEN16:1;					 /* Sampling enable for channel 16. */
        vuint32_t CWEN15:1;					 /* Sampling enable for channel 15. */
        vuint32_t CWEN14:1;					 /* Sampling enable for channel 14. */
        vuint32_t CWEN13:1;					 /* Sampling enable for channel 13. */
        vuint32_t CWEN12:1;					 /* Sampling enable for channel 12. */
        vuint32_t CWEN11:1;					 /* Sampling enable for channel 11. */
        vuint32_t CWEN10:1;					 /* Sampling enable for channel 10. */
        vuint32_t CWEN9:1;					 /* Sampling enable for channel 9. */
        vuint32_t CWEN8:1;					 /* Sampling enable for channel 8. */
        vuint32_t CWEN7:1;					 /* Sampling enable for channel 7. */
        vuint32_t CWEN6:1;					 /* Sampling enable for channel 6. */
        vuint32_t CWEN5:1;					 /* Sampling enable for channel 5. */
        vuint32_t CWEN4:1;					 /* Sampling enable for channel 4. */
        vuint32_t CWEN3:1;					 /* Sampling enable for channel 3. */
        vuint32_t CWEN2:1;					 /* Sampling enable for channel 2. */
        vuint32_t CWEN1:1;					 /* Sampling enable for channel 1. */
        vuint32_t CWEN0:1;					 /* Sampling enable for channel 0. */
    } B;
  } CWENR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t CWEN63:1;					 /* Sampling enable for channel 63. */
        vuint32_t CWEN62:1;					 /* Sampling enable for channel 62. */
        vuint32_t CWEN61:1;					 /* Sampling enable for channel 61. */
        vuint32_t CWEN60:1;					 /* Sampling enable for channel 60. */
        vuint32_t CWEN59:1;					 /* Sampling enable for channel 59. */
        vuint32_t CWEN58:1;					 /* Sampling enable for channel 58. */
        vuint32_t CWEN57:1;					 /* Sampling enable for channel 57. */
        vuint32_t CWEN56:1;					 /* Sampling enable for channel 56. */
        vuint32_t CWEN55:1;					 /* Sampling enable for channel 55. */
        vuint32_t CWEN54:1;					 /* Sampling enable for channel 54. */
        vuint32_t CWEN53:1;					 /* Sampling enable for channel 53. */
        vuint32_t CWEN52:1;					 /* Sampling enable for channel 52. */
        vuint32_t CWEN51:1;					 /* Sampling enable for channel 51. */
        vuint32_t CWEN50:1;					 /* Sampling enable for channel 50. */
        vuint32_t CWEN49:1;					 /* Sampling enable for channel 49. */
        vuint32_t CWEN48:1;					 /* Sampling enable for channel 48. */
        vuint32_t CWEN47:1;					 /* Sampling enable for channel 47. */
        vuint32_t CWEN46:1;					 /* Sampling enable for channel 46. */
        vuint32_t CWEN45:1;					 /* Sampling enable for channel 45. */
        vuint32_t CWEN44:1;					 /* Sampling enable for channel 44. */
        vuint32_t CWEN43:1;					 /* Sampling enable for channel 43. */
        vuint32_t CWEN42:1;					 /* Sampling enable for channel 42. */
        vuint32_t CWEN41:1;					 /* Sampling enable for channel 41. */
        vuint32_t CWEN40:1;					 /* Sampling enable for channel 40. */
        vuint32_t CWEN39:1;					 /* Sampling enable for channel 39. */
        vuint32_t CWEN38:1;					 /* Sampling enable for channel 38. */
        vuint32_t CWEN37:1;					 /* Sampling enable for channel 37. */
        vuint32_t CWEN36:1;					 /* Sampling enable for channel 36. */
        vuint32_t CWEN35:1;					 /* Sampling enable for channel 35. */
        vuint32_t CWEN34:1;					 /* Sampling enable for channel 34. */
        vuint32_t CWEN33:1;					 /* Sampling enable for channel 33. */
        vuint32_t CWEN32:1;					 /* Sampling enable for channel 32. */
    } B;
  } CWENR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t CWEN95:1;					 /* Sampling enable for channel 95. */
        vuint32_t CWEN94:1;					 /* Sampling enable for channel 94. */
        vuint32_t CWEN93:1;					 /* Sampling enable for channel 93. */
        vuint32_t CWEN92:1;					 /* Sampling enable for channel 92. */
        vuint32_t CWEN91:1;					 /* Sampling enable for channel 91. */
        vuint32_t CWEN90:1;					 /* Sampling enable for channel 90. */
        vuint32_t CWEN89:1;					 /* Sampling enable for channel 89. */
        vuint32_t CWEN88:1;					 /* Sampling enable for channel 88. */
        vuint32_t CWEN87:1;					 /* Sampling enable for channel 87. */
        vuint32_t CWEN86:1;					 /* Sampling enable for channel 86. */
        vuint32_t CWEN85:1;					 /* Sampling enable for channel 85. */
        vuint32_t CWEN84:1;					 /* Sampling enable for channel 84. */
        vuint32_t CWEN83:1;					 /* Sampling enable for channel 83. */
        vuint32_t CWEN82:1;					 /* Sampling enable for channel 82. */
        vuint32_t CWEN81:1;					 /* Sampling enable for channel 81. */
        vuint32_t CWEN80:1;					 /* Sampling enable for channel 80. */
        vuint32_t CWEN79:1;					 /* Sampling enable for channel 79. */
        vuint32_t CWEN78:1;					 /* Sampling enable for channel 78. */
        vuint32_t CWEN77:1;					 /* Sampling enable for channel 77. */
        vuint32_t CWEN76:1;					 /* Sampling enable for channel 76. */
        vuint32_t CWEN75:1;					 /* Sampling enable for channel 75. */
        vuint32_t CWEN74:1;					 /* Sampling enable for channel 74. */
        vuint32_t CWEN73:1;					 /* Sampling enable for channel 73. */
        vuint32_t CWEN72:1;					 /* Sampling enable for channel 72. */
        vuint32_t CWEN71:1;					 /* Sampling enable for channel 71. */
        vuint32_t CWEN70:1;					 /* Sampling enable for channel 70. */
        vuint32_t CWEN69:1;					 /* Sampling enable for channel 69. */
        vuint32_t CWEN68:1;					 /* Sampling enable for channel 68. */
        vuint32_t CWEN67:1;					 /* Sampling enable for channel 67. */
        vuint32_t CWEN66:1;					 /* Sampling enable for channel 66. */
        vuint32_t CWEN65:1;					 /* Sampling enable for channel 65. */
        vuint32_t CWEN64:1;					 /* Sampling enable for channel 64. */
    } B;
  } CWENR2;

  uint8_t ADC_reserved12[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t AWOR_CH31:1;					 /* Analog watchdog out of range for channel 31. */
        vuint32_t AWOR_CH30:1;					 /* Analog watchdog out of range for channel 30. */
        vuint32_t AWOR_CH29:1;					 /* Analog watchdog out of range for channel 29. */
        vuint32_t AWOR_CH28:1;					 /* Analog watchdog out of range for channel 28. */
        vuint32_t AWOR_CH27:1;					 /* Analog watchdog out of range for channel 27. */
        vuint32_t AWOR_CH26:1;					 /* Analog watchdog out of range for channel 26. */
        vuint32_t AWOR_CH25:1;					 /* Analog watchdog out of range for channel 25. */
        vuint32_t AWOR_CH24:1;					 /* Analog watchdog out of range for channel 24. */
        vuint32_t AWOR_CH23:1;					 /* Analog watchdog out of range for channel 23. */
        vuint32_t AWOR_CH22:1;					 /* Analog watchdog out of range for channel 22. */
        vuint32_t AWOR_CH21:1;					 /* Analog watchdog out of range for channel 21. */
        vuint32_t AWOR_CH20:1;					 /* Analog watchdog out of range for channel 20. */
        vuint32_t AWOR_CH19:1;					 /* Analog watchdog out of range for channel 19. */
        vuint32_t AWOR_CH18:1;					 /* Analog watchdog out of range for channel 18. */
        vuint32_t AWOR_CH17:1;					 /* Analog watchdog out of range for channel 17. */
        vuint32_t AWOR_CH16:1;					 /* Analog watchdog out of range for channel 16. */
        vuint32_t AWOR_CH15:1;					 /* Analog watchdog out of range for channel 15. */
        vuint32_t AWOR_CH14:1;					 /* Analog watchdog out of range for channel 14. */
        vuint32_t AWOR_CH13:1;					 /* Analog watchdog out of range for channel 13. */
        vuint32_t AWOR_CH12:1;					 /* Analog watchdog out of range for channel 12. */
        vuint32_t AWOR_CH11:1;					 /* Analog watchdog out of range for channel 11. */
        vuint32_t AWOR_CH10:1;					 /* Analog watchdog out of range for channel 10. */
        vuint32_t AWOR_CH9:1;					 /* Analog watchdog out of range for channel 9. */
        vuint32_t AWOR_CH8:1;					 /* Analog watchdog out of range for channel 8. */
        vuint32_t AWOR_CH7:1;					 /* Analog watchdog out of range for channel 7. */
        vuint32_t AWOR_CH6:1;					 /* Analog watchdog out of range for channel 6. */
        vuint32_t AWOR_CH5:1;					 /* Analog watchdog out of range for channel 5. */
        vuint32_t AWOR_CH4:1;					 /* Analog watchdog out of range for channel 4. */
        vuint32_t AWOR_CH3:1;					 /* Analog watchdog out of range for channel 3. */
        vuint32_t AWOR_CH2:1;					 /* Analog watchdog out of range for channel 2. */
        vuint32_t AWOR_CH1:1;					 /* Analog watchdog out of range for channel 1. */
        vuint32_t AWOR_CH0:1;					 /* Analog watchdog out of range for channel 0. */
    } B;
  } AWORR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t AWOR_CH63:1;					 /* Analog watchdog out of range for channel 63. */
        vuint32_t AWOR_CH62:1;					 /* Analog watchdog out of range for channel 62. */
        vuint32_t AWOR_CH61:1;					 /* Analog watchdog out of range for channel 61. */
        vuint32_t AWOR_CH60:1;					 /* Analog watchdog out of range for channel 60. */
        vuint32_t AWOR_CH59:1;					 /* Analog watchdog out of range for channel 59. */
        vuint32_t AWOR_CH58:1;					 /* Analog watchdog out of range for channel 58. */
        vuint32_t AWOR_CH57:1;					 /* Analog watchdog out of range for channel 57. */
        vuint32_t AWOR_CH56:1;					 /* Analog watchdog out of range for channel 56. */
        vuint32_t AWOR_CH55:1;					 /* Analog watchdog out of range for channel 55. */
        vuint32_t AWOR_CH54:1;					 /* Analog watchdog out of range for channel 54. */
        vuint32_t AWOR_CH53:1;					 /* Analog watchdog out of range for channel 53. */
        vuint32_t AWOR_CH52:1;					 /* Analog watchdog out of range for channel 52. */
        vuint32_t AWOR_CH51:1;					 /* Analog watchdog out of range for channel 51. */
        vuint32_t AWOR_CH50:1;					 /* Analog watchdog out of range for channel 50. */
        vuint32_t AWOR_CH49:1;					 /* Analog watchdog out of range for channel 49. */
        vuint32_t AWOR_CH48:1;					 /* Analog watchdog out of range for channel 48. */
        vuint32_t AWOR_CH47:1;					 /* Analog watchdog out of range for channel 47. */
        vuint32_t AWOR_CH46:1;					 /* Analog watchdog out of range for channel 46. */
        vuint32_t AWOR_CH45:1;					 /* Analog watchdog out of range for channel 45. */
        vuint32_t AWOR_CH44:1;					 /* Analog watchdog out of range for channel 44. */
        vuint32_t AWOR_CH43:1;					 /* Analog watchdog out of range for channel 43. */
        vuint32_t AWOR_CH42:1;					 /* Analog watchdog out of range for channel 42. */
        vuint32_t AWOR_CH41:1;					 /* Analog watchdog out of range for channel 41. */
        vuint32_t AWOR_CH40:1;					 /* Analog watchdog out of range for channel 40. */
        vuint32_t AWOR_CH39:1;					 /* Analog watchdog out of range for channel 39. */
        vuint32_t AWOR_CH38:1;					 /* Analog watchdog out of range for channel 38. */
        vuint32_t AWOR_CH37:1;					 /* Analog watchdog out of range for channel 37. */
        vuint32_t AWOR_CH36:1;					 /* Analog watchdog out of range for channel 36. */
        vuint32_t AWOR_CH35:1;					 /* Analog watchdog out of range for channel 35. */
        vuint32_t AWOR_CH34:1;					 /* Analog watchdog out of range for channel 34. */
        vuint32_t AWOR_CH33:1;					 /* Analog watchdog out of range for channel 33. */
        vuint32_t AWOR_CH32:1;					 /* Analog watchdog out of range for channel 32. */
    } B;
  } AWORR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t AWOR_CH95:1;					 /* Analog watchdog out of range for channel 95. */
        vuint32_t AWOR_CH94:1;					 /* Analog watchdog out of range for channel 94. */
        vuint32_t AWOR_CH93:1;					 /* Analog watchdog out of range for channel 93. */
        vuint32_t AWOR_CH92:1;					 /* Analog watchdog out of range for channel 92. */
        vuint32_t AWOR_CH91:1;					 /* Analog watchdog out of range for channel 91. */
        vuint32_t AWOR_CH90:1;					 /* Analog watchdog out of range for channel 90. */
        vuint32_t AWOR_CH89:1;					 /* Analog watchdog out of range for channel 89. */
        vuint32_t AWOR_CH88:1;					 /* Analog watchdog out of range for channel 88. */
        vuint32_t AWOR_CH87:1;					 /* Analog watchdog out of range for channel 87. */
        vuint32_t AWOR_CH86:1;					 /* Analog watchdog out of range for channel 86. */
        vuint32_t AWOR_CH85:1;					 /* Analog watchdog out of range for channel 85. */
        vuint32_t AWOR_CH84:1;					 /* Analog watchdog out of range for channel 84. */
        vuint32_t AWOR_CH83:1;					 /* Analog watchdog out of range for channel 83. */
        vuint32_t AWOR_CH82:1;					 /* Analog watchdog out of range for channel 82. */
        vuint32_t AWOR_CH81:1;					 /* Analog watchdog out of range for channel 81. */
        vuint32_t AWOR_CH80:1;					 /* Analog watchdog out of range for channel 80. */
        vuint32_t AWOR_CH79:1;					 /* Analog watchdog out of range for channel 79. */
        vuint32_t AWOR_CH78:1;					 /* Analog watchdog out of range for channel 78. */
        vuint32_t AWOR_CH77:1;					 /* Analog watchdog out of range for channel 77. */
        vuint32_t AWOR_CH76:1;					 /* Analog watchdog out of range for channel 76. */
        vuint32_t AWOR_CH75:1;					 /* Analog watchdog out of range for channel 75. */
        vuint32_t AWOR_CH74:1;					 /* Analog watchdog out of range for channel 74. */
        vuint32_t AWOR_CH73:1;					 /* Analog watchdog out of range for channel 73. */
        vuint32_t AWOR_CH72:1;					 /* Analog watchdog out of range for channel 72. */
        vuint32_t AWOR_CH71:1;					 /* Analog watchdog out of range for channel 71. */
        vuint32_t AWOR_CH70:1;					 /* Analog watchdog out of range for channel 70. */
        vuint32_t AWOR_CH69:1;					 /* Analog watchdog out of range for channel 69. */
        vuint32_t AWOR_CH68:1;					 /* Analog watchdog out of range for channel 68. */
        vuint32_t AWOR_CH67:1;					 /* Analog watchdog out of range for channel 67. */
        vuint32_t AWOR_CH66:1;					 /* Analog watchdog out of range for channel 66. */
        vuint32_t AWOR_CH65:1;					 /* Analog watchdog out of range for channel 65. */
        vuint32_t AWOR_CH64:1;					 /* Analog watchdog out of range for channel 64. */
    } B;
  } AWORR2;

  uint8_t ADC_reserved13[68];
  union {
    vuint32_t R;
      struct {
        vuint32_t INPSAMP_C:8;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t INPSAMP_S:8;					 /*  */
        vuint32_t  :8;					 /*  */
    } B;
  } STCR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t MSKWDSERR:1;					 /*  */
        vuint32_t SERR:1;					 /* Error fault injection bit (write-only). Writing 1 to this bit sets the STSR1[ERRx] status bits once only. Reading always returns 0. Setting this bit does not affect any of the self test data registers */
        vuint32_t MSKWDTERR:1;					 /* Interrupt enable (STSR.WDTERR status bit) */
        vuint32_t  :1;					 /*  */
        vuint32_t MSKST_EOC:1;					 /* Interrupt Enable bit for STSR2.ST_EOC */
        vuint32_t  :4;					 /*  */
        vuint32_t MSKWDG_EOA_C:1;					 /* Interrupt enable (WDG_EOA_C status bit) */
        vuint32_t  :1;					 /*  */
        vuint32_t MSKWDG_EOA_S:1;					 /* Interrupt enable (WDG_EOA_S status bit) */
        vuint32_t MSKERR_C:1;					 /* Interrupt enable (ERR_C status bit) */
        vuint32_t  :1;					 /*  */
        vuint32_t MSKERR_S2:1;					 /* Interrupt enable (ERR_S2 status bit) */
        vuint32_t MSKERR_S1:1;					 /* Interrupt enable (ERR_S1 status bit) */
        vuint32_t MSKERR_S0:1;					 /* Interrupt enable (ERR_S1 status bit) */
        vuint32_t  :3;					 /*  */
        vuint32_t EN:1;					 /* Self testing channel enable. The TEST conversions are enabled. */
        vuint32_t  :2;					 /*  */
        vuint32_t FMA_WDSERR:1;					 /* Fault mapping for the Watchdog Sequence error. */
        vuint32_t FMA_WDTERR:1;					 /* Fault mapping for the Watchdog Timer error. */
        vuint32_t FMA_C:1;					 /* Fault mapping for self test algorithm C. */
        vuint32_t  :1;					 /*  */
        vuint32_t FMA_S:1;					 /* Fault mapping for the self test algorithm BGAP. */
    } B;
  } STCR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t ALG:2;					 /* Algorithm scheduling. */
        vuint32_t  :3;					 /*  */
        vuint32_t MSTEP:5;					 /*  */
    } B;
  } STCR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :13;					 /*  */
        vuint32_t WDT:3;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t BR:8;					 /* Baud rate for the selected algorithm in SCAN mode (MCR[MODE] = 1). */
    } B;
  } STBRR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t WDSERR:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t WDTERR:1;					 /*  */
        vuint32_t OVERWR:1;					 /* Overwrite error. */
        vuint32_t ST_EOC:1;					 /* Self Test EOC Bit. */
        vuint32_t  :4;					 /*  */
        vuint32_t WDG_EOA_C:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t WDG_EOA_S:1;					 /*  */
        vuint32_t ERR_C:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t ERR_S2:1;					 /*  */
        vuint32_t ERR_S1:1;					 /*  */
        vuint32_t ERR_S0:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t STEP_C:5;					 /* Step of the algorithm C when an ERR_C has occurred. */
        vuint32_t  :5;					 /*  */
    } B;
  } STSR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t OVFL:1;					 /* Overflow Bit */
        vuint32_t  :3;					 /*  */
        vuint32_t DATA1:12;					 /* Test channel converted data when the ERR_S1 has occurred. */
        vuint32_t  :4;					 /*  */
        vuint32_t DATA0:12;					 /* Test channel converted data when the ERR_S1 has occurred. */
    } B;
  } STSR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t DATA1:12;					 /* Test channel converted data when the ERR_S2 has occurred. */
        vuint32_t  :4;					 /*  */
        vuint32_t DATA0:12;					 /* Test channel converted data when the ERR_S0 has occurred. */
    } B;
  } STSR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t DATA1:12;					 /* Test channel converted data when the ERR_C has occurred. */
        vuint32_t  :4;					 /*  */
        vuint32_t  :12;					 /*  */
    } B;
  } STSR4;

  uint8_t ADC_reserved14[16];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t VALID:1;					 /* Valid data. */
        vuint32_t OWERWR:1;					 /* Overwrite data. */
        vuint32_t  :6;					 /*  */
        vuint32_t TCDATA:12;					 /* Test channel converted data. (In 2's complement format) */
    } B;
  } STDR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t FDATA:12;					 /*  */
        vuint32_t VALID:1;					 /* Valid data. */
        vuint32_t OWERWR:1;					 /* Overwrite data. */
        vuint32_t  :6;					 /*  */
        vuint32_t IDATA:12;					 /*  */
    } B;
  } STDR2;

  uint8_t ADC_reserved15[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t AWDE:1;					 /* Analog watchdog enable (related to the algorithm S (step 0)) */
        vuint32_t WDTE:1;					 /* Watchdog timer enable (related to the algorithm S) */
        vuint32_t  :2;					 /*  */
        vuint32_t THRH:12;					 /* High threshold value for channel 0. */
        vuint32_t  :4;					 /*  */
        vuint32_t THRL:12;					 /* Low threshold value for channel 0. */
    } B;
  } STAW0R;

  union {
    vuint32_t R;
      struct {
        vuint32_t AWDE:1;					 /* Analog watchdog enable related to the algorithm S (step1). */
        vuint32_t  :3;					 /*  */
        vuint32_t THRH:12;					 /* High threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
        vuint32_t  :4;					 /*  */
        vuint32_t THRL:12;					 /* Low threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
    } B;
  } STAW1AR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t THRH:12;					 /* High threshold value (fractional part) for test channel for algorithm S (step 1)(unsigned coding). */
        vuint32_t  :4;					 /*  */
        vuint32_t THRL:12;					 /* Low threshold value (fractional part) for test channel for algorithm S (step 1) (unsigned coding). */
    } B;
  } STAW1BR;

  union {
    vuint32_t R;
      struct {
        vuint32_t AWDE:1;					 /* Analog watchdog enable related to the algorithm S (step2). */
        vuint32_t  :19;					 /*  */
        vuint32_t THRL:12;					 /* Low threshold value for channel x (unsigned coding). If the analog watchdog is enabled, the STSR1.ERR_S2 status bit is set if STDR1.TCDATA < THRL. */
    } B;
  } STAW2R;

  uint8_t ADC_reserved16[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t AWDE:1;					 /* Analog watchdog enable (related to the algorithm C) */
        vuint32_t WDTE:1;					 /* Watchdog timer enable (related to the algorithm C). */
        vuint32_t  :2;					 /*  */
        vuint32_t THRH:12;					 /* High threshold value for channel sampled for C algorithm. */
        vuint32_t  :4;					 /*  */
        vuint32_t THRL:12;					 /* Low threshold value for channel sampled for the C self test algorithm. */
    } B;
  } STAW4R;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t THRH:12;					 /* High threshold value for the algorithm C (step1 to step CS-1). */
        vuint32_t  :4;					 /*  */
        vuint32_t THRL:12;					 /* Low threshold value for the algorithm C (step1 to step CS-1). */
    } B;
  } STAW5R;

  uint8_t ADC_reserved17[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t TSAMP:2;					 /* Test Sample period in Calibration, BIST and Offset calculation process. */
        vuint32_t  :3;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t C_T_BUSY:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :6;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NR_SMPL:2;					 /* Number of Samples for averaging. */
        vuint32_t AVG_EN:1;					 /* Average Enable (for Calibration only). */
        vuint32_t TEST_FAIL:1;					 /* Test Fail. */
        vuint32_t  :2;					 /*  */
        vuint32_t TEST_EN:1;					 /* Enable the test. */
    } B;
  } CALBISTREG;

  uint8_t ADC_reserved18[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :6;					 /*  */
        vuint32_t GAIN_USER:10;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t OFFSET_USER:8;					 /*  */
    } B;
  } OFSGNUSR;

  uint8_t ADC_reserved19[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t TEST_RESULT:16;					 /* Test Result for last failing test ($FIXED_VALUE - $RAW_SAR_DATA) */
        vuint32_t  :4;					 /*  */
        vuint32_t STAT_12:1;					 /* Status of test 12. */
        vuint32_t STAT_11:1;					 /* Status of test 11. */
        vuint32_t STAT_10:1;					 /* Status of test 10. */
        vuint32_t STAT_9:1;					 /* Status of test 9. */
        vuint32_t STAT_8:1;					 /* Status of test 8. */
        vuint32_t STAT_7:1;					 /* Status of test 7. */
        vuint32_t STAT_6:1;					 /* Status of test 6. */
        vuint32_t STAT_5:1;					 /* Status of test 5. */
        vuint32_t STAT_4:1;					 /* Status of test 4. */
        vuint32_t STAT_3:1;					 /* Status of test 3. */
        vuint32_t STAT_2:1;					 /* Status of test 2. */
        vuint32_t STAT_1:1;					 /* Status of test 1. */
    } B;
  } BIST1;

};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

struct AIPS_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MTR0:1;					 /* Master 0 Trusted For Read */
        vuint32_t MTW0:1;					 /* Master 0 Trusted For Writes */
        vuint32_t MPL0:1;					 /* Master 0 Privilege Level */
        vuint32_t  :1;					 /*  */
        vuint32_t MTR1:1;					 /* Master 1 trusted for read */
        vuint32_t MTW1:1;					 /* Master 1 trusted for writes */
        vuint32_t MPL1:1;					 /* Master 1 privilege level */
        vuint32_t  :4;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t MTR3:1;					 /* Master 3 Trusted For Read */
        vuint32_t MTW3:1;					 /* Master 3 Trusted For Writes */
        vuint32_t MPL3:1;					 /* Master 3 Privilege Level */
        vuint32_t  :1;					 /*  */
        vuint32_t MTR4:1;					 /* Master 4 Trusted For Read */
        vuint32_t MTW4:1;					 /* Master 4 Trusted For Writes */
        vuint32_t MPL4:1;					 /* Master 4 Privilege Level */
        vuint32_t  :4;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t MTR7:1;					 /* Master 7 trusted for read */
        vuint32_t MTW7:1;					 /* Master 7 trusted for writes */
        vuint32_t MPL7:1;					 /* Master 7 privilege level */
    } B;
  } MPRA;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t MTR9:1;					 /* Master 9 trusted for read */
        vuint32_t MTW9:1;					 /* Master 9 trusted for writes */
        vuint32_t MPL9:1;					 /* Master 9 privilege level */
        vuint32_t  :4;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t  :4;					 /*  */
    } B;
  } MPRB;

  uint8_t AIPS_reserved0[248];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } PACRA;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } PACRB;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } PACRC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } PACRD;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } PACR_Reserved;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } PACRF;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } PACRG;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } PACRH;

  uint8_t AIPS_reserved1[32];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRA;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRB;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRD;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRE;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRF;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRG;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRH;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRI;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRJ;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRK;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRL;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRM;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRN;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRO;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRP;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRQ;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRS;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRT;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRU;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRV;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRW;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRX;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRY;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRZ;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRAA;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRAB;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRAC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRAD;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRAE;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t SP0:1;					 /* Supervisor Protect */
        vuint32_t WP0:1;					 /* Write Protect */
        vuint32_t TP0:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP1:1;					 /* Supervisor Protect */
        vuint32_t WP1:1;					 /* Write Protect */
        vuint32_t TP1:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP2:1;					 /* Supervisor Protect */
        vuint32_t WP2:1;					 /* Write Protect */
        vuint32_t TP2:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP3:1;					 /* Supervisor Protect */
        vuint32_t WP3:1;					 /* Write Protect */
        vuint32_t TP3:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP4:1;					 /* Supervisor Protect */
        vuint32_t WP4:1;					 /* Write Protect */
        vuint32_t TP4:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP5:1;					 /* Supervisor Protect */
        vuint32_t WP5:1;					 /* Write Protect */
        vuint32_t TP5:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP6:1;					 /* Supervisor Protect */
        vuint32_t WP6:1;					 /* Write Protect */
        vuint32_t TP6:1;					 /* Trusted Protect */
        vuint32_t  :1;					 /*  */
        vuint32_t SP7:1;					 /* Supervisor Protect */
        vuint32_t WP7:1;					 /* Write Protect */
        vuint32_t TP7:1;					 /* Trusted Protect */
    } B;
  } OPACRAF;

};


/* ============================================================================
   =============================== Module: BCTU ===============================
   ============================================================================ */

struct BCTU_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze mode - for debug operation. */
        vuint32_t  :2;					 /*  */
        vuint32_t GTRGEN:1;					 /* Global Trigger Enable. */
        vuint32_t  :6;					 /*  */
        vuint32_t DMA3:1;					 /* ADC3DR data transferring by DMA. */
        vuint32_t DMA2:1;					 /* ADC2DR data transferring by DMA. */
        vuint32_t DMA1:1;					 /* ADC1DR data transferring by DMA. */
        vuint32_t DMA0:1;					 /* ADC0DR data transferring by DMA. */
        vuint32_t  :8;					 /*  */
        vuint32_t TRGEN:1;					 /* Trigger interrupt request enable. */
        vuint32_t  :1;					 /*  */
        vuint32_t LIST_IEN:1;					 /* LIST interrupt enable. */
        vuint32_t  :1;					 /*  */
        vuint32_t IEN3:1;					 /* Interrupt enable bit for ADC3DR new data. */
        vuint32_t IEN2:1;					 /* Interrupt enable bit for ADC2DR new data. */
        vuint32_t IEN1:1;					 /* Interrupt enable bit for ADC1DR new data. */
        vuint32_t IEN0:1;					 /* Interrupt enable bit for ADC0DR new data. */
    } B;
  } MCR;

  uint8_t BCTU_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t TRGF_CLR:1;					 /* TRGF clear */
        vuint32_t  :3;					 /*  */
        vuint32_t LIST3_Last_CLR:1;					 /*  */
        vuint32_t LIST2_Last_CLR:1;					 /*  */
        vuint32_t LIST1_Last_CLR:1;					 /*  */
        vuint32_t LIST0_Last_CLR:1;					 /*  */
        vuint32_t DATAOVR3_CLR:1;					 /* Clears DATAOVR3 flag */
        vuint32_t DATAOVR2_CLR:1;					 /* Clears DATAOVR2 flag */
        vuint32_t DATAOVR1_CLR:1;					 /* Clears DATAOVR1 flag */
        vuint32_t DATAOVR0_CLR:1;					 /* Clears DATAOVR0 flag */
        vuint32_t NDATA3_CLR:1;					 /*  */
        vuint32_t NDATA2_CLR:1;					 /* Clears NDATA2 flag */
        vuint32_t NDATA1_CLR:1;					 /* Clears NDATA1 flag */
        vuint32_t NDATA0_CLR:1;					 /* Clears NDATA0 flag */
        vuint32_t TRGF:1;					 /* Trigger Flag */
        vuint32_t  :3;					 /*  */
        vuint32_t LIST3_Last:1;					 /*  */
        vuint32_t LIST2_Last:1;					 /*  */
        vuint32_t LIST1_Last:1;					 /*  */
        vuint32_t LIST0_Last:1;					 /*  */
        vuint32_t DATAOVR3:1;					 /*  */
        vuint32_t DATAOVR2:1;					 /*  */
        vuint32_t DATAOVR1:1;					 /*  */
        vuint32_t DATAOVR0:1;					 /*  */
        vuint32_t NDATA3:1;					 /*  */
        vuint32_t NDATA2:1;					 /*  */
        vuint32_t NDATA1:1;					 /*  */
        vuint32_t NDATA0:1;					 /*  */
    } B;
  } MSR;

  uint8_t BCTU_reserved1[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t LOOP:1;					 /* LOOP bit */
        vuint32_t  :7;					 /*  */
        vuint32_t CCP:8;					 /* Conversion Configuration Pointer */
        vuint32_t TRIGEN:1;					 /* Trigger enable */
        vuint32_t TRG_FLAG:1;					 /*  */
        vuint32_t TRS:1;					 /* Trigger resolution */
        vuint32_t  :1;					 /*  */
        vuint32_t ADC_SEL3:1;					 /*  */
        vuint32_t ADC_SEL2:1;					 /*  */
        vuint32_t ADC_SEL1:1;					 /*  */
        vuint32_t ADC_SEL0:1;					 /*  */
        vuint32_t CHANNEL_VALUE_OR_LADDR:8;					 /*  */
    } B;
  } TRGCFG[32];

  uint8_t BCTU_reserved2[400];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :28;					 /*  */
        vuint32_t PROTEC_CODE:4;					 /* The Protection code sets protection for the write protected registers */
    } B;
  } WRPROT;

  union {
    vuint32_t R;
      struct {
        vuint32_t SFTRG:32;					 /*  */
    } B;
  } SFTRGR1;

  uint8_t BCTU_reserved3[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t TRG_SRC:8;					 /*  */
        vuint32_t CH:8;					 /*  */
        vuint32_t LIST:1;					 /*  */
        vuint32_t LAST:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t ADC_DATA:12;					 /*  */
    } B;
  } ADCDR[4];

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t LISTSZ:8;					 /*  */
    } B;
  } LISTSTAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t LAST_y:1;					 /* Last channel in the list of channels. */
        vuint32_t  :3;					 /*  */
        vuint32_t TAG_y:4;					 /* TAG for the n LIST element */
        vuint32_t ADC_CH_y:8;					 /*  */
        vuint32_t LAST_y_plus_1:1;					 /* Second to last channel in the list of channels. */
        vuint32_t  :3;					 /*  */
        vuint32_t TAG_y_plus_1:4;					 /* TAG for the [y+1] LIST element. */
        vuint32_t ADC_CHL_n_plus_1:8;					 /*  */
    } B;
  } LISTCHR[32];

  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t DEST:2;					 /* Destination selection */
        vuint32_t DADDR:4;					 /* Destination Address */
        vuint32_t TAG:4;					 /* The TAG field is used in the Parallel Side Port as the TAG bits. */
    } B;
  } CCR[11];

};


/* ============================================================================
   ============================== Module: C55FMC ==============================
   ============================================================================ */

struct C55FMC_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t RVE:1;					 /* Read Voltage Error */
        vuint32_t RRE:1;					 /* Read Reference Error */
        vuint32_t AEE:1;					 /* Address Encode Error */
        vuint32_t EEE:1;					 /* ECC after ECC Error */
        vuint32_t  :12;					 /*  */
        vuint32_t EER:1;					 /* ECC Event Error */
        vuint32_t RWE:1;					 /* Read-While-Write Event Error */
        vuint32_t SBC:1;					 /* Single Bit Correction */
        vuint32_t  :1;					 /*  */
        vuint32_t PEAS:1;					 /* Program Access Space */
        vuint32_t DONE:1;					 /* State Machine Status */
        vuint32_t PEG:1;					 /* Program/Erase Good */
        vuint32_t PECIE:1;					 /* Program/Erase Complete Interrupt Enable */
        vuint32_t  :1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t PGM:1;					 /* Program */
        vuint32_t PSUS:1;					 /* Program Suspend */
        vuint32_t ERS:1;					 /* Erase */
        vuint32_t ESUS:1;					 /* Erase Suspend */
        vuint32_t EHV:1;					 /* Enable High Voltage */
    } B;
  } MCR;

  uint8_t C55FMC_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t HT:1;					 /* High Temperature Enabled. */
        vuint32_t  :2;					 /*  */
        vuint32_t n256K:5;					 /*  */
        vuint32_t n64Kh:3;					 /*  */
        vuint32_t n32Kh:2;					 /*  */
        vuint32_t n16Kh:3;					 /*  */
        vuint32_t n64Km:3;					 /*  */
        vuint32_t n32Km:2;					 /*  */
        vuint32_t n16Km:3;					 /*  */
        vuint32_t n64Kl:3;					 /*  */
        vuint32_t n32Kl:2;					 /*  */
        vuint32_t n16Kl:3;					 /*  */
    } B;
  } MCRE;

  uint8_t C55FMC_reserved1[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t TSLOCK:1;					 /* UTest NVM Lock. */
        vuint32_t  :1;					 /*  */
        vuint32_t LOWLOCK:14;					 /* Low Block Lock */
        vuint32_t MIDLOCK:16;					 /* Mid Block Lock */
    } B;
  } LOCK0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t HIGHLOCK:16;					 /* High Block Lock */
    } B;
  } LOCK1;

  union {
    vuint32_t R;
      struct {
        vuint32_t A256KLOCK:32;					 /* 256 KB Block Lock */
    } B;
  } LOCK2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t A256KLOCK:16;					 /* 256 KB Block Lock */
    } B;
  } LOCK3;

  uint8_t C55FMC_reserved2[24];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :2;					 /*  */
        vuint32_t LOWSEL:14;					 /* LOW Block Select. */
        vuint32_t MIDSEL:16;					 /* Mid Block Select. */
    } B;
  } SEL0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t HIGHSEL:16;					 /* High Block Select. */
    } B;
  } SEL1;

  union {
    vuint32_t R;
      struct {
        vuint32_t A256KSEL:32;					 /* 256 KB Block Select. */
    } B;
  } SEL2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t A256KSEL:16;					 /* 256 KB Block Select. */
    } B;
  } SEL3;

  uint8_t C55FMC_reserved3[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t SAD:1;					 /*  */
        vuint32_t aH:1;					 /*  */
        vuint32_t aM:1;					 /*  */
        vuint32_t aL:1;					 /*  */
        vuint32_t a256k:1;					 /*  */
        vuint32_t a64k:1;					 /*  */
        vuint32_t a32k:1;					 /*  */
        vuint32_t a16k:1;					 /*  */
        vuint32_t ADDR:21;					 /*  */
        vuint32_t  :3;					 /*  */
    } B;
  } ADR;

  union {
    vuint32_t R;
      struct {
        vuint32_t UTE:1;					 /*  */
        vuint32_t SBCE:1;					 /*  */
        vuint32_t  :11;					 /*  */
        vuint32_t CPR:1;					 /*  */
        vuint32_t CPA:1;					 /*  */
        vuint32_t CPE:1;					 /*  */
        vuint32_t  :6;					 /*  */
        vuint32_t NAIBP:1;					 /*  */
        vuint32_t AIBPE:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t AISUS:1;					 /*  */
        vuint32_t MRE:1;					 /*  */
        vuint32_t MRV:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t AIS:1;					 /*  */
        vuint32_t AIE:1;					 /*  */
        vuint32_t AID:1;					 /*  */
    } B;
  } UT0;

  union {
    vuint32_t R;
      struct {
        vuint32_t MISR:32;					 /*  */
    } B;
  } UM[10];

  union {
    vuint32_t R;
      struct {
        vuint32_t  :2;					 /*  */
        vuint32_t LOWOPP:14;					 /* Low Block Over-Program Protection[13:0]. */
        vuint32_t MIDOPP:16;					 /* Mid Block Over-Program Protection[15:0]. */
    } B;
  } OPP0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t HIGHOPP:16;					 /* High Block Over-Program Protection[15:0]. */
    } B;
  } OPP1;

  union {
    vuint32_t R;
      struct {
        vuint32_t A256KOPP:32;					 /* 256K Block Over-Program Protection[31:0]. */
    } B;
  } OPP2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t A256KOPP:16;					 /* 256K Block Over-Program Protection[47:32]. */
    } B;
  } OPP3;

};


/* ============================================================================
   =============================== Module: CAN ================================
   ============================================================================ */

struct CAN_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze Enable */
        vuint32_t RFEN:1;					 /* Rx FIFO Enable */
        vuint32_t HALT:1;					 /* Halt FlexCAN */
        vuint32_t NOTRDY:1;					 /* FlexCAN Not Ready */
        vuint32_t  :1;					 /*  */
        vuint32_t SOFTRST:1;					 /* Soft Reset */
        vuint32_t FRZACK:1;					 /* Freeze Mode Acknowledge */
        vuint32_t SUPV:1;					 /* Supervisor Mode */
        vuint32_t  :1;					 /*  */
        vuint32_t WRNEN:1;					 /* Warning Interrupt Enable */
        vuint32_t LPMACK:1;					 /* Low-Power Mode Acknowledge */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t SRXDIS:1;					 /* Self Reception Disable */
        vuint32_t IRMQ:1;					 /* Individual Rx Masking And Queue Enable */
        vuint32_t DMA:1;					 /* DMA Enable */
        vuint32_t  :1;					 /*  */
        vuint32_t LPRIOEN:1;					 /* Local Priority Enable */
        vuint32_t AEN:1;					 /* Abort Enable */
        vuint32_t  :2;					 /*  */
        vuint32_t IDAM:2;					 /* ID Acceptance Mode */
        vuint32_t  :1;					 /*  */
        vuint32_t MAXMB:7;					 /* Number Of The Last Message Buffer */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t PRESDIV:8;					 /* Prescaler Division Factor */
        vuint32_t RJW:2;					 /* Resync Jump Width */
        vuint32_t PSEG1:3;					 /* Phase Segment 1 */
        vuint32_t PSEG2:3;					 /* Phase Segment 2 */
        vuint32_t BOFFMSK:1;					 /* Bus Off Mask */
        vuint32_t ERRMSK:1;					 /* Error Mask */
        vuint32_t CLKSRC:1;					 /* CAN Engine Clock Source */
        vuint32_t LPB:1;					 /* Loop Back Mode */
        vuint32_t TWRNMSK:1;					 /* Tx Warning Interrupt Mask */
        vuint32_t RWRNMSK:1;					 /* Rx Warning Interrupt Mask */
        vuint32_t  :2;					 /*  */
        vuint32_t SMP:1;					 /* CAN Bit Sampling */
        vuint32_t BOFFREC:1;					 /* Bus Off Recovery */
        vuint32_t TSYN:1;					 /* Timer Sync */
        vuint32_t LBUF:1;					 /* Lowest Buffer Transmitted First */
        vuint32_t LOM:1;					 /* Listen-Only Mode */
        vuint32_t PROPSEG:3;					 /* Propagation Segment */
    } B;
  } CTRL1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t TIMER:16;					 /* Timer Value */
    } B;
  } TIMER;

  uint8_t CAN_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t MG:32;					 /* Rx Mailboxes Global Mask Bits */
    } B;
  } RXMGMASK;

  union {
    vuint32_t R;
      struct {
        vuint32_t RX14M:32;					 /* Rx Buffer 14 Mask Bits */
    } B;
  } RX14MASK;

  union {
    vuint32_t R;
      struct {
        vuint32_t RX15M:32;					 /* Rx Buffer 15 Mask Bits */
    } B;
  } RX15MASK;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t RXERRCNT:8;					 /* Receive Error Counter */
        vuint32_t TXERRCNT:8;					 /* Transmit Error Counter */
    } B;
  } ECR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :13;					 /*  */
        vuint32_t SYNCH:1;					 /* CAN Synchronization Status */
        vuint32_t TWRNINT:1;					 /* Tx Warning Interrupt Flag */
        vuint32_t RWRNINT:1;					 /* Rx Warning Interrupt Flag */
        vuint32_t BIT1ERR:1;					 /* Bit1 Error */
        vuint32_t BIT0ERR:1;					 /* Bit0 Error */
        vuint32_t ACKERR:1;					 /* Acknowledge Error */
        vuint32_t CRCERR:1;					 /* Cyclic Redundancy Check Error */
        vuint32_t FRMERR:1;					 /* Form Error */
        vuint32_t STFERR:1;					 /* Stuffing Error */
        vuint32_t TXWRN:1;					 /* TX Error Warning */
        vuint32_t RXWRN:1;					 /* Rx Error Warning */
        vuint32_t IDLE:1;					 /*  */
        vuint32_t TX:1;					 /* FlexCAN In Transmission */
        vuint32_t FLTCONF:2;					 /* Fault Confinement State */
        vuint32_t RX:1;					 /* FlexCAN In Reception */
        vuint32_t BOFFINT:1;					 /* Bus Off Interrupt */
        vuint32_t ERRINT:1;					 /* Error Interrupt */
        vuint32_t  :1;					 /*  */
    } B;
  } ESR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t BUFHM:32;					 /* Buffer MB i Mask */
    } B;
  } IMASK2;

  union {
    vuint32_t R;
      struct {
        vuint32_t BUFLM:32;					 /* Buffer MB i Mask */
    } B;
  } IMASK1;

  union {
    vuint32_t R;
      struct {
        vuint32_t BUFHI:32;					 /* Buffer MB i Interrupt */
    } B;
  } IFLAG2;

  union {
    vuint32_t R;
      struct {
        vuint32_t BUF31TO8I:24;					 /* Buffer MBi Interrupt */
        vuint32_t BUF7I:1;					 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
        vuint32_t BUF6I:1;					 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
        vuint32_t BUF5I:1;					 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
        vuint32_t BUF4TO1I:4;					 /* Buffer MB i Interrupt Or "reserved" */
        vuint32_t BUF0I:1;					 /* Buffer MB0 Interrupt Or Clear FIFO bit */
    } B;
  } IFLAG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :2;					 /*  */
        vuint32_t ECRWRE:1;					 /* Error-correction Configuration Register Write Enable */
        vuint32_t WRMFRZ:1;					 /* Write-Access To Memory In Freeze Mode */
        vuint32_t RFFN:4;					 /* Number Of Rx FIFO Filters */
        vuint32_t TASD:5;					 /* Tx Arbitration Start Delay */
        vuint32_t MRP:1;					 /* Mailboxes Reception Priority */
        vuint32_t RRS:1;					 /* Remote Request Storing */
        vuint32_t EACEN:1;					 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
        vuint32_t  :16;					 /*  */
    } B;
  } CTRL2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :9;					 /*  */
        vuint32_t LPTM:7;					 /* Lowest Priority Tx Mailbox */
        vuint32_t  :1;					 /*  */
        vuint32_t VPS:1;					 /* Valid Priority Status */
        vuint32_t IMB:1;					 /* Inactive Mailbox */
        vuint32_t  :13;					 /*  */
    } B;
  } ESR2;

  uint8_t CAN_reserved1[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :9;					 /*  */
        vuint32_t MBCRC:7;					 /* CRC Mailbox */
        vuint32_t  :1;					 /*  */
        vuint32_t TXCRC:15;					 /* CRC Transmitted */
    } B;
  } CRCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t FGM:32;					 /* Rx FIFO Global Mask Bits */
    } B;
  } RXFGMASK;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :23;					 /*  */
        vuint32_t IDHIT:9;					 /* Identifier Acceptance Filter Hit Indicator */
    } B;
  } RXFIR;

  uint8_t CAN_reserved2[48];
    
  struct MB_t
    {
        union {
            vuint32_t R;
            struct {
                vuint32_t:4;
                vuint32_t CODE:4;
                vuint32_t:1;
                vuint32_t SRR:1;
                vuint32_t IDE:1;
                vuint32_t RTR:1;
                vuint32_t DLC:4;
                vuint32_t TIMESTAMP:16;
            } B;
        } CS;
        
        vuint32_t ID;
        
        union {
            vuint8_t  B[8];
            vuint16_t H[4];
            vuint32_t W[2];
        } DATA;
        
    } MB[64];
    
  uint8_t CAN_reserved2a[1024];

  union {
    vuint32_t R;
      struct {
        vuint32_t MI:32;					 /* Individual Mask Bits */
    } B;
  } RXIMR[64];

  uint8_t CAN_reserved3[352];
  union {
    vuint32_t R;
      struct {
        vuint32_t ECRWRDIS:1;					 /* Error Configuration Register Write Disable */
        vuint32_t  :11;					 /*  */
        vuint32_t HANCEI_MSK:1;					 /* Host Access With Non-Correctable Errors Interrupt Mask */            
        vuint32_t FANCEI_MSK:1;					 /* FlexCAN Access With Non-Correctable Errors Interrupt Mask */
        vuint32_t  :1;					 /*  */
        vuint32_t CEI_MSK:1;					 /* Correctable Errors Interrupt Mask */
        vuint32_t HAERRIE:1;					 /* Host Access Error Injection Enable */
        vuint32_t FAERRIE:1;					 /* FlexCAN Access Error Injection Enable */
        vuint32_t EXTERRIE:1;					 /* Extended Error Injection Enable */
        vuint32_t  :3;					 /*  */
        vuint32_t RERRDIS:1;					 /* Error Report Disable */
        vuint32_t ECCDIS:1;					 /* Error Correction Disable */
        vuint32_t NCEFAFRZ:1;					 /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
        vuint32_t  :7;					 /*  */
    } B;
  } MECR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :18;					 /*  */
        vuint32_t INJADDR:14;					 /* Address Where Error Is To Be Injected */
    } B;
  } ERRIAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t DFLIP:32;					 /* Data flip pattern */
    } B;
  } ERRIDPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :3;					 /*  */
        vuint32_t PFLIP3:5;					 /* Parity Flip Pattern For Byte 3 (most significant) */
        vuint32_t  :3;					 /*  */
        vuint32_t PFLIP2:5;					 /* Parity Flip Pattern For Byte 2 */
        vuint32_t  :3;					 /*  */
        vuint32_t PFLIP1:5;					 /* Parity Flip Pattern For Byte 1 */
        vuint32_t  :3;					 /*  */
        vuint32_t PFLIP0:5;					 /* Parity Flip Pattern For Byte 0 (Least Significant) */
    } B;
  } ERRIPPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t NCE:1;					 /* Non-Correctable Error */
        vuint32_t  :5;					 /*  */
        vuint32_t SAID:3;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t ERRADDR:14;					 /* Address Where The Error Was Detected */
    } B;
  } RERRAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t RDATA:32;					 /* Raw data word read from memory with error */
    } B;
  } RERRDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t BE3:1;					 /* Byte Enabled For Byte 3 (Most Significant) */
        vuint32_t  :2;					 /*  */
        vuint32_t SYND3:5;					 /* Error Syndrome For Byte 3 (Most Significant) */
        vuint32_t BE2:1;					 /* Byte Enabled For Byte 2 */
        vuint32_t  :2;					 /*  */
        vuint32_t SYND2:5;					 /* Error Syndrome For Byte 2 */
        vuint32_t BE1:1;					 /* Byte Enabled For Byte 1 */
        vuint32_t  :2;					 /*  */
        vuint32_t SYND1:5;					 /* Error Syndrome for Byte 1 */
        vuint32_t BE0:1;					 /* Byte Enabled For Byte 0 (least significant) */
        vuint32_t  :2;					 /*  */
        vuint32_t SYND0:5;					 /* Error Syndrome For Byte 0 (least significant) */
    } B;
  } RERRSYNR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t HANCEIF:1;					 /* Host Access With Non-Correctable Error Interrupt Flag */
        vuint32_t FANCEIF:1;					 /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
        vuint32_t  :1;					 /*  */
        vuint32_t CEIF:1;					 /* Correctable Error Interrupt Flag */
        vuint32_t  :12;					 /*  */
        vuint32_t HANCEIOF:1;					 /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
        vuint32_t FANCEIOF:1;					 /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
        vuint32_t  :1;					 /*  */
        vuint32_t CEIOF:1;					 /* Correctable Error Interrupt Overrun Flag */
    } B;
  } ERRSR;

};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

struct CMU_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t SFM:1;					 /* Start frequency measure. */
        vuint32_t  :13;					 /*  */
        vuint32_t CKSEL1:2;					 /* Frequency measure clock selection bit. */
        vuint32_t  :5;					 /*  */
        vuint32_t RCDIV:2;					 /* CLKMT0_RMN division factor. */
        vuint32_t CME:1;					 /* CLKMN1 monitor enable. */
    } B;
  } CSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t FD:20;					 /* Measured frequency bits */
    } B;
  } FDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t HFREF:12;					 /* High Frequency reference value. */
    } B;
  } HFREFR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t LFREF:12;					 /* Low Frequency reference value. */
    } B;
  } LFREFR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :28;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t FHHI:1;					 /* CLKMN1 frequency higher than high reference event status */
        vuint32_t FLLI:1;					 /* CLKMN1 frequency less than low reference event status */
        vuint32_t OLRI:1;					 /* Oscillator frequency less than f CLKMT0_RMN * 2RCDIVevent status */
    } B;
  } ISR;

  uint8_t CMU_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t MD:20;					 /* Measurement duration bits */
    } B;
  } MDR;

};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

struct CRC_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t  :18;					 /*  */
        vuint32_t SWAP_BYTEWISE:1;					 /* Swap CRC_INP byte-wise */
        vuint32_t SWAP_BITWISE:1;					 /* Swap CRC_INP bit-wise */
        vuint32_t POLYG:2;					 /* Polynomial selection */
        vuint32_t SWAP:1;					 /* Swap selection */
        vuint32_t INV:1;					 /* Inversion selection */
    } B;
  } CFG;

  union {
    vuint32_t R;
      struct {
        vuint32_t INP:32;					 /* Input data for the CRC computation */
    } B;
  } INP;

  union {
    vuint32_t R;
      struct {
        vuint32_t CSTAT:32;					 /* CRC signature status */
    } B;
  } CSTAT;

  union {
    vuint32_t R;
      struct {
        vuint32_t OUTP:32;					 /* Final CRC signature */
    } B;
  } OUTP;

};


/* ============================================================================
   ============================ Module: DECFILTER =============================
   ============================================================================ */

struct DECFILTER_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FREN:1;					 /* Freeze Enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FRZ:1;					 /* Freeze Mode */
        vuint32_t SRES:1;					 /* Software-reset bit */
        vuint32_t CASCD:2;					 /* Cascade Mode Configuration */
        vuint32_t IDEN:1;					 /* Input Data Interrupt Enable */
        vuint32_t ODEN:1;					 /* Output Data Interrupt Enable */
        vuint32_t ERREN:1;					 /* Error Interrupt Enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FTYPE:2;					 /* Filter Type Selection bits */
        vuint32_t  :1;					 /*  */
        vuint32_t SCAL:2;					 /* Filter Scaling Factor */
        vuint32_t IDIS:1;					 /* Input Disable */
        vuint32_t SAT:1;					 /* Saturation Enable */
        vuint32_t ISEL:1;					 /* Input Selection */
        vuint32_t  :1;					 /*  */
        vuint32_t DEC_RATE:4;					 /* Decimation Rate Selection */
        vuint32_t SDIE:1;					 /* Integrator Data Interrupt Enable */
        vuint32_t DSEL:1;					 /* DMA Selection */
        vuint32_t IBIE:1;					 /* Input Buffer Interrupt Request Enable */
        vuint32_t OBIE:1;					 /* Output Buffer Interrupt Request Enable */
        vuint32_t  :4;					 /*  */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t BSY:1;					 /* Decimation Filter Busy indication */
        vuint32_t  :1;					 /*  */
        vuint32_t DEC_COUNTER:4;					 /* Decimation Counter */
        vuint32_t IDFC:1;					 /* Input Data Flag Clear bit */
        vuint32_t ODFC:1;					 /* Output Data Flag Clear bit */
        vuint32_t  :1;					 /*  */
        vuint32_t IBIC:1;					 /* Input Buffer Interrupt Request Clear bit */
        vuint32_t OBIC:1;					 /* Output Buffer Interrupt Request Clear bit */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t OVFC:1;					 /* OVF Clear bit */
        vuint32_t OVRC:1;					 /* OVR Clear bit */
        vuint32_t IVRC:1;					 /* IVR Clear bit */
        vuint32_t  :6;					 /*  */
        vuint32_t IDF:1;					 /* Input Data Flag */
        vuint32_t ODF:1;					 /* Output Data Flag */
        vuint32_t  :1;					 /*  */
        vuint32_t IBIF:1;					 /* Input Buffer Interrupt Request Flag */
        vuint32_t OBIF:1;					 /* Output Buffer Interrupt Request Flag */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t OVF:1;					 /* Filter Overflow Flag */
        vuint32_t OVR:1;					 /* Output Interface Buffer Overrun */
        vuint32_t IVR:1;					 /* Input Interface Buffer Overrun */
    } B;
  } MSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t SDMAE:1;					 /* Integrator DMA Enable */
        vuint32_t SSIG:1;					 /* Integrator Signal operation selection */
        vuint32_t SSAT:1;					 /* Integrator Saturated operation selection */
        vuint32_t SCSAT:1;					 /* Integrator Counter Saturated operation selection */
        vuint32_t  :10;					 /*  */
        vuint32_t SRQ:1;					 /* Integrator Output Request */
        vuint32_t SZRO:1;					 /* Integrator Zero */
        vuint32_t SISEL:1;					 /* Integrator Input Selection */
        vuint32_t  :1;					 /*  */
        vuint32_t SZROSEL:2;					 /* Integrator Zero Control Mode Selection */
        vuint32_t  :2;					 /*  */
        vuint32_t SHLTSEL:2;					 /* Integrator Halt Control Selection */
        vuint32_t  :1;					 /*  */
        vuint32_t SRQSEL:3;					 /* Integrator Output Read Request Mode Selection */
        vuint32_t  :2;					 /*  */
        vuint32_t SENSEL:2;					 /* Integrator Enable Control Selection */
    } B;
  } MXCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t SDFC:1;					 /* Integrator Output Data Flag Clear bit */
        vuint32_t  :2;					 /*  */
        vuint32_t SSEC:1;					 /* Integrator Sum Exception Clear bit */
        vuint32_t SCEC:1;					 /* Integrator Count Exception Clear bit */
        vuint32_t  :1;					 /*  */
        vuint32_t SSOVFC:1;					 /* Integrator Sum Overflow Clear bit */
        vuint32_t SCOVFC:1;					 /* Integrator Count Overflow Clear bit */
        vuint32_t SVRC:1;					 /* SVR Clear bit */
        vuint32_t  :7;					 /*  */
        vuint32_t SDF:1;					 /* Integrator Data Flag */
        vuint32_t  :2;					 /*  */
        vuint32_t SSE:1;					 /* Integrator Sum Exception flag */
        vuint32_t SCE:1;					 /* Integrator Count Exception flag */
        vuint32_t  :1;					 /*  */
        vuint32_t SSOVF:1;					 /* Integrator Sum Overflow Flag */
        vuint32_t SCOVF:1;					 /* Integrator Count Overflow Flag */
        vuint32_t SVR:1;					 /* Integrator Data Overrun */
    } B;
  } MXSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t INTAG:4;					 /* Decimation filter input tag bits */
        vuint32_t  :6;					 /*  */
        vuint32_t PREFILL:1;					 /* Decimation Filter Prefill/Filter control bit */
        vuint32_t FLUSH:1;					 /* Decimation Filter Flush control bit */
        vuint32_t INPBUF:16;					 /* Input Buffer Data */
    } B;
  } IB;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :11;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t OUTTAG:4;					 /* Decimation filter output tag bits */
        vuint32_t OUTBUF:16;					 /* Output Buffer Data */
    } B;
  } OB;

  uint8_t DECFILTER_reserved0[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t COEFn23R:8;					 /* COEFn23 repeated */
        vuint32_t COEFn:24;					 /* Coefficient n field */
    } B;
  } COEF[9];

  uint8_t DECFILTER_reserved1[52];
  union {
    vuint32_t R;
      struct {
        vuint32_t TAPn23R:8;					 /* TAPn23 repeated */
        vuint32_t TAPn:24;					 /* TAPn Register */
    } B;
  } TAP[8];

  uint8_t DECFILTER_reserved2[72];
  union {
    vuint32_t R;
      struct {
        vuint32_t SUM_VALUE:32;					 /* Integration Sum Value */
    } B;
  } FINTVAL;

  union {
    vuint32_t R;
      struct {
        vuint32_t COUNT:32;					 /* Integration Count Value */
    } B;
  } FINTCNT;

  union {
    vuint32_t R;
      struct {
        vuint32_t SUM_VALUE:32;					 /* Integration Sum Value */
    } B;
  } CINTVAL;

  union {
    vuint32_t R;
      struct {
        vuint32_t COUNT:32;					 /* Integration Count Value */
    } B;
  } CINTCNT;

};


/* ============================================================================
   ============================== Module: DMAMUX ==============================
   ============================================================================ */

struct DMAMUX_tag {
  union {
    vuint8_t R;
      struct {
        vuint8_t ENBL:1;					 /* DMA Channel Enable */
        vuint8_t TRIG:1;					 /* DMA Channel Trigger Enable */
        vuint8_t SOURCE:6;					 /* DMA Channel Source (Slot) */
    } B;
  } CHCFG[16];

};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

struct DMA_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :14;					 /*  */
        vuint32_t CX:1;					 /* Cancel Transfer */
        vuint32_t ECX:1;					 /* Error Cancel Transfer */
        vuint32_t GRP3PRI:2;					 /* Channel Group 3 Priority */
        vuint32_t GRP2PRI:2;					 /* Channel Group 2 Priority */
        vuint32_t GRP1PRI:2;					 /* Channel Group 1 Priority */
        vuint32_t GRP0PRI:2;					 /* Channel Group 0 Priority */
        vuint32_t EMLM:1;					 /* Enable Minor Loop Mapping. */
        vuint32_t CLM:1;					 /* Continuous Link Mode */
        vuint32_t HALT:1;					 /* Halt DMA Operations */
        vuint32_t HOE:1;					 /* Halt On Error */
        vuint32_t ERGA:1;					 /* Enable Round Robin Group Arbitration */
        vuint32_t ERCA:1;					 /* Enable Round Robin Channel Arbitration */
        vuint32_t EDBG:1;					 /* Enable Debug */
        vuint32_t EBW:1;					 /* Enable Buffered Writes */
    } B;
  } CR;

  union {
    vuint32_t R;
      struct {
        vuint32_t VLD:1;					 /*  */
        vuint32_t  :13;					 /*  */
        vuint32_t UCE:1;					 /* Uncorrectable ECC error. */
        vuint32_t ECX:1;					 /* Transfer Canceled. */
        vuint32_t GPE:1;					 /* Group Priority Error. */
        vuint32_t CPE:1;					 /* Channel Priority Error. */
        vuint32_t ERRCHN:6;					 /* Error/Cancelled Channel Number. */
        vuint32_t SAE:1;					 /* Source Address Error. */
        vuint32_t SOE:1;					 /* Source Offset Error */
        vuint32_t DAE:1;					 /* Destination Address Error. */
        vuint32_t DOE:1;					 /* Destination Offset Error. */
        vuint32_t NCE:1;					 /* NBYTES/CITER Configuration Error. */
        vuint32_t SGE:1;					 /* Scatter/Gather Configuration Error. */
        vuint32_t SBE:1;					 /* Source Bus Error. */
        vuint32_t DBE:1;					 /* Destination Bus Error. */
    } B;
  } ES;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERQ63:1;					 /* Enable DMA Request 63 */
        vuint32_t ERQ62:1;					 /* Enable DMA Request 62 */
        vuint32_t ERQ61:1;					 /* Enable DMA Request 61 */
        vuint32_t ERQ60:1;					 /* Enable DMA Request 60 */
        vuint32_t ERQ59:1;					 /* Enable DMA Request 59 */
        vuint32_t ERQ58:1;					 /* Enable DMA Request 58 */
        vuint32_t ERQ57:1;					 /* Enable DMA Request 57 */
        vuint32_t ERQ56:1;					 /* Enable DMA Request 56 */
        vuint32_t ERQ55:1;					 /* Enable DMA Request 55 */
        vuint32_t ERQ54:1;					 /* Enable DMA Request 54 */
        vuint32_t ERQ53:1;					 /* Enable DMA Request 53 */
        vuint32_t ERQ52:1;					 /* Enable DMA Request 52 */
        vuint32_t ERQ51:1;					 /* Enable DMA Request 51 */
        vuint32_t ERQ50:1;					 /* Enable DMA Request 50 */
        vuint32_t ERQ49:1;					 /* Enable DMA Request 49 */
        vuint32_t ERQ48:1;					 /* Enable DMA Request 48 */
        vuint32_t ERQ47:1;					 /* Enable DMA Request 47 */
        vuint32_t ERQ46:1;					 /* Enable DMA Request 46 */
        vuint32_t ERQ45:1;					 /* Enable DMA Request 45 */
        vuint32_t ERQ44:1;					 /* Enable DMA Request 44 */
        vuint32_t ERQ43:1;					 /* Enable DMA Request 43 */
        vuint32_t ERQ42:1;					 /* Enable DMA Request 42 */
        vuint32_t ERQ41:1;					 /* Enable DMA Request 41 */
        vuint32_t ERQ40:1;					 /* Enable DMA Request 40 */
        vuint32_t ERQ39:1;					 /* Enable DMA Request 39 */
        vuint32_t ERQ38:1;					 /* Enable DMA Request 38 */
        vuint32_t ERQ37:1;					 /* Enable DMA Request 37 */
        vuint32_t ERQ36:1;					 /* Enable DMA Request 36 */
        vuint32_t ERQ35:1;					 /* Enable DMA Request 35 */
        vuint32_t ERQ34:1;					 /* Enable DMA Request 34 */
        vuint32_t ERQ33:1;					 /* Enable DMA Request 33 */
        vuint32_t ERQ32:1;					 /* Enable DMA Request 32 */
    } B;
  } ERQH;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERQ31:1;					 /* Enable DMA Request 31 */
        vuint32_t ERQ30:1;					 /* Enable DMA Request 30 */
        vuint32_t ERQ29:1;					 /* Enable DMA Request 29 */
        vuint32_t ERQ28:1;					 /* Enable DMA Request 28 */
        vuint32_t ERQ27:1;					 /* Enable DMA Request 27 */
        vuint32_t ERQ26:1;					 /* Enable DMA Request 26 */
        vuint32_t ERQ25:1;					 /* Enable DMA Request 25 */
        vuint32_t ERQ24:1;					 /* Enable DMA Request 24 */
        vuint32_t ERQ23:1;					 /* Enable DMA Request 23 */
        vuint32_t ERQ22:1;					 /* Enable DMA Request 22 */
        vuint32_t ERQ21:1;					 /* Enable DMA Request 21 */
        vuint32_t ERQ20:1;					 /* Enable DMA Request 20 */
        vuint32_t ERQ19:1;					 /* Enable DMA Request 19 */
        vuint32_t ERQ18:1;					 /* Enable DMA Request 18 */
        vuint32_t ERQ17:1;					 /* Enable DMA Request 17 */
        vuint32_t ERQ16:1;					 /* Enable DMA Request 16 */
        vuint32_t ERQ15:1;					 /* Enable DMA Request 15 */
        vuint32_t ERQ14:1;					 /* Enable DMA Request 14 */
        vuint32_t ERQ13:1;					 /* Enable DMA Request 13 */
        vuint32_t ERQ12:1;					 /* Enable DMA Request 12 */
        vuint32_t ERQ11:1;					 /* Enable DMA Request 11 */
        vuint32_t ERQ10:1;					 /* Enable DMA Request 10 */
        vuint32_t ERQ9:1;					 /* Enable DMA Request 9 */
        vuint32_t ERQ8:1;					 /* Enable DMA Request 8 */
        vuint32_t ERQ7:1;					 /* Enable DMA Request 7 */
        vuint32_t ERQ6:1;					 /* Enable DMA Request 6 */
        vuint32_t ERQ5:1;					 /* Enable DMA Request 5 */
        vuint32_t ERQ4:1;					 /* Enable DMA Request 4 */
        vuint32_t ERQ3:1;					 /* Enable DMA Request 3 */
        vuint32_t ERQ2:1;					 /* Enable DMA Request 2 */
        vuint32_t ERQ1:1;					 /* Enable DMA Request 1 */
        vuint32_t ERQ0:1;					 /* Enable DMA Request 0 */
    } B;
  } ERQL;

  union {
    vuint32_t R;
      struct {
        vuint32_t EEI63:1;					 /* Enable Error Interrupt 63 */
        vuint32_t EEI62:1;					 /* Enable Error Interrupt 62 */
        vuint32_t EEI61:1;					 /* Enable Error Interrupt 61 */
        vuint32_t EEI60:1;					 /* Enable Error Interrupt 60 */
        vuint32_t EEI59:1;					 /* Enable Error Interrupt 59 */
        vuint32_t EEI58:1;					 /* Enable Error Interrupt 58 */
        vuint32_t EEI57:1;					 /* Enable Error Interrupt 57 */
        vuint32_t EEI56:1;					 /* Enable Error Interrupt 56 */
        vuint32_t EEI55:1;					 /* Enable Error Interrupt 55 */
        vuint32_t EEI54:1;					 /* Enable Error Interrupt 54 */
        vuint32_t EEI53:1;					 /* Enable Error Interrupt 53 */
        vuint32_t EEI52:1;					 /* Enable Error Interrupt 52 */
        vuint32_t EEI51:1;					 /* Enable Error Interrupt 51 */
        vuint32_t EEI50:1;					 /* Enable Error Interrupt 50 */
        vuint32_t EEI49:1;					 /* Enable Error Interrupt 49 */
        vuint32_t EEI48:1;					 /* Enable Error Interrupt 48 */
        vuint32_t EEI47:1;					 /* Enable Error Interrupt 47 */
        vuint32_t EEI46:1;					 /* Enable Error Interrupt 46 */
        vuint32_t EEI45:1;					 /* Enable Error Interrupt 45 */
        vuint32_t EEI44:1;					 /* Enable Error Interrupt 44 */
        vuint32_t EEI43:1;					 /* Enable Error Interrupt 43 */
        vuint32_t EEI42:1;					 /* Enable Error Interrupt 42 */
        vuint32_t EEI41:1;					 /* Enable Error Interrupt 41 */
        vuint32_t EEI40:1;					 /* Enable Error Interrupt 40 */
        vuint32_t EEI39:1;					 /* Enable Error Interrupt 39 */
        vuint32_t EEI38:1;					 /* Enable ErrorInterrupt 38 */
        vuint32_t EEI37:1;					 /* Enable Error Interrupt 37 */
        vuint32_t EEI36:1;					 /* Enable Error Interrupt 36 */
        vuint32_t EEI35:1;					 /* Enable Error Interrupt 35 */
        vuint32_t EEI34:1;					 /* Enable Error Interrupt 34 */
        vuint32_t EEI33:1;					 /* Enable Error Interrupt 33 */
        vuint32_t EEI32:1;					 /* Enable Error Interrupt 32 */
    } B;
  } EEIH;

  union {
    vuint32_t R;
      struct {
        vuint32_t EEI31:1;					 /* Enable Error Interrupt 31 */
        vuint32_t EEI30:1;					 /* Enable Error Interrupt 30 */
        vuint32_t EEI29:1;					 /* Enable Error Interrupt 29 */
        vuint32_t EEI28:1;					 /* Enable Error Interrupt 28 */
        vuint32_t EEI27:1;					 /* Enable Error Interrupt 27 */
        vuint32_t EEI26:1;					 /* Enable Error Interrupt 26 */
        vuint32_t EEI25:1;					 /* Enable Error Interrupt 25 */
        vuint32_t EEI24:1;					 /* Enable Error Interrupt 24 */
        vuint32_t EEI23:1;					 /* Enable Error Interrupt 23 */
        vuint32_t EEI22:1;					 /* Enable Error Interrupt 22 */
        vuint32_t EEI21:1;					 /* Enable Error Interrupt 21 */
        vuint32_t EEI20:1;					 /* Enable Error Interrupt 20 */
        vuint32_t EEI19:1;					 /* Enable Error Interrupt 19 */
        vuint32_t EEI18:1;					 /* Enable Error Interrupt 18 */
        vuint32_t EEI17:1;					 /* Enable Error Interrupt 17 */
        vuint32_t EEI16:1;					 /* Enable Error Interrupt 16 */
        vuint32_t EEI15:1;					 /* Enable Error Interrupt 15 */
        vuint32_t EEI14:1;					 /* Enable Error Interrupt 14 */
        vuint32_t EEI13:1;					 /* Enable Error Interrupt 13 */
        vuint32_t EEI12:1;					 /* Enable Error Interrupt 12 */
        vuint32_t EEI11:1;					 /* Enable Error Interrupt 11 */
        vuint32_t EEI10:1;					 /* Enable Error Interrupt 10 */
        vuint32_t EEI9:1;					 /* Enable Error Interrupt 9 */
        vuint32_t EEI8:1;					 /* Enable Error Interrupt 8 */
        vuint32_t EEI7:1;					 /* Enable Error Interrupt 7 */
        vuint32_t EEI6:1;					 /* Enable ErrorInterrupt 6 */
        vuint32_t EEI5:1;					 /* Enable Error Interrupt 5 */
        vuint32_t EEI4:1;					 /* Enable Error Interrupt 4 */
        vuint32_t EEI3:1;					 /* Enable Error Interrupt 3 */
        vuint32_t EEI2:1;					 /* Enable Error Interrupt 2 */
        vuint32_t EEI1:1;					 /* Enable Error Interrupt 1 */
        vuint32_t EEI0:1;					 /* Enable Error Interrupt 0 */
    } B;
  } EEIL;

  union {
    vuint8_t R;
      struct {
        vuint8_t NOP:1;					 /* No Op enable */
        vuint8_t SERQ:7;					 /* Set Enable Request. */
    } B;
  } SERQ;

  union {
    vuint8_t R;
      struct {
        vuint8_t NOP:1;					 /* No Op enable. */
        vuint8_t CERQ:7;					 /* Clear enable request. */
    } B;
  } CERQ;

  union {
    vuint8_t R;
      struct {
        vuint8_t NOP:1;					 /* No Op enable */
        vuint8_t SEEI:7;					 /* Set enable error interrupt */
    } B;
  } SEEI;

  union {
    vuint8_t R;
      struct {
        vuint8_t NOP:1;					 /* No Op enable */
        vuint8_t CEEI:7;					 /* Clear Enable Error Interrupt. */
    } B;
  } CEEI;

  union {
    vuint8_t R;
      struct {
        vuint8_t NOP:1;					 /* No Op enable. */
        vuint8_t CINT:7;					 /* Clear Interrupt Request. */
    } B;
  } CINT;

  union {
    vuint8_t R;
      struct {
        vuint8_t NOP:1;					 /* No Op enable. */
        vuint8_t CERR:7;					 /* Clear Error Indicator. */
    } B;
  } CERR;

  union {
    vuint8_t R;
      struct {
        vuint8_t NOP:1;					 /* No Op enable. */
        vuint8_t SSRT:7;					 /* Set START Bit */
    } B;
  } SSRT;

  union {
    vuint8_t R;
      struct {
        vuint8_t NOP:1;					 /* No Op enable. */
        vuint8_t CDNE:7;					 /* Clear DONE Status Bit. */
    } B;
  } CDNE;

  union {
    vuint32_t R;
      struct {
        vuint32_t INT63:1;					 /* Interrupt Request 63 */
        vuint32_t INT62:1;					 /* Interrupt Request 62 */
        vuint32_t INT61:1;					 /* Interrupt Request 61 */
        vuint32_t INT60:1;					 /* Interrupt Request 60 */
        vuint32_t INT59:1;					 /* Interrupt Request 59 */
        vuint32_t INT58:1;					 /* Interrupt Request 58 */
        vuint32_t INT57:1;					 /* Interrupt Request 57 */
        vuint32_t INT56:1;					 /* Interrupt Request 56 */
        vuint32_t INT55:1;					 /* Interrupt Request 55 */
        vuint32_t INT54:1;					 /* Interrupt Request 54 */
        vuint32_t INT53:1;					 /* Interrupt Request 53 */
        vuint32_t INT52:1;					 /* Interrupt Request 52 */
        vuint32_t INT51:1;					 /* Interrupt Request 51 */
        vuint32_t INT50:1;					 /* Interrupt Request 50 */
        vuint32_t INT49:1;					 /* Interrupt Request 49 */
        vuint32_t INT48:1;					 /* Interrupt Request 48 */
        vuint32_t INT47:1;					 /* Interrupt Request 47 */
        vuint32_t INT46:1;					 /* Interrupt Request 46 */
        vuint32_t INT45:1;					 /* Interrupt Request 45 */
        vuint32_t INT44:1;					 /* Interrupt Request 44 */
        vuint32_t INT43:1;					 /* Interrupt Request 43 */
        vuint32_t INT42:1;					 /* Interrupt Request 42 */
        vuint32_t INT41:1;					 /* Interrupt Request 41 */
        vuint32_t INT40:1;					 /* Interrupt Request 40 */
        vuint32_t INT39:1;					 /* Interrupt Request 30 */
        vuint32_t INT38:1;					 /* Interrupt Request 38 */
        vuint32_t INT37:1;					 /* Interrupt Request 37 */
        vuint32_t INT36:1;					 /* Interrupt Request 36 */
        vuint32_t INT35:1;					 /* Interrupt Request 35 */
        vuint32_t INT34:1;					 /* Interrupt Request 34 */
        vuint32_t INT33:1;					 /* Interrupt Request 33 */
        vuint32_t INT32:1;					 /* Interrupt Request 32 */
    } B;
  } INTH;

  union {
    vuint32_t R;
      struct {
        vuint32_t INT31:1;					 /* Interrupt Request 31 */
        vuint32_t INT30:1;					 /* Interrupt Request 30 */
        vuint32_t INT29:1;					 /* Interrupt Request 29 */
        vuint32_t INT28:1;					 /* Interrupt Request 28 */
        vuint32_t INT27:1;					 /* Interrupt Request 27 */
        vuint32_t INT26:1;					 /* Interrupt Request 26 */
        vuint32_t INT25:1;					 /* Interrupt Request 25 */
        vuint32_t INT24:1;					 /* Interrupt Request 24 */
        vuint32_t INT23:1;					 /* Interrupt Request 23 */
        vuint32_t INT22:1;					 /* Interrupt Request 22 */
        vuint32_t INT21:1;					 /* Interrupt Request 21 */
        vuint32_t INT20:1;					 /* Interrupt Request 20 */
        vuint32_t INT19:1;					 /* Interrupt Request 19 */
        vuint32_t INT18:1;					 /* Interrupt Request 18 */
        vuint32_t INT17:1;					 /* Interrupt Request 17 */
        vuint32_t INT16:1;					 /* Interrupt Request 16 */
        vuint32_t INT15:1;					 /* Interrupt Request 15 */
        vuint32_t INT14:1;					 /* Interrupt Request 14 */
        vuint32_t INT13:1;					 /* Interrupt Request 13 */
        vuint32_t INT12:1;					 /* Interrupt Request 12 */
        vuint32_t INT11:1;					 /* Interrupt Request 11 */
        vuint32_t INT10:1;					 /* Interrupt Request 10 */
        vuint32_t INT9:1;					 /* Interrupt Request 9 */
        vuint32_t INT8:1;					 /* Interrupt Request 8 */
        vuint32_t INT7:1;					 /* Interrupt Request 7 */
        vuint32_t INT6:1;					 /* Interrupt Request 6 */
        vuint32_t INT5:1;					 /* Interrupt Request 5 */
        vuint32_t INT4:1;					 /* Interrupt Request 4 */
        vuint32_t INT3:1;					 /* Interrupt Request 3 */
        vuint32_t INT2:1;					 /* Interrupt Request 2 */
        vuint32_t INT1:1;					 /* Interrupt Request 1 */
        vuint32_t INT0:1;					 /* Interrupt Request 0 */
    } B;
  } INTL;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERR63:1;					 /* Error In Channel 63 */
        vuint32_t ERR62:1;					 /* Error In Channel 62 */
        vuint32_t ERR61:1;					 /* Error In Channel 61 */
        vuint32_t ERR60:1;					 /* Error In Channel 60 */
        vuint32_t ERR59:1;					 /* Error In Channel 59 */
        vuint32_t ERR58:1;					 /* Error In Channel 58 */
        vuint32_t ERR57:1;					 /* Error In Channel 57 */
        vuint32_t ERR56:1;					 /* Error In Channel 56 */
        vuint32_t ERR55:1;					 /* Error In Channel 55 */
        vuint32_t ERR54:1;					 /* Error In Channel 54 */
        vuint32_t ERR53:1;					 /* Error In Channel 53 */
        vuint32_t ERR52:1;					 /* Error In Channel 52 */
        vuint32_t ERR51:1;					 /* Error In Channel 51 */
        vuint32_t ERR50:1;					 /* Error In Channel 50 */
        vuint32_t ERR49:1;					 /* Error In Channel 49 */
        vuint32_t ERR48:1;					 /* Error In Channel 48 */
        vuint32_t ERR47:1;					 /* Error In Channel 47 */
        vuint32_t ERR46:1;					 /* Error In Channel 46 */
        vuint32_t ERR45:1;					 /* Error In Channel 45 */
        vuint32_t ERR44:1;					 /* Error In Channel 44 */
        vuint32_t ERR43:1;					 /* Error In Channel 43 */
        vuint32_t ERR42:1;					 /* Error In Channel 42 */
        vuint32_t ERR41:1;					 /* Error In Channel 41 */
        vuint32_t ERR40:1;					 /* Error In Channel 40 */
        vuint32_t ERR39:1;					 /* Error In Channel 39 */
        vuint32_t ERR38:1;					 /* Error In Channel 38 */
        vuint32_t ERR37:1;					 /* Error In Channel 37 */
        vuint32_t ERR36:1;					 /* Error In Channel 36 */
        vuint32_t ERR35:1;					 /* Error In Channel 35 */
        vuint32_t ERR34:1;					 /* Error In Channel 34 */
        vuint32_t ERR33:1;					 /* Error In Channel 33 */
        vuint32_t ERR32:1;					 /* Error In Channel 32 */
    } B;
  } ERRH;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERR31:1;					 /* Error In Channel 31 */
        vuint32_t ERR30:1;					 /* Error In Channel 30 */
        vuint32_t ERR29:1;					 /* Error In Channel 29 */
        vuint32_t ERR28:1;					 /* Error In Channel 28 */
        vuint32_t ERR27:1;					 /* Error In Channel 27 */
        vuint32_t ERR26:1;					 /* Error In Channel 26 */
        vuint32_t ERR25:1;					 /* Error In Channel 25 */
        vuint32_t ERR24:1;					 /* Error In Channel 24 */
        vuint32_t ERR23:1;					 /* Error In Channel 23 */
        vuint32_t ERR22:1;					 /* Error In Channel 22 */
        vuint32_t ERR21:1;					 /* Error In Channel 21 */
        vuint32_t ERR20:1;					 /* Error In Channel 20 */
        vuint32_t ERR19:1;					 /* Error In Channel 19 */
        vuint32_t ERR18:1;					 /* Error In Channel 18 */
        vuint32_t ERR17:1;					 /* Error In Channel 17 */
        vuint32_t ERR16:1;					 /* Error In Channel 16 */
        vuint32_t ERR15:1;					 /* Error In Channel 15 */
        vuint32_t ERR14:1;					 /* Error In Channel 14 */
        vuint32_t ERR13:1;					 /* Error In Channel 13 */
        vuint32_t ERR12:1;					 /* Error In Channel 12 */
        vuint32_t ERR11:1;					 /* Error In Channel 11 */
        vuint32_t ERR10:1;					 /* Error In Channel 10 */
        vuint32_t ERR9:1;					 /* Error In Channel 9 */
        vuint32_t ERR8:1;					 /* Error In Channel 8 */
        vuint32_t ERR7:1;					 /* Error In Channel 7 */
        vuint32_t ERR6:1;					 /* Error In Channel 6 */
        vuint32_t ERR5:1;					 /* Error In Channel 5 */
        vuint32_t ERR4:1;					 /* Error In Channel 4 */
        vuint32_t ERR3:1;					 /* Error In Channel 3 */
        vuint32_t ERR2:1;					 /* Error In Channel 2 */
        vuint32_t ERR1:1;					 /* Error In Channel 1 */
        vuint32_t ERR0:1;					 /* Error In Channel 0 */
    } B;
  } ERRL;

  union {
    vuint32_t R;
      struct {
        vuint32_t HRS63:1;					 /* Hardware Request Status Channel 63 */
        vuint32_t HRS62:1;					 /* Hardware Request Status Channel 62 */
        vuint32_t HRS61:1;					 /* Hardware Request Status Channel 61 */
        vuint32_t HRS60:1;					 /* Hardware Request Status Channel 60 */
        vuint32_t HRS59:1;					 /* Hardware Request Status Channel 59 */
        vuint32_t HRS58:1;					 /* Hardware Request Status Channel 58 */
        vuint32_t HRS57:1;					 /* Hardware Request Status Channel 57 */
        vuint32_t HRS56:1;					 /* Hardware Request Status Channel 56 */
        vuint32_t HRS55:1;					 /* Hardware Request Status Channel 55 */
        vuint32_t HRS54:1;					 /* Hardware Request Status Channel 54 */
        vuint32_t HRS53:1;					 /* Hardware Request Status Channel 53 */
        vuint32_t HRS52:1;					 /* Hardware Request Status Channel 52 */
        vuint32_t HRS51:1;					 /* Hardware Request Status Channel 51 */
        vuint32_t HRS50:1;					 /* Hardware Request Status Channel 50 */
        vuint32_t HRS49:1;					 /* Hardware Request Status Channel 49 */
        vuint32_t HRS48:1;					 /* Hardware Request Status Channel 48 */
        vuint32_t HRS47:1;					 /* Hardware Request Status Channel 47 */
        vuint32_t HRS46:1;					 /* Hardware Request Status Channel 46 */
        vuint32_t HRS45:1;					 /* Hardware Request Status Channel 45 */
        vuint32_t HRS44:1;					 /* Hardware Request Status Channel 44 */
        vuint32_t HRS43:1;					 /* Hardware Request Status Channel 43 */
        vuint32_t HRS42:1;					 /* Hardware Request Status Channel 42 */
        vuint32_t HRS41:1;					 /* Hardware Request Status Channel 41 */
        vuint32_t HRS40:1;					 /* Hardware Request Status Channel 40 */
        vuint32_t HRS39:1;					 /* Hardware Request Status Channel 39 */
        vuint32_t HRS38:1;					 /* Hardware Request Status Channel 38 */
        vuint32_t HRS37:1;					 /* Hardware Request Status Channel 37 */
        vuint32_t HRS36:1;					 /* Hardware Request Status Channel 36 */
        vuint32_t HRS35:1;					 /* Hardware Request Status Channel 35 */
        vuint32_t HRS34:1;					 /* Hardware Request Status Channel 34 */
        vuint32_t HRS33:1;					 /* Hardware Request Status Channel 33 */
        vuint32_t HRS32:1;					 /* Hardware Request Status Channel 32 */
    } B;
  } HRSH;

  union {
    vuint32_t R;
      struct {
        vuint32_t HRS31:1;					 /* Hardware Request Status Channel 31 */
        vuint32_t HRS30:1;					 /* Hardware Request Status Channel 30 */
        vuint32_t HRS29:1;					 /* Hardware Request Status Channel 29 */
        vuint32_t HRS28:1;					 /* Hardware Request Status Channel 28 */
        vuint32_t HRS27:1;					 /* Hardware Request Status Channel 27 */
        vuint32_t HRS26:1;					 /* Hardware Request Status Channel 26 */
        vuint32_t HRS25:1;					 /* Hardware Request Status Channel 25 */
        vuint32_t HRS24:1;					 /* Hardware Request Status Channel 24 */
        vuint32_t HRS23:1;					 /* Hardware Request Status Channel 23 */
        vuint32_t HRS22:1;					 /* Hardware Request Status Channel 22 */
        vuint32_t HRS21:1;					 /* Hardware Request Status Channel 21 */
        vuint32_t HRS20:1;					 /* Hardware Request Status Channel 20 */
        vuint32_t HRS19:1;					 /* Hardware Request Status Channel 19 */
        vuint32_t HRS18:1;					 /* Hardware Request Status Channel 18 */
        vuint32_t HRS17:1;					 /* Hardware Request Status Channel 17 */
        vuint32_t HRS16:1;					 /* Hardware Request Status Channel 16 */
        vuint32_t HRS15:1;					 /* Hardware Request Status Channel 15 */
        vuint32_t HRS14:1;					 /* Hardware Request Status Channel 14 */
        vuint32_t HRS13:1;					 /* Hardware Request Status Channel 13 */
        vuint32_t HRS12:1;					 /* Hardware Request Status Channel 12 */
        vuint32_t HRS11:1;					 /* Hardware Request Status Channel 11 */
        vuint32_t HRS10:1;					 /* Hardware Request Status Channel 10 */
        vuint32_t HRS9:1;					 /* Hardware Request Status Channel 9 */
        vuint32_t HRS8:1;					 /* Hardware Request Status Channel 8 */
        vuint32_t HRS7:1;					 /* Hardware Request Status Channel 7 */
        vuint32_t HRS6:1;					 /* Hardware Request Status Channel 6 */
        vuint32_t HRS5:1;					 /* Hardware Request Status Channel 5 */
        vuint32_t HRS4:1;					 /* Hardware Request Status Channel 4 */
        vuint32_t HRS3:1;					 /* Hardware Request Status Channel 3 */
        vuint32_t HRS2:1;					 /* Hardware Request Status Channel 2 */
        vuint32_t HRS1:1;					 /* Hardware Request Status Channel 1 */
        vuint32_t HRS0:1;					 /* Hardware Request Status Channel 0 */
    } B;
  } HRSL;

  uint8_t DMA_reserved0[200];
  union {
    vuint8_t R;
      struct {
        vuint8_t ECP:1;					 /* Enable Channel Preemption. */
        vuint8_t DPA:1;					 /* Disable Preempt Ability. */
        vuint8_t GRPPRI:2;					 /* Channel n Current Group Priority */
        vuint8_t CHPRI:4;					 /* Channel n Arbitration Priority */
    } B;
  } DCHPRI[64];

  union {
    vuint8_t R;
      struct {
        vuint8_t EMI:1;					 /* Enable Master ID replication. */
        vuint8_t PAL:1;					 /* Privileged Access Level. */
        vuint8_t  :2;					 /*  */
        vuint8_t MID:4;					 /* Master ID. */
    } B;
  } DCHMID[64];

  uint8_t DMA_reserved1[3712];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t SADDR:32;					 /* Source Address. */
      } B;
    } WORD_0;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t SMOD:5;					 /* Source Address Modulo. */
          vuint32_t SSIZE:3;					 /* Source data transfer size. */
          vuint32_t DMOD:5;					 /* Destination Address Modulo. */
          vuint32_t DSIZE:3;					 /* Destination data transfer size */
          vuint32_t SOFF:16;					 /* Source address signed offset. */
      } B;
    } WORD_1;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t NBYTES:32;					 /* Inner "Minor" Byte Transfer Count */
      } B;
    } WORD_2;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t SLAST:32;					 /* Last Source Address Adjustment */
      } B;
    } WORD_3;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t DADDR:32;					 /* Destination Address. */
      } B;
    } WORD_4;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t CITER_E_LINK:1;					 /* Enable channel-to-channel linking on minor-loop complete. */
          vuint32_t LINKCH_CITER:6;					 /* Current "major" iteration count or Link channel number. */
          vuint32_t CITER:9;					 /* Current Major Iteration Count */
          vuint32_t DOFF:16;					 /* Destination address signed offset. */
      } B;
    } WORD_5;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t DLAST_SGA:32;					 /* Last destination address adjustment or the memory address for the next transfer control descriptor to be loaded into this channel (scatter/gather). */
      } B;
    } WORD_6;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t BITER_E_LINK:1;					 /* Enable channel-to-channel linking on minor loop complete. */
          vuint32_t BITER_BITER_LINKCH:6;					 /* "Beginning major iteration count" or "Beginning Link channel number". */
          vuint32_t BITER:9;					 /* Beginning "major" iteration count. */
          vuint32_t BWC:2;					 /* Bandwidth Control. */
          vuint32_t MAJOR_LINKCH:6;					 /* Link Channel Number. */
          vuint32_t DONE:1;					 /* Channel Done. */
          vuint32_t ACTIVE:1;					 /* Channel Active. */
          vuint32_t MAJOR_E_LINK:1;					 /* Enable channel-to-channel linking on major loop complete. */
          vuint32_t E_SG:1;					 /* Enable Scatter/Cather Processing. */
          vuint32_t DREQ:1;					 /* Disable Request. */
          vuint32_t INT_HALF:1;					 /* Enable an interrupt when major counter is half complete. */
          vuint32_t INT_MAJOR:1;					 /* Enable an interrupt when major iteration count completes. */
          vuint32_t START:1;					 /* Channel Start. */
      } B;
    } WORD_7;
  } TCD[64];

};


/* ============================================================================
   =============================== Module: DSPI ===============================
   ============================================================================ */

struct DSPI_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t MSTR:1;					 /* Master/Slave Mode Select */
        vuint32_t CONT_SCKE:1;					 /* Continuous SCK Enable */
        vuint32_t DCONF:2;					 /* DSPI Configuration */
        vuint32_t FRZ:1;					 /* Freeze */
        vuint32_t MTFE:1;					 /* Modified Timing Format Enable */
        vuint32_t PCSSE:1;					 /* Peripheral Chip Select Strobe Enable */
        vuint32_t ROOE:1;					 /* Receive FIFO Overflow Overwrite Enable */
        vuint32_t  :2;					 /*  */
        vuint32_t PCSIS:6;					 /* Peripheral Chip Select x Inactive State */
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t DIS_TXF:1;					 /* Disable Transmit FIFO */
        vuint32_t DIS_RXF:1;					 /* Disable Receive FIFO */
        vuint32_t CLR_TXF:1;					 /* Clear TX FIFO */
        vuint32_t CLR_RXF:1;					 /*  */
        vuint32_t SMPL_PT:2;					 /* Sample Point */
        vuint32_t  :4;					 /*  */
        vuint32_t XSPI:1;					 /* Extended SPI Mode */
        vuint32_t FCPCS:1;					 /* Fast Continuous PCS Mode. */
        vuint32_t PES:1;					 /* Parity Error Stop */
        vuint32_t HALT:1;					 /* Halt */
    } B;
  } MCR;

  uint8_t DSPI_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t SPI_TCNT:16;					 /* SPI Transfer Counter */
        vuint32_t  :16;					 /*  */
    } B;
  } TCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t DBR:1;					 /* Double Baud Rate */
        vuint32_t FMSZ:4;					 /* Frame Size */
        vuint32_t CPOL:1;					 /* Clock Polarity */
        vuint32_t CPHA:1;					 /* Clock Phase */
        vuint32_t LSBFE:1;					 /* LSB First */
        vuint32_t PCSSCK:2;					 /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;					 /* After SCK Delay Prescaler */
        vuint32_t PDT:2;					 /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;					 /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;					 /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;					 /* After SCK Delay Scaler */
        vuint32_t DT:4;					 /* Delay After Transfer Scaler */
        vuint32_t BR:4;					 /* Baud Rate Scaler */
    } B;
  } CTAR0;

//    union {
//    vuint32_t R;
//      struct {
//        vuint32_t FMSZ:5;					 /* Frame Size */
//        vuint32_t CPOL:1;					 /* Clock Polarity */
//        vuint32_t CPHA:1;					 /* Clock Phase */
//        vuint32_t PE:1;					 /* Parity Enable */
//        vuint32_t PP:1;					 /* Parity Polarity */
//        vuint32_t FMSZ5:1;					 /* MSB of Frame Size when DSI is used in 64-bit Mode */
//        vuint32_t  :22;					 /*  */
//    } B;
//  } CTAR0_SLAVE;

  union {
    vuint32_t R;
      struct {
        vuint32_t DBR:1;					 /* Double Baud Rate */
        vuint32_t FMSZ:4;					 /* Frame Size */
        vuint32_t CPOL:1;					 /* Clock Polarity */
        vuint32_t CPHA:1;					 /* Clock Phase */
        vuint32_t LSBFE:1;					 /* LSB First */
        vuint32_t PCSSCK:2;					 /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;					 /* After SCK Delay Prescaler */
        vuint32_t PDT:2;					 /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;					 /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;					 /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;					 /* After SCK Delay Scaler */
        vuint32_t DT:4;					 /* Delay After Transfer Scaler */
        vuint32_t BR:4;					 /* Baud Rate Scaler */
    } B;
  } CTAR1;

//  union {
//    vuint32_t R;
//      struct {
//        vuint32_t FMSZ:5;					 /* Frame Size */
//        vuint32_t CPOL:1;					 /* Clock Polarity */
//        vuint32_t CPHA:1;					 /* Clock Phase */
//        vuint32_t PE:1;					 /* Parity Enable */
//        vuint32_t PP:1;					 /* Parity Polarity */
//        vuint32_t FMSZ5:1;					 /* MSB of Frame Size when DSI is used in 64-bit Mode */
//        vuint32_t  :22;					 /*  */
//    } B;
//  } CTAR1_SLAVE;

  union {
    vuint32_t R;
      struct {
        vuint32_t DBR:1;					 /* Double Baud Rate */
        vuint32_t FMSZ:4;					 /* Frame Size */
        vuint32_t CPOL:1;					 /* Clock Polarity */
        vuint32_t CPHA:1;					 /* Clock Phase */
        vuint32_t LSBFE:1;					 /* LSB First */
        vuint32_t PCSSCK:2;					 /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;					 /* After SCK Delay Prescaler */
        vuint32_t PDT:2;					 /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;					 /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;					 /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;					 /* After SCK Delay Scaler */
        vuint32_t DT:4;					 /* Delay After Transfer Scaler */
        vuint32_t BR:4;					 /* Baud Rate Scaler */
    } B;
  } CTAR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t DBR:1;					 /* Double Baud Rate */
        vuint32_t FMSZ:4;					 /* Frame Size */
        vuint32_t CPOL:1;					 /* Clock Polarity */
        vuint32_t CPHA:1;					 /* Clock Phase */
        vuint32_t LSBFE:1;					 /* LSB First */
        vuint32_t PCSSCK:2;					 /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;					 /* After SCK Delay Prescaler */
        vuint32_t PDT:2;					 /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;					 /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;					 /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;					 /* After SCK Delay Scaler */
        vuint32_t DT:4;					 /* Delay After Transfer Scaler */
        vuint32_t BR:4;					 /* Baud Rate Scaler */
    } B;
  } CTAR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t DBR:1;					 /* Double Baud Rate */
        vuint32_t FMSZ:4;					 /* Frame Size */
        vuint32_t CPOL:1;					 /* Clock Polarity */
        vuint32_t CPHA:1;					 /* Clock Phase */
        vuint32_t LSBFE:1;					 /* LSB First */
        vuint32_t PCSSCK:2;					 /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;					 /* After SCK Delay Prescaler */
        vuint32_t PDT:2;					 /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;					 /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;					 /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;					 /* After SCK Delay Scaler */
        vuint32_t DT:4;					 /* Delay After Transfer Scaler */
        vuint32_t BR:4;					 /* Baud Rate Scaler */
    } B;
  } CTAR4;

  union {
    vuint32_t R;
      struct {
        vuint32_t DBR:1;					 /* Double Baud Rate */
        vuint32_t FMSZ:4;					 /* Frame Size */
        vuint32_t CPOL:1;					 /* Clock Polarity */
        vuint32_t CPHA:1;					 /* Clock Phase */
        vuint32_t LSBFE:1;					 /* LSB First */
        vuint32_t PCSSCK:2;					 /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;					 /* After SCK Delay Prescaler */
        vuint32_t PDT:2;					 /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;					 /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;					 /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;					 /* After SCK Delay Scaler */
        vuint32_t DT:4;					 /* Delay After Transfer Scaler */
        vuint32_t BR:4;					 /* Baud Rate Scaler */
    } B;
  } CTAR5;

  union {
    vuint32_t R;
      struct {
        vuint32_t DBR:1;					 /* Double Baud Rate */
        vuint32_t FMSZ:4;					 /* Frame Size */
        vuint32_t CPOL:1;					 /* Clock Polarity */
        vuint32_t CPHA:1;					 /* Clock Phase */
        vuint32_t LSBFE:1;					 /* LSB First */
        vuint32_t PCSSCK:2;					 /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;					 /* After SCK Delay Prescaler */
        vuint32_t PDT:2;					 /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;					 /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;					 /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;					 /* After SCK Delay Scaler */
        vuint32_t DT:4;					 /* Delay After Transfer Scaler */
        vuint32_t BR:4;					 /* Baud Rate Scaler */
    } B;
  } CTAR6;

  union {
    vuint32_t R;
      struct {
        vuint32_t DBR:1;					 /* Double Baud Rate */
        vuint32_t FMSZ:4;					 /* Frame Size */
        vuint32_t CPOL:1;					 /* Clock Polarity */
        vuint32_t CPHA:1;					 /* Clock Phase */
        vuint32_t LSBFE:1;					 /* LSB First */
        vuint32_t PCSSCK:2;					 /* PCS to SCK Delay Prescaler */
        vuint32_t PASC:2;					 /* After SCK Delay Prescaler */
        vuint32_t PDT:2;					 /* Delay after Transfer Prescaler */
        vuint32_t PBR:2;					 /* Baud Rate Prescaler */
        vuint32_t CSSCK:4;					 /* PCS to SCK Delay Scaler */
        vuint32_t ASC:4;					 /* After SCK Delay Scaler */
        vuint32_t DT:4;					 /* Delay After Transfer Scaler */
        vuint32_t BR:4;					 /* Baud Rate Scaler */
    } B;
  } CTAR7;

  union {
    vuint32_t R;
      struct {
        vuint32_t TCF:1;					 /* Transfer Complete Flag */
        vuint32_t TXRXS:1;					 /* TX and RX Status */
        vuint32_t SPITCF:1;					 /* SPI Frame Transfer Complete Flag. */
        vuint32_t EOQF:1;					 /* End of Queue Flag */
        vuint32_t TFUF:1;					 /* Transmit FIFO Underflow Flag */
        vuint32_t DSITCF:1;					 /* DSI Frame Transfer Complete Flag. */
        vuint32_t TFFF:1;					 /* Transmit FIFO Fill Flag */
        vuint32_t BSYF:1;					 /* Busy Flag. */
        vuint32_t CMDTCF:1;					 /* Command Transfer Complete Flag. */
        vuint32_t DPEF:1;					 /* DSI Parity Error Flag */
        vuint32_t SPEF:1;					 /* SPI Parity Error Flag */
        vuint32_t DDIF:1;					 /* DSI Data Received with Active Bits */
        vuint32_t RFOF:1;					 /* Receive FIFO Overflow Flag */
        vuint32_t TFIWF:1;					 /* Tranmit FIFO Invalid Write Flag */
        vuint32_t RFDF:1;					 /* Receive FIFO Drain Flag */
        vuint32_t CMDFFF:1;					 /* Command FIFO Fill Flag */
        vuint32_t TXCTR:4;					 /* TX FIFO Counter */
        vuint32_t TXNXTPTR:4;					 /* Transmit Next Pointer */
        vuint32_t RXCTR:4;					 /* RX FIFO Counter */
        vuint32_t POPNXTPTR:4;					 /* Pop Next Pointer */
    } B;
  } SR;

  union {
    vuint32_t R;
      struct {
        vuint32_t TCF_RE:1;					 /* Transmission Complete Request Enable */
        vuint32_t CMDFFF_RE:1;					 /* Command FIFO Fill Flag Request Enable. */
        vuint32_t SPITCF_RE:1;					 /* SPI Frame Transmission Complete Request Enable. */
        vuint32_t EOQF_RE:1;					 /* Finished Request Enable */
        vuint32_t TFUF_RE:1;					 /* Transmit FIFO Underflow Request Enable */
        vuint32_t DSITCF_RE:1;					 /* DSI Frame Transmission Complete Request Enable. */
        vuint32_t TFFF_RE:1;					 /* Transmit FIFO Fill Request Enable */
        vuint32_t TFFF_DIRS:1;					 /* Transmit FIFO Fill DMA or Interrupt Request Select */
        vuint32_t CMDTCF_RE:1;					 /* Command Transmission Complete Request Enable. */
        vuint32_t DPEF_RE:1;					 /* DSI Parity Error Request Enable */
        vuint32_t SPEF_RE:1;					 /* SPI Parity Error Request Enable */
        vuint32_t DDIF_RE:1;					 /* DSI data received with active bits Request Enable */
        vuint32_t RFOF_RE:1;					 /* Receive FIFO Overflow Request Enable */
        vuint32_t TFIWF_RE:1;					 /* Transmit FIFO Invalid Write Request Enable. */
        vuint32_t RFDF_RE:1;					 /* Receive FIFO Drain Request Enable */
        vuint32_t RFDF_DIRS:1;					 /* Receive FIFO Drain DMA or Interrupt Request Select */
        vuint32_t CMDFFF_DIRS:1;					 /* Command FIFO Fill DMA or Interrupt Request Select */
        vuint32_t DDIF_DIRS:1;					 /* DSI data received with active bits - DMA or Interrupt Request Select. */
        vuint32_t  :14;					 /*  */
    } B;
  } RSER;

//  union {
//    vuint32_t R;
//      struct {
//        vuint32_t  :16;					 /*  */
//        vuint32_t TXDATA:16;					 /* Transmit Data */
//    } B;
//  } PUSHR_SLAVE;
  
  union {
    vuint32_t R;
      struct {
        vuint32_t CONT:1;					 /* Continuous Peripheral Chip Select Enable */
        vuint32_t CTAS:3;					 /* Clock and Transfer Attributes Select */
        vuint32_t EOQ:1;					 /* End Of Queue */
        vuint32_t CTCNT:1;					 /* Clear Transfer Counter */
        vuint32_t PE_MASC:1;					 /* Parity Enable or Mask T ASC delay in the current frame */
        vuint32_t PP_MCSC:1;					 /* Parity Polarity or Mask T CSC delay in the next frame */
        vuint32_t  :2;					 /*  */
        vuint32_t PCS:6;					 /*  */
        vuint32_t TXDATA:16;					 /* Transmit Data */
    } B;
  } PUSHR;

  union {
    vuint32_t R;
      struct {
        vuint32_t RXDATA:32;					 /* Received Data */
    } B;
  } POPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t TXCMD_TXDATA:16;					 /* Transmit Command or Transmit Data */
        vuint32_t TXDATA:16;					 /* Transmit Data */
    } B;
  } TXFR[4];

  uint8_t DSPI_reserved1[48];
  union {
    vuint32_t R;
      struct {
        vuint32_t RXDATA:32;					 /* Receive Data */
    } B;
  } RXFR[4];

  uint8_t DSPI_reserved2[48];
  union {
    vuint32_t R;
      struct {
        vuint32_t MTOE:1;					 /* Multiple Transfer Operation Enable */
        vuint32_t FMSZ4:1;					 /* MSB of the frame size in master mode. */
        vuint32_t MTOCNT:6;					 /* Multiple Transfer Operation Count */
        vuint32_t FMSZ5:1;					 /* MSB of the frame size in master mode when DSI is used in 64-bit mode. */
        vuint32_t  :1;					 /*  */
        vuint32_t ITSB:1;					 /* Interleaved TSB mode. */
        vuint32_t TSBC:1;					 /* Timed Serial Bus Configuration. */
        vuint32_t TXSS:1;					 /* Transmit Data Source Select. */
        vuint32_t  :2;					 /*  */
        vuint32_t CID:1;					 /* Change In Data Transfer Enable */
        vuint32_t DCONT:1;					 /* DSI Continuous Peripheral Chip Select Enable */
        vuint32_t DSICTAS:3;					 /* DSI Clock and Transfer Attributes Select */
        vuint32_t DMS:1;					 /* Data Match Stop */
        vuint32_t PES:1;					 /* Parity Error Stop */
        vuint32_t PE:1;					 /* Parity Enable */
        vuint32_t PP:1;					 /* Parity Polarity */
        vuint32_t DPCSx:8;					 /* DSI Peripheral Chip Select 0-7 */
    } B;
  } DSICR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t SER_DATA:32;					 /* Serialized Data */
    } B;
  } SDR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t ASER_DATA:32;					 /* Alternate Serialized Data */
    } B;
  } ASDR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t COMP_DATA:32;					 /* Compare Data */
    } B;
  } COMPR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t DESER_DATA:32;					 /* Deserialized Data */
    } B;
  } DDR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :2;					 /*  */
        vuint32_t TSBCNT:6;					 /* Timed Serial Bus Operation Count */
        vuint32_t  :3;					 /*  */
        vuint32_t CSI_PRTY:1;					 /* CSI Priority */
        vuint32_t CSE:1;					 /* Command Select Enable */
        vuint32_t DSI64E:1;					 /* DSI 64-bit Mode Enable */
        vuint32_t DSE1:1;					 /* Data Select Enable 1 */
        vuint32_t DSE0:1;					 /* Data Select Enable 0 */
        vuint32_t  :8;					 /*  */
        vuint32_t DPCS1_x:8;					 /* DSI Peripheral Chip Select 0-7 */
    } B;
  } DSICR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t SS:32;					 /* Source Select */
    } B;
  } SSR0;

  uint8_t DSPI_reserved3[16];
  union {
    vuint32_t R;
      struct {
        vuint32_t MASK:32;					 /* Mask */
    } B;
  } DIMR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t DP:32;					 /* Data Polarity */
    } B;
  } DPIR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t SER_DATA:32;					 /* Serialized Data */
    } B;
  } SDR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t ASER_DATA:32;					 /* Alternate Serialized Data */
    } B;
  } ASDR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t COMP_DATA:32;					 /* Compare Data */
    } B;
  } COMPR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t DESER_DATA:32;					 /* Deserialized Data */
    } B;
  } DDR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t SS:32;					 /* Source Select */
    } B;
  } SSR1;

  uint8_t DSPI_reserved4[16];
  union {
    vuint32_t R;
      struct {
        vuint32_t MASK:32;					 /* Mask */
    } B;
  } DIMR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t DP:32;					 /* Data Polarity */
    } B;
  } DPIR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t FMSZE:1;					 /* Frame Size Extended */
        vuint32_t  :5;					 /*  */
        vuint32_t DTCP:11;					 /* Data Transfer Count Preload */
    } B;
  } CTARE[8];

  union {
    vuint32_t R;
      struct {
        vuint32_t  :17;					 /*  */
        vuint32_t RXCTR4:1;					 /* RX FIFO Counter[4] */
        vuint32_t  :2;					 /*  */
        vuint32_t TXCTR4:1;					 /* TX FIFO Counter[4] */
        vuint32_t  :2;					 /*  */
        vuint32_t CMDCTR:5;					 /* CMD FIFO Counter */
        vuint32_t CMDNXTPTR:4;					 /* Command Next Pointer */
    } B;
  } SREX;

  union {
    vuint32_t R;
      struct {
        vuint32_t ENABLE:1;					 /* Trigger Register Enable */
        vuint32_t  :27;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t ASDR_WT:1;					 /* ASDR Write Trigger Enable */
        vuint32_t CID:1;					 /* Change In Data Transfer Enable */
        vuint32_t  :1;					 /*  */
    } B;
  } TRIG;

  uint8_t DSPI_reserved5[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t TS3_LEN:7;					 /* Time Slot 3 Length */
        vuint32_t  :1;					 /*  */
        vuint32_t TS2_LEN:7;					 /* Time Slot 2 Length */
        vuint32_t  :1;					 /*  */
        vuint32_t TS1_LEN:7;					 /* Time Slot 1 Length */
        vuint32_t  :1;					 /*  */
        vuint32_t TS0_LEN:7;					 /* Time Slot 0 Length */
    } B;
  } TSL;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t TS3:4;					 /* Time Slot 3 */
        vuint32_t TS2:4;					 /* Time Slot 2 */
        vuint32_t TS1:4;					 /* Time Slot 1 */
        vuint32_t TS0:4;					 /* Time Slot 0 */
    } B;
  } TS_CONF;

};


/* ============================================================================
   =============================== Module: DTS ================================
   ============================================================================ */

struct DTS_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :30;					 /*  */
        vuint32_t DTS_EN_B:1;					 /*  */
        vuint32_t DTS_EN:1;					 /*  */
    } B;
  } ENABLE;

  union {
    vuint32_t R;
      struct {
        vuint32_t AD:32;					 /*  */
    } B;
  } STARTUP;

  union {
    vuint32_t R;
      struct {
        vuint32_t ST:32;					 /*  */
    } B;
  } SEMAPHORE;

  union {
    vuint32_t R;
      struct {
        vuint32_t ST_B:32;					 /*  */
    } B;
  } SEMAPHORE_B;

};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

struct FCCU_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t FILTER_BYPASS:1;					 /*  */
        vuint32_t FILTER_WIDTH:2;					 /*  */
        vuint32_t  :19;					 /*  */
        vuint32_t DEBUG:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t OPS:2;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t OPR:5;					 /*  */
    } B;
  } CTRL;

  union {
    vuint32_t R;
      struct {
        vuint32_t CTRLK:32;					 /*  */
    } B;
  } CTRLK;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t FCCU_SET_AFTER_RESET:1;					 /*  */
        vuint32_t FCCU_SET_CLEAR:2;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t SM:1;					 /*  */
        vuint32_t PS:1;					 /*  */
        vuint32_t FOM:3;					 /*  */
        vuint32_t  :6;					 /*  */
    } B;
  } CFG;

  uint8_t FCCU_reserved0[16];
  union {
    vuint32_t R;
      struct {
        vuint32_t NCFCx:32;					 /*  */
    } B;
  } NCF_CFG0;

  union {
    vuint32_t R;
      struct {
        vuint32_t NCFCx:32;					 /*  */
    } B;
  } NCF_CFG1;
  
  union {
    vuint32_t R;
      struct {
        vuint32_t NCFCx:32;					 /*  */
    } B;
  } NCF_CFG2;


  uint8_t FCCU_reserved1[36];
  union {
    vuint32_t R;
      struct {
        vuint32_t NCFSCx:32;					 /*  */
    } B;
  } NCFS_CFG[6];

  uint8_t FCCU_reserved2[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t NCFSx:32;					 /*  */
    } B;
  } NCF_S0;

  union {
    vuint32_t R;
      struct {
        vuint32_t NCFSx:32;					 /*  */
    } B;
  } NCF_S1;
  
  union {
    vuint32_t R;
      struct {
        vuint32_t NCFSx:32;					 /*  */
    } B;
  } NCF_S2;

  uint8_t FCCU_reserved3[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t NCFK:32;					 /*  */
    } B;
  } NCFK;

  union {
    vuint32_t R;
      struct {
        vuint32_t NCFEx:32;					 /*  */
    } B;
  } NCF_E0;

  union {
    vuint32_t R;
      struct {
        vuint32_t NCFEx:32;					 /*  */
    } B;
  } NCF_E1;
  
  union {
    vuint32_t R;
      struct {
        vuint32_t NCFEx:32;					 /*  */
    } B;
  } NCF_E2;

  uint8_t FCCU_reserved4[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t NCFTOEx:32;					 /*  */
    } B;
  } NCF_TOE0;

  union {
    vuint32_t R;
      struct {
        vuint32_t NCFTOEx:32;					 /*  */
    } B;
  } NCF_TOE1;
  
  union {
    vuint32_t R;
      struct {
        vuint32_t NCFTOEx:32;					 /*  */
    } B;
  } NCF_TOE2;

  uint8_t FCCU_reserved5[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t TO:32;					 /*  */
    } B;
  } NCF_TO;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :29;					 /*  */
        vuint32_t TO:3;					 /*  */
    } B;
  } CFG_TO;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t EIN1:1;					 /*  */
        vuint32_t EIN0:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t EOUT1:1;					 /*  */
        vuint32_t EOUT0:1;					 /*  */
    } B;
  } EINOUT;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t PhysicErrorPin:2;					 /*  */
        vuint32_t ESTAT:1;					 /*  */
        vuint32_t STATUS:3;					 /*  */
    } B;
  } STAT;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t NAFS:8;					 /*  */
    } B;
  } N2AF_STATUS;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t AF_SRC:2;					 /*  */
        vuint32_t AFFS:8;					 /*  */
    } B;
  } A2FF_STATUS;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t NF_SRC:2;					 /*  */
        vuint32_t NFFS:8;					 /*  */
    } B;
  } N2FF_STATUS;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :23;					 /*  */
        vuint32_t FAFS:9;					 /*  */
    } B;
  } F2A_STATUS;

  uint8_t FCCU_reserved6[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :25;					 /*  */
        vuint32_t FNCFC:7;					 /*  */
    } B;
  } NCFF;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :29;					 /*  */
        vuint32_t NMI_STAT:1;					 /*  */
        vuint32_t ALRM_STAT:1;					 /*  */
        vuint32_t CFG_TO_STAT:1;					 /*  */
    } B;
  } IRQ_STAT;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :31;					 /*  */
        vuint32_t CFG_TO_IEN:1;					 /*  */
    } B;
  } IRQ_EN;

  union {
    vuint32_t R;
      struct {
        vuint32_t XTMR:32;					 /*  */
    } B;
  } XTMR;

  union {
    vuint32_t R;
      struct {
        vuint32_t VL3:1;					 /*  */
        vuint32_t FS3:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MCS3:4;					 /*  */
        vuint32_t VL2:1;					 /*  */
        vuint32_t FS2:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MCS2:4;					 /*  */
        vuint32_t VL1:1;					 /*  */
        vuint32_t FS1:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MCS1:4;					 /*  */
        vuint32_t VL0:1;					 /*  */
        vuint32_t FS0:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MCS0:4;					 /*  */
    } B;
  } MCS;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :23;					 /*  */
        vuint32_t TRANSKEY:9;					 /*  */
    } B;
  } TRANS_LOCK;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :23;					 /*  */
        vuint32_t PERMNTKEY:9;					 /*  */
    } B;
  } PERMNT_LOCK;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :18;					 /*  */
        vuint32_t DELTA_T:14;					 /*  */
    } B;
  } DELTA_T;

  union {
    vuint32_t R;
      struct {
        vuint32_t IRQEN31:1;					 
        vuint32_t IRQEN30:1;					 
        vuint32_t IRQEN29:1;					 
        vuint32_t IRQEN28:1;					 
        vuint32_t IRQEN27:1;
        vuint32_t IRQEN26:1;					 
        vuint32_t IRQEN25:1;					 
        vuint32_t IRQEN24:1;					 
        vuint32_t IRQEN23:1;					 
        vuint32_t IRQEN22:1;
        vuint32_t IRQEN21:1;					 
        vuint32_t IRQEN20:1;					 
        vuint32_t IRQEN19:1;					 
        vuint32_t IRQEN18:1;					 
        vuint32_t IRQEN17:1;
        vuint32_t IRQEN16:1;					 
        vuint32_t IRQEN15:1;					 
        vuint32_t IRQEN14:1;					 
        vuint32_t IRQEN13:1;					 
        vuint32_t IRQEN12:1;
        vuint32_t IRQEN11:1;					 
        vuint32_t IRQEN10:1;					 
        vuint32_t IRQEN9:1;					 
        vuint32_t IRQEN8:1;					 
        vuint32_t IRQEN7:1;
        vuint32_t IRQEN6:1;					 
        vuint32_t IRQEN5:1;					 
        vuint32_t IRQEN4:1;					 
        vuint32_t IRQEN3:1;					 
        vuint32_t IRQEN2:1;
        vuint32_t IRQEN1:1;					 
        vuint32_t IRQEN0:1;
    } B;
  } IRQ_ALARM_EN[3];

  uint8_t FCCU_reserved7[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t NMIEN31:1;					 
        vuint32_t NMIEN30:1;					 
        vuint32_t NMIEN29:1;					 
        vuint32_t NMIEN28:1;					 
        vuint32_t NMIEN27:1;
        vuint32_t NMIEN26:1;					 
        vuint32_t NMIEN25:1;					 
        vuint32_t NMIEN24:1;					 
        vuint32_t NMIEN23:1;					 
        vuint32_t NMIEN22:1;
        vuint32_t NMIEN21:1;					 
        vuint32_t NMIEN20:1;					 
        vuint32_t NMIEN19:1;					 
        vuint32_t NMIEN18:1;					 
        vuint32_t NMIEN17:1;
        vuint32_t NMIEN16:1;					 
        vuint32_t NMIEN15:1;					 
        vuint32_t NMIEN14:1;					 
        vuint32_t NMIEN13:1;					 
        vuint32_t NMIEN12:1;
        vuint32_t NMIEN11:1;					 
        vuint32_t NMIEN10:1;					 
        vuint32_t NMIEN9:1;					 
        vuint32_t NMIEN8:1;					 
        vuint32_t NMIEN7:1;
        vuint32_t NMIEN6:1;					 
        vuint32_t NMIEN5:1;					 
        vuint32_t NMIEN4:1;					 
        vuint32_t NMIEN3:1;					 
        vuint32_t NMIEN2:1;
        vuint32_t NMIEN1:1;					 
        vuint32_t NMIEN0:1;
    } B;
  } NMI_EN[3];

  uint8_t FCCU_reserved8[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t EOUTEN31:1;					 
        vuint32_t EOUTEN30:1;					 
        vuint32_t EOUTEN29:1;					 
        vuint32_t EOUTEN28:1;					 
        vuint32_t EOUTEN27:1;
        vuint32_t EOUTEN26:1;					 
        vuint32_t EOUTEN25:1;					 
        vuint32_t EOUTEN24:1;					 
        vuint32_t EOUTEN23:1;					 
        vuint32_t EOUTEN22:1;
        vuint32_t EOUTEN21:1;					 
        vuint32_t EOUTEN20:1;					 
        vuint32_t EOUTEN19:1;					 
        vuint32_t EOUTEN18:1;					 
        vuint32_t EOUTEN17:1;
        vuint32_t EOUTEN16:1;					 
        vuint32_t EOUTEN15:1;					 
        vuint32_t EOUTEN14:1;					 
        vuint32_t EOUTEN13:1;					 
        vuint32_t EOUTEN12:1;
        vuint32_t EOUTEN11:1;					 
        vuint32_t EOUTEN10:1;					 
        vuint32_t EOUTEN9:1;					 
        vuint32_t EOUTEN8:1;					 
        vuint32_t EOUTEN7:1;
        vuint32_t EOUTEN6:1;					 
        vuint32_t EOUTEN5:1;					 
        vuint32_t EOUTEN4:1;					 
        vuint32_t EOUTEN3:1;					 
        vuint32_t EOUTEN2:1;
        vuint32_t EOUTEN1:1;					 
        vuint32_t EOUTEN0:1;
    } B;
  } EOUT_SIG_EN[3];

};


/* ============================================================================
   =============================== Module: FEC ================================
   ============================================================================ */

struct FEC_tag {
  uint8_t FEC_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t HBERR:1;					 /*  */
        vuint32_t BABR:1;					 /*  */
        vuint32_t BABT:1;					 /*  */
        vuint32_t GRA:1;					 /*  */
        vuint32_t TXF:1;					 /*  */
        vuint32_t TXB:1;					 /*  */
        vuint32_t RXF:1;					 /*  */
        vuint32_t RXB:1;					 /*  */
        vuint32_t MII:1;					 /*  */
        vuint32_t EBERR:1;					 /*  */
        vuint32_t LC:1;					 /*  */
        vuint32_t RL:1;					 /*  */
        vuint32_t UN:1;					 /*  */
        vuint32_t  :19;					 /*  */
    } B;
  } EIR;

  union {
    vuint32_t R;
      struct {
        vuint32_t HBERR:1;					 /*  */
        vuint32_t BABR:1;					 /*  */
        vuint32_t BABT:1;					 /*  */
        vuint32_t GRA:1;					 /*  */
        vuint32_t TXF:1;					 /*  */
        vuint32_t TXB:1;					 /*  */
        vuint32_t RXF:1;					 /*  */
        vuint32_t RXB:1;					 /*  */
        vuint32_t MII:1;					 /*  */
        vuint32_t EBERR:1;					 /*  */
        vuint32_t LC:1;					 /*  */
        vuint32_t RL:1;					 /*  */
        vuint32_t UN:1;					 /*  */
        vuint32_t  :19;					 /*  */
    } B;
  } EIMR;

  uint8_t FEC_reserved1[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t RDAR:1;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } RDAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t TDAR:1;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } TDAR;

  uint8_t FEC_reserved2[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :23;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t ETHER_EN:1;					 /*  */
        vuint32_t RESET:1;					 /*  */
    } B;
  } ECR;

  uint8_t FEC_reserved3[24];
  union {
    vuint32_t R;
      struct {
        vuint32_t ST:2;					 /*  */
        vuint32_t OP:2;					 /*  */
        vuint32_t PA:5;					 /*  */
        vuint32_t RA:5;					 /*  */
        vuint32_t TA:2;					 /*  */
        vuint32_t DATA:16;					 /*  */
    } B;
  } MMFR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t DIS_PRE:1;					 /*  */
        vuint32_t MII_SPEED:6;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } MSCR;

  uint8_t FEC_reserved4[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t MIB_DIS:1;					 /*  */
        vuint32_t MIB_IDLE:1;					 /*  */
        vuint32_t  :30;					 /*  */
    } B;
  } MIBC;

  uint8_t FEC_reserved5[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :5;					 /*  */
        vuint32_t MAX_FL:11;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t RMII_ECHO:1;					 /*  */
        vuint32_t RMII_LOOP:1;					 /*  */
        vuint32_t RMII_10T:1;					 /*  */
        vuint32_t RMII_MODE:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t FCE:1;					 /*  */
        vuint32_t BC_REJ:1;					 /*  */
        vuint32_t PROM:1;					 /*  */
        vuint32_t MII_MODE:1;					 /*  */
        vuint32_t DRT:1;					 /*  */
        vuint32_t LOOP:1;					 /*  */
    } B;
  } RCR;

  uint8_t FEC_reserved6[60];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :27;					 /*  */
        vuint32_t RFC_PAUSE:1;					 /*  */
        vuint32_t TFC_PAUSE:1;					 /*  */
        vuint32_t FDEN:1;					 /*  */
        vuint32_t HBC:1;					 /*  */
        vuint32_t GTS:1;					 /*  */
    } B;
  } TCR;

  uint8_t FEC_reserved7[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t PADDR1:32;					 /*  */
    } B;
  } PALR;

  union {
    vuint32_t R;
      struct {
        vuint32_t PADDR2:16;					 /*  */
        vuint32_t TYPE:16;					 /*  */
    } B;
  } PAUR;

  union {
    vuint32_t R;
      struct {
        vuint32_t OPCODE:16;					 /*  */
        vuint32_t PAUSE_DUR:16;					 /*  */
    } B;
  } OPD;

  uint8_t FEC_reserved8[40];
  union {
    vuint32_t R;
      struct {
        vuint32_t IADDR1:32;					 /*  */
    } B;
  } IAUR;

  union {
    vuint32_t R;
      struct {
        vuint32_t IADDR2:32;					 /*  */
    } B;
  } IALR;

  union {
    vuint32_t R;
      struct {
        vuint32_t GADDR1:32;					 /*  */
    } B;
  } GAUR;

  union {
    vuint32_t R;
      struct {
        vuint32_t GADDR2:32;					 /*  */
    } B;
  } GALR;

  uint8_t FEC_reserved9[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :30;					 /*  */
        vuint32_t TFWR:2;					 /*  */
    } B;
  } TFWR;

  uint8_t FEC_reserved10[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :21;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t R_BOUND:8;					 /*  */
        vuint32_t  :2;					 /*  */
    } B;
  } FRBR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :21;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t R_FSTART:8;					 /*  */
        vuint32_t  :2;					 /*  */
    } B;
  } FRSR;

  uint8_t FEC_reserved11[44];
  union {
    vuint32_t R;
      struct {
        vuint32_t R_DES_START:30;					 /*  */
        vuint32_t  :2;					 /*  */
    } B;
  } ERDSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t X_DES_START:30;					 /*  */
        vuint32_t  :2;					 /*  */
    } B;
  } ETDSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :21;					 /*  */
        vuint32_t R_BUF_SIZE:7;					 /*  */
        vuint32_t  :4;					 /*  */
    } B;
  } EMRBR;

  uint8_t FEC_reserved12[116];
  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_DROP:32;					 /*  */
    } B;
  } RMON_T_DROP;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_PACKETS:32;					 /*  */
    } B;
  } RMON_T_PACKETS;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_BC_PKT:32;					 /*  */
    } B;
  } RMON_T_BC_PKT;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_MC_PKT:32;					 /*  */
    } B;
  } RMON_T_MC_PKT;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_CRC_ALIGN:32;					 /*  */
    } B;
  } RMON_T_CRC_ALIGN;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_UNDERSIZE:32;					 /*  */
    } B;
  } RMON_T_UNDERSIZE;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_OVERSIZE:32;					 /*  */
    } B;
  } RMON_T_OVERSIZE;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_FRAG:32;					 /*  */
    } B;
  } RMON_T_FRAG;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_JAB:32;					 /*  */
    } B;
  } RMON_T_JAB;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_COL:32;					 /*  */
    } B;
  } RMON_T_COL;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_P64:32;					 /*  */
    } B;
  } RMON_T_P64;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_P65TO127:32;					 /*  */
    } B;
  } RMON_T_P65TO127;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_P128TO255:32;					 /*  */
    } B;
  } RMON_T_P128TO255;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_P256TO511:32;					 /*  */
    } B;
  } RMON_T_P256TO511;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_P512TO1023:32;					 /*  */
    } B;
  } RMON_T_P512TO1023;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_P1024TO2047:32;					 /*  */
    } B;
  } RMON_T_P1024TO2047;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_P_GTE2048:32;					 /*  */
    } B;
  } RMON_T_P_GTE2048;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_T_OCTETS:32;					 /*  */
    } B;
  } RMON_T_OCTETS;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_DROP:32;					 /*  */
    } B;
  } IEEE_T_DROP;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_FRAME_OK:32;					 /*  */
    } B;
  } IEEE_T_FRAME_OK;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_1COL:32;					 /*  */
    } B;
  } IEEE_T_1COL;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_MCOL:32;					 /*  */
    } B;
  } IEEE_T_MCOL;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_DEF:32;					 /*  */
    } B;
  } IEEE_T_DEF;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_LCOL:32;					 /*  */
    } B;
  } IEEE_T_LCOL;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_EXCOL:32;					 /*  */
    } B;
  } IEEE_T_EXCOL;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_MACERR:32;					 /*  */
    } B;
  } IEEE_T_MACERR;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_CSERR:32;					 /*  */
    } B;
  } IEEE_T_CSERR;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_SQE:32;					 /*  */
    } B;
  } IEEE_T_SQE;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_FDXFC:32;					 /*  */
    } B;
  } IEEE_T_FDXFC;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_T_OCTETS_OK:32;					 /*  */
    } B;
  } IEEE_T_OCTETS_OK;

  uint8_t FEC_reserved13[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_DROP:32;					 /*  */
    } B;
  } RMON_R_DROP;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_PACKETS:32;					 /*  */
    } B;
  } RMON_R_PACKETS;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_BC_PKT:32;					 /*  */
    } B;
  } RMON_R_BC_PKT;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_MC_PKT:32;					 /*  */
    } B;
  } RMON_R_MC_PKT;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_CRC_ALIGN:32;					 /*  */
    } B;
  } RMON_R_CRC_ALIGN;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_UNDERSIZE:32;					 /*  */
    } B;
  } RMON_R_UNDERSIZE;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_OVERSIZE:32;					 /*  */
    } B;
  } RMON_R_OVERSIZE;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_FRAG:32;					 /*  */
    } B;
  } RMON_R_FRAG;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_JAB:32;					 /*  */
    } B;
  } RMON_R_JAB;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_RESVD_0:32;					 /*  */
    } B;
  } RMON_R_RESVD_0;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_P64:32;					 /*  */
    } B;
  } RMON_R_P64;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_P65TO127:32;					 /*  */
    } B;
  } RMON_R_P65TO127;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_P128TO255:32;					 /*  */
    } B;
  } RMON_R_P128TO255;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_P256TO511:32;					 /*  */
    } B;
  } RMON_R_P256TO511;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_P512TO1023:32;					 /*  */
    } B;
  } RMON_R_P512TO1023;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_P1024TO2047:32;					 /*  */
    } B;
  } RMON_R_P1024TO2047;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_P_GTE2048:32;					 /*  */
    } B;
  } RMON_R_P_GTE2048;

  union {
    vuint32_t R;
      struct {
        vuint32_t RMON_R_OCTETS:32;					 /*  */
    } B;
  } RMON_R_OCTETS;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_R_DROP:32;					 /*  */
    } B;
  } IEEE_R_DROP;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_R_FRAME_OK:32;					 /*  */
    } B;
  } IEEE_R_FRAME_OK;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_R_CRC:32;					 /*  */
    } B;
  } IEEE_R_CRC;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_R_ALIGN:32;					 /*  */
    } B;
  } IEEE_R_ALIGN;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_R_MACERR:32;					 /*  */
    } B;
  } IEEE_R_MACERR;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_R_FDXFC:32;					 /*  */
    } B;
  } IEEE_R_FDXFC;

  union {
    vuint32_t R;
      struct {
        vuint32_t IEEE_R_OCTETS_OK:32;					 /*  */
    } B;
  } IEEE_R_OCTETS_OK;

};


/* ============================================================================
   =============================== Module: IGF ================================
   ============================================================================ */

struct IGF_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR0;

  uint8_t IGF_reserved0[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :23;					 /*  */
        vuint32_t FPRE:9;					 /* Filter prescaler */
    } B;
  } PRESR0;

  uint8_t IGF_reserved1[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR0;

  uint8_t IGF_reserved2[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR1;

  uint8_t IGF_reserved3[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR1;

  uint8_t IGF_reserved4[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR2;

  uint8_t IGF_reserved5[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR2;

  uint8_t IGF_reserved6[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR3;

  uint8_t IGF_reserved7[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR3;

  uint8_t IGF_reserved8[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR4;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR4;

  uint8_t IGF_reserved9[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR4;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR4;

  uint8_t IGF_reserved10[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR5;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR5;

  uint8_t IGF_reserved11[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR5;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR5;

  uint8_t IGF_reserved12[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR6;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR6;

  uint8_t IGF_reserved13[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR6;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR6;

  uint8_t IGF_reserved14[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR7;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR7;

  uint8_t IGF_reserved15[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR7;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR7;

  uint8_t IGF_reserved16[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR8;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR8;

  uint8_t IGF_reserved17[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR8;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR8;

  uint8_t IGF_reserved18[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR9;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR9;

  uint8_t IGF_reserved19[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR9;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR9;

  uint8_t IGF_reserved20[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR10;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR10;

  uint8_t IGF_reserved21[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR10;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR10;

  uint8_t IGF_reserved22[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR11;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR11;

  uint8_t IGF_reserved23[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR11;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR11;

  uint8_t IGF_reserved24[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR12;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR12;

  uint8_t IGF_reserved25[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR12;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR12;

  uint8_t IGF_reserved26[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR13;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR13;

  uint8_t IGF_reserved27[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR13;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR13;

  uint8_t IGF_reserved28[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR14;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR14;

  uint8_t IGF_reserved29[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR14;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR14;

  uint8_t IGF_reserved30[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR15;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR15;

  uint8_t IGF_reserved31[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR15;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR15;

  uint8_t IGF_reserved32[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR16;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR16;

  uint8_t IGF_reserved33[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR16;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR16;

  uint8_t IGF_reserved34[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR17;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR17;

  uint8_t IGF_reserved35[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR17;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR17;

  uint8_t IGF_reserved36[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR18;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR18;

  uint8_t IGF_reserved37[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR18;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR18;

  uint8_t IGF_reserved38[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR19;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR19;

  uint8_t IGF_reserved39[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR19;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR19;

  uint8_t IGF_reserved40[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR20;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR20;

  uint8_t IGF_reserved41[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR20;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR20;

  uint8_t IGF_reserved42[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR21;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR21;

  uint8_t IGF_reserved43[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR21;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR21;

  uint8_t IGF_reserved44[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR22;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR22;

  uint8_t IGF_reserved45[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR22;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR22;

  uint8_t IGF_reserved46[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR23;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR23;

  uint8_t IGF_reserved47[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR23;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR23;

  uint8_t IGF_reserved48[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR24;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR24;

  uint8_t IGF_reserved49[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR24;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR24;

  uint8_t IGF_reserved50[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR25;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR25;

  uint8_t IGF_reserved51[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR25;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR25;

  uint8_t IGF_reserved52[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR26;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR26;

  uint8_t IGF_reserved53[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR26;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR26;

  uint8_t IGF_reserved54[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR27;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR27;

  uint8_t IGF_reserved55[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR27;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR27;

  uint8_t IGF_reserved56[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR28;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR28;

  uint8_t IGF_reserved57[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR28;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR28;

  uint8_t IGF_reserved58[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR29;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR29;

  uint8_t IGF_reserved59[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR29;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR29;

  uint8_t IGF_reserved60[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR30;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR30;

  uint8_t IGF_reserved61[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR30;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR30;

  uint8_t IGF_reserved62[28];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze bit for debug operation */
        vuint32_t FBP:1;					 /* Force Bypass */
        vuint32_t FOH:1;					 /* Force filter output high */
        vuint32_t FOL:1;					 /* Force filter output low */
        vuint32_t  :16;					 /*  */
        vuint32_t IMM:1;					 /* Immediate edge propagation control bit */
        vuint32_t PSSEL:1;					 /* Prescaler selection bit */
        vuint32_t POL:1;					 /* Output polarity bit */
        vuint32_t FGEN:1;					 /* Filter global enable */
        vuint32_t  :1;					 /*  */
        vuint32_t FFM:2;					 /* Falling edge filter type selection */
        vuint32_t  :1;					 /*  */
        vuint32_t RFM:2;					 /* Rising edge filter type selection */
    } B;
  } MCR31;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WEDGE:1;					 /* Filter is active waiting for an edge */
        vuint32_t FEDGE:1;					 /* Filter is active processing an edge */
        vuint32_t RNDET:1;					 /* Rise noise detected bit */
        vuint32_t FNDET:1;					 /* Fall noise detected bit */
        vuint32_t FLI:1;					 /* Filter input */
        vuint32_t FLO:1;					 /* Filter output */
    } B;
  } MSR31;

  uint8_t IGF_reserved63[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RTH:24;					 /* Rising edge threshold */
    } B;
  } RTHR31;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t FTH:24;					 /* Falling edge threshold */
    } B;
  } FTHR31;

};

/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

struct INTC_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :19;                  /*  */
        vuint32_t HVEN3:1;                   /*  */
        vuint32_t  :3;                   /*  */
        vuint32_t HVEN2:1;                   /*  */
        vuint32_t  :3;                   /*  */
        vuint32_t HVEN1:1;                   /*  */
        vuint32_t  :3;                   /*  */
        vuint32_t HVEN0:1;                   /*  */
    } B;
  } BCR;

  uint8_t INTC_reserved0[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;                  /*  */
        vuint32_t PRI:6;                     /*  */
    } B;
  } CPR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;                  /*  */
        vuint32_t PRI:6;                     /*  */
    } B;
  } CPR1;

  uint8_t INTC_reserved1[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t VTBA:20;                   /*  */
        vuint32_t INTVEC:10;                     /*  */
        vuint32_t  :2;                   /*  */
    } B;
  } IACKR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t VTBA:20;                   /*  */
        vuint32_t INTVEC:10;                     /*  */
        vuint32_t  :2;                   /*  */
    } B;
  } IACKR1;

  uint8_t INTC_reserved2[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t EOI:32;                    /*  */
    } B;
  } EOIR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t EOI:32;                    /*  */
    } B;
  } EOIR1;

  uint8_t INTC_reserved3[8];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :6;                                                                                /*  */
        vuint8_t SET:1;                                                                          /*  */
        vuint8_t CLR:1;                                                                          /*  */
    } B;
  } SSCIR[32];

  union {
    vuint16_t R;
      struct {
        vuint16_t PRC_SELn:4;                    /*  */
        vuint16_t  :3;                   /*  */
        vuint16_t SWTn:1;                    /*  */
        vuint16_t  :2;                   /*  */
        vuint16_t PRIn:6;                    /*  */
    } B;
  } PSR[1024];

  uint8_t INTC_reserved4[1952];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t  :30;                    /*  */
          vuint32_t MM:2;                    /*  */
      } B;
    } MMRC;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :22;                    /*  */
          vuint32_t IRQ:10;                  /*  */
      } B;
    } HIPRIC[4];
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :8;                     /*  */
          vuint32_t LAT:24;                  /*  */
      } B;
    } LATC[4];
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :8;                     /*  */
          vuint32_t TIMER:24;                    /*  */
      } B;
    } TIMERC[4];
  } CH[2];

};



/* ============================================================================
   ============================== Module: IRCOSC ==============================
   ============================================================================ */

struct IRCOSC_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t USER_TRIM:5;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :5;					 /*  */
    } B;
  } CTL;

};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

struct JDC_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t JIN_IEN:1;					 /*  */
        vuint32_t  :15;					 /*  */
        vuint32_t JOUT_IEN:1;					 /*  */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :13;					 /*  */
        vuint32_t JIN_RDY:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t JIN_INT:1;					 /*  */
        vuint32_t  :13;					 /*  */
        vuint32_t JOUT_RDY:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t JOUT_INT:1;					 /*  */
    } B;
  } MSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t JOUT_IPSData:32;					 /*  */
    } B;
  } JOUT_IPS;

  union {
    vuint32_t R;
      struct {
        vuint32_t JIN_IPSData:32;					 /*  */
    } B;
  } JIN_IPS;

};


/* ============================================================================
   ============================== Module: JTAGM ===============================
   ============================================================================ */

struct JTAGM_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t SWRESET:1;					 /*  */
        vuint32_t  :17;					 /*  */
        vuint32_t inter_jtag_frame_timer:6;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t SIE:1;					 /*  */
        vuint32_t IIE:1;					 /*  */
        vuint32_t TCKSEL:3;					 /*  */
        vuint32_t jtagm_JCOMP:1;					 /*  */
        vuint32_t DTM:1;					 /*  */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :6;					 /*  */
        vuint32_t dci_status:8;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t SPU_INT_CLR:1;					 /*  */
        vuint32_t SPU_INT:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t Nexus_err:1;					 /*  */
        vuint32_t Idle:1;					 /*  */
        vuint32_t NR:1;					 /*  */
        vuint32_t  :8;					 /*  */
    } B;
  } SR;

  union {
    vuint32_t R;
      struct {
        vuint32_t TMS_HIGH:32;					 /*  */
    } B;
  } DOR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t TMS_LOW:28;					 /*  */
        vuint32_t  :4;					 /*  */
    } B;
  } DOR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t TDI_HIGH:32;					 /*  */
    } B;
  } DOR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t TDI_LOW:28;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t Send:1;					 /*  */
    } B;
  } DOR3;

  uint8_t JTAGM_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t TDO_LOW:32;					 /*  */
    } B;
  } DIR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t TDO_HIGH:28;					 /*  */
        vuint32_t  :4;					 /*  */
    } B;
  } DIR1;

};


/* ============================================================================
   ============================== Module: LFAST ===============================
   ============================================================================ */

struct LFAST_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t MSEN:1;					 /*  */
        vuint32_t  :6;					 /*  */
        vuint32_t IPGDBG:1;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t LSSEL:1;					 /*  */
        vuint32_t DRFEN:1;					 /*  */
        vuint32_t RXEN:1;					 /*  */
        vuint32_t TXEN:1;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t TXARBD:1;					 /*  */
        vuint32_t CTSEN:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t DRFRST:1;					 /*  */
        vuint32_t DATAEN:1;					 /*  */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t DRMD:1;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t RDR:1;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t TDR:1;					 /*  */
    } B;
  } SCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t SMPSEL:8;					 /*  */
        vuint32_t  :6;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t CORRTH:3;					 /*  */
        vuint32_t PHSSEL:1;					 /*  */
    } B;
  } COCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :6;					 /*  */
        vuint32_t CLKTST:1;					 /*  */
        vuint32_t LPON:1;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t LPMOD:3;					 /*  */
        vuint32_t LPFRMTH:16;					 /*  */
    } B;
  } TMCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t LPCNTEN:1;					 /*  */
        vuint32_t LPFMCNT:16;					 /*  */
    } B;
  } ALCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t DRCNT:4;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } RCDCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t HSCNT:8;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t LSCNT:4;					 /*  */
        vuint32_t HWKCNT:8;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t LWKCNT:4;					 /*  */
    } B;
  } SLCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :14;					 /*  */
        vuint32_t ICLCSEQ:1;					 /*  */
        vuint32_t SNDICLC:1;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t ICLCPLD:8;					 /*  */
    } B;
  } ICR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t PNGREQ:1;					 /*  */
        vuint32_t PNGAUTO:1;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t PNGPYLD:8;					 /*  */
    } B;
  } PICR;

  uint8_t LFAST_reserved0[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :10;					 /*  */
        vuint32_t RCTSMX:6;					 /*  */
        vuint32_t  :10;					 /*  */
        vuint32_t RCTSMN:6;					 /*  */
    } B;
  } RFCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :14;					 /*  */
        vuint32_t TXIIE:1;					 /*  */
        vuint32_t TXOVIE:1;					 /*  */
        vuint32_t  :11;					 /*  */
        vuint32_t TXPNGIE:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t TXUNSIE:1;					 /*  */
        vuint32_t TXICLCIE:1;					 /*  */
        vuint32_t TXDTIE:1;					 /*  */
    } B;
  } TIER;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RXUOIE:1;					 /*  */
        vuint32_t RXMNIE:1;					 /*  */
        vuint32_t RXMXIE:1;					 /*  */
        vuint32_t RXUFIE:1;					 /*  */
        vuint32_t RXOFIE:1;					 /*  */
        vuint32_t RXSZIE:1;					 /*  */
        vuint32_t RXICIE:1;					 /*  */
        vuint32_t RXLCEIE:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t RXCTSIE:1;					 /*  */
        vuint32_t RXDIE:1;					 /*  */
        vuint32_t RXUNSIE:1;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } RIER;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :18;					 /*  */
        vuint32_t ICPFIE:1;					 /*  */
        vuint32_t ICPSIE:1;					 /*  */
        vuint32_t ICPRIE:1;					 /*  */
        vuint32_t ICTOIE:1;					 /*  */
        vuint32_t ICLPIE:1;					 /*  */
        vuint32_t ICCTIE:1;					 /*  */
        vuint32_t ICTDIE:1;					 /*  */
        vuint32_t ICTEIE:1;					 /*  */
        vuint32_t ICRFIE:1;					 /*  */
        vuint32_t ICRSIE:1;					 /*  */
        vuint32_t ICTFIE:1;					 /*  */
        vuint32_t ICTSIE:1;					 /*  */
        vuint32_t ICPOFIE:1;					 /*  */
        vuint32_t ICPONIE:1;					 /*  */
    } B;
  } RIIER;

  union {
    vuint32_t R;
      struct {
        vuint32_t IPTMOD:3;					 /*  */
        vuint32_t  :11;					 /*  */
        vuint32_t SWPOFF:1;					 /*  */
        vuint32_t SWPON:1;					 /*  */
        vuint32_t REFINV:1;					 /*  */
        vuint32_t LPCFG:2;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t PLCKCW:2;					 /*  */
        vuint32_t FDIVEN:1;					 /*  */
        vuint32_t FBDIV:6;					 /*  */
        vuint32_t PREDIV:2;					 /*  */
    } B;
  } PLLCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t SWWKLD:1;					 /*  */
        vuint32_t SWSLPLD:1;					 /*  */
        vuint32_t SWWKLR:1;					 /*  */
        vuint32_t SWSLPLR:1;					 /*  */
        vuint32_t SWOFFLD:1;					 /*  */
        vuint32_t SWONLD:1;					 /*  */
        vuint32_t SWOFFLR:1;					 /*  */
        vuint32_t SWONLR:1;					 /*  */
        vuint32_t LVRXOFF:1;					 /*  */
        vuint32_t LVTXOE:1;					 /*  */
        vuint32_t TXCMUX:1;					 /*  */
        vuint32_t LVRFEN:1;					 /*  */
        vuint32_t LVLPEN:1;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t LVRXOP:3;					 /*  */
        vuint32_t LVTXOP:1;					 /*  */
        vuint32_t LVCKSS:1;					 /*  */
        vuint32_t LVCKP:1;					 /*  */
    } B;
  } LCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t USNDRQ:1;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t UNSHDR:7;					 /*  */
    } B;
  } UNSTCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t UNTXD:32;					 /*  */
    } B;
  } UNSTDR[9];

  uint8_t LFAST_reserved1[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t DUALMD:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t LRMD:1;					 /*  */
        vuint32_t LDSM:1;					 /*  */
        vuint32_t DRSM:1;					 /*  */
        vuint32_t  :11;					 /*  */
        vuint32_t LPTXDN:1;					 /*  */
        vuint32_t LPFPDV:1;					 /*  */
        vuint32_t LPCPDV:1;					 /*  */
        vuint32_t LPCHDV:1;					 /*  */
        vuint32_t LPCSDV:1;					 /*  */
    } B;
  } GSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t RXPNGD:8;					 /*  */
    } B;
  } PISR;

  uint8_t LFAST_reserved2[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :2;					 /*  */
        vuint32_t RXDCNT:6;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t RXFCNT:3;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t TXDCNT:6;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t TXFCNT:3;					 /*  */
    } B;
  } DFSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :14;					 /*  */
        vuint32_t TXIEF:1;					 /*  */
        vuint32_t TXOVF:1;					 /*  */
        vuint32_t  :11;					 /*  */
        vuint32_t TXPNGF:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t TXUNSF:1;					 /*  */
        vuint32_t TXICLCF:1;					 /*  */
        vuint32_t TXDTF:1;					 /*  */
    } B;
  } TISR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t RXUOF:1;					 /*  */
        vuint32_t RXMNF:1;					 /*  */
        vuint32_t RXMXF:1;					 /*  */
        vuint32_t RXUFF:1;					 /*  */
        vuint32_t RXOFF:1;					 /*  */
        vuint32_t RXSZF:1;					 /*  */
        vuint32_t RXICF:1;					 /*  */
        vuint32_t RXLCEF:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t RXCTSF:1;					 /*  */
        vuint32_t RXDF:1;					 /*  */
        vuint32_t RXUNSF:1;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } RISR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :18;					 /*  */
        vuint32_t ICPFF:1;					 /*  */
        vuint32_t ICPSF:1;					 /*  */
        vuint32_t ICPRF:1;					 /*  */
        vuint32_t ICTOF:1;					 /*  */
        vuint32_t ICLPF:1;					 /*  */
        vuint32_t ICCTF:1;					 /*  */
        vuint32_t ICTDF:1;					 /*  */
        vuint32_t ICTEF:1;					 /*  */
        vuint32_t ICRFF:1;					 /*  */
        vuint32_t ICRSF:1;					 /*  */
        vuint32_t ICTFF:1;					 /*  */
        vuint32_t ICTSF:1;					 /*  */
        vuint32_t ICPOFF:1;					 /*  */
        vuint32_t ICPONF:1;					 /*  */
    } B;
  } RIISR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :14;					 /*  */
        vuint32_t PLLDIS:1;					 /*  */
        vuint32_t PLDCR:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t LRSLPS:1;					 /*  */
        vuint32_t LDSLPS:1;					 /*  */
        vuint32_t LDPDS:1;					 /*  */
        vuint32_t LRPDS:1;					 /*  */
    } B;
  } PLLLSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :23;					 /*  */
        vuint32_t URXDV:1;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t URPCNT:3;					 /*  */
    } B;
  } UNSRSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t UNRXD:32;					 /*  */
    } B;
  } UNSRDR[9];

};


/* ============================================================================
   ============================= Module: LINFlexD =============================
   ============================================================================ */

struct LINFlexD_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t CCD:1;					 /*  */
        vuint32_t CFD:1;					 /*  */
        vuint32_t LASE:1;					 /*  */
        vuint32_t AUTOWU:1;					 /*  */
        vuint32_t MBL:4;					 /*  */
        vuint32_t BF:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t LBKM:1;					 /*  */
        vuint32_t MME:1;					 /*  */
        vuint32_t SSBL:1;					 /*  */
        vuint32_t RBLM:1;					 /*  */
        vuint32_t SLEEP:1;					 /*  */
        vuint32_t INIT:1;					 /*  */
    } B;
  } LINCR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t SZIE:1;					 /*  */
        vuint32_t OCIE:1;					 /*  */
        vuint32_t BEIE:1;					 /*  */
        vuint32_t CEIE:1;					 /*  */
        vuint32_t HEIE:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t FEIE:1;					 /*  */
        vuint32_t BOIE:1;					 /*  */
        vuint32_t LSIE:1;					 /*  */
        vuint32_t WUIE:1;					 /*  */
        vuint32_t DBFIE:1;					 /*  */
        vuint32_t DBEIETOIE:1;					 /*  */
        vuint32_t DRIE:1;					 /*  */
        vuint32_t DTIE:1;					 /*  */
        vuint32_t HRIE:1;					 /*  */
    } B;
  } LINIER;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t AUTOSYNC_COMP:1;					 /*  */
        vuint32_t RDC:3;					 /*  */
        vuint32_t LINS:4;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t RMB:1;					 /*  */
        vuint32_t DRBNE:1;					 /*  */
        vuint32_t RXbusy:1;					 /*  */
        vuint32_t RDI:1;					 /*  */
        vuint32_t WUF:1;					 /*  */
        vuint32_t DBFF:1;					 /*  */
        vuint32_t DBEF:1;					 /*  */
        vuint32_t DRF:1;					 /*  */
        vuint32_t DTF:1;					 /*  */
        vuint32_t HRF:1;					 /*  */
    } B;
  } LINSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t SZF:1;					 /*  */
        vuint32_t OCF:1;					 /*  */
        vuint32_t BEF:1;					 /*  */
        vuint32_t CEF:1;					 /*  */
        vuint32_t SFEF:1;					 /*  */
        vuint32_t SDEF:1;					 /*  */
        vuint32_t IDPEF:1;					 /*  */
        vuint32_t FEF:1;					 /*  */
        vuint32_t BOF:1;					 /*  */
        vuint32_t  :6;					 /*  */
        vuint32_t NF:1;					 /*  */
    } B;
  } LINESR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t NEF:3;					 /*  */
        vuint32_t DTU:1;					 /*  */
        vuint32_t SBUR:2;					 /*  */
        vuint32_t WLS:1;					 /*  */
        vuint32_t TDFLTFC:3;					 /*  */
        vuint32_t RDFLRFC:3;					 /*  */
        vuint32_t RFBM:1;					 /*  */
        vuint32_t TFBM:1;					 /*  */
        vuint32_t WL1:1;					 /*  */
        vuint32_t PC1:1;					 /*  */
        vuint32_t RxEn:1;					 /*  */
        vuint32_t TxEn:1;					 /*  */
        vuint32_t PC0:1;					 /*  */
        vuint32_t PCE:1;					 /*  */
        vuint32_t WL0:1;					 /*  */
        vuint32_t UART:1;					 /*  */
    } B;
  } UARTCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t SZF:1;					 /*  */
        vuint32_t OCF:1;					 /*  */
        vuint32_t PE:4;					 /*  */
        vuint32_t RMB:1;					 /*  */
        vuint32_t FEF:1;					 /*  */
        vuint32_t BOF:1;					 /*  */
        vuint32_t RDI:1;					 /*  */
        vuint32_t WUF:1;					 /*  */
        vuint32_t RFNE:1;					 /*  */
        vuint32_t TO:1;					 /*  */
        vuint32_t DRFRFE:1;					 /*  */
        vuint32_t DTFTFF:1;					 /*  */
        vuint32_t NF:1;					 /*  */
    } B;
  } UARTSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :21;					 /*  */
        vuint32_t MODE:1;					 /*  */
        vuint32_t IOT:1;					 /*  */
        vuint32_t TOCE:1;					 /*  */
        vuint32_t CNT:8;					 /*  */
    } B;
  } LINTCSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t OC2:8;					 /*  */
        vuint32_t OC1:8;					 /*  */
    } B;
  } LINOCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t RTO:4;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t HTO:7;					 /*  */
    } B;
  } LINTOCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :28;					 /*  */
        vuint32_t FBR:4;					 /*  */
    } B;
  } LINFBRR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t IBR:20;					 /*  */
    } B;
  } LINIBRR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t CF:8;					 /*  */
    } B;
  } LINCFR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t TBDE:1;					 /*  */
        vuint32_t IOBE:1;					 /*  */
        vuint32_t IOPE:1;					 /*  */
        vuint32_t WURQ:1;					 /*  */
        vuint32_t DDRQ:1;					 /*  */
        vuint32_t DTRQ:1;					 /*  */
        vuint32_t ABRQ:1;					 /*  */
        vuint32_t HTRQ:1;					 /*  */
        vuint32_t  :8;					 /*  */
    } B;
  } LINCR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t DFL:6;					 /*  */
        vuint32_t DIR:1;					 /*  */
        vuint32_t CCS:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t ID:6;					 /*  */
    } B;
  } BIDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t DATA3:8;					 /*  */
        vuint32_t DATA2:8;					 /*  */
        vuint32_t DATA1:8;					 /*  */
        vuint32_t DATA0:8;					 /*  */
    } B;
  } BDRL;

  union {
    vuint32_t R;
      struct {
        vuint32_t DATA7:8;					 /*  */
        vuint32_t DATA6:8;					 /*  */
        vuint32_t DATA5:8;					 /*  */
        vuint32_t DATA4:8;					 /*  */
    } B;
  } BDRM;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t FACT:16;					 /*  */
    } B;
  } IFER;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :27;					 /*  */
        vuint32_t IFMI:5;					 /*  */
    } B;
  } IFMI;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t IFM:8;					 /*  */
    } B;
  } IFMR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t DFL:6;					 /* Data Field Length */
        vuint32_t DIR:1;					 /* Direction */
        vuint32_t CCS:1;					 /* Classic Checksum */
        vuint32_t  :2;					 /*  */
        vuint32_t ID:6;					 /* Identifier */
    } B;
  } IFCR[16];

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t TDFBM:1;					 /*  */
        vuint32_t RDFBM:1;					 /*  */
        vuint32_t TDLIS:1;					 /*  */
        vuint32_t RDLIS:1;					 /*  */
        vuint32_t STOP:1;					 /*  */
        vuint32_t SR:1;					 /*  */
    } B;
  } GCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t PTO:12;					 /*  */
    } B;
  } UARTPTO;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t CTO:12;					 /*  */
    } B;
  } UARTCTO;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t DTE:16;					 /*  */
    } B;
  } DMATXE;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t DRE:16;					 /*  */
    } B;
  } DMARXE;

};


/* ============================================================================
   ============================== Module: MC_CGM ==============================
   ============================================================================ */

struct MC_CGM_tag {
  union {
    vuint8_t R;
      struct {
        vuint8_t SDUR:8;					 /*  */
    } B;
  } PCS_SDUR;

  uint8_t MC_CGM_reserved1[3];
  union {
    vuint32_t R;
      struct {
        vuint32_t INIT:16;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t RATE:8;					 /*  */
    } B;
  } PCS_DIVC1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t DIVE:20;					 /*  */
    } B;
  } PCS_DIVE1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t DIVS:20;					 /*  */
    } B;
  } PCS_DIVS1;

  union {
    vuint32_t R;
      struct {
        vuint32_t INIT:16;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t RATE:8;					 /*  */
    } B;
  } PCS_DIVC2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t DIVE:20;					 /*  */
    } B;
  } PCS_DIVE2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t DIVS:20;					 /*  */
    } B;
  } PCS_DIVS2;

  uint8_t MC_CGM_reserved2[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t INIT:16;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t RATE:8;					 /*  */
    } B;
  } PCS_DIVC4;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t DIVE:20;					 /*  */
    } B;
  } PCS_DIVE4;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t DIVS:20;					 /*  */
    } B;
  } PCS_DIVS4;

  uint8_t MC_CGM_reserved3[156];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :31;					 /*  */
        vuint32_t SYS_DIV_RATIO_CHNG:1;					 /*  */
    } B;
  } SC_DIV_RC;

  union {
    vuint32_t R;
      struct {
        vuint32_t SYS_UPD_TYPE:1;					 /*  */
        vuint32_t  :20;					 /*  */
        vuint32_t AUX10_UPD_TYPE:1;					 /*  */
        vuint32_t AUX9_UPD_TYPE:1;					 /*  */
        vuint32_t AUX8_UPD_TYPE:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t AUX6_UPD_TYPE:1;					 /*  */
        vuint32_t AUX5_UPD_TYPE:1;					 /*  */
        vuint32_t AUX4_UPD_TYPE:1;					 /*  */
        vuint32_t AUX3_UPD_TYPE:1;					 /*  */
        vuint32_t AUX2_UPD_TYPE:1;					 /*  */
        vuint32_t AUX1_UPD_TYPE:1;					 /*  */
        vuint32_t AUX0_UPD_TYPE:1;					 /*  */
    } B;
  } DIV_UPD_TYPE;

  union {
    vuint32_t R;
      struct {
        vuint32_t DIV_UPD_TRIGGER:32;					 /*  */
    } B;
  } DIV_UPD_TRIG;

  union {
    vuint32_t R;
      struct {
        vuint32_t SYS_UPD_STAT:1;					 /*  */
        vuint32_t  :20;					 /*  */
        vuint32_t AUX10_UPD_STAT:1;					 /*  */
        vuint32_t AUX9_UPD_STAT:1;					 /*  */
        vuint32_t AUX8_UPD_STAT:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t AUX6_UPD_STAT:1;					 /*  */
        vuint32_t AUX5_UPD_STAT:1;					 /*  */
        vuint32_t AUX4_UPD_STAT:1;					 /*  */
        vuint32_t AUX3_UPD_STAT:1;					 /*  */
        vuint32_t AUX2_UPD_STAT:1;					 /*  */
        vuint32_t AUX1_UPD_STAT:1;					 /*  */
        vuint32_t AUX0_UPD_STAT:1;					 /*  */
    } B;
  } DIV_UPD_STAT;

  uint8_t MC_CGM_reserved4[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t SWTRG:3;					 /*  */
        vuint32_t SWIP:1;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } SC_SS;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t DIV:6;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } SC_DC[3];

  uint8_t MC_CGM_reserved5[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELCTL:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC0_SC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC0_SS;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :11;					 /*  */
        vuint32_t DIV:4;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC0_DC0;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t DIV:7;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC0_DC1;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t DIV:7;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC0_DC2;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t DIV:13;					 /*  */
        vuint32_t  :14;					 /*  */
        vuint32_t DIV_FMT:2;					 /*  */
    } B;
  } AC0_DC3;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t DIV:6;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC0_DC4;

  uint8_t MC_CGM_reserved6[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELCTL:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC1_SC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC1_SS;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t DIV:7;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC1_DC0;

  uint8_t MC_CGM_reserved7[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELCTL:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC2_SC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC2_SS;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t DIV:6;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC2_DC0;

  uint8_t MC_CGM_reserved8[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELCTL:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC3_SC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC3_SS;

  uint8_t MC_CGM_reserved9[24];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELCTL:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC4_SC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC4_SS;

  uint8_t MC_CGM_reserved10[24];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELCTL:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC5_SC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC5_SS;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t DIV:6;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC5_DC0;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t DIV:6;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC5_DC1;

  uint8_t MC_CGM_reserved11[16];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELCTL:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC6_SC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC6_SS;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t DIV:6;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC6_DC0;

  uint8_t MC_CGM_reserved12[52];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELCTL:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC8_SC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC8_SS;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t DIV:6;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC8_DC0;

  uint8_t MC_CGM_reserved13[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELCTL:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC9_SC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC9_SS;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t DIV:6;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC9_DC0;

  uint8_t MC_CGM_reserved14[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELCTL:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC10_SC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t SELSTAT:4;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } AC10_SS;

  union {
    vuint32_t R;
      struct {
        vuint32_t DE:1;					 /*  */
        vuint32_t  :11;					 /*  */
        vuint32_t DIV:4;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } AC10_DC0;

};


/* ============================================================================
   ============================== Module: MC_ME ===============================
   ============================================================================ */

struct MC_ME_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t S_CURRENT_MODE:4;					 /*  */
        vuint32_t S_MTRANS:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t S_PDO:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t S_MVR:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t S_FLA:2;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t S_PLL1:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t S_PLL0:1;					 /*  */
        vuint32_t S_XOSC:1;					 /*  */
        vuint32_t S_IRC:1;					 /*  */
        vuint32_t S_SYSCLK:4;					 /*  */
    } B;
  } GS;

  union {
    vuint32_t R;
      struct {
        vuint32_t TARGET_MODE:4;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t KEY:16;					 /*  */
    } B;
  } MCTL;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t RESET_DEST:1;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t STOP0:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t HALT0:1;					 /*  */
        vuint32_t RUN3:1;					 /*  */
        vuint32_t RUN2:1;					 /*  */
        vuint32_t RUN1:1;					 /*  */
        vuint32_t RUN0:1;					 /*  */
        vuint32_t DRUN:1;					 /*  */
        vuint32_t SAFE:1;					 /*  */
        vuint32_t TEST:1;					 /*  */
        vuint32_t RESET_FUNC:1;					 /*  */
    } B;
  } ME;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t I_ICONF_CC:1;					 /*  */
        vuint32_t I_CONF_CU:1;					 /*  */
        vuint32_t I_ICONF:1;					 /*  */
        vuint32_t I_IMODE:1;					 /*  */
        vuint32_t I_SAFE:1;					 /*  */
        vuint32_t I_MTC:1;					 /*  */
    } B;
  } IS;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t M_ICONF_CC:1;					 /*  */
        vuint32_t M_ICONF_CU:1;					 /*  */
        vuint32_t M_ICONF:1;					 /*  */
        vuint32_t M_IMODE:1;					 /*  */
        vuint32_t M_SAFE:1;					 /*  */
        vuint32_t M_MTC:1;					 /*  */
    } B;
  } IM;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t S_MRIG:1;					 /*  */
        vuint32_t S_MTI:1;					 /*  */
        vuint32_t S_MRI:1;					 /*  */
        vuint32_t S_DMA:1;					 /*  */
        vuint32_t S_NMA:1;					 /*  */
        vuint32_t S_SEA:1;					 /*  */
    } B;
  } IMTS;

  union {
    vuint32_t R;
      struct {
        vuint32_t PREVIOUS_MODE:4;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t MPH_BUSY:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t PMC_PROG:1;					 /*  */
        vuint32_t DBG_MODE:1;					 /*  */
        vuint32_t CCKL_PROG:1;					 /*  */
        vuint32_t PCS_PROG:1;					 /*  */
        vuint32_t SMR:1;					 /*  */
        vuint32_t CDP_PRPH_0_255:1;					 /*  */
        vuint32_t VREG_CSRC_SC:1;					 /*  */
        vuint32_t CSRC_CSRC_SC:1;					 /*  */
        vuint32_t IRC_SC:1;					 /*  */
        vuint32_t SCSRC_SC:1;					 /*  */
        vuint32_t SYSCLK_SW:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t FLASH_SC:1;					 /*  */
        vuint32_t CDP_PRPH_244_255:1;					 /*  */
        vuint32_t CDP_PRPH_192_223:1;					 /*  */
        vuint32_t CDP_PRPH_160_191:1;					 /*  */
        vuint32_t CDP_PRPH_128_159:1;					 /*  */
        vuint32_t CDP_PRPH_96_127:1;					 /*  */
        vuint32_t CDP_PRPH_64_95:1;					 /*  */
        vuint32_t CDP_PRPH_32_63:1;					 /*  */
        vuint32_t CDP_PRPH_0_31:1;					 /*  */
    } B;
  } DMTS;

  uint8_t MC_ME_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t PWRLVL:3;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t PDO:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MVRON:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t FLAON:2;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t PLL1ON:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t PLL0ON:1;					 /*  */
        vuint32_t XOSCON:1;					 /*  */
        vuint32_t IRCON:1;					 /*  */
        vuint32_t SYSCLK:4;					 /*  */
    } B;
  } RESET_MC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t PWRLVL:3;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t PDO:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MVRON:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t FLAON:2;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t PLL10N:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t PLL0ON:1;					 /*  */
        vuint32_t XOSCON:1;					 /*  */
        vuint32_t IRCON:1;					 /*  */
        vuint32_t SYSCLK:4;					 /*  */
    } B;
  } TEST_MC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t PWRLVL:3;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t PDO:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MVRON:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t FLAON:2;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t PLL1ON:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t PLL0ON:1;					 /*  */
        vuint32_t XOSCON:1;					 /*  */
        vuint32_t IRCON:1;					 /*  */
        vuint32_t SYSCLK:4;					 /*  */
    } B;
  } SAFE_MC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t PWRLVL:3;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t PDO:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MVRON:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t FLAON:2;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t PLL1ON:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t PLL0ON:1;					 /*  */
        vuint32_t XOSCON:1;					 /*  */
        vuint32_t IRCON:1;					 /*  */
        vuint32_t SYSCLK:4;					 /*  */
    } B;
  } DRUN_MC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t PWRLVL:3;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t PDO:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MVRON:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t FLAON:2;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t PLL1ON:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t PLL0ON:1;					 /*  */
        vuint32_t XOSCON:1;					 /*  */
        vuint32_t IRCON:1;					 /*  */
        vuint32_t SYSCLK:4;					 /*  */
    } B;
  } RUN_MC[4];

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t PWRLVL:3;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t PDO:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MVRON:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t FLAON:2;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t PLL1ON:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t PLL0ON:1;					 /*  */
        vuint32_t XOSCON:1;					 /*  */
        vuint32_t IRCON:1;					 /*  */
        vuint32_t SYSCLK:4;					 /*  */
    } B;
  } HALT0_MC;

  uint8_t MC_ME_reserved1[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t PWRLVL:3;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t PDO:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t MVRON:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t FLAON:2;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t PLL1ON:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t PLL0ON:1;					 /*  */
        vuint32_t XOSCON:1;					 /*  */
        vuint32_t IRCON:1;					 /*  */
        vuint32_t SYSCLK:4;					 /*  */
    } B;
  } STOP0_MC;

  uint8_t MC_ME_reserved2[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t S_PIT_RTI_1:1;					 /*  */
        vuint32_t S_PIT_RTI_0:1;					 /*  */
        vuint32_t S_DECFILT_0:1;					 /*  */
        vuint32_t S_DECFILT_1:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t S_SIUL2_0:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t S_SIPI_0:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t S_LFAST_0:1;					 /*  */
        vuint32_t  :9;					 /*  */
    } B;
  } PS0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :3;					 /*  */
        vuint32_t S_ADCSD_0:1;					 /*  */
        vuint32_t S_ADCSD_2:1;					 /*  */
        vuint32_t  :13;					 /*  */
        vuint32_t S_JTAGM_0:1;					 /*  */
        vuint32_t  :6;					 /*  */
        vuint32_t S_CRC_0:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t S_DMA_CH_MUX0_2:1;					 /*  */
        vuint32_t  :4;					 /*  */
    } B;
  } PS1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :3;					 /*  */
        vuint32_t S_LINFLEX_0:1;					 /*  */
        vuint32_t S_LINFLEX_2:1;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t S_LINFLEX_M0:1;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t S_FLEXCAN_0:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t S_FLEXCAN_2:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t S_ADCSAR_0:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t S_ADCSAR_2:1;					 /*  */
        vuint32_t  :5;					 /*  */
    } B;
  } PS2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :23;					 /*  */
        vuint32_t S_SENT_0:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t S_EMIOS_0:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t S_DSPI_0:1;					 /*  */
        vuint32_t S_DSPI_2:1;					 /*  */
        vuint32_t S_DSPI_4:1;					 /*  */
        vuint32_t S_DSPI_M0:1;					 /*  */
    } B;
  } PS3;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t S_DMA_CH_MUX3:1;					 /*  */
        vuint32_t  :15;					 /*  */
    } B;
  } PS4;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :3;					 /*  */
        vuint32_t ADC_SD1:1;					 /*  */
        vuint32_t  :21;					 /*  */
        vuint32_t CRC_1:1;					 /*  */
        vuint32_t  :6;					 /*  */
    } B;
  } PS5;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :3;					 /*  */
        vuint32_t LINFLEX_1:1;					 /*  */
        vuint32_t LINFLEX_3:1;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t LINFLEX_M1:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t FLEXCAN1:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t FLEXCAN3:1;					 /*  */
        vuint32_t ETPU:1;					 /*  */
        vuint32_t REACM:1;					 /*  */
        vuint32_t ETPU_SPRAM0:1;					 /*  */
        vuint32_t ETPU_SPRAM1:1;					 /*  */
        vuint32_t ETPU_SCRAM0:1;					 /*  */
        vuint32_t ETPU_SCRAM1:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t ADCSAR_1:1;					 /*  */
        vuint32_t IGF:1;					 /*  */
        vuint32_t ADCSAR_3:1;					 /*  */
        vuint32_t  :4;					 /*  */
    } B;
  } PS6;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t BCTU_1:1;					 /*  */
        vuint32_t  :18;					 /*  */
        vuint32_t SENT_1:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t EMIOS_1:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t DSPI_1:1;					 /*  */
        vuint32_t DSPI_3:1;					 /*  */
        vuint32_t DSPI_M1:1;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } PS7;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t RUN3:1;					 /*  */
        vuint32_t RUN2:1;					 /*  */
        vuint32_t RUN1:1;					 /*  */
        vuint32_t RUN0:1;					 /*  */
        vuint32_t DRUN:1;					 /*  */
        vuint32_t SAFE:1;					 /*  */
        vuint32_t TEST:1;					 /*  */
        vuint32_t RESET:1;					 /*  */
    } B;
  } RUN_PC[8];

  union {
    vuint32_t R;
      struct {
        vuint32_t  :21;					 /*  */
        vuint32_t STOP0:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t HATL0:1;					 /*  */
        vuint32_t  :8;					 /*  */
    } B;
  } LP_PC[8];

  uint8_t MC_ME_reserved3[9];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL9;

  uint8_t MC_ME_reserved4[1];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL11;

  uint8_t MC_ME_reserved5[3];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL15;

  uint8_t MC_ME_reserved6[12];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL28;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL29;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL30;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL31;

  uint8_t MC_ME_reserved7[4];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL36;

  uint8_t MC_ME_reserved8[1];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL38;

  uint8_t MC_ME_reserved9[5];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL45;

  uint8_t MC_ME_reserved10[14];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL59;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL60;

  uint8_t MC_ME_reserved11[8];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL69;

  uint8_t MC_ME_reserved12[1];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL71;

  uint8_t MC_ME_reserved13[6];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL78;

  uint8_t MC_ME_reserved14[1];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL80;

  uint8_t MC_ME_reserved15[4];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL85;

  uint8_t MC_ME_reserved16[5];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL91;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL92;

  uint8_t MC_ME_reserved17[3];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL96;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL97;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL98;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL99;

  uint8_t MC_ME_reserved18[2];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL102;

  uint8_t MC_ME_reserved19[1];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL104;

  uint8_t MC_ME_reserved20[38];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL143;

  uint8_t MC_ME_reserved21[22];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL166;

  uint8_t MC_ME_reserved22[21];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL188;

  uint8_t MC_ME_reserved23[7];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL196;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL197;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL198;

  uint8_t MC_ME_reserved24[3];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL202;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL203;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL204;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL205;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL206;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL207;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL208;

  uint8_t MC_ME_reserved25[1];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL210;

  uint8_t MC_ME_reserved26[2];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL213;

  uint8_t MC_ME_reserved27[5];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL219;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL220;

  uint8_t MC_ME_reserved28[4];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL225;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL226;

  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL227;

  uint8_t MC_ME_reserved29[2];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL230;

  uint8_t MC_ME_reserved30[1];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL232;

  uint8_t MC_ME_reserved31[18];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :1;					 /*  */
        vuint8_t DBG_F:1;					 /*  */
        vuint8_t LP_CFG:3;					 /*  */
        vuint8_t RUN_CFG:3;					 /*  */
    } B;
  } PCTL251;

  uint8_t MC_ME_reserved32[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :29;					 /*  */
        vuint32_t S_CORE2:1;					 /*  */
        vuint32_t S_CORE1:1;					 /*  */
        vuint32_t S_CORE0:1;					 /*  */
    } B;
  } CS;

  union {
    vuint16_t R;
      struct {
        vuint16_t  :5;					 /*  */
        vuint16_t STOP0:1;					 /*  */
        vuint16_t  :1;					 /*  */
        vuint16_t HALT0:1;					 /*  */
        vuint16_t RUN3:1;					 /*  */
        vuint16_t RUN2:1;					 /*  */
        vuint16_t RUN1:1;					 /*  */
        vuint16_t RUN0:1;					 /*  */
        vuint16_t DRUN:1;					 /*  */
        vuint16_t SAFE:1;					 /*  */
        vuint16_t TEST:1;					 /*  */
        vuint16_t RESET:1;					 /*  */
    } B;
  } CCTL[3];

  uint8_t MC_ME_reserved33[22];
  union {
    vuint32_t R;
      struct {
        vuint32_t ADDR:30;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t RMC:1;					 /*  */
    } B;
  } CADDR[3];

};


/* ============================================================================
   ============================== Module: MC_PCU ==============================
   ============================================================================ */

struct MC_PCU_tag {
  uint8_t MC_PCU_reserved0[64];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :31;					 /*  */
        vuint32_t PD0:1;					 /*  */
    } B;
  } PSTAT;

};


/* ============================================================================
   ============================== Module: MC_RGM ==============================
   ============================================================================ */

struct MC_RGM_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :6;					 /*  */
        vuint32_t F_PMC:1;					 /*  */
        vuint32_t F_VOR:1;					 /* Flag for Voltage Out of Range */
        vuint32_t F_TSR:1;					 /* Flag for Temparature sensor */
        vuint32_t  :12;					 /*  */
        vuint32_t F_JTAG:1;					 /* Flag for JTAG destructive reset */
        vuint32_t F_FIF:1;					 /* Flag for Flash Initialization Failure */
        vuint32_t F_EDR:1;					 /* Flag for 'Functional' reset Escalation */
        vuint32_t  :1;					 /*  */
        vuint32_t F_SSR:1;					 /* WHAT IS THE NAME FOR THIS BIT */
        vuint32_t F_SUF:1;					 /* Flag for STCU Unrecoverable Fault */
        vuint32_t F_FFRR:1;					 /* Flag for FCCU Failure to React reset */
        vuint32_t F_SOFT_DEST:1;					 /* Flag for Software destructive reset */
        vuint32_t  :1;					 /*  */
        vuint32_t F_PORST:1;					 /* Flag for External PowerOn reset */
        vuint32_t F_POR:1;					 /* Flag for Power-On reset */
    } B;
  } DES;

  uint8_t MC_RGM_reserved0[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */ 
        vuint32_t D_VOR:1;					 /*  */
        vuint32_t D_TSR:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t D_JTAG:1;					 /*  */
        vuint32_t D_FIF:1;					 /*  */
        vuint32_t D_EDR:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t D_SUF:1;					 /*  */
        vuint32_t D_FFRR:1;					 /*  */
        vuint32_t D_SOFT_DEST:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t D_PORST:1;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } DERD;

  uint8_t MC_RGM_reserved1[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t AR_TSR:1;					 /*  */
        vuint32_t  :21;					 /*  */
        vuint32_t AR_PORST:1;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } DEAR;

  uint8_t MC_RGM_reserved2[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t BE_VOR:1;					 /*  */
        vuint32_t BE_TSR:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t BE_JTAG:1;					 /*  */
        vuint32_t BE_FIF:1;					 /*  */
        vuint32_t BE_EDR:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t BE_SUF:1;					 /*  */
        vuint32_t BE_FFRR:1;					 /*  */
        vuint32_t BE_SOFT_DEST:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t BE_PORST:1;					 /*  */
        vuint32_t BE_POR:1;					 /*  */
    } B;
  } DBRE;

  uint8_t MC_RGM_reserved3[716];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t F_VOR_FUNC:1;					 /*  */
        vuint32_t F_TSR_FUNC:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t F_JTAG_FUNC:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t F_FCCU_SOFT:1;					 /*  */
        vuint32_t F_FCCU_HARD:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t F_SOFT_FUNC:1;					 /*  */
        vuint32_t F_ST_DONE:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t F_EXR:1;					 /*  */
    } B;
  } FES;

  uint8_t MC_RGM_reserved4[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t D_VOR_FUNC:1;					 /*  */
        vuint32_t D_TSR_FUNC:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t D_JTAG_FUNC:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t D_FCCU_SOFT:1;					 /*  */
        vuint32_t D_FCCU_HARD:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t D_SOFT_FUNC:1;					 /*  */
        vuint32_t D_ST_DONE:1;					 /*  */
        vuint32_t  :2;					 /*  */
    } B;
  } FERD;

  uint8_t MC_RGM_reserved5[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t AR_VOR_FUNC:1;					 /*  */
        vuint32_t AR_TSR_FUNC:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t AR_JTAG_FUNC:1;					 /*  */
        vuint32_t  :10;					 /*  */
    } B;
  } FEAR;

  uint8_t MC_RGM_reserved6[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t BE_VOR_FUNC:1;					 /*  */
        vuint32_t BE_TSR_FUNC:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t BE_JTAG_FUNC:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t BE_FCCU_SOFT:1;					 /*  */
        vuint32_t BE_FCCU_HARD:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t BE_SOFT_FUNC:1;					 /*  */
        vuint32_t BE_ST_DONE:1;					 /*  */
        vuint32_t  :1;					   /* Reserved */
        vuint32_t BE_ESR0:1;					 /*  */
    } B;
  } FBRE;

  uint8_t MC_RGM_reserved7[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :7;					 /*  */
        vuint32_t SS_VOR_FUNC:1;					 /*  */
        vuint32_t SS_TSR_FUNC:1;					 /*  */
        vuint32_t  :12;					 /*  */
        vuint32_t SS_JTAG_FUNC:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t SS_FCCU_SOFT:1;					 /*  */
        vuint32_t SS_FCCU_HARD:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t SS_SOFT_FUNC:1;					 /*  */
        vuint32_t SS_ST_DONE:1;					 /*  */
        vuint32_t  :1;					 /* Reserved */
        vuint32_t SS_EXR:1;					 /*  */
    } B;
  } FESS;

  uint8_t MC_RGM_reserved8[704];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :4;					 /*  */
        vuint8_t FRET:4;					 /*  */
    } B;
  } FRET;

  uint8_t MC_RGM_reserved9[3];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :4;					 /*  */
        vuint8_t DRET:4;					 /*  */
    } B;
  } DRET;

};


/* ============================================================================
   =============================== Module: MEMU ===============================
   ============================================================================ */

struct MEMU_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t SWR:1;					 /*  */
        vuint32_t  :15;					 /*  */
    } B;
  } CTRL;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :11;					 /*  */
        vuint32_t PR_CE:1;					 /*  */
        vuint32_t PR_UCE:1;					 /*  */
        vuint32_t PR_CEO:1;					 /*  */
        vuint32_t PR_UCO:1;					 /*  */
        vuint32_t PR_EBO:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t F_CE:1;					 /*  */
        vuint32_t F_UCE:1;					 /*  */
        vuint32_t F_CEO:1;					 /*  */
        vuint32_t F_UCO:1;					 /*  */
        vuint32_t F_EBO:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t SR_CE:1;					 /*  */
        vuint32_t SR_UCE:1;					 /*  */
        vuint32_t SR_CEO:1;					 /*  */
        vuint32_t SR_UCO:1;					 /*  */
        vuint32_t SR_EBO:1;					 /*  */
    } B;
  } ERR_FLAG;

  uint8_t MEMU_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :11;					 /*  */
        vuint32_t FR_PR_CE:1;					 /*  */
        vuint32_t FR_PR_UCE:1;					 /*  */
        vuint32_t FR_PR_CEO:1;					 /*  */
        vuint32_t FR_PR_UCO:1;					 /*  */
        vuint32_t FR_PR_EBO:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t FR_F_CE:1;					 /*  */
        vuint32_t FR_F_UCE:1;					 /*  */
        vuint32_t FR_F_CEO:1;					 /*  */
        vuint32_t FR_F_UCO:1;					 /*  */
        vuint32_t FR_F_EBO:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t FR_SR_CE:1;					 /*  */
        vuint32_t FR_SR_UCE:1;					 /*  */
        vuint32_t FR_SR_CEO:1;					 /*  */
        vuint32_t FR_SR_UCO:1;					 /*  */
        vuint32_t FR_SR_EBO:1;					 /*  */
    } B;
  } DEBUG;

  uint8_t MEMU_reserved1[16];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t VLD:1;					 /*  */
          vuint32_t  :23;					 /*  */
          vuint32_t BAD_BIT:8;					 /*  */
      } B;
    } STS;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t ERR_ADD:32;					 /*  */
      } B;
    } ADDR;
  } SYS_RAM_CERR[10];

  union {
    vuint32_t R;
      struct {
        vuint32_t VLD:1;					 /*  */
        vuint32_t  :31;					 /*  */
    } B;
  } SYS_RAM_UNCERR_STS;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;					 /*  */
    } B;
  } SYS_RAM_UNCERR_ADDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t OFLW:32;					 /*  */
    } B;
  } SYS_RAM_OFLW0;

  uint8_t MEMU_reserved2[1444];
  union {
    vuint32_t R;
      struct {
        vuint32_t VLD:1;					 /*  */
        vuint32_t  :23;					 /*  */
        vuint32_t BAD_BIT:8;					 /*  */
    } B;
  } PERIPH_RAM_CERR_STS0;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;					 /*  */
    } B;
  } PERIPH_RAM_CERR_ADDR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t VLD:1;					 /*  */
        vuint32_t  :23;					 /*  */
        vuint32_t BAD_BIT:8;					 /*  */
    } B;
  } PERIPH_RAM_CERR_STS1;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;					 /*  */
    } B;
  } PERIPH_RAM_CERR_ADDR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t VLD:1;					 /*  */
        vuint32_t  :31;					 /*  */
    } B;
  } PERIPH_RAM_UNCERR_STS;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;					 /*  */
    } B;
  } PERIPH_RAM_UNCERR_ADDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t OFLW:32;					 /*  */
    } B;
  } PERIPH_RAM_OFLW0;

  uint8_t MEMU_reserved3[1508];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t VLD:1;					 /*  */
          vuint32_t  :23;					 /*  */
          vuint32_t BAD_BIT:8;					 /*  */
      } B;
    } STS;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t ERR_ADD:32;					 /*  */
      } B;
    } ADDR;
  } FLASH_CERR[20];

  union {
    vuint32_t R;
      struct {
        vuint32_t VLD:1;					 /*  */
        vuint32_t  :31;					 /*  */
    } B;
  } FLASH_UNCERR_STS;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;					 /*  */
    } B;
  } FLASH_UNCERR_ADDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t OFLW:32;					 /*  */
    } B;
  } FLASH_OFLW0;

};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

struct PASS_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t CNS:1;					 /*  */
        vuint32_t JUN:1;					 /*  */
        vuint32_t  :27;					 /*  */
        vuint32_t LIFE:3;					 /*  */
    } B;
  } LCSTAT;

  uint8_t PASS_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :30;					 /*  */
        vuint32_t GRP:2;					 /*  */
    } B;
  } CHSEL;

  uint8_t PASS_reserved1[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :28;					 /*  */
        vuint32_t CMST:4;					 /*  */
    } B;
  } CSTAT;

  uint8_t PASS_reserved2[12];
  union {
    vuint32_t R;
      struct {
        vuint32_t PW32:32;					 /*  */
    } B;
  } CIN[8];

  uint8_t PASS_reserved3[192];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t TSLOCK:1;					 /*  */
          vuint32_t ATSL:1;					 /*  */
          vuint32_t LOWLOCK:14;					 /*  */
          vuint32_t MIDLOCK:16;					 /*  */
      } B;
    } LOCK0;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :16;					 /*  */
          vuint32_t HIGHLOCK:16;					 /*  */
      } B;
    } LOCK1;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t L256LCK_L:32;					 /*  */
      } B;
    } LOCK2;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t PGL:1;					 /*  */
          vuint32_t DBL:1;					 /*  */
          vuint32_t MO:1;					 /*  */
          vuint32_t  :1;					 /*  */
          vuint32_t MSTR:4;					 /*  */
          vuint32_t  :3;					 /*  */
          vuint32_t RL4:1;					 /*  */
          vuint32_t RL3:1;					 /*  */
          vuint32_t RL2:1;					 /*  */
          vuint32_t RL1:1;					 /*  */
          vuint32_t RL0:1;					 /*  */
          vuint32_t L256LCK_U:16;					 /*  */
      } B;
    } LOCK3;
  } PG[4];

};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

struct PCM_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :21;					 /*  */
        vuint32_t ACCERR:1;					 /*  */
        vuint32_t WBEN:1;					 /*  */
        vuint32_t RBEN:1;					 /*  */
        vuint32_t FXSBE:8;					 /*  */
    } B;
  } FBOMCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :13;					 /*  */
        vuint32_t PRE_DMA:1;					 /* Pending read enable (PRE) DMA */
        vuint32_t BRE_DMA:1;					 /* Burst read enable (BRE) DMA */
        vuint32_t BWE_DMA:1;					 /* Burst write enable (BWE) DMA */
        vuint32_t  :5;					 /*  */
        vuint32_t PRE_S0:1;					 /* Pending read enable (PRE) S0 */
        vuint32_t BRE_S0:1;					 /* Burst read enable (BRE) S0. */
        vuint32_t BWE_S0:1;					 /* Burst write enable (BWE) S0. */
        vuint32_t  :5;					 /*  */
        vuint32_t PRE_M3:1;					 /* Pending read enable (PRE) M3. */
        vuint32_t BRE_M3:1;					 /* Burst read enable (BRE) M3. */
        vuint32_t BWE_M3:1;					 /* Burst write enable (BWE) M3. */
    } B;
  } IAHB_BE1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :13;					 /*  */
        vuint32_t PRE_SIPI:1;					 /* Pending read enable (PRE) SIPI. */
        vuint32_t BRE_SIPI:1;					 /* Burst read enable (BRE) SIPI. */
        vuint32_t BWE_SIPI:1;					 /* Burst write enable (BWE) SIPI. */
        vuint32_t  :13;					 /*  */
        vuint32_t PRE_FEC:1;					 /* Pending read enable (PRE) FEC. */
        vuint32_t BRE_FEC:1;					 /* Burst read enable (BRE) FEC. */
        vuint32_t BWE_FEC:1;					 /* Burst write enable (BWE) FEC. */
    } B;
  } IAHB_BE2;

};


/* ============================================================================
   ============================== Module: PFLASH ==============================
   ============================================================================ */

struct PFLASH_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t P0_M15PFE:1;					 /*  */
        vuint32_t P0_M14PFE:1;					 /*  */
        vuint32_t P0_M13PFE:1;					 /*  */
        vuint32_t P0_M12PFE:1;					 /*  */
        vuint32_t P0_M11PFE:1;					 /*  */
        vuint32_t P0_M10PFE:1;					 /*  */
        vuint32_t P0_M9PFE:1;					 /*  */
        vuint32_t P0_M8PFE:1;					 /*  */
        vuint32_t P0_M7PFE:1;					 /*  */
        vuint32_t P0_M6PFE:1;					 /*  */
        vuint32_t P0_M5PFE:1;					 /*  */
        vuint32_t P0_M4PFE:1;					 /*  */
        vuint32_t P0_M3PFE:1;					 /*  */
        vuint32_t P0_M2PFE:1;					 /*  */
        vuint32_t P0_M1PFE:1;					 /*  */
        vuint32_t P0_M0PFE:1;					 /*  */
        vuint32_t APC:3;					 /*  */
        vuint32_t RWSC:5;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t P0_DPFEN:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t P0_IPFEN:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t P0_PFLIM:2;					 /*  */
        vuint32_t P0_BFEN:1;					 /*  */
    } B;
  } PFCR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t P1_M15PFE:1;					 /*  */
        vuint32_t P1_M14PFE:1;					 /*  */
        vuint32_t P1_M13PFE:1;					 /*  */
        vuint32_t P1_M12PFE:1;					 /*  */
        vuint32_t P1_M11PFE:1;					 /*  */
        vuint32_t P1_M10PFE:1;					 /*  */
        vuint32_t P1_M9PFE:1;					 /*  */
        vuint32_t P1_M8PFE:1;					 /*  */
        vuint32_t P1_M7PFE:1;					 /*  */
        vuint32_t P1_M6PFE:1;					 /*  */
        vuint32_t P1_M5PFE:1;					 /*  */
        vuint32_t P1_M4PFE:1;					 /*  */
        vuint32_t P1_M3PFE:1;					 /*  */
        vuint32_t P1_M2PFE:1;					 /*  */
        vuint32_t P1_M1PFE:1;					 /*  */
        vuint32_t P1_M0PFE:1;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t P1_DPFEN:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t P1_IPFEN:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t P1_PFLIM:2;					 /*  */
        vuint32_t P1_BFEN:1;					 /*  */
    } B;
  } PFCR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t P0_WCFG:2;					 /*  */
        vuint32_t P1_WCFG:2;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t BDRM:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t BAF_DIS:1;					 /*  */
        vuint32_t ARBM:2;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t  :12;					 /*  */
    } B;
  } PFCR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t M0AP:2;					 /*  */
        vuint32_t M1AP:2;					 /*  */
        vuint32_t M2AP:2;					 /*  */
        vuint32_t M3AP:2;					 /*  */
        vuint32_t M4AP:2;					 /*  */
        vuint32_t M5AP:2;					 /*  */
        vuint32_t M6AP:2;					 /*  */
        vuint32_t M7AP:2;					 /*  */
        vuint32_t M8AP:2;					 /*  */
        vuint32_t M9AP:2;					 /*  */
        vuint32_t M10AP:2;					 /*  */
        vuint32_t M11AP:2;					 /*  */
        vuint32_t M12AP:2;					 /*  */
        vuint32_t M13AP:2;					 /*  */
        vuint32_t M14AP:2;					 /*  */
        vuint32_t M15AP:2;					 /*  */
    } B;
  } PFAPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :23;					 /*  */
        vuint32_t SAFE_CAL:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t IRMEN:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t GRMEN:1;					 /*  */
    } B;
  } PFCRCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t CRD0EN:1;					 /*  */
        vuint32_t CRD1EN:1;					 /*  */
        vuint32_t CRD2EN:1;					 /*  */
        vuint32_t CRD3EN:1;					 /*  */
        vuint32_t CRD4EN:1;					 /*  */
        vuint32_t CRD5EN:1;					 /*  */
        vuint32_t CRD6EN:1;					 /*  */
        vuint32_t CRD7EN:1;					 /*  */
        vuint32_t CRD8EN:1;					 /*  */
        vuint32_t CRD9EN:1;					 /*  */
        vuint32_t CRD10EN:1;					 /*  */
        vuint32_t CRD11EN:1;					 /*  */
        vuint32_t CRD12EN:1;					 /*  */
        vuint32_t CRD13EN:1;					 /*  */
        vuint32_t CRD14EN:1;					 /*  */
        vuint32_t CRD15EN:1;					 /*  */
        vuint32_t CRD16EN:1;					 /*  */
        vuint32_t CRD17EN:1;					 /*  */
        vuint32_t CRD18EN:1;					 /*  */
        vuint32_t CRD19EN:1;					 /*  */
        vuint32_t CRD20EN:1;					 /*  */
        vuint32_t CRD21EN:1;					 /*  */
        vuint32_t CRD22EN:1;					 /*  */
        vuint32_t CRD23EN:1;					 /*  */
        vuint32_t CRD24EN:1;					 /*  */
        vuint32_t CRD25EN:1;					 /*  */
        vuint32_t CRD26EN:1;					 /*  */
        vuint32_t CRD27EN:1;					 /*  */
        vuint32_t CRD28EN:1;					 /*  */
        vuint32_t CRD29EN:1;					 /*  */
        vuint32_t CRD30EN:1;					 /*  */
        vuint32_t CRD31EN:1;					 /*  */
    } B;
  } PFCRDE;

  uint8_t PFLASH_reserved0[232];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t LSTARTADDR:28;					 /*  */
          vuint32_t  :4;					 /*  */
      } B;
    } Word0;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t PSTARTADDR:28;					 /*  */
          vuint32_t  :4;					 /*  */
      } B;
    } Word1;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t M0EN:1;					 /*  */
          vuint32_t M1EN:1;					 /*  */
          vuint32_t M2EN:1;					 /*  */
          vuint32_t M3EN:1;					 /*  */
          vuint32_t M4EN:1;					 /*  */
          vuint32_t M5EN:1;					 /*  */
          vuint32_t M6EN:1;					 /*  */
          vuint32_t M7EN:1;					 /*  */
          vuint32_t M8EN:1;					 /*  */
          vuint32_t M9EN:1;					 /*  */
          vuint32_t M10EN:1;					 /*  */
          vuint32_t M11EN:1;					 /*  */
          vuint32_t M12EN:1;					 /*  */
          vuint32_t M13EN:1;					 /*  */
          vuint32_t M14EN:1;					 /*  */
          vuint32_t M15EN:1;					 /*  */
          vuint32_t  :11;					 /*  */
          vuint32_t CRDSize:5;					 /*  */
      } B;
    } Word2;
  
    uint8_t PFLASH_reserved1[4];
  } PFCRD[32];

};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

struct PIT_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :29;					 /*  */
        vuint32_t MDIS_RTI:1;					 /* Module Disable - RTI section */
        vuint32_t MDIS:1;					 /* Module Disable - (PIT section) */
        vuint32_t FRZ:1;					 /* Freeze */
    } B;
  } MCR;

  uint8_t PIT_reserved0[220];
  union {
    vuint32_t R;
      struct {
        vuint32_t LTH:32;					 /* Life Timer value */
    } B;
  } LTMR64H;

  union {
    vuint32_t R;
      struct {
        vuint32_t LTL:32;					 /* Life Timer value */
    } B;
  } LTMR64L;

  uint8_t PIT_reserved1[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t TSV:32;					 /* Timer Start Value */
    } B;
  } RTI_LDVAL;

  union {
    vuint32_t R;
      struct {
        vuint32_t TVL:32;					 /* Current Timer Value */
    } B;
  } RTI_CVAL;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :30;					 /*  */
        vuint32_t TIE:1;					 /* Timer Interrupt Enable */
        vuint32_t TEN:1;					 /* Timer Enable Bit */
    } B;
  } RTI_TCTRL;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :31;					 /*  */
        vuint32_t TIF:1;					 /* Timer Interrupt Flag. */
    } B;
  } RTI_TFLG;

  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t TSV:32;					 /* Timer Start Value */
      } B;
    } LDVAL;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t TVL:32;					 /* Current Timer Value */
      } B;
    } CVAL;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :29;					 /*  */
          vuint32_t CHN:1;					 /* Chain Mode */
          vuint32_t TIE:1;					 /* Timer Interrupt Enable */
          vuint32_t TEN:1;					 /* Timer Enable */
      } B;
    } TCTRL;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :31;					 /*  */
          vuint32_t TIF:1;					 /* Timer Interrupt Flag */
      } B;
    } TFLG;
  } CH[8];

};


/* ============================================================================
   ============================== Module: PLLDIG ==============================
   ============================================================================ */

struct PLLDIG_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t CLKCFG:2;					 /*  */
        vuint32_t EXPDIE:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t LOLIE:1;					 /*  */
        vuint32_t LOLRE:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } PLL0CR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t EXTPDF:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t LOLF:1;					 /*  */
        vuint32_t LOCK:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } PLL0SR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t RFDPHI1:4;					 /* PHI1 reduced frequency divider. */
        vuint32_t  :5;					 /*  */
        vuint32_t RFDPHI:6;					 /* PHI reduced frequency divider. */
        vuint32_t  :1;					 /*  */
        vuint32_t PREDIV:3;					 /* Input clock predivider. */
        vuint32_t  :5;					 /*  */
        vuint32_t MFD:7;					 /* Loop multiplication factor divider. */
    } B;
  } PLL0DV;

  uint8_t PLLDIG_reserved0[20];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t CLKCFG:2;					 /*  */
        vuint32_t EXPDIE:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t LOLIE:1;					 /*  */
        vuint32_t LOLRE:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } PLL1CR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t EXTPDF:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t LOLF:1;					 /*  */
        vuint32_t LOCK:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } PLL1SR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t  :6;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t RFDPHI:6;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t MFD:7;					 /* Loop multiplication factor divider. */
    } B;
  } PLL1DV;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MODEN:1;					 /* Modulation enable. */
        vuint32_t MODSEL:1;					 /* Modulation selection. */
        vuint32_t MODPRD:13;					 /* Modulation period. */
        vuint32_t  :1;					 /*  */
        vuint32_t INCSTP:15;					 /* Increment step. */
    } B;
  } PLL1FM;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t FDEN:1;					 /* Fractional Divide Enable */
        vuint32_t  :12;					 /*  */
        vuint32_t DTHDIS:2;					 /* Dither Disable. */
        vuint32_t  :4;					 /*  */
        vuint32_t FRCDIV:12;					 /*  */
    } B;
  } PLL1FD;

};


/* ============================================================================
   =============================== Module: PMC ================================
   ============================================================================ */

struct PMC_tag {
  uint8_t PMC_reserved0[164];
  union {
    vuint32_t R;
      struct {
        vuint32_t TS_EN:1;					 /* Temperature Sensor interrupts Enable */
        vuint32_t  :25;					 /*  */
        vuint32_t TS1_3IE:1;					 /* Temperature Sensor 1 input 3 Interrupt Enable. */
        vuint32_t TS1_2IE:1;					 /* Temperature Sensor 1 input 2 Interrupt Enable. */
        vuint32_t TS1_0IE:1;					 /* Temperature Sensor 1 input 0 Interrupt Enable. */
        vuint32_t TS0_3IE:1;					 /* Temperature Sensor 0 input 3 Interrupt Enable. */
        vuint32_t TS0_2IE:1;					 /* Temperature Sensor 0 input 2 Interrupt Enable. */
        vuint32_t TS0_0IE:1;					 /* Temperature Sensor 0 input 0 Interrupt Enable. */
    } B;
  } TS_IER;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t TEMP1_3:1;					 /*  */
        vuint32_t TEMP1_2:1;					 /*  */
        vuint32_t TEMP1_0:1;					 /*  */
        vuint32_t TEMP0_3:1;					 /*  */
        vuint32_t TEMP0_2:1;					 /*  */
        vuint32_t TEMP0_0:1;					 /*  */
    } B;
  } ESR_TD;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t TEMP1_3:1;					 /*  */
        vuint32_t TEMP1_2:1;					 /*  */
        vuint32_t TEMP1_0:1;					 /*  */
        vuint32_t TEMP0_3:1;					 /*  */
        vuint32_t TEMP0_2:1;					 /*  */
        vuint32_t TEMP0_0:1;					 /*  */
    } B;
  } REE_TD;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t TEMP1_3:1;					 /* TEMP1_3 Reset Event Select. */
        vuint32_t TEMP1_2:1;					 /* TEMP1_2 Reset Event Select. */
        vuint32_t TEMP1_0:1;					 /* TEMP1_0 Reset Event Select. */
        vuint32_t TEMP0_3:1;					 /* TEMP0_3 Reset Event Select. */
        vuint32_t TEMP0_2:1;					 /* TEMP0_2 Reset Event Select. */
        vuint32_t TEMP0_0:1;					 /* TEMP0_0 Reset Event Select. */
    } B;
  } RES_TD;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :17;					 /*  */
        vuint32_t TS1_TRIM_ADJ:5;					 /*  */
        vuint32_t TS1_DOUT_EN:1;					 /*  */
        vuint32_t TS1_AOUT_EN:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t TS0_TRIM_ADJ:5;					 /*  */
        vuint32_t TS0_DOUT_EN:1;					 /*  */
        vuint32_t TS0_AOUT_EN:1;					 /*  */
    } B;
  } CTL_TD;

  uint8_t PMC_reserved1[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :31;					 /*  */
        vuint32_t TSNS_FAULT:1;					 /* Temperature Sensor Fault injection. */
    } B;
  } TS_FIR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t TS1_SELTSH:1;					 /* Temperature Sensor 1 Select Threshold. */
        vuint32_t TS1MODE:3;					 /* Temperature Sensor 1 test Mode. */
        vuint32_t TS0_SELTSH:1;					 /* Temperature Sensor 0 Select Threshold. */
        vuint32_t TS0MODE:3;					 /* Temperature Sensor 0 test Mode. */
    } B;
  } TS_TMC;

  union {
    vuint32_t R;
      struct {
        vuint32_t PMC_ENABLE:1;					 /* PMC Enable Control */
        vuint32_t  :10;					 /*  */
        vuint32_t VREG_LFASTPLL:1;					 /*  */
        vuint32_t VREG_FLASH:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t VREG_1P2_MAIN:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t LVD_JTAG:1;					 /*  */
        vuint32_t LVD_PMC:1;					 /*  */
        vuint32_t LVD_FEC:1;					 /*  */
        vuint32_t LVD_MSC_3:1;					 /*  */
        vuint32_t LVD_MSC:1;					 /*  */
        vuint32_t LVD_SAR_ADC:1;					 /*  */
        vuint32_t LVD_SD_ADC:1;					 /*  */
        vuint32_t HVD_SAR_ADC:1;					 /*  */
        vuint32_t HVD_SD_ADC:1;					 /*  */
        vuint32_t LVD_IO:1;					 /*  */
        vuint32_t HVD_FLASH:1;					 /*  */
        vuint32_t LVD_FLASH:1;					 /*  */
        vuint32_t HVD_HV:1;					 /*  */
        vuint32_t HVD_CORE:1;					 /*  */
        vuint32_t LVD_CORE_HOT:1;					 /*  */
        vuint32_t LVD_CORE_COLD:1;					 /* LVD Core Enable Disbale Bit */
    } B;
  } CR_ENB;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t STTW:12;					 /*  */
    } B;
  } STTW;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :14;					 /*  */
        vuint32_t ST_RESULT:1;					 /*  */
        vuint32_t ST_DONE:1;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t ST_MODE:2;					 /* Self Test mode bits for testing of LVDs and HVDs. */
        vuint32_t VD_ST_CTRL:6;					 /*  */
    } B;
  } SELF_TEST_UM_VD_REG;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :28;					 /*  */
        vuint32_t STEST_FAULT:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t HVD_FAULT:1;					 /* High Voltage Detect Fault injection. */
        vuint32_t LVD_FAULT:1;					 /* Low Voltage Detect Fault injection. */
    } B;
  } FIR;

  union {
    vuint32_t R;
      struct {
        vuint32_t PMC_ENABLE:1;					 /* PMC Enable Control */
        vuint32_t  :15;					 /*  */
        vuint32_t LVD_JTAG:1;					 /*  */
        vuint32_t LVD_PMC:1;					 /*  */
        vuint32_t LVD_FEC:1;					 /*  */
        vuint32_t LVD_MSC_3:1;					 /*  */
        vuint32_t LVD_MSC_5:1;					 /*  */
        vuint32_t LVD_SAR_ADC:1;					 /*  */
        vuint32_t LVD_SD_ADC:1;					 /*  */
        vuint32_t HVD_SAR_ADC:1;					 /*  */
        vuint32_t HVD_SD_ADC:1;					 /*  */
        vuint32_t LVD_IO:1;					 /*  */
        vuint32_t HVD_FLASH:1;					 /*  */
        vuint32_t LVD_FLASH:1;					 /*  */
        vuint32_t HVD_HV:1;					 /*  */
        vuint32_t HVD_CORE:1;					 /*  */
        vuint32_t LVD_CORE_HOT:1;					 /*  */
        vuint32_t LVD_CORE_COLD:1;					 /* LVD Core Enable Disbale Bit */
    } B;
  } VD_INTR_ENB;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t LVD_JTAG:1;					 /*  */
        vuint32_t LVD_PMC:1;					 /*  */
        vuint32_t LVD_FEC:1;					 /*  */
        vuint32_t LVD_MSC_3:1;					 /*  */
        vuint32_t LVD_MSC_5:1;					 /*  */
        vuint32_t LVD_SAR_ADC:1;					 /*  */
        vuint32_t LVD_SD_ADC:1;					 /*  */
        vuint32_t HVD_SAR_ADC:1;					 /*  */
        vuint32_t HVD_SD_ADC:1;					 /*  */
        vuint32_t LVD_IO:1;					 /*  */
        vuint32_t HVD_FLASH:1;					 /*  */
        vuint32_t LVD_FLASH:1;					 /*  */
        vuint32_t HVD_HV:1;					 /*  */
        vuint32_t HVD_CORE:1;					 /*  */
        vuint32_t LVD_CORE_HOT:1;					 /*  */
        vuint32_t LVD_CORE_COLD:1;					 /*  */
    } B;
  } VD_EVENT_STATUS;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t LVD_JTAG:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t LVD_FEC:1;					 /*  */
        vuint32_t LVD_MSC_3:1;					 /*  */
        vuint32_t LVD_MSC_5:1;					 /*  */
        vuint32_t LVD_SAR_ADC:1;					 /*  */
        vuint32_t LVD_SD_ADC:1;					 /*  */
        vuint32_t HVD_SAR_ADC:1;					 /*  */
        vuint32_t HVD_SD_ADC:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t HVD_FLASH:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t HVD_HV:1;					 /*  */
        vuint32_t HVD_CORE:1;					 /*  */
        vuint32_t LVD_CORE_HOT:1;					 /*  */
        vuint32_t LVD_CORE_COLD:1;					 /* LVD Core Enable Disbale Bit */
    } B;
  } REE;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t LVD_JTAG:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t LVD_FEC:1;					 /*  */
        vuint32_t LVD_MSC_3:1;					 /*  */
        vuint32_t LVD_MSC_5:1;					 /*  */
        vuint32_t LVD_SAR_ADC:1;					 /*  */
        vuint32_t LVD_SD_ADC:1;					 /*  */
        vuint32_t HVD_SAR_ADC:1;					 /*  */
        vuint32_t HVD_SD_ADC:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t HVD_FLASH:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t HVD_HV:1;					 /*  */
        vuint32_t HVD_CORE:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t LVD_CORE_COLD:1;					 /* LVD Core Enable Disbale Bit */
    } B;
  } RES;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t STND_BY_RAM_BO_CLR:1;					 /*  */
        vuint32_t STND_BY_RAM_BR_DETCT:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t ADC_CS:6;					 /*  */
    } B;
  } ADC_CS;

};


/* ============================================================================
   ============================== Module: PRAMC ===============================
   ============================================================================ */

struct PRAMC_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t PRI:2;					 /* AHB port arbitration mode. */
        vuint32_t P1_BO_DIS:1;					 /* Port p1 read burst optimization disable. */
        vuint32_t P0_BO_DIS:1;					 /* Port p0 read burst optimization disable. */
        vuint32_t  :5;					 /*  */
        vuint32_t FT_DIS:1;					 /* Flow through disabled. */
    } B;
  } PRCR1;

};


/* ============================================================================
   ============================== Module: REACM2 ==============================
   ============================================================================ */

struct REACM2_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t OVRC:1;					 /* Overrun Detection Flag Clear */
        vuint32_t MDIS:1;					 /* Module Disable */
        vuint32_t FRZ:1;					 /* Freeze Control */
        vuint32_t  :1;					 /*  */
        vuint32_t FREN:1;					 /* Freeze Enable */
        vuint32_t TPREN:1;					 /* Timer Prescaler Enable */
        vuint32_t HPREN:1;					 /* Hold Timer Prescaler Enable */
        vuint32_t GIEN:1;					 /* Global Interrupt Enable */
        vuint32_t OVREN:1;					 /* Overrun Detection Interrupt Enable */
        vuint32_t  :23;					 /*  */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t HPRE:12;					 /* Hold Timer Prescaler */
        vuint32_t  :8;					 /*  */
        vuint32_t TPRE:8;					 /* Timer Prescaler */
    } B;
  } TCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :6;					 /*  */
        vuint32_t WREN1:1;					 /* Write Enable Bit for THRADC1 */
        vuint32_t WREN0:1;					 /* Write Enable Bit for THRADC0 */
        vuint32_t  :12;					 /*  */
        vuint32_t THRADC1:4;					 /* ADC result Router value for Threshold Bank address one */
        vuint32_t  :4;					 /*  */
        vuint32_t THRADC0:4;					 /* ADC result Router for Threshold Bank address zero */
    } B;
  } THRR;

  uint8_t REACM2_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t ADC_TAG:4;					 /* TAG value */
        vuint32_t ADC_RESULT:16;					 /* ADC conversion result value */
    } B;
  } SINR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t PERPRESC:8;					 /* Period prescaler rate value */
        vuint32_t PER:16;					 /* Period time value */
    } B;
  } PCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t DLY:16;					 /* Delay value between two consecutive channel period pulses */
    } B;
  } PSCR;

  uint8_t REACM2_reserved1[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t OVR:1;					 /* Overrun Detection Flag */
        vuint32_t  :21;					 /*  */
        vuint32_t EF9:1;					 /* Error Flag */
        vuint32_t EF8:1;					 /* Error Flag */
        vuint32_t EF7:1;					 /* Error Flag */
        vuint32_t EF6:1;					 /* Error Flag */
        vuint32_t EF5:1;					 /* Error Flag */
        vuint32_t EF4:1;					 /* Error Flag */
        vuint32_t EF3:1;					 /* Error Flag */
        vuint32_t EF2:1;					 /* Error Flag */
        vuint32_t EF1:1;					 /* Error Flag */
        vuint32_t EF0:1;					 /* Error Flag */
    } B;
  } GEFR;

  uint8_t REACM2_reserved2[220];
  struct{
    union {
      vuint32_t R;
        struct {
          vuint32_t CHEN:2;					 /* Channel Enable Bits */
          vuint32_t SWMC:1;					 /* Software Modulation Control bit */
          vuint32_t MAXLEN:1;					 /* ADC result Maximum Limit Interrupt Enable bit */
          vuint32_t OCDFEN:1;					 /* OCDF Interrupt Enable bit */
          vuint32_t SCDFEN:1;					 /* SCDF Interrupt Enable bit */
          vuint32_t TAEREN:1;					 /* TAER Interrupt Enable bit */
          vuint32_t SQEREN:1;					 /* Modulation Word Sequence Error Interrupt Enable */
          vuint32_t RAEREN:1;					 /* Resource Allocation Error Interrupt Enable */
          vuint32_t DMAEN:1;					 /* Direct Memory Access Enable bit */
          vuint32_t CHOFF:1;					 /* Output Disable bit */
          vuint32_t SDCM:1;					 /* Short Detection Counting Mode */
          vuint32_t  :1;					 /*  */
          vuint32_t DOFF:3;					 /* Drive Off Control field */
          vuint32_t  :5;					 /*  */
          vuint32_t BSB:3;					 /* Bank Support Bits */
          vuint32_t  :3;					 /*  */
          vuint32_t MODULATION_ADDR:5;					 /* Address for Modulation Control Bank */
      } B;
    } CHCR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :2;					 /*  */
          vuint32_t MODACT:1;				 /* Modulation Active Flag */
          vuint32_t MAXL:1;					 /* ADC Maximum Limit Detection Flag */
          vuint32_t OCDF:1;					 /* Open Circuit Detection Flag */
          vuint32_t SCDF:1;					 /* Short Circuit Detection Flag */
          vuint32_t TAER:1;					 /* Timer Allocation Error */
          vuint32_t SQER:1;					 /* Modulation Word Sequence Error Flag */
          vuint32_t RAER:1;					 /* Resource Allocation Error Flag */
          vuint32_t CHOUT:3;					 /* Channel Output Monitoring bits */
          vuint32_t  :7;					 /*  */
          vuint32_t MAXLC:1;					 /* ADC Maximum Limit Flag Clear */
          vuint32_t OCDFC:1;					 /* Open Circuit Detection Flag Clear */
          vuint32_t SCDFC:1;					 /* Short Circuit Detection Flag clear */
          vuint32_t TAERC:1;					 /* TAER Clear bit */
          vuint32_t SQERC:1;					 /* Modulation Word Sequence Error Flag clear */
          vuint32_t RAERC:1;					 /* Resource Allocation Error Flag clear */
          vuint32_t  :1;					 /*  */
          vuint32_t MODULATION_POINTER:6;				 /* Modulation bank address generated by the channel */
      } B;
    } CHSR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :12;					 /*  */
          vuint32_t ADCR:4;					 /* ADC result router field */
          vuint32_t  :12;					 /*  */
          vuint32_t CHIR:4;					 /* Channel Input router field */
      } B;
    } CHRR;
     uint8_t REACM2_reserved10[4];

  }CH[10];
    
    
  uint8_t REACM2_reserved3[352];
  
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t SHARED_TIMER:16;					 /* Timer Value */
    } B;
  } STBK[5];

  uint8_t REACM2_reserved4[108];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t HOLD_TIM:12;					 /* Hold Timer Value */
    } B;
  } HOTBK[5];

  uint8_t REACM2_reserved5[108];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t THRESHOLD_VALUE:16;					 /* Threshold Value */
    } B;
  } THBK[32];

  uint8_t REACM2_reserved6[384];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t ADC_MAX_LIMIT:16;					 /* Maximum Limit allowed for the ADC result */
    } B;
  } ADCMAX;

  uint8_t REACM2_reserved7[124];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t RANGE_PWD:12;					 /* Range Pulse Width */
    } B;
  } RANGE_PWD;

  uint8_t REACM2_reserved8[60];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t MIN_PWD:12;					 /* Minimum Pulse Width */
    } B;
  } MIN_PWD;

  uint8_t REACM2_reserved9[60];
  union {
    vuint32_t R;
      struct {
        vuint32_t LOOP:1;					 /* Loop Control Bit */
        vuint32_t IOSS:1;					 /* Initial Output State Selection */
        vuint32_t DMA:1;					 /* DMA bit */
        vuint32_t MM:2;					 /* Modulation Mode */
        vuint32_t  :1;					 /*  */
        vuint32_t SM:2;					 /* Sequencer Mode */
        vuint32_t  :1;					 /*  */
        vuint32_t HOD:3;					 /* High Output Drive */
        vuint32_t  :1;					 /*  */
        vuint32_t LOD:3;					 /* Low Output Drive */
        vuint32_t  :2;					 /*  */
        vuint32_t THRESPT:5;					 /* Threshold Pointer */
        vuint32_t  :1;					 /*  */
        vuint32_t STPT:3;					 /* Shared Timer Pointer */
        vuint32_t  :2;					 /*  */
        vuint32_t HDOFFTPT:3;					 /* Hold on/off Pointer */
    } B;
  } MWBK[32];

};


/* ============================================================================
   ============================== Module: SDADC ===============================
   ============================================================================ */

struct SDADC_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :3;					 /*  */
        vuint32_t PDR:5;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t PGAN:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t HPFEN:1;					 /*  */
        vuint32_t WDGEN:1;					 /*  */
        vuint32_t TRIGEDSEL:2;					 /*  */
        vuint32_t TRIGEN:1;					 /*  */
        vuint32_t TRIGSEL:4;					 /*  */
        vuint32_t FRZ:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t VCOMSEL:1;					 /*  */
        vuint32_t WRMODE:1;					 /*  */
        vuint32_t GECEN:1;					 /* Accurate Gain Error Mode Enable */
        vuint32_t MODE:1;					 /*  */
        vuint32_t EN:1;					 /*  */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t BIASEN:8;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t ANCHSEL_WRAP:3;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t ANCHSEL:3;					 /*  */
    } B;
  } CSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t RESET_KEY:16;					 /*  */
    } B;
  } RKR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :13;					 /*  */
        vuint32_t ANCHSEL_CNT:3;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t DFEF:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t WTHH:1;					 /*  */
        vuint32_t WTHL:1;					 /*  */
        vuint32_t CDVF:1;					 /*  */
        vuint32_t DFORF:1;					 /*  */
        vuint32_t DFFF:1;					 /*  */
    } B;
  } SFR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :14;					 /*  */
        vuint32_t WTHDIRS:1;					 /*  */
        vuint32_t DFFDIRS:1;					 /*  */
        vuint32_t GDIGE:1;					 /*  */
        vuint32_t  :11;					 /*  */
        vuint32_t WTHDIRE:1;					 /*  */
        vuint32_t CDVEE:1;					 /*  */
        vuint32_t DFORIE:1;					 /*  */
        vuint32_t DFFDIRE:1;					 /*  */
    } B;
  } RSER;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t OSD:8;					 /*  */
    } B;
  } OSDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t FTHLD:4;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t FSIZE:2;					 /*  */
        vuint32_t FE:1;					 /*  */
    } B;
  } FCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t ST_KEY:16;					 /*  */
    } B;
  } STKR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t CDATA:16;					 /*  */
    } B;
  } CDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t THRH:16;					 /*  */
        vuint32_t THRL:16;					 /*  */
    } B;
  } WTHHLR;

};


/* ============================================================================
   ============================== Module: SEMA42 ==============================
   ============================================================================ */

struct SEMA42_tag {
      union {
        vuint8_t R;
          struct {
            vuint8_t  :4;                                                                                /*  */
            vuint8_t GTFSM:4;                                                                  /* Gate Finite State Machine. */
        }B;
      } GATE[16];

       uint8_t SEMA42_reserved0[48];

      union                                                
      {
         vuint16_t R ;
         struct {
                  vuint16_t RSTGDP:8;                                                                              /*  */
                  vuint16_t RSTGTN:8;                                                                              /*  */
                }B;

         struct {
                  vuint16_t  :2;                                                                                
                  vuint16_t RSTGSM:2;                                                                             
                  vuint16_t RSTGMS:4;                                                                             
                  vuint16_t RSTGTN:8;                                                                              
                }B_R;

      }RSTGT;
    };


/* ============================================================================
   =============================== Module: SIPI ===============================
   ============================================================================ */

struct SIPI_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t TC:1;					 /* Send Trigger Command. */
        vuint32_t  :8;					 /*  */
        vuint32_t WL:2;					 /* Word Length Transfer. */
        vuint32_t CHEN:1;					 /* Channel Enable. */
        vuint32_t ST:1;					 /* Streaming Transfer. */
        vuint32_t IDT:1;					 /* ID Read Request Transfer. */
        vuint32_t RRT:1;					 /* Read Request Transfer. */
        vuint32_t WRT:1;					 /* Write Request Transfer. */
        vuint32_t DEN:1;					 /* DMA Enable. */
    } B;
  } CCR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t RAR:1;					 /*  */
        vuint32_t TID:3;					 /* Transaction ID of transmitted frame. */
        vuint32_t ACKR:1;					 /*  */
        vuint32_t CB:1;					 /* Channel Busy. */
        vuint32_t  :2;					 /*  */
    } B;
  } CSR0;

  uint8_t SIPI_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WAIE:1;					 /* Write Acknowledge Interrupt Enable. */
        vuint32_t RAIE:1;					 /* Read Answer Interrupt Enable. */
        vuint32_t TCIE:1;					 /* Trigger Command Interrupt Enable. */
        vuint32_t TOIE:1;					 /* Timeout Error Interrupt Enabled. */
        vuint32_t TIDIE:1;					 /* Transaction ID Error Interrupt Enable. */
        vuint32_t ACKIE:1;					 /* Acknowledge Error Interrupt Enable. */
    } B;
  } CIR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t TOR:8;					 /* Timeout value for transmitted requests. */
    } B;
  } CTOR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t CRCI:16;					 /*  */
        vuint32_t CRCT:16;					 /*  */
    } B;
  } CCRC0;

  union {
    vuint32_t R;
      struct {
        vuint32_t CAR:32;					 /*  */
    } B;
  } CAR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t CDR:32;					 /*  */
    } B;
  } CDR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t TC:1;					 /* Send Trigger Command. */
        vuint32_t  :8;					 /*  */
        vuint32_t WL:2;					 /* Word Length Transfer. */
        vuint32_t CHEN:1;					 /* Channel Enable. */
        vuint32_t ST:1;					 /*  */
        vuint32_t IDT:1;					 /* ID Read Request Transfer. */
        vuint32_t RRT:1;					 /*  */
        vuint32_t WRT:1;					 /*  */
        vuint32_t DEN:1;					 /* DMA Enable. */
    } B;
  } CCR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t RAR:1;					 /*  */
        vuint32_t TID:3;					 /*  */
        vuint32_t ACKR:1;					 /*  */
        vuint32_t CB:1;					 /* Channel Busy. */
        vuint32_t  :2;					 /*  */
    } B;
  } CSR1;

  uint8_t SIPI_reserved1[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WAIE:1;					 /*  */
        vuint32_t RAIE:1;					 /*  */
        vuint32_t TCIE:1;					 /*  */
        vuint32_t TOIE:1;					 /*  */
        vuint32_t TIDIE:1;					 /*  */
        vuint32_t ACKIE:1;					 /*  */
    } B;
  } CIR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t TOR:8;					 /* Timeout value for transmitted requests. */
    } B;
  } CTOR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t CRCI:16;					 /*  */
        vuint32_t CRCT:16;					 /*  */
    } B;
  } CCRC1;

  union {
    vuint32_t R;
      struct {
        vuint32_t CAR:32;					 /*  */
    } B;
  } CAR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t CDR:32;					 /*  */
    } B;
  } CDR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t TC:1;					 /* Send Trigger Command. */
        vuint32_t  :8;					 /*  */
        vuint32_t WL:2;					 /* Word Length Transfer. */
        vuint32_t CHEN:1;					 /* Channel Enable. */
        vuint32_t ST:1;					 /*  */
        vuint32_t IDT:1;					 /* ID Read Request Transfer. */
        vuint32_t RRT:1;					 /* Read Request Transfer. */
        vuint32_t WRT:1;					 /*  */
        vuint32_t DEN:1;					 /*  */
    } B;
  } CCR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t RAR:1;					 /*  */
        vuint32_t TID:3;					 /* Transaction ID of transmitted frame. */
        vuint32_t ACKR:1;					 /*  */
        vuint32_t CB:1;					 /* Channel Busy. */
        vuint32_t  :2;					 /*  */
    } B;
  } CSR2;

  uint8_t SIPI_reserved2[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WAIE:1;					 /*  */
        vuint32_t RAIE:1;					 /*  */
        vuint32_t TCIE:1;					 /*  */
        vuint32_t TOIE:1;					 /*  */
        vuint32_t TIDIE:1;					 /*  */
        vuint32_t ACKIE:1;					 /*  */
    } B;
  } CIR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t TOR:8;					 /*  */
    } B;
  } CTOR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t CRCI:16;					 /*  */
        vuint32_t CRCT:16;					 /*  */
    } B;
  } CCRC2;

  union {
    vuint32_t R;
      struct {
        vuint32_t CAR:32;					 /*  */
    } B;
  } CAR2;

  union {
    vuint32_t R;
      struct {
        vuint32_t CDR2:32;					 /*  */
    } B;
  } CDR2[8];

  union {
    vuint32_t R;
      struct {
        vuint32_t  :15;					 /*  */
        vuint32_t TC:1;					 /* Send Trigger Command. */
        vuint32_t  :8;					 /*  */
        vuint32_t WL:2;					 /* Word Length Transfer. */
        vuint32_t CHEN:1;					 /* Channel Enable. */
        vuint32_t ST:1;					 /* Streaming Transfer. */
        vuint32_t IDT:1;					 /* ID Read Request Transfer. */
        vuint32_t RRT:1;					 /*  */
        vuint32_t WRT:1;					 /*  */
        vuint32_t DEN:1;					 /* DMA Enable. */
    } B;
  } CCR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t RAR:1;					 /*  */
        vuint32_t TID:3;					 /* Transaction ID of transmitted frame. */
        vuint32_t ACKR:1;					 /*  */
        vuint32_t CB:1;					 /* Channel Busy. */
        vuint32_t  :2;					 /*  */
    } B;
  } CSR3;

  uint8_t SIPI_reserved3[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t WAIE:1;					 /*  */
        vuint32_t RAIE:1;					 /*  */
        vuint32_t TCIE:1;					 /*  */
        vuint32_t TOIE:1;					 /*  */
        vuint32_t TIDIE:1;					 /*  */
        vuint32_t ACKIE:1;					 /*  */
    } B;
  } CIR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /*  */
        vuint32_t TOR:8;					 /* Timeout value for transmitted requests. */
    } B;
  } CTOR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t CRCI:16;					 /*  */
        vuint32_t CRCT:16;					 /*  */
    } B;
  } CCRC3;

  union {
    vuint32_t R;
      struct {
        vuint32_t CAR:32;					 /*  */
    } B;
  } CAR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t CDR:32;					 /*  */
    } B;
  } CDR3;

  union {
    vuint32_t R;
      struct {
        vuint32_t FRZ:1;					 /* Freeze Enable */
        vuint32_t  :1;					 /*  */
        vuint32_t HALT:1;					 /* Halt Mode Enable */
        vuint32_t  :2;					 /*  */
        vuint32_t PRSCLR:11;					 /* Timeout counter prescaler */
        vuint32_t AID:2;					 /* Address Increment/Decrement */
        vuint32_t  :3;					 /*  */
        vuint32_t CRCIE:1;					 /* CRC Error Interrupt Enable */
        vuint32_t MCRIE:1;					 /* Max Count Reached Interrupt Enable */
        vuint32_t  :4;					 /*  */
        vuint32_t CHNSB:1;					 /* Channel coding select bit. */
        vuint32_t TEN:1;					 /* Target Enable */
        vuint32_t INIT:1;					 /* Initialization Mode */
        vuint32_t MOEN:1;					 /* Module Enable */
        vuint32_t SR:1;					 /* Soft Reset */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t FRZACK:1;					 /*  */
        vuint32_t LPMACK:1;					 /* Low Power Mode Acknowledge. */
        vuint32_t  :19;					 /*  */
        vuint32_t GCRCE:1;					 /*  */
        vuint32_t MCR:1;					 /* Maximum Count Reached. */
        vuint32_t  :1;					 /*  */
        vuint32_t TE:4;					 /*  */
        vuint32_t STATE:4;					 /*  */
    } B;
  } SR;

  union {
    vuint32_t R;
      struct {
        vuint32_t MXCNT:30;					 /*  */
        vuint32_t  :2;					 /*  */
    } B;
  } MAXCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t ADRLD:30;					 /*  */
        vuint32_t  :2;					 /*  */
    } B;
  } ARR;

  union {
    vuint32_t R;
      struct {
        vuint32_t ADCNT:30;					 /* Feflects the count value of address counter at target node. */
        vuint32_t  :2;					 /*  */
    } B;
  } ACR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :5;					 /*  */
        vuint32_t TOE3:1;					 /*  */
        vuint32_t TIDE3:1;					 /*  */
        vuint32_t ACKE3:1;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t TOE2:1;					 /*  */
        vuint32_t TIDE2:1;					 /*  */
        vuint32_t ACKE2:1;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t TOE1:1;					 /*  */
        vuint32_t TIDE1:1;					 /*  */
        vuint32_t ACKE1:1;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t TOE0:1;					 /*  */
        vuint32_t TIDE0:1;					 /*  */
        vuint32_t ACKE0:1;					 /*  */
    } B;
  } ERR;

};


/* ============================================================================
   ============================== Module: SIUL2 ===============================
   ============================================================================ */

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t PARTNUM:16;					 /* MCU Part Number */
        vuint32_t ED:1;					 /*  */
        vuint32_t PKG:5;					 /* Package Settings */
        vuint32_t  :2;					 /*  */
        vuint32_t MAJOR_MASK:4;					 /* Major Mask Revision */
        vuint32_t MINOR_MASK:4;					 /* Minor Mask Revision */
    } B;
  } MIDR1;

  union {
    vuint32_t R;
      struct {
        vuint32_t SF:1;					 /* Manufacturer */
        vuint32_t FLASH_SIZE_1:4;					 /* Coarse granularity for flash memory size */
        vuint32_t FLASH_SIZE_2:4;					 /* Fine granularity for flash memory size */
        vuint32_t  :7;					 /*  */
        vuint32_t PARTNUM:8;					 /* ASCII character in MCU Part Number */
        vuint32_t  :8;					 /*  */
    } B;
  } MIDR2;

  uint8_t SIUL2_reserved1[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t EIF31:1;					 /* External Interrupt Status Flag 31 */
        vuint32_t EIF30:1;					 /* External Interrupt Status Flag 30 */
        vuint32_t EIF29:1;					 /* External Interrupt Status Flag 29 */
        vuint32_t EIF28:1;					 /* External Interrupt Status Flag 28 */
        vuint32_t EIF27:1;					 /* External Interrupt Status Flag 27 */
        vuint32_t EIF26:1;					 /* External Interrupt Status Flag 26 */
        vuint32_t EIF25:1;					 /* External Interrupt Status Flag 25 */
        vuint32_t EIF24:1;					 /* External Interrupt Status Flag 24 */
        vuint32_t EIF23:1;					 /* External Interrupt Status Flag 23 */
        vuint32_t EIF22:1;					 /* External Interrupt Status Flag 22 */
        vuint32_t EIF21:1;					 /* External Interrupt Status Flag 21 */
        vuint32_t EIF20:1;					 /* External Interrupt Status Flag 20 */
        vuint32_t EIF19:1;					 /* External Interrupt Status Flag 19 */
        vuint32_t EIF18:1;					 /* External Interrupt Status Flag 18 */
        vuint32_t EIF17:1;					 /* External Interrupt Status Flag 17 */
        vuint32_t EIF16:1;					 /* External Interrupt Status Flag 16 */
        vuint32_t EIF15:1;					 /* External Interrupt Status Flag 15 */
        vuint32_t EIF14:1;					 /* External Interrupt Status Flag 14 */
        vuint32_t EIF13:1;					 /* External Interrupt Status Flag 13 */
        vuint32_t EIF12:1;					 /* External Interrupt Status Flag 12 */
        vuint32_t EIF11:1;					 /* External Interrupt Status Flag 11 */
        vuint32_t EIF10:1;					 /* External Interrupt Status Flag 10 */
        vuint32_t EIF9:1;					 /* External Interrupt Status Flag 9 */
        vuint32_t EIF8:1;					 /* External Interrupt Status Flag 8 */
        vuint32_t EIF7:1;					 /* External Interrupt Status Flag 7 */
        vuint32_t EIF6:1;					 /* External Interrupt Status Flag 6 */
        vuint32_t EIF5:1;					 /* External Interrupt Status Flag 5 */
        vuint32_t EIF4:1;					 /* External Interrupt Status Flag 4 */
        vuint32_t EIF3:1;					 /* External Interrupt Status Flag 3 */
        vuint32_t EIF2:1;					 /* External Interrupt Status Flag 2 */
        vuint32_t EIF1:1;					 /* External Interrupt Status Flag 1 */
        vuint32_t EIF0:1;					 /* External Interrupt Status Flag 0 */
    } B;
  } DISR0;

  uint8_t SIUL2_reserved2[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t EIRE31:1;					 /*  */
        vuint32_t EIRE30:1;					 /*  */
        vuint32_t EIRE29:1;					 /*  */
        vuint32_t EIRE28:1;					 /*  */
        vuint32_t EIRE27:1;					 /*  */
        vuint32_t EIRE26:1;					 /*  */
        vuint32_t EIRE25:1;					 /*  */
        vuint32_t EIRE24:1;					 /*  */
        vuint32_t EIRE23:1;					 /*  */
        vuint32_t EIRE22:1;					 /*  */
        vuint32_t EIRE21:1;					 /*  */
        vuint32_t EIRE20:1;					 /*  */
        vuint32_t EIRE19:1;					 /*  */
        vuint32_t EIRE18:1;					 /*  */
        vuint32_t EIRE17:1;					 /*  */
        vuint32_t EIRE16:1;					 /*  */
        vuint32_t EIRE15:1;					 /*  */
        vuint32_t EIRE14:1;					 /*  */
        vuint32_t EIRE13:1;					 /*  */
        vuint32_t EIRE12:1;					 /*  */
        vuint32_t EIRE11:1;					 /*  */
        vuint32_t EIRE10:1;					 /*  */
        vuint32_t EIRE9:1;					 /*  */
        vuint32_t EIRE8:1;					 /*  */
        vuint32_t EIRE7:1;					 /*  */
        vuint32_t EIRE6:1;					 /*  */
        vuint32_t EIRE5:1;					 /*  */
        vuint32_t EIRE4:1;					 /*  */
        vuint32_t EIRE3:1;					 /*  */
        vuint32_t EIRE2:1;					 /*  */
        vuint32_t EIRE1:1;					 /*  */
        vuint32_t EIRE0:1;					 /*  */
    } B;
  } DIRER0;

  uint8_t SIUL2_reserved3[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t DIRSR31:1;					 /*  */
        vuint32_t DIRSR30:1;					 /*  */
        vuint32_t DIRSR29:1;					 /*  */
        vuint32_t DIRSR28:1;					 /*  */
        vuint32_t DIRSR27:1;					 /*  */
        vuint32_t DIRSR26:1;					 /*  */
        vuint32_t DIRSR25:1;					 /*  */
        vuint32_t DIRSR24:1;					 /*  */
        vuint32_t DIRSR23:1;					 /*  */
        vuint32_t DIRSR22:1;					 /*  */
        vuint32_t DIRSR21:1;					 /*  */
        vuint32_t DIRSR20:1;					 /*  */
        vuint32_t DIRSR19:1;					 /*  */
        vuint32_t DIRSR18:1;					 /*  */
        vuint32_t DIRSR17:1;					 /*  */
        vuint32_t DIRSR16:1;					 /*  */
        vuint32_t DIRSR15:1;					 /*  */
        vuint32_t DIRSR14:1;					 /*  */
        vuint32_t DIRSR13:1;					 /*  */
        vuint32_t DIRSR12:1;					 /*  */
        vuint32_t DIRSR11:1;					 /*  */
        vuint32_t DIRSR10:1;					 /*  */
        vuint32_t DIRSR9:1;					 /*  */
        vuint32_t DIRSR8:1;					 /*  */
        vuint32_t DIRSR7:1;					 /*  */
        vuint32_t DIRSR6:1;					 /*  */
        vuint32_t DIRSR5:1;					 /*  */
        vuint32_t DIRSR4:1;					 /*  */
        vuint32_t DIRSR3:1;					 /*  */
        vuint32_t DIRSR2:1;					 /*  */
        vuint32_t DIRSR1:1;					 /*  */
        vuint32_t DIRSR0:1;					 /*  */
    } B;
  } DIRSR0;

  uint8_t SIUL2_reserved4[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t IREE31:1;					 /*  */
        vuint32_t IREE30:1;					 /*  */
        vuint32_t IREE29:1;					 /*  */
        vuint32_t IREE28:1;					 /*  */
        vuint32_t IREE27:1;					 /*  */
        vuint32_t IREE26:1;					 /*  */
        vuint32_t IREE25:1;					 /*  */
        vuint32_t IREE24:1;					 /*  */
        vuint32_t IREE23:1;					 /*  */
        vuint32_t IREE22:1;					 /*  */
        vuint32_t IREE21:1;					 /*  */
        vuint32_t IREE20:1;					 /*  */
        vuint32_t IREE19:1;					 /*  */
        vuint32_t IREE18:1;					 /*  */
        vuint32_t IREE17:1;					 /*  */
        vuint32_t IREE16:1;					 /*  */
        vuint32_t IREE15:1;					 /*  */
        vuint32_t IREE14:1;					 /*  */
        vuint32_t IREE13:1;					 /*  */
        vuint32_t IREE12:1;					 /*  */
        vuint32_t IREE11:1;					 /*  */
        vuint32_t IREE10:1;					 /*  */
        vuint32_t IREE9:1;					 /*  */
        vuint32_t IREE8:1;					 /*  */
        vuint32_t IREE7:1;					 /*  */
        vuint32_t IREE6:1;					 /*  */
        vuint32_t IREE5:1;					 /*  */
        vuint32_t IREE4:1;					 /*  */
        vuint32_t IREE3:1;					 /*  */
        vuint32_t IREE2:1;					 /*  */
        vuint32_t IREE1:1;					 /*  */
        vuint32_t IREE0:1;					 /*  */
    } B;
  } IREER0;

  uint8_t SIUL2_reserved5[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t IFEE31:1;					 /*  */
        vuint32_t IFEE30:1;					 /*  */
        vuint32_t IFEE29:1;					 /*  */
        vuint32_t IFEE28:1;					 /*  */
        vuint32_t IFEE27:1;					 /*  */
        vuint32_t IFEE26:1;					 /*  */
        vuint32_t IFEE25:1;					 /*  */
        vuint32_t IFEE24:1;					 /*  */
        vuint32_t IFEE23:1;					 /*  */
        vuint32_t IFEE22:1;					 /*  */
        vuint32_t IFEE21:1;					 /*  */
        vuint32_t IFEE20:1;					 /*  */
        vuint32_t IFEE19:1;					 /*  */
        vuint32_t IFEE18:1;					 /*  */
        vuint32_t IFEE17:1;					 /*  */
        vuint32_t IFEE16:1;					 /*  */
        vuint32_t IFEE15:1;					 /*  */
        vuint32_t IFEE14:1;					 /*  */
        vuint32_t IFEE13:1;					 /*  */
        vuint32_t IFEE12:1;					 /*  */
        vuint32_t IFEE11:1;					 /*  */
        vuint32_t IFEE10:1;					 /*  */
        vuint32_t IFEE9:1;					 /*  */
        vuint32_t IFEE8:1;					 /*  */
        vuint32_t IFEE7:1;					 /*  */
        vuint32_t IFEE6:1;					 /*  */
        vuint32_t IFEE5:1;					 /*  */
        vuint32_t IFEE4:1;					 /*  */
        vuint32_t IFEE3:1;					 /*  */
        vuint32_t IFEE2:1;					 /*  */
        vuint32_t IFEE1:1;					 /*  */
        vuint32_t IFEE0:1;					 /*  */
    } B;
  } IFEER0;

  uint8_t SIUL2_reserved6[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t IFE31:1;					 /*  */
        vuint32_t IFE30:1;					 /*  */
        vuint32_t IFE29:1;					 /*  */
        vuint32_t IFE28:1;					 /*  */
        vuint32_t IFE27:1;					 /*  */
        vuint32_t IFE26:1;					 /*  */
        vuint32_t IFE25:1;					 /*  */
        vuint32_t IFE24:1;					 /*  */
        vuint32_t IFE23:1;					 /*  */
        vuint32_t IFE22:1;					 /*  */
        vuint32_t IFE21:1;					 /*  */
        vuint32_t IFE20:1;					 /*  */
        vuint32_t IFE19:1;					 /*  */
        vuint32_t IFE18:1;					 /*  */
        vuint32_t IFE17:1;					 /*  */
        vuint32_t IFE16:1;					 /*  */
        vuint32_t IFE15:1;					 /*  */
        vuint32_t IFE14:1;					 /*  */
        vuint32_t IFE13:1;					 /*  */
        vuint32_t IFE12:1;					 /*  */
        vuint32_t IFE11:1;					 /*  */
        vuint32_t IFE10:1;					 /*  */
        vuint32_t IFE9:1;					 /*  */
        vuint32_t IFE8:1;					 /*  */
        vuint32_t IFE7:1;					 /*  */
        vuint32_t IFE6:1;					 /*  */
        vuint32_t IFE5:1;					 /*  */
        vuint32_t IFE4:1;					 /*  */
        vuint32_t IFE3:1;					 /*  */
        vuint32_t IFE2:1;					 /*  */
        vuint32_t IFE1:1;					 /*  */
        vuint32_t IFE0:1;					 /*  */
    } B;
  } IFER0;

  uint8_t SIUL2_reserved7[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :28;					 /*  */
        vuint32_t MAXCNT:4;					 /* Maximum Interrupt Filter Counter setting */
    } B;
  } IFMCR[32];

  union {
    vuint32_t R;
      struct {
        vuint32_t  :28;					 /*  */
        vuint32_t IFCP:4;					 /* Interrupt Filter Clock Prescaler setting */
    } B;
  } IFCPR;

  uint8_t SIUL2_reserved8[60];
  union {
    vuint16_t R;
      struct {
        vuint16_t UDR15:1;					 /*  */
        vuint16_t UDR14:1;					 /*  */
        vuint16_t UDR13:1;					 /*  */
        vuint16_t UDR12:1;					 /*  */
        vuint16_t UDR11:1;					 /*  */
        vuint16_t UDR10:1;					 /*  */
        vuint16_t UDR9:1;					 /*  */
        vuint16_t UDR8:1;					 /*  */
        vuint16_t UDR7:1;					 /*  */
        vuint16_t UDR6:1;					 /*  */
        vuint16_t UDR5:1;					 /*  */
        vuint16_t UDR4:1;					 /*  */
        vuint16_t UDR3:1;					 /*  */
        vuint16_t UDR2:1;					 /*  */
        vuint16_t UDR1:1;					 /*  */
        vuint16_t UDR0:1;					 /*  */
    } B;
  } UDR0;

  uint8_t SIUL2_reserved9[318];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :2;					 /*  */
        vuint32_t OERC:2;					 /* Output Edge Rate Control */
        vuint32_t  :2;					 /*  */
        vuint32_t ODC:2;					 /* Output Drive Control */
        vuint32_t SMC:1;					 /* Safe Mode Control */
        vuint32_t APC:1;					 /* Analog Pad Control */
        vuint32_t ILS:2;					 /* Input Level Selection */
        vuint32_t IBE:1;					 /* Input Buffer Enable */
        vuint32_t HYS:1;					 /* Input Hysteresis */
        vuint32_t WPDE:1;					 /* Weak Pulldown Enable */
        vuint32_t WPUE:1;					 /* Weak Pullup Enable */
        vuint32_t INV:1;					 /* Invert */
        vuint32_t  :7;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t SSS:4;					 /* Source Signal Select */
    } B;
  } MSCR0_255[256];

  uint8_t SIUL2_reserved10[1024];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t INV:1;					 /* Invert */
        vuint32_t  :7;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t SSS:4;					 /* Source Signal Select */
    } B;
  } MSCR512_955[484];

  uint8_t SIUL2_reserved11[112];
  
  union {                              /* General Purpose Register 0 */
    vuint32_t R;
    struct {
      vuint32_t GPI243_STR1:1;
      vuint32_t GPI243_STR0:1;
      vuint32_t GPI243_SEL1:1;
      vuint32_t GPI243_SEL0:1;
      vuint32_t GPI242_STR1:1;
      vuint32_t GPI242_STR0:1;
      vuint32_t GPI242_SEL1:1;
      vuint32_t GPI242_SEL0:1;
      vuint32_t GPI241_STR1:1;
      vuint32_t GPI241_STR0:1;
      vuint32_t GPI241_SEL1:1;
      vuint32_t GPI241_SEL0:1;
      vuint32_t GPI240_STR1:1;
      vuint32_t GPI240_STR0:1;
      vuint32_t GPI240_SEL1:1;
      vuint32_t GPI240_SEL0:1;
      vuint32_t GPI227_STR1:1;
      vuint32_t GPI227_STR0:1;
      vuint32_t GPI227_SEL1:1;
      vuint32_t GPI227_SEL0:1;
      vuint32_t GPI226_STR1:1;
      vuint32_t GPI226_STR0:1;
      vuint32_t GPI226_SEL1:1;
      vuint32_t GPI226_SEL0:1;
      vuint32_t GPI225_STR1:1;
      vuint32_t GPI225_STR0:1;
      vuint32_t GPI225_SEL1:1;
      vuint32_t GPI225_SEL0:1;
      vuint32_t GPI224_STR1:1;
      vuint32_t GPI224_STR0:1;
      vuint32_t GPI224_SEL1:1;
      vuint32_t GPI224_SEL0:1;
    } B;
  } GPR0;

  union {                              /* General Purpose Register 1 */
    vuint32_t R;
    struct {
      vuint32_t GPI251_STR1:1;
      vuint32_t GPI251_STR0:1;
      vuint32_t GPI251_SEL1:1;
      vuint32_t GPI251_SEL0:1;
      vuint32_t GPI250_STR1:1;
      vuint32_t GPI250_STR0:1;
      vuint32_t GPI250_SEL1:1;
      vuint32_t GPI250_SEL0:1;
      vuint32_t GPI249_STR1:1;
      vuint32_t GPI249_STR0:1;
      vuint32_t GPI249_SEL1:1;
      vuint32_t GPI249_SEL0:1;
      vuint32_t GPI248_STR1:1;
      vuint32_t GPI248_STR0:1;
      vuint32_t GPI248_SEL1:1;
      vuint32_t GPI248_SEL0:1;
      vuint32_t GPI247_STR1:1;
      vuint32_t GPI247_STR0:1;
      vuint32_t GPI247_SEL1:1;
      vuint32_t GPI247_SEL0:1;
      vuint32_t GPI246_STR1:1;
      vuint32_t GPI246_STR0:1;
      vuint32_t GPI246_SEL1:1;
      vuint32_t GPI246_SEL0:1;
      vuint32_t GPI245_STR1:1;
      vuint32_t GPI245_STR0:1;
      vuint32_t GPI245_SEL1:1;
      vuint32_t GPI245_SEL0:1;
      vuint32_t GPI244_STR1:1;
      vuint32_t GPI244_STR0:1;
      vuint32_t GPI244_SEL1:1;
      vuint32_t GPI244_SEL0:1;
    } B;
  } GPR1;

  union {                              /* General Purpose Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t GPI255_STR1:1;
      vuint32_t GPI255_STR0:1;
      vuint32_t GPI255_SEL1:1;
      vuint32_t GPI255_SEL0:1;
      vuint32_t GPI254_STR1:1;
      vuint32_t GPI254_STR0:1;
      vuint32_t GPI254_SEL1:1;
      vuint32_t GPI254_SEL0:1;
      vuint32_t GPI253_STR1:1;
      vuint32_t GPI253_STR0:1;
      vuint32_t GPI253_SEL1:1;
      vuint32_t GPI253_SEL0:1;
      vuint32_t GPI252_STR1:1;
      vuint32_t GPI252_STR0:1;
      vuint32_t GPI252_SEL1:1;
      vuint32_t GPI252_SEL0:1;
    } B;
  } GPR2;

  union {                              /* General Purpose Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t LF_CLK:1;              /* LinFlex Clock */
      vuint32_t POR_MASK:1;            /* Power-on Reset Mask */
    } B;
  } GPR3;

  uint8_t SIUL2_reserved11a[176];
 
  union {
    vuint8_t R;
      struct {
        vuint8_t  :7;					 /*  */
        vuint8_t PDO:1;					 /* Pad Data Out */
    } B;
  } GPDO[256];

  uint8_t SIUL2_reserved12[256];
  union {
    vuint8_t R;
      struct {
        vuint8_t  :7;					 /*  */
        vuint8_t PDI:1;					 /* Pad Data In */
    } B;
  } GPDI[256];

  uint8_t SIUL2_reserved13[256];
  union {
    vuint16_t R;
      struct {
        vuint16_t PPDO:16;					 /* Parallel Pad Data Out */
    } B;
  } PGPDO[32];

  union {
    vuint16_t R;
      struct {
        vuint16_t PPDI:16;					 /* Parallel Pad Data In */
    } B;
  } PGPDI[32];

  union {
    vuint32_t R;
      struct {
        vuint32_t MASK:16;					 /* Mask Field */
        vuint32_t MPPDO:16;					 /* Masked Parallel Pad Data Out */
    } B;
  } MPGPDO[32];

};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

struct SMPU_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t MERR:16;					 /* Master n error, where the bus master number matches the bit number */
        vuint32_t  :1;					 /*  */
        vuint32_t  :11;					 /*  */
        vuint32_t HRL:3;					 /* Hardware revision level */
        vuint32_t GVLD:1;					 /* Global Valid (global enable/disable for the SMPU) */
    } B;
  } CESR0;

  union {
    vuint32_t R;
      struct {
        vuint32_t MEOVR:16;					 /* Master n error overrun, where the bus master number matches the bit number */
        vuint32_t  :1;					 /*  */
        vuint32_t  :11;					 /*  */
        vuint32_t NRGD:4;					 /* Number of region descriptors */
    } B;
  } CESR1;

  uint8_t SMPU_reserved0[248];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t EADDR:32;					 /* Error address */
      } B;
    } EAR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t EACD:24;					 /* Error access control detail */
          vuint32_t  :1;					 /*  */
          vuint32_t EATTR:2;					 /* Error attributes */
          vuint32_t ERW:1;					 /* Error read/write */
          vuint32_t EMN:4;					 /* Error master number */
      } B;
    } EDR;
  } CH[16];

  uint8_t SMPU_reserved1[640];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t SRTADDR:32;					 /* Start address */
      } B;
    } WORD0;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t ENDADDR:32;					 /* End address */
      } B;
    } WORD1;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t M0P:2;					 /* Bus master 0 permissions */
          vuint32_t M1P:2;					 /* Bus master 1 permissions */
          vuint32_t M2P:2;					 /* Bus master 2 permissions */
          vuint32_t M3P:2;					 /* Bus master 3 permissions */
          vuint32_t M4P:2;					 /* Bus master 4 permissions */
          vuint32_t M5P:2;					 /* Bus master 5 permissions */
          vuint32_t M6P:2;					 /* Bus master 6 permissions */
          vuint32_t M7P:2;					 /* Bus master 7 permissions */
          vuint32_t M8P:2;					 /* Bus master 8 permissions */
          vuint32_t M9P:2;					 /* Bus master 9 permissions */
          vuint32_t M10P:2;					 /* Bus master 10 permissions */
          vuint32_t M11P:2;					 /* Bus master 11 permissions */
          vuint32_t M12P:2;					 /* Bus master 12 permissions */
          vuint32_t M13P:2;					 /* Bus master 13 permissions */
          vuint32_t M14P:2;					 /* Bus master 14 permissions */
          vuint32_t M15P:2;					 /* Bus master 15 permissions */
      } B;
    } WORD2;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :28;					 /*  */
          vuint32_t RO:1;					 /* Read-Only */
          vuint32_t  :1;					 /*  */
          vuint32_t CI:1;					 /* Cache Inhibit */
          vuint32_t VLD:1;					 /* Valid */
      } B;
    } WORD3;
  } RGD[12];

};


/* ============================================================================
   =============================== Module: SRX ================================
   ============================================================================ */

struct SRX_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t TSPRSC:8;					 /*  */
        vuint32_t  :14;					 /*  */
        vuint32_t FMDUIE:1;					 /*  */
        vuint32_t SMDUIE:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t FAST_CLR:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t DBG_FRZ:1;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t SENT_EN:1;					 /*  */
    } B;
  } GBL_CTRL;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t EN_CH:16;					 /*  */
    } B;
  } CHNL_EN;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t FDMU:1;					 /*  */
        vuint32_t SMDU:1;					 /*  */
        vuint32_t  :8;					 /*  */
    } B;
  } GBL_STATUS;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t F_RDY:16;					 /*  */
    } B;
  } FMSG_RDY;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t S_RDY:16;					 /*  */
    } B;
  } SMSG_RDY;

  uint8_t SRX_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH0:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH1:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH2:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH3:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH4:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH5:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH6:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH7:3;					 /*  */
    } B;
  } DATA_CTRL1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH8:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH9:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH10:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH11:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH12:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH13:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH14:3;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t NIBBCH15:3;					 /*  */
    } B;
  } DATA_CTRL2;

  uint8_t SRX_reserved1[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t FDMA_EN:16;					 /*  */
    } B;
  } FDMA_CTRL;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t SDMA_EN:16;					 /*  */
    } B;
  } SDMA_CTRL;

  uint8_t SRX_reserved2[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t FRDY_IE:16;					 /*  */
    } B;
  } FRDY_IE;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t SRDY_IE:16;					 /*  */
    } B;
  } SRDY_IE;

  uint8_t SRX_reserved3[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t CHNUM:4;					 /*  */
        vuint32_t SCNIB:4;					 /*  */
        vuint32_t DNIB1:4;					 /*  */
        vuint32_t DNIB2:4;					 /*  */
        vuint32_t DNIB3:4;					 /*  */
        vuint32_t DNIB4:4;					 /*  */
        vuint32_t DNIB5:4;					 /*  */
        vuint32_t DNIB6:4;					 /*  */
    } B;
  } DMA_FMSG_DATA;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :12;					 /*  */
        vuint32_t CRC4b:4;					 /*  */
        vuint32_t  :16;					 /*  */
    } B;
  } DMA_FMSG_CRC;

  union {
    vuint32_t R;
      struct {
        vuint32_t TS:32;					 /*  */
    } B;
  } DMA_FMSG_TS;

  uint8_t SRX_reserved4[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t CHNUM:4;					 /*  */
        vuint32_t TYPE:1;					 /*  */
        vuint32_t  :16;					 /*  */
        vuint32_t CFG:1;					 /*  */
        vuint32_t ID7_4_D3_0:4;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t ID3_0_DATA15_12:4;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } DMA_SMSG_BIT3;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :10;					 /*  */
        vuint32_t SMCRC:6;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t DATA:12;					 /*  */
    } B;
  } DMA_SMSG_BIT2;

  union {
    vuint32_t R;
      struct {
        vuint32_t TS:32;					 /*  */
    } B;
  } DMA_SMSG_TS;

  uint8_t SRX_reserved5[4];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t  :1;					 /*  */
          vuint32_t CM_PRSC:15;					 /*  */
          vuint32_t COMP_EN:1;					 /*  */
          vuint32_t  :1;					 /*  */
          vuint32_t PRSC:14;					 /*  */
      } B;
    } CLK_CTRL;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t BUS_IDLE:1;					 /*  */
          vuint32_t  :3;					 /*  */
          vuint32_t CAL_RESYNC:1;					 /*  */
          vuint32_t CAL_20_25:1;					 /*  */
          vuint32_t SMSG_OFLW:1;					 /*  */
          vuint32_t FMSG_OFLW:1;					 /*  */
          vuint32_t  :1;					 /*  */
          vuint32_t PP_DIAG_ERR:1;					 /*  */
          vuint32_t CAL_LEN_ERR:1;					 /*  */
          vuint32_t CAL_DIAG_ERR:1;					 /*  */
          vuint32_t NIB_VAL_ERR:1;					 /*  */
          vuint32_t SMSG_CRC_ERR:1;					 /*  */
          vuint32_t FMSG_CRC_ERR:1;					 /*  */
          vuint32_t NUM_EDGES_ERR:1;					 /*  */
          vuint32_t  :16;					 /*  */
      } B;
    } STATUS;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t BUS_IDLE_CNT:4;					 /*  */
          vuint32_t IE_CAL_RESYNC:1;					 /*  */
          vuint32_t IE_CAL_20_25:1;					 /*  */
          vuint32_t IE_SMSG_OFLW:1;					 /*  */
          vuint32_t IE_FMSG_OFLW:1;					 /*  */
          vuint32_t FCRC_CHK_OFF:1;					 /*  */
          vuint32_t IE_PP_DIAG_ERR:1;					 /*  */
          vuint32_t IE_CAL_LEN_ERR:1;					 /*  */
          vuint32_t IE_CAL_DIAG_ERR:1;					 /*  */
          vuint32_t IE_NIB_VAL_ERR:1;					 /*  */
          vuint32_t IE_SMSG_CRC_ERR:1;					 /*  */
          vuint32_t IE_FMSG_CRC_ERR:1;					 /*  */
          vuint32_t IE_NUM_EDGES_ERR:1;					 /*  */
          vuint32_t DCHNG_INT:1;					 /*  */
          vuint32_t CAL_RNG:1;					 /*  */
          vuint32_t PP_CHKSEL:1;					 /*  */
          vuint32_t FCRC_TYPE:1;					 /*  */
          vuint32_t FCRC_SC_EN:1;					 /*  */
          vuint32_t SCRC_TYPE:1;					 /*  */
          vuint32_t PAUSE_EN:1;					 /*  */
          vuint32_t SUCC_CAL_CHK:1;					 /*  */
          vuint32_t FIL_CNT:8;					 /*  */
      } B;
    } CONFIG;
  
    uint8_t SRX_reserved6[4];
  } CHA[16];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t CHNUM:4;					 /*  */
          vuint32_t SCNIB:4;					 /*  */
          vuint32_t DNIB1:4;					 /*  */
          vuint32_t DNIB2:4;					 /*  */
          vuint32_t DNIB3:4;					 /*  */
          vuint32_t DNIB4:4;					 /*  */
          vuint32_t DNIB5:4;					 /*  */
          vuint32_t DNIB6:4;					 /*  */
      } B;
    } FMSG_DATA;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :12;					 /*  */
          vuint32_t CRC4b:4;					 /*  */
          vuint32_t  :16;					 /*  */
      } B;
    } FMSG_CRC;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t TS:32;					 /*  */
      } B;
    } FMSG_TS;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t CHNUM:4;					 /*  */
          vuint32_t TYPE:1;					 /*  */
          vuint32_t  :16;					 /*  */
          vuint32_t CFG:1;					 /*  */
          vuint32_t ID7_4_ID3_0:4;					 /*  */
          vuint32_t  :1;					 /*  */
          vuint32_t ID3_0_DATA15_12:4;					 /*  */
          vuint32_t  :1;					 /*  */
      } B;
    } SMSG_BIT3;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :10;					 /*  */
          vuint32_t SMCRC:6;					 /*  */
          vuint32_t  :4;					 /*  */
          vuint32_t DATA:12;					 /*  */
      } B;
    } SMSG_BIT2;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t TS:32;					 /*  */
      } B;
    } SMSG_TS;
  } CHB[16];  

};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

struct SSCM_tag {
  union {
    vuint16_t R;
      struct {
        vuint16_t  :1;					 /*  */
        vuint16_t CER:1;					 /* Configuration Error */
        vuint16_t  :1;					 /*  */
        vuint16_t NXEN1:1;					 /* Processor 1 Nexus enable status */
        vuint16_t NXEN:1;					 /* Processor 0 Nexus enable status */
        vuint16_t  :1;					 /*  */
        vuint16_t  :1;					 /*  */
        vuint16_t  :1;					 /*  */
        vuint16_t BMODE:3;					 /* Device Boot Mode */
        vuint16_t VLE:1;					 /*  */
        vuint16_t  :1;					 /*  */
        vuint16_t  :1;					 /*  */
        vuint16_t  :2;					 /*  */
    } B;
  } STATUS;

  union {
    vuint16_t R;
      struct {
        vuint16_t JPIN:10;					 /*  */
        vuint16_t  :1;					 /*  */
        vuint16_t MREV:4;					 /* Minor Mask Revision */
        vuint16_t  :1;					 /*  */
    } B;
  } MEMCONFIG;

  uint8_t SSCM_reserved0[36];
  union {
    vuint32_t R;
      struct {
        vuint32_t SADR:32;					 /* Processor Start Address */
    } B;
  } PSA;

  union {
    vuint32_t R;
      struct {
        vuint32_t CL:32;					 /* Length of the code for the identified boot sector */
    } B;
  } CLEN;

  uint8_t SSCM_reserved1[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :22;					 /*  */
        vuint32_t PLC:2;					 /* Pre-Life Cycle */
        vuint32_t  :5;					 /*  */
        vuint32_t LC:3;					 /* Life Cycle */
    } B;
  } LCSTAT;

};


/* ============================================================================
   ============================== Module: STCU2 ===============================
   ============================================================================ */

struct STCU2_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :21;					 /*  */
        vuint32_t BYP:1;					 /*  */
        vuint32_t MBPLLEN:1;					 /*  */
        vuint32_t LBPLLEN:1;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t RUN:1;					 /*  */
    } B;
  } RUN;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :20;					 /*  */
        vuint32_t MBIE:1;					 /*  */
        vuint32_t LBIE:1;					 /*  */
        vuint32_t MBSWPLLEN:1;					 /*  */
        vuint32_t LBSWPLLEN:1;					 /*  */
        vuint32_t  :6;					 /*  */
        vuint32_t RUNSW_ABORT:1;					 /*  */
        vuint32_t RUNSW:1;					 /*  */
    } B;
  } RUNSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t SKC:32;					 /*  */
    } B;
  } SKC;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t PTR:7;					 /*  */
        vuint32_t LB_DELAY:8;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t WRP:1;					 /*  */
        vuint32_t  :2;					 /*  */
        vuint32_t CRCEN:1;					 /*  */
        vuint32_t PMOSEN:1;					 /*  */
        vuint32_t MBU:1;					 /*  */
        vuint32_t CLK_CFG:3;					 /*  */
    } B;
  } CFG;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :2;					 /*  */
        vuint32_t PLLODF:6;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t PLLIDF:3;					 /*  */
        vuint32_t  :9;					 /*  */
        vuint32_t PLLLDF:7;					 /*  */
    } B;
  } PLL_CFG;

  union {
    vuint32_t R;
      struct {
        vuint32_t WDGEOC:32;					 /*  */
    } B;
  } WDG;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :30;					 /*  */
        vuint32_t MBIFLG:1;					 /*  */
        vuint32_t LBIFLG:1;					 /*  */
    } B;
  } INT_FLG;

  union {
    vuint32_t R;
      struct {
        vuint32_t CRCE:32;					 /*  */
    } B;
  } CRCE;

  union {
    vuint32_t R;
      struct {
        vuint32_t CRCR:32;					 /*  */
    } B;
  } CRCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :6;					 /*  */
        vuint32_t ABORTHW:1;					 /*  */
        vuint32_t ABORTSW:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t LOCKESW:1;					 /*  */
        vuint32_t WDTOSW:1;					 /*  */
        vuint32_t CRCSSW:1;					 /*  */
        vuint32_t ENGESW:1;					 /*  */
        vuint32_t INVPSW:1;					 /*  */
        vuint32_t  :6;					 /*  */
        vuint32_t UFSF:1;					 /*  */
        vuint32_t RFSF:1;					 /*  */
        vuint32_t  :3;					 /*  */
        vuint32_t LOCKE:1;					 /*  */
        vuint32_t WDTO:1;					 /*  */
        vuint32_t CRCS:1;					 /*  */
        vuint32_t ENGE:1;					 /*  */
        vuint32_t INVP:1;					 /*  */
    } B;
  } ERR_STAT;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :27;					 /*  */
        vuint32_t LOCKEUFM:1;					 /*  */
        vuint32_t WDTOUFM:1;					 /*  */
        vuint32_t CRCSUFM:1;					 /*  */
        vuint32_t ENGEUFM:1;					 /*  */
        vuint32_t INVPUFM:1;					 /*  */
    } B;
  } ERR_FM;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t LBS15:1;					 /*  */
        vuint32_t LBS14:1;					 /*  */
        vuint32_t LBS13:1;					 /*  */
        vuint32_t LBS12:1;					 /*  */
        vuint32_t LBS11:1;					 /*  */
        vuint32_t LBS10:1;					 /*  */
        vuint32_t LBS9:1;					 /*  */
        vuint32_t LBS8:1;					 /*  */
        vuint32_t LBS7:1;					 /*  */
        vuint32_t LBS6:1;					 /*  */
        vuint32_t LBS5:1;					 /*  */
        vuint32_t LBS4:1;					 /*  */
        vuint32_t LBS3:1;					 /*  */
        vuint32_t LBS2:1;					 /*  */
        vuint32_t LBS1:1;					 /*  */
        vuint32_t LBS0:1;					 /*  */
    } B;
  } LBS;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t LBE15:1;					 /*  */
        vuint32_t LBE14:1;					 /*  */
        vuint32_t LBE13:1;					 /*  */
        vuint32_t LBE12:1;					 /*  */
        vuint32_t LBE11:1;					 /*  */
        vuint32_t LBE10:1;					 /*  */
        vuint32_t LBE9:1;					 /*  */
        vuint32_t LBE8:1;					 /*  */
        vuint32_t LBE7:1;					 /*  */
        vuint32_t LBE6:1;					 /*  */
        vuint32_t LBE5:1;					 /*  */
        vuint32_t LBE4:1;					 /*  */
        vuint32_t LBE3:1;					 /*  */
        vuint32_t LBE2:1;					 /*  */
        vuint32_t LBE1:1;					 /*  */
        vuint32_t LBE0:1;					 /*  */
    } B;
  } LBE;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t LBSSW15:1;					 /*  */
        vuint32_t LBSSW14:1;					 /*  */
        vuint32_t LBSSW13:1;					 /*  */
        vuint32_t LBSSW12:1;					 /*  */
        vuint32_t LBSSW11:1;					 /*  */
        vuint32_t LBSSW10:1;					 /*  */
        vuint32_t LBSSW9:1;					 /*  */
        vuint32_t LBSSW8:1;					 /*  */
        vuint32_t LBSSW7:1;					 /*  */
        vuint32_t LBSSW6:1;					 /*  */
        vuint32_t LBSSW5:1;					 /*  */
        vuint32_t LBSSW4:1;					 /*  */
        vuint32_t LBSSW3:1;					 /*  */
        vuint32_t LBSSW2:1;					 /*  */
        vuint32_t LBSSW1:1;					 /*  */
        vuint32_t LBSSW0:1;					 /*  */
    } B;
  } LBSSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t LBESW15:1;					 /*  */
        vuint32_t LBESW14:1;					 /*  */
        vuint32_t LBESW13:1;					 /*  */
        vuint32_t LBESW12:1;					 /*  */
        vuint32_t LBESW11:1;					 /*  */
        vuint32_t LBESW10:1;					 /*  */
        vuint32_t LBESW9:1;					 /*  */
        vuint32_t LBESW8:1;					 /*  */
        vuint32_t LBESW7:1;					 /*  */
        vuint32_t LBESW6:1;					 /*  */
        vuint32_t LBESW5:1;					 /*  */
        vuint32_t LBESW4:1;					 /*  */
        vuint32_t LBESW3:1;					 /*  */
        vuint32_t LBESW2:1;					 /*  */
        vuint32_t LBESW1:1;					 /*  */
        vuint32_t LBESW0:1;					 /*  */
    } B;
  } LBESW;

  uint8_t STCU2_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t LBUFM15:1;					 /*  */
        vuint32_t LBUFM14:1;					 /*  */
        vuint32_t LBUFM13:1;					 /*  */
        vuint32_t LBUFM12:1;					 /*  */
        vuint32_t LBUFM11:1;					 /*  */
        vuint32_t LBUFM10:1;					 /*  */
        vuint32_t LBUFM9:1;					 /*  */
        vuint32_t LBUFM8:1;					 /*  */
        vuint32_t LBUFM7:1;					 /*  */
        vuint32_t LBUFM6:1;					 /*  */
        vuint32_t LBUFM5:1;					 /*  */
        vuint32_t LBUFM4:1;					 /*  */
        vuint32_t LBUFM3:1;					 /*  */
        vuint32_t LBUFM2:1;					 /*  */
        vuint32_t LBUFM1:1;					 /*  */
        vuint32_t LBUFM0:1;					 /*  */
    } B;
  } LBUFM;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBS31:1;					 /*  */
        vuint32_t MBS30:1;					 /*  */
        vuint32_t MBS29:1;					 /*  */
        vuint32_t MBS28:1;					 /*  */
        vuint32_t MBS27:1;					 /*  */
        vuint32_t MBS26:1;					 /*  */
        vuint32_t MBS25:1;					 /*  */
        vuint32_t MBS24:1;					 /*  */
        vuint32_t MBS23:1;					 /*  */
        vuint32_t MBS22:1;					 /*  */
        vuint32_t MBS21:1;					 /*  */
        vuint32_t MBS20:1;					 /*  */
        vuint32_t MBS19:1;					 /*  */
        vuint32_t MBS18:1;					 /*  */
        vuint32_t MBS17:1;					 /*  */
        vuint32_t MBS16:1;					 /*  */
        vuint32_t MBS15:1;					 /*  */
        vuint32_t MBS14:1;					 /*  */
        vuint32_t MBS13:1;					 /*  */
        vuint32_t MBS12:1;					 /*  */
        vuint32_t MBS11:1;					 /*  */
        vuint32_t MBS10:1;					 /*  */
        vuint32_t MBS9:1;					 /*  */
        vuint32_t MBS8:1;					 /*  */
        vuint32_t MBS7:1;					 /*  */
        vuint32_t MBS6:1;					 /*  */
        vuint32_t MBS5:1;					 /*  */
        vuint32_t MBS4:1;					 /*  */
        vuint32_t MBS3:1;					 /*  */
        vuint32_t MBS2:1;					 /*  */
        vuint32_t MBS1:1;					 /*  */
        vuint32_t MBS0:1;					 /*  */
    } B;
  } MBSL;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBS63:1;					 /*  */
        vuint32_t MBS62:1;					 /*  */
        vuint32_t MBS61:1;					 /*  */
        vuint32_t MBS60:1;					 /*  */
        vuint32_t MBS59:1;					 /*  */
        vuint32_t MBS58:1;					 /*  */
        vuint32_t MBS57:1;					 /*  */
        vuint32_t MBS56:1;					 /*  */
        vuint32_t MBS55:1;					 /*  */
        vuint32_t MBS54:1;					 /*  */
        vuint32_t MBS53:1;					 /*  */
        vuint32_t MBS52:1;					 /*  */
        vuint32_t MBS51:1;					 /*  */
        vuint32_t MBS50:1;					 /*  */
        vuint32_t MBS49:1;					 /*  */
        vuint32_t MBS48:1;					 /*  */
        vuint32_t MBS47:1;					 /*  */
        vuint32_t MBS46:1;					 /*  */
        vuint32_t MBS45:1;					 /*  */
        vuint32_t MBS44:1;					 /*  */
        vuint32_t MBS43:1;					 /*  */
        vuint32_t MBS42:1;					 /*  */
        vuint32_t MBS41:1;					 /*  */
        vuint32_t MBS40:1;					 /*  */
        vuint32_t MBS39:1;					 /*  */
        vuint32_t MBS38:1;					 /*  */
        vuint32_t MBS37:1;					 /*  */
        vuint32_t MBS36:1;					 /*  */
        vuint32_t MBS35:1;					 /*  */
        vuint32_t MBS34:1;					 /*  */
        vuint32_t MBS33:1;					 /*  */
        vuint32_t MBS32:1;					 /*  */
    } B;
  } MBSM;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBS95:1;					 /*  */
        vuint32_t MBS94:1;					 /*  */
        vuint32_t MBS93:1;					 /*  */
        vuint32_t MBS92:1;					 /*  */
        vuint32_t MBS91:1;					 /*  */
        vuint32_t MBS90:1;					 /*  */
        vuint32_t MBS89:1;					 /*  */
        vuint32_t MBS88:1;					 /*  */
        vuint32_t MBS87:1;					 /*  */
        vuint32_t MBS86:1;					 /*  */
        vuint32_t MBS85:1;					 /*  */
        vuint32_t MBS84:1;					 /*  */
        vuint32_t MBS83:1;					 /*  */
        vuint32_t MBS82:1;					 /*  */
        vuint32_t MBS81:1;					 /*  */
        vuint32_t MBS80:1;					 /*  */
        vuint32_t MBS79:1;					 /*  */
        vuint32_t MBS78:1;					 /*  */
        vuint32_t MBS77:1;					 /*  */
        vuint32_t MBS76:1;					 /*  */
        vuint32_t MBS75:1;					 /*  */
        vuint32_t MBS74:1;					 /*  */
        vuint32_t MBS73:1;					 /*  */
        vuint32_t MBS72:1;					 /*  */
        vuint32_t MBS71:1;					 /*  */
        vuint32_t MBS70:1;					 /*  */
        vuint32_t MBS69:1;					 /*  */
        vuint32_t MBS68:1;					 /*  */
        vuint32_t MBS67:1;					 /*  */
        vuint32_t MBS66:1;					 /*  */
        vuint32_t MBS65:1;					 /*  */
        vuint32_t MBS64:1;					 /*  */
    } B;
  } MBSH;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBE31:1;					 /*  */
        vuint32_t MBE30:1;					 /*  */
        vuint32_t MBE29:1;					 /*  */
        vuint32_t MBE28:1;					 /*  */
        vuint32_t MBE27:1;					 /*  */
        vuint32_t MBE26:1;					 /*  */
        vuint32_t MBE25:1;					 /*  */
        vuint32_t MBE24:1;					 /*  */
        vuint32_t MBE23:1;					 /*  */
        vuint32_t MBE22:1;					 /*  */
        vuint32_t MBE21:1;					 /*  */
        vuint32_t MBE20:1;					 /*  */
        vuint32_t MBE19:1;					 /*  */
        vuint32_t MBE18:1;					 /*  */
        vuint32_t MBE17:1;					 /*  */
        vuint32_t MBE16:1;					 /*  */
        vuint32_t MBE15:1;					 /*  */
        vuint32_t MBE14:1;					 /*  */
        vuint32_t MBE13:1;					 /*  */
        vuint32_t MBE12:1;					 /*  */
        vuint32_t MBE11:1;					 /*  */
        vuint32_t MBE10:1;					 /*  */
        vuint32_t MBE9:1;					 /*  */
        vuint32_t MBE8:1;					 /*  */
        vuint32_t MBE7:1;					 /*  */
        vuint32_t MBE6:1;					 /*  */
        vuint32_t MBE5:1;					 /*  */
        vuint32_t MBE4:1;					 /*  */
        vuint32_t MBE3:1;					 /*  */
        vuint32_t MBE2:1;					 /*  */
        vuint32_t MBE1:1;					 /*  */
        vuint32_t MBE0:1;					 /*  */
    } B;
  } MBEL;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBE63:1;					 /*  */
        vuint32_t MBE62:1;					 /*  */
        vuint32_t MBE61:1;					 /*  */
        vuint32_t MBE60:1;					 /*  */
        vuint32_t MBE59:1;					 /*  */
        vuint32_t MBE58:1;					 /*  */
        vuint32_t MBE57:1;					 /*  */
        vuint32_t MBE56:1;					 /*  */
        vuint32_t MBE55:1;					 /*  */
        vuint32_t MBE54:1;					 /*  */
        vuint32_t MBE53:1;					 /*  */
        vuint32_t MBE52:1;					 /*  */
        vuint32_t MBE51:1;					 /*  */
        vuint32_t MBE50:1;					 /*  */
        vuint32_t MBE49:1;					 /*  */
        vuint32_t MBE48:1;					 /*  */
        vuint32_t MBE47:1;					 /*  */
        vuint32_t MBE46:1;					 /*  */
        vuint32_t MBE45:1;					 /*  */
        vuint32_t MBE44:1;					 /*  */
        vuint32_t MBE43:1;					 /*  */
        vuint32_t MBE42:1;					 /*  */
        vuint32_t MBE41:1;					 /*  */
        vuint32_t MBE40:1;					 /*  */
        vuint32_t MBE39:1;					 /*  */
        vuint32_t MBE38:1;					 /*  */
        vuint32_t MBE37:1;					 /*  */
        vuint32_t MBE36:1;					 /*  */
        vuint32_t MBE35:1;					 /*  */
        vuint32_t MBE34:1;					 /*  */
        vuint32_t MBE33:1;					 /*  */
        vuint32_t MBE32:1;					 /*  */
    } B;
  } MBEM;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBE95:1;					 /*  */
        vuint32_t MBE94:1;					 /*  */
        vuint32_t MBE93:1;					 /*  */
        vuint32_t MBE92:1;					 /*  */
        vuint32_t MBE91:1;					 /*  */
        vuint32_t MBE90:1;					 /*  */
        vuint32_t MBE89:1;					 /*  */
        vuint32_t MBE88:1;					 /*  */
        vuint32_t MBE87:1;					 /*  */
        vuint32_t MBE86:1;					 /*  */
        vuint32_t MBE85:1;					 /*  */
        vuint32_t MBE84:1;					 /*  */
        vuint32_t MBE83:1;					 /*  */
        vuint32_t MBE82:1;					 /*  */
        vuint32_t MBE81:1;					 /*  */
        vuint32_t MBE80:1;					 /*  */
        vuint32_t MBE79:1;					 /*  */
        vuint32_t MBE78:1;					 /*  */
        vuint32_t MBE77:1;					 /*  */
        vuint32_t MBE76:1;					 /*  */
        vuint32_t MBE75:1;					 /*  */
        vuint32_t MBE74:1;					 /*  */
        vuint32_t MBE73:1;					 /*  */
        vuint32_t MBE72:1;					 /*  */
        vuint32_t MBE71:1;					 /*  */
        vuint32_t MBE70:1;					 /*  */
        vuint32_t MBE69:1;					 /*  */
        vuint32_t MBE68:1;					 /*  */
        vuint32_t MBE67:1;					 /*  */
        vuint32_t MBE66:1;					 /*  */
        vuint32_t MBE65:1;					 /*  */
        vuint32_t MBE64:1;					 /*  */
    } B;
  } MBEH;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBSSW31:1;					 /*  */
        vuint32_t MBSSW30:1;					 /*  */
        vuint32_t MBSSW29:1;					 /*  */
        vuint32_t MBSSW28:1;					 /*  */
        vuint32_t MBSSW27:1;					 /*  */
        vuint32_t MBSSW26:1;					 /*  */
        vuint32_t MBSSW25:1;					 /*  */
        vuint32_t MBSSW24:1;					 /*  */
        vuint32_t MBSSW23:1;					 /*  */
        vuint32_t MBSSW22:1;					 /*  */
        vuint32_t MBSSW21:1;					 /*  */
        vuint32_t MBSSW20:1;					 /*  */
        vuint32_t MBSSW19:1;					 /*  */
        vuint32_t MBSSW18:1;					 /*  */
        vuint32_t MBSSW17:1;					 /*  */
        vuint32_t MBSSW16:1;					 /*  */
        vuint32_t MBSSW15:1;					 /*  */
        vuint32_t MBSSW14:1;					 /*  */
        vuint32_t MBSSW13:1;					 /*  */
        vuint32_t MBSSW12:1;					 /*  */
        vuint32_t MBSSW11:1;					 /*  */
        vuint32_t MBSSW10:1;					 /*  */
        vuint32_t MBSSW9:1;					 /*  */
        vuint32_t MBSSW8:1;					 /*  */
        vuint32_t MBSSW7:1;					 /*  */
        vuint32_t MBSSW6:1;					 /*  */
        vuint32_t MBSSW5:1;					 /*  */
        vuint32_t MBSSW4:1;					 /*  */
        vuint32_t MBSSW3:1;					 /*  */
        vuint32_t MBSSW2:1;					 /*  */
        vuint32_t MBSSW1:1;					 /*  */
        vuint32_t MBSSW0:1;					 /*  */
    } B;
  } MBSLSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBSSW63:1;					 /*  */
        vuint32_t MBSSW62:1;					 /*  */
        vuint32_t MBSSW61:1;					 /*  */
        vuint32_t MBSSW60:1;					 /*  */
        vuint32_t MBSSW59:1;					 /*  */
        vuint32_t MBSSW58:1;					 /*  */
        vuint32_t MBSSW57:1;					 /*  */
        vuint32_t MBSSW56:1;					 /*  */
        vuint32_t MBSSW55:1;					 /*  */
        vuint32_t MBSSW54:1;					 /*  */
        vuint32_t MBSSW53:1;					 /*  */
        vuint32_t MBSSW52:1;					 /*  */
        vuint32_t MBSSW51:1;					 /*  */
        vuint32_t MBSSW50:1;					 /*  */
        vuint32_t MBSSW49:1;					 /*  */
        vuint32_t MBSSW48:1;					 /*  */
        vuint32_t MBSSW47:1;					 /*  */
        vuint32_t MBSSW46:1;					 /*  */
        vuint32_t MBSSW45:1;					 /*  */
        vuint32_t MBSSW44:1;					 /*  */
        vuint32_t MBSSW43:1;					 /*  */
        vuint32_t MBSSW42:1;					 /*  */
        vuint32_t MBSSW41:1;					 /*  */
        vuint32_t MBSSW40:1;					 /*  */
        vuint32_t MBSSW39:1;					 /*  */
        vuint32_t MBSSW38:1;					 /*  */
        vuint32_t MBSSW37:1;					 /*  */
        vuint32_t MBSSW36:1;					 /*  */
        vuint32_t MBSSW35:1;					 /*  */
        vuint32_t MBSSW34:1;					 /*  */
        vuint32_t MBSSW33:1;					 /*  */
        vuint32_t MBSSW32:1;					 /*  */
    } B;
  } MBSMSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBSSW95:1;					 /*  */
        vuint32_t MBSSW94:1;					 /*  */
        vuint32_t MBSSW93:1;					 /*  */
        vuint32_t MBSSW92:1;					 /*  */
        vuint32_t MBSSW91:1;					 /*  */
        vuint32_t MBSSW90:1;					 /*  */
        vuint32_t MBSSW89:1;					 /*  */
        vuint32_t MBSSW88:1;					 /*  */
        vuint32_t MBSSW87:1;					 /*  */
        vuint32_t MBSSW86:1;					 /*  */
        vuint32_t MBSSW85:1;					 /*  */
        vuint32_t MBSSW84:1;					 /*  */
        vuint32_t MBSSW83:1;					 /*  */
        vuint32_t MBSSW82:1;					 /*  */
        vuint32_t MBSSW81:1;					 /*  */
        vuint32_t MBSSW80:1;					 /*  */
        vuint32_t MBSSW79:1;					 /*  */
        vuint32_t MBSSW78:1;					 /*  */
        vuint32_t MBSSW77:1;					 /*  */
        vuint32_t MBSSW76:1;					 /*  */
        vuint32_t MBSSW75:1;					 /*  */
        vuint32_t MBSSW74:1;					 /*  */
        vuint32_t MBSSW73:1;					 /*  */
        vuint32_t MBSSW72:1;					 /*  */
        vuint32_t MBSSW71:1;					 /*  */
        vuint32_t MBSSW70:1;					 /*  */
        vuint32_t MBSSW69:1;					 /*  */
        vuint32_t MBSSW68:1;					 /*  */
        vuint32_t MBSSW67:1;					 /*  */
        vuint32_t MBSSW66:1;					 /*  */
        vuint32_t MBSSW65:1;					 /*  */
        vuint32_t MBSSW64:1;					 /*  */
    } B;
  } MBSHSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBESW31:1;					 /*  */
        vuint32_t MBESW30:1;					 /*  */
        vuint32_t MBESW29:1;					 /*  */
        vuint32_t MBESW28:1;					 /*  */
        vuint32_t MBESW27:1;					 /*  */
        vuint32_t MBESW26:1;					 /*  */
        vuint32_t MBESW25:1;					 /*  */
        vuint32_t MBESW24:1;					 /*  */
        vuint32_t MBESW23:1;					 /*  */
        vuint32_t MBESW22:1;					 /*  */
        vuint32_t MBESW21:1;					 /*  */
        vuint32_t MBESW20:1;					 /*  */
        vuint32_t MBESW19:1;					 /*  */
        vuint32_t MBESW18:1;					 /*  */
        vuint32_t MBESW17:1;					 /*  */
        vuint32_t MBESW16:1;					 /*  */
        vuint32_t MBESW15:1;					 /*  */
        vuint32_t MBESW14:1;					 /*  */
        vuint32_t MBESW13:1;					 /*  */
        vuint32_t MBESW12:1;					 /*  */
        vuint32_t MBESW11:1;					 /*  */
        vuint32_t MBESW10:1;					 /*  */
        vuint32_t MBESW9:1;					 /*  */
        vuint32_t MBESW8:1;					 /*  */
        vuint32_t MBESW7:1;					 /*  */
        vuint32_t MBESW6:1;					 /*  */
        vuint32_t MBESW5:1;					 /*  */
        vuint32_t MBESW4:1;					 /*  */
        vuint32_t MBESW3:1;					 /*  */
        vuint32_t MBESW2:1;					 /*  */
        vuint32_t MBESW1:1;					 /*  */
        vuint32_t MBESW0:1;					 /*  */
    } B;
  } MBELSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBESW63:1;					 /*  */
        vuint32_t MBESW62:1;					 /*  */
        vuint32_t MBESW61:1;					 /*  */
        vuint32_t MBESW60:1;					 /*  */
        vuint32_t MBESW59:1;					 /*  */
        vuint32_t MBESW58:1;					 /*  */
        vuint32_t MBESW57:1;					 /*  */
        vuint32_t MBESW56:1;					 /*  */
        vuint32_t MBESW55:1;					 /*  */
        vuint32_t MBESW54:1;					 /*  */
        vuint32_t MBESW53:1;					 /*  */
        vuint32_t MBESW52:1;					 /*  */
        vuint32_t MBESW51:1;					 /*  */
        vuint32_t MBESW50:1;					 /*  */
        vuint32_t MBESW49:1;					 /*  */
        vuint32_t MBESW48:1;					 /*  */
        vuint32_t MBESW47:1;					 /*  */
        vuint32_t MBESW46:1;					 /*  */
        vuint32_t MBESW45:1;					 /*  */
        vuint32_t MBESW44:1;					 /*  */
        vuint32_t MBESW43:1;					 /*  */
        vuint32_t MBESW42:1;					 /*  */
        vuint32_t MBESW41:1;					 /*  */
        vuint32_t MBESW40:1;					 /*  */
        vuint32_t MBESW39:1;					 /*  */
        vuint32_t MBESW38:1;					 /*  */
        vuint32_t MBESW37:1;					 /*  */
        vuint32_t MBESW36:1;					 /*  */
        vuint32_t MBESW35:1;					 /*  */
        vuint32_t MBESW34:1;					 /*  */
        vuint32_t MBESW33:1;					 /*  */
        vuint32_t MBESW32:1;					 /*  */
    } B;
  } MBEMSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBESW95:1;					 /*  */
        vuint32_t MBESW94:1;					 /*  */
        vuint32_t MBESW93:1;					 /*  */
        vuint32_t MBESW92:1;					 /*  */
        vuint32_t MBESW91:1;					 /*  */
        vuint32_t MBESW90:1;					 /*  */
        vuint32_t MBESW89:1;					 /*  */
        vuint32_t MBESW88:1;					 /*  */
        vuint32_t MBESW87:1;					 /*  */
        vuint32_t MBESW86:1;					 /*  */
        vuint32_t MBESW85:1;					 /*  */
        vuint32_t MBESW84:1;					 /*  */
        vuint32_t MBESW83:1;					 /*  */
        vuint32_t MBESW82:1;					 /*  */
        vuint32_t MBESW81:1;					 /*  */
        vuint32_t MBESW80:1;					 /*  */
        vuint32_t MBESW79:1;					 /*  */
        vuint32_t MBESW78:1;					 /*  */
        vuint32_t MBESW77:1;					 /*  */
        vuint32_t MBESW76:1;					 /*  */
        vuint32_t MBESW75:1;					 /*  */
        vuint32_t MBESW74:1;					 /*  */
        vuint32_t MBESW73:1;					 /*  */
        vuint32_t MBESW72:1;					 /*  */
        vuint32_t MBESW71:1;					 /*  */
        vuint32_t MBESW70:1;					 /*  */
        vuint32_t MBESW69:1;					 /*  */
        vuint32_t MBESW68:1;					 /*  */
        vuint32_t MBESW67:1;					 /*  */
        vuint32_t MBESW66:1;					 /*  */
        vuint32_t MBESW65:1;					 /*  */
        vuint32_t MBESW64:1;					 /*  */
    } B;
  } MBEHSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBUFM31:1;					 /*  */
        vuint32_t MBUFM30:1;					 /*  */
        vuint32_t MBUFM29:1;					 /*  */
        vuint32_t MBUFM28:1;					 /*  */
        vuint32_t MBUFM27:1;					 /*  */
        vuint32_t MBUFM26:1;					 /*  */
        vuint32_t MBUFM25:1;					 /*  */
        vuint32_t MBUFM24:1;					 /*  */
        vuint32_t MBUFM23:1;					 /*  */
        vuint32_t MBUFM22:1;					 /*  */
        vuint32_t MBUFM21:1;					 /*  */
        vuint32_t MBUFM20:1;					 /*  */
        vuint32_t MBUFM19:1;					 /*  */
        vuint32_t MBUFM18:1;					 /*  */
        vuint32_t MBUFM17:1;					 /*  */
        vuint32_t MBUFM16:1;					 /*  */
        vuint32_t MBUFM15:1;					 /*  */
        vuint32_t MBUFM14:1;					 /*  */
        vuint32_t MBUFM13:1;					 /*  */
        vuint32_t MBUFM12:1;					 /*  */
        vuint32_t MBUFM11:1;					 /*  */
        vuint32_t MBUFM10:1;					 /*  */
        vuint32_t MBUFM9:1;					 /*  */
        vuint32_t MBUFM8:1;					 /*  */
        vuint32_t MBUFM7:1;					 /*  */
        vuint32_t MBUFM6:1;					 /*  */
        vuint32_t MBUFM5:1;					 /*  */
        vuint32_t MBUFM4:1;					 /*  */
        vuint32_t MBUFM3:1;					 /*  */
        vuint32_t MBUFM2:1;					 /*  */
        vuint32_t MBUFM1:1;					 /*  */
        vuint32_t MBUFM0:1;					 /*  */
    } B;
  } MBUFML;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBUFM63:1;					 /*  */
        vuint32_t MBUFM62:1;					 /*  */
        vuint32_t MBUFM61:1;					 /*  */
        vuint32_t MBUFM60:1;					 /*  */
        vuint32_t MBUFM59:1;					 /*  */
        vuint32_t MBUFM58:1;					 /*  */
        vuint32_t MBUFM57:1;					 /*  */
        vuint32_t MBUFM56:1;					 /*  */
        vuint32_t MBUFM55:1;					 /*  */
        vuint32_t MBUFM54:1;					 /*  */
        vuint32_t MBUFM53:1;					 /*  */
        vuint32_t MBUFM52:1;					 /*  */
        vuint32_t MBUFM51:1;					 /*  */
        vuint32_t MBUFM50:1;					 /*  */
        vuint32_t MBUFM49:1;					 /*  */
        vuint32_t MBUFM48:1;					 /*  */
        vuint32_t MBUFM47:1;					 /*  */
        vuint32_t MBUFM46:1;					 /*  */
        vuint32_t MBUFM45:1;					 /*  */
        vuint32_t MBUFM44:1;					 /*  */
        vuint32_t MBUFM43:1;					 /*  */
        vuint32_t MBUFM42:1;					 /*  */
        vuint32_t MBUFM41:1;					 /*  */
        vuint32_t MBUFM40:1;					 /*  */
        vuint32_t MBUFM39:1;					 /*  */
        vuint32_t MBUFM38:1;					 /*  */
        vuint32_t MBUFM37:1;					 /*  */
        vuint32_t MBUFM36:1;					 /*  */
        vuint32_t MBUFM35:1;					 /*  */
        vuint32_t MBUFM34:1;					 /*  */
        vuint32_t MBUFM33:1;					 /*  */
        vuint32_t MBUFM32:1;					 /*  */
    } B;
  } MBUFMM;

  union {
    vuint32_t R;
      struct {
        vuint32_t MBUFM95:1;					 /*  */
        vuint32_t MBUFM94:1;					 /*  */
        vuint32_t MBUFM93:1;					 /*  */
        vuint32_t MBUFM92:1;					 /*  */
        vuint32_t MBUFM91:1;					 /*  */
        vuint32_t MBUFM90:1;					 /*  */
        vuint32_t MBUFM89:1;					 /*  */
        vuint32_t MBUFM88:1;					 /*  */
        vuint32_t MBUFM87:1;					 /*  */
        vuint32_t MBUFM86:1;					 /*  */
        vuint32_t MBUFM85:1;					 /*  */
        vuint32_t MBUFM84:1;					 /*  */
        vuint32_t MBUFM83:1;					 /*  */
        vuint32_t MBUFM82:1;					 /*  */
        vuint32_t MBUFM81:1;					 /*  */
        vuint32_t MBUFM80:1;					 /*  */
        vuint32_t MBUFM79:1;					 /*  */
        vuint32_t MBUFM78:1;					 /*  */
        vuint32_t MBUFM77:1;					 /*  */
        vuint32_t MBUFM76:1;					 /*  */
        vuint32_t MBUFM75:1;					 /*  */
        vuint32_t MBUFM74:1;					 /*  */
        vuint32_t MBUFM73:1;					 /*  */
        vuint32_t MBUFM72:1;					 /*  */
        vuint32_t MBUFM71:1;					 /*  */
        vuint32_t MBUFM70:1;					 /*  */
        vuint32_t MBUFM69:1;					 /*  */
        vuint32_t MBUFM68:1;					 /*  */
        vuint32_t MBUFM67:1;					 /*  */
        vuint32_t MBUFM66:1;					 /*  */
        vuint32_t MBUFM65:1;					 /*  */
        vuint32_t MBUFM64:1;					 /*  */
    } B;
  } MBUFMH;

  uint8_t STCU2_reserved1[1088];
  union {
    vuint32_t R;
      struct {
        vuint32_t CSM:1;					 /*  */
        vuint32_t PTR:7;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t PRPGEN:1;					 /*  */
        vuint32_t SHS:3;					 /*  */
        vuint32_t SCEN_OFF:4;					 /*  */
        vuint32_t SCEN_ON:4;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t PFT:1;					 /*  */
        vuint32_t CWS:3;					 /*  */
    } B;
  } LB_CTRL;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :6;					 /*  */
        vuint32_t PCS:26;					 /*  */
    } B;
  } LB_PCS;

  union {
    vuint32_t R;
      struct {
        vuint32_t PRPGx:32;					 /*  */
    } B;
  } LB_PRPGL;

  union {
    vuint32_t R;
      struct {
        vuint32_t PRPGx:32;					 /*  */
    } B;
  } LB_PRPGH;

  union {
    vuint32_t R;
      struct {
        vuint32_t MISREx:32;					 /*  */
    } B;
  } LB_MISREL;

  union {
    vuint32_t R;
      struct {
        vuint32_t MISREx:32;					 /*  */
    } B;
  } LB_MISREH;

  union {
    vuint32_t R;
      struct {
        vuint32_t MISRRx:32;					 /*  */
    } B;
  } LB_MISRRL;

  union {
    vuint32_t R;
      struct {
        vuint32_t MISRRx:32;					 /*  */
    } B;
  } LB_MISRRH;

  union {
    vuint32_t R;
      struct {
        vuint32_t MISRESWx:32;					 /*  */
    } B;
  } LB_MISRELSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t MISRESWx:32;					 /*  */
    } B;
  } LB_MISREHSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t MISRRSWx:32;					 /*  */
    } B;
  } LB_MISRRLSW;

  union {
    vuint32_t R;
      struct {
        vuint32_t MISRRSWx:32;					 /*  */
    } B;
  } LB_MISRRHSW;

  uint8_t STCU2_reserved2[648];
  union {
    vuint32_t R;
      struct {
        vuint32_t CSM:1;					 /*  */
        vuint32_t PTR:7;					 /*  */
        vuint32_t  :24;					 /*  */
    } B;
  } MB_CTRL;

};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

struct STM_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t CPS:8;					 /* Counter Prescaler. */
        vuint32_t  :6;					 /*  */
        vuint32_t FRZ:1;					 /* Freeze. */
        vuint32_t TEN:1;					 /* Timer counter Enabled. */
    } B;
  } CR;

  union {
    vuint32_t R;
      struct {
        vuint32_t CNT:32;					 /* Timer count value used as the time base for all channels. */
    } B;
  } CNT;

  uint8_t STM_reserved0[4];
  struct {
    uint8_t STM_reserved1[4];
    union {
      vuint32_t R;
        struct {
          vuint32_t  :31;					 /*  */
          vuint32_t CEN:1;					 /* Channel Enable */
      } B;
    } CCR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :31;					 /*  */
          vuint32_t CIF:1;					 /* Channel Interrupt Flag */
      } B;
    } CIR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t CMP:32;					 /* Compare value for channel n. */
      } B;
    } CMP;
  } CH[4];

};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

struct SWT_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t MAP0:1;					 /*  */
        vuint32_t MAP1:1;					 /*  */
        vuint32_t MAP2:1;					 /*  */
        vuint32_t MAP3:1;					 /*  */
        vuint32_t MAP4:1;					 /*  */
        vuint32_t MAP5:1;					 /*  */
        vuint32_t MAP6:1;					 /*  */
        vuint32_t MAP7:1;					 /*  */
        vuint32_t  :13;					 /*  */
        vuint32_t SMD:2;					 /* Service Mode. */
        vuint32_t RIA:1;					 /*  */
        vuint32_t WND:1;					 /*  */
        vuint32_t ITR:1;					 /*  */
        vuint32_t HLK:1;					 /*  */
        vuint32_t SLK:1;					 /*  */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t STP:1;					 /*  */
        vuint32_t FRZ:1;					 /*  */
        vuint32_t WEN:1;					 /*  */
    } B;
  } CR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :31;					 /*  */
        vuint32_t TIF:1;					 /*  */
    } B;
  } IR;

  union {
    vuint32_t R;
      struct {
        vuint32_t WTO:32;					 /*  */
    } B;
  } TO;

  union {
    vuint32_t R;
      struct {
        vuint32_t WST:32;					 /*  */
    } B;
  } WN;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t WSC:16;					 /*  */
    } B;
  } SR;

  union {
    vuint32_t R;
      struct {
        vuint32_t CNT:32;					 /*  */
    } B;
  } CO;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /*  */
        vuint32_t SK:16;					 /*  */
    } B;
  } SK;

};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

struct TDM_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :26;					 /*  */
        vuint32_t TDRS5:1;					 /*  */
        vuint32_t TDRSR4:1;					 /*  */
        vuint32_t TDRSR3:1;					 /*  */
        vuint32_t TDRSR2:1;					 /*  */
        vuint32_t TDRSR1:1;					 /*  */
        vuint32_t TDRSR0:1;					 /*  */
    } B;
  } TDRSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t LFPAR:24;					 /*  */
    } B;
  } LFPAR;

};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

struct WKPU_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t NIF0:1;					 /* NMI Status Flag 0 (safety core) */
        vuint32_t NOVF0:1;					 /* NMI Overrun Status Flag 0 (safety core) */
        vuint32_t  :6;					 /*  */
        vuint32_t NIF1:1;					 /* NMI Status Flag 1 (Core 1) */
        vuint32_t NOVF1:1;					 /* NMI Overrun Status Flag 1 (Core 1) */
        vuint32_t  :6;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t  :8;					 /*  */
    } B;
  } NSR;

  uint8_t WKPU_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t NLOCK0:1;					 /* NMI Configuration Lock Register 0 */
        vuint32_t NDSS0:2;					 /* NMI Destination Source Select 0 */
        vuint32_t NWRE0:1;					 /* NMI Wakeup Request Enable 0 */
        vuint32_t  :1;					 /*  */
        vuint32_t NREE0:1;					 /* NMI Rising-edge Events Enable 0 */
        vuint32_t NFEE0:1;					 /* NMI Falling-edge Events Enable 0 */
        vuint32_t NFE0:1;					 /* NMI Filter Enable */
        vuint32_t NLOCK1:1;					 /* NMI Configuration Lock Register 1 */
        vuint32_t NDSS1:2;					 /* NMI Destination Source Select 1 */
        vuint32_t NWRE1:1;					 /* NMI Wakeup Request Enable 1 */
        vuint32_t  :1;					 /*  */
        vuint32_t NREE1:1;					 /* NMI Rising-edge Events Enable 1 */
        vuint32_t NFEE1:1;					 /* NMI Falling-edge Events Enable 1 */
        vuint32_t  :1;					 /*  */
        vuint32_t  :8;					 /*  */
        vuint32_t  :8;					 /*  */
    } B;
  } NCR;

};


/* ============================================================================
   =============================== Module: XBAR ===============================
   ============================================================================ */

struct XBAR_tag {
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t  :1;					 /*  */
          vuint32_t  :3;					 /*  */
          vuint32_t  :1;					 /*  */
          vuint32_t  :3;					 /*  */
          vuint32_t  :1;					 /*  */
          vuint32_t  :3;					 /*  */
          vuint32_t  :1;					 /*  */
          vuint32_t M4:3;					 /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
          vuint32_t  :1;					 /*  */
          vuint32_t M3:3;					 /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
          vuint32_t  :1;					 /*  */
          vuint32_t M2:3;					 /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
          vuint32_t  :1;					 /*  */
          vuint32_t M1:3;					 /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
          vuint32_t  :1;					 /*  */
          vuint32_t M0:3;					 /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
      } B;
    } PRS;
  
    uint8_t XBAR_reserved0[12];
    union {
      vuint32_t R;
        struct {
          vuint32_t RO:1;					 /* Read Only */
          vuint32_t  :1;					 /*  */
          vuint32_t  :20;					 /*  */
          vuint32_t ARB:2;					 /* Arbitration Mode */
          vuint32_t  :2;					 /*  */
          vuint32_t PCTL:2;					 /* Parking Control */
          vuint32_t  :1;					 /*  */
          vuint32_t PARK:3;					 /* Park */
      } B;
    } CRS;
  
    uint8_t XBAR_reserved1[236];
  } CH1[8];
  
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t  :29;					 /*  */
          vuint32_t AULB:3;					 /* Arbitrates On Undefined Length Bursts */
      } B;
    } MGPCR;
  
    uint8_t XBAR_reserved2[252];
  } CH2[8];
  
};


/* ============================================================================
   =============================== Module: XOSC ===============================
   ============================================================================ */

struct XOSC_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t OSCBYP:1;					 /*  */
        vuint32_t  :7;					 /*  */
        vuint32_t EOCV:8;					 /* End of Count Value */
        vuint32_t M_OSC:1;					 /* Crystal oscillator clock interrupt mask */
        vuint32_t  :2;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t I_OSC:1;					 /*  */
        vuint32_t  :5;					 /*  */
        vuint32_t  :1;					 /*  */
        vuint32_t  :1;					 /*  */
    } B;
  } CTL;

};


/* ============================================================================
   ============================= Module: eMIOS200 =============================
   ============================================================================ */

struct eMIOS200_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :1;					 /*  */
        vuint32_t MDIS:1;					 /* Module Disable bit. */
        vuint32_t FRZ:1;					 /* Freeze bit. */
        vuint32_t GTBE:1;					 /* Global Time Base Enable bit. */
        vuint32_t  :1;					 /*  */
        vuint32_t GPREN:1;					 /* Global Prescaler Enable bit. */
        vuint32_t  :6;					 /*  */
        vuint32_t  :4;					 /*  */
        vuint32_t GPRE:8;					 /* Global Prescaler bits. */
        vuint32_t  :8;					 /*  */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t F23_F0:24;					 /* Channel [n] Output Update Disable bit. */
    } B;
  } GFLAG;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t OU23_OU0:24;					 /* Channel [n] Output Update Disable bit. */
    } B;
  } OUDIS;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t CHDIS23_CHDIS0:24;					 /* Enable Channel n bit. */
    } B;
  } UCDIS;

};


/* ============================================================================
   ============================== Module: eMIOS ===============================
   ============================================================================ */

struct eMIOS_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t A:24;					 /*  */
    } B;
  } A;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t B:24;					 /* See text above register figure. */
    } B;
  } B;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /*  */
        vuint32_t C:24;					 /* See text above register figure. */
    } B;
  } CNT;

  union {
    vuint32_t R;
      struct {
        vuint32_t FREN:1;					 /* Freeze Enable bit. */
        vuint32_t ODIS:1;					 /* Output Disable bit. */
        vuint32_t ODISSL:2;					 /* Output Disable select bits. */
        vuint32_t UCPRE:2;					 /* Prescaler bits. */
        vuint32_t UCPREN:1;					 /* Prescaler Enable bit. */
        vuint32_t DMA:1;					 /* Direct Memory Access bit. */
        vuint32_t  :1;					 /*  */
        vuint32_t IF:4;					 /* Input Filter bits. */
        vuint32_t FCK:1;					 /* Filter Clock select bit. */
        vuint32_t FEN:1;					 /* FLAG Enable bit. */
        vuint32_t  :3;					 /*  */
        vuint32_t FORCMA:1;					 /* Force Match A bit. */
        vuint32_t FORCMB:1;					 /* Force Match B bit. */
        vuint32_t  :1;					 /*  */
        vuint32_t BSL:2;					 /* Bus Select bits. */
        vuint32_t EDSEL:1;					 /* Edge Selection bit. */
        vuint32_t EDPOL:1;					 /* Edge Polarity bit. */
        vuint32_t MODE:7;					 /* Mode selection bits. */
    } B;
  } C;

  union {
    vuint32_t R;
      struct {
        vuint32_t OVR:1;					 /* Overrun bit. */
        vuint32_t  :15;					 /*  */
        vuint32_t OVFL:1;					 /* Overflow bit. */
        vuint32_t  :12;					 /* Reserved. */
        vuint32_t UCIN:1;					 /* Unified Channel Input pin bit. */
        vuint32_t UCOUT:1;					 /* Unified Channel Output pin bit. */
        vuint32_t FLAG:1;					 /* FLAG bit. */
    } B;
  } S;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /* Reserved. */
        vuint32_t ALTA:24;					 /* See text above register figure. */
    } B;
  } ALTA;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :4;					 /*  */
        vuint32_t UCEXTPRE:12;					 /* Extended Prescaler bits [ 0:11 ]. */
        vuint32_t  :1;					 /*  */
        vuint32_t UCPRECLK:1;					 /* Prescaler Clock select bit. */
        vuint32_t  :14;					 /*  */
    } B;
  } C2;

};


/* ============================================================================
   ============================ Module: eTPU_CCCR =============================
   ============================================================================ */

struct eTPU_CCCR_tag {
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t CIE:1;					 /* Channel Interrupt Enable (see the eTPU Channel Interrupt Enable Register (ETPUCIER)). */
          vuint32_t DTRE:1;					 /* Channel Data Transfer Request Enable (see the "Channel Interrupt and Data Transfer Requests" section). */
          vuint32_t CPR:2;					 /* Channel Priority. */
          vuint32_t T4DIS:1;					 /* T4 channel action Disable. */
          vuint32_t SSMAE:1;					 /* Shared Subsystem Microengine Access Enable. */
          vuint32_t ETPD:1;					 /* Entry Table Pin Direction. */
          vuint32_t ETCS:1;					 /* Entry Table Condition Select. */
          vuint32_t  :3;					 /* Reserved. */
          vuint32_t CFS:5;					 /* Channel Function Select. */
          vuint32_t ODIS:1;					 /* Output Disable. */
          vuint32_t OPOL:1;					 /* Output Polarity. */
          vuint32_t  :3;					 /* Reserved. */
          vuint32_t CPBA:11;					 /* Channel n Parameter Base Address. */
      } B;
    } CR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t CIS:1;					 /* Channel Interrupt Status. */
          vuint32_t CIOS:1;					 /* Channel Interrupt Overflow Status. */
          vuint32_t  :6;					 /* Reserved. */
          vuint32_t DTRS:1;					 /* Data Transfer Request Status. */
          vuint32_t DTROS:1;					 /* Data Transfer Request Overflow Status. */
          vuint32_t  :6;					 /* Reserved. */
          vuint32_t IPS:1;					 /* Channel Input Pin State. */
          vuint32_t OPS:1;					 /* Channel Output Pin State. */
          vuint32_t OBE:1;					 /* Output Buffer Enable. */
          vuint32_t  :11;					 /* Reserved. */
          vuint32_t FM:2;					 /* Channel Function Mode. */
      } B;
    } SCR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :29;					 /* Reserved. */
          vuint32_t HSR:3;				 /* Host Service Request */
      } B;
    } HSRR;
    uint8_t eTPU_CCCR_reserved1[4];      /* Added, Ibuka */
  } ENG1_C[32];       /* C(0-32)CR_ENG1, C(0-32)SCR_ENG1, C(0-32)HSRR_ENG1 */

  uint8_t eTPU_CCCR_reserved2[512];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t CIE:1;					 /* Channel Interrupt Enable (see the Channel Interrupts ad Data Transfer Requests section). */
          vuint32_t DTRE:1;					 /* Channel Data Transfer Request Enable (see the "Channel Interrupt and Data Transfer Requests" section). */
          vuint32_t CPR:2;					 /* Channel Priority. */
          vuint32_t T4DIS:1;					 /* T4 channel action Disable. */
          vuint32_t SSMAE:1;					 /* Shared Subsystem Microengine Access Enable. */
          vuint32_t ETPD:1;					 /* Entry Table Pin Direction. */
          vuint32_t ETCS:1;					 /* Entry Table Condition Select. */
          vuint32_t  :3;					 /* Reserved. */
          vuint32_t CFS:5;					 /* Channel Function Select. */
          vuint32_t ODIS:1;					 /* Output Disable. */
          vuint32_t OPOL:1;					 /* Output Polarity. */
          vuint32_t  :3;					 /* Reserved. */
          vuint32_t CPBA:11;					 /* Channel n Parameter Base Address. */
      } B;
    } CR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t CIS:1;					 /* Channel Interrupt Status. */
          vuint32_t CIOS:1;					 /* Channel Interrupt Overflow Status. */
          vuint32_t  :6;					 /* Reserved. */
          vuint32_t DTRS:1;					 /* Data Transfer Request Status. */
          vuint32_t DTROS:1;					 /* Data Transfer Request Overflow Status. */
          vuint32_t  :6;					 /* Reserved. */
          vuint32_t IPS:1;					 /* Channel Input Pin State. */
          vuint32_t OPS:1;					 /* Channel Output Pin State. */
          vuint32_t OBE:1;					 /* Output Buffer Enable. */
          vuint32_t  :11;					 /* Reserved. */
          vuint32_t FM:2;					 /* Channel Function Mode. */
      } B;
    } SCR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :29;					 /* Reserved. */
          vuint32_t HSR:3;					 /* Host Service Request */
      } B;
    } HSRR;
    uint8_t eTPU_CCCR_reserved1[4];         /* Added Ibuka  */
  } ENG2_C[32];       /* C(0-32)CR_ENG2, C(0-32)SCR_ENG1, C(0-32)HSRR_ENG2 */

};


/* ============================================================================
   ============================= Module: eTPU_ER ==============================
   ============================================================================ */

struct eTPU_ER_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t WDM:2;					 /* Watchdog Mode. */
        vuint32_t  :1;					 /*  */
        vuint32_t WMO:1;					 /* Watchdog Monitor Operation. */
        vuint32_t  :12;					 /*  */
        vuint32_t WDCNT:16;					 /* Watchdog Count. */
    } B;
  } WDTR_ENG1;

  uint8_t eTPU_ER_reserved1[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t IDLE_CNT:31;					 /* Idle Count. */
        vuint32_t ICLR:1;					 /* Idle Clear. */
    } B;
  } IDLER_ENG1;

  uint8_t eTPU_ER_reserved2[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t WDM:2;					 /* Watchdog Mode. */
        vuint32_t  :1;					 /*  */
        vuint32_t WMO:1;					 /* Watchdog Monitor Operation. */
        vuint32_t  :12;					 /*  */
        vuint32_t WDCNT:16;					 /* Watchdog Count. */
    } B;
  } WDTR_ENG2;

  uint8_t eTPU_ER_reserved3[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t IDLE_CNT:31;					 /* Idle Count. */
        vuint32_t ICLR:1;					 /* Idle Clear. */
    } B;
  } IDLER_ENG2;

};


/* ============================================================================
   ============================= Module: eTPU_GCR =============================
   ============================================================================ */

struct eTPU_GCR_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t CISn:32;					 /* Channel n Interrupt Status. */
    } B;
  } CISR_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t CISn:32;					 /* Channel n Interrupt Status. */
    } B;
  } CISR_ENG2;

  uint8_t eTPU_GCR_reserved1[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t DTRSn:32;					 /* Channel n Data Transfer Request Status. */
    } B;
  } CDTRSR_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t DTRSn:32;					 /* Channel n Data Transfer Request Status. */
    } B;
  } CDTRSR_ENG2;

  uint8_t eTPU_GCR_reserved2[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t CIOSn:32;					 /* Channel n Interrupt Overflow Status */
    } B;
  } CIOSR_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t CIOSn:32;					 /* Channel n Interrupt Overflow Status */
    } B;
  } CIOSR_ENG2;

  uint8_t eTPU_GCR_reserved3[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t DTROSn:32;					 /* Channel n Data Transfer Request Overflow Status. */
    } B;
  } CDTROSR_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t DTROSn:32;					 /* Channel n Data Transfer Request Overflow Status. */
    } B;
  } CDTROSR_ENG2;

  uint8_t eTPU_GCR_reserved4[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t CIEn:32;					 /* Channel n Interrupt Enable. */
    } B;
  } CIER_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t CIEn:32;					 /* Channel n Interrupt Enable. */
    } B;
  } CIER_ENG2;

  uint8_t eTPU_GCR_reserved5[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t DTREn:32;					 /* Channel n Data Transfer Request Enable. */
    } B;
  } CDTRER_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t DTREn:32;					 /* Channel n Data Transfer Request Enable. */
    } B;
  } CDTRER_ENG2;

  uint8_t eTPU_GCR_reserved6[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t WDSn:32;					 /* Channel n Watchdog Status. For details about Watchdog mechanism, see the Watchdog section. */
    } B;
  } WDSR_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t WDSn:32;					 /* Channel n Watchdog Status. For details about Watchdog mechanism, see the Watchdog section. */
    } B;
  } WDSR_ENG2;

  uint8_t eTPU_GCR_reserved7[24];
  union {
    vuint32_t R;
      struct {
        vuint32_t SRn:32;					 /* Pending Service Request n. */
    } B;
  } CPSSR_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t SRn:32;					 /* Pending Service Request n. */
    } B;
  } CPSSR_ENG2;

  uint8_t eTPU_GCR_reserved8[8];
  union {
    vuint32_t R;
      struct {
        vuint32_t SSn:32;					 /* Service Status n. */
    } B;
  } CSSR_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t SSn:32;					 /* Service Status n. */
    } B;
  } CSSR_ENG2;

};


/* ============================================================================
   ============================= Module: eTPU_LMR =============================
   ============================================================================ */

struct eTPU_LMR_tag {
  //uint8_t eTPU_LMR_reserved0[128];       /* commented out as the offset is */
                                           /* accounted for in the base address */
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t LMM:2;					 /* Latency Monitor Mode. */
          vuint32_t  :3;					 /* Reserved. */
          vuint32_t SRSEL:3;					 /* Service Request Selection */
          vuint32_t  :3;					 /* Reserved. */
          vuint32_t MONCHAN:5;					 /* Monitored Channel. */
          vuint32_t MAXLAT:16;					 /* Maximum Latency. */
      } B;
    } CR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :16;					 /* Reserved. */
          vuint32_t LATENCY:15;					 /* Latency measurement. */
          vuint32_t LTC:1;					 /* Latency measurement clear */
      } B;
    } MR;
  } ENG1_LM[6];        /* LM(0-5)CR_ENG1 & LM(0-5)MR_ENG1 */

  uint8_t eTPU_LMR_reserved1[16];
  struct {
    union {
      vuint32_t R;
        struct {
          vuint32_t LMM:2;					 /* Latency Monitor Mode. */
          vuint32_t  :3;					 /* Reserved. */
          vuint32_t SRSEL:3;					 /* Service Request Selection */
          vuint32_t  :3;					 /* Reserved. */
          vuint32_t MONCHAN:5;					 /* Monitored Channel. */
          vuint32_t MAXLAT:16;					 /* Maximum Latency. */
      } B;
    } CR;
  
    union {
      vuint32_t R;
        struct {
          vuint32_t  :16;					 /* Reserved. */
          vuint32_t LATENCY:15;					 /* Latency measurement. */
          vuint32_t LTC:1;					 /* Latency measurement clear. */
      } B;
    } MR;
  } ENG2_LM[6];        /* LM(0-5)CR_ENG1 & LM(0-5)MR_ENG1 */
  
};


/* ============================================================================
   ============================ Module: eTPU_MESR =============================
   ============================================================================ */

struct eTPU_MESR_tag {
  //uint8_t eTPU_MESR_reserved0[256];
  union {
    vuint32_t R;
      struct {
        vuint32_t FME:1;					 /* Field Modification Enable. */
        vuint32_t  :14;					 /* Reserved. */
        vuint32_t MECIE:1;					 /* Memory Error Correction Interrupt Enable. */
        vuint32_t HDEIE:1;					 /* Host Data Error Injection Enable */
        vuint32_t MDEIE:1;					 /* Microengine(s) Data Error Injection Enable. */
        vuint32_t  :3;					 /* Reserved. */
        vuint32_t DTEND:1;					 /* Thread End on Data Non-correctable Error. */
        vuint32_t DRDIS:1;					 /* Data Error Report Disable. */
        vuint32_t DEDD:1;					 /* Data Error Detection Disable. */
        vuint32_t CEIE:1;					 /* Code Error Injection Enable. */
        vuint32_t  :4;					 /* Reserved. */
        vuint32_t CTEND:1;					 /* Thread End on Code Non-correctable Error. */
        vuint32_t CRDIS:1;					 /* Code Error Report Disable. */
        vuint32_t CEDD:1;					 /* Code Error Detection Disable. */
    } B;
  } MECR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :18;					 /* Reserved. */
        vuint32_t INJ_ADDR:12;					 /* Injection Address. */
        vuint32_t  :2;					 /* Reserved. */
    } B;
  } DEIAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t DFLIP:32;					 /* Data Flip bits. */
    } B;
  } DEIDPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :3;					 /* Reserved. */
        vuint32_t PFLIP_19_15:5;					 /* Parity Flip bits. */
        vuint32_t  :3;					 /* Reserved. */
        vuint32_t PFLIP_14_10:5;					 /* Parity Flip bits. */
        vuint32_t  :3;					 /* Reserved. */
        vuint32_t PFLIP_9_5:5;					 /* Parity Flip bits. */
        vuint32_t  :3;					 /* Reserved. */
        vuint32_t PFLIP_4_0:5;					 /* Parity Flip bits. */
    } B;
  } DEIPPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERR_ACC:2;					 /* Error Access Source Indication. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t ERR_CHANNEL:5;					 /* Error Channel Access Indication. */
        vuint32_t  :10;					 /* Reserved. */
        vuint32_t ERR_ADDR:12;					 /* Error Address. */
        vuint32_t  :2;					 /* Reserved. */
    } B;
  } DERAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t DATA:32;					 /* DATA. */
    } B;
  } DERDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t BE3:1;					 /* Byte Enable 3. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t SYND3:5;					 /* Error Syndrome 3. */
        vuint32_t BE2:1;					 /* Byte Enable 2. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t SYND2:5;					 /* Error Syndrome 2. */
        vuint32_t BE1:1;					 /* Byte Enable 1. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t SYND1:5;					 /* Error Syndrome 1. */
        vuint32_t BE0:1;					 /* Byte Enable 0. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t SYND0:5;					 /* Error Syndrome 0. */
    } B;
  } DERSR;

  uint8_t eTPU_MESR_reserved1[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t DCERR:1;					 /* Data Correctable Error flag. */
        vuint32_t  :6;					 /* Reserved. */
        vuint32_t DCOVR:1;					 /* Data Correctable Overrun flag. */
        vuint32_t CCERR:1;					 /* Code Error flag. */
        vuint32_t  :6;					 /* Reserved. */
        vuint32_t CCOVR:1;					 /* Code Correctable Overrun flag */
        vuint32_t DNCERR:1;					 /* Data Non-Correctable Error flag */
        vuint32_t  :6;					 /* Reserved. */
        vuint32_t DNCOVR:1;					 /* Data Non-Correctable Overrun flag. */
        vuint32_t CNCERR:1;					 /* Code Non-Correctable Error flag */
        vuint32_t  :6;					 /* Reserved. */
        vuint32_t CNCOVR:1;					 /* Code Non-Correctable Overrun flag. */
    } B;
  } MESR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :16;					 /* Reserved. */
        vuint32_t INJ_ADDR:14;					 /* Injection Address. */
        vuint32_t  :2;					 /* Reserved. */
    } B;
  } CEIAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t DFLIP:32;					 /* Data Flip bits. */
    } B;
  } CEIDPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :25;					 /* Reserved. */
        vuint32_t PFLIPc:7;					 /* Parity Flip bits. */
    } B;
  } CEIPPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t ERR_ACC:2;					 /* Error Access Source Indication. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t ERR_CHANNEL:5;					 /* Error Channel Access Indication. */
        vuint32_t  :8;					 /* Reserved. */
        vuint32_t ERR_ADDR:14;					 /* Error Address. */
        vuint32_t  :2;					 /* Reserved. */
    } B;
  } CERAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t CODE:32;					 /* CODE[31-0]. */
    } B;
  } CERDR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :25;					 /* Reserved. */
        vuint32_t SYND:7;					 /* Error Syndrome. */
    } B;
  } CERSR;

  union {
    vuint32_t R;
      struct {
        vuint32_t CFIXM:2;					 /* Code Fix Mode. */
        vuint32_t  :14;					 /* Reserved. */
        vuint32_t CFIX_ADDR:14;					 /* Code Fix Address. */
        vuint32_t  :2;					 /* Reserved. */
    } B;
  } CEFR;

};


/* ============================================================================
   ============================= Module: eTPU_SCR =============================
   ============================================================================ */

struct eTPU_SCR_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t GEC:1;					 /* Global Exception Clear. */
        vuint32_t SDMERR:1;					 /* SDM Read Error */
        vuint32_t WDTO1:1;					 /* Watchdog 1 Timeout. */
        vuint32_t WDTO2:1;					 /* Watchdog 2 Timeout. */
        vuint32_t MGE1:1;					 /* Microcode Global Exception Engine 1. */
        vuint32_t MGE2:1;					 /* Microcode Global Exception Engine 2. */
        vuint32_t ILF1:1;					 /* Illegal Instruction Flag for Engine 1. */
        vuint32_t ILF2:1;					 /* Illegal Instruction Flag for Engine 2. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t SCMSIZE:5;					 /* SCM Size = 64 Kbytes. */
        vuint32_t LTO1:1;					 /* Latency Timeout for Engine 1. */
        vuint32_t LTO2:1;					 /* Latency Timeout for Engine 2. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t SCMMISC:1;					 /* SCM MISC Complete flag. */
        vuint32_t SCMMISF:1;					 /* SCM MISC Flag. */
        vuint32_t SCMMISEN:1;					 /* SCM MISC Enable. */
        vuint32_t SCMERR:1;					 /* SCM Read Error. */
        vuint32_t  :1;					 /*  */
        vuint32_t VIS:1;					 /* SCM Visibility Bit. */
        vuint32_t  :5;					 /* Reserved. */
        vuint32_t GTBE:1;					 /* Global Time Base Enable. */
    } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t STS:1;					 /* Start Bit. */
        vuint32_t CTBASE:5;					 /* Channel Transfer Base. */
        vuint32_t PBBASE:10;					 /* Parameter Buffer Base Address. */
        vuint32_t PWIDTH:1;					 /* Parameter Width Selection. */
        vuint32_t PARM0:7;					 /* Channel Parameter number 0. */
        vuint32_t WR:1;					 /* Read/Write selection. */
        vuint32_t PARM1:7;					 /* Channel Parameter number 1. */
    } B;
  } CDCR;

  uint8_t eTPU_SCR_reserved0[4];
  union {
    vuint32_t R;
      struct {
        vuint32_t ETPUMISCCMP:32;					 /* Expected Multiple Input Signature Register value. */
    } B;
  } MISCCMPR;

  union {
    vuint32_t R;
      struct {
        vuint32_t ETPUSCMOFFDATAR:32;					 /* SCM Off-range read data value. */
    } B;
  } SCMOFFDATAR;

  union {
    vuint32_t R;
      struct {
        vuint32_t FEND:1;					 /* Force End. */
        vuint32_t MDIS:1;					 /* Module Disable Bit. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t STF:1;					 /* Stop Flag Bit. */
        vuint32_t  :4;					 /* Reserved. */
        vuint32_t HLTF:1;					 /* Halt Mode Flag. */
        vuint32_t  :3;					 /* Reserved. */
        vuint32_t FCSS:1;					 /* Filter Clock Source Selection */
        vuint32_t FPSCK:3;					 /* Filter Prescaler Clock Control. */
        vuint32_t CDFC:2;					 /* Channel Digital Filter Control. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t ERBA:5;					 /* Engine Relative Base Address. */
        vuint32_t SPPDIS:1;					 /* Schedule Priority Passing Disable. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t ETB:5;					 /* Entry Table Base. */
    } B;
  } ECR_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t FEND:1;					 /* Force End. */
        vuint32_t MDIS:1;					 /* Module Disable Bit. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t STF:1;					 /* Stop Flag Bit. */
        vuint32_t  :4;					 /* Reserved. */
        vuint32_t HLTF:1;					 /* Halt Mode Flag. */
        vuint32_t  :3;					 /* Reserved. */
        vuint32_t FCSS:1;					 /* Filter Clock Source Selection */
        vuint32_t FPSCK:3;					 /* Filter Prescaler Clock Control. */
        vuint32_t CDFC:2;					 /* Channel Digital Filter Control. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t ERBA:5;					 /* Engine Relative Base Address. */
        vuint32_t SPPDIS:1;					 /* Schedule Priority Passing Disable. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t ETB:5;					 /* Entry Table Base. */
    } B;
  } ECR_ENG2;

};


/* ============================================================================
   ============================ Module: eTPU_SSIR =============================
   ============================================================================ */

struct eTPU_SSIR_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /* Reserved. */
        vuint32_t LENG:2;					 /* Link Engine. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t LCHAN:5;					 /* Link Channel. */
    } B;
  } ETPUSSS0IR;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :24;					 /* Reserved. */
        vuint32_t LENG:2;					 /* Link Engine. */
        vuint32_t  :1;					 /* Reserved. */
        vuint32_t LCHAN:5;					 /* Link Channel. */
    } B;
  } ETPUSSS1IR;

};


/* ============================================================================
   ============================= Module: eTPU_TBR =============================
   ============================================================================ */

struct eTPU_TBR_tag {
  union {
    vuint32_t R;
      struct {
        vuint32_t TCR2CTL:3;					 /* TCR2 Clock/Gate Control. */
        vuint32_t TCRCF:2;					 /* TCRCLK Signal Filter Control. */
        vuint32_t AM:2;					 /* Angle Mode Selection. */
        vuint32_t ATGC:1;					 /* Angle Tick Generator Clock. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t TCR2P:6;					 /* Timer Count Register 2 Prescaler Control. */
        vuint32_t TCR1CTL:2;					 /* TCR1 Clock/Gate Control. */
        vuint32_t TCR1CS:1;					 /* TCR1 Clock Source */
        vuint32_t  :5;					 /* Reserved. */
        vuint32_t TCR1P:8;					 /* Timer Count Register 1 Prescaler Control. */
    } B;
  } TBCR_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /* Reserved. */
        vuint32_t TCR1:24;					 /* TCR1 value. */
    } B;
  } TB1R_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /* Reserved. */
        vuint32_t TCR2:24;					 /* TCR2 value. */
    } B;
  } TB2R_ENG1;

  union {
    vuint32_t R;
      struct {
        vuint32_t REN1:1;					 /* TCR1 Resource Client/Server Operation Enable Bit. */
        vuint32_t RSC1:1;					 /* TCR1 Resource Server/Client Assignment Bits. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t SERVER_ID1:4;					 /* STAC ID 1. */
        vuint32_t  :4;					 /* Reserved. */
        vuint32_t SRV1:4;					 /* TCR1 Resource Server. */
        vuint32_t REN2:1;					 /* TCR2 Resource Client/Server Operation Enable Bit. */
        vuint32_t RSC2:1;					 /* TCR2 ResourceEither time or angle TCR2 values. Server/Client Assignment Bits. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t SERVER_ID2:4;					 /* STAC ID 2. */
        vuint32_t  :4;					 /* Reserved. */
        vuint32_t SRV2:4;					 /* TCR2 Resource Server. */
    } B;
  } REDCR_ENG1;

  uint8_t eTPU_TBR_reserved1[16];
  union {
    vuint32_t R;
      struct {
        vuint32_t TCR2CTL:3;					 /* TCR2 Clock/Gate Control. */
        vuint32_t TCRCF:2;					 /* TCRCLK Signal Filter Control. */
        vuint32_t AM:2;					 /* Angle Mode Selection. */
        vuint32_t ATGC:1;					 /* Angle Tick Generator Clock. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t TCR2P:6;					 /* Timer Count Register 2 Prescaler Control. */
        vuint32_t TCR1CTL:2;					 /* TCR1 Clock/Gate Control. */
        vuint32_t TCR1CS:1;					 /* TCR1 Clock Source */
        vuint32_t  :5;					 /* Reserved. */
        vuint32_t TCR1P:8;					 /* Timer Count Register 1 Prescaler Control. */
    } B;
  } TBCR_ENG2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /* Reserved. */
        vuint32_t TCR1:24;					 /* TCR1 value. */
    } B;
  } TB1R_ENG2;

  union {
    vuint32_t R;
      struct {
        vuint32_t  :8;					 /* Reserved. */
        vuint32_t TCR2:24;					 /* TCR2 value. */
    } B;
  } TB2R_ENG2;

  union {
    vuint32_t R;
      struct {
        vuint32_t REN1:1;					 /* TCR1 Resource Client/Server Operation Enable Bit. */
        vuint32_t RSC1:1;					 /* TCR1 ResourceResource identifies any parameter that changes along the time and can be exported / imported from other device. In eTPU context, a resource can be TCR1 or TCR2 (either Time or Angle values). Server/Client Assignment Bits. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t SERVER_ID1:4;					 /* STAC ID 1. */
        vuint32_t  :4;					 /* Reserved. */
        vuint32_t SRV1:4;					 /* TCR1 Resource Server. */
        vuint32_t REN2:1;					 /* TCR2 Resource Client/Server Operation Enable Bit. */
        vuint32_t RSC2:1;					 /* TCR2 ResourceResource identifies any parameter that changes along the time and can be exported / imported from other device. In eTPU context, a resource can be TCR1 or TCR2 (either Time or Angle values). Server/Client Assignment Bits. */
        vuint32_t  :2;					 /* Reserved. */
        vuint32_t SERVER_ID2:4;					 /* STAC ID 2. */
        vuint32_t  :4;					 /* Reserved. */
        vuint32_t SRV2:4;					 /* TCR2 Resource Server. */
    } B;
  } REDCR_ENG2;
};

/* ============================================================================
   ============================ Module: XBIC =============================
   ============================================================================ */

struct XBIC_tag {
  
  union {
    vuint32_t R;
      struct {
        vuint32_t SE0 :1;					 
        vuint32_t SE1 :1;
        vuint32_t SE2 :1;					 
        vuint32_t SE3 :1;
        vuint32_t SE4 :1;					 
        vuint32_t SE5 :1;
        vuint32_t SE6 :1;					 
        vuint32_t SE7 :1;
        vuint32_t ME0 :1;					 
        vuint32_t ME1 :1;
        vuint32_t ME2 :1;					 
        vuint32_t ME3 :1;
        vuint32_t ME4 :1;					 
        vuint32_t ME5 :1;
        vuint32_t ME6 :1;					 
        vuint32_t ME7 :1;
        vuint32_t  :16;					 /* Reserved. */
     } B;
  } MCR;

  union {
    vuint32_t R;
      struct {
        vuint32_t EIE :1;					 
        vuint32_t :16;					 /* Reserved. */
        vuint32_t SLV:3;				 
        vuint32_t MST:4;					
        vuint32_t SYN:8;
    } B;
  } EIR;

  union {
    vuint32_t R;
      struct {
        vuint32_t VLD :1;
        vuint32_t DPSE0 :1;					 
        vuint32_t DPSE1 :1;
        vuint32_t DPSE2 :1;					 
        vuint32_t DPSE3 :1;
        vuint32_t DPSE4 :1;					 
        vuint32_t DPSE5 :1;
        vuint32_t DPSE6 :1;					 
        vuint32_t DPSE7 :1;
        vuint32_t DPME0 :1;					 
        vuint32_t DPME1 :1;
        vuint32_t DPME2 :1;					 
        vuint32_t DPME3 :1;
        vuint32_t DPME4 :1;					 
        vuint32_t DPME5 :1;
        vuint32_t DPME6 :1;					 
        vuint32_t DPME7 :1;
        vuint32_t SLV:3;				 
        vuint32_t MST:4;					
        vuint32_t SYN:8;
     } B;
  } ESR;
  
  union {
    vuint32_t R;
      struct {
        vuint32_t ADDR :32;					 
     } B;
  } EAR;
};



#define SRAM0_START 0x40000000UL;
#define ADC_0 (*(volatile struct ADC_tag *) 0xFFEE0000UL)
#define ADC_1 (*(volatile struct ADC_tag *) 0xFBEE4000UL)
#define ADC_2 (*(volatile struct ADC_tag *) 0xFFEE8000UL)
#define ADC_3 (*(volatile struct ADC_tag *) 0xFBEEC000UL)
#define AIPS_A (*(volatile struct AIPS_tag *) 0xFC000000UL)
#define AIPS_B (*(volatile struct AIPS_tag *) 0xF8000000UL)
#define BCTU (*(volatile struct BCTU_tag *) 0xFFC10000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CAN_0 (*(volatile struct CAN_tag *) 0xFFEB0000UL)
#define CAN_1 (*(volatile struct CAN_tag *) 0xFBEB4000UL)
#define CAN_2 (*(volatile struct CAN_tag *) 0xFFEB8000UL)
#define CAN_3 (*(volatile struct CAN_tag *) 0xFBEBC000UL)
#define CMU_ADCSD (*(volatile struct CMU_tag *) 0xFBFB0300UL)
#define CMU_AIPS (*(volatile struct CMU_tag *) 0xFBFB0280UL)
#define CMU_CLKOUT (*(volatile struct CMU_tag *) 0xFBFB04C0UL)
#define CMU_FXBAR (*(volatile struct CMU_tag *) 0xFBFB0200UL)
#define CMU_PER (*(volatile struct CMU_tag *) 0xFBFB02C0UL)
#define CMU_PLL (*(volatile struct CMU_tag *) 0xFBFB0500UL)
#define CMU_SARADC (*(volatile struct CMU_tag *) 0xFBFB0340UL)
#define CMU_SENT (*(volatile struct CMU_tag *) 0xFBFB0380UL)
#define CMU_SXBAR (*(volatile struct CMU_tag *) 0xFBFB0240UL)
#define CMU_eMIOS (*(volatile struct CMU_tag *) 0xFBFB0400UL)
#define CMU_eTPU2 (*(volatile struct CMU_tag *) 0xFBFB0440UL)
#define CRC_0 (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define CRC_1 (*(volatile struct CRC_tag *) 0xFBF64000UL)
#define DECFILTER_0 (*(volatile struct DECFILTER_tag *) 0xFFF88000UL)
#define DECFILTER_1 (*(volatile struct DECFILTER_tag *) 0xFFF8C000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFFF6C200UL)
#define DMAMUX_2 (*(volatile struct DMAMUX_tag *) 0xFFF6C400UL)
#define DMAMUX_3 (*(volatile struct DMAMUX_tag *) 0xFBFC0000UL)
#define DMA_0 (*(volatile struct DMA_tag *) 0xFC0A0000UL)
#define DSPI_0 (*(volatile struct DSPI_tag *) 0xFFE70000UL)
#define DSPI_1 (*(volatile struct DSPI_tag *) 0xFBE70000UL)
#define DSPI_2 (*(volatile struct DSPI_tag *) 0xFFE74000UL)
#define DSPI_3 (*(volatile struct DSPI_tag *) 0xFBE74000UL)
#define DSPI_4 (*(volatile struct DSPI_tag *) 0xFFE78000UL)
#define DSPI_M0 (*(volatile struct DSPI_tag *) 0xFFE7C000UL)
#define DSPI_M1 (*(volatile struct DSPI_tag *) 0xFBE78000UL)
#define DTS (*(volatile struct DTS_tag *) 0xFFF38000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FEC (*(volatile struct FEC_tag *) 0xFC0B0000UL)
#define IGF (*(volatile struct IGF_tag *) 0xFFCE8000UL)
#define INTC_0 (*(volatile struct INTC_tag *) 0xFC040000UL)
#define IRCOSC (*(volatile struct IRCOSC_tag *) 0xFFFB0000UL)
#define JDC (*(volatile struct JDC_tag *) 0xFFF3C000UL)
#define JTAGM (*(volatile struct JTAGM_tag *) 0xFFF48000UL)
#define LFAST (*(volatile struct LFAST_tag *) 0xFFFD8000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFFE8C000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFBE8C000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define LINFlexD_3 (*(volatile struct LINFlexD_tag *) 0xFBE90000UL)
#define LINFlexD_M0 (*(volatile struct LINFlexD_tag *) 0xFFEA8000UL)
#define LINFlexD_M1 (*(volatile struct LINFlexD_tag *) 0xFBEA8000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0700UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0xFFFA8000UL)
#define MEMU (*(volatile struct MEMU_tag *) 0xFFF50000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT_0 (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PIT_1 (*(volatile struct PIT_tag *) 0xFFF80000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0100UL)
#define PMC (*(volatile struct PMC_tag *) 0xFFFA0400UL)
#define PRAMC (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define REACM2 (*(volatile struct REACM2_tag *) 0xFFCC4000UL)
#define SDADC_0 (*(volatile struct SDADC_tag *) 0xFFF0C000UL)
#define SDADC_1 (*(volatile struct SDADC_tag *) 0xFBF0C000UL)
#define SDADC_2 (*(volatile struct SDADC_tag *) 0xFFF10000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIPI (*(volatile struct SIPI_tag *) 0xFFFD0000UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU_0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU_1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SRX_0 (*(volatile struct SRX_tag *) 0xFFE5C000UL)
#define SRX_1 (*(volatile struct SRX_tag *) 0xFBE5C000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SWT_3 (*(volatile struct SWT_tag *) 0xFC05C000UL)
#define TDM (*(volatile struct TDM_tag *) 0xFFF34000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define XBAR_0 (*(volatile struct XBAR_tag *) 0xFC004000UL)
#define XBAR_1 (*(volatile struct XBAR_tag *) 0xFC008000UL)
#define XBIC_0 (*(volatile struct XBIC_tag *) 0xFC018000UL)
#define XBIC_1 (*(volatile struct XBIC_tag *) 0xFC01C000UL)
#define XOSC (*(volatile struct XOSC_tag *) 0xFFFB0080UL)
#define eMIOS200_0 (*(volatile struct eMIOS200_tag *) 0xFFE64000UL)
#define eMIOS200_1 (*(volatile struct eMIOS200_tag *) 0xFBE64000UL)
#define eMIOS_0_UC08 (*(volatile struct eMIOS_tag *) 0xFFE64120UL)
#define eMIOS_0_UC09 (*(volatile struct eMIOS_tag *) 0xFFE64140UL)
#define eMIOS_0_UC10 (*(volatile struct eMIOS_tag *) 0xFFE64160UL)
#define eMIOS_0_UC11 (*(volatile struct eMIOS_tag *) 0xFFE64180UL)
#define eMIOS_0_UC12 (*(volatile struct eMIOS_tag *) 0xFFE641A0UL)
#define eMIOS_0_UC13 (*(volatile struct eMIOS_tag *) 0xFFE641C0UL)
#define eMIOS_0_UC14 (*(volatile struct eMIOS_tag *) 0xFFE641E0UL)
#define eMIOS_0_UC15 (*(volatile struct eMIOS_tag *) 0xFFE64200UL)
#define eMIOS_0_UC16 (*(volatile struct eMIOS_tag *) 0xFFE64220UL)
#define eMIOS_0_UC17 (*(volatile struct eMIOS_tag *) 0xFFE64240UL)
#define eMIOS_0_UC18 (*(volatile struct eMIOS_tag *) 0xFFE64260UL)
#define eMIOS_0_UC19 (*(volatile struct eMIOS_tag *) 0xFFE64280UL)
#define eMIOS_0_UC20 (*(volatile struct eMIOS_tag *) 0xFFE642A0UL)
#define eMIOS_0_UC21 (*(volatile struct eMIOS_tag *) 0xFFE642C0UL)
#define eMIOS_0_UC22 (*(volatile struct eMIOS_tag *) 0xFFE642E0UL)
#define eMIOS_0_UC23 (*(volatile struct eMIOS_tag *) 0xFFE64300UL)
#define eMIOS_1_UC08 (*(volatile struct eMIOS_tag *) 0xFBE64120UL)
#define eMIOS_1_UC09 (*(volatile struct eMIOS_tag *) 0xFBE64140UL)
#define eMIOS_1_UC10 (*(volatile struct eMIOS_tag *) 0xFBE64160UL)
#define eMIOS_1_UC11 (*(volatile struct eMIOS_tag *) 0xFBE64180UL)
#define eMIOS_1_UC12 (*(volatile struct eMIOS_tag *) 0xFBE641A0UL)
#define eMIOS_1_UC13 (*(volatile struct eMIOS_tag *) 0xFBE641C0UL)
#define eMIOS_1_UC14 (*(volatile struct eMIOS_tag *) 0xFBE641E0UL)
#define eMIOS_1_UC15 (*(volatile struct eMIOS_tag *) 0xFBE64200UL)
#define eMIOS_1_UC16 (*(volatile struct eMIOS_tag *) 0xFBE64220UL)
#define eMIOS_1_UC17 (*(volatile struct eMIOS_tag *) 0xFBE64240UL)
#define eMIOS_1_UC18 (*(volatile struct eMIOS_tag *) 0xFBE64260UL)
#define eMIOS_1_UC19 (*(volatile struct eMIOS_tag *) 0xFBE64280UL)
#define eMIOS_1_UC20 (*(volatile struct eMIOS_tag *) 0xFBE642A0UL)
#define eMIOS_1_UC21 (*(volatile struct eMIOS_tag *) 0xFBE642C0UL)
#define eMIOS_1_UC22 (*(volatile struct eMIOS_tag *) 0xFBE642E0UL)
#define eMIOS_1_UC23 (*(volatile struct eMIOS_tag *) 0xFBE64300UL)
#define eTPU_CCCR_0 (*(volatile struct eTPU_CCCR_tag *) 0xFFCC0400UL)
#define eTPU_ER_0 (*(volatile struct eTPU_ER_tag *) 0xFFCC0060UL)
#define eTPU_GCR_0 (*(volatile struct eTPU_GCR_tag *) 0xFFCC0200UL)
#define eTPU_LMR_0 (*(volatile struct eTPU_LMR_tag *) 0xFFCC0080UL)
#define eTPU_MESR_0 (*(volatile struct eTPU_MESR_tag *) 0xFFCC0100UL)
#define eTPU_SCR_0 (*(volatile struct eTPU_SCR_tag *) 0xFFCC0000UL)
#define eTPU_SSIR_0 (*(volatile struct eTPU_SSIR_tag *) 0xFFCC0C00UL)
#define eTPU_TBR_0 (*(volatile struct eTPU_TBR_tag *) 0xFFCC0020UL)
#ifdef __MWERKS__
#pragma pop
#endif
#ifdef  __cplusplus
}
#endif
#endif /* ifdef _MPC5746R_H */
