
/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file CAN_Node1_demo.c
*
* @author Freescale
*
* @version 0.0.1
*
* @date Oct. 15, 2013
*
* @brief providing framework of demo cases for MCU. 
*
*******************************************************************************/

#include "common.h"
#include "ics.h"
#include "rtc.h"
#include "uart.h"
#include "mq.h"
#include "sim.h"
#include "mscan.h"
#include "mscan_api.h"
#include "sysinit.h"

#define NODE_ID1			0x802
#define NODE_ID2			0x801
#define NODE_ID3			0x803

/* define MACRO for filter,here define a dual filter to receive 
   extend and standard frame from ID(NODE_ID2&NODE_ID3) */
#define CAN_IDAR0			NODE_ID2<<1
#define CAN_IDAR1			NODE_ID3<<1
#define CAN_IDMR0			0x1|(uint32_t)0x18<<16 /* received all standard and extend frame from ID(NODE_ID2) */
#define CAN_IDMR1			0x1|(uint32_t)0x18<<16 

//printf("%d\r\n", Baud_RATE);
//CalCANBaudrate(20000000L, 125000);
//void CalCANBaudrate(uint32_t clk, uint32_t baudrate)
//{
//    uint32_t ps, seg1, seg2;
//    uint32_t tq;
//    for(ps=0; ps<64; ps++)
//    {
//        for(seg1=0; seg1<16; seg1++)
//        {
//            for(seg2=0; seg2<16; seg2++) 
//            {
//                tq = clk/(ps+1);
//                if((tq/(3 + seg1 + seg2)) == baudrate)
//                {
//                    if(seg1 > seg2)
//                    {
//                        printf("ps:%d seg1:%d seg2:%d\r\n", ps, seg1, seg2);
//                    }
//                    
//                }

//            }
//        }
//    }
//}

void UART_HandleInt(UART_Type *pUART)
{
    uint8_t data;
    msg_t pMsg;
    static uint8_t buf[2048];
    static uint32_t i, len;
    if(UART_IsRxBuffFull(pUART))       
    {
        data = UART_ReadDataReg(pUART);
        buf[len++] = data;

//        if(i > 7)
//        {
//            pMsg.msg_len = i;
//            memcpy(pMsg.payload, buf, i);
//            mq_push(pMsg);
//            i = 0;
//        }
    }
    
    if(UART_CheckFlag(pUART, UART_FlagOR))
    {
        printf("!!!\r\n");
        while(1);
        data = UART_ReadDataReg(pUART);     
    }
    
    if(UART_CheckFlag(pUART, UART_FlagIDLE))
    {
        uint32_t block, remain;
        data = UART_ReadDataReg(pUART);
        if(len)
        {
            block = len/8;
            remain = len%8;
            for(i=0; i<block; i++)
            {
                pMsg.msg_len = 8;
                memcpy(pMsg.payload, buf+i*8, 8);
                mq_push(pMsg); 
            }
            if(remain)
            {
                pMsg.msg_len = remain;
                memcpy(pMsg.payload, buf+block*8, remain);
                mq_push(pMsg); 
                
            }
        }
        len = 0;
    }
}

int main (void)
{
    MSCAN_ConfigType sMSCANConfig = {0};
    ItemInfoType     sCANTxItemInfo;
    MSCAN_FrameType  sRxFrameInfo;
    uint8_t i;
	sysinit();

    MSCAN_GlobeVaribleInit(MSCAN);
    
    SIM->PINSEL1 |= SIM_PINSEL1_MSCANPS_MASK;
    sMSCANConfig.sBaudRateSetting.SJW = BAUD_RATE_SJW;
    sMSCANConfig.sBaudRateSetting.BRP = BAUD_RATE_BRP;
    sMSCANConfig.sBaudRateSetting.SAMP = BAUD_RATE_SAMP;
	sMSCANConfig.sBaudRateSetting.TSEG1= BAUD_RATE_TSEG1;
	sMSCANConfig.sBaudRateSetting.TSEG2= BAUD_RATE_TSEG2;
	sMSCANConfig.u32IDAR0 = (CAN_IDAR0);
	sMSCANConfig.u32IDAR1 = (CAN_IDAR1);
	sMSCANConfig.u32IDMR0 = (CAN_IDMR0);
	sMSCANConfig.u32IDMR1 = (CAN_IDMR1);
	sMSCANConfig.u8IDARMode = ID_ACCEPT_MODE_TWO32;
	sMSCANConfig.sSetting.bCanEn = 1;
    sMSCANConfig.sSetting.bCLKSRC = 1;
  //  sMSCANConfig.sSetting.bLoopModeEn = 1;
	sMSCANConfig.sSetting.bRxFullIEn=1;
	sMSCANConfig.sSetting.bTimerEn=1;
	sMSCANConfig.sSetting.bOverRunIEn=1;
	sMSCANConfig.sSetting.bStatusChangeIEn=1;
	//sMSCANConfig.sSetting.bTxEmptyIEn=1;
	CAN_Init(MSCAN,&sMSCANConfig);

	//Initialize the Tx information
	sCANTxItemInfo.bIsExtOrStand = 1;
	sCANTxItemInfo.bIsRemoteFrame = 0;
	sCANTxItemInfo.ID_Type.ID = NODE_ID1;
	sCANTxItemInfo.u32DataLength = 8;
	sCANTxItemInfo.u8BPR = 0x80;

    mq_init();
    
    UART_SetCallback(UART_HandleInt);	
 	UART_EnableInterrupt(UART1, UART_RxBuffFullInt);
    UART_EnableInterrupt(UART1, UART_IdleLineInt);
    NVIC_EnableIRQ(UART1_IRQn);
    printf("USB-CAN\r\n");
    msg_t *pMsg;
   
    memcpy(&sCANTxItemInfo.u8DataBuff, "012345678", 8);
    static uint32_t cnt;
    while(1)
    {
        if(mq_exist())
        {
            pMsg = mq_pop();
           // printf("%d\r\n", pMsg->msg_len);
            
          //  for(i=0; i<pMsg->msg_len; i++)
            {
           //     UART_PutChar(UART1, pMsg->payload[i]);
            }
            /* UART->CAN */
            sCANTxItemInfo.u32DataLength = pMsg->msg_len;
           // cnt += pMsg->msg_len;
            memcpy(sCANTxItemInfo.u8DataBuff, pMsg->payload, pMsg->msg_len);
            MSCAN_RegisterFrameType frame;
            CAN_MakeFrame(&sCANTxItemInfo, &frame);
            while(CAN_LoadOneFrameToBuff(MSCAN, &frame) == FALSE);
            
        }

        /* CAN ->UART */
        while(CAN_ReadOneFramefromBufferQueue(&sRxFrameInfo))
        {
            //printf("cnt:%d\r\n", cnt);
            //cnt = 0;
			for(i=0; i<sRxFrameInfo.DLR; i++)
			{
                UART_PutChar(UART1, sRxFrameInfo.DSR[i]);
			}
        }
    }
}




